// Compiled by ClojureScript 0.0-3196 {}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('dommy.template');
goog.require('dommy.attrs');
goog.require('dommy.utils');
goog.require('clojure.string');
dommy.core.has_class_QMARK_ = dommy.attrs.has_class_QMARK_;
dommy.core.add_class_BANG_ = dommy.attrs.add_class_BANG_;
dommy.core.remove_class_BANG_ = dommy.attrs.remove_class_BANG_;
dommy.core.toggle_class_BANG_ = dommy.attrs.toggle_class_BANG_;
dommy.core.set_attr_BANG_ = dommy.attrs.set_attr_BANG_;
dommy.core.set_style_BANG_ = dommy.attrs.set_style_BANG_;
dommy.core.set_px_BANG_ = dommy.attrs.set_px_BANG_;
dommy.core.px = dommy.attrs.px;
dommy.core.style_str = dommy.attrs.style_str;
dommy.core.style = dommy.attrs.style;
dommy.core.remove_attr_BANG_ = dommy.attrs.remove_attr_BANG_;
dommy.core.toggle_attr_BANG_ = dommy.attrs.toggle_attr_BANG_;
dommy.core.attr = dommy.attrs.attr;
dommy.core.hidden_QMARK_ = dommy.attrs.hidden_QMARK_;
dommy.core.toggle_BANG_ = dommy.attrs.toggle_BANG_;
dommy.core.hide_BANG_ = dommy.attrs.hide_BANG_;
dommy.core.show_BANG_ = dommy.attrs.show_BANG_;
dommy.core.bounding_client_rect = dommy.attrs.bounding_client_rect;
dommy.core.scroll_into_view = dommy.attrs.scroll_into_view;
dommy.core.dissoc_in = dommy.utils.dissoc_in;
dommy.core.__GT_Array = dommy.utils.__GT_Array;
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
elem__$1.innerHTML = html;

return elem__$1;
});
dommy.core.html = (function dommy$core$html(elem){
return dommy.template.__GT_node_like.call(null,elem).innerHTML;
});
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var prop = (cljs.core.truth_(elem__$1.textContent)?"textContent":"innerText");
(elem__$1[prop] = text);

return elem__$1;
});
dommy.core.text = (function dommy$core$text(elem){
var or__4276__auto__ = elem.textContent;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return elem.innerText;
}
});
dommy.core.value = (function dommy$core$value(elem){
return dommy.template.__GT_node_like.call(null,elem).value;
});
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
elem__$1.value = value;

return elem__$1;
});
/**
 * append `child` to `parent`. 'parent' and 'child' should be node-like
 * (work with dommy.template/->node-like). The node-like projection
 * of parent is returned after appending child.
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(){
var G__11021 = arguments.length;
switch (G__11021) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__11022 = dommy.template.__GT_node_like.call(null,parent);
G__11022.appendChild(dommy.template.__GT_node_like.call(null,child));

return G__11022;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
var seq__11023_11028 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__11024_11029 = null;
var count__11025_11030 = (0);
var i__11026_11031 = (0);
while(true){
if((i__11026_11031 < count__11025_11030)){
var c_11032 = cljs.core._nth.call(null,chunk__11024_11029,i__11026_11031);
dommy.core.append_BANG_.call(null,parent__$1,c_11032);

var G__11033 = seq__11023_11028;
var G__11034 = chunk__11024_11029;
var G__11035 = count__11025_11030;
var G__11036 = (i__11026_11031 + (1));
seq__11023_11028 = G__11033;
chunk__11024_11029 = G__11034;
count__11025_11030 = G__11035;
i__11026_11031 = G__11036;
continue;
} else {
var temp__4126__auto___11037 = cljs.core.seq.call(null,seq__11023_11028);
if(temp__4126__auto___11037){
var seq__11023_11038__$1 = temp__4126__auto___11037;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11023_11038__$1)){
var c__5061__auto___11039 = cljs.core.chunk_first.call(null,seq__11023_11038__$1);
var G__11040 = cljs.core.chunk_rest.call(null,seq__11023_11038__$1);
var G__11041 = c__5061__auto___11039;
var G__11042 = cljs.core.count.call(null,c__5061__auto___11039);
var G__11043 = (0);
seq__11023_11028 = G__11040;
chunk__11024_11029 = G__11041;
count__11025_11030 = G__11042;
i__11026_11031 = G__11043;
continue;
} else {
var c_11044 = cljs.core.first.call(null,seq__11023_11038__$1);
dommy.core.append_BANG_.call(null,parent__$1,c_11044);

var G__11045 = cljs.core.next.call(null,seq__11023_11038__$1);
var G__11046 = null;
var G__11047 = (0);
var G__11048 = (0);
seq__11023_11028 = G__11045;
chunk__11024_11029 = G__11046;
count__11025_11030 = G__11047;
i__11026_11031 = G__11048;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq11017){
var G__11018 = cljs.core.first.call(null,seq11017);
var seq11017__$1 = cljs.core.next.call(null,seq11017);
var G__11019 = cljs.core.first.call(null,seq11017__$1);
var seq11017__$2 = cljs.core.next.call(null,seq11017__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11018,G__11019,seq11017__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * prepend `child` to `parent`, both node-like
 * return ->node-like projection of `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(){
var G__11053 = arguments.length;
switch (G__11053) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
return parent__$1.insertBefore(dommy.template.__GT_node_like.call(null,child),parent__$1.firstChild);
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like.call(null,parent);
var seq__11054_11059 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__11055_11060 = null;
var count__11056_11061 = (0);
var i__11057_11062 = (0);
while(true){
if((i__11057_11062 < count__11056_11061)){
var c_11063 = cljs.core._nth.call(null,chunk__11055_11060,i__11057_11062);
dommy.core.prepend_BANG_.call(null,parent__$1,c_11063);

var G__11064 = seq__11054_11059;
var G__11065 = chunk__11055_11060;
var G__11066 = count__11056_11061;
var G__11067 = (i__11057_11062 + (1));
seq__11054_11059 = G__11064;
chunk__11055_11060 = G__11065;
count__11056_11061 = G__11066;
i__11057_11062 = G__11067;
continue;
} else {
var temp__4126__auto___11068 = cljs.core.seq.call(null,seq__11054_11059);
if(temp__4126__auto___11068){
var seq__11054_11069__$1 = temp__4126__auto___11068;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11054_11069__$1)){
var c__5061__auto___11070 = cljs.core.chunk_first.call(null,seq__11054_11069__$1);
var G__11071 = cljs.core.chunk_rest.call(null,seq__11054_11069__$1);
var G__11072 = c__5061__auto___11070;
var G__11073 = cljs.core.count.call(null,c__5061__auto___11070);
var G__11074 = (0);
seq__11054_11059 = G__11071;
chunk__11055_11060 = G__11072;
count__11056_11061 = G__11073;
i__11057_11062 = G__11074;
continue;
} else {
var c_11075 = cljs.core.first.call(null,seq__11054_11069__$1);
dommy.core.prepend_BANG_.call(null,parent__$1,c_11075);

var G__11076 = cljs.core.next.call(null,seq__11054_11069__$1);
var G__11077 = null;
var G__11078 = (0);
var G__11079 = (0);
seq__11054_11059 = G__11076;
chunk__11055_11060 = G__11077;
count__11056_11061 = G__11078;
i__11057_11062 = G__11079;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq11049){
var G__11050 = cljs.core.first.call(null,seq11049);
var seq11049__$1 = cljs.core.next.call(null,seq11049);
var G__11051 = cljs.core.first.call(null,seq11049__$1);
var seq11049__$2 = cljs.core.next.call(null,seq11049__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11050,G__11051,seq11049__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * insert `node` before `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like.call(null,elem);
var other__$1 = dommy.template.__GT_node_like.call(null,other);
if(cljs.core.truth_(other__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"other","other",-1658642225,null))))].join('')));
}

other__$1.parentNode.insertBefore(actual_node,other__$1);

return actual_node;
});
/**
 * insert `node` after `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like.call(null,elem);
var other__$1 = dommy.template.__GT_node_like.call(null,other);
var parent = other__$1.parentNode;
var temp__4124__auto___11080 = other__$1.nextSibling;
if(cljs.core.truth_(temp__4124__auto___11080)){
var next_11081 = temp__4124__auto___11080;
parent.insertBefore(actual_node,next_11081);
} else {
parent.appendChild(actual_node);
}

return actual_node;
});
/**
 * replace `elem` with `new`, both node-like, return node-like projection of new.
 * node-like projection of elem must have parent.
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var new$__$1 = dommy.template.__GT_node_like.call(null,new$);
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
if(cljs.core.truth_(elem__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"elem","elem",-2035804713,null))))].join('')));
}

elem__$1.parentNode.replaceChild(new$__$1,elem__$1);

return new$__$1;
});
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(parent,node_like){
var G__11083 = dommy.template.__GT_node_like.call(null,parent);
G__11083.innerHTML = "";

dommy.core.append_BANG_.call(null,G__11083,node_like);

return G__11083;
});
/**
 * remove node-like `elem` from parent, return node-like projection of elem
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(elem){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
var G__11085 = elem__$1.parentNode;
G__11085.removeChild(elem__$1);

return G__11085;
});
/**
 * clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.template.__GT_node_like.call(null,elem).innerHTML = "";
});
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_.call(null,data)){
return clojure.string.join.call(null," ",cljs.core.map.call(null,dommy$core$selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name.call(null,data);
} else {
return null;
}
}
});
dommy.core.selector_map = (function dommy$core$selector_map(template,key_selectors_map){
var container = dommy.template.__GT_node_like.call(null,template);
if(!(cljs.core.contains_QMARK_.call(null,key_selectors_map,new cljs.core.Keyword(null,"container","container",-1736937707)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"key-selectors-map","key-selectors-map",1212911103,null),new cljs.core.Keyword(null,"container","container",-1736937707)))))].join('')));
}

return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"container","container",-1736937707),container], null),cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (container){
return (function (p__11091){
var vec__11092 = p__11091;
var k = cljs.core.nth.call(null,vec__11092,(0),null);
var v = cljs.core.nth.call(null,vec__11092,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(new cljs.core.Keyword(null,"live","live",-1610148039).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v)))?(function (){
if(typeof dommy.core.t11093 !== 'undefined'){
} else {

/**
* @constructor
*/
dommy.core.t11093 = (function (v,k,vec__11092,p__11091,container,key_selectors_map,template,selector_map,meta11094){
this.v = v;
this.k = k;
this.vec__11092 = vec__11092;
this.p__11091 = p__11091;
this.container = container;
this.key_selectors_map = key_selectors_map;
this.template = template;
this.selector_map = selector_map;
this.meta11094 = meta11094;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 425984;
})
dommy.core.t11093.prototype.cljs$core$IDeref$_deref$arity$1 = ((function (vec__11092,k,v,container){
return (function (this$){
var self__ = this;
var this$__$1 = this;
return dommy.utils.__GT_Array.call(null,dommy.template.__GT_node_like.call(null,self__.container).querySelectorAll(dommy.core.selector.call(null,self__.v)));
});})(vec__11092,k,v,container))
;

dommy.core.t11093.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (vec__11092,k,v,container){
return (function (_11095){
var self__ = this;
var _11095__$1 = this;
return self__.meta11094;
});})(vec__11092,k,v,container))
;

dommy.core.t11093.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (vec__11092,k,v,container){
return (function (_11095,meta11094__$1){
var self__ = this;
var _11095__$1 = this;
return (new dommy.core.t11093(self__.v,self__.k,self__.vec__11092,self__.p__11091,self__.container,self__.key_selectors_map,self__.template,self__.selector_map,meta11094__$1));
});})(vec__11092,k,v,container))
;

dommy.core.t11093.cljs$lang$type = true;

dommy.core.t11093.cljs$lang$ctorStr = "dommy.core/t11093";

dommy.core.t11093.cljs$lang$ctorPrWriter = ((function (vec__11092,k,v,container){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"dommy.core/t11093");
});})(vec__11092,k,v,container))
;

dommy.core.__GT_t11093 = ((function (vec__11092,k,v,container){
return (function dommy$core$selector_map_$___GT_t11093(v__$1,k__$1,vec__11092__$1,p__11091__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta11094){
return (new dommy.core.t11093(v__$1,k__$1,vec__11092__$1,p__11091__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta11094));
});})(vec__11092,k,v,container))
;

}

return (new dommy.core.t11093(v,k,vec__11092,p__11091,container,key_selectors_map,template,dommy$core$selector_map,cljs.core.PersistentArrayMap.EMPTY));
})()
:dommy.template.__GT_node_like.call(null,container).querySelector(dommy.core.selector.call(null,v)))], null);
});})(container))
,key_selectors_map)));
});
/**
 * a lazy seq of the ancestors of `node`
 */
dommy.core.ancestor_nodes = (function dommy$core$ancestor_nodes(elem){
return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,(function (p1__11096_SHARP_){
return p1__11096_SHARP_.parentNode;
}),dommy.template.__GT_node_like.call(null,elem)));
});
/**
 * returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(){
var G__11098 = arguments.length;
switch (G__11098) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array.call(null,dommy.template.__GT_node_like.call(null,dommy.template.__GT_node_like.call(null,base)).querySelectorAll(dommy.core.selector.call(null,selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.call(null,document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;
/**
 * closest ancestor of `node` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(){
var G__11102 = arguments.length;
switch (G__11102) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
var base__$1 = dommy.template.__GT_node_like.call(null,base);
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base__$1,selector),cljs.core.take_while.call(null,((function (base__$1,elem__$1){
return (function (p1__11100_SHARP_){
return !((p1__11100_SHARP_ === base__$1));
});})(base__$1,elem__$1))
,dommy.core.ancestor_nodes.call(null,elem__$1))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,selector),dommy.core.ancestor_nodes.call(null,dommy.template.__GT_node_like.call(null,elem))));
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;
/**
 * is `descendant` a descendant of `ancestor`?
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
var descendant__$1 = dommy.template.__GT_node_like.call(null,descendant);
var ancestor__$1 = dommy.template.__GT_node_like.call(null,ancestor);
if(cljs.core.truth_(ancestor__$1.contains)){
return ancestor__$1.contains(descendant__$1);
} else {
if(cljs.core.truth_(ancestor__$1.compareDocumentPosition)){
return ((ancestor__$1.compareDocumentPosition(descendant__$1) & (1 << (4))) != 0);
} else {
return null;
}
}
});
dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__11104){
var vec__11105 = p__11104;
var special_mouse_event = cljs.core.nth.call(null,vec__11105,(0),null);
var real_mouse_event = cljs.core.nth.call(null,vec__11105,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,new cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__11105,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__11105,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4276__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4264__auto__ = related_target;
if(cljs.core.truth_(and__4264__auto__)){
return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else {
return and__4264__auto__;
}
})())){
return null;
} else {
return f.call(null,event);
}
});
;})(vec__11105,special_mouse_event,real_mouse_event))
});})(vec__11105,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.call(null,dommy.template.__GT_node_like.call(null,elem),event.target,selector);
if(cljs.core.truth_((function (){var and__4264__auto__ = selected_target;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__4264__auto__;
}
})())){
event.selectedTarget = selected_target;

return f.call(null,event);
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `nodes`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4276__auto__ = dommy.template.__GT_node_like.call(null,elem).dommyEventListeners;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = dommy.template.__GT_node_like.call(null,elem);
return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq11106){
var G__11107 = cljs.core.first.call(null,seq11106);
var seq11106__$1 = cljs.core.next.call(null,seq11106);
var G__11108 = cljs.core.first.call(null,seq11106__$1);
var seq11106__$2 = cljs.core.next.call(null,seq11106__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11107,G__11108,seq11106__$2);
});
dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_.call(null,elem_sel)){
return cljs.core.juxt.call(null,(function (p1__11109_SHARP_){
return dommy.template.__GT_node_like.call(null,cljs.core.first.call(null,p1__11109_SHARP_));
}),cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dommy.template.__GT_node_like.call(null,elem_sel),null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 * (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 * (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 * (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11112_11135 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11136 = cljs.core.nth.call(null,vec__11112_11135,(0),null);
var selector_11137 = cljs.core.nth.call(null,vec__11112_11135,(1),null);
var seq__11113_11138 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11120_11139 = null;
var count__11121_11140 = (0);
var i__11122_11141 = (0);
while(true){
if((i__11122_11141 < count__11121_11140)){
var vec__11129_11142 = cljs.core._nth.call(null,chunk__11120_11139,i__11122_11141);
var orig_type_11143 = cljs.core.nth.call(null,vec__11129_11142,(0),null);
var f_11144 = cljs.core.nth.call(null,vec__11129_11142,(1),null);
var seq__11123_11145 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11143,new cljs.core.PersistentArrayMap.fromArray([orig_type_11143,cljs.core.identity], true, false)));
var chunk__11125_11146 = null;
var count__11126_11147 = (0);
var i__11127_11148 = (0);
while(true){
if((i__11127_11148 < count__11126_11147)){
var vec__11130_11149 = cljs.core._nth.call(null,chunk__11125_11146,i__11127_11148);
var actual_type_11150 = cljs.core.nth.call(null,vec__11130_11149,(0),null);
var factory_11151 = cljs.core.nth.call(null,vec__11130_11149,(1),null);
var canonical_f_11152 = (cljs.core.truth_(selector_11137)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11136,selector_11137):cljs.core.identity).call(null,factory_11151.call(null,f_11144));
dommy.core.update_event_listeners_BANG_.call(null,elem_11136,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11137,actual_type_11150,f_11144], null),canonical_f_11152);

if(cljs.core.truth_(elem_11136.addEventListener)){
elem_11136.addEventListener(cljs.core.name.call(null,actual_type_11150),canonical_f_11152);
} else {
elem_11136.attachEvent(cljs.core.name.call(null,actual_type_11150),canonical_f_11152);
}

var G__11153 = seq__11123_11145;
var G__11154 = chunk__11125_11146;
var G__11155 = count__11126_11147;
var G__11156 = (i__11127_11148 + (1));
seq__11123_11145 = G__11153;
chunk__11125_11146 = G__11154;
count__11126_11147 = G__11155;
i__11127_11148 = G__11156;
continue;
} else {
var temp__4126__auto___11157 = cljs.core.seq.call(null,seq__11123_11145);
if(temp__4126__auto___11157){
var seq__11123_11158__$1 = temp__4126__auto___11157;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11123_11158__$1)){
var c__5061__auto___11159 = cljs.core.chunk_first.call(null,seq__11123_11158__$1);
var G__11160 = cljs.core.chunk_rest.call(null,seq__11123_11158__$1);
var G__11161 = c__5061__auto___11159;
var G__11162 = cljs.core.count.call(null,c__5061__auto___11159);
var G__11163 = (0);
seq__11123_11145 = G__11160;
chunk__11125_11146 = G__11161;
count__11126_11147 = G__11162;
i__11127_11148 = G__11163;
continue;
} else {
var vec__11131_11164 = cljs.core.first.call(null,seq__11123_11158__$1);
var actual_type_11165 = cljs.core.nth.call(null,vec__11131_11164,(0),null);
var factory_11166 = cljs.core.nth.call(null,vec__11131_11164,(1),null);
var canonical_f_11167 = (cljs.core.truth_(selector_11137)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11136,selector_11137):cljs.core.identity).call(null,factory_11166.call(null,f_11144));
dommy.core.update_event_listeners_BANG_.call(null,elem_11136,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11137,actual_type_11165,f_11144], null),canonical_f_11167);

if(cljs.core.truth_(elem_11136.addEventListener)){
elem_11136.addEventListener(cljs.core.name.call(null,actual_type_11165),canonical_f_11167);
} else {
elem_11136.attachEvent(cljs.core.name.call(null,actual_type_11165),canonical_f_11167);
}

var G__11168 = cljs.core.next.call(null,seq__11123_11158__$1);
var G__11169 = null;
var G__11170 = (0);
var G__11171 = (0);
seq__11123_11145 = G__11168;
chunk__11125_11146 = G__11169;
count__11126_11147 = G__11170;
i__11127_11148 = G__11171;
continue;
}
} else {
}
}
break;
}

var G__11172 = seq__11113_11138;
var G__11173 = chunk__11120_11139;
var G__11174 = count__11121_11140;
var G__11175 = (i__11122_11141 + (1));
seq__11113_11138 = G__11172;
chunk__11120_11139 = G__11173;
count__11121_11140 = G__11174;
i__11122_11141 = G__11175;
continue;
} else {
var temp__4126__auto___11176 = cljs.core.seq.call(null,seq__11113_11138);
if(temp__4126__auto___11176){
var seq__11113_11177__$1 = temp__4126__auto___11176;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11113_11177__$1)){
var c__5061__auto___11178 = cljs.core.chunk_first.call(null,seq__11113_11177__$1);
var G__11179 = cljs.core.chunk_rest.call(null,seq__11113_11177__$1);
var G__11180 = c__5061__auto___11178;
var G__11181 = cljs.core.count.call(null,c__5061__auto___11178);
var G__11182 = (0);
seq__11113_11138 = G__11179;
chunk__11120_11139 = G__11180;
count__11121_11140 = G__11181;
i__11122_11141 = G__11182;
continue;
} else {
var vec__11132_11183 = cljs.core.first.call(null,seq__11113_11177__$1);
var orig_type_11184 = cljs.core.nth.call(null,vec__11132_11183,(0),null);
var f_11185 = cljs.core.nth.call(null,vec__11132_11183,(1),null);
var seq__11114_11186 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11184,new cljs.core.PersistentArrayMap.fromArray([orig_type_11184,cljs.core.identity], true, false)));
var chunk__11116_11187 = null;
var count__11117_11188 = (0);
var i__11118_11189 = (0);
while(true){
if((i__11118_11189 < count__11117_11188)){
var vec__11133_11190 = cljs.core._nth.call(null,chunk__11116_11187,i__11118_11189);
var actual_type_11191 = cljs.core.nth.call(null,vec__11133_11190,(0),null);
var factory_11192 = cljs.core.nth.call(null,vec__11133_11190,(1),null);
var canonical_f_11193 = (cljs.core.truth_(selector_11137)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11136,selector_11137):cljs.core.identity).call(null,factory_11192.call(null,f_11185));
dommy.core.update_event_listeners_BANG_.call(null,elem_11136,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11137,actual_type_11191,f_11185], null),canonical_f_11193);

if(cljs.core.truth_(elem_11136.addEventListener)){
elem_11136.addEventListener(cljs.core.name.call(null,actual_type_11191),canonical_f_11193);
} else {
elem_11136.attachEvent(cljs.core.name.call(null,actual_type_11191),canonical_f_11193);
}

var G__11194 = seq__11114_11186;
var G__11195 = chunk__11116_11187;
var G__11196 = count__11117_11188;
var G__11197 = (i__11118_11189 + (1));
seq__11114_11186 = G__11194;
chunk__11116_11187 = G__11195;
count__11117_11188 = G__11196;
i__11118_11189 = G__11197;
continue;
} else {
var temp__4126__auto___11198__$1 = cljs.core.seq.call(null,seq__11114_11186);
if(temp__4126__auto___11198__$1){
var seq__11114_11199__$1 = temp__4126__auto___11198__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11114_11199__$1)){
var c__5061__auto___11200 = cljs.core.chunk_first.call(null,seq__11114_11199__$1);
var G__11201 = cljs.core.chunk_rest.call(null,seq__11114_11199__$1);
var G__11202 = c__5061__auto___11200;
var G__11203 = cljs.core.count.call(null,c__5061__auto___11200);
var G__11204 = (0);
seq__11114_11186 = G__11201;
chunk__11116_11187 = G__11202;
count__11117_11188 = G__11203;
i__11118_11189 = G__11204;
continue;
} else {
var vec__11134_11205 = cljs.core.first.call(null,seq__11114_11199__$1);
var actual_type_11206 = cljs.core.nth.call(null,vec__11134_11205,(0),null);
var factory_11207 = cljs.core.nth.call(null,vec__11134_11205,(1),null);
var canonical_f_11208 = (cljs.core.truth_(selector_11137)?cljs.core.partial.call(null,dommy.core.live_listener,elem_11136,selector_11137):cljs.core.identity).call(null,factory_11207.call(null,f_11185));
dommy.core.update_event_listeners_BANG_.call(null,elem_11136,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11137,actual_type_11206,f_11185], null),canonical_f_11208);

if(cljs.core.truth_(elem_11136.addEventListener)){
elem_11136.addEventListener(cljs.core.name.call(null,actual_type_11206),canonical_f_11208);
} else {
elem_11136.attachEvent(cljs.core.name.call(null,actual_type_11206),canonical_f_11208);
}

var G__11209 = cljs.core.next.call(null,seq__11114_11199__$1);
var G__11210 = null;
var G__11211 = (0);
var G__11212 = (0);
seq__11114_11186 = G__11209;
chunk__11116_11187 = G__11210;
count__11117_11188 = G__11211;
i__11118_11189 = G__11212;
continue;
}
} else {
}
}
break;
}

var G__11213 = cljs.core.next.call(null,seq__11113_11177__$1);
var G__11214 = null;
var G__11215 = (0);
var G__11216 = (0);
seq__11113_11138 = G__11213;
chunk__11120_11139 = G__11214;
count__11121_11140 = G__11215;
i__11122_11141 = G__11216;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq11110){
var G__11111 = cljs.core.first.call(null,seq11110);
var seq11110__$1 = cljs.core.next.call(null,seq11110);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11111,seq11110__$1);
});
/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 * The following forms are allowed, and will remove all handlers
 * that match the parameters passed in:
 * 
 * (unlisten! [elem :.selector] :click event-listener)
 * 
 * (unlisten! [elem :.selector]
 * :click event-listener
 * :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11219_11242 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11243 = cljs.core.nth.call(null,vec__11219_11242,(0),null);
var selector_11244 = cljs.core.nth.call(null,vec__11219_11242,(1),null);
var seq__11220_11245 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11227_11246 = null;
var count__11228_11247 = (0);
var i__11229_11248 = (0);
while(true){
if((i__11229_11248 < count__11228_11247)){
var vec__11236_11249 = cljs.core._nth.call(null,chunk__11227_11246,i__11229_11248);
var orig_type_11250 = cljs.core.nth.call(null,vec__11236_11249,(0),null);
var f_11251 = cljs.core.nth.call(null,vec__11236_11249,(1),null);
var seq__11230_11252 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11250,new cljs.core.PersistentArrayMap.fromArray([orig_type_11250,cljs.core.identity], true, false)));
var chunk__11232_11253 = null;
var count__11233_11254 = (0);
var i__11234_11255 = (0);
while(true){
if((i__11234_11255 < count__11233_11254)){
var vec__11237_11256 = cljs.core._nth.call(null,chunk__11232_11253,i__11234_11255);
var actual_type_11257 = cljs.core.nth.call(null,vec__11237_11256,(0),null);
var __11258 = cljs.core.nth.call(null,vec__11237_11256,(1),null);
var keys_11259 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11244,actual_type_11257,f_11251], null);
var canonical_f_11260 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11243),keys_11259);
dommy.core.update_event_listeners_BANG_.call(null,elem_11243,dommy.utils.dissoc_in,keys_11259);

if(cljs.core.truth_(elem_11243.removeEventListener)){
elem_11243.removeEventListener(cljs.core.name.call(null,actual_type_11257),canonical_f_11260);
} else {
elem_11243.detachEvent(cljs.core.name.call(null,actual_type_11257),canonical_f_11260);
}

var G__11261 = seq__11230_11252;
var G__11262 = chunk__11232_11253;
var G__11263 = count__11233_11254;
var G__11264 = (i__11234_11255 + (1));
seq__11230_11252 = G__11261;
chunk__11232_11253 = G__11262;
count__11233_11254 = G__11263;
i__11234_11255 = G__11264;
continue;
} else {
var temp__4126__auto___11265 = cljs.core.seq.call(null,seq__11230_11252);
if(temp__4126__auto___11265){
var seq__11230_11266__$1 = temp__4126__auto___11265;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11230_11266__$1)){
var c__5061__auto___11267 = cljs.core.chunk_first.call(null,seq__11230_11266__$1);
var G__11268 = cljs.core.chunk_rest.call(null,seq__11230_11266__$1);
var G__11269 = c__5061__auto___11267;
var G__11270 = cljs.core.count.call(null,c__5061__auto___11267);
var G__11271 = (0);
seq__11230_11252 = G__11268;
chunk__11232_11253 = G__11269;
count__11233_11254 = G__11270;
i__11234_11255 = G__11271;
continue;
} else {
var vec__11238_11272 = cljs.core.first.call(null,seq__11230_11266__$1);
var actual_type_11273 = cljs.core.nth.call(null,vec__11238_11272,(0),null);
var __11274 = cljs.core.nth.call(null,vec__11238_11272,(1),null);
var keys_11275 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11244,actual_type_11273,f_11251], null);
var canonical_f_11276 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11243),keys_11275);
dommy.core.update_event_listeners_BANG_.call(null,elem_11243,dommy.utils.dissoc_in,keys_11275);

if(cljs.core.truth_(elem_11243.removeEventListener)){
elem_11243.removeEventListener(cljs.core.name.call(null,actual_type_11273),canonical_f_11276);
} else {
elem_11243.detachEvent(cljs.core.name.call(null,actual_type_11273),canonical_f_11276);
}

var G__11277 = cljs.core.next.call(null,seq__11230_11266__$1);
var G__11278 = null;
var G__11279 = (0);
var G__11280 = (0);
seq__11230_11252 = G__11277;
chunk__11232_11253 = G__11278;
count__11233_11254 = G__11279;
i__11234_11255 = G__11280;
continue;
}
} else {
}
}
break;
}

var G__11281 = seq__11220_11245;
var G__11282 = chunk__11227_11246;
var G__11283 = count__11228_11247;
var G__11284 = (i__11229_11248 + (1));
seq__11220_11245 = G__11281;
chunk__11227_11246 = G__11282;
count__11228_11247 = G__11283;
i__11229_11248 = G__11284;
continue;
} else {
var temp__4126__auto___11285 = cljs.core.seq.call(null,seq__11220_11245);
if(temp__4126__auto___11285){
var seq__11220_11286__$1 = temp__4126__auto___11285;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11220_11286__$1)){
var c__5061__auto___11287 = cljs.core.chunk_first.call(null,seq__11220_11286__$1);
var G__11288 = cljs.core.chunk_rest.call(null,seq__11220_11286__$1);
var G__11289 = c__5061__auto___11287;
var G__11290 = cljs.core.count.call(null,c__5061__auto___11287);
var G__11291 = (0);
seq__11220_11245 = G__11288;
chunk__11227_11246 = G__11289;
count__11228_11247 = G__11290;
i__11229_11248 = G__11291;
continue;
} else {
var vec__11239_11292 = cljs.core.first.call(null,seq__11220_11286__$1);
var orig_type_11293 = cljs.core.nth.call(null,vec__11239_11292,(0),null);
var f_11294 = cljs.core.nth.call(null,vec__11239_11292,(1),null);
var seq__11221_11295 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_11293,new cljs.core.PersistentArrayMap.fromArray([orig_type_11293,cljs.core.identity], true, false)));
var chunk__11223_11296 = null;
var count__11224_11297 = (0);
var i__11225_11298 = (0);
while(true){
if((i__11225_11298 < count__11224_11297)){
var vec__11240_11299 = cljs.core._nth.call(null,chunk__11223_11296,i__11225_11298);
var actual_type_11300 = cljs.core.nth.call(null,vec__11240_11299,(0),null);
var __11301 = cljs.core.nth.call(null,vec__11240_11299,(1),null);
var keys_11302 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11244,actual_type_11300,f_11294], null);
var canonical_f_11303 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11243),keys_11302);
dommy.core.update_event_listeners_BANG_.call(null,elem_11243,dommy.utils.dissoc_in,keys_11302);

if(cljs.core.truth_(elem_11243.removeEventListener)){
elem_11243.removeEventListener(cljs.core.name.call(null,actual_type_11300),canonical_f_11303);
} else {
elem_11243.detachEvent(cljs.core.name.call(null,actual_type_11300),canonical_f_11303);
}

var G__11304 = seq__11221_11295;
var G__11305 = chunk__11223_11296;
var G__11306 = count__11224_11297;
var G__11307 = (i__11225_11298 + (1));
seq__11221_11295 = G__11304;
chunk__11223_11296 = G__11305;
count__11224_11297 = G__11306;
i__11225_11298 = G__11307;
continue;
} else {
var temp__4126__auto___11308__$1 = cljs.core.seq.call(null,seq__11221_11295);
if(temp__4126__auto___11308__$1){
var seq__11221_11309__$1 = temp__4126__auto___11308__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11221_11309__$1)){
var c__5061__auto___11310 = cljs.core.chunk_first.call(null,seq__11221_11309__$1);
var G__11311 = cljs.core.chunk_rest.call(null,seq__11221_11309__$1);
var G__11312 = c__5061__auto___11310;
var G__11313 = cljs.core.count.call(null,c__5061__auto___11310);
var G__11314 = (0);
seq__11221_11295 = G__11311;
chunk__11223_11296 = G__11312;
count__11224_11297 = G__11313;
i__11225_11298 = G__11314;
continue;
} else {
var vec__11241_11315 = cljs.core.first.call(null,seq__11221_11309__$1);
var actual_type_11316 = cljs.core.nth.call(null,vec__11241_11315,(0),null);
var __11317 = cljs.core.nth.call(null,vec__11241_11315,(1),null);
var keys_11318 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_11244,actual_type_11316,f_11294], null);
var canonical_f_11319 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_11243),keys_11318);
dommy.core.update_event_listeners_BANG_.call(null,elem_11243,dommy.utils.dissoc_in,keys_11318);

if(cljs.core.truth_(elem_11243.removeEventListener)){
elem_11243.removeEventListener(cljs.core.name.call(null,actual_type_11316),canonical_f_11319);
} else {
elem_11243.detachEvent(cljs.core.name.call(null,actual_type_11316),canonical_f_11319);
}

var G__11320 = cljs.core.next.call(null,seq__11221_11309__$1);
var G__11321 = null;
var G__11322 = (0);
var G__11323 = (0);
seq__11221_11295 = G__11320;
chunk__11223_11296 = G__11321;
count__11224_11297 = G__11322;
i__11225_11298 = G__11323;
continue;
}
} else {
}
}
break;
}

var G__11324 = cljs.core.next.call(null,seq__11220_11286__$1);
var G__11325 = null;
var G__11326 = (0);
var G__11327 = (0);
seq__11220_11245 = G__11324;
chunk__11227_11246 = G__11325;
count__11228_11247 = G__11326;
i__11229_11248 = G__11327;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq11217){
var G__11218 = cljs.core.first.call(null,seq11217);
var seq11217__$1 = cljs.core.next.call(null,seq11217);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11218,seq11217__$1);
});
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))))].join('')));
}

var vec__11330_11337 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_11338 = cljs.core.nth.call(null,vec__11330_11337,(0),null);
var selector_11339 = cljs.core.nth.call(null,vec__11330_11337,(1),null);
var seq__11331_11340 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__11332_11341 = null;
var count__11333_11342 = (0);
var i__11334_11343 = (0);
while(true){
if((i__11334_11343 < count__11333_11342)){
var vec__11335_11344 = cljs.core._nth.call(null,chunk__11332_11341,i__11334_11343);
var type_11345 = cljs.core.nth.call(null,vec__11335_11344,(0),null);
var f_11346 = cljs.core.nth.call(null,vec__11335_11344,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_11345,((function (seq__11331_11340,chunk__11332_11341,count__11333_11342,i__11334_11343,vec__11335_11344,type_11345,f_11346,vec__11330_11337,elem_11338,selector_11339){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_11345,dommy$core$this_fn);

return f_11346.call(null,e);
});})(seq__11331_11340,chunk__11332_11341,count__11333_11342,i__11334_11343,vec__11335_11344,type_11345,f_11346,vec__11330_11337,elem_11338,selector_11339))
);

var G__11347 = seq__11331_11340;
var G__11348 = chunk__11332_11341;
var G__11349 = count__11333_11342;
var G__11350 = (i__11334_11343 + (1));
seq__11331_11340 = G__11347;
chunk__11332_11341 = G__11348;
count__11333_11342 = G__11349;
i__11334_11343 = G__11350;
continue;
} else {
var temp__4126__auto___11351 = cljs.core.seq.call(null,seq__11331_11340);
if(temp__4126__auto___11351){
var seq__11331_11352__$1 = temp__4126__auto___11351;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11331_11352__$1)){
var c__5061__auto___11353 = cljs.core.chunk_first.call(null,seq__11331_11352__$1);
var G__11354 = cljs.core.chunk_rest.call(null,seq__11331_11352__$1);
var G__11355 = c__5061__auto___11353;
var G__11356 = cljs.core.count.call(null,c__5061__auto___11353);
var G__11357 = (0);
seq__11331_11340 = G__11354;
chunk__11332_11341 = G__11355;
count__11333_11342 = G__11356;
i__11334_11343 = G__11357;
continue;
} else {
var vec__11336_11358 = cljs.core.first.call(null,seq__11331_11352__$1);
var type_11359 = cljs.core.nth.call(null,vec__11336_11358,(0),null);
var f_11360 = cljs.core.nth.call(null,vec__11336_11358,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_11359,((function (seq__11331_11340,chunk__11332_11341,count__11333_11342,i__11334_11343,vec__11336_11358,type_11359,f_11360,seq__11331_11352__$1,temp__4126__auto___11351,vec__11330_11337,elem_11338,selector_11339){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_11359,dommy$core$this_fn);

return f_11360.call(null,e);
});})(seq__11331_11340,chunk__11332_11341,count__11333_11342,i__11334_11343,vec__11336_11358,type_11359,f_11360,seq__11331_11352__$1,temp__4126__auto___11351,vec__11330_11337,elem_11338,selector_11339))
);

var G__11361 = cljs.core.next.call(null,seq__11331_11352__$1);
var G__11362 = null;
var G__11363 = (0);
var G__11364 = (0);
seq__11331_11340 = G__11361;
chunk__11332_11341 = G__11362;
count__11333_11342 = G__11363;
i__11334_11343 = G__11364;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq11328){
var G__11329 = cljs.core.first.call(null,seq11328);
var seq11328__$1 = cljs.core.next.call(null,seq11328);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11329,seq11328__$1);
});
/**
 * NOTE: ONLY TO BE USED FOR TESTS. May not work at mocking many
 * event types or their bubbling behaviours
 * 
 * Creates an event of type `event-type`, optionally having
 * `update-event!` mutate and return an updated event object,
 * and fires it on `node`.
 * Only works when `node` is in the DOM
 */
dommy.core.fire_BANG_ = (function dommy$core$fire_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (node,event_type,p__11368){
var vec__11369 = p__11368;
var update_event_BANG_ = cljs.core.nth.call(null,vec__11369,(0),null);
if(dommy.core.descendant_QMARK_.call(null,node,document.documentElement)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"descendant?","descendant?",-1027057938,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol("js","document.documentElement","js/document.documentElement",1597931428,null))))].join('')));
}

var update_event_BANG___$1 = (function (){var or__4276__auto__ = update_event_BANG_;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.identity;
}
})();
if(cljs.core.truth_(document.createEvent)){
var event = document.createEvent("Event");
event.initEvent(cljs.core.name.call(null,event_type),true,true);

return node.dispatchEvent(update_event_BANG___$1.call(null,event));
} else {
return node.fireEvent([cljs.core.str("on"),cljs.core.str(cljs.core.name.call(null,event_type))].join(''),update_event_BANG___$1.call(null,document.createEventObject()));
}
});

dommy.core.fire_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.fire_BANG_.cljs$lang$applyTo = (function (seq11365){
var G__11366 = cljs.core.first.call(null,seq11365);
var seq11365__$1 = cljs.core.next.call(null,seq11365);
var G__11367 = cljs.core.first.call(null,seq11365__$1);
var seq11365__$2 = cljs.core.next.call(null,seq11365__$1);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11366,G__11367,seq11365__$2);
});
