// Compiled by ClojureScript 0.0-3196 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('goog.math.Long');
goog.require('com.cognitect.transit.eq');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__11834_11838 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__11835_11839 = null;
var count__11836_11840 = (0);
var i__11837_11841 = (0);
while(true){
if((i__11837_11841 < count__11836_11840)){
var k_11842 = cljs.core._nth.call(null,chunk__11835_11839,i__11837_11841);
var v_11843 = (b[k_11842]);
(a[k_11842] = v_11843);

var G__11844 = seq__11834_11838;
var G__11845 = chunk__11835_11839;
var G__11846 = count__11836_11840;
var G__11847 = (i__11837_11841 + (1));
seq__11834_11838 = G__11844;
chunk__11835_11839 = G__11845;
count__11836_11840 = G__11846;
i__11837_11841 = G__11847;
continue;
} else {
var temp__4126__auto___11848 = cljs.core.seq.call(null,seq__11834_11838);
if(temp__4126__auto___11848){
var seq__11834_11849__$1 = temp__4126__auto___11848;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11834_11849__$1)){
var c__5061__auto___11850 = cljs.core.chunk_first.call(null,seq__11834_11849__$1);
var G__11851 = cljs.core.chunk_rest.call(null,seq__11834_11849__$1);
var G__11852 = c__5061__auto___11850;
var G__11853 = cljs.core.count.call(null,c__5061__auto___11850);
var G__11854 = (0);
seq__11834_11838 = G__11851;
chunk__11835_11839 = G__11852;
count__11836_11840 = G__11853;
i__11837_11841 = G__11854;
continue;
} else {
var k_11855 = cljs.core.first.call(null,seq__11834_11849__$1);
var v_11856 = (b[k_11855]);
(a[k_11855] = v_11856);

var G__11857 = cljs.core.next.call(null,seq__11834_11849__$1);
var G__11858 = null;
var G__11859 = (0);
var G__11860 = (0);
seq__11834_11838 = G__11857;
chunk__11835_11839 = G__11858;
count__11836_11840 = G__11859;
i__11837_11841 = G__11860;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(){
var G__11862 = arguments.length;
switch (G__11862) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"prefersStrings": false, "arrayBuilder": (new cognitect.transit.VectorBuilder()), "mapBuilder": (new cognitect.transit.MapBuilder()), "handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__11864 = (i + (2));
var G__11865 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__11864;
ret = G__11865;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts)))},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;
/**
 * Read a transit encoded string into ClojureScript values given a
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__11866_11870 = cljs.core.seq.call(null,v);
var chunk__11867_11871 = null;
var count__11868_11872 = (0);
var i__11869_11873 = (0);
while(true){
if((i__11869_11873 < count__11868_11872)){
var x_11874 = cljs.core._nth.call(null,chunk__11867_11871,i__11869_11873);
ret.push(x_11874);

var G__11875 = seq__11866_11870;
var G__11876 = chunk__11867_11871;
var G__11877 = count__11868_11872;
var G__11878 = (i__11869_11873 + (1));
seq__11866_11870 = G__11875;
chunk__11867_11871 = G__11876;
count__11868_11872 = G__11877;
i__11869_11873 = G__11878;
continue;
} else {
var temp__4126__auto___11879 = cljs.core.seq.call(null,seq__11866_11870);
if(temp__4126__auto___11879){
var seq__11866_11880__$1 = temp__4126__auto___11879;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11866_11880__$1)){
var c__5061__auto___11881 = cljs.core.chunk_first.call(null,seq__11866_11880__$1);
var G__11882 = cljs.core.chunk_rest.call(null,seq__11866_11880__$1);
var G__11883 = c__5061__auto___11881;
var G__11884 = cljs.core.count.call(null,c__5061__auto___11881);
var G__11885 = (0);
seq__11866_11870 = G__11882;
chunk__11867_11871 = G__11883;
count__11868_11872 = G__11884;
i__11869_11873 = G__11885;
continue;
} else {
var x_11886 = cljs.core.first.call(null,seq__11866_11880__$1);
ret.push(x_11886);

var G__11887 = cljs.core.next.call(null,seq__11866_11880__$1);
var G__11888 = null;
var G__11889 = (0);
var G__11890 = (0);
seq__11866_11870 = G__11887;
chunk__11867_11871 = G__11888;
count__11868_11872 = G__11889;
i__11869_11873 = G__11890;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__11891_11895 = cljs.core.seq.call(null,v);
var chunk__11892_11896 = null;
var count__11893_11897 = (0);
var i__11894_11898 = (0);
while(true){
if((i__11894_11898 < count__11893_11897)){
var x_11899 = cljs.core._nth.call(null,chunk__11892_11896,i__11894_11898);
ret.push(x_11899);

var G__11900 = seq__11891_11895;
var G__11901 = chunk__11892_11896;
var G__11902 = count__11893_11897;
var G__11903 = (i__11894_11898 + (1));
seq__11891_11895 = G__11900;
chunk__11892_11896 = G__11901;
count__11893_11897 = G__11902;
i__11894_11898 = G__11903;
continue;
} else {
var temp__4126__auto___11904 = cljs.core.seq.call(null,seq__11891_11895);
if(temp__4126__auto___11904){
var seq__11891_11905__$1 = temp__4126__auto___11904;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11891_11905__$1)){
var c__5061__auto___11906 = cljs.core.chunk_first.call(null,seq__11891_11905__$1);
var G__11907 = cljs.core.chunk_rest.call(null,seq__11891_11905__$1);
var G__11908 = c__5061__auto___11906;
var G__11909 = cljs.core.count.call(null,c__5061__auto___11906);
var G__11910 = (0);
seq__11891_11895 = G__11907;
chunk__11892_11896 = G__11908;
count__11893_11897 = G__11909;
i__11894_11898 = G__11910;
continue;
} else {
var x_11911 = cljs.core.first.call(null,seq__11891_11905__$1);
ret.push(x_11911);

var G__11912 = cljs.core.next.call(null,seq__11891_11905__$1);
var G__11913 = null;
var G__11914 = (0);
var G__11915 = (0);
seq__11891_11895 = G__11912;
chunk__11892_11896 = G__11913;
count__11893_11897 = G__11914;
i__11894_11898 = G__11915;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__11916_11920 = cljs.core.seq.call(null,v);
var chunk__11917_11921 = null;
var count__11918_11922 = (0);
var i__11919_11923 = (0);
while(true){
if((i__11919_11923 < count__11918_11922)){
var x_11924 = cljs.core._nth.call(null,chunk__11917_11921,i__11919_11923);
ret.push(x_11924);

var G__11925 = seq__11916_11920;
var G__11926 = chunk__11917_11921;
var G__11927 = count__11918_11922;
var G__11928 = (i__11919_11923 + (1));
seq__11916_11920 = G__11925;
chunk__11917_11921 = G__11926;
count__11918_11922 = G__11927;
i__11919_11923 = G__11928;
continue;
} else {
var temp__4126__auto___11929 = cljs.core.seq.call(null,seq__11916_11920);
if(temp__4126__auto___11929){
var seq__11916_11930__$1 = temp__4126__auto___11929;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11916_11930__$1)){
var c__5061__auto___11931 = cljs.core.chunk_first.call(null,seq__11916_11930__$1);
var G__11932 = cljs.core.chunk_rest.call(null,seq__11916_11930__$1);
var G__11933 = c__5061__auto___11931;
var G__11934 = cljs.core.count.call(null,c__5061__auto___11931);
var G__11935 = (0);
seq__11916_11920 = G__11932;
chunk__11917_11921 = G__11933;
count__11918_11922 = G__11934;
i__11919_11923 = G__11935;
continue;
} else {
var x_11936 = cljs.core.first.call(null,seq__11916_11930__$1);
ret.push(x_11936);

var G__11937 = cljs.core.next.call(null,seq__11916_11930__$1);
var G__11938 = null;
var G__11939 = (0);
var G__11940 = (0);
seq__11916_11920 = G__11937;
chunk__11917_11921 = G__11938;
count__11918_11922 = G__11939;
i__11919_11923 = G__11940;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 * opts is a map containing a :handlers entry. :handlers is a JavaScript
 * array of interleaved type constructors and handler instances for those
 * type constructors.
 */
cognitect.transit.writer = (function cognitect$transit$writer(){
var G__11942 = arguments.length;
switch (G__11942) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x11944 = cljs.core.clone.call(null,handlers);
x11944.forEach = ((function (x11944,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__11945 = cljs.core.seq.call(null,coll);
var chunk__11946 = null;
var count__11947 = (0);
var i__11948 = (0);
while(true){
if((i__11948 < count__11947)){
var vec__11949 = cljs.core._nth.call(null,chunk__11946,i__11948);
var k = cljs.core.nth.call(null,vec__11949,(0),null);
var v = cljs.core.nth.call(null,vec__11949,(1),null);
f.call(null,v,k);

var G__11952 = seq__11945;
var G__11953 = chunk__11946;
var G__11954 = count__11947;
var G__11955 = (i__11948 + (1));
seq__11945 = G__11952;
chunk__11946 = G__11953;
count__11947 = G__11954;
i__11948 = G__11955;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq.call(null,seq__11945);
if(temp__4126__auto__){
var seq__11945__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__11945__$1)){
var c__5061__auto__ = cljs.core.chunk_first.call(null,seq__11945__$1);
var G__11956 = cljs.core.chunk_rest.call(null,seq__11945__$1);
var G__11957 = c__5061__auto__;
var G__11958 = cljs.core.count.call(null,c__5061__auto__);
var G__11959 = (0);
seq__11945 = G__11956;
chunk__11946 = G__11957;
count__11947 = G__11958;
i__11948 = G__11959;
continue;
} else {
var vec__11950 = cljs.core.first.call(null,seq__11945__$1);
var k = cljs.core.nth.call(null,vec__11950,(0),null);
var v = cljs.core.nth.call(null,vec__11950,(1),null);
f.call(null,v,k);

var G__11960 = cljs.core.next.call(null,seq__11945__$1);
var G__11961 = null;
var G__11962 = (0);
var G__11963 = (0);
seq__11945 = G__11960;
chunk__11946 = G__11961;
count__11947 = G__11962;
i__11948 = G__11963;
continue;
}
} else {
return null;
}
}
break;
}
});})(x11944,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x11944;
})(), "objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__11943 = obj;
G__11943.push(kfn.call(null,k),vfn.call(null,v));

return G__11943;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;
/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(){
var G__11965 = arguments.length;
switch (G__11965) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t11966 !== 'undefined'){
} else {

/**
* @constructor
*/
cognitect.transit.t11966 = (function (verbose_handler_fn,str_rep_fn,rep_fn,tag_fn,meta11967){
this.verbose_handler_fn = verbose_handler_fn;
this.str_rep_fn = str_rep_fn;
this.rep_fn = rep_fn;
this.tag_fn = tag_fn;
this.meta11967 = meta11967;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cognitect.transit.t11966.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t11966.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t11966.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t11966.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t11966.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11968){
var self__ = this;
var _11968__$1 = this;
return self__.meta11967;
});

cognitect.transit.t11966.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11968,meta11967__$1){
var self__ = this;
var _11968__$1 = this;
return (new cognitect.transit.t11966(self__.verbose_handler_fn,self__.str_rep_fn,self__.rep_fn,self__.tag_fn,meta11967__$1));
});

cognitect.transit.t11966.cljs$lang$type = true;

cognitect.transit.t11966.cljs$lang$ctorStr = "cognitect.transit/t11966";

cognitect.transit.t11966.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write.call(null,writer__4856__auto__,"cognitect.transit/t11966");
});

cognitect.transit.__GT_t11966 = (function cognitect$transit$__GT_t11966(verbose_handler_fn__$1,str_rep_fn__$1,rep_fn__$1,tag_fn__$1,meta11967){
return (new cognitect.transit.t11966(verbose_handler_fn__$1,str_rep_fn__$1,rep_fn__$1,tag_fn__$1,meta11967));
});

}

return (new cognitect.transit.t11966(verbose_handler_fn,str_rep_fn,rep_fn,tag_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;
/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 * in the 53bit integer range, a goog.math.Long instance if above. s
 * may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.integer.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 * range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
return com.cognitect.transit.types.isUUID.call(null,x);
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});
