// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__4264__auto__ = v;
if(cljs.core.truth_(and__4264__auto__)){
return (v > (0));
} else {
return and__4264__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(cljs.core.not(clojure.string.blank_QMARK_(s))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__30642_SHARP_,p2__30641_SHARP_){
var vec__30644 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(p2__30641_SHARP_,/=/);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30644,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30644,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30642_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(no.en.core.url_decode(k)),no.en.core.url_decode(v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(cljs.core.not(clojure.string.blank_QMARK_(url))){
var uri = (function (){var G__30646 = url;
return goog.Uri.parse(G__30646);
})();
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.constant$keyword$scheme,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(uri.getScheme()),cljs.core.constant$keyword$server_DASH_name,uri.getDomain(),cljs.core.constant$keyword$server_DASH_port,cljs_http.client.if_pos(uri.getPort()),cljs.core.constant$keyword$uri,uri.getPath(),cljs.core.constant$keyword$query_DASH_string,((cljs.core.not(query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),cljs.core.constant$keyword$query_DASH_params,((cljs.core.not(query_data.isEmpty()))?cljs_http.client.parse_query_params([cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode(cljs.core.name(k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode([cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30647_SHARP_){
return cljs_http.client.encode_val(k,p1__30647_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__30648){
var vec__30650 = p__30648;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30650,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30650,(1),null);
if(cljs.core.coll_QMARK_(v)){
return cljs_http.client.encode_vals(k,v);
} else {
return cljs_http.client.encode_val(k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap(esc_chars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (esc_chars){
return (function (p1__30651_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__30651_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.replace.cljs$core$IFn$_invoke$arity$2(cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__4264__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$head,request_method);
if(and__4264__auto__){
return cljs.core.re_find(cljs.core.re_pattern([cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special(content_type))].join('')),[cljs.core.str(cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$headers.cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$body], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4124__auto__ = cljs.core.constant$keyword$edn_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var G__30654 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$edn_DASH_params),cljs.core.constant$keyword$body,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([params], 0))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/edn");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30654) : client.call(null,G__30654));
} else {
var G__30655 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30655) : client.call(null,G__30655));
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var c__7942__auto___30694 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___30694,channel){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___30694,channel){
return (function (state_30683){
var state_val_30684 = (state_30683[(1)]);
if((state_val_30684 === (2))){
var inst_30677 = (state_30683[(2)]);
var inst_30678 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_30679 = cljs_http.client.decode_body(inst_30677,cljs.reader.read_string,"application/edn",inst_30678);
var inst_30680 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_30679);
var inst_30681 = cljs.core.async.close_BANG_(channel);
var state_30683__$1 = (function (){var statearr_30685 = state_30683;
(statearr_30685[(7)] = inst_30680);

return statearr_30685;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30683__$1,inst_30681);
} else {
if((state_val_30684 === (1))){
var inst_30675 = (function (){var G__30686 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30686) : client.call(null,G__30686));
})();
var state_30683__$1 = state_30683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30683__$1,(2),inst_30675);
} else {
return null;
}
}
});})(c__7942__auto___30694,channel))
;
return ((function (switch__7880__auto__,c__7942__auto___30694,channel){
return (function() {
var cljs_http$client$wrap_edn_response_$_state_machine__7881__auto__ = null;
var cljs_http$client$wrap_edn_response_$_state_machine__7881__auto____0 = (function (){
var statearr_30690 = [null,null,null,null,null,null,null,null];
(statearr_30690[(0)] = cljs_http$client$wrap_edn_response_$_state_machine__7881__auto__);

(statearr_30690[(1)] = (1));

return statearr_30690;
});
var cljs_http$client$wrap_edn_response_$_state_machine__7881__auto____1 = (function (state_30683){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_30683);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e30691){if((e30691 instanceof Object)){
var ex__7884__auto__ = e30691;
var statearr_30692_30695 = state_30683;
(statearr_30692_30695[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30683);

return cljs.core.constant$keyword$recur;
} else {
throw e30691;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__30696 = state_30683;
state_30683 = G__30696;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs_http$client$wrap_edn_response_$_state_machine__7881__auto__ = function(state_30683){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_edn_response_$_state_machine__7881__auto____0.call(this);
case 1:
return cljs_http$client$wrap_edn_response_$_state_machine__7881__auto____1.call(this,state_30683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_edn_response_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_edn_response_$_state_machine__7881__auto____0;
cljs_http$client$wrap_edn_response_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_edn_response_$_state_machine__7881__auto____1;
return cljs_http$client$wrap_edn_response_$_state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___30694,channel))
})();
var state__7944__auto__ = (function (){var statearr_30693 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_30693[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___30694);

return statearr_30693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___30694,channel))
);


return channel;
});
});
cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__30699){
var vec__30700 = p__30699;
var accept = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30700,(0),null);
return ((function (vec__30700,accept){
return (function (request){
var temp__4124__auto__ = (function (){var or__4276__auto__ = cljs.core.constant$keyword$accept.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var accept__$1 = temp__4124__auto__;
var G__30701 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"accept"], null),accept__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30701) : client.call(null,G__30701));
} else {
var G__30702 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30702) : client.call(null,G__30702));
}
});
;})(vec__30700,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq30697){
var G__30698 = cljs.core.first(seq30697);
var seq30697__$1 = cljs.core.next(seq30697);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__30698,seq30697__$1);
});
cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__30705){
var vec__30706 = p__30705;
var content_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30706,(0),null);
return ((function (vec__30706,content_type){
return (function (request){
var temp__4124__auto__ = (function (){var or__4276__auto__ = cljs.core.constant$keyword$content_DASH_type.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var content_type__$1 = temp__4124__auto__;
var G__30707 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),content_type__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30707) : client.call(null,G__30707));
} else {
var G__30708 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30708) : client.call(null,G__30708));
}
});
;})(vec__30706,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq30703){
var G__30704 = cljs.core.first(seq30703);
var seq30703__$1 = cljs.core.next(seq30703);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__30704,seq30703__$1);
});
cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$encoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$encoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY,cljs.core.constant$keyword$decoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$decoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 * Content Type header.
 * 
 * A :transit-opts map can be optionally provided with the following keys:
 * 
 * :encoding                #{:json, :json-verbose}
 * :decoding                #{:json, :json-verbose}
 * :encoding/decoding-opts  appropriate map of options to be passed to
 * transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4124__auto__ = cljs.core.constant$keyword$transit_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var map__30712 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__30712__$1 = ((cljs.core.seq_QMARK_(map__30712))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30712):map__30712);
var encoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30712__$1,cljs.core.constant$keyword$encoding_DASH_opts);
var encoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30712__$1,cljs.core.constant$keyword$encoding);
var G__30713 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$transit_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.transit_encode(params,encoding,encoding_opts)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/transit+json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30713) : client.call(null,G__30713));
} else {
var G__30714 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30714) : client.call(null,G__30714));
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var map__30737 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__30737__$1 = ((cljs.core.seq_QMARK_(map__30737))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30737):map__30737);
var decoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30737__$1,cljs.core.constant$keyword$decoding_DASH_opts);
var decoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30737__$1,cljs.core.constant$keyword$decoding);
var c__7942__auto___30758 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___30758,channel,map__30737,map__30737__$1,decoding_opts,decoding){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___30758,channel,map__30737,map__30737__$1,decoding_opts,decoding){
return (function (state_30747){
var state_val_30748 = (state_30747[(1)]);
if((state_val_30748 === (2))){
var inst_30740 = (state_30747[(2)]);
var inst_30741 = (function (){var response = inst_30740;
return ((function (response,inst_30740,state_val_30748,c__7942__auto___30758,channel,map__30737,map__30737__$1,decoding_opts,decoding){
return (function (p1__30715_SHARP_){
return cljs_http.util.transit_decode(p1__30715_SHARP_,decoding,decoding_opts);
});
;})(response,inst_30740,state_val_30748,c__7942__auto___30758,channel,map__30737,map__30737__$1,decoding_opts,decoding))
})();
var inst_30742 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_30743 = cljs_http.client.decode_body(inst_30740,inst_30741,"application/transit+json",inst_30742);
var inst_30744 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_30743);
var inst_30745 = cljs.core.async.close_BANG_(channel);
var state_30747__$1 = (function (){var statearr_30749 = state_30747;
(statearr_30749[(7)] = inst_30744);

return statearr_30749;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30747__$1,inst_30745);
} else {
if((state_val_30748 === (1))){
var inst_30738 = (function (){var G__30750 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30750) : client.call(null,G__30750));
})();
var state_30747__$1 = state_30747;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30747__$1,(2),inst_30738);
} else {
return null;
}
}
});})(c__7942__auto___30758,channel,map__30737,map__30737__$1,decoding_opts,decoding))
;
return ((function (switch__7880__auto__,c__7942__auto___30758,channel,map__30737,map__30737__$1,decoding_opts,decoding){
return (function() {
var cljs_http$client$wrap_transit_response_$_state_machine__7881__auto__ = null;
var cljs_http$client$wrap_transit_response_$_state_machine__7881__auto____0 = (function (){
var statearr_30754 = [null,null,null,null,null,null,null,null];
(statearr_30754[(0)] = cljs_http$client$wrap_transit_response_$_state_machine__7881__auto__);

(statearr_30754[(1)] = (1));

return statearr_30754;
});
var cljs_http$client$wrap_transit_response_$_state_machine__7881__auto____1 = (function (state_30747){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_30747);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e30755){if((e30755 instanceof Object)){
var ex__7884__auto__ = e30755;
var statearr_30756_30759 = state_30747;
(statearr_30756_30759[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30747);

return cljs.core.constant$keyword$recur;
} else {
throw e30755;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__30760 = state_30747;
state_30747 = G__30760;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs_http$client$wrap_transit_response_$_state_machine__7881__auto__ = function(state_30747){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_transit_response_$_state_machine__7881__auto____0.call(this);
case 1:
return cljs_http$client$wrap_transit_response_$_state_machine__7881__auto____1.call(this,state_30747);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_transit_response_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_transit_response_$_state_machine__7881__auto____0;
cljs_http$client$wrap_transit_response_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_transit_response_$_state_machine__7881__auto____1;
return cljs_http$client$wrap_transit_response_$_state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___30758,channel,map__30737,map__30737__$1,decoding_opts,decoding))
})();
var state__7944__auto__ = (function (){var statearr_30757 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_30757[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___30758);

return statearr_30757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___30758,channel,map__30737,map__30737__$1,decoding_opts,decoding))
);


return channel;
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4124__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var G__30763 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$json_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.json_encode(params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30763) : client.call(null,G__30763));
} else {
var G__30764 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30764) : client.call(null,G__30764));
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var c__7942__auto___30803 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___30803,channel){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___30803,channel){
return (function (state_30792){
var state_val_30793 = (state_30792[(1)]);
if((state_val_30793 === (2))){
var inst_30786 = (state_30792[(2)]);
var inst_30787 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_30788 = cljs_http.client.decode_body(inst_30786,cljs_http.util.json_decode,"application/json",inst_30787);
var inst_30789 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_30788);
var inst_30790 = cljs.core.async.close_BANG_(channel);
var state_30792__$1 = (function (){var statearr_30794 = state_30792;
(statearr_30794[(7)] = inst_30789);

return statearr_30794;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30792__$1,inst_30790);
} else {
if((state_val_30793 === (1))){
var inst_30784 = (function (){var G__30795 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30795) : client.call(null,G__30795));
})();
var state_30792__$1 = state_30792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30792__$1,(2),inst_30784);
} else {
return null;
}
}
});})(c__7942__auto___30803,channel))
;
return ((function (switch__7880__auto__,c__7942__auto___30803,channel){
return (function() {
var cljs_http$client$wrap_json_response_$_state_machine__7881__auto__ = null;
var cljs_http$client$wrap_json_response_$_state_machine__7881__auto____0 = (function (){
var statearr_30799 = [null,null,null,null,null,null,null,null];
(statearr_30799[(0)] = cljs_http$client$wrap_json_response_$_state_machine__7881__auto__);

(statearr_30799[(1)] = (1));

return statearr_30799;
});
var cljs_http$client$wrap_json_response_$_state_machine__7881__auto____1 = (function (state_30792){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_30792);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e30800){if((e30800 instanceof Object)){
var ex__7884__auto__ = e30800;
var statearr_30801_30804 = state_30792;
(statearr_30801_30804[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30792);

return cljs.core.constant$keyword$recur;
} else {
throw e30800;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__30805 = state_30792;
state_30792 = G__30805;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs_http$client$wrap_json_response_$_state_machine__7881__auto__ = function(state_30792){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_json_response_$_state_machine__7881__auto____0.call(this);
case 1:
return cljs_http$client$wrap_json_response_$_state_machine__7881__auto____1.call(this,state_30792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_json_response_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_json_response_$_state_machine__7881__auto____0;
cljs_http$client$wrap_json_response_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_json_response_$_state_machine__7881__auto____1;
return cljs_http$client$wrap_json_response_$_state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___30803,channel))
})();
var state__7944__auto__ = (function (){var statearr_30802 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_30802[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___30803);

return statearr_30802;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___30803,channel))
);


return channel;
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__30810){
var map__30811 = p__30810;
var map__30811__$1 = ((cljs.core.seq_QMARK_(map__30811))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30811):map__30811);
var req = map__30811__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30811__$1,cljs.core.constant$keyword$query_DASH_params);
if(cljs.core.truth_(query_params)){
var G__30812 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$query_DASH_params),cljs.core.constant$keyword$query_DASH_string,cljs_http.client.generate_query_string(query_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30812) : client.call(null,G__30812));
} else {
var G__30813 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30813) : client.call(null,G__30813));
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__30818){
var map__30819 = p__30818;
var map__30819__$1 = ((cljs.core.seq_QMARK_(map__30819))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30819):map__30819);
var request = map__30819__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30819__$1,cljs.core.constant$keyword$request_DASH_method);
var form_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30819__$1,cljs.core.constant$keyword$form_DASH_params);
if(cljs.core.truth_((function (){var and__4264__auto__ = form_params;
if(cljs.core.truth_(and__4264__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$delete,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null).call(null,request_method);
} else {
return and__4264__auto__;
}
})())){
var G__30820 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$form_DASH_params),cljs.core.constant$keyword$body,cljs_http.client.generate_query_string(form_params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/x-www-form-urlencoded");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30820) : client.call(null,G__30820));
} else {
var G__30821 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30821) : client.call(null,G__30821));
}
});
});
cljs_http.client.wrap_android_cors_bugfix = (function cljs_http$client$wrap_android_cors_bugfix(client){
return (function (request){
var G__30823 = (cljs.core.truth_(cljs_http.util.android_QMARK_())?cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$android], null),(function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})()):request);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30823) : client.call(null,G__30823));
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4124__auto__ = cljs.core.constant$keyword$method.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var m = temp__4124__auto__;
var G__30826 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$method),cljs.core.constant$keyword$request_DASH_method,m);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30826) : client.call(null,G__30826));
} else {
var G__30827 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30827) : client.call(null,G__30827));
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__30828_SHARP_){
var G__30830 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30828_SHARP_,cljs.core.constant$keyword$server_DASH_name,server_name);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30830) : client.call(null,G__30830));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__30836){
var map__30837 = p__30836;
var map__30837__$1 = ((cljs.core.seq_QMARK_(map__30837))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30837):map__30837);
var req = map__30837__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30837__$1,cljs.core.constant$keyword$query_DASH_params);
var temp__4124__auto__ = cljs_http.client.parse_url(cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4124__auto__)){
var spec = temp__4124__auto__;
var G__30838 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,spec], 0)),cljs.core.constant$keyword$url),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params], null),((function (spec,temp__4124__auto__,map__30837,map__30837__$1,req,query_params){
return (function (p1__30831_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__30831_SHARP_,query_params], 0));
});})(spec,temp__4124__auto__,map__30837,map__30837__$1,req,query_params))
);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30838) : client.call(null,G__30838));
} else {
var G__30839 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30839) : client.call(null,G__30839));
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 * an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__30842){
var vec__30843 = p__30842;
var credentials = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30843,(0),null);
return ((function (vec__30843,credentials){
return (function (req){
var credentials__$1 = (function (){var or__4276__auto__ = cljs.core.constant$keyword$basic_DASH_auth.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_(credentials__$1))){
var G__30844 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$basic_DASH_auth),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),cljs_http.util.basic_auth(credentials__$1));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30844) : client.call(null,G__30844));
} else {
var G__30845 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30845) : client.call(null,G__30845));
}
});
;})(vec__30843,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq30840){
var G__30841 = cljs.core.first(seq30840);
var seq30840__$1 = cljs.core.next(seq30840);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__30841,seq30840__$1);
});
/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4124__auto__ = cljs.core.constant$keyword$oauth_DASH_token.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var oauth_token = temp__4124__auto__;
var G__30848 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$oauth_DASH_token),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join(''));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30848) : client.call(null,G__30848));
} else {
var G__30849 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30849) : client.call(null,G__30849));
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/client.
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_json_response(cljs_http.client.wrap_json_params(cljs_http.client.wrap_transit_response(cljs_http.client.wrap_transit_params(cljs_http.client.wrap_edn_response(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(request)))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request(cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30852){
var vec__30853 = p__30852;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30853,(0),null);
var G__30854 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$delete,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30854) : cljs_http.client.request.call(null,G__30854));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq30850){
var G__30851 = cljs.core.first(seq30850);
var seq30850__$1 = cljs.core.next(seq30850);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__30851,seq30850__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30857){
var vec__30858 = p__30857;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30858,(0),null);
var G__30859 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30859) : cljs_http.client.request.call(null,G__30859));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq30855){
var G__30856 = cljs.core.first(seq30855);
var seq30855__$1 = cljs.core.next(seq30855);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__30856,seq30855__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30862){
var vec__30863 = p__30862;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30863,(0),null);
var G__30864 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$head,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30864) : cljs_http.client.request.call(null,G__30864));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq30860){
var G__30861 = cljs.core.first(seq30860);
var seq30860__$1 = cljs.core.next(seq30860);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__30861,seq30860__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30867){
var vec__30868 = p__30867;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30868,(0),null);
var G__30869 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$move,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30869) : cljs_http.client.request.call(null,G__30869));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq30865){
var G__30866 = cljs.core.first(seq30865);
var seq30865__$1 = cljs.core.next(seq30865);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__30866,seq30865__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30872){
var vec__30873 = p__30872;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30873,(0),null);
var G__30874 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$options,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30874) : cljs_http.client.request.call(null,G__30874));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq30870){
var G__30871 = cljs.core.first(seq30870);
var seq30870__$1 = cljs.core.next(seq30870);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__30871,seq30870__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30877){
var vec__30878 = p__30877;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30878,(0),null);
var G__30879 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$patch,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30879) : cljs_http.client.request.call(null,G__30879));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq30875){
var G__30876 = cljs.core.first(seq30875);
var seq30875__$1 = cljs.core.next(seq30875);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__30876,seq30875__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30882){
var vec__30883 = p__30882;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30883,(0),null);
var G__30884 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30884) : cljs_http.client.request.call(null,G__30884));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq30880){
var G__30881 = cljs.core.first(seq30880);
var seq30880__$1 = cljs.core.next(seq30880);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__30881,seq30880__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30887){
var vec__30888 = p__30887;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30888,(0),null);
var G__30889 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$put,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30889) : cljs_http.client.request.call(null,G__30889));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq30885){
var G__30886 = cljs.core.first(seq30885);
var seq30885__$1 = cljs.core.next(seq30885);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__30886,seq30885__$1);
});
