// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t30895 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30895 = (function (f,fn_handler,meta30896){
this.f = f;
this.fn_handler = fn_handler;
this.meta30896 = meta30896;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t30895.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t30895.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t30895.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t30895.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30897){
var self__ = this;
var _30897__$1 = this;
return self__.meta30896;
});

cljs.core.async.t30895.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30897,meta30896__$1){
var self__ = this;
var _30897__$1 = this;
return (new cljs.core.async.t30895(self__.f,self__.fn_handler,meta30896__$1));
});

cljs.core.async.t30895.cljs$lang$type = true;

cljs.core.async.t30895.cljs$lang$ctorStr = "cljs.core.async/t30895";

cljs.core.async.t30895.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t30895");
});

cljs.core.async.__GT_t30895 = (function cljs$core$async$fn_handler_$___GT_t30895(f__$1,fn_handler__$1,meta30896){
return (new cljs.core.async.t30895(f__$1,fn_handler__$1,meta30896));
});

}

return (new cljs.core.async.t30895(f,cljs$core$async$fn_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
var G__30899 = buff;
if(G__30899){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__30899.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__30899.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,G__30899);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,G__30899);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var G__30901 = arguments.length;
switch (G__30901) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var G__30904 = arguments.length;
switch (G__30904) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_30909 = (function (){var G__30905 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30905) : cljs.core.deref.call(null,G__30905));
})();
if(cljs.core.truth_(on_caller_QMARK_)){
var G__30906_30910 = val_30909;
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__30906_30910) : fn1.call(null,G__30906_30910));
} else {
cljs.core.async.impl.dispatch.run(((function (val_30909,ret){
return (function (){
var G__30907 = val_30909;
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__30907) : fn1.call(null,G__30907));
});})(val_30909,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var G__30912 = arguments.length;
switch (G__30912) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4124__auto__)){
var ret = temp__4124__auto__;
var G__30913 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30913) : cljs.core.deref.call(null,G__30913));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4124__auto__)){
var retb = temp__4124__auto__;
var ret = (function (){var G__30914 = retb;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30914) : cljs.core.deref.call(null,G__30914));
})();
if(cljs.core.truth_(on_caller_QMARK_)){
var G__30915_30918 = ret;
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__30915_30918) : fn1.call(null,G__30915_30918));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4124__auto__){
return (function (){
var G__30916 = ret;
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__30916) : fn1.call(null,G__30916));
});})(ret,retb,temp__4124__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5161__auto___30919 = n;
var x_30920 = (0);
while(true){
if((x_30920 < n__5161__auto___30919)){
(a[x_30920] = (0));

var G__30921 = (x_30920 + (1));
x_30920 = G__30921;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__30922 = (i + (1));
i = G__30922;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (function (){var G__30930 = true;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30930) : cljs.core.atom.call(null,G__30930));
})();
if(typeof cljs.core.async.t30931 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30931 = (function (flag,alt_flag,meta30932){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta30932 = meta30932;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t30931.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t30931.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30934 = self__.flag;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30934) : cljs.core.deref.call(null,G__30934));
});})(flag))
;

cljs.core.async.t30931.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30935_30937 = self__.flag;
var G__30936_30938 = null;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30935_30937,G__30936_30938) : cljs.core.reset_BANG_.call(null,G__30935_30937,G__30936_30938));

return true;
});})(flag))
;

cljs.core.async.t30931.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_30933){
var self__ = this;
var _30933__$1 = this;
return self__.meta30932;
});})(flag))
;

cljs.core.async.t30931.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_30933,meta30932__$1){
var self__ = this;
var _30933__$1 = this;
return (new cljs.core.async.t30931(self__.flag,self__.alt_flag,meta30932__$1));
});})(flag))
;

cljs.core.async.t30931.cljs$lang$type = true;

cljs.core.async.t30931.cljs$lang$ctorStr = "cljs.core.async/t30931";

cljs.core.async.t30931.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t30931");
});})(flag))
;

cljs.core.async.__GT_t30931 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t30931(flag__$1,alt_flag__$1,meta30932){
return (new cljs.core.async.t30931(flag__$1,alt_flag__$1,meta30932));
});})(flag))
;

}

return (new cljs.core.async.t30931(flag,cljs$core$async$alt_flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t30942 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30942 = (function (cb,flag,alt_handler,meta30943){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta30943 = meta30943;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t30942.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t30942.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t30942.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t30942.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30944){
var self__ = this;
var _30944__$1 = this;
return self__.meta30943;
});

cljs.core.async.t30942.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30944,meta30943__$1){
var self__ = this;
var _30944__$1 = this;
return (new cljs.core.async.t30942(self__.cb,self__.flag,self__.alt_handler,meta30943__$1));
});

cljs.core.async.t30942.cljs$lang$type = true;

cljs.core.async.t30942.cljs$lang$ctorStr = "cljs.core.async/t30942";

cljs.core.async.t30942.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t30942");
});

cljs.core.async.__GT_t30942 = (function cljs$core$async$alt_handler_$___GT_t30942(cb__$1,flag__$1,alt_handler__$1,meta30943){
return (new cljs.core.async.t30942(cb__$1,flag__$1,alt_handler__$1,meta30943));
});

}

return (new cljs.core.async.t30942(cb,flag,cljs$core$async$alt_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.constant$keyword$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(function (){var G__30952 = (0);
return (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1(G__30952) : port.call(null,G__30952));
})():null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (function (){var G__30953 = (1);
return (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1(G__30953) : port.call(null,G__30953));
})();
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30945_SHARP_){
var G__30954 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30945_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30954) : fret.call(null,G__30954));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30946_SHARP_){
var G__30955 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30946_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30955) : fret.call(null,G__30955));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__30956 = vbox;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30956) : cljs.core.deref.call(null,G__30956));
})(),(function (){var or__4276__auto__ = wport;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30957 = (i + (1));
i = G__30957;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4276__auto__ = ret;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.constant$keyword$default)){
var temp__4126__auto__ = (function (){var and__4264__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4126__auto__)){
var got = temp__4126__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.constant$keyword$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30960){
var map__30961 = p__30960;
var map__30961__$1 = ((cljs.core.seq_QMARK_(map__30961))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30961):map__30961);
var opts = map__30961__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30958){
var G__30959 = cljs.core.first(seq30958);
var seq30958__$1 = cljs.core.next(seq30958);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30959,seq30958__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var G__30963 = arguments.length;
switch (G__30963) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__7942__auto___31012 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___31012){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___31012){
return (function (state_30987){
var state_val_30988 = (state_30987[(1)]);
if((state_val_30988 === (7))){
var inst_30983 = (state_30987[(2)]);
var state_30987__$1 = state_30987;
var statearr_30989_31013 = state_30987__$1;
(statearr_30989_31013[(2)] = inst_30983);

(statearr_30989_31013[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30988 === (1))){
var state_30987__$1 = state_30987;
var statearr_30990_31014 = state_30987__$1;
(statearr_30990_31014[(2)] = null);

(statearr_30990_31014[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30988 === (4))){
var inst_30966 = (state_30987[(7)]);
var inst_30966__$1 = (state_30987[(2)]);
var inst_30967 = (inst_30966__$1 == null);
var state_30987__$1 = (function (){var statearr_30991 = state_30987;
(statearr_30991[(7)] = inst_30966__$1);

return statearr_30991;
})();
if(cljs.core.truth_(inst_30967)){
var statearr_30992_31015 = state_30987__$1;
(statearr_30992_31015[(1)] = (5));

} else {
var statearr_30993_31016 = state_30987__$1;
(statearr_30993_31016[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30988 === (13))){
var state_30987__$1 = state_30987;
var statearr_30994_31017 = state_30987__$1;
(statearr_30994_31017[(2)] = null);

(statearr_30994_31017[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30988 === (6))){
var inst_30966 = (state_30987[(7)]);
var state_30987__$1 = state_30987;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30987__$1,(11),to,inst_30966);
} else {
if((state_val_30988 === (3))){
var inst_30985 = (state_30987[(2)]);
var state_30987__$1 = state_30987;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30987__$1,inst_30985);
} else {
if((state_val_30988 === (12))){
var state_30987__$1 = state_30987;
var statearr_30995_31018 = state_30987__$1;
(statearr_30995_31018[(2)] = null);

(statearr_30995_31018[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30988 === (2))){
var state_30987__$1 = state_30987;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30987__$1,(4),from);
} else {
if((state_val_30988 === (11))){
var inst_30976 = (state_30987[(2)]);
var state_30987__$1 = state_30987;
if(cljs.core.truth_(inst_30976)){
var statearr_30996_31019 = state_30987__$1;
(statearr_30996_31019[(1)] = (12));

} else {
var statearr_30997_31020 = state_30987__$1;
(statearr_30997_31020[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30988 === (9))){
var state_30987__$1 = state_30987;
var statearr_30998_31021 = state_30987__$1;
(statearr_30998_31021[(2)] = null);

(statearr_30998_31021[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30988 === (5))){
var state_30987__$1 = state_30987;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30999_31022 = state_30987__$1;
(statearr_30999_31022[(1)] = (8));

} else {
var statearr_31000_31023 = state_30987__$1;
(statearr_31000_31023[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30988 === (14))){
var inst_30981 = (state_30987[(2)]);
var state_30987__$1 = state_30987;
var statearr_31001_31024 = state_30987__$1;
(statearr_31001_31024[(2)] = inst_30981);

(statearr_31001_31024[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30988 === (10))){
var inst_30973 = (state_30987[(2)]);
var state_30987__$1 = state_30987;
var statearr_31002_31025 = state_30987__$1;
(statearr_31002_31025[(2)] = inst_30973);

(statearr_31002_31025[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30988 === (8))){
var inst_30970 = cljs.core.async.close_BANG_(to);
var state_30987__$1 = state_30987;
var statearr_31003_31026 = state_30987__$1;
(statearr_31003_31026[(2)] = inst_30970);

(statearr_31003_31026[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___31012))
;
return ((function (switch__7880__auto__,c__7942__auto___31012){
return (function() {
var cljs$core$async$state_machine__7881__auto__ = null;
var cljs$core$async$state_machine__7881__auto____0 = (function (){
var statearr_31007 = [null,null,null,null,null,null,null,null];
(statearr_31007[(0)] = cljs$core$async$state_machine__7881__auto__);

(statearr_31007[(1)] = (1));

return statearr_31007;
});
var cljs$core$async$state_machine__7881__auto____1 = (function (state_30987){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_30987);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e31008){if((e31008 instanceof Object)){
var ex__7884__auto__ = e31008;
var statearr_31009_31027 = state_30987;
(statearr_31009_31027[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30987);

return cljs.core.constant$keyword$recur;
} else {
throw e31008;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__31028 = state_30987;
state_30987 = G__31028;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$state_machine__7881__auto__ = function(state_30987){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7881__auto____1.call(this,state_30987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7881__auto____0;
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7881__auto____1;
return cljs$core$async$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___31012))
})();
var state__7944__auto__ = (function (){var statearr_31010 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_31010[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___31012);

return statearr_31010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___31012))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__31214){
var vec__31215 = p__31214;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31215,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31215,(1),null);
var job = vec__31215;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__7942__auto___31399 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___31399,res,vec__31215,v,p,job,jobs,results){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___31399,res,vec__31215,v,p,job,jobs,results){
return (function (state_31220){
var state_val_31221 = (state_31220[(1)]);
if((state_val_31221 === (2))){
var inst_31217 = (state_31220[(2)]);
var inst_31218 = cljs.core.async.close_BANG_(res);
var state_31220__$1 = (function (){var statearr_31222 = state_31220;
(statearr_31222[(7)] = inst_31217);

return statearr_31222;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31220__$1,inst_31218);
} else {
if((state_val_31221 === (1))){
var state_31220__$1 = state_31220;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31220__$1,(2),res,v);
} else {
return null;
}
}
});})(c__7942__auto___31399,res,vec__31215,v,p,job,jobs,results))
;
return ((function (switch__7880__auto__,c__7942__auto___31399,res,vec__31215,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0 = (function (){
var statearr_31226 = [null,null,null,null,null,null,null,null];
(statearr_31226[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__);

(statearr_31226[(1)] = (1));

return statearr_31226;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1 = (function (state_31220){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_31220);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e31227){if((e31227 instanceof Object)){
var ex__7884__auto__ = e31227;
var statearr_31228_31400 = state_31220;
(statearr_31228_31400[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31220);

return cljs.core.constant$keyword$recur;
} else {
throw e31227;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__31401 = state_31220;
state_31220 = G__31401;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__ = function(state_31220){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1.call(this,state_31220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___31399,res,vec__31215,v,p,job,jobs,results))
})();
var state__7944__auto__ = (function (){var statearr_31229 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_31229[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___31399);

return statearr_31229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___31399,res,vec__31215,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31230){
var vec__31231 = p__31230;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31231,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31231,(1),null);
var job = vec__31231;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var G__31232_31402 = v;
var G__31233_31403 = res;
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(G__31232_31402,G__31233_31403) : xf.call(null,G__31232_31402,G__31233_31403));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__5161__auto___31404 = n;
var __31405 = (0);
while(true){
if((__31405 < n__5161__auto___31404)){
var G__31234_31406 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__31234_31406) {
case "async":
var c__7942__auto___31408 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31405,c__7942__auto___31408,G__31234_31406,n__5161__auto___31404,jobs,results,process,async){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (__31405,c__7942__auto___31408,G__31234_31406,n__5161__auto___31404,jobs,results,process,async){
return (function (state_31247){
var state_val_31248 = (state_31247[(1)]);
if((state_val_31248 === (7))){
var inst_31243 = (state_31247[(2)]);
var state_31247__$1 = state_31247;
var statearr_31249_31409 = state_31247__$1;
(statearr_31249_31409[(2)] = inst_31243);

(statearr_31249_31409[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (6))){
var state_31247__$1 = state_31247;
var statearr_31250_31410 = state_31247__$1;
(statearr_31250_31410[(2)] = null);

(statearr_31250_31410[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (5))){
var state_31247__$1 = state_31247;
var statearr_31251_31411 = state_31247__$1;
(statearr_31251_31411[(2)] = null);

(statearr_31251_31411[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (4))){
var inst_31237 = (state_31247[(2)]);
var inst_31238 = async(inst_31237);
var state_31247__$1 = state_31247;
if(cljs.core.truth_(inst_31238)){
var statearr_31252_31412 = state_31247__$1;
(statearr_31252_31412[(1)] = (5));

} else {
var statearr_31253_31413 = state_31247__$1;
(statearr_31253_31413[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31248 === (3))){
var inst_31245 = (state_31247[(2)]);
var state_31247__$1 = state_31247;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31247__$1,inst_31245);
} else {
if((state_val_31248 === (2))){
var state_31247__$1 = state_31247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31247__$1,(4),jobs);
} else {
if((state_val_31248 === (1))){
var state_31247__$1 = state_31247;
var statearr_31254_31414 = state_31247__$1;
(statearr_31254_31414[(2)] = null);

(statearr_31254_31414[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31405,c__7942__auto___31408,G__31234_31406,n__5161__auto___31404,jobs,results,process,async))
;
return ((function (__31405,switch__7880__auto__,c__7942__auto___31408,G__31234_31406,n__5161__auto___31404,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0 = (function (){
var statearr_31258 = [null,null,null,null,null,null,null];
(statearr_31258[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__);

(statearr_31258[(1)] = (1));

return statearr_31258;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1 = (function (state_31247){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_31247);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e31259){if((e31259 instanceof Object)){
var ex__7884__auto__ = e31259;
var statearr_31260_31415 = state_31247;
(statearr_31260_31415[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31247);

return cljs.core.constant$keyword$recur;
} else {
throw e31259;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__31416 = state_31247;
state_31247 = G__31416;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__ = function(state_31247){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1.call(this,state_31247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__;
})()
;})(__31405,switch__7880__auto__,c__7942__auto___31408,G__31234_31406,n__5161__auto___31404,jobs,results,process,async))
})();
var state__7944__auto__ = (function (){var statearr_31261 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_31261[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___31408);

return statearr_31261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(__31405,c__7942__auto___31408,G__31234_31406,n__5161__auto___31404,jobs,results,process,async))
);


break;
case "compute":
var c__7942__auto___31417 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31405,c__7942__auto___31417,G__31234_31406,n__5161__auto___31404,jobs,results,process,async){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (__31405,c__7942__auto___31417,G__31234_31406,n__5161__auto___31404,jobs,results,process,async){
return (function (state_31274){
var state_val_31275 = (state_31274[(1)]);
if((state_val_31275 === (7))){
var inst_31270 = (state_31274[(2)]);
var state_31274__$1 = state_31274;
var statearr_31276_31418 = state_31274__$1;
(statearr_31276_31418[(2)] = inst_31270);

(statearr_31276_31418[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31275 === (6))){
var state_31274__$1 = state_31274;
var statearr_31277_31419 = state_31274__$1;
(statearr_31277_31419[(2)] = null);

(statearr_31277_31419[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31275 === (5))){
var state_31274__$1 = state_31274;
var statearr_31278_31420 = state_31274__$1;
(statearr_31278_31420[(2)] = null);

(statearr_31278_31420[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31275 === (4))){
var inst_31264 = (state_31274[(2)]);
var inst_31265 = process(inst_31264);
var state_31274__$1 = state_31274;
if(cljs.core.truth_(inst_31265)){
var statearr_31279_31421 = state_31274__$1;
(statearr_31279_31421[(1)] = (5));

} else {
var statearr_31280_31422 = state_31274__$1;
(statearr_31280_31422[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31275 === (3))){
var inst_31272 = (state_31274[(2)]);
var state_31274__$1 = state_31274;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31274__$1,inst_31272);
} else {
if((state_val_31275 === (2))){
var state_31274__$1 = state_31274;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31274__$1,(4),jobs);
} else {
if((state_val_31275 === (1))){
var state_31274__$1 = state_31274;
var statearr_31281_31423 = state_31274__$1;
(statearr_31281_31423[(2)] = null);

(statearr_31281_31423[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31405,c__7942__auto___31417,G__31234_31406,n__5161__auto___31404,jobs,results,process,async))
;
return ((function (__31405,switch__7880__auto__,c__7942__auto___31417,G__31234_31406,n__5161__auto___31404,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0 = (function (){
var statearr_31285 = [null,null,null,null,null,null,null];
(statearr_31285[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__);

(statearr_31285[(1)] = (1));

return statearr_31285;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1 = (function (state_31274){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_31274);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e31286){if((e31286 instanceof Object)){
var ex__7884__auto__ = e31286;
var statearr_31287_31424 = state_31274;
(statearr_31287_31424[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31274);

return cljs.core.constant$keyword$recur;
} else {
throw e31286;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__31425 = state_31274;
state_31274 = G__31425;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__ = function(state_31274){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1.call(this,state_31274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__;
})()
;})(__31405,switch__7880__auto__,c__7942__auto___31417,G__31234_31406,n__5161__auto___31404,jobs,results,process,async))
})();
var state__7944__auto__ = (function (){var statearr_31288 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_31288[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___31417);

return statearr_31288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(__31405,c__7942__auto___31417,G__31234_31406,n__5161__auto___31404,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__31426 = (__31405 + (1));
__31405 = G__31426;
continue;
} else {
}
break;
}

var c__7942__auto___31427 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___31427,jobs,results,process,async){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___31427,jobs,results,process,async){
return (function (state_31310){
var state_val_31311 = (state_31310[(1)]);
if((state_val_31311 === (9))){
var inst_31303 = (state_31310[(2)]);
var state_31310__$1 = (function (){var statearr_31312 = state_31310;
(statearr_31312[(7)] = inst_31303);

return statearr_31312;
})();
var statearr_31313_31428 = state_31310__$1;
(statearr_31313_31428[(2)] = null);

(statearr_31313_31428[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31311 === (8))){
var inst_31296 = (state_31310[(8)]);
var inst_31301 = (state_31310[(2)]);
var state_31310__$1 = (function (){var statearr_31314 = state_31310;
(statearr_31314[(9)] = inst_31301);

return statearr_31314;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31310__$1,(9),results,inst_31296);
} else {
if((state_val_31311 === (7))){
var inst_31306 = (state_31310[(2)]);
var state_31310__$1 = state_31310;
var statearr_31315_31429 = state_31310__$1;
(statearr_31315_31429[(2)] = inst_31306);

(statearr_31315_31429[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31311 === (6))){
var inst_31296 = (state_31310[(8)]);
var inst_31291 = (state_31310[(10)]);
var inst_31296__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31298 = [inst_31291,inst_31296__$1];
var inst_31299 = (new cljs.core.PersistentVector(null,2,(5),inst_31297,inst_31298,null));
var state_31310__$1 = (function (){var statearr_31316 = state_31310;
(statearr_31316[(8)] = inst_31296__$1);

return statearr_31316;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31310__$1,(8),jobs,inst_31299);
} else {
if((state_val_31311 === (5))){
var inst_31294 = cljs.core.async.close_BANG_(jobs);
var state_31310__$1 = state_31310;
var statearr_31317_31430 = state_31310__$1;
(statearr_31317_31430[(2)] = inst_31294);

(statearr_31317_31430[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31311 === (4))){
var inst_31291 = (state_31310[(10)]);
var inst_31291__$1 = (state_31310[(2)]);
var inst_31292 = (inst_31291__$1 == null);
var state_31310__$1 = (function (){var statearr_31318 = state_31310;
(statearr_31318[(10)] = inst_31291__$1);

return statearr_31318;
})();
if(cljs.core.truth_(inst_31292)){
var statearr_31319_31431 = state_31310__$1;
(statearr_31319_31431[(1)] = (5));

} else {
var statearr_31320_31432 = state_31310__$1;
(statearr_31320_31432[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31311 === (3))){
var inst_31308 = (state_31310[(2)]);
var state_31310__$1 = state_31310;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31310__$1,inst_31308);
} else {
if((state_val_31311 === (2))){
var state_31310__$1 = state_31310;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31310__$1,(4),from);
} else {
if((state_val_31311 === (1))){
var state_31310__$1 = state_31310;
var statearr_31321_31433 = state_31310__$1;
(statearr_31321_31433[(2)] = null);

(statearr_31321_31433[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___31427,jobs,results,process,async))
;
return ((function (switch__7880__auto__,c__7942__auto___31427,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0 = (function (){
var statearr_31325 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31325[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__);

(statearr_31325[(1)] = (1));

return statearr_31325;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1 = (function (state_31310){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_31310);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e31326){if((e31326 instanceof Object)){
var ex__7884__auto__ = e31326;
var statearr_31327_31434 = state_31310;
(statearr_31327_31434[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31310);

return cljs.core.constant$keyword$recur;
} else {
throw e31326;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__31435 = state_31310;
state_31310 = G__31435;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__ = function(state_31310){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1.call(this,state_31310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___31427,jobs,results,process,async))
})();
var state__7944__auto__ = (function (){var statearr_31328 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_31328[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___31427);

return statearr_31328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___31427,jobs,results,process,async))
);


var c__7942__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto__,jobs,results,process,async){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto__,jobs,results,process,async){
return (function (state_31366){
var state_val_31367 = (state_31366[(1)]);
if((state_val_31367 === (7))){
var inst_31362 = (state_31366[(2)]);
var state_31366__$1 = state_31366;
var statearr_31368_31436 = state_31366__$1;
(statearr_31368_31436[(2)] = inst_31362);

(statearr_31368_31436[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (20))){
var state_31366__$1 = state_31366;
var statearr_31369_31437 = state_31366__$1;
(statearr_31369_31437[(2)] = null);

(statearr_31369_31437[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (1))){
var state_31366__$1 = state_31366;
var statearr_31370_31438 = state_31366__$1;
(statearr_31370_31438[(2)] = null);

(statearr_31370_31438[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (4))){
var inst_31331 = (state_31366[(7)]);
var inst_31331__$1 = (state_31366[(2)]);
var inst_31332 = (inst_31331__$1 == null);
var state_31366__$1 = (function (){var statearr_31371 = state_31366;
(statearr_31371[(7)] = inst_31331__$1);

return statearr_31371;
})();
if(cljs.core.truth_(inst_31332)){
var statearr_31372_31439 = state_31366__$1;
(statearr_31372_31439[(1)] = (5));

} else {
var statearr_31373_31440 = state_31366__$1;
(statearr_31373_31440[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (15))){
var inst_31344 = (state_31366[(8)]);
var state_31366__$1 = state_31366;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31366__$1,(18),to,inst_31344);
} else {
if((state_val_31367 === (21))){
var inst_31357 = (state_31366[(2)]);
var state_31366__$1 = state_31366;
var statearr_31374_31441 = state_31366__$1;
(statearr_31374_31441[(2)] = inst_31357);

(statearr_31374_31441[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (13))){
var inst_31359 = (state_31366[(2)]);
var state_31366__$1 = (function (){var statearr_31375 = state_31366;
(statearr_31375[(9)] = inst_31359);

return statearr_31375;
})();
var statearr_31376_31442 = state_31366__$1;
(statearr_31376_31442[(2)] = null);

(statearr_31376_31442[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (6))){
var inst_31331 = (state_31366[(7)]);
var state_31366__$1 = state_31366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31366__$1,(11),inst_31331);
} else {
if((state_val_31367 === (17))){
var inst_31352 = (state_31366[(2)]);
var state_31366__$1 = state_31366;
if(cljs.core.truth_(inst_31352)){
var statearr_31377_31443 = state_31366__$1;
(statearr_31377_31443[(1)] = (19));

} else {
var statearr_31378_31444 = state_31366__$1;
(statearr_31378_31444[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (3))){
var inst_31364 = (state_31366[(2)]);
var state_31366__$1 = state_31366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31366__$1,inst_31364);
} else {
if((state_val_31367 === (12))){
var inst_31341 = (state_31366[(10)]);
var state_31366__$1 = state_31366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31366__$1,(14),inst_31341);
} else {
if((state_val_31367 === (2))){
var state_31366__$1 = state_31366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31366__$1,(4),results);
} else {
if((state_val_31367 === (19))){
var state_31366__$1 = state_31366;
var statearr_31379_31445 = state_31366__$1;
(statearr_31379_31445[(2)] = null);

(statearr_31379_31445[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (11))){
var inst_31341 = (state_31366[(2)]);
var state_31366__$1 = (function (){var statearr_31380 = state_31366;
(statearr_31380[(10)] = inst_31341);

return statearr_31380;
})();
var statearr_31381_31446 = state_31366__$1;
(statearr_31381_31446[(2)] = null);

(statearr_31381_31446[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (9))){
var state_31366__$1 = state_31366;
var statearr_31382_31447 = state_31366__$1;
(statearr_31382_31447[(2)] = null);

(statearr_31382_31447[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (5))){
var state_31366__$1 = state_31366;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31383_31448 = state_31366__$1;
(statearr_31383_31448[(1)] = (8));

} else {
var statearr_31384_31449 = state_31366__$1;
(statearr_31384_31449[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (14))){
var inst_31344 = (state_31366[(8)]);
var inst_31346 = (state_31366[(11)]);
var inst_31344__$1 = (state_31366[(2)]);
var inst_31345 = (inst_31344__$1 == null);
var inst_31346__$1 = cljs.core.not(inst_31345);
var state_31366__$1 = (function (){var statearr_31385 = state_31366;
(statearr_31385[(8)] = inst_31344__$1);

(statearr_31385[(11)] = inst_31346__$1);

return statearr_31385;
})();
if(inst_31346__$1){
var statearr_31386_31450 = state_31366__$1;
(statearr_31386_31450[(1)] = (15));

} else {
var statearr_31387_31451 = state_31366__$1;
(statearr_31387_31451[(1)] = (16));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (16))){
var inst_31346 = (state_31366[(11)]);
var state_31366__$1 = state_31366;
var statearr_31388_31452 = state_31366__$1;
(statearr_31388_31452[(2)] = inst_31346);

(statearr_31388_31452[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (10))){
var inst_31338 = (state_31366[(2)]);
var state_31366__$1 = state_31366;
var statearr_31389_31453 = state_31366__$1;
(statearr_31389_31453[(2)] = inst_31338);

(statearr_31389_31453[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (18))){
var inst_31349 = (state_31366[(2)]);
var state_31366__$1 = state_31366;
var statearr_31390_31454 = state_31366__$1;
(statearr_31390_31454[(2)] = inst_31349);

(statearr_31390_31454[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31367 === (8))){
var inst_31335 = cljs.core.async.close_BANG_(to);
var state_31366__$1 = state_31366;
var statearr_31391_31455 = state_31366__$1;
(statearr_31391_31455[(2)] = inst_31335);

(statearr_31391_31455[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto__,jobs,results,process,async))
;
return ((function (switch__7880__auto__,c__7942__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0 = (function (){
var statearr_31395 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31395[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__);

(statearr_31395[(1)] = (1));

return statearr_31395;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1 = (function (state_31366){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_31366);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e31396){if((e31396 instanceof Object)){
var ex__7884__auto__ = e31396;
var statearr_31397_31456 = state_31366;
(statearr_31397_31456[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31366);

return cljs.core.constant$keyword$recur;
} else {
throw e31396;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__31457 = state_31366;
state_31366 = G__31457;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__ = function(state_31366){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1.call(this,state_31366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7881__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto__,jobs,results,process,async))
})();
var state__7944__auto__ = (function (){var statearr_31398 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_31398[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto__);

return statearr_31398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto__,jobs,results,process,async))
);

return c__7942__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var G__31459 = arguments.length;
switch (G__31459) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.constant$keyword$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var G__31462 = arguments.length;
switch (G__31462) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.constant$keyword$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var G__31465 = arguments.length;
switch (G__31465) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__7942__auto___31518 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___31518,tc,fc){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___31518,tc,fc){
return (function (state_31491){
var state_val_31492 = (state_31491[(1)]);
if((state_val_31492 === (7))){
var inst_31487 = (state_31491[(2)]);
var state_31491__$1 = state_31491;
var statearr_31493_31519 = state_31491__$1;
(statearr_31493_31519[(2)] = inst_31487);

(statearr_31493_31519[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31492 === (1))){
var state_31491__$1 = state_31491;
var statearr_31494_31520 = state_31491__$1;
(statearr_31494_31520[(2)] = null);

(statearr_31494_31520[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31492 === (4))){
var inst_31468 = (state_31491[(7)]);
var inst_31468__$1 = (state_31491[(2)]);
var inst_31469 = (inst_31468__$1 == null);
var state_31491__$1 = (function (){var statearr_31495 = state_31491;
(statearr_31495[(7)] = inst_31468__$1);

return statearr_31495;
})();
if(cljs.core.truth_(inst_31469)){
var statearr_31496_31521 = state_31491__$1;
(statearr_31496_31521[(1)] = (5));

} else {
var statearr_31497_31522 = state_31491__$1;
(statearr_31497_31522[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31492 === (13))){
var state_31491__$1 = state_31491;
var statearr_31498_31523 = state_31491__$1;
(statearr_31498_31523[(2)] = null);

(statearr_31498_31523[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31492 === (6))){
var inst_31468 = (state_31491[(7)]);
var inst_31474 = (function (){var G__31499 = inst_31468;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__31499) : p.call(null,G__31499));
})();
var state_31491__$1 = state_31491;
if(cljs.core.truth_(inst_31474)){
var statearr_31500_31524 = state_31491__$1;
(statearr_31500_31524[(1)] = (9));

} else {
var statearr_31501_31525 = state_31491__$1;
(statearr_31501_31525[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31492 === (3))){
var inst_31489 = (state_31491[(2)]);
var state_31491__$1 = state_31491;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31491__$1,inst_31489);
} else {
if((state_val_31492 === (12))){
var state_31491__$1 = state_31491;
var statearr_31502_31526 = state_31491__$1;
(statearr_31502_31526[(2)] = null);

(statearr_31502_31526[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31492 === (2))){
var state_31491__$1 = state_31491;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31491__$1,(4),ch);
} else {
if((state_val_31492 === (11))){
var inst_31468 = (state_31491[(7)]);
var inst_31478 = (state_31491[(2)]);
var state_31491__$1 = state_31491;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31491__$1,(8),inst_31478,inst_31468);
} else {
if((state_val_31492 === (9))){
var state_31491__$1 = state_31491;
var statearr_31503_31527 = state_31491__$1;
(statearr_31503_31527[(2)] = tc);

(statearr_31503_31527[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31492 === (5))){
var inst_31471 = cljs.core.async.close_BANG_(tc);
var inst_31472 = cljs.core.async.close_BANG_(fc);
var state_31491__$1 = (function (){var statearr_31504 = state_31491;
(statearr_31504[(8)] = inst_31471);

return statearr_31504;
})();
var statearr_31505_31528 = state_31491__$1;
(statearr_31505_31528[(2)] = inst_31472);

(statearr_31505_31528[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31492 === (14))){
var inst_31485 = (state_31491[(2)]);
var state_31491__$1 = state_31491;
var statearr_31506_31529 = state_31491__$1;
(statearr_31506_31529[(2)] = inst_31485);

(statearr_31506_31529[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31492 === (10))){
var state_31491__$1 = state_31491;
var statearr_31507_31530 = state_31491__$1;
(statearr_31507_31530[(2)] = fc);

(statearr_31507_31530[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31492 === (8))){
var inst_31480 = (state_31491[(2)]);
var state_31491__$1 = state_31491;
if(cljs.core.truth_(inst_31480)){
var statearr_31508_31531 = state_31491__$1;
(statearr_31508_31531[(1)] = (12));

} else {
var statearr_31509_31532 = state_31491__$1;
(statearr_31509_31532[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___31518,tc,fc))
;
return ((function (switch__7880__auto__,c__7942__auto___31518,tc,fc){
return (function() {
var cljs$core$async$state_machine__7881__auto__ = null;
var cljs$core$async$state_machine__7881__auto____0 = (function (){
var statearr_31513 = [null,null,null,null,null,null,null,null,null];
(statearr_31513[(0)] = cljs$core$async$state_machine__7881__auto__);

(statearr_31513[(1)] = (1));

return statearr_31513;
});
var cljs$core$async$state_machine__7881__auto____1 = (function (state_31491){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_31491);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e31514){if((e31514 instanceof Object)){
var ex__7884__auto__ = e31514;
var statearr_31515_31533 = state_31491;
(statearr_31515_31533[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31491);

return cljs.core.constant$keyword$recur;
} else {
throw e31514;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__31534 = state_31491;
state_31491 = G__31534;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$state_machine__7881__auto__ = function(state_31491){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7881__auto____1.call(this,state_31491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7881__auto____0;
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7881__auto____1;
return cljs$core$async$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___31518,tc,fc))
})();
var state__7944__auto__ = (function (){var statearr_31516 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_31516[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___31518);

return statearr_31516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___31518,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__7942__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto__){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto__){
return (function (state_31583){
var state_val_31584 = (state_31583[(1)]);
if((state_val_31584 === (7))){
var inst_31579 = (state_31583[(2)]);
var state_31583__$1 = state_31583;
var statearr_31585_31603 = state_31583__$1;
(statearr_31585_31603[(2)] = inst_31579);

(statearr_31585_31603[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31584 === (6))){
var inst_31572 = (state_31583[(7)]);
var inst_31569 = (state_31583[(8)]);
var inst_31576 = (function (){var G__31586 = inst_31569;
var G__31587 = inst_31572;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__31586,G__31587) : f.call(null,G__31586,G__31587));
})();
var inst_31569__$1 = inst_31576;
var state_31583__$1 = (function (){var statearr_31588 = state_31583;
(statearr_31588[(8)] = inst_31569__$1);

return statearr_31588;
})();
var statearr_31589_31604 = state_31583__$1;
(statearr_31589_31604[(2)] = null);

(statearr_31589_31604[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31584 === (5))){
var inst_31569 = (state_31583[(8)]);
var state_31583__$1 = state_31583;
var statearr_31590_31605 = state_31583__$1;
(statearr_31590_31605[(2)] = inst_31569);

(statearr_31590_31605[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31584 === (4))){
var inst_31572 = (state_31583[(7)]);
var inst_31572__$1 = (state_31583[(2)]);
var inst_31573 = (inst_31572__$1 == null);
var state_31583__$1 = (function (){var statearr_31591 = state_31583;
(statearr_31591[(7)] = inst_31572__$1);

return statearr_31591;
})();
if(cljs.core.truth_(inst_31573)){
var statearr_31592_31606 = state_31583__$1;
(statearr_31592_31606[(1)] = (5));

} else {
var statearr_31593_31607 = state_31583__$1;
(statearr_31593_31607[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31584 === (3))){
var inst_31581 = (state_31583[(2)]);
var state_31583__$1 = state_31583;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31583__$1,inst_31581);
} else {
if((state_val_31584 === (2))){
var state_31583__$1 = state_31583;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31583__$1,(4),ch);
} else {
if((state_val_31584 === (1))){
var inst_31569 = init;
var state_31583__$1 = (function (){var statearr_31594 = state_31583;
(statearr_31594[(8)] = inst_31569);

return statearr_31594;
})();
var statearr_31595_31608 = state_31583__$1;
(statearr_31595_31608[(2)] = null);

(statearr_31595_31608[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__7942__auto__))
;
return ((function (switch__7880__auto__,c__7942__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__7881__auto__ = null;
var cljs$core$async$reduce_$_state_machine__7881__auto____0 = (function (){
var statearr_31599 = [null,null,null,null,null,null,null,null,null];
(statearr_31599[(0)] = cljs$core$async$reduce_$_state_machine__7881__auto__);

(statearr_31599[(1)] = (1));

return statearr_31599;
});
var cljs$core$async$reduce_$_state_machine__7881__auto____1 = (function (state_31583){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_31583);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e31600){if((e31600 instanceof Object)){
var ex__7884__auto__ = e31600;
var statearr_31601_31609 = state_31583;
(statearr_31601_31609[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31583);

return cljs.core.constant$keyword$recur;
} else {
throw e31600;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__31610 = state_31583;
state_31583 = G__31610;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__7881__auto__ = function(state_31583){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__7881__auto____1.call(this,state_31583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__7881__auto____0;
cljs$core$async$reduce_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__7881__auto____1;
return cljs$core$async$reduce_$_state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto__))
})();
var state__7944__auto__ = (function (){var statearr_31602 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_31602[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto__);

return statearr_31602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto__))
);

return c__7942__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var G__31612 = arguments.length;
switch (G__31612) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__7942__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto__){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto__){
return (function (state_31637){
var state_val_31638 = (state_31637[(1)]);
if((state_val_31638 === (7))){
var inst_31619 = (state_31637[(2)]);
var state_31637__$1 = state_31637;
var statearr_31639_31663 = state_31637__$1;
(statearr_31639_31663[(2)] = inst_31619);

(statearr_31639_31663[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (1))){
var inst_31613 = cljs.core.seq(coll);
var inst_31614 = inst_31613;
var state_31637__$1 = (function (){var statearr_31640 = state_31637;
(statearr_31640[(7)] = inst_31614);

return statearr_31640;
})();
var statearr_31641_31664 = state_31637__$1;
(statearr_31641_31664[(2)] = null);

(statearr_31641_31664[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (4))){
var inst_31614 = (state_31637[(7)]);
var inst_31617 = cljs.core.first(inst_31614);
var state_31637__$1 = state_31637;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31637__$1,(7),ch,inst_31617);
} else {
if((state_val_31638 === (13))){
var inst_31631 = (state_31637[(2)]);
var state_31637__$1 = state_31637;
var statearr_31642_31665 = state_31637__$1;
(statearr_31642_31665[(2)] = inst_31631);

(statearr_31642_31665[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (6))){
var inst_31622 = (state_31637[(2)]);
var state_31637__$1 = state_31637;
if(cljs.core.truth_(inst_31622)){
var statearr_31643_31666 = state_31637__$1;
(statearr_31643_31666[(1)] = (8));

} else {
var statearr_31644_31667 = state_31637__$1;
(statearr_31644_31667[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (3))){
var inst_31635 = (state_31637[(2)]);
var state_31637__$1 = state_31637;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31637__$1,inst_31635);
} else {
if((state_val_31638 === (12))){
var state_31637__$1 = state_31637;
var statearr_31645_31668 = state_31637__$1;
(statearr_31645_31668[(2)] = null);

(statearr_31645_31668[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (2))){
var inst_31614 = (state_31637[(7)]);
var state_31637__$1 = state_31637;
if(cljs.core.truth_(inst_31614)){
var statearr_31646_31669 = state_31637__$1;
(statearr_31646_31669[(1)] = (4));

} else {
var statearr_31647_31670 = state_31637__$1;
(statearr_31647_31670[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (11))){
var inst_31628 = cljs.core.async.close_BANG_(ch);
var state_31637__$1 = state_31637;
var statearr_31648_31671 = state_31637__$1;
(statearr_31648_31671[(2)] = inst_31628);

(statearr_31648_31671[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (9))){
var state_31637__$1 = state_31637;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31649_31672 = state_31637__$1;
(statearr_31649_31672[(1)] = (11));

} else {
var statearr_31650_31673 = state_31637__$1;
(statearr_31650_31673[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (5))){
var inst_31614 = (state_31637[(7)]);
var state_31637__$1 = state_31637;
var statearr_31651_31674 = state_31637__$1;
(statearr_31651_31674[(2)] = inst_31614);

(statearr_31651_31674[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (10))){
var inst_31633 = (state_31637[(2)]);
var state_31637__$1 = state_31637;
var statearr_31652_31675 = state_31637__$1;
(statearr_31652_31675[(2)] = inst_31633);

(statearr_31652_31675[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31638 === (8))){
var inst_31614 = (state_31637[(7)]);
var inst_31624 = cljs.core.next(inst_31614);
var inst_31614__$1 = inst_31624;
var state_31637__$1 = (function (){var statearr_31653 = state_31637;
(statearr_31653[(7)] = inst_31614__$1);

return statearr_31653;
})();
var statearr_31654_31676 = state_31637__$1;
(statearr_31654_31676[(2)] = null);

(statearr_31654_31676[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto__))
;
return ((function (switch__7880__auto__,c__7942__auto__){
return (function() {
var cljs$core$async$state_machine__7881__auto__ = null;
var cljs$core$async$state_machine__7881__auto____0 = (function (){
var statearr_31658 = [null,null,null,null,null,null,null,null];
(statearr_31658[(0)] = cljs$core$async$state_machine__7881__auto__);

(statearr_31658[(1)] = (1));

return statearr_31658;
});
var cljs$core$async$state_machine__7881__auto____1 = (function (state_31637){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_31637);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e31659){if((e31659 instanceof Object)){
var ex__7884__auto__ = e31659;
var statearr_31660_31677 = state_31637;
(statearr_31660_31677[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31637);

return cljs.core.constant$keyword$recur;
} else {
throw e31659;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__31678 = state_31637;
state_31637 = G__31678;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$state_machine__7881__auto__ = function(state_31637){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7881__auto____1.call(this,state_31637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7881__auto____0;
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7881__auto____1;
return cljs$core$async$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto__))
})();
var state__7944__auto__ = (function (){var statearr_31661 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_31661[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto__);

return statearr_31661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto__))
);

return c__7942__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj31680 = {};
return obj31680;
})();

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((function (){var and__4264__auto__ = _;
if(and__4264__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4912__auto__ = (((_ == null))?null:_);
return (function (){var or__4276__auto__ = (cljs.core.async.muxch_STAR_[(function (){var G__31684 = x__4912__auto__;
return goog.typeOf(G__31684);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj31686 = {};
return obj31686;
})();

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.tap_STAR_[(function (){var G__31690 = x__4912__auto__;
return goog.typeOf(G__31690);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_STAR_[(function (){var G__31694 = x__4912__auto__;
return goog.typeOf(G__31694);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_all_STAR_[(function (){var G__31698 = x__4912__auto__;
return goog.typeOf(G__31698);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__31928 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31928) : cljs.core.atom.call(null,G__31928));
})();
var m = (function (){
if(typeof cljs.core.async.t31929 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31929 = (function (cs,ch,mult,meta31930){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta31930 = meta31930;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31929.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t31929.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t31929.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t31929.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__31932_32157 = self__.cs;
var G__31933_32158 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__31932_32157,G__31933_32158) : cljs.core.reset_BANG_.call(null,G__31932_32157,G__31933_32158));

return null;
});})(cs))
;

cljs.core.async.t31929.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t31929.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t31929.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_31931){
var self__ = this;
var _31931__$1 = this;
return self__.meta31930;
});})(cs))
;

cljs.core.async.t31929.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_31931,meta31930__$1){
var self__ = this;
var _31931__$1 = this;
return (new cljs.core.async.t31929(self__.cs,self__.ch,self__.mult,meta31930__$1));
});})(cs))
;

cljs.core.async.t31929.cljs$lang$type = true;

cljs.core.async.t31929.cljs$lang$ctorStr = "cljs.core.async/t31929";

cljs.core.async.t31929.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t31929");
});})(cs))
;

cljs.core.async.__GT_t31929 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t31929(cs__$1,ch__$1,mult__$1,meta31930){
return (new cljs.core.async.t31929(cs__$1,ch__$1,mult__$1,meta31930));
});})(cs))
;

}

return (new cljs.core.async.t31929(cs,ch,cljs$core$async$mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (function (){var G__31934 = null;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31934) : cljs.core.atom.call(null,G__31934));
})();
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__7942__auto___32159 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___32159,cs,m,dchan,dctr,done){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___32159,cs,m,dchan,dctr,done){
return (function (state_32065){
var state_val_32066 = (state_32065[(1)]);
if((state_val_32066 === (7))){
var inst_32061 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32067_32160 = state_32065__$1;
(statearr_32067_32160[(2)] = inst_32061);

(statearr_32067_32160[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (20))){
var inst_31966 = (state_32065[(7)]);
var inst_31976 = cljs.core.first(inst_31966);
var inst_31977 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31976,(0),null);
var inst_31978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31976,(1),null);
var state_32065__$1 = (function (){var statearr_32068 = state_32065;
(statearr_32068[(8)] = inst_31977);

return statearr_32068;
})();
if(cljs.core.truth_(inst_31978)){
var statearr_32069_32161 = state_32065__$1;
(statearr_32069_32161[(1)] = (22));

} else {
var statearr_32070_32162 = state_32065__$1;
(statearr_32070_32162[(1)] = (23));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (27))){
var inst_31937 = (state_32065[(9)]);
var inst_32013 = (state_32065[(10)]);
var inst_32008 = (state_32065[(11)]);
var inst_32006 = (state_32065[(12)]);
var inst_32013__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32006,inst_32008);
var inst_32014 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32013__$1,inst_31937,done);
var state_32065__$1 = (function (){var statearr_32071 = state_32065;
(statearr_32071[(10)] = inst_32013__$1);

return statearr_32071;
})();
if(cljs.core.truth_(inst_32014)){
var statearr_32072_32163 = state_32065__$1;
(statearr_32072_32163[(1)] = (30));

} else {
var statearr_32073_32164 = state_32065__$1;
(statearr_32073_32164[(1)] = (31));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (1))){
var state_32065__$1 = state_32065;
var statearr_32074_32165 = state_32065__$1;
(statearr_32074_32165[(2)] = null);

(statearr_32074_32165[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (24))){
var inst_31966 = (state_32065[(7)]);
var inst_31983 = (state_32065[(2)]);
var inst_31984 = cljs.core.next(inst_31966);
var inst_31946 = inst_31984;
var inst_31947 = null;
var inst_31948 = (0);
var inst_31949 = (0);
var state_32065__$1 = (function (){var statearr_32075 = state_32065;
(statearr_32075[(13)] = inst_31949);

(statearr_32075[(14)] = inst_31948);

(statearr_32075[(15)] = inst_31983);

(statearr_32075[(16)] = inst_31947);

(statearr_32075[(17)] = inst_31946);

return statearr_32075;
})();
var statearr_32076_32166 = state_32065__$1;
(statearr_32076_32166[(2)] = null);

(statearr_32076_32166[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (39))){
var state_32065__$1 = state_32065;
var statearr_32080_32167 = state_32065__$1;
(statearr_32080_32167[(2)] = null);

(statearr_32080_32167[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (4))){
var inst_31937 = (state_32065[(9)]);
var inst_31937__$1 = (state_32065[(2)]);
var inst_31938 = (inst_31937__$1 == null);
var state_32065__$1 = (function (){var statearr_32081 = state_32065;
(statearr_32081[(9)] = inst_31937__$1);

return statearr_32081;
})();
if(cljs.core.truth_(inst_31938)){
var statearr_32082_32168 = state_32065__$1;
(statearr_32082_32168[(1)] = (5));

} else {
var statearr_32083_32169 = state_32065__$1;
(statearr_32083_32169[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (15))){
var inst_31949 = (state_32065[(13)]);
var inst_31948 = (state_32065[(14)]);
var inst_31947 = (state_32065[(16)]);
var inst_31946 = (state_32065[(17)]);
var inst_31962 = (state_32065[(2)]);
var inst_31963 = (inst_31949 + (1));
var tmp32077 = inst_31948;
var tmp32078 = inst_31947;
var tmp32079 = inst_31946;
var inst_31946__$1 = tmp32079;
var inst_31947__$1 = tmp32078;
var inst_31948__$1 = tmp32077;
var inst_31949__$1 = inst_31963;
var state_32065__$1 = (function (){var statearr_32084 = state_32065;
(statearr_32084[(18)] = inst_31962);

(statearr_32084[(13)] = inst_31949__$1);

(statearr_32084[(14)] = inst_31948__$1);

(statearr_32084[(16)] = inst_31947__$1);

(statearr_32084[(17)] = inst_31946__$1);

return statearr_32084;
})();
var statearr_32085_32170 = state_32065__$1;
(statearr_32085_32170[(2)] = null);

(statearr_32085_32170[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (21))){
var inst_31987 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32089_32171 = state_32065__$1;
(statearr_32089_32171[(2)] = inst_31987);

(statearr_32089_32171[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (31))){
var inst_32013 = (state_32065[(10)]);
var inst_32017 = done(null);
var inst_32018 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32013);
var state_32065__$1 = (function (){var statearr_32090 = state_32065;
(statearr_32090[(19)] = inst_32017);

return statearr_32090;
})();
var statearr_32091_32172 = state_32065__$1;
(statearr_32091_32172[(2)] = inst_32018);

(statearr_32091_32172[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (32))){
var inst_32007 = (state_32065[(20)]);
var inst_32008 = (state_32065[(11)]);
var inst_32006 = (state_32065[(12)]);
var inst_32005 = (state_32065[(21)]);
var inst_32020 = (state_32065[(2)]);
var inst_32021 = (inst_32008 + (1));
var tmp32086 = inst_32007;
var tmp32087 = inst_32006;
var tmp32088 = inst_32005;
var inst_32005__$1 = tmp32088;
var inst_32006__$1 = tmp32087;
var inst_32007__$1 = tmp32086;
var inst_32008__$1 = inst_32021;
var state_32065__$1 = (function (){var statearr_32092 = state_32065;
(statearr_32092[(22)] = inst_32020);

(statearr_32092[(20)] = inst_32007__$1);

(statearr_32092[(11)] = inst_32008__$1);

(statearr_32092[(12)] = inst_32006__$1);

(statearr_32092[(21)] = inst_32005__$1);

return statearr_32092;
})();
var statearr_32093_32173 = state_32065__$1;
(statearr_32093_32173[(2)] = null);

(statearr_32093_32173[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (40))){
var inst_32033 = (state_32065[(23)]);
var inst_32037 = done(null);
var inst_32038 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32033);
var state_32065__$1 = (function (){var statearr_32094 = state_32065;
(statearr_32094[(24)] = inst_32037);

return statearr_32094;
})();
var statearr_32095_32174 = state_32065__$1;
(statearr_32095_32174[(2)] = inst_32038);

(statearr_32095_32174[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (33))){
var inst_32024 = (state_32065[(25)]);
var inst_32026 = cljs.core.chunked_seq_QMARK_(inst_32024);
var state_32065__$1 = state_32065;
if(inst_32026){
var statearr_32096_32175 = state_32065__$1;
(statearr_32096_32175[(1)] = (36));

} else {
var statearr_32097_32176 = state_32065__$1;
(statearr_32097_32176[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (13))){
var inst_31956 = (state_32065[(26)]);
var inst_31959 = cljs.core.async.close_BANG_(inst_31956);
var state_32065__$1 = state_32065;
var statearr_32098_32177 = state_32065__$1;
(statearr_32098_32177[(2)] = inst_31959);

(statearr_32098_32177[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (22))){
var inst_31977 = (state_32065[(8)]);
var inst_31980 = cljs.core.async.close_BANG_(inst_31977);
var state_32065__$1 = state_32065;
var statearr_32099_32178 = state_32065__$1;
(statearr_32099_32178[(2)] = inst_31980);

(statearr_32099_32178[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (36))){
var inst_32024 = (state_32065[(25)]);
var inst_32028 = cljs.core.chunk_first(inst_32024);
var inst_32029 = cljs.core.chunk_rest(inst_32024);
var inst_32030 = cljs.core.count(inst_32028);
var inst_32005 = inst_32029;
var inst_32006 = inst_32028;
var inst_32007 = inst_32030;
var inst_32008 = (0);
var state_32065__$1 = (function (){var statearr_32100 = state_32065;
(statearr_32100[(20)] = inst_32007);

(statearr_32100[(11)] = inst_32008);

(statearr_32100[(12)] = inst_32006);

(statearr_32100[(21)] = inst_32005);

return statearr_32100;
})();
var statearr_32101_32179 = state_32065__$1;
(statearr_32101_32179[(2)] = null);

(statearr_32101_32179[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (41))){
var inst_32024 = (state_32065[(25)]);
var inst_32040 = (state_32065[(2)]);
var inst_32041 = cljs.core.next(inst_32024);
var inst_32005 = inst_32041;
var inst_32006 = null;
var inst_32007 = (0);
var inst_32008 = (0);
var state_32065__$1 = (function (){var statearr_32102 = state_32065;
(statearr_32102[(20)] = inst_32007);

(statearr_32102[(11)] = inst_32008);

(statearr_32102[(12)] = inst_32006);

(statearr_32102[(27)] = inst_32040);

(statearr_32102[(21)] = inst_32005);

return statearr_32102;
})();
var statearr_32103_32180 = state_32065__$1;
(statearr_32103_32180[(2)] = null);

(statearr_32103_32180[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (43))){
var state_32065__$1 = state_32065;
var statearr_32104_32181 = state_32065__$1;
(statearr_32104_32181[(2)] = null);

(statearr_32104_32181[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (29))){
var inst_32049 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32105_32182 = state_32065__$1;
(statearr_32105_32182[(2)] = inst_32049);

(statearr_32105_32182[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (44))){
var inst_32058 = (state_32065[(2)]);
var state_32065__$1 = (function (){var statearr_32106 = state_32065;
(statearr_32106[(28)] = inst_32058);

return statearr_32106;
})();
var statearr_32107_32183 = state_32065__$1;
(statearr_32107_32183[(2)] = null);

(statearr_32107_32183[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (6))){
var inst_31997 = (state_32065[(29)]);
var inst_31996 = (function (){var G__32108 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32108) : cljs.core.deref.call(null,G__32108));
})();
var inst_31997__$1 = cljs.core.keys(inst_31996);
var inst_31998 = cljs.core.count(inst_31997__$1);
var inst_31999 = (function (){var G__32109 = dctr;
var G__32110 = inst_31998;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32109,G__32110) : cljs.core.reset_BANG_.call(null,G__32109,G__32110));
})();
var inst_32004 = cljs.core.seq(inst_31997__$1);
var inst_32005 = inst_32004;
var inst_32006 = null;
var inst_32007 = (0);
var inst_32008 = (0);
var state_32065__$1 = (function (){var statearr_32111 = state_32065;
(statearr_32111[(29)] = inst_31997__$1);

(statearr_32111[(30)] = inst_31999);

(statearr_32111[(20)] = inst_32007);

(statearr_32111[(11)] = inst_32008);

(statearr_32111[(12)] = inst_32006);

(statearr_32111[(21)] = inst_32005);

return statearr_32111;
})();
var statearr_32112_32184 = state_32065__$1;
(statearr_32112_32184[(2)] = null);

(statearr_32112_32184[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (28))){
var inst_32024 = (state_32065[(25)]);
var inst_32005 = (state_32065[(21)]);
var inst_32024__$1 = cljs.core.seq(inst_32005);
var state_32065__$1 = (function (){var statearr_32113 = state_32065;
(statearr_32113[(25)] = inst_32024__$1);

return statearr_32113;
})();
if(inst_32024__$1){
var statearr_32114_32185 = state_32065__$1;
(statearr_32114_32185[(1)] = (33));

} else {
var statearr_32115_32186 = state_32065__$1;
(statearr_32115_32186[(1)] = (34));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (25))){
var inst_32007 = (state_32065[(20)]);
var inst_32008 = (state_32065[(11)]);
var inst_32010 = (inst_32008 < inst_32007);
var inst_32011 = inst_32010;
var state_32065__$1 = state_32065;
if(cljs.core.truth_(inst_32011)){
var statearr_32116_32187 = state_32065__$1;
(statearr_32116_32187[(1)] = (27));

} else {
var statearr_32117_32188 = state_32065__$1;
(statearr_32117_32188[(1)] = (28));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (34))){
var state_32065__$1 = state_32065;
var statearr_32118_32189 = state_32065__$1;
(statearr_32118_32189[(2)] = null);

(statearr_32118_32189[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (17))){
var state_32065__$1 = state_32065;
var statearr_32119_32190 = state_32065__$1;
(statearr_32119_32190[(2)] = null);

(statearr_32119_32190[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (3))){
var inst_32063 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32065__$1,inst_32063);
} else {
if((state_val_32066 === (12))){
var inst_31992 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32120_32191 = state_32065__$1;
(statearr_32120_32191[(2)] = inst_31992);

(statearr_32120_32191[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (2))){
var state_32065__$1 = state_32065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32065__$1,(4),ch);
} else {
if((state_val_32066 === (23))){
var state_32065__$1 = state_32065;
var statearr_32121_32192 = state_32065__$1;
(statearr_32121_32192[(2)] = null);

(statearr_32121_32192[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (35))){
var inst_32047 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32122_32193 = state_32065__$1;
(statearr_32122_32193[(2)] = inst_32047);

(statearr_32122_32193[(1)] = (29));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (19))){
var inst_31966 = (state_32065[(7)]);
var inst_31970 = cljs.core.chunk_first(inst_31966);
var inst_31971 = cljs.core.chunk_rest(inst_31966);
var inst_31972 = cljs.core.count(inst_31970);
var inst_31946 = inst_31971;
var inst_31947 = inst_31970;
var inst_31948 = inst_31972;
var inst_31949 = (0);
var state_32065__$1 = (function (){var statearr_32123 = state_32065;
(statearr_32123[(13)] = inst_31949);

(statearr_32123[(14)] = inst_31948);

(statearr_32123[(16)] = inst_31947);

(statearr_32123[(17)] = inst_31946);

return statearr_32123;
})();
var statearr_32124_32194 = state_32065__$1;
(statearr_32124_32194[(2)] = null);

(statearr_32124_32194[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (11))){
var inst_31966 = (state_32065[(7)]);
var inst_31946 = (state_32065[(17)]);
var inst_31966__$1 = cljs.core.seq(inst_31946);
var state_32065__$1 = (function (){var statearr_32125 = state_32065;
(statearr_32125[(7)] = inst_31966__$1);

return statearr_32125;
})();
if(inst_31966__$1){
var statearr_32126_32195 = state_32065__$1;
(statearr_32126_32195[(1)] = (16));

} else {
var statearr_32127_32196 = state_32065__$1;
(statearr_32127_32196[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (9))){
var inst_31994 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32128_32197 = state_32065__$1;
(statearr_32128_32197[(2)] = inst_31994);

(statearr_32128_32197[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (5))){
var inst_31944 = (function (){var G__32129 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32129) : cljs.core.deref.call(null,G__32129));
})();
var inst_31945 = cljs.core.seq(inst_31944);
var inst_31946 = inst_31945;
var inst_31947 = null;
var inst_31948 = (0);
var inst_31949 = (0);
var state_32065__$1 = (function (){var statearr_32130 = state_32065;
(statearr_32130[(13)] = inst_31949);

(statearr_32130[(14)] = inst_31948);

(statearr_32130[(16)] = inst_31947);

(statearr_32130[(17)] = inst_31946);

return statearr_32130;
})();
var statearr_32131_32198 = state_32065__$1;
(statearr_32131_32198[(2)] = null);

(statearr_32131_32198[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (14))){
var state_32065__$1 = state_32065;
var statearr_32132_32199 = state_32065__$1;
(statearr_32132_32199[(2)] = null);

(statearr_32132_32199[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (45))){
var inst_32055 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32133_32200 = state_32065__$1;
(statearr_32133_32200[(2)] = inst_32055);

(statearr_32133_32200[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (26))){
var inst_31997 = (state_32065[(29)]);
var inst_32051 = (state_32065[(2)]);
var inst_32052 = cljs.core.seq(inst_31997);
var state_32065__$1 = (function (){var statearr_32134 = state_32065;
(statearr_32134[(31)] = inst_32051);

return statearr_32134;
})();
if(inst_32052){
var statearr_32135_32201 = state_32065__$1;
(statearr_32135_32201[(1)] = (42));

} else {
var statearr_32136_32202 = state_32065__$1;
(statearr_32136_32202[(1)] = (43));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (16))){
var inst_31966 = (state_32065[(7)]);
var inst_31968 = cljs.core.chunked_seq_QMARK_(inst_31966);
var state_32065__$1 = state_32065;
if(inst_31968){
var statearr_32137_32203 = state_32065__$1;
(statearr_32137_32203[(1)] = (19));

} else {
var statearr_32138_32204 = state_32065__$1;
(statearr_32138_32204[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (38))){
var inst_32044 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32139_32205 = state_32065__$1;
(statearr_32139_32205[(2)] = inst_32044);

(statearr_32139_32205[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (30))){
var state_32065__$1 = state_32065;
var statearr_32140_32206 = state_32065__$1;
(statearr_32140_32206[(2)] = null);

(statearr_32140_32206[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (10))){
var inst_31949 = (state_32065[(13)]);
var inst_31947 = (state_32065[(16)]);
var inst_31955 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31947,inst_31949);
var inst_31956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31955,(0),null);
var inst_31957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31955,(1),null);
var state_32065__$1 = (function (){var statearr_32141 = state_32065;
(statearr_32141[(26)] = inst_31956);

return statearr_32141;
})();
if(cljs.core.truth_(inst_31957)){
var statearr_32142_32207 = state_32065__$1;
(statearr_32142_32207[(1)] = (13));

} else {
var statearr_32143_32208 = state_32065__$1;
(statearr_32143_32208[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (18))){
var inst_31990 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32144_32209 = state_32065__$1;
(statearr_32144_32209[(2)] = inst_31990);

(statearr_32144_32209[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (42))){
var state_32065__$1 = state_32065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32065__$1,(45),dchan);
} else {
if((state_val_32066 === (37))){
var inst_31937 = (state_32065[(9)]);
var inst_32024 = (state_32065[(25)]);
var inst_32033 = (state_32065[(23)]);
var inst_32033__$1 = cljs.core.first(inst_32024);
var inst_32034 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32033__$1,inst_31937,done);
var state_32065__$1 = (function (){var statearr_32145 = state_32065;
(statearr_32145[(23)] = inst_32033__$1);

return statearr_32145;
})();
if(cljs.core.truth_(inst_32034)){
var statearr_32146_32210 = state_32065__$1;
(statearr_32146_32210[(1)] = (39));

} else {
var statearr_32147_32211 = state_32065__$1;
(statearr_32147_32211[(1)] = (40));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32066 === (8))){
var inst_31949 = (state_32065[(13)]);
var inst_31948 = (state_32065[(14)]);
var inst_31951 = (inst_31949 < inst_31948);
var inst_31952 = inst_31951;
var state_32065__$1 = state_32065;
if(cljs.core.truth_(inst_31952)){
var statearr_32148_32212 = state_32065__$1;
(statearr_32148_32212[(1)] = (10));

} else {
var statearr_32149_32213 = state_32065__$1;
(statearr_32149_32213[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___32159,cs,m,dchan,dctr,done))
;
return ((function (switch__7880__auto__,c__7942__auto___32159,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__7881__auto__ = null;
var cljs$core$async$mult_$_state_machine__7881__auto____0 = (function (){
var statearr_32153 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32153[(0)] = cljs$core$async$mult_$_state_machine__7881__auto__);

(statearr_32153[(1)] = (1));

return statearr_32153;
});
var cljs$core$async$mult_$_state_machine__7881__auto____1 = (function (state_32065){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_32065);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e32154){if((e32154 instanceof Object)){
var ex__7884__auto__ = e32154;
var statearr_32155_32214 = state_32065;
(statearr_32155_32214[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32065);

return cljs.core.constant$keyword$recur;
} else {
throw e32154;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__32215 = state_32065;
state_32065 = G__32215;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__7881__auto__ = function(state_32065){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__7881__auto____1.call(this,state_32065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__7881__auto____0;
cljs$core$async$mult_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__7881__auto____1;
return cljs$core$async$mult_$_state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___32159,cs,m,dchan,dctr,done))
})();
var state__7944__auto__ = (function (){var statearr_32156 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_32156[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___32159);

return statearr_32156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___32159,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var G__32217 = arguments.length;
switch (G__32217) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

cljs.core.async.Mix = (function (){var obj32220 = {};
return obj32220;
})();

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.admix_STAR_[(function (){var G__32224 = x__4912__auto__;
return goog.typeOf(G__32224);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_STAR_[(function (){var G__32228 = x__4912__auto__;
return goog.typeOf(G__32228);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_all_STAR_[(function (){var G__32232 = x__4912__auto__;
return goog.typeOf(G__32232);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.toggle_STAR_[(function (){var G__32236 = x__4912__auto__;
return goog.typeOf(G__32236);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.solo_mode_STAR_[(function (){var G__32240 = x__4912__auto__;
return goog.typeOf(G__32240);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var argseq__5316__auto__ = ((((3) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5316__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32245){
var map__32246 = p__32245;
var map__32246__$1 = ((cljs.core.seq_QMARK_(map__32246))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32246):map__32246);
var opts = map__32246__$1;
var statearr_32247_32251 = state;
(statearr_32247_32251[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4126__auto__ = cljs.core.async.do_alts(((function (map__32246,map__32246__$1,opts){
return (function (val){
var statearr_32248_32252 = state;
(statearr_32248_32252[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__32246,map__32246__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4126__auto__)){
var cb = temp__4126__auto__;
var statearr_32249_32253 = state;
(statearr_32249_32253[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (function (){var G__32250 = cb;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32250) : cljs.core.deref.call(null,G__32250));
})());


return cljs.core.constant$keyword$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32241){
var G__32242 = cljs.core.first(seq32241);
var seq32241__$1 = cljs.core.next(seq32241);
var G__32243 = cljs.core.first(seq32241__$1);
var seq32241__$2 = cljs.core.next(seq32241__$1);
var G__32244 = cljs.core.first(seq32241__$2);
var seq32241__$3 = cljs.core.next(seq32241__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32242,G__32243,G__32244,seq32241__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__32387 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32387) : cljs.core.atom.call(null,G__32387));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$pause,null,cljs.core.constant$keyword$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.constant$keyword$solo);
var solo_mode = (function (){var G__32388 = cljs.core.constant$keyword$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32388) : cljs.core.atom.call(null,G__32388));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((function (){var G__32389 = v;
return (attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(G__32389) : attr.call(null,G__32389));
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (function (){var G__32390 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32390) : cljs.core.deref.call(null,G__32390));
})();
var mode = (function (){var G__32391 = solo_mode;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32391) : cljs.core.deref.call(null,G__32391));
})();
var solos = pick(cljs.core.constant$keyword$solo,chs);
var pauses = pick(cljs.core.constant$keyword$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$solos,solos,cljs.core.constant$keyword$mutes,pick(cljs.core.constant$keyword$mute,chs),cljs.core.constant$keyword$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.constant$keyword$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t32392 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32392 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32393){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32393 = meta32393;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32392.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t32392.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32392.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32392.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32395_32520 = self__.cs;
var G__32396_32521 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32395_32520,G__32396_32521) : cljs.core.reset_BANG_.call(null,G__32395_32520,G__32396_32521));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32392.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32392.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((function (){var G__32397 = mode;
return (self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(G__32397) : self__.solo_modes.call(null,G__32397));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))], 0)))].join('')));
}

var G__32398_32522 = self__.solo_mode;
var G__32399_32523 = mode;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32398_32522,G__32399_32523) : cljs.core.reset_BANG_.call(null,G__32398_32522,G__32399_32523));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32392.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t32392.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32392.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32394){
var self__ = this;
var _32394__$1 = this;
return self__.meta32393;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32392.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32394,meta32393__$1){
var self__ = this;
var _32394__$1 = this;
return (new cljs.core.async.t32392(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32393__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32392.cljs$lang$type = true;

cljs.core.async.t32392.cljs$lang$ctorStr = "cljs.core.async/t32392";

cljs.core.async.t32392.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t32392");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t32392 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t32392(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32393){
return (new cljs.core.async.t32392(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32393));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t32392(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7942__auto___32524 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___32524,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___32524,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32471){
var state_val_32472 = (state_32471[(1)]);
if((state_val_32472 === (7))){
var inst_32413 = (state_32471[(7)]);
var inst_32418 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32413);
var state_32471__$1 = state_32471;
var statearr_32473_32525 = state_32471__$1;
(statearr_32473_32525[(2)] = inst_32418);

(statearr_32473_32525[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (20))){
var inst_32428 = (state_32471[(8)]);
var state_32471__$1 = state_32471;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32471__$1,(23),out,inst_32428);
} else {
if((state_val_32472 === (1))){
var inst_32403 = (state_32471[(9)]);
var inst_32403__$1 = calc_state();
var inst_32404 = cljs.core.seq_QMARK_(inst_32403__$1);
var state_32471__$1 = (function (){var statearr_32474 = state_32471;
(statearr_32474[(9)] = inst_32403__$1);

return statearr_32474;
})();
if(inst_32404){
var statearr_32475_32526 = state_32471__$1;
(statearr_32475_32526[(1)] = (2));

} else {
var statearr_32476_32527 = state_32471__$1;
(statearr_32476_32527[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (24))){
var inst_32421 = (state_32471[(10)]);
var inst_32413 = inst_32421;
var state_32471__$1 = (function (){var statearr_32477 = state_32471;
(statearr_32477[(7)] = inst_32413);

return statearr_32477;
})();
var statearr_32478_32528 = state_32471__$1;
(statearr_32478_32528[(2)] = null);

(statearr_32478_32528[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (4))){
var inst_32403 = (state_32471[(9)]);
var inst_32409 = (state_32471[(2)]);
var inst_32410 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32409,cljs.core.constant$keyword$reads);
var inst_32411 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32409,cljs.core.constant$keyword$mutes);
var inst_32412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32409,cljs.core.constant$keyword$solos);
var inst_32413 = inst_32403;
var state_32471__$1 = (function (){var statearr_32479 = state_32471;
(statearr_32479[(11)] = inst_32411);

(statearr_32479[(12)] = inst_32412);

(statearr_32479[(13)] = inst_32410);

(statearr_32479[(7)] = inst_32413);

return statearr_32479;
})();
var statearr_32480_32529 = state_32471__$1;
(statearr_32480_32529[(2)] = null);

(statearr_32480_32529[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (15))){
var state_32471__$1 = state_32471;
var statearr_32481_32530 = state_32471__$1;
(statearr_32481_32530[(2)] = null);

(statearr_32481_32530[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (21))){
var inst_32421 = (state_32471[(10)]);
var inst_32413 = inst_32421;
var state_32471__$1 = (function (){var statearr_32482 = state_32471;
(statearr_32482[(7)] = inst_32413);

return statearr_32482;
})();
var statearr_32483_32531 = state_32471__$1;
(statearr_32483_32531[(2)] = null);

(statearr_32483_32531[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (13))){
var inst_32467 = (state_32471[(2)]);
var state_32471__$1 = state_32471;
var statearr_32484_32532 = state_32471__$1;
(statearr_32484_32532[(2)] = inst_32467);

(statearr_32484_32532[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (22))){
var inst_32465 = (state_32471[(2)]);
var state_32471__$1 = state_32471;
var statearr_32485_32533 = state_32471__$1;
(statearr_32485_32533[(2)] = inst_32465);

(statearr_32485_32533[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (6))){
var inst_32469 = (state_32471[(2)]);
var state_32471__$1 = state_32471;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32471__$1,inst_32469);
} else {
if((state_val_32472 === (25))){
var state_32471__$1 = state_32471;
var statearr_32486_32534 = state_32471__$1;
(statearr_32486_32534[(2)] = null);

(statearr_32486_32534[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (17))){
var inst_32444 = (state_32471[(14)]);
var state_32471__$1 = state_32471;
var statearr_32487_32535 = state_32471__$1;
(statearr_32487_32535[(2)] = inst_32444);

(statearr_32487_32535[(1)] = (19));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (3))){
var inst_32403 = (state_32471[(9)]);
var state_32471__$1 = state_32471;
var statearr_32488_32536 = state_32471__$1;
(statearr_32488_32536[(2)] = inst_32403);

(statearr_32488_32536[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (12))){
var inst_32424 = (state_32471[(15)]);
var inst_32444 = (state_32471[(14)]);
var inst_32429 = (state_32471[(16)]);
var inst_32444__$1 = (function (){var G__32489 = inst_32429;
return (inst_32424.cljs$core$IFn$_invoke$arity$1 ? inst_32424.cljs$core$IFn$_invoke$arity$1(G__32489) : inst_32424.call(null,G__32489));
})();
var state_32471__$1 = (function (){var statearr_32490 = state_32471;
(statearr_32490[(14)] = inst_32444__$1);

return statearr_32490;
})();
if(cljs.core.truth_(inst_32444__$1)){
var statearr_32491_32537 = state_32471__$1;
(statearr_32491_32537[(1)] = (17));

} else {
var statearr_32492_32538 = state_32471__$1;
(statearr_32492_32538[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (2))){
var inst_32403 = (state_32471[(9)]);
var inst_32406 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32403);
var state_32471__$1 = state_32471;
var statearr_32493_32539 = state_32471__$1;
(statearr_32493_32539[(2)] = inst_32406);

(statearr_32493_32539[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (23))){
var inst_32456 = (state_32471[(2)]);
var state_32471__$1 = state_32471;
if(cljs.core.truth_(inst_32456)){
var statearr_32494_32540 = state_32471__$1;
(statearr_32494_32540[(1)] = (24));

} else {
var statearr_32495_32541 = state_32471__$1;
(statearr_32495_32541[(1)] = (25));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (19))){
var inst_32453 = (state_32471[(2)]);
var state_32471__$1 = state_32471;
if(cljs.core.truth_(inst_32453)){
var statearr_32496_32542 = state_32471__$1;
(statearr_32496_32542[(1)] = (20));

} else {
var statearr_32497_32543 = state_32471__$1;
(statearr_32497_32543[(1)] = (21));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (11))){
var inst_32428 = (state_32471[(8)]);
var inst_32434 = (inst_32428 == null);
var state_32471__$1 = state_32471;
if(cljs.core.truth_(inst_32434)){
var statearr_32498_32544 = state_32471__$1;
(statearr_32498_32544[(1)] = (14));

} else {
var statearr_32499_32545 = state_32471__$1;
(statearr_32499_32545[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (9))){
var inst_32421 = (state_32471[(10)]);
var inst_32421__$1 = (state_32471[(2)]);
var inst_32422 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32421__$1,cljs.core.constant$keyword$reads);
var inst_32423 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32421__$1,cljs.core.constant$keyword$mutes);
var inst_32424 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32421__$1,cljs.core.constant$keyword$solos);
var state_32471__$1 = (function (){var statearr_32500 = state_32471;
(statearr_32500[(10)] = inst_32421__$1);

(statearr_32500[(15)] = inst_32424);

(statearr_32500[(17)] = inst_32423);

return statearr_32500;
})();
return cljs.core.async.ioc_alts_BANG_(state_32471__$1,(10),inst_32422);
} else {
if((state_val_32472 === (5))){
var inst_32413 = (state_32471[(7)]);
var inst_32416 = cljs.core.seq_QMARK_(inst_32413);
var state_32471__$1 = state_32471;
if(inst_32416){
var statearr_32501_32546 = state_32471__$1;
(statearr_32501_32546[(1)] = (7));

} else {
var statearr_32502_32547 = state_32471__$1;
(statearr_32502_32547[(1)] = (8));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (14))){
var inst_32429 = (state_32471[(16)]);
var inst_32436 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32429);
var state_32471__$1 = state_32471;
var statearr_32503_32548 = state_32471__$1;
(statearr_32503_32548[(2)] = inst_32436);

(statearr_32503_32548[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (26))){
var inst_32461 = (state_32471[(2)]);
var state_32471__$1 = state_32471;
var statearr_32504_32549 = state_32471__$1;
(statearr_32504_32549[(2)] = inst_32461);

(statearr_32504_32549[(1)] = (22));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (16))){
var inst_32439 = (state_32471[(2)]);
var inst_32440 = calc_state();
var inst_32413 = inst_32440;
var state_32471__$1 = (function (){var statearr_32505 = state_32471;
(statearr_32505[(18)] = inst_32439);

(statearr_32505[(7)] = inst_32413);

return statearr_32505;
})();
var statearr_32506_32550 = state_32471__$1;
(statearr_32506_32550[(2)] = null);

(statearr_32506_32550[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (10))){
var inst_32428 = (state_32471[(8)]);
var inst_32429 = (state_32471[(16)]);
var inst_32427 = (state_32471[(2)]);
var inst_32428__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32427,(0),null);
var inst_32429__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32427,(1),null);
var inst_32430 = (inst_32428__$1 == null);
var inst_32431 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32429__$1,change);
var inst_32432 = (inst_32430) || (inst_32431);
var state_32471__$1 = (function (){var statearr_32507 = state_32471;
(statearr_32507[(8)] = inst_32428__$1);

(statearr_32507[(16)] = inst_32429__$1);

return statearr_32507;
})();
if(cljs.core.truth_(inst_32432)){
var statearr_32508_32551 = state_32471__$1;
(statearr_32508_32551[(1)] = (11));

} else {
var statearr_32509_32552 = state_32471__$1;
(statearr_32509_32552[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (18))){
var inst_32424 = (state_32471[(15)]);
var inst_32423 = (state_32471[(17)]);
var inst_32429 = (state_32471[(16)]);
var inst_32448 = cljs.core.empty_QMARK_(inst_32424);
var inst_32449 = (function (){var G__32510 = inst_32429;
return (inst_32423.cljs$core$IFn$_invoke$arity$1 ? inst_32423.cljs$core$IFn$_invoke$arity$1(G__32510) : inst_32423.call(null,G__32510));
})();
var inst_32450 = cljs.core.not(inst_32449);
var inst_32451 = (inst_32448) && (inst_32450);
var state_32471__$1 = state_32471;
var statearr_32511_32553 = state_32471__$1;
(statearr_32511_32553[(2)] = inst_32451);

(statearr_32511_32553[(1)] = (19));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32472 === (8))){
var inst_32413 = (state_32471[(7)]);
var state_32471__$1 = state_32471;
var statearr_32512_32554 = state_32471__$1;
(statearr_32512_32554[(2)] = inst_32413);

(statearr_32512_32554[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___32524,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__7880__auto__,c__7942__auto___32524,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__7881__auto__ = null;
var cljs$core$async$mix_$_state_machine__7881__auto____0 = (function (){
var statearr_32516 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32516[(0)] = cljs$core$async$mix_$_state_machine__7881__auto__);

(statearr_32516[(1)] = (1));

return statearr_32516;
});
var cljs$core$async$mix_$_state_machine__7881__auto____1 = (function (state_32471){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_32471);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e32517){if((e32517 instanceof Object)){
var ex__7884__auto__ = e32517;
var statearr_32518_32555 = state_32471;
(statearr_32518_32555[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32471);

return cljs.core.constant$keyword$recur;
} else {
throw e32517;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__32556 = state_32471;
state_32471 = G__32556;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__7881__auto__ = function(state_32471){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__7881__auto____1.call(this,state_32471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__7881__auto____0;
cljs$core$async$mix_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__7881__auto____1;
return cljs$core$async$mix_$_state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___32524,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__7944__auto__ = (function (){var statearr_32519 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_32519[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___32524);

return statearr_32519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___32524,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

cljs.core.async.Pub = (function (){var obj32558 = {};
return obj32558;
})();

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.sub_STAR_[(function (){var G__32562 = x__4912__auto__;
return goog.typeOf(G__32562);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_STAR_[(function (){var G__32566 = x__4912__auto__;
return goog.typeOf(G__32566);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var G__32568 = arguments.length;
switch (G__32568) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[(function (){var G__32570 = x__4912__auto__;
return goog.typeOf(G__32570);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[(function (){var G__32572 = x__4912__auto__;
return goog.typeOf(G__32572);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var G__32576 = arguments.length;
switch (G__32576) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__32577 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32577) : cljs.core.atom.call(null,G__32577));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__4276__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((function (){var G__32579 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32579) : cljs.core.deref.call(null,G__32579));
})(),topic);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4276__auto__,mults){
return (function (p1__32574_SHARP_){
if(cljs.core.truth_((function (){var G__32580 = topic;
return (p1__32574_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32574_SHARP_.cljs$core$IFn$_invoke$arity$1(G__32580) : p1__32574_SHARP_.call(null,G__32580));
})())){
return p1__32574_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32574_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((function (){var G__32581 = topic;
return (buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(G__32581) : buf_fn.call(null,G__32581));
})())));
}
});})(or__4276__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t32582 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32582 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,meta32583){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.meta32583 = meta32583;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32582.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t32582.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (function (){var G__32585 = topic;
return (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(G__32585) : self__.ensure_mult.call(null,G__32585));
})();
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t32582.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((function (){var G__32586 = self__.mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32586) : cljs.core.deref.call(null,G__32586));
})(),topic);
if(cljs.core.truth_(temp__4126__auto__)){
var m = temp__4126__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t32582.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32587 = self__.mults;
var G__32588 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32587,G__32588) : cljs.core.reset_BANG_.call(null,G__32587,G__32588));
});})(mults,ensure_mult))
;

cljs.core.async.t32582.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t32582.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t32582.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t32582.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32584){
var self__ = this;
var _32584__$1 = this;
return self__.meta32583;
});})(mults,ensure_mult))
;

cljs.core.async.t32582.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32584,meta32583__$1){
var self__ = this;
var _32584__$1 = this;
return (new cljs.core.async.t32582(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,meta32583__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t32582.cljs$lang$type = true;

cljs.core.async.t32582.cljs$lang$ctorStr = "cljs.core.async/t32582";

cljs.core.async.t32582.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t32582");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t32582 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t32582(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta32583){
return (new cljs.core.async.t32582(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta32583));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t32582(ensure_mult,mults,buf_fn,topic_fn,ch,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7942__auto___32712 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___32712,mults,ensure_mult,p){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___32712,mults,ensure_mult,p){
return (function (state_32660){
var state_val_32661 = (state_32660[(1)]);
if((state_val_32661 === (7))){
var inst_32656 = (state_32660[(2)]);
var state_32660__$1 = state_32660;
var statearr_32662_32713 = state_32660__$1;
(statearr_32662_32713[(2)] = inst_32656);

(statearr_32662_32713[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (20))){
var state_32660__$1 = state_32660;
var statearr_32663_32714 = state_32660__$1;
(statearr_32663_32714[(2)] = null);

(statearr_32663_32714[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (1))){
var state_32660__$1 = state_32660;
var statearr_32664_32715 = state_32660__$1;
(statearr_32664_32715[(2)] = null);

(statearr_32664_32715[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (24))){
var inst_32639 = (state_32660[(7)]);
var inst_32648 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32639);
var state_32660__$1 = state_32660;
var statearr_32665_32716 = state_32660__$1;
(statearr_32665_32716[(2)] = inst_32648);

(statearr_32665_32716[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (4))){
var inst_32591 = (state_32660[(8)]);
var inst_32591__$1 = (state_32660[(2)]);
var inst_32592 = (inst_32591__$1 == null);
var state_32660__$1 = (function (){var statearr_32666 = state_32660;
(statearr_32666[(8)] = inst_32591__$1);

return statearr_32666;
})();
if(cljs.core.truth_(inst_32592)){
var statearr_32667_32717 = state_32660__$1;
(statearr_32667_32717[(1)] = (5));

} else {
var statearr_32668_32718 = state_32660__$1;
(statearr_32668_32718[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (15))){
var inst_32633 = (state_32660[(2)]);
var state_32660__$1 = state_32660;
var statearr_32669_32719 = state_32660__$1;
(statearr_32669_32719[(2)] = inst_32633);

(statearr_32669_32719[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (21))){
var inst_32653 = (state_32660[(2)]);
var state_32660__$1 = (function (){var statearr_32670 = state_32660;
(statearr_32670[(9)] = inst_32653);

return statearr_32670;
})();
var statearr_32671_32720 = state_32660__$1;
(statearr_32671_32720[(2)] = null);

(statearr_32671_32720[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (13))){
var inst_32615 = (state_32660[(10)]);
var inst_32617 = cljs.core.chunked_seq_QMARK_(inst_32615);
var state_32660__$1 = state_32660;
if(inst_32617){
var statearr_32672_32721 = state_32660__$1;
(statearr_32672_32721[(1)] = (16));

} else {
var statearr_32673_32722 = state_32660__$1;
(statearr_32673_32722[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (22))){
var inst_32645 = (state_32660[(2)]);
var state_32660__$1 = state_32660;
if(cljs.core.truth_(inst_32645)){
var statearr_32674_32723 = state_32660__$1;
(statearr_32674_32723[(1)] = (23));

} else {
var statearr_32675_32724 = state_32660__$1;
(statearr_32675_32724[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (6))){
var inst_32641 = (state_32660[(11)]);
var inst_32639 = (state_32660[(7)]);
var inst_32591 = (state_32660[(8)]);
var inst_32639__$1 = (function (){var G__32676 = inst_32591;
return (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(G__32676) : topic_fn.call(null,G__32676));
})();
var inst_32640 = (function (){var G__32677 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32677) : cljs.core.deref.call(null,G__32677));
})();
var inst_32641__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32640,inst_32639__$1);
var state_32660__$1 = (function (){var statearr_32678 = state_32660;
(statearr_32678[(11)] = inst_32641__$1);

(statearr_32678[(7)] = inst_32639__$1);

return statearr_32678;
})();
if(cljs.core.truth_(inst_32641__$1)){
var statearr_32679_32725 = state_32660__$1;
(statearr_32679_32725[(1)] = (19));

} else {
var statearr_32680_32726 = state_32660__$1;
(statearr_32680_32726[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (25))){
var inst_32650 = (state_32660[(2)]);
var state_32660__$1 = state_32660;
var statearr_32681_32727 = state_32660__$1;
(statearr_32681_32727[(2)] = inst_32650);

(statearr_32681_32727[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (17))){
var inst_32615 = (state_32660[(10)]);
var inst_32624 = cljs.core.first(inst_32615);
var inst_32625 = cljs.core.async.muxch_STAR_(inst_32624);
var inst_32626 = cljs.core.async.close_BANG_(inst_32625);
var inst_32627 = cljs.core.next(inst_32615);
var inst_32601 = inst_32627;
var inst_32602 = null;
var inst_32603 = (0);
var inst_32604 = (0);
var state_32660__$1 = (function (){var statearr_32682 = state_32660;
(statearr_32682[(12)] = inst_32604);

(statearr_32682[(13)] = inst_32626);

(statearr_32682[(14)] = inst_32603);

(statearr_32682[(15)] = inst_32602);

(statearr_32682[(16)] = inst_32601);

return statearr_32682;
})();
var statearr_32683_32728 = state_32660__$1;
(statearr_32683_32728[(2)] = null);

(statearr_32683_32728[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (3))){
var inst_32658 = (state_32660[(2)]);
var state_32660__$1 = state_32660;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32660__$1,inst_32658);
} else {
if((state_val_32661 === (12))){
var inst_32635 = (state_32660[(2)]);
var state_32660__$1 = state_32660;
var statearr_32684_32729 = state_32660__$1;
(statearr_32684_32729[(2)] = inst_32635);

(statearr_32684_32729[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (2))){
var state_32660__$1 = state_32660;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32660__$1,(4),ch);
} else {
if((state_val_32661 === (23))){
var state_32660__$1 = state_32660;
var statearr_32685_32730 = state_32660__$1;
(statearr_32685_32730[(2)] = null);

(statearr_32685_32730[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (19))){
var inst_32641 = (state_32660[(11)]);
var inst_32591 = (state_32660[(8)]);
var inst_32643 = cljs.core.async.muxch_STAR_(inst_32641);
var state_32660__$1 = state_32660;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32660__$1,(22),inst_32643,inst_32591);
} else {
if((state_val_32661 === (11))){
var inst_32615 = (state_32660[(10)]);
var inst_32601 = (state_32660[(16)]);
var inst_32615__$1 = cljs.core.seq(inst_32601);
var state_32660__$1 = (function (){var statearr_32686 = state_32660;
(statearr_32686[(10)] = inst_32615__$1);

return statearr_32686;
})();
if(inst_32615__$1){
var statearr_32687_32731 = state_32660__$1;
(statearr_32687_32731[(1)] = (13));

} else {
var statearr_32688_32732 = state_32660__$1;
(statearr_32688_32732[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (9))){
var inst_32637 = (state_32660[(2)]);
var state_32660__$1 = state_32660;
var statearr_32689_32733 = state_32660__$1;
(statearr_32689_32733[(2)] = inst_32637);

(statearr_32689_32733[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (5))){
var inst_32598 = (function (){var G__32690 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32690) : cljs.core.deref.call(null,G__32690));
})();
var inst_32599 = cljs.core.vals(inst_32598);
var inst_32600 = cljs.core.seq(inst_32599);
var inst_32601 = inst_32600;
var inst_32602 = null;
var inst_32603 = (0);
var inst_32604 = (0);
var state_32660__$1 = (function (){var statearr_32691 = state_32660;
(statearr_32691[(12)] = inst_32604);

(statearr_32691[(14)] = inst_32603);

(statearr_32691[(15)] = inst_32602);

(statearr_32691[(16)] = inst_32601);

return statearr_32691;
})();
var statearr_32692_32734 = state_32660__$1;
(statearr_32692_32734[(2)] = null);

(statearr_32692_32734[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (14))){
var state_32660__$1 = state_32660;
var statearr_32696_32735 = state_32660__$1;
(statearr_32696_32735[(2)] = null);

(statearr_32696_32735[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (16))){
var inst_32615 = (state_32660[(10)]);
var inst_32619 = cljs.core.chunk_first(inst_32615);
var inst_32620 = cljs.core.chunk_rest(inst_32615);
var inst_32621 = cljs.core.count(inst_32619);
var inst_32601 = inst_32620;
var inst_32602 = inst_32619;
var inst_32603 = inst_32621;
var inst_32604 = (0);
var state_32660__$1 = (function (){var statearr_32697 = state_32660;
(statearr_32697[(12)] = inst_32604);

(statearr_32697[(14)] = inst_32603);

(statearr_32697[(15)] = inst_32602);

(statearr_32697[(16)] = inst_32601);

return statearr_32697;
})();
var statearr_32698_32736 = state_32660__$1;
(statearr_32698_32736[(2)] = null);

(statearr_32698_32736[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (10))){
var inst_32604 = (state_32660[(12)]);
var inst_32603 = (state_32660[(14)]);
var inst_32602 = (state_32660[(15)]);
var inst_32601 = (state_32660[(16)]);
var inst_32609 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32602,inst_32604);
var inst_32610 = cljs.core.async.muxch_STAR_(inst_32609);
var inst_32611 = cljs.core.async.close_BANG_(inst_32610);
var inst_32612 = (inst_32604 + (1));
var tmp32693 = inst_32603;
var tmp32694 = inst_32602;
var tmp32695 = inst_32601;
var inst_32601__$1 = tmp32695;
var inst_32602__$1 = tmp32694;
var inst_32603__$1 = tmp32693;
var inst_32604__$1 = inst_32612;
var state_32660__$1 = (function (){var statearr_32699 = state_32660;
(statearr_32699[(12)] = inst_32604__$1);

(statearr_32699[(14)] = inst_32603__$1);

(statearr_32699[(15)] = inst_32602__$1);

(statearr_32699[(16)] = inst_32601__$1);

(statearr_32699[(17)] = inst_32611);

return statearr_32699;
})();
var statearr_32700_32737 = state_32660__$1;
(statearr_32700_32737[(2)] = null);

(statearr_32700_32737[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (18))){
var inst_32630 = (state_32660[(2)]);
var state_32660__$1 = state_32660;
var statearr_32701_32738 = state_32660__$1;
(statearr_32701_32738[(2)] = inst_32630);

(statearr_32701_32738[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32661 === (8))){
var inst_32604 = (state_32660[(12)]);
var inst_32603 = (state_32660[(14)]);
var inst_32606 = (inst_32604 < inst_32603);
var inst_32607 = inst_32606;
var state_32660__$1 = state_32660;
if(cljs.core.truth_(inst_32607)){
var statearr_32702_32739 = state_32660__$1;
(statearr_32702_32739[(1)] = (10));

} else {
var statearr_32703_32740 = state_32660__$1;
(statearr_32703_32740[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___32712,mults,ensure_mult,p))
;
return ((function (switch__7880__auto__,c__7942__auto___32712,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__7881__auto__ = null;
var cljs$core$async$state_machine__7881__auto____0 = (function (){
var statearr_32707 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32707[(0)] = cljs$core$async$state_machine__7881__auto__);

(statearr_32707[(1)] = (1));

return statearr_32707;
});
var cljs$core$async$state_machine__7881__auto____1 = (function (state_32660){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_32660);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e32708){if((e32708 instanceof Object)){
var ex__7884__auto__ = e32708;
var statearr_32709_32741 = state_32660;
(statearr_32709_32741[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32660);

return cljs.core.constant$keyword$recur;
} else {
throw e32708;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__32742 = state_32660;
state_32660 = G__32742;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$state_machine__7881__auto__ = function(state_32660){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7881__auto____1.call(this,state_32660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7881__auto____0;
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7881__auto____1;
return cljs$core$async$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___32712,mults,ensure_mult,p))
})();
var state__7944__auto__ = (function (){var statearr_32710 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_32710[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___32712);

return statearr_32710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___32712,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var G__32744 = arguments.length;
switch (G__32744) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var G__32747 = arguments.length;
switch (G__32747) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var G__32750 = arguments.length;
switch (G__32750) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (function (){var G__32751 = null;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32751) : cljs.core.atom.call(null,G__32751));
})();
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__7942__auto___32825 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___32825,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___32825,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32790){
var state_val_32791 = (state_32790[(1)]);
if((state_val_32791 === (7))){
var state_32790__$1 = state_32790;
var statearr_32792_32826 = state_32790__$1;
(statearr_32792_32826[(2)] = null);

(statearr_32792_32826[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (1))){
var state_32790__$1 = state_32790;
var statearr_32793_32827 = state_32790__$1;
(statearr_32793_32827[(2)] = null);

(statearr_32793_32827[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (4))){
var inst_32754 = (state_32790[(7)]);
var inst_32756 = (inst_32754 < cnt);
var state_32790__$1 = state_32790;
if(cljs.core.truth_(inst_32756)){
var statearr_32794_32828 = state_32790__$1;
(statearr_32794_32828[(1)] = (6));

} else {
var statearr_32795_32829 = state_32790__$1;
(statearr_32795_32829[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (15))){
var inst_32786 = (state_32790[(2)]);
var state_32790__$1 = state_32790;
var statearr_32796_32830 = state_32790__$1;
(statearr_32796_32830[(2)] = inst_32786);

(statearr_32796_32830[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (13))){
var inst_32779 = cljs.core.async.close_BANG_(out);
var state_32790__$1 = state_32790;
var statearr_32797_32831 = state_32790__$1;
(statearr_32797_32831[(2)] = inst_32779);

(statearr_32797_32831[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (6))){
var state_32790__$1 = state_32790;
var statearr_32798_32832 = state_32790__$1;
(statearr_32798_32832[(2)] = null);

(statearr_32798_32832[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (3))){
var inst_32788 = (state_32790[(2)]);
var state_32790__$1 = state_32790;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32790__$1,inst_32788);
} else {
if((state_val_32791 === (12))){
var inst_32776 = (state_32790[(8)]);
var inst_32776__$1 = (state_32790[(2)]);
var inst_32777 = cljs.core.some(cljs.core.nil_QMARK_,inst_32776__$1);
var state_32790__$1 = (function (){var statearr_32799 = state_32790;
(statearr_32799[(8)] = inst_32776__$1);

return statearr_32799;
})();
if(cljs.core.truth_(inst_32777)){
var statearr_32800_32833 = state_32790__$1;
(statearr_32800_32833[(1)] = (13));

} else {
var statearr_32801_32834 = state_32790__$1;
(statearr_32801_32834[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (2))){
var inst_32753 = (function (){var G__32802 = dctr;
var G__32803 = cnt;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32802,G__32803) : cljs.core.reset_BANG_.call(null,G__32802,G__32803));
})();
var inst_32754 = (0);
var state_32790__$1 = (function (){var statearr_32804 = state_32790;
(statearr_32804[(7)] = inst_32754);

(statearr_32804[(9)] = inst_32753);

return statearr_32804;
})();
var statearr_32805_32835 = state_32790__$1;
(statearr_32805_32835[(2)] = null);

(statearr_32805_32835[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (11))){
var inst_32754 = (state_32790[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_32790,(10),Object,null,(9));
var inst_32763 = (function (){var G__32806 = inst_32754;
return (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(G__32806) : chs__$1.call(null,G__32806));
})();
var inst_32764 = (function (){var G__32807 = inst_32754;
return (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(G__32807) : done.call(null,G__32807));
})();
var inst_32765 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32763,inst_32764);
var state_32790__$1 = state_32790;
var statearr_32808_32836 = state_32790__$1;
(statearr_32808_32836[(2)] = inst_32765);


cljs.core.async.impl.ioc_helpers.process_exception(state_32790__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (9))){
var inst_32754 = (state_32790[(7)]);
var inst_32767 = (state_32790[(2)]);
var inst_32768 = (inst_32754 + (1));
var inst_32754__$1 = inst_32768;
var state_32790__$1 = (function (){var statearr_32809 = state_32790;
(statearr_32809[(10)] = inst_32767);

(statearr_32809[(7)] = inst_32754__$1);

return statearr_32809;
})();
var statearr_32810_32837 = state_32790__$1;
(statearr_32810_32837[(2)] = null);

(statearr_32810_32837[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (5))){
var inst_32774 = (state_32790[(2)]);
var state_32790__$1 = (function (){var statearr_32811 = state_32790;
(statearr_32811[(11)] = inst_32774);

return statearr_32811;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32790__$1,(12),dchan);
} else {
if((state_val_32791 === (14))){
var inst_32776 = (state_32790[(8)]);
var inst_32781 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_32776);
var state_32790__$1 = state_32790;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32790__$1,(16),out,inst_32781);
} else {
if((state_val_32791 === (16))){
var inst_32783 = (state_32790[(2)]);
var state_32790__$1 = (function (){var statearr_32812 = state_32790;
(statearr_32812[(12)] = inst_32783);

return statearr_32812;
})();
var statearr_32813_32838 = state_32790__$1;
(statearr_32813_32838[(2)] = null);

(statearr_32813_32838[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (10))){
var inst_32758 = (state_32790[(2)]);
var inst_32759 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_32790__$1 = (function (){var statearr_32814 = state_32790;
(statearr_32814[(13)] = inst_32758);

return statearr_32814;
})();
var statearr_32815_32839 = state_32790__$1;
(statearr_32815_32839[(2)] = inst_32759);


cljs.core.async.impl.ioc_helpers.process_exception(state_32790__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32791 === (8))){
var inst_32772 = (state_32790[(2)]);
var state_32790__$1 = state_32790;
var statearr_32816_32840 = state_32790__$1;
(statearr_32816_32840[(2)] = inst_32772);

(statearr_32816_32840[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___32825,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__7880__auto__,c__7942__auto___32825,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__7881__auto__ = null;
var cljs$core$async$state_machine__7881__auto____0 = (function (){
var statearr_32820 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32820[(0)] = cljs$core$async$state_machine__7881__auto__);

(statearr_32820[(1)] = (1));

return statearr_32820;
});
var cljs$core$async$state_machine__7881__auto____1 = (function (state_32790){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_32790);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e32821){if((e32821 instanceof Object)){
var ex__7884__auto__ = e32821;
var statearr_32822_32841 = state_32790;
(statearr_32822_32841[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32790);

return cljs.core.constant$keyword$recur;
} else {
throw e32821;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__32842 = state_32790;
state_32790 = G__32842;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$state_machine__7881__auto__ = function(state_32790){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7881__auto____1.call(this,state_32790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7881__auto____0;
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7881__auto____1;
return cljs$core$async$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___32825,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__7944__auto__ = (function (){var statearr_32823 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_32823[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___32825);

return statearr_32823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___32825,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var G__32845 = arguments.length;
switch (G__32845) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7942__auto___32900 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___32900,out){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___32900,out){
return (function (state_32875){
var state_val_32876 = (state_32875[(1)]);
if((state_val_32876 === (7))){
var inst_32854 = (state_32875[(7)]);
var inst_32855 = (state_32875[(8)]);
var inst_32854__$1 = (state_32875[(2)]);
var inst_32855__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32854__$1,(0),null);
var inst_32856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32854__$1,(1),null);
var inst_32857 = (inst_32855__$1 == null);
var state_32875__$1 = (function (){var statearr_32877 = state_32875;
(statearr_32877[(7)] = inst_32854__$1);

(statearr_32877[(9)] = inst_32856);

(statearr_32877[(8)] = inst_32855__$1);

return statearr_32877;
})();
if(cljs.core.truth_(inst_32857)){
var statearr_32878_32901 = state_32875__$1;
(statearr_32878_32901[(1)] = (8));

} else {
var statearr_32879_32902 = state_32875__$1;
(statearr_32879_32902[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32876 === (1))){
var inst_32846 = cljs.core.vec(chs);
var inst_32847 = inst_32846;
var state_32875__$1 = (function (){var statearr_32880 = state_32875;
(statearr_32880[(10)] = inst_32847);

return statearr_32880;
})();
var statearr_32881_32903 = state_32875__$1;
(statearr_32881_32903[(2)] = null);

(statearr_32881_32903[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32876 === (4))){
var inst_32847 = (state_32875[(10)]);
var state_32875__$1 = state_32875;
return cljs.core.async.ioc_alts_BANG_(state_32875__$1,(7),inst_32847);
} else {
if((state_val_32876 === (6))){
var inst_32871 = (state_32875[(2)]);
var state_32875__$1 = state_32875;
var statearr_32882_32904 = state_32875__$1;
(statearr_32882_32904[(2)] = inst_32871);

(statearr_32882_32904[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32876 === (3))){
var inst_32873 = (state_32875[(2)]);
var state_32875__$1 = state_32875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32875__$1,inst_32873);
} else {
if((state_val_32876 === (2))){
var inst_32847 = (state_32875[(10)]);
var inst_32849 = cljs.core.count(inst_32847);
var inst_32850 = (inst_32849 > (0));
var state_32875__$1 = state_32875;
if(cljs.core.truth_(inst_32850)){
var statearr_32884_32905 = state_32875__$1;
(statearr_32884_32905[(1)] = (4));

} else {
var statearr_32885_32906 = state_32875__$1;
(statearr_32885_32906[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32876 === (11))){
var inst_32847 = (state_32875[(10)]);
var inst_32864 = (state_32875[(2)]);
var tmp32883 = inst_32847;
var inst_32847__$1 = tmp32883;
var state_32875__$1 = (function (){var statearr_32886 = state_32875;
(statearr_32886[(11)] = inst_32864);

(statearr_32886[(10)] = inst_32847__$1);

return statearr_32886;
})();
var statearr_32887_32907 = state_32875__$1;
(statearr_32887_32907[(2)] = null);

(statearr_32887_32907[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32876 === (9))){
var inst_32855 = (state_32875[(8)]);
var state_32875__$1 = state_32875;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32875__$1,(11),out,inst_32855);
} else {
if((state_val_32876 === (5))){
var inst_32869 = cljs.core.async.close_BANG_(out);
var state_32875__$1 = state_32875;
var statearr_32888_32908 = state_32875__$1;
(statearr_32888_32908[(2)] = inst_32869);

(statearr_32888_32908[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32876 === (10))){
var inst_32867 = (state_32875[(2)]);
var state_32875__$1 = state_32875;
var statearr_32889_32909 = state_32875__$1;
(statearr_32889_32909[(2)] = inst_32867);

(statearr_32889_32909[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32876 === (8))){
var inst_32854 = (state_32875[(7)]);
var inst_32856 = (state_32875[(9)]);
var inst_32847 = (state_32875[(10)]);
var inst_32855 = (state_32875[(8)]);
var inst_32859 = (function (){var c = inst_32856;
var v = inst_32855;
var vec__32852 = inst_32854;
var cs = inst_32847;
return ((function (c,v,vec__32852,cs,inst_32854,inst_32856,inst_32847,inst_32855,state_val_32876,c__7942__auto___32900,out){
return (function (p1__32843_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__32843_SHARP_);
});
;})(c,v,vec__32852,cs,inst_32854,inst_32856,inst_32847,inst_32855,state_val_32876,c__7942__auto___32900,out))
})();
var inst_32860 = cljs.core.filterv(inst_32859,inst_32847);
var inst_32847__$1 = inst_32860;
var state_32875__$1 = (function (){var statearr_32890 = state_32875;
(statearr_32890[(10)] = inst_32847__$1);

return statearr_32890;
})();
var statearr_32891_32910 = state_32875__$1;
(statearr_32891_32910[(2)] = null);

(statearr_32891_32910[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___32900,out))
;
return ((function (switch__7880__auto__,c__7942__auto___32900,out){
return (function() {
var cljs$core$async$state_machine__7881__auto__ = null;
var cljs$core$async$state_machine__7881__auto____0 = (function (){
var statearr_32895 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32895[(0)] = cljs$core$async$state_machine__7881__auto__);

(statearr_32895[(1)] = (1));

return statearr_32895;
});
var cljs$core$async$state_machine__7881__auto____1 = (function (state_32875){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_32875);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e32896){if((e32896 instanceof Object)){
var ex__7884__auto__ = e32896;
var statearr_32897_32911 = state_32875;
(statearr_32897_32911[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32875);

return cljs.core.constant$keyword$recur;
} else {
throw e32896;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__32912 = state_32875;
state_32875 = G__32912;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$state_machine__7881__auto__ = function(state_32875){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7881__auto____1.call(this,state_32875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7881__auto____0;
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7881__auto____1;
return cljs$core$async$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___32900,out))
})();
var state__7944__auto__ = (function (){var statearr_32898 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_32898[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___32900);

return statearr_32898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___32900,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var G__32914 = arguments.length;
switch (G__32914) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7942__auto___32962 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___32962,out){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___32962,out){
return (function (state_32938){
var state_val_32939 = (state_32938[(1)]);
if((state_val_32939 === (7))){
var inst_32920 = (state_32938[(7)]);
var inst_32920__$1 = (state_32938[(2)]);
var inst_32921 = (inst_32920__$1 == null);
var inst_32922 = cljs.core.not(inst_32921);
var state_32938__$1 = (function (){var statearr_32940 = state_32938;
(statearr_32940[(7)] = inst_32920__$1);

return statearr_32940;
})();
if(inst_32922){
var statearr_32941_32963 = state_32938__$1;
(statearr_32941_32963[(1)] = (8));

} else {
var statearr_32942_32964 = state_32938__$1;
(statearr_32942_32964[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32939 === (1))){
var inst_32915 = (0);
var state_32938__$1 = (function (){var statearr_32943 = state_32938;
(statearr_32943[(8)] = inst_32915);

return statearr_32943;
})();
var statearr_32944_32965 = state_32938__$1;
(statearr_32944_32965[(2)] = null);

(statearr_32944_32965[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32939 === (4))){
var state_32938__$1 = state_32938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32938__$1,(7),ch);
} else {
if((state_val_32939 === (6))){
var inst_32933 = (state_32938[(2)]);
var state_32938__$1 = state_32938;
var statearr_32945_32966 = state_32938__$1;
(statearr_32945_32966[(2)] = inst_32933);

(statearr_32945_32966[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32939 === (3))){
var inst_32935 = (state_32938[(2)]);
var inst_32936 = cljs.core.async.close_BANG_(out);
var state_32938__$1 = (function (){var statearr_32946 = state_32938;
(statearr_32946[(9)] = inst_32935);

return statearr_32946;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32938__$1,inst_32936);
} else {
if((state_val_32939 === (2))){
var inst_32915 = (state_32938[(8)]);
var inst_32917 = (inst_32915 < n);
var state_32938__$1 = state_32938;
if(cljs.core.truth_(inst_32917)){
var statearr_32947_32967 = state_32938__$1;
(statearr_32947_32967[(1)] = (4));

} else {
var statearr_32948_32968 = state_32938__$1;
(statearr_32948_32968[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32939 === (11))){
var inst_32915 = (state_32938[(8)]);
var inst_32925 = (state_32938[(2)]);
var inst_32926 = (inst_32915 + (1));
var inst_32915__$1 = inst_32926;
var state_32938__$1 = (function (){var statearr_32949 = state_32938;
(statearr_32949[(8)] = inst_32915__$1);

(statearr_32949[(10)] = inst_32925);

return statearr_32949;
})();
var statearr_32950_32969 = state_32938__$1;
(statearr_32950_32969[(2)] = null);

(statearr_32950_32969[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32939 === (9))){
var state_32938__$1 = state_32938;
var statearr_32951_32970 = state_32938__$1;
(statearr_32951_32970[(2)] = null);

(statearr_32951_32970[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32939 === (5))){
var state_32938__$1 = state_32938;
var statearr_32952_32971 = state_32938__$1;
(statearr_32952_32971[(2)] = null);

(statearr_32952_32971[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32939 === (10))){
var inst_32930 = (state_32938[(2)]);
var state_32938__$1 = state_32938;
var statearr_32953_32972 = state_32938__$1;
(statearr_32953_32972[(2)] = inst_32930);

(statearr_32953_32972[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32939 === (8))){
var inst_32920 = (state_32938[(7)]);
var state_32938__$1 = state_32938;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32938__$1,(11),out,inst_32920);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___32962,out))
;
return ((function (switch__7880__auto__,c__7942__auto___32962,out){
return (function() {
var cljs$core$async$state_machine__7881__auto__ = null;
var cljs$core$async$state_machine__7881__auto____0 = (function (){
var statearr_32957 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32957[(0)] = cljs$core$async$state_machine__7881__auto__);

(statearr_32957[(1)] = (1));

return statearr_32957;
});
var cljs$core$async$state_machine__7881__auto____1 = (function (state_32938){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_32938);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e32958){if((e32958 instanceof Object)){
var ex__7884__auto__ = e32958;
var statearr_32959_32973 = state_32938;
(statearr_32959_32973[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32938);

return cljs.core.constant$keyword$recur;
} else {
throw e32958;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__32974 = state_32938;
state_32938 = G__32974;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$state_machine__7881__auto__ = function(state_32938){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7881__auto____1.call(this,state_32938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7881__auto____0;
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7881__auto____1;
return cljs$core$async$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___32962,out))
})();
var state__7944__auto__ = (function (){var statearr_32960 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_32960[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___32962);

return statearr_32960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___32962,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t32987 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32987 = (function (ch,f,map_LT_,meta32988){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta32988 = meta32988;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32987.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t32987.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t32987.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t32987.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t32990 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32990 = (function (fn1,_,meta32988,map_LT_,f,ch,meta32991){
this.fn1 = fn1;
this._ = _;
this.meta32988 = meta32988;
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta32991 = meta32991;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32990.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t32990.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t32990.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32975_SHARP_){
var G__32993 = (((p1__32975_SHARP_ == null))?null:(function (){var G__32994 = p1__32975_SHARP_;
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__32994) : self__.f.call(null,G__32994));
})());
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__32993) : f1.call(null,G__32993));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t32990.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32992){
var self__ = this;
var _32992__$1 = this;
return self__.meta32991;
});})(___$1))
;

cljs.core.async.t32990.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32992,meta32991__$1){
var self__ = this;
var _32992__$1 = this;
return (new cljs.core.async.t32990(self__.fn1,self__._,self__.meta32988,self__.map_LT_,self__.f,self__.ch,meta32991__$1));
});})(___$1))
;

cljs.core.async.t32990.cljs$lang$type = true;

cljs.core.async.t32990.cljs$lang$ctorStr = "cljs.core.async/t32990";

cljs.core.async.t32990.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t32990");
});})(___$1))
;

cljs.core.async.__GT_t32990 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t32990(fn1__$1,___$2,meta32988__$1,map_LT___$1,f__$1,ch__$1,meta32991){
return (new cljs.core.async.t32990(fn1__$1,___$2,meta32988__$1,map_LT___$1,f__$1,ch__$1,meta32991));
});})(___$1))
;

}

return (new cljs.core.async.t32990(fn1,___$1,self__.meta32988,self__.map_LT_,self__.f,self__.ch,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4264__auto__ = ret;
if(cljs.core.truth_(and__4264__auto__)){
return !(((function (){var G__32995 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32995) : cljs.core.deref.call(null,G__32995));
})() == null));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__32996 = (function (){var G__32997 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32997) : cljs.core.deref.call(null,G__32997));
})();
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__32996) : self__.f.call(null,G__32996));
})());
} else {
return ret;
}
});

cljs.core.async.t32987.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t32987.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t32987.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t32987.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32989){
var self__ = this;
var _32989__$1 = this;
return self__.meta32988;
});

cljs.core.async.t32987.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32989,meta32988__$1){
var self__ = this;
var _32989__$1 = this;
return (new cljs.core.async.t32987(self__.ch,self__.f,self__.map_LT_,meta32988__$1));
});

cljs.core.async.t32987.cljs$lang$type = true;

cljs.core.async.t32987.cljs$lang$ctorStr = "cljs.core.async/t32987";

cljs.core.async.t32987.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t32987");
});

cljs.core.async.__GT_t32987 = (function cljs$core$async$map_LT__$___GT_t32987(ch__$1,f__$1,map_LT___$1,meta32988){
return (new cljs.core.async.t32987(ch__$1,f__$1,map_LT___$1,meta32988));
});

}

return (new cljs.core.async.t32987(ch,f,cljs$core$async$map_LT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t33002 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t33002 = (function (ch,f,map_GT_,meta33003){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta33003 = meta33003;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t33002.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t33002.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(function (){var G__33005 = val;
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33005) : self__.f.call(null,G__33005));
})(),fn1);
});

cljs.core.async.t33002.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t33002.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t33002.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t33002.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t33002.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33004){
var self__ = this;
var _33004__$1 = this;
return self__.meta33003;
});

cljs.core.async.t33002.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33004,meta33003__$1){
var self__ = this;
var _33004__$1 = this;
return (new cljs.core.async.t33002(self__.ch,self__.f,self__.map_GT_,meta33003__$1));
});

cljs.core.async.t33002.cljs$lang$type = true;

cljs.core.async.t33002.cljs$lang$ctorStr = "cljs.core.async/t33002";

cljs.core.async.t33002.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t33002");
});

cljs.core.async.__GT_t33002 = (function cljs$core$async$map_GT__$___GT_t33002(ch__$1,f__$1,map_GT___$1,meta33003){
return (new cljs.core.async.t33002(ch__$1,f__$1,map_GT___$1,meta33003));
});

}

return (new cljs.core.async.t33002(ch,f,cljs$core$async$map_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t33010 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t33010 = (function (ch,p,filter_GT_,meta33011){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta33011 = meta33011;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t33010.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t33010.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((function (){var G__33013 = val;
return (self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(G__33013) : self__.p.call(null,G__33013));
})())){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t33010.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t33010.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t33010.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t33010.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t33010.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t33010.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33012){
var self__ = this;
var _33012__$1 = this;
return self__.meta33011;
});

cljs.core.async.t33010.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33012,meta33011__$1){
var self__ = this;
var _33012__$1 = this;
return (new cljs.core.async.t33010(self__.ch,self__.p,self__.filter_GT_,meta33011__$1));
});

cljs.core.async.t33010.cljs$lang$type = true;

cljs.core.async.t33010.cljs$lang$ctorStr = "cljs.core.async/t33010";

cljs.core.async.t33010.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t33010");
});

cljs.core.async.__GT_t33010 = (function cljs$core$async$filter_GT__$___GT_t33010(ch__$1,p__$1,filter_GT___$1,meta33011){
return (new cljs.core.async.t33010(ch__$1,p__$1,filter_GT___$1,meta33011));
});

}

return (new cljs.core.async.t33010(ch,p,cljs$core$async$filter_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var G__33015 = arguments.length;
switch (G__33015) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7942__auto___33059 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___33059,out){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___33059,out){
return (function (state_33036){
var state_val_33037 = (state_33036[(1)]);
if((state_val_33037 === (7))){
var inst_33032 = (state_33036[(2)]);
var state_33036__$1 = state_33036;
var statearr_33038_33060 = state_33036__$1;
(statearr_33038_33060[(2)] = inst_33032);

(statearr_33038_33060[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33037 === (1))){
var state_33036__$1 = state_33036;
var statearr_33039_33061 = state_33036__$1;
(statearr_33039_33061[(2)] = null);

(statearr_33039_33061[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33037 === (4))){
var inst_33018 = (state_33036[(7)]);
var inst_33018__$1 = (state_33036[(2)]);
var inst_33019 = (inst_33018__$1 == null);
var state_33036__$1 = (function (){var statearr_33040 = state_33036;
(statearr_33040[(7)] = inst_33018__$1);

return statearr_33040;
})();
if(cljs.core.truth_(inst_33019)){
var statearr_33041_33062 = state_33036__$1;
(statearr_33041_33062[(1)] = (5));

} else {
var statearr_33042_33063 = state_33036__$1;
(statearr_33042_33063[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33037 === (6))){
var inst_33018 = (state_33036[(7)]);
var inst_33023 = (function (){var G__33043 = inst_33018;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__33043) : p.call(null,G__33043));
})();
var state_33036__$1 = state_33036;
if(cljs.core.truth_(inst_33023)){
var statearr_33044_33064 = state_33036__$1;
(statearr_33044_33064[(1)] = (8));

} else {
var statearr_33045_33065 = state_33036__$1;
(statearr_33045_33065[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33037 === (3))){
var inst_33034 = (state_33036[(2)]);
var state_33036__$1 = state_33036;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33036__$1,inst_33034);
} else {
if((state_val_33037 === (2))){
var state_33036__$1 = state_33036;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33036__$1,(4),ch);
} else {
if((state_val_33037 === (11))){
var inst_33026 = (state_33036[(2)]);
var state_33036__$1 = state_33036;
var statearr_33046_33066 = state_33036__$1;
(statearr_33046_33066[(2)] = inst_33026);

(statearr_33046_33066[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33037 === (9))){
var state_33036__$1 = state_33036;
var statearr_33047_33067 = state_33036__$1;
(statearr_33047_33067[(2)] = null);

(statearr_33047_33067[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33037 === (5))){
var inst_33021 = cljs.core.async.close_BANG_(out);
var state_33036__$1 = state_33036;
var statearr_33048_33068 = state_33036__$1;
(statearr_33048_33068[(2)] = inst_33021);

(statearr_33048_33068[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33037 === (10))){
var inst_33029 = (state_33036[(2)]);
var state_33036__$1 = (function (){var statearr_33049 = state_33036;
(statearr_33049[(8)] = inst_33029);

return statearr_33049;
})();
var statearr_33050_33069 = state_33036__$1;
(statearr_33050_33069[(2)] = null);

(statearr_33050_33069[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33037 === (8))){
var inst_33018 = (state_33036[(7)]);
var state_33036__$1 = state_33036;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33036__$1,(11),out,inst_33018);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___33059,out))
;
return ((function (switch__7880__auto__,c__7942__auto___33059,out){
return (function() {
var cljs$core$async$state_machine__7881__auto__ = null;
var cljs$core$async$state_machine__7881__auto____0 = (function (){
var statearr_33054 = [null,null,null,null,null,null,null,null,null];
(statearr_33054[(0)] = cljs$core$async$state_machine__7881__auto__);

(statearr_33054[(1)] = (1));

return statearr_33054;
});
var cljs$core$async$state_machine__7881__auto____1 = (function (state_33036){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_33036);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e33055){if((e33055 instanceof Object)){
var ex__7884__auto__ = e33055;
var statearr_33056_33070 = state_33036;
(statearr_33056_33070[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33036);

return cljs.core.constant$keyword$recur;
} else {
throw e33055;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__33071 = state_33036;
state_33036 = G__33071;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$state_machine__7881__auto__ = function(state_33036){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7881__auto____1.call(this,state_33036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7881__auto____0;
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7881__auto____1;
return cljs$core$async$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___33059,out))
})();
var state__7944__auto__ = (function (){var statearr_33057 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_33057[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___33059);

return statearr_33057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___33059,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var G__33073 = arguments.length;
switch (G__33073) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__7942__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto__){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto__){
return (function (state_33241){
var state_val_33242 = (state_33241[(1)]);
if((state_val_33242 === (7))){
var inst_33237 = (state_33241[(2)]);
var state_33241__$1 = state_33241;
var statearr_33243_33285 = state_33241__$1;
(statearr_33243_33285[(2)] = inst_33237);

(statearr_33243_33285[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (20))){
var inst_33207 = (state_33241[(7)]);
var inst_33218 = (state_33241[(2)]);
var inst_33219 = cljs.core.next(inst_33207);
var inst_33193 = inst_33219;
var inst_33194 = null;
var inst_33195 = (0);
var inst_33196 = (0);
var state_33241__$1 = (function (){var statearr_33244 = state_33241;
(statearr_33244[(8)] = inst_33218);

(statearr_33244[(9)] = inst_33196);

(statearr_33244[(10)] = inst_33193);

(statearr_33244[(11)] = inst_33195);

(statearr_33244[(12)] = inst_33194);

return statearr_33244;
})();
var statearr_33245_33286 = state_33241__$1;
(statearr_33245_33286[(2)] = null);

(statearr_33245_33286[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (1))){
var state_33241__$1 = state_33241;
var statearr_33246_33287 = state_33241__$1;
(statearr_33246_33287[(2)] = null);

(statearr_33246_33287[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (4))){
var inst_33182 = (state_33241[(13)]);
var inst_33182__$1 = (state_33241[(2)]);
var inst_33183 = (inst_33182__$1 == null);
var state_33241__$1 = (function (){var statearr_33247 = state_33241;
(statearr_33247[(13)] = inst_33182__$1);

return statearr_33247;
})();
if(cljs.core.truth_(inst_33183)){
var statearr_33248_33288 = state_33241__$1;
(statearr_33248_33288[(1)] = (5));

} else {
var statearr_33249_33289 = state_33241__$1;
(statearr_33249_33289[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (15))){
var state_33241__$1 = state_33241;
var statearr_33253_33290 = state_33241__$1;
(statearr_33253_33290[(2)] = null);

(statearr_33253_33290[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (21))){
var state_33241__$1 = state_33241;
var statearr_33254_33291 = state_33241__$1;
(statearr_33254_33291[(2)] = null);

(statearr_33254_33291[(1)] = (23));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (13))){
var inst_33196 = (state_33241[(9)]);
var inst_33193 = (state_33241[(10)]);
var inst_33195 = (state_33241[(11)]);
var inst_33194 = (state_33241[(12)]);
var inst_33203 = (state_33241[(2)]);
var inst_33204 = (inst_33196 + (1));
var tmp33250 = inst_33193;
var tmp33251 = inst_33195;
var tmp33252 = inst_33194;
var inst_33193__$1 = tmp33250;
var inst_33194__$1 = tmp33252;
var inst_33195__$1 = tmp33251;
var inst_33196__$1 = inst_33204;
var state_33241__$1 = (function (){var statearr_33255 = state_33241;
(statearr_33255[(14)] = inst_33203);

(statearr_33255[(9)] = inst_33196__$1);

(statearr_33255[(10)] = inst_33193__$1);

(statearr_33255[(11)] = inst_33195__$1);

(statearr_33255[(12)] = inst_33194__$1);

return statearr_33255;
})();
var statearr_33256_33292 = state_33241__$1;
(statearr_33256_33292[(2)] = null);

(statearr_33256_33292[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (22))){
var state_33241__$1 = state_33241;
var statearr_33257_33293 = state_33241__$1;
(statearr_33257_33293[(2)] = null);

(statearr_33257_33293[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (6))){
var inst_33182 = (state_33241[(13)]);
var inst_33191 = (function (){var G__33258 = inst_33182;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33258) : f.call(null,G__33258));
})();
var inst_33192 = cljs.core.seq(inst_33191);
var inst_33193 = inst_33192;
var inst_33194 = null;
var inst_33195 = (0);
var inst_33196 = (0);
var state_33241__$1 = (function (){var statearr_33259 = state_33241;
(statearr_33259[(9)] = inst_33196);

(statearr_33259[(10)] = inst_33193);

(statearr_33259[(11)] = inst_33195);

(statearr_33259[(12)] = inst_33194);

return statearr_33259;
})();
var statearr_33260_33294 = state_33241__$1;
(statearr_33260_33294[(2)] = null);

(statearr_33260_33294[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (17))){
var inst_33207 = (state_33241[(7)]);
var inst_33211 = cljs.core.chunk_first(inst_33207);
var inst_33212 = cljs.core.chunk_rest(inst_33207);
var inst_33213 = cljs.core.count(inst_33211);
var inst_33193 = inst_33212;
var inst_33194 = inst_33211;
var inst_33195 = inst_33213;
var inst_33196 = (0);
var state_33241__$1 = (function (){var statearr_33261 = state_33241;
(statearr_33261[(9)] = inst_33196);

(statearr_33261[(10)] = inst_33193);

(statearr_33261[(11)] = inst_33195);

(statearr_33261[(12)] = inst_33194);

return statearr_33261;
})();
var statearr_33262_33295 = state_33241__$1;
(statearr_33262_33295[(2)] = null);

(statearr_33262_33295[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (3))){
var inst_33239 = (state_33241[(2)]);
var state_33241__$1 = state_33241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33241__$1,inst_33239);
} else {
if((state_val_33242 === (12))){
var inst_33227 = (state_33241[(2)]);
var state_33241__$1 = state_33241;
var statearr_33263_33296 = state_33241__$1;
(statearr_33263_33296[(2)] = inst_33227);

(statearr_33263_33296[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (2))){
var state_33241__$1 = state_33241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33241__$1,(4),in$);
} else {
if((state_val_33242 === (23))){
var inst_33235 = (state_33241[(2)]);
var state_33241__$1 = state_33241;
var statearr_33264_33297 = state_33241__$1;
(statearr_33264_33297[(2)] = inst_33235);

(statearr_33264_33297[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (19))){
var inst_33222 = (state_33241[(2)]);
var state_33241__$1 = state_33241;
var statearr_33265_33298 = state_33241__$1;
(statearr_33265_33298[(2)] = inst_33222);

(statearr_33265_33298[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (11))){
var inst_33193 = (state_33241[(10)]);
var inst_33207 = (state_33241[(7)]);
var inst_33207__$1 = cljs.core.seq(inst_33193);
var state_33241__$1 = (function (){var statearr_33266 = state_33241;
(statearr_33266[(7)] = inst_33207__$1);

return statearr_33266;
})();
if(inst_33207__$1){
var statearr_33267_33299 = state_33241__$1;
(statearr_33267_33299[(1)] = (14));

} else {
var statearr_33268_33300 = state_33241__$1;
(statearr_33268_33300[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (9))){
var inst_33229 = (state_33241[(2)]);
var inst_33230 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33241__$1 = (function (){var statearr_33269 = state_33241;
(statearr_33269[(15)] = inst_33229);

return statearr_33269;
})();
if(cljs.core.truth_(inst_33230)){
var statearr_33270_33301 = state_33241__$1;
(statearr_33270_33301[(1)] = (21));

} else {
var statearr_33271_33302 = state_33241__$1;
(statearr_33271_33302[(1)] = (22));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (5))){
var inst_33185 = cljs.core.async.close_BANG_(out);
var state_33241__$1 = state_33241;
var statearr_33272_33303 = state_33241__$1;
(statearr_33272_33303[(2)] = inst_33185);

(statearr_33272_33303[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (14))){
var inst_33207 = (state_33241[(7)]);
var inst_33209 = cljs.core.chunked_seq_QMARK_(inst_33207);
var state_33241__$1 = state_33241;
if(inst_33209){
var statearr_33273_33304 = state_33241__$1;
(statearr_33273_33304[(1)] = (17));

} else {
var statearr_33274_33305 = state_33241__$1;
(statearr_33274_33305[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (16))){
var inst_33225 = (state_33241[(2)]);
var state_33241__$1 = state_33241;
var statearr_33275_33306 = state_33241__$1;
(statearr_33275_33306[(2)] = inst_33225);

(statearr_33275_33306[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33242 === (10))){
var inst_33196 = (state_33241[(9)]);
var inst_33194 = (state_33241[(12)]);
var inst_33201 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33194,inst_33196);
var state_33241__$1 = state_33241;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33241__$1,(13),out,inst_33201);
} else {
if((state_val_33242 === (18))){
var inst_33207 = (state_33241[(7)]);
var inst_33216 = cljs.core.first(inst_33207);
var state_33241__$1 = state_33241;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33241__$1,(20),out,inst_33216);
} else {
if((state_val_33242 === (8))){
var inst_33196 = (state_33241[(9)]);
var inst_33195 = (state_33241[(11)]);
var inst_33198 = (inst_33196 < inst_33195);
var inst_33199 = inst_33198;
var state_33241__$1 = state_33241;
if(cljs.core.truth_(inst_33199)){
var statearr_33276_33307 = state_33241__$1;
(statearr_33276_33307[(1)] = (10));

} else {
var statearr_33277_33308 = state_33241__$1;
(statearr_33277_33308[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto__))
;
return ((function (switch__7880__auto__,c__7942__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__7881__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__7881__auto____0 = (function (){
var statearr_33281 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33281[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__7881__auto__);

(statearr_33281[(1)] = (1));

return statearr_33281;
});
var cljs$core$async$mapcat_STAR__$_state_machine__7881__auto____1 = (function (state_33241){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_33241);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e33282){if((e33282 instanceof Object)){
var ex__7884__auto__ = e33282;
var statearr_33283_33309 = state_33241;
(statearr_33283_33309[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33241);

return cljs.core.constant$keyword$recur;
} else {
throw e33282;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__33310 = state_33241;
state_33241 = G__33310;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__7881__auto__ = function(state_33241){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__7881__auto____1.call(this,state_33241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__7881__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__7881__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto__))
})();
var state__7944__auto__ = (function (){var statearr_33284 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_33284[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto__);

return statearr_33284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto__))
);

return c__7942__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var G__33312 = arguments.length;
switch (G__33312) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var G__33315 = arguments.length;
switch (G__33315) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var G__33318 = arguments.length;
switch (G__33318) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7942__auto___33368 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___33368,out){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___33368,out){
return (function (state_33342){
var state_val_33343 = (state_33342[(1)]);
if((state_val_33343 === (7))){
var inst_33337 = (state_33342[(2)]);
var state_33342__$1 = state_33342;
var statearr_33344_33369 = state_33342__$1;
(statearr_33344_33369[(2)] = inst_33337);

(statearr_33344_33369[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33343 === (1))){
var inst_33319 = null;
var state_33342__$1 = (function (){var statearr_33345 = state_33342;
(statearr_33345[(7)] = inst_33319);

return statearr_33345;
})();
var statearr_33346_33370 = state_33342__$1;
(statearr_33346_33370[(2)] = null);

(statearr_33346_33370[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33343 === (4))){
var inst_33322 = (state_33342[(8)]);
var inst_33322__$1 = (state_33342[(2)]);
var inst_33323 = (inst_33322__$1 == null);
var inst_33324 = cljs.core.not(inst_33323);
var state_33342__$1 = (function (){var statearr_33347 = state_33342;
(statearr_33347[(8)] = inst_33322__$1);

return statearr_33347;
})();
if(inst_33324){
var statearr_33348_33371 = state_33342__$1;
(statearr_33348_33371[(1)] = (5));

} else {
var statearr_33349_33372 = state_33342__$1;
(statearr_33349_33372[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33343 === (6))){
var state_33342__$1 = state_33342;
var statearr_33350_33373 = state_33342__$1;
(statearr_33350_33373[(2)] = null);

(statearr_33350_33373[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33343 === (3))){
var inst_33339 = (state_33342[(2)]);
var inst_33340 = cljs.core.async.close_BANG_(out);
var state_33342__$1 = (function (){var statearr_33351 = state_33342;
(statearr_33351[(9)] = inst_33339);

return statearr_33351;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33342__$1,inst_33340);
} else {
if((state_val_33343 === (2))){
var state_33342__$1 = state_33342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33342__$1,(4),ch);
} else {
if((state_val_33343 === (11))){
var inst_33322 = (state_33342[(8)]);
var inst_33331 = (state_33342[(2)]);
var inst_33319 = inst_33322;
var state_33342__$1 = (function (){var statearr_33352 = state_33342;
(statearr_33352[(7)] = inst_33319);

(statearr_33352[(10)] = inst_33331);

return statearr_33352;
})();
var statearr_33353_33374 = state_33342__$1;
(statearr_33353_33374[(2)] = null);

(statearr_33353_33374[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33343 === (9))){
var inst_33322 = (state_33342[(8)]);
var state_33342__$1 = state_33342;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33342__$1,(11),out,inst_33322);
} else {
if((state_val_33343 === (5))){
var inst_33319 = (state_33342[(7)]);
var inst_33322 = (state_33342[(8)]);
var inst_33326 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33322,inst_33319);
var state_33342__$1 = state_33342;
if(inst_33326){
var statearr_33355_33375 = state_33342__$1;
(statearr_33355_33375[(1)] = (8));

} else {
var statearr_33356_33376 = state_33342__$1;
(statearr_33356_33376[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33343 === (10))){
var inst_33334 = (state_33342[(2)]);
var state_33342__$1 = state_33342;
var statearr_33357_33377 = state_33342__$1;
(statearr_33357_33377[(2)] = inst_33334);

(statearr_33357_33377[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33343 === (8))){
var inst_33319 = (state_33342[(7)]);
var tmp33354 = inst_33319;
var inst_33319__$1 = tmp33354;
var state_33342__$1 = (function (){var statearr_33358 = state_33342;
(statearr_33358[(7)] = inst_33319__$1);

return statearr_33358;
})();
var statearr_33359_33378 = state_33342__$1;
(statearr_33359_33378[(2)] = null);

(statearr_33359_33378[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___33368,out))
;
return ((function (switch__7880__auto__,c__7942__auto___33368,out){
return (function() {
var cljs$core$async$state_machine__7881__auto__ = null;
var cljs$core$async$state_machine__7881__auto____0 = (function (){
var statearr_33363 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33363[(0)] = cljs$core$async$state_machine__7881__auto__);

(statearr_33363[(1)] = (1));

return statearr_33363;
});
var cljs$core$async$state_machine__7881__auto____1 = (function (state_33342){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_33342);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e33364){if((e33364 instanceof Object)){
var ex__7884__auto__ = e33364;
var statearr_33365_33379 = state_33342;
(statearr_33365_33379[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33342);

return cljs.core.constant$keyword$recur;
} else {
throw e33364;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__33380 = state_33342;
state_33342 = G__33380;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$state_machine__7881__auto__ = function(state_33342){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7881__auto____1.call(this,state_33342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7881__auto____0;
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7881__auto____1;
return cljs$core$async$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___33368,out))
})();
var state__7944__auto__ = (function (){var statearr_33366 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_33366[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___33368);

return statearr_33366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___33368,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var G__33382 = arguments.length;
switch (G__33382) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7942__auto___33451 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___33451,out){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___33451,out){
return (function (state_33420){
var state_val_33421 = (state_33420[(1)]);
if((state_val_33421 === (7))){
var inst_33416 = (state_33420[(2)]);
var state_33420__$1 = state_33420;
var statearr_33422_33452 = state_33420__$1;
(statearr_33422_33452[(2)] = inst_33416);

(statearr_33422_33452[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33421 === (1))){
var inst_33383 = (new Array(n));
var inst_33384 = inst_33383;
var inst_33385 = (0);
var state_33420__$1 = (function (){var statearr_33423 = state_33420;
(statearr_33423[(7)] = inst_33384);

(statearr_33423[(8)] = inst_33385);

return statearr_33423;
})();
var statearr_33424_33453 = state_33420__$1;
(statearr_33424_33453[(2)] = null);

(statearr_33424_33453[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33421 === (4))){
var inst_33388 = (state_33420[(9)]);
var inst_33388__$1 = (state_33420[(2)]);
var inst_33389 = (inst_33388__$1 == null);
var inst_33390 = cljs.core.not(inst_33389);
var state_33420__$1 = (function (){var statearr_33425 = state_33420;
(statearr_33425[(9)] = inst_33388__$1);

return statearr_33425;
})();
if(inst_33390){
var statearr_33426_33454 = state_33420__$1;
(statearr_33426_33454[(1)] = (5));

} else {
var statearr_33427_33455 = state_33420__$1;
(statearr_33427_33455[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33421 === (15))){
var inst_33410 = (state_33420[(2)]);
var state_33420__$1 = state_33420;
var statearr_33428_33456 = state_33420__$1;
(statearr_33428_33456[(2)] = inst_33410);

(statearr_33428_33456[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33421 === (13))){
var state_33420__$1 = state_33420;
var statearr_33429_33457 = state_33420__$1;
(statearr_33429_33457[(2)] = null);

(statearr_33429_33457[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33421 === (6))){
var inst_33385 = (state_33420[(8)]);
var inst_33406 = (inst_33385 > (0));
var state_33420__$1 = state_33420;
if(cljs.core.truth_(inst_33406)){
var statearr_33430_33458 = state_33420__$1;
(statearr_33430_33458[(1)] = (12));

} else {
var statearr_33431_33459 = state_33420__$1;
(statearr_33431_33459[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33421 === (3))){
var inst_33418 = (state_33420[(2)]);
var state_33420__$1 = state_33420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33420__$1,inst_33418);
} else {
if((state_val_33421 === (12))){
var inst_33384 = (state_33420[(7)]);
var inst_33408 = cljs.core.vec(inst_33384);
var state_33420__$1 = state_33420;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33420__$1,(15),out,inst_33408);
} else {
if((state_val_33421 === (2))){
var state_33420__$1 = state_33420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33420__$1,(4),ch);
} else {
if((state_val_33421 === (11))){
var inst_33400 = (state_33420[(2)]);
var inst_33401 = (new Array(n));
var inst_33384 = inst_33401;
var inst_33385 = (0);
var state_33420__$1 = (function (){var statearr_33432 = state_33420;
(statearr_33432[(7)] = inst_33384);

(statearr_33432[(10)] = inst_33400);

(statearr_33432[(8)] = inst_33385);

return statearr_33432;
})();
var statearr_33433_33460 = state_33420__$1;
(statearr_33433_33460[(2)] = null);

(statearr_33433_33460[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33421 === (9))){
var inst_33384 = (state_33420[(7)]);
var inst_33398 = cljs.core.vec(inst_33384);
var state_33420__$1 = state_33420;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33420__$1,(11),out,inst_33398);
} else {
if((state_val_33421 === (5))){
var inst_33384 = (state_33420[(7)]);
var inst_33385 = (state_33420[(8)]);
var inst_33388 = (state_33420[(9)]);
var inst_33393 = (state_33420[(11)]);
var inst_33392 = (inst_33384[inst_33385] = inst_33388);
var inst_33393__$1 = (inst_33385 + (1));
var inst_33394 = (inst_33393__$1 < n);
var state_33420__$1 = (function (){var statearr_33434 = state_33420;
(statearr_33434[(12)] = inst_33392);

(statearr_33434[(11)] = inst_33393__$1);

return statearr_33434;
})();
if(cljs.core.truth_(inst_33394)){
var statearr_33435_33461 = state_33420__$1;
(statearr_33435_33461[(1)] = (8));

} else {
var statearr_33436_33462 = state_33420__$1;
(statearr_33436_33462[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33421 === (14))){
var inst_33413 = (state_33420[(2)]);
var inst_33414 = cljs.core.async.close_BANG_(out);
var state_33420__$1 = (function (){var statearr_33438 = state_33420;
(statearr_33438[(13)] = inst_33413);

return statearr_33438;
})();
var statearr_33439_33463 = state_33420__$1;
(statearr_33439_33463[(2)] = inst_33414);

(statearr_33439_33463[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33421 === (10))){
var inst_33404 = (state_33420[(2)]);
var state_33420__$1 = state_33420;
var statearr_33440_33464 = state_33420__$1;
(statearr_33440_33464[(2)] = inst_33404);

(statearr_33440_33464[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33421 === (8))){
var inst_33384 = (state_33420[(7)]);
var inst_33393 = (state_33420[(11)]);
var tmp33437 = inst_33384;
var inst_33384__$1 = tmp33437;
var inst_33385 = inst_33393;
var state_33420__$1 = (function (){var statearr_33441 = state_33420;
(statearr_33441[(7)] = inst_33384__$1);

(statearr_33441[(8)] = inst_33385);

return statearr_33441;
})();
var statearr_33442_33465 = state_33420__$1;
(statearr_33442_33465[(2)] = null);

(statearr_33442_33465[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___33451,out))
;
return ((function (switch__7880__auto__,c__7942__auto___33451,out){
return (function() {
var cljs$core$async$state_machine__7881__auto__ = null;
var cljs$core$async$state_machine__7881__auto____0 = (function (){
var statearr_33446 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33446[(0)] = cljs$core$async$state_machine__7881__auto__);

(statearr_33446[(1)] = (1));

return statearr_33446;
});
var cljs$core$async$state_machine__7881__auto____1 = (function (state_33420){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_33420);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e33447){if((e33447 instanceof Object)){
var ex__7884__auto__ = e33447;
var statearr_33448_33466 = state_33420;
(statearr_33448_33466[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33420);

return cljs.core.constant$keyword$recur;
} else {
throw e33447;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__33467 = state_33420;
state_33420 = G__33467;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$state_machine__7881__auto__ = function(state_33420){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7881__auto____1.call(this,state_33420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7881__auto____0;
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7881__auto____1;
return cljs$core$async$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___33451,out))
})();
var state__7944__auto__ = (function (){var statearr_33449 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_33449[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___33451);

return statearr_33449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___33451,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var G__33469 = arguments.length;
switch (G__33469) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7942__auto___33543 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto___33543,out){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto___33543,out){
return (function (state_33511){
var state_val_33512 = (state_33511[(1)]);
if((state_val_33512 === (7))){
var inst_33507 = (state_33511[(2)]);
var state_33511__$1 = state_33511;
var statearr_33513_33544 = state_33511__$1;
(statearr_33513_33544[(2)] = inst_33507);

(statearr_33513_33544[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33512 === (1))){
var inst_33470 = [];
var inst_33471 = inst_33470;
var inst_33472 = cljs.core.constant$keyword$cljs$core$async_SLASH_nothing;
var state_33511__$1 = (function (){var statearr_33514 = state_33511;
(statearr_33514[(7)] = inst_33472);

(statearr_33514[(8)] = inst_33471);

return statearr_33514;
})();
var statearr_33515_33545 = state_33511__$1;
(statearr_33515_33545[(2)] = null);

(statearr_33515_33545[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33512 === (4))){
var inst_33475 = (state_33511[(9)]);
var inst_33475__$1 = (state_33511[(2)]);
var inst_33476 = (inst_33475__$1 == null);
var inst_33477 = cljs.core.not(inst_33476);
var state_33511__$1 = (function (){var statearr_33516 = state_33511;
(statearr_33516[(9)] = inst_33475__$1);

return statearr_33516;
})();
if(inst_33477){
var statearr_33517_33546 = state_33511__$1;
(statearr_33517_33546[(1)] = (5));

} else {
var statearr_33518_33547 = state_33511__$1;
(statearr_33518_33547[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33512 === (15))){
var inst_33501 = (state_33511[(2)]);
var state_33511__$1 = state_33511;
var statearr_33519_33548 = state_33511__$1;
(statearr_33519_33548[(2)] = inst_33501);

(statearr_33519_33548[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33512 === (13))){
var state_33511__$1 = state_33511;
var statearr_33520_33549 = state_33511__$1;
(statearr_33520_33549[(2)] = null);

(statearr_33520_33549[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33512 === (6))){
var inst_33471 = (state_33511[(8)]);
var inst_33496 = inst_33471.length;
var inst_33497 = (inst_33496 > (0));
var state_33511__$1 = state_33511;
if(cljs.core.truth_(inst_33497)){
var statearr_33521_33550 = state_33511__$1;
(statearr_33521_33550[(1)] = (12));

} else {
var statearr_33522_33551 = state_33511__$1;
(statearr_33522_33551[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33512 === (3))){
var inst_33509 = (state_33511[(2)]);
var state_33511__$1 = state_33511;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33511__$1,inst_33509);
} else {
if((state_val_33512 === (12))){
var inst_33471 = (state_33511[(8)]);
var inst_33499 = cljs.core.vec(inst_33471);
var state_33511__$1 = state_33511;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33511__$1,(15),out,inst_33499);
} else {
if((state_val_33512 === (2))){
var state_33511__$1 = state_33511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33511__$1,(4),ch);
} else {
if((state_val_33512 === (11))){
var inst_33479 = (state_33511[(10)]);
var inst_33475 = (state_33511[(9)]);
var inst_33489 = (state_33511[(2)]);
var inst_33490 = [];
var inst_33491 = inst_33490.push(inst_33475);
var inst_33471 = inst_33490;
var inst_33472 = inst_33479;
var state_33511__$1 = (function (){var statearr_33523 = state_33511;
(statearr_33523[(7)] = inst_33472);

(statearr_33523[(11)] = inst_33489);

(statearr_33523[(8)] = inst_33471);

(statearr_33523[(12)] = inst_33491);

return statearr_33523;
})();
var statearr_33524_33552 = state_33511__$1;
(statearr_33524_33552[(2)] = null);

(statearr_33524_33552[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33512 === (9))){
var inst_33471 = (state_33511[(8)]);
var inst_33487 = cljs.core.vec(inst_33471);
var state_33511__$1 = state_33511;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33511__$1,(11),out,inst_33487);
} else {
if((state_val_33512 === (5))){
var inst_33472 = (state_33511[(7)]);
var inst_33479 = (state_33511[(10)]);
var inst_33475 = (state_33511[(9)]);
var inst_33479__$1 = (function (){var G__33525 = inst_33475;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33525) : f.call(null,G__33525));
})();
var inst_33480 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33479__$1,inst_33472);
var inst_33481 = cljs.core.keyword_identical_QMARK_(inst_33472,cljs.core.constant$keyword$cljs$core$async_SLASH_nothing);
var inst_33482 = (inst_33480) || (inst_33481);
var state_33511__$1 = (function (){var statearr_33526 = state_33511;
(statearr_33526[(10)] = inst_33479__$1);

return statearr_33526;
})();
if(cljs.core.truth_(inst_33482)){
var statearr_33527_33553 = state_33511__$1;
(statearr_33527_33553[(1)] = (8));

} else {
var statearr_33528_33554 = state_33511__$1;
(statearr_33528_33554[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33512 === (14))){
var inst_33504 = (state_33511[(2)]);
var inst_33505 = cljs.core.async.close_BANG_(out);
var state_33511__$1 = (function (){var statearr_33530 = state_33511;
(statearr_33530[(13)] = inst_33504);

return statearr_33530;
})();
var statearr_33531_33555 = state_33511__$1;
(statearr_33531_33555[(2)] = inst_33505);

(statearr_33531_33555[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33512 === (10))){
var inst_33494 = (state_33511[(2)]);
var state_33511__$1 = state_33511;
var statearr_33532_33556 = state_33511__$1;
(statearr_33532_33556[(2)] = inst_33494);

(statearr_33532_33556[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33512 === (8))){
var inst_33479 = (state_33511[(10)]);
var inst_33475 = (state_33511[(9)]);
var inst_33471 = (state_33511[(8)]);
var inst_33484 = inst_33471.push(inst_33475);
var tmp33529 = inst_33471;
var inst_33471__$1 = tmp33529;
var inst_33472 = inst_33479;
var state_33511__$1 = (function (){var statearr_33533 = state_33511;
(statearr_33533[(7)] = inst_33472);

(statearr_33533[(8)] = inst_33471__$1);

(statearr_33533[(14)] = inst_33484);

return statearr_33533;
})();
var statearr_33534_33557 = state_33511__$1;
(statearr_33534_33557[(2)] = null);

(statearr_33534_33557[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto___33543,out))
;
return ((function (switch__7880__auto__,c__7942__auto___33543,out){
return (function() {
var cljs$core$async$state_machine__7881__auto__ = null;
var cljs$core$async$state_machine__7881__auto____0 = (function (){
var statearr_33538 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33538[(0)] = cljs$core$async$state_machine__7881__auto__);

(statearr_33538[(1)] = (1));

return statearr_33538;
});
var cljs$core$async$state_machine__7881__auto____1 = (function (state_33511){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_33511);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e33539){if((e33539 instanceof Object)){
var ex__7884__auto__ = e33539;
var statearr_33540_33558 = state_33511;
(statearr_33540_33558[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33511);

return cljs.core.constant$keyword$recur;
} else {
throw e33539;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__33559 = state_33511;
state_33511 = G__33559;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
cljs$core$async$state_machine__7881__auto__ = function(state_33511){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7881__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7881__auto____1.call(this,state_33511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7881__auto____0;
cljs$core$async$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7881__auto____1;
return cljs$core$async$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto___33543,out))
})();
var state__7944__auto__ = (function (){var statearr_33541 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_33541[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto___33543);

return statearr_33541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto___33543,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
