// Compiled by ClojureScript 0.0-3196 {}
goog.provide('milia.api.dataset');
goog.require('cljs.core');
goog.require('milia.utils.remote');
goog.require('milia.utils.seq');
goog.require('milia.api.http');
goog.require('milia.api.io');
/**
 * Return all the datasets for an account.
 */
milia.api.dataset.all = (function milia$api$dataset$all(account){
var url = milia.api.io.make_url.call(null,[cljs.core.str("forms?owner="),cljs.core.str(new cljs.core.Keyword(null,"username","username",1605666410).cljs$core$IFn$_invoke$arity$1(account))].join(''));
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account);
});
/**
 * Return all public datasets for a specific user.
 */
milia.api.dataset.public$ = (function milia$api$dataset$public(account,username){
var url = milia.api.io.make_url.call(null,"forms",username);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account);
});
/**
 * Set the metadata for a dataset using PUT. All parameters must be passed.
 */
milia.api.dataset.update = (function milia$api$dataset$update(account,dataset_id,params){
if(cljs.core.truth_(milia.utils.seq.has_keys_QMARK_.call(null,params,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"created_by","created_by",562491388),new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"downloadable","downloadable",933081130),new cljs.core.Keyword(null,"owner","owner",-392611939),new cljs.core.Keyword(null,"project","project",1124394579),new cljs.core.Keyword(null,"public","public",1566243851),new cljs.core.Keyword(null,"public_data","public_data",2053501804),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"uuid","uuid",-2145095719)], null)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"has-keys?","has-keys?",-2012545374,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"created_by","created_by",562491388),new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"downloadable","downloadable",933081130),new cljs.core.Keyword(null,"owner","owner",-392611939),new cljs.core.Keyword(null,"project","project",1124394579),new cljs.core.Keyword(null,"public","public",1566243851),new cljs.core.Keyword(null,"public_data","public_data",2053501804),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"uuid","uuid",-2145095719)], null))))].join('')));
}

var url = milia.api.io.make_url.call(null,"forms",dataset_id);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"put","put",1299772570),url,account,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"form-params","form-params",1884296467),params], null));
});
/**
 * Update the title of a form
 */
milia.api.dataset.update_form_name = (function milia$api$dataset$update_form_name(account,dataset_id,params){
var url = milia.api.io.make_url.call(null,"forms",dataset_id);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"put","put",1299772570),url,account,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"form-params","form-params",1884296467),params], null));
});
/**
 * Return the data associated with a dataset.
 */
milia.api.dataset.data = (function milia$api$dataset$data(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic = (function (account,dataset_id,p__10962){
var map__10963 = p__10962;
var map__10963__$1 = ((cljs.core.seq_QMARK_.call(null,map__10963))?cljs.core.apply.call(null,cljs.core.hash_map,map__10963):map__10963);
var raw_QMARK_ = cljs.core.get.call(null,map__10963__$1,new cljs.core.Keyword(null,"raw?","raw?",394379982));
var format = cljs.core.get.call(null,map__10963__$1,new cljs.core.Keyword(null,"format","format",-1306924766),"json");
var dataset_suffix = (cljs.core.truth_(format)?[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format)].join(''):dataset_id);
var url = milia.api.io.make_url.call(null,"data",dataset_suffix);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"raw-response?","raw-response?",557978228),raw_QMARK_], null));
});

milia.api.dataset.data.cljs$lang$maxFixedArity = (2);

milia.api.dataset.data.cljs$lang$applyTo = (function (seq10959){
var G__10960 = cljs.core.first.call(null,seq10959);
var seq10959__$1 = cljs.core.next.call(null,seq10959);
var G__10961 = cljs.core.first.call(null,seq10959__$1);
var seq10959__$2 = cljs.core.next.call(null,seq10959__$1);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic(G__10960,G__10961,seq10959__$2);
});
/**
 * Retrieve a record from the dataset.
 */
milia.api.dataset.record = (function milia$api$dataset$record(account,dataset_id,record_id){
var url = milia.api.io.make_url.call(null,"data",dataset_id,record_id);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account);
});
/**
 * Returns tags for a dataset
 */
milia.api.dataset.tags = (function milia$api$dataset$tags(account,dataset_id){
var url = milia.api.io.make_url.call(null,"forms",dataset_id,"labels");
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account);
});
/**
 * Add tags to a dataset
 */
milia.api.dataset.add_tags = (function milia$api$dataset$add_tags(account,dataset_id,tags){
var url = milia.api.io.make_url.call(null,"forms",dataset_id,"labels");
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"post","post",269697687),url,account,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"form-params","form-params",1884296467),tags], null));
});
/**
 * Return filename taking format special cases into account.
 */
milia.api.dataset.filename_for_format = (function milia$api$dataset$filename_for_format(dataset_id,format){
return [cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(((cljs.core._EQ_.call(null,format,"csvzip"))?"zip":format))].join('');
});
/**
 * Return options needed to handle format.
 */
milia.api.dataset.options_for_format = (function milia$api$dataset$options_for_format(format){
if(cljs.core.truth_(milia.utils.seq.in_QMARK_.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["csvzip","sav","xls","xlsx"], null),format))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"byte-array","byte-array",369158537)], null);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
/**
 * Download form as JSON string or file in specified format if format passed.
 */
milia.api.dataset.form = (function milia$api$dataset$form(){
var G__10965 = arguments.length;
switch (G__10965) {
case 2:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2 = (function (account,dataset_id){
var url = milia.api.io.make_url.call(null,"forms",dataset_id,"form.json");
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account);
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$3 = (function (account,dataset_id,format){
var suffix = [cljs.core.str("form."),cljs.core.str(format)].join('');
var options = milia.api.dataset.options_for_format.call(null,format);
var url = milia.api.io.make_url.call(null,"forms",dataset_id,suffix);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account,options,[cljs.core.str(dataset_id),cljs.core.str("_"),cljs.core.str(suffix)].join(''));
});

milia.api.dataset.form.cljs$lang$maxFixedArity = 3;
/**
 * Show dataset metadata.
 */
milia.api.dataset.metadata = (function milia$api$dataset$metadata(account,dataset_id){
var url = milia.api.io.make_url.call(null,"forms",dataset_id);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account);
});
/**
 * Return link to online data entry.
 */
milia.api.dataset.edit_link = (function milia$api$dataset$edit_link(account,dataset_id,instance_id){
var zebra_blank = milia.utils.remote.make_zebra_url.call(null,"blank");
var url = milia.api.io.make_url.call(null,"data",dataset_id,instance_id,[cljs.core.str("enketo?return_url="),cljs.core.str(zebra_blank)].join(''));
return new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account));
});
/**
 * Delete a dataset by ID.
 */
milia.api.dataset.delete$ = (function milia$api$dataset$delete(account,dataset_id){
var url = milia.api.io.make_url.call(null,"forms",dataset_id,"delete_async");
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),url,account);
});
/**
 * Move a dataset to a project use account if no owner passed.
 */
milia.api.dataset.move_to_project = (function milia$api$dataset$move_to_project(account,dataset_id,project_id){
var url = milia.api.io.make_url.call(null,"projects",project_id,"forms");
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"post","post",269697687),url,account,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"form-params","form-params",1884296467),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"formid","formid",-2121398991),dataset_id], null)], null));
});
/**
 * Share dataset with specific user
 */
milia.api.dataset.update_sharing = (function milia$api$dataset$update_sharing(account,dataset_id,username,role){
var url = milia.api.io.make_url.call(null,"forms",dataset_id,"share");
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"role","role",-736691072),role], null);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"post","post",269697687),url,account,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"form-params","form-params",1884296467),data], null));
});
/**
 * Add xls report link to dataset
 */
milia.api.dataset.add_xls_report = (function milia$api$dataset$add_xls_report(account,dataset_id,uuid,filename){
var xls_url = milia.utils.remote.make_j2x_url.call(null,"xls",uuid);
var url = milia.api.io.make_url.call(null,"metadata");
var data = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"xform","xform",-1725711008),dataset_id,new cljs.core.Keyword(null,"data_type","data_type",1391137078),"external_export",new cljs.core.Keyword(null,"data_value","data_value",-683590351),[cljs.core.str(filename),cljs.core.str("|"),cljs.core.str(xls_url)].join('')], null);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"post","post",269697687),url,account,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"form-params","form-params",1884296467),data], null));
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataset.download_xls_report = (function milia$api$dataset$download_xls_report(){
var G__10968 = arguments.length;
switch (G__10968) {
case 4:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4 = (function (account,dataset_id,meta_id,filename){
return milia.api.dataset.download_xls_report.call(null,account,dataset_id,meta_id,filename,null);
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$5 = (function (account,dataset_id,meta_id,filename,data_id){
var suffix = (cljs.core.truth_(data_id)?[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id),cljs.core.str("&data_id="),cljs.core.str(data_id)].join(''):[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id)].join(''));
var url = milia.api.io.make_url.call(null,"forms",suffix);
return milia.api.http.parse_http.call(null,new cljs.core.Keyword(null,"get","get",1683182755),url,account,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"byte-array","byte-array",369158537),new cljs.core.Keyword(null,"as-map?","as-map?",1213586270),true], null),filename);
});

milia.api.dataset.download_xls_report.cljs$lang$maxFixedArity = 5;
