// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('milia.utils.remote');
goog.require('dommy.core');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.string');
milia.api.io.make_url = milia.utils.remote.make_url;
milia.api.io.make_json_url = (function milia$api$io$make_json_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

var bare_url = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.io.make_url,args);
return [cljs.core.str(bare_url),cljs.core.str(".json")].join('');
});

milia.api.io.make_json_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_json_url.cljs$lang$applyTo = (function (seq28455){
return milia.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28455));
});
milia.api.io.refresh_token_url = (function milia$api$io$refresh_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/temp-token")].join('');
});
milia.api.io.validate_token_url = (function milia$api$io$validate_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/validate-token")].join('');
});
/**
 * Build a url off of zebra
 */
milia.api.io.make_zebra_url = (function milia$api$io$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var zebra_host = ((window["location"])["origin"]);
return milia.utils.remote.url_join(zebra_host,postfix);
});

milia.api.io.make_zebra_url.cljs$lang$maxFixedArity = (0);

milia.api.io.make_zebra_url.cljs$lang$applyTo = (function (seq28456){
return milia.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28456));
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request)))))))))));
milia.api.io.raw_get = (function milia$api$io$raw_get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__28459){
var vec__28460 = p__28459;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28460,(0),null);

var G__28461 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__28461) : milia.api.io.raw_request.call(null,G__28461));
});

milia.api.io.raw_get.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_get.cljs$lang$applyTo = (function (seq28457){
var G__28458 = cljs.core.first(seq28457);
var seq28457__$1 = cljs.core.next(seq28457);
return milia.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic(G__28458,seq28457__$1);
});
milia.api.io.raw_post = (function milia$api$io$raw_post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__28464){
var vec__28465 = p__28464;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28465,(0),null);

var G__28466 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? milia.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__28466) : milia.api.io.raw_request.call(null,G__28466));
});

milia.api.io.raw_post.cljs$lang$maxFixedArity = (1);

milia.api.io.raw_post.cljs$lang$applyTo = (function (seq28462){
var G__28463 = cljs.core.first(seq28462);
var seq28462__$1 = cljs.core.next(seq28462);
return milia.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic(G__28463,seq28462__$1);
});
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(){
var G__28468 = arguments.length;
switch (G__28468) {
case 1:
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1 = (function (token){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(token,false);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2 = (function (token,get_crsftoken_QMARK_){
var headers = (cljs.core.truth_((function (){var and__4264__auto__ = token;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not(clojure.string.blank_QMARK_(token));
} else {
return and__4264__auto__;
}
})())?new cljs.core.PersistentArrayMap(null, 1, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(token)].join('')], null):null);
var temp__4124__auto__ = (function (){var and__4264__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__4264__auto__)){
var G__28469 = "csrftoken";
return goog.net.cookies.get(G__28469);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var crsf_token = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(headers,"X-CSRFToken",crsf_token);
} else {
return headers;
}
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = 2;
milia.api.io.query_helper = (function milia$api$io$query_helper(method){

return (function() {
var G__28483 = null;
var G__28483__1 = (function (url){
return milia$api$io$query_helper(method).call(null,url,null,null);
});
var G__28483__2 = (function (url,query_params){
return milia$api$io$query_helper(method).call(null,url,query_params,null);
});
var G__28483__4 = (function() { 
var G__28484__delegate = function (url,query_params,token,p__28478){
var map__28479 = p__28478;
var map__28479__$1 = ((cljs.core.seq_QMARK_(map__28479))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28479):map__28479);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28479__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var http_method = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$get,cljs_http.client.get,cljs.core.constant$keyword$raw_DASH_get,milia.api.io.raw_get,cljs.core.constant$keyword$post,cljs_http.client.post,cljs.core.constant$keyword$raw_DASH_post,milia.api.io.raw_post,cljs.core.constant$keyword$delete,cljs_http.client.delete$,cljs.core.constant$keyword$put,cljs_http.client.put,cljs.core.constant$keyword$patch,cljs_http.client.patch], null).call(null,method);
var param_key = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$put,null], null), null),method))?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(token,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(http_method,cljs_http.client.delete$));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$t,(function (){var G__28480 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__28480) : cljs_hash.md5.md5.call(null,G__28480));
})()], null):null);
var query_params__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([query_params,time_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$xhr,true], null)], 0));
var G__28481 = url;
var G__28482 = new cljs.core.PersistentArrayMap.fromArray([cljs.core.constant$keyword$headers,headers,param_key,query_params__$1], true, false);
return (http_method.cljs$core$IFn$_invoke$arity$2 ? http_method.cljs$core$IFn$_invoke$arity$2(G__28481,G__28482) : http_method.call(null,G__28481,G__28482));
};
var G__28484 = function (url,query_params,token,var_args){
var p__28478 = null;
if (arguments.length > 3) {
var G__28485__i = 0, G__28485__a = new Array(arguments.length -  3);
while (G__28485__i < G__28485__a.length) {G__28485__a[G__28485__i] = arguments[G__28485__i + 3]; ++G__28485__i;}
  p__28478 = new cljs.core.IndexedSeq(G__28485__a,0);
} 
return G__28484__delegate.call(this,url,query_params,token,p__28478);};
G__28484.cljs$lang$maxFixedArity = 3;
G__28484.cljs$lang$applyTo = (function (arglist__28486){
var url = cljs.core.first(arglist__28486);
arglist__28486 = cljs.core.next(arglist__28486);
var query_params = cljs.core.first(arglist__28486);
arglist__28486 = cljs.core.next(arglist__28486);
var token = cljs.core.first(arglist__28486);
var p__28478 = cljs.core.rest(arglist__28486);
return G__28484__delegate(url,query_params,token,p__28478);
});
G__28484.cljs$core$IFn$_invoke$arity$variadic = G__28484__delegate;
return G__28484;
})()
;
G__28483 = function(url,query_params,token,var_args){
var p__28478 = var_args;
switch(arguments.length){
case 1:
return G__28483__1.call(this,url);
case 2:
return G__28483__2.call(this,url,query_params);
default:
var G__28487 = null;
if (arguments.length > 3) {
var G__28488__i = 0, G__28488__a = new Array(arguments.length -  3);
while (G__28488__i < G__28488__a.length) {G__28488__a[G__28488__i] = arguments[G__28488__i + 3]; ++G__28488__i;}
G__28487 = new cljs.core.IndexedSeq(G__28488__a,0);
}
return G__28483__4.cljs$core$IFn$_invoke$arity$variadic(url,query_params,token, G__28487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28483.cljs$lang$maxFixedArity = 3;
G__28483.cljs$lang$applyTo = G__28483__4.cljs$lang$applyTo;
G__28483.cljs$core$IFn$_invoke$arity$1 = G__28483__1;
G__28483.cljs$core$IFn$_invoke$arity$2 = G__28483__2;
G__28483.cljs$core$IFn$_invoke$arity$variadic = G__28483__4.cljs$core$IFn$_invoke$arity$variadic;
return G__28483;
})()
});
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_get_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_get);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.get_url = milia.api.io.query_helper(cljs.core.constant$keyword$get);
/**
 * Issues a DELETE request to a given url.
 */
milia.api.io.delete_url = milia.api.io.query_helper(cljs.core.constant$keyword$delete);
/**
 * Issues a PATCH request for updating information.
 */
milia.api.io.patch_url = milia.api.io.query_helper(cljs.core.constant$keyword$patch);
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
milia.api.io.raw_post_url = milia.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_post);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
milia.api.io.post_url = milia.api.io.query_helper(cljs.core.constant$keyword$post);
milia.api.io.put_url = milia.api.io.query_helper(cljs.core.constant$keyword$put);
milia.api.io.query_helper_BANG_ = (function milia$api$io$query_helper_BANG_(){
var G__28496 = arguments.length;
switch (G__28496) {
case 2:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(url,method,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (method,url,callback){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(method,url,callback,null);
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (method,url,callback,query_params){
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(method,url,callback,query_params,cljs.core.array_seq([null], 0));
});

milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,callback,query_params,token,opts){
var c__7942__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto__){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto__){
return (function (state_28507){
var state_val_28508 = (state_28507[(1)]);
if((state_val_28508 === (5))){
var inst_28505 = (state_28507[(2)]);
var state_28507__$1 = state_28507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28507__$1,inst_28505);
} else {
if((state_val_28508 === (4))){
var state_28507__$1 = state_28507;
var statearr_28509_28527 = state_28507__$1;
(statearr_28509_28527[(2)] = null);

(statearr_28509_28527[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28508 === (3))){
var inst_28500 = (state_28507[(7)]);
var inst_28502 = (function (){var G__28510 = inst_28500;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__28510) : callback.call(null,G__28510));
})();
var state_28507__$1 = state_28507;
var statearr_28511_28528 = state_28507__$1;
(statearr_28511_28528[(2)] = inst_28502);

(statearr_28511_28528[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28508 === (2))){
var inst_28500 = (state_28507[(2)]);
var state_28507__$1 = (function (){var statearr_28512 = state_28507;
(statearr_28512[(7)] = inst_28500);

return statearr_28512;
})();
if(cljs.core.truth_(callback)){
var statearr_28513_28529 = state_28507__$1;
(statearr_28513_28529[(1)] = (3));

} else {
var statearr_28514_28530 = state_28507__$1;
(statearr_28514_28530[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28508 === (1))){
var inst_28497 = milia.api.io.query_helper(method);
var inst_28498 = (function (){var G__28515 = url;
var G__28516 = query_params;
var G__28517 = token;
var G__28518 = opts;
return (inst_28497.cljs$core$IFn$_invoke$arity$4 ? inst_28497.cljs$core$IFn$_invoke$arity$4(G__28515,G__28516,G__28517,G__28518) : inst_28497.call(null,G__28515,G__28516,G__28517,G__28518));
})();
var state_28507__$1 = state_28507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28507__$1,(2),inst_28498);
} else {
return null;
}
}
}
}
}
});})(c__7942__auto__))
;
return ((function (switch__7880__auto__,c__7942__auto__){
return (function() {
var milia$api$io$state_machine__7881__auto__ = null;
var milia$api$io$state_machine__7881__auto____0 = (function (){
var statearr_28522 = [null,null,null,null,null,null,null,null];
(statearr_28522[(0)] = milia$api$io$state_machine__7881__auto__);

(statearr_28522[(1)] = (1));

return statearr_28522;
});
var milia$api$io$state_machine__7881__auto____1 = (function (state_28507){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_28507);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e28523){if((e28523 instanceof Object)){
var ex__7884__auto__ = e28523;
var statearr_28524_28531 = state_28507;
(statearr_28524_28531[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28507);

return cljs.core.constant$keyword$recur;
} else {
throw e28523;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__28532 = state_28507;
state_28507 = G__28532;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
milia$api$io$state_machine__7881__auto__ = function(state_28507){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__7881__auto____0.call(this);
case 1:
return milia$api$io$state_machine__7881__auto____1.call(this,state_28507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__7881__auto____0;
milia$api$io$state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__7881__auto____1;
return milia$api$io$state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto__))
})();
var state__7944__auto__ = (function (){var statearr_28525 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_28525[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto__);

return statearr_28525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto__))
);

return c__7942__auto__;
});

milia.api.io.query_helper_BANG_.cljs$lang$applyTo = (function (seq28489){
var G__28490 = cljs.core.first(seq28489);
var seq28489__$1 = cljs.core.next(seq28489);
var G__28491 = cljs.core.first(seq28489__$1);
var seq28489__$2 = cljs.core.next(seq28489__$1);
var G__28492 = cljs.core.first(seq28489__$2);
var seq28489__$3 = cljs.core.next(seq28489__$2);
var G__28493 = cljs.core.first(seq28489__$3);
var seq28489__$4 = cljs.core.next(seq28489__$3);
var G__28494 = cljs.core.first(seq28489__$4);
var seq28489__$5 = cljs.core.next(seq28489__$4);
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28490,G__28491,G__28492,G__28493,G__28494,seq28489__$5);
});

milia.api.io.query_helper_BANG_.cljs$lang$maxFixedArity = 4;
milia.api.io.get_event = (function milia$api$io$get_event(){
var G__28534 = arguments.length;
switch (G__28534) {
case 1:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__28535 = event.target;
var G__28536 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__28535,G__28536) : dommy.core.attr.call(null,G__28535,G__28536));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,cljs.core.PersistentArrayMap.EMPTY);
});

milia.api.io.get_event.cljs$core$IFn$_invoke$arity$3 = (function (event,callback,params){
var url = (function (){var G__28537 = event.target.form;
var G__28538 = cljs.core.constant$keyword$action;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__28537,G__28538) : dommy.core.attr.call(null,G__28537,G__28538));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,params);
});

milia.api.io.get_event.cljs$lang$maxFixedArity = 3;
milia.api.io.post_event = (function milia$api$io$post_event(){
var G__28541 = arguments.length;
switch (G__28541) {
case 1:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

milia.api.io.post_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__28542 = event.target;
var G__28543 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__28542,G__28543) : dommy.core.attr.call(null,G__28542,G__28543));
})();
return milia.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$post,url,callback);
});

milia.api.io.post_event.cljs$lang$maxFixedArity = 2;
/**
 * Checks if validate toke response returns invalid token message
 */
milia.api.io.invalid_token_QMARK_ = (function milia$api$io$invalid_token_QMARK_(response){
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$status.cljs$core$IFn$_invoke$arity$1(response),(403))) && ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Invalid token")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Token expired")))){
return true;
} else {
return null;
}
});
/**
 * Validates users auth-token on client
 */
milia.api.io.validate_token = (function milia$api$io$validate_token(auth_token,username){
var c__7942__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7942__auto__){
return (function (){
var f__7943__auto__ = (function (){var switch__7880__auto__ = ((function (c__7942__auto__){
return (function (state_28678){
var state_val_28679 = (state_28678[(1)]);
if((state_val_28679 === (7))){
var inst_28643 = (state_28678[(2)]);
var state_28678__$1 = state_28678;
var statearr_28680_28725 = state_28678__$1;
(statearr_28680_28725[(2)] = inst_28643);

(statearr_28680_28725[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (20))){
var state_28678__$1 = state_28678;
var statearr_28681_28726 = state_28678__$1;
(statearr_28681_28726[(2)] = null);

(statearr_28681_28726[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (1))){
var inst_28635 = (state_28678[(7)]);
var inst_28635__$1 = (auth_token == null);
var state_28678__$1 = (function (){var statearr_28682 = state_28678;
(statearr_28682[(7)] = inst_28635__$1);

return statearr_28682;
})();
if(cljs.core.truth_(inst_28635__$1)){
var statearr_28683_28727 = state_28678__$1;
(statearr_28683_28727[(1)] = (2));

} else {
var statearr_28684_28728 = state_28678__$1;
(statearr_28684_28728[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (4))){
var inst_28645 = (state_28678[(2)]);
var state_28678__$1 = state_28678;
if(cljs.core.truth_(inst_28645)){
var statearr_28685_28729 = state_28678__$1;
(statearr_28685_28729[(1)] = (8));

} else {
var statearr_28686_28730 = state_28678__$1;
(statearr_28686_28730[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (15))){
var inst_28658 = (state_28678[(8)]);
var inst_28658__$1 = (state_28678[(2)]);
var inst_28659 = cljs.core.seq_QMARK_(inst_28658__$1);
var state_28678__$1 = (function (){var statearr_28687 = state_28678;
(statearr_28687[(8)] = inst_28658__$1);

return statearr_28687;
})();
if(inst_28659){
var statearr_28688_28731 = state_28678__$1;
(statearr_28688_28731[(1)] = (16));

} else {
var statearr_28689_28732 = state_28678__$1;
(statearr_28689_28732[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (21))){
var inst_28671 = (state_28678[(2)]);
var state_28678__$1 = state_28678;
var statearr_28690_28733 = state_28678__$1;
(statearr_28690_28733[(2)] = inst_28671);

(statearr_28690_28733[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (13))){
var state_28678__$1 = state_28678;
var statearr_28691_28734 = state_28678__$1;
(statearr_28691_28734[(2)] = auth_token);

(statearr_28691_28734[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (6))){
var inst_28641 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",auth_token);
var state_28678__$1 = state_28678;
var statearr_28692_28735 = state_28678__$1;
(statearr_28692_28735[(2)] = inst_28641);

(statearr_28692_28735[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (17))){
var inst_28658 = (state_28678[(8)]);
var state_28678__$1 = state_28678;
var statearr_28693_28736 = state_28678__$1;
(statearr_28693_28736[(2)] = inst_28658);

(statearr_28693_28736[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (3))){
var inst_28638 = (state_28678[(9)]);
var inst_28638__$1 = clojure.string.blank_QMARK_(auth_token);
var state_28678__$1 = (function (){var statearr_28694 = state_28678;
(statearr_28694[(9)] = inst_28638__$1);

return statearr_28694;
})();
if(cljs.core.truth_(inst_28638__$1)){
var statearr_28695_28737 = state_28678__$1;
(statearr_28695_28737[(1)] = (5));

} else {
var statearr_28696_28738 = state_28678__$1;
(statearr_28696_28738[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (12))){
var inst_28655 = milia.api.io.refresh_token_url(username);
var inst_28656 = (function (){var G__28697 = inst_28655;
var G__28698 = null;
var G__28699 = null;
var G__28700 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__28701 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__28697,G__28698,G__28699,G__28700,G__28701) : milia.api.io.get_url.call(null,G__28697,G__28698,G__28699,G__28700,G__28701));
})();
var state_28678__$1 = state_28678;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28678__$1,(15),inst_28656);
} else {
if((state_val_28679 === (2))){
var inst_28635 = (state_28678[(7)]);
var state_28678__$1 = state_28678;
var statearr_28702_28739 = state_28678__$1;
(statearr_28702_28739[(2)] = inst_28635);

(statearr_28702_28739[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (19))){
var inst_28665 = (state_28678[(10)]);
var state_28678__$1 = state_28678;
var statearr_28703_28740 = state_28678__$1;
(statearr_28703_28740[(2)] = inst_28665);

(statearr_28703_28740[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (11))){
var inst_28651 = (state_28678[(2)]);
var inst_28652 = milia.api.io.invalid_token_QMARK_(inst_28651);
var state_28678__$1 = state_28678;
if(cljs.core.truth_(inst_28652)){
var statearr_28704_28741 = state_28678__$1;
(statearr_28704_28741[(1)] = (12));

} else {
var statearr_28705_28742 = state_28678__$1;
(statearr_28705_28742[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (9))){
var inst_28648 = milia.api.io.validate_token_url(username);
var inst_28649 = (function (){var G__28706 = inst_28648;
var G__28707 = null;
var G__28708 = null;
var G__28709 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__28710 = true;
return (milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? milia.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__28706,G__28707,G__28708,G__28709,G__28710) : milia.api.io.get_url.call(null,G__28706,G__28707,G__28708,G__28709,G__28710));
})();
var state_28678__$1 = state_28678;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28678__$1,(11),inst_28649);
} else {
if((state_val_28679 === (5))){
var inst_28638 = (state_28678[(9)]);
var state_28678__$1 = state_28678;
var statearr_28711_28743 = state_28678__$1;
(statearr_28711_28743[(2)] = inst_28638);

(statearr_28711_28743[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (14))){
var inst_28674 = (state_28678[(2)]);
var state_28678__$1 = state_28678;
var statearr_28712_28744 = state_28678__$1;
(statearr_28712_28744[(2)] = inst_28674);

(statearr_28712_28744[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (16))){
var inst_28658 = (state_28678[(8)]);
var inst_28661 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_28658);
var state_28678__$1 = state_28678;
var statearr_28713_28745 = state_28678__$1;
(statearr_28713_28745[(2)] = inst_28661);

(statearr_28713_28745[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (10))){
var inst_28676 = (state_28678[(2)]);
var state_28678__$1 = state_28678;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28678__$1,inst_28676);
} else {
if((state_val_28679 === (18))){
var inst_28664 = (state_28678[(2)]);
var inst_28665 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28664,cljs.core.constant$keyword$body);
var inst_28666 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28664,cljs.core.constant$keyword$status);
var inst_28667 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28666,(200));
var state_28678__$1 = (function (){var statearr_28714 = state_28678;
(statearr_28714[(10)] = inst_28665);

return statearr_28714;
})();
if(inst_28667){
var statearr_28715_28746 = state_28678__$1;
(statearr_28715_28746[(1)] = (19));

} else {
var statearr_28716_28747 = state_28678__$1;
(statearr_28716_28747[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_28679 === (8))){
var state_28678__$1 = state_28678;
var statearr_28717_28748 = state_28678__$1;
(statearr_28717_28748[(2)] = null);

(statearr_28717_28748[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7942__auto__))
;
return ((function (switch__7880__auto__,c__7942__auto__){
return (function() {
var milia$api$io$validate_token_$_state_machine__7881__auto__ = null;
var milia$api$io$validate_token_$_state_machine__7881__auto____0 = (function (){
var statearr_28721 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28721[(0)] = milia$api$io$validate_token_$_state_machine__7881__auto__);

(statearr_28721[(1)] = (1));

return statearr_28721;
});
var milia$api$io$validate_token_$_state_machine__7881__auto____1 = (function (state_28678){
while(true){
var ret_value__7882__auto__ = (function (){try{while(true){
var result__7883__auto__ = switch__7880__auto__(state_28678);
if(cljs.core.keyword_identical_QMARK_(result__7883__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7883__auto__;
}
break;
}
}catch (e28722){if((e28722 instanceof Object)){
var ex__7884__auto__ = e28722;
var statearr_28723_28749 = state_28678;
(statearr_28723_28749[(5)] = ex__7884__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28678);

return cljs.core.constant$keyword$recur;
} else {
throw e28722;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7882__auto__,cljs.core.constant$keyword$recur)){
var G__28750 = state_28678;
state_28678 = G__28750;
continue;
} else {
return ret_value__7882__auto__;
}
break;
}
});
milia$api$io$validate_token_$_state_machine__7881__auto__ = function(state_28678){
switch(arguments.length){
case 0:
return milia$api$io$validate_token_$_state_machine__7881__auto____0.call(this);
case 1:
return milia$api$io$validate_token_$_state_machine__7881__auto____1.call(this,state_28678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$validate_token_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$validate_token_$_state_machine__7881__auto____0;
milia$api$io$validate_token_$_state_machine__7881__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$validate_token_$_state_machine__7881__auto____1;
return milia$api$io$validate_token_$_state_machine__7881__auto__;
})()
;})(switch__7880__auto__,c__7942__auto__))
})();
var state__7944__auto__ = (function (){var statearr_28724 = (function (){return (f__7943__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7943__auto__.cljs$core$IFn$_invoke$arity$0() : f__7943__auto__.call(null));
})();
(statearr_28724[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7942__auto__);

return statearr_28724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7944__auto__);
});})(c__7942__auto__))
);

return c__7942__auto__;
});
/**
 * Use google library to upload file
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__28757_28763 = io_obj;
var G__28758_28764 = goog.net.EventType.SUCCESS;
var G__28759_28765 = ((function (G__28757_28763,G__28758_28764,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__28757_28763,G__28758_28764,io_obj,url))
;
goog.events.listen(G__28757_28763,G__28758_28764,G__28759_28765);

var G__28760_28766 = io_obj;
var G__28761_28767 = goog.net.EventType.ERROR;
var G__28762_28768 = ((function (G__28760_28766,G__28761_28767,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__28760_28766,G__28761_28767,io_obj,url))
;
goog.events.listen(G__28760_28766,G__28761_28767,G__28762_28768);

return io_obj.sendFromForm(form,url);
});
