// Compiled by ClojureScript 0.0-3196 {}
goog.provide('ona.utils.remote');
goog.require('cljs.core');
goog.require('ona.utils.url');
goog.require('clojure.string');
ona.utils.remote.hosts = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ui","ui",-469653645),"beta.ona.io",new cljs.core.Keyword(null,"data","data",-232669377),"stage.ona.io",new cljs.core.Keyword(null,"ona-api-server-protocol","ona-api-server-protocol",1305279248),"https"], null));
ona.utils.remote.protocol = new cljs.core.Keyword(null,"ona-api-server-protocol","ona-api-server-protocol",1305279248).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ona.utils.remote.hosts));
/**
 * Prefix the resources with the protocol and format strings.
 */
ona.utils.remote.protocol_prefixed_STAR_ = (function ona$utils$remote$protocol_prefixed_STAR_(resources){
return clojure.string.join.call(null,cljs.core.flatten.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [ona.utils.remote.protocol,"://",resources], null)));
});
ona.utils.remote.protocol_prefixed = cljs.core.memoize.call(null,ona.utils.remote.protocol_prefixed_STAR_);
ona.utils.remote.j2x_host = "j2x.ona.io";
ona.utils.remote.thumbor_host = "images.ona.io";
ona.utils.remote.forms_host = ona.utils.remote.protocol_prefixed.call(null,(function (){var or__4276__auto__ = new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ona.utils.remote.hosts));
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ona.utils.remote.hosts));
}
})());
ona.utils.remote.host_server = ona.utils.remote.protocol_prefixed.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,ona.utils.remote.hosts)),"/"], null));
ona.utils.remote.j2x_host_server = ona.utils.remote.protocol_prefixed.call(null,ona.utils.remote.j2x_host);
ona.utils.remote.thumbor_server = ona.utils.remote.protocol_prefixed.call(null,ona.utils.remote.thumbor_host);
ona.utils.remote.url_join = (function ona$utils$remote$url_join(host,args){
return clojure.string.join.call(null,cljs.core.conj.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.call(null,ona.utils.url.url,args)));
});
/**
 * Build an API url.
 */
ona.utils.remote.make_url = (function ona$utils$remote$make_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return ona.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

ona.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return ona.utils.remote.url_join.call(null,[cljs.core.str(ona.utils.remote.host_server),cljs.core.str("api/v1")].join(''),postfix);
});

ona.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

ona.utils.remote.make_url.cljs$lang$applyTo = (function (seq10946){
return ona.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10946));
});
/**
 * Build a Zebra url.
 */
ona.utils.remote.make_zebra_url = (function ona$utils$remote$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return ona.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

ona.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return ona.utils.remote.url_join.call(null,ona.utils.remote.protocol_prefixed.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645).cljs$core$IFn$_invoke$arity$1(ona.utils.remote.hosts),"/"], null)),postfix);
});

ona.utils.remote.make_zebra_url.cljs$lang$maxFixedArity = (0);

ona.utils.remote.make_zebra_url.cljs$lang$applyTo = (function (seq10947){
return ona.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10947));
});
/**
 * Build an API url.
 */
ona.utils.remote.make_j2x_url = (function ona$utils$remote$make_j2x_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return ona.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

ona.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return ona.utils.remote.url_join.call(null,ona.utils.remote.j2x_host_server,postfix);
});

ona.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

ona.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq10948){
return ona.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq10948));
});
ona.utils.remote.url_for_headers = (function ona$utils$remote$url_for_headers(headers,suffix){
return [cljs.core.str(ona.utils.remote.protocol),cljs.core.str("://"),cljs.core.str(headers.call(null,"host")),cljs.core.str(suffix)].join('');
});
