// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('ona.utils.remote');
goog.require('cljs.core');
goog.require('ona.utils.url');
goog.require('clojure.string');
ona.utils.remote.hosts = (function (){var G__32505 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$ui,"beta.ona.io",cljs.core.constant$keyword$data,"stage.ona.io",cljs.core.constant$keyword$ona_DASH_api_DASH_server_DASH_protocol,"https"], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32505) : cljs.core.atom.call(null,G__32505));
})();
ona.utils.remote.protocol = cljs.core.constant$keyword$ona_DASH_api_DASH_server_DASH_protocol.cljs$core$IFn$_invoke$arity$1((function (){var G__32506 = ona.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32506) : cljs.core.deref.call(null,G__32506));
})());
/**
 * Prefix the resources with the protocol and format strings.
 */
ona.utils.remote.protocol_prefixed_STAR_ = (function ona$utils$remote$protocol_prefixed_STAR_(resources){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [ona.utils.remote.protocol,"://",resources], null)));
});
ona.utils.remote.protocol_prefixed = cljs.core.memoize(ona.utils.remote.protocol_prefixed_STAR_);
ona.utils.remote.j2x_host = "j2x.ona.io";
ona.utils.remote.thumbor_host = "images.ona.io";
ona.utils.remote.forms_host = (function (){var G__32507 = (function (){var or__4276__auto__ = cljs.core.constant$keyword$forms.cljs$core$IFn$_invoke$arity$1((function (){var G__32509 = ona.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32509) : cljs.core.deref.call(null,G__32509));
})());
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.constant$keyword$data.cljs$core$IFn$_invoke$arity$1((function (){var G__32510 = ona.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32510) : cljs.core.deref.call(null,G__32510));
})());
}
})();
return (ona.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1 ? ona.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1(G__32507) : ona.utils.remote.protocol_prefixed.call(null,G__32507));
})();
ona.utils.remote.host_server = (function (){var G__32511 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$data.cljs$core$IFn$_invoke$arity$1((function (){var G__32512 = ona.utils.remote.hosts;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32512) : cljs.core.deref.call(null,G__32512));
})()),"/"], null);
return (ona.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1 ? ona.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1(G__32511) : ona.utils.remote.protocol_prefixed.call(null,G__32511));
})();
ona.utils.remote.j2x_host_server = (function (){var G__32513 = ona.utils.remote.j2x_host;
return (ona.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1 ? ona.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1(G__32513) : ona.utils.remote.protocol_prefixed.call(null,G__32513));
})();
ona.utils.remote.thumbor_server = (function (){var G__32514 = ona.utils.remote.thumbor_host;
return (ona.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1 ? ona.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1(G__32514) : ona.utils.remote.protocol_prefixed.call(null,G__32514));
})();
ona.utils.remote.url_join = (function ona$utils$remote$url_join(host,args){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [host], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(ona.utils.url.url,args)));
});
/**
 * Build an API url.
 */
ona.utils.remote.make_url = (function ona$utils$remote$make_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return ona.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

ona.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return ona.utils.remote.url_join([cljs.core.str(ona.utils.remote.host_server),cljs.core.str("api/v1")].join(''),postfix);
});

ona.utils.remote.make_url.cljs$lang$maxFixedArity = (0);

ona.utils.remote.make_url.cljs$lang$applyTo = (function (seq32515){
return ona.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32515));
});
/**
 * Build a Zebra url.
 */
ona.utils.remote.make_zebra_url = (function ona$utils$remote$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return ona.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

ona.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return ona.utils.remote.url_join((function (){var G__32517 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$ui.cljs$core$IFn$_invoke$arity$1(ona.utils.remote.hosts),"/"], null);
return (ona.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1 ? ona.utils.remote.protocol_prefixed.cljs$core$IFn$_invoke$arity$1(G__32517) : ona.utils.remote.protocol_prefixed.call(null,G__32517));
})(),postfix);
});

ona.utils.remote.make_zebra_url.cljs$lang$maxFixedArity = (0);

ona.utils.remote.make_zebra_url.cljs$lang$applyTo = (function (seq32516){
return ona.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32516));
});
/**
 * Build an API url.
 */
ona.utils.remote.make_j2x_url = (function ona$utils$remote$make_j2x_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return ona.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

ona.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
return ona.utils.remote.url_join(ona.utils.remote.j2x_host_server,postfix);
});

ona.utils.remote.make_j2x_url.cljs$lang$maxFixedArity = (0);

ona.utils.remote.make_j2x_url.cljs$lang$applyTo = (function (seq32518){
return ona.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32518));
});
ona.utils.remote.url_for_headers = (function ona$utils$remote$url_for_headers(headers,suffix){
return [cljs.core.str(ona.utils.remote.protocol),cljs.core.str("://"),cljs.core.str((function (){var G__32520 = "host";
return (headers.cljs$core$IFn$_invoke$arity$1 ? headers.cljs$core$IFn$_invoke$arity$1(G__32520) : headers.call(null,G__32520));
})()),cljs.core.str(suffix)].join('');
});
