// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('ona.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('ona.utils.remote');
goog.require('goog.events');
goog.require('dommy.core');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('clojure.string');
ona.api.io.make_url = ona.utils.remote.make_url;
ona.api.io.make_json_url = (function ona$api$io$make_json_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return ona.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

ona.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic = (function (args){

var bare_url = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(ona.api.io.make_url,args);
return [cljs.core.str(bare_url),cljs.core.str(".json")].join('');
});

ona.api.io.make_json_url.cljs$lang$maxFixedArity = (0);

ona.api.io.make_json_url.cljs$lang$applyTo = (function (seq32620){
return ona.api.io.make_json_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32620));
});
ona.api.io.refresh_token_url = (function ona$api$io$refresh_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/temp-token")].join('');
});
ona.api.io.validate_token_url = (function ona$api$io$validate_token_url(username){
return [cljs.core.str("/"),cljs.core.str(username),cljs.core.str("/validate-token")].join('');
});
/**
 * Build a url off of zebra
 */
ona.api.io.make_zebra_url = (function ona$api$io$make_zebra_url(){
var argseq__5316__auto__ = ((((0) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(0)),(0))):null);
return ona.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
});

ona.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic = (function (postfix){
var zebra_host = ((window["location"])["origin"]);
return ona.utils.remote.url_join(zebra_host,postfix);
});

ona.api.io.make_zebra_url.cljs$lang$maxFixedArity = (0);

ona.api.io.make_zebra_url.cljs$lang$applyTo = (function (seq32621){
return ona.api.io.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32621));
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
ona.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request)))))))))));
ona.api.io.raw_get = (function ona$api$io$raw_get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return ona.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

ona.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__32624){
var vec__32625 = p__32624;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32625,(0),null);

var G__32626 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (ona.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? ona.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__32626) : ona.api.io.raw_request.call(null,G__32626));
});

ona.api.io.raw_get.cljs$lang$maxFixedArity = (1);

ona.api.io.raw_get.cljs$lang$applyTo = (function (seq32622){
var G__32623 = cljs.core.first(seq32622);
var seq32622__$1 = cljs.core.next(seq32622);
return ona.api.io.raw_get.cljs$core$IFn$_invoke$arity$variadic(G__32623,seq32622__$1);
});
ona.api.io.raw_post = (function ona$api$io$raw_post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return ona.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

ona.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__32629){
var vec__32630 = p__32629;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32630,(0),null);

var G__32631 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (ona.api.io.raw_request.cljs$core$IFn$_invoke$arity$1 ? ona.api.io.raw_request.cljs$core$IFn$_invoke$arity$1(G__32631) : ona.api.io.raw_request.call(null,G__32631));
});

ona.api.io.raw_post.cljs$lang$maxFixedArity = (1);

ona.api.io.raw_post.cljs$lang$applyTo = (function (seq32627){
var G__32628 = cljs.core.first(seq32627);
var seq32627__$1 = cljs.core.next(seq32627);
return ona.api.io.raw_post.cljs$core$IFn$_invoke$arity$variadic(G__32628,seq32627__$1);
});
ona.api.io.token__GT_headers = (function ona$api$io$token__GT_headers(){
var G__32633 = arguments.length;
switch (G__32633) {
case 1:
return ona.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return ona.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

ona.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$1 = (function (token){
return ona.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(token,false);
});

ona.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2 = (function (token,get_crsftoken_QMARK_){
var headers = (cljs.core.truth_((function (){var and__4264__auto__ = token;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not(clojure.string.blank_QMARK_(token));
} else {
return and__4264__auto__;
}
})())?new cljs.core.PersistentArrayMap(null, 1, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(token)].join('')], null):null);
var temp__4124__auto__ = (function (){var and__4264__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__4264__auto__)){
var G__32634 = "csrftoken";
return goog.net.cookies.get(G__32634);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var crsf_token = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(headers,"X-CSRFToken",crsf_token);
} else {
return headers;
}
});

ona.api.io.token__GT_headers.cljs$lang$maxFixedArity = 2;
ona.api.io.query_helper = (function ona$api$io$query_helper(method){

return (function() {
var G__32648 = null;
var G__32648__1 = (function (url){
return ona$api$io$query_helper(method).call(null,url,null,null);
});
var G__32648__2 = (function (url,query_params){
return ona$api$io$query_helper(method).call(null,url,query_params,null);
});
var G__32648__4 = (function() { 
var G__32649__delegate = function (url,query_params,token,p__32643){
var map__32644 = p__32643;
var map__32644__$1 = ((cljs.core.seq_QMARK_(map__32644))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32644):map__32644);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32644__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var http_method = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.constant$keyword$get,cljs_http.client.get,cljs.core.constant$keyword$raw_DASH_get,ona.api.io.raw_get,cljs.core.constant$keyword$post,cljs_http.client.post,cljs.core.constant$keyword$raw_DASH_post,ona.api.io.raw_post,cljs.core.constant$keyword$delete,cljs_http.client.delete$,cljs.core.constant$keyword$put,cljs_http.client.put,cljs.core.constant$keyword$patch,cljs_http.client.patch], null).call(null,method);
var param_key = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$put,null], null), null),method))?cljs.core.constant$keyword$form_DASH_params:cljs.core.constant$keyword$query_DASH_params);
var headers = ona.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$2(token,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(http_method,cljs_http.client.delete$));
var time_params = (cljs.core.truth_(no_cache_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$t,(function (){var G__32645 = Date.now().toString();
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__32645) : cljs_hash.md5.md5.call(null,G__32645));
})()], null):null);
var query_params__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([query_params,time_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$xhr,true], null)], 0));
var G__32646 = url;
var G__32647 = new cljs.core.PersistentArrayMap.fromArray([cljs.core.constant$keyword$headers,headers,param_key,query_params__$1], true, false);
return (http_method.cljs$core$IFn$_invoke$arity$2 ? http_method.cljs$core$IFn$_invoke$arity$2(G__32646,G__32647) : http_method.call(null,G__32646,G__32647));
};
var G__32649 = function (url,query_params,token,var_args){
var p__32643 = null;
if (arguments.length > 3) {
var G__32650__i = 0, G__32650__a = new Array(arguments.length -  3);
while (G__32650__i < G__32650__a.length) {G__32650__a[G__32650__i] = arguments[G__32650__i + 3]; ++G__32650__i;}
  p__32643 = new cljs.core.IndexedSeq(G__32650__a,0);
} 
return G__32649__delegate.call(this,url,query_params,token,p__32643);};
G__32649.cljs$lang$maxFixedArity = 3;
G__32649.cljs$lang$applyTo = (function (arglist__32651){
var url = cljs.core.first(arglist__32651);
arglist__32651 = cljs.core.next(arglist__32651);
var query_params = cljs.core.first(arglist__32651);
arglist__32651 = cljs.core.next(arglist__32651);
var token = cljs.core.first(arglist__32651);
var p__32643 = cljs.core.rest(arglist__32651);
return G__32649__delegate(url,query_params,token,p__32643);
});
G__32649.cljs$core$IFn$_invoke$arity$variadic = G__32649__delegate;
return G__32649;
})()
;
G__32648 = function(url,query_params,token,var_args){
var p__32643 = var_args;
switch(arguments.length){
case 1:
return G__32648__1.call(this,url);
case 2:
return G__32648__2.call(this,url,query_params);
default:
var G__32652 = null;
if (arguments.length > 3) {
var G__32653__i = 0, G__32653__a = new Array(arguments.length -  3);
while (G__32653__i < G__32653__a.length) {G__32653__a[G__32653__i] = arguments[G__32653__i + 3]; ++G__32653__i;}
G__32652 = new cljs.core.IndexedSeq(G__32653__a,0);
}
return G__32648__4.cljs$core$IFn$_invoke$arity$variadic(url,query_params,token, G__32652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32648.cljs$lang$maxFixedArity = 3;
G__32648.cljs$lang$applyTo = G__32648__4.cljs$lang$applyTo;
G__32648.cljs$core$IFn$_invoke$arity$1 = G__32648__1;
G__32648.cljs$core$IFn$_invoke$arity$2 = G__32648__2;
G__32648.cljs$core$IFn$_invoke$arity$variadic = G__32648__4.cljs$core$IFn$_invoke$arity$variadic;
return G__32648;
})()
});
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
ona.api.io.raw_get_url = ona.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_get);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
ona.api.io.get_url = ona.api.io.query_helper(cljs.core.constant$keyword$get);
/**
 * Issues a DELETE request to a given url.
 */
ona.api.io.delete_url = ona.api.io.query_helper(cljs.core.constant$keyword$delete);
/**
 * Issues a PATCH request for updating information.
 */
ona.api.io.patch_url = ona.api.io.query_helper(cljs.core.constant$keyword$patch);
/**
 * GET a url (without decoding response); return channel w/ future response.
 */
ona.api.io.raw_post_url = ona.api.io.query_helper(cljs.core.constant$keyword$raw_DASH_post);
/**
 * GET a url AND decode the response; return channel w/ future response.
 */
ona.api.io.post_url = ona.api.io.query_helper(cljs.core.constant$keyword$post);
ona.api.io.put_url = ona.api.io.query_helper(cljs.core.constant$keyword$put);
ona.api.io.query_helper_BANG_ = (function ona$api$io$query_helper_BANG_(){
var G__32661 = arguments.length;
switch (G__32661) {
case 2:
return ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,4),(0)));
return ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5328__auto__);

}
});

ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (method,url){
return ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(url,method,null);
});

ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (method,url,callback){
return ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(method,url,callback,null);
});

ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (method,url,callback,query_params){
return ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(method,url,callback,query_params,cljs.core.array_seq([null], 0));
});

ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,callback,query_params,token,opts){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_32672){
var state_val_32673 = (state_32672[(1)]);
if((state_val_32673 === (5))){
var inst_32670 = (state_32672[(2)]);
var state_32672__$1 = state_32672;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32672__$1,inst_32670);
} else {
if((state_val_32673 === (4))){
var state_32672__$1 = state_32672;
var statearr_32674_32692 = state_32672__$1;
(statearr_32674_32692[(2)] = null);

(statearr_32674_32692[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32673 === (3))){
var inst_32665 = (state_32672[(7)]);
var inst_32667 = (function (){var G__32675 = inst_32665;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__32675) : callback.call(null,G__32675));
})();
var state_32672__$1 = state_32672;
var statearr_32676_32693 = state_32672__$1;
(statearr_32676_32693[(2)] = inst_32667);

(statearr_32676_32693[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32673 === (2))){
var inst_32665 = (state_32672[(2)]);
var state_32672__$1 = (function (){var statearr_32677 = state_32672;
(statearr_32677[(7)] = inst_32665);

return statearr_32677;
})();
if(cljs.core.truth_(callback)){
var statearr_32678_32694 = state_32672__$1;
(statearr_32678_32694[(1)] = (3));

} else {
var statearr_32679_32695 = state_32672__$1;
(statearr_32679_32695[(1)] = (4));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32673 === (1))){
var inst_32662 = ona.api.io.query_helper(method);
var inst_32663 = (function (){var G__32680 = url;
var G__32681 = query_params;
var G__32682 = token;
var G__32683 = opts;
return (inst_32662.cljs$core$IFn$_invoke$arity$4 ? inst_32662.cljs$core$IFn$_invoke$arity$4(G__32680,G__32681,G__32682,G__32683) : inst_32662.call(null,G__32680,G__32681,G__32682,G__32683));
})();
var state_32672__$1 = state_32672;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32672__$1,(2),inst_32663);
} else {
return null;
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var ona$api$io$state_machine__7648__auto__ = null;
var ona$api$io$state_machine__7648__auto____0 = (function (){
var statearr_32687 = [null,null,null,null,null,null,null,null];
(statearr_32687[(0)] = ona$api$io$state_machine__7648__auto__);

(statearr_32687[(1)] = (1));

return statearr_32687;
});
var ona$api$io$state_machine__7648__auto____1 = (function (state_32672){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_32672);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e32688){if((e32688 instanceof Object)){
var ex__7651__auto__ = e32688;
var statearr_32689_32696 = state_32672;
(statearr_32689_32696[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32672);

return cljs.core.constant$keyword$recur;
} else {
throw e32688;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__32697 = state_32672;
state_32672 = G__32697;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
ona$api$io$state_machine__7648__auto__ = function(state_32672){
switch(arguments.length){
case 0:
return ona$api$io$state_machine__7648__auto____0.call(this);
case 1:
return ona$api$io$state_machine__7648__auto____1.call(this,state_32672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ona$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = ona$api$io$state_machine__7648__auto____0;
ona$api$io$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = ona$api$io$state_machine__7648__auto____1;
return ona$api$io$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_32690 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_32690[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_32690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

ona.api.io.query_helper_BANG_.cljs$lang$applyTo = (function (seq32654){
var G__32655 = cljs.core.first(seq32654);
var seq32654__$1 = cljs.core.next(seq32654);
var G__32656 = cljs.core.first(seq32654__$1);
var seq32654__$2 = cljs.core.next(seq32654__$1);
var G__32657 = cljs.core.first(seq32654__$2);
var seq32654__$3 = cljs.core.next(seq32654__$2);
var G__32658 = cljs.core.first(seq32654__$3);
var seq32654__$4 = cljs.core.next(seq32654__$3);
var G__32659 = cljs.core.first(seq32654__$4);
var seq32654__$5 = cljs.core.next(seq32654__$4);
return ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32655,G__32656,G__32657,G__32658,G__32659,seq32654__$5);
});

ona.api.io.query_helper_BANG_.cljs$lang$maxFixedArity = 4;
ona.api.io.get_event = (function ona$api$io$get_event(){
var G__32699 = arguments.length;
switch (G__32699) {
case 1:
return ona.api.io.get_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return ona.api.io.get_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return ona.api.io.get_event.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

ona.api.io.get_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return ona.api.io.get_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

ona.api.io.get_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__32700 = event.target;
var G__32701 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__32700,G__32701) : dommy.core.attr.call(null,G__32700,G__32701));
})();
return ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,cljs.core.PersistentArrayMap.EMPTY);
});

ona.api.io.get_event.cljs$core$IFn$_invoke$arity$3 = (function (event,callback,params){
var url = (function (){var G__32702 = event.target.form;
var G__32703 = cljs.core.constant$keyword$action;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__32702,G__32703) : dommy.core.attr.call(null,G__32702,G__32703));
})();
return ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,callback,params);
});

ona.api.io.get_event.cljs$lang$maxFixedArity = 3;
ona.api.io.post_event = (function ona$api$io$post_event(){
var G__32706 = arguments.length;
switch (G__32706) {
case 1:
return ona.api.io.post_event.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return ona.api.io.post_event.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

ona.api.io.post_event.cljs$core$IFn$_invoke$arity$1 = (function (event){
return ona.api.io.post_event.cljs$core$IFn$_invoke$arity$2(event,null);
});

ona.api.io.post_event.cljs$core$IFn$_invoke$arity$2 = (function (event,callback){
var url = (function (){var G__32707 = event.target;
var G__32708 = cljs.core.constant$keyword$href;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__32707,G__32708) : dommy.core.attr.call(null,G__32707,G__32708));
})();
return ona.api.io.query_helper_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$post,url,callback);
});

ona.api.io.post_event.cljs$lang$maxFixedArity = 2;
/**
 * Checks if validate toke response returns invalid token message
 */
ona.api.io.invalid_token_QMARK_ = (function ona$api$io$invalid_token_QMARK_(response){
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$status.cljs$core$IFn$_invoke$arity$1(response),(403))) && ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Invalid token")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$body.cljs$core$IFn$_invoke$arity$1(response),"Token expired")))){
return true;
} else {
return null;
}
});
/**
 * Validates users auth-token on client
 */
ona.api.io.validate_token = (function ona$api$io$validate_token(auth_token,username){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_32843){
var state_val_32844 = (state_32843[(1)]);
if((state_val_32844 === (7))){
var inst_32808 = (state_32843[(2)]);
var state_32843__$1 = state_32843;
var statearr_32845_32890 = state_32843__$1;
(statearr_32845_32890[(2)] = inst_32808);

(statearr_32845_32890[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (20))){
var state_32843__$1 = state_32843;
var statearr_32846_32891 = state_32843__$1;
(statearr_32846_32891[(2)] = null);

(statearr_32846_32891[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (1))){
var inst_32800 = (state_32843[(7)]);
var inst_32800__$1 = (auth_token == null);
var state_32843__$1 = (function (){var statearr_32847 = state_32843;
(statearr_32847[(7)] = inst_32800__$1);

return statearr_32847;
})();
if(cljs.core.truth_(inst_32800__$1)){
var statearr_32848_32892 = state_32843__$1;
(statearr_32848_32892[(1)] = (2));

} else {
var statearr_32849_32893 = state_32843__$1;
(statearr_32849_32893[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (4))){
var inst_32810 = (state_32843[(2)]);
var state_32843__$1 = state_32843;
if(cljs.core.truth_(inst_32810)){
var statearr_32850_32894 = state_32843__$1;
(statearr_32850_32894[(1)] = (8));

} else {
var statearr_32851_32895 = state_32843__$1;
(statearr_32851_32895[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (15))){
var inst_32823 = (state_32843[(8)]);
var inst_32823__$1 = (state_32843[(2)]);
var inst_32824 = cljs.core.seq_QMARK_(inst_32823__$1);
var state_32843__$1 = (function (){var statearr_32852 = state_32843;
(statearr_32852[(8)] = inst_32823__$1);

return statearr_32852;
})();
if(inst_32824){
var statearr_32853_32896 = state_32843__$1;
(statearr_32853_32896[(1)] = (16));

} else {
var statearr_32854_32897 = state_32843__$1;
(statearr_32854_32897[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (21))){
var inst_32836 = (state_32843[(2)]);
var state_32843__$1 = state_32843;
var statearr_32855_32898 = state_32843__$1;
(statearr_32855_32898[(2)] = inst_32836);

(statearr_32855_32898[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (13))){
var state_32843__$1 = state_32843;
var statearr_32856_32899 = state_32843__$1;
(statearr_32856_32899[(2)] = auth_token);

(statearr_32856_32899[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (6))){
var inst_32806 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",auth_token);
var state_32843__$1 = state_32843;
var statearr_32857_32900 = state_32843__$1;
(statearr_32857_32900[(2)] = inst_32806);

(statearr_32857_32900[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (17))){
var inst_32823 = (state_32843[(8)]);
var state_32843__$1 = state_32843;
var statearr_32858_32901 = state_32843__$1;
(statearr_32858_32901[(2)] = inst_32823);

(statearr_32858_32901[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (3))){
var inst_32803 = (state_32843[(9)]);
var inst_32803__$1 = clojure.string.blank_QMARK_(auth_token);
var state_32843__$1 = (function (){var statearr_32859 = state_32843;
(statearr_32859[(9)] = inst_32803__$1);

return statearr_32859;
})();
if(cljs.core.truth_(inst_32803__$1)){
var statearr_32860_32902 = state_32843__$1;
(statearr_32860_32902[(1)] = (5));

} else {
var statearr_32861_32903 = state_32843__$1;
(statearr_32861_32903[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (12))){
var inst_32820 = ona.api.io.refresh_token_url(username);
var inst_32821 = (function (){var G__32862 = inst_32820;
var G__32863 = null;
var G__32864 = null;
var G__32865 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__32866 = true;
return (ona.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? ona.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__32862,G__32863,G__32864,G__32865,G__32866) : ona.api.io.get_url.call(null,G__32862,G__32863,G__32864,G__32865,G__32866));
})();
var state_32843__$1 = state_32843;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32843__$1,(15),inst_32821);
} else {
if((state_val_32844 === (2))){
var inst_32800 = (state_32843[(7)]);
var state_32843__$1 = state_32843;
var statearr_32867_32904 = state_32843__$1;
(statearr_32867_32904[(2)] = inst_32800);

(statearr_32867_32904[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (19))){
var inst_32830 = (state_32843[(10)]);
var state_32843__$1 = state_32843;
var statearr_32868_32905 = state_32843__$1;
(statearr_32868_32905[(2)] = inst_32830);

(statearr_32868_32905[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (11))){
var inst_32816 = (state_32843[(2)]);
var inst_32817 = ona.api.io.invalid_token_QMARK_(inst_32816);
var state_32843__$1 = state_32843;
if(cljs.core.truth_(inst_32817)){
var statearr_32869_32906 = state_32843__$1;
(statearr_32869_32906[(1)] = (12));

} else {
var statearr_32870_32907 = state_32843__$1;
(statearr_32870_32907[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (9))){
var inst_32813 = ona.api.io.validate_token_url(username);
var inst_32814 = (function (){var G__32871 = inst_32813;
var G__32872 = null;
var G__32873 = null;
var G__32874 = cljs.core.constant$keyword$no_DASH_cache_QMARK_;
var G__32875 = true;
return (ona.api.io.get_url.cljs$core$IFn$_invoke$arity$5 ? ona.api.io.get_url.cljs$core$IFn$_invoke$arity$5(G__32871,G__32872,G__32873,G__32874,G__32875) : ona.api.io.get_url.call(null,G__32871,G__32872,G__32873,G__32874,G__32875));
})();
var state_32843__$1 = state_32843;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32843__$1,(11),inst_32814);
} else {
if((state_val_32844 === (5))){
var inst_32803 = (state_32843[(9)]);
var state_32843__$1 = state_32843;
var statearr_32876_32908 = state_32843__$1;
(statearr_32876_32908[(2)] = inst_32803);

(statearr_32876_32908[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (14))){
var inst_32839 = (state_32843[(2)]);
var state_32843__$1 = state_32843;
var statearr_32877_32909 = state_32843__$1;
(statearr_32877_32909[(2)] = inst_32839);

(statearr_32877_32909[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (16))){
var inst_32823 = (state_32843[(8)]);
var inst_32826 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32823);
var state_32843__$1 = state_32843;
var statearr_32878_32910 = state_32843__$1;
(statearr_32878_32910[(2)] = inst_32826);

(statearr_32878_32910[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (10))){
var inst_32841 = (state_32843[(2)]);
var state_32843__$1 = state_32843;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32843__$1,inst_32841);
} else {
if((state_val_32844 === (18))){
var inst_32829 = (state_32843[(2)]);
var inst_32830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32829,cljs.core.constant$keyword$body);
var inst_32831 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32829,cljs.core.constant$keyword$status);
var inst_32832 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32831,(200));
var state_32843__$1 = (function (){var statearr_32879 = state_32843;
(statearr_32879[(10)] = inst_32830);

return statearr_32879;
})();
if(inst_32832){
var statearr_32880_32911 = state_32843__$1;
(statearr_32880_32911[(1)] = (19));

} else {
var statearr_32881_32912 = state_32843__$1;
(statearr_32881_32912[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32844 === (8))){
var state_32843__$1 = state_32843;
var statearr_32882_32913 = state_32843__$1;
(statearr_32882_32913[(2)] = null);

(statearr_32882_32913[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var ona$api$io$validate_token_$_state_machine__7648__auto__ = null;
var ona$api$io$validate_token_$_state_machine__7648__auto____0 = (function (){
var statearr_32886 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32886[(0)] = ona$api$io$validate_token_$_state_machine__7648__auto__);

(statearr_32886[(1)] = (1));

return statearr_32886;
});
var ona$api$io$validate_token_$_state_machine__7648__auto____1 = (function (state_32843){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_32843);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e32887){if((e32887 instanceof Object)){
var ex__7651__auto__ = e32887;
var statearr_32888_32914 = state_32843;
(statearr_32888_32914[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32843);

return cljs.core.constant$keyword$recur;
} else {
throw e32887;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__32915 = state_32843;
state_32843 = G__32915;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
ona$api$io$validate_token_$_state_machine__7648__auto__ = function(state_32843){
switch(arguments.length){
case 0:
return ona$api$io$validate_token_$_state_machine__7648__auto____0.call(this);
case 1:
return ona$api$io$validate_token_$_state_machine__7648__auto____1.call(this,state_32843);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ona$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = ona$api$io$validate_token_$_state_machine__7648__auto____0;
ona$api$io$validate_token_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = ona$api$io$validate_token_$_state_machine__7648__auto____1;
return ona$api$io$validate_token_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_32889 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_32889[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_32889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Use google library to upload file
 */
ona.api.io.upload_file = (function ona$api$io$upload_file(form,chan){
var io_obj = (new goog.net.IframeIo());
var url = form.action;
var G__32922_32928 = io_obj;
var G__32923_32929 = goog.net.EventType.SUCCESS;
var G__32924_32930 = ((function (G__32922_32928,G__32923_32929,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,true,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__32922_32928,G__32923_32929,io_obj,url))
;
goog.events.listen(G__32922_32928,G__32923_32929,G__32924_32930);

var G__32925_32931 = io_obj;
var G__32926_32932 = goog.net.EventType.ERROR;
var G__32927_32933 = ((function (G__32925_32931,G__32926_32932,io_obj,url){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$success_QMARK_,false,cljs.core.constant$keyword$io_DASH_obj,io_obj], null));
});})(G__32925_32931,G__32926_32932,io_obj,url))
;
goog.events.listen(G__32925_32931,G__32926_32932,G__32927_32933);

return io_obj.sendFromForm(form,url);
});
