// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('ona.api.dataset');
goog.require('cljs.core');
goog.require('ona.utils.remote');
goog.require('ona.utils.seq');
goog.require('ona.api.http');
goog.require('ona.api.io');
/**
 * Return all the datasets for an account.
 */
ona.api.dataset.all = (function ona$api$dataset$all(account){
var url = (function (){var G__32534 = [cljs.core.str("forms?owner="),cljs.core.str(cljs.core.constant$keyword$username.cljs$core$IFn$_invoke$arity$1(account))].join('');
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$1 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$1(G__32534) : ona.api.io.make_url.call(null,G__32534));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Return all public datasets for a specific user.
 */
ona.api.dataset.public$ = (function ona$api$dataset$public(account,username){
var url = (function (){var G__32537 = "forms";
var G__32538 = username;
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__32537,G__32538) : ona.api.io.make_url.call(null,G__32537,G__32538));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Set the metadata for a dataset using PUT. All parameters must be passed.
 */
ona.api.dataset.update = (function ona$api$dataset$update(account,dataset_id,params){
if(cljs.core.truth_(ona.utils.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$created_by,cljs.core.constant$keyword$description,cljs.core.constant$keyword$downloadable,cljs.core.constant$keyword$owner,cljs.core.constant$keyword$project,cljs.core.constant$keyword$public,cljs.core.constant$keyword$public_data,cljs.core.constant$keyword$title,cljs.core.constant$keyword$uuid], null)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"has-keys?","has-keys?",-2012545374,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$created_by,cljs.core.constant$keyword$description,cljs.core.constant$keyword$downloadable,cljs.core.constant$keyword$owner,cljs.core.constant$keyword$project,cljs.core.constant$keyword$public,cljs.core.constant$keyword$public_data,cljs.core.constant$keyword$title,cljs.core.constant$keyword$uuid], null))], 0)))].join('')));
}

var url = (function (){var G__32541 = "forms";
var G__32542 = dataset_id;
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__32541,G__32542) : ona.api.io.make_url.call(null,G__32541,G__32542));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$put,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null));
});
/**
 * Update the title of a form
 */
ona.api.dataset.update_form_name = (function ona$api$dataset$update_form_name(account,dataset_id,params){
var url = (function (){var G__32545 = "forms";
var G__32546 = dataset_id;
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__32545,G__32546) : ona.api.io.make_url.call(null,G__32545,G__32546));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$put,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,params], null));
});
/**
 * Return the data associated with a dataset.
 */
ona.api.dataset.data = (function ona$api$dataset$data(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return ona.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

ona.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic = (function (account,dataset_id,p__32550){
var map__32551 = p__32550;
var map__32551__$1 = ((cljs.core.seq_QMARK_(map__32551))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32551):map__32551);
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32551__$1,cljs.core.constant$keyword$raw_QMARK_);
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32551__$1,cljs.core.constant$keyword$format,"json");
var dataset_suffix = (cljs.core.truth_(format)?[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format)].join(''):dataset_id);
var url = (function (){var G__32552 = "data";
var G__32553 = dataset_suffix;
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__32552,G__32553) : ona.api.io.make_url.call(null,G__32552,G__32553));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$get,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$raw_DASH_response_QMARK_,raw_QMARK_], null));
});

ona.api.dataset.data.cljs$lang$maxFixedArity = (2);

ona.api.dataset.data.cljs$lang$applyTo = (function (seq32547){
var G__32548 = cljs.core.first(seq32547);
var seq32547__$1 = cljs.core.next(seq32547);
var G__32549 = cljs.core.first(seq32547__$1);
var seq32547__$2 = cljs.core.next(seq32547__$1);
return ona.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic(G__32548,G__32549,seq32547__$2);
});
/**
 * Retrieve a record from the dataset.
 */
ona.api.dataset.record = (function ona$api$dataset$record(account,dataset_id,record_id){
var url = (function (){var G__32557 = "data";
var G__32558 = dataset_id;
var G__32559 = record_id;
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__32557,G__32558,G__32559) : ona.api.io.make_url.call(null,G__32557,G__32558,G__32559));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Returns tags for a dataset
 */
ona.api.dataset.tags = (function ona$api$dataset$tags(account,dataset_id){
var url = (function (){var G__32563 = "forms";
var G__32564 = dataset_id;
var G__32565 = "labels";
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__32563,G__32564,G__32565) : ona.api.io.make_url.call(null,G__32563,G__32564,G__32565));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Add tags to a dataset
 */
ona.api.dataset.add_tags = (function ona$api$dataset$add_tags(account,dataset_id,tags){
var url = (function (){var G__32569 = "forms";
var G__32570 = dataset_id;
var G__32571 = "labels";
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__32569,G__32570,G__32571) : ona.api.io.make_url.call(null,G__32569,G__32570,G__32571));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,tags], null));
});
/**
 * Return filename taking format special cases into account.
 */
ona.api.dataset.filename_for_format = (function ona$api$dataset$filename_for_format(dataset_id,format){
return [cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(format,"csvzip"))?"zip":format))].join('');
});
/**
 * Return options needed to handle format.
 */
ona.api.dataset.options_for_format = (function ona$api$dataset$options_for_format(format){
if(cljs.core.truth_(ona.utils.seq.in_QMARK_(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["csvzip","sav","xls","xlsx"], null),format))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$as,cljs.core.constant$keyword$byte_DASH_array], null);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
/**
 * Download form as JSON string or file in specified format if format passed.
 */
ona.api.dataset.form = (function ona$api$dataset$form(){
var G__32573 = arguments.length;
switch (G__32573) {
case 2:
return ona.api.dataset.form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return ona.api.dataset.form.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

ona.api.dataset.form.cljs$core$IFn$_invoke$arity$2 = (function (account,dataset_id){
var url = (function (){var G__32574 = "forms";
var G__32575 = dataset_id;
var G__32576 = "form.json";
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__32574,G__32575,G__32576) : ona.api.io.make_url.call(null,G__32574,G__32575,G__32576));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});

ona.api.dataset.form.cljs$core$IFn$_invoke$arity$3 = (function (account,dataset_id,format){
var suffix = [cljs.core.str("form."),cljs.core.str(format)].join('');
var options = ona.api.dataset.options_for_format(format);
var url = (function (){var G__32577 = "forms";
var G__32578 = dataset_id;
var G__32579 = suffix;
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__32577,G__32578,G__32579) : ona.api.io.make_url.call(null,G__32577,G__32578,G__32579));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$5(cljs.core.constant$keyword$get,url,account,options,[cljs.core.str(dataset_id),cljs.core.str("_"),cljs.core.str(suffix)].join(''));
});

ona.api.dataset.form.cljs$lang$maxFixedArity = 3;
/**
 * Show dataset metadata.
 */
ona.api.dataset.metadata = (function ona$api$dataset$metadata(account,dataset_id){
var url = (function (){var G__32583 = "forms";
var G__32584 = dataset_id;
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__32583,G__32584) : ona.api.io.make_url.call(null,G__32583,G__32584));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account);
});
/**
 * Return link to online data entry.
 */
ona.api.dataset.edit_link = (function ona$api$dataset$edit_link(account,dataset_id,instance_id){
var zebra_blank = ona.utils.remote.make_zebra_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["blank"], 0));
var url = (function (){var G__32589 = "data";
var G__32590 = dataset_id;
var G__32591 = instance_id;
var G__32592 = [cljs.core.str("enketo?return_url="),cljs.core.str(zebra_blank)].join('');
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$4 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$4(G__32589,G__32590,G__32591,G__32592) : ona.api.io.make_url.call(null,G__32589,G__32590,G__32591,G__32592));
})();
return cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$get,url,account));
});
/**
 * Delete a dataset by ID.
 */
ona.api.dataset.delete$ = (function ona$api$dataset$delete(account,dataset_id){
var url = (function (){var G__32596 = "forms";
var G__32597 = dataset_id;
var G__32598 = "delete_async";
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__32596,G__32597,G__32598) : ona.api.io.make_url.call(null,G__32596,G__32597,G__32598));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$delete,url,account);
});
/**
 * Move a dataset to a project use account if no owner passed.
 */
ona.api.dataset.move_to_project = (function ona$api$dataset$move_to_project(account,dataset_id,project_id){
var url = (function (){var G__32602 = "projects";
var G__32603 = project_id;
var G__32604 = "forms";
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__32602,G__32603,G__32604) : ona.api.io.make_url.call(null,G__32602,G__32603,G__32604));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$formid,dataset_id], null)], null));
});
/**
 * Share dataset with specific user
 */
ona.api.dataset.update_sharing = (function ona$api$dataset$update_sharing(account,dataset_id,username,role){
var url = (function (){var G__32608 = "forms";
var G__32609 = dataset_id;
var G__32610 = "share";
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$3(G__32608,G__32609,G__32610) : ona.api.io.make_url.call(null,G__32608,G__32609,G__32610));
})();
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$username,username,cljs.core.constant$keyword$role,role], null);
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,data], null));
});
/**
 * Add xls report link to dataset
 */
ona.api.dataset.add_xls_report = (function ona$api$dataset$add_xls_report(account,dataset_id,uuid,filename){
var xls_url = ona.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["xls",uuid], 0));
var url = (function (){var G__32612 = "metadata";
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$1 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$1(G__32612) : ona.api.io.make_url.call(null,G__32612));
})();
var data = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$xform,dataset_id,cljs.core.constant$keyword$data_type,"external_export",cljs.core.constant$keyword$data_value,[cljs.core.str(filename),cljs.core.str("|"),cljs.core.str(xls_url)].join('')], null);
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$4(cljs.core.constant$keyword$post,url,account,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,data], null));
});
/**
 * Download xls report from the j2x service
 */
ona.api.dataset.download_xls_report = (function ona$api$dataset$download_xls_report(){
var G__32614 = arguments.length;
switch (G__32614) {
case 4:
return ona.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return ona.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

ona.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4 = (function (account,dataset_id,meta_id,filename){
return ona.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$5(account,dataset_id,meta_id,filename,null);
});

ona.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$5 = (function (account,dataset_id,meta_id,filename,data_id){
var suffix = (cljs.core.truth_(data_id)?[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id),cljs.core.str("&data_id="),cljs.core.str(data_id)].join(''):[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id)].join(''));
var url = (function (){var G__32615 = "forms";
var G__32616 = suffix;
return (ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2 ? ona.api.io.make_url.cljs$core$IFn$_invoke$arity$2(G__32615,G__32616) : ona.api.io.make_url.call(null,G__32615,G__32616));
})();
return ona.api.http.parse_http.cljs$core$IFn$_invoke$arity$5(cljs.core.constant$keyword$get,url,account,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$as,cljs.core.constant$keyword$byte_DASH_array,cljs.core.constant$keyword$as_DASH_map_QMARK_,true], null),filename);
});

ona.api.dataset.download_xls_report.cljs$lang$maxFixedArity = 5;
