// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('dommy.template');
goog.require('dommy.attrs');
goog.require('dommy.utils');
goog.require('clojure.string');
dommy.core.has_class_QMARK_ = dommy.attrs.has_class_QMARK_;
dommy.core.add_class_BANG_ = dommy.attrs.add_class_BANG_;
dommy.core.remove_class_BANG_ = dommy.attrs.remove_class_BANG_;
dommy.core.toggle_class_BANG_ = dommy.attrs.toggle_class_BANG_;
dommy.core.set_attr_BANG_ = dommy.attrs.set_attr_BANG_;
dommy.core.set_style_BANG_ = dommy.attrs.set_style_BANG_;
dommy.core.set_px_BANG_ = dommy.attrs.set_px_BANG_;
dommy.core.px = dommy.attrs.px;
dommy.core.style_str = dommy.attrs.style_str;
dommy.core.style = dommy.attrs.style;
dommy.core.remove_attr_BANG_ = dommy.attrs.remove_attr_BANG_;
dommy.core.toggle_attr_BANG_ = dommy.attrs.toggle_attr_BANG_;
dommy.core.attr = dommy.attrs.attr;
dommy.core.hidden_QMARK_ = dommy.attrs.hidden_QMARK_;
dommy.core.toggle_BANG_ = dommy.attrs.toggle_BANG_;
dommy.core.hide_BANG_ = dommy.attrs.hide_BANG_;
dommy.core.show_BANG_ = dommy.attrs.show_BANG_;
dommy.core.bounding_client_rect = dommy.attrs.bounding_client_rect;
dommy.core.scroll_into_view = dommy.attrs.scroll_into_view;
dommy.core.dissoc_in = dommy.utils.dissoc_in;
dommy.core.__GT_Array = dommy.utils.__GT_Array;
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
var elem__$1 = dommy.template.__GT_node_like(elem);
elem__$1.innerHTML = html;

return elem__$1;
});
dommy.core.html = (function dommy$core$html(elem){
return dommy.template.__GT_node_like(elem).innerHTML;
});
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
var elem__$1 = dommy.template.__GT_node_like(elem);
var prop = (cljs.core.truth_(elem__$1.textContent)?"textContent":"innerText");
(elem__$1[prop] = text);

return elem__$1;
});
dommy.core.text = (function dommy$core$text(elem){
var or__4276__auto__ = elem.textContent;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return elem.innerText;
}
});
dommy.core.value = (function dommy$core$value(elem){
return dommy.template.__GT_node_like(elem).value;
});
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
var elem__$1 = dommy.template.__GT_node_like(elem);
elem__$1.value = value;

return elem__$1;
});
/**
 * append `child` to `parent`. 'parent' and 'child' should be node-like
 * (work with dommy.template/->node-like). The node-like projection
 * of parent is returned after appending child.
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(){
var G__28864 = arguments.length;
switch (G__28864) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__28865 = dommy.template.__GT_node_like(parent);
G__28865.appendChild(dommy.template.__GT_node_like(child));

return G__28865;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like(parent);
var seq__28866_28871 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__28867_28872 = null;
var count__28868_28873 = (0);
var i__28869_28874 = (0);
while(true){
if((i__28869_28874 < count__28868_28873)){
var c_28875 = chunk__28867_28872.cljs$core$IIndexed$_nth$arity$2(null,i__28869_28874);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_28875);

var G__28876 = seq__28866_28871;
var G__28877 = chunk__28867_28872;
var G__28878 = count__28868_28873;
var G__28879 = (i__28869_28874 + (1));
seq__28866_28871 = G__28876;
chunk__28867_28872 = G__28877;
count__28868_28873 = G__28878;
i__28869_28874 = G__28879;
continue;
} else {
var temp__4126__auto___28880 = cljs.core.seq(seq__28866_28871);
if(temp__4126__auto___28880){
var seq__28866_28881__$1 = temp__4126__auto___28880;
if(cljs.core.chunked_seq_QMARK_(seq__28866_28881__$1)){
var c__5061__auto___28882 = cljs.core.chunk_first(seq__28866_28881__$1);
var G__28883 = cljs.core.chunk_rest(seq__28866_28881__$1);
var G__28884 = c__5061__auto___28882;
var G__28885 = cljs.core.count(c__5061__auto___28882);
var G__28886 = (0);
seq__28866_28871 = G__28883;
chunk__28867_28872 = G__28884;
count__28868_28873 = G__28885;
i__28869_28874 = G__28886;
continue;
} else {
var c_28887 = cljs.core.first(seq__28866_28881__$1);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_28887);

var G__28888 = cljs.core.next(seq__28866_28881__$1);
var G__28889 = null;
var G__28890 = (0);
var G__28891 = (0);
seq__28866_28871 = G__28888;
chunk__28867_28872 = G__28889;
count__28868_28873 = G__28890;
i__28869_28874 = G__28891;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq28860){
var G__28861 = cljs.core.first(seq28860);
var seq28860__$1 = cljs.core.next(seq28860);
var G__28862 = cljs.core.first(seq28860__$1);
var seq28860__$2 = cljs.core.next(seq28860__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28861,G__28862,seq28860__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * prepend `child` to `parent`, both node-like
 * return ->node-like projection of `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(){
var G__28896 = arguments.length;
switch (G__28896) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var parent__$1 = dommy.template.__GT_node_like(parent);
return parent__$1.insertBefore(dommy.template.__GT_node_like(child),parent__$1.firstChild);
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var parent__$1 = dommy.template.__GT_node_like(parent);
var seq__28897_28902 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__28898_28903 = null;
var count__28899_28904 = (0);
var i__28900_28905 = (0);
while(true){
if((i__28900_28905 < count__28899_28904)){
var c_28906 = chunk__28898_28903.cljs$core$IIndexed$_nth$arity$2(null,i__28900_28905);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_28906);

var G__28907 = seq__28897_28902;
var G__28908 = chunk__28898_28903;
var G__28909 = count__28899_28904;
var G__28910 = (i__28900_28905 + (1));
seq__28897_28902 = G__28907;
chunk__28898_28903 = G__28908;
count__28899_28904 = G__28909;
i__28900_28905 = G__28910;
continue;
} else {
var temp__4126__auto___28911 = cljs.core.seq(seq__28897_28902);
if(temp__4126__auto___28911){
var seq__28897_28912__$1 = temp__4126__auto___28911;
if(cljs.core.chunked_seq_QMARK_(seq__28897_28912__$1)){
var c__5061__auto___28913 = cljs.core.chunk_first(seq__28897_28912__$1);
var G__28914 = cljs.core.chunk_rest(seq__28897_28912__$1);
var G__28915 = c__5061__auto___28913;
var G__28916 = cljs.core.count(c__5061__auto___28913);
var G__28917 = (0);
seq__28897_28902 = G__28914;
chunk__28898_28903 = G__28915;
count__28899_28904 = G__28916;
i__28900_28905 = G__28917;
continue;
} else {
var c_28918 = cljs.core.first(seq__28897_28912__$1);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent__$1,c_28918);

var G__28919 = cljs.core.next(seq__28897_28912__$1);
var G__28920 = null;
var G__28921 = (0);
var G__28922 = (0);
seq__28897_28902 = G__28919;
chunk__28898_28903 = G__28920;
count__28899_28904 = G__28921;
i__28900_28905 = G__28922;
continue;
}
} else {
}
}
break;
}

return parent__$1;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq28892){
var G__28893 = cljs.core.first(seq28892);
var seq28892__$1 = cljs.core.next(seq28892);
var G__28894 = cljs.core.first(seq28892__$1);
var seq28892__$2 = cljs.core.next(seq28892__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28893,G__28894,seq28892__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * insert `node` before `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like(elem);
var other__$1 = dommy.template.__GT_node_like(other);
if(cljs.core.truth_(other__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"other","other",-1658642225,null))], 0)))].join('')));
}

other__$1.parentNode.insertBefore(actual_node,other__$1);

return actual_node;
});
/**
 * insert `node` after `other`, both node-like,
 * `other` must have a parent. return `node`
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var actual_node = dommy.template.__GT_node_like(elem);
var other__$1 = dommy.template.__GT_node_like(other);
var parent = other__$1.parentNode;
var temp__4124__auto___28923 = other__$1.nextSibling;
if(cljs.core.truth_(temp__4124__auto___28923)){
var next_28924 = temp__4124__auto___28923;
parent.insertBefore(actual_node,next_28924);
} else {
parent.appendChild(actual_node);
}

return actual_node;
});
/**
 * replace `elem` with `new`, both node-like, return node-like projection of new.
 * node-like projection of elem must have parent.
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var new$__$1 = dommy.template.__GT_node_like(new$);
var elem__$1 = dommy.template.__GT_node_like(elem);
if(cljs.core.truth_(elem__$1.parentNode)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,".-parentNode",".-parentNode",-1418255893,null),new cljs.core.Symbol(null,"elem","elem",-2035804713,null))], 0)))].join('')));
}

elem__$1.parentNode.replaceChild(new$__$1,elem__$1);

return new$__$1;
});
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(parent,node_like){
var G__28926 = dommy.template.__GT_node_like(parent);
G__28926.innerHTML = "";

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(G__28926,node_like);

return G__28926;
});
/**
 * remove node-like `elem` from parent, return node-like projection of elem
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(elem){
var elem__$1 = dommy.template.__GT_node_like(elem);
var G__28928 = elem__$1.parentNode;
G__28928.removeChild(elem__$1);

return G__28928;
});
/**
 * clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.template.__GT_node_like(elem).innerHTML = "";
});
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_(data)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(dommy$core$selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name(data);
} else {
return null;
}
}
});
dommy.core.selector_map = (function dommy$core$selector_map(template,key_selectors_map){
var container = dommy.template.__GT_node_like(template);
if(!(cljs.core.contains_QMARK_(key_selectors_map,cljs.core.constant$keyword$container))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),cljs.core.list(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol(null,"key-selectors-map","key-selectors-map",1212911103,null),cljs.core.constant$keyword$container))], 0)))].join('')));
}

return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$container,container], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (container){
return (function (p__28934){
var vec__28935 = p__28934;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28935,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28935,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(cljs.core.truth_(cljs.core.constant$keyword$live.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v)))?(function (){
if(typeof dommy.core.t28936 !== 'undefined'){
} else {

/**
* @constructor
*/
dommy.core.t28936 = (function (v,k,vec__28935,p__28934,container,key_selectors_map,template,selector_map,meta28937){
this.v = v;
this.k = k;
this.vec__28935 = vec__28935;
this.p__28934 = p__28934;
this.container = container;
this.key_selectors_map = key_selectors_map;
this.template = template;
this.selector_map = selector_map;
this.meta28937 = meta28937;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 425984;
})
dommy.core.t28936.prototype.cljs$core$IDeref$_deref$arity$1 = ((function (vec__28935,k,v,container){
return (function (this$){
var self__ = this;
var this$__$1 = this;
return dommy.utils.__GT_Array(dommy.template.__GT_node_like(self__.container).querySelectorAll(dommy.core.selector(self__.v)));
});})(vec__28935,k,v,container))
;

dommy.core.t28936.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (vec__28935,k,v,container){
return (function (_28938){
var self__ = this;
var _28938__$1 = this;
return self__.meta28937;
});})(vec__28935,k,v,container))
;

dommy.core.t28936.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (vec__28935,k,v,container){
return (function (_28938,meta28937__$1){
var self__ = this;
var _28938__$1 = this;
return (new dommy.core.t28936(self__.v,self__.k,self__.vec__28935,self__.p__28934,self__.container,self__.key_selectors_map,self__.template,self__.selector_map,meta28937__$1));
});})(vec__28935,k,v,container))
;

dommy.core.t28936.cljs$lang$type = true;

dommy.core.t28936.cljs$lang$ctorStr = "dommy.core/t28936";

dommy.core.t28936.cljs$lang$ctorPrWriter = ((function (vec__28935,k,v,container){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"dommy.core/t28936");
});})(vec__28935,k,v,container))
;

dommy.core.__GT_t28936 = ((function (vec__28935,k,v,container){
return (function dommy$core$selector_map_$___GT_t28936(v__$1,k__$1,vec__28935__$1,p__28934__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta28937){
return (new dommy.core.t28936(v__$1,k__$1,vec__28935__$1,p__28934__$1,container__$1,key_selectors_map__$1,template__$1,selector_map__$1,meta28937));
});})(vec__28935,k,v,container))
;

}

return (new dommy.core.t28936(v,k,vec__28935,p__28934,container,key_selectors_map,template,dommy$core$selector_map,cljs.core.PersistentArrayMap.EMPTY));
})()
:dommy.template.__GT_node_like(container).querySelector(dommy.core.selector(v)))], null);
});})(container))
,key_selectors_map))], 0));
});
/**
 * a lazy seq of the ancestors of `node`
 */
dommy.core.ancestor_nodes = (function dommy$core$ancestor_nodes(elem){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate((function (p1__28939_SHARP_){
return p1__28939_SHARP_.parentNode;
}),dommy.template.__GT_node_like(elem)));
});
/**
 * returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(){
var G__28941 = arguments.length;
switch (G__28941) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array(dommy.template.__GT_node_like(dommy.template.__GT_node_like(base)).querySelectorAll(dommy.core.selector(selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;
/**
 * closest ancestor of `node` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(){
var G__28945 = arguments.length;
switch (G__28945) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
var base__$1 = dommy.template.__GT_node_like(base);
var elem__$1 = dommy.template.__GT_node_like(elem);
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(base__$1,selector),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (base__$1,elem__$1){
return (function (p1__28943_SHARP_){
return !((p1__28943_SHARP_ === base__$1));
});})(base__$1,elem__$1))
,dommy.core.ancestor_nodes(elem__$1))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1(selector),dommy.core.ancestor_nodes(dommy.template.__GT_node_like(elem))));
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;
/**
 * is `descendant` a descendant of `ancestor`?
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
var descendant__$1 = dommy.template.__GT_node_like(descendant);
var ancestor__$1 = dommy.template.__GT_node_like(ancestor);
if(cljs.core.truth_(ancestor__$1.contains)){
return ancestor__$1.contains(descendant__$1);
} else {
if(cljs.core.truth_(ancestor__$1.compareDocumentPosition)){
return ((ancestor__$1.compareDocumentPosition(descendant__$1) & (1 << (4))) != 0);
} else {
return null;
}
}
});
dommy.core.special_listener_makers = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__28947){
var vec__28948 = p__28947;
var special_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28948,(0),null);
var real_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28948,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,new cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__28948,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__28948,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4276__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4264__auto__ = related_target;
if(cljs.core.truth_(and__4264__auto__)){
return dommy.core.descendant_QMARK_(related_target,listener_target);
} else {
return and__4264__auto__;
}
})())){
return null;
} else {
var G__28949 = event;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__28949) : f.call(null,G__28949));
}
});
;})(vec__28948,special_mouse_event,real_mouse_event))
});})(vec__28948,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$mouseenter,cljs.core.constant$keyword$mouseover,cljs.core.constant$keyword$mouseleave,cljs.core.constant$keyword$mouseout], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.cljs$core$IFn$_invoke$arity$3(dommy.template.__GT_node_like(elem),event.target,selector);
if(cljs.core.truth_((function (){var and__4264__auto__ = selected_target;
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.not((function (){var G__28953 = selected_target;
var G__28954 = cljs.core.constant$keyword$disabled;
return (dommy.core.attr.cljs$core$IFn$_invoke$arity$2 ? dommy.core.attr.cljs$core$IFn$_invoke$arity$2(G__28953,G__28954) : dommy.core.attr.call(null,G__28953,G__28954));
})());
} else {
return and__4264__auto__;
}
})())){
event.selectedTarget = selected_target;

var G__28955 = event;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__28955) : f.call(null,G__28955));
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `nodes`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4276__auto__ = dommy.template.__GT_node_like(elem).dommyEventListeners;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = dommy.template.__GT_node_like(elem);
return elem__$1.dommyEventListeners = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,dommy.core.event_listeners(elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq28956){
var G__28957 = cljs.core.first(seq28956);
var seq28956__$1 = cljs.core.next(seq28956);
var G__28958 = cljs.core.first(seq28956__$1);
var seq28956__$2 = cljs.core.next(seq28956__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28957,G__28958,seq28956__$2);
});
dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_(elem_sel)){
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((function (p1__28959_SHARP_){
return dommy.template.__GT_node_like(cljs.core.first(p1__28959_SHARP_));
}),cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dommy.template.__GT_node_like(elem_sel),null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 * (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 * (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 * (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__28962_28989 = dommy.core.elem_and_selector(elem_sel);
var elem_28990 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28962_28989,(0),null);
var selector_28991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28962_28989,(1),null);
var seq__28963_28992 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__28970_28993 = null;
var count__28971_28994 = (0);
var i__28972_28995 = (0);
while(true){
if((i__28972_28995 < count__28971_28994)){
var vec__28979_28996 = chunk__28970_28993.cljs$core$IIndexed$_nth$arity$2(null,i__28972_28995);
var orig_type_28997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28979_28996,(0),null);
var f_28998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28979_28996,(1),null);
var seq__28973_28999 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_28997,new cljs.core.PersistentArrayMap.fromArray([orig_type_28997,cljs.core.identity], true, false)));
var chunk__28975_29000 = null;
var count__28976_29001 = (0);
var i__28977_29002 = (0);
while(true){
if((i__28977_29002 < count__28976_29001)){
var vec__28980_29003 = chunk__28975_29000.cljs$core$IIndexed$_nth$arity$2(null,i__28977_29002);
var actual_type_29004 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28980_29003,(0),null);
var factory_29005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28980_29003,(1),null);
var canonical_f_29006 = (cljs.core.truth_(selector_28991)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_28990,selector_28991):cljs.core.identity).call(null,(function (){var G__28981 = f_28998;
return (factory_29005.cljs$core$IFn$_invoke$arity$1 ? factory_29005.cljs$core$IFn$_invoke$arity$1(G__28981) : factory_29005.call(null,G__28981));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_28990,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_28991,actual_type_29004,f_28998], null),canonical_f_29006], 0));

if(cljs.core.truth_(elem_28990.addEventListener)){
elem_28990.addEventListener(cljs.core.name(actual_type_29004),canonical_f_29006);
} else {
elem_28990.attachEvent(cljs.core.name(actual_type_29004),canonical_f_29006);
}

var G__29007 = seq__28973_28999;
var G__29008 = chunk__28975_29000;
var G__29009 = count__28976_29001;
var G__29010 = (i__28977_29002 + (1));
seq__28973_28999 = G__29007;
chunk__28975_29000 = G__29008;
count__28976_29001 = G__29009;
i__28977_29002 = G__29010;
continue;
} else {
var temp__4126__auto___29011 = cljs.core.seq(seq__28973_28999);
if(temp__4126__auto___29011){
var seq__28973_29012__$1 = temp__4126__auto___29011;
if(cljs.core.chunked_seq_QMARK_(seq__28973_29012__$1)){
var c__5061__auto___29013 = cljs.core.chunk_first(seq__28973_29012__$1);
var G__29014 = cljs.core.chunk_rest(seq__28973_29012__$1);
var G__29015 = c__5061__auto___29013;
var G__29016 = cljs.core.count(c__5061__auto___29013);
var G__29017 = (0);
seq__28973_28999 = G__29014;
chunk__28975_29000 = G__29015;
count__28976_29001 = G__29016;
i__28977_29002 = G__29017;
continue;
} else {
var vec__28982_29018 = cljs.core.first(seq__28973_29012__$1);
var actual_type_29019 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28982_29018,(0),null);
var factory_29020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28982_29018,(1),null);
var canonical_f_29021 = (cljs.core.truth_(selector_28991)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_28990,selector_28991):cljs.core.identity).call(null,(function (){var G__28983 = f_28998;
return (factory_29020.cljs$core$IFn$_invoke$arity$1 ? factory_29020.cljs$core$IFn$_invoke$arity$1(G__28983) : factory_29020.call(null,G__28983));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_28990,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_28991,actual_type_29019,f_28998], null),canonical_f_29021], 0));

if(cljs.core.truth_(elem_28990.addEventListener)){
elem_28990.addEventListener(cljs.core.name(actual_type_29019),canonical_f_29021);
} else {
elem_28990.attachEvent(cljs.core.name(actual_type_29019),canonical_f_29021);
}

var G__29022 = cljs.core.next(seq__28973_29012__$1);
var G__29023 = null;
var G__29024 = (0);
var G__29025 = (0);
seq__28973_28999 = G__29022;
chunk__28975_29000 = G__29023;
count__28976_29001 = G__29024;
i__28977_29002 = G__29025;
continue;
}
} else {
}
}
break;
}

var G__29026 = seq__28963_28992;
var G__29027 = chunk__28970_28993;
var G__29028 = count__28971_28994;
var G__29029 = (i__28972_28995 + (1));
seq__28963_28992 = G__29026;
chunk__28970_28993 = G__29027;
count__28971_28994 = G__29028;
i__28972_28995 = G__29029;
continue;
} else {
var temp__4126__auto___29030 = cljs.core.seq(seq__28963_28992);
if(temp__4126__auto___29030){
var seq__28963_29031__$1 = temp__4126__auto___29030;
if(cljs.core.chunked_seq_QMARK_(seq__28963_29031__$1)){
var c__5061__auto___29032 = cljs.core.chunk_first(seq__28963_29031__$1);
var G__29033 = cljs.core.chunk_rest(seq__28963_29031__$1);
var G__29034 = c__5061__auto___29032;
var G__29035 = cljs.core.count(c__5061__auto___29032);
var G__29036 = (0);
seq__28963_28992 = G__29033;
chunk__28970_28993 = G__29034;
count__28971_28994 = G__29035;
i__28972_28995 = G__29036;
continue;
} else {
var vec__28984_29037 = cljs.core.first(seq__28963_29031__$1);
var orig_type_29038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28984_29037,(0),null);
var f_29039 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28984_29037,(1),null);
var seq__28964_29040 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_29038,new cljs.core.PersistentArrayMap.fromArray([orig_type_29038,cljs.core.identity], true, false)));
var chunk__28966_29041 = null;
var count__28967_29042 = (0);
var i__28968_29043 = (0);
while(true){
if((i__28968_29043 < count__28967_29042)){
var vec__28985_29044 = chunk__28966_29041.cljs$core$IIndexed$_nth$arity$2(null,i__28968_29043);
var actual_type_29045 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28985_29044,(0),null);
var factory_29046 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28985_29044,(1),null);
var canonical_f_29047 = (cljs.core.truth_(selector_28991)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_28990,selector_28991):cljs.core.identity).call(null,(function (){var G__28986 = f_29039;
return (factory_29046.cljs$core$IFn$_invoke$arity$1 ? factory_29046.cljs$core$IFn$_invoke$arity$1(G__28986) : factory_29046.call(null,G__28986));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_28990,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_28991,actual_type_29045,f_29039], null),canonical_f_29047], 0));

if(cljs.core.truth_(elem_28990.addEventListener)){
elem_28990.addEventListener(cljs.core.name(actual_type_29045),canonical_f_29047);
} else {
elem_28990.attachEvent(cljs.core.name(actual_type_29045),canonical_f_29047);
}

var G__29048 = seq__28964_29040;
var G__29049 = chunk__28966_29041;
var G__29050 = count__28967_29042;
var G__29051 = (i__28968_29043 + (1));
seq__28964_29040 = G__29048;
chunk__28966_29041 = G__29049;
count__28967_29042 = G__29050;
i__28968_29043 = G__29051;
continue;
} else {
var temp__4126__auto___29052__$1 = cljs.core.seq(seq__28964_29040);
if(temp__4126__auto___29052__$1){
var seq__28964_29053__$1 = temp__4126__auto___29052__$1;
if(cljs.core.chunked_seq_QMARK_(seq__28964_29053__$1)){
var c__5061__auto___29054 = cljs.core.chunk_first(seq__28964_29053__$1);
var G__29055 = cljs.core.chunk_rest(seq__28964_29053__$1);
var G__29056 = c__5061__auto___29054;
var G__29057 = cljs.core.count(c__5061__auto___29054);
var G__29058 = (0);
seq__28964_29040 = G__29055;
chunk__28966_29041 = G__29056;
count__28967_29042 = G__29057;
i__28968_29043 = G__29058;
continue;
} else {
var vec__28987_29059 = cljs.core.first(seq__28964_29053__$1);
var actual_type_29060 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28987_29059,(0),null);
var factory_29061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28987_29059,(1),null);
var canonical_f_29062 = (cljs.core.truth_(selector_28991)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_28990,selector_28991):cljs.core.identity).call(null,(function (){var G__28988 = f_29039;
return (factory_29061.cljs$core$IFn$_invoke$arity$1 ? factory_29061.cljs$core$IFn$_invoke$arity$1(G__28988) : factory_29061.call(null,G__28988));
})());
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_28990,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_28991,actual_type_29060,f_29039], null),canonical_f_29062], 0));

if(cljs.core.truth_(elem_28990.addEventListener)){
elem_28990.addEventListener(cljs.core.name(actual_type_29060),canonical_f_29062);
} else {
elem_28990.attachEvent(cljs.core.name(actual_type_29060),canonical_f_29062);
}

var G__29063 = cljs.core.next(seq__28964_29053__$1);
var G__29064 = null;
var G__29065 = (0);
var G__29066 = (0);
seq__28964_29040 = G__29063;
chunk__28966_29041 = G__29064;
count__28967_29042 = G__29065;
i__28968_29043 = G__29066;
continue;
}
} else {
}
}
break;
}

var G__29067 = cljs.core.next(seq__28963_29031__$1);
var G__29068 = null;
var G__29069 = (0);
var G__29070 = (0);
seq__28963_28992 = G__29067;
chunk__28970_28993 = G__29068;
count__28971_28994 = G__29069;
i__28972_28995 = G__29070;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq28960){
var G__28961 = cljs.core.first(seq28960);
var seq28960__$1 = cljs.core.next(seq28960);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__28961,seq28960__$1);
});
/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 * The following forms are allowed, and will remove all handlers
 * that match the parameters passed in:
 * 
 * (unlisten! [elem :.selector] :click event-listener)
 * 
 * (unlisten! [elem :.selector]
 * :click event-listener
 * :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__29073_29096 = dommy.core.elem_and_selector(elem_sel);
var elem_29097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29073_29096,(0),null);
var selector_29098 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29073_29096,(1),null);
var seq__29074_29099 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__29081_29100 = null;
var count__29082_29101 = (0);
var i__29083_29102 = (0);
while(true){
if((i__29083_29102 < count__29082_29101)){
var vec__29090_29103 = chunk__29081_29100.cljs$core$IIndexed$_nth$arity$2(null,i__29083_29102);
var orig_type_29104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29090_29103,(0),null);
var f_29105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29090_29103,(1),null);
var seq__29084_29106 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_29104,new cljs.core.PersistentArrayMap.fromArray([orig_type_29104,cljs.core.identity], true, false)));
var chunk__29086_29107 = null;
var count__29087_29108 = (0);
var i__29088_29109 = (0);
while(true){
if((i__29088_29109 < count__29087_29108)){
var vec__29091_29110 = chunk__29086_29107.cljs$core$IIndexed$_nth$arity$2(null,i__29088_29109);
var actual_type_29111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29091_29110,(0),null);
var __29112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29091_29110,(1),null);
var keys_29113 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29098,actual_type_29111,f_29105], null);
var canonical_f_29114 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_29097),keys_29113);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29097,dommy.utils.dissoc_in,cljs.core.array_seq([keys_29113], 0));

if(cljs.core.truth_(elem_29097.removeEventListener)){
elem_29097.removeEventListener(cljs.core.name(actual_type_29111),canonical_f_29114);
} else {
elem_29097.detachEvent(cljs.core.name(actual_type_29111),canonical_f_29114);
}

var G__29115 = seq__29084_29106;
var G__29116 = chunk__29086_29107;
var G__29117 = count__29087_29108;
var G__29118 = (i__29088_29109 + (1));
seq__29084_29106 = G__29115;
chunk__29086_29107 = G__29116;
count__29087_29108 = G__29117;
i__29088_29109 = G__29118;
continue;
} else {
var temp__4126__auto___29119 = cljs.core.seq(seq__29084_29106);
if(temp__4126__auto___29119){
var seq__29084_29120__$1 = temp__4126__auto___29119;
if(cljs.core.chunked_seq_QMARK_(seq__29084_29120__$1)){
var c__5061__auto___29121 = cljs.core.chunk_first(seq__29084_29120__$1);
var G__29122 = cljs.core.chunk_rest(seq__29084_29120__$1);
var G__29123 = c__5061__auto___29121;
var G__29124 = cljs.core.count(c__5061__auto___29121);
var G__29125 = (0);
seq__29084_29106 = G__29122;
chunk__29086_29107 = G__29123;
count__29087_29108 = G__29124;
i__29088_29109 = G__29125;
continue;
} else {
var vec__29092_29126 = cljs.core.first(seq__29084_29120__$1);
var actual_type_29127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29092_29126,(0),null);
var __29128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29092_29126,(1),null);
var keys_29129 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29098,actual_type_29127,f_29105], null);
var canonical_f_29130 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_29097),keys_29129);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29097,dommy.utils.dissoc_in,cljs.core.array_seq([keys_29129], 0));

if(cljs.core.truth_(elem_29097.removeEventListener)){
elem_29097.removeEventListener(cljs.core.name(actual_type_29127),canonical_f_29130);
} else {
elem_29097.detachEvent(cljs.core.name(actual_type_29127),canonical_f_29130);
}

var G__29131 = cljs.core.next(seq__29084_29120__$1);
var G__29132 = null;
var G__29133 = (0);
var G__29134 = (0);
seq__29084_29106 = G__29131;
chunk__29086_29107 = G__29132;
count__29087_29108 = G__29133;
i__29088_29109 = G__29134;
continue;
}
} else {
}
}
break;
}

var G__29135 = seq__29074_29099;
var G__29136 = chunk__29081_29100;
var G__29137 = count__29082_29101;
var G__29138 = (i__29083_29102 + (1));
seq__29074_29099 = G__29135;
chunk__29081_29100 = G__29136;
count__29082_29101 = G__29137;
i__29083_29102 = G__29138;
continue;
} else {
var temp__4126__auto___29139 = cljs.core.seq(seq__29074_29099);
if(temp__4126__auto___29139){
var seq__29074_29140__$1 = temp__4126__auto___29139;
if(cljs.core.chunked_seq_QMARK_(seq__29074_29140__$1)){
var c__5061__auto___29141 = cljs.core.chunk_first(seq__29074_29140__$1);
var G__29142 = cljs.core.chunk_rest(seq__29074_29140__$1);
var G__29143 = c__5061__auto___29141;
var G__29144 = cljs.core.count(c__5061__auto___29141);
var G__29145 = (0);
seq__29074_29099 = G__29142;
chunk__29081_29100 = G__29143;
count__29082_29101 = G__29144;
i__29083_29102 = G__29145;
continue;
} else {
var vec__29093_29146 = cljs.core.first(seq__29074_29140__$1);
var orig_type_29147 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29093_29146,(0),null);
var f_29148 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29093_29146,(1),null);
var seq__29075_29149 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_29147,new cljs.core.PersistentArrayMap.fromArray([orig_type_29147,cljs.core.identity], true, false)));
var chunk__29077_29150 = null;
var count__29078_29151 = (0);
var i__29079_29152 = (0);
while(true){
if((i__29079_29152 < count__29078_29151)){
var vec__29094_29153 = chunk__29077_29150.cljs$core$IIndexed$_nth$arity$2(null,i__29079_29152);
var actual_type_29154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29094_29153,(0),null);
var __29155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29094_29153,(1),null);
var keys_29156 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29098,actual_type_29154,f_29148], null);
var canonical_f_29157 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_29097),keys_29156);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29097,dommy.utils.dissoc_in,cljs.core.array_seq([keys_29156], 0));

if(cljs.core.truth_(elem_29097.removeEventListener)){
elem_29097.removeEventListener(cljs.core.name(actual_type_29154),canonical_f_29157);
} else {
elem_29097.detachEvent(cljs.core.name(actual_type_29154),canonical_f_29157);
}

var G__29158 = seq__29075_29149;
var G__29159 = chunk__29077_29150;
var G__29160 = count__29078_29151;
var G__29161 = (i__29079_29152 + (1));
seq__29075_29149 = G__29158;
chunk__29077_29150 = G__29159;
count__29078_29151 = G__29160;
i__29079_29152 = G__29161;
continue;
} else {
var temp__4126__auto___29162__$1 = cljs.core.seq(seq__29075_29149);
if(temp__4126__auto___29162__$1){
var seq__29075_29163__$1 = temp__4126__auto___29162__$1;
if(cljs.core.chunked_seq_QMARK_(seq__29075_29163__$1)){
var c__5061__auto___29164 = cljs.core.chunk_first(seq__29075_29163__$1);
var G__29165 = cljs.core.chunk_rest(seq__29075_29163__$1);
var G__29166 = c__5061__auto___29164;
var G__29167 = cljs.core.count(c__5061__auto___29164);
var G__29168 = (0);
seq__29075_29149 = G__29165;
chunk__29077_29150 = G__29166;
count__29078_29151 = G__29167;
i__29079_29152 = G__29168;
continue;
} else {
var vec__29095_29169 = cljs.core.first(seq__29075_29163__$1);
var actual_type_29170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29095_29169,(0),null);
var __29171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29095_29169,(1),null);
var keys_29172 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_29098,actual_type_29170,f_29148], null);
var canonical_f_29173 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_29097),keys_29172);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_29097,dommy.utils.dissoc_in,cljs.core.array_seq([keys_29172], 0));

if(cljs.core.truth_(elem_29097.removeEventListener)){
elem_29097.removeEventListener(cljs.core.name(actual_type_29170),canonical_f_29173);
} else {
elem_29097.detachEvent(cljs.core.name(actual_type_29170),canonical_f_29173);
}

var G__29174 = cljs.core.next(seq__29075_29163__$1);
var G__29175 = null;
var G__29176 = (0);
var G__29177 = (0);
seq__29075_29149 = G__29174;
chunk__29077_29150 = G__29175;
count__29078_29151 = G__29176;
i__29079_29152 = G__29177;
continue;
}
} else {
}
}
break;
}

var G__29178 = cljs.core.next(seq__29074_29140__$1);
var G__29179 = null;
var G__29180 = (0);
var G__29181 = (0);
seq__29074_29099 = G__29178;
chunk__29081_29100 = G__29179;
count__29082_29101 = G__29180;
i__29083_29102 = G__29181;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq29071){
var G__29072 = cljs.core.first(seq29071);
var seq29071__$1 = cljs.core.next(seq29071);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29072,seq29071__$1);
});
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"type-fs","type-fs",1567896074,null)))], 0)))].join('')));
}

var vec__29184_29195 = dommy.core.elem_and_selector(elem_sel);
var elem_29196 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29184_29195,(0),null);
var selector_29197 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29184_29195,(1),null);
var seq__29185_29198 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__29186_29199 = null;
var count__29187_29200 = (0);
var i__29188_29201 = (0);
while(true){
if((i__29188_29201 < count__29187_29200)){
var vec__29189_29202 = chunk__29186_29199.cljs$core$IIndexed$_nth$arity$2(null,i__29188_29201);
var type_29203 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29189_29202,(0),null);
var f_29204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29189_29202,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_29203,((function (seq__29185_29198,chunk__29186_29199,count__29187_29200,i__29188_29201,vec__29189_29202,type_29203,f_29204,vec__29184_29195,elem_29196,selector_29197){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_29203,dommy$core$this_fn], 0));

var G__29191 = e;
return (f_29204.cljs$core$IFn$_invoke$arity$1 ? f_29204.cljs$core$IFn$_invoke$arity$1(G__29191) : f_29204.call(null,G__29191));
});})(seq__29185_29198,chunk__29186_29199,count__29187_29200,i__29188_29201,vec__29189_29202,type_29203,f_29204,vec__29184_29195,elem_29196,selector_29197))
], 0));

var G__29205 = seq__29185_29198;
var G__29206 = chunk__29186_29199;
var G__29207 = count__29187_29200;
var G__29208 = (i__29188_29201 + (1));
seq__29185_29198 = G__29205;
chunk__29186_29199 = G__29206;
count__29187_29200 = G__29207;
i__29188_29201 = G__29208;
continue;
} else {
var temp__4126__auto___29209 = cljs.core.seq(seq__29185_29198);
if(temp__4126__auto___29209){
var seq__29185_29210__$1 = temp__4126__auto___29209;
if(cljs.core.chunked_seq_QMARK_(seq__29185_29210__$1)){
var c__5061__auto___29211 = cljs.core.chunk_first(seq__29185_29210__$1);
var G__29212 = cljs.core.chunk_rest(seq__29185_29210__$1);
var G__29213 = c__5061__auto___29211;
var G__29214 = cljs.core.count(c__5061__auto___29211);
var G__29215 = (0);
seq__29185_29198 = G__29212;
chunk__29186_29199 = G__29213;
count__29187_29200 = G__29214;
i__29188_29201 = G__29215;
continue;
} else {
var vec__29192_29216 = cljs.core.first(seq__29185_29210__$1);
var type_29217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29192_29216,(0),null);
var f_29218 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29192_29216,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_29217,((function (seq__29185_29198,chunk__29186_29199,count__29187_29200,i__29188_29201,vec__29192_29216,type_29217,f_29218,seq__29185_29210__$1,temp__4126__auto___29209,vec__29184_29195,elem_29196,selector_29197){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_29217,dommy$core$this_fn], 0));

var G__29194 = e;
return (f_29218.cljs$core$IFn$_invoke$arity$1 ? f_29218.cljs$core$IFn$_invoke$arity$1(G__29194) : f_29218.call(null,G__29194));
});})(seq__29185_29198,chunk__29186_29199,count__29187_29200,i__29188_29201,vec__29192_29216,type_29217,f_29218,seq__29185_29210__$1,temp__4126__auto___29209,vec__29184_29195,elem_29196,selector_29197))
], 0));

var G__29219 = cljs.core.next(seq__29185_29210__$1);
var G__29220 = null;
var G__29221 = (0);
var G__29222 = (0);
seq__29185_29198 = G__29219;
chunk__29186_29199 = G__29220;
count__29187_29200 = G__29221;
i__29188_29201 = G__29222;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq29182){
var G__29183 = cljs.core.first(seq29182);
var seq29182__$1 = cljs.core.next(seq29182);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29183,seq29182__$1);
});
/**
 * NOTE: ONLY TO BE USED FOR TESTS. May not work at mocking many
 * event types or their bubbling behaviours
 * 
 * Creates an event of type `event-type`, optionally having
 * `update-event!` mutate and return an updated event object,
 * and fires it on `node`.
 * Only works when `node` is in the DOM
 */
dommy.core.fire_BANG_ = (function dommy$core$fire_BANG_(){
var argseq__5316__auto__ = ((((2) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(2)),(0))):null);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5316__auto__);
});

dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (node,event_type,p__29226){
var vec__29227 = p__29226;
var update_event_BANG_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29227,(0),null);
if(dommy.core.descendant_QMARK_(node,document.documentElement)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"descendant?","descendant?",-1027057938,null),new cljs.core.Symbol(null,"node","node",-2073234571,null),new cljs.core.Symbol("js","document.documentElement","js/document.documentElement",1597931428,null))], 0)))].join('')));
}

var update_event_BANG___$1 = (function (){var or__4276__auto__ = update_event_BANG_;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.identity;
}
})();
if(cljs.core.truth_(document.createEvent)){
var event = document.createEvent("Event");
event.initEvent(cljs.core.name(event_type),true,true);

return node.dispatchEvent((function (){var G__29228 = event;
return (update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1 ? update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1(G__29228) : update_event_BANG___$1.call(null,G__29228));
})());
} else {
return node.fireEvent([cljs.core.str("on"),cljs.core.str(cljs.core.name(event_type))].join(''),(function (){var G__29229 = document.createEventObject();
return (update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1 ? update_event_BANG___$1.cljs$core$IFn$_invoke$arity$1(G__29229) : update_event_BANG___$1.call(null,G__29229));
})());
}
});

dommy.core.fire_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.fire_BANG_.cljs$lang$applyTo = (function (seq29223){
var G__29224 = cljs.core.first(seq29223);
var seq29223__$1 = cljs.core.next(seq29223);
var G__29225 = cljs.core.first(seq29223__$1);
var seq29223__$2 = cljs.core.next(seq29223__$1);
return dommy.core.fire_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29224,G__29225,seq29223__$2);
});
