// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('dommy.attrs');
goog.require('cljs.core');
goog.require('clojure.string');
/**
 * does class-name string have class starting at index idx.
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_match_QMARK_ = (function dommy$attrs$class_match_QMARK_(class_name,class$,idx){
var and__4264__auto__ = ((idx === (0))) || ((" " === class_name.charAt((idx - (1)))));
if(and__4264__auto__){
var total_len = class_name.length;
var stop = (idx + class$.length);
if((stop <= total_len)){
return ((stop === total_len)) || ((" " === class_name.charAt(stop)));
} else {
return null;
}
} else {
return and__4264__auto__;
}
});
/**
 * Finds the index of class in a space-delimited class-name
 * only will be used when Element::classList doesn't exist
 */
dommy.attrs.class_index = (function dommy$attrs$class_index(class_name,class$){
var start_from = (0);
while(true){
var i = class_name.indexOf(class$,start_from);
if((i >= (0))){
if(dommy.attrs.class_match_QMARK_(class_name,class$,i)){
return i;
} else {
var G__29241 = (i + class$.length);
start_from = G__29241;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Does an HTML element have a class. Uses Element::classList if
 * available and otherwise does fast parse of className string
 */
dommy.attrs.has_class_QMARK_ = (function dommy$attrs$has_class_QMARK_(elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4124__auto__ = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto__)){
var class_list = temp__4124__auto__;
return class_list.contains(class$__$1);
} else {
var temp__4126__auto__ = elem__$1.className;
if(cljs.core.truth_(temp__4126__auto__)){
var class_name = temp__4126__auto__;
var temp__4126__auto____$1 = dommy.attrs.class_index(class_name,class$__$1);
if(cljs.core.truth_(temp__4126__auto____$1)){
var i = temp__4126__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * add class to element
 */
dommy.attrs.add_class_BANG_ = (function dommy$attrs$add_class_BANG_(){
var G__29246 = arguments.length;
switch (G__29246) {
case 2:
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var classes__$1 = clojure.string.trim(cljs.core.name(classes));
if(cljs.core.seq(classes__$1)){
var temp__4124__auto___29260 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___29260)){
var class_list_29261 = temp__4124__auto___29260;
var seq__29247_29262 = cljs.core.seq(classes__$1.split(/\s+/));
var chunk__29248_29263 = null;
var count__29249_29264 = (0);
var i__29250_29265 = (0);
while(true){
if((i__29250_29265 < count__29249_29264)){
var class_29266 = chunk__29248_29263.cljs$core$IIndexed$_nth$arity$2(null,i__29250_29265);
class_list_29261.add(class_29266);

var G__29267 = seq__29247_29262;
var G__29268 = chunk__29248_29263;
var G__29269 = count__29249_29264;
var G__29270 = (i__29250_29265 + (1));
seq__29247_29262 = G__29267;
chunk__29248_29263 = G__29268;
count__29249_29264 = G__29269;
i__29250_29265 = G__29270;
continue;
} else {
var temp__4126__auto___29271 = cljs.core.seq(seq__29247_29262);
if(temp__4126__auto___29271){
var seq__29247_29272__$1 = temp__4126__auto___29271;
if(cljs.core.chunked_seq_QMARK_(seq__29247_29272__$1)){
var c__5061__auto___29273 = cljs.core.chunk_first(seq__29247_29272__$1);
var G__29274 = cljs.core.chunk_rest(seq__29247_29272__$1);
var G__29275 = c__5061__auto___29273;
var G__29276 = cljs.core.count(c__5061__auto___29273);
var G__29277 = (0);
seq__29247_29262 = G__29274;
chunk__29248_29263 = G__29275;
count__29249_29264 = G__29276;
i__29250_29265 = G__29277;
continue;
} else {
var class_29278 = cljs.core.first(seq__29247_29272__$1);
class_list_29261.add(class_29278);

var G__29279 = cljs.core.next(seq__29247_29272__$1);
var G__29280 = null;
var G__29281 = (0);
var G__29282 = (0);
seq__29247_29262 = G__29279;
chunk__29248_29263 = G__29280;
count__29249_29264 = G__29281;
i__29250_29265 = G__29282;
continue;
}
} else {
}
}
break;
}
} else {
var class_name_29283 = elem__$1.className;
var seq__29251_29284 = cljs.core.seq(classes__$1.split(/\s+/));
var chunk__29252_29285 = null;
var count__29253_29286 = (0);
var i__29254_29287 = (0);
while(true){
if((i__29254_29287 < count__29253_29286)){
var class_29288 = chunk__29252_29285.cljs$core$IIndexed$_nth$arity$2(null,i__29254_29287);
if(cljs.core.truth_(dommy.attrs.class_index(class_name_29283,class_29288))){
} else {
elem__$1.className = (((class_name_29283 === ""))?class_29288:[cljs.core.str(class_name_29283),cljs.core.str(" "),cljs.core.str(class_29288)].join(''));
}

var G__29289 = seq__29251_29284;
var G__29290 = chunk__29252_29285;
var G__29291 = count__29253_29286;
var G__29292 = (i__29254_29287 + (1));
seq__29251_29284 = G__29289;
chunk__29252_29285 = G__29290;
count__29253_29286 = G__29291;
i__29254_29287 = G__29292;
continue;
} else {
var temp__4126__auto___29293 = cljs.core.seq(seq__29251_29284);
if(temp__4126__auto___29293){
var seq__29251_29294__$1 = temp__4126__auto___29293;
if(cljs.core.chunked_seq_QMARK_(seq__29251_29294__$1)){
var c__5061__auto___29295 = cljs.core.chunk_first(seq__29251_29294__$1);
var G__29296 = cljs.core.chunk_rest(seq__29251_29294__$1);
var G__29297 = c__5061__auto___29295;
var G__29298 = cljs.core.count(c__5061__auto___29295);
var G__29299 = (0);
seq__29251_29284 = G__29296;
chunk__29252_29285 = G__29297;
count__29253_29286 = G__29298;
i__29254_29287 = G__29299;
continue;
} else {
var class_29300 = cljs.core.first(seq__29251_29294__$1);
if(cljs.core.truth_(dommy.attrs.class_index(class_name_29283,class_29300))){
} else {
elem__$1.className = (((class_name_29283 === ""))?class_29300:[cljs.core.str(class_name_29283),cljs.core.str(" "),cljs.core.str(class_29300)].join(''));
}

var G__29301 = cljs.core.next(seq__29251_29294__$1);
var G__29302 = null;
var G__29303 = (0);
var G__29304 = (0);
seq__29251_29284 = G__29301;
chunk__29252_29285 = G__29302;
count__29253_29286 = G__29303;
i__29254_29287 = G__29304;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__29255_29305 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(more_classes,classes));
var chunk__29256_29306 = null;
var count__29257_29307 = (0);
var i__29258_29308 = (0);
while(true){
if((i__29258_29308 < count__29257_29307)){
var c_29309 = chunk__29256_29306.cljs$core$IIndexed$_nth$arity$2(null,i__29258_29308);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c_29309);

var G__29310 = seq__29255_29305;
var G__29311 = chunk__29256_29306;
var G__29312 = count__29257_29307;
var G__29313 = (i__29258_29308 + (1));
seq__29255_29305 = G__29310;
chunk__29256_29306 = G__29311;
count__29257_29307 = G__29312;
i__29258_29308 = G__29313;
continue;
} else {
var temp__4126__auto___29314 = cljs.core.seq(seq__29255_29305);
if(temp__4126__auto___29314){
var seq__29255_29315__$1 = temp__4126__auto___29314;
if(cljs.core.chunked_seq_QMARK_(seq__29255_29315__$1)){
var c__5061__auto___29316 = cljs.core.chunk_first(seq__29255_29315__$1);
var G__29317 = cljs.core.chunk_rest(seq__29255_29315__$1);
var G__29318 = c__5061__auto___29316;
var G__29319 = cljs.core.count(c__5061__auto___29316);
var G__29320 = (0);
seq__29255_29305 = G__29317;
chunk__29256_29306 = G__29318;
count__29257_29307 = G__29319;
i__29258_29308 = G__29320;
continue;
} else {
var c_29321 = cljs.core.first(seq__29255_29315__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c_29321);

var G__29322 = cljs.core.next(seq__29255_29315__$1);
var G__29323 = null;
var G__29324 = (0);
var G__29325 = (0);
seq__29255_29305 = G__29322;
chunk__29256_29306 = G__29323;
count__29257_29307 = G__29324;
i__29258_29308 = G__29325;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.add_class_BANG_.cljs$lang$applyTo = (function (seq29242){
var G__29243 = cljs.core.first(seq29242);
var seq29242__$1 = cljs.core.next(seq29242);
var G__29244 = cljs.core.first(seq29242__$1);
var seq29242__$2 = cljs.core.next(seq29242__$1);
return dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29243,G__29244,seq29242__$2);
});

dommy.attrs.add_class_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.remove_class_str = (function dommy$attrs$remove_class_str(init_class_name,class$){
var class_name = init_class_name;
while(true){
var class_len = class_name.length;
var temp__4124__auto__ = dommy.attrs.class_index(class_name,class$);
if(cljs.core.truth_(temp__4124__auto__)){
var i = temp__4124__auto__;
var G__29326 = (function (){var end = (i + class$.length);
return [cljs.core.str((((end < class_len))?[cljs.core.str(class_name.substring((0),i)),cljs.core.str(class_name.substr((end + (1))))].join(''):class_name.substring((0),(i - (1)))))].join('');
})();
class_name = G__29326;
continue;
} else {
return class_name;
}
break;
}
});
/**
 * remove class from and returns `elem`
 */
dommy.attrs.remove_class_BANG_ = (function dommy$attrs$remove_class_BANG_(){
var G__29331 = arguments.length;
switch (G__29331) {
case 2:
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4124__auto___29337 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___29337)){
var class_list_29338 = temp__4124__auto___29337;
class_list_29338.remove(class$__$1);
} else {
var class_name_29339 = elem__$1.className;
var new_class_name_29340 = dommy.attrs.remove_class_str(class_name_29339,class$__$1);
if((class_name_29339 === new_class_name_29340)){
} else {
elem__$1.className = new_class_name_29340;
}
}

return elem__$1;
});

dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__29332 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(classes,class$));
var chunk__29333 = null;
var count__29334 = (0);
var i__29335 = (0);
while(true){
if((i__29335 < count__29334)){
var c = chunk__29333.cljs$core$IIndexed$_nth$arity$2(null,i__29335);
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c);

var G__29341 = seq__29332;
var G__29342 = chunk__29333;
var G__29343 = count__29334;
var G__29344 = (i__29335 + (1));
seq__29332 = G__29341;
chunk__29333 = G__29342;
count__29334 = G__29343;
i__29335 = G__29344;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__29332);
if(temp__4126__auto__){
var seq__29332__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29332__$1)){
var c__5061__auto__ = cljs.core.chunk_first(seq__29332__$1);
var G__29345 = cljs.core.chunk_rest(seq__29332__$1);
var G__29346 = c__5061__auto__;
var G__29347 = cljs.core.count(c__5061__auto__);
var G__29348 = (0);
seq__29332 = G__29345;
chunk__29333 = G__29346;
count__29334 = G__29347;
i__29335 = G__29348;
continue;
} else {
var c = cljs.core.first(seq__29332__$1);
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,c);

var G__29349 = cljs.core.next(seq__29332__$1);
var G__29350 = null;
var G__29351 = (0);
var G__29352 = (0);
seq__29332 = G__29349;
chunk__29333 = G__29350;
count__29334 = G__29351;
i__29335 = G__29352;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.attrs.remove_class_BANG_.cljs$lang$applyTo = (function (seq29327){
var G__29328 = cljs.core.first(seq29327);
var seq29327__$1 = cljs.core.next(seq29327);
var G__29329 = cljs.core.first(seq29327__$1);
var seq29327__$2 = cljs.core.next(seq29327__$1);
return dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29328,G__29329,seq29327__$2);
});

dommy.attrs.remove_class_BANG_.cljs$lang$maxFixedArity = 2;
/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.attrs.toggle_class_BANG_ = (function dommy$attrs$toggle_class_BANG_(){
var G__29354 = arguments.length;
switch (G__29354) {
case 2:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,class$){
var elem__$1 = dommy.template.__GT_node_like(elem);
var class$__$1 = cljs.core.name(class$);
var temp__4124__auto___29356 = elem__$1.classList;
if(cljs.core.truth_(temp__4124__auto___29356)){
var class_list_29357 = temp__4124__auto___29356;
class_list_29357.toggle(class$__$1);
} else {
dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,class$__$1,!(dommy.attrs.has_class_QMARK_(elem__$1,class$__$1)));
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(add_QMARK_){
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,class$);
} else {
dommy.attrs.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,class$);
}

return elem__$1;
});

dommy.attrs.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.style_str = (function dommy$attrs$style_str(x){
if(typeof x === 'string'){
return x;
} else {
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__29360){
var vec__29361 = p__29360;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29361,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29361,(1),null);
return [cljs.core.str(cljs.core.name(k)),cljs.core.str(":"),cljs.core.str(cljs.core.name(v)),cljs.core.str(";")].join('');
}),x));
}
});
dommy.attrs.set_style_BANG_ = (function dommy$attrs$set_style_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var style = elem__$1.style;
var seq__29364_29370 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__29365_29371 = null;
var count__29366_29372 = (0);
var i__29367_29373 = (0);
while(true){
if((i__29367_29373 < count__29366_29372)){
var vec__29368_29374 = chunk__29365_29371.cljs$core$IIndexed$_nth$arity$2(null,i__29367_29373);
var k_29375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29368_29374,(0),null);
var v_29376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29368_29374,(1),null);
(style[cljs.core.name(k_29375)] = v_29376);

var G__29377 = seq__29364_29370;
var G__29378 = chunk__29365_29371;
var G__29379 = count__29366_29372;
var G__29380 = (i__29367_29373 + (1));
seq__29364_29370 = G__29377;
chunk__29365_29371 = G__29378;
count__29366_29372 = G__29379;
i__29367_29373 = G__29380;
continue;
} else {
var temp__4126__auto___29381 = cljs.core.seq(seq__29364_29370);
if(temp__4126__auto___29381){
var seq__29364_29382__$1 = temp__4126__auto___29381;
if(cljs.core.chunked_seq_QMARK_(seq__29364_29382__$1)){
var c__5061__auto___29383 = cljs.core.chunk_first(seq__29364_29382__$1);
var G__29384 = cljs.core.chunk_rest(seq__29364_29382__$1);
var G__29385 = c__5061__auto___29383;
var G__29386 = cljs.core.count(c__5061__auto___29383);
var G__29387 = (0);
seq__29364_29370 = G__29384;
chunk__29365_29371 = G__29385;
count__29366_29372 = G__29386;
i__29367_29373 = G__29387;
continue;
} else {
var vec__29369_29388 = cljs.core.first(seq__29364_29382__$1);
var k_29389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29369_29388,(0),null);
var v_29390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29369_29388,(1),null);
(style[cljs.core.name(k_29389)] = v_29390);

var G__29391 = cljs.core.next(seq__29364_29382__$1);
var G__29392 = null;
var G__29393 = (0);
var G__29394 = (0);
seq__29364_29370 = G__29391;
chunk__29365_29371 = G__29392;
count__29366_29372 = G__29393;
i__29367_29373 = G__29394;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_style_BANG_.cljs$lang$applyTo = (function (seq29362){
var G__29363 = cljs.core.first(seq29362);
var seq29362__$1 = cljs.core.next(seq29362);
return dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29363,seq29362__$1);
});
dommy.attrs.style = (function dommy$attrs$style(elem,k){
if(cljs.core.truth_(k)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"k","k",-505765866,null)], 0)))].join('')));
}

return ((function (){var G__29396 = dommy.template.__GT_node_like(elem);
return window.getComputedStyle(G__29396);
})()[cljs.core.name(k)]);
});
dommy.attrs.set_px_BANG_ = (function dommy$attrs$set_px_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__29399_29405 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__29400_29406 = null;
var count__29401_29407 = (0);
var i__29402_29408 = (0);
while(true){
if((i__29402_29408 < count__29401_29407)){
var vec__29403_29409 = chunk__29400_29406.cljs$core$IIndexed$_nth$arity$2(null,i__29402_29408);
var k_29410 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29403_29409,(0),null);
var v_29411 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29403_29409,(1),null);
dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem__$1,cljs.core.array_seq([k_29410,[cljs.core.str(v_29411),cljs.core.str("px")].join('')], 0));

var G__29412 = seq__29399_29405;
var G__29413 = chunk__29400_29406;
var G__29414 = count__29401_29407;
var G__29415 = (i__29402_29408 + (1));
seq__29399_29405 = G__29412;
chunk__29400_29406 = G__29413;
count__29401_29407 = G__29414;
i__29402_29408 = G__29415;
continue;
} else {
var temp__4126__auto___29416 = cljs.core.seq(seq__29399_29405);
if(temp__4126__auto___29416){
var seq__29399_29417__$1 = temp__4126__auto___29416;
if(cljs.core.chunked_seq_QMARK_(seq__29399_29417__$1)){
var c__5061__auto___29418 = cljs.core.chunk_first(seq__29399_29417__$1);
var G__29419 = cljs.core.chunk_rest(seq__29399_29417__$1);
var G__29420 = c__5061__auto___29418;
var G__29421 = cljs.core.count(c__5061__auto___29418);
var G__29422 = (0);
seq__29399_29405 = G__29419;
chunk__29400_29406 = G__29420;
count__29401_29407 = G__29421;
i__29402_29408 = G__29422;
continue;
} else {
var vec__29404_29423 = cljs.core.first(seq__29399_29417__$1);
var k_29424 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29404_29423,(0),null);
var v_29425 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29404_29423,(1),null);
dommy.attrs.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem__$1,cljs.core.array_seq([k_29424,[cljs.core.str(v_29425),cljs.core.str("px")].join('')], 0));

var G__29426 = cljs.core.next(seq__29399_29417__$1);
var G__29427 = null;
var G__29428 = (0);
var G__29429 = (0);
seq__29399_29405 = G__29426;
chunk__29400_29406 = G__29427;
count__29401_29407 = G__29428;
i__29402_29408 = G__29429;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.attrs.set_px_BANG_.cljs$lang$applyTo = (function (seq29397){
var G__29398 = cljs.core.first(seq29397);
var seq29397__$1 = cljs.core.next(seq29397);
return dommy.attrs.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29398,seq29397__$1);
});
dommy.attrs.px = (function dommy$attrs$px(elem,k){
var pixels = dommy.attrs.style(dommy.template.__GT_node_like(elem),k);
if(cljs.core.seq(pixels)){
var G__29431 = pixels;
return parseInt(G__29431);
} else {
return null;
}
});
/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to "true":
 * 
 * (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 * (set-attr! elem :id "some-id"
 * :name "some-name")
 */
dommy.attrs.set_attr_BANG_ = (function dommy$attrs$set_attr_BANG_(){
var G__29437 = arguments.length;
switch (G__29437) {
case 2:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,3),(0)));
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5328__auto__);

}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(dommy.template.__GT_node_like(elem),k,"true");
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_(v)){
var G__29438 = dommy.template.__GT_node_like(elem);
(G__29438[cljs.core.name(k)] = v);

return G__29438;
} else {
var G__29439 = dommy.template.__GT_node_like(elem);
G__29439.setAttribute(cljs.core.name(k),(((k === cljs.core.constant$keyword$style))?dommy.attrs.style_str(v):v));

return G__29439;
}
} else {
return null;
}
});

dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))], 0)))].join('')));
}

var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__29440_29447 = cljs.core.seq(cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs)));
var chunk__29441_29448 = null;
var count__29442_29449 = (0);
var i__29443_29450 = (0);
while(true){
if((i__29443_29450 < count__29442_29449)){
var vec__29444_29451 = chunk__29441_29448.cljs$core$IIndexed$_nth$arity$2(null,i__29443_29450);
var k_29452__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29444_29451,(0),null);
var v_29453__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29444_29451,(1),null);
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,k_29452__$1,v_29453__$1);

var G__29454 = seq__29440_29447;
var G__29455 = chunk__29441_29448;
var G__29456 = count__29442_29449;
var G__29457 = (i__29443_29450 + (1));
seq__29440_29447 = G__29454;
chunk__29441_29448 = G__29455;
count__29442_29449 = G__29456;
i__29443_29450 = G__29457;
continue;
} else {
var temp__4126__auto___29458 = cljs.core.seq(seq__29440_29447);
if(temp__4126__auto___29458){
var seq__29440_29459__$1 = temp__4126__auto___29458;
if(cljs.core.chunked_seq_QMARK_(seq__29440_29459__$1)){
var c__5061__auto___29460 = cljs.core.chunk_first(seq__29440_29459__$1);
var G__29461 = cljs.core.chunk_rest(seq__29440_29459__$1);
var G__29462 = c__5061__auto___29460;
var G__29463 = cljs.core.count(c__5061__auto___29460);
var G__29464 = (0);
seq__29440_29447 = G__29461;
chunk__29441_29448 = G__29462;
count__29442_29449 = G__29463;
i__29443_29450 = G__29464;
continue;
} else {
var vec__29445_29465 = cljs.core.first(seq__29440_29459__$1);
var k_29466__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29445_29465,(0),null);
var v_29467__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29445_29465,(1),null);
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem__$1,k_29466__$1,v_29467__$1);

var G__29468 = cljs.core.next(seq__29440_29459__$1);
var G__29469 = null;
var G__29470 = (0);
var G__29471 = (0);
seq__29440_29447 = G__29468;
chunk__29441_29448 = G__29469;
count__29442_29449 = G__29470;
i__29443_29450 = G__29471;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.set_attr_BANG_.cljs$lang$applyTo = (function (seq29432){
var G__29433 = cljs.core.first(seq29432);
var seq29432__$1 = cljs.core.next(seq29432);
var G__29434 = cljs.core.first(seq29432__$1);
var seq29432__$2 = cljs.core.next(seq29432__$1);
var G__29435 = cljs.core.first(seq29432__$2);
var seq29432__$3 = cljs.core.next(seq29432__$2);
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29433,G__29434,G__29435,seq29432__$3);
});

dommy.attrs.set_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.remove_attr_BANG_ = (function dommy$attrs$remove_attr_BANG_(){
var G__29476 = arguments.length;
switch (G__29476) {
case 2:
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__5328__auto__ = (new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,2),(0)));
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5328__auto__);

}
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$class,null,cljs.core.constant$keyword$classes,null], null), null).call(null,k))){
elem__$1.className = "";
} else {
elem__$1.removeAttribute(cljs.core.name(k));
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var elem__$1 = dommy.template.__GT_node_like(elem);
var seq__29477_29482 = cljs.core.seq(cljs.core.cons(k,ks));
var chunk__29478_29483 = null;
var count__29479_29484 = (0);
var i__29480_29485 = (0);
while(true){
if((i__29480_29485 < count__29479_29484)){
var k_29486__$1 = chunk__29478_29483.cljs$core$IIndexed$_nth$arity$2(null,i__29480_29485);
dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k_29486__$1);

var G__29487 = seq__29477_29482;
var G__29488 = chunk__29478_29483;
var G__29489 = count__29479_29484;
var G__29490 = (i__29480_29485 + (1));
seq__29477_29482 = G__29487;
chunk__29478_29483 = G__29488;
count__29479_29484 = G__29489;
i__29480_29485 = G__29490;
continue;
} else {
var temp__4126__auto___29491 = cljs.core.seq(seq__29477_29482);
if(temp__4126__auto___29491){
var seq__29477_29492__$1 = temp__4126__auto___29491;
if(cljs.core.chunked_seq_QMARK_(seq__29477_29492__$1)){
var c__5061__auto___29493 = cljs.core.chunk_first(seq__29477_29492__$1);
var G__29494 = cljs.core.chunk_rest(seq__29477_29492__$1);
var G__29495 = c__5061__auto___29493;
var G__29496 = cljs.core.count(c__5061__auto___29493);
var G__29497 = (0);
seq__29477_29482 = G__29494;
chunk__29478_29483 = G__29495;
count__29479_29484 = G__29496;
i__29480_29485 = G__29497;
continue;
} else {
var k_29498__$1 = cljs.core.first(seq__29477_29492__$1);
dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k_29498__$1);

var G__29499 = cljs.core.next(seq__29477_29492__$1);
var G__29500 = null;
var G__29501 = (0);
var G__29502 = (0);
seq__29477_29482 = G__29499;
chunk__29478_29483 = G__29500;
count__29479_29484 = G__29501;
i__29480_29485 = G__29502;
continue;
}
} else {
}
}
break;
}

return elem__$1;
});

dommy.attrs.remove_attr_BANG_.cljs$lang$applyTo = (function (seq29472){
var G__29473 = cljs.core.first(seq29472);
var seq29472__$1 = cljs.core.next(seq29472);
var G__29474 = cljs.core.first(seq29472__$1);
var seq29472__$2 = cljs.core.next(seq29472__$1);
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29473,G__29474,seq29472__$2);
});

dommy.attrs.remove_attr_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.attr = (function dommy$attrs$attr(elem,k){
if(cljs.core.truth_(k)){
return dommy.template.__GT_node_like(elem).getAttribute(cljs.core.name(k));
} else {
return null;
}
});
dommy.attrs.toggle_attr_BANG_ = (function dommy$attrs$toggle_attr_BANG_(){
var G__29504 = arguments.length;
switch (G__29504) {
case 2:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,cljs.core.boolean$(dommy.attrs.attr(elem,k)));
});

dommy.attrs.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
if(add_QMARK_){
return dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k);
} else {
return dommy.attrs.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,k);
}
});

dommy.attrs.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;
dommy.attrs.hidden_QMARK_ = (function dommy$attrs$hidden_QMARK_(elem){
return ("none" === dommy.template.__GT_node_like(elem).style.display);
});
/**
 * Display or hide the given `elem`. Takes an optional boolean `show?`
 * indicating whether to show or hide `elem`.
 */
dommy.attrs.toggle_BANG_ = (function dommy$attrs$toggle_BANG_(){
var G__29507 = arguments.length;
switch (G__29507) {
case 2:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
var G__29508 = dommy.template.__GT_node_like(elem);
G__29508.style.display = ((show_QMARK_)?"":"none");

return G__29508;
});

dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var elem__$1 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem__$1,dommy.attrs.hidden_QMARK_(elem__$1));

return elem__$1;
});

dommy.attrs.toggle_BANG_.cljs$lang$maxFixedArity = 2;
dommy.attrs.hide_BANG_ = (function dommy$attrs$hide_BANG_(elem){
var G__29511 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(G__29511,false);

return G__29511;
});
dommy.attrs.show_BANG_ = (function dommy$attrs$show_BANG_(elem){
var G__29513 = dommy.template.__GT_node_like(elem);
dommy.attrs.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(G__29513,true);

return G__29513;
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.attrs.bounding_client_rect = (function dommy$attrs$bounding_client_rect(elem){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__29515 = dommy.template.__GT_node_like(elem).getBoundingClientRect();
(G__29515["constructor"] = Object);

return G__29515;
})(),cljs.core.array_seq([cljs.core.constant$keyword$keywordize_DASH_keys,true], 0));
});
dommy.attrs.scroll_into_view = (function dommy$attrs$scroll_into_view(elem,align_with_top_QMARK_){
var elem__$1 = dommy.template.__GT_node_like(elem);
var top = cljs.core.constant$keyword$top.cljs$core$IFn$_invoke$arity$1(dommy.attrs.bounding_client_rect(elem__$1));
if((window.innerHeight < (top + elem__$1.offsetHeight))){
return elem__$1.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
