// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__4264__auto__ = v;
if(cljs.core.truth_(and__4264__auto__)){
return (v > (0));
} else {
return and__4264__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(cljs.core.not(clojure.string.blank_QMARK_(s))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__30298_SHARP_,p2__30297_SHARP_){
var vec__30300 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(p2__30297_SHARP_,/=/);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30300,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30300,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30298_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(no.en.core.url_decode(k)),no.en.core.url_decode(v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(cljs.core.not(clojure.string.blank_QMARK_(url))){
var uri = (function (){var G__30302 = url;
return goog.Uri.parse(G__30302);
})();
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.constant$keyword$scheme,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(uri.getScheme()),cljs.core.constant$keyword$server_DASH_name,uri.getDomain(),cljs.core.constant$keyword$server_DASH_port,cljs_http.client.if_pos(uri.getPort()),cljs.core.constant$keyword$uri,uri.getPath(),cljs.core.constant$keyword$query_DASH_string,((cljs.core.not(query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),cljs.core.constant$keyword$query_DASH_params,((cljs.core.not(query_data.isEmpty()))?cljs_http.client.parse_query_params([cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode(cljs.core.name(k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode([cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__30303_SHARP_){
return cljs_http.client.encode_val(k,p1__30303_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__30304){
var vec__30306 = p__30304;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30306,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30306,(1),null);
if(cljs.core.coll_QMARK_(v)){
return cljs_http.client.encode_vals(k,v);
} else {
return cljs_http.client.encode_val(k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap(esc_chars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (esc_chars){
return (function (p1__30307_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__30307_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.replace.cljs$core$IFn$_invoke$arity$2(cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__4264__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.constant$keyword$head,request_method);
if(and__4264__auto__){
return cljs.core.re_find(cljs.core.re_pattern([cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special(content_type))].join('')),[cljs.core.str(cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.constant$keyword$headers.cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$body], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4124__auto__ = cljs.core.constant$keyword$edn_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var G__30310 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$edn_DASH_params),cljs.core.constant$keyword$body,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([params], 0))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/edn");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30310) : client.call(null,G__30310));
} else {
var G__30311 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30311) : client.call(null,G__30311));
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var c__7709__auto___30350 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___30350,channel){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___30350,channel){
return (function (state_30339){
var state_val_30340 = (state_30339[(1)]);
if((state_val_30340 === (2))){
var inst_30333 = (state_30339[(2)]);
var inst_30334 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_30335 = cljs_http.client.decode_body(inst_30333,cljs.reader.read_string,"application/edn",inst_30334);
var inst_30336 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_30335);
var inst_30337 = cljs.core.async.close_BANG_(channel);
var state_30339__$1 = (function (){var statearr_30341 = state_30339;
(statearr_30341[(7)] = inst_30336);

return statearr_30341;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30339__$1,inst_30337);
} else {
if((state_val_30340 === (1))){
var inst_30331 = (function (){var G__30342 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30342) : client.call(null,G__30342));
})();
var state_30339__$1 = state_30339;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30339__$1,(2),inst_30331);
} else {
return null;
}
}
});})(c__7709__auto___30350,channel))
;
return ((function (switch__7647__auto__,c__7709__auto___30350,channel){
return (function() {
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0 = (function (){
var statearr_30346 = [null,null,null,null,null,null,null,null];
(statearr_30346[(0)] = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__);

(statearr_30346[(1)] = (1));

return statearr_30346;
});
var cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1 = (function (state_30339){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_30339);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e30347){if((e30347 instanceof Object)){
var ex__7651__auto__ = e30347;
var statearr_30348_30351 = state_30339;
(statearr_30348_30351[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30339);

return cljs.core.constant$keyword$recur;
} else {
throw e30347;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__30352 = state_30339;
state_30339 = G__30352;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__ = function(state_30339){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1.call(this,state_30339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_edn_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_edn_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___30350,channel))
})();
var state__7711__auto__ = (function (){var statearr_30349 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_30349[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___30350);

return statearr_30349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___30350,channel))
);


return channel;
});
});
cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__30355){
var vec__30356 = p__30355;
var accept = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30356,(0),null);
return ((function (vec__30356,accept){
return (function (request){
var temp__4124__auto__ = (function (){var or__4276__auto__ = cljs.core.constant$keyword$accept.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var accept__$1 = temp__4124__auto__;
var G__30357 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"accept"], null),accept__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30357) : client.call(null,G__30357));
} else {
var G__30358 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30358) : client.call(null,G__30358));
}
});
;})(vec__30356,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq30353){
var G__30354 = cljs.core.first(seq30353);
var seq30353__$1 = cljs.core.next(seq30353);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__30354,seq30353__$1);
});
cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__30361){
var vec__30362 = p__30361;
var content_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30362,(0),null);
return ((function (vec__30362,content_type){
return (function (request){
var temp__4124__auto__ = (function (){var or__4276__auto__ = cljs.core.constant$keyword$content_DASH_type.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4124__auto__)){
var content_type__$1 = temp__4124__auto__;
var G__30363 = cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),content_type__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30363) : client.call(null,G__30363));
} else {
var G__30364 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30364) : client.call(null,G__30364));
}
});
;})(vec__30362,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq30359){
var G__30360 = cljs.core.first(seq30359);
var seq30359__$1 = cljs.core.next(seq30359);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__30360,seq30359__$1);
});
cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$encoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$encoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY,cljs.core.constant$keyword$decoding,cljs.core.constant$keyword$json,cljs.core.constant$keyword$decoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 * Content Type header.
 * 
 * A :transit-opts map can be optionally provided with the following keys:
 * 
 * :encoding                #{:json, :json-verbose}
 * :decoding                #{:json, :json-verbose}
 * :encoding/decoding-opts  appropriate map of options to be passed to
 * transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4124__auto__ = cljs.core.constant$keyword$transit_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var map__30368 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__30368__$1 = ((cljs.core.seq_QMARK_(map__30368))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30368):map__30368);
var encoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30368__$1,cljs.core.constant$keyword$encoding_DASH_opts);
var encoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30368__$1,cljs.core.constant$keyword$encoding);
var G__30369 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$transit_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.transit_encode(params,encoding,encoding_opts)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/transit+json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30369) : client.call(null,G__30369));
} else {
var G__30370 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30370) : client.call(null,G__30370));
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var map__30393 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.constant$keyword$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request)], 0));
var map__30393__$1 = ((cljs.core.seq_QMARK_(map__30393))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30393):map__30393);
var decoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30393__$1,cljs.core.constant$keyword$decoding_DASH_opts);
var decoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30393__$1,cljs.core.constant$keyword$decoding);
var c__7709__auto___30414 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___30414,channel,map__30393,map__30393__$1,decoding_opts,decoding){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___30414,channel,map__30393,map__30393__$1,decoding_opts,decoding){
return (function (state_30403){
var state_val_30404 = (state_30403[(1)]);
if((state_val_30404 === (2))){
var inst_30396 = (state_30403[(2)]);
var inst_30397 = (function (){var response = inst_30396;
return ((function (response,inst_30396,state_val_30404,c__7709__auto___30414,channel,map__30393,map__30393__$1,decoding_opts,decoding){
return (function (p1__30371_SHARP_){
return cljs_http.util.transit_decode(p1__30371_SHARP_,decoding,decoding_opts);
});
;})(response,inst_30396,state_val_30404,c__7709__auto___30414,channel,map__30393,map__30393__$1,decoding_opts,decoding))
})();
var inst_30398 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_30399 = cljs_http.client.decode_body(inst_30396,inst_30397,"application/transit+json",inst_30398);
var inst_30400 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_30399);
var inst_30401 = cljs.core.async.close_BANG_(channel);
var state_30403__$1 = (function (){var statearr_30405 = state_30403;
(statearr_30405[(7)] = inst_30400);

return statearr_30405;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30403__$1,inst_30401);
} else {
if((state_val_30404 === (1))){
var inst_30394 = (function (){var G__30406 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30406) : client.call(null,G__30406));
})();
var state_30403__$1 = state_30403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30403__$1,(2),inst_30394);
} else {
return null;
}
}
});})(c__7709__auto___30414,channel,map__30393,map__30393__$1,decoding_opts,decoding))
;
return ((function (switch__7647__auto__,c__7709__auto___30414,channel,map__30393,map__30393__$1,decoding_opts,decoding){
return (function() {
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0 = (function (){
var statearr_30410 = [null,null,null,null,null,null,null,null];
(statearr_30410[(0)] = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__);

(statearr_30410[(1)] = (1));

return statearr_30410;
});
var cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1 = (function (state_30403){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_30403);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e30411){if((e30411 instanceof Object)){
var ex__7651__auto__ = e30411;
var statearr_30412_30415 = state_30403;
(statearr_30412_30415[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30403);

return cljs.core.constant$keyword$recur;
} else {
throw e30411;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__30416 = state_30403;
state_30403 = G__30416;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__ = function(state_30403){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1.call(this,state_30403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_transit_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_transit_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___30414,channel,map__30393,map__30393__$1,decoding_opts,decoding))
})();
var state__7711__auto__ = (function (){var statearr_30413 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_30413[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___30414);

return statearr_30413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___30414,channel,map__30393,map__30393__$1,decoding_opts,decoding))
);


return channel;
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 * Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4124__auto__ = cljs.core.constant$keyword$json_DASH_params.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4124__auto__)){
var params = temp__4124__auto__;
var G__30419 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$json_DASH_params),cljs.core.constant$keyword$body,cljs_http.util.json_encode(params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/json");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30419) : client.call(null,G__30419));
} else {
var G__30420 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30420) : client.call(null,G__30420));
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
var channel = cljs_http.core.channel_for_request(request);
var c__7709__auto___30459 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___30459,channel){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___30459,channel){
return (function (state_30448){
var state_val_30449 = (state_30448[(1)]);
if((state_val_30449 === (2))){
var inst_30442 = (state_30448[(2)]);
var inst_30443 = cljs.core.constant$keyword$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request);
var inst_30444 = cljs_http.client.decode_body(inst_30442,cljs_http.util.json_decode,"application/json",inst_30443);
var inst_30445 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,inst_30444);
var inst_30446 = cljs.core.async.close_BANG_(channel);
var state_30448__$1 = (function (){var statearr_30450 = state_30448;
(statearr_30450[(7)] = inst_30445);

return statearr_30450;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30448__$1,inst_30446);
} else {
if((state_val_30449 === (1))){
var inst_30440 = (function (){var G__30451 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30451) : client.call(null,G__30451));
})();
var state_30448__$1 = state_30448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30448__$1,(2),inst_30440);
} else {
return null;
}
}
});})(c__7709__auto___30459,channel))
;
return ((function (switch__7647__auto__,c__7709__auto___30459,channel){
return (function() {
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto__ = null;
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0 = (function (){
var statearr_30455 = [null,null,null,null,null,null,null,null];
(statearr_30455[(0)] = cljs_http$client$wrap_json_response_$_state_machine__7648__auto__);

(statearr_30455[(1)] = (1));

return statearr_30455;
});
var cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1 = (function (state_30448){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_30448);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e30456){if((e30456 instanceof Object)){
var ex__7651__auto__ = e30456;
var statearr_30457_30460 = state_30448;
(statearr_30457_30460[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30448);

return cljs.core.constant$keyword$recur;
} else {
throw e30456;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__30461 = state_30448;
state_30448 = G__30461;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__ = function(state_30448){
switch(arguments.length){
case 0:
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1.call(this,state_30448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$client$wrap_json_response_$_state_machine__7648__auto____0;
cljs_http$client$wrap_json_response_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$client$wrap_json_response_$_state_machine__7648__auto____1;
return cljs_http$client$wrap_json_response_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___30459,channel))
})();
var state__7711__auto__ = (function (){var statearr_30458 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_30458[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___30459);

return statearr_30458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___30459,channel))
);


return channel;
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__30466){
var map__30467 = p__30466;
var map__30467__$1 = ((cljs.core.seq_QMARK_(map__30467))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30467):map__30467);
var req = map__30467__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30467__$1,cljs.core.constant$keyword$query_DASH_params);
if(cljs.core.truth_(query_params)){
var G__30468 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$query_DASH_params),cljs.core.constant$keyword$query_DASH_string,cljs_http.client.generate_query_string(query_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30468) : client.call(null,G__30468));
} else {
var G__30469 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30469) : client.call(null,G__30469));
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__30474){
var map__30475 = p__30474;
var map__30475__$1 = ((cljs.core.seq_QMARK_(map__30475))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30475):map__30475);
var request = map__30475__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30475__$1,cljs.core.constant$keyword$request_DASH_method);
var form_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30475__$1,cljs.core.constant$keyword$form_DASH_params);
if(cljs.core.truth_((function (){var and__4264__auto__ = form_params;
if(cljs.core.truth_(and__4264__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.constant$keyword$patch,null,cljs.core.constant$keyword$delete,null,cljs.core.constant$keyword$post,null,cljs.core.constant$keyword$put,null], null), null).call(null,request_method);
} else {
return and__4264__auto__;
}
})())){
var G__30476 = cljs.core.assoc_in(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request,cljs.core.constant$keyword$form_DASH_params),cljs.core.constant$keyword$body,cljs_http.client.generate_query_string(form_params)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"content-type"], null),"application/x-www-form-urlencoded");
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30476) : client.call(null,G__30476));
} else {
var G__30477 = request;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30477) : client.call(null,G__30477));
}
});
});
cljs_http.client.wrap_android_cors_bugfix = (function cljs_http$client$wrap_android_cors_bugfix(client){
return (function (request){
var G__30479 = (cljs.core.truth_(cljs_http.util.android_QMARK_())?cljs.core.assoc_in(request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$android], null),(function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})()):request);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30479) : client.call(null,G__30479));
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4124__auto__ = cljs.core.constant$keyword$method.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var m = temp__4124__auto__;
var G__30482 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$method),cljs.core.constant$keyword$request_DASH_method,m);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30482) : client.call(null,G__30482));
} else {
var G__30483 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30483) : client.call(null,G__30483));
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__30484_SHARP_){
var G__30486 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30484_SHARP_,cljs.core.constant$keyword$server_DASH_name,server_name);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30486) : client.call(null,G__30486));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__30492){
var map__30493 = p__30492;
var map__30493__$1 = ((cljs.core.seq_QMARK_(map__30493))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30493):map__30493);
var req = map__30493__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30493__$1,cljs.core.constant$keyword$query_DASH_params);
var temp__4124__auto__ = cljs_http.client.parse_url(cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4124__auto__)){
var spec = temp__4124__auto__;
var G__30494 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,spec], 0)),cljs.core.constant$keyword$url),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params], null),((function (spec,temp__4124__auto__,map__30493,map__30493__$1,req,query_params){
return (function (p1__30487_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__30487_SHARP_,query_params], 0));
});})(spec,temp__4124__auto__,map__30493,map__30493__$1,req,query_params))
);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30494) : client.call(null,G__30494));
} else {
var G__30495 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30495) : client.call(null,G__30495));
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 * an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__30498){
var vec__30499 = p__30498;
var credentials = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30499,(0),null);
return ((function (vec__30499,credentials){
return (function (req){
var credentials__$1 = (function (){var or__4276__auto__ = cljs.core.constant$keyword$basic_DASH_auth.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_(credentials__$1))){
var G__30500 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$basic_DASH_auth),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),cljs_http.util.basic_auth(credentials__$1));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30500) : client.call(null,G__30500));
} else {
var G__30501 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30501) : client.call(null,G__30501));
}
});
;})(vec__30499,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq30496){
var G__30497 = cljs.core.first(seq30496);
var seq30496__$1 = cljs.core.next(seq30496);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__30497,seq30496__$1);
});
/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4124__auto__ = cljs.core.constant$keyword$oauth_DASH_token.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4124__auto__)){
var oauth_token = temp__4124__auto__;
var G__30504 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.constant$keyword$oauth_DASH_token),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$headers,"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join(''));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30504) : client.call(null,G__30504));
} else {
var G__30505 = req;
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__30505) : client.call(null,G__30505));
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/client.
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_android_cors_bugfix(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_json_response(cljs_http.client.wrap_json_params(cljs_http.client.wrap_transit_response(cljs_http.client.wrap_transit_params(cljs_http.client.wrap_edn_response(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(request)))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request(cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30508){
var vec__30509 = p__30508;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30509,(0),null);
var G__30510 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$delete,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30510) : cljs_http.client.request.call(null,G__30510));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq30506){
var G__30507 = cljs.core.first(seq30506);
var seq30506__$1 = cljs.core.next(seq30506);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__30507,seq30506__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30513){
var vec__30514 = p__30513;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30514,(0),null);
var G__30515 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$get,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30515) : cljs_http.client.request.call(null,G__30515));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq30511){
var G__30512 = cljs.core.first(seq30511);
var seq30511__$1 = cljs.core.next(seq30511);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__30512,seq30511__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30518){
var vec__30519 = p__30518;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30519,(0),null);
var G__30520 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$head,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30520) : cljs_http.client.request.call(null,G__30520));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq30516){
var G__30517 = cljs.core.first(seq30516);
var seq30516__$1 = cljs.core.next(seq30516);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__30517,seq30516__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30523){
var vec__30524 = p__30523;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30524,(0),null);
var G__30525 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$move,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30525) : cljs_http.client.request.call(null,G__30525));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq30521){
var G__30522 = cljs.core.first(seq30521);
var seq30521__$1 = cljs.core.next(seq30521);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__30522,seq30521__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30528){
var vec__30529 = p__30528;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30529,(0),null);
var G__30530 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$options,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30530) : cljs_http.client.request.call(null,G__30530));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq30526){
var G__30527 = cljs.core.first(seq30526);
var seq30526__$1 = cljs.core.next(seq30526);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__30527,seq30526__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30533){
var vec__30534 = p__30533;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30534,(0),null);
var G__30535 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$patch,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30535) : cljs_http.client.request.call(null,G__30535));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq30531){
var G__30532 = cljs.core.first(seq30531);
var seq30531__$1 = cljs.core.next(seq30531);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__30532,seq30531__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30538){
var vec__30539 = p__30538;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30539,(0),null);
var G__30540 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$post,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30540) : cljs_http.client.request.call(null,G__30540));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq30536){
var G__30537 = cljs.core.first(seq30536);
var seq30536__$1 = cljs.core.next(seq30536);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__30537,seq30536__$1);
});
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__30543){
var vec__30544 = p__30543;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30544,(0),null);
var G__30545 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$method,cljs.core.constant$keyword$put,cljs.core.constant$keyword$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__30545) : cljs_http.client.request.call(null,G__30545));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq30541){
var G__30542 = cljs.core.first(seq30541);
var seq30541__$1 = cljs.core.next(seq30541);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__30542,seq30541__$1);
});
