// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(f){
if(typeof cljs.core.async.t30551 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30551 = (function (f,fn_handler,meta30552){
this.f = f;
this.fn_handler = fn_handler;
this.meta30552 = meta30552;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t30551.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t30551.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t30551.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t30551.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30553){
var self__ = this;
var _30553__$1 = this;
return self__.meta30552;
});

cljs.core.async.t30551.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30553,meta30552__$1){
var self__ = this;
var _30553__$1 = this;
return (new cljs.core.async.t30551(self__.f,self__.fn_handler,meta30552__$1));
});

cljs.core.async.t30551.cljs$lang$type = true;

cljs.core.async.t30551.cljs$lang$ctorStr = "cljs.core.async/t30551";

cljs.core.async.t30551.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t30551");
});

cljs.core.async.__GT_t30551 = (function cljs$core$async$fn_handler_$___GT_t30551(f__$1,fn_handler__$1,meta30552){
return (new cljs.core.async.t30551(f__$1,fn_handler__$1,meta30552));
});

}

return (new cljs.core.async.t30551(f,cljs$core$async$fn_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 * val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 * buffered, but oldest elements in buffer will be dropped (not
 * transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full.
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
var G__30555 = buff;
if(G__30555){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__30555.cljs$core$async$impl$protocols$UnblockingBuffer$;
}
})())){
return true;
} else {
if((!G__30555.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,G__30555);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,G__30555);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 * (filter p) etc or a composition thereof), and an optional exception handler.
 * If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 * transducer is supplied a buffer must be specified. ex-handler must be a
 * fn of one argument - if an exception occurs during transformation it will be called
 * with the thrown value as an argument, and any non-nil return value will be placed
 * in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(){
var G__30557 = arguments.length;
switch (G__30557) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 * return nil if closed. Will park if nothing is available.
 * Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(){
var G__30560 = arguments.length;
switch (G__30560) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(ret)){
var val_30565 = (function (){var G__30561 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30561) : cljs.core.deref.call(null,G__30561));
})();
if(cljs.core.truth_(on_caller_QMARK_)){
var G__30562_30566 = val_30565;
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__30562_30566) : fn1.call(null,G__30562_30566));
} else {
cljs.core.async.impl.dispatch.run(((function (val_30565,ret){
return (function (){
var G__30563 = val_30565;
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__30563) : fn1.call(null,G__30563));
});})(val_30565,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 * inside a (go ...) block. Will park if no buffer space is available.
 * Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(){
var G__30568 = arguments.length;
switch (G__30568) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4124__auto__)){
var ret = temp__4124__auto__;
var G__30569 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30569) : cljs.core.deref.call(null,G__30569));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4124__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler(fn1));
if(cljs.core.truth_(temp__4124__auto__)){
var retb = temp__4124__auto__;
var ret = (function (){var G__30570 = retb;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30570) : cljs.core.deref.call(null,G__30570));
})();
if(cljs.core.truth_(on_caller_QMARK_)){
var G__30571_30574 = ret;
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__30571_30574) : fn1.call(null,G__30571_30574));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4124__auto__){
return (function (){
var G__30572 = ret;
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(G__30572) : fn1.call(null,G__30572));
});})(ret,retb,temp__4124__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5161__auto___30575 = n;
var x_30576 = (0);
while(true){
if((x_30576 < n__5161__auto___30575)){
(a[x_30576] = (0));

var G__30577 = (x_30576 + (1));
x_30576 = G__30577;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__30578 = (i + (1));
i = G__30578;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (function (){var G__30586 = true;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30586) : cljs.core.atom.call(null,G__30586));
})();
if(typeof cljs.core.async.t30587 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30587 = (function (flag,alt_flag,meta30588){
this.flag = flag;
this.alt_flag = alt_flag;
this.meta30588 = meta30588;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t30587.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t30587.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30590 = self__.flag;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30590) : cljs.core.deref.call(null,G__30590));
});})(flag))
;

cljs.core.async.t30587.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__30591_30593 = self__.flag;
var G__30592_30594 = null;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30591_30593,G__30592_30594) : cljs.core.reset_BANG_.call(null,G__30591_30593,G__30592_30594));

return true;
});})(flag))
;

cljs.core.async.t30587.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_30589){
var self__ = this;
var _30589__$1 = this;
return self__.meta30588;
});})(flag))
;

cljs.core.async.t30587.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_30589,meta30588__$1){
var self__ = this;
var _30589__$1 = this;
return (new cljs.core.async.t30587(self__.flag,self__.alt_flag,meta30588__$1));
});})(flag))
;

cljs.core.async.t30587.cljs$lang$type = true;

cljs.core.async.t30587.cljs$lang$ctorStr = "cljs.core.async/t30587";

cljs.core.async.t30587.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t30587");
});})(flag))
;

cljs.core.async.__GT_t30587 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t30587(flag__$1,alt_flag__$1,meta30588){
return (new cljs.core.async.t30587(flag__$1,alt_flag__$1,meta30588));
});})(flag))
;

}

return (new cljs.core.async.t30587(flag,cljs$core$async$alt_flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t30598 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t30598 = (function (cb,flag,alt_handler,meta30599){
this.cb = cb;
this.flag = flag;
this.alt_handler = alt_handler;
this.meta30599 = meta30599;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t30598.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t30598.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t30598.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t30598.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30600){
var self__ = this;
var _30600__$1 = this;
return self__.meta30599;
});

cljs.core.async.t30598.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30600,meta30599__$1){
var self__ = this;
var _30600__$1 = this;
return (new cljs.core.async.t30598(self__.cb,self__.flag,self__.alt_handler,meta30599__$1));
});

cljs.core.async.t30598.cljs$lang$type = true;

cljs.core.async.t30598.cljs$lang$ctorStr = "cljs.core.async/t30598";

cljs.core.async.t30598.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t30598");
});

cljs.core.async.__GT_t30598 = (function cljs$core$async$alt_handler_$___GT_t30598(cb__$1,flag__$1,alt_handler__$1,meta30599){
return (new cljs.core.async.t30598(cb__$1,flag__$1,alt_handler__$1,meta30599));
});

}

return (new cljs.core.async.t30598(cb,flag,cljs$core$async$alt_handler,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.constant$keyword$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(function (){var G__30608 = (0);
return (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1(G__30608) : port.call(null,G__30608));
})():null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (function (){var G__30609 = (1);
return (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1(G__30609) : port.call(null,G__30609));
})();
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30601_SHARP_){
var G__30610 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30601_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30610) : fret.call(null,G__30610));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30602_SHARP_){
var G__30611 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30602_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30611) : fret.call(null,G__30611));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__30612 = vbox;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__30612) : cljs.core.deref.call(null,G__30612));
})(),(function (){var or__4276__auto__ = wport;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30613 = (i + (1));
i = G__30613;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4276__auto__ = ret;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.constant$keyword$default)){
var temp__4126__auto__ = (function (){var and__4264__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__4264__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__4264__auto__;
}
})();
if(cljs.core.truth_(temp__4126__auto__)){
var got = temp__4126__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.constant$keyword$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 * [channel-to-put-to val-to-put], in any combination. Takes will be
 * made as if by <!, and puts will be made as if by >!. Unless
 * the :priority option is true, if more than one port operation is
 * ready a non-deterministic choice will be made. If no operation is
 * ready and a :default value is supplied, [default-val :default] will
 * be returned, otherwise alts! will park until the first operation to
 * become ready completes. Returns [val port] of the completed
 * operation, where val is the value taken for takes, and a
 * boolean (true unless already closed, as per put!) for puts.
 * 
 * opts are passed as :key val ... Supported options:
 * 
 * :default val - the value to use if none of the operations are immediately ready
 * :priority true - (default nil) when true, the operations will be tried in order.
 * 
 * Note: there is no guarantee that the port exps or val exprs will be
 * used, nor in what order should they be, so they should not be
 * depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(){
var argseq__5316__auto__ = ((((1) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5316__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30616){
var map__30617 = p__30616;
var map__30617__$1 = ((cljs.core.seq_QMARK_(map__30617))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30617):map__30617);
var opts = map__30617__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30614){
var G__30615 = cljs.core.first(seq30614);
var seq30614__$1 = cljs.core.next(seq30614);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30615,seq30614__$1);
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(){
var G__30619 = arguments.length;
switch (G__30619) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__7709__auto___30668 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___30668){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___30668){
return (function (state_30643){
var state_val_30644 = (state_30643[(1)]);
if((state_val_30644 === (7))){
var inst_30639 = (state_30643[(2)]);
var state_30643__$1 = state_30643;
var statearr_30645_30669 = state_30643__$1;
(statearr_30645_30669[(2)] = inst_30639);

(statearr_30645_30669[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30644 === (1))){
var state_30643__$1 = state_30643;
var statearr_30646_30670 = state_30643__$1;
(statearr_30646_30670[(2)] = null);

(statearr_30646_30670[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30644 === (4))){
var inst_30622 = (state_30643[(7)]);
var inst_30622__$1 = (state_30643[(2)]);
var inst_30623 = (inst_30622__$1 == null);
var state_30643__$1 = (function (){var statearr_30647 = state_30643;
(statearr_30647[(7)] = inst_30622__$1);

return statearr_30647;
})();
if(cljs.core.truth_(inst_30623)){
var statearr_30648_30671 = state_30643__$1;
(statearr_30648_30671[(1)] = (5));

} else {
var statearr_30649_30672 = state_30643__$1;
(statearr_30649_30672[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30644 === (13))){
var state_30643__$1 = state_30643;
var statearr_30650_30673 = state_30643__$1;
(statearr_30650_30673[(2)] = null);

(statearr_30650_30673[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30644 === (6))){
var inst_30622 = (state_30643[(7)]);
var state_30643__$1 = state_30643;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30643__$1,(11),to,inst_30622);
} else {
if((state_val_30644 === (3))){
var inst_30641 = (state_30643[(2)]);
var state_30643__$1 = state_30643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30643__$1,inst_30641);
} else {
if((state_val_30644 === (12))){
var state_30643__$1 = state_30643;
var statearr_30651_30674 = state_30643__$1;
(statearr_30651_30674[(2)] = null);

(statearr_30651_30674[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30644 === (2))){
var state_30643__$1 = state_30643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30643__$1,(4),from);
} else {
if((state_val_30644 === (11))){
var inst_30632 = (state_30643[(2)]);
var state_30643__$1 = state_30643;
if(cljs.core.truth_(inst_30632)){
var statearr_30652_30675 = state_30643__$1;
(statearr_30652_30675[(1)] = (12));

} else {
var statearr_30653_30676 = state_30643__$1;
(statearr_30653_30676[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30644 === (9))){
var state_30643__$1 = state_30643;
var statearr_30654_30677 = state_30643__$1;
(statearr_30654_30677[(2)] = null);

(statearr_30654_30677[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30644 === (5))){
var state_30643__$1 = state_30643;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30655_30678 = state_30643__$1;
(statearr_30655_30678[(1)] = (8));

} else {
var statearr_30656_30679 = state_30643__$1;
(statearr_30656_30679[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30644 === (14))){
var inst_30637 = (state_30643[(2)]);
var state_30643__$1 = state_30643;
var statearr_30657_30680 = state_30643__$1;
(statearr_30657_30680[(2)] = inst_30637);

(statearr_30657_30680[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30644 === (10))){
var inst_30629 = (state_30643[(2)]);
var state_30643__$1 = state_30643;
var statearr_30658_30681 = state_30643__$1;
(statearr_30658_30681[(2)] = inst_30629);

(statearr_30658_30681[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30644 === (8))){
var inst_30626 = cljs.core.async.close_BANG_(to);
var state_30643__$1 = state_30643;
var statearr_30659_30682 = state_30643__$1;
(statearr_30659_30682[(2)] = inst_30626);

(statearr_30659_30682[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___30668))
;
return ((function (switch__7647__auto__,c__7709__auto___30668){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_30663 = [null,null,null,null,null,null,null,null];
(statearr_30663[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_30663[(1)] = (1));

return statearr_30663;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_30643){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_30643);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e30664){if((e30664 instanceof Object)){
var ex__7651__auto__ = e30664;
var statearr_30665_30683 = state_30643;
(statearr_30665_30683[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30643);

return cljs.core.constant$keyword$recur;
} else {
throw e30664;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__30684 = state_30643;
state_30643 = G__30684;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_30643){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_30643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___30668))
})();
var state__7711__auto__ = (function (){var statearr_30666 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_30666[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___30668);

return statearr_30666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___30668))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__30870){
var vec__30871 = p__30870;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30871,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30871,(1),null);
var job = vec__30871;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__7709__auto___31055 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___31055,res,vec__30871,v,p,job,jobs,results){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___31055,res,vec__30871,v,p,job,jobs,results){
return (function (state_30876){
var state_val_30877 = (state_30876[(1)]);
if((state_val_30877 === (2))){
var inst_30873 = (state_30876[(2)]);
var inst_30874 = cljs.core.async.close_BANG_(res);
var state_30876__$1 = (function (){var statearr_30878 = state_30876;
(statearr_30878[(7)] = inst_30873);

return statearr_30878;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30876__$1,inst_30874);
} else {
if((state_val_30877 === (1))){
var state_30876__$1 = state_30876;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30876__$1,(2),res,v);
} else {
return null;
}
}
});})(c__7709__auto___31055,res,vec__30871,v,p,job,jobs,results))
;
return ((function (switch__7647__auto__,c__7709__auto___31055,res,vec__30871,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_30882 = [null,null,null,null,null,null,null,null];
(statearr_30882[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_30882[(1)] = (1));

return statearr_30882;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_30876){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_30876);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e30883){if((e30883 instanceof Object)){
var ex__7651__auto__ = e30883;
var statearr_30884_31056 = state_30876;
(statearr_30884_31056[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30876);

return cljs.core.constant$keyword$recur;
} else {
throw e30883;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__31057 = state_30876;
state_30876 = G__31057;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_30876){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_30876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___31055,res,vec__30871,v,p,job,jobs,results))
})();
var state__7711__auto__ = (function (){var statearr_30885 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_30885[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___31055);

return statearr_30885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___31055,res,vec__30871,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__30886){
var vec__30887 = p__30886;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30887,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30887,(1),null);
var job = vec__30887;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var G__30888_31058 = v;
var G__30889_31059 = res;
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(G__30888_31058,G__30889_31059) : xf.call(null,G__30888_31058,G__30889_31059));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__5161__auto___31060 = n;
var __31061 = (0);
while(true){
if((__31061 < n__5161__auto___31060)){
var G__30890_31062 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__30890_31062) {
case "async":
var c__7709__auto___31064 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31061,c__7709__auto___31064,G__30890_31062,n__5161__auto___31060,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__31061,c__7709__auto___31064,G__30890_31062,n__5161__auto___31060,jobs,results,process,async){
return (function (state_30903){
var state_val_30904 = (state_30903[(1)]);
if((state_val_30904 === (7))){
var inst_30899 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
var statearr_30905_31065 = state_30903__$1;
(statearr_30905_31065[(2)] = inst_30899);

(statearr_30905_31065[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30904 === (6))){
var state_30903__$1 = state_30903;
var statearr_30906_31066 = state_30903__$1;
(statearr_30906_31066[(2)] = null);

(statearr_30906_31066[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30904 === (5))){
var state_30903__$1 = state_30903;
var statearr_30907_31067 = state_30903__$1;
(statearr_30907_31067[(2)] = null);

(statearr_30907_31067[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30904 === (4))){
var inst_30893 = (state_30903[(2)]);
var inst_30894 = async(inst_30893);
var state_30903__$1 = state_30903;
if(cljs.core.truth_(inst_30894)){
var statearr_30908_31068 = state_30903__$1;
(statearr_30908_31068[(1)] = (5));

} else {
var statearr_30909_31069 = state_30903__$1;
(statearr_30909_31069[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30904 === (3))){
var inst_30901 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30903__$1,inst_30901);
} else {
if((state_val_30904 === (2))){
var state_30903__$1 = state_30903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30903__$1,(4),jobs);
} else {
if((state_val_30904 === (1))){
var state_30903__$1 = state_30903;
var statearr_30910_31070 = state_30903__$1;
(statearr_30910_31070[(2)] = null);

(statearr_30910_31070[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31061,c__7709__auto___31064,G__30890_31062,n__5161__auto___31060,jobs,results,process,async))
;
return ((function (__31061,switch__7647__auto__,c__7709__auto___31064,G__30890_31062,n__5161__auto___31060,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_30914 = [null,null,null,null,null,null,null];
(statearr_30914[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_30914[(1)] = (1));

return statearr_30914;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_30903){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_30903);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e30915){if((e30915 instanceof Object)){
var ex__7651__auto__ = e30915;
var statearr_30916_31071 = state_30903;
(statearr_30916_31071[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30903);

return cljs.core.constant$keyword$recur;
} else {
throw e30915;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__31072 = state_30903;
state_30903 = G__31072;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_30903){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_30903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__31061,switch__7647__auto__,c__7709__auto___31064,G__30890_31062,n__5161__auto___31060,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_30917 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_30917[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___31064);

return statearr_30917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(__31061,c__7709__auto___31064,G__30890_31062,n__5161__auto___31060,jobs,results,process,async))
);


break;
case "compute":
var c__7709__auto___31073 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31061,c__7709__auto___31073,G__30890_31062,n__5161__auto___31060,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (__31061,c__7709__auto___31073,G__30890_31062,n__5161__auto___31060,jobs,results,process,async){
return (function (state_30930){
var state_val_30931 = (state_30930[(1)]);
if((state_val_30931 === (7))){
var inst_30926 = (state_30930[(2)]);
var state_30930__$1 = state_30930;
var statearr_30932_31074 = state_30930__$1;
(statearr_30932_31074[(2)] = inst_30926);

(statearr_30932_31074[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30931 === (6))){
var state_30930__$1 = state_30930;
var statearr_30933_31075 = state_30930__$1;
(statearr_30933_31075[(2)] = null);

(statearr_30933_31075[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30931 === (5))){
var state_30930__$1 = state_30930;
var statearr_30934_31076 = state_30930__$1;
(statearr_30934_31076[(2)] = null);

(statearr_30934_31076[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30931 === (4))){
var inst_30920 = (state_30930[(2)]);
var inst_30921 = process(inst_30920);
var state_30930__$1 = state_30930;
if(cljs.core.truth_(inst_30921)){
var statearr_30935_31077 = state_30930__$1;
(statearr_30935_31077[(1)] = (5));

} else {
var statearr_30936_31078 = state_30930__$1;
(statearr_30936_31078[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30931 === (3))){
var inst_30928 = (state_30930[(2)]);
var state_30930__$1 = state_30930;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30930__$1,inst_30928);
} else {
if((state_val_30931 === (2))){
var state_30930__$1 = state_30930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30930__$1,(4),jobs);
} else {
if((state_val_30931 === (1))){
var state_30930__$1 = state_30930;
var statearr_30937_31079 = state_30930__$1;
(statearr_30937_31079[(2)] = null);

(statearr_30937_31079[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31061,c__7709__auto___31073,G__30890_31062,n__5161__auto___31060,jobs,results,process,async))
;
return ((function (__31061,switch__7647__auto__,c__7709__auto___31073,G__30890_31062,n__5161__auto___31060,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_30941 = [null,null,null,null,null,null,null];
(statearr_30941[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_30941[(1)] = (1));

return statearr_30941;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_30930){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_30930);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e30942){if((e30942 instanceof Object)){
var ex__7651__auto__ = e30942;
var statearr_30943_31080 = state_30930;
(statearr_30943_31080[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30930);

return cljs.core.constant$keyword$recur;
} else {
throw e30942;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__31081 = state_30930;
state_30930 = G__31081;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_30930){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_30930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(__31061,switch__7647__auto__,c__7709__auto___31073,G__30890_31062,n__5161__auto___31060,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_30944 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_30944[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___31073);

return statearr_30944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(__31061,c__7709__auto___31073,G__30890_31062,n__5161__auto___31060,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__31082 = (__31061 + (1));
__31061 = G__31082;
continue;
} else {
}
break;
}

var c__7709__auto___31083 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___31083,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___31083,jobs,results,process,async){
return (function (state_30966){
var state_val_30967 = (state_30966[(1)]);
if((state_val_30967 === (9))){
var inst_30959 = (state_30966[(2)]);
var state_30966__$1 = (function (){var statearr_30968 = state_30966;
(statearr_30968[(7)] = inst_30959);

return statearr_30968;
})();
var statearr_30969_31084 = state_30966__$1;
(statearr_30969_31084[(2)] = null);

(statearr_30969_31084[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30967 === (8))){
var inst_30952 = (state_30966[(8)]);
var inst_30957 = (state_30966[(2)]);
var state_30966__$1 = (function (){var statearr_30970 = state_30966;
(statearr_30970[(9)] = inst_30957);

return statearr_30970;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30966__$1,(9),results,inst_30952);
} else {
if((state_val_30967 === (7))){
var inst_30962 = (state_30966[(2)]);
var state_30966__$1 = state_30966;
var statearr_30971_31085 = state_30966__$1;
(statearr_30971_31085[(2)] = inst_30962);

(statearr_30971_31085[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30967 === (6))){
var inst_30952 = (state_30966[(8)]);
var inst_30947 = (state_30966[(10)]);
var inst_30952__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_30953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30954 = [inst_30947,inst_30952__$1];
var inst_30955 = (new cljs.core.PersistentVector(null,2,(5),inst_30953,inst_30954,null));
var state_30966__$1 = (function (){var statearr_30972 = state_30966;
(statearr_30972[(8)] = inst_30952__$1);

return statearr_30972;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30966__$1,(8),jobs,inst_30955);
} else {
if((state_val_30967 === (5))){
var inst_30950 = cljs.core.async.close_BANG_(jobs);
var state_30966__$1 = state_30966;
var statearr_30973_31086 = state_30966__$1;
(statearr_30973_31086[(2)] = inst_30950);

(statearr_30973_31086[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_30967 === (4))){
var inst_30947 = (state_30966[(10)]);
var inst_30947__$1 = (state_30966[(2)]);
var inst_30948 = (inst_30947__$1 == null);
var state_30966__$1 = (function (){var statearr_30974 = state_30966;
(statearr_30974[(10)] = inst_30947__$1);

return statearr_30974;
})();
if(cljs.core.truth_(inst_30948)){
var statearr_30975_31087 = state_30966__$1;
(statearr_30975_31087[(1)] = (5));

} else {
var statearr_30976_31088 = state_30966__$1;
(statearr_30976_31088[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_30967 === (3))){
var inst_30964 = (state_30966[(2)]);
var state_30966__$1 = state_30966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30966__$1,inst_30964);
} else {
if((state_val_30967 === (2))){
var state_30966__$1 = state_30966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30966__$1,(4),from);
} else {
if((state_val_30967 === (1))){
var state_30966__$1 = state_30966;
var statearr_30977_31089 = state_30966__$1;
(statearr_30977_31089[(2)] = null);

(statearr_30977_31089[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___31083,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto___31083,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_30981 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30981[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_30981[(1)] = (1));

return statearr_30981;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_30966){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_30966);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e30982){if((e30982 instanceof Object)){
var ex__7651__auto__ = e30982;
var statearr_30983_31090 = state_30966;
(statearr_30983_31090[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_30966);

return cljs.core.constant$keyword$recur;
} else {
throw e30982;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__31091 = state_30966;
state_30966 = G__31091;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_30966){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_30966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___31083,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_30984 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_30984[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___31083);

return statearr_30984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___31083,jobs,results,process,async))
);


var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__,jobs,results,process,async){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__,jobs,results,process,async){
return (function (state_31022){
var state_val_31023 = (state_31022[(1)]);
if((state_val_31023 === (7))){
var inst_31018 = (state_31022[(2)]);
var state_31022__$1 = state_31022;
var statearr_31024_31092 = state_31022__$1;
(statearr_31024_31092[(2)] = inst_31018);

(statearr_31024_31092[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (20))){
var state_31022__$1 = state_31022;
var statearr_31025_31093 = state_31022__$1;
(statearr_31025_31093[(2)] = null);

(statearr_31025_31093[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (1))){
var state_31022__$1 = state_31022;
var statearr_31026_31094 = state_31022__$1;
(statearr_31026_31094[(2)] = null);

(statearr_31026_31094[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (4))){
var inst_30987 = (state_31022[(7)]);
var inst_30987__$1 = (state_31022[(2)]);
var inst_30988 = (inst_30987__$1 == null);
var state_31022__$1 = (function (){var statearr_31027 = state_31022;
(statearr_31027[(7)] = inst_30987__$1);

return statearr_31027;
})();
if(cljs.core.truth_(inst_30988)){
var statearr_31028_31095 = state_31022__$1;
(statearr_31028_31095[(1)] = (5));

} else {
var statearr_31029_31096 = state_31022__$1;
(statearr_31029_31096[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (15))){
var inst_31000 = (state_31022[(8)]);
var state_31022__$1 = state_31022;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31022__$1,(18),to,inst_31000);
} else {
if((state_val_31023 === (21))){
var inst_31013 = (state_31022[(2)]);
var state_31022__$1 = state_31022;
var statearr_31030_31097 = state_31022__$1;
(statearr_31030_31097[(2)] = inst_31013);

(statearr_31030_31097[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (13))){
var inst_31015 = (state_31022[(2)]);
var state_31022__$1 = (function (){var statearr_31031 = state_31022;
(statearr_31031[(9)] = inst_31015);

return statearr_31031;
})();
var statearr_31032_31098 = state_31022__$1;
(statearr_31032_31098[(2)] = null);

(statearr_31032_31098[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (6))){
var inst_30987 = (state_31022[(7)]);
var state_31022__$1 = state_31022;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31022__$1,(11),inst_30987);
} else {
if((state_val_31023 === (17))){
var inst_31008 = (state_31022[(2)]);
var state_31022__$1 = state_31022;
if(cljs.core.truth_(inst_31008)){
var statearr_31033_31099 = state_31022__$1;
(statearr_31033_31099[(1)] = (19));

} else {
var statearr_31034_31100 = state_31022__$1;
(statearr_31034_31100[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (3))){
var inst_31020 = (state_31022[(2)]);
var state_31022__$1 = state_31022;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31022__$1,inst_31020);
} else {
if((state_val_31023 === (12))){
var inst_30997 = (state_31022[(10)]);
var state_31022__$1 = state_31022;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31022__$1,(14),inst_30997);
} else {
if((state_val_31023 === (2))){
var state_31022__$1 = state_31022;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31022__$1,(4),results);
} else {
if((state_val_31023 === (19))){
var state_31022__$1 = state_31022;
var statearr_31035_31101 = state_31022__$1;
(statearr_31035_31101[(2)] = null);

(statearr_31035_31101[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (11))){
var inst_30997 = (state_31022[(2)]);
var state_31022__$1 = (function (){var statearr_31036 = state_31022;
(statearr_31036[(10)] = inst_30997);

return statearr_31036;
})();
var statearr_31037_31102 = state_31022__$1;
(statearr_31037_31102[(2)] = null);

(statearr_31037_31102[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (9))){
var state_31022__$1 = state_31022;
var statearr_31038_31103 = state_31022__$1;
(statearr_31038_31103[(2)] = null);

(statearr_31038_31103[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (5))){
var state_31022__$1 = state_31022;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31039_31104 = state_31022__$1;
(statearr_31039_31104[(1)] = (8));

} else {
var statearr_31040_31105 = state_31022__$1;
(statearr_31040_31105[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (14))){
var inst_31002 = (state_31022[(11)]);
var inst_31000 = (state_31022[(8)]);
var inst_31000__$1 = (state_31022[(2)]);
var inst_31001 = (inst_31000__$1 == null);
var inst_31002__$1 = cljs.core.not(inst_31001);
var state_31022__$1 = (function (){var statearr_31041 = state_31022;
(statearr_31041[(11)] = inst_31002__$1);

(statearr_31041[(8)] = inst_31000__$1);

return statearr_31041;
})();
if(inst_31002__$1){
var statearr_31042_31106 = state_31022__$1;
(statearr_31042_31106[(1)] = (15));

} else {
var statearr_31043_31107 = state_31022__$1;
(statearr_31043_31107[(1)] = (16));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (16))){
var inst_31002 = (state_31022[(11)]);
var state_31022__$1 = state_31022;
var statearr_31044_31108 = state_31022__$1;
(statearr_31044_31108[(2)] = inst_31002);

(statearr_31044_31108[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (10))){
var inst_30994 = (state_31022[(2)]);
var state_31022__$1 = state_31022;
var statearr_31045_31109 = state_31022__$1;
(statearr_31045_31109[(2)] = inst_30994);

(statearr_31045_31109[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (18))){
var inst_31005 = (state_31022[(2)]);
var state_31022__$1 = state_31022;
var statearr_31046_31110 = state_31022__$1;
(statearr_31046_31110[(2)] = inst_31005);

(statearr_31046_31110[(1)] = (17));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31023 === (8))){
var inst_30991 = cljs.core.async.close_BANG_(to);
var state_31022__$1 = state_31022;
var statearr_31047_31111 = state_31022__$1;
(statearr_31047_31111[(2)] = inst_30991);

(statearr_31047_31111[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__,jobs,results,process,async))
;
return ((function (switch__7647__auto__,c__7709__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_31051 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31051[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__);

(statearr_31051[(1)] = (1));

return statearr_31051;
});
var cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1 = (function (state_31022){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_31022);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e31052){if((e31052 instanceof Object)){
var ex__7651__auto__ = e31052;
var statearr_31053_31112 = state_31022;
(statearr_31053_31112[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31022);

return cljs.core.constant$keyword$recur;
} else {
throw e31052;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__31113 = state_31022;
state_31022 = G__31113;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__ = function(state_31022){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1.call(this,state_31022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__,jobs,results,process,async))
})();
var state__7711__auto__ = (function (){var statearr_31054 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_31054[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_31054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__,jobs,results,process,async))
);

return c__7709__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the async function af, with parallelism n. af
 * must be a function of two arguments, the first an input value and
 * the second a channel on which to place the result(s). af must close!
 * the channel before returning.  The presumption is that af will
 * return immediately, having launched some asynchronous operation
 * whose completion/callback will manipulate the result channel. Outputs
 * will be returned in order relative to  the inputs. By default, the to
 * channel will be closed when the from channel closes, but can be
 * determined by the close?  parameter. Will stop consuming the from
 * channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(){
var G__31115 = arguments.length;
switch (G__31115) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.constant$keyword$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 * channel, subject to the transducer xf, with parallelism n. Because
 * it is parallel, the transducer will be applied independently to each
 * element, not across elements, and may produce zero or more outputs
 * per input.  Outputs will be returned in order relative to the
 * inputs. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes.
 * 
 * Note this is supplied for API compatibility with the Clojure version.
 * Values of N > 1 will not result in actual concurrency in a
 * single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(){
var G__31118 = arguments.length;
switch (G__31118) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.constant$keyword$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 * channels, the first of which will contain the values for which the
 * predicate returned true, the second those for which it returned
 * false.
 * 
 * The out channels will be unbuffered by default, or two buf-or-ns can
 * be supplied. The channels will close after the source channel has
 * closed.
 */
cljs.core.async.split = (function cljs$core$async$split(){
var G__31121 = arguments.length;
switch (G__31121) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__7709__auto___31174 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___31174,tc,fc){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___31174,tc,fc){
return (function (state_31147){
var state_val_31148 = (state_31147[(1)]);
if((state_val_31148 === (7))){
var inst_31143 = (state_31147[(2)]);
var state_31147__$1 = state_31147;
var statearr_31149_31175 = state_31147__$1;
(statearr_31149_31175[(2)] = inst_31143);

(statearr_31149_31175[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31148 === (1))){
var state_31147__$1 = state_31147;
var statearr_31150_31176 = state_31147__$1;
(statearr_31150_31176[(2)] = null);

(statearr_31150_31176[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31148 === (4))){
var inst_31124 = (state_31147[(7)]);
var inst_31124__$1 = (state_31147[(2)]);
var inst_31125 = (inst_31124__$1 == null);
var state_31147__$1 = (function (){var statearr_31151 = state_31147;
(statearr_31151[(7)] = inst_31124__$1);

return statearr_31151;
})();
if(cljs.core.truth_(inst_31125)){
var statearr_31152_31177 = state_31147__$1;
(statearr_31152_31177[(1)] = (5));

} else {
var statearr_31153_31178 = state_31147__$1;
(statearr_31153_31178[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31148 === (13))){
var state_31147__$1 = state_31147;
var statearr_31154_31179 = state_31147__$1;
(statearr_31154_31179[(2)] = null);

(statearr_31154_31179[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31148 === (6))){
var inst_31124 = (state_31147[(7)]);
var inst_31130 = (function (){var G__31155 = inst_31124;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__31155) : p.call(null,G__31155));
})();
var state_31147__$1 = state_31147;
if(cljs.core.truth_(inst_31130)){
var statearr_31156_31180 = state_31147__$1;
(statearr_31156_31180[(1)] = (9));

} else {
var statearr_31157_31181 = state_31147__$1;
(statearr_31157_31181[(1)] = (10));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31148 === (3))){
var inst_31145 = (state_31147[(2)]);
var state_31147__$1 = state_31147;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31147__$1,inst_31145);
} else {
if((state_val_31148 === (12))){
var state_31147__$1 = state_31147;
var statearr_31158_31182 = state_31147__$1;
(statearr_31158_31182[(2)] = null);

(statearr_31158_31182[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31148 === (2))){
var state_31147__$1 = state_31147;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31147__$1,(4),ch);
} else {
if((state_val_31148 === (11))){
var inst_31124 = (state_31147[(7)]);
var inst_31134 = (state_31147[(2)]);
var state_31147__$1 = state_31147;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31147__$1,(8),inst_31134,inst_31124);
} else {
if((state_val_31148 === (9))){
var state_31147__$1 = state_31147;
var statearr_31159_31183 = state_31147__$1;
(statearr_31159_31183[(2)] = tc);

(statearr_31159_31183[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31148 === (5))){
var inst_31127 = cljs.core.async.close_BANG_(tc);
var inst_31128 = cljs.core.async.close_BANG_(fc);
var state_31147__$1 = (function (){var statearr_31160 = state_31147;
(statearr_31160[(8)] = inst_31127);

return statearr_31160;
})();
var statearr_31161_31184 = state_31147__$1;
(statearr_31161_31184[(2)] = inst_31128);

(statearr_31161_31184[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31148 === (14))){
var inst_31141 = (state_31147[(2)]);
var state_31147__$1 = state_31147;
var statearr_31162_31185 = state_31147__$1;
(statearr_31162_31185[(2)] = inst_31141);

(statearr_31162_31185[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31148 === (10))){
var state_31147__$1 = state_31147;
var statearr_31163_31186 = state_31147__$1;
(statearr_31163_31186[(2)] = fc);

(statearr_31163_31186[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31148 === (8))){
var inst_31136 = (state_31147[(2)]);
var state_31147__$1 = state_31147;
if(cljs.core.truth_(inst_31136)){
var statearr_31164_31187 = state_31147__$1;
(statearr_31164_31187[(1)] = (12));

} else {
var statearr_31165_31188 = state_31147__$1;
(statearr_31165_31188[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___31174,tc,fc))
;
return ((function (switch__7647__auto__,c__7709__auto___31174,tc,fc){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_31169 = [null,null,null,null,null,null,null,null,null];
(statearr_31169[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_31169[(1)] = (1));

return statearr_31169;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_31147){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_31147);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e31170){if((e31170 instanceof Object)){
var ex__7651__auto__ = e31170;
var statearr_31171_31189 = state_31147;
(statearr_31171_31189[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31147);

return cljs.core.constant$keyword$recur;
} else {
throw e31170;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__31190 = state_31147;
state_31147 = G__31190;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_31147){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_31147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___31174,tc,fc))
})();
var state__7711__auto__ = (function (){var statearr_31172 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_31172[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___31174);

return statearr_31172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___31174,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 * the single result of applying f to init and the first item from the
 * channel, then applying f to that result and the 2nd item, etc. If
 * the channel closes without yielding items, returns init and f is not
 * called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_31239){
var state_val_31240 = (state_31239[(1)]);
if((state_val_31240 === (7))){
var inst_31235 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
var statearr_31241_31259 = state_31239__$1;
(statearr_31241_31259[(2)] = inst_31235);

(statearr_31241_31259[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (6))){
var inst_31225 = (state_31239[(7)]);
var inst_31228 = (state_31239[(8)]);
var inst_31232 = (function (){var G__31242 = inst_31225;
var G__31243 = inst_31228;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__31242,G__31243) : f.call(null,G__31242,G__31243));
})();
var inst_31225__$1 = inst_31232;
var state_31239__$1 = (function (){var statearr_31244 = state_31239;
(statearr_31244[(7)] = inst_31225__$1);

return statearr_31244;
})();
var statearr_31245_31260 = state_31239__$1;
(statearr_31245_31260[(2)] = null);

(statearr_31245_31260[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (5))){
var inst_31225 = (state_31239[(7)]);
var state_31239__$1 = state_31239;
var statearr_31246_31261 = state_31239__$1;
(statearr_31246_31261[(2)] = inst_31225);

(statearr_31246_31261[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (4))){
var inst_31228 = (state_31239[(8)]);
var inst_31228__$1 = (state_31239[(2)]);
var inst_31229 = (inst_31228__$1 == null);
var state_31239__$1 = (function (){var statearr_31247 = state_31239;
(statearr_31247[(8)] = inst_31228__$1);

return statearr_31247;
})();
if(cljs.core.truth_(inst_31229)){
var statearr_31248_31262 = state_31239__$1;
(statearr_31248_31262[(1)] = (5));

} else {
var statearr_31249_31263 = state_31239__$1;
(statearr_31249_31263[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31240 === (3))){
var inst_31237 = (state_31239[(2)]);
var state_31239__$1 = state_31239;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31239__$1,inst_31237);
} else {
if((state_val_31240 === (2))){
var state_31239__$1 = state_31239;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31239__$1,(4),ch);
} else {
if((state_val_31240 === (1))){
var inst_31225 = init;
var state_31239__$1 = (function (){var statearr_31250 = state_31239;
(statearr_31250[(7)] = inst_31225);

return statearr_31250;
})();
var statearr_31251_31264 = state_31239__$1;
(statearr_31251_31264[(2)] = null);

(statearr_31251_31264[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__7648__auto__ = null;
var cljs$core$async$reduce_$_state_machine__7648__auto____0 = (function (){
var statearr_31255 = [null,null,null,null,null,null,null,null,null];
(statearr_31255[(0)] = cljs$core$async$reduce_$_state_machine__7648__auto__);

(statearr_31255[(1)] = (1));

return statearr_31255;
});
var cljs$core$async$reduce_$_state_machine__7648__auto____1 = (function (state_31239){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_31239);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e31256){if((e31256 instanceof Object)){
var ex__7651__auto__ = e31256;
var statearr_31257_31265 = state_31239;
(statearr_31257_31265[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31239);

return cljs.core.constant$keyword$recur;
} else {
throw e31256;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__31266 = state_31239;
state_31239 = G__31266;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__7648__auto__ = function(state_31239){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__7648__auto____1.call(this,state_31239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__7648__auto____0;
cljs$core$async$reduce_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__7648__auto____1;
return cljs$core$async$reduce_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_31258 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_31258[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_31258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 * By default the channel will be closed after the items are copied,
 * but can be determined by the close? parameter.
 * 
 * Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(){
var G__31268 = arguments.length;
switch (G__31268) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_31293){
var state_val_31294 = (state_31293[(1)]);
if((state_val_31294 === (7))){
var inst_31275 = (state_31293[(2)]);
var state_31293__$1 = state_31293;
var statearr_31295_31319 = state_31293__$1;
(statearr_31295_31319[(2)] = inst_31275);

(statearr_31295_31319[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31294 === (1))){
var inst_31269 = cljs.core.seq(coll);
var inst_31270 = inst_31269;
var state_31293__$1 = (function (){var statearr_31296 = state_31293;
(statearr_31296[(7)] = inst_31270);

return statearr_31296;
})();
var statearr_31297_31320 = state_31293__$1;
(statearr_31297_31320[(2)] = null);

(statearr_31297_31320[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31294 === (4))){
var inst_31270 = (state_31293[(7)]);
var inst_31273 = cljs.core.first(inst_31270);
var state_31293__$1 = state_31293;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31293__$1,(7),ch,inst_31273);
} else {
if((state_val_31294 === (13))){
var inst_31287 = (state_31293[(2)]);
var state_31293__$1 = state_31293;
var statearr_31298_31321 = state_31293__$1;
(statearr_31298_31321[(2)] = inst_31287);

(statearr_31298_31321[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31294 === (6))){
var inst_31278 = (state_31293[(2)]);
var state_31293__$1 = state_31293;
if(cljs.core.truth_(inst_31278)){
var statearr_31299_31322 = state_31293__$1;
(statearr_31299_31322[(1)] = (8));

} else {
var statearr_31300_31323 = state_31293__$1;
(statearr_31300_31323[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31294 === (3))){
var inst_31291 = (state_31293[(2)]);
var state_31293__$1 = state_31293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31293__$1,inst_31291);
} else {
if((state_val_31294 === (12))){
var state_31293__$1 = state_31293;
var statearr_31301_31324 = state_31293__$1;
(statearr_31301_31324[(2)] = null);

(statearr_31301_31324[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31294 === (2))){
var inst_31270 = (state_31293[(7)]);
var state_31293__$1 = state_31293;
if(cljs.core.truth_(inst_31270)){
var statearr_31302_31325 = state_31293__$1;
(statearr_31302_31325[(1)] = (4));

} else {
var statearr_31303_31326 = state_31293__$1;
(statearr_31303_31326[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31294 === (11))){
var inst_31284 = cljs.core.async.close_BANG_(ch);
var state_31293__$1 = state_31293;
var statearr_31304_31327 = state_31293__$1;
(statearr_31304_31327[(2)] = inst_31284);

(statearr_31304_31327[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31294 === (9))){
var state_31293__$1 = state_31293;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31305_31328 = state_31293__$1;
(statearr_31305_31328[(1)] = (11));

} else {
var statearr_31306_31329 = state_31293__$1;
(statearr_31306_31329[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31294 === (5))){
var inst_31270 = (state_31293[(7)]);
var state_31293__$1 = state_31293;
var statearr_31307_31330 = state_31293__$1;
(statearr_31307_31330[(2)] = inst_31270);

(statearr_31307_31330[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31294 === (10))){
var inst_31289 = (state_31293[(2)]);
var state_31293__$1 = state_31293;
var statearr_31308_31331 = state_31293__$1;
(statearr_31308_31331[(2)] = inst_31289);

(statearr_31308_31331[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31294 === (8))){
var inst_31270 = (state_31293[(7)]);
var inst_31280 = cljs.core.next(inst_31270);
var inst_31270__$1 = inst_31280;
var state_31293__$1 = (function (){var statearr_31309 = state_31293;
(statearr_31309[(7)] = inst_31270__$1);

return statearr_31309;
})();
var statearr_31310_31332 = state_31293__$1;
(statearr_31310_31332[(2)] = null);

(statearr_31310_31332[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_31314 = [null,null,null,null,null,null,null,null];
(statearr_31314[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_31314[(1)] = (1));

return statearr_31314;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_31293){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_31293);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e31315){if((e31315 instanceof Object)){
var ex__7651__auto__ = e31315;
var statearr_31316_31333 = state_31293;
(statearr_31316_31333[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31293);

return cljs.core.constant$keyword$recur;
} else {
throw e31315;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__31334 = state_31293;
state_31293 = G__31334;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_31293){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_31293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_31317 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_31317[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_31317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 * closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

cljs.core.async.Mux = (function (){var obj31336 = {};
return obj31336;
})();

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((function (){var and__4264__auto__ = _;
if(and__4264__auto__){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4912__auto__ = (((_ == null))?null:_);
return (function (){var or__4276__auto__ = (cljs.core.async.muxch_STAR_[(function (){var G__31340 = x__4912__auto__;
return goog.typeOf(G__31340);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
})().call(null,_);
}
});


cljs.core.async.Mult = (function (){var obj31342 = {};
return obj31342;
})();

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$tap_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.tap_STAR_[(function (){var G__31346 = x__4912__auto__;
return goog.typeOf(G__31346);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
})().call(null,m,ch,close_QMARK_);
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_STAR_[(function (){var G__31350 = x__4912__auto__;
return goog.typeOf(G__31350);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.untap_all_STAR_[(function (){var G__31354 = x__4912__auto__;
return goog.typeOf(G__31354);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
})().call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 * containing copies of the channel can be created with 'tap', and
 * detached with 'untap'.
 * 
 * Each item is distributed to all taps in parallel and synchronously,
 * i.e. each tap must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow taps from holding up the mult.
 * 
 * Items received when there are no taps get dropped.
 * 
 * If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__31584 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31584) : cljs.core.atom.call(null,G__31584));
})();
var m = (function (){
if(typeof cljs.core.async.t31585 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t31585 = (function (cs,ch,mult,meta31586){
this.cs = cs;
this.ch = ch;
this.mult = mult;
this.meta31586 = meta31586;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t31585.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t31585.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t31585.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t31585.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__31588_31813 = self__.cs;
var G__31589_31814 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__31588_31813,G__31589_31814) : cljs.core.reset_BANG_.call(null,G__31588_31813,G__31589_31814));

return null;
});})(cs))
;

cljs.core.async.t31585.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t31585.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t31585.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_31587){
var self__ = this;
var _31587__$1 = this;
return self__.meta31586;
});})(cs))
;

cljs.core.async.t31585.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_31587,meta31586__$1){
var self__ = this;
var _31587__$1 = this;
return (new cljs.core.async.t31585(self__.cs,self__.ch,self__.mult,meta31586__$1));
});})(cs))
;

cljs.core.async.t31585.cljs$lang$type = true;

cljs.core.async.t31585.cljs$lang$ctorStr = "cljs.core.async/t31585";

cljs.core.async.t31585.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t31585");
});})(cs))
;

cljs.core.async.__GT_t31585 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t31585(cs__$1,ch__$1,mult__$1,meta31586){
return (new cljs.core.async.t31585(cs__$1,ch__$1,mult__$1,meta31586));
});})(cs))
;

}

return (new cljs.core.async.t31585(cs,ch,cljs$core$async$mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (function (){var G__31590 = null;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31590) : cljs.core.atom.call(null,G__31590));
})();
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__7709__auto___31815 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___31815,cs,m,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___31815,cs,m,dchan,dctr,done){
return (function (state_31721){
var state_val_31722 = (state_31721[(1)]);
if((state_val_31722 === (7))){
var inst_31717 = (state_31721[(2)]);
var state_31721__$1 = state_31721;
var statearr_31723_31816 = state_31721__$1;
(statearr_31723_31816[(2)] = inst_31717);

(statearr_31723_31816[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (20))){
var inst_31622 = (state_31721[(7)]);
var inst_31632 = cljs.core.first(inst_31622);
var inst_31633 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31632,(0),null);
var inst_31634 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31632,(1),null);
var state_31721__$1 = (function (){var statearr_31724 = state_31721;
(statearr_31724[(8)] = inst_31633);

return statearr_31724;
})();
if(cljs.core.truth_(inst_31634)){
var statearr_31725_31817 = state_31721__$1;
(statearr_31725_31817[(1)] = (22));

} else {
var statearr_31726_31818 = state_31721__$1;
(statearr_31726_31818[(1)] = (23));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (27))){
var inst_31664 = (state_31721[(9)]);
var inst_31669 = (state_31721[(10)]);
var inst_31593 = (state_31721[(11)]);
var inst_31662 = (state_31721[(12)]);
var inst_31669__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31662,inst_31664);
var inst_31670 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31669__$1,inst_31593,done);
var state_31721__$1 = (function (){var statearr_31727 = state_31721;
(statearr_31727[(10)] = inst_31669__$1);

return statearr_31727;
})();
if(cljs.core.truth_(inst_31670)){
var statearr_31728_31819 = state_31721__$1;
(statearr_31728_31819[(1)] = (30));

} else {
var statearr_31729_31820 = state_31721__$1;
(statearr_31729_31820[(1)] = (31));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (1))){
var state_31721__$1 = state_31721;
var statearr_31730_31821 = state_31721__$1;
(statearr_31730_31821[(2)] = null);

(statearr_31730_31821[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (24))){
var inst_31622 = (state_31721[(7)]);
var inst_31639 = (state_31721[(2)]);
var inst_31640 = cljs.core.next(inst_31622);
var inst_31602 = inst_31640;
var inst_31603 = null;
var inst_31604 = (0);
var inst_31605 = (0);
var state_31721__$1 = (function (){var statearr_31731 = state_31721;
(statearr_31731[(13)] = inst_31605);

(statearr_31731[(14)] = inst_31602);

(statearr_31731[(15)] = inst_31603);

(statearr_31731[(16)] = inst_31604);

(statearr_31731[(17)] = inst_31639);

return statearr_31731;
})();
var statearr_31732_31822 = state_31721__$1;
(statearr_31732_31822[(2)] = null);

(statearr_31732_31822[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (39))){
var state_31721__$1 = state_31721;
var statearr_31736_31823 = state_31721__$1;
(statearr_31736_31823[(2)] = null);

(statearr_31736_31823[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (4))){
var inst_31593 = (state_31721[(11)]);
var inst_31593__$1 = (state_31721[(2)]);
var inst_31594 = (inst_31593__$1 == null);
var state_31721__$1 = (function (){var statearr_31737 = state_31721;
(statearr_31737[(11)] = inst_31593__$1);

return statearr_31737;
})();
if(cljs.core.truth_(inst_31594)){
var statearr_31738_31824 = state_31721__$1;
(statearr_31738_31824[(1)] = (5));

} else {
var statearr_31739_31825 = state_31721__$1;
(statearr_31739_31825[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (15))){
var inst_31605 = (state_31721[(13)]);
var inst_31602 = (state_31721[(14)]);
var inst_31603 = (state_31721[(15)]);
var inst_31604 = (state_31721[(16)]);
var inst_31618 = (state_31721[(2)]);
var inst_31619 = (inst_31605 + (1));
var tmp31733 = inst_31602;
var tmp31734 = inst_31603;
var tmp31735 = inst_31604;
var inst_31602__$1 = tmp31733;
var inst_31603__$1 = tmp31734;
var inst_31604__$1 = tmp31735;
var inst_31605__$1 = inst_31619;
var state_31721__$1 = (function (){var statearr_31740 = state_31721;
(statearr_31740[(13)] = inst_31605__$1);

(statearr_31740[(18)] = inst_31618);

(statearr_31740[(14)] = inst_31602__$1);

(statearr_31740[(15)] = inst_31603__$1);

(statearr_31740[(16)] = inst_31604__$1);

return statearr_31740;
})();
var statearr_31741_31826 = state_31721__$1;
(statearr_31741_31826[(2)] = null);

(statearr_31741_31826[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (21))){
var inst_31643 = (state_31721[(2)]);
var state_31721__$1 = state_31721;
var statearr_31745_31827 = state_31721__$1;
(statearr_31745_31827[(2)] = inst_31643);

(statearr_31745_31827[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (31))){
var inst_31669 = (state_31721[(10)]);
var inst_31673 = done(null);
var inst_31674 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31669);
var state_31721__$1 = (function (){var statearr_31746 = state_31721;
(statearr_31746[(19)] = inst_31673);

return statearr_31746;
})();
var statearr_31747_31828 = state_31721__$1;
(statearr_31747_31828[(2)] = inst_31674);

(statearr_31747_31828[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (32))){
var inst_31664 = (state_31721[(9)]);
var inst_31661 = (state_31721[(20)]);
var inst_31663 = (state_31721[(21)]);
var inst_31662 = (state_31721[(12)]);
var inst_31676 = (state_31721[(2)]);
var inst_31677 = (inst_31664 + (1));
var tmp31742 = inst_31661;
var tmp31743 = inst_31663;
var tmp31744 = inst_31662;
var inst_31661__$1 = tmp31742;
var inst_31662__$1 = tmp31744;
var inst_31663__$1 = tmp31743;
var inst_31664__$1 = inst_31677;
var state_31721__$1 = (function (){var statearr_31748 = state_31721;
(statearr_31748[(9)] = inst_31664__$1);

(statearr_31748[(20)] = inst_31661__$1);

(statearr_31748[(21)] = inst_31663__$1);

(statearr_31748[(12)] = inst_31662__$1);

(statearr_31748[(22)] = inst_31676);

return statearr_31748;
})();
var statearr_31749_31829 = state_31721__$1;
(statearr_31749_31829[(2)] = null);

(statearr_31749_31829[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (40))){
var inst_31689 = (state_31721[(23)]);
var inst_31693 = done(null);
var inst_31694 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31689);
var state_31721__$1 = (function (){var statearr_31750 = state_31721;
(statearr_31750[(24)] = inst_31693);

return statearr_31750;
})();
var statearr_31751_31830 = state_31721__$1;
(statearr_31751_31830[(2)] = inst_31694);

(statearr_31751_31830[(1)] = (41));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (33))){
var inst_31680 = (state_31721[(25)]);
var inst_31682 = cljs.core.chunked_seq_QMARK_(inst_31680);
var state_31721__$1 = state_31721;
if(inst_31682){
var statearr_31752_31831 = state_31721__$1;
(statearr_31752_31831[(1)] = (36));

} else {
var statearr_31753_31832 = state_31721__$1;
(statearr_31753_31832[(1)] = (37));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (13))){
var inst_31612 = (state_31721[(26)]);
var inst_31615 = cljs.core.async.close_BANG_(inst_31612);
var state_31721__$1 = state_31721;
var statearr_31754_31833 = state_31721__$1;
(statearr_31754_31833[(2)] = inst_31615);

(statearr_31754_31833[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (22))){
var inst_31633 = (state_31721[(8)]);
var inst_31636 = cljs.core.async.close_BANG_(inst_31633);
var state_31721__$1 = state_31721;
var statearr_31755_31834 = state_31721__$1;
(statearr_31755_31834[(2)] = inst_31636);

(statearr_31755_31834[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (36))){
var inst_31680 = (state_31721[(25)]);
var inst_31684 = cljs.core.chunk_first(inst_31680);
var inst_31685 = cljs.core.chunk_rest(inst_31680);
var inst_31686 = cljs.core.count(inst_31684);
var inst_31661 = inst_31685;
var inst_31662 = inst_31684;
var inst_31663 = inst_31686;
var inst_31664 = (0);
var state_31721__$1 = (function (){var statearr_31756 = state_31721;
(statearr_31756[(9)] = inst_31664);

(statearr_31756[(20)] = inst_31661);

(statearr_31756[(21)] = inst_31663);

(statearr_31756[(12)] = inst_31662);

return statearr_31756;
})();
var statearr_31757_31835 = state_31721__$1;
(statearr_31757_31835[(2)] = null);

(statearr_31757_31835[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (41))){
var inst_31680 = (state_31721[(25)]);
var inst_31696 = (state_31721[(2)]);
var inst_31697 = cljs.core.next(inst_31680);
var inst_31661 = inst_31697;
var inst_31662 = null;
var inst_31663 = (0);
var inst_31664 = (0);
var state_31721__$1 = (function (){var statearr_31758 = state_31721;
(statearr_31758[(9)] = inst_31664);

(statearr_31758[(27)] = inst_31696);

(statearr_31758[(20)] = inst_31661);

(statearr_31758[(21)] = inst_31663);

(statearr_31758[(12)] = inst_31662);

return statearr_31758;
})();
var statearr_31759_31836 = state_31721__$1;
(statearr_31759_31836[(2)] = null);

(statearr_31759_31836[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (43))){
var state_31721__$1 = state_31721;
var statearr_31760_31837 = state_31721__$1;
(statearr_31760_31837[(2)] = null);

(statearr_31760_31837[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (29))){
var inst_31705 = (state_31721[(2)]);
var state_31721__$1 = state_31721;
var statearr_31761_31838 = state_31721__$1;
(statearr_31761_31838[(2)] = inst_31705);

(statearr_31761_31838[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (44))){
var inst_31714 = (state_31721[(2)]);
var state_31721__$1 = (function (){var statearr_31762 = state_31721;
(statearr_31762[(28)] = inst_31714);

return statearr_31762;
})();
var statearr_31763_31839 = state_31721__$1;
(statearr_31763_31839[(2)] = null);

(statearr_31763_31839[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (6))){
var inst_31653 = (state_31721[(29)]);
var inst_31652 = (function (){var G__31764 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__31764) : cljs.core.deref.call(null,G__31764));
})();
var inst_31653__$1 = cljs.core.keys(inst_31652);
var inst_31654 = cljs.core.count(inst_31653__$1);
var inst_31655 = (function (){var G__31765 = dctr;
var G__31766 = inst_31654;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__31765,G__31766) : cljs.core.reset_BANG_.call(null,G__31765,G__31766));
})();
var inst_31660 = cljs.core.seq(inst_31653__$1);
var inst_31661 = inst_31660;
var inst_31662 = null;
var inst_31663 = (0);
var inst_31664 = (0);
var state_31721__$1 = (function (){var statearr_31767 = state_31721;
(statearr_31767[(9)] = inst_31664);

(statearr_31767[(20)] = inst_31661);

(statearr_31767[(30)] = inst_31655);

(statearr_31767[(21)] = inst_31663);

(statearr_31767[(12)] = inst_31662);

(statearr_31767[(29)] = inst_31653__$1);

return statearr_31767;
})();
var statearr_31768_31840 = state_31721__$1;
(statearr_31768_31840[(2)] = null);

(statearr_31768_31840[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (28))){
var inst_31661 = (state_31721[(20)]);
var inst_31680 = (state_31721[(25)]);
var inst_31680__$1 = cljs.core.seq(inst_31661);
var state_31721__$1 = (function (){var statearr_31769 = state_31721;
(statearr_31769[(25)] = inst_31680__$1);

return statearr_31769;
})();
if(inst_31680__$1){
var statearr_31770_31841 = state_31721__$1;
(statearr_31770_31841[(1)] = (33));

} else {
var statearr_31771_31842 = state_31721__$1;
(statearr_31771_31842[(1)] = (34));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (25))){
var inst_31664 = (state_31721[(9)]);
var inst_31663 = (state_31721[(21)]);
var inst_31666 = (inst_31664 < inst_31663);
var inst_31667 = inst_31666;
var state_31721__$1 = state_31721;
if(cljs.core.truth_(inst_31667)){
var statearr_31772_31843 = state_31721__$1;
(statearr_31772_31843[(1)] = (27));

} else {
var statearr_31773_31844 = state_31721__$1;
(statearr_31773_31844[(1)] = (28));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (34))){
var state_31721__$1 = state_31721;
var statearr_31774_31845 = state_31721__$1;
(statearr_31774_31845[(2)] = null);

(statearr_31774_31845[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (17))){
var state_31721__$1 = state_31721;
var statearr_31775_31846 = state_31721__$1;
(statearr_31775_31846[(2)] = null);

(statearr_31775_31846[(1)] = (18));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (3))){
var inst_31719 = (state_31721[(2)]);
var state_31721__$1 = state_31721;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31721__$1,inst_31719);
} else {
if((state_val_31722 === (12))){
var inst_31648 = (state_31721[(2)]);
var state_31721__$1 = state_31721;
var statearr_31776_31847 = state_31721__$1;
(statearr_31776_31847[(2)] = inst_31648);

(statearr_31776_31847[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (2))){
var state_31721__$1 = state_31721;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31721__$1,(4),ch);
} else {
if((state_val_31722 === (23))){
var state_31721__$1 = state_31721;
var statearr_31777_31848 = state_31721__$1;
(statearr_31777_31848[(2)] = null);

(statearr_31777_31848[(1)] = (24));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (35))){
var inst_31703 = (state_31721[(2)]);
var state_31721__$1 = state_31721;
var statearr_31778_31849 = state_31721__$1;
(statearr_31778_31849[(2)] = inst_31703);

(statearr_31778_31849[(1)] = (29));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (19))){
var inst_31622 = (state_31721[(7)]);
var inst_31626 = cljs.core.chunk_first(inst_31622);
var inst_31627 = cljs.core.chunk_rest(inst_31622);
var inst_31628 = cljs.core.count(inst_31626);
var inst_31602 = inst_31627;
var inst_31603 = inst_31626;
var inst_31604 = inst_31628;
var inst_31605 = (0);
var state_31721__$1 = (function (){var statearr_31779 = state_31721;
(statearr_31779[(13)] = inst_31605);

(statearr_31779[(14)] = inst_31602);

(statearr_31779[(15)] = inst_31603);

(statearr_31779[(16)] = inst_31604);

return statearr_31779;
})();
var statearr_31780_31850 = state_31721__$1;
(statearr_31780_31850[(2)] = null);

(statearr_31780_31850[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (11))){
var inst_31622 = (state_31721[(7)]);
var inst_31602 = (state_31721[(14)]);
var inst_31622__$1 = cljs.core.seq(inst_31602);
var state_31721__$1 = (function (){var statearr_31781 = state_31721;
(statearr_31781[(7)] = inst_31622__$1);

return statearr_31781;
})();
if(inst_31622__$1){
var statearr_31782_31851 = state_31721__$1;
(statearr_31782_31851[(1)] = (16));

} else {
var statearr_31783_31852 = state_31721__$1;
(statearr_31783_31852[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (9))){
var inst_31650 = (state_31721[(2)]);
var state_31721__$1 = state_31721;
var statearr_31784_31853 = state_31721__$1;
(statearr_31784_31853[(2)] = inst_31650);

(statearr_31784_31853[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (5))){
var inst_31600 = (function (){var G__31785 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__31785) : cljs.core.deref.call(null,G__31785));
})();
var inst_31601 = cljs.core.seq(inst_31600);
var inst_31602 = inst_31601;
var inst_31603 = null;
var inst_31604 = (0);
var inst_31605 = (0);
var state_31721__$1 = (function (){var statearr_31786 = state_31721;
(statearr_31786[(13)] = inst_31605);

(statearr_31786[(14)] = inst_31602);

(statearr_31786[(15)] = inst_31603);

(statearr_31786[(16)] = inst_31604);

return statearr_31786;
})();
var statearr_31787_31854 = state_31721__$1;
(statearr_31787_31854[(2)] = null);

(statearr_31787_31854[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (14))){
var state_31721__$1 = state_31721;
var statearr_31788_31855 = state_31721__$1;
(statearr_31788_31855[(2)] = null);

(statearr_31788_31855[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (45))){
var inst_31711 = (state_31721[(2)]);
var state_31721__$1 = state_31721;
var statearr_31789_31856 = state_31721__$1;
(statearr_31789_31856[(2)] = inst_31711);

(statearr_31789_31856[(1)] = (44));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (26))){
var inst_31653 = (state_31721[(29)]);
var inst_31707 = (state_31721[(2)]);
var inst_31708 = cljs.core.seq(inst_31653);
var state_31721__$1 = (function (){var statearr_31790 = state_31721;
(statearr_31790[(31)] = inst_31707);

return statearr_31790;
})();
if(inst_31708){
var statearr_31791_31857 = state_31721__$1;
(statearr_31791_31857[(1)] = (42));

} else {
var statearr_31792_31858 = state_31721__$1;
(statearr_31792_31858[(1)] = (43));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (16))){
var inst_31622 = (state_31721[(7)]);
var inst_31624 = cljs.core.chunked_seq_QMARK_(inst_31622);
var state_31721__$1 = state_31721;
if(inst_31624){
var statearr_31793_31859 = state_31721__$1;
(statearr_31793_31859[(1)] = (19));

} else {
var statearr_31794_31860 = state_31721__$1;
(statearr_31794_31860[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (38))){
var inst_31700 = (state_31721[(2)]);
var state_31721__$1 = state_31721;
var statearr_31795_31861 = state_31721__$1;
(statearr_31795_31861[(2)] = inst_31700);

(statearr_31795_31861[(1)] = (35));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (30))){
var state_31721__$1 = state_31721;
var statearr_31796_31862 = state_31721__$1;
(statearr_31796_31862[(2)] = null);

(statearr_31796_31862[(1)] = (32));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (10))){
var inst_31605 = (state_31721[(13)]);
var inst_31603 = (state_31721[(15)]);
var inst_31611 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_31603,inst_31605);
var inst_31612 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31611,(0),null);
var inst_31613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31611,(1),null);
var state_31721__$1 = (function (){var statearr_31797 = state_31721;
(statearr_31797[(26)] = inst_31612);

return statearr_31797;
})();
if(cljs.core.truth_(inst_31613)){
var statearr_31798_31863 = state_31721__$1;
(statearr_31798_31863[(1)] = (13));

} else {
var statearr_31799_31864 = state_31721__$1;
(statearr_31799_31864[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (18))){
var inst_31646 = (state_31721[(2)]);
var state_31721__$1 = state_31721;
var statearr_31800_31865 = state_31721__$1;
(statearr_31800_31865[(2)] = inst_31646);

(statearr_31800_31865[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (42))){
var state_31721__$1 = state_31721;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31721__$1,(45),dchan);
} else {
if((state_val_31722 === (37))){
var inst_31689 = (state_31721[(23)]);
var inst_31593 = (state_31721[(11)]);
var inst_31680 = (state_31721[(25)]);
var inst_31689__$1 = cljs.core.first(inst_31680);
var inst_31690 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31689__$1,inst_31593,done);
var state_31721__$1 = (function (){var statearr_31801 = state_31721;
(statearr_31801[(23)] = inst_31689__$1);

return statearr_31801;
})();
if(cljs.core.truth_(inst_31690)){
var statearr_31802_31866 = state_31721__$1;
(statearr_31802_31866[(1)] = (39));

} else {
var statearr_31803_31867 = state_31721__$1;
(statearr_31803_31867[(1)] = (40));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_31722 === (8))){
var inst_31605 = (state_31721[(13)]);
var inst_31604 = (state_31721[(16)]);
var inst_31607 = (inst_31605 < inst_31604);
var inst_31608 = inst_31607;
var state_31721__$1 = state_31721;
if(cljs.core.truth_(inst_31608)){
var statearr_31804_31868 = state_31721__$1;
(statearr_31804_31868[(1)] = (10));

} else {
var statearr_31805_31869 = state_31721__$1;
(statearr_31805_31869[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___31815,cs,m,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___31815,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__7648__auto__ = null;
var cljs$core$async$mult_$_state_machine__7648__auto____0 = (function (){
var statearr_31809 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31809[(0)] = cljs$core$async$mult_$_state_machine__7648__auto__);

(statearr_31809[(1)] = (1));

return statearr_31809;
});
var cljs$core$async$mult_$_state_machine__7648__auto____1 = (function (state_31721){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_31721);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e31810){if((e31810 instanceof Object)){
var ex__7651__auto__ = e31810;
var statearr_31811_31870 = state_31721;
(statearr_31811_31870[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31721);

return cljs.core.constant$keyword$recur;
} else {
throw e31810;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__31871 = state_31721;
state_31721 = G__31871;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__7648__auto__ = function(state_31721){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__7648__auto____1.call(this,state_31721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__7648__auto____0;
cljs$core$async$mult_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__7648__auto____1;
return cljs$core$async$mult_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___31815,cs,m,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_31812 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_31812[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___31815);

return statearr_31812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___31815,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(){
var G__31873 = arguments.length;
switch (G__31873) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

cljs.core.async.Mix = (function (){var obj31876 = {};
return obj31876;
})();

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$admix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.admix_STAR_[(function (){var G__31880 = x__4912__auto__;
return goog.typeOf(G__31880);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_STAR_[(function (){var G__31884 = x__4912__auto__;
return goog.typeOf(G__31884);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
})().call(null,m,ch);
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.unmix_all_STAR_[(function (){var G__31888 = x__4912__auto__;
return goog.typeOf(G__31888);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
})().call(null,m);
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.toggle_STAR_[(function (){var G__31892 = x__4912__auto__;
return goog.typeOf(G__31892);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
})().call(null,m,state_map);
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((function (){var and__4264__auto__ = m;
if(and__4264__auto__){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4912__auto__ = (((m == null))?null:m);
return (function (){var or__4276__auto__ = (cljs.core.async.solo_mode_STAR_[(function (){var G__31896 = x__4912__auto__;
return goog.typeOf(G__31896);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
})().call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(){
var argseq__5316__auto__ = ((((3) < arguments.length))?(new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments,(3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5316__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31901){
var map__31902 = p__31901;
var map__31902__$1 = ((cljs.core.seq_QMARK_(map__31902))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31902):map__31902);
var opts = map__31902__$1;
var statearr_31903_31907 = state;
(statearr_31903_31907[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4126__auto__ = cljs.core.async.do_alts(((function (map__31902,map__31902__$1,opts){
return (function (val){
var statearr_31904_31908 = state;
(statearr_31904_31908[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__31902,map__31902__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4126__auto__)){
var cb = temp__4126__auto__;
var statearr_31905_31909 = state;
(statearr_31905_31909[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (function (){var G__31906 = cb;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__31906) : cljs.core.deref.call(null,G__31906));
})());


return cljs.core.constant$keyword$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31897){
var G__31898 = cljs.core.first(seq31897);
var seq31897__$1 = cljs.core.next(seq31897);
var G__31899 = cljs.core.first(seq31897__$1);
var seq31897__$2 = cljs.core.next(seq31897__$1);
var G__31900 = cljs.core.first(seq31897__$2);
var seq31897__$3 = cljs.core.next(seq31897__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31898,G__31899,G__31900,seq31897__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 * be put on the supplied out channel. Input sources can be added to
 * the mix with 'admix', and removed with 'unmix'. A mix supports
 * soloing, muting and pausing multiple inputs atomically using
 * 'toggle', and can solo using either muting or pausing as determined
 * by 'solo-mode'.
 * 
 * Each channel can have zero or more boolean modes set via 'toggle':
 * 
 * :solo - when true, only this (ond other soloed) channel(s) will appear
 * in the mix output channel. :mute and :pause states of soloed
 * channels are ignored. If solo-mode is :mute, non-soloed
 * channels are muted, if :pause, non-soloed channels are
 * paused.
 * 
 * :mute - muted channels will have their contents consumed but not included in the mix
 * :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__32043 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32043) : cljs.core.atom.call(null,G__32043));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$pause,null,cljs.core.constant$keyword$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.constant$keyword$solo);
var solo_mode = (function (){var G__32044 = cljs.core.constant$keyword$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32044) : cljs.core.atom.call(null,G__32044));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((function (){var G__32045 = v;
return (attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(G__32045) : attr.call(null,G__32045));
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (function (){var G__32046 = cs;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32046) : cljs.core.deref.call(null,G__32046));
})();
var mode = (function (){var G__32047 = solo_mode;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32047) : cljs.core.deref.call(null,G__32047));
})();
var solos = pick(cljs.core.constant$keyword$solo,chs);
var pauses = pick(cljs.core.constant$keyword$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.constant$keyword$solos,solos,cljs.core.constant$keyword$mutes,pick(cljs.core.constant$keyword$mute,chs),cljs.core.constant$keyword$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.constant$keyword$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t32048 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32048 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32049){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32049 = meta32049;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32048.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t32048.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32048.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32048.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32051_32176 = self__.cs;
var G__32052_32177 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32051_32176,G__32052_32177) : cljs.core.reset_BANG_.call(null,G__32051_32176,G__32052_32177));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32048.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32048.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((function (){var G__32053 = mode;
return (self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(G__32053) : self__.solo_modes.call(null,G__32053));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))], 0)))].join('')));
}

var G__32054_32178 = self__.solo_mode;
var G__32055_32179 = mode;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32054_32178,G__32055_32179) : cljs.core.reset_BANG_.call(null,G__32054_32178,G__32055_32179));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32048.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t32048.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32048.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32050){
var self__ = this;
var _32050__$1 = this;
return self__.meta32049;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32048.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32050,meta32049__$1){
var self__ = this;
var _32050__$1 = this;
return (new cljs.core.async.t32048(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32049__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t32048.cljs$lang$type = true;

cljs.core.async.t32048.cljs$lang$ctorStr = "cljs.core.async/t32048";

cljs.core.async.t32048.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t32048");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t32048 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t32048(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32049){
return (new cljs.core.async.t32048(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32049));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t32048(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___32180 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___32180,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___32180,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32127){
var state_val_32128 = (state_32127[(1)]);
if((state_val_32128 === (7))){
var inst_32069 = (state_32127[(7)]);
var inst_32074 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32069);
var state_32127__$1 = state_32127;
var statearr_32129_32181 = state_32127__$1;
(statearr_32129_32181[(2)] = inst_32074);

(statearr_32129_32181[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (20))){
var inst_32084 = (state_32127[(8)]);
var state_32127__$1 = state_32127;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32127__$1,(23),out,inst_32084);
} else {
if((state_val_32128 === (1))){
var inst_32059 = (state_32127[(9)]);
var inst_32059__$1 = calc_state();
var inst_32060 = cljs.core.seq_QMARK_(inst_32059__$1);
var state_32127__$1 = (function (){var statearr_32130 = state_32127;
(statearr_32130[(9)] = inst_32059__$1);

return statearr_32130;
})();
if(inst_32060){
var statearr_32131_32182 = state_32127__$1;
(statearr_32131_32182[(1)] = (2));

} else {
var statearr_32132_32183 = state_32127__$1;
(statearr_32132_32183[(1)] = (3));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (24))){
var inst_32077 = (state_32127[(10)]);
var inst_32069 = inst_32077;
var state_32127__$1 = (function (){var statearr_32133 = state_32127;
(statearr_32133[(7)] = inst_32069);

return statearr_32133;
})();
var statearr_32134_32184 = state_32127__$1;
(statearr_32134_32184[(2)] = null);

(statearr_32134_32184[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (4))){
var inst_32059 = (state_32127[(9)]);
var inst_32065 = (state_32127[(2)]);
var inst_32066 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32065,cljs.core.constant$keyword$reads);
var inst_32067 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32065,cljs.core.constant$keyword$mutes);
var inst_32068 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32065,cljs.core.constant$keyword$solos);
var inst_32069 = inst_32059;
var state_32127__$1 = (function (){var statearr_32135 = state_32127;
(statearr_32135[(7)] = inst_32069);

(statearr_32135[(11)] = inst_32068);

(statearr_32135[(12)] = inst_32067);

(statearr_32135[(13)] = inst_32066);

return statearr_32135;
})();
var statearr_32136_32185 = state_32127__$1;
(statearr_32136_32185[(2)] = null);

(statearr_32136_32185[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (15))){
var state_32127__$1 = state_32127;
var statearr_32137_32186 = state_32127__$1;
(statearr_32137_32186[(2)] = null);

(statearr_32137_32186[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (21))){
var inst_32077 = (state_32127[(10)]);
var inst_32069 = inst_32077;
var state_32127__$1 = (function (){var statearr_32138 = state_32127;
(statearr_32138[(7)] = inst_32069);

return statearr_32138;
})();
var statearr_32139_32187 = state_32127__$1;
(statearr_32139_32187[(2)] = null);

(statearr_32139_32187[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (13))){
var inst_32123 = (state_32127[(2)]);
var state_32127__$1 = state_32127;
var statearr_32140_32188 = state_32127__$1;
(statearr_32140_32188[(2)] = inst_32123);

(statearr_32140_32188[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (22))){
var inst_32121 = (state_32127[(2)]);
var state_32127__$1 = state_32127;
var statearr_32141_32189 = state_32127__$1;
(statearr_32141_32189[(2)] = inst_32121);

(statearr_32141_32189[(1)] = (13));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (6))){
var inst_32125 = (state_32127[(2)]);
var state_32127__$1 = state_32127;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32127__$1,inst_32125);
} else {
if((state_val_32128 === (25))){
var state_32127__$1 = state_32127;
var statearr_32142_32190 = state_32127__$1;
(statearr_32142_32190[(2)] = null);

(statearr_32142_32190[(1)] = (26));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (17))){
var inst_32100 = (state_32127[(14)]);
var state_32127__$1 = state_32127;
var statearr_32143_32191 = state_32127__$1;
(statearr_32143_32191[(2)] = inst_32100);

(statearr_32143_32191[(1)] = (19));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (3))){
var inst_32059 = (state_32127[(9)]);
var state_32127__$1 = state_32127;
var statearr_32144_32192 = state_32127__$1;
(statearr_32144_32192[(2)] = inst_32059);

(statearr_32144_32192[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (12))){
var inst_32080 = (state_32127[(15)]);
var inst_32100 = (state_32127[(14)]);
var inst_32085 = (state_32127[(16)]);
var inst_32100__$1 = (function (){var G__32145 = inst_32085;
return (inst_32080.cljs$core$IFn$_invoke$arity$1 ? inst_32080.cljs$core$IFn$_invoke$arity$1(G__32145) : inst_32080.call(null,G__32145));
})();
var state_32127__$1 = (function (){var statearr_32146 = state_32127;
(statearr_32146[(14)] = inst_32100__$1);

return statearr_32146;
})();
if(cljs.core.truth_(inst_32100__$1)){
var statearr_32147_32193 = state_32127__$1;
(statearr_32147_32193[(1)] = (17));

} else {
var statearr_32148_32194 = state_32127__$1;
(statearr_32148_32194[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (2))){
var inst_32059 = (state_32127[(9)]);
var inst_32062 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32059);
var state_32127__$1 = state_32127;
var statearr_32149_32195 = state_32127__$1;
(statearr_32149_32195[(2)] = inst_32062);

(statearr_32149_32195[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (23))){
var inst_32112 = (state_32127[(2)]);
var state_32127__$1 = state_32127;
if(cljs.core.truth_(inst_32112)){
var statearr_32150_32196 = state_32127__$1;
(statearr_32150_32196[(1)] = (24));

} else {
var statearr_32151_32197 = state_32127__$1;
(statearr_32151_32197[(1)] = (25));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (19))){
var inst_32109 = (state_32127[(2)]);
var state_32127__$1 = state_32127;
if(cljs.core.truth_(inst_32109)){
var statearr_32152_32198 = state_32127__$1;
(statearr_32152_32198[(1)] = (20));

} else {
var statearr_32153_32199 = state_32127__$1;
(statearr_32153_32199[(1)] = (21));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (11))){
var inst_32084 = (state_32127[(8)]);
var inst_32090 = (inst_32084 == null);
var state_32127__$1 = state_32127;
if(cljs.core.truth_(inst_32090)){
var statearr_32154_32200 = state_32127__$1;
(statearr_32154_32200[(1)] = (14));

} else {
var statearr_32155_32201 = state_32127__$1;
(statearr_32155_32201[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (9))){
var inst_32077 = (state_32127[(10)]);
var inst_32077__$1 = (state_32127[(2)]);
var inst_32078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32077__$1,cljs.core.constant$keyword$reads);
var inst_32079 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32077__$1,cljs.core.constant$keyword$mutes);
var inst_32080 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32077__$1,cljs.core.constant$keyword$solos);
var state_32127__$1 = (function (){var statearr_32156 = state_32127;
(statearr_32156[(17)] = inst_32079);

(statearr_32156[(15)] = inst_32080);

(statearr_32156[(10)] = inst_32077__$1);

return statearr_32156;
})();
return cljs.core.async.ioc_alts_BANG_(state_32127__$1,(10),inst_32078);
} else {
if((state_val_32128 === (5))){
var inst_32069 = (state_32127[(7)]);
var inst_32072 = cljs.core.seq_QMARK_(inst_32069);
var state_32127__$1 = state_32127;
if(inst_32072){
var statearr_32157_32202 = state_32127__$1;
(statearr_32157_32202[(1)] = (7));

} else {
var statearr_32158_32203 = state_32127__$1;
(statearr_32158_32203[(1)] = (8));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (14))){
var inst_32085 = (state_32127[(16)]);
var inst_32092 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32085);
var state_32127__$1 = state_32127;
var statearr_32159_32204 = state_32127__$1;
(statearr_32159_32204[(2)] = inst_32092);

(statearr_32159_32204[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (26))){
var inst_32117 = (state_32127[(2)]);
var state_32127__$1 = state_32127;
var statearr_32160_32205 = state_32127__$1;
(statearr_32160_32205[(2)] = inst_32117);

(statearr_32160_32205[(1)] = (22));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (16))){
var inst_32095 = (state_32127[(2)]);
var inst_32096 = calc_state();
var inst_32069 = inst_32096;
var state_32127__$1 = (function (){var statearr_32161 = state_32127;
(statearr_32161[(7)] = inst_32069);

(statearr_32161[(18)] = inst_32095);

return statearr_32161;
})();
var statearr_32162_32206 = state_32127__$1;
(statearr_32162_32206[(2)] = null);

(statearr_32162_32206[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (10))){
var inst_32084 = (state_32127[(8)]);
var inst_32085 = (state_32127[(16)]);
var inst_32083 = (state_32127[(2)]);
var inst_32084__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32083,(0),null);
var inst_32085__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32083,(1),null);
var inst_32086 = (inst_32084__$1 == null);
var inst_32087 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32085__$1,change);
var inst_32088 = (inst_32086) || (inst_32087);
var state_32127__$1 = (function (){var statearr_32163 = state_32127;
(statearr_32163[(8)] = inst_32084__$1);

(statearr_32163[(16)] = inst_32085__$1);

return statearr_32163;
})();
if(cljs.core.truth_(inst_32088)){
var statearr_32164_32207 = state_32127__$1;
(statearr_32164_32207[(1)] = (11));

} else {
var statearr_32165_32208 = state_32127__$1;
(statearr_32165_32208[(1)] = (12));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (18))){
var inst_32079 = (state_32127[(17)]);
var inst_32080 = (state_32127[(15)]);
var inst_32085 = (state_32127[(16)]);
var inst_32104 = cljs.core.empty_QMARK_(inst_32080);
var inst_32105 = (function (){var G__32166 = inst_32085;
return (inst_32079.cljs$core$IFn$_invoke$arity$1 ? inst_32079.cljs$core$IFn$_invoke$arity$1(G__32166) : inst_32079.call(null,G__32166));
})();
var inst_32106 = cljs.core.not(inst_32105);
var inst_32107 = (inst_32104) && (inst_32106);
var state_32127__$1 = state_32127;
var statearr_32167_32209 = state_32127__$1;
(statearr_32167_32209[(2)] = inst_32107);

(statearr_32167_32209[(1)] = (19));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32128 === (8))){
var inst_32069 = (state_32127[(7)]);
var state_32127__$1 = state_32127;
var statearr_32168_32210 = state_32127__$1;
(statearr_32168_32210[(2)] = inst_32069);

(statearr_32168_32210[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___32180,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__7647__auto__,c__7709__auto___32180,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__7648__auto__ = null;
var cljs$core$async$mix_$_state_machine__7648__auto____0 = (function (){
var statearr_32172 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32172[(0)] = cljs$core$async$mix_$_state_machine__7648__auto__);

(statearr_32172[(1)] = (1));

return statearr_32172;
});
var cljs$core$async$mix_$_state_machine__7648__auto____1 = (function (state_32127){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_32127);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e32173){if((e32173 instanceof Object)){
var ex__7651__auto__ = e32173;
var statearr_32174_32211 = state_32127;
(statearr_32174_32211[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32127);

return cljs.core.constant$keyword$recur;
} else {
throw e32173;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__32212 = state_32127;
state_32127 = G__32212;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__7648__auto__ = function(state_32127){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__7648__auto____1.call(this,state_32127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__7648__auto____0;
cljs$core$async$mix_$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__7648__auto____1;
return cljs$core$async$mix_$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___32180,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__7711__auto__ = (function (){var statearr_32175 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_32175[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___32180);

return statearr_32175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___32180,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 * state map is a map of channels -> channel-state-map. A
 * channel-state-map is a map of attrs -> boolean, where attr is one or
 * more of :mute, :pause or :solo. Any states supplied are merged with
 * the current state.
 * 
 * Note that channels can be added to a mix via toggle, which can be
 * used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

cljs.core.async.Pub = (function (){var obj32214 = {};
return obj32214;
})();

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$sub_STAR_$arity$4;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.sub_STAR_[(function (){var G__32218 = x__4912__auto__;
return goog.typeOf(G__32218);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
})().call(null,p,v,ch,close_QMARK_);
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_STAR_[(function (){var G__32222 = x__4912__auto__;
return goog.typeOf(G__32222);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
})().call(null,p,v,ch);
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(){
var G__32224 = arguments.length;
switch (G__32224) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[(function (){var G__32226 = x__4912__auto__;
return goog.typeOf(G__32226);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
})().call(null,p);
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((function (){var and__4264__auto__ = p;
if(and__4264__auto__){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2;
} else {
return and__4264__auto__;
}
})()){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4912__auto__ = (((p == null))?null:p);
return (function (){var or__4276__auto__ = (cljs.core.async.unsub_all_STAR_[(function (){var G__32228 = x__4912__auto__;
return goog.typeOf(G__32228);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
})().call(null,p,v);
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 * partitioned into topics by the topic-fn. topic-fn will be applied to
 * each value on the channel and the result will determine the 'topic'
 * on which that value will be put. Channels can be subscribed to
 * receive copies of topics using 'sub', and unsubscribed using
 * 'unsub'. Each topic will be handled by an internal mult on a
 * dedicated channel. By default these internal channels are
 * unbuffered, but a buf-fn can be supplied which, given a topic,
 * creates a buffer with desired properties.
 * 
 * Each item is distributed to all subs in parallel and synchronously,
 * i.e. each sub must accept before the next item is distributed. Use
 * buffering/windowing to prevent slow subs from holding up the pub.
 * 
 * Items received when there are no matching subs get dropped.
 * 
 * Note that if buf-fns are used then each topic is handled
 * asynchronously, i.e. if a channel is subscribed to more than one
 * topic it should not expect them to be interleaved identically with
 * the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(){
var G__32232 = arguments.length;
switch (G__32232) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__32233 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32233) : cljs.core.atom.call(null,G__32233));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__4276__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((function (){var G__32235 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32235) : cljs.core.deref.call(null,G__32235));
})(),topic);
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4276__auto__,mults){
return (function (p1__32230_SHARP_){
if(cljs.core.truth_((function (){var G__32236 = topic;
return (p1__32230_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32230_SHARP_.cljs$core$IFn$_invoke$arity$1(G__32236) : p1__32230_SHARP_.call(null,G__32236));
})())){
return p1__32230_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32230_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((function (){var G__32237 = topic;
return (buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(G__32237) : buf_fn.call(null,G__32237));
})())));
}
});})(or__4276__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t32238 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32238 = (function (ensure_mult,mults,buf_fn,topic_fn,ch,meta32239){
this.ensure_mult = ensure_mult;
this.mults = mults;
this.buf_fn = buf_fn;
this.topic_fn = topic_fn;
this.ch = ch;
this.meta32239 = meta32239;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32238.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t32238.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (function (){var G__32241 = topic;
return (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(G__32241) : self__.ensure_mult.call(null,G__32241));
})();
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t32238.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((function (){var G__32242 = self__.mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32242) : cljs.core.deref.call(null,G__32242));
})(),topic);
if(cljs.core.truth_(temp__4126__auto__)){
var m = temp__4126__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t32238.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32243 = self__.mults;
var G__32244 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32243,G__32244) : cljs.core.reset_BANG_.call(null,G__32243,G__32244));
});})(mults,ensure_mult))
;

cljs.core.async.t32238.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t32238.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t32238.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t32238.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32240){
var self__ = this;
var _32240__$1 = this;
return self__.meta32239;
});})(mults,ensure_mult))
;

cljs.core.async.t32238.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32240,meta32239__$1){
var self__ = this;
var _32240__$1 = this;
return (new cljs.core.async.t32238(self__.ensure_mult,self__.mults,self__.buf_fn,self__.topic_fn,self__.ch,meta32239__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t32238.cljs$lang$type = true;

cljs.core.async.t32238.cljs$lang$ctorStr = "cljs.core.async/t32238";

cljs.core.async.t32238.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t32238");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t32238 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t32238(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta32239){
return (new cljs.core.async.t32238(ensure_mult__$1,mults__$1,buf_fn__$1,topic_fn__$1,ch__$1,meta32239));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t32238(ensure_mult,mults,buf_fn,topic_fn,ch,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__7709__auto___32368 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___32368,mults,ensure_mult,p){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___32368,mults,ensure_mult,p){
return (function (state_32316){
var state_val_32317 = (state_32316[(1)]);
if((state_val_32317 === (7))){
var inst_32312 = (state_32316[(2)]);
var state_32316__$1 = state_32316;
var statearr_32318_32369 = state_32316__$1;
(statearr_32318_32369[(2)] = inst_32312);

(statearr_32318_32369[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (20))){
var state_32316__$1 = state_32316;
var statearr_32319_32370 = state_32316__$1;
(statearr_32319_32370[(2)] = null);

(statearr_32319_32370[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (1))){
var state_32316__$1 = state_32316;
var statearr_32320_32371 = state_32316__$1;
(statearr_32320_32371[(2)] = null);

(statearr_32320_32371[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (24))){
var inst_32295 = (state_32316[(7)]);
var inst_32304 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_32295);
var state_32316__$1 = state_32316;
var statearr_32321_32372 = state_32316__$1;
(statearr_32321_32372[(2)] = inst_32304);

(statearr_32321_32372[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (4))){
var inst_32247 = (state_32316[(8)]);
var inst_32247__$1 = (state_32316[(2)]);
var inst_32248 = (inst_32247__$1 == null);
var state_32316__$1 = (function (){var statearr_32322 = state_32316;
(statearr_32322[(8)] = inst_32247__$1);

return statearr_32322;
})();
if(cljs.core.truth_(inst_32248)){
var statearr_32323_32373 = state_32316__$1;
(statearr_32323_32373[(1)] = (5));

} else {
var statearr_32324_32374 = state_32316__$1;
(statearr_32324_32374[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (15))){
var inst_32289 = (state_32316[(2)]);
var state_32316__$1 = state_32316;
var statearr_32325_32375 = state_32316__$1;
(statearr_32325_32375[(2)] = inst_32289);

(statearr_32325_32375[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (21))){
var inst_32309 = (state_32316[(2)]);
var state_32316__$1 = (function (){var statearr_32326 = state_32316;
(statearr_32326[(9)] = inst_32309);

return statearr_32326;
})();
var statearr_32327_32376 = state_32316__$1;
(statearr_32327_32376[(2)] = null);

(statearr_32327_32376[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (13))){
var inst_32271 = (state_32316[(10)]);
var inst_32273 = cljs.core.chunked_seq_QMARK_(inst_32271);
var state_32316__$1 = state_32316;
if(inst_32273){
var statearr_32328_32377 = state_32316__$1;
(statearr_32328_32377[(1)] = (16));

} else {
var statearr_32329_32378 = state_32316__$1;
(statearr_32329_32378[(1)] = (17));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (22))){
var inst_32301 = (state_32316[(2)]);
var state_32316__$1 = state_32316;
if(cljs.core.truth_(inst_32301)){
var statearr_32330_32379 = state_32316__$1;
(statearr_32330_32379[(1)] = (23));

} else {
var statearr_32331_32380 = state_32316__$1;
(statearr_32331_32380[(1)] = (24));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (6))){
var inst_32295 = (state_32316[(7)]);
var inst_32297 = (state_32316[(11)]);
var inst_32247 = (state_32316[(8)]);
var inst_32295__$1 = (function (){var G__32332 = inst_32247;
return (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(G__32332) : topic_fn.call(null,G__32332));
})();
var inst_32296 = (function (){var G__32333 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32333) : cljs.core.deref.call(null,G__32333));
})();
var inst_32297__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32296,inst_32295__$1);
var state_32316__$1 = (function (){var statearr_32334 = state_32316;
(statearr_32334[(7)] = inst_32295__$1);

(statearr_32334[(11)] = inst_32297__$1);

return statearr_32334;
})();
if(cljs.core.truth_(inst_32297__$1)){
var statearr_32335_32381 = state_32316__$1;
(statearr_32335_32381[(1)] = (19));

} else {
var statearr_32336_32382 = state_32316__$1;
(statearr_32336_32382[(1)] = (20));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (25))){
var inst_32306 = (state_32316[(2)]);
var state_32316__$1 = state_32316;
var statearr_32337_32383 = state_32316__$1;
(statearr_32337_32383[(2)] = inst_32306);

(statearr_32337_32383[(1)] = (21));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (17))){
var inst_32271 = (state_32316[(10)]);
var inst_32280 = cljs.core.first(inst_32271);
var inst_32281 = cljs.core.async.muxch_STAR_(inst_32280);
var inst_32282 = cljs.core.async.close_BANG_(inst_32281);
var inst_32283 = cljs.core.next(inst_32271);
var inst_32257 = inst_32283;
var inst_32258 = null;
var inst_32259 = (0);
var inst_32260 = (0);
var state_32316__$1 = (function (){var statearr_32338 = state_32316;
(statearr_32338[(12)] = inst_32258);

(statearr_32338[(13)] = inst_32260);

(statearr_32338[(14)] = inst_32259);

(statearr_32338[(15)] = inst_32282);

(statearr_32338[(16)] = inst_32257);

return statearr_32338;
})();
var statearr_32339_32384 = state_32316__$1;
(statearr_32339_32384[(2)] = null);

(statearr_32339_32384[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (3))){
var inst_32314 = (state_32316[(2)]);
var state_32316__$1 = state_32316;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32316__$1,inst_32314);
} else {
if((state_val_32317 === (12))){
var inst_32291 = (state_32316[(2)]);
var state_32316__$1 = state_32316;
var statearr_32340_32385 = state_32316__$1;
(statearr_32340_32385[(2)] = inst_32291);

(statearr_32340_32385[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (2))){
var state_32316__$1 = state_32316;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32316__$1,(4),ch);
} else {
if((state_val_32317 === (23))){
var state_32316__$1 = state_32316;
var statearr_32341_32386 = state_32316__$1;
(statearr_32341_32386[(2)] = null);

(statearr_32341_32386[(1)] = (25));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (19))){
var inst_32297 = (state_32316[(11)]);
var inst_32247 = (state_32316[(8)]);
var inst_32299 = cljs.core.async.muxch_STAR_(inst_32297);
var state_32316__$1 = state_32316;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32316__$1,(22),inst_32299,inst_32247);
} else {
if((state_val_32317 === (11))){
var inst_32271 = (state_32316[(10)]);
var inst_32257 = (state_32316[(16)]);
var inst_32271__$1 = cljs.core.seq(inst_32257);
var state_32316__$1 = (function (){var statearr_32342 = state_32316;
(statearr_32342[(10)] = inst_32271__$1);

return statearr_32342;
})();
if(inst_32271__$1){
var statearr_32343_32387 = state_32316__$1;
(statearr_32343_32387[(1)] = (13));

} else {
var statearr_32344_32388 = state_32316__$1;
(statearr_32344_32388[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (9))){
var inst_32293 = (state_32316[(2)]);
var state_32316__$1 = state_32316;
var statearr_32345_32389 = state_32316__$1;
(statearr_32345_32389[(2)] = inst_32293);

(statearr_32345_32389[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (5))){
var inst_32254 = (function (){var G__32346 = mults;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32346) : cljs.core.deref.call(null,G__32346));
})();
var inst_32255 = cljs.core.vals(inst_32254);
var inst_32256 = cljs.core.seq(inst_32255);
var inst_32257 = inst_32256;
var inst_32258 = null;
var inst_32259 = (0);
var inst_32260 = (0);
var state_32316__$1 = (function (){var statearr_32347 = state_32316;
(statearr_32347[(12)] = inst_32258);

(statearr_32347[(13)] = inst_32260);

(statearr_32347[(14)] = inst_32259);

(statearr_32347[(16)] = inst_32257);

return statearr_32347;
})();
var statearr_32348_32390 = state_32316__$1;
(statearr_32348_32390[(2)] = null);

(statearr_32348_32390[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (14))){
var state_32316__$1 = state_32316;
var statearr_32352_32391 = state_32316__$1;
(statearr_32352_32391[(2)] = null);

(statearr_32352_32391[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (16))){
var inst_32271 = (state_32316[(10)]);
var inst_32275 = cljs.core.chunk_first(inst_32271);
var inst_32276 = cljs.core.chunk_rest(inst_32271);
var inst_32277 = cljs.core.count(inst_32275);
var inst_32257 = inst_32276;
var inst_32258 = inst_32275;
var inst_32259 = inst_32277;
var inst_32260 = (0);
var state_32316__$1 = (function (){var statearr_32353 = state_32316;
(statearr_32353[(12)] = inst_32258);

(statearr_32353[(13)] = inst_32260);

(statearr_32353[(14)] = inst_32259);

(statearr_32353[(16)] = inst_32257);

return statearr_32353;
})();
var statearr_32354_32392 = state_32316__$1;
(statearr_32354_32392[(2)] = null);

(statearr_32354_32392[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (10))){
var inst_32258 = (state_32316[(12)]);
var inst_32260 = (state_32316[(13)]);
var inst_32259 = (state_32316[(14)]);
var inst_32257 = (state_32316[(16)]);
var inst_32265 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32258,inst_32260);
var inst_32266 = cljs.core.async.muxch_STAR_(inst_32265);
var inst_32267 = cljs.core.async.close_BANG_(inst_32266);
var inst_32268 = (inst_32260 + (1));
var tmp32349 = inst_32258;
var tmp32350 = inst_32259;
var tmp32351 = inst_32257;
var inst_32257__$1 = tmp32351;
var inst_32258__$1 = tmp32349;
var inst_32259__$1 = tmp32350;
var inst_32260__$1 = inst_32268;
var state_32316__$1 = (function (){var statearr_32355 = state_32316;
(statearr_32355[(12)] = inst_32258__$1);

(statearr_32355[(17)] = inst_32267);

(statearr_32355[(13)] = inst_32260__$1);

(statearr_32355[(14)] = inst_32259__$1);

(statearr_32355[(16)] = inst_32257__$1);

return statearr_32355;
})();
var statearr_32356_32393 = state_32316__$1;
(statearr_32356_32393[(2)] = null);

(statearr_32356_32393[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (18))){
var inst_32286 = (state_32316[(2)]);
var state_32316__$1 = state_32316;
var statearr_32357_32394 = state_32316__$1;
(statearr_32357_32394[(2)] = inst_32286);

(statearr_32357_32394[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32317 === (8))){
var inst_32260 = (state_32316[(13)]);
var inst_32259 = (state_32316[(14)]);
var inst_32262 = (inst_32260 < inst_32259);
var inst_32263 = inst_32262;
var state_32316__$1 = state_32316;
if(cljs.core.truth_(inst_32263)){
var statearr_32358_32395 = state_32316__$1;
(statearr_32358_32395[(1)] = (10));

} else {
var statearr_32359_32396 = state_32316__$1;
(statearr_32359_32396[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___32368,mults,ensure_mult,p))
;
return ((function (switch__7647__auto__,c__7709__auto___32368,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_32363 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32363[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_32363[(1)] = (1));

return statearr_32363;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_32316){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_32316);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e32364){if((e32364 instanceof Object)){
var ex__7651__auto__ = e32364;
var statearr_32365_32397 = state_32316;
(statearr_32365_32397[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32316);

return cljs.core.constant$keyword$recur;
} else {
throw e32364;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__32398 = state_32316;
state_32316 = G__32398;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_32316){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_32316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___32368,mults,ensure_mult,p))
})();
var state__7711__auto__ = (function (){var statearr_32366 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_32366[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___32368);

return statearr_32366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___32368,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 * By default the channel will be closed when the source closes,
 * but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(){
var G__32400 = arguments.length;
switch (G__32400) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(){
var G__32403 = arguments.length;
switch (G__32403) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 * channel which contains the values produced by applying f to the set
 * of first items taken from each source channel, followed by applying
 * f to the set of second items from each channel, until any one of the
 * channels is closed, at which point the output channel will be
 * closed. The returned channel will be unbuffered by default, or a
 * buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(){
var G__32406 = arguments.length;
switch (G__32406) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (function (){var G__32407 = null;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32407) : cljs.core.atom.call(null,G__32407));
})();
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__7709__auto___32481 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___32481,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___32481,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32446){
var state_val_32447 = (state_32446[(1)]);
if((state_val_32447 === (7))){
var state_32446__$1 = state_32446;
var statearr_32448_32482 = state_32446__$1;
(statearr_32448_32482[(2)] = null);

(statearr_32448_32482[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (1))){
var state_32446__$1 = state_32446;
var statearr_32449_32483 = state_32446__$1;
(statearr_32449_32483[(2)] = null);

(statearr_32449_32483[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (4))){
var inst_32410 = (state_32446[(7)]);
var inst_32412 = (inst_32410 < cnt);
var state_32446__$1 = state_32446;
if(cljs.core.truth_(inst_32412)){
var statearr_32450_32484 = state_32446__$1;
(statearr_32450_32484[(1)] = (6));

} else {
var statearr_32451_32485 = state_32446__$1;
(statearr_32451_32485[(1)] = (7));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (15))){
var inst_32442 = (state_32446[(2)]);
var state_32446__$1 = state_32446;
var statearr_32452_32486 = state_32446__$1;
(statearr_32452_32486[(2)] = inst_32442);

(statearr_32452_32486[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (13))){
var inst_32435 = cljs.core.async.close_BANG_(out);
var state_32446__$1 = state_32446;
var statearr_32453_32487 = state_32446__$1;
(statearr_32453_32487[(2)] = inst_32435);

(statearr_32453_32487[(1)] = (15));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (6))){
var state_32446__$1 = state_32446;
var statearr_32454_32488 = state_32446__$1;
(statearr_32454_32488[(2)] = null);

(statearr_32454_32488[(1)] = (11));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (3))){
var inst_32444 = (state_32446[(2)]);
var state_32446__$1 = state_32446;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32446__$1,inst_32444);
} else {
if((state_val_32447 === (12))){
var inst_32432 = (state_32446[(8)]);
var inst_32432__$1 = (state_32446[(2)]);
var inst_32433 = cljs.core.some(cljs.core.nil_QMARK_,inst_32432__$1);
var state_32446__$1 = (function (){var statearr_32455 = state_32446;
(statearr_32455[(8)] = inst_32432__$1);

return statearr_32455;
})();
if(cljs.core.truth_(inst_32433)){
var statearr_32456_32489 = state_32446__$1;
(statearr_32456_32489[(1)] = (13));

} else {
var statearr_32457_32490 = state_32446__$1;
(statearr_32457_32490[(1)] = (14));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (2))){
var inst_32409 = (function (){var G__32458 = dctr;
var G__32459 = cnt;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32458,G__32459) : cljs.core.reset_BANG_.call(null,G__32458,G__32459));
})();
var inst_32410 = (0);
var state_32446__$1 = (function (){var statearr_32460 = state_32446;
(statearr_32460[(7)] = inst_32410);

(statearr_32460[(9)] = inst_32409);

return statearr_32460;
})();
var statearr_32461_32491 = state_32446__$1;
(statearr_32461_32491[(2)] = null);

(statearr_32461_32491[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (11))){
var inst_32410 = (state_32446[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_32446,(10),Object,null,(9));
var inst_32419 = (function (){var G__32462 = inst_32410;
return (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(G__32462) : chs__$1.call(null,G__32462));
})();
var inst_32420 = (function (){var G__32463 = inst_32410;
return (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(G__32463) : done.call(null,G__32463));
})();
var inst_32421 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32419,inst_32420);
var state_32446__$1 = state_32446;
var statearr_32464_32492 = state_32446__$1;
(statearr_32464_32492[(2)] = inst_32421);


cljs.core.async.impl.ioc_helpers.process_exception(state_32446__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (9))){
var inst_32410 = (state_32446[(7)]);
var inst_32423 = (state_32446[(2)]);
var inst_32424 = (inst_32410 + (1));
var inst_32410__$1 = inst_32424;
var state_32446__$1 = (function (){var statearr_32465 = state_32446;
(statearr_32465[(7)] = inst_32410__$1);

(statearr_32465[(10)] = inst_32423);

return statearr_32465;
})();
var statearr_32466_32493 = state_32446__$1;
(statearr_32466_32493[(2)] = null);

(statearr_32466_32493[(1)] = (4));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (5))){
var inst_32430 = (state_32446[(2)]);
var state_32446__$1 = (function (){var statearr_32467 = state_32446;
(statearr_32467[(11)] = inst_32430);

return statearr_32467;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32446__$1,(12),dchan);
} else {
if((state_val_32447 === (14))){
var inst_32432 = (state_32446[(8)]);
var inst_32437 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_32432);
var state_32446__$1 = state_32446;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32446__$1,(16),out,inst_32437);
} else {
if((state_val_32447 === (16))){
var inst_32439 = (state_32446[(2)]);
var state_32446__$1 = (function (){var statearr_32468 = state_32446;
(statearr_32468[(12)] = inst_32439);

return statearr_32468;
})();
var statearr_32469_32494 = state_32446__$1;
(statearr_32469_32494[(2)] = null);

(statearr_32469_32494[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (10))){
var inst_32414 = (state_32446[(2)]);
var inst_32415 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_32446__$1 = (function (){var statearr_32470 = state_32446;
(statearr_32470[(13)] = inst_32414);

return statearr_32470;
})();
var statearr_32471_32495 = state_32446__$1;
(statearr_32471_32495[(2)] = inst_32415);


cljs.core.async.impl.ioc_helpers.process_exception(state_32446__$1);

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32447 === (8))){
var inst_32428 = (state_32446[(2)]);
var state_32446__$1 = state_32446;
var statearr_32472_32496 = state_32446__$1;
(statearr_32472_32496[(2)] = inst_32428);

(statearr_32472_32496[(1)] = (5));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___32481,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__7647__auto__,c__7709__auto___32481,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_32476 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32476[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_32476[(1)] = (1));

return statearr_32476;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_32446){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_32446);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e32477){if((e32477 instanceof Object)){
var ex__7651__auto__ = e32477;
var statearr_32478_32497 = state_32446;
(statearr_32478_32497[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32446);

return cljs.core.constant$keyword$recur;
} else {
throw e32477;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__32498 = state_32446;
state_32446 = G__32498;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_32446){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_32446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___32481,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__7711__auto__ = (function (){var statearr_32479 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_32479[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___32481);

return statearr_32479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___32481,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 * contains all values taken from them. The returned channel will be
 * unbuffered by default, or a buf-or-n can be supplied. The channel
 * will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(){
var G__32501 = arguments.length;
switch (G__32501) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___32556 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___32556,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___32556,out){
return (function (state_32531){
var state_val_32532 = (state_32531[(1)]);
if((state_val_32532 === (7))){
var inst_32510 = (state_32531[(7)]);
var inst_32511 = (state_32531[(8)]);
var inst_32510__$1 = (state_32531[(2)]);
var inst_32511__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32510__$1,(0),null);
var inst_32512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32510__$1,(1),null);
var inst_32513 = (inst_32511__$1 == null);
var state_32531__$1 = (function (){var statearr_32533 = state_32531;
(statearr_32533[(7)] = inst_32510__$1);

(statearr_32533[(9)] = inst_32512);

(statearr_32533[(8)] = inst_32511__$1);

return statearr_32533;
})();
if(cljs.core.truth_(inst_32513)){
var statearr_32534_32557 = state_32531__$1;
(statearr_32534_32557[(1)] = (8));

} else {
var statearr_32535_32558 = state_32531__$1;
(statearr_32535_32558[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32532 === (1))){
var inst_32502 = cljs.core.vec(chs);
var inst_32503 = inst_32502;
var state_32531__$1 = (function (){var statearr_32536 = state_32531;
(statearr_32536[(10)] = inst_32503);

return statearr_32536;
})();
var statearr_32537_32559 = state_32531__$1;
(statearr_32537_32559[(2)] = null);

(statearr_32537_32559[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32532 === (4))){
var inst_32503 = (state_32531[(10)]);
var state_32531__$1 = state_32531;
return cljs.core.async.ioc_alts_BANG_(state_32531__$1,(7),inst_32503);
} else {
if((state_val_32532 === (6))){
var inst_32527 = (state_32531[(2)]);
var state_32531__$1 = state_32531;
var statearr_32538_32560 = state_32531__$1;
(statearr_32538_32560[(2)] = inst_32527);

(statearr_32538_32560[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32532 === (3))){
var inst_32529 = (state_32531[(2)]);
var state_32531__$1 = state_32531;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32531__$1,inst_32529);
} else {
if((state_val_32532 === (2))){
var inst_32503 = (state_32531[(10)]);
var inst_32505 = cljs.core.count(inst_32503);
var inst_32506 = (inst_32505 > (0));
var state_32531__$1 = state_32531;
if(cljs.core.truth_(inst_32506)){
var statearr_32540_32561 = state_32531__$1;
(statearr_32540_32561[(1)] = (4));

} else {
var statearr_32541_32562 = state_32531__$1;
(statearr_32541_32562[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32532 === (11))){
var inst_32503 = (state_32531[(10)]);
var inst_32520 = (state_32531[(2)]);
var tmp32539 = inst_32503;
var inst_32503__$1 = tmp32539;
var state_32531__$1 = (function (){var statearr_32542 = state_32531;
(statearr_32542[(10)] = inst_32503__$1);

(statearr_32542[(11)] = inst_32520);

return statearr_32542;
})();
var statearr_32543_32563 = state_32531__$1;
(statearr_32543_32563[(2)] = null);

(statearr_32543_32563[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32532 === (9))){
var inst_32511 = (state_32531[(8)]);
var state_32531__$1 = state_32531;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32531__$1,(11),out,inst_32511);
} else {
if((state_val_32532 === (5))){
var inst_32525 = cljs.core.async.close_BANG_(out);
var state_32531__$1 = state_32531;
var statearr_32544_32564 = state_32531__$1;
(statearr_32544_32564[(2)] = inst_32525);

(statearr_32544_32564[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32532 === (10))){
var inst_32523 = (state_32531[(2)]);
var state_32531__$1 = state_32531;
var statearr_32545_32565 = state_32531__$1;
(statearr_32545_32565[(2)] = inst_32523);

(statearr_32545_32565[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32532 === (8))){
var inst_32503 = (state_32531[(10)]);
var inst_32510 = (state_32531[(7)]);
var inst_32512 = (state_32531[(9)]);
var inst_32511 = (state_32531[(8)]);
var inst_32515 = (function (){var c = inst_32512;
var v = inst_32511;
var vec__32508 = inst_32510;
var cs = inst_32503;
return ((function (c,v,vec__32508,cs,inst_32503,inst_32510,inst_32512,inst_32511,state_val_32532,c__7709__auto___32556,out){
return (function (p1__32499_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__32499_SHARP_);
});
;})(c,v,vec__32508,cs,inst_32503,inst_32510,inst_32512,inst_32511,state_val_32532,c__7709__auto___32556,out))
})();
var inst_32516 = cljs.core.filterv(inst_32515,inst_32503);
var inst_32503__$1 = inst_32516;
var state_32531__$1 = (function (){var statearr_32546 = state_32531;
(statearr_32546[(10)] = inst_32503__$1);

return statearr_32546;
})();
var statearr_32547_32566 = state_32531__$1;
(statearr_32547_32566[(2)] = null);

(statearr_32547_32566[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___32556,out))
;
return ((function (switch__7647__auto__,c__7709__auto___32556,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_32551 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32551[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_32551[(1)] = (1));

return statearr_32551;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_32531){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_32531);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e32552){if((e32552 instanceof Object)){
var ex__7651__auto__ = e32552;
var statearr_32553_32567 = state_32531;
(statearr_32553_32567[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32531);

return cljs.core.constant$keyword$recur;
} else {
throw e32552;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__32568 = state_32531;
state_32531 = G__32568;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_32531){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_32531);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___32556,out))
})();
var state__7711__auto__ = (function (){var statearr_32554 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_32554[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___32556);

return statearr_32554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___32556,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 * items taken from the channel conjoined to the supplied
 * collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 * The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(){
var G__32570 = arguments.length;
switch (G__32570) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___32618 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___32618,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___32618,out){
return (function (state_32594){
var state_val_32595 = (state_32594[(1)]);
if((state_val_32595 === (7))){
var inst_32576 = (state_32594[(7)]);
var inst_32576__$1 = (state_32594[(2)]);
var inst_32577 = (inst_32576__$1 == null);
var inst_32578 = cljs.core.not(inst_32577);
var state_32594__$1 = (function (){var statearr_32596 = state_32594;
(statearr_32596[(7)] = inst_32576__$1);

return statearr_32596;
})();
if(inst_32578){
var statearr_32597_32619 = state_32594__$1;
(statearr_32597_32619[(1)] = (8));

} else {
var statearr_32598_32620 = state_32594__$1;
(statearr_32598_32620[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32595 === (1))){
var inst_32571 = (0);
var state_32594__$1 = (function (){var statearr_32599 = state_32594;
(statearr_32599[(8)] = inst_32571);

return statearr_32599;
})();
var statearr_32600_32621 = state_32594__$1;
(statearr_32600_32621[(2)] = null);

(statearr_32600_32621[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32595 === (4))){
var state_32594__$1 = state_32594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32594__$1,(7),ch);
} else {
if((state_val_32595 === (6))){
var inst_32589 = (state_32594[(2)]);
var state_32594__$1 = state_32594;
var statearr_32601_32622 = state_32594__$1;
(statearr_32601_32622[(2)] = inst_32589);

(statearr_32601_32622[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32595 === (3))){
var inst_32591 = (state_32594[(2)]);
var inst_32592 = cljs.core.async.close_BANG_(out);
var state_32594__$1 = (function (){var statearr_32602 = state_32594;
(statearr_32602[(9)] = inst_32591);

return statearr_32602;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32594__$1,inst_32592);
} else {
if((state_val_32595 === (2))){
var inst_32571 = (state_32594[(8)]);
var inst_32573 = (inst_32571 < n);
var state_32594__$1 = state_32594;
if(cljs.core.truth_(inst_32573)){
var statearr_32603_32623 = state_32594__$1;
(statearr_32603_32623[(1)] = (4));

} else {
var statearr_32604_32624 = state_32594__$1;
(statearr_32604_32624[(1)] = (5));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32595 === (11))){
var inst_32571 = (state_32594[(8)]);
var inst_32581 = (state_32594[(2)]);
var inst_32582 = (inst_32571 + (1));
var inst_32571__$1 = inst_32582;
var state_32594__$1 = (function (){var statearr_32605 = state_32594;
(statearr_32605[(8)] = inst_32571__$1);

(statearr_32605[(10)] = inst_32581);

return statearr_32605;
})();
var statearr_32606_32625 = state_32594__$1;
(statearr_32606_32625[(2)] = null);

(statearr_32606_32625[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32595 === (9))){
var state_32594__$1 = state_32594;
var statearr_32607_32626 = state_32594__$1;
(statearr_32607_32626[(2)] = null);

(statearr_32607_32626[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32595 === (5))){
var state_32594__$1 = state_32594;
var statearr_32608_32627 = state_32594__$1;
(statearr_32608_32627[(2)] = null);

(statearr_32608_32627[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32595 === (10))){
var inst_32586 = (state_32594[(2)]);
var state_32594__$1 = state_32594;
var statearr_32609_32628 = state_32594__$1;
(statearr_32609_32628[(2)] = inst_32586);

(statearr_32609_32628[(1)] = (6));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32595 === (8))){
var inst_32576 = (state_32594[(7)]);
var state_32594__$1 = state_32594;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32594__$1,(11),out,inst_32576);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___32618,out))
;
return ((function (switch__7647__auto__,c__7709__auto___32618,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_32613 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32613[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_32613[(1)] = (1));

return statearr_32613;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_32594){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_32594);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e32614){if((e32614 instanceof Object)){
var ex__7651__auto__ = e32614;
var statearr_32615_32629 = state_32594;
(statearr_32615_32629[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32594);

return cljs.core.constant$keyword$recur;
} else {
throw e32614;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__32630 = state_32594;
state_32594 = G__32630;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_32594){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_32594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___32618,out))
})();
var state__7711__auto__ = (function (){var statearr_32616 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_32616[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___32618);

return statearr_32616;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___32618,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t32643 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32643 = (function (ch,f,map_LT_,meta32644){
this.ch = ch;
this.f = f;
this.map_LT_ = map_LT_;
this.meta32644 = meta32644;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32643.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t32643.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t32643.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t32643.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t32646 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32646 = (function (fn1,_,meta32644,map_LT_,f,ch,meta32647){
this.fn1 = fn1;
this._ = _;
this.meta32644 = meta32644;
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta32647 = meta32647;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32646.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t32646.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t32646.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32631_SHARP_){
var G__32649 = (((p1__32631_SHARP_ == null))?null:(function (){var G__32650 = p1__32631_SHARP_;
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__32650) : self__.f.call(null,G__32650));
})());
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__32649) : f1.call(null,G__32649));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t32646.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32648){
var self__ = this;
var _32648__$1 = this;
return self__.meta32647;
});})(___$1))
;

cljs.core.async.t32646.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32648,meta32647__$1){
var self__ = this;
var _32648__$1 = this;
return (new cljs.core.async.t32646(self__.fn1,self__._,self__.meta32644,self__.map_LT_,self__.f,self__.ch,meta32647__$1));
});})(___$1))
;

cljs.core.async.t32646.cljs$lang$type = true;

cljs.core.async.t32646.cljs$lang$ctorStr = "cljs.core.async/t32646";

cljs.core.async.t32646.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t32646");
});})(___$1))
;

cljs.core.async.__GT_t32646 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t32646(fn1__$1,___$2,meta32644__$1,map_LT___$1,f__$1,ch__$1,meta32647){
return (new cljs.core.async.t32646(fn1__$1,___$2,meta32644__$1,map_LT___$1,f__$1,ch__$1,meta32647));
});})(___$1))
;

}

return (new cljs.core.async.t32646(fn1,___$1,self__.meta32644,self__.map_LT_,self__.f,self__.ch,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4264__auto__ = ret;
if(cljs.core.truth_(and__4264__auto__)){
return !(((function (){var G__32651 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32651) : cljs.core.deref.call(null,G__32651));
})() == null));
} else {
return and__4264__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__32652 = (function (){var G__32653 = ret;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__32653) : cljs.core.deref.call(null,G__32653));
})();
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__32652) : self__.f.call(null,G__32652));
})());
} else {
return ret;
}
});

cljs.core.async.t32643.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t32643.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t32643.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t32643.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32645){
var self__ = this;
var _32645__$1 = this;
return self__.meta32644;
});

cljs.core.async.t32643.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32645,meta32644__$1){
var self__ = this;
var _32645__$1 = this;
return (new cljs.core.async.t32643(self__.ch,self__.f,self__.map_LT_,meta32644__$1));
});

cljs.core.async.t32643.cljs$lang$type = true;

cljs.core.async.t32643.cljs$lang$ctorStr = "cljs.core.async/t32643";

cljs.core.async.t32643.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t32643");
});

cljs.core.async.__GT_t32643 = (function cljs$core$async$map_LT__$___GT_t32643(ch__$1,f__$1,map_LT___$1,meta32644){
return (new cljs.core.async.t32643(ch__$1,f__$1,map_LT___$1,meta32644));
});

}

return (new cljs.core.async.t32643(ch,f,cljs$core$async$map_LT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t32658 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32658 = (function (ch,f,map_GT_,meta32659){
this.ch = ch;
this.f = f;
this.map_GT_ = map_GT_;
this.meta32659 = meta32659;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32658.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t32658.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(function (){var G__32661 = val;
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__32661) : self__.f.call(null,G__32661));
})(),fn1);
});

cljs.core.async.t32658.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t32658.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t32658.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t32658.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t32658.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32660){
var self__ = this;
var _32660__$1 = this;
return self__.meta32659;
});

cljs.core.async.t32658.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32660,meta32659__$1){
var self__ = this;
var _32660__$1 = this;
return (new cljs.core.async.t32658(self__.ch,self__.f,self__.map_GT_,meta32659__$1));
});

cljs.core.async.t32658.cljs$lang$type = true;

cljs.core.async.t32658.cljs$lang$ctorStr = "cljs.core.async/t32658";

cljs.core.async.t32658.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t32658");
});

cljs.core.async.__GT_t32658 = (function cljs$core$async$map_GT__$___GT_t32658(ch__$1,f__$1,map_GT___$1,meta32659){
return (new cljs.core.async.t32658(ch__$1,f__$1,map_GT___$1,meta32659));
});

}

return (new cljs.core.async.t32658(ch,f,cljs$core$async$map_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t32666 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.async.t32666 = (function (ch,p,filter_GT_,meta32667){
this.ch = ch;
this.p = p;
this.filter_GT_ = filter_GT_;
this.meta32667 = meta32667;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.async.t32666.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t32666.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((function (){var G__32669 = val;
return (self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(G__32669) : self__.p.call(null,G__32669));
})())){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t32666.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t32666.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t32666.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t32666.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t32666.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t32666.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32668){
var self__ = this;
var _32668__$1 = this;
return self__.meta32667;
});

cljs.core.async.t32666.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32668,meta32667__$1){
var self__ = this;
var _32668__$1 = this;
return (new cljs.core.async.t32666(self__.ch,self__.p,self__.filter_GT_,meta32667__$1));
});

cljs.core.async.t32666.cljs$lang$type = true;

cljs.core.async.t32666.cljs$lang$ctorStr = "cljs.core.async/t32666";

cljs.core.async.t32666.cljs$lang$ctorPrWriter = (function (this__4855__auto__,writer__4856__auto__,opt__4857__auto__){
return cljs.core._write(writer__4856__auto__,"cljs.core.async/t32666");
});

cljs.core.async.__GT_t32666 = (function cljs$core$async$filter_GT__$___GT_t32666(ch__$1,p__$1,filter_GT___$1,meta32667){
return (new cljs.core.async.t32666(ch__$1,p__$1,filter_GT___$1,meta32667));
});

}

return (new cljs.core.async.t32666(ch,p,cljs$core$async$filter_GT_,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(){
var G__32671 = arguments.length;
switch (G__32671) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___32715 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___32715,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___32715,out){
return (function (state_32692){
var state_val_32693 = (state_32692[(1)]);
if((state_val_32693 === (7))){
var inst_32688 = (state_32692[(2)]);
var state_32692__$1 = state_32692;
var statearr_32694_32716 = state_32692__$1;
(statearr_32694_32716[(2)] = inst_32688);

(statearr_32694_32716[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32693 === (1))){
var state_32692__$1 = state_32692;
var statearr_32695_32717 = state_32692__$1;
(statearr_32695_32717[(2)] = null);

(statearr_32695_32717[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32693 === (4))){
var inst_32674 = (state_32692[(7)]);
var inst_32674__$1 = (state_32692[(2)]);
var inst_32675 = (inst_32674__$1 == null);
var state_32692__$1 = (function (){var statearr_32696 = state_32692;
(statearr_32696[(7)] = inst_32674__$1);

return statearr_32696;
})();
if(cljs.core.truth_(inst_32675)){
var statearr_32697_32718 = state_32692__$1;
(statearr_32697_32718[(1)] = (5));

} else {
var statearr_32698_32719 = state_32692__$1;
(statearr_32698_32719[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32693 === (6))){
var inst_32674 = (state_32692[(7)]);
var inst_32679 = (function (){var G__32699 = inst_32674;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__32699) : p.call(null,G__32699));
})();
var state_32692__$1 = state_32692;
if(cljs.core.truth_(inst_32679)){
var statearr_32700_32720 = state_32692__$1;
(statearr_32700_32720[(1)] = (8));

} else {
var statearr_32701_32721 = state_32692__$1;
(statearr_32701_32721[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32693 === (3))){
var inst_32690 = (state_32692[(2)]);
var state_32692__$1 = state_32692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32692__$1,inst_32690);
} else {
if((state_val_32693 === (2))){
var state_32692__$1 = state_32692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32692__$1,(4),ch);
} else {
if((state_val_32693 === (11))){
var inst_32682 = (state_32692[(2)]);
var state_32692__$1 = state_32692;
var statearr_32702_32722 = state_32692__$1;
(statearr_32702_32722[(2)] = inst_32682);

(statearr_32702_32722[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32693 === (9))){
var state_32692__$1 = state_32692;
var statearr_32703_32723 = state_32692__$1;
(statearr_32703_32723[(2)] = null);

(statearr_32703_32723[(1)] = (10));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32693 === (5))){
var inst_32677 = cljs.core.async.close_BANG_(out);
var state_32692__$1 = state_32692;
var statearr_32704_32724 = state_32692__$1;
(statearr_32704_32724[(2)] = inst_32677);

(statearr_32704_32724[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32693 === (10))){
var inst_32685 = (state_32692[(2)]);
var state_32692__$1 = (function (){var statearr_32705 = state_32692;
(statearr_32705[(8)] = inst_32685);

return statearr_32705;
})();
var statearr_32706_32725 = state_32692__$1;
(statearr_32706_32725[(2)] = null);

(statearr_32706_32725[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32693 === (8))){
var inst_32674 = (state_32692[(7)]);
var state_32692__$1 = state_32692;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32692__$1,(11),out,inst_32674);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___32715,out))
;
return ((function (switch__7647__auto__,c__7709__auto___32715,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_32710 = [null,null,null,null,null,null,null,null,null];
(statearr_32710[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_32710[(1)] = (1));

return statearr_32710;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_32692){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_32692);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e32711){if((e32711 instanceof Object)){
var ex__7651__auto__ = e32711;
var statearr_32712_32726 = state_32692;
(statearr_32712_32726[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32692);

return cljs.core.constant$keyword$recur;
} else {
throw e32711;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__32727 = state_32692;
state_32692 = G__32727;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_32692){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_32692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___32715,out))
})();
var state__7711__auto__ = (function (){var statearr_32713 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_32713[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___32715);

return statearr_32713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___32715,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(){
var G__32729 = arguments.length;
switch (G__32729) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__7709__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto__){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto__){
return (function (state_32897){
var state_val_32898 = (state_32897[(1)]);
if((state_val_32898 === (7))){
var inst_32893 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
var statearr_32899_32941 = state_32897__$1;
(statearr_32899_32941[(2)] = inst_32893);

(statearr_32899_32941[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (20))){
var inst_32863 = (state_32897[(7)]);
var inst_32874 = (state_32897[(2)]);
var inst_32875 = cljs.core.next(inst_32863);
var inst_32849 = inst_32875;
var inst_32850 = null;
var inst_32851 = (0);
var inst_32852 = (0);
var state_32897__$1 = (function (){var statearr_32900 = state_32897;
(statearr_32900[(8)] = inst_32849);

(statearr_32900[(9)] = inst_32850);

(statearr_32900[(10)] = inst_32851);

(statearr_32900[(11)] = inst_32874);

(statearr_32900[(12)] = inst_32852);

return statearr_32900;
})();
var statearr_32901_32942 = state_32897__$1;
(statearr_32901_32942[(2)] = null);

(statearr_32901_32942[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (1))){
var state_32897__$1 = state_32897;
var statearr_32902_32943 = state_32897__$1;
(statearr_32902_32943[(2)] = null);

(statearr_32902_32943[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (4))){
var inst_32838 = (state_32897[(13)]);
var inst_32838__$1 = (state_32897[(2)]);
var inst_32839 = (inst_32838__$1 == null);
var state_32897__$1 = (function (){var statearr_32903 = state_32897;
(statearr_32903[(13)] = inst_32838__$1);

return statearr_32903;
})();
if(cljs.core.truth_(inst_32839)){
var statearr_32904_32944 = state_32897__$1;
(statearr_32904_32944[(1)] = (5));

} else {
var statearr_32905_32945 = state_32897__$1;
(statearr_32905_32945[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (15))){
var state_32897__$1 = state_32897;
var statearr_32909_32946 = state_32897__$1;
(statearr_32909_32946[(2)] = null);

(statearr_32909_32946[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (21))){
var state_32897__$1 = state_32897;
var statearr_32910_32947 = state_32897__$1;
(statearr_32910_32947[(2)] = null);

(statearr_32910_32947[(1)] = (23));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (13))){
var inst_32849 = (state_32897[(8)]);
var inst_32850 = (state_32897[(9)]);
var inst_32851 = (state_32897[(10)]);
var inst_32852 = (state_32897[(12)]);
var inst_32859 = (state_32897[(2)]);
var inst_32860 = (inst_32852 + (1));
var tmp32906 = inst_32849;
var tmp32907 = inst_32850;
var tmp32908 = inst_32851;
var inst_32849__$1 = tmp32906;
var inst_32850__$1 = tmp32907;
var inst_32851__$1 = tmp32908;
var inst_32852__$1 = inst_32860;
var state_32897__$1 = (function (){var statearr_32911 = state_32897;
(statearr_32911[(8)] = inst_32849__$1);

(statearr_32911[(9)] = inst_32850__$1);

(statearr_32911[(14)] = inst_32859);

(statearr_32911[(10)] = inst_32851__$1);

(statearr_32911[(12)] = inst_32852__$1);

return statearr_32911;
})();
var statearr_32912_32948 = state_32897__$1;
(statearr_32912_32948[(2)] = null);

(statearr_32912_32948[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (22))){
var state_32897__$1 = state_32897;
var statearr_32913_32949 = state_32897__$1;
(statearr_32913_32949[(2)] = null);

(statearr_32913_32949[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (6))){
var inst_32838 = (state_32897[(13)]);
var inst_32847 = (function (){var G__32914 = inst_32838;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__32914) : f.call(null,G__32914));
})();
var inst_32848 = cljs.core.seq(inst_32847);
var inst_32849 = inst_32848;
var inst_32850 = null;
var inst_32851 = (0);
var inst_32852 = (0);
var state_32897__$1 = (function (){var statearr_32915 = state_32897;
(statearr_32915[(8)] = inst_32849);

(statearr_32915[(9)] = inst_32850);

(statearr_32915[(10)] = inst_32851);

(statearr_32915[(12)] = inst_32852);

return statearr_32915;
})();
var statearr_32916_32950 = state_32897__$1;
(statearr_32916_32950[(2)] = null);

(statearr_32916_32950[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (17))){
var inst_32863 = (state_32897[(7)]);
var inst_32867 = cljs.core.chunk_first(inst_32863);
var inst_32868 = cljs.core.chunk_rest(inst_32863);
var inst_32869 = cljs.core.count(inst_32867);
var inst_32849 = inst_32868;
var inst_32850 = inst_32867;
var inst_32851 = inst_32869;
var inst_32852 = (0);
var state_32897__$1 = (function (){var statearr_32917 = state_32897;
(statearr_32917[(8)] = inst_32849);

(statearr_32917[(9)] = inst_32850);

(statearr_32917[(10)] = inst_32851);

(statearr_32917[(12)] = inst_32852);

return statearr_32917;
})();
var statearr_32918_32951 = state_32897__$1;
(statearr_32918_32951[(2)] = null);

(statearr_32918_32951[(1)] = (8));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (3))){
var inst_32895 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32897__$1,inst_32895);
} else {
if((state_val_32898 === (12))){
var inst_32883 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
var statearr_32919_32952 = state_32897__$1;
(statearr_32919_32952[(2)] = inst_32883);

(statearr_32919_32952[(1)] = (9));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (2))){
var state_32897__$1 = state_32897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32897__$1,(4),in$);
} else {
if((state_val_32898 === (23))){
var inst_32891 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
var statearr_32920_32953 = state_32897__$1;
(statearr_32920_32953[(2)] = inst_32891);

(statearr_32920_32953[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (19))){
var inst_32878 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
var statearr_32921_32954 = state_32897__$1;
(statearr_32921_32954[(2)] = inst_32878);

(statearr_32921_32954[(1)] = (16));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (11))){
var inst_32849 = (state_32897[(8)]);
var inst_32863 = (state_32897[(7)]);
var inst_32863__$1 = cljs.core.seq(inst_32849);
var state_32897__$1 = (function (){var statearr_32922 = state_32897;
(statearr_32922[(7)] = inst_32863__$1);

return statearr_32922;
})();
if(inst_32863__$1){
var statearr_32923_32955 = state_32897__$1;
(statearr_32923_32955[(1)] = (14));

} else {
var statearr_32924_32956 = state_32897__$1;
(statearr_32924_32956[(1)] = (15));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (9))){
var inst_32885 = (state_32897[(2)]);
var inst_32886 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_32897__$1 = (function (){var statearr_32925 = state_32897;
(statearr_32925[(15)] = inst_32885);

return statearr_32925;
})();
if(cljs.core.truth_(inst_32886)){
var statearr_32926_32957 = state_32897__$1;
(statearr_32926_32957[(1)] = (21));

} else {
var statearr_32927_32958 = state_32897__$1;
(statearr_32927_32958[(1)] = (22));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (5))){
var inst_32841 = cljs.core.async.close_BANG_(out);
var state_32897__$1 = state_32897;
var statearr_32928_32959 = state_32897__$1;
(statearr_32928_32959[(2)] = inst_32841);

(statearr_32928_32959[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (14))){
var inst_32863 = (state_32897[(7)]);
var inst_32865 = cljs.core.chunked_seq_QMARK_(inst_32863);
var state_32897__$1 = state_32897;
if(inst_32865){
var statearr_32929_32960 = state_32897__$1;
(statearr_32929_32960[(1)] = (17));

} else {
var statearr_32930_32961 = state_32897__$1;
(statearr_32930_32961[(1)] = (18));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (16))){
var inst_32881 = (state_32897[(2)]);
var state_32897__$1 = state_32897;
var statearr_32931_32962 = state_32897__$1;
(statearr_32931_32962[(2)] = inst_32881);

(statearr_32931_32962[(1)] = (12));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32898 === (10))){
var inst_32850 = (state_32897[(9)]);
var inst_32852 = (state_32897[(12)]);
var inst_32857 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32850,inst_32852);
var state_32897__$1 = state_32897;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32897__$1,(13),out,inst_32857);
} else {
if((state_val_32898 === (18))){
var inst_32863 = (state_32897[(7)]);
var inst_32872 = cljs.core.first(inst_32863);
var state_32897__$1 = state_32897;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32897__$1,(20),out,inst_32872);
} else {
if((state_val_32898 === (8))){
var inst_32851 = (state_32897[(10)]);
var inst_32852 = (state_32897[(12)]);
var inst_32854 = (inst_32852 < inst_32851);
var inst_32855 = inst_32854;
var state_32897__$1 = state_32897;
if(cljs.core.truth_(inst_32855)){
var statearr_32932_32963 = state_32897__$1;
(statearr_32932_32963[(1)] = (10));

} else {
var statearr_32933_32964 = state_32897__$1;
(statearr_32933_32964[(1)] = (11));

}

return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto__))
;
return ((function (switch__7647__auto__,c__7709__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0 = (function (){
var statearr_32937 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32937[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__);

(statearr_32937[(1)] = (1));

return statearr_32937;
});
var cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1 = (function (state_32897){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_32897);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e32938){if((e32938 instanceof Object)){
var ex__7651__auto__ = e32938;
var statearr_32939_32965 = state_32897;
(statearr_32939_32965[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32897);

return cljs.core.constant$keyword$recur;
} else {
throw e32938;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__32966 = state_32897;
state_32897 = G__32966;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__ = function(state_32897){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1.call(this,state_32897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__7648__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto__))
})();
var state__7711__auto__ = (function (){var statearr_32940 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_32940[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto__);

return statearr_32940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto__))
);

return c__7709__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(){
var G__32968 = arguments.length;
switch (G__32968) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(){
var G__32971 = arguments.length;
switch (G__32971) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(){
var G__32974 = arguments.length;
switch (G__32974) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___33024 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___33024,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___33024,out){
return (function (state_32998){
var state_val_32999 = (state_32998[(1)]);
if((state_val_32999 === (7))){
var inst_32993 = (state_32998[(2)]);
var state_32998__$1 = state_32998;
var statearr_33000_33025 = state_32998__$1;
(statearr_33000_33025[(2)] = inst_32993);

(statearr_33000_33025[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32999 === (1))){
var inst_32975 = null;
var state_32998__$1 = (function (){var statearr_33001 = state_32998;
(statearr_33001[(7)] = inst_32975);

return statearr_33001;
})();
var statearr_33002_33026 = state_32998__$1;
(statearr_33002_33026[(2)] = null);

(statearr_33002_33026[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32999 === (4))){
var inst_32978 = (state_32998[(8)]);
var inst_32978__$1 = (state_32998[(2)]);
var inst_32979 = (inst_32978__$1 == null);
var inst_32980 = cljs.core.not(inst_32979);
var state_32998__$1 = (function (){var statearr_33003 = state_32998;
(statearr_33003[(8)] = inst_32978__$1);

return statearr_33003;
})();
if(inst_32980){
var statearr_33004_33027 = state_32998__$1;
(statearr_33004_33027[(1)] = (5));

} else {
var statearr_33005_33028 = state_32998__$1;
(statearr_33005_33028[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32999 === (6))){
var state_32998__$1 = state_32998;
var statearr_33006_33029 = state_32998__$1;
(statearr_33006_33029[(2)] = null);

(statearr_33006_33029[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32999 === (3))){
var inst_32995 = (state_32998[(2)]);
var inst_32996 = cljs.core.async.close_BANG_(out);
var state_32998__$1 = (function (){var statearr_33007 = state_32998;
(statearr_33007[(9)] = inst_32995);

return statearr_33007;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32998__$1,inst_32996);
} else {
if((state_val_32999 === (2))){
var state_32998__$1 = state_32998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32998__$1,(4),ch);
} else {
if((state_val_32999 === (11))){
var inst_32978 = (state_32998[(8)]);
var inst_32987 = (state_32998[(2)]);
var inst_32975 = inst_32978;
var state_32998__$1 = (function (){var statearr_33008 = state_32998;
(statearr_33008[(10)] = inst_32987);

(statearr_33008[(7)] = inst_32975);

return statearr_33008;
})();
var statearr_33009_33030 = state_32998__$1;
(statearr_33009_33030[(2)] = null);

(statearr_33009_33030[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32999 === (9))){
var inst_32978 = (state_32998[(8)]);
var state_32998__$1 = state_32998;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32998__$1,(11),out,inst_32978);
} else {
if((state_val_32999 === (5))){
var inst_32978 = (state_32998[(8)]);
var inst_32975 = (state_32998[(7)]);
var inst_32982 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32978,inst_32975);
var state_32998__$1 = state_32998;
if(inst_32982){
var statearr_33011_33031 = state_32998__$1;
(statearr_33011_33031[(1)] = (8));

} else {
var statearr_33012_33032 = state_32998__$1;
(statearr_33012_33032[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_32999 === (10))){
var inst_32990 = (state_32998[(2)]);
var state_32998__$1 = state_32998;
var statearr_33013_33033 = state_32998__$1;
(statearr_33013_33033[(2)] = inst_32990);

(statearr_33013_33033[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_32999 === (8))){
var inst_32975 = (state_32998[(7)]);
var tmp33010 = inst_32975;
var inst_32975__$1 = tmp33010;
var state_32998__$1 = (function (){var statearr_33014 = state_32998;
(statearr_33014[(7)] = inst_32975__$1);

return statearr_33014;
})();
var statearr_33015_33034 = state_32998__$1;
(statearr_33015_33034[(2)] = null);

(statearr_33015_33034[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___33024,out))
;
return ((function (switch__7647__auto__,c__7709__auto___33024,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_33019 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33019[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_33019[(1)] = (1));

return statearr_33019;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_32998){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_32998);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e33020){if((e33020 instanceof Object)){
var ex__7651__auto__ = e33020;
var statearr_33021_33035 = state_32998;
(statearr_33021_33035[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32998);

return cljs.core.constant$keyword$recur;
} else {
throw e33020;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__33036 = state_32998;
state_32998 = G__33036;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_32998){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_32998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___33024,out))
})();
var state__7711__auto__ = (function (){var statearr_33022 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_33022[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___33024);

return statearr_33022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___33024,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(){
var G__33038 = arguments.length;
switch (G__33038) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___33107 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___33107,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___33107,out){
return (function (state_33076){
var state_val_33077 = (state_33076[(1)]);
if((state_val_33077 === (7))){
var inst_33072 = (state_33076[(2)]);
var state_33076__$1 = state_33076;
var statearr_33078_33108 = state_33076__$1;
(statearr_33078_33108[(2)] = inst_33072);

(statearr_33078_33108[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33077 === (1))){
var inst_33039 = (new Array(n));
var inst_33040 = inst_33039;
var inst_33041 = (0);
var state_33076__$1 = (function (){var statearr_33079 = state_33076;
(statearr_33079[(7)] = inst_33040);

(statearr_33079[(8)] = inst_33041);

return statearr_33079;
})();
var statearr_33080_33109 = state_33076__$1;
(statearr_33080_33109[(2)] = null);

(statearr_33080_33109[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33077 === (4))){
var inst_33044 = (state_33076[(9)]);
var inst_33044__$1 = (state_33076[(2)]);
var inst_33045 = (inst_33044__$1 == null);
var inst_33046 = cljs.core.not(inst_33045);
var state_33076__$1 = (function (){var statearr_33081 = state_33076;
(statearr_33081[(9)] = inst_33044__$1);

return statearr_33081;
})();
if(inst_33046){
var statearr_33082_33110 = state_33076__$1;
(statearr_33082_33110[(1)] = (5));

} else {
var statearr_33083_33111 = state_33076__$1;
(statearr_33083_33111[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33077 === (15))){
var inst_33066 = (state_33076[(2)]);
var state_33076__$1 = state_33076;
var statearr_33084_33112 = state_33076__$1;
(statearr_33084_33112[(2)] = inst_33066);

(statearr_33084_33112[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33077 === (13))){
var state_33076__$1 = state_33076;
var statearr_33085_33113 = state_33076__$1;
(statearr_33085_33113[(2)] = null);

(statearr_33085_33113[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33077 === (6))){
var inst_33041 = (state_33076[(8)]);
var inst_33062 = (inst_33041 > (0));
var state_33076__$1 = state_33076;
if(cljs.core.truth_(inst_33062)){
var statearr_33086_33114 = state_33076__$1;
(statearr_33086_33114[(1)] = (12));

} else {
var statearr_33087_33115 = state_33076__$1;
(statearr_33087_33115[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33077 === (3))){
var inst_33074 = (state_33076[(2)]);
var state_33076__$1 = state_33076;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33076__$1,inst_33074);
} else {
if((state_val_33077 === (12))){
var inst_33040 = (state_33076[(7)]);
var inst_33064 = cljs.core.vec(inst_33040);
var state_33076__$1 = state_33076;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33076__$1,(15),out,inst_33064);
} else {
if((state_val_33077 === (2))){
var state_33076__$1 = state_33076;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33076__$1,(4),ch);
} else {
if((state_val_33077 === (11))){
var inst_33056 = (state_33076[(2)]);
var inst_33057 = (new Array(n));
var inst_33040 = inst_33057;
var inst_33041 = (0);
var state_33076__$1 = (function (){var statearr_33088 = state_33076;
(statearr_33088[(7)] = inst_33040);

(statearr_33088[(8)] = inst_33041);

(statearr_33088[(10)] = inst_33056);

return statearr_33088;
})();
var statearr_33089_33116 = state_33076__$1;
(statearr_33089_33116[(2)] = null);

(statearr_33089_33116[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33077 === (9))){
var inst_33040 = (state_33076[(7)]);
var inst_33054 = cljs.core.vec(inst_33040);
var state_33076__$1 = state_33076;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33076__$1,(11),out,inst_33054);
} else {
if((state_val_33077 === (5))){
var inst_33040 = (state_33076[(7)]);
var inst_33041 = (state_33076[(8)]);
var inst_33049 = (state_33076[(11)]);
var inst_33044 = (state_33076[(9)]);
var inst_33048 = (inst_33040[inst_33041] = inst_33044);
var inst_33049__$1 = (inst_33041 + (1));
var inst_33050 = (inst_33049__$1 < n);
var state_33076__$1 = (function (){var statearr_33090 = state_33076;
(statearr_33090[(12)] = inst_33048);

(statearr_33090[(11)] = inst_33049__$1);

return statearr_33090;
})();
if(cljs.core.truth_(inst_33050)){
var statearr_33091_33117 = state_33076__$1;
(statearr_33091_33117[(1)] = (8));

} else {
var statearr_33092_33118 = state_33076__$1;
(statearr_33092_33118[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33077 === (14))){
var inst_33069 = (state_33076[(2)]);
var inst_33070 = cljs.core.async.close_BANG_(out);
var state_33076__$1 = (function (){var statearr_33094 = state_33076;
(statearr_33094[(13)] = inst_33069);

return statearr_33094;
})();
var statearr_33095_33119 = state_33076__$1;
(statearr_33095_33119[(2)] = inst_33070);

(statearr_33095_33119[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33077 === (10))){
var inst_33060 = (state_33076[(2)]);
var state_33076__$1 = state_33076;
var statearr_33096_33120 = state_33076__$1;
(statearr_33096_33120[(2)] = inst_33060);

(statearr_33096_33120[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33077 === (8))){
var inst_33040 = (state_33076[(7)]);
var inst_33049 = (state_33076[(11)]);
var tmp33093 = inst_33040;
var inst_33040__$1 = tmp33093;
var inst_33041 = inst_33049;
var state_33076__$1 = (function (){var statearr_33097 = state_33076;
(statearr_33097[(7)] = inst_33040__$1);

(statearr_33097[(8)] = inst_33041);

return statearr_33097;
})();
var statearr_33098_33121 = state_33076__$1;
(statearr_33098_33121[(2)] = null);

(statearr_33098_33121[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___33107,out))
;
return ((function (switch__7647__auto__,c__7709__auto___33107,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_33102 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33102[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_33102[(1)] = (1));

return statearr_33102;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_33076){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_33076);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e33103){if((e33103 instanceof Object)){
var ex__7651__auto__ = e33103;
var statearr_33104_33122 = state_33076;
(statearr_33104_33122[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33076);

return cljs.core.constant$keyword$recur;
} else {
throw e33103;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__33123 = state_33076;
state_33076 = G__33123;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_33076){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_33076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___33107,out))
})();
var state__7711__auto__ = (function (){var statearr_33105 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_33105[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___33107);

return statearr_33105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___33107,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(){
var G__33125 = arguments.length;
switch (G__33125) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__7709__auto___33199 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__7709__auto___33199,out){
return (function (){
var f__7710__auto__ = (function (){var switch__7647__auto__ = ((function (c__7709__auto___33199,out){
return (function (state_33167){
var state_val_33168 = (state_33167[(1)]);
if((state_val_33168 === (7))){
var inst_33163 = (state_33167[(2)]);
var state_33167__$1 = state_33167;
var statearr_33169_33200 = state_33167__$1;
(statearr_33169_33200[(2)] = inst_33163);

(statearr_33169_33200[(1)] = (3));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33168 === (1))){
var inst_33126 = [];
var inst_33127 = inst_33126;
var inst_33128 = cljs.core.constant$keyword$cljs$core$async_SLASH_nothing;
var state_33167__$1 = (function (){var statearr_33170 = state_33167;
(statearr_33170[(7)] = inst_33128);

(statearr_33170[(8)] = inst_33127);

return statearr_33170;
})();
var statearr_33171_33201 = state_33167__$1;
(statearr_33171_33201[(2)] = null);

(statearr_33171_33201[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33168 === (4))){
var inst_33131 = (state_33167[(9)]);
var inst_33131__$1 = (state_33167[(2)]);
var inst_33132 = (inst_33131__$1 == null);
var inst_33133 = cljs.core.not(inst_33132);
var state_33167__$1 = (function (){var statearr_33172 = state_33167;
(statearr_33172[(9)] = inst_33131__$1);

return statearr_33172;
})();
if(inst_33133){
var statearr_33173_33202 = state_33167__$1;
(statearr_33173_33202[(1)] = (5));

} else {
var statearr_33174_33203 = state_33167__$1;
(statearr_33174_33203[(1)] = (6));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33168 === (15))){
var inst_33157 = (state_33167[(2)]);
var state_33167__$1 = state_33167;
var statearr_33175_33204 = state_33167__$1;
(statearr_33175_33204[(2)] = inst_33157);

(statearr_33175_33204[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33168 === (13))){
var state_33167__$1 = state_33167;
var statearr_33176_33205 = state_33167__$1;
(statearr_33176_33205[(2)] = null);

(statearr_33176_33205[(1)] = (14));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33168 === (6))){
var inst_33127 = (state_33167[(8)]);
var inst_33152 = inst_33127.length;
var inst_33153 = (inst_33152 > (0));
var state_33167__$1 = state_33167;
if(cljs.core.truth_(inst_33153)){
var statearr_33177_33206 = state_33167__$1;
(statearr_33177_33206[(1)] = (12));

} else {
var statearr_33178_33207 = state_33167__$1;
(statearr_33178_33207[(1)] = (13));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33168 === (3))){
var inst_33165 = (state_33167[(2)]);
var state_33167__$1 = state_33167;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33167__$1,inst_33165);
} else {
if((state_val_33168 === (12))){
var inst_33127 = (state_33167[(8)]);
var inst_33155 = cljs.core.vec(inst_33127);
var state_33167__$1 = state_33167;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33167__$1,(15),out,inst_33155);
} else {
if((state_val_33168 === (2))){
var state_33167__$1 = state_33167;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33167__$1,(4),ch);
} else {
if((state_val_33168 === (11))){
var inst_33131 = (state_33167[(9)]);
var inst_33135 = (state_33167[(10)]);
var inst_33145 = (state_33167[(2)]);
var inst_33146 = [];
var inst_33147 = inst_33146.push(inst_33131);
var inst_33127 = inst_33146;
var inst_33128 = inst_33135;
var state_33167__$1 = (function (){var statearr_33179 = state_33167;
(statearr_33179[(7)] = inst_33128);

(statearr_33179[(11)] = inst_33145);

(statearr_33179[(8)] = inst_33127);

(statearr_33179[(12)] = inst_33147);

return statearr_33179;
})();
var statearr_33180_33208 = state_33167__$1;
(statearr_33180_33208[(2)] = null);

(statearr_33180_33208[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33168 === (9))){
var inst_33127 = (state_33167[(8)]);
var inst_33143 = cljs.core.vec(inst_33127);
var state_33167__$1 = state_33167;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33167__$1,(11),out,inst_33143);
} else {
if((state_val_33168 === (5))){
var inst_33128 = (state_33167[(7)]);
var inst_33131 = (state_33167[(9)]);
var inst_33135 = (state_33167[(10)]);
var inst_33135__$1 = (function (){var G__33181 = inst_33131;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33181) : f.call(null,G__33181));
})();
var inst_33136 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33135__$1,inst_33128);
var inst_33137 = cljs.core.keyword_identical_QMARK_(inst_33128,cljs.core.constant$keyword$cljs$core$async_SLASH_nothing);
var inst_33138 = (inst_33136) || (inst_33137);
var state_33167__$1 = (function (){var statearr_33182 = state_33167;
(statearr_33182[(10)] = inst_33135__$1);

return statearr_33182;
})();
if(cljs.core.truth_(inst_33138)){
var statearr_33183_33209 = state_33167__$1;
(statearr_33183_33209[(1)] = (8));

} else {
var statearr_33184_33210 = state_33167__$1;
(statearr_33184_33210[(1)] = (9));

}

return cljs.core.constant$keyword$recur;
} else {
if((state_val_33168 === (14))){
var inst_33160 = (state_33167[(2)]);
var inst_33161 = cljs.core.async.close_BANG_(out);
var state_33167__$1 = (function (){var statearr_33186 = state_33167;
(statearr_33186[(13)] = inst_33160);

return statearr_33186;
})();
var statearr_33187_33211 = state_33167__$1;
(statearr_33187_33211[(2)] = inst_33161);

(statearr_33187_33211[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33168 === (10))){
var inst_33150 = (state_33167[(2)]);
var state_33167__$1 = state_33167;
var statearr_33188_33212 = state_33167__$1;
(statearr_33188_33212[(2)] = inst_33150);

(statearr_33188_33212[(1)] = (7));


return cljs.core.constant$keyword$recur;
} else {
if((state_val_33168 === (8))){
var inst_33131 = (state_33167[(9)]);
var inst_33127 = (state_33167[(8)]);
var inst_33135 = (state_33167[(10)]);
var inst_33140 = inst_33127.push(inst_33131);
var tmp33185 = inst_33127;
var inst_33127__$1 = tmp33185;
var inst_33128 = inst_33135;
var state_33167__$1 = (function (){var statearr_33189 = state_33167;
(statearr_33189[(7)] = inst_33128);

(statearr_33189[(14)] = inst_33140);

(statearr_33189[(8)] = inst_33127__$1);

return statearr_33189;
})();
var statearr_33190_33213 = state_33167__$1;
(statearr_33190_33213[(2)] = null);

(statearr_33190_33213[(1)] = (2));


return cljs.core.constant$keyword$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__7709__auto___33199,out))
;
return ((function (switch__7647__auto__,c__7709__auto___33199,out){
return (function() {
var cljs$core$async$state_machine__7648__auto__ = null;
var cljs$core$async$state_machine__7648__auto____0 = (function (){
var statearr_33194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33194[(0)] = cljs$core$async$state_machine__7648__auto__);

(statearr_33194[(1)] = (1));

return statearr_33194;
});
var cljs$core$async$state_machine__7648__auto____1 = (function (state_33167){
while(true){
var ret_value__7649__auto__ = (function (){try{while(true){
var result__7650__auto__ = switch__7647__auto__(state_33167);
if(cljs.core.keyword_identical_QMARK_(result__7650__auto__,cljs.core.constant$keyword$recur)){
continue;
} else {
return result__7650__auto__;
}
break;
}
}catch (e33195){if((e33195 instanceof Object)){
var ex__7651__auto__ = e33195;
var statearr_33196_33214 = state_33167;
(statearr_33196_33214[(5)] = ex__7651__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33167);

return cljs.core.constant$keyword$recur;
} else {
throw e33195;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__7649__auto__,cljs.core.constant$keyword$recur)){
var G__33215 = state_33167;
state_33167 = G__33215;
continue;
} else {
return ret_value__7649__auto__;
}
break;
}
});
cljs$core$async$state_machine__7648__auto__ = function(state_33167){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__7648__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__7648__auto____1.call(this,state_33167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__7648__auto____0;
cljs$core$async$state_machine__7648__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__7648__auto____1;
return cljs$core$async$state_machine__7648__auto__;
})()
;})(switch__7647__auto__,c__7709__auto___33199,out))
})();
var state__7711__auto__ = (function (){var statearr_33197 = (function (){return (f__7710__auto__.cljs$core$IFn$_invoke$arity$0 ? f__7710__auto__.cljs$core$IFn$_invoke$arity$0() : f__7710__auto__.call(null));
})();
(statearr_33197[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__7709__auto___33199);

return statearr_33197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__7711__auto__);
});})(c__7709__auto___33199,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
