if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}


var CLOSURE_NO_DEPS = true;
var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.global.CLOSURE_UNCOMPILED_DEFINES;
goog.global.CLOSURE_DEFINES;
goog.isDef = function(val) {
  return val !== void 0;
};
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if (!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0]);
  }
  for (var part;parts.length && (part = parts.shift());) {
    if (!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object;
    } else {
      if (cur[part]) {
        cur = cur[part];
      } else {
        cur = cur[part] = {};
      }
    }
  }
};
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    if (goog.global.CLOSURE_UNCOMPILED_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
    } else {
      if (goog.global.CLOSURE_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, name)) {
        value = goog.global.CLOSURE_DEFINES[name];
      }
    }
  }
  goog.exportPath_(name, value);
};
goog.DEBUG = true;
goog.define("goog.LOCALE", "en");
goog.define("goog.TRUSTED_SITE", true);
goog.define("goog.STRICT_MODE_COMPATIBLE", false);
goog.provide = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while (namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }
  goog.exportPath_(name);
};
goog.setTestOnly = function(opt_message) {
  if (COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + (opt_message ? ": " + opt_message : "."));
  }
};
goog.forwardDeclare = function(name) {
};
if (!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && goog.isDefAndNotNull(goog.getObjectByName(name));
  };
  goog.implicitNamespaces_ = {};
}
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for (var part;part = parts.shift();) {
    if (goog.isDefAndNotNull(cur[part])) {
      cur = cur[part];
    } else {
      return null;
    }
  }
  return cur;
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if (goog.DEPENDENCIES_ENABLED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for (var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if (!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {};
      }
      deps.pathToNames[path][provide] = true;
    }
    for (var j = 0;require = requires[j];j++) {
      if (!(path in deps.requires)) {
        deps.requires[path] = {};
      }
      deps.requires[path][require] = true;
    }
  }
};
goog.define("goog.ENABLE_DEBUG_LOADER", true);
goog.require = function(name) {
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      return;
    }
    if (goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if (path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return;
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if (goog.global.console) {
      goog.global.console["error"](errorMessage);
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(opt_returnValue, var_args) {
  return opt_returnValue;
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return ctor.instance_ = new ctor;
  };
};
goog.instantiatedSingletons_ = [];
goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;
if (goog.DEPENDENCIES_ENABLED) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc;
  };
  goog.findBasePath_ = function() {
    if (goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else {
      if (!goog.inHtmlDocument_()) {
        return;
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for (var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if (!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.writeScriptTag_ = function(src) {
    if (goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      if (doc.readyState == "complete") {
        var isDeps = /\bdeps.js$/.test(src);
        if (isDeps) {
          return false;
        } else {
          throw Error('Cannot write "' + src + '" after document load');
        }
      }
      doc.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"\x3e\x3c/' + "script\x3e");
      return true;
    } else {
      return false;
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if (path in deps.written) {
        return;
      }
      if (path in deps.visited) {
        if (!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path);
        }
        return;
      }
      deps.visited[path] = true;
      if (path in deps.requires) {
        for (var requireName in deps.requires[path]) {
          if (!goog.isProvided_(requireName)) {
            if (requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName]);
            } else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if (!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path);
      }
    }
    for (var path in goog.included_) {
      if (!deps.written[path]) {
        visitNode(path);
      }
    }
    for (var i = 0;i < scripts.length;i++) {
      if (scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i]);
      } else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if (rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule];
    } else {
      return null;
    }
  };
  goog.findBasePath_();
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js");
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == "object") {
    if (value) {
      if (value instanceof Array) {
        return "array";
      } else {
        if (value instanceof Object) {
          return s;
        }
      }
      var className = Object.prototype.toString.call((value));
      if (className == "[object Window]") {
        return "object";
      }
      if (className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return "array";
      }
      if (className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return "function";
      }
    } else {
      return "null";
    }
  } else {
    if (s == "function" && typeof value.call == "undefined") {
      return "object";
    }
  }
  return s;
};
goog.isNull = function(val) {
  return val === null;
};
goog.isDefAndNotNull = function(val) {
  return val != null;
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array";
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number";
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function";
};
goog.isString = function(val) {
  return typeof val == "string";
};
goog.isBoolean = function(val) {
  return typeof val == "boolean";
};
goog.isNumber = function(val) {
  return typeof val == "number";
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function";
};
goog.isObject = function(val) {
  var type = typeof val;
  return type == "object" && val != null || type == "function";
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
goog.hasUid = function(obj) {
  return!!obj[goog.UID_PROPERTY_];
};
goog.removeUid = function(obj) {
  if ("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + (Math.random() * 1E9 >>> 0);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.bindNative_ = function(fn, selfObj, var_args) {
  return(fn.call.apply(fn.bind, arguments));
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error;
  }
  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if (Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
goog.now = goog.TRUSTED_SITE && Date.now || function() {
  return+new Date;
};
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, "JavaScript");
  } else {
    if (goog.global.eval) {
      if (goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ \x3d 1;");
        if (typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true;
        } else {
          goog.evalWorksForGlobals_ = false;
        }
      }
      if (goog.evalWorksForGlobals_) {
        goog.global.eval(script);
      } else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt);
      }
    } else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for (var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join("-");
  };
  var rename;
  if (goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }
  if (opt_modifier) {
    return className + "-" + rename(opt_modifier);
  } else {
    return rename(className);
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}
goog.getMsg = function(str, opt_values) {
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return key in opt_values ? opt_values[key] : match;
    });
  }
  return str;
};
goog.getMsgWithFallback = function(a, b) {
  return a;
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor;
  childCtor.base = function(me, methodName, var_args) {
    var args = Array.prototype.slice.call(arguments, 2);
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !caller) {
    throw Error("arguments.caller not defined.  goog.base() cannot be used " + "with strict mode code. See " + "http://www.ecma-international.org/ecma-262/5.1/#sec-C");
  }
  if (caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1));
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for (var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else {
      if (foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args);
      }
    }
  }
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global);
};
if (!COMPILED) {
  goog.global["COMPILED"] = COMPILED;
}
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor;
  var statics = def.statics;
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw Error("cannot instantiate an interface (no constructor defined).");
    };
  }
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }
  return cls;
};
goog.defineClass.ClassDescriptor;
goog.define("goog.defineClass.SEAL_CLASS_INSTANCES", goog.DEBUG);
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (goog.defineClass.SEAL_CLASS_INSTANCES && Object.seal instanceof Function) {
    if (superClass && superClass.prototype && superClass.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]) {
      return ctr;
    }
    var wrappedCtr = function() {
      var instance = ctr.apply(this, arguments) || this;
      if (this.constructor === wrappedCtr) {
        Object.seal(instance);
      }
      return instance;
    };
    return wrappedCtr;
  }
  return ctr;
};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.defineClass.applyProperties_ = function(target, source) {
  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
  for (var i = 0;i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable";
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.define("goog.string.DETECT_DOUBLE_ESCAPING", false);
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0;
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l;
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0;
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0;
};
goog.string.caseInsensitiveEquals = function(str1, str2) {
  return str1.toLowerCase() == str2.toLowerCase();
};
goog.string.subs = function(str, var_args) {
  var splitParts = str.split("%s");
  var returnString = "";
  var subsArguments = Array.prototype.slice.call(arguments, 1);
  while (subsArguments.length && splitParts.length > 1) {
    returnString += splitParts.shift() + subsArguments.shift();
  }
  return returnString + splitParts.join("%s");
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "");
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str);
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str));
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str);
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str);
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str);
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str);
};
goog.string.isSpace = function(ch) {
  return ch == " ";
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd";
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ");
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n");
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ");
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ");
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "");
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "");
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "");
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "");
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if (test1 < test2) {
    return-1;
  } else {
    if (test1 == test2) {
      return 0;
    } else {
      return 1;
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if (str1 == str2) {
    return 0;
  }
  if (!str1) {
    return-1;
  }
  if (!str2) {
    return 1;
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for (var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if (a != b) {
      var num1 = parseInt(a, 10);
      if (!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if (!isNaN(num2) && num1 - num2) {
          return num1 - num2;
        }
      }
      return a < b ? -1 : 1;
    }
  }
  if (tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length;
  }
  return str1 < str2 ? -1 : 1;
};
goog.string.urlEncode = function(str) {
  return encodeURIComponent(String(str));
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "));
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "\x3cbr /\x3e" : "\x3cbr\x3e");
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if (opt_isLikelyToContainHtmlChars) {
    str = str.replace(goog.string.AMP_RE_, "\x26amp;").replace(goog.string.LT_RE_, "\x26lt;").replace(goog.string.GT_RE_, "\x26gt;").replace(goog.string.QUOT_RE_, "\x26quot;").replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;").replace(goog.string.NULL_RE_, "\x26#0;");
    if (goog.string.DETECT_DOUBLE_ESCAPING) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  } else {
    if (!goog.string.ALL_RE_.test(str)) {
      return str;
    }
    if (str.indexOf("\x26") != -1) {
      str = str.replace(goog.string.AMP_RE_, "\x26amp;");
    }
    if (str.indexOf("\x3c") != -1) {
      str = str.replace(goog.string.LT_RE_, "\x26lt;");
    }
    if (str.indexOf("\x3e") != -1) {
      str = str.replace(goog.string.GT_RE_, "\x26gt;");
    }
    if (str.indexOf('"') != -1) {
      str = str.replace(goog.string.QUOT_RE_, "\x26quot;");
    }
    if (str.indexOf("'") != -1) {
      str = str.replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;");
    }
    if (str.indexOf("\x00") != -1) {
      str = str.replace(goog.string.NULL_RE_, "\x26#0;");
    }
    if (goog.string.DETECT_DOUBLE_ESCAPING && str.indexOf("e") != -1) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  }
};
goog.string.AMP_RE_ = /&/g;
goog.string.LT_RE_ = /</g;
goog.string.GT_RE_ = />/g;
goog.string.QUOT_RE_ = /"/g;
goog.string.SINGLE_QUOTE_RE_ = /'/g;
goog.string.NULL_RE_ = /\x00/g;
goog.string.E_RE_ = /e/g;
goog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\x00&<>"'e]/ : /[\x00&<>"']/;
goog.string.unescapeEntities = function(str) {
  if (goog.string.contains(str, "\x26")) {
    if ("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str);
    } else {
      return goog.string.unescapePureXmlEntities_(str);
    }
  }
  return str;
};
goog.string.unescapeEntitiesWithDocument = function(str, document) {
  if (goog.string.contains(str, "\x26")) {
    return goog.string.unescapeEntitiesUsingDom_(str, document);
  }
  return str;
};
goog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {
  var seen = {"\x26amp;":"\x26", "\x26lt;":"\x3c", "\x26gt;":"\x3e", "\x26quot;":'"'};
  var div;
  if (opt_document) {
    div = opt_document.createElement("div");
  } else {
    div = goog.global.document.createElement("div");
  }
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if (value) {
      return value;
    }
    if (entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if (!isNaN(n)) {
        value = String.fromCharCode(n);
      }
    }
    if (!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1);
    }
    return seen[s] = value;
  });
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return "\x26";
      case "lt":
        return "\x3c";
      case "gt":
        return "\x3e";
      case "quot":
        return'"';
      default:
        if (entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if (!isNaN(n)) {
            return String.fromCharCode(n);
          }
        }
        return s;
    }
  });
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " \x26#160;"), opt_xml);
};
goog.string.preserveSpaces = function(str) {
  return str.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP);
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for (var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if (str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1);
    }
  }
  return str;
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (str.length > chars) {
    str = str.substring(0, chars - 3) + "...";
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (opt_trailingChars && str.length > chars) {
    if (opt_trailingChars > chars) {
      opt_trailingChars = chars;
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint);
  } else {
    if (str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos);
    }
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\b":"\\b", "\f":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if (s.quote) {
    return s.quote();
  } else {
    var sb = ['"'];
    for (var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch));
    }
    sb.push('"');
    return sb.join("");
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for (var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i));
  }
  return sb.join("");
};
goog.string.escapeChar = function(c) {
  if (c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c];
  }
  if (c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if (cc > 31 && cc < 127) {
    rv = c;
  } else {
    if (cc < 256) {
      rv = "\\x";
      if (cc < 16 || cc > 256) {
        rv += "0";
      }
    } else {
      rv = "\\u";
      if (cc < 4096) {
        rv += "0";
      }
    }
    rv += cc.toString(16).toUpperCase();
  }
  return goog.string.jsEscapeCache_[c] = rv;
};
goog.string.toMap = function(s) {
  var rv = {};
  for (var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true;
  }
  return rv;
};
goog.string.contains = function(str, subString) {
  return str.indexOf(subString) != -1;
};
goog.string.caseInsensitiveContains = function(str, subString) {
  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());
};
goog.string.countOf = function(s, ss) {
  return s && ss ? s.split(ss).length - 1 : 0;
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if (index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength);
  }
  return resultStr;
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "");
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "");
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string);
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if (index == -1) {
    index = s.length;
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s;
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj);
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "");
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for (var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if (v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break;
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2]);
    } while (order == 0);
  }
  return order;
};
goog.string.compareElements_ = function(left, right) {
  if (left < right) {
    return-1;
  } else {
    if (left > right) {
      return 1;
    }
  }
  return 0;
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for (var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_;
  }
  return result;
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return "goog_" + goog.string.uniqueStringCounter_++;
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if (num == 0 && goog.string.isEmpty(str)) {
    return NaN;
  }
  return num;
};
goog.string.isLowerCamelCase = function(str) {
  return/^[a-z]+([A-Z][a-z]*)*$/.test(str);
};
goog.string.isUpperCamelCase = function(str) {
  return/^([A-Z][a-z]*)+$/.test(str);
};
goog.string.toCamelCase = function(str) {
  return String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase();
  });
};
goog.string.toSelectorCase = function(str) {
  return String(str).replace(/([A-Z])/g, "-$1").toLowerCase();
};
goog.string.toTitleCase = function(str, opt_delimiters) {
  var delimiters = goog.isString(opt_delimiters) ? goog.string.regExpEscape(opt_delimiters) : "\\s";
  delimiters = delimiters ? "|[" + delimiters + "]+" : "";
  var regexp = new RegExp("(^" + delimiters + ")([a-z])", "g");
  return str.replace(regexp, function(all, p1, p2) {
    return p1 + p2.toUpperCase();
  });
};
goog.string.parseInt = function(value) {
  if (isFinite(value)) {
    value = String(value);
  }
  if (goog.isString(value)) {
    return/^\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);
  }
  return NaN;
};
goog.string.splitLimit = function(str, separator, limit) {
  var parts = str.split(separator);
  var returnVal = [];
  while (limit > 0 && parts.length) {
    returnVal.push(parts.shift());
    limit--;
  }
  if (parts.length) {
    returnVal.push(parts.join(separator));
  }
  return returnVal;
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for (var key in obj) {
    f.call(opt_obj, obj[key], key, obj);
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key];
    }
  }
  return res;
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj);
  }
  return res;
};
goog.object.some = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      return true;
    }
  }
  return false;
};
goog.object.every = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (!f.call(opt_obj, obj[key], key, obj)) {
      return false;
    }
  }
  return true;
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for (var key in obj) {
    rv++;
  }
  return rv;
};
goog.object.getAnyKey = function(obj) {
  for (var key in obj) {
    return key;
  }
};
goog.object.getAnyValue = function(obj) {
  for (var key in obj) {
    return obj[key];
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val);
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = obj[key];
  }
  return res;
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = key;
  }
  return res;
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for (var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if (!goog.isDef(obj)) {
      break;
    }
  }
  return obj;
};
goog.object.containsKey = function(obj, key) {
  return key in obj;
};
goog.object.containsValue = function(obj, val) {
  for (var key in obj) {
    if (obj[key] == val) {
      return true;
    }
  }
  return false;
};
goog.object.findKey = function(obj, f, opt_this) {
  for (var key in obj) {
    if (f.call(opt_this, obj[key], key, obj)) {
      return key;
    }
  }
  return undefined;
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key];
};
goog.object.isEmpty = function(obj) {
  for (var key in obj) {
    return false;
  }
  return true;
};
goog.object.clear = function(obj) {
  for (var i in obj) {
    delete obj[i];
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if (rv = key in obj) {
    delete obj[key];
  }
  return rv;
};
goog.object.add = function(obj, key, val) {
  if (key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val);
};
goog.object.get = function(obj, key, opt_val) {
  if (key in obj) {
    return obj[key];
  }
  return opt_val;
};
goog.object.set = function(obj, key, value) {
  obj[key] = value;
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value;
};
goog.object.clone = function(obj) {
  var res = {};
  for (var key in obj) {
    res[key] = obj[key];
  }
  return res;
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for (var key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for (var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for (var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0]);
  }
  var rv = {};
  for (var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true;
  }
  return rv;
};
goog.object.createImmutableView = function(obj) {
  var result = obj;
  if (Object.isFrozen && !Object.isFrozen(obj)) {
    result = Object.create(obj);
    Object.freeze(result);
  }
  return result;
};
goog.object.isImmutableView = function(obj) {
  return!!Object.isFrozen && Object.isFrozen(obj);
};
goog.provide("goog.string.StringBuffer");
goog.string.StringBuffer = function(opt_a1, var_args) {
  if (opt_a1 != null) {
    this.append.apply(this, arguments);
  }
};
goog.string.StringBuffer.prototype.buffer_ = "";
goog.string.StringBuffer.prototype.set = function(s) {
  this.buffer_ = "" + s;
};
goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
  this.buffer_ += a1;
  if (opt_a2 != null) {
    for (var i = 1;i < arguments.length;i++) {
      this.buffer_ += arguments[i];
    }
  }
  return this;
};
goog.string.StringBuffer.prototype.clear = function() {
  this.buffer_ = "";
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.buffer_.length;
};
goog.string.StringBuffer.prototype.toString = function() {
  return this.buffer_;
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, goog.debug.Error);
  } else {
    var stack = (new Error).stack;
    if (stack) {
      this.stack = stack;
    }
  }
  if (opt_msg) {
    this.message = String(opt_msg);
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.dom.NodeType");
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.dom.NodeType");
goog.require("goog.string");
goog.define("goog.asserts.ENABLE_ASSERTS", goog.DEBUG);
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern;
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.DEFAULT_ERROR_HANDLER = function(e) {
  throw e;
};
goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if (givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs;
  } else {
    if (defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs;
    }
  }
  var e = new goog.asserts.AssertionError("" + message, args || []);
  goog.asserts.errorHandler_(e);
};
goog.asserts.setErrorHandler = function(errorHandler) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_ = errorHandler;
  }
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return condition;
};
goog.asserts.fail = function(opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1)));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return(value);
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return(value);
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return(value);
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return(value);
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return(value);
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return(value);
};
goog.asserts.assertElement = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && (!goog.isObject(value) || value.nodeType != goog.dom.NodeType.ELEMENT)) {
    goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return(value);
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3));
  }
  return value;
};
goog.asserts.assertObjectPrototypeIsIntact = function() {
  for (var key in Object.prototype) {
    goog.asserts.fail(key + " should not be enumerable in Object.prototype.");
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.define("goog.NATIVE_ARRAY_PROTOTYPES", goog.TRUSTED_SITE);
goog.define("goog.array.ASSUME_NATIVE_FUNCTIONS", false);
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1];
};
goog.array.last = goog.array.peek;
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.indexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return-1;
    }
    return arr.indexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i < arr.length;i++) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return-1;
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.lastIndexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if (fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex);
  }
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return-1;
    }
    return arr.lastIndexOf(obj, fromIndex);
  }
  for (var i = fromIndex;i >= 0;i--) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return-1;
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.forEach) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;--i) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.filter) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      var val = arr2[i];
      if (f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val;
      }
    }
  }
  return res;
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.map) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr);
    }
  }
  return res;
};
goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduce) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return goog.array.ARRAY_PROTOTYPE_.reduce.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.reduceRight) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return goog.array.ARRAY_PROTOTYPE_.reduceRight.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.some) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true;
    }
  }
  return false;
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || goog.array.ARRAY_PROTOTYPE_.every) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false;
    }
  }
  return true;
};
goog.array.count = function(arr, f, opt_obj) {
  var count = 0;
  goog.array.forEach(arr, function(element, index, arr) {
    if (f.call(opt_obj, element, index, arr)) {
      ++count;
    }
  }, opt_obj);
  return count;
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0;i < l;i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return-1;
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1;i >= 0;i--) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return-1;
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0;
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0;
};
goog.array.clear = function(arr) {
  if (!goog.isArray(arr)) {
    for (var i = arr.length - 1;i >= 0;i--) {
      delete arr[i];
    }
  }
  arr.length = 0;
};
goog.array.insert = function(arr, obj) {
  if (!goog.array.contains(arr, obj)) {
    arr.push(obj);
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj);
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if (arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj);
  } else {
    goog.array.insertAt(arr, obj, i);
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if (rv = i >= 0) {
    goog.array.removeAt(arr, i);
  }
  return rv;
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1;
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.join = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments);
};
goog.array.toArray = function(object) {
  var length = object.length;
  if (length > 0) {
    var rv = new Array(length);
    for (var i = 0;i < length;i++) {
      rv[i] = object[i];
    }
    return rv;
  }
  return[];
};
goog.array.clone = goog.array.toArray;
goog.array.extend = function(arr1, var_args) {
  for (var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if (goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && Object.prototype.hasOwnProperty.call(arr2, "callee")) {
      arr1.push.apply(arr1, arr2);
    } else {
      if (isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for (var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j];
        }
      } else {
        arr1.push(arr2);
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1));
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if (arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start);
  } else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end);
  }
};
goog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {
  var returnArray = opt_rv || arr;
  var defaultHashFn = function(item) {
    return goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
  };
  var hashFn = opt_hashFn || defaultHashFn;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while (cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = hashFn(current);
    if (!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current;
    }
  }
  returnArray.length = cursorInsert;
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target);
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj);
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while (left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if (isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr);
    } else {
      compareResult = compareFn(opt_target, arr[middle]);
    }
    if (compareResult > 0) {
      left = middle + 1;
    } else {
      right = middle;
      found = !compareResult;
    }
  }
  return found ? left : ~left;
};
goog.array.sort = function(arr, opt_compareFn) {
  arr.sort(opt_compareFn || goog.array.defaultCompare);
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for (var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]};
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;
  }
  goog.array.sort(arr, stableCompareFn);
  for (var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value;
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key]);
  });
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for (var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if (compareResult > 0 || compareResult == 0 && opt_strict) {
      return false;
    }
  }
  return true;
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false;
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for (var i = 0;i < l;i++) {
    if (!equalsFn(arr1[i], arr2[i])) {
      return false;
    }
  }
  return true;
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for (var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if (result != 0) {
      return result;
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length);
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0;
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b;
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if (index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true;
  }
  return false;
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false;
};
goog.array.bucket = function(array, sorter, opt_obj) {
  var buckets = {};
  for (var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter.call(opt_obj, value, i, array);
    if (goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value);
    }
  }
  return buckets;
};
goog.array.toObject = function(arr, keyFunc, opt_obj) {
  var ret = {};
  goog.array.forEach(arr, function(element, index) {
    ret[keyFunc.call(opt_obj, element, index, arr)] = element;
  });
  return ret;
};
goog.array.range = function(startOrEnd, opt_end, opt_step) {
  var array = [];
  var start = 0;
  var end = startOrEnd;
  var step = opt_step || 1;
  if (opt_end !== undefined) {
    start = startOrEnd;
    end = opt_end;
  }
  if (step * (end - start) < 0) {
    return[];
  }
  if (step > 0) {
    for (var i = start;i < end;i += step) {
      array.push(i);
    }
  } else {
    for (var i = start;i > end;i += step) {
      array.push(i);
    }
  }
  return array;
};
goog.array.repeat = function(value, n) {
  var array = [];
  for (var i = 0;i < n;i++) {
    array[i] = value;
  }
  return array;
};
goog.array.flatten = function(var_args) {
  var result = [];
  for (var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if (goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element));
    } else {
      result.push(element);
    }
  }
  return result;
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if (array.length) {
    n %= array.length;
    if (n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n));
    } else {
      if (n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n));
      }
    }
  }
  return array;
};
goog.array.moveItem = function(arr, fromIndex, toIndex) {
  goog.asserts.assert(fromIndex >= 0 && fromIndex < arr.length);
  goog.asserts.assert(toIndex >= 0 && toIndex < arr.length);
  var removedItems = goog.array.ARRAY_PROTOTYPE_.splice.call(arr, fromIndex, 1);
  goog.array.ARRAY_PROTOTYPE_.splice.call(arr, toIndex, 0, removedItems[0]);
};
goog.array.zip = function(var_args) {
  if (!arguments.length) {
    return[];
  }
  var result = [];
  for (var i = 0;true;i++) {
    var value = [];
    for (var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if (i >= arr.length) {
        return result;
      }
      value.push(arr[i]);
    }
    result.push(value);
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for (var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }
};
goog.provide("cljs.core");
goog.require("goog.string.StringBuffer");
goog.require("goog.array");
goog.require("goog.object");
goog.require("goog.string");
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-3196";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_target_STAR_ = "default";
if (typeof cljs.core._STAR_print_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_fn_STAR_ = function cljs$core$_STAR_print_fn_STAR_(_) {
    throw new Error("No *print-fn* fn set for evaluation environment");
  };
}
cljs.core.set_print_fn_BANG_ = function cljs$core$set_print_fn_BANG_(f) {
  return cljs.core._STAR_print_fn_STAR_ = f;
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
if (typeof cljs.core._STAR_loaded_libs_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = function cljs$core$pr_opts() {
  return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null, "flush-on-newline", "flush-on-newline", -151457939), cljs.core._STAR_flush_on_newline_STAR_, new cljs.core.Keyword(null, "readably", "readably", 1129599760), cljs.core._STAR_print_readably_STAR_, new cljs.core.Keyword(null, "meta", "meta", 1499536964), cljs.core._STAR_print_meta_STAR_, new cljs.core.Keyword(null, "dup", "dup", 556298533), cljs.core._STAR_print_dup_STAR_, new cljs.core.Keyword(null, "print-length", "print-length", 
  1931866356), cljs.core._STAR_print_length_STAR_], null);
};
cljs.core.enable_console_print_BANG_ = function cljs$core$enable_console_print_BANG_() {
  cljs.core._STAR_print_newline_STAR_ = false;
  return cljs.core._STAR_print_fn_STAR_ = function() {
    var G__14970__delegate = function(args) {
      return console.log.apply(console, function() {
        var G__14969 = args;
        return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__14969) : cljs.core.into_array.call(null, G__14969);
      }());
    };
    var G__14970 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__14971__i = 0, G__14971__a = new Array(arguments.length - 0);
        while (G__14971__i < G__14971__a.length) {
          G__14971__a[G__14971__i] = arguments[G__14971__i + 0];
          ++G__14971__i;
        }
        args = new cljs.core.IndexedSeq(G__14971__a, 0);
      }
      return G__14970__delegate.call(this, args);
    };
    G__14970.cljs$lang$maxFixedArity = 0;
    G__14970.cljs$lang$applyTo = function(arglist__14972) {
      var args = cljs.core.seq(arglist__14972);
      return G__14970__delegate(args);
    };
    G__14970.cljs$core$IFn$_invoke$arity$variadic = G__14970__delegate;
    return G__14970;
  }();
};
cljs.core.truth_ = function cljs$core$truth_(x) {
  return x != null && x !== false;
};
cljs.core.not_native = null;
cljs.core.identical_QMARK_ = function cljs$core$identical_QMARK_(x, y) {
  return x === y;
};
cljs.core.nil_QMARK_ = function cljs$core$nil_QMARK_(x) {
  return x == null;
};
cljs.core.array_QMARK_ = function cljs$core$array_QMARK_(x) {
  if (cljs.core._STAR_target_STAR_ === "nodejs") {
    return Array.isArray(x);
  } else {
    return x instanceof Array;
  }
};
cljs.core.number_QMARK_ = function cljs$core$number_QMARK_(n) {
  return typeof n === "number";
};
cljs.core.not = function cljs$core$not(x) {
  if (cljs.core.truth_(x)) {
    return false;
  } else {
    return true;
  }
};
cljs.core.some_QMARK_ = function cljs$core$some_QMARK_(x) {
  return!(x == null);
};
cljs.core.object_QMARK_ = function cljs$core$object_QMARK_(x) {
  if (!(x == null)) {
    return x.constructor === Object;
  } else {
    return false;
  }
};
cljs.core.string_QMARK_ = function cljs$core$string_QMARK_(x) {
  var G__14974 = x;
  return goog.isString(G__14974);
};
cljs.core.native_satisfies_QMARK_ = function cljs$core$native_satisfies_QMARK_(p, x) {
  var x__$1 = x == null ? null : x;
  if (p[function() {
    var G__14976 = x__$1;
    return goog.typeOf(G__14976);
  }()]) {
    return true;
  } else {
    if (p["_"]) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.is_proto_ = function cljs$core$is_proto_(x) {
  return x.constructor.prototype === x;
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.type = function cljs$core$type(x) {
  if (x == null) {
    return null;
  } else {
    return x.constructor;
  }
};
cljs.core.missing_protocol = function cljs$core$missing_protocol(proto, obj) {
  var ty = cljs.core.type(obj);
  var ty__$1 = cljs.core.truth_(function() {
    var and__4264__auto__ = ty;
    if (cljs.core.truth_(and__4264__auto__)) {
      return ty.cljs$lang$type;
    } else {
      return and__4264__auto__;
    }
  }()) ? ty.cljs$lang$ctorStr : function() {
    var G__14978 = obj;
    return goog.typeOf(G__14978);
  }();
  return new Error(["No protocol method ", proto, " defined for type ", ty__$1, ": ", obj].join(""));
};
cljs.core.type__GT_str = function cljs$core$type__GT_str(ty) {
  var temp__4124__auto__ = ty.cljs$lang$ctorStr;
  if (cljs.core.truth_(temp__4124__auto__)) {
    var s = temp__4124__auto__;
    return s;
  } else {
    return[cljs.core.str(ty)].join("");
  }
};
cljs.core.load_file = function cljs$core$load_file(file) {
  if (cljs.core.truth_(COMPILED)) {
    return null;
  } else {
    return goog.nodeGlobalRequire(file);
  }
};
if (typeof Symbol !== "undefined" && function() {
  var G__14980 = Symbol;
  return goog.typeOf(G__14980);
}() === "function") {
  cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
  cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.make_array = function cljs$core$make_array() {
  var G__14982 = arguments.length;
  switch(G__14982) {
    case 1:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = function(size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = function(type, size) {
  return new Array(size);
};
cljs.core.make_array.cljs$lang$maxFixedArity = 2;
cljs.core.aclone = function cljs$core$aclone(arr) {
  var len = arr.length;
  var new_arr = new Array(len);
  var n__5161__auto___14984 = len;
  var i_14985 = 0;
  while (true) {
    if (i_14985 < n__5161__auto___14984) {
      new_arr[i_14985] = arr[i_14985];
      var G__14986 = i_14985 + 1;
      i_14985 = G__14986;
      continue;
    } else {
    }
    break;
  }
  return new_arr;
};
cljs.core.array = function cljs$core$array(var_args) {
  var a = new Array(arguments.length);
  var i = 0;
  while (true) {
    if (i < a.length) {
      a[i] = arguments[i];
      var G__14987 = i + 1;
      i = G__14987;
      continue;
    } else {
      return a;
    }
    break;
  }
};
cljs.core.aget = function cljs$core$aget() {
  var G__14992 = arguments.length;
  switch(G__14992) {
    case 2:
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return array[i];
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = function(array, i, idxs) {
  var G__14993 = cljs.core.aget;
  var G__14994 = array[i];
  var G__14995 = idxs;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__14993, G__14994, G__14995) : cljs.core.apply.call(null, G__14993, G__14994, G__14995);
};
cljs.core.aget.cljs$lang$applyTo = function(seq14988) {
  var G__14989 = cljs.core.first(seq14988);
  var seq14988__$1 = cljs.core.next(seq14988);
  var G__14990 = cljs.core.first(seq14988__$1);
  var seq14988__$2 = cljs.core.next(seq14988__$1);
  return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__14989, G__14990, seq14988__$2);
};
cljs.core.aget.cljs$lang$maxFixedArity = 2;
cljs.core.aset = function cljs$core$aset() {
  var G__15002 = arguments.length;
  switch(G__15002) {
    case 3:
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5328__auto__);
  }
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = function(array, i, val) {
  return array[i] = val;
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idx2, idxv) {
  var G__15003 = cljs.core.aset;
  var G__15004 = array[idx];
  var G__15005 = idx2;
  var G__15006 = idxv;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__15003, G__15004, G__15005, G__15006) : cljs.core.apply.call(null, G__15003, G__15004, G__15005, G__15006);
};
cljs.core.aset.cljs$lang$applyTo = function(seq14997) {
  var G__14998 = cljs.core.first(seq14997);
  var seq14997__$1 = cljs.core.next(seq14997);
  var G__14999 = cljs.core.first(seq14997__$1);
  var seq14997__$2 = cljs.core.next(seq14997__$1);
  var G__15000 = cljs.core.first(seq14997__$2);
  var seq14997__$3 = cljs.core.next(seq14997__$2);
  return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__14998, G__14999, G__15000, seq14997__$3);
};
cljs.core.aset.cljs$lang$maxFixedArity = 3;
cljs.core.alength = function cljs$core$alength(array) {
  return array.length;
};
cljs.core.into_array = function cljs$core$into_array() {
  var G__15009 = arguments.length;
  switch(G__15009) {
    case 1:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = function(aseq) {
  return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null, aseq);
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = function(type, aseq) {
  var G__15010 = function(a, x) {
    a.push(x);
    return a;
  };
  var G__15011 = [];
  var G__15012 = aseq;
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__15010, G__15011, G__15012) : cljs.core.reduce.call(null, G__15010, G__15011, G__15012);
};
cljs.core.into_array.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke = function cljs$core$js_invoke() {
  var argseq__5316__auto__ = 2 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0) : null;
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5316__auto__);
};
cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = function(obj, s, args) {
  return obj[s].apply(obj, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
cljs.core.js_invoke.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke.cljs$lang$applyTo = function(seq15014) {
  var G__15015 = cljs.core.first(seq15014);
  var seq15014__$1 = cljs.core.next(seq15014);
  var G__15016 = cljs.core.first(seq15014__$1);
  var seq15014__$2 = cljs.core.next(seq15014__$1);
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__15015, G__15016, seq15014__$2);
};
cljs.core.Fn = function() {
  var obj15018 = {};
  return obj15018;
}();
cljs.core.IFn = function() {
  var obj15020 = {};
  return obj15020;
}();
cljs.core._invoke = function cljs$core$_invoke() {
  var G__15022 = arguments.length;
  switch(G__15022) {
    case 1:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    case 8:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]);
      break;
    case 9:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8]);
      break;
    case 10:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);
      break;
    case 11:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10]);
      break;
    case 12:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11]);
      break;
    case 13:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12]);
      break;
    case 14:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13]);
      break;
    case 15:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14]);
      break;
    case 16:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15]);
      break;
    case 17:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16]);
      break;
    case 18:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17]);
      break;
    case 19:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18]);
      break;
    case 20:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19]);
      break;
    case 21:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20]);
      break;
    case 22:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20], arguments[21]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = function(this$) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$1(this$);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15024 = x__4912__auto__;
        return goog.typeOf(G__15024);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = function(this$, a) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$2(this$, a);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15026 = x__4912__auto__;
        return goog.typeOf(G__15026);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = function(this$, a, b) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15028 = x__4912__auto__;
        return goog.typeOf(G__15028);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = function(this$, a, b, c) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$4;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15030 = x__4912__auto__;
        return goog.typeOf(G__15030);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = function(this$, a, b, c, d) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$5;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15032 = x__4912__auto__;
        return goog.typeOf(G__15032);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = function(this$, a, b, c, d, e) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$6;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15034 = x__4912__auto__;
        return goog.typeOf(G__15034);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = function(this$, a, b, c, d, e, f) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$7;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15036 = x__4912__auto__;
        return goog.typeOf(G__15036);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = function(this$, a, b, c, d, e, f, g) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$8;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15038 = x__4912__auto__;
        return goog.typeOf(G__15038);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = function(this$, a, b, c, d, e, f, g, h) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$9;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15040 = x__4912__auto__;
        return goog.typeOf(G__15040);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = function(this$, a, b, c, d, e, f, g, h, i) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$10;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15042 = x__4912__auto__;
        return goog.typeOf(G__15042);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$11;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15044 = x__4912__auto__;
        return goog.typeOf(G__15044);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$12;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15046 = x__4912__auto__;
        return goog.typeOf(G__15046);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$13;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15048 = x__4912__auto__;
        return goog.typeOf(G__15048);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$14;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15050 = x__4912__auto__;
        return goog.typeOf(G__15050);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$15;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15052 = x__4912__auto__;
        return goog.typeOf(G__15052);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$16;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15054 = x__4912__auto__;
        return goog.typeOf(G__15054);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$17;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15056 = x__4912__auto__;
        return goog.typeOf(G__15056);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$18;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15058 = x__4912__auto__;
        return goog.typeOf(G__15058);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$19;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15060 = x__4912__auto__;
        return goog.typeOf(G__15060);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$20;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15062 = x__4912__auto__;
        return goog.typeOf(G__15062);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$21;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15064 = x__4912__auto__;
        return goog.typeOf(G__15064);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IFn$_invoke$arity$22;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._invoke[function() {
        var G__15066 = x__4912__auto__;
        return goog.typeOf(G__15066);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._invoke["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IFn.-invoke", this$);
        }
      }
    }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  }
};
cljs.core._invoke.cljs$lang$maxFixedArity = 22;
cljs.core.ICloneable = function() {
  var obj15069 = {};
  return obj15069;
}();
cljs.core._clone = function cljs$core$_clone(value) {
  if (function() {
    var and__4264__auto__ = value;
    if (and__4264__auto__) {
      return value.cljs$core$ICloneable$_clone$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return value.cljs$core$ICloneable$_clone$arity$1(value);
  } else {
    var x__4912__auto__ = value == null ? null : value;
    return function() {
      var or__4276__auto__ = cljs.core._clone[function() {
        var G__15073 = x__4912__auto__;
        return goog.typeOf(G__15073);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._clone["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICloneable.-clone", value);
        }
      }
    }().call(null, value);
  }
};
cljs.core.ICounted = function() {
  var obj15075 = {};
  return obj15075;
}();
cljs.core._count = function cljs$core$_count(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$ICounted$_count$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._count[function() {
        var G__15079 = x__4912__auto__;
        return goog.typeOf(G__15079);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._count["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICounted.-count", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IEmptyableCollection = function() {
  var obj15081 = {};
  return obj15081;
}();
cljs.core._empty = function cljs$core$_empty(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._empty[function() {
        var G__15085 = x__4912__auto__;
        return goog.typeOf(G__15085);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._empty["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ICollection = function() {
  var obj15087 = {};
  return obj15087;
}();
cljs.core._conj = function cljs$core$_conj(coll, o) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$ICollection$_conj$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._conj[function() {
        var G__15091 = x__4912__auto__;
        return goog.typeOf(G__15091);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._conj["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o);
  }
};
cljs.core.IIndexed = function() {
  var obj15093 = {};
  return obj15093;
}();
cljs.core._nth = function cljs$core$_nth() {
  var G__15095 = arguments.length;
  switch(G__15095) {
    case 2:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IIndexed$_nth$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._nth[function() {
        var G__15097 = x__4912__auto__;
        return goog.typeOf(G__15097);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._nth["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIndexed.-nth", coll);
        }
      }
    }().call(null, coll, n);
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IIndexed$_nth$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._nth[function() {
        var G__15099 = x__4912__auto__;
        return goog.typeOf(G__15099);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._nth["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIndexed.-nth", coll);
        }
      }
    }().call(null, coll, n, not_found);
  }
};
cljs.core._nth.cljs$lang$maxFixedArity = 3;
cljs.core.ASeq = function() {
  var obj15102 = {};
  return obj15102;
}();
cljs.core.ISeq = function() {
  var obj15104 = {};
  return obj15104;
}();
cljs.core._first = function cljs$core$_first(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$ISeq$_first$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._first[function() {
        var G__15108 = x__4912__auto__;
        return goog.typeOf(G__15108);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._first["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeq.-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._rest = function cljs$core$_rest(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$ISeq$_rest$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._rest[function() {
        var G__15112 = x__4912__auto__;
        return goog.typeOf(G__15112);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._rest["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeq.-rest", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.INext = function() {
  var obj15114 = {};
  return obj15114;
}();
cljs.core._next = function cljs$core$_next(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$INext$_next$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$INext$_next$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._next[function() {
        var G__15118 = x__4912__auto__;
        return goog.typeOf(G__15118);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._next["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INext.-next", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ILookup = function() {
  var obj15120 = {};
  return obj15120;
}();
cljs.core._lookup = function cljs$core$_lookup() {
  var G__15122 = arguments.length;
  switch(G__15122) {
    case 2:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$ILookup$_lookup$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$ILookup$_lookup$arity$2(o, k);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._lookup[function() {
        var G__15124 = x__4912__auto__;
        return goog.typeOf(G__15124);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._lookup["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ILookup.-lookup", o);
        }
      }
    }().call(null, o, k);
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$ILookup$_lookup$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._lookup[function() {
        var G__15126 = x__4912__auto__;
        return goog.typeOf(G__15126);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._lookup["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ILookup.-lookup", o);
        }
      }
    }().call(null, o, k, not_found);
  }
};
cljs.core._lookup.cljs$lang$maxFixedArity = 3;
cljs.core.IAssociative = function() {
  var obj15129 = {};
  return obj15129;
}();
cljs.core._contains_key_QMARK_ = function cljs$core$_contains_key_QMARK_(coll, k) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._contains_key_QMARK_[function() {
        var G__15133 = x__4912__auto__;
        return goog.typeOf(G__15133);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._contains_key_QMARK_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k);
  }
};
cljs.core._assoc = function cljs$core$_assoc(coll, k, v) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IAssociative$_assoc$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._assoc[function() {
        var G__15137 = x__4912__auto__;
        return goog.typeOf(G__15137);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._assoc["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v);
  }
};
cljs.core.IMap = function() {
  var obj15139 = {};
  return obj15139;
}();
cljs.core._dissoc = function cljs$core$_dissoc(coll, k) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IMap$_dissoc$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._dissoc[function() {
        var G__15143 = x__4912__auto__;
        return goog.typeOf(G__15143);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._dissoc["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k);
  }
};
cljs.core.IMapEntry = function() {
  var obj15145 = {};
  return obj15145;
}();
cljs.core._key = function cljs$core$_key(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IMapEntry$_key$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._key[function() {
        var G__15149 = x__4912__auto__;
        return goog.typeOf(G__15149);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._key["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMapEntry.-key", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._val = function cljs$core$_val(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IMapEntry$_val$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._val[function() {
        var G__15153 = x__4912__auto__;
        return goog.typeOf(G__15153);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._val["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMapEntry.-val", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ISet = function() {
  var obj15155 = {};
  return obj15155;
}();
cljs.core._disjoin = function cljs$core$_disjoin(coll, v) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$ISet$_disjoin$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._disjoin[function() {
        var G__15159 = x__4912__auto__;
        return goog.typeOf(G__15159);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._disjoin["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v);
  }
};
cljs.core.IStack = function() {
  var obj15161 = {};
  return obj15161;
}();
cljs.core._peek = function cljs$core$_peek(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IStack$_peek$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._peek[function() {
        var G__15165 = x__4912__auto__;
        return goog.typeOf(G__15165);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._peek["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IStack.-peek", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._pop = function cljs$core$_pop(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IStack$_pop$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._pop[function() {
        var G__15169 = x__4912__auto__;
        return goog.typeOf(G__15169);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._pop["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IStack.-pop", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IVector = function() {
  var obj15171 = {};
  return obj15171;
}();
cljs.core._assoc_n = function cljs$core$_assoc_n(coll, n, val) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IVector$_assoc_n$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._assoc_n[function() {
        var G__15175 = x__4912__auto__;
        return goog.typeOf(G__15175);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._assoc_n["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val);
  }
};
cljs.core.IDeref = function() {
  var obj15177 = {};
  return obj15177;
}();
cljs.core._deref = function cljs$core$_deref(o) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$IDeref$_deref$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._deref[function() {
        var G__15181 = x__4912__auto__;
        return goog.typeOf(G__15181);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._deref["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IDeref.-deref", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.IDerefWithTimeout = function() {
  var obj15183 = {};
  return obj15183;
}();
cljs.core._deref_with_timeout = function cljs$core$_deref_with_timeout(o, msec, timeout_val) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._deref_with_timeout[function() {
        var G__15187 = x__4912__auto__;
        return goog.typeOf(G__15187);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._deref_with_timeout["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val);
  }
};
cljs.core.IMeta = function() {
  var obj15189 = {};
  return obj15189;
}();
cljs.core._meta = function cljs$core$_meta(o) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$IMeta$_meta$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._meta[function() {
        var G__15193 = x__4912__auto__;
        return goog.typeOf(G__15193);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._meta["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IMeta.-meta", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.IWithMeta = function() {
  var obj15195 = {};
  return obj15195;
}();
cljs.core._with_meta = function cljs$core$_with_meta(o, meta) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._with_meta[function() {
        var G__15199 = x__4912__auto__;
        return goog.typeOf(G__15199);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._with_meta["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta);
  }
};
cljs.core.IReduce = function() {
  var obj15201 = {};
  return obj15201;
}();
cljs.core._reduce = function cljs$core$_reduce() {
  var G__15203 = arguments.length;
  switch(G__15203) {
    case 2:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = function(coll, f) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IReduce$_reduce$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$2(coll, f);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._reduce[function() {
        var G__15205 = x__4912__auto__;
        return goog.typeOf(G__15205);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._reduce["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReduce.-reduce", coll);
        }
      }
    }().call(null, coll, f);
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = function(coll, f, start) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IReduce$_reduce$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._reduce[function() {
        var G__15207 = x__4912__auto__;
        return goog.typeOf(G__15207);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._reduce["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReduce.-reduce", coll);
        }
      }
    }().call(null, coll, f, start);
  }
};
cljs.core._reduce.cljs$lang$maxFixedArity = 3;
cljs.core.IKVReduce = function() {
  var obj15210 = {};
  return obj15210;
}();
cljs.core._kv_reduce = function cljs$core$_kv_reduce(coll, f, init) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._kv_reduce[function() {
        var G__15214 = x__4912__auto__;
        return goog.typeOf(G__15214);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._kv_reduce["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init);
  }
};
cljs.core.IEquiv = function() {
  var obj15216 = {};
  return obj15216;
}();
cljs.core._equiv = function cljs$core$_equiv(o, other) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$IEquiv$_equiv$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._equiv[function() {
        var G__15220 = x__4912__auto__;
        return goog.typeOf(G__15220);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._equiv["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other);
  }
};
cljs.core.IHash = function() {
  var obj15222 = {};
  return obj15222;
}();
cljs.core._hash = function cljs$core$_hash(o) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$IHash$_hash$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._hash[function() {
        var G__15226 = x__4912__auto__;
        return goog.typeOf(G__15226);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._hash["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IHash.-hash", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.ISeqable = function() {
  var obj15228 = {};
  return obj15228;
}();
cljs.core._seq = function cljs$core$_seq(o) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$ISeqable$_seq$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._seq[function() {
        var G__15232 = x__4912__auto__;
        return goog.typeOf(G__15232);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._seq["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISeqable.-seq", o);
        }
      }
    }().call(null, o);
  }
};
cljs.core.ISequential = function() {
  var obj15234 = {};
  return obj15234;
}();
cljs.core.IList = function() {
  var obj15236 = {};
  return obj15236;
}();
cljs.core.IRecord = function() {
  var obj15238 = {};
  return obj15238;
}();
cljs.core.IReversible = function() {
  var obj15240 = {};
  return obj15240;
}();
cljs.core._rseq = function cljs$core$_rseq(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IReversible$_rseq$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._rseq[function() {
        var G__15244 = x__4912__auto__;
        return goog.typeOf(G__15244);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._rseq["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReversible.-rseq", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ISorted = function() {
  var obj15246 = {};
  return obj15246;
}();
cljs.core._sorted_seq = function cljs$core$_sorted_seq(coll, ascending_QMARK_) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._sorted_seq[function() {
        var G__15250 = x__4912__auto__;
        return goog.typeOf(G__15250);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._sorted_seq["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_);
  }
};
cljs.core._sorted_seq_from = function cljs$core$_sorted_seq_from(coll, k, ascending_QMARK_) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._sorted_seq_from[function() {
        var G__15254 = x__4912__auto__;
        return goog.typeOf(G__15254);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._sorted_seq_from["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_);
  }
};
cljs.core._entry_key = function cljs$core$_entry_key(coll, entry) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$ISorted$_entry_key$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._entry_key[function() {
        var G__15258 = x__4912__auto__;
        return goog.typeOf(G__15258);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._entry_key["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry);
  }
};
cljs.core._comparator = function cljs$core$_comparator(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$ISorted$_comparator$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._comparator[function() {
        var G__15262 = x__4912__auto__;
        return goog.typeOf(G__15262);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._comparator["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISorted.-comparator", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IWriter = function() {
  var obj15264 = {};
  return obj15264;
}();
cljs.core._write = function cljs$core$_write(writer, s) {
  if (function() {
    var and__4264__auto__ = writer;
    if (and__4264__auto__) {
      return writer.cljs$core$IWriter$_write$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return writer.cljs$core$IWriter$_write$arity$2(writer, s);
  } else {
    var x__4912__auto__ = writer == null ? null : writer;
    return function() {
      var or__4276__auto__ = cljs.core._write[function() {
        var G__15268 = x__4912__auto__;
        return goog.typeOf(G__15268);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._write["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWriter.-write", writer);
        }
      }
    }().call(null, writer, s);
  }
};
cljs.core._flush = function cljs$core$_flush(writer) {
  if (function() {
    var and__4264__auto__ = writer;
    if (and__4264__auto__) {
      return writer.cljs$core$IWriter$_flush$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return writer.cljs$core$IWriter$_flush$arity$1(writer);
  } else {
    var x__4912__auto__ = writer == null ? null : writer;
    return function() {
      var or__4276__auto__ = cljs.core._flush[function() {
        var G__15272 = x__4912__auto__;
        return goog.typeOf(G__15272);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._flush["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWriter.-flush", writer);
        }
      }
    }().call(null, writer);
  }
};
cljs.core.IPrintWithWriter = function() {
  var obj15274 = {};
  return obj15274;
}();
cljs.core._pr_writer = function cljs$core$_pr_writer(o, writer, opts) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o, writer, opts);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._pr_writer[function() {
        var G__15278 = x__4912__auto__;
        return goog.typeOf(G__15278);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._pr_writer["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer", o);
        }
      }
    }().call(null, o, writer, opts);
  }
};
cljs.core.IPending = function() {
  var obj15280 = {};
  return obj15280;
}();
cljs.core._realized_QMARK_ = function cljs$core$_realized_QMARK_(d) {
  if (function() {
    var and__4264__auto__ = d;
    if (and__4264__auto__) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
  } else {
    var x__4912__auto__ = d == null ? null : d;
    return function() {
      var or__4276__auto__ = cljs.core._realized_QMARK_[function() {
        var G__15284 = x__4912__auto__;
        return goog.typeOf(G__15284);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._realized_QMARK_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IPending.-realized?", d);
        }
      }
    }().call(null, d);
  }
};
cljs.core.IWatchable = function() {
  var obj15286 = {};
  return obj15286;
}();
cljs.core._notify_watches = function cljs$core$_notify_watches(this$, oldval, newval) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._notify_watches[function() {
        var G__15290 = x__4912__auto__;
        return goog.typeOf(G__15290);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._notify_watches["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval);
  }
};
cljs.core._add_watch = function cljs$core$_add_watch(this$, key, f) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._add_watch[function() {
        var G__15294 = x__4912__auto__;
        return goog.typeOf(G__15294);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._add_watch["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f);
  }
};
cljs.core._remove_watch = function cljs$core$_remove_watch(this$, key) {
  if (function() {
    var and__4264__auto__ = this$;
    if (and__4264__auto__) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key);
  } else {
    var x__4912__auto__ = this$ == null ? null : this$;
    return function() {
      var or__4276__auto__ = cljs.core._remove_watch[function() {
        var G__15298 = x__4912__auto__;
        return goog.typeOf(G__15298);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._remove_watch["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key);
  }
};
cljs.core.IEditableCollection = function() {
  var obj15300 = {};
  return obj15300;
}();
cljs.core._as_transient = function cljs$core$_as_transient(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._as_transient[function() {
        var G__15304 = x__4912__auto__;
        return goog.typeOf(G__15304);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._as_transient["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.ITransientCollection = function() {
  var obj15306 = {};
  return obj15306;
}();
cljs.core._conj_BANG_ = function cljs$core$_conj_BANG_(tcoll, val) {
  if (function() {
    var and__4264__auto__ = tcoll;
    if (and__4264__auto__) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val);
  } else {
    var x__4912__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4276__auto__ = cljs.core._conj_BANG_[function() {
        var G__15310 = x__4912__auto__;
        return goog.typeOf(G__15310);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._conj_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val);
  }
};
cljs.core._persistent_BANG_ = function cljs$core$_persistent_BANG_(tcoll) {
  if (function() {
    var and__4264__auto__ = tcoll;
    if (and__4264__auto__) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
  } else {
    var x__4912__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4276__auto__ = cljs.core._persistent_BANG_[function() {
        var G__15314 = x__4912__auto__;
        return goog.typeOf(G__15314);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._persistent_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll);
  }
};
cljs.core.ITransientAssociative = function() {
  var obj15316 = {};
  return obj15316;
}();
cljs.core._assoc_BANG_ = function cljs$core$_assoc_BANG_(tcoll, key, val) {
  if (function() {
    var and__4264__auto__ = tcoll;
    if (and__4264__auto__) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val);
  } else {
    var x__4912__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4276__auto__ = cljs.core._assoc_BANG_[function() {
        var G__15320 = x__4912__auto__;
        return goog.typeOf(G__15320);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._assoc_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val);
  }
};
cljs.core.ITransientMap = function() {
  var obj15322 = {};
  return obj15322;
}();
cljs.core._dissoc_BANG_ = function cljs$core$_dissoc_BANG_(tcoll, key) {
  if (function() {
    var and__4264__auto__ = tcoll;
    if (and__4264__auto__) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key);
  } else {
    var x__4912__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4276__auto__ = cljs.core._dissoc_BANG_[function() {
        var G__15326 = x__4912__auto__;
        return goog.typeOf(G__15326);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._dissoc_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key);
  }
};
cljs.core.ITransientVector = function() {
  var obj15328 = {};
  return obj15328;
}();
cljs.core._assoc_n_BANG_ = function cljs$core$_assoc_n_BANG_(tcoll, n, val) {
  if (function() {
    var and__4264__auto__ = tcoll;
    if (and__4264__auto__) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val);
  } else {
    var x__4912__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4276__auto__ = cljs.core._assoc_n_BANG_[function() {
        var G__15332 = x__4912__auto__;
        return goog.typeOf(G__15332);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._assoc_n_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val);
  }
};
cljs.core._pop_BANG_ = function cljs$core$_pop_BANG_(tcoll) {
  if (function() {
    var and__4264__auto__ = tcoll;
    if (and__4264__auto__) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
  } else {
    var x__4912__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4276__auto__ = cljs.core._pop_BANG_[function() {
        var G__15336 = x__4912__auto__;
        return goog.typeOf(G__15336);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._pop_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll);
  }
};
cljs.core.ITransientSet = function() {
  var obj15338 = {};
  return obj15338;
}();
cljs.core._disjoin_BANG_ = function cljs$core$_disjoin_BANG_(tcoll, v) {
  if (function() {
    var and__4264__auto__ = tcoll;
    if (and__4264__auto__) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v);
  } else {
    var x__4912__auto__ = tcoll == null ? null : tcoll;
    return function() {
      var or__4276__auto__ = cljs.core._disjoin_BANG_[function() {
        var G__15342 = x__4912__auto__;
        return goog.typeOf(G__15342);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._disjoin_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v);
  }
};
cljs.core.IComparable = function() {
  var obj15344 = {};
  return obj15344;
}();
cljs.core._compare = function cljs$core$_compare(x, y) {
  if (function() {
    var and__4264__auto__ = x;
    if (and__4264__auto__) {
      return x.cljs$core$IComparable$_compare$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y);
  } else {
    var x__4912__auto__ = x == null ? null : x;
    return function() {
      var or__4276__auto__ = cljs.core._compare[function() {
        var G__15348 = x__4912__auto__;
        return goog.typeOf(G__15348);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._compare["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IComparable.-compare", x);
        }
      }
    }().call(null, x, y);
  }
};
cljs.core.IChunk = function() {
  var obj15350 = {};
  return obj15350;
}();
cljs.core._drop_first = function cljs$core$_drop_first(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IChunk$_drop_first$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._drop_first[function() {
        var G__15354 = x__4912__auto__;
        return goog.typeOf(G__15354);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._drop_first["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunk.-drop-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IChunkedSeq = function() {
  var obj15356 = {};
  return obj15356;
}();
cljs.core._chunked_first = function cljs$core$_chunked_first(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._chunked_first[function() {
        var G__15360 = x__4912__auto__;
        return goog.typeOf(G__15360);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._chunked_first["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core._chunked_rest = function cljs$core$_chunked_rest(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._chunked_rest[function() {
        var G__15364 = x__4912__auto__;
        return goog.typeOf(G__15364);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._chunked_rest["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.IChunkedNext = function() {
  var obj15366 = {};
  return obj15366;
}();
cljs.core._chunked_next = function cljs$core$_chunked_next(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._chunked_next[function() {
        var G__15370 = x__4912__auto__;
        return goog.typeOf(G__15370);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._chunked_next["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IChunkedNext.-chunked-next", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.INamed = function() {
  var obj15372 = {};
  return obj15372;
}();
cljs.core._name = function cljs$core$_name(x) {
  if (function() {
    var and__4264__auto__ = x;
    if (and__4264__auto__) {
      return x.cljs$core$INamed$_name$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return x.cljs$core$INamed$_name$arity$1(x);
  } else {
    var x__4912__auto__ = x == null ? null : x;
    return function() {
      var or__4276__auto__ = cljs.core._name[function() {
        var G__15376 = x__4912__auto__;
        return goog.typeOf(G__15376);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._name["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INamed.-name", x);
        }
      }
    }().call(null, x);
  }
};
cljs.core._namespace = function cljs$core$_namespace(x) {
  if (function() {
    var and__4264__auto__ = x;
    if (and__4264__auto__) {
      return x.cljs$core$INamed$_namespace$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return x.cljs$core$INamed$_namespace$arity$1(x);
  } else {
    var x__4912__auto__ = x == null ? null : x;
    return function() {
      var or__4276__auto__ = cljs.core._namespace[function() {
        var G__15380 = x__4912__auto__;
        return goog.typeOf(G__15380);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._namespace["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("INamed.-namespace", x);
        }
      }
    }().call(null, x);
  }
};
cljs.core.IAtom = function() {
  var obj15382 = {};
  return obj15382;
}();
cljs.core.IReset = function() {
  var obj15384 = {};
  return obj15384;
}();
cljs.core._reset_BANG_ = function cljs$core$_reset_BANG_(o, new_value) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$IReset$_reset_BANG_$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$IReset$_reset_BANG_$arity$2(o, new_value);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._reset_BANG_[function() {
        var G__15388 = x__4912__auto__;
        return goog.typeOf(G__15388);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._reset_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IReset.-reset!", o);
        }
      }
    }().call(null, o, new_value);
  }
};
cljs.core.ISwap = function() {
  var obj15390 = {};
  return obj15390;
}();
cljs.core._swap_BANG_ = function cljs$core$_swap_BANG_() {
  var G__15392 = arguments.length;
  switch(G__15392) {
    case 2:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(o, f) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$2(o, f);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._swap_BANG_[function() {
        var G__15394 = x__4912__auto__;
        return goog.typeOf(G__15394);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(o, f, a) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$3;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$3(o, f, a);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._swap_BANG_[function() {
        var G__15396 = x__4912__auto__;
        return goog.typeOf(G__15396);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(o, f, a, b) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$4;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$4(o, f, a, b);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._swap_BANG_[function() {
        var G__15398 = x__4912__auto__;
        return goog.typeOf(G__15398);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a, b);
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = function(o, f, a, b, xs) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$ISwap$_swap_BANG_$arity$5;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$5(o, f, a, b, xs);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._swap_BANG_[function() {
        var G__15400 = x__4912__auto__;
        return goog.typeOf(G__15400);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._swap_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("ISwap.-swap!", o);
        }
      }
    }().call(null, o, f, a, b, xs);
  }
};
cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;
cljs.core.IVolatile = function() {
  var obj15403 = {};
  return obj15403;
}();
cljs.core._vreset_BANG_ = function cljs$core$_vreset_BANG_(o, new_value) {
  if (function() {
    var and__4264__auto__ = o;
    if (and__4264__auto__) {
      return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o, new_value);
  } else {
    var x__4912__auto__ = o == null ? null : o;
    return function() {
      var or__4276__auto__ = cljs.core._vreset_BANG_[function() {
        var G__15407 = x__4912__auto__;
        return goog.typeOf(G__15407);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._vreset_BANG_["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IVolatile.-vreset!", o);
        }
      }
    }().call(null, o, new_value);
  }
};
cljs.core.IIterable = function() {
  var obj15409 = {};
  return obj15409;
}();
cljs.core._iterator = function cljs$core$_iterator(coll) {
  if (function() {
    var and__4264__auto__ = coll;
    if (and__4264__auto__) {
      return coll.cljs$core$IIterable$_iterator$arity$1;
    } else {
      return and__4264__auto__;
    }
  }()) {
    return coll.cljs$core$IIterable$_iterator$arity$1(coll);
  } else {
    var x__4912__auto__ = coll == null ? null : coll;
    return function() {
      var or__4276__auto__ = cljs.core._iterator[function() {
        var G__15413 = x__4912__auto__;
        return goog.typeOf(G__15413);
      }()];
      if (or__4276__auto__) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = cljs.core._iterator["_"];
        if (or__4276__auto____$1) {
          return or__4276__auto____$1;
        } else {
          throw cljs.core.missing_protocol("IIterable.-iterator", coll);
        }
      }
    }().call(null, coll);
  }
};
cljs.core.StringBufferWriter = function(sb) {
  this.sb = sb;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1073741824;
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = function(_, s) {
  var self__ = this;
  var ___$1 = this;
  return self__.sb.append(s);
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return null;
};
cljs.core.StringBufferWriter.cljs$lang$type = true;
cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";
cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/StringBufferWriter");
};
cljs.core.__GT_StringBufferWriter = function cljs$core$__GT_StringBufferWriter(sb) {
  return new cljs.core.StringBufferWriter(sb);
};
cljs.core.pr_str_STAR_ = function cljs$core$pr_str_STAR_(obj) {
  var sb = new goog.string.StringBuffer;
  var writer = new cljs.core.StringBufferWriter(sb);
  obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null, writer, cljs.core.pr_opts());
  writer.cljs$core$IWriter$_flush$arity$1(null);
  return[cljs.core.str(sb)].join("");
};
cljs.core.int_rotate_left = function cljs$core$int_rotate_left(x, n) {
  return x << n | x >>> -n;
};
if (typeof Math.imul !== "undefined" && !(function() {
  var G__15416 = 4294967295;
  var G__15417 = 5;
  return Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__15416, G__15417) : Math.imul.call(null, G__15416, G__15417);
}() === 0)) {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var G__15420 = a;
    var G__15421 = b;
    return Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__15420, G__15421) : Math.imul.call(null, G__15420, G__15421);
  };
} else {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var ah = a >>> 16 & 65535;
    var al = a & 65535;
    var bh = b >>> 16 & 65535;
    var bl = b & 65535;
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
  };
}
cljs.core.m3_seed = 0;
cljs.core.m3_C1 = 3432918353 | 0;
cljs.core.m3_C2 = 461845907 | 0;
cljs.core.m3_mix_K1 = function cljs$core$m3_mix_K1(k1) {
  return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1 | 0, cljs.core.m3_C1), 15), cljs.core.m3_C2);
};
cljs.core.m3_mix_H1 = function cljs$core$m3_mix_H1(h1, k1) {
  return cljs.core.imul(cljs.core.int_rotate_left((h1 | 0) ^ (k1 | 0), 13), 5) + (3864292196 | 0) | 0;
};
cljs.core.m3_fmix = function cljs$core$m3_fmix(h1, len) {
  var h1__$1 = h1 | 0;
  var h1__$2 = h1__$1 ^ len;
  var h1__$3 = h1__$2 ^ h1__$2 >>> 16;
  var h1__$4 = cljs.core.imul(h1__$3, 2246822507 | 0);
  var h1__$5 = h1__$4 ^ h1__$4 >>> 13;
  var h1__$6 = cljs.core.imul(h1__$5, 3266489909 | 0);
  var h1__$7 = h1__$6 ^ h1__$6 >>> 16;
  return h1__$7;
};
cljs.core.m3_hash_int = function cljs$core$m3_hash_int(in$) {
  if (in$ === 0) {
    return in$;
  } else {
    var k1 = cljs.core.m3_mix_K1(in$);
    var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed, k1);
    return cljs.core.m3_fmix(h1, 4);
  }
};
cljs.core.m3_hash_unencoded_chars = function cljs$core$m3_hash_unencoded_chars(in$) {
  var h1 = function() {
    var i = 1;
    var h1 = cljs.core.m3_seed;
    while (true) {
      if (i < in$.length) {
        var G__15422 = i + 2;
        var G__15423 = cljs.core.m3_mix_H1(h1, cljs.core.m3_mix_K1(in$.charCodeAt(i - 1) | in$.charCodeAt(i) << 16));
        i = G__15422;
        h1 = G__15423;
        continue;
      } else {
        return h1;
      }
      break;
    }
  }();
  var h1__$1 = (in$.length & 1) === 1 ? h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt(in$.length - 1)) : h1;
  return cljs.core.m3_fmix(h1__$1, cljs.core.imul(2, in$.length));
};
cljs.core.string_hash_cache = function() {
  var obj15425 = {};
  return obj15425;
}();
cljs.core.string_hash_cache_count = 0;
cljs.core.hash_string_STAR_ = function cljs$core$hash_string_STAR_(s) {
  if (!(s == null)) {
    var len = s.length;
    if (len > 0) {
      var i = 0;
      var hash = 0;
      while (true) {
        if (i < len) {
          var G__15426 = i + 1;
          var G__15427 = cljs.core.imul(31, hash) + s.charCodeAt(i);
          i = G__15426;
          hash = G__15427;
          continue;
        } else {
          return hash;
        }
        break;
      }
    } else {
      return 0;
    }
  } else {
    return 0;
  }
};
cljs.core.add_to_string_hash_cache = function cljs$core$add_to_string_hash_cache(k) {
  var h = cljs.core.hash_string_STAR_(k);
  cljs.core.string_hash_cache[k] = h;
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h;
};
cljs.core.hash_string = function cljs$core$hash_string(k) {
  if (cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = function() {
      var obj15431 = {};
      return obj15431;
    }();
    cljs.core.string_hash_cache_count = 0;
  } else {
  }
  var h = cljs.core.string_hash_cache[k];
  if (typeof h === "number") {
    return h;
  } else {
    return cljs.core.add_to_string_hash_cache(k);
  }
};
cljs.core.hash = function cljs$core$hash(o) {
  if (function() {
    var G__15434 = o;
    if (G__15434) {
      var bit__4943__auto__ = G__15434.cljs$lang$protocol_mask$partition0$ & 4194304;
      if (bit__4943__auto__ || G__15434.cljs$core$IHash$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(null);
  } else {
    if (typeof o === "number") {
      return function() {
        var G__15435 = o;
        return Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__15435) : Math.floor.call(null, G__15435);
      }() % 2147483647;
    } else {
      if (o === true) {
        return 1;
      } else {
        if (o === false) {
          return 0;
        } else {
          if (typeof o === "string") {
            return cljs.core.m3_hash_int(cljs.core.hash_string(o));
          } else {
            if (o instanceof Date) {
              return o.valueOf();
            } else {
              if (o == null) {
                return 0;
              } else {
                return cljs.core._hash(o);
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.hash_combine = function cljs$core$hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2);
};
cljs.core.instance_QMARK_ = function cljs$core$instance_QMARK_(t, o) {
  return o instanceof t;
};
cljs.core.symbol_QMARK_ = function cljs$core$symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol;
};
cljs.core.hash_symbol = function cljs$core$hash_symbol(sym) {
  return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name), cljs.core.hash_string(sym.ns));
};
cljs.core.compare_symbols = function cljs$core$compare_symbols(a, b) {
  if (a.str === b.str) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__4264__auto__ = cljs.core.not(a.ns);
      if (and__4264__auto__) {
        return b.ns;
      } else {
        return and__4264__auto__;
      }
    }())) {
      return-1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__15442 = a.ns;
            var G__15443 = b.ns;
            return goog.array.defaultCompare(G__15442, G__15443);
          }();
          if (0 === nsc) {
            var G__15444 = a.name;
            var G__15445 = b.name;
            return goog.array.defaultCompare(G__15444, G__15445);
          } else {
            return nsc;
          }
        }
      } else {
        var G__15446 = a.name;
        var G__15447 = b.name;
        return goog.array.defaultCompare(G__15446, G__15447);
      }
    }
  }
};
cljs.core.Symbol = function(ns, name, str, _hash, _meta) {
  this.ns = ns;
  this.name = name;
  this.str = str;
  this._hash = _hash;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 2154168321;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, self__.str);
};
cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = function(sym) {
  var self__ = this;
  var sym__$1 = this;
  var h__4692__auto__ = self__._hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_symbol(sym__$1);
    self__._hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Symbol(self__.ns, self__.name, self__.str, self__._hash, new_meta);
};
cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Symbol.prototype.call = function() {
  var G__15449 = null;
  var G__15449__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, null);
  };
  var G__15449__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found);
  };
  G__15449 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__15449__2.call(this, self__, coll);
      case 3:
        return G__15449__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__15449.cljs$core$IFn$_invoke$arity$2 = G__15449__2;
  G__15449.cljs$core$IFn$_invoke$arity$3 = G__15449__3;
  return G__15449;
}();
cljs.core.Symbol.prototype.apply = function(self__, args15448) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args15448)));
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var sym = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, null);
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var sym = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found);
};
cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Symbol) {
    return self__.str === other.str;
  } else {
    return false;
  }
};
cljs.core.Symbol.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return self__.str;
};
cljs.core.Symbol.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Symbol.cljs$lang$type = true;
cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";
cljs.core.Symbol.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/Symbol");
};
cljs.core.__GT_Symbol = function cljs$core$__GT_Symbol(ns, name, str, _hash, _meta) {
  return new cljs.core.Symbol(ns, name, str, _hash, _meta);
};
cljs.core.symbol = function cljs$core$symbol() {
  var G__15451 = arguments.length;
  switch(G__15451) {
    case 1:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Symbol) {
    return name;
  } else {
    return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null, name);
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var sym_str = !(ns == null) ? [cljs.core.str(ns), cljs.core.str("/"), cljs.core.str(name)].join("") : name;
  return new cljs.core.Symbol(ns, name, sym_str, null, null);
};
cljs.core.symbol.cljs$lang$maxFixedArity = 2;
cljs.core.Var = function(val, sym, _meta) {
  this.val = val;
  this.sym = sym;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 163841;
};
cljs.core.Var.prototype.call = function() {
  var G__15498 = null;
  var G__15498__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null);
  };
  var G__15498__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a);
  };
  var G__15498__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b);
  };
  var G__15498__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c);
  };
  var G__15498__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d);
  };
  var G__15498__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e);
  };
  var G__15498__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f);
  };
  var G__15498__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g);
  };
  var G__15498__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h);
  };
  var G__15498__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__15498__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__15498__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__15498__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__15498__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__15498__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__15498__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__15498__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__15498__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__15498__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__15498__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__15498__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__15498__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15454 = function() {
      return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    }();
    var G__15455 = a;
    var G__15456 = b;
    var G__15457 = c;
    var G__15458 = d;
    var G__15459 = e;
    var G__15460 = f;
    var G__15461 = g;
    var G__15462 = h;
    var G__15463 = i;
    var G__15464 = j;
    var G__15465 = k;
    var G__15466 = l;
    var G__15467 = m;
    var G__15468 = n;
    var G__15469 = o;
    var G__15470 = p;
    var G__15471 = q;
    var G__15472 = r;
    var G__15473 = s;
    var G__15474 = t;
    var G__15475 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__15454, G__15455, G__15456, G__15457, G__15458, G__15459, G__15460, G__15461, G__15462, G__15463, G__15464, G__15465, G__15466, G__15467, G__15468, G__15469, G__15470, G__15471, G__15472, G__15473, G__15474, G__15475) : cljs.core.apply.call(null, G__15454, G__15455, G__15456, G__15457, G__15458, G__15459, G__15460, G__15461, G__15462, G__15463, G__15464, G__15465, G__15466, G__15467, G__15468, 
    G__15469, G__15470, G__15471, G__15472, G__15473, G__15474, G__15475);
  };
  G__15498 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__15498__1.call(this, self__);
      case 2:
        return G__15498__2.call(this, self__, a);
      case 3:
        return G__15498__3.call(this, self__, a, b);
      case 4:
        return G__15498__4.call(this, self__, a, b, c);
      case 5:
        return G__15498__5.call(this, self__, a, b, c, d);
      case 6:
        return G__15498__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__15498__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__15498__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__15498__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__15498__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__15498__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__15498__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__15498__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__15498__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__15498__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__15498__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__15498__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__15498__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__15498__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__15498__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__15498__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__15498__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__15498.cljs$core$IFn$_invoke$arity$1 = G__15498__1;
  G__15498.cljs$core$IFn$_invoke$arity$2 = G__15498__2;
  G__15498.cljs$core$IFn$_invoke$arity$3 = G__15498__3;
  G__15498.cljs$core$IFn$_invoke$arity$4 = G__15498__4;
  G__15498.cljs$core$IFn$_invoke$arity$5 = G__15498__5;
  G__15498.cljs$core$IFn$_invoke$arity$6 = G__15498__6;
  G__15498.cljs$core$IFn$_invoke$arity$7 = G__15498__7;
  G__15498.cljs$core$IFn$_invoke$arity$8 = G__15498__8;
  G__15498.cljs$core$IFn$_invoke$arity$9 = G__15498__9;
  G__15498.cljs$core$IFn$_invoke$arity$10 = G__15498__10;
  G__15498.cljs$core$IFn$_invoke$arity$11 = G__15498__11;
  G__15498.cljs$core$IFn$_invoke$arity$12 = G__15498__12;
  G__15498.cljs$core$IFn$_invoke$arity$13 = G__15498__13;
  G__15498.cljs$core$IFn$_invoke$arity$14 = G__15498__14;
  G__15498.cljs$core$IFn$_invoke$arity$15 = G__15498__15;
  G__15498.cljs$core$IFn$_invoke$arity$16 = G__15498__16;
  G__15498.cljs$core$IFn$_invoke$arity$17 = G__15498__17;
  G__15498.cljs$core$IFn$_invoke$arity$18 = G__15498__18;
  G__15498.cljs$core$IFn$_invoke$arity$19 = G__15498__19;
  G__15498.cljs$core$IFn$_invoke$arity$20 = G__15498__20;
  G__15498.cljs$core$IFn$_invoke$arity$21 = G__15498__21;
  G__15498.cljs$core$IFn$_invoke$arity$22 = G__15498__22;
  return G__15498;
}();
cljs.core.Var.prototype.apply = function(self__, args15453) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args15453)));
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }().call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__15476 = function() {
    return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  }();
  var G__15477 = a;
  var G__15478 = b;
  var G__15479 = c;
  var G__15480 = d;
  var G__15481 = e;
  var G__15482 = f;
  var G__15483 = g;
  var G__15484 = h;
  var G__15485 = i;
  var G__15486 = j;
  var G__15487 = k;
  var G__15488 = l;
  var G__15489 = m;
  var G__15490 = n;
  var G__15491 = o;
  var G__15492 = p;
  var G__15493 = q;
  var G__15494 = r;
  var G__15495 = s;
  var G__15496 = t;
  var G__15497 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__15476, G__15477, G__15478, G__15479, G__15480, G__15481, G__15482, G__15483, G__15484, G__15485, G__15486, G__15487, G__15488, G__15489, G__15490, G__15491, G__15492, G__15493, G__15494, G__15495, G__15496, G__15497) : cljs.core.apply.call(null, G__15476, G__15477, G__15478, G__15479, G__15480, G__15481, G__15482, G__15483, G__15484, G__15485, G__15486, G__15487, G__15488, G__15489, G__15490, 
  G__15491, G__15492, G__15493, G__15494, G__15495, G__15496, G__15497);
};
cljs.core.Var.prototype.cljs$core$Fn$ = true;
cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
};
cljs.core.Var.cljs$lang$type = true;
cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";
cljs.core.Var.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/Var");
};
cljs.core.__GT_Var = function cljs$core$__GT_Var(val, sym, _meta) {
  return new cljs.core.Var(val, sym, _meta);
};
cljs.core.iterable_QMARK_ = function cljs$core$iterable_QMARK_(x) {
  var G__15500 = x;
  if (G__15500) {
    var bit__4950__auto__ = null;
    if (cljs.core.truth_(function() {
      var or__4276__auto__ = bit__4950__auto__;
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        return G__15500.cljs$core$IIterable$;
      }
    }())) {
      return true;
    } else {
      if (!G__15500.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, G__15500);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, G__15500);
  }
};
cljs.core.clone = function cljs$core$clone(value) {
  return cljs.core._clone(value);
};
cljs.core.cloneable_QMARK_ = function cljs$core$cloneable_QMARK_(value) {
  var G__15502 = value;
  if (G__15502) {
    var bit__4950__auto__ = G__15502.cljs$lang$protocol_mask$partition1$ & 8192;
    if (bit__4950__auto__ || G__15502.cljs$core$ICloneable$) {
      return true;
    } else {
      if (!G__15502.cljs$lang$protocol_mask$partition1$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, G__15502);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, G__15502);
  }
};
cljs.core.seq = function cljs$core$seq(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__15504 = coll;
      if (G__15504) {
        var bit__4943__auto__ = G__15504.cljs$lang$protocol_mask$partition0$ & 8388608;
        if (bit__4943__auto__ || G__15504.cljs$core$ISeqable$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeqable$_seq$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        if (coll.length === 0) {
          return null;
        } else {
          return new cljs.core.IndexedSeq(coll, 0);
        }
      } else {
        if (typeof coll === "string") {
          if (coll.length === 0) {
            return null;
          } else {
            return new cljs.core.IndexedSeq(coll, 0);
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, coll)) {
            return cljs.core._seq(coll);
          } else {
            throw new Error([cljs.core.str(coll), cljs.core.str(" is not ISeqable")].join(""));
          }
        }
      }
    }
  }
};
cljs.core.first = function cljs$core$first(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__15506 = coll;
      if (G__15506) {
        var bit__4943__auto__ = G__15506.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4943__auto__ || G__15506.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeq$_first$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s == null) {
        return null;
      } else {
        return cljs.core._first(s);
      }
    }
  }
};
cljs.core.rest = function cljs$core$rest(coll) {
  if (!(coll == null)) {
    if (function() {
      var G__15508 = coll;
      if (G__15508) {
        var bit__4943__auto__ = G__15508.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4943__auto__ || G__15508.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ISeq$_rest$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s) {
        return cljs.core._rest(s);
      } else {
        return cljs.core.List.EMPTY;
      }
    }
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.next = function cljs$core$next(coll) {
  if (coll == null) {
    return null;
  } else {
    if (function() {
      var G__15510 = coll;
      if (G__15510) {
        var bit__4943__auto__ = G__15510.cljs$lang$protocol_mask$partition0$ & 128;
        if (bit__4943__auto__ || G__15510.cljs$core$INext$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$INext$_next$arity$1(null);
    } else {
      return cljs.core.seq(cljs.core.rest(coll));
    }
  }
};
cljs.core._EQ_ = function cljs$core$_EQ_() {
  var G__15515 = arguments.length;
  switch(G__15515) {
    case 1:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  if (x == null) {
    return y == null;
  } else {
    return x === y || cljs.core._equiv(x, y);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
      if (cljs.core.next(more)) {
        var G__15517 = y;
        var G__15518 = cljs.core.first(more);
        var G__15519 = cljs.core.next(more);
        x = G__15517;
        y = G__15518;
        more = G__15519;
        continue;
      } else {
        return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y, cljs.core.first(more));
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ_.cljs$lang$applyTo = function(seq15511) {
  var G__15512 = cljs.core.first(seq15511);
  var seq15511__$1 = cljs.core.next(seq15511);
  var G__15513 = cljs.core.first(seq15511__$1);
  var seq15511__$2 = cljs.core.next(seq15511__$1);
  return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__15512, G__15513, seq15511__$2);
};
cljs.core._EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.ES6Iterator = function(s) {
  this.s = s;
};
cljs.core.ES6Iterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return{"done":false, "value":x};
  } else {
    return{"done":true, "value":null};
  }
};
cljs.core.ES6Iterator.cljs$lang$type = true;
cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";
cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ES6Iterator");
};
cljs.core.__GT_ES6Iterator = function cljs$core$__GT_ES6Iterator(s) {
  return new cljs.core.ES6Iterator(s);
};
cljs.core.es6_iterator = function cljs$core$es6_iterator(coll) {
  return new cljs.core.ES6Iterator(cljs.core.seq(coll));
};
cljs.core.ES6IteratorSeq = function(value, iter, _rest) {
  this.value = value;
  this.iter = iter;
  this._rest = _rest;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 8388672;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.value;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__._rest == null) {
    self__._rest = function() {
      var G__15520 = self__.iter;
      return cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__15520) : cljs.core.es6_iterator_seq.call(null, G__15520);
    }();
  } else {
  }
  return self__._rest;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ES6IteratorSeq.cljs$lang$type = true;
cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";
cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ES6IteratorSeq");
};
cljs.core.__GT_ES6IteratorSeq = function cljs$core$__GT_ES6IteratorSeq(value, iter, _rest) {
  return new cljs.core.ES6IteratorSeq(value, iter, _rest);
};
cljs.core.es6_iterator_seq = function cljs$core$es6_iterator_seq(iter) {
  var v = iter.next();
  if (cljs.core.truth_(v.done)) {
    return cljs.core.List.EMPTY;
  } else {
    return new cljs.core.ES6IteratorSeq(v.value, iter, null);
  }
};
cljs.core.mix_collection_hash = function cljs$core$mix_collection_hash(hash_basis, count) {
  var h1 = cljs.core.m3_seed;
  var k1 = cljs.core.m3_mix_K1(hash_basis);
  var h1__$1 = cljs.core.m3_mix_H1(h1, k1);
  return cljs.core.m3_fmix(h1__$1, count);
};
cljs.core.hash_ordered_coll = function cljs$core$hash_ordered_coll(coll) {
  var n = 0;
  var hash_code = 1;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__15521 = n + 1;
      var G__15522 = cljs.core.imul(31, hash_code) + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__15523 = cljs.core.next(coll__$1);
      n = G__15521;
      hash_code = G__15522;
      coll__$1 = G__15523;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash(1, 0);
cljs.core.hash_unordered_coll = function cljs$core$hash_unordered_coll(coll) {
  var n = 0;
  var hash_code = 0;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__15524 = n + 1;
      var G__15525 = hash_code + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__15526 = cljs.core.next(coll__$1);
      n = G__15524;
      hash_code = G__15525;
      coll__$1 = G__15526;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash(0, 0);
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0;
};
Date.prototype.cljs$core$IComparable$ = true;
Date.prototype.cljs$core$IComparable$_compare$arity$2 = function(this$, other) {
  var this$__$1 = this;
  var G__15527 = this$__$1.valueOf();
  var G__15528 = other.valueOf();
  return goog.array.defaultCompare(G__15527, G__15528);
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var o__$1 = this;
  return other instanceof Date && o__$1.valueOf() === other.valueOf();
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o;
};
cljs.core.IMeta["function"] = true;
cljs.core._meta["function"] = function(_) {
  return null;
};
cljs.core.Fn["function"] = true;
cljs.core.IHash["_"] = true;
cljs.core._hash["_"] = function(o) {
  var G__15529 = o;
  return goog.getUid(G__15529);
};
cljs.core.inc = function cljs$core$inc(x) {
  return x + 1;
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var self__ = this;
  var o__$1 = this;
  return self__.val;
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";
cljs.core.Reduced.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/Reduced");
};
cljs.core.__GT_Reduced = function cljs$core$__GT_Reduced(val) {
  return new cljs.core.Reduced(val);
};
cljs.core.reduced = function cljs$core$reduced(x) {
  return new cljs.core.Reduced(x);
};
cljs.core.reduced_QMARK_ = function cljs$core$reduced_QMARK_(r) {
  return r instanceof cljs.core.Reduced;
};
cljs.core.ensure_reduced = function cljs$core$ensure_reduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return x;
  } else {
    return cljs.core.reduced(x);
  }
};
cljs.core.unreduced = function cljs$core$unreduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    var G__15531 = x;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__15531) : cljs.core.deref.call(null, G__15531);
  } else {
    return x;
  }
};
cljs.core.deref = function cljs$core$deref(o) {
  return cljs.core._deref(o);
};
cljs.core.ci_reduce = function cljs$core$ci_reduce() {
  var G__15533 = arguments.length;
  switch(G__15533) {
    case 2:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = function(cicoll, f) {
  var cnt = cljs.core._count(cicoll);
  if (cnt === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, 0);
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__15534 = val;
          var G__15535 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15534, G__15535) : f.call(null, G__15534, G__15535);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__15541 = nval;
          var G__15542 = n + 1;
          val = G__15541;
          n = G__15542;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = function(cicoll, f, val) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__15536 = val__$1;
        var G__15537 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15536, G__15537) : f.call(null, G__15536, G__15537);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__15543 = nval;
        var G__15544 = n + 1;
        val__$1 = G__15543;
        n = G__15544;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = function(cicoll, f, val, idx) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__15538 = val__$1;
        var G__15539 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15538, G__15539) : f.call(null, G__15538, G__15539);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__15545 = nval;
        var G__15546 = n + 1;
        val__$1 = G__15545;
        n = G__15546;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = function cljs$core$array_reduce() {
  var G__15548 = arguments.length;
  switch(G__15548) {
    case 2:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = function(arr, f) {
  var cnt = arr.length;
  if (arr.length === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = arr[0];
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__15549 = val;
          var G__15550 = arr[n];
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15549, G__15550) : f.call(null, G__15549, G__15550);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__15556 = nval;
          var G__15557 = n + 1;
          val = G__15556;
          n = G__15557;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = function(arr, f, val) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__15551 = val__$1;
        var G__15552 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15551, G__15552) : f.call(null, G__15551, G__15552);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__15558 = nval;
        var G__15559 = n + 1;
        val__$1 = G__15558;
        n = G__15559;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = function(arr, f, val, idx) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__15553 = val__$1;
        var G__15554 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__15553, G__15554) : f.call(null, G__15553, G__15554);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__15560 = nval;
        var G__15561 = n + 1;
        val__$1 = G__15560;
        n = G__15561;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.counted_QMARK_ = function cljs$core$counted_QMARK_(x) {
  var G__15563 = x;
  if (G__15563) {
    var bit__4950__auto__ = G__15563.cljs$lang$protocol_mask$partition0$ & 2;
    if (bit__4950__auto__ || G__15563.cljs$core$ICounted$) {
      return true;
    } else {
      if (!G__15563.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, G__15563);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, G__15563);
  }
};
cljs.core.indexed_QMARK_ = function cljs$core$indexed_QMARK_(x) {
  var G__15565 = x;
  if (G__15565) {
    var bit__4950__auto__ = G__15565.cljs$lang$protocol_mask$partition0$ & 16;
    if (bit__4950__auto__ || G__15565.cljs$core$IIndexed$) {
      return true;
    } else {
      if (!G__15565.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, G__15565);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, G__15565);
  }
};
cljs.core.IndexedSeqIterator = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.IndexedSeqIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.IndexedSeqIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.IndexedSeqIterator.cljs$lang$type = true;
cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";
cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/IndexedSeqIterator");
};
cljs.core.__GT_IndexedSeqIterator = function cljs$core$__GT_IndexedSeqIterator(arr, i) {
  return new cljs.core.IndexedSeqIterator(arr, i);
};
cljs.core.IndexedSeq = function(arr, i) {
  this.arr = arr;
  this.i = i;
  this.cljs$lang$protocol_mask$partition0$ = 166199550;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.IndexedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return not_found;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeqIterator(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.arr.length - self__.i;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var c = cljs.core._count(coll__$1);
  if (c > 0) {
    return new cljs.core.RSeq(coll__$1, c - 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  var G__15566 = coll__$1;
  var G__15567 = other;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__15566, G__15567) : cljs.core.equiv_sequential.call(null, G__15566, G__15567);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.i], self__.i + 1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.arr[self__.i];
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__15568 = o;
  var G__15569 = coll__$1;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__15568, G__15569) : cljs.core.cons.call(null, G__15568, G__15569);
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";
cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/IndexedSeq");
};
cljs.core.__GT_IndexedSeq = function cljs$core$__GT_IndexedSeq(arr, i) {
  return new cljs.core.IndexedSeq(arr, i);
};
cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.prim_seq = function cljs$core$prim_seq() {
  var G__15571 = arguments.length;
  switch(G__15571) {
    case 1:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = function(prim) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim, 0);
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = function(prim, i) {
  if (i < prim.length) {
    return new cljs.core.IndexedSeq(prim, i);
  } else {
    return null;
  }
};
cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
cljs.core.array_seq = function cljs$core$array_seq() {
  var G__15574 = arguments.length;
  switch(G__15574) {
    case 1:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = function(array) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, 0);
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, i);
};
cljs.core.array_seq.cljs$lang$maxFixedArity = 2;
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.RSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.RSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, self__.meta);
};
cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return null;
  }
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.i + 1;
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  var G__15576 = coll__$1;
  var G__15577 = other;
  return cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__15576, G__15577) : cljs.core.equiv_sequential.call(null, G__15576, G__15577);
};
cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__15578 = cljs.core.List.EMPTY;
  var G__15579 = self__.meta;
  return cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__15578, G__15579) : cljs.core.with_meta.call(null, G__15578, G__15579);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(col, f) {
  var self__ = this;
  var col__$1 = this;
  var G__15580 = f;
  var G__15581 = col__$1;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__15580, G__15581) : cljs.core.seq_reduce.call(null, G__15580, G__15581);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(col, f, start) {
  var self__ = this;
  var col__$1 = this;
  var G__15582 = f;
  var G__15583 = start;
  var G__15584 = col__$1;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__15582, G__15583, G__15584) : cljs.core.seq_reduce.call(null, G__15582, G__15583, G__15584);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci, self__.i);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, new_meta);
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__15585 = o;
  var G__15586 = coll__$1;
  return cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__15585, G__15586) : cljs.core.cons.call(null, G__15585, G__15586);
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";
cljs.core.RSeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/RSeq");
};
cljs.core.__GT_RSeq = function cljs$core$__GT_RSeq(ci, i, meta) {
  return new cljs.core.RSeq(ci, i, meta);
};
cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.second = function cljs$core$second(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.ffirst = function cljs$core$ffirst(coll) {
  return cljs.core.first(cljs.core.first(coll));
};
cljs.core.nfirst = function cljs$core$nfirst(coll) {
  return cljs.core.next(cljs.core.first(coll));
};
cljs.core.fnext = function cljs$core$fnext(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.nnext = function cljs$core$nnext(coll) {
  return cljs.core.next(cljs.core.next(coll));
};
cljs.core.last = function cljs$core$last(s) {
  while (true) {
    var sn = cljs.core.next(s);
    if (!(sn == null)) {
      var G__15587 = sn;
      s = G__15587;
      continue;
    } else {
      return cljs.core.first(s);
    }
    break;
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o;
};
cljs.core.conj = function cljs$core$conj() {
  var G__15592 = arguments.length;
  switch(G__15592) {
    case 0:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  if (!(coll == null)) {
    return cljs.core._conj(coll, x);
  } else {
    return cljs.core._conj(cljs.core.List.EMPTY, x);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = function(coll, x, xs) {
  while (true) {
    if (cljs.core.truth_(xs)) {
      var G__15594 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
      var G__15595 = cljs.core.first(xs);
      var G__15596 = cljs.core.next(xs);
      coll = G__15594;
      x = G__15595;
      xs = G__15596;
      continue;
    } else {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
    }
    break;
  }
};
cljs.core.conj.cljs$lang$applyTo = function(seq15588) {
  var G__15589 = cljs.core.first(seq15588);
  var seq15588__$1 = cljs.core.next(seq15588);
  var G__15590 = cljs.core.first(seq15588__$1);
  var seq15588__$2 = cljs.core.next(seq15588__$1);
  return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__15589, G__15590, seq15588__$2);
};
cljs.core.conj.cljs$lang$maxFixedArity = 2;
cljs.core.empty = function cljs$core$empty(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._empty(coll);
  }
};
cljs.core.accumulating_seq_count = function cljs$core$accumulating_seq_count(coll) {
  var s = cljs.core.seq(coll);
  var acc = 0;
  while (true) {
    if (cljs.core.counted_QMARK_(s)) {
      return acc + cljs.core._count(s);
    } else {
      var G__15597 = cljs.core.next(s);
      var G__15598 = acc + 1;
      s = G__15597;
      acc = G__15598;
      continue;
    }
    break;
  }
};
cljs.core.count = function cljs$core$count(coll) {
  if (!(coll == null)) {
    if (function() {
      var G__15600 = coll;
      if (G__15600) {
        var bit__4943__auto__ = G__15600.cljs$lang$protocol_mask$partition0$ & 2;
        if (bit__4943__auto__ || G__15600.cljs$core$ICounted$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return coll.cljs$core$ICounted$_count$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return coll.length;
      } else {
        if (typeof coll === "string") {
          return coll.length;
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, coll)) {
            return cljs.core._count(coll);
          } else {
            return cljs.core.accumulating_seq_count(coll);
          }
        }
      }
    }
  } else {
    return 0;
  }
};
cljs.core.linear_traversal_nth = function cljs$core$linear_traversal_nth() {
  var G__15602 = arguments.length;
  switch(G__15602) {
    case 2:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  while (true) {
    if (coll == null) {
      throw new Error("Index out of bounds");
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          throw new Error("Index out of bounds");
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
        } else {
          if (cljs.core.seq(coll)) {
            var G__15604 = cljs.core.next(coll);
            var G__15605 = n - 1;
            coll = G__15604;
            n = G__15605;
            continue;
          } else {
            throw new Error("Index out of bounds");
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  while (true) {
    if (coll == null) {
      return not_found;
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          return not_found;
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
        } else {
          if (cljs.core.seq(coll)) {
            var G__15606 = cljs.core.next(coll);
            var G__15607 = n - 1;
            var G__15608 = not_found;
            coll = G__15606;
            n = G__15607;
            not_found = G__15608;
            continue;
          } else {
            return not_found;
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
cljs.core.nth = function cljs$core$nth() {
  var G__15610 = arguments.length;
  switch(G__15610) {
    case 2:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number");
  } else {
    if (coll == null) {
      return coll;
    } else {
      if (function() {
        var G__15611 = coll;
        if (G__15611) {
          var bit__4943__auto__ = G__15611.cljs$lang$protocol_mask$partition0$ & 16;
          if (bit__4943__auto__ || G__15611.cljs$core$IIndexed$) {
            return true;
          } else {
            return false;
          }
        } else {
          return false;
        }
      }()) {
        return coll.cljs$core$IIndexed$_nth$arity$2(null, n);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return null;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll[n];
            } else {
              return null;
            }
          } else {
            if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
              return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (function() {
                var G__15612 = coll;
                if (G__15612) {
                  var bit__4950__auto__ = G__15612.cljs$lang$protocol_mask$partition0$ & 64;
                  if (bit__4950__auto__ || G__15612.cljs$core$ISeq$) {
                    return true;
                  } else {
                    if (!G__15612.cljs$lang$protocol_mask$partition0$) {
                      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__15612);
                    } else {
                      return false;
                    }
                  }
                } else {
                  return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__15612);
                }
              }()) {
                return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(typeof n === "number")) {
    throw new Error("index argument to nth must be a number.");
  } else {
    if (coll == null) {
      return not_found;
    } else {
      if (function() {
        var G__15613 = coll;
        if (G__15613) {
          var bit__4943__auto__ = G__15613.cljs$lang$protocol_mask$partition0$ & 16;
          if (bit__4943__auto__ || G__15613.cljs$core$IIndexed$) {
            return true;
          } else {
            return false;
          }
        } else {
          return false;
        }
      }()) {
        return coll.cljs$core$IIndexed$_nth$arity$3(null, n, not_found);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n < coll.length) {
            return coll[n];
          } else {
            return not_found;
          }
        } else {
          if (typeof coll === "string") {
            if (n < coll.length) {
              return coll[n];
            } else {
              return not_found;
            }
          } else {
            if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
              return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (function() {
                var G__15614 = coll;
                if (G__15614) {
                  var bit__4950__auto__ = G__15614.cljs$lang$protocol_mask$partition0$ & 64;
                  if (bit__4950__auto__ || G__15614.cljs$core$ISeq$) {
                    return true;
                  } else {
                    if (!G__15614.cljs$lang$protocol_mask$partition0$) {
                      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__15614);
                    } else {
                      return false;
                    }
                  }
                } else {
                  return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__15614);
                }
              }()) {
                return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
              } else {
                throw new Error([cljs.core.str("nth not supported on this type "), cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$lang$maxFixedArity = 3;
cljs.core.nthrest = function cljs$core$nthrest(coll, n) {
  var n__$1 = n;
  var xs = coll;
  while (true) {
    if (n__$1 > 0 && cljs.core.seq(xs)) {
      var G__15616 = n__$1 - 1;
      var G__15617 = cljs.core.rest(xs);
      n__$1 = G__15616;
      xs = G__15617;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.get = function cljs$core$get() {
  var G__15619 = arguments.length;
  switch(G__15619) {
    case 2:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (o == null) {
    return null;
  } else {
    if (function() {
      var G__15620 = o;
      if (G__15620) {
        var bit__4943__auto__ = G__15620.cljs$lang$protocol_mask$partition0$ & 256;
        if (bit__4943__auto__ || G__15620.cljs$core$ILookup$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(null, k);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k];
        } else {
          return null;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k];
          } else {
            return null;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o, k);
          } else {
            return null;
          }
        }
      }
    }
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null)) {
    if (function() {
      var G__15621 = o;
      if (G__15621) {
        var bit__4943__auto__ = G__15621.cljs$lang$protocol_mask$partition0$ & 256;
        if (bit__4943__auto__ || G__15621.cljs$core$ILookup$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (k < o.length) {
          return o[k];
        } else {
          return not_found;
        }
      } else {
        if (typeof o === "string") {
          if (k < o.length) {
            return o[k];
          } else {
            return not_found;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o, k, not_found);
          } else {
            return not_found;
          }
        }
      }
    }
  } else {
    return not_found;
  }
};
cljs.core.get.cljs$lang$maxFixedArity = 3;
cljs.core.assoc = function cljs$core$assoc() {
  var G__15628 = arguments.length;
  switch(G__15628) {
    case 3:
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5328__auto__);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = function(coll, k, v) {
  if (!(coll == null)) {
    return cljs.core._assoc(coll, k, v);
  } else {
    return cljs.core.PersistentHashMap.fromArrays([k], [v]);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, v, kvs) {
  while (true) {
    var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll, k, v);
    if (cljs.core.truth_(kvs)) {
      var G__15630 = ret;
      var G__15631 = cljs.core.first(kvs);
      var G__15632 = cljs.core.second(kvs);
      var G__15633 = cljs.core.nnext(kvs);
      coll = G__15630;
      k = G__15631;
      v = G__15632;
      kvs = G__15633;
      continue;
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.assoc.cljs$lang$applyTo = function(seq15623) {
  var G__15624 = cljs.core.first(seq15623);
  var seq15623__$1 = cljs.core.next(seq15623);
  var G__15625 = cljs.core.first(seq15623__$1);
  var seq15623__$2 = cljs.core.next(seq15623__$1);
  var G__15626 = cljs.core.first(seq15623__$2);
  var seq15623__$3 = cljs.core.next(seq15623__$2);
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__15624, G__15625, G__15626, seq15623__$3);
};
cljs.core.assoc.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc = function cljs$core$dissoc() {
  var G__15638 = arguments.length;
  switch(G__15638) {
    case 1:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._dissoc(coll, k);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__15640 = ret;
        var G__15641 = cljs.core.first(ks);
        var G__15642 = cljs.core.next(ks);
        coll = G__15640;
        k = G__15641;
        ks = G__15642;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.dissoc.cljs$lang$applyTo = function(seq15634) {
  var G__15635 = cljs.core.first(seq15634);
  var seq15634__$1 = cljs.core.next(seq15634);
  var G__15636 = cljs.core.first(seq15634__$1);
  var seq15634__$2 = cljs.core.next(seq15634__$1);
  return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__15635, G__15636, seq15634__$2);
};
cljs.core.dissoc.cljs$lang$maxFixedArity = 2;
cljs.core.fn_QMARK_ = function cljs$core$fn_QMARK_(f) {
  var or__4276__auto__ = function() {
    var G__15647 = f;
    return goog.isFunction(G__15647);
  }();
  if (cljs.core.truth_(or__4276__auto__)) {
    return or__4276__auto__;
  } else {
    var G__15648 = f;
    if (G__15648) {
      var bit__4950__auto__ = null;
      if (cljs.core.truth_(function() {
        var or__4276__auto____$1 = bit__4950__auto__;
        if (cljs.core.truth_(or__4276__auto____$1)) {
          return or__4276__auto____$1;
        } else {
          return G__15648.cljs$core$Fn$;
        }
      }())) {
        return true;
      } else {
        if (!G__15648.cljs$lang$protocol_mask$partition$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, G__15648);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, G__15648);
    }
  }
};
cljs.core.MetaFn = function(afn, meta) {
  this.afn = afn;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 393217;
};
cljs.core.MetaFn.prototype.call = function() {
  var G__16114 = null;
  var G__16114__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
  };
  var G__16114__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15650 = a;
    return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__15650) : self__.afn.call(null, G__15650);
  };
  var G__16114__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15651 = a;
    var G__15652 = b;
    return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__15651, G__15652) : self__.afn.call(null, G__15651, G__15652);
  };
  var G__16114__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15653 = a;
    var G__15654 = b;
    var G__15655 = c;
    return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__15653, G__15654, G__15655) : self__.afn.call(null, G__15653, G__15654, G__15655);
  };
  var G__16114__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15656 = a;
    var G__15657 = b;
    var G__15658 = c;
    var G__15659 = d;
    return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__15656, G__15657, G__15658, G__15659) : self__.afn.call(null, G__15656, G__15657, G__15658, G__15659);
  };
  var G__16114__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15660 = a;
    var G__15661 = b;
    var G__15662 = c;
    var G__15663 = d;
    var G__15664 = e;
    return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__15660, G__15661, G__15662, G__15663, G__15664) : self__.afn.call(null, G__15660, G__15661, G__15662, G__15663, G__15664);
  };
  var G__16114__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15665 = a;
    var G__15666 = b;
    var G__15667 = c;
    var G__15668 = d;
    var G__15669 = e;
    var G__15670 = f;
    return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__15665, G__15666, G__15667, G__15668, G__15669, G__15670) : self__.afn.call(null, G__15665, G__15666, G__15667, G__15668, G__15669, G__15670);
  };
  var G__16114__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15671 = a;
    var G__15672 = b;
    var G__15673 = c;
    var G__15674 = d;
    var G__15675 = e;
    var G__15676 = f;
    var G__15677 = g;
    return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__15671, G__15672, G__15673, G__15674, G__15675, G__15676, G__15677) : self__.afn.call(null, G__15671, G__15672, G__15673, G__15674, G__15675, G__15676, G__15677);
  };
  var G__16114__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15678 = a;
    var G__15679 = b;
    var G__15680 = c;
    var G__15681 = d;
    var G__15682 = e;
    var G__15683 = f;
    var G__15684 = g;
    var G__15685 = h;
    return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__15678, G__15679, G__15680, G__15681, G__15682, G__15683, G__15684, G__15685) : self__.afn.call(null, G__15678, G__15679, G__15680, G__15681, G__15682, G__15683, G__15684, G__15685);
  };
  var G__16114__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15686 = a;
    var G__15687 = b;
    var G__15688 = c;
    var G__15689 = d;
    var G__15690 = e;
    var G__15691 = f;
    var G__15692 = g;
    var G__15693 = h;
    var G__15694 = i;
    return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__15686, G__15687, G__15688, G__15689, G__15690, G__15691, G__15692, G__15693, G__15694) : self__.afn.call(null, G__15686, G__15687, G__15688, G__15689, G__15690, G__15691, G__15692, G__15693, G__15694);
  };
  var G__16114__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15695 = a;
    var G__15696 = b;
    var G__15697 = c;
    var G__15698 = d;
    var G__15699 = e;
    var G__15700 = f;
    var G__15701 = g;
    var G__15702 = h;
    var G__15703 = i;
    var G__15704 = j;
    return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__15695, G__15696, G__15697, G__15698, G__15699, G__15700, G__15701, G__15702, G__15703, G__15704) : self__.afn.call(null, G__15695, G__15696, G__15697, G__15698, G__15699, G__15700, G__15701, G__15702, G__15703, G__15704);
  };
  var G__16114__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15705 = a;
    var G__15706 = b;
    var G__15707 = c;
    var G__15708 = d;
    var G__15709 = e;
    var G__15710 = f;
    var G__15711 = g;
    var G__15712 = h;
    var G__15713 = i;
    var G__15714 = j;
    var G__15715 = k;
    return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__15705, G__15706, G__15707, G__15708, G__15709, G__15710, G__15711, G__15712, G__15713, G__15714, G__15715) : self__.afn.call(null, G__15705, G__15706, G__15707, G__15708, G__15709, G__15710, G__15711, G__15712, G__15713, G__15714, G__15715);
  };
  var G__16114__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15716 = a;
    var G__15717 = b;
    var G__15718 = c;
    var G__15719 = d;
    var G__15720 = e;
    var G__15721 = f;
    var G__15722 = g;
    var G__15723 = h;
    var G__15724 = i;
    var G__15725 = j;
    var G__15726 = k;
    var G__15727 = l;
    return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__15716, G__15717, G__15718, G__15719, G__15720, G__15721, G__15722, G__15723, G__15724, G__15725, G__15726, G__15727) : self__.afn.call(null, G__15716, G__15717, G__15718, G__15719, G__15720, G__15721, G__15722, G__15723, G__15724, G__15725, G__15726, G__15727);
  };
  var G__16114__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15728 = a;
    var G__15729 = b;
    var G__15730 = c;
    var G__15731 = d;
    var G__15732 = e;
    var G__15733 = f;
    var G__15734 = g;
    var G__15735 = h;
    var G__15736 = i;
    var G__15737 = j;
    var G__15738 = k;
    var G__15739 = l;
    var G__15740 = m;
    return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__15728, G__15729, G__15730, G__15731, G__15732, G__15733, G__15734, G__15735, G__15736, G__15737, G__15738, G__15739, G__15740) : self__.afn.call(null, G__15728, G__15729, G__15730, G__15731, G__15732, G__15733, G__15734, G__15735, G__15736, G__15737, G__15738, G__15739, G__15740);
  };
  var G__16114__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15741 = a;
    var G__15742 = b;
    var G__15743 = c;
    var G__15744 = d;
    var G__15745 = e;
    var G__15746 = f;
    var G__15747 = g;
    var G__15748 = h;
    var G__15749 = i;
    var G__15750 = j;
    var G__15751 = k;
    var G__15752 = l;
    var G__15753 = m;
    var G__15754 = n;
    return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__15741, G__15742, G__15743, G__15744, G__15745, G__15746, G__15747, G__15748, G__15749, G__15750, G__15751, G__15752, G__15753, G__15754) : self__.afn.call(null, G__15741, G__15742, G__15743, G__15744, G__15745, G__15746, G__15747, G__15748, G__15749, G__15750, G__15751, G__15752, G__15753, G__15754);
  };
  var G__16114__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15755 = a;
    var G__15756 = b;
    var G__15757 = c;
    var G__15758 = d;
    var G__15759 = e;
    var G__15760 = f;
    var G__15761 = g;
    var G__15762 = h;
    var G__15763 = i;
    var G__15764 = j;
    var G__15765 = k;
    var G__15766 = l;
    var G__15767 = m;
    var G__15768 = n;
    var G__15769 = o;
    return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__15755, G__15756, G__15757, G__15758, G__15759, G__15760, G__15761, G__15762, G__15763, G__15764, G__15765, G__15766, G__15767, G__15768, G__15769) : self__.afn.call(null, G__15755, G__15756, G__15757, G__15758, G__15759, G__15760, G__15761, G__15762, G__15763, G__15764, G__15765, G__15766, G__15767, G__15768, G__15769);
  };
  var G__16114__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15770 = a;
    var G__15771 = b;
    var G__15772 = c;
    var G__15773 = d;
    var G__15774 = e;
    var G__15775 = f;
    var G__15776 = g;
    var G__15777 = h;
    var G__15778 = i;
    var G__15779 = j;
    var G__15780 = k;
    var G__15781 = l;
    var G__15782 = m;
    var G__15783 = n;
    var G__15784 = o;
    var G__15785 = p;
    return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__15770, G__15771, G__15772, G__15773, G__15774, G__15775, G__15776, G__15777, G__15778, G__15779, G__15780, G__15781, G__15782, G__15783, G__15784, G__15785) : self__.afn.call(null, G__15770, G__15771, G__15772, G__15773, G__15774, G__15775, G__15776, G__15777, G__15778, G__15779, G__15780, G__15781, G__15782, G__15783, G__15784, G__15785);
  };
  var G__16114__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15786 = a;
    var G__15787 = b;
    var G__15788 = c;
    var G__15789 = d;
    var G__15790 = e;
    var G__15791 = f;
    var G__15792 = g;
    var G__15793 = h;
    var G__15794 = i;
    var G__15795 = j;
    var G__15796 = k;
    var G__15797 = l;
    var G__15798 = m;
    var G__15799 = n;
    var G__15800 = o;
    var G__15801 = p;
    var G__15802 = q;
    return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__15786, G__15787, G__15788, G__15789, G__15790, G__15791, G__15792, G__15793, G__15794, G__15795, G__15796, G__15797, G__15798, G__15799, G__15800, G__15801, G__15802) : self__.afn.call(null, G__15786, G__15787, G__15788, G__15789, G__15790, G__15791, G__15792, G__15793, G__15794, G__15795, G__15796, G__15797, G__15798, G__15799, G__15800, G__15801, G__15802);
  };
  var G__16114__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15803 = a;
    var G__15804 = b;
    var G__15805 = c;
    var G__15806 = d;
    var G__15807 = e;
    var G__15808 = f;
    var G__15809 = g;
    var G__15810 = h;
    var G__15811 = i;
    var G__15812 = j;
    var G__15813 = k;
    var G__15814 = l;
    var G__15815 = m;
    var G__15816 = n;
    var G__15817 = o;
    var G__15818 = p;
    var G__15819 = q;
    var G__15820 = r;
    return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__15803, G__15804, G__15805, G__15806, G__15807, G__15808, G__15809, G__15810, G__15811, G__15812, G__15813, G__15814, G__15815, G__15816, G__15817, G__15818, G__15819, G__15820) : self__.afn.call(null, G__15803, G__15804, G__15805, G__15806, G__15807, G__15808, G__15809, G__15810, G__15811, G__15812, G__15813, G__15814, G__15815, G__15816, G__15817, G__15818, G__15819, G__15820);
  };
  var G__16114__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15821 = a;
    var G__15822 = b;
    var G__15823 = c;
    var G__15824 = d;
    var G__15825 = e;
    var G__15826 = f;
    var G__15827 = g;
    var G__15828 = h;
    var G__15829 = i;
    var G__15830 = j;
    var G__15831 = k;
    var G__15832 = l;
    var G__15833 = m;
    var G__15834 = n;
    var G__15835 = o;
    var G__15836 = p;
    var G__15837 = q;
    var G__15838 = r;
    var G__15839 = s;
    return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__15821, G__15822, G__15823, G__15824, G__15825, G__15826, G__15827, G__15828, G__15829, G__15830, G__15831, G__15832, G__15833, G__15834, G__15835, G__15836, G__15837, G__15838, G__15839) : self__.afn.call(null, G__15821, G__15822, G__15823, G__15824, G__15825, G__15826, G__15827, G__15828, G__15829, G__15830, G__15831, G__15832, G__15833, G__15834, G__15835, G__15836, G__15837, G__15838, G__15839);
  };
  var G__16114__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15840 = a;
    var G__15841 = b;
    var G__15842 = c;
    var G__15843 = d;
    var G__15844 = e;
    var G__15845 = f;
    var G__15846 = g;
    var G__15847 = h;
    var G__15848 = i;
    var G__15849 = j;
    var G__15850 = k;
    var G__15851 = l;
    var G__15852 = m;
    var G__15853 = n;
    var G__15854 = o;
    var G__15855 = p;
    var G__15856 = q;
    var G__15857 = r;
    var G__15858 = s;
    var G__15859 = t;
    return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__15840, G__15841, G__15842, G__15843, G__15844, G__15845, G__15846, G__15847, G__15848, G__15849, G__15850, G__15851, G__15852, G__15853, G__15854, G__15855, G__15856, G__15857, G__15858, G__15859) : self__.afn.call(null, G__15840, G__15841, G__15842, G__15843, G__15844, G__15845, G__15846, G__15847, G__15848, G__15849, G__15850, G__15851, G__15852, G__15853, G__15854, G__15855, G__15856, G__15857, 
    G__15858, G__15859);
  };
  var G__16114__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var G__15860 = self__.afn;
    var G__15861 = a;
    var G__15862 = b;
    var G__15863 = c;
    var G__15864 = d;
    var G__15865 = e;
    var G__15866 = f;
    var G__15867 = g;
    var G__15868 = h;
    var G__15869 = i;
    var G__15870 = j;
    var G__15871 = k;
    var G__15872 = l;
    var G__15873 = m;
    var G__15874 = n;
    var G__15875 = o;
    var G__15876 = p;
    var G__15877 = q;
    var G__15878 = r;
    var G__15879 = s;
    var G__15880 = t;
    var G__15881 = rest;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__15860, G__15861, G__15862, G__15863, G__15864, G__15865, G__15866, G__15867, G__15868, G__15869, G__15870, G__15871, G__15872, G__15873, G__15874, G__15875, G__15876, G__15877, G__15878, G__15879, G__15880, G__15881) : cljs.core.apply.call(null, G__15860, G__15861, G__15862, G__15863, G__15864, G__15865, G__15866, G__15867, G__15868, G__15869, G__15870, G__15871, G__15872, G__15873, G__15874, 
    G__15875, G__15876, G__15877, G__15878, G__15879, G__15880, G__15881);
  };
  G__16114 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__16114__1.call(this, self__);
      case 2:
        return G__16114__2.call(this, self__, a);
      case 3:
        return G__16114__3.call(this, self__, a, b);
      case 4:
        return G__16114__4.call(this, self__, a, b, c);
      case 5:
        return G__16114__5.call(this, self__, a, b, c, d);
      case 6:
        return G__16114__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__16114__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__16114__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__16114__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__16114__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__16114__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__16114__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__16114__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__16114__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__16114__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__16114__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__16114__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__16114__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__16114__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__16114__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__16114__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__16114__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__16114.cljs$core$IFn$_invoke$arity$1 = G__16114__1;
  G__16114.cljs$core$IFn$_invoke$arity$2 = G__16114__2;
  G__16114.cljs$core$IFn$_invoke$arity$3 = G__16114__3;
  G__16114.cljs$core$IFn$_invoke$arity$4 = G__16114__4;
  G__16114.cljs$core$IFn$_invoke$arity$5 = G__16114__5;
  G__16114.cljs$core$IFn$_invoke$arity$6 = G__16114__6;
  G__16114.cljs$core$IFn$_invoke$arity$7 = G__16114__7;
  G__16114.cljs$core$IFn$_invoke$arity$8 = G__16114__8;
  G__16114.cljs$core$IFn$_invoke$arity$9 = G__16114__9;
  G__16114.cljs$core$IFn$_invoke$arity$10 = G__16114__10;
  G__16114.cljs$core$IFn$_invoke$arity$11 = G__16114__11;
  G__16114.cljs$core$IFn$_invoke$arity$12 = G__16114__12;
  G__16114.cljs$core$IFn$_invoke$arity$13 = G__16114__13;
  G__16114.cljs$core$IFn$_invoke$arity$14 = G__16114__14;
  G__16114.cljs$core$IFn$_invoke$arity$15 = G__16114__15;
  G__16114.cljs$core$IFn$_invoke$arity$16 = G__16114__16;
  G__16114.cljs$core$IFn$_invoke$arity$17 = G__16114__17;
  G__16114.cljs$core$IFn$_invoke$arity$18 = G__16114__18;
  G__16114.cljs$core$IFn$_invoke$arity$19 = G__16114__19;
  G__16114.cljs$core$IFn$_invoke$arity$20 = G__16114__20;
  G__16114.cljs$core$IFn$_invoke$arity$21 = G__16114__21;
  G__16114.cljs$core$IFn$_invoke$arity$22 = G__16114__22;
  return G__16114;
}();
cljs.core.MetaFn.prototype.apply = function(self__, args15649) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args15649)));
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  var G__15882 = a;
  return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__15882) : self__.afn.call(null, G__15882);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  var G__15883 = a;
  var G__15884 = b;
  return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__15883, G__15884) : self__.afn.call(null, G__15883, G__15884);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  var G__15885 = a;
  var G__15886 = b;
  var G__15887 = c;
  return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__15885, G__15886, G__15887) : self__.afn.call(null, G__15885, G__15886, G__15887);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  var G__15888 = a;
  var G__15889 = b;
  var G__15890 = c;
  var G__15891 = d;
  return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__15888, G__15889, G__15890, G__15891) : self__.afn.call(null, G__15888, G__15889, G__15890, G__15891);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  var G__15892 = a;
  var G__15893 = b;
  var G__15894 = c;
  var G__15895 = d;
  var G__15896 = e;
  return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__15892, G__15893, G__15894, G__15895, G__15896) : self__.afn.call(null, G__15892, G__15893, G__15894, G__15895, G__15896);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  var G__15897 = a;
  var G__15898 = b;
  var G__15899 = c;
  var G__15900 = d;
  var G__15901 = e;
  var G__15902 = f;
  return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__15897, G__15898, G__15899, G__15900, G__15901, G__15902) : self__.afn.call(null, G__15897, G__15898, G__15899, G__15900, G__15901, G__15902);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  var G__15903 = a;
  var G__15904 = b;
  var G__15905 = c;
  var G__15906 = d;
  var G__15907 = e;
  var G__15908 = f;
  var G__15909 = g;
  return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__15903, G__15904, G__15905, G__15906, G__15907, G__15908, G__15909) : self__.afn.call(null, G__15903, G__15904, G__15905, G__15906, G__15907, G__15908, G__15909);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  var G__15910 = a;
  var G__15911 = b;
  var G__15912 = c;
  var G__15913 = d;
  var G__15914 = e;
  var G__15915 = f;
  var G__15916 = g;
  var G__15917 = h;
  return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__15910, G__15911, G__15912, G__15913, G__15914, G__15915, G__15916, G__15917) : self__.afn.call(null, G__15910, G__15911, G__15912, G__15913, G__15914, G__15915, G__15916, G__15917);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  var G__15918 = a;
  var G__15919 = b;
  var G__15920 = c;
  var G__15921 = d;
  var G__15922 = e;
  var G__15923 = f;
  var G__15924 = g;
  var G__15925 = h;
  var G__15926 = i;
  return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__15918, G__15919, G__15920, G__15921, G__15922, G__15923, G__15924, G__15925, G__15926) : self__.afn.call(null, G__15918, G__15919, G__15920, G__15921, G__15922, G__15923, G__15924, G__15925, G__15926);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  var G__15927 = a;
  var G__15928 = b;
  var G__15929 = c;
  var G__15930 = d;
  var G__15931 = e;
  var G__15932 = f;
  var G__15933 = g;
  var G__15934 = h;
  var G__15935 = i;
  var G__15936 = j;
  return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__15927, G__15928, G__15929, G__15930, G__15931, G__15932, G__15933, G__15934, G__15935, G__15936) : self__.afn.call(null, G__15927, G__15928, G__15929, G__15930, G__15931, G__15932, G__15933, G__15934, G__15935, G__15936);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  var G__15937 = a;
  var G__15938 = b;
  var G__15939 = c;
  var G__15940 = d;
  var G__15941 = e;
  var G__15942 = f;
  var G__15943 = g;
  var G__15944 = h;
  var G__15945 = i;
  var G__15946 = j;
  var G__15947 = k;
  return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__15937, G__15938, G__15939, G__15940, G__15941, G__15942, G__15943, G__15944, G__15945, G__15946, G__15947) : self__.afn.call(null, G__15937, G__15938, G__15939, G__15940, G__15941, G__15942, G__15943, G__15944, G__15945, G__15946, G__15947);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  var G__15948 = a;
  var G__15949 = b;
  var G__15950 = c;
  var G__15951 = d;
  var G__15952 = e;
  var G__15953 = f;
  var G__15954 = g;
  var G__15955 = h;
  var G__15956 = i;
  var G__15957 = j;
  var G__15958 = k;
  var G__15959 = l;
  return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__15948, G__15949, G__15950, G__15951, G__15952, G__15953, G__15954, G__15955, G__15956, G__15957, G__15958, G__15959) : self__.afn.call(null, G__15948, G__15949, G__15950, G__15951, G__15952, G__15953, G__15954, G__15955, G__15956, G__15957, G__15958, G__15959);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  var G__15960 = a;
  var G__15961 = b;
  var G__15962 = c;
  var G__15963 = d;
  var G__15964 = e;
  var G__15965 = f;
  var G__15966 = g;
  var G__15967 = h;
  var G__15968 = i;
  var G__15969 = j;
  var G__15970 = k;
  var G__15971 = l;
  var G__15972 = m;
  return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__15960, G__15961, G__15962, G__15963, G__15964, G__15965, G__15966, G__15967, G__15968, G__15969, G__15970, G__15971, G__15972) : self__.afn.call(null, G__15960, G__15961, G__15962, G__15963, G__15964, G__15965, G__15966, G__15967, G__15968, G__15969, G__15970, G__15971, G__15972);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  var G__15973 = a;
  var G__15974 = b;
  var G__15975 = c;
  var G__15976 = d;
  var G__15977 = e;
  var G__15978 = f;
  var G__15979 = g;
  var G__15980 = h;
  var G__15981 = i;
  var G__15982 = j;
  var G__15983 = k;
  var G__15984 = l;
  var G__15985 = m;
  var G__15986 = n;
  return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__15973, G__15974, G__15975, G__15976, G__15977, G__15978, G__15979, G__15980, G__15981, G__15982, G__15983, G__15984, G__15985, G__15986) : self__.afn.call(null, G__15973, G__15974, G__15975, G__15976, G__15977, G__15978, G__15979, G__15980, G__15981, G__15982, G__15983, G__15984, G__15985, G__15986);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  var G__15987 = a;
  var G__15988 = b;
  var G__15989 = c;
  var G__15990 = d;
  var G__15991 = e;
  var G__15992 = f;
  var G__15993 = g;
  var G__15994 = h;
  var G__15995 = i;
  var G__15996 = j;
  var G__15997 = k;
  var G__15998 = l;
  var G__15999 = m;
  var G__16000 = n;
  var G__16001 = o;
  return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__15987, G__15988, G__15989, G__15990, G__15991, G__15992, G__15993, G__15994, G__15995, G__15996, G__15997, G__15998, G__15999, G__16000, G__16001) : self__.afn.call(null, G__15987, G__15988, G__15989, G__15990, G__15991, G__15992, G__15993, G__15994, G__15995, G__15996, G__15997, G__15998, G__15999, G__16000, G__16001);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  var G__16002 = a;
  var G__16003 = b;
  var G__16004 = c;
  var G__16005 = d;
  var G__16006 = e;
  var G__16007 = f;
  var G__16008 = g;
  var G__16009 = h;
  var G__16010 = i;
  var G__16011 = j;
  var G__16012 = k;
  var G__16013 = l;
  var G__16014 = m;
  var G__16015 = n;
  var G__16016 = o;
  var G__16017 = p;
  return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__16002, G__16003, G__16004, G__16005, G__16006, G__16007, G__16008, G__16009, G__16010, G__16011, G__16012, G__16013, G__16014, G__16015, G__16016, G__16017) : self__.afn.call(null, G__16002, G__16003, G__16004, G__16005, G__16006, G__16007, G__16008, G__16009, G__16010, G__16011, G__16012, G__16013, G__16014, G__16015, G__16016, G__16017);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  var G__16018 = a;
  var G__16019 = b;
  var G__16020 = c;
  var G__16021 = d;
  var G__16022 = e;
  var G__16023 = f;
  var G__16024 = g;
  var G__16025 = h;
  var G__16026 = i;
  var G__16027 = j;
  var G__16028 = k;
  var G__16029 = l;
  var G__16030 = m;
  var G__16031 = n;
  var G__16032 = o;
  var G__16033 = p;
  var G__16034 = q;
  return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__16018, G__16019, G__16020, G__16021, G__16022, G__16023, G__16024, G__16025, G__16026, G__16027, G__16028, G__16029, G__16030, G__16031, G__16032, G__16033, G__16034) : self__.afn.call(null, G__16018, G__16019, G__16020, G__16021, G__16022, G__16023, G__16024, G__16025, G__16026, G__16027, G__16028, G__16029, G__16030, G__16031, G__16032, G__16033, G__16034);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  var G__16035 = a;
  var G__16036 = b;
  var G__16037 = c;
  var G__16038 = d;
  var G__16039 = e;
  var G__16040 = f;
  var G__16041 = g;
  var G__16042 = h;
  var G__16043 = i;
  var G__16044 = j;
  var G__16045 = k;
  var G__16046 = l;
  var G__16047 = m;
  var G__16048 = n;
  var G__16049 = o;
  var G__16050 = p;
  var G__16051 = q;
  var G__16052 = r;
  return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__16035, G__16036, G__16037, G__16038, G__16039, G__16040, G__16041, G__16042, G__16043, G__16044, G__16045, G__16046, G__16047, G__16048, G__16049, G__16050, G__16051, G__16052) : self__.afn.call(null, G__16035, G__16036, G__16037, G__16038, G__16039, G__16040, G__16041, G__16042, G__16043, G__16044, G__16045, G__16046, G__16047, G__16048, G__16049, G__16050, G__16051, G__16052);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  var G__16053 = a;
  var G__16054 = b;
  var G__16055 = c;
  var G__16056 = d;
  var G__16057 = e;
  var G__16058 = f;
  var G__16059 = g;
  var G__16060 = h;
  var G__16061 = i;
  var G__16062 = j;
  var G__16063 = k;
  var G__16064 = l;
  var G__16065 = m;
  var G__16066 = n;
  var G__16067 = o;
  var G__16068 = p;
  var G__16069 = q;
  var G__16070 = r;
  var G__16071 = s;
  return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__16053, G__16054, G__16055, G__16056, G__16057, G__16058, G__16059, G__16060, G__16061, G__16062, G__16063, G__16064, G__16065, G__16066, G__16067, G__16068, G__16069, G__16070, G__16071) : self__.afn.call(null, G__16053, G__16054, G__16055, G__16056, G__16057, G__16058, G__16059, G__16060, G__16061, G__16062, G__16063, G__16064, G__16065, G__16066, G__16067, G__16068, G__16069, G__16070, G__16071);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  var G__16072 = a;
  var G__16073 = b;
  var G__16074 = c;
  var G__16075 = d;
  var G__16076 = e;
  var G__16077 = f;
  var G__16078 = g;
  var G__16079 = h;
  var G__16080 = i;
  var G__16081 = j;
  var G__16082 = k;
  var G__16083 = l;
  var G__16084 = m;
  var G__16085 = n;
  var G__16086 = o;
  var G__16087 = p;
  var G__16088 = q;
  var G__16089 = r;
  var G__16090 = s;
  var G__16091 = t;
  return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__16072, G__16073, G__16074, G__16075, G__16076, G__16077, G__16078, G__16079, G__16080, G__16081, G__16082, G__16083, G__16084, G__16085, G__16086, G__16087, G__16088, G__16089, G__16090, G__16091) : self__.afn.call(null, G__16072, G__16073, G__16074, G__16075, G__16076, G__16077, G__16078, G__16079, G__16080, G__16081, G__16082, G__16083, G__16084, G__16085, G__16086, G__16087, G__16088, G__16089, G__16090, 
  G__16091);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  var G__16092 = self__.afn;
  var G__16093 = a;
  var G__16094 = b;
  var G__16095 = c;
  var G__16096 = d;
  var G__16097 = e;
  var G__16098 = f;
  var G__16099 = g;
  var G__16100 = h;
  var G__16101 = i;
  var G__16102 = j;
  var G__16103 = k;
  var G__16104 = l;
  var G__16105 = m;
  var G__16106 = n;
  var G__16107 = o;
  var G__16108 = p;
  var G__16109 = q;
  var G__16110 = r;
  var G__16111 = s;
  var G__16112 = t;
  var G__16113 = rest;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__16092, G__16093, G__16094, G__16095, G__16096, G__16097, G__16098, G__16099, G__16100, G__16101, G__16102, G__16103, G__16104, G__16105, G__16106, G__16107, G__16108, G__16109, G__16110, G__16111, G__16112, G__16113) : cljs.core.apply.call(null, G__16092, G__16093, G__16094, G__16095, G__16096, G__16097, G__16098, G__16099, G__16100, G__16101, G__16102, G__16103, G__16104, G__16105, G__16106, 
  G__16107, G__16108, G__16109, G__16110, G__16111, G__16112, G__16113);
};
cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;
cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.MetaFn(self__.afn, new_meta);
};
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.MetaFn.cljs$lang$type = true;
cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";
cljs.core.MetaFn.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/MetaFn");
};
cljs.core.__GT_MetaFn = function cljs$core$__GT_MetaFn(afn, meta) {
  return new cljs.core.MetaFn(afn, meta);
};
cljs.core.with_meta = function cljs$core$with_meta(o, meta) {
  if (cljs.core.fn_QMARK_(o) && !function() {
    var G__16118 = o;
    if (G__16118) {
      var bit__4950__auto__ = G__16118.cljs$lang$protocol_mask$partition0$ & 262144;
      if (bit__4950__auto__ || G__16118.cljs$core$IWithMeta$) {
        return true;
      } else {
        if (!G__16118.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta, G__16118);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta, G__16118);
    }
  }()) {
    return new cljs.core.MetaFn(o, meta);
  } else {
    if (o == null) {
      return null;
    } else {
      return cljs.core._with_meta(o, meta);
    }
  }
};
cljs.core.meta = function cljs$core$meta(o) {
  if (function() {
    var and__4264__auto__ = !(o == null);
    if (and__4264__auto__) {
      var G__16122 = o;
      if (G__16122) {
        var bit__4950__auto__ = G__16122.cljs$lang$protocol_mask$partition0$ & 131072;
        if (bit__4950__auto__ || G__16122.cljs$core$IMeta$) {
          return true;
        } else {
          if (!G__16122.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, G__16122);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, G__16122);
      }
    } else {
      return and__4264__auto__;
    }
  }()) {
    return cljs.core._meta(o);
  } else {
    return null;
  }
};
cljs.core.peek = function cljs$core$peek(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._peek(coll);
  }
};
cljs.core.pop = function cljs$core$pop(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._pop(coll);
  }
};
cljs.core.disj = function cljs$core$disj() {
  var G__16127 = arguments.length;
  switch(G__16127) {
    case 1:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._disjoin(coll, k);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__16129 = ret;
        var G__16130 = cljs.core.first(ks);
        var G__16131 = cljs.core.next(ks);
        coll = G__16129;
        k = G__16130;
        ks = G__16131;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.disj.cljs$lang$applyTo = function(seq16123) {
  var G__16124 = cljs.core.first(seq16123);
  var seq16123__$1 = cljs.core.next(seq16123);
  var G__16125 = cljs.core.first(seq16123__$1);
  var seq16123__$2 = cljs.core.next(seq16123__$1);
  return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__16124, G__16125, seq16123__$2);
};
cljs.core.disj.cljs$lang$maxFixedArity = 2;
cljs.core.empty_QMARK_ = function cljs$core$empty_QMARK_(coll) {
  return coll == null || cljs.core.not(cljs.core.seq(coll));
};
cljs.core.coll_QMARK_ = function cljs$core$coll_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__16133 = x;
    if (G__16133) {
      var bit__4950__auto__ = G__16133.cljs$lang$protocol_mask$partition0$ & 8;
      if (bit__4950__auto__ || G__16133.cljs$core$ICollection$) {
        return true;
      } else {
        if (!G__16133.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, G__16133);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, G__16133);
    }
  }
};
cljs.core.set_QMARK_ = function cljs$core$set_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__16135 = x;
    if (G__16135) {
      var bit__4950__auto__ = G__16135.cljs$lang$protocol_mask$partition0$ & 4096;
      if (bit__4950__auto__ || G__16135.cljs$core$ISet$) {
        return true;
      } else {
        if (!G__16135.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, G__16135);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, G__16135);
    }
  }
};
cljs.core.associative_QMARK_ = function cljs$core$associative_QMARK_(x) {
  var G__16137 = x;
  if (G__16137) {
    var bit__4950__auto__ = G__16137.cljs$lang$protocol_mask$partition0$ & 512;
    if (bit__4950__auto__ || G__16137.cljs$core$IAssociative$) {
      return true;
    } else {
      if (!G__16137.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, G__16137);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, G__16137);
  }
};
cljs.core.sequential_QMARK_ = function cljs$core$sequential_QMARK_(x) {
  var G__16139 = x;
  if (G__16139) {
    var bit__4950__auto__ = G__16139.cljs$lang$protocol_mask$partition0$ & 16777216;
    if (bit__4950__auto__ || G__16139.cljs$core$ISequential$) {
      return true;
    } else {
      if (!G__16139.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, G__16139);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, G__16139);
  }
};
cljs.core.sorted_QMARK_ = function cljs$core$sorted_QMARK_(x) {
  var G__16141 = x;
  if (G__16141) {
    var bit__4950__auto__ = G__16141.cljs$lang$protocol_mask$partition0$ & 268435456;
    if (bit__4950__auto__ || G__16141.cljs$core$ISorted$) {
      return true;
    } else {
      if (!G__16141.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, G__16141);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, G__16141);
  }
};
cljs.core.reduceable_QMARK_ = function cljs$core$reduceable_QMARK_(x) {
  var G__16143 = x;
  if (G__16143) {
    var bit__4950__auto__ = G__16143.cljs$lang$protocol_mask$partition0$ & 524288;
    if (bit__4950__auto__ || G__16143.cljs$core$IReduce$) {
      return true;
    } else {
      if (!G__16143.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, G__16143);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, G__16143);
  }
};
cljs.core.map_QMARK_ = function cljs$core$map_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    var G__16145 = x;
    if (G__16145) {
      var bit__4950__auto__ = G__16145.cljs$lang$protocol_mask$partition0$ & 1024;
      if (bit__4950__auto__ || G__16145.cljs$core$IMap$) {
        return true;
      } else {
        if (!G__16145.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, G__16145);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, G__16145);
    }
  }
};
cljs.core.vector_QMARK_ = function cljs$core$vector_QMARK_(x) {
  var G__16147 = x;
  if (G__16147) {
    var bit__4950__auto__ = G__16147.cljs$lang$protocol_mask$partition0$ & 16384;
    if (bit__4950__auto__ || G__16147.cljs$core$IVector$) {
      return true;
    } else {
      if (!G__16147.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, G__16147);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, G__16147);
  }
};
cljs.core.chunked_seq_QMARK_ = function cljs$core$chunked_seq_QMARK_(x) {
  var G__16149 = x;
  if (G__16149) {
    var bit__4943__auto__ = G__16149.cljs$lang$protocol_mask$partition1$ & 512;
    if (bit__4943__auto__ || G__16149.cljs$core$IChunkedSeq$) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
cljs.core.js_obj = function cljs$core$js_obj() {
  var G__16152 = arguments.length;
  switch(G__16152) {
    case 0:
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0);
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__5328__auto__);
  }
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = function() {
  var obj16154 = {};
  return obj16154;
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var G__16155 = goog.object.create;
  var G__16156 = keyvals;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__16155, G__16156) : cljs.core.apply.call(null, G__16155, G__16156);
};
cljs.core.js_obj.cljs$lang$applyTo = function(seq16150) {
  return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16150));
};
cljs.core.js_obj.cljs$lang$maxFixedArity = 0;
cljs.core.js_keys = function cljs$core$js_keys(obj) {
  var keys = [];
  var G__16160_16162 = obj;
  var G__16161_16163 = function(G__16160_16162, keys) {
    return function(val, key, obj__$1) {
      return keys.push(key);
    };
  }(G__16160_16162, keys);
  goog.object.forEach(G__16160_16162, G__16161_16163);
  return keys;
};
cljs.core.js_delete = function cljs$core$js_delete(obj, key) {
  return delete obj[key];
};
cljs.core.array_copy = function cljs$core$array_copy(from, i, to, j, len) {
  var i__$1 = i;
  var j__$1 = j;
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__16164 = i__$1 + 1;
      var G__16165 = j__$1 + 1;
      var G__16166 = len__$1 - 1;
      i__$1 = G__16164;
      j__$1 = G__16165;
      len__$1 = G__16166;
      continue;
    }
    break;
  }
};
cljs.core.array_copy_downward = function cljs$core$array_copy_downward(from, i, to, j, len) {
  var i__$1 = i + (len - 1);
  var j__$1 = j + (len - 1);
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__16167 = i__$1 - 1;
      var G__16168 = j__$1 - 1;
      var G__16169 = len__$1 - 1;
      i__$1 = G__16167;
      j__$1 = G__16168;
      len__$1 = G__16169;
      continue;
    }
    break;
  }
};
cljs.core.lookup_sentinel = function() {
  var obj16171 = {};
  return obj16171;
}();
cljs.core.false_QMARK_ = function cljs$core$false_QMARK_(x) {
  return x === false;
};
cljs.core.true_QMARK_ = function cljs$core$true_QMARK_(x) {
  return x === true;
};
cljs.core.undefined_QMARK_ = function cljs$core$undefined_QMARK_(x) {
  return void 0 === x;
};
cljs.core.seq_QMARK_ = function cljs$core$seq_QMARK_(s) {
  if (s == null) {
    return false;
  } else {
    var G__16173 = s;
    if (G__16173) {
      var bit__4950__auto__ = G__16173.cljs$lang$protocol_mask$partition0$ & 64;
      if (bit__4950__auto__ || G__16173.cljs$core$ISeq$) {
        return true;
      } else {
        if (!G__16173.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__16173);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, G__16173);
    }
  }
};
cljs.core.seqable_QMARK_ = function cljs$core$seqable_QMARK_(s) {
  var G__16175 = s;
  if (G__16175) {
    var bit__4950__auto__ = G__16175.cljs$lang$protocol_mask$partition0$ & 8388608;
    if (bit__4950__auto__ || G__16175.cljs$core$ISeqable$) {
      return true;
    } else {
      if (!G__16175.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, G__16175);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, G__16175);
  }
};
cljs.core.boolean$ = function cljs$core$boolean(x) {
  if (cljs.core.truth_(x)) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ifn_QMARK_ = function cljs$core$ifn_QMARK_(f) {
  var or__4276__auto__ = cljs.core.fn_QMARK_(f);
  if (or__4276__auto__) {
    return or__4276__auto__;
  } else {
    var G__16179 = f;
    if (G__16179) {
      var bit__4950__auto__ = G__16179.cljs$lang$protocol_mask$partition0$ & 1;
      if (bit__4950__auto__ || G__16179.cljs$core$IFn$) {
        return true;
      } else {
        if (!G__16179.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, G__16179);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, G__16179);
    }
  }
};
cljs.core.integer_QMARK_ = function cljs$core$integer_QMARK_(n) {
  return typeof n === "number" && cljs.core.not(function() {
    var G__16192 = n;
    return isNaN(G__16192);
  }()) && !(n === Infinity) && function() {
    var G__16193 = n;
    return parseFloat(G__16193);
  }() === function() {
    var G__16194 = n;
    var G__16195 = 10;
    return parseInt(G__16194, G__16195);
  }();
};
cljs.core.contains_QMARK_ = function cljs$core$contains_QMARK_(coll, v) {
  if (cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false;
  } else {
    return true;
  }
};
cljs.core.find = function cljs$core$find(coll, k) {
  if (!(coll == null) && cljs.core.associative_QMARK_(coll) && cljs.core.contains_QMARK_(coll, k)) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, k)], null);
  } else {
    return null;
  }
};
cljs.core.distinct_QMARK_ = function cljs$core$distinct_QMARK_() {
  var G__16200 = arguments.length;
  switch(G__16200) {
    case 1:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  if (!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
    var s = cljs.core.PersistentHashSet.fromArray([x, y], true);
    var xs = more;
    while (true) {
      var x__$1 = cljs.core.first(xs);
      var etc = cljs.core.next(xs);
      if (cljs.core.truth_(xs)) {
        if (cljs.core.contains_QMARK_(s, x__$1)) {
          return false;
        } else {
          var G__16202 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s, x__$1);
          var G__16203 = etc;
          s = G__16202;
          xs = G__16203;
          continue;
        }
      } else {
        return true;
      }
      break;
    }
  } else {
    return false;
  }
};
cljs.core.distinct_QMARK_.cljs$lang$applyTo = function(seq16196) {
  var G__16197 = cljs.core.first(seq16196);
  var seq16196__$1 = cljs.core.next(seq16196);
  var G__16198 = cljs.core.first(seq16196__$1);
  var seq16196__$2 = cljs.core.next(seq16196__$1);
  return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__16197, G__16198, seq16196__$2);
};
cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs.core.compare = function cljs$core$compare(x, y) {
  if (x === y) {
    return 0;
  } else {
    if (x == null) {
      return-1;
    } else {
      if (y == null) {
        return 1;
      } else {
        if (cljs.core.type(x) === cljs.core.type(y)) {
          if (function() {
            var G__16207 = x;
            if (G__16207) {
              var bit__4943__auto__ = G__16207.cljs$lang$protocol_mask$partition1$ & 2048;
              if (bit__4943__auto__ || G__16207.cljs$core$IComparable$) {
                return true;
              } else {
                return false;
              }
            } else {
              return false;
            }
          }()) {
            return x.cljs$core$IComparable$_compare$arity$2(null, y);
          } else {
            var G__16208 = x;
            var G__16209 = y;
            return goog.array.defaultCompare(G__16208, G__16209);
          }
        } else {
          throw new Error("compare on non-nil objects of different types");
        }
      }
    }
  }
};
cljs.core.compare_indexed = function cljs$core$compare_indexed() {
  var G__16211 = arguments.length;
  switch(G__16211) {
    case 2:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 4:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = function(xs, ys) {
  var xl = cljs.core.count(xs);
  var yl = cljs.core.count(ys);
  if (xl < yl) {
    return-1;
  } else {
    if (xl > yl) {
      return 1;
    } else {
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs, ys, xl, 0);
    }
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = function(xs, ys, len, n) {
  while (true) {
    var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs, n), cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys, n));
    if (d === 0 && n + 1 < len) {
      var G__16213 = xs;
      var G__16214 = ys;
      var G__16215 = len;
      var G__16216 = n + 1;
      xs = G__16213;
      ys = G__16214;
      len = G__16215;
      n = G__16216;
      continue;
    } else {
      return d;
    }
    break;
  }
};
cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
cljs.core.fn__GT_comparator = function cljs$core$fn__GT_comparator(f) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f, cljs.core.compare)) {
    return cljs.core.compare;
  } else {
    return function(x, y) {
      var r = function() {
        var G__16221 = x;
        var G__16222 = y;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16221, G__16222) : f.call(null, G__16221, G__16222);
      }();
      if (typeof r === "number") {
        return r;
      } else {
        if (cljs.core.truth_(r)) {
          return-1;
        } else {
          if (cljs.core.truth_(function() {
            var G__16223 = y;
            var G__16224 = x;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16223, G__16224) : f.call(null, G__16223, G__16224);
          }())) {
            return 1;
          } else {
            return 0;
          }
        }
      }
    };
  }
};
cljs.core.sort = function cljs$core$sort() {
  var G__16226 = arguments.length;
  switch(G__16226) {
    case 1:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare, coll);
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = function(comp, coll) {
  if (cljs.core.seq(coll)) {
    var a = function() {
      var G__16227 = coll;
      return cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__16227) : cljs.core.to_array.call(null, G__16227);
    }();
    var G__16228_16231 = a;
    var G__16229_16232 = cljs.core.fn__GT_comparator(comp);
    goog.array.stableSort(G__16228_16231, G__16229_16232);
    return cljs.core.seq(a);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.sort.cljs$lang$maxFixedArity = 2;
cljs.core.sort_by = function cljs$core$sort_by() {
  var G__16234 = arguments.length;
  switch(G__16234) {
    case 2:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = function(keyfn, coll) {
  return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn, cljs.core.compare, coll);
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = function(keyfn, comp, coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(function(x, y) {
    return cljs.core.fn__GT_comparator(comp).call(null, function() {
      var G__16235 = x;
      return keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__16235) : keyfn.call(null, G__16235);
    }(), function() {
      var G__16236 = y;
      return keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__16236) : keyfn.call(null, G__16236);
    }());
  }, coll);
};
cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = function cljs$core$seq_reduce() {
  var G__16239 = arguments.length;
  switch(G__16239) {
    case 2:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var temp__4124__auto__ = cljs.core.seq(coll);
  if (temp__4124__auto__) {
    var s = temp__4124__auto__;
    var G__16240 = f;
    var G__16241 = cljs.core.first(s);
    var G__16242 = cljs.core.next(s);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__16240, G__16241, G__16242) : cljs.core.reduce.call(null, G__16240, G__16241, G__16242);
  } else {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  var val__$1 = val;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (coll__$1) {
      var nval = function() {
        var G__16243 = val__$1;
        var G__16244 = cljs.core.first(coll__$1);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16243, G__16244) : f.call(null, G__16243, G__16244);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__16246 = nval;
        var G__16247 = cljs.core.next(coll__$1);
        val__$1 = G__16246;
        coll__$1 = G__16247;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
cljs.core.shuffle = function cljs$core$shuffle(coll) {
  var a = function() {
    var G__16251 = coll;
    return cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__16251) : cljs.core.to_array.call(null, G__16251);
  }();
  var G__16252_16254 = a;
  goog.array.shuffle(G__16252_16254);
  var G__16253 = a;
  return cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__16253) : cljs.core.vec.call(null, G__16253);
};
cljs.core.reduce = function cljs$core$reduce() {
  var G__16256 = arguments.length;
  switch(G__16256) {
    case 2:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  if (function() {
    var G__16257 = coll;
    if (G__16257) {
      var bit__4943__auto__ = G__16257.cljs$lang$protocol_mask$partition0$ & 524288;
      if (bit__4943__auto__ || G__16257.cljs$core$IReduce$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$2(null, f);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  if (function() {
    var G__16258 = coll;
    if (G__16258) {
      var bit__4943__auto__ = G__16258.cljs$lang$protocol_mask$partition0$ & 524288;
      if (bit__4943__auto__ || G__16258.cljs$core$IReduce$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return coll.cljs$core$IReduce$_reduce$arity$3(null, f, val);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
        } else {
          return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, val, coll);
        }
      }
    }
  }
};
cljs.core.reduce.cljs$lang$maxFixedArity = 3;
cljs.core.reduce_kv = function cljs$core$reduce_kv(f, init, coll) {
  if (!(coll == null)) {
    return cljs.core._kv_reduce(coll, f, init);
  } else {
    return init;
  }
};
cljs.core.identity = function cljs$core$identity(x) {
  return x;
};
cljs.core.completing = function cljs$core$completing() {
  var G__16261 = arguments.length;
  switch(G__16261) {
    case 1:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f, cljs.core.identity);
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = function(f, cf) {
  return function() {
    var G__16266 = null;
    var G__16266__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    };
    var G__16266__1 = function(x) {
      var G__16262 = x;
      return cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__16262) : cf.call(null, G__16262);
    };
    var G__16266__2 = function(x, y) {
      var G__16263 = x;
      var G__16264 = y;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16263, G__16264) : f.call(null, G__16263, G__16264);
    };
    G__16266 = function(x, y) {
      switch(arguments.length) {
        case 0:
          return G__16266__0.call(this);
        case 1:
          return G__16266__1.call(this, x);
        case 2:
          return G__16266__2.call(this, x, y);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__16266.cljs$core$IFn$_invoke$arity$0 = G__16266__0;
    G__16266.cljs$core$IFn$_invoke$arity$1 = G__16266__1;
    G__16266.cljs$core$IFn$_invoke$arity$2 = G__16266__2;
    return G__16266;
  }();
};
cljs.core.completing.cljs$lang$maxFixedArity = 2;
cljs.core.transduce = function cljs$core$transduce() {
  var G__16268 = arguments.length;
  switch(G__16268) {
    case 3:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = function(xform, f, coll) {
  return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, f, function() {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }(), coll);
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = function(xform, f, init, coll) {
  var f__$1 = function() {
    var G__16269 = f;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__16269) : xform.call(null, G__16269);
  }();
  var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1, init, coll);
  var G__16270 = ret;
  return f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__16270) : f__$1.call(null, G__16270);
};
cljs.core.transduce.cljs$lang$maxFixedArity = 4;
cljs.core._PLUS_ = function cljs$core$_PLUS_() {
  var G__16276 = arguments.length;
  switch(G__16276) {
    case 0:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_, x + y, more);
};
cljs.core._PLUS_.cljs$lang$applyTo = function(seq16272) {
  var G__16273 = cljs.core.first(seq16272);
  var seq16272__$1 = cljs.core.next(seq16272);
  var G__16274 = cljs.core.first(seq16272__$1);
  var seq16272__$2 = cljs.core.next(seq16272__$1);
  return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__16273, G__16274, seq16272__$2);
};
cljs.core._PLUS_.cljs$lang$maxFixedArity = 2;
cljs.core._ = function cljs$core$_() {
  var G__16282 = arguments.length;
  switch(G__16282) {
    case 1:
      return cljs.core._.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core._.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return-x;
};
cljs.core._.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core._.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._, x - y, more);
};
cljs.core._.cljs$lang$applyTo = function(seq16278) {
  var G__16279 = cljs.core.first(seq16278);
  var seq16278__$1 = cljs.core.next(seq16278);
  var G__16280 = cljs.core.first(seq16278__$1);
  var seq16278__$2 = cljs.core.next(seq16278__$1);
  return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__16279, G__16280, seq16278__$2);
};
cljs.core._.cljs$lang$maxFixedArity = 2;
cljs.core._STAR_ = function cljs$core$_STAR_() {
  var G__16288 = arguments.length;
  switch(G__16288) {
    case 0:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_, x * y, more);
};
cljs.core._STAR_.cljs$lang$applyTo = function(seq16284) {
  var G__16285 = cljs.core.first(seq16284);
  var seq16284__$1 = cljs.core.next(seq16284);
  var G__16286 = cljs.core.first(seq16284__$1);
  var seq16284__$2 = cljs.core.next(seq16284__$1);
  return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__16285, G__16286, seq16284__$2);
};
cljs.core._STAR_.cljs$lang$maxFixedArity = 2;
cljs.core._SLASH_ = function cljs$core$_SLASH_() {
  var G__16294 = arguments.length;
  switch(G__16294) {
    case 1:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_, x / y, more);
};
cljs.core._SLASH_.cljs$lang$applyTo = function(seq16290) {
  var G__16291 = cljs.core.first(seq16290);
  var seq16290__$1 = cljs.core.next(seq16290);
  var G__16292 = cljs.core.first(seq16290__$1);
  var seq16290__$2 = cljs.core.next(seq16290__$1);
  return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__16291, G__16292, seq16290__$2);
};
cljs.core._SLASH_.cljs$lang$maxFixedArity = 2;
cljs.core._LT_ = function cljs$core$_LT_() {
  var G__16300 = arguments.length;
  switch(G__16300) {
    case 1:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x < y;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x < y) {
      if (cljs.core.next(more)) {
        var G__16302 = y;
        var G__16303 = cljs.core.first(more);
        var G__16304 = cljs.core.next(more);
        x = G__16302;
        y = G__16303;
        more = G__16304;
        continue;
      } else {
        return y < cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT_.cljs$lang$applyTo = function(seq16296) {
  var G__16297 = cljs.core.first(seq16296);
  var seq16296__$1 = cljs.core.next(seq16296);
  var G__16298 = cljs.core.first(seq16296__$1);
  var seq16296__$2 = cljs.core.next(seq16296__$1);
  return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__16297, G__16298, seq16296__$2);
};
cljs.core._LT_.cljs$lang$maxFixedArity = 2;
cljs.core._LT__EQ_ = function cljs$core$_LT__EQ_() {
  var G__16309 = arguments.length;
  switch(G__16309) {
    case 1:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x <= y;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x <= y) {
      if (cljs.core.next(more)) {
        var G__16311 = y;
        var G__16312 = cljs.core.first(more);
        var G__16313 = cljs.core.next(more);
        x = G__16311;
        y = G__16312;
        more = G__16313;
        continue;
      } else {
        return y <= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT__EQ_.cljs$lang$applyTo = function(seq16305) {
  var G__16306 = cljs.core.first(seq16305);
  var seq16305__$1 = cljs.core.next(seq16305);
  var G__16307 = cljs.core.first(seq16305__$1);
  var seq16305__$2 = cljs.core.next(seq16305__$1);
  return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__16306, G__16307, seq16305__$2);
};
cljs.core._LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core._GT_ = function cljs$core$_GT_() {
  var G__16318 = arguments.length;
  switch(G__16318) {
    case 1:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x > y;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x > y) {
      if (cljs.core.next(more)) {
        var G__16320 = y;
        var G__16321 = cljs.core.first(more);
        var G__16322 = cljs.core.next(more);
        x = G__16320;
        y = G__16321;
        more = G__16322;
        continue;
      } else {
        return y > cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT_.cljs$lang$applyTo = function(seq16314) {
  var G__16315 = cljs.core.first(seq16314);
  var seq16314__$1 = cljs.core.next(seq16314);
  var G__16316 = cljs.core.first(seq16314__$1);
  var seq16314__$2 = cljs.core.next(seq16314__$1);
  return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__16315, G__16316, seq16314__$2);
};
cljs.core._GT_.cljs$lang$maxFixedArity = 2;
cljs.core._GT__EQ_ = function cljs$core$_GT__EQ_() {
  var G__16327 = arguments.length;
  switch(G__16327) {
    case 1:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x >= y;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x >= y) {
      if (cljs.core.next(more)) {
        var G__16329 = y;
        var G__16330 = cljs.core.first(more);
        var G__16331 = cljs.core.next(more);
        x = G__16329;
        y = G__16330;
        more = G__16331;
        continue;
      } else {
        return y >= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT__EQ_.cljs$lang$applyTo = function(seq16323) {
  var G__16324 = cljs.core.first(seq16323);
  var seq16323__$1 = cljs.core.next(seq16323);
  var G__16325 = cljs.core.first(seq16323__$1);
  var seq16323__$2 = cljs.core.next(seq16323__$1);
  return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__16324, G__16325, seq16323__$2);
};
cljs.core._GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.dec = function cljs$core$dec(x) {
  return x - 1;
};
cljs.core.max = function cljs$core$max() {
  var G__16336 = arguments.length;
  switch(G__16336) {
    case 1:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.max.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__4588__auto__ = x;
  var y__4589__auto__ = y;
  return x__4588__auto__ > y__4589__auto__ ? x__4588__auto__ : y__4589__auto__;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max, function() {
    var x__4588__auto__ = x;
    var y__4589__auto__ = y;
    return x__4588__auto__ > y__4589__auto__ ? x__4588__auto__ : y__4589__auto__;
  }(), more);
};
cljs.core.max.cljs$lang$applyTo = function(seq16332) {
  var G__16333 = cljs.core.first(seq16332);
  var seq16332__$1 = cljs.core.next(seq16332);
  var G__16334 = cljs.core.first(seq16332__$1);
  var seq16332__$2 = cljs.core.next(seq16332__$1);
  return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__16333, G__16334, seq16332__$2);
};
cljs.core.max.cljs$lang$maxFixedArity = 2;
cljs.core.min = function cljs$core$min() {
  var G__16342 = arguments.length;
  switch(G__16342) {
    case 1:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.min.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__4595__auto__ = x;
  var y__4596__auto__ = y;
  return x__4595__auto__ < y__4596__auto__ ? x__4595__auto__ : y__4596__auto__;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min, function() {
    var x__4595__auto__ = x;
    var y__4596__auto__ = y;
    return x__4595__auto__ < y__4596__auto__ ? x__4595__auto__ : y__4596__auto__;
  }(), more);
};
cljs.core.min.cljs$lang$applyTo = function(seq16338) {
  var G__16339 = cljs.core.first(seq16338);
  var seq16338__$1 = cljs.core.next(seq16338);
  var G__16340 = cljs.core.first(seq16338__$1);
  var seq16338__$2 = cljs.core.next(seq16338__$1);
  return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__16339, G__16340, seq16338__$2);
};
cljs.core.min.cljs$lang$maxFixedArity = 2;
cljs.core.byte$ = function cljs$core$byte(x) {
  return x;
};
cljs.core.char$ = function cljs$core$char(x) {
  if (typeof x === "number") {
    return String.fromCharCode(x);
  } else {
    if (typeof x === "string" && x.length === 1) {
      return x;
    } else {
      throw new Error("Argument to char must be a character or number");
    }
  }
};
cljs.core.short$ = function cljs$core$short(x) {
  return x;
};
cljs.core.float$ = function cljs$core$float(x) {
  return x;
};
cljs.core.double$ = function cljs$core$double(x) {
  return x;
};
cljs.core.unchecked_byte = function cljs$core$unchecked_byte(x) {
  return x;
};
cljs.core.unchecked_char = function cljs$core$unchecked_char(x) {
  return x;
};
cljs.core.unchecked_short = function cljs$core$unchecked_short(x) {
  return x;
};
cljs.core.unchecked_float = function cljs$core$unchecked_float(x) {
  return x;
};
cljs.core.unchecked_double = function cljs$core$unchecked_double(x) {
  return x;
};
cljs.core.unchecked_add = function cljs$core$unchecked_add() {
  var G__16348 = arguments.length;
  switch(G__16348) {
    case 0:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add, x + y, more);
};
cljs.core.unchecked_add.cljs$lang$applyTo = function(seq16344) {
  var G__16345 = cljs.core.first(seq16344);
  var seq16344__$1 = cljs.core.next(seq16344);
  var G__16346 = cljs.core.first(seq16344__$1);
  var seq16344__$2 = cljs.core.next(seq16344__$1);
  return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__16345, G__16346, seq16344__$2);
};
cljs.core.unchecked_add.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_add_int = function cljs$core$unchecked_add_int() {
  var G__16354 = arguments.length;
  switch(G__16354) {
    case 0:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int, x + y, more);
};
cljs.core.unchecked_add_int.cljs$lang$applyTo = function(seq16350) {
  var G__16351 = cljs.core.first(seq16350);
  var seq16350__$1 = cljs.core.next(seq16350);
  var G__16352 = cljs.core.first(seq16350__$1);
  var seq16350__$2 = cljs.core.next(seq16350__$1);
  return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__16351, G__16352, seq16350__$2);
};
cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_dec = function cljs$core$unchecked_dec(x) {
  return x - 1;
};
cljs.core.unchecked_dec_int = function cljs$core$unchecked_dec_int(x) {
  return x - 1;
};
cljs.core.unchecked_divide_int = function cljs$core$unchecked_divide_int() {
  var G__16360 = arguments.length;
  switch(G__16360) {
    case 1:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int, x / y, more);
};
cljs.core.unchecked_divide_int.cljs$lang$applyTo = function(seq16356) {
  var G__16357 = cljs.core.first(seq16356);
  var seq16356__$1 = cljs.core.next(seq16356);
  var G__16358 = cljs.core.first(seq16356__$1);
  var seq16356__$2 = cljs.core.next(seq16356__$1);
  return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__16357, G__16358, seq16356__$2);
};
cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_inc = function cljs$core$unchecked_inc(x) {
  return x + 1;
};
cljs.core.unchecked_inc_int = function cljs$core$unchecked_inc_int(x) {
  return x + 1;
};
cljs.core.unchecked_multiply = function cljs$core$unchecked_multiply() {
  var G__16366 = arguments.length;
  switch(G__16366) {
    case 0:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply, x * y, more);
};
cljs.core.unchecked_multiply.cljs$lang$applyTo = function(seq16362) {
  var G__16363 = cljs.core.first(seq16362);
  var seq16362__$1 = cljs.core.next(seq16362);
  var G__16364 = cljs.core.first(seq16362__$1);
  var seq16362__$2 = cljs.core.next(seq16362__$1);
  return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__16363, G__16364, seq16362__$2);
};
cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_multiply_int = function cljs$core$unchecked_multiply_int() {
  var G__16372 = arguments.length;
  switch(G__16372) {
    case 0:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int, x * y, more);
};
cljs.core.unchecked_multiply_int.cljs$lang$applyTo = function(seq16368) {
  var G__16369 = cljs.core.first(seq16368);
  var seq16368__$1 = cljs.core.next(seq16368);
  var G__16370 = cljs.core.first(seq16368__$1);
  var seq16368__$2 = cljs.core.next(seq16368__$1);
  return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__16369, G__16370, seq16368__$2);
};
cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_negate = function cljs$core$unchecked_negate(x) {
  return-x;
};
cljs.core.unchecked_negate_int = function cljs$core$unchecked_negate_int(x) {
  return-x;
};
cljs.core.unchecked_remainder_int = function cljs$core$unchecked_remainder_int(x, n) {
  var G__16376 = x;
  var G__16377 = n;
  return cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__16376, G__16377) : cljs.core.mod.call(null, G__16376, G__16377);
};
cljs.core.unchecked_subtract = function cljs$core$unchecked_subtract() {
  var G__16382 = arguments.length;
  switch(G__16382) {
    case 1:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return-x;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract, x - y, more);
};
cljs.core.unchecked_subtract.cljs$lang$applyTo = function(seq16378) {
  var G__16379 = cljs.core.first(seq16378);
  var seq16378__$1 = cljs.core.next(seq16378);
  var G__16380 = cljs.core.first(seq16378__$1);
  var seq16378__$2 = cljs.core.next(seq16378__$1);
  return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__16379, G__16380, seq16378__$2);
};
cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_subtract_int = function cljs$core$unchecked_subtract_int() {
  var G__16388 = arguments.length;
  switch(G__16388) {
    case 1:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return-x;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int, x - y, more);
};
cljs.core.unchecked_subtract_int.cljs$lang$applyTo = function(seq16384) {
  var G__16385 = cljs.core.first(seq16384);
  var seq16384__$1 = cljs.core.next(seq16384);
  var G__16386 = cljs.core.first(seq16384__$1);
  var seq16384__$2 = cljs.core.next(seq16384__$1);
  return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__16385, G__16386, seq16384__$2);
};
cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs.core.fix = function cljs$core$fix(q) {
  if (q >= 0) {
    var G__16392 = q;
    return Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__16392) : Math.floor.call(null, G__16392);
  } else {
    var G__16393 = q;
    return Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__16393) : Math.ceil.call(null, G__16393);
  }
};
cljs.core.int$ = function cljs$core$int(x) {
  return x | 0;
};
cljs.core.unchecked_int = function cljs$core$unchecked_int(x) {
  return cljs.core.fix(x);
};
cljs.core.long$ = function cljs$core$long(x) {
  return cljs.core.fix(x);
};
cljs.core.unchecked_long = function cljs$core$unchecked_long(x) {
  return cljs.core.fix(x);
};
cljs.core.booleans = function cljs$core$booleans(x) {
  return x;
};
cljs.core.bytes = function cljs$core$bytes(x) {
  return x;
};
cljs.core.chars = function cljs$core$chars(x) {
  return x;
};
cljs.core.shorts = function cljs$core$shorts(x) {
  return x;
};
cljs.core.ints = function cljs$core$ints(x) {
  return x;
};
cljs.core.floats = function cljs$core$floats(x) {
  return x;
};
cljs.core.doubles = function cljs$core$doubles(x) {
  return x;
};
cljs.core.longs = function cljs$core$longs(x) {
  return x;
};
cljs.core.js_mod = function cljs$core$js_mod(n, d) {
  return n % d;
};
cljs.core.mod = function cljs$core$mod(n, d) {
  return(n % d + d) % d;
};
cljs.core.quot = function cljs$core$quot(n, d) {
  var rem = n % d;
  return cljs.core.fix((n - rem) / d);
};
cljs.core.rem = function cljs$core$rem(n, d) {
  var q = cljs.core.quot(n, d);
  return n - d * q;
};
cljs.core.bit_xor = function cljs$core$bit_xor() {
  var G__16398 = arguments.length;
  switch(G__16398) {
    case 2:
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x ^ y;
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor, x ^ y, more);
};
cljs.core.bit_xor.cljs$lang$applyTo = function(seq16394) {
  var G__16395 = cljs.core.first(seq16394);
  var seq16394__$1 = cljs.core.next(seq16394);
  var G__16396 = cljs.core.first(seq16394__$1);
  var seq16394__$2 = cljs.core.next(seq16394__$1);
  return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__16395, G__16396, seq16394__$2);
};
cljs.core.bit_xor.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and = function cljs$core$bit_and() {
  var G__16404 = arguments.length;
  switch(G__16404) {
    case 2:
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & y;
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and, x & y, more);
};
cljs.core.bit_and.cljs$lang$applyTo = function(seq16400) {
  var G__16401 = cljs.core.first(seq16400);
  var seq16400__$1 = cljs.core.next(seq16400);
  var G__16402 = cljs.core.first(seq16400__$1);
  var seq16400__$2 = cljs.core.next(seq16400__$1);
  return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__16401, G__16402, seq16400__$2);
};
cljs.core.bit_and.cljs$lang$maxFixedArity = 2;
cljs.core.bit_or = function cljs$core$bit_or() {
  var G__16410 = arguments.length;
  switch(G__16410) {
    case 2:
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x | y;
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or, x | y, more);
};
cljs.core.bit_or.cljs$lang$applyTo = function(seq16406) {
  var G__16407 = cljs.core.first(seq16406);
  var seq16406__$1 = cljs.core.next(seq16406);
  var G__16408 = cljs.core.first(seq16406__$1);
  var seq16406__$2 = cljs.core.next(seq16406__$1);
  return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__16407, G__16408, seq16406__$2);
};
cljs.core.bit_or.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and_not = function cljs$core$bit_and_not() {
  var G__16416 = arguments.length;
  switch(G__16416) {
    case 2:
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & ~y;
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not, x & ~y, more);
};
cljs.core.bit_and_not.cljs$lang$applyTo = function(seq16412) {
  var G__16413 = cljs.core.first(seq16412);
  var seq16412__$1 = cljs.core.next(seq16412);
  var G__16414 = cljs.core.first(seq16412__$1);
  var seq16412__$2 = cljs.core.next(seq16412__$1);
  return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__16413, G__16414, seq16412__$2);
};
cljs.core.bit_and_not.cljs$lang$maxFixedArity = 2;
cljs.core.bit_clear = function cljs$core$bit_clear(x, n) {
  return x & ~(1 << n);
};
cljs.core.bit_flip = function cljs$core$bit_flip(x, n) {
  return x ^ 1 << n;
};
cljs.core.bit_not = function cljs$core$bit_not(x) {
  return~x;
};
cljs.core.bit_set = function cljs$core$bit_set(x, n) {
  return x | 1 << n;
};
cljs.core.bit_test = function cljs$core$bit_test(x, n) {
  return(x & 1 << n) != 0;
};
cljs.core.bit_shift_left = function cljs$core$bit_shift_left(x, n) {
  return x << n;
};
cljs.core.bit_shift_right = function cljs$core$bit_shift_right(x, n) {
  return x >> n;
};
cljs.core.bit_shift_right_zero_fill = function cljs$core$bit_shift_right_zero_fill(x, n) {
  return x >>> n;
};
cljs.core.unsigned_bit_shift_right = function cljs$core$unsigned_bit_shift_right(x, n) {
  return x >>> n;
};
cljs.core.bit_count = function cljs$core$bit_count(v) {
  var v__$1 = v - (v >> 1 & 1431655765);
  var v__$2 = (v__$1 & 858993459) + (v__$1 >> 2 & 858993459);
  return(v__$2 + (v__$2 >> 4) & 252645135) * 16843009 >> 24;
};
cljs.core._EQ__EQ_ = function cljs$core$_EQ__EQ_() {
  var G__16422 = arguments.length;
  switch(G__16422) {
    case 1:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return cljs.core._equiv(x, y);
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x === y) {
      if (cljs.core.next(more)) {
        var G__16424 = y;
        var G__16425 = cljs.core.first(more);
        var G__16426 = cljs.core.next(more);
        x = G__16424;
        y = G__16425;
        more = G__16426;
        continue;
      } else {
        return y === cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ__EQ_.cljs$lang$applyTo = function(seq16418) {
  var G__16419 = cljs.core.first(seq16418);
  var seq16418__$1 = cljs.core.next(seq16418);
  var G__16420 = cljs.core.first(seq16418__$1);
  var seq16418__$2 = cljs.core.next(seq16418__$1);
  return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__16419, G__16420, seq16418__$2);
};
cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.pos_QMARK_ = function cljs$core$pos_QMARK_(n) {
  return n > 0;
};
cljs.core.zero_QMARK_ = function cljs$core$zero_QMARK_(n) {
  return n === 0;
};
cljs.core.neg_QMARK_ = function cljs$core$neg_QMARK_(x) {
  return x < 0;
};
cljs.core.nthnext = function cljs$core$nthnext(coll, n) {
  var n__$1 = n;
  var xs = cljs.core.seq(coll);
  while (true) {
    if (xs && n__$1 > 0) {
      var G__16427 = n__$1 - 1;
      var G__16428 = cljs.core.next(xs);
      n__$1 = G__16427;
      xs = G__16428;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.str = function cljs$core$str() {
  var G__16432 = arguments.length;
  switch(G__16432) {
    case 0:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5328__auto__);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$0 = function() {
  return "";
};
cljs.core.str.cljs$core$IFn$_invoke$arity$1 = function(x) {
  if (x == null) {
    return "";
  } else {
    var G__16433 = x;
    return goog.string.buildString(G__16433);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = function(x, ys) {
  var sb = new goog.string.StringBuffer([cljs.core.str(x)].join(""));
  var more = ys;
  while (true) {
    if (cljs.core.truth_(more)) {
      var G__16435 = sb.append([cljs.core.str(cljs.core.first(more))].join(""));
      var G__16436 = cljs.core.next(more);
      sb = G__16435;
      more = G__16436;
      continue;
    } else {
      return sb.toString();
    }
    break;
  }
};
cljs.core.str.cljs$lang$applyTo = function(seq16429) {
  var G__16430 = cljs.core.first(seq16429);
  var seq16429__$1 = cljs.core.next(seq16429);
  return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__16430, seq16429__$1);
};
cljs.core.str.cljs$lang$maxFixedArity = 1;
cljs.core.subs = function cljs$core$subs() {
  var G__16438 = arguments.length;
  switch(G__16438) {
    case 2:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = function(s, start) {
  return s.substring(start);
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = function(s, start, end) {
  return s.substring(start, end);
};
cljs.core.subs.cljs$lang$maxFixedArity = 3;
cljs.core.equiv_sequential = function cljs$core$equiv_sequential(x, y) {
  return cljs.core.boolean$(cljs.core.sequential_QMARK_(y) ? cljs.core.counted_QMARK_(x) && cljs.core.counted_QMARK_(y) && !(cljs.core.count(x) === cljs.core.count(y)) ? false : function() {
    var xs = cljs.core.seq(x);
    var ys = cljs.core.seq(y);
    while (true) {
      if (xs == null) {
        return ys == null;
      } else {
        if (ys == null) {
          return false;
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs), cljs.core.first(ys))) {
            var G__16440 = cljs.core.next(xs);
            var G__16441 = cljs.core.next(ys);
            xs = G__16440;
            ys = G__16441;
            continue;
          } else {
            return false;
          }
        }
      }
      break;
    }
  }() : null);
};
cljs.core.hash_coll = function cljs$core$hash_coll(coll) {
  if (cljs.core.seq(coll)) {
    var res = cljs.core.hash(cljs.core.first(coll));
    var s = cljs.core.next(coll);
    while (true) {
      if (s == null) {
        return res;
      } else {
        var G__16442 = cljs.core.hash_combine(res, cljs.core.hash(cljs.core.first(s)));
        var G__16443 = cljs.core.next(s);
        res = G__16442;
        s = G__16443;
        continue;
      }
      break;
    }
  } else {
    return 0;
  }
};
cljs.core.hash_imap = function cljs$core$hash_imap(m) {
  var h = 0;
  var s = cljs.core.seq(m);
  while (true) {
    if (s) {
      var e = cljs.core.first(s);
      var G__16448 = (h + (cljs.core.hash(function() {
        var G__16446 = e;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__16446) : cljs.core.key.call(null, G__16446);
      }()) ^ cljs.core.hash(function() {
        var G__16447 = e;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__16447) : cljs.core.val.call(null, G__16447);
      }()))) % 4503599627370496;
      var G__16449 = cljs.core.next(s);
      h = G__16448;
      s = G__16449;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.hash_iset = function cljs$core$hash_iset(s) {
  var h = 0;
  var s__$1 = cljs.core.seq(s);
  while (true) {
    if (s__$1) {
      var e = cljs.core.first(s__$1);
      var G__16450 = (h + cljs.core.hash(e)) % 4503599627370496;
      var G__16451 = cljs.core.next(s__$1);
      h = G__16450;
      s__$1 = G__16451;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.extend_object_BANG_ = function cljs$core$extend_object_BANG_(obj, fn_map) {
  var seq__16462_16472 = cljs.core.seq(fn_map);
  var chunk__16463_16473 = null;
  var count__16464_16474 = 0;
  var i__16465_16475 = 0;
  while (true) {
    if (i__16465_16475 < count__16464_16474) {
      var vec__16466_16476 = chunk__16463_16473.cljs$core$IIndexed$_nth$arity$2(null, i__16465_16475);
      var key_name_16477 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16466_16476, 0, null);
      var f_16478 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16466_16476, 1, null);
      var str_name_16479 = function() {
        var G__16467 = key_name_16477;
        return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__16467) : cljs.core.name.call(null, G__16467);
      }();
      obj[str_name_16479] = f_16478;
      var G__16480 = seq__16462_16472;
      var G__16481 = chunk__16463_16473;
      var G__16482 = count__16464_16474;
      var G__16483 = i__16465_16475 + 1;
      seq__16462_16472 = G__16480;
      chunk__16463_16473 = G__16481;
      count__16464_16474 = G__16482;
      i__16465_16475 = G__16483;
      continue;
    } else {
      var temp__4126__auto___16484 = cljs.core.seq(seq__16462_16472);
      if (temp__4126__auto___16484) {
        var seq__16462_16485__$1 = temp__4126__auto___16484;
        if (cljs.core.chunked_seq_QMARK_(seq__16462_16485__$1)) {
          var c__5061__auto___16486 = function() {
            var G__16468 = seq__16462_16485__$1;
            return cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__16468) : cljs.core.chunk_first.call(null, G__16468);
          }();
          var G__16487 = function() {
            var G__16469 = seq__16462_16485__$1;
            return cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__16469) : cljs.core.chunk_rest.call(null, G__16469);
          }();
          var G__16488 = c__5061__auto___16486;
          var G__16489 = cljs.core.count(c__5061__auto___16486);
          var G__16490 = 0;
          seq__16462_16472 = G__16487;
          chunk__16463_16473 = G__16488;
          count__16464_16474 = G__16489;
          i__16465_16475 = G__16490;
          continue;
        } else {
          var vec__16470_16491 = cljs.core.first(seq__16462_16485__$1);
          var key_name_16492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16470_16491, 0, null);
          var f_16493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16470_16491, 1, null);
          var str_name_16494 = function() {
            var G__16471 = key_name_16492;
            return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__16471) : cljs.core.name.call(null, G__16471);
          }();
          obj[str_name_16494] = f_16493;
          var G__16495 = cljs.core.next(seq__16462_16485__$1);
          var G__16496 = null;
          var G__16497 = 0;
          var G__16498 = 0;
          seq__16462_16472 = G__16495;
          chunk__16463_16473 = G__16496;
          count__16464_16474 = G__16497;
          i__16465_16475 = G__16498;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return obj;
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65937646;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.List.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.List.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.List(self__.meta, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return null;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._rest(coll__$1);
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(meta__$1, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, coll__$1, self__.count + 1, null);
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";
cljs.core.List.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/List");
};
cljs.core.__GT_List = function cljs$core$__GT_List(meta, first, rest, count, __hash) {
  return new cljs.core.List(meta, first, rest, count, __hash);
};
cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 65937614;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.EmptyList.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.EmptyList.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.EmptyList(self__.meta);
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return 0;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.empty_ordered_hash;
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.EmptyList(meta__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, null, 1, null);
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";
cljs.core.EmptyList.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/EmptyList");
};
cljs.core.__GT_EmptyList = function cljs$core$__GT_EmptyList(meta) {
  return new cljs.core.EmptyList(meta);
};
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.reversible_QMARK_ = function cljs$core$reversible_QMARK_(coll) {
  var G__16500 = coll;
  if (G__16500) {
    var bit__4950__auto__ = G__16500.cljs$lang$protocol_mask$partition0$ & 134217728;
    if (bit__4950__auto__ || G__16500.cljs$core$IReversible$) {
      return true;
    } else {
      if (!G__16500.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, G__16500);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, G__16500);
  }
};
cljs.core.rseq = function cljs$core$rseq(coll) {
  return cljs.core._rseq(coll);
};
cljs.core.reverse = function cljs$core$reverse(coll) {
  if (cljs.core.reversible_QMARK_(coll)) {
    return cljs.core.rseq(coll);
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, coll);
  }
};
cljs.core.list = function cljs$core$list() {
  var argseq__5316__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
};
cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = function(xs) {
  var arr = xs instanceof cljs.core.IndexedSeq && xs.i === 0 ? xs.arr : function() {
    var arr = [];
    var xs__$1 = xs;
    while (true) {
      if (!(xs__$1 == null)) {
        arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));
        var G__16502 = xs__$1.cljs$core$INext$_next$arity$1(null);
        xs__$1 = G__16502;
        continue;
      } else {
        return arr;
      }
      break;
    }
  }();
  var i = arr.length;
  var r = cljs.core.List.EMPTY;
  while (true) {
    if (i > 0) {
      var G__16503 = i - 1;
      var G__16504 = r.cljs$core$ICollection$_conj$arity$2(null, arr[i - 1]);
      i = G__16503;
      r = G__16504;
      continue;
    } else {
      return r;
    }
    break;
  }
};
cljs.core.list.cljs$lang$maxFixedArity = 0;
cljs.core.list.cljs$lang$applyTo = function(seq16501) {
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16501));
};
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65929452;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Cons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Cons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Cons(self__.meta, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core.seq(self__.rest);
  }
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(meta__$1, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(null, o, coll__$1, self__.__hash);
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";
cljs.core.Cons.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/Cons");
};
cljs.core.__GT_Cons = function cljs$core$__GT_Cons(meta, first, rest, __hash) {
  return new cljs.core.Cons(meta, first, rest, __hash);
};
cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.cons = function cljs$core$cons(x, coll) {
  if (function() {
    var or__4276__auto__ = coll == null;
    if (or__4276__auto__) {
      return or__4276__auto__;
    } else {
      var G__16508 = coll;
      if (G__16508) {
        var bit__4943__auto__ = G__16508.cljs$lang$protocol_mask$partition0$ & 64;
        if (bit__4943__auto__ || G__16508.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null);
  } else {
    return new cljs.core.Cons(null, x, cljs.core.seq(coll), null);
  }
};
cljs.core.list_QMARK_ = function cljs$core$list_QMARK_(x) {
  var G__16510 = x;
  if (G__16510) {
    var bit__4950__auto__ = G__16510.cljs$lang$protocol_mask$partition0$ & 33554432;
    if (bit__4950__auto__ || G__16510.cljs$core$IList$) {
      return true;
    } else {
      if (!G__16510.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IList, G__16510);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IList, G__16510);
  }
};
cljs.core.hash_keyword = function cljs$core$hash_keyword(k) {
  return cljs.core.hash_symbol(k) + 2654435769 | 0;
};
cljs.core.compare_keywords = function cljs$core$compare_keywords(a, b) {
  if (a.fqn === b.fqn) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__4264__auto__ = cljs.core.not(a.ns);
      if (and__4264__auto__) {
        return b.ns;
      } else {
        return and__4264__auto__;
      }
    }())) {
      return-1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__16517 = a.ns;
            var G__16518 = b.ns;
            return goog.array.defaultCompare(G__16517, G__16518);
          }();
          if (0 === nsc) {
            var G__16519 = a.name;
            var G__16520 = b.name;
            return goog.array.defaultCompare(G__16519, G__16520);
          } else {
            return nsc;
          }
        }
      } else {
        var G__16521 = a.name;
        var G__16522 = b.name;
        return goog.array.defaultCompare(G__16521, G__16522);
      }
    }
  }
};
cljs.core.Keyword = function(ns, name, fqn, _hash) {
  this.ns = ns;
  this.name = name;
  this.fqn = fqn;
  this._hash = _hash;
  this.cljs$lang$protocol_mask$partition0$ = 2153775105;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, [cljs.core.str(":"), cljs.core.str(self__.fqn)].join(""));
};
cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var h__4692__auto__ = self__._hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_keyword(this$__$1);
    self__._hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.Keyword.prototype.call = function() {
  var G__16524 = null;
  var G__16524__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
  };
  var G__16524__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
  };
  G__16524 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__16524__2.call(this, self__, coll);
      case 3:
        return G__16524__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__16524.cljs$core$IFn$_invoke$arity$2 = G__16524__2;
  G__16524.cljs$core$IFn$_invoke$arity$3 = G__16524__3;
  return G__16524;
}();
cljs.core.Keyword.prototype.apply = function(self__, args16523) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args16523)));
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
};
cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Keyword) {
    return self__.fqn === other.fqn;
  } else {
    return false;
  }
};
cljs.core.Keyword.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return[cljs.core.str(":"), cljs.core.str(self__.fqn)].join("");
};
cljs.core.Keyword.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";
cljs.core.Keyword.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/Keyword");
};
cljs.core.__GT_Keyword = function cljs$core$__GT_Keyword(ns, name, fqn, _hash) {
  return new cljs.core.Keyword(ns, name, fqn, _hash);
};
cljs.core.keyword_QMARK_ = function cljs$core$keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword;
};
cljs.core.keyword_identical_QMARK_ = function cljs$core$keyword_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Keyword && y instanceof cljs.core.Keyword) {
      return x.fqn === y.fqn;
    } else {
      return false;
    }
  }
};
cljs.core.namespace = function cljs$core$namespace(x) {
  if (function() {
    var G__16526 = x;
    if (G__16526) {
      var bit__4943__auto__ = G__16526.cljs$lang$protocol_mask$partition1$ & 4096;
      if (bit__4943__auto__ || G__16526.cljs$core$INamed$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return x.cljs$core$INamed$_namespace$arity$1(null);
  } else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.keyword = function cljs$core$keyword() {
  var G__16528 = arguments.length;
  switch(G__16528) {
    case 1:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Keyword) {
    return name;
  } else {
    if (name instanceof cljs.core.Symbol) {
      return new cljs.core.Keyword(cljs.core.namespace(name), function() {
        var G__16529 = name;
        return cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__16529) : cljs.core.name.call(null, G__16529);
      }(), name.str, null);
    } else {
      if (typeof name === "string") {
        var parts = name.split("/");
        if (parts.length === 2) {
          return new cljs.core.Keyword(parts[0], parts[1], name, null);
        } else {
          return new cljs.core.Keyword(null, parts[0], name, null);
        }
      } else {
        return null;
      }
    }
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  return new cljs.core.Keyword(ns, name, [cljs.core.str(cljs.core.truth_(ns) ? [cljs.core.str(ns), cljs.core.str("/")].join("") : null), cljs.core.str(name)].join(""), null);
};
cljs.core.keyword.cljs$lang$maxFixedArity = 2;
cljs.core.LazySeq = function(meta, fn, s, __hash) {
  this.meta = meta;
  this.fn = fn;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
};
cljs.core.LazySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.LazySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.LazySeq.prototype.sval = function() {
  var self__ = this;
  var coll = this;
  if (self__.fn == null) {
    return self__.s;
  } else {
    self__.s = function() {
      return self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null);
    }();
    self__.fn = null;
    return self__.s;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.next(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  cljs.core._seq(coll__$1);
  if (!(self__.s == null)) {
    return cljs.core.rest(self__.s);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.sval();
  if (self__.s == null) {
    return null;
  } else {
    var ls = self__.s;
    while (true) {
      if (ls instanceof cljs.core.LazySeq) {
        var G__16531 = ls.sval();
        ls = G__16531;
        continue;
      } else {
        self__.s = ls;
        return cljs.core.seq(self__.s);
      }
      break;
    }
  }
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.LazySeq(meta__$1, self__.fn, self__.s, self__.__hash);
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";
cljs.core.LazySeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/LazySeq");
};
cljs.core.__GT_LazySeq = function cljs$core$__GT_LazySeq(meta, fn, s, __hash) {
  return new cljs.core.LazySeq(meta, fn, s, __hash);
};
cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2;
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end;
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var self__ = this;
  var _ = this;
  self__.buf[self__.end] = o;
  return self__.end = self__.end + 1;
};
cljs.core.ChunkBuffer.prototype.chunk = function(o) {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.ArrayChunk(self__.buf, 0, self__.end);
  self__.buf = null;
  return ret;
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";
cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ChunkBuffer");
};
cljs.core.__GT_ChunkBuffer = function cljs$core$__GT_ChunkBuffer(buf, end) {
  return new cljs.core.ChunkBuffer(buf, end);
};
cljs.core.chunk_buffer = function cljs$core$chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(new Array(capacity), 0);
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 524306;
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.off], self__.off + 1);
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.off);
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off === self__.end) {
    throw new Error("-drop-first of empty chunk");
  } else {
    return new cljs.core.ArrayChunk(self__.arr, self__.off + 1, self__.end);
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var self__ = this;
  var coll__$1 = this;
  return self__.arr[self__.off + i];
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (i >= 0 && i < self__.end - self__.off) {
    return self__.arr[self__.off + i];
  } else {
    return not_found;
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end - self__.off;
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";
cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ArrayChunk");
};
cljs.core.__GT_ArrayChunk = function cljs$core$__GT_ArrayChunk(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk = function cljs$core$array_chunk() {
  var G__16533 = arguments.length;
  switch(G__16533) {
    case 1:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = function(arr) {
  return new cljs.core.ArrayChunk(arr, 0, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = function(arr, off) {
  return new cljs.core.ArrayChunk(arr, off, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = function(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;
cljs.core.ChunkedCons = function(chunk, more, meta, __hash) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850732;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedCons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedCons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    var more__$1 = cljs.core._seq(self__.more);
    if (more__$1 == null) {
      return null;
    } else {
      return more__$1;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk, 0);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    if (self__.more == null) {
      return cljs.core.List.EMPTY;
    } else {
      return self__.more;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.chunk;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ChunkedCons(self__.chunk, self__.more, m, self__.__hash);
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, this$__$1);
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return null;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";
cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ChunkedCons");
};
cljs.core.__GT_ChunkedCons = function cljs$core$__GT_ChunkedCons(chunk, more, meta, __hash) {
  return new cljs.core.ChunkedCons(chunk, more, meta, __hash);
};
cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.chunk_cons = function cljs$core$chunk_cons(chunk, rest) {
  if (cljs.core._count(chunk) === 0) {
    return rest;
  } else {
    return new cljs.core.ChunkedCons(chunk, rest, null, null);
  }
};
cljs.core.chunk_append = function cljs$core$chunk_append(b, x) {
  return b.add(x);
};
cljs.core.chunk = function cljs$core$chunk(b) {
  return b.chunk();
};
cljs.core.chunk_first = function cljs$core$chunk_first(s) {
  return cljs.core._chunked_first(s);
};
cljs.core.chunk_rest = function cljs$core$chunk_rest(s) {
  return cljs.core._chunked_rest(s);
};
cljs.core.chunk_next = function cljs$core$chunk_next(s) {
  if (function() {
    var G__16536 = s;
    if (G__16536) {
      var bit__4943__auto__ = G__16536.cljs$lang$protocol_mask$partition1$ & 1024;
      if (bit__4943__auto__ || G__16536.cljs$core$IChunkedNext$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return cljs.core._chunked_next(s);
  } else {
    return cljs.core.seq(cljs.core._chunked_rest(s));
  }
};
cljs.core.to_array = function cljs$core$to_array(s) {
  var ary = [];
  var s__$1 = s;
  while (true) {
    if (cljs.core.seq(s__$1)) {
      ary.push(cljs.core.first(s__$1));
      var G__16537 = cljs.core.next(s__$1);
      s__$1 = G__16537;
      continue;
    } else {
      return ary;
    }
    break;
  }
};
cljs.core.to_array_2d = function cljs$core$to_array_2d(coll) {
  var ret = new Array(cljs.core.count(coll));
  var i_16538 = 0;
  var xs_16539 = cljs.core.seq(coll);
  while (true) {
    if (xs_16539) {
      ret[i_16538] = cljs.core.to_array(cljs.core.first(xs_16539));
      var G__16540 = i_16538 + 1;
      var G__16541 = cljs.core.next(xs_16539);
      i_16538 = G__16540;
      xs_16539 = G__16541;
      continue;
    } else {
    }
    break;
  }
  return ret;
};
cljs.core.int_array = function cljs$core$int_array() {
  var G__16543 = arguments.length;
  switch(G__16543) {
    case 1:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__16545 = i + 1;
        var G__16546 = cljs.core.next(s__$1);
        i = G__16545;
        s__$1 = G__16546;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5161__auto___16547 = size;
    var i_16548 = 0;
    while (true) {
      if (i_16548 < n__5161__auto___16547) {
        a[i_16548] = init_val_or_seq;
        var G__16549 = i_16548 + 1;
        i_16548 = G__16549;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.int_array.cljs$lang$maxFixedArity = 2;
cljs.core.long_array = function cljs$core$long_array() {
  var G__16551 = arguments.length;
  switch(G__16551) {
    case 1:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__16553 = i + 1;
        var G__16554 = cljs.core.next(s__$1);
        i = G__16553;
        s__$1 = G__16554;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5161__auto___16555 = size;
    var i_16556 = 0;
    while (true) {
      if (i_16556 < n__5161__auto___16555) {
        a[i_16556] = init_val_or_seq;
        var G__16557 = i_16556 + 1;
        i_16556 = G__16557;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.long_array.cljs$lang$maxFixedArity = 2;
cljs.core.double_array = function cljs$core$double_array() {
  var G__16559 = arguments.length;
  switch(G__16559) {
    case 1:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__16561 = i + 1;
        var G__16562 = cljs.core.next(s__$1);
        i = G__16561;
        s__$1 = G__16562;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5161__auto___16563 = size;
    var i_16564 = 0;
    while (true) {
      if (i_16564 < n__5161__auto___16563) {
        a[i_16564] = init_val_or_seq;
        var G__16565 = i_16564 + 1;
        i_16564 = G__16565;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.double_array.cljs$lang$maxFixedArity = 2;
cljs.core.object_array = function cljs$core$object_array() {
  var G__16567 = arguments.length;
  switch(G__16567) {
    case 1:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__16569 = i + 1;
        var G__16570 = cljs.core.next(s__$1);
        i = G__16569;
        s__$1 = G__16570;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__5161__auto___16571 = size;
    var i_16572 = 0;
    while (true) {
      if (i_16572 < n__5161__auto___16571) {
        a[i_16572] = init_val_or_seq;
        var G__16573 = i_16572 + 1;
        i_16572 = G__16573;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = function cljs$core$bounded_count(s, n) {
  if (cljs.core.counted_QMARK_(s)) {
    return cljs.core.count(s);
  } else {
    var s__$1 = s;
    var i = n;
    var sum = 0;
    while (true) {
      if (i > 0 && cljs.core.seq(s__$1)) {
        var G__16574 = cljs.core.next(s__$1);
        var G__16575 = i - 1;
        var G__16576 = sum + 1;
        s__$1 = G__16574;
        i = G__16575;
        sum = G__16576;
        continue;
      } else {
        return sum;
      }
      break;
    }
  }
};
cljs.core.spread = function cljs$core$spread(arglist) {
  if (arglist == null) {
    return null;
  } else {
    if (cljs.core.next(arglist) == null) {
      return cljs.core.seq(cljs.core.first(arglist));
    } else {
      return cljs.core.cons(cljs.core.first(arglist), cljs$core$spread(cljs.core.next(arglist)));
    }
  }
};
cljs.core.concat = function cljs$core$concat() {
  var G__16582 = arguments.length;
  switch(G__16582) {
    case 0:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = function() {
  return new cljs.core.LazySeq(null, function() {
    return null;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return x;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return new cljs.core.LazySeq(null, function() {
    var s = cljs.core.seq(x);
    if (s) {
      if (cljs.core.chunked_seq_QMARK_(s)) {
        return cljs.core.chunk_cons(cljs.core.chunk_first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s), y));
      } else {
        return cljs.core.cons(cljs.core.first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s), y));
      }
    } else {
      return y;
    }
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = function(x, y, zs) {
  var cat = function cljs$core$cat(xys, zs__$1) {
    return new cljs.core.LazySeq(null, function() {
      var xys__$1 = cljs.core.seq(xys);
      if (xys__$1) {
        if (cljs.core.chunked_seq_QMARK_(xys__$1)) {
          return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1), cljs$core$cat(cljs.core.chunk_rest(xys__$1), zs__$1));
        } else {
          return cljs.core.cons(cljs.core.first(xys__$1), cljs$core$cat(cljs.core.rest(xys__$1), zs__$1));
        }
      } else {
        if (cljs.core.truth_(zs__$1)) {
          return cljs$core$cat(cljs.core.first(zs__$1), cljs.core.next(zs__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x, y), zs);
};
cljs.core.concat.cljs$lang$applyTo = function(seq16578) {
  var G__16579 = cljs.core.first(seq16578);
  var seq16578__$1 = cljs.core.next(seq16578);
  var G__16580 = cljs.core.first(seq16578__$1);
  var seq16578__$2 = cljs.core.next(seq16578__$1);
  return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__16579, G__16580, seq16578__$2);
};
cljs.core.concat.cljs$lang$maxFixedArity = 2;
cljs.core.list_STAR_ = function cljs$core$list_STAR_() {
  var G__16596 = arguments.length;
  switch(G__16596) {
    case 1:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5328__auto__);
  }
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = function(args) {
  return cljs.core.seq(args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = function(a, args) {
  return cljs.core.cons(a, args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = function(a, b, args) {
  return cljs.core.cons(a, cljs.core.cons(b, args));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, args) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, args)));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = function(a, b, c, d, more) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(more)))));
};
cljs.core.list_STAR_.cljs$lang$applyTo = function(seq16590) {
  var G__16591 = cljs.core.first(seq16590);
  var seq16590__$1 = cljs.core.next(seq16590);
  var G__16592 = cljs.core.first(seq16590__$1);
  var seq16590__$2 = cljs.core.next(seq16590__$1);
  var G__16593 = cljs.core.first(seq16590__$2);
  var seq16590__$3 = cljs.core.next(seq16590__$2);
  var G__16594 = cljs.core.first(seq16590__$3);
  var seq16590__$4 = cljs.core.next(seq16590__$3);
  return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__16591, G__16592, G__16593, G__16594, seq16590__$4);
};
cljs.core.list_STAR_.cljs$lang$maxFixedArity = 4;
cljs.core.transient$ = function cljs$core$transient(coll) {
  return cljs.core._as_transient(coll);
};
cljs.core.persistent_BANG_ = function cljs$core$persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_(tcoll);
};
cljs.core.conj_BANG_ = function cljs$core$conj_BANG_() {
  var G__16602 = arguments.length;
  switch(G__16602) {
    case 0:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._conj_BANG_(tcoll, val);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._conj_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__16604 = ntcoll;
      var G__16605 = cljs.core.first(vals);
      var G__16606 = cljs.core.next(vals);
      tcoll = G__16604;
      val = G__16605;
      vals = G__16606;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.conj_BANG_.cljs$lang$applyTo = function(seq16598) {
  var G__16599 = cljs.core.first(seq16598);
  var seq16598__$1 = cljs.core.next(seq16598);
  var G__16600 = cljs.core.first(seq16598__$1);
  var seq16598__$2 = cljs.core.next(seq16598__$1);
  return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16599, G__16600, seq16598__$2);
};
cljs.core.conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.assoc_BANG_ = function cljs$core$assoc_BANG_() {
  var G__16612 = arguments.length;
  switch(G__16612) {
    case 3:
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5328__auto__);
  }
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = function(tcoll, key, val) {
  return cljs.core._assoc_BANG_(tcoll, key, val);
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, val, kvs) {
  while (true) {
    var ntcoll = cljs.core._assoc_BANG_(tcoll, key, val);
    if (cljs.core.truth_(kvs)) {
      var G__16614 = ntcoll;
      var G__16615 = cljs.core.first(kvs);
      var G__16616 = cljs.core.second(kvs);
      var G__16617 = cljs.core.nnext(kvs);
      tcoll = G__16614;
      key = G__16615;
      val = G__16616;
      kvs = G__16617;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.assoc_BANG_.cljs$lang$applyTo = function(seq16607) {
  var G__16608 = cljs.core.first(seq16607);
  var seq16607__$1 = cljs.core.next(seq16607);
  var G__16609 = cljs.core.first(seq16607__$1);
  var seq16607__$2 = cljs.core.next(seq16607__$1);
  var G__16610 = cljs.core.first(seq16607__$2);
  var seq16607__$3 = cljs.core.next(seq16607__$2);
  return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16608, G__16609, G__16610, seq16607__$3);
};
cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc_BANG_ = function cljs$core$dissoc_BANG_() {
  var G__16622 = arguments.length;
  switch(G__16622) {
    case 2:
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, key) {
  return cljs.core._dissoc_BANG_(tcoll, key);
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, ks) {
  while (true) {
    var ntcoll = cljs.core._dissoc_BANG_(tcoll, key);
    if (cljs.core.truth_(ks)) {
      var G__16624 = ntcoll;
      var G__16625 = cljs.core.first(ks);
      var G__16626 = cljs.core.next(ks);
      tcoll = G__16624;
      key = G__16625;
      ks = G__16626;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.dissoc_BANG_.cljs$lang$applyTo = function(seq16618) {
  var G__16619 = cljs.core.first(seq16618);
  var seq16618__$1 = cljs.core.next(seq16618);
  var G__16620 = cljs.core.first(seq16618__$1);
  var seq16618__$2 = cljs.core.next(seq16618__$1);
  return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16619, G__16620, seq16618__$2);
};
cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.pop_BANG_ = function cljs$core$pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_(tcoll);
};
cljs.core.disj_BANG_ = function cljs$core$disj_BANG_() {
  var G__16631 = arguments.length;
  switch(G__16631) {
    case 2:
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._disjoin_BANG_(tcoll, val);
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._disjoin_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__16633 = ntcoll;
      var G__16634 = cljs.core.first(vals);
      var G__16635 = cljs.core.next(vals);
      tcoll = G__16633;
      val = G__16634;
      vals = G__16635;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.disj_BANG_.cljs$lang$applyTo = function(seq16627) {
  var G__16628 = cljs.core.first(seq16627);
  var seq16627__$1 = cljs.core.next(seq16627);
  var G__16629 = cljs.core.first(seq16627__$1);
  var seq16627__$2 = cljs.core.next(seq16627__$1);
  return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16628, G__16629, seq16627__$2);
};
cljs.core.disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.apply_to = function cljs$core$apply_to(f, argc, args) {
  var args__$1 = cljs.core.seq(args);
  if (argc === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var a5205 = cljs.core._first(args__$1);
    var args__$2 = cljs.core._rest(args__$1);
    if (argc === 1) {
      if (f.cljs$core$IFn$_invoke$arity$1) {
        return f.cljs$core$IFn$_invoke$arity$1(a5205);
      } else {
        var G__16846 = a5205;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__16846) : f.call(null, G__16846);
      }
    } else {
      var b5206 = cljs.core._first(args__$2);
      var args__$3 = cljs.core._rest(args__$2);
      if (argc === 2) {
        if (f.cljs$core$IFn$_invoke$arity$2) {
          return f.cljs$core$IFn$_invoke$arity$2(a5205, b5206);
        } else {
          var G__16847 = a5205;
          var G__16848 = b5206;
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__16847, G__16848) : f.call(null, G__16847, G__16848);
        }
      } else {
        var c5207 = cljs.core._first(args__$3);
        var args__$4 = cljs.core._rest(args__$3);
        if (argc === 3) {
          if (f.cljs$core$IFn$_invoke$arity$3) {
            return f.cljs$core$IFn$_invoke$arity$3(a5205, b5206, c5207);
          } else {
            var G__16849 = a5205;
            var G__16850 = b5206;
            var G__16851 = c5207;
            return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__16849, G__16850, G__16851) : f.call(null, G__16849, G__16850, G__16851);
          }
        } else {
          var d5208 = cljs.core._first(args__$4);
          var args__$5 = cljs.core._rest(args__$4);
          if (argc === 4) {
            if (f.cljs$core$IFn$_invoke$arity$4) {
              return f.cljs$core$IFn$_invoke$arity$4(a5205, b5206, c5207, d5208);
            } else {
              var G__16852 = a5205;
              var G__16853 = b5206;
              var G__16854 = c5207;
              var G__16855 = d5208;
              return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__16852, G__16853, G__16854, G__16855) : f.call(null, G__16852, G__16853, G__16854, G__16855);
            }
          } else {
            var e5209 = cljs.core._first(args__$5);
            var args__$6 = cljs.core._rest(args__$5);
            if (argc === 5) {
              if (f.cljs$core$IFn$_invoke$arity$5) {
                return f.cljs$core$IFn$_invoke$arity$5(a5205, b5206, c5207, d5208, e5209);
              } else {
                var G__16856 = a5205;
                var G__16857 = b5206;
                var G__16858 = c5207;
                var G__16859 = d5208;
                var G__16860 = e5209;
                return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__16856, G__16857, G__16858, G__16859, G__16860) : f.call(null, G__16856, G__16857, G__16858, G__16859, G__16860);
              }
            } else {
              var f5210 = cljs.core._first(args__$6);
              var args__$7 = cljs.core._rest(args__$6);
              if (argc === 6) {
                if (f.cljs$core$IFn$_invoke$arity$6) {
                  return f.cljs$core$IFn$_invoke$arity$6(a5205, b5206, c5207, d5208, e5209, f5210);
                } else {
                  var G__16861 = a5205;
                  var G__16862 = b5206;
                  var G__16863 = c5207;
                  var G__16864 = d5208;
                  var G__16865 = e5209;
                  var G__16866 = f5210;
                  return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__16861, G__16862, G__16863, G__16864, G__16865, G__16866) : f.call(null, G__16861, G__16862, G__16863, G__16864, G__16865, G__16866);
                }
              } else {
                var g5211 = cljs.core._first(args__$7);
                var args__$8 = cljs.core._rest(args__$7);
                if (argc === 7) {
                  if (f.cljs$core$IFn$_invoke$arity$7) {
                    return f.cljs$core$IFn$_invoke$arity$7(a5205, b5206, c5207, d5208, e5209, f5210, g5211);
                  } else {
                    var G__16867 = a5205;
                    var G__16868 = b5206;
                    var G__16869 = c5207;
                    var G__16870 = d5208;
                    var G__16871 = e5209;
                    var G__16872 = f5210;
                    var G__16873 = g5211;
                    return f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__16867, G__16868, G__16869, G__16870, G__16871, G__16872, G__16873) : f.call(null, G__16867, G__16868, G__16869, G__16870, G__16871, G__16872, G__16873);
                  }
                } else {
                  var h5212 = cljs.core._first(args__$8);
                  var args__$9 = cljs.core._rest(args__$8);
                  if (argc === 8) {
                    if (f.cljs$core$IFn$_invoke$arity$8) {
                      return f.cljs$core$IFn$_invoke$arity$8(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212);
                    } else {
                      var G__16874 = a5205;
                      var G__16875 = b5206;
                      var G__16876 = c5207;
                      var G__16877 = d5208;
                      var G__16878 = e5209;
                      var G__16879 = f5210;
                      var G__16880 = g5211;
                      var G__16881 = h5212;
                      return f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__16874, G__16875, G__16876, G__16877, G__16878, G__16879, G__16880, G__16881) : f.call(null, G__16874, G__16875, G__16876, G__16877, G__16878, G__16879, G__16880, G__16881);
                    }
                  } else {
                    var i5213 = cljs.core._first(args__$9);
                    var args__$10 = cljs.core._rest(args__$9);
                    if (argc === 9) {
                      if (f.cljs$core$IFn$_invoke$arity$9) {
                        return f.cljs$core$IFn$_invoke$arity$9(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213);
                      } else {
                        var G__16882 = a5205;
                        var G__16883 = b5206;
                        var G__16884 = c5207;
                        var G__16885 = d5208;
                        var G__16886 = e5209;
                        var G__16887 = f5210;
                        var G__16888 = g5211;
                        var G__16889 = h5212;
                        var G__16890 = i5213;
                        return f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__16882, G__16883, G__16884, G__16885, G__16886, G__16887, G__16888, G__16889, G__16890) : f.call(null, G__16882, G__16883, G__16884, G__16885, G__16886, G__16887, G__16888, G__16889, G__16890);
                      }
                    } else {
                      var j5214 = cljs.core._first(args__$10);
                      var args__$11 = cljs.core._rest(args__$10);
                      if (argc === 10) {
                        if (f.cljs$core$IFn$_invoke$arity$10) {
                          return f.cljs$core$IFn$_invoke$arity$10(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213, j5214);
                        } else {
                          var G__16891 = a5205;
                          var G__16892 = b5206;
                          var G__16893 = c5207;
                          var G__16894 = d5208;
                          var G__16895 = e5209;
                          var G__16896 = f5210;
                          var G__16897 = g5211;
                          var G__16898 = h5212;
                          var G__16899 = i5213;
                          var G__16900 = j5214;
                          return f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__16891, G__16892, G__16893, G__16894, G__16895, G__16896, G__16897, G__16898, G__16899, G__16900) : f.call(null, G__16891, G__16892, G__16893, G__16894, G__16895, G__16896, G__16897, G__16898, G__16899, G__16900);
                        }
                      } else {
                        var k5215 = cljs.core._first(args__$11);
                        var args__$12 = cljs.core._rest(args__$11);
                        if (argc === 11) {
                          if (f.cljs$core$IFn$_invoke$arity$11) {
                            return f.cljs$core$IFn$_invoke$arity$11(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213, j5214, k5215);
                          } else {
                            var G__16901 = a5205;
                            var G__16902 = b5206;
                            var G__16903 = c5207;
                            var G__16904 = d5208;
                            var G__16905 = e5209;
                            var G__16906 = f5210;
                            var G__16907 = g5211;
                            var G__16908 = h5212;
                            var G__16909 = i5213;
                            var G__16910 = j5214;
                            var G__16911 = k5215;
                            return f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__16901, G__16902, G__16903, G__16904, G__16905, G__16906, G__16907, G__16908, G__16909, G__16910, G__16911) : f.call(null, G__16901, G__16902, G__16903, G__16904, G__16905, G__16906, G__16907, G__16908, G__16909, G__16910, G__16911);
                          }
                        } else {
                          var l5216 = cljs.core._first(args__$12);
                          var args__$13 = cljs.core._rest(args__$12);
                          if (argc === 12) {
                            if (f.cljs$core$IFn$_invoke$arity$12) {
                              return f.cljs$core$IFn$_invoke$arity$12(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213, j5214, k5215, l5216);
                            } else {
                              var G__16912 = a5205;
                              var G__16913 = b5206;
                              var G__16914 = c5207;
                              var G__16915 = d5208;
                              var G__16916 = e5209;
                              var G__16917 = f5210;
                              var G__16918 = g5211;
                              var G__16919 = h5212;
                              var G__16920 = i5213;
                              var G__16921 = j5214;
                              var G__16922 = k5215;
                              var G__16923 = l5216;
                              return f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__16912, G__16913, G__16914, G__16915, G__16916, G__16917, G__16918, G__16919, G__16920, G__16921, G__16922, G__16923) : f.call(null, G__16912, G__16913, G__16914, G__16915, G__16916, G__16917, G__16918, G__16919, G__16920, G__16921, G__16922, G__16923);
                            }
                          } else {
                            var m5217 = cljs.core._first(args__$13);
                            var args__$14 = cljs.core._rest(args__$13);
                            if (argc === 13) {
                              if (f.cljs$core$IFn$_invoke$arity$13) {
                                return f.cljs$core$IFn$_invoke$arity$13(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213, j5214, k5215, l5216, m5217);
                              } else {
                                var G__16924 = a5205;
                                var G__16925 = b5206;
                                var G__16926 = c5207;
                                var G__16927 = d5208;
                                var G__16928 = e5209;
                                var G__16929 = f5210;
                                var G__16930 = g5211;
                                var G__16931 = h5212;
                                var G__16932 = i5213;
                                var G__16933 = j5214;
                                var G__16934 = k5215;
                                var G__16935 = l5216;
                                var G__16936 = m5217;
                                return f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__16924, G__16925, G__16926, G__16927, G__16928, G__16929, G__16930, G__16931, G__16932, G__16933, G__16934, G__16935, G__16936) : f.call(null, G__16924, G__16925, G__16926, G__16927, G__16928, G__16929, G__16930, G__16931, G__16932, G__16933, G__16934, G__16935, G__16936);
                              }
                            } else {
                              var n5218 = cljs.core._first(args__$14);
                              var args__$15 = cljs.core._rest(args__$14);
                              if (argc === 14) {
                                if (f.cljs$core$IFn$_invoke$arity$14) {
                                  return f.cljs$core$IFn$_invoke$arity$14(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213, j5214, k5215, l5216, m5217, n5218);
                                } else {
                                  var G__16937 = a5205;
                                  var G__16938 = b5206;
                                  var G__16939 = c5207;
                                  var G__16940 = d5208;
                                  var G__16941 = e5209;
                                  var G__16942 = f5210;
                                  var G__16943 = g5211;
                                  var G__16944 = h5212;
                                  var G__16945 = i5213;
                                  var G__16946 = j5214;
                                  var G__16947 = k5215;
                                  var G__16948 = l5216;
                                  var G__16949 = m5217;
                                  var G__16950 = n5218;
                                  return f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__16937, G__16938, G__16939, G__16940, G__16941, G__16942, G__16943, G__16944, G__16945, G__16946, G__16947, G__16948, G__16949, G__16950) : f.call(null, G__16937, G__16938, G__16939, G__16940, G__16941, G__16942, G__16943, G__16944, G__16945, G__16946, G__16947, G__16948, G__16949, G__16950);
                                }
                              } else {
                                var o5219 = cljs.core._first(args__$15);
                                var args__$16 = cljs.core._rest(args__$15);
                                if (argc === 15) {
                                  if (f.cljs$core$IFn$_invoke$arity$15) {
                                    return f.cljs$core$IFn$_invoke$arity$15(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213, j5214, k5215, l5216, m5217, n5218, o5219);
                                  } else {
                                    var G__16951 = a5205;
                                    var G__16952 = b5206;
                                    var G__16953 = c5207;
                                    var G__16954 = d5208;
                                    var G__16955 = e5209;
                                    var G__16956 = f5210;
                                    var G__16957 = g5211;
                                    var G__16958 = h5212;
                                    var G__16959 = i5213;
                                    var G__16960 = j5214;
                                    var G__16961 = k5215;
                                    var G__16962 = l5216;
                                    var G__16963 = m5217;
                                    var G__16964 = n5218;
                                    var G__16965 = o5219;
                                    return f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__16951, G__16952, G__16953, G__16954, G__16955, G__16956, G__16957, G__16958, G__16959, G__16960, G__16961, G__16962, G__16963, G__16964, G__16965) : f.call(null, G__16951, G__16952, G__16953, G__16954, G__16955, G__16956, G__16957, G__16958, G__16959, G__16960, G__16961, G__16962, G__16963, G__16964, G__16965);
                                  }
                                } else {
                                  var p5220 = cljs.core._first(args__$16);
                                  var args__$17 = cljs.core._rest(args__$16);
                                  if (argc === 16) {
                                    if (f.cljs$core$IFn$_invoke$arity$16) {
                                      return f.cljs$core$IFn$_invoke$arity$16(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213, j5214, k5215, l5216, m5217, n5218, o5219, p5220);
                                    } else {
                                      var G__16966 = a5205;
                                      var G__16967 = b5206;
                                      var G__16968 = c5207;
                                      var G__16969 = d5208;
                                      var G__16970 = e5209;
                                      var G__16971 = f5210;
                                      var G__16972 = g5211;
                                      var G__16973 = h5212;
                                      var G__16974 = i5213;
                                      var G__16975 = j5214;
                                      var G__16976 = k5215;
                                      var G__16977 = l5216;
                                      var G__16978 = m5217;
                                      var G__16979 = n5218;
                                      var G__16980 = o5219;
                                      var G__16981 = p5220;
                                      return f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__16966, G__16967, G__16968, G__16969, G__16970, G__16971, G__16972, G__16973, G__16974, G__16975, G__16976, G__16977, G__16978, G__16979, G__16980, G__16981) : f.call(null, G__16966, G__16967, G__16968, G__16969, G__16970, G__16971, G__16972, G__16973, G__16974, G__16975, G__16976, G__16977, G__16978, G__16979, G__16980, G__16981);
                                    }
                                  } else {
                                    var q5221 = cljs.core._first(args__$17);
                                    var args__$18 = cljs.core._rest(args__$17);
                                    if (argc === 17) {
                                      if (f.cljs$core$IFn$_invoke$arity$17) {
                                        return f.cljs$core$IFn$_invoke$arity$17(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213, j5214, k5215, l5216, m5217, n5218, o5219, p5220, q5221);
                                      } else {
                                        var G__16982 = a5205;
                                        var G__16983 = b5206;
                                        var G__16984 = c5207;
                                        var G__16985 = d5208;
                                        var G__16986 = e5209;
                                        var G__16987 = f5210;
                                        var G__16988 = g5211;
                                        var G__16989 = h5212;
                                        var G__16990 = i5213;
                                        var G__16991 = j5214;
                                        var G__16992 = k5215;
                                        var G__16993 = l5216;
                                        var G__16994 = m5217;
                                        var G__16995 = n5218;
                                        var G__16996 = o5219;
                                        var G__16997 = p5220;
                                        var G__16998 = q5221;
                                        return f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__16982, G__16983, G__16984, G__16985, G__16986, G__16987, G__16988, G__16989, G__16990, G__16991, G__16992, G__16993, G__16994, G__16995, G__16996, G__16997, G__16998) : f.call(null, G__16982, G__16983, G__16984, G__16985, G__16986, G__16987, G__16988, G__16989, G__16990, G__16991, G__16992, G__16993, G__16994, G__16995, G__16996, G__16997, G__16998);
                                      }
                                    } else {
                                      var r5222 = cljs.core._first(args__$18);
                                      var args__$19 = cljs.core._rest(args__$18);
                                      if (argc === 18) {
                                        if (f.cljs$core$IFn$_invoke$arity$18) {
                                          return f.cljs$core$IFn$_invoke$arity$18(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213, j5214, k5215, l5216, m5217, n5218, o5219, p5220, q5221, r5222);
                                        } else {
                                          var G__16999 = a5205;
                                          var G__17000 = b5206;
                                          var G__17001 = c5207;
                                          var G__17002 = d5208;
                                          var G__17003 = e5209;
                                          var G__17004 = f5210;
                                          var G__17005 = g5211;
                                          var G__17006 = h5212;
                                          var G__17007 = i5213;
                                          var G__17008 = j5214;
                                          var G__17009 = k5215;
                                          var G__17010 = l5216;
                                          var G__17011 = m5217;
                                          var G__17012 = n5218;
                                          var G__17013 = o5219;
                                          var G__17014 = p5220;
                                          var G__17015 = q5221;
                                          var G__17016 = r5222;
                                          return f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__16999, G__17000, G__17001, G__17002, G__17003, G__17004, G__17005, G__17006, G__17007, G__17008, G__17009, G__17010, G__17011, G__17012, G__17013, G__17014, G__17015, G__17016) : f.call(null, G__16999, G__17000, G__17001, G__17002, G__17003, G__17004, G__17005, G__17006, G__17007, G__17008, G__17009, G__17010, G__17011, G__17012, G__17013, G__17014, G__17015, G__17016);
                                        }
                                      } else {
                                        var s5223 = cljs.core._first(args__$19);
                                        var args__$20 = cljs.core._rest(args__$19);
                                        if (argc === 19) {
                                          if (f.cljs$core$IFn$_invoke$arity$19) {
                                            return f.cljs$core$IFn$_invoke$arity$19(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213, j5214, k5215, l5216, m5217, n5218, o5219, p5220, q5221, r5222, s5223);
                                          } else {
                                            var G__17017 = a5205;
                                            var G__17018 = b5206;
                                            var G__17019 = c5207;
                                            var G__17020 = d5208;
                                            var G__17021 = e5209;
                                            var G__17022 = f5210;
                                            var G__17023 = g5211;
                                            var G__17024 = h5212;
                                            var G__17025 = i5213;
                                            var G__17026 = j5214;
                                            var G__17027 = k5215;
                                            var G__17028 = l5216;
                                            var G__17029 = m5217;
                                            var G__17030 = n5218;
                                            var G__17031 = o5219;
                                            var G__17032 = p5220;
                                            var G__17033 = q5221;
                                            var G__17034 = r5222;
                                            var G__17035 = s5223;
                                            return f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__17017, G__17018, G__17019, G__17020, G__17021, G__17022, G__17023, G__17024, G__17025, G__17026, G__17027, G__17028, G__17029, G__17030, G__17031, G__17032, G__17033, G__17034, G__17035) : f.call(null, G__17017, G__17018, G__17019, G__17020, G__17021, G__17022, G__17023, G__17024, G__17025, G__17026, G__17027, G__17028, G__17029, G__17030, G__17031, G__17032, G__17033, G__17034, 
                                            G__17035);
                                          }
                                        } else {
                                          var t5224 = cljs.core._first(args__$20);
                                          var args__$21 = cljs.core._rest(args__$20);
                                          if (argc === 20) {
                                            if (f.cljs$core$IFn$_invoke$arity$20) {
                                              return f.cljs$core$IFn$_invoke$arity$20(a5205, b5206, c5207, d5208, e5209, f5210, g5211, h5212, i5213, j5214, k5215, l5216, m5217, n5218, o5219, p5220, q5221, r5222, s5223, t5224);
                                            } else {
                                              var G__17036 = a5205;
                                              var G__17037 = b5206;
                                              var G__17038 = c5207;
                                              var G__17039 = d5208;
                                              var G__17040 = e5209;
                                              var G__17041 = f5210;
                                              var G__17042 = g5211;
                                              var G__17043 = h5212;
                                              var G__17044 = i5213;
                                              var G__17045 = j5214;
                                              var G__17046 = k5215;
                                              var G__17047 = l5216;
                                              var G__17048 = m5217;
                                              var G__17049 = n5218;
                                              var G__17050 = o5219;
                                              var G__17051 = p5220;
                                              var G__17052 = q5221;
                                              var G__17053 = r5222;
                                              var G__17054 = s5223;
                                              var G__17055 = t5224;
                                              return f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__17036, G__17037, G__17038, G__17039, G__17040, G__17041, G__17042, G__17043, G__17044, G__17045, G__17046, G__17047, G__17048, G__17049, G__17050, G__17051, G__17052, G__17053, G__17054, G__17055) : f.call(null, G__17036, G__17037, G__17038, G__17039, G__17040, G__17041, G__17042, G__17043, G__17044, G__17045, G__17046, G__17047, G__17048, G__17049, G__17050, G__17051, G__17052, 
                                              G__17053, G__17054, G__17055);
                                            }
                                          } else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply = function cljs$core$apply() {
  var G__17063 = arguments.length;
  switch(G__17063) {
    case 2:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 5), 0);
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], argseq__5328__auto__);
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = function(f, args) {
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(args, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, args);
    } else {
      return f.cljs$lang$applyTo(args);
    }
  } else {
    return f.apply(f, cljs.core.to_array(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = function(f, x, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x, y, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = function(f, x, y, z, args) {
  var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x, y, z, args);
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = function(f, a, b, c, d, args) {
  var arglist = cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(args)))));
  var fixed_arity = f.cljs$lang$maxFixedArity;
  if (f.cljs$lang$applyTo) {
    var bc = cljs.core.bounded_count(arglist, fixed_arity + 1);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return f.apply(f, cljs.core.to_array(arglist));
  }
};
cljs.core.apply.cljs$lang$applyTo = function(seq17056) {
  var G__17057 = cljs.core.first(seq17056);
  var seq17056__$1 = cljs.core.next(seq17056);
  var G__17058 = cljs.core.first(seq17056__$1);
  var seq17056__$2 = cljs.core.next(seq17056__$1);
  var G__17059 = cljs.core.first(seq17056__$2);
  var seq17056__$3 = cljs.core.next(seq17056__$2);
  var G__17060 = cljs.core.first(seq17056__$3);
  var seq17056__$4 = cljs.core.next(seq17056__$3);
  var G__17061 = cljs.core.first(seq17056__$4);
  var seq17056__$5 = cljs.core.next(seq17056__$4);
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__17057, G__17058, G__17059, G__17060, G__17061, seq17056__$5);
};
cljs.core.apply.cljs$lang$maxFixedArity = 5;
cljs.core.vary_meta = function cljs$core$vary_meta() {
  var G__17073 = arguments.length;
  switch(G__17073) {
    case 2:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5328__auto__);
  }
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = function(obj, f) {
  return cljs.core.with_meta(obj, function() {
    var G__17074 = cljs.core.meta(obj);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17074) : f.call(null, G__17074);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = function(obj, f, a) {
  return cljs.core.with_meta(obj, function() {
    var G__17075 = cljs.core.meta(obj);
    var G__17076 = a;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17075, G__17076) : f.call(null, G__17075, G__17076);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = function(obj, f, a, b) {
  return cljs.core.with_meta(obj, function() {
    var G__17077 = cljs.core.meta(obj);
    var G__17078 = a;
    var G__17079 = b;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17077, G__17078, G__17079) : f.call(null, G__17077, G__17078, G__17079);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = function(obj, f, a, b, c) {
  return cljs.core.with_meta(obj, function() {
    var G__17080 = cljs.core.meta(obj);
    var G__17081 = a;
    var G__17082 = b;
    var G__17083 = c;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17080, G__17081, G__17082, G__17083) : f.call(null, G__17080, G__17081, G__17082, G__17083);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = function(obj, f, a, b, c, d) {
  return cljs.core.with_meta(obj, function() {
    var G__17084 = cljs.core.meta(obj);
    var G__17085 = a;
    var G__17086 = b;
    var G__17087 = c;
    var G__17088 = d;
    return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__17084, G__17085, G__17086, G__17087, G__17088) : f.call(null, G__17084, G__17085, G__17086, G__17087, G__17088);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = function(obj, f, a, b, c, d, args) {
  return cljs.core.with_meta(obj, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.meta(obj), a, b, c, cljs.core.array_seq([d, args], 0)));
};
cljs.core.vary_meta.cljs$lang$applyTo = function(seq17065) {
  var G__17066 = cljs.core.first(seq17065);
  var seq17065__$1 = cljs.core.next(seq17065);
  var G__17067 = cljs.core.first(seq17065__$1);
  var seq17065__$2 = cljs.core.next(seq17065__$1);
  var G__17068 = cljs.core.first(seq17065__$2);
  var seq17065__$3 = cljs.core.next(seq17065__$2);
  var G__17069 = cljs.core.first(seq17065__$3);
  var seq17065__$4 = cljs.core.next(seq17065__$3);
  var G__17070 = cljs.core.first(seq17065__$4);
  var seq17065__$5 = cljs.core.next(seq17065__$4);
  var G__17071 = cljs.core.first(seq17065__$5);
  var seq17065__$6 = cljs.core.next(seq17065__$5);
  return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__17066, G__17067, G__17068, G__17069, G__17070, G__17071, seq17065__$6);
};
cljs.core.vary_meta.cljs$lang$maxFixedArity = 6;
cljs.core.not_EQ_ = function cljs$core$not_EQ_() {
  var G__17094 = arguments.length;
  switch(G__17094) {
    case 1:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return false;
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_, x, y, more));
};
cljs.core.not_EQ_.cljs$lang$applyTo = function(seq17090) {
  var G__17091 = cljs.core.first(seq17090);
  var seq17090__$1 = cljs.core.next(seq17090);
  var G__17092 = cljs.core.first(seq17090__$1);
  var seq17090__$2 = cljs.core.next(seq17090__$1);
  return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__17091, G__17092, seq17090__$2);
};
cljs.core.not_EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.not_empty = function cljs$core$not_empty(coll) {
  if (cljs.core.seq(coll)) {
    return coll;
  } else {
    return null;
  }
};
cljs.core.nil_iter = function cljs$core$nil_iter() {
  if (typeof cljs.core.t17099 !== "undefined") {
  } else {
    cljs.core.t17099 = function(nil_iter, meta17100) {
      this.nil_iter = nil_iter;
      this.meta17100 = meta17100;
      this.cljs$lang$protocol_mask$partition1$ = 0;
      this.cljs$lang$protocol_mask$partition0$ = 393216;
    };
    cljs.core.t17099.prototype.hasNext = function() {
      var self__ = this;
      var _ = this;
      return false;
    };
    cljs.core.t17099.prototype.next = function() {
      var self__ = this;
      var _ = this;
      return new Error("No such element");
    };
    cljs.core.t17099.prototype.remove = function() {
      var self__ = this;
      var _ = this;
      return new Error("Unsupported operation");
    };
    cljs.core.t17099.prototype.cljs$core$IMeta$_meta$arity$1 = function(_17101) {
      var self__ = this;
      var _17101__$1 = this;
      return self__.meta17100;
    };
    cljs.core.t17099.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_17101, meta17100__$1) {
      var self__ = this;
      var _17101__$1 = this;
      return new cljs.core.t17099(self__.nil_iter, meta17100__$1);
    };
    cljs.core.t17099.cljs$lang$type = true;
    cljs.core.t17099.cljs$lang$ctorStr = "cljs.core/t17099";
    cljs.core.t17099.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
      return cljs.core._write(writer__4856__auto__, "cljs.core/t17099");
    };
    cljs.core.__GT_t17099 = function cljs$core$nil_iter_$___GT_t17099(nil_iter__$1, meta17100) {
      return new cljs.core.t17099(nil_iter__$1, meta17100);
    };
  }
  return new cljs.core.t17099(cljs$core$nil_iter, cljs.core.PersistentArrayMap.EMPTY);
};
cljs.core.StringIter = function(s, i) {
  this.s = s;
  this.i = i;
};
cljs.core.StringIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.s.length;
};
cljs.core.StringIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.s.charAt(self__.i);
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.StringIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.StringIter.cljs$lang$type = true;
cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";
cljs.core.StringIter.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/StringIter");
};
cljs.core.__GT_StringIter = function cljs$core$__GT_StringIter(s, i) {
  return new cljs.core.StringIter(s, i);
};
cljs.core.string_iter = function cljs$core$string_iter(x) {
  return new cljs.core.StringIter(x, 0);
};
cljs.core.ArrayIter = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.ArrayIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.ArrayIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.ArrayIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayIter.cljs$lang$type = true;
cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";
cljs.core.ArrayIter.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ArrayIter");
};
cljs.core.__GT_ArrayIter = function cljs$core$__GT_ArrayIter(arr, i) {
  return new cljs.core.ArrayIter(arr, i);
};
cljs.core.array_iter = function cljs$core$array_iter(x) {
  return new cljs.core.ArrayIter(x, 0);
};
cljs.core.INIT = {};
cljs.core.START = {};
cljs.core.SeqIter = function(_seq, _next) {
  this._seq = _seq;
  this._next = _next;
};
cljs.core.SeqIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__._seq === cljs.core.INIT) {
    self__._seq = cljs.core.START;
    self__._next = cljs.core.seq(self__._next);
  } else {
    if (self__._seq === self__._next) {
      self__._next = cljs.core.next(self__._seq);
    } else {
    }
  }
  return!(self__._next == null);
};
cljs.core.SeqIter.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (cljs.core.not(this$.hasNext())) {
    throw new Error("No such element");
  } else {
    self__._seq = self__._next;
    return cljs.core.first(self__._next);
  }
};
cljs.core.SeqIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.SeqIter.cljs$lang$type = true;
cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";
cljs.core.SeqIter.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/SeqIter");
};
cljs.core.__GT_SeqIter = function cljs$core$__GT_SeqIter(_seq, _next) {
  return new cljs.core.SeqIter(_seq, _next);
};
cljs.core.seq_iter = function cljs$core$seq_iter(coll) {
  return new cljs.core.SeqIter(cljs.core.INIT, coll);
};
cljs.core.iter = function cljs$core$iter(coll) {
  if (coll == null) {
    return cljs.core.nil_iter();
  } else {
    if (typeof coll === "string") {
      return cljs.core.string_iter(coll);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return cljs.core.array_iter(coll);
      } else {
        if (cljs.core.truth_(cljs.core.iterable_QMARK_(coll))) {
          return cljs.core._iterator(coll);
        } else {
          if (cljs.core.seqable_QMARK_(coll)) {
            return cljs.core.seq_iter(coll);
          } else {
            throw new Error([cljs.core.str("Cannot create iterator from "), cljs.core.str(coll)].join(""));
          }
        }
      }
    }
  }
};
cljs.core.lazy_transformer = function cljs$core$lazy_transformer(stepper) {
  return new cljs.core.LazyTransformer(stepper, null, null, null);
};
cljs.core.Stepper = function(xform, iter) {
  this.xform = xform;
  this.iter = iter;
};
cljs.core.Stepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__4264__auto__ = !(lt.stepper == null);
      if (and__4264__auto__) {
        return self__.iter.hasNext();
      } else {
        return and__4264__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(function() {
        var G__17102 = lt;
        var G__17103 = self__.iter.next();
        return self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__17102, G__17103) : self__.xform.call(null, G__17102, G__17103);
      }())) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    var G__17104 = lt;
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__17104) : self__.xform.call(null, G__17104);
  }
};
cljs.core.Stepper.cljs$lang$type = true;
cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";
cljs.core.Stepper.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/Stepper");
};
cljs.core.__GT_Stepper = function cljs$core$__GT_Stepper(xform, iter) {
  return new cljs.core.Stepper(xform, iter);
};
cljs.core.stepper = function cljs$core$stepper(xform, iter) {
  var stepfn = function() {
    var cljs$core$stepper_$_stepfn = null;
    var cljs$core$stepper_$_stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return result;
    };
    var cljs$core$stepper_$_stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepper_$_stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepper_$_stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepper_$_stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
    cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
    return cljs$core$stepper_$_stepfn;
  }();
  return new cljs.core.Stepper(function() {
    var G__17106 = stepfn;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__17106) : xform.call(null, G__17106);
  }(), iter);
};
cljs.core.MultiStepper = function(xform, iters, nexts) {
  this.xform = xform;
  this.iters = iters;
  this.nexts = nexts;
};
cljs.core.MultiStepper.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var iters__$1 = cljs.core.seq(self__.iters);
  while (true) {
    if (!(iters__$1 == null)) {
      var iter = cljs.core.first(iters__$1);
      if (cljs.core.not(iter.hasNext())) {
        return false;
      } else {
        var G__17108 = cljs.core.next(iters__$1);
        iters__$1 = G__17108;
        continue;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.MultiStepper.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var n__5161__auto___17109 = self__.iters.length;
  var i_17110 = 0;
  while (true) {
    if (i_17110 < n__5161__auto___17109) {
      self__.nexts[i_17110] = self__.iters[i_17110].next();
      var G__17111 = i_17110 + 1;
      i_17110 = G__17111;
      continue;
    } else {
    }
    break;
  }
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts, 0);
};
cljs.core.MultiStepper.prototype.step = function(lt) {
  var self__ = this;
  var this$ = this;
  while (true) {
    if (cljs.core.truth_(function() {
      var and__4264__auto__ = !(lt.stepper == null);
      if (and__4264__auto__) {
        return this$.hasNext();
      } else {
        return and__4264__auto__;
      }
    }())) {
      if (cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform, cljs.core.cons(lt, this$.next())))) {
        if (lt.rest == null) {
        } else {
          lt.rest.stepper = null;
        }
      } else {
        continue;
      }
    } else {
    }
    break;
  }
  if (lt.stepper == null) {
    return null;
  } else {
    var G__17107 = lt;
    return self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__17107) : self__.xform.call(null, G__17107);
  }
};
cljs.core.MultiStepper.cljs$lang$type = true;
cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";
cljs.core.MultiStepper.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/MultiStepper");
};
cljs.core.__GT_MultiStepper = function cljs$core$__GT_MultiStepper(xform, iters, nexts) {
  return new cljs.core.MultiStepper(xform, iters, nexts);
};
cljs.core.multi_stepper = function cljs$core$multi_stepper() {
  var G__17113 = arguments.length;
  switch(G__17113) {
    case 2:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = function(xform, iters) {
  return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length));
};
cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = function(xform, iters, nexts) {
  var stepfn = function() {
    var cljs$core$stepfn = null;
    var cljs$core$stepfn__1 = function(result) {
      var lt = cljs.core.reduced_QMARK_(result) ? cljs.core.deref(result) : result;
      lt.stepper = null;
      return lt;
    };
    var cljs$core$stepfn__2 = function(result, input) {
      var lt = result;
      lt.first = input;
      lt.rest = cljs.core.lazy_transformer(lt.stepper);
      lt.stepper = null;
      return lt.rest;
    };
    cljs$core$stepfn = function(result, input) {
      switch(arguments.length) {
        case 1:
          return cljs$core$stepfn__1.call(this, result);
        case 2:
          return cljs$core$stepfn__2.call(this, result, input);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
    cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
    return cljs$core$stepfn;
  }();
  return new cljs.core.MultiStepper(function() {
    var G__17114 = stepfn;
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__17114) : xform.call(null, G__17114);
  }(), iters, nexts);
};
cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;
cljs.core.LazyTransformer = function(stepper, first, rest, meta) {
  this.stepper = stepper;
  this.first = first;
  this.rest = rest;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31719628;
};
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core._seq(self__.rest);
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return self__.first;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    cljs.core._seq(this$__$1);
  }
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.stepper == null) {
  } else {
    self__.stepper.step(this$__$1);
  }
  if (self__.rest == null) {
    return null;
  } else {
    return this$__$1;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.hash_ordered_coll(this$__$1);
};
cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  var s = cljs.core._seq(this$__$1);
  if (!(s == null)) {
    return cljs.core.equiv_sequential(this$__$1, other);
  } else {
    return cljs.core.sequential_QMARK_(other) && cljs.core.seq(other) == null;
  }
};
cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, cljs.core._seq(this$__$1));
};
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(this$, new_meta) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.LazyTransformer(self__.stepper, self__.first, self__.rest, new_meta);
};
cljs.core.LazyTransformer.cljs$lang$type = true;
cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";
cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/LazyTransformer");
};
cljs.core.__GT_LazyTransformer = function cljs$core$__GT_LazyTransformer(stepper, first, rest, meta) {
  return new cljs.core.LazyTransformer(stepper, first, rest, meta);
};
cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.LazyTransformer.create = function(xform, coll) {
  return new cljs.core.LazyTransformer(cljs.core.stepper(xform, cljs.core.iter(coll)), null, null, null);
};
cljs.core.LazyTransformer.createMulti = function(xform, colls) {
  var iters = [];
  var seq__17116_17120 = cljs.core.seq(colls);
  var chunk__17117_17121 = null;
  var count__17118_17122 = 0;
  var i__17119_17123 = 0;
  while (true) {
    if (i__17119_17123 < count__17118_17122) {
      var coll_17124 = chunk__17117_17121.cljs$core$IIndexed$_nth$arity$2(null, i__17119_17123);
      iters.push(cljs.core.iter(coll_17124));
      var G__17125 = seq__17116_17120;
      var G__17126 = chunk__17117_17121;
      var G__17127 = count__17118_17122;
      var G__17128 = i__17119_17123 + 1;
      seq__17116_17120 = G__17125;
      chunk__17117_17121 = G__17126;
      count__17118_17122 = G__17127;
      i__17119_17123 = G__17128;
      continue;
    } else {
      var temp__4126__auto___17129 = cljs.core.seq(seq__17116_17120);
      if (temp__4126__auto___17129) {
        var seq__17116_17130__$1 = temp__4126__auto___17129;
        if (cljs.core.chunked_seq_QMARK_(seq__17116_17130__$1)) {
          var c__5061__auto___17131 = cljs.core.chunk_first(seq__17116_17130__$1);
          var G__17132 = cljs.core.chunk_rest(seq__17116_17130__$1);
          var G__17133 = c__5061__auto___17131;
          var G__17134 = cljs.core.count(c__5061__auto___17131);
          var G__17135 = 0;
          seq__17116_17120 = G__17132;
          chunk__17117_17121 = G__17133;
          count__17118_17122 = G__17134;
          i__17119_17123 = G__17135;
          continue;
        } else {
          var coll_17136 = cljs.core.first(seq__17116_17130__$1);
          iters.push(cljs.core.iter(coll_17136));
          var G__17137 = cljs.core.next(seq__17116_17130__$1);
          var G__17138 = null;
          var G__17139 = 0;
          var G__17140 = 0;
          seq__17116_17120 = G__17137;
          chunk__17117_17121 = G__17138;
          count__17118_17122 = G__17139;
          i__17119_17123 = G__17140;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform, iters, new Array(iters.length)), null, null, null);
};
cljs.core.sequence = function cljs$core$sequence() {
  var G__17145 = arguments.length;
  switch(G__17145) {
    case 1:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  if (cljs.core.seq_QMARK_(coll)) {
    return coll;
  } else {
    var or__4276__auto__ = cljs.core.seq(coll);
    if (or__4276__auto__) {
      return or__4276__auto__;
    } else {
      return cljs.core.List.EMPTY;
    }
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = function(xform, coll) {
  return cljs.core.LazyTransformer.create(xform, coll);
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = function(xform, coll, colls) {
  return cljs.core.LazyTransformer.createMulti(xform, cljs.core.to_array(cljs.core.cons(coll, colls)));
};
cljs.core.sequence.cljs$lang$applyTo = function(seq17141) {
  var G__17142 = cljs.core.first(seq17141);
  var seq17141__$1 = cljs.core.next(seq17141);
  var G__17143 = cljs.core.first(seq17141__$1);
  var seq17141__$2 = cljs.core.next(seq17141__$1);
  return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__17142, G__17143, seq17141__$2);
};
cljs.core.sequence.cljs$lang$maxFixedArity = 2;
cljs.core.every_QMARK_ = function cljs$core$every_QMARK_(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll) == null) {
      return true;
    } else {
      if (cljs.core.truth_(function() {
        var G__17148 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17148) : pred.call(null, G__17148);
      }())) {
        var G__17149 = pred;
        var G__17150 = cljs.core.next(coll);
        pred = G__17149;
        coll = G__17150;
        continue;
      } else {
        return false;
      }
    }
    break;
  }
};
cljs.core.not_every_QMARK_ = function cljs$core$not_every_QMARK_(pred, coll) {
  return!cljs.core.every_QMARK_(pred, coll);
};
cljs.core.some = function cljs$core$some(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll)) {
      var or__4276__auto__ = function() {
        var G__17154 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17154) : pred.call(null, G__17154);
      }();
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        var G__17155 = pred;
        var G__17156 = cljs.core.next(coll);
        pred = G__17155;
        coll = G__17156;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.not_any_QMARK_ = function cljs$core$not_any_QMARK_(pred, coll) {
  return cljs.core.not(cljs.core.some(pred, coll));
};
cljs.core.even_QMARK_ = function cljs$core$even_QMARK_(n) {
  if (cljs.core.integer_QMARK_(n)) {
    return(n & 1) === 0;
  } else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function cljs$core$odd_QMARK_(n) {
  return!cljs.core.even_QMARK_(n);
};
cljs.core.complement = function cljs$core$complement(f) {
  return function() {
    var G__17163 = null;
    var G__17163__0 = function() {
      return cljs.core.not(function() {
        return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
      }());
    };
    var G__17163__1 = function(x) {
      return cljs.core.not(function() {
        var G__17160 = x;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17160) : f.call(null, G__17160);
      }());
    };
    var G__17163__2 = function(x, y) {
      return cljs.core.not(function() {
        var G__17161 = x;
        var G__17162 = y;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17161, G__17162) : f.call(null, G__17161, G__17162);
      }());
    };
    var G__17163__3 = function() {
      var G__17164__delegate = function(x, y, zs) {
        return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f, x, y, zs));
      };
      var G__17164 = function(x, y, var_args) {
        var zs = null;
        if (arguments.length > 2) {
          var G__17165__i = 0, G__17165__a = new Array(arguments.length - 2);
          while (G__17165__i < G__17165__a.length) {
            G__17165__a[G__17165__i] = arguments[G__17165__i + 2];
            ++G__17165__i;
          }
          zs = new cljs.core.IndexedSeq(G__17165__a, 0);
        }
        return G__17164__delegate.call(this, x, y, zs);
      };
      G__17164.cljs$lang$maxFixedArity = 2;
      G__17164.cljs$lang$applyTo = function(arglist__17166) {
        var x = cljs.core.first(arglist__17166);
        arglist__17166 = cljs.core.next(arglist__17166);
        var y = cljs.core.first(arglist__17166);
        var zs = cljs.core.rest(arglist__17166);
        return G__17164__delegate(x, y, zs);
      };
      G__17164.cljs$core$IFn$_invoke$arity$variadic = G__17164__delegate;
      return G__17164;
    }();
    G__17163 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__17163__0.call(this);
        case 1:
          return G__17163__1.call(this, x);
        case 2:
          return G__17163__2.call(this, x, y);
        default:
          var G__17167 = null;
          if (arguments.length > 2) {
            var G__17168__i = 0, G__17168__a = new Array(arguments.length - 2);
            while (G__17168__i < G__17168__a.length) {
              G__17168__a[G__17168__i] = arguments[G__17168__i + 2];
              ++G__17168__i;
            }
            G__17167 = new cljs.core.IndexedSeq(G__17168__a, 0);
          }
          return G__17163__3.cljs$core$IFn$_invoke$arity$variadic(x, y, G__17167);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17163.cljs$lang$maxFixedArity = 2;
    G__17163.cljs$lang$applyTo = G__17163__3.cljs$lang$applyTo;
    G__17163.cljs$core$IFn$_invoke$arity$0 = G__17163__0;
    G__17163.cljs$core$IFn$_invoke$arity$1 = G__17163__1;
    G__17163.cljs$core$IFn$_invoke$arity$2 = G__17163__2;
    G__17163.cljs$core$IFn$_invoke$arity$variadic = G__17163__3.cljs$core$IFn$_invoke$arity$variadic;
    return G__17163;
  }();
};
cljs.core.constantly = function cljs$core$constantly(x) {
  return function() {
    var G__17169__delegate = function(args) {
      return x;
    };
    var G__17169 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__17170__i = 0, G__17170__a = new Array(arguments.length - 0);
        while (G__17170__i < G__17170__a.length) {
          G__17170__a[G__17170__i] = arguments[G__17170__i + 0];
          ++G__17170__i;
        }
        args = new cljs.core.IndexedSeq(G__17170__a, 0);
      }
      return G__17169__delegate.call(this, args);
    };
    G__17169.cljs$lang$maxFixedArity = 0;
    G__17169.cljs$lang$applyTo = function(arglist__17171) {
      var args = cljs.core.seq(arglist__17171);
      return G__17169__delegate(args);
    };
    G__17169.cljs$core$IFn$_invoke$arity$variadic = G__17169__delegate;
    return G__17169;
  }();
};
cljs.core.comp = function cljs$core$comp() {
  var G__17177 = arguments.length;
  switch(G__17177) {
    case 0:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5328__auto__);
  }
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.identity;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = function(f, g) {
  return function() {
    var G__17206 = null;
    var G__17206__0 = function() {
      var G__17178 = function() {
        return g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17178) : f.call(null, G__17178);
    };
    var G__17206__1 = function(x) {
      var G__17179 = function() {
        var G__17180 = x;
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17180) : g.call(null, G__17180);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17179) : f.call(null, G__17179);
    };
    var G__17206__2 = function(x, y) {
      var G__17181 = function() {
        var G__17182 = x;
        var G__17183 = y;
        return g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__17182, G__17183) : g.call(null, G__17182, G__17183);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17181) : f.call(null, G__17181);
    };
    var G__17206__3 = function(x, y, z) {
      var G__17184 = function() {
        var G__17185 = x;
        var G__17186 = y;
        var G__17187 = z;
        return g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__17185, G__17186, G__17187) : g.call(null, G__17185, G__17186, G__17187);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17184) : f.call(null, G__17184);
    };
    var G__17206__4 = function() {
      var G__17207__delegate = function(x, y, z, args) {
        var G__17188 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g, x, y, z, args);
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17188) : f.call(null, G__17188);
      };
      var G__17207 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17208__i = 0, G__17208__a = new Array(arguments.length - 3);
          while (G__17208__i < G__17208__a.length) {
            G__17208__a[G__17208__i] = arguments[G__17208__i + 3];
            ++G__17208__i;
          }
          args = new cljs.core.IndexedSeq(G__17208__a, 0);
        }
        return G__17207__delegate.call(this, x, y, z, args);
      };
      G__17207.cljs$lang$maxFixedArity = 3;
      G__17207.cljs$lang$applyTo = function(arglist__17209) {
        var x = cljs.core.first(arglist__17209);
        arglist__17209 = cljs.core.next(arglist__17209);
        var y = cljs.core.first(arglist__17209);
        arglist__17209 = cljs.core.next(arglist__17209);
        var z = cljs.core.first(arglist__17209);
        var args = cljs.core.rest(arglist__17209);
        return G__17207__delegate(x, y, z, args);
      };
      G__17207.cljs$core$IFn$_invoke$arity$variadic = G__17207__delegate;
      return G__17207;
    }();
    G__17206 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__17206__0.call(this);
        case 1:
          return G__17206__1.call(this, x);
        case 2:
          return G__17206__2.call(this, x, y);
        case 3:
          return G__17206__3.call(this, x, y, z);
        default:
          var G__17210 = null;
          if (arguments.length > 3) {
            var G__17211__i = 0, G__17211__a = new Array(arguments.length - 3);
            while (G__17211__i < G__17211__a.length) {
              G__17211__a[G__17211__i] = arguments[G__17211__i + 3];
              ++G__17211__i;
            }
            G__17210 = new cljs.core.IndexedSeq(G__17211__a, 0);
          }
          return G__17206__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17210);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17206.cljs$lang$maxFixedArity = 3;
    G__17206.cljs$lang$applyTo = G__17206__4.cljs$lang$applyTo;
    G__17206.cljs$core$IFn$_invoke$arity$0 = G__17206__0;
    G__17206.cljs$core$IFn$_invoke$arity$1 = G__17206__1;
    G__17206.cljs$core$IFn$_invoke$arity$2 = G__17206__2;
    G__17206.cljs$core$IFn$_invoke$arity$3 = G__17206__3;
    G__17206.cljs$core$IFn$_invoke$arity$variadic = G__17206__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17206;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = function(f, g, h) {
  return function() {
    var G__17212 = null;
    var G__17212__0 = function() {
      var G__17189 = function() {
        var G__17190 = function() {
          return h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17190) : g.call(null, G__17190);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17189) : f.call(null, G__17189);
    };
    var G__17212__1 = function(x) {
      var G__17191 = function() {
        var G__17192 = function() {
          var G__17193 = x;
          return h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__17193) : h.call(null, G__17193);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17192) : g.call(null, G__17192);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17191) : f.call(null, G__17191);
    };
    var G__17212__2 = function(x, y) {
      var G__17194 = function() {
        var G__17195 = function() {
          var G__17196 = x;
          var G__17197 = y;
          return h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__17196, G__17197) : h.call(null, G__17196, G__17197);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17195) : g.call(null, G__17195);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17194) : f.call(null, G__17194);
    };
    var G__17212__3 = function(x, y, z) {
      var G__17198 = function() {
        var G__17199 = function() {
          var G__17200 = x;
          var G__17201 = y;
          var G__17202 = z;
          return h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__17200, G__17201, G__17202) : h.call(null, G__17200, G__17201, G__17202);
        }();
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17199) : g.call(null, G__17199);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17198) : f.call(null, G__17198);
    };
    var G__17212__4 = function() {
      var G__17213__delegate = function(x, y, z, args) {
        var G__17203 = function() {
          var G__17204 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h, x, y, z, args);
          return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__17204) : g.call(null, G__17204);
        }();
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17203) : f.call(null, G__17203);
      };
      var G__17213 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17214__i = 0, G__17214__a = new Array(arguments.length - 3);
          while (G__17214__i < G__17214__a.length) {
            G__17214__a[G__17214__i] = arguments[G__17214__i + 3];
            ++G__17214__i;
          }
          args = new cljs.core.IndexedSeq(G__17214__a, 0);
        }
        return G__17213__delegate.call(this, x, y, z, args);
      };
      G__17213.cljs$lang$maxFixedArity = 3;
      G__17213.cljs$lang$applyTo = function(arglist__17215) {
        var x = cljs.core.first(arglist__17215);
        arglist__17215 = cljs.core.next(arglist__17215);
        var y = cljs.core.first(arglist__17215);
        arglist__17215 = cljs.core.next(arglist__17215);
        var z = cljs.core.first(arglist__17215);
        var args = cljs.core.rest(arglist__17215);
        return G__17213__delegate(x, y, z, args);
      };
      G__17213.cljs$core$IFn$_invoke$arity$variadic = G__17213__delegate;
      return G__17213;
    }();
    G__17212 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__17212__0.call(this);
        case 1:
          return G__17212__1.call(this, x);
        case 2:
          return G__17212__2.call(this, x, y);
        case 3:
          return G__17212__3.call(this, x, y, z);
        default:
          var G__17216 = null;
          if (arguments.length > 3) {
            var G__17217__i = 0, G__17217__a = new Array(arguments.length - 3);
            while (G__17217__i < G__17217__a.length) {
              G__17217__a[G__17217__i] = arguments[G__17217__i + 3];
              ++G__17217__i;
            }
            G__17216 = new cljs.core.IndexedSeq(G__17217__a, 0);
          }
          return G__17212__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17216);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17212.cljs$lang$maxFixedArity = 3;
    G__17212.cljs$lang$applyTo = G__17212__4.cljs$lang$applyTo;
    G__17212.cljs$core$IFn$_invoke$arity$0 = G__17212__0;
    G__17212.cljs$core$IFn$_invoke$arity$1 = G__17212__1;
    G__17212.cljs$core$IFn$_invoke$arity$2 = G__17212__2;
    G__17212.cljs$core$IFn$_invoke$arity$3 = G__17212__3;
    G__17212.cljs$core$IFn$_invoke$arity$variadic = G__17212__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17212;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = function(f1, f2, f3, fs) {
  var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1, f2, f3, fs));
  return function(fs__$1) {
    return function() {
      var G__17218__delegate = function(args) {
        var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1), args);
        var fs__$2 = cljs.core.next(fs__$1);
        while (true) {
          if (fs__$2) {
            var G__17219 = cljs.core.first(fs__$2).call(null, ret);
            var G__17220 = cljs.core.next(fs__$2);
            ret = G__17219;
            fs__$2 = G__17220;
            continue;
          } else {
            return ret;
          }
          break;
        }
      };
      var G__17218 = function(var_args) {
        var args = null;
        if (arguments.length > 0) {
          var G__17221__i = 0, G__17221__a = new Array(arguments.length - 0);
          while (G__17221__i < G__17221__a.length) {
            G__17221__a[G__17221__i] = arguments[G__17221__i + 0];
            ++G__17221__i;
          }
          args = new cljs.core.IndexedSeq(G__17221__a, 0);
        }
        return G__17218__delegate.call(this, args);
      };
      G__17218.cljs$lang$maxFixedArity = 0;
      G__17218.cljs$lang$applyTo = function(arglist__17222) {
        var args = cljs.core.seq(arglist__17222);
        return G__17218__delegate(args);
      };
      G__17218.cljs$core$IFn$_invoke$arity$variadic = G__17218__delegate;
      return G__17218;
    }();
  }(fs__$1);
};
cljs.core.comp.cljs$lang$applyTo = function(seq17172) {
  var G__17173 = cljs.core.first(seq17172);
  var seq17172__$1 = cljs.core.next(seq17172);
  var G__17174 = cljs.core.first(seq17172__$1);
  var seq17172__$2 = cljs.core.next(seq17172__$1);
  var G__17175 = cljs.core.first(seq17172__$2);
  var seq17172__$3 = cljs.core.next(seq17172__$2);
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__17173, G__17174, G__17175, seq17172__$3);
};
cljs.core.comp.cljs$lang$maxFixedArity = 3;
cljs.core.partial = function cljs$core$partial() {
  var G__17229 = arguments.length;
  switch(G__17229) {
    case 1:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5328__auto__);
  }
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = function(f, arg1) {
  return function() {
    var G__17273 = null;
    var G__17273__0 = function() {
      var G__17230 = arg1;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17230) : f.call(null, G__17230);
    };
    var G__17273__1 = function(x) {
      var G__17231 = arg1;
      var G__17232 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17231, G__17232) : f.call(null, G__17231, G__17232);
    };
    var G__17273__2 = function(x, y) {
      var G__17233 = arg1;
      var G__17234 = x;
      var G__17235 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17233, G__17234, G__17235) : f.call(null, G__17233, G__17234, G__17235);
    };
    var G__17273__3 = function(x, y, z) {
      var G__17236 = arg1;
      var G__17237 = x;
      var G__17238 = y;
      var G__17239 = z;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17236, G__17237, G__17238, G__17239) : f.call(null, G__17236, G__17237, G__17238, G__17239);
    };
    var G__17273__4 = function() {
      var G__17274__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, x, y, z, cljs.core.array_seq([args], 0));
      };
      var G__17274 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17275__i = 0, G__17275__a = new Array(arguments.length - 3);
          while (G__17275__i < G__17275__a.length) {
            G__17275__a[G__17275__i] = arguments[G__17275__i + 3];
            ++G__17275__i;
          }
          args = new cljs.core.IndexedSeq(G__17275__a, 0);
        }
        return G__17274__delegate.call(this, x, y, z, args);
      };
      G__17274.cljs$lang$maxFixedArity = 3;
      G__17274.cljs$lang$applyTo = function(arglist__17276) {
        var x = cljs.core.first(arglist__17276);
        arglist__17276 = cljs.core.next(arglist__17276);
        var y = cljs.core.first(arglist__17276);
        arglist__17276 = cljs.core.next(arglist__17276);
        var z = cljs.core.first(arglist__17276);
        var args = cljs.core.rest(arglist__17276);
        return G__17274__delegate(x, y, z, args);
      };
      G__17274.cljs$core$IFn$_invoke$arity$variadic = G__17274__delegate;
      return G__17274;
    }();
    G__17273 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__17273__0.call(this);
        case 1:
          return G__17273__1.call(this, x);
        case 2:
          return G__17273__2.call(this, x, y);
        case 3:
          return G__17273__3.call(this, x, y, z);
        default:
          var G__17277 = null;
          if (arguments.length > 3) {
            var G__17278__i = 0, G__17278__a = new Array(arguments.length - 3);
            while (G__17278__i < G__17278__a.length) {
              G__17278__a[G__17278__i] = arguments[G__17278__i + 3];
              ++G__17278__i;
            }
            G__17277 = new cljs.core.IndexedSeq(G__17278__a, 0);
          }
          return G__17273__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17277);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17273.cljs$lang$maxFixedArity = 3;
    G__17273.cljs$lang$applyTo = G__17273__4.cljs$lang$applyTo;
    G__17273.cljs$core$IFn$_invoke$arity$0 = G__17273__0;
    G__17273.cljs$core$IFn$_invoke$arity$1 = G__17273__1;
    G__17273.cljs$core$IFn$_invoke$arity$2 = G__17273__2;
    G__17273.cljs$core$IFn$_invoke$arity$3 = G__17273__3;
    G__17273.cljs$core$IFn$_invoke$arity$variadic = G__17273__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17273;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = function(f, arg1, arg2) {
  return function() {
    var G__17279 = null;
    var G__17279__0 = function() {
      var G__17240 = arg1;
      var G__17241 = arg2;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17240, G__17241) : f.call(null, G__17240, G__17241);
    };
    var G__17279__1 = function(x) {
      var G__17242 = arg1;
      var G__17243 = arg2;
      var G__17244 = x;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17242, G__17243, G__17244) : f.call(null, G__17242, G__17243, G__17244);
    };
    var G__17279__2 = function(x, y) {
      var G__17245 = arg1;
      var G__17246 = arg2;
      var G__17247 = x;
      var G__17248 = y;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17245, G__17246, G__17247, G__17248) : f.call(null, G__17245, G__17246, G__17247, G__17248);
    };
    var G__17279__3 = function(x, y, z) {
      var G__17249 = arg1;
      var G__17250 = arg2;
      var G__17251 = x;
      var G__17252 = y;
      var G__17253 = z;
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__17249, G__17250, G__17251, G__17252, G__17253) : f.call(null, G__17249, G__17250, G__17251, G__17252, G__17253);
    };
    var G__17279__4 = function() {
      var G__17280__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, x, y, cljs.core.array_seq([z, args], 0));
      };
      var G__17280 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17281__i = 0, G__17281__a = new Array(arguments.length - 3);
          while (G__17281__i < G__17281__a.length) {
            G__17281__a[G__17281__i] = arguments[G__17281__i + 3];
            ++G__17281__i;
          }
          args = new cljs.core.IndexedSeq(G__17281__a, 0);
        }
        return G__17280__delegate.call(this, x, y, z, args);
      };
      G__17280.cljs$lang$maxFixedArity = 3;
      G__17280.cljs$lang$applyTo = function(arglist__17282) {
        var x = cljs.core.first(arglist__17282);
        arglist__17282 = cljs.core.next(arglist__17282);
        var y = cljs.core.first(arglist__17282);
        arglist__17282 = cljs.core.next(arglist__17282);
        var z = cljs.core.first(arglist__17282);
        var args = cljs.core.rest(arglist__17282);
        return G__17280__delegate(x, y, z, args);
      };
      G__17280.cljs$core$IFn$_invoke$arity$variadic = G__17280__delegate;
      return G__17280;
    }();
    G__17279 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__17279__0.call(this);
        case 1:
          return G__17279__1.call(this, x);
        case 2:
          return G__17279__2.call(this, x, y);
        case 3:
          return G__17279__3.call(this, x, y, z);
        default:
          var G__17283 = null;
          if (arguments.length > 3) {
            var G__17284__i = 0, G__17284__a = new Array(arguments.length - 3);
            while (G__17284__i < G__17284__a.length) {
              G__17284__a[G__17284__i] = arguments[G__17284__i + 3];
              ++G__17284__i;
            }
            G__17283 = new cljs.core.IndexedSeq(G__17284__a, 0);
          }
          return G__17279__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17283);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17279.cljs$lang$maxFixedArity = 3;
    G__17279.cljs$lang$applyTo = G__17279__4.cljs$lang$applyTo;
    G__17279.cljs$core$IFn$_invoke$arity$0 = G__17279__0;
    G__17279.cljs$core$IFn$_invoke$arity$1 = G__17279__1;
    G__17279.cljs$core$IFn$_invoke$arity$2 = G__17279__2;
    G__17279.cljs$core$IFn$_invoke$arity$3 = G__17279__3;
    G__17279.cljs$core$IFn$_invoke$arity$variadic = G__17279__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17279;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = function(f, arg1, arg2, arg3) {
  return function() {
    var G__17285 = null;
    var G__17285__0 = function() {
      var G__17254 = arg1;
      var G__17255 = arg2;
      var G__17256 = arg3;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17254, G__17255, G__17256) : f.call(null, G__17254, G__17255, G__17256);
    };
    var G__17285__1 = function(x) {
      var G__17257 = arg1;
      var G__17258 = arg2;
      var G__17259 = arg3;
      var G__17260 = x;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17257, G__17258, G__17259, G__17260) : f.call(null, G__17257, G__17258, G__17259, G__17260);
    };
    var G__17285__2 = function(x, y) {
      var G__17261 = arg1;
      var G__17262 = arg2;
      var G__17263 = arg3;
      var G__17264 = x;
      var G__17265 = y;
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__17261, G__17262, G__17263, G__17264, G__17265) : f.call(null, G__17261, G__17262, G__17263, G__17264, G__17265);
    };
    var G__17285__3 = function(x, y, z) {
      var G__17266 = arg1;
      var G__17267 = arg2;
      var G__17268 = arg3;
      var G__17269 = x;
      var G__17270 = y;
      var G__17271 = z;
      return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__17266, G__17267, G__17268, G__17269, G__17270, G__17271) : f.call(null, G__17266, G__17267, G__17268, G__17269, G__17270, G__17271);
    };
    var G__17285__4 = function() {
      var G__17286__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, arg3, x, cljs.core.array_seq([y, z, args], 0));
      };
      var G__17286 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17287__i = 0, G__17287__a = new Array(arguments.length - 3);
          while (G__17287__i < G__17287__a.length) {
            G__17287__a[G__17287__i] = arguments[G__17287__i + 3];
            ++G__17287__i;
          }
          args = new cljs.core.IndexedSeq(G__17287__a, 0);
        }
        return G__17286__delegate.call(this, x, y, z, args);
      };
      G__17286.cljs$lang$maxFixedArity = 3;
      G__17286.cljs$lang$applyTo = function(arglist__17288) {
        var x = cljs.core.first(arglist__17288);
        arglist__17288 = cljs.core.next(arglist__17288);
        var y = cljs.core.first(arglist__17288);
        arglist__17288 = cljs.core.next(arglist__17288);
        var z = cljs.core.first(arglist__17288);
        var args = cljs.core.rest(arglist__17288);
        return G__17286__delegate(x, y, z, args);
      };
      G__17286.cljs$core$IFn$_invoke$arity$variadic = G__17286__delegate;
      return G__17286;
    }();
    G__17285 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__17285__0.call(this);
        case 1:
          return G__17285__1.call(this, x);
        case 2:
          return G__17285__2.call(this, x, y);
        case 3:
          return G__17285__3.call(this, x, y, z);
        default:
          var G__17289 = null;
          if (arguments.length > 3) {
            var G__17290__i = 0, G__17290__a = new Array(arguments.length - 3);
            while (G__17290__i < G__17290__a.length) {
              G__17290__a[G__17290__i] = arguments[G__17290__i + 3];
              ++G__17290__i;
            }
            G__17289 = new cljs.core.IndexedSeq(G__17290__a, 0);
          }
          return G__17285__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17289);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17285.cljs$lang$maxFixedArity = 3;
    G__17285.cljs$lang$applyTo = G__17285__4.cljs$lang$applyTo;
    G__17285.cljs$core$IFn$_invoke$arity$0 = G__17285__0;
    G__17285.cljs$core$IFn$_invoke$arity$1 = G__17285__1;
    G__17285.cljs$core$IFn$_invoke$arity$2 = G__17285__2;
    G__17285.cljs$core$IFn$_invoke$arity$3 = G__17285__3;
    G__17285.cljs$core$IFn$_invoke$arity$variadic = G__17285__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17285;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = function(f, arg1, arg2, arg3, more) {
  return function() {
    var G__17291__delegate = function(args) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, arg1, arg2, arg3, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more, args));
    };
    var G__17291 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__17292__i = 0, G__17292__a = new Array(arguments.length - 0);
        while (G__17292__i < G__17292__a.length) {
          G__17292__a[G__17292__i] = arguments[G__17292__i + 0];
          ++G__17292__i;
        }
        args = new cljs.core.IndexedSeq(G__17292__a, 0);
      }
      return G__17291__delegate.call(this, args);
    };
    G__17291.cljs$lang$maxFixedArity = 0;
    G__17291.cljs$lang$applyTo = function(arglist__17293) {
      var args = cljs.core.seq(arglist__17293);
      return G__17291__delegate(args);
    };
    G__17291.cljs$core$IFn$_invoke$arity$variadic = G__17291__delegate;
    return G__17291;
  }();
};
cljs.core.partial.cljs$lang$applyTo = function(seq17223) {
  var G__17224 = cljs.core.first(seq17223);
  var seq17223__$1 = cljs.core.next(seq17223);
  var G__17225 = cljs.core.first(seq17223__$1);
  var seq17223__$2 = cljs.core.next(seq17223__$1);
  var G__17226 = cljs.core.first(seq17223__$2);
  var seq17223__$3 = cljs.core.next(seq17223__$2);
  var G__17227 = cljs.core.first(seq17223__$3);
  var seq17223__$4 = cljs.core.next(seq17223__$3);
  return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__17224, G__17225, G__17226, G__17227, seq17223__$4);
};
cljs.core.partial.cljs$lang$maxFixedArity = 4;
cljs.core.fnil = function cljs$core$fnil() {
  var G__17295 = arguments.length;
  switch(G__17295) {
    case 2:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = function(f, x) {
  return function() {
    var G__17313 = null;
    var G__17313__1 = function(a) {
      var G__17296 = a == null ? x : a;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17296) : f.call(null, G__17296);
    };
    var G__17313__2 = function(a, b) {
      var G__17297 = a == null ? x : a;
      var G__17298 = b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17297, G__17298) : f.call(null, G__17297, G__17298);
    };
    var G__17313__3 = function(a, b, c) {
      var G__17299 = a == null ? x : a;
      var G__17300 = b;
      var G__17301 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17299, G__17300, G__17301) : f.call(null, G__17299, G__17300, G__17301);
    };
    var G__17313__4 = function() {
      var G__17314__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b, c, ds);
      };
      var G__17314 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__17315__i = 0, G__17315__a = new Array(arguments.length - 3);
          while (G__17315__i < G__17315__a.length) {
            G__17315__a[G__17315__i] = arguments[G__17315__i + 3];
            ++G__17315__i;
          }
          ds = new cljs.core.IndexedSeq(G__17315__a, 0);
        }
        return G__17314__delegate.call(this, a, b, c, ds);
      };
      G__17314.cljs$lang$maxFixedArity = 3;
      G__17314.cljs$lang$applyTo = function(arglist__17316) {
        var a = cljs.core.first(arglist__17316);
        arglist__17316 = cljs.core.next(arglist__17316);
        var b = cljs.core.first(arglist__17316);
        arglist__17316 = cljs.core.next(arglist__17316);
        var c = cljs.core.first(arglist__17316);
        var ds = cljs.core.rest(arglist__17316);
        return G__17314__delegate(a, b, c, ds);
      };
      G__17314.cljs$core$IFn$_invoke$arity$variadic = G__17314__delegate;
      return G__17314;
    }();
    G__17313 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 1:
          return G__17313__1.call(this, a);
        case 2:
          return G__17313__2.call(this, a, b);
        case 3:
          return G__17313__3.call(this, a, b, c);
        default:
          var G__17317 = null;
          if (arguments.length > 3) {
            var G__17318__i = 0, G__17318__a = new Array(arguments.length - 3);
            while (G__17318__i < G__17318__a.length) {
              G__17318__a[G__17318__i] = arguments[G__17318__i + 3];
              ++G__17318__i;
            }
            G__17317 = new cljs.core.IndexedSeq(G__17318__a, 0);
          }
          return G__17313__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__17317);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17313.cljs$lang$maxFixedArity = 3;
    G__17313.cljs$lang$applyTo = G__17313__4.cljs$lang$applyTo;
    G__17313.cljs$core$IFn$_invoke$arity$1 = G__17313__1;
    G__17313.cljs$core$IFn$_invoke$arity$2 = G__17313__2;
    G__17313.cljs$core$IFn$_invoke$arity$3 = G__17313__3;
    G__17313.cljs$core$IFn$_invoke$arity$variadic = G__17313__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17313;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = function(f, x, y) {
  return function() {
    var G__17319 = null;
    var G__17319__2 = function(a, b) {
      var G__17302 = a == null ? x : a;
      var G__17303 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17302, G__17303) : f.call(null, G__17302, G__17303);
    };
    var G__17319__3 = function(a, b, c) {
      var G__17304 = a == null ? x : a;
      var G__17305 = b == null ? y : b;
      var G__17306 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17304, G__17305, G__17306) : f.call(null, G__17304, G__17305, G__17306);
    };
    var G__17319__4 = function() {
      var G__17320__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c, ds);
      };
      var G__17320 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__17321__i = 0, G__17321__a = new Array(arguments.length - 3);
          while (G__17321__i < G__17321__a.length) {
            G__17321__a[G__17321__i] = arguments[G__17321__i + 3];
            ++G__17321__i;
          }
          ds = new cljs.core.IndexedSeq(G__17321__a, 0);
        }
        return G__17320__delegate.call(this, a, b, c, ds);
      };
      G__17320.cljs$lang$maxFixedArity = 3;
      G__17320.cljs$lang$applyTo = function(arglist__17322) {
        var a = cljs.core.first(arglist__17322);
        arglist__17322 = cljs.core.next(arglist__17322);
        var b = cljs.core.first(arglist__17322);
        arglist__17322 = cljs.core.next(arglist__17322);
        var c = cljs.core.first(arglist__17322);
        var ds = cljs.core.rest(arglist__17322);
        return G__17320__delegate(a, b, c, ds);
      };
      G__17320.cljs$core$IFn$_invoke$arity$variadic = G__17320__delegate;
      return G__17320;
    }();
    G__17319 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__17319__2.call(this, a, b);
        case 3:
          return G__17319__3.call(this, a, b, c);
        default:
          var G__17323 = null;
          if (arguments.length > 3) {
            var G__17324__i = 0, G__17324__a = new Array(arguments.length - 3);
            while (G__17324__i < G__17324__a.length) {
              G__17324__a[G__17324__i] = arguments[G__17324__i + 3];
              ++G__17324__i;
            }
            G__17323 = new cljs.core.IndexedSeq(G__17324__a, 0);
          }
          return G__17319__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__17323);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17319.cljs$lang$maxFixedArity = 3;
    G__17319.cljs$lang$applyTo = G__17319__4.cljs$lang$applyTo;
    G__17319.cljs$core$IFn$_invoke$arity$2 = G__17319__2;
    G__17319.cljs$core$IFn$_invoke$arity$3 = G__17319__3;
    G__17319.cljs$core$IFn$_invoke$arity$variadic = G__17319__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17319;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, z) {
  return function() {
    var G__17325 = null;
    var G__17325__2 = function(a, b) {
      var G__17307 = a == null ? x : a;
      var G__17308 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17307, G__17308) : f.call(null, G__17307, G__17308);
    };
    var G__17325__3 = function(a, b, c) {
      var G__17309 = a == null ? x : a;
      var G__17310 = b == null ? y : b;
      var G__17311 = c == null ? z : c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17309, G__17310, G__17311) : f.call(null, G__17309, G__17310, G__17311);
    };
    var G__17325__4 = function() {
      var G__17326__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds);
      };
      var G__17326 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__17327__i = 0, G__17327__a = new Array(arguments.length - 3);
          while (G__17327__i < G__17327__a.length) {
            G__17327__a[G__17327__i] = arguments[G__17327__i + 3];
            ++G__17327__i;
          }
          ds = new cljs.core.IndexedSeq(G__17327__a, 0);
        }
        return G__17326__delegate.call(this, a, b, c, ds);
      };
      G__17326.cljs$lang$maxFixedArity = 3;
      G__17326.cljs$lang$applyTo = function(arglist__17328) {
        var a = cljs.core.first(arglist__17328);
        arglist__17328 = cljs.core.next(arglist__17328);
        var b = cljs.core.first(arglist__17328);
        arglist__17328 = cljs.core.next(arglist__17328);
        var c = cljs.core.first(arglist__17328);
        var ds = cljs.core.rest(arglist__17328);
        return G__17326__delegate(a, b, c, ds);
      };
      G__17326.cljs$core$IFn$_invoke$arity$variadic = G__17326__delegate;
      return G__17326;
    }();
    G__17325 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__17325__2.call(this, a, b);
        case 3:
          return G__17325__3.call(this, a, b, c);
        default:
          var G__17329 = null;
          if (arguments.length > 3) {
            var G__17330__i = 0, G__17330__a = new Array(arguments.length - 3);
            while (G__17330__i < G__17330__a.length) {
              G__17330__a[G__17330__i] = arguments[G__17330__i + 3];
              ++G__17330__i;
            }
            G__17329 = new cljs.core.IndexedSeq(G__17330__a, 0);
          }
          return G__17325__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__17329);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__17325.cljs$lang$maxFixedArity = 3;
    G__17325.cljs$lang$applyTo = G__17325__4.cljs$lang$applyTo;
    G__17325.cljs$core$IFn$_invoke$arity$2 = G__17325__2;
    G__17325.cljs$core$IFn$_invoke$arity$3 = G__17325__3;
    G__17325.cljs$core$IFn$_invoke$arity$variadic = G__17325__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__17325;
  }();
};
cljs.core.fnil.cljs$lang$maxFixedArity = 4;
cljs.core.map_indexed = function cljs$core$map_indexed() {
  var G__17332 = arguments.length;
  switch(G__17332) {
    case 1:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var i = function() {
      var G__17333 = -1;
      return cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__17333) : cljs.core.volatile_BANG_.call(null, G__17333);
    }();
    return function(i) {
      return function() {
        var G__17364 = null;
        var G__17364__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17364__1 = function(result) {
          var G__17334 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17334) : rf.call(null, G__17334);
        };
        var G__17364__2 = function(result, input) {
          var G__17335 = result;
          var G__17336 = function() {
            var G__17337 = cljs.core._vreset_BANG_(i, cljs.core._deref(i) + 1);
            var G__17338 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17337, G__17338) : f.call(null, G__17337, G__17338);
          }();
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17335, G__17336) : rf.call(null, G__17335, G__17336);
        };
        G__17364 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17364__0.call(this);
            case 1:
              return G__17364__1.call(this, result);
            case 2:
              return G__17364__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17364.cljs$core$IFn$_invoke$arity$0 = G__17364__0;
        G__17364.cljs$core$IFn$_invoke$arity$1 = G__17364__1;
        G__17364.cljs$core$IFn$_invoke$arity$2 = G__17364__2;
        return G__17364;
      }();
    }(i);
  };
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var mapi = function cljs$core$mapi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4126__auto__ = cljs.core.seq(coll__$1);
      if (temp__4126__auto__) {
        var s = temp__4126__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__5161__auto___17365 = size;
          var i_17366 = 0;
          while (true) {
            if (i_17366 < n__5161__auto___17365) {
              cljs.core.chunk_append(b, function() {
                var G__17359 = idx + i_17366;
                var G__17360 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_17366);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17359, G__17360) : f.call(null, G__17359, G__17360);
              }());
              var G__17367 = i_17366 + 1;
              i_17366 = G__17367;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$mapi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          return cljs.core.cons(function() {
            var G__17361 = idx;
            var G__17362 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17361, G__17362) : f.call(null, G__17361, G__17362);
          }(), cljs$core$mapi(idx + 1, cljs.core.rest(s)));
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return mapi(0, coll);
};
cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.keep = function cljs$core$keep() {
  var G__17369 = arguments.length;
  switch(G__17369) {
    case 1:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__17377 = null;
      var G__17377__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__17377__1 = function(result) {
        var G__17370 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17370) : rf.call(null, G__17370);
      };
      var G__17377__2 = function(result, input) {
        var v = function() {
          var G__17371 = input;
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17371) : f.call(null, G__17371);
        }();
        if (v == null) {
          return result;
        } else {
          var G__17372 = result;
          var G__17373 = v;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17372, G__17373) : rf.call(null, G__17372, G__17373);
        }
      };
      G__17377 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__17377__0.call(this);
          case 1:
            return G__17377__1.call(this, result);
          case 2:
            return G__17377__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__17377.cljs$core$IFn$_invoke$arity$0 = G__17377__0;
      G__17377.cljs$core$IFn$_invoke$arity$1 = G__17377__1;
      G__17377.cljs$core$IFn$_invoke$arity$2 = G__17377__2;
      return G__17377;
    }();
  };
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4126__auto__ = cljs.core.seq(coll);
    if (temp__4126__auto__) {
      var s = temp__4126__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5161__auto___17378 = size;
        var i_17379 = 0;
        while (true) {
          if (i_17379 < n__5161__auto___17378) {
            var x_17380 = function() {
              var G__17374 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_17379);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17374) : f.call(null, G__17374);
            }();
            if (x_17380 == null) {
            } else {
              cljs.core.chunk_append(b, x_17380);
            }
            var G__17381 = i_17379 + 1;
            i_17379 = G__17381;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        var x = function() {
          var G__17375 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17375) : f.call(null, G__17375);
        }();
        if (x == null) {
          return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s));
        } else {
          return cljs.core.cons(x, cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.keep.cljs$lang$maxFixedArity = 2;
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition0$ = 6455296;
  this.cljs$lang$protocol_mask$partition1$ = 16386;
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var G__17382 = this$__$1;
  return goog.getUid(G__17382);
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var self__ = this;
  var this$__$1 = this;
  var seq__17383 = cljs.core.seq(self__.watches);
  var chunk__17384 = null;
  var count__17385 = 0;
  var i__17386 = 0;
  while (true) {
    if (i__17386 < count__17385) {
      var vec__17387 = chunk__17384.cljs$core$IIndexed$_nth$arity$2(null, i__17386);
      var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17387, 0, null);
      var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17387, 1, null);
      var G__17388_17397 = key;
      var G__17389_17398 = this$__$1;
      var G__17390_17399 = oldval;
      var G__17391_17400 = newval;
      f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17388_17397, G__17389_17398, G__17390_17399, G__17391_17400) : f.call(null, G__17388_17397, G__17389_17398, G__17390_17399, G__17391_17400);
      var G__17401 = seq__17383;
      var G__17402 = chunk__17384;
      var G__17403 = count__17385;
      var G__17404 = i__17386 + 1;
      seq__17383 = G__17401;
      chunk__17384 = G__17402;
      count__17385 = G__17403;
      i__17386 = G__17404;
      continue;
    } else {
      var temp__4126__auto__ = cljs.core.seq(seq__17383);
      if (temp__4126__auto__) {
        var seq__17383__$1 = temp__4126__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__17383__$1)) {
          var c__5061__auto__ = cljs.core.chunk_first(seq__17383__$1);
          var G__17405 = cljs.core.chunk_rest(seq__17383__$1);
          var G__17406 = c__5061__auto__;
          var G__17407 = cljs.core.count(c__5061__auto__);
          var G__17408 = 0;
          seq__17383 = G__17405;
          chunk__17384 = G__17406;
          count__17385 = G__17407;
          i__17386 = G__17408;
          continue;
        } else {
          var vec__17392 = cljs.core.first(seq__17383__$1);
          var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17392, 0, null);
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17392, 1, null);
          var G__17393_17409 = key;
          var G__17394_17410 = this$__$1;
          var G__17395_17411 = oldval;
          var G__17396_17412 = newval;
          f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__17393_17409, G__17394_17410, G__17395_17411, G__17396_17412) : f.call(null, G__17393_17409, G__17394_17410, G__17395_17411, G__17396_17412);
          var G__17413 = cljs.core.next(seq__17383__$1);
          var G__17414 = null;
          var G__17415 = 0;
          var G__17416 = 0;
          seq__17383 = G__17413;
          chunk__17384 = G__17414;
          count__17385 = G__17415;
          i__17386 = G__17416;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var self__ = this;
  var this$__$1 = this;
  this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches, key, f);
  return this$__$1;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches, key);
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return o__$1 === other;
};
cljs.core.Atom.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";
cljs.core.Atom.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/Atom");
};
cljs.core.__GT_Atom = function cljs$core$__GT_Atom(state, meta, validator, watches) {
  return new cljs.core.Atom(state, meta, validator, watches);
};
cljs.core.atom = function cljs$core$atom() {
  var G__17420 = arguments.length;
  switch(G__17420) {
    case 1:
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5328__auto__);
  }
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.Atom(x, null, null, null);
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = function(x, p__17421) {
  var map__17422 = p__17421;
  var map__17422__$1 = cljs.core.seq_QMARK_(map__17422) ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map, map__17422) : map__17422;
  var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17422__$1, new cljs.core.Keyword(null, "validator", "validator", -1966190681));
  var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17422__$1, new cljs.core.Keyword(null, "meta", "meta", 1499536964));
  return new cljs.core.Atom(x, meta, validator, null);
};
cljs.core.atom.cljs$lang$applyTo = function(seq17417) {
  var G__17418 = cljs.core.first(seq17417);
  var seq17417__$1 = cljs.core.next(seq17417);
  return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__17418, seq17417__$1);
};
cljs.core.atom.cljs$lang$maxFixedArity = 1;
cljs.core.reset_BANG_ = function cljs$core$reset_BANG_(a, new_value) {
  if (a instanceof cljs.core.Atom) {
    var validate = a.validator;
    if (validate == null) {
    } else {
      if (cljs.core.truth_(function() {
        var G__17426 = new_value;
        return validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__17426) : validate.call(null, G__17426);
      }())) {
      } else {
        throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(function() {
          var G__17427 = cljs.core.list(new cljs.core.Symbol(null, "validate", "validate", 1439230700, null), new cljs.core.Symbol(null, "new-value", "new-value", -1567397401, null));
          return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__17427) : cljs.core.pr_str.call(null, G__17427);
        }())].join(""));
      }
    }
    var old_value = a.state;
    a.state = new_value;
    if (a.watches == null) {
    } else {
      cljs.core._notify_watches(a, old_value, new_value);
    }
    return new_value;
  } else {
    return cljs.core._reset_BANG_(a, new_value);
  }
};
cljs.core.swap_BANG_ = function cljs$core$swap_BANG_() {
  var G__17434 = arguments.length;
  switch(G__17434) {
    case 2:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5328__auto__);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(a, f) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__17435 = a.state;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17435) : f.call(null, G__17435);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a, f);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(a, f, x) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__17436 = a.state;
      var G__17437 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17436, G__17437) : f.call(null, G__17436, G__17437);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a, f, x);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(a, f, x, y) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__17438 = a.state;
      var G__17439 = x;
      var G__17440 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17438, G__17439, G__17440) : f.call(null, G__17438, G__17439, G__17440);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a, f, x, y);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(a, f, x, y, more) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a.state, x, y, more));
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a, f, x, y, more);
  }
};
cljs.core.swap_BANG_.cljs$lang$applyTo = function(seq17428) {
  var G__17429 = cljs.core.first(seq17428);
  var seq17428__$1 = cljs.core.next(seq17428);
  var G__17430 = cljs.core.first(seq17428__$1);
  var seq17428__$2 = cljs.core.next(seq17428__$1);
  var G__17431 = cljs.core.first(seq17428__$2);
  var seq17428__$3 = cljs.core.next(seq17428__$2);
  var G__17432 = cljs.core.first(seq17428__$3);
  var seq17428__$4 = cljs.core.next(seq17428__$3);
  return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17429, G__17430, G__17431, G__17432, seq17428__$4);
};
cljs.core.swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.compare_and_set_BANG_ = function cljs$core$compare_and_set_BANG_(a, oldval, newval) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null), oldval)) {
    cljs.core.reset_BANG_(a, newval);
    return true;
  } else {
    return false;
  }
};
cljs.core.set_validator_BANG_ = function cljs$core$set_validator_BANG_(iref, val) {
  return iref.validator = val;
};
cljs.core.get_validator = function cljs$core$get_validator(iref) {
  return iref.validator;
};
cljs.core.Volatile = function(state) {
  this.state = state;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
};
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;
cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = function(_, new_state) {
  var self__ = this;
  var ___$1 = this;
  return self__.state = new_state;
};
cljs.core.Volatile.cljs$lang$type = true;
cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";
cljs.core.Volatile.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/Volatile");
};
cljs.core.__GT_Volatile = function cljs$core$__GT_Volatile(state) {
  return new cljs.core.Volatile(state);
};
cljs.core.volatile_BANG_ = function cljs$core$volatile_BANG_(val) {
  return new cljs.core.Volatile(val);
};
cljs.core.volatile_QMARK_ = function cljs$core$volatile_QMARK_(x) {
  return x instanceof cljs.core.Volatile;
};
cljs.core.vreset_BANG_ = function cljs$core$vreset_BANG_(vol, newval) {
  return cljs.core._vreset_BANG_(vol, newval);
};
cljs.core.keep_indexed = function cljs$core$keep_indexed() {
  var G__17443 = arguments.length;
  switch(G__17443) {
    case 1:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var ia = cljs.core.volatile_BANG_(-1);
    return function(ia) {
      return function() {
        var G__17478 = null;
        var G__17478__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17478__1 = function(result) {
          var G__17444 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17444) : rf.call(null, G__17444);
        };
        var G__17478__2 = function(result, input) {
          var i = cljs.core._vreset_BANG_(ia, cljs.core._deref(ia) + 1);
          var v = function() {
            var G__17445 = i;
            var G__17446 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17445, G__17446) : f.call(null, G__17445, G__17446);
          }();
          if (v == null) {
            return result;
          } else {
            var G__17447 = result;
            var G__17448 = v;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17447, G__17448) : rf.call(null, G__17447, G__17448);
          }
        };
        G__17478 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17478__0.call(this);
            case 1:
              return G__17478__1.call(this, result);
            case 2:
              return G__17478__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17478.cljs$core$IFn$_invoke$arity$0 = G__17478__0;
        G__17478.cljs$core$IFn$_invoke$arity$1 = G__17478__1;
        G__17478.cljs$core$IFn$_invoke$arity$2 = G__17478__2;
        return G__17478;
      }();
    }(ia);
  };
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var keepi = function cljs$core$keepi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4126__auto__ = cljs.core.seq(coll__$1);
      if (temp__4126__auto__) {
        var s = temp__4126__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__5161__auto___17479 = size;
          var i_17480 = 0;
          while (true) {
            if (i_17480 < n__5161__auto___17479) {
              var x_17481 = function() {
                var G__17473 = idx + i_17480;
                var G__17474 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_17480);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17473, G__17474) : f.call(null, G__17473, G__17474);
              }();
              if (x_17481 == null) {
              } else {
                cljs.core.chunk_append(b, x_17481);
              }
              var G__17482 = i_17480 + 1;
              i_17480 = G__17482;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$keepi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          var x = function() {
            var G__17475 = idx;
            var G__17476 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17475, G__17476) : f.call(null, G__17475, G__17476);
          }();
          if (x == null) {
            return cljs$core$keepi(idx + 1, cljs.core.rest(s));
          } else {
            return cljs.core.cons(x, cljs$core$keepi(idx + 1, cljs.core.rest(s)));
          }
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return keepi(0, coll);
};
cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.every_pred = function cljs$core$every_pred() {
  var G__17494 = arguments.length;
  switch(G__17494) {
    case 1:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5328__auto__);
  }
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$ep1 = null;
    var cljs$core$ep1__0 = function() {
      return true;
    };
    var cljs$core$ep1__1 = function(x) {
      return cljs.core.boolean$(function() {
        var G__17510 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17510) : p.call(null, G__17510);
      }());
    };
    var cljs$core$ep1__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4264__auto__ = function() {
          var G__17512 = x;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17512) : p.call(null, G__17512);
        }();
        if (cljs.core.truth_(and__4264__auto__)) {
          var G__17513 = y;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17513) : p.call(null, G__17513);
        } else {
          return and__4264__auto__;
        }
      }());
    };
    var cljs$core$ep1__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4264__auto__ = function() {
          var G__17515 = x;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17515) : p.call(null, G__17515);
        }();
        if (cljs.core.truth_(and__4264__auto__)) {
          var and__4264__auto____$1 = function() {
            var G__17517 = y;
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17517) : p.call(null, G__17517);
          }();
          if (cljs.core.truth_(and__4264__auto____$1)) {
            var G__17518 = z;
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17518) : p.call(null, G__17518);
          } else {
            return and__4264__auto____$1;
          }
        } else {
          return and__4264__auto__;
        }
      }());
    };
    var cljs$core$ep1__4 = function() {
      var G__17680__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4264__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4264__auto__)) {
            return cljs.core.every_QMARK_(p, args);
          } else {
            return and__4264__auto__;
          }
        }());
      };
      var G__17680 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17681__i = 0, G__17681__a = new Array(arguments.length - 3);
          while (G__17681__i < G__17681__a.length) {
            G__17681__a[G__17681__i] = arguments[G__17681__i + 3];
            ++G__17681__i;
          }
          args = new cljs.core.IndexedSeq(G__17681__a, 0);
        }
        return G__17680__delegate.call(this, x, y, z, args);
      };
      G__17680.cljs$lang$maxFixedArity = 3;
      G__17680.cljs$lang$applyTo = function(arglist__17682) {
        var x = cljs.core.first(arglist__17682);
        arglist__17682 = cljs.core.next(arglist__17682);
        var y = cljs.core.first(arglist__17682);
        arglist__17682 = cljs.core.next(arglist__17682);
        var z = cljs.core.first(arglist__17682);
        var args = cljs.core.rest(arglist__17682);
        return G__17680__delegate(x, y, z, args);
      };
      G__17680.cljs$core$IFn$_invoke$arity$variadic = G__17680__delegate;
      return G__17680;
    }();
    cljs$core$ep1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep1__0.call(this);
        case 1:
          return cljs$core$ep1__1.call(this, x);
        case 2:
          return cljs$core$ep1__2.call(this, x, y);
        case 3:
          return cljs$core$ep1__3.call(this, x, y, z);
        default:
          var G__17683 = null;
          if (arguments.length > 3) {
            var G__17684__i = 0, G__17684__a = new Array(arguments.length - 3);
            while (G__17684__i < G__17684__a.length) {
              G__17684__a[G__17684__i] = arguments[G__17684__i + 3];
              ++G__17684__i;
            }
            G__17683 = new cljs.core.IndexedSeq(G__17684__a, 0);
          }
          return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17683);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep1.cljs$lang$maxFixedArity = 3;
    cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep1;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$ep2 = null;
    var cljs$core$ep2__0 = function() {
      return true;
    };
    var cljs$core$ep2__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__4264__auto__ = function() {
          var G__17550 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17550) : p1.call(null, G__17550);
        }();
        if (cljs.core.truth_(and__4264__auto__)) {
          var G__17551 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17551) : p2.call(null, G__17551);
        } else {
          return and__4264__auto__;
        }
      }());
    };
    var cljs$core$ep2__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4264__auto__ = function() {
          var G__17553 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17553) : p1.call(null, G__17553);
        }();
        if (cljs.core.truth_(and__4264__auto__)) {
          var and__4264__auto____$1 = function() {
            var G__17555 = y;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17555) : p1.call(null, G__17555);
          }();
          if (cljs.core.truth_(and__4264__auto____$1)) {
            var and__4264__auto____$2 = function() {
              var G__17557 = x;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17557) : p2.call(null, G__17557);
            }();
            if (cljs.core.truth_(and__4264__auto____$2)) {
              var G__17558 = y;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17558) : p2.call(null, G__17558);
            } else {
              return and__4264__auto____$2;
            }
          } else {
            return and__4264__auto____$1;
          }
        } else {
          return and__4264__auto__;
        }
      }());
    };
    var cljs$core$ep2__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4264__auto__ = function() {
          var G__17560 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17560) : p1.call(null, G__17560);
        }();
        if (cljs.core.truth_(and__4264__auto__)) {
          var and__4264__auto____$1 = function() {
            var G__17562 = y;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17562) : p1.call(null, G__17562);
          }();
          if (cljs.core.truth_(and__4264__auto____$1)) {
            var and__4264__auto____$2 = function() {
              var G__17564 = z;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17564) : p1.call(null, G__17564);
            }();
            if (cljs.core.truth_(and__4264__auto____$2)) {
              var and__4264__auto____$3 = function() {
                var G__17566 = x;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17566) : p2.call(null, G__17566);
              }();
              if (cljs.core.truth_(and__4264__auto____$3)) {
                var and__4264__auto____$4 = function() {
                  var G__17568 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17568) : p2.call(null, G__17568);
                }();
                if (cljs.core.truth_(and__4264__auto____$4)) {
                  var G__17569 = z;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17569) : p2.call(null, G__17569);
                } else {
                  return and__4264__auto____$4;
                }
              } else {
                return and__4264__auto____$3;
              }
            } else {
              return and__4264__auto____$2;
            }
          } else {
            return and__4264__auto____$1;
          }
        } else {
          return and__4264__auto__;
        }
      }());
    };
    var cljs$core$ep2__4 = function() {
      var G__17685__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4264__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4264__auto__)) {
            return cljs.core.every_QMARK_(function(and__4264__auto__) {
              return function(p1__17483_SHARP_) {
                var and__4264__auto____$1 = function() {
                  var G__17571 = p1__17483_SHARP_;
                  return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17571) : p1.call(null, G__17571);
                }();
                if (cljs.core.truth_(and__4264__auto____$1)) {
                  var G__17572 = p1__17483_SHARP_;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17572) : p2.call(null, G__17572);
                } else {
                  return and__4264__auto____$1;
                }
              };
            }(and__4264__auto__), args);
          } else {
            return and__4264__auto__;
          }
        }());
      };
      var G__17685 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17686__i = 0, G__17686__a = new Array(arguments.length - 3);
          while (G__17686__i < G__17686__a.length) {
            G__17686__a[G__17686__i] = arguments[G__17686__i + 3];
            ++G__17686__i;
          }
          args = new cljs.core.IndexedSeq(G__17686__a, 0);
        }
        return G__17685__delegate.call(this, x, y, z, args);
      };
      G__17685.cljs$lang$maxFixedArity = 3;
      G__17685.cljs$lang$applyTo = function(arglist__17687) {
        var x = cljs.core.first(arglist__17687);
        arglist__17687 = cljs.core.next(arglist__17687);
        var y = cljs.core.first(arglist__17687);
        arglist__17687 = cljs.core.next(arglist__17687);
        var z = cljs.core.first(arglist__17687);
        var args = cljs.core.rest(arglist__17687);
        return G__17685__delegate(x, y, z, args);
      };
      G__17685.cljs$core$IFn$_invoke$arity$variadic = G__17685__delegate;
      return G__17685;
    }();
    cljs$core$ep2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep2__0.call(this);
        case 1:
          return cljs$core$ep2__1.call(this, x);
        case 2:
          return cljs$core$ep2__2.call(this, x, y);
        case 3:
          return cljs$core$ep2__3.call(this, x, y, z);
        default:
          var G__17688 = null;
          if (arguments.length > 3) {
            var G__17689__i = 0, G__17689__a = new Array(arguments.length - 3);
            while (G__17689__i < G__17689__a.length) {
              G__17689__a[G__17689__i] = arguments[G__17689__i + 3];
              ++G__17689__i;
            }
            G__17688 = new cljs.core.IndexedSeq(G__17689__a, 0);
          }
          return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17688);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep2.cljs$lang$maxFixedArity = 3;
    cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep2;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$ep3 = null;
    var cljs$core$ep3__0 = function() {
      return true;
    };
    var cljs$core$ep3__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__4264__auto__ = function() {
          var G__17618 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17618) : p1.call(null, G__17618);
        }();
        if (cljs.core.truth_(and__4264__auto__)) {
          var and__4264__auto____$1 = function() {
            var G__17620 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17620) : p2.call(null, G__17620);
          }();
          if (cljs.core.truth_(and__4264__auto____$1)) {
            var G__17621 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17621) : p3.call(null, G__17621);
          } else {
            return and__4264__auto____$1;
          }
        } else {
          return and__4264__auto__;
        }
      }());
    };
    var cljs$core$ep3__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__4264__auto__ = function() {
          var G__17623 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17623) : p1.call(null, G__17623);
        }();
        if (cljs.core.truth_(and__4264__auto__)) {
          var and__4264__auto____$1 = function() {
            var G__17625 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17625) : p2.call(null, G__17625);
          }();
          if (cljs.core.truth_(and__4264__auto____$1)) {
            var and__4264__auto____$2 = function() {
              var G__17627 = x;
              return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17627) : p3.call(null, G__17627);
            }();
            if (cljs.core.truth_(and__4264__auto____$2)) {
              var and__4264__auto____$3 = function() {
                var G__17629 = y;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17629) : p1.call(null, G__17629);
              }();
              if (cljs.core.truth_(and__4264__auto____$3)) {
                var and__4264__auto____$4 = function() {
                  var G__17631 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17631) : p2.call(null, G__17631);
                }();
                if (cljs.core.truth_(and__4264__auto____$4)) {
                  var G__17632 = y;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17632) : p3.call(null, G__17632);
                } else {
                  return and__4264__auto____$4;
                }
              } else {
                return and__4264__auto____$3;
              }
            } else {
              return and__4264__auto____$2;
            }
          } else {
            return and__4264__auto____$1;
          }
        } else {
          return and__4264__auto__;
        }
      }());
    };
    var cljs$core$ep3__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__4264__auto__ = function() {
          var G__17634 = x;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17634) : p1.call(null, G__17634);
        }();
        if (cljs.core.truth_(and__4264__auto__)) {
          var and__4264__auto____$1 = function() {
            var G__17636 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17636) : p2.call(null, G__17636);
          }();
          if (cljs.core.truth_(and__4264__auto____$1)) {
            var and__4264__auto____$2 = function() {
              var G__17638 = x;
              return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17638) : p3.call(null, G__17638);
            }();
            if (cljs.core.truth_(and__4264__auto____$2)) {
              var and__4264__auto____$3 = function() {
                var G__17640 = y;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17640) : p1.call(null, G__17640);
              }();
              if (cljs.core.truth_(and__4264__auto____$3)) {
                var and__4264__auto____$4 = function() {
                  var G__17642 = y;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17642) : p2.call(null, G__17642);
                }();
                if (cljs.core.truth_(and__4264__auto____$4)) {
                  var and__4264__auto____$5 = function() {
                    var G__17644 = y;
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17644) : p3.call(null, G__17644);
                  }();
                  if (cljs.core.truth_(and__4264__auto____$5)) {
                    var and__4264__auto____$6 = function() {
                      var G__17646 = z;
                      return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17646) : p1.call(null, G__17646);
                    }();
                    if (cljs.core.truth_(and__4264__auto____$6)) {
                      var and__4264__auto____$7 = function() {
                        var G__17648 = z;
                        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17648) : p2.call(null, G__17648);
                      }();
                      if (cljs.core.truth_(and__4264__auto____$7)) {
                        var G__17649 = z;
                        return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17649) : p3.call(null, G__17649);
                      } else {
                        return and__4264__auto____$7;
                      }
                    } else {
                      return and__4264__auto____$6;
                    }
                  } else {
                    return and__4264__auto____$5;
                  }
                } else {
                  return and__4264__auto____$4;
                }
              } else {
                return and__4264__auto____$3;
              }
            } else {
              return and__4264__auto____$2;
            }
          } else {
            return and__4264__auto____$1;
          }
        } else {
          return and__4264__auto__;
        }
      }());
    };
    var cljs$core$ep3__4 = function() {
      var G__17690__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__4264__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__4264__auto__)) {
            return cljs.core.every_QMARK_(function(and__4264__auto__) {
              return function(p1__17484_SHARP_) {
                var and__4264__auto____$1 = function() {
                  var G__17651 = p1__17484_SHARP_;
                  return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17651) : p1.call(null, G__17651);
                }();
                if (cljs.core.truth_(and__4264__auto____$1)) {
                  var and__4264__auto____$2 = function() {
                    var G__17653 = p1__17484_SHARP_;
                    return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17653) : p2.call(null, G__17653);
                  }();
                  if (cljs.core.truth_(and__4264__auto____$2)) {
                    var G__17654 = p1__17484_SHARP_;
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17654) : p3.call(null, G__17654);
                  } else {
                    return and__4264__auto____$2;
                  }
                } else {
                  return and__4264__auto____$1;
                }
              };
            }(and__4264__auto__), args);
          } else {
            return and__4264__auto__;
          }
        }());
      };
      var G__17690 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17691__i = 0, G__17691__a = new Array(arguments.length - 3);
          while (G__17691__i < G__17691__a.length) {
            G__17691__a[G__17691__i] = arguments[G__17691__i + 3];
            ++G__17691__i;
          }
          args = new cljs.core.IndexedSeq(G__17691__a, 0);
        }
        return G__17690__delegate.call(this, x, y, z, args);
      };
      G__17690.cljs$lang$maxFixedArity = 3;
      G__17690.cljs$lang$applyTo = function(arglist__17692) {
        var x = cljs.core.first(arglist__17692);
        arglist__17692 = cljs.core.next(arglist__17692);
        var y = cljs.core.first(arglist__17692);
        arglist__17692 = cljs.core.next(arglist__17692);
        var z = cljs.core.first(arglist__17692);
        var args = cljs.core.rest(arglist__17692);
        return G__17690__delegate(x, y, z, args);
      };
      G__17690.cljs$core$IFn$_invoke$arity$variadic = G__17690__delegate;
      return G__17690;
    }();
    cljs$core$ep3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep3__0.call(this);
        case 1:
          return cljs$core$ep3__1.call(this, x);
        case 2:
          return cljs$core$ep3__2.call(this, x, y);
        case 3:
          return cljs$core$ep3__3.call(this, x, y, z);
        default:
          var G__17693 = null;
          if (arguments.length > 3) {
            var G__17694__i = 0, G__17694__a = new Array(arguments.length - 3);
            while (G__17694__i < G__17694__a.length) {
              G__17694__a[G__17694__i] = arguments[G__17694__i + 3];
              ++G__17694__i;
            }
            G__17693 = new cljs.core.IndexedSeq(G__17694__a, 0);
          }
          return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17693);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$ep3.cljs$lang$maxFixedArity = 3;
    cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep3;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$epn = null;
      var cljs$core$epn__0 = function() {
        return true;
      };
      var cljs$core$epn__1 = function(x) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__17485_SHARP_) {
            var G__17670 = x;
            return p1__17485_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17485_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17670) : p1__17485_SHARP_.call(null, G__17670);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__2 = function(x, y) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__17486_SHARP_) {
            var and__4264__auto__ = function() {
              var G__17672 = x;
              return p1__17486_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17486_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17672) : p1__17486_SHARP_.call(null, G__17672);
            }();
            if (cljs.core.truth_(and__4264__auto__)) {
              var G__17673 = y;
              return p1__17486_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17486_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17673) : p1__17486_SHARP_.call(null, G__17673);
            } else {
              return and__4264__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__3 = function(x, y, z) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__17487_SHARP_) {
            var and__4264__auto__ = function() {
              var G__17675 = x;
              return p1__17487_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17487_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17675) : p1__17487_SHARP_.call(null, G__17675);
            }();
            if (cljs.core.truth_(and__4264__auto__)) {
              var and__4264__auto____$1 = function() {
                var G__17677 = y;
                return p1__17487_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17487_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17677) : p1__17487_SHARP_.call(null, G__17677);
              }();
              if (cljs.core.truth_(and__4264__auto____$1)) {
                var G__17678 = z;
                return p1__17487_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17487_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17678) : p1__17487_SHARP_.call(null, G__17678);
              } else {
                return and__4264__auto____$1;
              }
            } else {
              return and__4264__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__4 = function() {
        var G__17695__delegate = function(x, y, z, args) {
          return cljs.core.boolean$(function() {
            var and__4264__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x, y, z);
            if (cljs.core.truth_(and__4264__auto__)) {
              return cljs.core.every_QMARK_(function(and__4264__auto__, ps__$1) {
                return function(p1__17488_SHARP_) {
                  return cljs.core.every_QMARK_(p1__17488_SHARP_, args);
                };
              }(and__4264__auto__, ps__$1), ps__$1);
            } else {
              return and__4264__auto__;
            }
          }());
        };
        var G__17695 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__17696__i = 0, G__17696__a = new Array(arguments.length - 3);
            while (G__17696__i < G__17696__a.length) {
              G__17696__a[G__17696__i] = arguments[G__17696__i + 3];
              ++G__17696__i;
            }
            args = new cljs.core.IndexedSeq(G__17696__a, 0);
          }
          return G__17695__delegate.call(this, x, y, z, args);
        };
        G__17695.cljs$lang$maxFixedArity = 3;
        G__17695.cljs$lang$applyTo = function(arglist__17697) {
          var x = cljs.core.first(arglist__17697);
          arglist__17697 = cljs.core.next(arglist__17697);
          var y = cljs.core.first(arglist__17697);
          arglist__17697 = cljs.core.next(arglist__17697);
          var z = cljs.core.first(arglist__17697);
          var args = cljs.core.rest(arglist__17697);
          return G__17695__delegate(x, y, z, args);
        };
        G__17695.cljs$core$IFn$_invoke$arity$variadic = G__17695__delegate;
        return G__17695;
      }();
      cljs$core$epn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$epn__0.call(this);
          case 1:
            return cljs$core$epn__1.call(this, x);
          case 2:
            return cljs$core$epn__2.call(this, x, y);
          case 3:
            return cljs$core$epn__3.call(this, x, y, z);
          default:
            var G__17698 = null;
            if (arguments.length > 3) {
              var G__17699__i = 0, G__17699__a = new Array(arguments.length - 3);
              while (G__17699__i < G__17699__a.length) {
                G__17699__a[G__17699__i] = arguments[G__17699__i + 3];
                ++G__17699__i;
              }
              G__17698 = new cljs.core.IndexedSeq(G__17699__a, 0);
            }
            return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17698);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$epn.cljs$lang$maxFixedArity = 3;
      cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$epn;
    }();
  }(ps__$1);
};
cljs.core.every_pred.cljs$lang$applyTo = function(seq17489) {
  var G__17490 = cljs.core.first(seq17489);
  var seq17489__$1 = cljs.core.next(seq17489);
  var G__17491 = cljs.core.first(seq17489__$1);
  var seq17489__$2 = cljs.core.next(seq17489__$1);
  var G__17492 = cljs.core.first(seq17489__$2);
  var seq17489__$3 = cljs.core.next(seq17489__$2);
  return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__17490, G__17491, G__17492, seq17489__$3);
};
cljs.core.every_pred.cljs$lang$maxFixedArity = 3;
cljs.core.some_fn = function cljs$core$some_fn() {
  var G__17711 = arguments.length;
  switch(G__17711) {
    case 1:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5328__auto__);
  }
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$sp1 = null;
    var cljs$core$sp1__0 = function() {
      return null;
    };
    var cljs$core$sp1__1 = function(x) {
      var G__17727 = x;
      return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17727) : p.call(null, G__17727);
    };
    var cljs$core$sp1__2 = function(x, y) {
      var or__4276__auto__ = function() {
        var G__17729 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17729) : p.call(null, G__17729);
      }();
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        var G__17730 = y;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17730) : p.call(null, G__17730);
      }
    };
    var cljs$core$sp1__3 = function(x, y, z) {
      var or__4276__auto__ = function() {
        var G__17732 = x;
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17732) : p.call(null, G__17732);
      }();
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = function() {
          var G__17734 = y;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17734) : p.call(null, G__17734);
        }();
        if (cljs.core.truth_(or__4276__auto____$1)) {
          return or__4276__auto____$1;
        } else {
          var G__17735 = z;
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__17735) : p.call(null, G__17735);
        }
      }
    };
    var cljs$core$sp1__4 = function() {
      var G__17897__delegate = function(x, y, z, args) {
        var or__4276__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4276__auto__)) {
          return or__4276__auto__;
        } else {
          return cljs.core.some(p, args);
        }
      };
      var G__17897 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17898__i = 0, G__17898__a = new Array(arguments.length - 3);
          while (G__17898__i < G__17898__a.length) {
            G__17898__a[G__17898__i] = arguments[G__17898__i + 3];
            ++G__17898__i;
          }
          args = new cljs.core.IndexedSeq(G__17898__a, 0);
        }
        return G__17897__delegate.call(this, x, y, z, args);
      };
      G__17897.cljs$lang$maxFixedArity = 3;
      G__17897.cljs$lang$applyTo = function(arglist__17899) {
        var x = cljs.core.first(arglist__17899);
        arglist__17899 = cljs.core.next(arglist__17899);
        var y = cljs.core.first(arglist__17899);
        arglist__17899 = cljs.core.next(arglist__17899);
        var z = cljs.core.first(arglist__17899);
        var args = cljs.core.rest(arglist__17899);
        return G__17897__delegate(x, y, z, args);
      };
      G__17897.cljs$core$IFn$_invoke$arity$variadic = G__17897__delegate;
      return G__17897;
    }();
    cljs$core$sp1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp1__0.call(this);
        case 1:
          return cljs$core$sp1__1.call(this, x);
        case 2:
          return cljs$core$sp1__2.call(this, x, y);
        case 3:
          return cljs$core$sp1__3.call(this, x, y, z);
        default:
          var G__17900 = null;
          if (arguments.length > 3) {
            var G__17901__i = 0, G__17901__a = new Array(arguments.length - 3);
            while (G__17901__i < G__17901__a.length) {
              G__17901__a[G__17901__i] = arguments[G__17901__i + 3];
              ++G__17901__i;
            }
            G__17900 = new cljs.core.IndexedSeq(G__17901__a, 0);
          }
          return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17900);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp1.cljs$lang$maxFixedArity = 3;
    cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp1;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$sp2 = null;
    var cljs$core$sp2__0 = function() {
      return null;
    };
    var cljs$core$sp2__1 = function(x) {
      var or__4276__auto__ = function() {
        var G__17767 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17767) : p1.call(null, G__17767);
      }();
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        var G__17768 = x;
        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17768) : p2.call(null, G__17768);
      }
    };
    var cljs$core$sp2__2 = function(x, y) {
      var or__4276__auto__ = function() {
        var G__17770 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17770) : p1.call(null, G__17770);
      }();
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = function() {
          var G__17772 = y;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17772) : p1.call(null, G__17772);
        }();
        if (cljs.core.truth_(or__4276__auto____$1)) {
          return or__4276__auto____$1;
        } else {
          var or__4276__auto____$2 = function() {
            var G__17774 = x;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17774) : p2.call(null, G__17774);
          }();
          if (cljs.core.truth_(or__4276__auto____$2)) {
            return or__4276__auto____$2;
          } else {
            var G__17775 = y;
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17775) : p2.call(null, G__17775);
          }
        }
      }
    };
    var cljs$core$sp2__3 = function(x, y, z) {
      var or__4276__auto__ = function() {
        var G__17777 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17777) : p1.call(null, G__17777);
      }();
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = function() {
          var G__17779 = y;
          return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17779) : p1.call(null, G__17779);
        }();
        if (cljs.core.truth_(or__4276__auto____$1)) {
          return or__4276__auto____$1;
        } else {
          var or__4276__auto____$2 = function() {
            var G__17781 = z;
            return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17781) : p1.call(null, G__17781);
          }();
          if (cljs.core.truth_(or__4276__auto____$2)) {
            return or__4276__auto____$2;
          } else {
            var or__4276__auto____$3 = function() {
              var G__17783 = x;
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17783) : p2.call(null, G__17783);
            }();
            if (cljs.core.truth_(or__4276__auto____$3)) {
              return or__4276__auto____$3;
            } else {
              var or__4276__auto____$4 = function() {
                var G__17785 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17785) : p2.call(null, G__17785);
              }();
              if (cljs.core.truth_(or__4276__auto____$4)) {
                return or__4276__auto____$4;
              } else {
                var G__17786 = z;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17786) : p2.call(null, G__17786);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp2__4 = function() {
      var G__17902__delegate = function(x, y, z, args) {
        var or__4276__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4276__auto__)) {
          return or__4276__auto__;
        } else {
          return cljs.core.some(function(or__4276__auto__) {
            return function(p1__17700_SHARP_) {
              var or__4276__auto____$1 = function() {
                var G__17788 = p1__17700_SHARP_;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17788) : p1.call(null, G__17788);
              }();
              if (cljs.core.truth_(or__4276__auto____$1)) {
                return or__4276__auto____$1;
              } else {
                var G__17789 = p1__17700_SHARP_;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17789) : p2.call(null, G__17789);
              }
            };
          }(or__4276__auto__), args);
        }
      };
      var G__17902 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17903__i = 0, G__17903__a = new Array(arguments.length - 3);
          while (G__17903__i < G__17903__a.length) {
            G__17903__a[G__17903__i] = arguments[G__17903__i + 3];
            ++G__17903__i;
          }
          args = new cljs.core.IndexedSeq(G__17903__a, 0);
        }
        return G__17902__delegate.call(this, x, y, z, args);
      };
      G__17902.cljs$lang$maxFixedArity = 3;
      G__17902.cljs$lang$applyTo = function(arglist__17904) {
        var x = cljs.core.first(arglist__17904);
        arglist__17904 = cljs.core.next(arglist__17904);
        var y = cljs.core.first(arglist__17904);
        arglist__17904 = cljs.core.next(arglist__17904);
        var z = cljs.core.first(arglist__17904);
        var args = cljs.core.rest(arglist__17904);
        return G__17902__delegate(x, y, z, args);
      };
      G__17902.cljs$core$IFn$_invoke$arity$variadic = G__17902__delegate;
      return G__17902;
    }();
    cljs$core$sp2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp2__0.call(this);
        case 1:
          return cljs$core$sp2__1.call(this, x);
        case 2:
          return cljs$core$sp2__2.call(this, x, y);
        case 3:
          return cljs$core$sp2__3.call(this, x, y, z);
        default:
          var G__17905 = null;
          if (arguments.length > 3) {
            var G__17906__i = 0, G__17906__a = new Array(arguments.length - 3);
            while (G__17906__i < G__17906__a.length) {
              G__17906__a[G__17906__i] = arguments[G__17906__i + 3];
              ++G__17906__i;
            }
            G__17905 = new cljs.core.IndexedSeq(G__17906__a, 0);
          }
          return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17905);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp2.cljs$lang$maxFixedArity = 3;
    cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp2;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$sp3 = null;
    var cljs$core$sp3__0 = function() {
      return null;
    };
    var cljs$core$sp3__1 = function(x) {
      var or__4276__auto__ = function() {
        var G__17835 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17835) : p1.call(null, G__17835);
      }();
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = function() {
          var G__17837 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17837) : p2.call(null, G__17837);
        }();
        if (cljs.core.truth_(or__4276__auto____$1)) {
          return or__4276__auto____$1;
        } else {
          var G__17838 = x;
          return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17838) : p3.call(null, G__17838);
        }
      }
    };
    var cljs$core$sp3__2 = function(x, y) {
      var or__4276__auto__ = function() {
        var G__17840 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17840) : p1.call(null, G__17840);
      }();
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = function() {
          var G__17842 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17842) : p2.call(null, G__17842);
        }();
        if (cljs.core.truth_(or__4276__auto____$1)) {
          return or__4276__auto____$1;
        } else {
          var or__4276__auto____$2 = function() {
            var G__17844 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17844) : p3.call(null, G__17844);
          }();
          if (cljs.core.truth_(or__4276__auto____$2)) {
            return or__4276__auto____$2;
          } else {
            var or__4276__auto____$3 = function() {
              var G__17846 = y;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17846) : p1.call(null, G__17846);
            }();
            if (cljs.core.truth_(or__4276__auto____$3)) {
              return or__4276__auto____$3;
            } else {
              var or__4276__auto____$4 = function() {
                var G__17848 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17848) : p2.call(null, G__17848);
              }();
              if (cljs.core.truth_(or__4276__auto____$4)) {
                return or__4276__auto____$4;
              } else {
                var G__17849 = y;
                return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17849) : p3.call(null, G__17849);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__3 = function(x, y, z) {
      var or__4276__auto__ = function() {
        var G__17851 = x;
        return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17851) : p1.call(null, G__17851);
      }();
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        var or__4276__auto____$1 = function() {
          var G__17853 = x;
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17853) : p2.call(null, G__17853);
        }();
        if (cljs.core.truth_(or__4276__auto____$1)) {
          return or__4276__auto____$1;
        } else {
          var or__4276__auto____$2 = function() {
            var G__17855 = x;
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17855) : p3.call(null, G__17855);
          }();
          if (cljs.core.truth_(or__4276__auto____$2)) {
            return or__4276__auto____$2;
          } else {
            var or__4276__auto____$3 = function() {
              var G__17857 = y;
              return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17857) : p1.call(null, G__17857);
            }();
            if (cljs.core.truth_(or__4276__auto____$3)) {
              return or__4276__auto____$3;
            } else {
              var or__4276__auto____$4 = function() {
                var G__17859 = y;
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17859) : p2.call(null, G__17859);
              }();
              if (cljs.core.truth_(or__4276__auto____$4)) {
                return or__4276__auto____$4;
              } else {
                var or__4276__auto____$5 = function() {
                  var G__17861 = y;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17861) : p3.call(null, G__17861);
                }();
                if (cljs.core.truth_(or__4276__auto____$5)) {
                  return or__4276__auto____$5;
                } else {
                  var or__4276__auto____$6 = function() {
                    var G__17863 = z;
                    return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17863) : p1.call(null, G__17863);
                  }();
                  if (cljs.core.truth_(or__4276__auto____$6)) {
                    return or__4276__auto____$6;
                  } else {
                    var or__4276__auto____$7 = function() {
                      var G__17865 = z;
                      return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17865) : p2.call(null, G__17865);
                    }();
                    if (cljs.core.truth_(or__4276__auto____$7)) {
                      return or__4276__auto____$7;
                    } else {
                      var G__17866 = z;
                      return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17866) : p3.call(null, G__17866);
                    }
                  }
                }
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__4 = function() {
      var G__17907__delegate = function(x, y, z, args) {
        var or__4276__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__4276__auto__)) {
          return or__4276__auto__;
        } else {
          return cljs.core.some(function(or__4276__auto__) {
            return function(p1__17701_SHARP_) {
              var or__4276__auto____$1 = function() {
                var G__17868 = p1__17701_SHARP_;
                return p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__17868) : p1.call(null, G__17868);
              }();
              if (cljs.core.truth_(or__4276__auto____$1)) {
                return or__4276__auto____$1;
              } else {
                var or__4276__auto____$2 = function() {
                  var G__17870 = p1__17701_SHARP_;
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__17870) : p2.call(null, G__17870);
                }();
                if (cljs.core.truth_(or__4276__auto____$2)) {
                  return or__4276__auto____$2;
                } else {
                  var G__17871 = p1__17701_SHARP_;
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__17871) : p3.call(null, G__17871);
                }
              }
            };
          }(or__4276__auto__), args);
        }
      };
      var G__17907 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__17908__i = 0, G__17908__a = new Array(arguments.length - 3);
          while (G__17908__i < G__17908__a.length) {
            G__17908__a[G__17908__i] = arguments[G__17908__i + 3];
            ++G__17908__i;
          }
          args = new cljs.core.IndexedSeq(G__17908__a, 0);
        }
        return G__17907__delegate.call(this, x, y, z, args);
      };
      G__17907.cljs$lang$maxFixedArity = 3;
      G__17907.cljs$lang$applyTo = function(arglist__17909) {
        var x = cljs.core.first(arglist__17909);
        arglist__17909 = cljs.core.next(arglist__17909);
        var y = cljs.core.first(arglist__17909);
        arglist__17909 = cljs.core.next(arglist__17909);
        var z = cljs.core.first(arglist__17909);
        var args = cljs.core.rest(arglist__17909);
        return G__17907__delegate(x, y, z, args);
      };
      G__17907.cljs$core$IFn$_invoke$arity$variadic = G__17907__delegate;
      return G__17907;
    }();
    cljs$core$sp3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp3__0.call(this);
        case 1:
          return cljs$core$sp3__1.call(this, x);
        case 2:
          return cljs$core$sp3__2.call(this, x, y);
        case 3:
          return cljs$core$sp3__3.call(this, x, y, z);
        default:
          var G__17910 = null;
          if (arguments.length > 3) {
            var G__17911__i = 0, G__17911__a = new Array(arguments.length - 3);
            while (G__17911__i < G__17911__a.length) {
              G__17911__a[G__17911__i] = arguments[G__17911__i + 3];
              ++G__17911__i;
            }
            G__17910 = new cljs.core.IndexedSeq(G__17911__a, 0);
          }
          return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17910);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    cljs$core$sp3.cljs$lang$maxFixedArity = 3;
    cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp3;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$spn = null;
      var cljs$core$spn__0 = function() {
        return null;
      };
      var cljs$core$spn__1 = function(x) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__17702_SHARP_) {
            var G__17887 = x;
            return p1__17702_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17702_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17887) : p1__17702_SHARP_.call(null, G__17887);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__2 = function(x, y) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__17703_SHARP_) {
            var or__4276__auto__ = function() {
              var G__17889 = x;
              return p1__17703_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17703_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17889) : p1__17703_SHARP_.call(null, G__17889);
            }();
            if (cljs.core.truth_(or__4276__auto__)) {
              return or__4276__auto__;
            } else {
              var G__17890 = y;
              return p1__17703_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17703_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17890) : p1__17703_SHARP_.call(null, G__17890);
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__3 = function(x, y, z) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__17704_SHARP_) {
            var or__4276__auto__ = function() {
              var G__17892 = x;
              return p1__17704_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17704_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17892) : p1__17704_SHARP_.call(null, G__17892);
            }();
            if (cljs.core.truth_(or__4276__auto__)) {
              return or__4276__auto__;
            } else {
              var or__4276__auto____$1 = function() {
                var G__17894 = y;
                return p1__17704_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17704_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17894) : p1__17704_SHARP_.call(null, G__17894);
              }();
              if (cljs.core.truth_(or__4276__auto____$1)) {
                return or__4276__auto____$1;
              } else {
                var G__17895 = z;
                return p1__17704_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__17704_SHARP_.cljs$core$IFn$_invoke$arity$1(G__17895) : p1__17704_SHARP_.call(null, G__17895);
              }
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__4 = function() {
        var G__17912__delegate = function(x, y, z, args) {
          var or__4276__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(or__4276__auto__)) {
            return or__4276__auto__;
          } else {
            return cljs.core.some(function(or__4276__auto__, ps__$1) {
              return function(p1__17705_SHARP_) {
                return cljs.core.some(p1__17705_SHARP_, args);
              };
            }(or__4276__auto__, ps__$1), ps__$1);
          }
        };
        var G__17912 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__17913__i = 0, G__17913__a = new Array(arguments.length - 3);
            while (G__17913__i < G__17913__a.length) {
              G__17913__a[G__17913__i] = arguments[G__17913__i + 3];
              ++G__17913__i;
            }
            args = new cljs.core.IndexedSeq(G__17913__a, 0);
          }
          return G__17912__delegate.call(this, x, y, z, args);
        };
        G__17912.cljs$lang$maxFixedArity = 3;
        G__17912.cljs$lang$applyTo = function(arglist__17914) {
          var x = cljs.core.first(arglist__17914);
          arglist__17914 = cljs.core.next(arglist__17914);
          var y = cljs.core.first(arglist__17914);
          arglist__17914 = cljs.core.next(arglist__17914);
          var z = cljs.core.first(arglist__17914);
          var args = cljs.core.rest(arglist__17914);
          return G__17912__delegate(x, y, z, args);
        };
        G__17912.cljs$core$IFn$_invoke$arity$variadic = G__17912__delegate;
        return G__17912;
      }();
      cljs$core$spn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$spn__0.call(this);
          case 1:
            return cljs$core$spn__1.call(this, x);
          case 2:
            return cljs$core$spn__2.call(this, x, y);
          case 3:
            return cljs$core$spn__3.call(this, x, y, z);
          default:
            var G__17915 = null;
            if (arguments.length > 3) {
              var G__17916__i = 0, G__17916__a = new Array(arguments.length - 3);
              while (G__17916__i < G__17916__a.length) {
                G__17916__a[G__17916__i] = arguments[G__17916__i + 3];
                ++G__17916__i;
              }
              G__17915 = new cljs.core.IndexedSeq(G__17916__a, 0);
            }
            return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__17915);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      cljs$core$spn.cljs$lang$maxFixedArity = 3;
      cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$spn;
    }();
  }(ps__$1);
};
cljs.core.some_fn.cljs$lang$applyTo = function(seq17706) {
  var G__17707 = cljs.core.first(seq17706);
  var seq17706__$1 = cljs.core.next(seq17706);
  var G__17708 = cljs.core.first(seq17706__$1);
  var seq17706__$2 = cljs.core.next(seq17706__$1);
  var G__17709 = cljs.core.first(seq17706__$2);
  var seq17706__$3 = cljs.core.next(seq17706__$2);
  return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__17707, G__17708, G__17709, seq17706__$3);
};
cljs.core.some_fn.cljs$lang$maxFixedArity = 3;
cljs.core.map = function cljs$core$map() {
  var G__17924 = arguments.length;
  switch(G__17924) {
    case 1:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5328__auto__);
  }
};
cljs.core.map.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__17940 = null;
      var G__17940__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__17940__1 = function(result) {
        var G__17925 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17925) : rf.call(null, G__17925);
      };
      var G__17940__2 = function(result, input) {
        var G__17926 = result;
        var G__17927 = function() {
          var G__17928 = input;
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17928) : f.call(null, G__17928);
        }();
        return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17926, G__17927) : rf.call(null, G__17926, G__17927);
      };
      var G__17940__3 = function() {
        var G__17941__delegate = function(result, input, inputs) {
          var G__17929 = result;
          var G__17930 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f, input, inputs);
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17929, G__17930) : rf.call(null, G__17929, G__17930);
        };
        var G__17941 = function(result, input, var_args) {
          var inputs = null;
          if (arguments.length > 2) {
            var G__17942__i = 0, G__17942__a = new Array(arguments.length - 2);
            while (G__17942__i < G__17942__a.length) {
              G__17942__a[G__17942__i] = arguments[G__17942__i + 2];
              ++G__17942__i;
            }
            inputs = new cljs.core.IndexedSeq(G__17942__a, 0);
          }
          return G__17941__delegate.call(this, result, input, inputs);
        };
        G__17941.cljs$lang$maxFixedArity = 2;
        G__17941.cljs$lang$applyTo = function(arglist__17943) {
          var result = cljs.core.first(arglist__17943);
          arglist__17943 = cljs.core.next(arglist__17943);
          var input = cljs.core.first(arglist__17943);
          var inputs = cljs.core.rest(arglist__17943);
          return G__17941__delegate(result, input, inputs);
        };
        G__17941.cljs$core$IFn$_invoke$arity$variadic = G__17941__delegate;
        return G__17941;
      }();
      G__17940 = function(result, input, var_args) {
        var inputs = var_args;
        switch(arguments.length) {
          case 0:
            return G__17940__0.call(this);
          case 1:
            return G__17940__1.call(this, result);
          case 2:
            return G__17940__2.call(this, result, input);
          default:
            var G__17944 = null;
            if (arguments.length > 2) {
              var G__17945__i = 0, G__17945__a = new Array(arguments.length - 2);
              while (G__17945__i < G__17945__a.length) {
                G__17945__a[G__17945__i] = arguments[G__17945__i + 2];
                ++G__17945__i;
              }
              G__17944 = new cljs.core.IndexedSeq(G__17945__a, 0);
            }
            return G__17940__3.cljs$core$IFn$_invoke$arity$variadic(result, input, G__17944);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__17940.cljs$lang$maxFixedArity = 2;
      G__17940.cljs$lang$applyTo = G__17940__3.cljs$lang$applyTo;
      G__17940.cljs$core$IFn$_invoke$arity$0 = G__17940__0;
      G__17940.cljs$core$IFn$_invoke$arity$1 = G__17940__1;
      G__17940.cljs$core$IFn$_invoke$arity$2 = G__17940__2;
      G__17940.cljs$core$IFn$_invoke$arity$variadic = G__17940__3.cljs$core$IFn$_invoke$arity$variadic;
      return G__17940;
    }();
  };
};
cljs.core.map.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4126__auto__ = cljs.core.seq(coll);
    if (temp__4126__auto__) {
      var s = temp__4126__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5161__auto___17946 = size;
        var i_17947 = 0;
        while (true) {
          if (i_17947 < n__5161__auto___17946) {
            cljs.core.chunk_append(b, function() {
              var G__17931 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_17947);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17931) : f.call(null, G__17931);
            }());
            var G__17948 = i_17947 + 1;
            i_17947 = G__17948;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        return cljs.core.cons(function() {
          var G__17932 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17932) : f.call(null, G__17932);
        }(), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(function() {
        var G__17933 = cljs.core.first(s1);
        var G__17934 = cljs.core.first(s2);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__17933, G__17934) : f.call(null, G__17933, G__17934);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, cljs.core.rest(s1), cljs.core.rest(s2)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    var s3 = cljs.core.seq(c3);
    if (s1 && s2 && s3) {
      return cljs.core.cons(function() {
        var G__17935 = cljs.core.first(s1);
        var G__17936 = cljs.core.first(s2);
        var G__17937 = cljs.core.first(s3);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__17935, G__17936, G__17937) : f.call(null, G__17935, G__17936, G__17937);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, cljs.core.rest(s1), cljs.core.rest(s2), cljs.core.rest(s3)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  var step = function cljs$core$step(cs) {
    return new cljs.core.LazySeq(null, function() {
      var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cs);
      if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
        return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
      } else {
        return null;
      }
    }, null, null);
  };
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(step) {
    return function(p1__17917_SHARP_) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f, p1__17917_SHARP_);
    };
  }(step), step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c3, cljs.core.array_seq([c2, c1], 0))));
};
cljs.core.map.cljs$lang$applyTo = function(seq17918) {
  var G__17919 = cljs.core.first(seq17918);
  var seq17918__$1 = cljs.core.next(seq17918);
  var G__17920 = cljs.core.first(seq17918__$1);
  var seq17918__$2 = cljs.core.next(seq17918__$1);
  var G__17921 = cljs.core.first(seq17918__$2);
  var seq17918__$3 = cljs.core.next(seq17918__$2);
  var G__17922 = cljs.core.first(seq17918__$3);
  var seq17918__$4 = cljs.core.next(seq17918__$3);
  return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__17919, G__17920, G__17921, G__17922, seq17918__$4);
};
cljs.core.map.cljs$lang$maxFixedArity = 4;
cljs.core.take = function cljs$core$take() {
  var G__17950 = arguments.length;
  switch(G__17950) {
    case 1:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.take.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__17955 = null;
        var G__17955__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17955__1 = function(result) {
          var G__17951 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17951) : rf.call(null, G__17951);
        };
        var G__17955__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          var nn = cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          var result__$1 = n__$1 > 0 ? function() {
            var G__17952 = result;
            var G__17953 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17952, G__17953) : rf.call(null, G__17952, G__17953);
          }() : result;
          if (!(nn > 0)) {
            return cljs.core.ensure_reduced(result__$1);
          } else {
            return result__$1;
          }
        };
        G__17955 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17955__0.call(this);
            case 1:
              return G__17955__1.call(this, result);
            case 2:
              return G__17955__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17955.cljs$core$IFn$_invoke$arity$0 = G__17955__0;
        G__17955.cljs$core$IFn$_invoke$arity$1 = G__17955__1;
        G__17955.cljs$core$IFn$_invoke$arity$2 = G__17955__2;
        return G__17955;
      }();
    }(na);
  };
};
cljs.core.take.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return new cljs.core.LazySeq(null, function() {
    if (n > 0) {
      var temp__4126__auto__ = cljs.core.seq(coll);
      if (temp__4126__auto__) {
        var s = temp__4126__auto__;
        return cljs.core.cons(cljs.core.first(s), cljs.core.take.cljs$core$IFn$_invoke$arity$2(n - 1, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take.cljs$lang$maxFixedArity = 2;
cljs.core.drop = function cljs$core$drop() {
  var G__17957 = arguments.length;
  switch(G__17957) {
    case 1:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__17962 = null;
        var G__17962__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17962__1 = function(result) {
          var G__17958 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17958) : rf.call(null, G__17958);
        };
        var G__17962__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          if (n__$1 > 0) {
            return result;
          } else {
            var G__17959 = result;
            var G__17960 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17959, G__17960) : rf.call(null, G__17959, G__17960);
          }
        };
        G__17962 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17962__0.call(this);
            case 1:
              return G__17962__1.call(this, result);
            case 2:
              return G__17962__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17962.cljs$core$IFn$_invoke$arity$0 = G__17962__0;
        G__17962.cljs$core$IFn$_invoke$arity$1 = G__17962__1;
        G__17962.cljs$core$IFn$_invoke$arity$2 = G__17962__2;
        return G__17962;
      }();
    }(na);
  };
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  var step = function(n__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (n__$1 > 0 && s) {
        var G__17963 = n__$1 - 1;
        var G__17964 = cljs.core.rest(s);
        n__$1 = G__17963;
        coll__$1 = G__17964;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(n, coll);
    };
  }(step), null, null);
};
cljs.core.drop.cljs$lang$maxFixedArity = 2;
cljs.core.drop_last = function cljs$core$drop_last() {
  var G__17966 = arguments.length;
  switch(G__17966) {
    case 1:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = function(s) {
  return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(1, s);
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = function(n, s) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$3(function(x, _) {
    return x;
  }, s, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, s));
};
cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
cljs.core.take_last = function cljs$core$take_last(n, coll) {
  var s = cljs.core.seq(coll);
  var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll));
  while (true) {
    if (lead) {
      var G__17968 = cljs.core.next(s);
      var G__17969 = cljs.core.next(lead);
      s = G__17968;
      lead = G__17969;
      continue;
    } else {
      return s;
    }
    break;
  }
};
cljs.core.drop_while = function cljs$core$drop_while() {
  var G__17971 = arguments.length;
  switch(G__17971) {
    case 1:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    var da = cljs.core.volatile_BANG_(true);
    return function(da) {
      return function() {
        var G__17979 = null;
        var G__17979__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__17979__1 = function(result) {
          var G__17972 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__17972) : rf.call(null, G__17972);
        };
        var G__17979__2 = function(result, input) {
          var drop_QMARK_ = cljs.core.deref(da);
          if (cljs.core.truth_(function() {
            var and__4264__auto__ = drop_QMARK_;
            if (cljs.core.truth_(and__4264__auto__)) {
              var G__17973 = input;
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__17973) : pred.call(null, G__17973);
            } else {
              return and__4264__auto__;
            }
          }())) {
            return result;
          } else {
            cljs.core.vreset_BANG_(da, null);
            var G__17974 = result;
            var G__17975 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__17974, G__17975) : rf.call(null, G__17974, G__17975);
          }
        };
        G__17979 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__17979__0.call(this);
            case 1:
              return G__17979__1.call(this, result);
            case 2:
              return G__17979__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__17979.cljs$core$IFn$_invoke$arity$0 = G__17979__0;
        G__17979.cljs$core$IFn$_invoke$arity$1 = G__17979__1;
        G__17979.cljs$core$IFn$_invoke$arity$2 = G__17979__2;
        return G__17979;
      }();
    }(da);
  };
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  var step = function(pred__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (cljs.core.truth_(function() {
        var and__4264__auto__ = s;
        if (and__4264__auto__) {
          var G__17977 = cljs.core.first(s);
          return pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__17977) : pred__$1.call(null, G__17977);
        } else {
          return and__4264__auto__;
        }
      }())) {
        var G__17980 = pred__$1;
        var G__17981 = cljs.core.rest(s);
        pred__$1 = G__17980;
        coll__$1 = G__17981;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(pred, coll);
    };
  }(step), null, null);
};
cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
cljs.core.cycle = function cljs$core$cycle(coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4126__auto__ = cljs.core.seq(coll);
    if (temp__4126__auto__) {
      var s = temp__4126__auto__;
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s, cljs$core$cycle(s));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.split_at = function cljs$core$split_at(n, coll) {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, coll), cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll)], null);
};
cljs.core.repeat = function cljs$core$repeat() {
  var G__17984 = arguments.length;
  switch(G__17984) {
    case 1:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(x, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
  }, null, null);
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = function(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeat.cljs$lang$maxFixedArity = 2;
cljs.core.replicate = function cljs$core$replicate(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeatedly = function cljs$core$repeatedly() {
  var G__17987 = arguments.length;
  switch(G__17987) {
    case 1:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    }(), cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
  }, null, null);
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = function(n, f) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
};
cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
cljs.core.iterate = function cljs$core$iterate(f, x) {
  return cljs.core.cons(x, new cljs.core.LazySeq(null, function() {
    return cljs$core$iterate(f, function() {
      var G__17992 = x;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__17992) : f.call(null, G__17992);
    }());
  }, null, null));
};
cljs.core.interleave = function cljs$core$interleave() {
  var G__17997 = arguments.length;
  switch(G__17997) {
    case 2:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 2), 0);
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__5328__auto__);
  }
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = function(c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(cljs.core.first(s1), cljs.core.cons(cljs.core.first(s2), cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1), cljs.core.rest(s2))));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = function(c1, c2, colls) {
  return new cljs.core.LazySeq(null, function() {
    var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c2, cljs.core.array_seq([c1], 0)));
    if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave, cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$lang$applyTo = function(seq17993) {
  var G__17994 = cljs.core.first(seq17993);
  var seq17993__$1 = cljs.core.next(seq17993);
  var G__17995 = cljs.core.first(seq17993__$1);
  var seq17993__$2 = cljs.core.next(seq17993__$1);
  return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__17994, G__17995, seq17993__$2);
};
cljs.core.interleave.cljs$lang$maxFixedArity = 2;
cljs.core.interpose = function cljs$core$interpose() {
  var G__18000 = arguments.length;
  switch(G__18000) {
    case 1:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = function(sep) {
  return function(rf) {
    var started = cljs.core.volatile_BANG_(false);
    return function(started) {
      return function() {
        var G__18009 = null;
        var G__18009__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__18009__1 = function(result) {
          var G__18001 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18001) : rf.call(null, G__18001);
        };
        var G__18009__2 = function(result, input) {
          if (cljs.core.truth_(cljs.core.deref(started))) {
            var sepr = function() {
              var G__18002 = result;
              var G__18003 = sep;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18002, G__18003) : rf.call(null, G__18002, G__18003);
            }();
            if (cljs.core.reduced_QMARK_(sepr)) {
              return sepr;
            } else {
              var G__18004 = sepr;
              var G__18005 = input;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18004, G__18005) : rf.call(null, G__18004, G__18005);
            }
          } else {
            cljs.core.vreset_BANG_(started, true);
            var G__18006 = result;
            var G__18007 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18006, G__18007) : rf.call(null, G__18006, G__18007);
          }
        };
        G__18009 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__18009__0.call(this);
            case 1:
              return G__18009__1.call(this, result);
            case 2:
              return G__18009__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__18009.cljs$core$IFn$_invoke$arity$0 = G__18009__0;
        G__18009.cljs$core$IFn$_invoke$arity$1 = G__18009__1;
        G__18009.cljs$core$IFn$_invoke$arity$2 = G__18009__2;
        return G__18009;
      }();
    }(started);
  };
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = function(sep, coll) {
  return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(1, cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep), coll));
};
cljs.core.interpose.cljs$lang$maxFixedArity = 2;
cljs.core.flatten1 = function cljs$core$flatten1(colls) {
  var cat = function cljs$core$flatten1_$_cat(coll, colls__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__4124__auto__ = cljs.core.seq(coll);
      if (temp__4124__auto__) {
        var coll__$1 = temp__4124__auto__;
        return cljs.core.cons(cljs.core.first(coll__$1), cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1), colls__$1));
      } else {
        if (cljs.core.seq(colls__$1)) {
          return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1), cljs.core.rest(colls__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(null, colls);
};
cljs.core.mapcat = function cljs$core$mapcat() {
  var G__18021 = arguments.length;
  switch(G__18021) {
    case 1:
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0);
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5328__auto__);
  }
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f), cljs.core.cat);
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = function(f, colls) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat, cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map, f, colls));
};
cljs.core.mapcat.cljs$lang$applyTo = function(seq18018) {
  var G__18019 = cljs.core.first(seq18018);
  var seq18018__$1 = cljs.core.next(seq18018);
  return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__18019, seq18018__$1);
};
cljs.core.mapcat.cljs$lang$maxFixedArity = 1;
cljs.core.filter = function cljs$core$filter() {
  var G__18024 = arguments.length;
  switch(G__18024) {
    case 1:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__18032 = null;
      var G__18032__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__18032__1 = function(result) {
        var G__18025 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18025) : rf.call(null, G__18025);
      };
      var G__18032__2 = function(result, input) {
        if (cljs.core.truth_(function() {
          var G__18026 = input;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18026) : pred.call(null, G__18026);
        }())) {
          var G__18027 = result;
          var G__18028 = input;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18027, G__18028) : rf.call(null, G__18027, G__18028);
        } else {
          return result;
        }
      };
      G__18032 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__18032__0.call(this);
          case 1:
            return G__18032__1.call(this, result);
          case 2:
            return G__18032__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__18032.cljs$core$IFn$_invoke$arity$0 = G__18032__0;
      G__18032.cljs$core$IFn$_invoke$arity$1 = G__18032__1;
      G__18032.cljs$core$IFn$_invoke$arity$2 = G__18032__2;
      return G__18032;
    }();
  };
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4126__auto__ = cljs.core.seq(coll);
    if (temp__4126__auto__) {
      var s = temp__4126__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__5161__auto___18033 = size;
        var i_18034 = 0;
        while (true) {
          if (i_18034 < n__5161__auto___18033) {
            if (cljs.core.truth_(function() {
              var G__18029 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_18034);
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18029) : pred.call(null, G__18029);
            }())) {
              cljs.core.chunk_append(b, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_18034));
            } else {
            }
            var G__18035 = i_18034 + 1;
            i_18034 = G__18035;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.chunk_rest(s)));
      } else {
        var f = cljs.core.first(s);
        var r = cljs.core.rest(s);
        if (cljs.core.truth_(function() {
          var G__18030 = f;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18030) : pred.call(null, G__18030);
        }())) {
          return cljs.core.cons(f, cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r));
        } else {
          return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r);
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.filter.cljs$lang$maxFixedArity = 2;
cljs.core.remove = function cljs$core$remove() {
  var G__18037 = arguments.length;
  switch(G__18037) {
    case 1:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred), coll);
};
cljs.core.remove.cljs$lang$maxFixedArity = 2;
cljs.core.tree_seq = function cljs$core$tree_seq(branch_QMARK_, children, root) {
  var walk = function cljs$core$tree_seq_$_walk(node) {
    return new cljs.core.LazySeq(null, function() {
      return cljs.core.cons(node, cljs.core.truth_(function() {
        var G__18045 = node;
        return branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__18045) : branch_QMARK_.call(null, G__18045);
      }()) ? cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk, cljs.core.array_seq([function() {
        var G__18046 = node;
        return children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__18046) : children.call(null, G__18046);
      }()], 0)) : null);
    }, null, null);
  };
  return walk(root);
};
cljs.core.flatten = function cljs$core$flatten(x) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(function(p1__18047_SHARP_) {
    return!cljs.core.sequential_QMARK_(p1__18047_SHARP_);
  }, cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_, cljs.core.seq, x)));
};
cljs.core.into = function cljs$core$into() {
  var G__18049 = arguments.length;
  switch(G__18049) {
    case 2:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$2 = function(to, from) {
  if (!(to == null)) {
    if (function() {
      var G__18050 = to;
      if (G__18050) {
        var bit__4943__auto__ = G__18050.cljs$lang$protocol_mask$partition1$ & 4;
        if (bit__4943__auto__ || G__18050.cljs$core$IEditableCollection$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }()) {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
    } else {
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, to, from);
    }
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, from);
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$3 = function(to, xform, from) {
  if (function() {
    var G__18051 = to;
    if (G__18051) {
      var bit__4943__auto__ = G__18051.cljs$lang$protocol_mask$partition1$ & 4;
      if (bit__4943__auto__ || G__18051.cljs$core$IEditableCollection$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
  } else {
    return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj, to, from);
  }
};
cljs.core.into.cljs$lang$maxFixedArity = 3;
cljs.core.mapv = function cljs$core$mapv() {
  var G__18059 = arguments.length;
  switch(G__18059) {
    case 2:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 4), 0);
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__5328__auto__);
  }
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, function() {
      var G__18060 = o;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18060) : f.call(null, G__18060);
    }());
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, c1, c2));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, c1, c2, c3));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map, f, c1, c2, c3, cljs.core.array_seq([colls], 0)));
};
cljs.core.mapv.cljs$lang$applyTo = function(seq18053) {
  var G__18054 = cljs.core.first(seq18053);
  var seq18053__$1 = cljs.core.next(seq18053);
  var G__18055 = cljs.core.first(seq18053__$1);
  var seq18053__$2 = cljs.core.next(seq18053__$1);
  var G__18056 = cljs.core.first(seq18053__$2);
  var seq18053__$3 = cljs.core.next(seq18053__$2);
  var G__18057 = cljs.core.first(seq18053__$3);
  var seq18053__$4 = cljs.core.next(seq18053__$3);
  return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__18054, G__18055, G__18056, G__18057, seq18053__$4);
};
cljs.core.mapv.cljs$lang$maxFixedArity = 4;
cljs.core.filterv = function cljs$core$filterv(pred, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    if (cljs.core.truth_(function() {
      var G__18063 = o;
      return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18063) : pred.call(null, G__18063);
    }())) {
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, o);
    } else {
      return v;
    }
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.partition = function cljs$core$partition() {
  var G__18065 = arguments.length;
  switch(G__18065) {
    case 2:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4126__auto__ = cljs.core.seq(coll);
    if (temp__4126__auto__) {
      var s = temp__4126__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = function(n, step, pad, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4126__auto__ = cljs.core.seq(coll);
    if (temp__4126__auto__) {
      var s = temp__4126__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n, step, pad, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return cljs.core._conj(cljs.core.List.EMPTY, cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p, pad)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$lang$maxFixedArity = 4;
cljs.core.get_in = function cljs$core$get_in() {
  var G__18068 = arguments.length;
  switch(G__18068) {
    case 2:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = function(m, ks) {
  return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(m, ks, null);
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = function(m, ks, not_found) {
  var sentinel = cljs.core.lookup_sentinel;
  var m__$1 = m;
  var ks__$1 = cljs.core.seq(ks);
  while (true) {
    if (ks__$1) {
      if (!function() {
        var G__18069 = m__$1;
        if (G__18069) {
          var bit__4950__auto__ = G__18069.cljs$lang$protocol_mask$partition0$ & 256;
          if (bit__4950__auto__ || G__18069.cljs$core$ILookup$) {
            return true;
          } else {
            if (!G__18069.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, G__18069);
            } else {
              return false;
            }
          }
        } else {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, G__18069);
        }
      }()) {
        return not_found;
      } else {
        var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1, cljs.core.first(ks__$1), sentinel);
        if (sentinel === m__$2) {
          return not_found;
        } else {
          var G__18071 = sentinel;
          var G__18072 = m__$2;
          var G__18073 = cljs.core.next(ks__$1);
          sentinel = G__18071;
          m__$1 = G__18072;
          ks__$1 = G__18073;
          continue;
        }
      }
    } else {
      return m__$1;
    }
    break;
  }
};
cljs.core.get_in.cljs$lang$maxFixedArity = 3;
cljs.core.assoc_in = function cljs$core$assoc_in(m, p__18074, v) {
  var vec__18079 = p__18074;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18079, 0, null);
  var ks = cljs.core.nthnext(vec__18079, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, v));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
  }
};
cljs.core.update_in = function cljs$core$update_in() {
  var G__18088 = arguments.length;
  switch(G__18088) {
    case 3:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5328__auto__);
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = function(m, p__18089, f) {
  var vec__18090 = p__18089;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18090, 0, null);
  var ks = cljs.core.nthnext(vec__18090, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__18091 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18091) : f.call(null, G__18091);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = function(m, p__18092, f, a) {
  var vec__18093 = p__18092;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18093, 0, null);
  var ks = cljs.core.nthnext(vec__18093, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__18094 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__18095 = a;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18094, G__18095) : f.call(null, G__18094, G__18095);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = function(m, p__18096, f, a, b) {
  var vec__18097 = p__18096;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18097, 0, null);
  var ks = cljs.core.nthnext(vec__18097, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__18098 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__18099 = a;
      var G__18100 = b;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18098, G__18099, G__18100) : f.call(null, G__18098, G__18099, G__18100);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = function(m, p__18101, f, a, b, c) {
  var vec__18102 = p__18101;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18102, 0, null);
  var ks = cljs.core.nthnext(vec__18102, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b, c));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__18103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__18104 = a;
      var G__18105 = b;
      var G__18106 = c;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__18103, G__18104, G__18105, G__18106) : f.call(null, G__18103, G__18104, G__18105, G__18106);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = function(m, p__18107, f, a, b, c, args) {
  var vec__18108 = p__18107;
  var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18108, 0, null);
  var ks = cljs.core.nthnext(vec__18108, 1);
  if (cljs.core.truth_(ks)) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, cljs.core.array_seq([b, c, args], 0)));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), a, b, c, cljs.core.array_seq([args], 0)));
  }
};
cljs.core.update_in.cljs$lang$applyTo = function(seq18080) {
  var G__18081 = cljs.core.first(seq18080);
  var seq18080__$1 = cljs.core.next(seq18080);
  var G__18082 = cljs.core.first(seq18080__$1);
  var seq18080__$2 = cljs.core.next(seq18080__$1);
  var G__18083 = cljs.core.first(seq18080__$2);
  var seq18080__$3 = cljs.core.next(seq18080__$2);
  var G__18084 = cljs.core.first(seq18080__$3);
  var seq18080__$4 = cljs.core.next(seq18080__$3);
  var G__18085 = cljs.core.first(seq18080__$4);
  var seq18080__$5 = cljs.core.next(seq18080__$4);
  var G__18086 = cljs.core.first(seq18080__$5);
  var seq18080__$6 = cljs.core.next(seq18080__$5);
  return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__18081, G__18082, G__18083, G__18084, G__18085, G__18086, seq18080__$6);
};
cljs.core.update_in.cljs$lang$maxFixedArity = 6;
cljs.core.update = function cljs$core$update() {
  var G__18118 = arguments.length;
  switch(G__18118) {
    case 3:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 6), 0);
      return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__5328__auto__);
  }
};
cljs.core.update.cljs$core$IFn$_invoke$arity$3 = function(m, k, f) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__18119 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18119) : f.call(null, G__18119);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$4 = function(m, k, f, x) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__18120 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__18121 = x;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18120, G__18121) : f.call(null, G__18120, G__18121);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$5 = function(m, k, f, x, y) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__18122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__18123 = x;
    var G__18124 = y;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18122, G__18123, G__18124) : f.call(null, G__18122, G__18123, G__18124);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$6 = function(m, k, f, x, y, z) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__18125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__18126 = x;
    var G__18127 = y;
    var G__18128 = z;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__18125, G__18126, G__18127, G__18128) : f.call(null, G__18125, G__18126, G__18127, G__18128);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = function(m, k, f, x, y, z, more) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), x, y, z, cljs.core.array_seq([more], 0)));
};
cljs.core.update.cljs$lang$applyTo = function(seq18110) {
  var G__18111 = cljs.core.first(seq18110);
  var seq18110__$1 = cljs.core.next(seq18110);
  var G__18112 = cljs.core.first(seq18110__$1);
  var seq18110__$2 = cljs.core.next(seq18110__$1);
  var G__18113 = cljs.core.first(seq18110__$2);
  var seq18110__$3 = cljs.core.next(seq18110__$2);
  var G__18114 = cljs.core.first(seq18110__$3);
  var seq18110__$4 = cljs.core.next(seq18110__$3);
  var G__18115 = cljs.core.first(seq18110__$4);
  var seq18110__$5 = cljs.core.next(seq18110__$4);
  var G__18116 = cljs.core.first(seq18110__$5);
  var seq18110__$6 = cljs.core.next(seq18110__$5);
  return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__18111, G__18112, G__18113, G__18114, G__18115, G__18116, seq18110__$6);
};
cljs.core.update.cljs$lang$maxFixedArity = 6;
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr;
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";
cljs.core.VectorNode.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/VectorNode");
};
cljs.core.__GT_VectorNode = function cljs$core$__GT_VectorNode(edit, arr) {
  return new cljs.core.VectorNode(edit, arr);
};
cljs.core.pv_fresh_node = function cljs$core$pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
};
cljs.core.pv_aget = function cljs$core$pv_aget(node, idx) {
  return node.arr[idx];
};
cljs.core.pv_aset = function cljs$core$pv_aset(node, idx, val) {
  return node.arr[idx] = val;
};
cljs.core.pv_clone_node = function cljs$core$pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone(node.arr));
};
cljs.core.tail_off = function cljs$core$tail_off(pv) {
  var cnt = pv.cnt;
  if (cnt < 32) {
    return 0;
  } else {
    return cnt - 1 >>> 5 << 5;
  }
};
cljs.core.new_path = function cljs$core$new_path(edit, level, node) {
  var ll = level;
  var ret = node;
  while (true) {
    if (ll === 0) {
      return ret;
    } else {
      var embed = ret;
      var r = cljs.core.pv_fresh_node(edit);
      var _ = cljs.core.pv_aset(r, 0, embed);
      var G__18130 = ll - 5;
      var G__18131 = r;
      ll = G__18130;
      ret = G__18131;
      continue;
    }
    break;
  }
};
cljs.core.push_tail = function cljs$core$push_tail(pv, level, parent, tailnode) {
  var ret = cljs.core.pv_clone_node(parent);
  var subidx = pv.cnt - 1 >>> level & 31;
  if (5 === level) {
    cljs.core.pv_aset(ret, subidx, tailnode);
    return ret;
  } else {
    var child = cljs.core.pv_aget(parent, subidx);
    if (!(child == null)) {
      var node_to_insert = cljs$core$push_tail(pv, level - 5, child, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    } else {
      var node_to_insert = cljs.core.new_path(null, level - 5, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    }
  }
};
cljs.core.vector_index_out_of_bounds = function cljs$core$vector_index_out_of_bounds(i, cnt) {
  throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(cnt)].join(""));
};
cljs.core.first_array_for_longvec = function cljs$core$first_array_for_longvec(pv) {
  var node = pv.root;
  var level = pv.shift;
  while (true) {
    if (level > 0) {
      var G__18136 = cljs.core.pv_aget(node, 0);
      var G__18137 = level - 5;
      node = G__18136;
      level = G__18137;
      continue;
    } else {
      return node.arr;
    }
    break;
  }
};
cljs.core.unchecked_array_for = function cljs$core$unchecked_array_for(pv, i) {
  if (i >= cljs.core.tail_off(pv)) {
    return pv.tail;
  } else {
    var node = pv.root;
    var level = pv.shift;
    while (true) {
      if (level > 0) {
        var G__18138 = cljs.core.pv_aget(node, i >>> level & 31);
        var G__18139 = level - 5;
        node = G__18138;
        level = G__18139;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.array_for = function cljs$core$array_for(pv, i) {
  if (0 <= i && i < pv.cnt) {
    return cljs.core.unchecked_array_for(pv, i);
  } else {
    return cljs.core.vector_index_out_of_bounds(i, pv.cnt);
  }
};
cljs.core.do_assoc = function cljs$core$do_assoc(pv, level, node, i, val) {
  var ret = cljs.core.pv_clone_node(node);
  if (level === 0) {
    cljs.core.pv_aset(ret, i & 31, val);
    return ret;
  } else {
    var subidx = i >>> level & 31;
    cljs.core.pv_aset(ret, subidx, cljs$core$do_assoc(pv, level - 5, cljs.core.pv_aget(node, subidx), i, val));
    return ret;
  }
};
cljs.core.pop_tail = function cljs$core$pop_tail(pv, level, node) {
  var subidx = pv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$pop_tail(pv, level - 5, cljs.core.pv_aget(node, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, new_child);
      return ret;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, null);
      return ret;
    }
  }
};
cljs.core.RangedIterator = function(i, base, arr, v, start, end) {
  this.i = i;
  this.base = base;
  this.arr = arr;
  this.v = v;
  this.start = start;
  this.end = end;
};
cljs.core.RangedIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  return self__.i < self__.end;
};
cljs.core.RangedIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (self__.i - self__.base === 32) {
    self__.arr = cljs.core.unchecked_array_for(self__.v, self__.i);
    self__.base = self__.base + 32;
  } else {
  }
  var ret = self__.arr[self__.i & 31];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.RangedIterator.cljs$lang$type = true;
cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";
cljs.core.RangedIterator.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/RangedIterator");
};
cljs.core.__GT_RangedIterator = function cljs$core$__GT_RangedIterator(i, base, arr, v, start, end) {
  return new cljs.core.RangedIterator(i, base, arr, v, start, end);
};
cljs.core.ranged_iterator = function cljs$core$ranged_iterator(v, start, end) {
  var i = start;
  return new cljs.core.RangedIterator(i, i - i % 32, start < cljs.core.count(v) ? cljs.core.unchecked_array_for(v, i) : null, v, start, end);
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167668511;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentVector.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentVector.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__18149 = init__$2;
              var G__18150 = j + i;
              var G__18151 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18149, G__18150, G__18151) : f.call(null, G__18149, G__18150, G__18151);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__18162 = j + 1;
              var G__18163 = init__$3;
              j = G__18162;
              init__$2 = G__18163;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__18152 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18152) : cljs.core.deref.call(null, G__18152);
      } else {
        var G__18164 = i + len;
        var G__18165 = init__$2;
        i = G__18164;
        init__$1 = G__18165;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_for(coll__$1, n)[n & 31];
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core.unchecked_array_for(coll__$1, n)[n & 31];
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    if (cljs.core.tail_off(coll__$1) <= n) {
      var new_tail = cljs.core.aclone(self__.tail);
      new_tail[n & 31] = val;
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, new_tail, null);
    } else {
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, cljs.core.do_assoc(coll__$1, self__.shift, self__.root, n, val), self__.tail, null);
    }
  } else {
    if (n === self__.cnt) {
      return cljs.core._conj(coll__$1, val);
    } else {
      throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds  [0,"), cljs.core.str(self__.cnt), cljs.core.str("]")].join(""));
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.ranged_iterator(this$__$1, 0, self__.cnt);
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 0);
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, 1);
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, self__.cnt - 1);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    throw new Error("Can't pop empty vector");
  } else {
    if (1 === self__.cnt) {
      return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
    } else {
      if (1 < self__.cnt - cljs.core.tail_off(coll__$1)) {
        return new cljs.core.PersistentVector(self__.meta, self__.cnt - 1, self__.shift, self__.root, self__.tail.slice(0, -1), null);
      } else {
        var new_tail = cljs.core.unchecked_array_for(coll__$1, self__.cnt - 2);
        var nr = cljs.core.pop_tail(coll__$1, self__.shift, self__.root);
        var new_root = nr == null ? cljs.core.PersistentVector.EMPTY_NODE : nr;
        var cnt_1 = self__.cnt - 1;
        if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift - 5, cljs.core.pv_aget(new_root, 0), new_tail, null);
        } else {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift, new_root, new_tail, null);
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return new cljs.core.RSeq(coll__$1, self__.cnt - 1, null);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (other instanceof cljs.core.PersistentVector) {
    if (self__.cnt === cljs.core.count(other)) {
      var me_iter = cljs.core._iterator(coll__$1);
      var you_iter = cljs.core._iterator(other);
      while (true) {
        if (cljs.core.truth_(me_iter.hasNext())) {
          var x = me_iter.next();
          var y = you_iter.next();
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
            continue;
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_sequential(coll__$1, other);
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientVector(self__.cnt, self__.shift, function() {
    var G__18153 = self__.root;
    return cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__18153) : cljs.core.tv_editable_root.call(null, G__18153);
  }(), function() {
    var G__18154 = self__.tail;
    return cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__18154) : cljs.core.tv_editable_tail.call(null, G__18154);
  }());
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var self__ = this;
  var v__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1, f);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__18155 = init__$2;
              var G__18156 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18155, G__18156) : f.call(null, G__18155, G__18156);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__18166 = j + 1;
              var G__18167 = init__$3;
              j = G__18166;
              init__$2 = G__18167;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__18157 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18157) : cljs.core.deref.call(null, G__18157);
      } else {
        var G__18168 = i + len;
        var G__18169 = init__$2;
        i = G__18168;
        init__$1 = G__18169;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._assoc_n(coll__$1, k, v);
  } else {
    throw new Error("Vector's key for assoc must be a number.");
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    return null;
  } else {
    if (self__.cnt <= 32) {
      return new cljs.core.IndexedSeq(self__.tail, 0);
    } else {
      var G__18158 = coll__$1;
      var G__18159 = cljs.core.first_array_for_longvec(coll__$1);
      var G__18160 = 0;
      var G__18161 = 0;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18158, G__18159, G__18160, G__18161) : cljs.core.chunked_seq.call(null, G__18158, G__18159, G__18160, G__18161);
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(meta__$1, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt - cljs.core.tail_off(coll__$1) < 32) {
    var len = self__.tail.length;
    var new_tail = new Array(len + 1);
    var n__5161__auto___18170 = len;
    var i_18171 = 0;
    while (true) {
      if (i_18171 < n__5161__auto___18170) {
        new_tail[i_18171] = self__.tail[i_18171];
        var G__18172 = i_18171 + 1;
        i_18171 = G__18172;
        continue;
      } else {
      }
      break;
    }
    new_tail[len] = o;
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, self__.shift, self__.root, new_tail, null);
  } else {
    var root_overflow_QMARK_ = self__.cnt >>> 5 > 1 << self__.shift;
    var new_shift = root_overflow_QMARK_ ? self__.shift + 5 : self__.shift;
    var new_root = root_overflow_QMARK_ ? function() {
      var n_r = cljs.core.pv_fresh_node(null);
      cljs.core.pv_aset(n_r, 0, self__.root);
      cljs.core.pv_aset(n_r, 1, cljs.core.new_path(null, self__.shift, new cljs.core.VectorNode(null, self__.tail)));
      return n_r;
    }() : cljs.core.push_tail(coll__$1, self__.shift, self__.root, new cljs.core.VectorNode(null, self__.tail));
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, new_shift, new_root, [o], null);
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__18173 = null;
  var G__18173__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__18173__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__18173 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18173__2.call(this, self__, k);
      case 3:
        return G__18173__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18173.cljs$core$IFn$_invoke$arity$2 = G__18173__2;
  G__18173.cljs$core$IFn$_invoke$arity$3 = G__18173__3;
  return G__18173;
}();
cljs.core.PersistentVector.prototype.apply = function(self__, args18148) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18148)));
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";
cljs.core.PersistentVector.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/PersistentVector");
};
cljs.core.__GT_PersistentVector = function cljs$core$__GT_PersistentVector(meta, cnt, shift, root, tail, __hash) {
  return new cljs.core.PersistentVector(meta, cnt, shift, root, tail, __hash);
};
cljs.core.PersistentVector.EMPTY_NODE = new cljs.core.VectorNode(null, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], cljs.core.empty_ordered_hash);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l = xs.length;
  var xs__$1 = no_clone ? xs : cljs.core.aclone(xs);
  if (l < 32) {
    return new cljs.core.PersistentVector(null, l, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__$1, null);
  } else {
    var node = xs__$1.slice(0, 32);
    var v = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node, null);
    var i = 32;
    var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
    while (true) {
      if (i < l) {
        var G__18174 = i + 1;
        var G__18175 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out, xs__$1[i]);
        i = G__18174;
        out = G__18175;
        continue;
      } else {
        return cljs.core.persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.vec = function cljs$core$vec(coll) {
  if (cljs.core.array_QMARK_(coll)) {
    return cljs.core.PersistentVector.fromArray(coll, true);
  } else {
    return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core._as_transient(cljs.core.PersistentVector.EMPTY), coll));
  }
};
cljs.core.vector = function cljs$core$vector() {
  var argseq__5316__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
};
cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = function(args) {
  if (args instanceof cljs.core.IndexedSeq && args.i === 0) {
    return cljs.core.PersistentVector.fromArray(args.arr, true);
  } else {
    return cljs.core.vec(args);
  }
};
cljs.core.vector.cljs$lang$maxFixedArity = 0;
cljs.core.vector.cljs$lang$applyTo = function(seq18176) {
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18176));
};
cljs.core.ChunkedSeq = function(vec, node, i, off, meta, __hash) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375020;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__18177 = self__.vec;
      var G__18178 = self__.node;
      var G__18179 = self__.i;
      var G__18180 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18177, G__18178, G__18179, G__18180) : cljs.core.chunked_seq.call(null, G__18177, G__18178, G__18179, G__18180);
    }();
    if (s == null) {
      return null;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_next(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(function() {
    var G__18181 = self__.vec;
    var G__18182 = self__.i + self__.off;
    var G__18183 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__18181, G__18182, G__18183) : cljs.core.subvec.call(null, G__18181, G__18182, G__18183);
  }(), f);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(function() {
    var G__18184 = self__.vec;
    var G__18185 = self__.i + self__.off;
    var G__18186 = cljs.core.count(self__.vec);
    return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__18184, G__18185, G__18186) : cljs.core.subvec.call(null, G__18184, G__18185, G__18186);
  }(), f, start);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.node[self__.off];
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = function() {
      var G__18187 = self__.vec;
      var G__18188 = self__.node;
      var G__18189 = self__.i;
      var G__18190 = self__.off + 1;
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18187, G__18188, G__18189, G__18190) : cljs.core.chunked_seq.call(null, G__18187, G__18188, G__18189, G__18190);
    }();
    if (s == null) {
      return cljs.core.List.EMPTY;
    } else {
      return s;
    }
  } else {
    return cljs.core._chunked_rest(coll__$1);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node, self__.off);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__18191 = self__.vec;
    var G__18192 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__18193 = end;
    var G__18194 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18191, G__18192, G__18193, G__18194) : cljs.core.chunked_seq.call(null, G__18191, G__18192, G__18193, G__18194);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  var G__18195 = self__.vec;
  var G__18196 = self__.node;
  var G__18197 = self__.i;
  var G__18198 = self__.off;
  var G__18199 = m;
  return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__18195, G__18196, G__18197, G__18198, G__18199) : cljs.core.chunked_seq.call(null, G__18195, G__18196, G__18197, G__18198, G__18199);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    var G__18200 = self__.vec;
    var G__18201 = cljs.core.unchecked_array_for(self__.vec, end);
    var G__18202 = end;
    var G__18203 = 0;
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__18200, G__18201, G__18202, G__18203) : cljs.core.chunked_seq.call(null, G__18200, G__18201, G__18202, G__18203);
  } else {
    return null;
  }
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";
cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ChunkedSeq");
};
cljs.core.__GT_ChunkedSeq = function cljs$core$__GT_ChunkedSeq(vec, node, i, off, meta, __hash) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, __hash);
};
cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.chunked_seq = function cljs$core$chunked_seq() {
  var G__18205 = arguments.length;
  switch(G__18205) {
    case 3:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = function(vec, i, off) {
  return new cljs.core.ChunkedSeq(vec, cljs.core.array_for(vec, i), i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = function(vec, node, i, off) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = function(vec, node, i, off, meta) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, null);
};
cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167666463;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Subvec.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Subvec.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var i = self__.start;
  var j = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.end) {
      var init__$2 = function() {
        var G__18208 = init__$1;
        var G__18209 = j;
        var G__18210 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18208, G__18209, G__18210) : f.call(null, G__18208, G__18209, G__18210);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__18211 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18211) : cljs.core.deref.call(null, G__18211);
      } else {
        var G__18233 = i + 1;
        var G__18234 = j + 1;
        var G__18235 = init__$2;
        i = G__18233;
        j = G__18234;
        init__$1 = G__18235;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return cljs.core.vector_index_out_of_bounds(n, self__.end - self__.start);
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.start + n);
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return not_found;
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v, self__.start + n, not_found);
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  var v_pos = self__.start + n;
  var G__18212 = self__.meta;
  var G__18213 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v, v_pos, val);
  var G__18214 = self__.start;
  var G__18215 = function() {
    var x__4588__auto__ = self__.end;
    var y__4589__auto__ = v_pos + 1;
    return x__4588__auto__ > y__4589__auto__ ? x__4588__auto__ : y__4589__auto__;
  }();
  var G__18216 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__18212, G__18213, G__18214, G__18215, G__18216) : cljs.core.build_subvec.call(null, G__18212, G__18213, G__18214, G__18215, G__18216);
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Subvec(self__.meta, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.end - self__.start;
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.end - 1);
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.start === self__.end) {
    throw new Error("Can't pop empty vector");
  } else {
    var G__18217 = self__.meta;
    var G__18218 = self__.v;
    var G__18219 = self__.start;
    var G__18220 = self__.end - 1;
    var G__18221 = null;
    return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__18217, G__18218, G__18219, G__18220, G__18221) : cljs.core.build_subvec.call(null, G__18217, G__18218, G__18219, G__18220, G__18221);
  }
};
cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.start === self__.end)) {
    return new cljs.core.RSeq(coll__$1, self__.end - self__.start - 1, null);
  } else {
    return null;
  }
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1, f);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1, f, start__$1);
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n(coll__$1, key, val);
  } else {
    throw new Error("Subvec's key for assoc must be a number.");
  }
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var subvec_seq = function(coll__$1) {
    return function cljs$core$subvec_seq(i) {
      if (i === self__.end) {
        return null;
      } else {
        return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i), new cljs.core.LazySeq(null, function(coll__$1) {
          return function() {
            return cljs$core$subvec_seq(i + 1);
          };
        }(coll__$1), null, null));
      }
    };
  }(coll__$1);
  return subvec_seq(self__.start);
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  var G__18223 = meta__$1;
  var G__18224 = self__.v;
  var G__18225 = self__.start;
  var G__18226 = self__.end;
  var G__18227 = self__.__hash;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__18223, G__18224, G__18225, G__18226, G__18227) : cljs.core.build_subvec.call(null, G__18223, G__18224, G__18225, G__18226, G__18227);
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  var G__18228 = self__.meta;
  var G__18229 = cljs.core._assoc_n(self__.v, self__.end, o);
  var G__18230 = self__.start;
  var G__18231 = self__.end + 1;
  var G__18232 = null;
  return cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__18228, G__18229, G__18230, G__18231, G__18232) : cljs.core.build_subvec.call(null, G__18228, G__18229, G__18230, G__18231, G__18232);
};
cljs.core.Subvec.prototype.call = function() {
  var G__18236 = null;
  var G__18236__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__18236__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__18236 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18236__2.call(this, self__, k);
      case 3:
        return G__18236__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18236.cljs$core$IFn$_invoke$arity$2 = G__18236__2;
  G__18236.cljs$core$IFn$_invoke$arity$3 = G__18236__3;
  return G__18236;
}();
cljs.core.Subvec.prototype.apply = function(self__, args18207) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18207)));
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";
cljs.core.Subvec.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/Subvec");
};
cljs.core.__GT_Subvec = function cljs$core$__GT_Subvec(meta, v, start, end, __hash) {
  return new cljs.core.Subvec(meta, v, start, end, __hash);
};
cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.build_subvec = function cljs$core$build_subvec(meta, v, start, end, __hash) {
  while (true) {
    if (v instanceof cljs.core.Subvec) {
      var G__18237 = meta;
      var G__18238 = v.v;
      var G__18239 = v.start + start;
      var G__18240 = v.start + end;
      var G__18241 = __hash;
      meta = G__18237;
      v = G__18238;
      start = G__18239;
      end = G__18240;
      __hash = G__18241;
      continue;
    } else {
      var c = cljs.core.count(v);
      if (start < 0 || end < 0 || start > c || end > c) {
        throw new Error("Index out of bounds");
      } else {
      }
      return new cljs.core.Subvec(meta, v, start, end, __hash);
    }
    break;
  }
};
cljs.core.subvec = function cljs$core$subvec() {
  var G__18243 = arguments.length;
  switch(G__18243) {
    case 2:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = function(v, start) {
  return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v, start, cljs.core.count(v));
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = function(v, start, end) {
  return cljs.core.build_subvec(null, v, start, end, null);
};
cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = function cljs$core$tv_ensure_editable(edit, node) {
  if (edit === node.edit) {
    return node;
  } else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone(node.arr));
  }
};
cljs.core.tv_editable_root = function cljs$core$tv_editable_root(node) {
  return new cljs.core.VectorNode(function() {
    var obj18248 = {};
    return obj18248;
  }(), cljs.core.aclone(node.arr));
};
cljs.core.tv_editable_tail = function cljs$core$tv_editable_tail(tl) {
  var ret = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
  cljs.core.array_copy(tl, 0, ret, 0, tl.length);
  return ret;
};
cljs.core.tv_push_tail = function cljs$core$tv_push_tail(tv, level, parent, tail_node) {
  var ret = cljs.core.tv_ensure_editable(tv.root.edit, parent);
  var subidx = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset(ret, subidx, level === 5 ? tail_node : function() {
    var child = cljs.core.pv_aget(ret, subidx);
    if (!(child == null)) {
      return cljs$core$tv_push_tail(tv, level - 5, child, tail_node);
    } else {
      return cljs.core.new_path(tv.root.edit, level - 5, tail_node);
    }
  }());
  return ret;
};
cljs.core.tv_pop_tail = function cljs$core$tv_pop_tail(tv, level, node) {
  var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit, node);
  var subidx = tv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = cljs$core$tv_pop_tail(tv, level - 5, cljs.core.pv_aget(node__$1, subidx));
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, new_child);
      return node__$1;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, null);
      return node__$1;
    }
  }
};
cljs.core.unchecked_editable_array_for = function cljs$core$unchecked_editable_array_for(tv, i) {
  if (i >= cljs.core.tail_off(tv)) {
    return tv.tail;
  } else {
    var root = tv.root;
    var node = root;
    var level = tv.shift;
    while (true) {
      if (level > 0) {
        var G__18256 = cljs.core.tv_ensure_editable(root.edit, cljs.core.pv_aget(node, i >>> level & 31));
        var G__18257 = level - 5;
        node = G__18256;
        level = G__18257;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 275;
  this.cljs$lang$protocol_mask$partition1$ = 88;
};
cljs.core.TransientVector.prototype.call = function() {
  var G__18261 = null;
  var G__18261__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__18261__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__18261 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18261__2.call(this, self__, k);
      case 3:
        return G__18261__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18261.cljs$core$IFn$_invoke$arity$2 = G__18261__2;
  G__18261.cljs$core$IFn$_invoke$arity$3 = G__18261__3;
  return G__18261;
}();
cljs.core.TransientVector.prototype.apply = function(self__, args18258) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18258)));
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return cljs.core.array_for(coll__$1, n)[n & 31];
  } else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1, n);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return self__.cnt;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (0 <= n && n < self__.cnt) {
      if (cljs.core.tail_off(tcoll__$1) <= n) {
        self__.tail[n & 31] = val;
        return tcoll__$1;
      } else {
        var new_root = function(tcoll__$1) {
          return function cljs$core$go(level, node) {
            var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit, node);
            if (level === 0) {
              cljs.core.pv_aset(node__$1, n & 31, val);
              return node__$1;
            } else {
              var subidx = n >>> level & 31;
              cljs.core.pv_aset(node__$1, subidx, cljs$core$go(level - 5, cljs.core.pv_aget(node__$1, subidx)));
              return node__$1;
            }
          };
        }(tcoll__$1).call(null, self__.shift, self__.root);
        self__.root = new_root;
        return tcoll__$1;
      }
    } else {
      if (n === self__.cnt) {
        return cljs.core._conj_BANG_(tcoll__$1, val);
      } else {
        throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(self__.cnt)].join(""));
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt === 0) {
      throw new Error("Can't pop empty vector");
    } else {
      if (1 === self__.cnt) {
        self__.cnt = 0;
        return tcoll__$1;
      } else {
        if ((self__.cnt - 1 & 31) > 0) {
          self__.cnt = self__.cnt - 1;
          return tcoll__$1;
        } else {
          var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1, self__.cnt - 2);
          var new_root = function() {
            var nr = cljs.core.tv_pop_tail(tcoll__$1, self__.shift, self__.root);
            if (!(nr == null)) {
              return nr;
            } else {
              return new cljs.core.VectorNode(self__.root.edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
            }
          }();
          if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
            var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit, cljs.core.pv_aget(new_root, 0));
            self__.root = new_root__$1;
            self__.shift = self__.shift - 5;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          } else {
            self__.root = new_root;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          }
        }
      }
    }
  } else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (typeof key === "number") {
    return cljs.core._assoc_n_BANG_(tcoll__$1, key, val);
  } else {
    throw new Error("TransientVector's key for assoc! must be a number.");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt - cljs.core.tail_off(tcoll__$1) < 32) {
      self__.tail[self__.cnt & 31] = o;
      self__.cnt = self__.cnt + 1;
      return tcoll__$1;
    } else {
      var tail_node = new cljs.core.VectorNode(self__.root.edit, self__.tail);
      var new_tail = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      new_tail[0] = o;
      self__.tail = new_tail;
      if (self__.cnt >>> 5 > 1 << self__.shift) {
        var new_root_array = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var new_shift = self__.shift + 5;
        new_root_array[0] = self__.root;
        new_root_array[1] = cljs.core.new_path(self__.root.edit, self__.shift, tail_node);
        self__.root = new cljs.core.VectorNode(self__.root.edit, new_root_array);
        self__.shift = new_shift;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      } else {
        var new_root = cljs.core.tv_push_tail(tcoll__$1, self__.shift, self__.root, tail_node);
        self__.root = new_root;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    self__.root.edit = null;
    var len = self__.cnt - cljs.core.tail_off(tcoll__$1);
    var trimmed_tail = new Array(len);
    cljs.core.array_copy(self__.tail, 0, trimmed_tail, 0, len);
    return new cljs.core.PersistentVector(null, self__.cnt, self__.shift, self__.root, trimmed_tail, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";
cljs.core.TransientVector.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/TransientVector");
};
cljs.core.__GT_TransientVector = function cljs$core$__GT_TransientVector(cnt, shift, root, tail) {
  return new cljs.core.TransientVector(cnt, shift, root, tail);
};
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850572;
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueueSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var temp__4124__auto__ = cljs.core.next(self__.front);
  if (temp__4124__auto__) {
    var f1 = temp__4124__auto__;
    return new cljs.core.PersistentQueueSeq(self__.meta, f1, self__.rear, null);
  } else {
    if (self__.rear == null) {
      return cljs.core._empty(coll__$1);
    } else {
      return new cljs.core.PersistentQueueSeq(self__.meta, self__.rear, null, null);
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueSeq(meta__$1, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/PersistentQueueSeq");
};
cljs.core.__GT_PersistentQueueSeq = function cljs$core$__GT_PersistentQueueSeq(meta, front, rear, __hash) {
  return new cljs.core.PersistentQueueSeq(meta, front, rear, __hash);
};
cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31858766;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueue.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(self__.meta, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    var temp__4124__auto__ = cljs.core.next(self__.front);
    if (temp__4124__auto__) {
      var f1 = temp__4124__auto__;
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, f1, self__.rear, null);
    } else {
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, cljs.core.seq(self__.rear), cljs.core.PersistentVector.EMPTY, null);
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY, self__.meta);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.rest(cljs.core.seq(coll__$1));
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var rear__$1 = cljs.core.seq(self__.rear);
  if (cljs.core.truth_(function() {
    var or__4276__auto__ = self__.front;
    if (cljs.core.truth_(or__4276__auto__)) {
      return or__4276__auto__;
    } else {
      return rear__$1;
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, self__.front, cljs.core.seq(rear__$1), null);
  } else {
    return null;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(meta__$1, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, self__.front, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
      var or__4276__auto__ = self__.rear;
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        return cljs.core.PersistentVector.EMPTY;
      }
    }(), o), null);
  } else {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front, o), cljs.core.PersistentVector.EMPTY, null);
  }
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";
cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/PersistentQueue");
};
cljs.core.__GT_PersistentQueue = function cljs$core$__GT_PersistentQueue(meta, count, front, rear, __hash) {
  return new cljs.core.PersistentQueue(meta, count, front, rear, __hash);
};
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, cljs.core.empty_ordered_hash);
cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return false;
};
cljs.core.NeverEquiv.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";
cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/NeverEquiv");
};
cljs.core.__GT_NeverEquiv = function cljs$core$__GT_NeverEquiv() {
  return new cljs.core.NeverEquiv;
};
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function cljs$core$equiv_map(x, y) {
  return cljs.core.boolean$(cljs.core.map_QMARK_(y) ? cljs.core.count(x) === cljs.core.count(y) ? cljs.core.every_QMARK_(cljs.core.identity, cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(xkv) {
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y, cljs.core.first(xkv), cljs.core.never_equiv), cljs.core.second(xkv));
  }, x)) : null : null);
};
cljs.core.scan_array = function cljs$core$scan_array(incr, k, array) {
  var len = array.length;
  var i = 0;
  while (true) {
    if (i < len) {
      if (k === array[i]) {
        return i;
      } else {
        var G__18262 = i + incr;
        i = G__18262;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.obj_map_compare_keys = function cljs$core$obj_map_compare_keys(a, b) {
  var a__$1 = cljs.core.hash(a);
  var b__$1 = cljs.core.hash(b);
  if (a__$1 < b__$1) {
    return-1;
  } else {
    if (a__$1 > b__$1) {
      return 1;
    } else {
      return 0;
    }
  }
};
cljs.core.obj_map__GT_hash_map = function cljs$core$obj_map__GT_hash_map(m, k, v) {
  var ks = m.keys;
  var len = ks.length;
  var so = m.strobj;
  var mm = cljs.core.meta(m);
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var k__$1 = ks[i];
      var G__18263 = i + 1;
      var G__18264 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k__$1, so[k__$1]);
      i = G__18263;
      out = G__18264;
      continue;
    } else {
      return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k, v)), mm);
    }
    break;
  }
};
cljs.core.obj_clone = function cljs$core$obj_clone(obj, ks) {
  var new_obj = function() {
    var obj18268 = {};
    return obj18268;
  }();
  var l = ks.length;
  var i_18269 = 0;
  while (true) {
    if (i_18269 < l) {
      var k_18270 = ks[i_18269];
      new_obj[k_18270] = obj[k_18270];
      var G__18271 = i_18269 + 1;
      i_18269 = G__18271;
      continue;
    } else {
    }
    break;
  }
  return new_obj;
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 4;
};
cljs.core.ObjMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ObjMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4264__auto__ = function() {
      var G__18275 = k;
      return goog.isString(G__18275);
    }();
    if (cljs.core.truth_(and__4264__auto__)) {
      return!(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4264__auto__;
    }
  }())) {
    return self__.strobj[k];
  } else {
    return not_found;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.keys.length;
  var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
  var init__$1 = init;
  while (true) {
    if (cljs.core.seq(keys__$1)) {
      var k = cljs.core.first(keys__$1);
      var init__$2 = function() {
        var G__18276 = init__$1;
        var G__18277 = k;
        var G__18278 = self__.strobj[k];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18276, G__18277, G__18278) : f.call(null, G__18276, G__18277, G__18278);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__18279 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18279) : cljs.core.deref.call(null, G__18279);
      } else {
        var G__18285 = cljs.core.rest(keys__$1);
        var G__18286 = init__$2;
        keys__$1 = G__18285;
        init__$1 = G__18286;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.keys.length;
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1));
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.ObjMap.EMPTY, self__.meta);
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4264__auto__ = function() {
      var G__18281 = k;
      return goog.isString(G__18281);
    }();
    if (cljs.core.truth_(and__4264__auto__)) {
      return!(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4264__auto__;
    }
  }())) {
    var new_keys = cljs.core.aclone(self__.keys);
    var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
    new_keys.splice(cljs.core.scan_array(1, k, new_keys), 1);
    delete new_strobj[k];
    return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
  } else {
    return coll__$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var G__18282 = k;
    return goog.isString(G__18282);
  }())) {
    if (self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD || self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD) {
      return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
    } else {
      if (!(cljs.core.scan_array(1, k, self__.keys) == null)) {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        new_strobj[k] = v;
        return new cljs.core.ObjMap(self__.meta, self__.keys, new_strobj, self__.update_count + 1, null);
      } else {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        var new_keys = cljs.core.aclone(self__.keys);
        new_strobj[k] = v;
        new_keys.push(k);
        return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
      }
    }
  } else {
    return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(function() {
    var and__4264__auto__ = function() {
      var G__18284 = k;
      return goog.isString(G__18284);
    }();
    if (cljs.core.truth_(and__4264__auto__)) {
      return!(cljs.core.scan_array(1, k, self__.keys) == null);
    } else {
      return and__4264__auto__;
    }
  }())) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.keys.length > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(coll__$1) {
      return function(p1__18272_SHARP_) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18272_SHARP_, self__.strobj[p1__18272_SHARP_]], null);
      };
    }(coll__$1), self__.keys.sort(cljs.core.obj_map_compare_keys));
  } else {
    return null;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ObjMap(meta__$1, self__.keys, self__.strobj, self__.update_count, self__.__hash);
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, coll__$1, entry);
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__18287 = null;
  var G__18287__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__18287__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__18287 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18287__2.call(this, self__, k);
      case 3:
        return G__18287__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18287.cljs$core$IFn$_invoke$arity$2 = G__18287__2;
  G__18287.cljs$core$IFn$_invoke$arity$3 = G__18287__3;
  return G__18287;
}();
cljs.core.ObjMap.prototype.apply = function(self__, args18273) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18273)));
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";
cljs.core.ObjMap.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ObjMap");
};
cljs.core.__GT_ObjMap = function cljs$core$__GT_ObjMap(meta, keys, strobj, update_count, __hash) {
  return new cljs.core.ObjMap(meta, keys, strobj, update_count, __hash);
};
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], function() {
  var obj18289 = {};
  return obj18289;
}(), 0, cljs.core.empty_unordered_hash);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 8;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null);
};
cljs.core.ES6EntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6EntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var vec__18290 = cljs.core.first(self__.s);
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18290, 0, null);
    var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18290, 1, null);
    self__.s = cljs.core.next(self__.s);
    return{"done":false, "value":[k, v]};
  } else {
    return{"done":true, "value":null};
  }
};
cljs.core.ES6EntriesIterator.cljs$lang$type = true;
cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";
cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ES6EntriesIterator");
};
cljs.core.__GT_ES6EntriesIterator = function cljs$core$__GT_ES6EntriesIterator(s) {
  return new cljs.core.ES6EntriesIterator(s);
};
cljs.core.es6_entries_iterator = function cljs$core$es6_entries_iterator(coll) {
  return new cljs.core.ES6EntriesIterator(cljs.core.seq(coll));
};
cljs.core.ES6SetEntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6SetEntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return{"done":false, "value":[x, x]};
  } else {
    return{"done":true, "value":null};
  }
};
cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ES6SetEntriesIterator");
};
cljs.core.__GT_ES6SetEntriesIterator = function cljs$core$__GT_ES6SetEntriesIterator(s) {
  return new cljs.core.ES6SetEntriesIterator(s);
};
cljs.core.es6_set_entries_iterator = function cljs$core$es6_set_entries_iterator(coll) {
  return new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll));
};
cljs.core.array_index_of_nil_QMARK_ = function cljs$core$array_index_of_nil_QMARK_(arr) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return-1;
    } else {
      if (arr[i] == null) {
        return i;
      } else {
        var G__18291 = i + 2;
        i = G__18291;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_keyword_QMARK_ = function cljs$core$array_index_of_keyword_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.fqn;
  var i = 0;
  while (true) {
    if (len <= i) {
      return-1;
    } else {
      if (function() {
        var k_SINGLEQUOTE_ = arr[i];
        return k_SINGLEQUOTE_ instanceof cljs.core.Keyword && kstr === k_SINGLEQUOTE_.fqn;
      }()) {
        return i;
      } else {
        var G__18292 = i + 2;
        i = G__18292;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_symbol_QMARK_ = function cljs$core$array_index_of_symbol_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.str;
  var i = 0;
  while (true) {
    if (len <= i) {
      return-1;
    } else {
      if (function() {
        var k_SINGLEQUOTE_ = arr[i];
        return k_SINGLEQUOTE_ instanceof cljs.core.Symbol && kstr === k_SINGLEQUOTE_.str;
      }()) {
        return i;
      } else {
        var G__18293 = i + 2;
        i = G__18293;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_identical_QMARK_ = function cljs$core$array_index_of_identical_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return-1;
    } else {
      if (k === arr[i]) {
        return i;
      } else {
        var G__18294 = i + 2;
        i = G__18294;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_equiv_QMARK_ = function cljs$core$array_index_of_equiv_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return-1;
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, arr[i])) {
        return i;
      } else {
        var G__18295 = i + 2;
        i = G__18295;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of = function cljs$core$array_index_of(arr, k) {
  if (k instanceof cljs.core.Keyword) {
    return cljs.core.array_index_of_keyword_QMARK_(arr, k);
  } else {
    if (cljs.core.truth_(function() {
      var or__4276__auto__ = function() {
        var G__18299 = k;
        return goog.isString(G__18299);
      }();
      if (cljs.core.truth_(or__4276__auto__)) {
        return or__4276__auto__;
      } else {
        return typeof k === "number";
      }
    }())) {
      return cljs.core.array_index_of_identical_QMARK_(arr, k);
    } else {
      if (k instanceof cljs.core.Symbol) {
        return cljs.core.array_index_of_symbol_QMARK_(arr, k);
      } else {
        if (k == null) {
          return cljs.core.array_index_of_nil_QMARK_(arr);
        } else {
          return cljs.core.array_index_of_equiv_QMARK_(arr, k);
        }
      }
    }
  }
};
cljs.core.array_map_index_of = function cljs$core$array_map_index_of(m, k) {
  return cljs.core.array_index_of(m.arr, k);
};
cljs.core.array_extend_kv = function cljs$core$array_extend_kv(arr, k, v) {
  var l = arr.length;
  var narr = new Array(l + 2);
  var i_18300 = 0;
  while (true) {
    if (i_18300 < l) {
      narr[i_18300] = arr[i_18300];
      var G__18301 = i_18300 + 1;
      i_18300 = G__18301;
      continue;
    } else {
    }
    break;
  }
  narr[l] = k;
  narr[l + 1] = v;
  return narr;
};
cljs.core.array_map_extend_kv = function cljs$core$array_map_extend_kv(m, k, v) {
  return cljs.core.array_extend_kv(m.arr, k, v);
};
cljs.core.PersistentArrayMapSeq = function(arr, i, _meta) {
  this.arr = arr;
  this.i = i;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
};
cljs.core.PersistentArrayMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return(self__.arr.length - self__.i) / 2;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i, new_meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/PersistentArrayMapSeq");
};
cljs.core.__GT_PersistentArrayMapSeq = function cljs$core$__GT_PersistentArrayMapSeq(arr, i, _meta) {
  return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
};
cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.persistent_array_map_seq = function cljs$core$persistent_array_map_seq(arr, i, _meta) {
  if (i <= arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapIterator = function(arr, i, cnt) {
  this.arr = arr;
  this.i = i;
  this.cnt = cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[self__.i], self__.arr[self__.i + 1]], null);
  self__.i = self__.i + 2;
  return ret;
};
cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/PersistentArrayMapIterator");
};
cljs.core.__GT_PersistentArrayMapIterator = function cljs$core$__GT_PersistentArrayMapIterator(arr, i, cnt) {
  return new cljs.core.PersistentArrayMapIterator(arr, i, cnt);
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16647951;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__18303 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__18303) : cljs.core.keys.call(null, G__18303);
  }());
};
cljs.core.PersistentArrayMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentArrayMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__18304 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__18304) : cljs.core.vals.call(null, G__18304);
  }());
};
cljs.core.PersistentArrayMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentArrayMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__18305 = cljs.core.seq(coll);
  var chunk__18306 = null;
  var count__18307 = 0;
  var i__18308 = 0;
  while (true) {
    if (i__18308 < count__18307) {
      var vec__18309 = chunk__18306.cljs$core$IIndexed$_nth$arity$2(null, i__18308);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18309, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18309, 1, null);
      var G__18310_18323 = v;
      var G__18311_18324 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18310_18323, G__18311_18324) : f.call(null, G__18310_18323, G__18311_18324);
      var G__18325 = seq__18305;
      var G__18326 = chunk__18306;
      var G__18327 = count__18307;
      var G__18328 = i__18308 + 1;
      seq__18305 = G__18325;
      chunk__18306 = G__18326;
      count__18307 = G__18327;
      i__18308 = G__18328;
      continue;
    } else {
      var temp__4126__auto__ = cljs.core.seq(seq__18305);
      if (temp__4126__auto__) {
        var seq__18305__$1 = temp__4126__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__18305__$1)) {
          var c__5061__auto__ = cljs.core.chunk_first(seq__18305__$1);
          var G__18329 = cljs.core.chunk_rest(seq__18305__$1);
          var G__18330 = c__5061__auto__;
          var G__18331 = cljs.core.count(c__5061__auto__);
          var G__18332 = 0;
          seq__18305 = G__18329;
          chunk__18306 = G__18330;
          count__18307 = G__18331;
          i__18308 = G__18332;
          continue;
        } else {
          var vec__18312 = cljs.core.first(seq__18305__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18312, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18312, 1, null);
          var G__18313_18333 = v;
          var G__18314_18334 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18313_18333, G__18314_18334) : f.call(null, G__18313_18333, G__18314_18334);
          var G__18335 = cljs.core.next(seq__18305__$1);
          var G__18336 = null;
          var G__18337 = 0;
          var G__18338 = 0;
          seq__18305 = G__18335;
          chunk__18306 = G__18336;
          count__18307 = G__18337;
          i__18308 = G__18338;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    return not_found;
  } else {
    return self__.arr[idx + 1];
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var G__18315 = init__$1;
        var G__18316 = self__.arr[i];
        var G__18317 = self__.arr[i + 1];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18315, G__18316, G__18317) : f.call(null, G__18315, G__18316, G__18317);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__18318 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18318) : cljs.core.deref.call(null, G__18318);
      } else {
        var G__18339 = i + 2;
        var G__18340 = init__$2;
        i = G__18339;
        init__$1 = G__18340;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.PersistentArrayMapIterator(self__.arr, 0, self__.cnt * 2);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (function() {
    var G__18319 = other;
    if (G__18319) {
      var bit__4943__auto__ = G__18319.cljs$lang$protocol_mask$partition0$ & 1024;
      if (bit__4943__auto__ || G__18319.cljs$core$IMap$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    var alen = self__.arr.length;
    var other__$1 = other;
    if (self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null)) {
      var i = 0;
      while (true) {
        if (i < alen) {
          var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null, self__.arr[i], cljs.core.lookup_sentinel);
          if (!(v === cljs.core.lookup_sentinel)) {
            if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[i + 1], v)) {
              var G__18341 = i + 2;
              i = G__18341;
              continue;
            } else {
              return false;
            }
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_map(coll__$1, other);
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientArrayMap(function() {
    var obj18321 = {};
    return obj18321;
  }(), self__.arr.length, cljs.core.aclone(self__.arr));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY, self__.meta);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx >= 0) {
    var len = self__.arr.length;
    var new_len = len - 2;
    if (new_len === 0) {
      return cljs.core._empty(coll__$1);
    } else {
      var new_arr = new Array(new_len);
      var s = 0;
      var d = 0;
      while (true) {
        if (s >= len) {
          return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt - 1, new_arr, null);
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, self__.arr[s])) {
            var G__18342 = s + 2;
            var G__18343 = d;
            s = G__18342;
            d = G__18343;
            continue;
          } else {
            new_arr[d] = self__.arr[s];
            new_arr[d + 1] = self__.arr[s + 1];
            var G__18344 = s + 2;
            var G__18345 = d + 2;
            s = G__18344;
            d = G__18345;
            continue;
          }
        }
        break;
      }
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    if (self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      var arr__$1 = cljs.core.array_map_extend_kv(coll__$1, k, v);
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt + 1, arr__$1, null);
    } else {
      return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1), k, v), self__.meta);
    }
  } else {
    if (v === self__.arr[idx + 1]) {
      return coll__$1;
    } else {
      var arr__$1 = function() {
        var G__18322 = cljs.core.aclone(self__.arr);
        G__18322[idx + 1] = v;
        return G__18322;
      }();
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, arr__$1, null);
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return!(cljs.core.array_map_index_of(coll__$1, k) === -1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.persistent_array_map_seq(self__.arr, 0, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMap(meta__$1, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__18346 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__18347 = cljs.core.next(es);
          ret = G__18346;
          es = G__18347;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__18348 = null;
  var G__18348__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__18348__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__18348 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18348__2.call(this, self__, k);
      case 3:
        return G__18348__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18348.cljs$core$IFn$_invoke$arity$2 = G__18348__2;
  G__18348.cljs$core$IFn$_invoke$arity$3 = G__18348__3;
  return G__18348;
}();
cljs.core.PersistentArrayMap.prototype.apply = function(self__, args18302) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18302)));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";
cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/PersistentArrayMap");
};
cljs.core.__GT_PersistentArrayMap = function cljs$core$__GT_PersistentArrayMap(meta, cnt, arr, __hash) {
  return new cljs.core.PersistentArrayMap(meta, cnt, arr, __hash);
};
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], cljs.core.empty_unordered_hash);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 8;
cljs.core.PersistentArrayMap.fromArray = function(arr, no_clone, no_check) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var arr__$2 = no_check ? arr__$1 : function() {
    var ret = [];
    var i_18349 = 0;
    while (true) {
      if (i_18349 < arr__$1.length) {
        var k_18350 = arr__$1[i_18349];
        var v_18351 = arr__$1[i_18349 + 1];
        var idx_18352 = cljs.core.array_index_of(ret, k_18350);
        if (idx_18352 === -1) {
          ret.push(k_18350);
          ret.push(v_18351);
        } else {
        }
        var G__18353 = i_18349 + 2;
        i_18349 = G__18353;
        continue;
      } else {
      }
      break;
    }
    return ret;
  }();
  var arr__$3 = function() {
    var cnt = arr__$2.length / 2;
    return new cljs.core.PersistentArrayMap(null, cnt, arr__$2, null);
  }();
  return arr__$3;
};
cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 56;
  this.cljs$lang$protocol_mask$partition0$ = 258;
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx >= 0) {
      self__.arr[idx] = self__.arr[self__.len - 2];
      self__.arr[idx + 1] = self__.arr[self__.len - 1];
      var G__18354_18362 = self__.arr;
      G__18354_18362.pop();
      G__18354_18362.pop();
      self__.len = self__.len - 2;
    } else {
    }
    return tcoll__$1;
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx === -1) {
      if (self__.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        self__.len = self__.len + 2;
        self__.arr.push(key);
        self__.arr.push(val);
        return tcoll__$1;
      } else {
        return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(function() {
          var G__18355 = self__.len;
          var G__18356 = self__.arr;
          return cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__18355, G__18356) : cljs.core.array__GT_transient_hash_map.call(null, G__18355, G__18356);
        }(), key, val);
      }
    } else {
      if (val === self__.arr[idx + 1]) {
        return tcoll__$1;
      } else {
        self__.arr[idx + 1] = val;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    if (function() {
      var G__18357 = o;
      if (G__18357) {
        var bit__4950__auto__ = G__18357.cljs$lang$protocol_mask$partition0$ & 2048;
        if (bit__4950__auto__ || G__18357.cljs$core$IMapEntry$) {
          return true;
        } else {
          if (!G__18357.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__18357);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__18357);
      }
    }()) {
      return cljs.core._assoc_BANG_(tcoll__$1, function() {
        var G__18358 = o;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__18358) : cljs.core.key.call(null, G__18358);
      }(), function() {
        var G__18359 = o;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__18359) : cljs.core.val.call(null, G__18359);
      }());
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$2 = tcoll__$1;
      while (true) {
        var temp__4124__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4124__auto__)) {
          var e = temp__4124__auto__;
          var G__18363 = cljs.core.next(es);
          var G__18364 = cljs.core._assoc_BANG_(tcoll__$2, function() {
            var G__18360 = e;
            return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__18360) : cljs.core.key.call(null, G__18360);
          }(), function() {
            var G__18361 = e;
            return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__18361) : cljs.core.val.call(null, G__18361);
          }());
          es = G__18363;
          tcoll__$2 = G__18364;
          continue;
        } else {
          return tcoll__$2;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    self__.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot(self__.len, 2), self__.arr, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1, k, null);
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, k);
    if (idx === -1) {
      return not_found;
    } else {
      return self__.arr[idx + 1];
    }
  } else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    return cljs.core.quot(self__.len, 2);
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";
cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/TransientArrayMap");
};
cljs.core.__GT_TransientArrayMap = function cljs$core$__GT_TransientArrayMap(editable_QMARK_, len, arr) {
  return new cljs.core.TransientArrayMap(editable_QMARK_, len, arr);
};
cljs.core.array__GT_transient_hash_map = function cljs$core$array__GT_transient_hash_map(len, arr) {
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  var i = 0;
  while (true) {
    if (i < len) {
      var G__18365 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, arr[i], arr[i + 1]);
      var G__18366 = i + 2;
      out = G__18365;
      i = G__18366;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.Box = function(val) {
  this.val = val;
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";
cljs.core.Box.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/Box");
};
cljs.core.__GT_Box = function cljs$core$__GT_Box(val) {
  return new cljs.core.Box(val);
};
cljs.core.key_test = function cljs$core$key_test(key, other) {
  if (key === other) {
    return true;
  } else {
    if (cljs.core.keyword_identical_QMARK_(key, other)) {
      return true;
    } else {
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key, other);
    }
  }
};
cljs.core.mask = function cljs$core$mask(hash, shift) {
  return hash >>> shift & 31;
};
cljs.core.clone_and_set = function cljs$core$clone_and_set() {
  var G__18368 = arguments.length;
  switch(G__18368) {
    case 3:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = function(arr, i, a) {
  var G__18369 = cljs.core.aclone(arr);
  G__18369[i] = a;
  return G__18369;
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = function(arr, i, a, j, b) {
  var G__18370 = cljs.core.aclone(arr);
  G__18370[i] = a;
  G__18370[j] = b;
  return G__18370;
};
cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = function cljs$core$remove_pair(arr, i) {
  var new_arr = new Array(arr.length - 2);
  cljs.core.array_copy(arr, 0, new_arr, 0, 2 * i);
  cljs.core.array_copy(arr, 2 * (i + 1), new_arr, 2 * i, new_arr.length - 2 * i);
  return new_arr;
};
cljs.core.bitmap_indexed_node_index = function cljs$core$bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count(bitmap & bit - 1);
};
cljs.core.bitpos = function cljs$core$bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31);
};
cljs.core.edit_and_set = function cljs$core$edit_and_set() {
  var G__18373 = arguments.length;
  switch(G__18373) {
    case 4:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 6:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = function(inode, edit, i, a) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  return editable;
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = function(inode, edit, i, a, j, b) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  editable.arr[j] = b;
  return editable;
};
cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = function cljs$core$inode_kv_reduce(arr, f, init) {
  var len = arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var k = arr[i];
        if (!(k == null)) {
          var G__18379 = init__$1;
          var G__18380 = k;
          var G__18381 = arr[i + 1];
          return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18379, G__18380, G__18381) : f.call(null, G__18379, G__18380, G__18381);
        } else {
          var node = arr[i + 1];
          if (!(node == null)) {
            return node.kv_reduce(f, init__$1);
          } else {
            return init__$1;
          }
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        var G__18382 = init__$2;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18382) : cljs.core.deref.call(null, G__18382);
      } else {
        var G__18383 = i + 2;
        var G__18384 = init__$2;
        i = G__18383;
        init__$1 = G__18384;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr;
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var n = cljs.core.bit_count(self__.bitmap);
    var new_arr = new Array(n < 0 ? 4 : 2 * (n + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * n);
    return new cljs.core.BitmapIndexedNode(e, self__.bitmap, new_arr);
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return inode.edit_and_remove_pair(edit__$1, bit, idx);
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        removed_leaf_QMARK_[0] = true;
        return inode.edit_and_remove_pair(edit__$1, bit, idx);
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var self__ = this;
  var inode = this;
  if (self__.bitmap === bit) {
    return null;
  } else {
    var editable = inode.ensure_editable(e);
    var earr = editable.arr;
    var len = earr.length;
    editable.bitmap = bit ^ editable.bitmap;
    cljs.core.array_copy(earr, 2 * (i + 1), earr, 2 * i, len - 2 * (i + 1));
    earr[len - 2] = null;
    earr[len - 1] = null;
    return editable;
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__18385 = self__.arr;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__18385) : cljs.core.create_inode_seq.call(null, G__18385);
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_lookup(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return val_or_node;
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (2 * n < self__.arr.length) {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      added_leaf_QMARK_.val = true;
      cljs.core.array_copy_downward(earr, 2 * idx, earr, 2 * (idx + 1), 2 * (n - idx));
      earr[2 * idx] = key;
      earr[2 * idx + 1] = val;
      editable.bitmap = editable.bitmap | bit;
      return editable;
    } else {
      if (n >= 16) {
        var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var jdx = hash >>> shift & 31;
        nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i_18399 = 0;
        var j_18400 = 0;
        while (true) {
          if (i_18399 < 32) {
            if ((self__.bitmap >>> i_18399 & 1) === 0) {
              var G__18401 = i_18399 + 1;
              var G__18402 = j_18400;
              i_18399 = G__18401;
              j_18400 = G__18402;
              continue;
            } else {
              nodes[i_18399] = !(self__.arr[j_18400] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, cljs.core.hash(self__.arr[j_18400]), self__.arr[j_18400], self__.arr[j_18400 + 1], added_leaf_QMARK_) : self__.arr[j_18400 + 1];
              var G__18403 = i_18399 + 1;
              var G__18404 = j_18400 + 2;
              i_18399 = G__18403;
              j_18400 = G__18404;
              continue;
            }
          } else {
          }
          break;
        }
        return new cljs.core.ArrayNode(edit__$1, n + 1, nodes);
      } else {
        var new_arr = new Array(2 * (n + 4));
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
        new_arr[2 * idx] = key;
        new_arr[2 * idx + 1] = val;
        cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
        added_leaf_QMARK_.val = true;
        var editable = inode.ensure_editable(edit__$1);
        editable.arr = new_arr;
        editable.bitmap = editable.bitmap | bit;
        return editable;
      }
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, val);
        }
      } else {
        added_leaf_QMARK_.val = true;
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * idx, null, 2 * idx + 1, function() {
          var G__18386 = edit__$1;
          var G__18387 = shift + 5;
          var G__18388 = key_or_nil;
          var G__18389 = val_or_node;
          var G__18390 = hash;
          var G__18391 = key;
          var G__18392 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__18386, G__18387, G__18388, G__18389, G__18390, G__18391, G__18392) : cljs.core.create_node.call(null, G__18386, G__18387, G__18388, G__18389, G__18390, G__18391, G__18392);
        }());
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
  if ((self__.bitmap & bit) === 0) {
    var n = cljs.core.bit_count(self__.bitmap);
    if (n >= 16) {
      var nodes = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      var jdx = hash >>> shift & 31;
      nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i_18405 = 0;
      var j_18406 = 0;
      while (true) {
        if (i_18405 < 32) {
          if ((self__.bitmap >>> i_18405 & 1) === 0) {
            var G__18407 = i_18405 + 1;
            var G__18408 = j_18406;
            i_18405 = G__18407;
            j_18406 = G__18408;
            continue;
          } else {
            nodes[i_18405] = !(self__.arr[j_18406] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash(self__.arr[j_18406]), self__.arr[j_18406], self__.arr[j_18406 + 1], added_leaf_QMARK_) : self__.arr[j_18406 + 1];
            var G__18409 = i_18405 + 1;
            var G__18410 = j_18406 + 2;
            i_18405 = G__18409;
            j_18406 = G__18410;
            continue;
          }
        } else {
        }
        break;
      }
      return new cljs.core.ArrayNode(null, n + 1, nodes);
    } else {
      var new_arr = new Array(2 * (n + 1));
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * idx);
      new_arr[2 * idx] = key;
      new_arr[2 * idx + 1] = val;
      cljs.core.array_copy(self__.arr, 2 * idx, new_arr, 2 * (idx + 1), 2 * (n - idx));
      added_leaf_QMARK_.val = true;
      return new cljs.core.BitmapIndexedNode(null, self__.bitmap | bit, new_arr);
    }
  } else {
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        if (val === val_or_node) {
          return inode;
        } else {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, val));
        }
      } else {
        added_leaf_QMARK_.val = true;
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr, 2 * idx, null, 2 * idx + 1, function() {
          var G__18393 = shift + 5;
          var G__18394 = key_or_nil;
          var G__18395 = val_or_node;
          var G__18396 = hash;
          var G__18397 = key;
          var G__18398 = val;
          return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__18393, G__18394, G__18395, G__18396, G__18397, G__18398) : cljs.core.create_node.call(null, G__18393, G__18394, G__18395, G__18396, G__18397, G__18398);
        }()));
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return not_found;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      return val_or_node.inode_find(shift + 5, hash, key, not_found);
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil, val_or_node], null);
      } else {
        return not_found;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without(shift + 5, hash, key);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return new cljs.core.BitmapIndexedNode(null, self__.bitmap, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, 2 * idx + 1, n));
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        return new cljs.core.BitmapIndexedNode(null, self__.bitmap ^ bit, cljs.core.remove_pair(self__.arr, idx));
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/BitmapIndexedNode");
};
cljs.core.__GT_BitmapIndexedNode = function cljs$core$__GT_BitmapIndexedNode(edit, bitmap, arr) {
  return new cljs.core.BitmapIndexedNode(edit, bitmap, arr);
};
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, []);
cljs.core.pack_array_node = function cljs$core$pack_array_node(array_node, edit, idx) {
  var arr = array_node.arr;
  var len = arr.length;
  var new_arr = new Array(2 * (array_node.cnt - 1));
  var i = 0;
  var j = 1;
  var bitmap = 0;
  while (true) {
    if (i < len) {
      if (!(i === idx) && !(arr[i] == null)) {
        new_arr[j] = arr[i];
        var G__18411 = i + 1;
        var G__18412 = j + 2;
        var G__18413 = bitmap | 1 << i;
        i = G__18411;
        j = G__18412;
        bitmap = G__18413;
        continue;
      } else {
        var G__18414 = i + 1;
        var G__18415 = j;
        var G__18416 = bitmap;
        i = G__18414;
        j = G__18415;
        bitmap = G__18416;
        continue;
      }
    } else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap, new_arr);
    }
    break;
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    return new cljs.core.ArrayNode(e, self__.cnt, cljs.core.aclone(self__.arr));
  }
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return inode;
  } else {
    var n = node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, edit__$1, idx);
        } else {
          var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
          editable.cnt = editable.cnt - 1;
          return editable;
        }
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
      }
    }
  }
};
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__18417 = self__.arr;
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__18417) : cljs.core.create_array_node_seq.call(null, G__18417);
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var node = self__.arr[i];
      if (!(node == null)) {
        var init__$2 = node.kv_reduce(f, init__$1);
        if (cljs.core.reduced_QMARK_(init__$2)) {
          var G__18418 = init__$2;
          return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18418) : cljs.core.deref.call(null, G__18418);
        } else {
          var G__18419 = i + 1;
          var G__18420 = init__$2;
          i = G__18419;
          init__$1 = G__18420;
          continue;
        }
      } else {
        var G__18421 = i + 1;
        var G__18422 = init__$1;
        i = G__18421;
        init__$1 = G__18422;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ArrayNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_lookup(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable.cnt = editable.cnt + 1;
    return editable;
  } else {
    var n = node.inode_assoc_BANG_(edit__$1, shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx, n);
    }
  }
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (node == null) {
    return new cljs.core.ArrayNode(null, self__.cnt + 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)));
  } else {
    var n = node.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if (n === node) {
      return inode;
    } else {
      return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
    }
  }
};
cljs.core.ArrayNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    return node.inode_find(shift + 5, hash, key, not_found);
  } else {
    return not_found;
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = hash >>> shift & 31;
  var node = self__.arr[idx];
  if (!(node == null)) {
    var n = node.inode_without(shift + 5, hash, key);
    if (n === node) {
      return inode;
    } else {
      if (n == null) {
        if (self__.cnt <= 8) {
          return cljs.core.pack_array_node(inode, null, idx);
        } else {
          return new cljs.core.ArrayNode(null, self__.cnt - 1, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
        }
      } else {
        return new cljs.core.ArrayNode(null, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx, n));
      }
    }
  } else {
    return inode;
  }
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";
cljs.core.ArrayNode.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ArrayNode");
};
cljs.core.__GT_ArrayNode = function cljs$core$__GT_ArrayNode(edit, cnt, arr) {
  return new cljs.core.ArrayNode(edit, cnt, arr);
};
cljs.core.hash_collision_node_find_index = function cljs$core$hash_collision_node_find_index(arr, cnt, key) {
  var lim = 2 * cnt;
  var i = 0;
  while (true) {
    if (i < lim) {
      if (cljs.core.key_test(key, arr[i])) {
        return i;
      } else {
        var G__18423 = i + 2;
        i = G__18423;
        continue;
      }
    } else {
      return-1;
    }
    break;
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr;
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var new_arr = new Array(2 * (self__.cnt + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * self__.cnt);
    return new cljs.core.HashCollisionNode(e, self__.collision_hash, self__.cnt, new_arr);
  }
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    removed_leaf_QMARK_[0] = true;
    if (self__.cnt === 1) {
      return null;
    } else {
      var editable = inode.ensure_editable(edit__$1);
      var earr = editable.arr;
      earr[idx] = earr[2 * self__.cnt - 2];
      earr[idx + 1] = earr[2 * self__.cnt - 1];
      earr[2 * self__.cnt - 1] = null;
      earr[2 * self__.cnt - 2] = null;
      editable.cnt = editable.cnt - 1;
      return editable;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  var G__18424 = self__.arr;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__18424) : cljs.core.create_inode_seq.call(null, G__18424);
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.HashCollisionNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return self__.arr[idx + 1];
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit__$1, shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      if (self__.arr.length > 2 * self__.cnt) {
        var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode, edit__$1, 2 * self__.cnt, key, 2 * self__.cnt + 1, val);
        added_leaf_QMARK_.val = true;
        editable.cnt = editable.cnt + 1;
        return editable;
      } else {
        var len = self__.arr.length;
        var new_arr = new Array(len + 2);
        cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
        new_arr[len] = key;
        new_arr[len + 1] = val;
        added_leaf_QMARK_.val = true;
        return inode.ensure_editable_array(edit__$1, self__.cnt + 1, new_arr);
      }
    } else {
      if (self__.arr[idx + 1] === val) {
        return inode;
      } else {
        return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, idx + 1, val);
      }
    }
  } else {
    return(new cljs.core.BitmapIndexedNode(edit__$1, 1 << (self__.collision_hash >>> shift & 31), [null, inode, null, null])).inode_assoc_BANG_(edit__$1, shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  if (hash === self__.collision_hash) {
    var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
    if (idx === -1) {
      var len = 2 * self__.cnt;
      var new_arr = new Array(len + 2);
      cljs.core.array_copy(self__.arr, 0, new_arr, 0, len);
      new_arr[len] = key;
      new_arr[len + 1] = val;
      added_leaf_QMARK_.val = true;
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt + 1, new_arr);
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[idx], val)) {
        return inode;
      } else {
        return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt, cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr, idx + 1, val));
      }
    }
  } else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (self__.collision_hash >>> shift & 31), [null, inode])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_);
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable_array = function(e, count, array) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    self__.arr = array;
    self__.cnt = count;
    return inode;
  } else {
    return new cljs.core.HashCollisionNode(self__.edit, self__.collision_hash, count, array);
  }
};
cljs.core.HashCollisionNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx < 0) {
    return not_found;
  } else {
    if (cljs.core.key_test(key, self__.arr[idx])) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.arr[idx], self__.arr[idx + 1]], null);
    } else {
      return not_found;
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var self__ = this;
  var inode = this;
  var idx = cljs.core.hash_collision_node_find_index(self__.arr, self__.cnt, key);
  if (idx === -1) {
    return inode;
  } else {
    if (self__.cnt === 1) {
      return null;
    } else {
      return new cljs.core.HashCollisionNode(null, self__.collision_hash, self__.cnt - 1, cljs.core.remove_pair(self__.arr, cljs.core.quot(idx, 2)));
    }
  }
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";
cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/HashCollisionNode");
};
cljs.core.__GT_HashCollisionNode = function cljs$core$__GT_HashCollisionNode(edit, collision_hash, cnt, arr) {
  return new cljs.core.HashCollisionNode(edit, collision_hash, cnt, arr);
};
cljs.core.create_node = function cljs$core$create_node() {
  var G__18426 = arguments.length;
  switch(G__18426) {
    case 6:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = function(shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
  var key1hash = cljs.core.hash(key1);
  if (key1hash === key2hash) {
    return new cljs.core.HashCollisionNode(null, key1hash, 2, [key1, val1, key2, val2]);
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash, key1, val1, added_leaf_QMARK_).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK_);
  }
};
cljs.core.create_node.cljs$lang$maxFixedArity = 7;
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
};
cljs.core.NodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.NodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.nodes[self__.i], self__.nodes[self__.i + 1]], null);
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.s == null) {
    var G__18428 = self__.nodes;
    var G__18429 = self__.i + 2;
    var G__18430 = null;
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__18428, G__18429, G__18430) : cljs.core.create_inode_seq.call(null, G__18428, G__18429, G__18430);
  } else {
    var G__18431 = self__.nodes;
    var G__18432 = self__.i;
    var G__18433 = cljs.core.next(self__.s);
    return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__18431, G__18432, G__18433) : cljs.core.create_inode_seq.call(null, G__18431, G__18432, G__18433);
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.NodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";
cljs.core.NodeSeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/NodeSeq");
};
cljs.core.__GT_NodeSeq = function cljs$core$__GT_NodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.NodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.create_inode_seq = function cljs$core$create_inode_seq() {
  var G__18435 = arguments.length;
  switch(G__18435) {
    case 1:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 3:
      return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes, 0, null);
};
cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = function(nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        if (!(nodes[j] == null)) {
          return new cljs.core.NodeSeq(null, nodes, j, null, null);
        } else {
          var temp__4124__auto__ = nodes[j + 1];
          if (cljs.core.truth_(temp__4124__auto__)) {
            var node = temp__4124__auto__;
            var temp__4124__auto____$1 = node.inode_seq();
            if (cljs.core.truth_(temp__4124__auto____$1)) {
              var node_seq = temp__4124__auto____$1;
              return new cljs.core.NodeSeq(null, nodes, j + 2, node_seq, null);
            } else {
              var G__18437 = j + 2;
              j = G__18437;
              continue;
            }
          } else {
            var G__18438 = j + 2;
            j = G__18438;
            continue;
          }
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.NodeSeq(null, nodes, i, s, null);
  }
};
cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32374860;
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ArrayNodeSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.s);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var G__18439 = null;
  var G__18440 = self__.nodes;
  var G__18441 = self__.i;
  var G__18442 = cljs.core.next(self__.s);
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__18439, G__18440, G__18441, G__18442) : cljs.core.create_array_node_seq.call(null, G__18439, G__18440, G__18441, G__18442);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ArrayNodeSeq(meta__$1, self__.nodes, self__.i, self__.s, self__.__hash);
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ArrayNodeSeq");
};
cljs.core.__GT_ArrayNodeSeq = function cljs$core$__GT_ArrayNodeSeq(meta, nodes, i, s, __hash) {
  return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, __hash);
};
cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.create_array_node_seq = function cljs$core$create_array_node_seq() {
  var G__18444 = arguments.length;
  switch(G__18444) {
    case 1:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 4:
      return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = function(nodes) {
  return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null, nodes, 0, null);
};
cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = function(meta, nodes, i, s) {
  if (s == null) {
    var len = nodes.length;
    var j = i;
    while (true) {
      if (j < len) {
        var temp__4124__auto__ = nodes[j];
        if (cljs.core.truth_(temp__4124__auto__)) {
          var nj = temp__4124__auto__;
          var temp__4124__auto____$1 = nj.inode_seq();
          if (cljs.core.truth_(temp__4124__auto____$1)) {
            var ns = temp__4124__auto____$1;
            return new cljs.core.ArrayNodeSeq(meta, nodes, j + 1, ns, null);
          } else {
            var G__18446 = j + 1;
            j = G__18446;
            continue;
          }
        } else {
          var G__18447 = j + 1;
          j = G__18447;
          continue;
        }
      } else {
        return null;
      }
      break;
    }
  } else {
    return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null);
  }
};
cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__18449 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__18449) : cljs.core.keys.call(null, G__18449);
  }());
};
cljs.core.PersistentHashMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__18450 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__18450) : cljs.core.vals.call(null, G__18450);
  }());
};
cljs.core.PersistentHashMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__18451 = cljs.core.seq(coll);
  var chunk__18452 = null;
  var count__18453 = 0;
  var i__18454 = 0;
  while (true) {
    if (i__18454 < count__18453) {
      var vec__18455 = chunk__18452.cljs$core$IIndexed$_nth$arity$2(null, i__18454);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18455, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18455, 1, null);
      var G__18456_18467 = v;
      var G__18457_18468 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18456_18467, G__18457_18468) : f.call(null, G__18456_18467, G__18457_18468);
      var G__18469 = seq__18451;
      var G__18470 = chunk__18452;
      var G__18471 = count__18453;
      var G__18472 = i__18454 + 1;
      seq__18451 = G__18469;
      chunk__18452 = G__18470;
      count__18453 = G__18471;
      i__18454 = G__18472;
      continue;
    } else {
      var temp__4126__auto__ = cljs.core.seq(seq__18451);
      if (temp__4126__auto__) {
        var seq__18451__$1 = temp__4126__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__18451__$1)) {
          var c__5061__auto__ = cljs.core.chunk_first(seq__18451__$1);
          var G__18473 = cljs.core.chunk_rest(seq__18451__$1);
          var G__18474 = c__5061__auto__;
          var G__18475 = cljs.core.count(c__5061__auto__);
          var G__18476 = 0;
          seq__18451 = G__18473;
          chunk__18452 = G__18474;
          count__18453 = G__18475;
          i__18454 = G__18476;
          continue;
        } else {
          var vec__18458 = cljs.core.first(seq__18451__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18458, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18458, 1, null);
          var G__18459_18477 = v;
          var G__18460_18478 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18459_18477, G__18460_18478) : f.call(null, G__18459_18477, G__18460_18478);
          var G__18479 = cljs.core.next(seq__18451__$1);
          var G__18480 = null;
          var G__18481 = 0;
          var G__18482 = 0;
          seq__18451 = G__18479;
          chunk__18452 = G__18480;
          count__18453 = G__18481;
          i__18454 = G__18482;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var init__$1 = self__.has_nil_QMARK_ ? function() {
    var G__18461 = init;
    var G__18462 = null;
    var G__18463 = self__.nil_val;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18461, G__18462, G__18463) : f.call(null, G__18461, G__18462, G__18463);
  }() : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    var G__18464 = init__$1;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18464) : cljs.core.deref.call(null, G__18464);
  } else {
    if (!(self__.root == null)) {
      return self__.root.kv_reduce(f, init__$1);
    } else {
      return init__$1;
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashMap(self__.meta, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashMap(function() {
    var obj18466 = {};
    return obj18466;
  }(), self__.root, self__.cnt, self__.has_nil_QMARK_, self__.nil_val);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY, self__.meta);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, self__.root, false, null, null);
    } else {
      return coll__$1;
    }
  } else {
    if (self__.root == null) {
      return coll__$1;
    } else {
      var new_root = self__.root.inode_without(0, cljs.core.hash(k), k);
      if (new_root === self__.root) {
        return coll__$1;
      } else {
        return new cljs.core.PersistentHashMap(self__.meta, self__.cnt - 1, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_ && v === self__.nil_val) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, self__.has_nil_QMARK_ ? self__.cnt : self__.cnt + 1, self__.root, true, v, null);
    }
  } else {
    var added_leaf_QMARK_ = new cljs.core.Box(false);
    var new_root = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc(0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
    if (new_root === self__.root) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentHashMap(self__.meta, added_leaf_QMARK_.val ? self__.cnt + 1 : self__.cnt, new_root, self__.has_nil_QMARK_, self__.nil_val, null);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (k == null) {
    return self__.has_nil_QMARK_;
  } else {
    if (self__.root == null) {
      return false;
    } else {
      return!(self__.root.inode_lookup(0, cljs.core.hash(k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel);
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var s = !(self__.root == null) ? self__.root.inode_seq() : null;
    if (self__.has_nil_QMARK_) {
      return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null, self__.nil_val], null), s);
    } else {
      return s;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashMap(meta__$1, self__.cnt, self__.root, self__.has_nil_QMARK_, self__.nil_val, self__.__hash);
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__18483 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__18484 = cljs.core.next(es);
          ret = G__18483;
          es = G__18484;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__18485 = null;
  var G__18485__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__18485__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__18485 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18485__2.call(this, self__, k);
      case 3:
        return G__18485__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18485.cljs$core$IFn$_invoke$arity$2 = G__18485__2;
  G__18485.cljs$core$IFn$_invoke$arity$3 = G__18485__3;
  return G__18485;
}();
cljs.core.PersistentHashMap.prototype.apply = function(self__, args18448) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18448)));
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";
cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/PersistentHashMap");
};
cljs.core.__GT_PersistentHashMap = function cljs$core$__GT_PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  return new cljs.core.PersistentHashMap(meta, cnt, root, has_nil_QMARK_, nil_val, __hash);
};
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashMap.fromArray = function(arr, no_clone) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var len = arr__$1.length;
  var i = 0;
  var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__18486 = i + 2;
      var G__18487 = cljs.core._assoc_BANG_(ret, arr__$1[i], arr__$1[i + 1]);
      i = G__18486;
      ret = G__18487;
      continue;
    } else {
      return cljs.core._persistent_BANG_(ret);
    }
    break;
  }
};
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len = ks.length;
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var G__18488 = i + 1;
      var G__18489 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, ks[i], vs[i]);
      i = G__18488;
      out = G__18489;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 56;
  this.cljs$lang$protocol_mask$partition0$ = 258;
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.without_BANG_(key);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.assoc_BANG_(key, val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.conj_BANG_(val);
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.persistent_BANG_();
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return null;
    }
  } else {
    if (self__.root == null) {
      return null;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (k == null) {
    if (self__.has_nil_QMARK_) {
      return self__.nil_val;
    } else {
      return not_found;
    }
  } else {
    if (self__.root == null) {
      return not_found;
    } else {
      return self__.root.inode_lookup(0, cljs.core.hash(k), k, not_found);
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.edit) {
    return self__.count;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (function() {
      var G__18490 = o;
      if (G__18490) {
        var bit__4950__auto__ = G__18490.cljs$lang$protocol_mask$partition0$ & 2048;
        if (bit__4950__auto__ || G__18490.cljs$core$IMapEntry$) {
          return true;
        } else {
          if (!G__18490.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__18490);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry, G__18490);
      }
    }()) {
      return tcoll.assoc_BANG_(function() {
        var G__18491 = o;
        return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__18491) : cljs.core.key.call(null, G__18491);
      }(), function() {
        var G__18492 = o;
        return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__18492) : cljs.core.val.call(null, G__18492);
      }());
    } else {
      var es = cljs.core.seq(o);
      var tcoll__$1 = tcoll;
      while (true) {
        var temp__4124__auto__ = cljs.core.first(es);
        if (cljs.core.truth_(temp__4124__auto__)) {
          var e = temp__4124__auto__;
          var G__18495 = cljs.core.next(es);
          var G__18496 = tcoll__$1.assoc_BANG_(function() {
            var G__18493 = e;
            return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__18493) : cljs.core.key.call(null, G__18493);
          }(), function() {
            var G__18494 = e;
            return cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__18494) : cljs.core.val.call(null, G__18494);
          }());
          es = G__18495;
          tcoll__$1 = G__18496;
          continue;
        } else {
          return tcoll__$1;
        }
        break;
      }
    }
  } else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.nil_val === v) {
      } else {
        self__.nil_val = v;
      }
      if (self__.has_nil_QMARK_) {
      } else {
        self__.count = self__.count + 1;
        self__.has_nil_QMARK_ = true;
      }
      return tcoll;
    } else {
      var added_leaf_QMARK_ = new cljs.core.Box(false);
      var node = (self__.root == null ? cljs.core.BitmapIndexedNode.EMPTY : self__.root).inode_assoc_BANG_(self__.edit, 0, cljs.core.hash(k), k, v, added_leaf_QMARK_);
      if (node === self__.root) {
      } else {
        self__.root = node;
      }
      if (added_leaf_QMARK_.val) {
        self__.count = self__.count + 1;
      } else {
      }
      return tcoll;
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    if (k == null) {
      if (self__.has_nil_QMARK_) {
        self__.has_nil_QMARK_ = false;
        self__.nil_val = null;
        self__.count = self__.count - 1;
        return tcoll;
      } else {
        return tcoll;
      }
    } else {
      if (self__.root == null) {
        return tcoll;
      } else {
        var removed_leaf_QMARK_ = new cljs.core.Box(false);
        var node = self__.root.inode_without_BANG_(self__.edit, 0, cljs.core.hash(k), k, removed_leaf_QMARK_);
        if (node === self__.root) {
        } else {
          self__.root = node;
        }
        if (cljs.core.truth_(removed_leaf_QMARK_[0])) {
          self__.count = self__.count - 1;
        } else {
        }
        return tcoll;
      }
    }
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var self__ = this;
  var tcoll = this;
  if (self__.edit) {
    self__.edit = null;
    return new cljs.core.PersistentHashMap(null, self__.count, self__.root, self__.has_nil_QMARK_, self__.nil_val, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";
cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/TransientHashMap");
};
cljs.core.__GT_TransientHashMap = function cljs$core$__GT_TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val) {
  return new cljs.core.TransientHashMap(edit, root, count, has_nil_QMARK_, nil_val);
};
cljs.core.tree_map_seq_push = function cljs$core$tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t = node;
  var stack__$1 = stack;
  while (true) {
    if (!(t == null)) {
      var G__18497 = ascending_QMARK_ ? t.left : t.right;
      var G__18498 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1, t);
      t = G__18497;
      stack__$1 = G__18498;
      continue;
    } else {
      return stack__$1;
    }
    break;
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32374862;
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt < 0) {
    return cljs.core.count(cljs.core.next(coll__$1)) + 1;
  } else {
    return self__.cnt;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.peek(self__.stack);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var t = cljs.core.first(self__.stack);
  var next_stack = cljs.core.tree_map_seq_push(self__.ascending_QMARK_ ? t.right : t.left, cljs.core.next(self__.stack), self__.ascending_QMARK_);
  if (!(next_stack == null)) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack, self__.ascending_QMARK_, self__.cnt - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMapSeq(meta__$1, self__.stack, self__.ascending_QMARK_, self__.cnt, self__.__hash);
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/PersistentTreeMapSeq");
};
cljs.core.__GT_PersistentTreeMapSeq = function cljs$core$__GT_PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash) {
  return new cljs.core.PersistentTreeMapSeq(meta, stack, ascending_QMARK_, cnt, __hash);
};
cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.create_tree_map_seq = function cljs$core$create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push(tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null);
};
cljs.core.balance_left = function cljs$core$balance_left(key, val, ins, right) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null);
    } else {
      if (ins.right instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, ins, right, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, ins, right, null);
  }
};
cljs.core.balance_right = function cljs$core$balance_right(key, val, left, ins) {
  if (ins instanceof cljs.core.RedNode) {
    if (ins.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null);
    } else {
      if (ins.left instanceof cljs.core.RedNode) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null);
      } else {
        return new cljs.core.BlackNode(key, val, left, ins, null);
      }
    }
  } else {
    return new cljs.core.BlackNode(key, val, left, ins, null);
  }
};
cljs.core.balance_left_del = function cljs$core$balance_left_del(key, val, del, right) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null);
  } else {
    if (right instanceof cljs.core.BlackNode) {
      return cljs.core.balance_right(key, val, del, right.redden());
    } else {
      if (right instanceof cljs.core.RedNode && right.left instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right(right.key, right.val, right.left.right, right.right.redden()), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.balance_right_del = function cljs$core$balance_right_del(key, val, left, del) {
  if (del instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null);
  } else {
    if (left instanceof cljs.core.BlackNode) {
      return cljs.core.balance_left(key, val, left.redden(), del);
    } else {
      if (left instanceof cljs.core.RedNode && left.right instanceof cljs.core.BlackNode) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left(left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null);
      } else {
        throw new Error("red-black tree invariant violation");
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function cljs$core$tree_map_kv_reduce(node, f, init) {
  var init__$1 = !(node.left == null) ? cljs$core$tree_map_kv_reduce(node.left, f, init) : init;
  if (cljs.core.reduced_QMARK_(init__$1)) {
    var G__18511 = init__$1;
    return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18511) : cljs.core.deref.call(null, G__18511);
  } else {
    var init__$2 = function() {
      var G__18512 = init__$1;
      var G__18513 = node.key;
      var G__18514 = node.val;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18512, G__18513, G__18514) : f.call(null, G__18512, G__18513, G__18514);
    }();
    if (cljs.core.reduced_QMARK_(init__$2)) {
      var G__18515 = init__$2;
      return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18515) : cljs.core.deref.call(null, G__18515);
    } else {
      var init__$3 = !(node.right == null) ? cljs$core$tree_map_kv_reduce(node.right, f, init__$2) : init__$2;
      if (cljs.core.reduced_QMARK_(init__$3)) {
        var G__18516 = init__$3;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18516) : cljs.core.deref.call(null, G__18516);
      } else {
        return init__$3;
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_right(node);
};
cljs.core.BlackNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.BlackNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return node;
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return ins.balance_left(node);
};
cljs.core.BlackNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
};
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_left_del(self__.key, self__.val, del, self__.right);
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return cljs.core.balance_right_del(self__.key, self__.val, self__.left, del);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY, self__.val), self__.key);
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.BlackNode.prototype.call = function() {
  var G__18518 = null;
  var G__18518__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__18518__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__18518 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18518__2.call(this, self__, k);
      case 3:
        return G__18518__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18518.cljs$core$IFn$_invoke$arity$2 = G__18518__2;
  G__18518.cljs$core$IFn$_invoke$arity$3 = G__18518__3;
  return G__18518;
}();
cljs.core.BlackNode.prototype.apply = function(self__, args18517) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18517)));
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";
cljs.core.BlackNode.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/BlackNode");
};
cljs.core.__GT_BlackNode = function cljs$core$__GT_BlackNode(key, val, left, right, __hash) {
  return new cljs.core.BlackNode(key, val, left, right, __hash);
};
cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32402207;
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, ins, null);
};
cljs.core.RedNode.prototype.redden = function() {
  var self__ = this;
  var node = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.blacken = function() {
  var self__ = this;
  var node = this;
  return new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right, null);
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, ins, self__.right, null);
};
cljs.core.RedNode.prototype.replace = function(key__$1, val__$1, left__$1, right__$1) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(key__$1, val__$1, left__$1, right__$1, null);
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.left instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, self__.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, self__.right, parent.right, null), null);
  } else {
    if (self__.right instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.right.key, self__.right.val, new cljs.core.BlackNode(self__.key, self__.val, self__.left, self__.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, self__.right.right, parent.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, node, parent.right, null);
    }
  }
};
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var self__ = this;
  var node = this;
  if (self__.right instanceof cljs.core.RedNode) {
    return new cljs.core.RedNode(self__.key, self__.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left, null), self__.right.blacken(), null);
  } else {
    if (self__.left instanceof cljs.core.RedNode) {
      return new cljs.core.RedNode(self__.left.key, self__.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, self__.left.left, null), new cljs.core.BlackNode(self__.key, self__.val, self__.left.right, self__.right, null), null);
    } else {
      return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node, null);
    }
  }
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, del, self__.right, null);
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var node = this;
  return cljs.core.tree_map_kv_reduce(node, f, init);
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var self__ = this;
  var node = this;
  return new cljs.core.RedNode(self__.key, self__.val, self__.left, del, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, null);
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1, k, not_found);
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return null;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY, self__.val), self__.key);
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.RedNode.prototype.call = function() {
  var G__18520 = null;
  var G__18520__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__18520__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__18520 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18520__2.call(this, self__, k);
      case 3:
        return G__18520__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18520.cljs$core$IFn$_invoke$arity$2 = G__18520__2;
  G__18520.cljs$core$IFn$_invoke$arity$3 = G__18520__3;
  return G__18520;
}();
cljs.core.RedNode.prototype.apply = function(self__, args18519) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18519)));
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";
cljs.core.RedNode.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/RedNode");
};
cljs.core.__GT_RedNode = function cljs$core$__GT_RedNode(key, val, left, right, __hash) {
  return new cljs.core.RedNode(key, val, left, right, __hash);
};
cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.tree_map_add = function cljs$core$tree_map_add(comp, tree, k, v, found) {
  if (tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null);
  } else {
    var c = function() {
      var G__18533 = k;
      var G__18534 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__18533, G__18534) : comp.call(null, G__18533, G__18534);
    }();
    if (c === 0) {
      found[0] = tree;
      return null;
    } else {
      if (c < 0) {
        var ins = cljs$core$tree_map_add(comp, tree.left, k, v, found);
        if (!(ins == null)) {
          return tree.add_left(ins);
        } else {
          return null;
        }
      } else {
        var ins = cljs$core$tree_map_add(comp, tree.right, k, v, found);
        if (!(ins == null)) {
          return tree.add_right(ins);
        } else {
          return null;
        }
      }
    }
  }
};
cljs.core.tree_map_append = function cljs$core$tree_map_append(left, right) {
  if (left == null) {
    return right;
  } else {
    if (right == null) {
      return left;
    } else {
      if (left instanceof cljs.core.RedNode) {
        if (right instanceof cljs.core.RedNode) {
          var app = cljs$core$tree_map_append(left.right, right.left);
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.RedNode(left.key, left.val, left.left, app.left, null), new cljs.core.RedNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app, right.right, null), null);
          }
        } else {
          return new cljs.core.RedNode(left.key, left.val, left.left, cljs$core$tree_map_append(left.right, right), null);
        }
      } else {
        if (right instanceof cljs.core.RedNode) {
          return new cljs.core.RedNode(right.key, right.val, cljs$core$tree_map_append(left, right.left), right.right, null);
        } else {
          var app = cljs$core$tree_map_append(left.right, right.left);
          if (app instanceof cljs.core.RedNode) {
            return new cljs.core.RedNode(app.key, app.val, new cljs.core.BlackNode(left.key, left.val, left.left, app.left, null), new cljs.core.BlackNode(right.key, right.val, app.right, right.right, null), null);
          } else {
            return cljs.core.balance_left_del(left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app, right.right, null));
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function cljs$core$tree_map_remove(comp, tree, k, found) {
  if (!(tree == null)) {
    var c = function() {
      var G__18553 = k;
      var G__18554 = tree.key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__18553, G__18554) : comp.call(null, G__18553, G__18554);
    }();
    if (c === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append(tree.left, tree.right);
    } else {
      if (c < 0) {
        var del = cljs$core$tree_map_remove(comp, tree.left, k, found);
        if (!(del == null) || !(found[0] == null)) {
          if (tree.left instanceof cljs.core.BlackNode) {
            return cljs.core.balance_left_del(tree.key, tree.val, del, tree.right);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, del, tree.right, null);
          }
        } else {
          return null;
        }
      } else {
        var del = cljs$core$tree_map_remove(comp, tree.right, k, found);
        if (!(del == null) || !(found[0] == null)) {
          if (tree.right instanceof cljs.core.BlackNode) {
            return cljs.core.balance_right_del(tree.key, tree.val, tree.left, del);
          } else {
            return new cljs.core.RedNode(tree.key, tree.val, tree.left, del, null);
          }
        } else {
          return null;
        }
      }
    }
  } else {
    return null;
  }
};
cljs.core.tree_map_replace = function cljs$core$tree_map_replace(comp, tree, k, v) {
  var tk = tree.key;
  var c = function() {
    var G__18565 = k;
    var G__18566 = tk;
    return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__18565, G__18566) : comp.call(null, G__18565, G__18566);
  }();
  if (c === 0) {
    return tree.replace(tk, v, tree.left, tree.right);
  } else {
    if (c < 0) {
      return tree.replace(tk, tree.val, cljs$core$tree_map_replace(comp, tree.left, k, v), tree.right);
    } else {
      return tree.replace(tk, tree.val, tree.left, cljs$core$tree_map_replace(comp, tree.right, k, v));
    }
  }
};
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 418776847;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentTreeMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__18568 = cljs.core.seq(coll);
  var chunk__18569 = null;
  var count__18570 = 0;
  var i__18571 = 0;
  while (true) {
    if (i__18571 < count__18570) {
      var vec__18572 = chunk__18569.cljs$core$IIndexed$_nth$arity$2(null, i__18571);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18572, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18572, 1, null);
      var G__18573_18585 = v;
      var G__18574_18586 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18573_18585, G__18574_18586) : f.call(null, G__18573_18585, G__18574_18586);
      var G__18587 = seq__18568;
      var G__18588 = chunk__18569;
      var G__18589 = count__18570;
      var G__18590 = i__18571 + 1;
      seq__18568 = G__18587;
      chunk__18569 = G__18588;
      count__18570 = G__18589;
      i__18571 = G__18590;
      continue;
    } else {
      var temp__4126__auto__ = cljs.core.seq(seq__18568);
      if (temp__4126__auto__) {
        var seq__18568__$1 = temp__4126__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__18568__$1)) {
          var c__5061__auto__ = cljs.core.chunk_first(seq__18568__$1);
          var G__18591 = cljs.core.chunk_rest(seq__18568__$1);
          var G__18592 = c__5061__auto__;
          var G__18593 = cljs.core.count(c__5061__auto__);
          var G__18594 = 0;
          seq__18568 = G__18591;
          chunk__18569 = G__18592;
          count__18570 = G__18593;
          i__18571 = G__18594;
          continue;
        } else {
          var vec__18575 = cljs.core.first(seq__18568__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18575, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18575, 1, null);
          var G__18576_18595 = v;
          var G__18577_18596 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18576_18595, G__18577_18596) : f.call(null, G__18576_18595, G__18577_18596);
          var G__18597 = cljs.core.next(seq__18568__$1);
          var G__18598 = null;
          var G__18599 = 0;
          var G__18600 = 0;
          seq__18568 = G__18597;
          chunk__18569 = G__18598;
          count__18570 = G__18599;
          i__18571 = G__18600;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentTreeMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__18578 = coll;
    return cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__18578) : cljs.core.keys.call(null, G__18578);
  }());
};
cljs.core.PersistentTreeMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(function() {
    var G__18579 = coll;
    return cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__18579) : cljs.core.vals.call(null, G__18579);
  }());
};
cljs.core.PersistentTreeMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var self__ = this;
  var coll = this;
  var t = self__.tree;
  while (true) {
    if (!(t == null)) {
      var c = function() {
        var G__18580 = k;
        var G__18581 = t.key;
        return self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__18580, G__18581) : self__.comp.call(null, G__18580, G__18581);
      }();
      if (c === 0) {
        return t;
      } else {
        if (c < 0) {
          var G__18601 = t.left;
          t = G__18601;
          continue;
        } else {
          var G__18602 = t.right;
          t = G__18602;
          continue;
        }
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.PersistentTreeMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, k, null);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var n = coll__$1.entry_at(k);
  if (!(n == null)) {
    return n.val;
  } else {
    return not_found;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.tree == null)) {
    return cljs.core.tree_map_kv_reduce(self__.tree, f, init);
  } else {
    return init;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, self__.tree, self__.cnt, self__.meta, self__.__hash);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, false, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, null, 0, self__.meta, 0);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var found = [null];
  var t = cljs.core.tree_map_remove(self__.comp, self__.tree, k, found);
  if (t == null) {
    if (cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found, 0) == null) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentTreeMap(self__.comp, null, 0, self__.meta, null);
    }
  } else {
    return new cljs.core.PersistentTreeMap(self__.comp, t.blacken(), self__.cnt - 1, self__.meta, null);
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var found = [null];
  var t = cljs.core.tree_map_add(self__.comp, self__.tree, k, v, found);
  if (t == null) {
    var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found, 0);
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v, found_node.val)) {
      return coll__$1;
    } else {
      return new cljs.core.PersistentTreeMap(self__.comp, cljs.core.tree_map_replace(self__.comp, self__.tree, k, v), self__.cnt, self__.meta, null);
    }
  } else {
    return new cljs.core.PersistentTreeMap(self__.comp, t.blacken(), self__.cnt + 1, self__.meta, null);
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return!(coll__$1.entry_at(k) == null);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, true, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeMap(self__.comp, self__.tree, self__.cnt, meta__$1, self__.__hash);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return cljs.core._assoc(coll__$1, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__18603 = cljs.core._assoc(ret, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__18604 = cljs.core.next(es);
          ret = G__18603;
          es = G__18604;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__18605 = null;
  var G__18605__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__18605__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__18605 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18605__2.call(this, self__, k);
      case 3:
        return G__18605__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18605.cljs$core$IFn$_invoke$arity$2 = G__18605__2;
  G__18605.cljs$core$IFn$_invoke$arity$3 = G__18605__3;
  return G__18605;
}();
cljs.core.PersistentTreeMap.prototype.apply = function(self__, args18567) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18567)));
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return cljs.core.create_tree_map_seq(self__.tree, ascending_QMARK_, self__.cnt);
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    var stack = null;
    var t = self__.tree;
    while (true) {
      if (!(t == null)) {
        var c = function() {
          var G__18582 = k;
          var G__18583 = t.key;
          return self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__18582, G__18583) : self__.comp.call(null, G__18582, G__18583);
        }();
        if (c === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t), ascending_QMARK_, -1, null);
        } else {
          if (cljs.core.truth_(ascending_QMARK_)) {
            if (c < 0) {
              var G__18606 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t);
              var G__18607 = t.left;
              stack = G__18606;
              t = G__18607;
              continue;
            } else {
              var G__18608 = stack;
              var G__18609 = t.right;
              stack = G__18608;
              t = G__18609;
              continue;
            }
          } else {
            if (c > 0) {
              var G__18610 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack, t);
              var G__18611 = t.right;
              stack = G__18610;
              t = G__18611;
              continue;
            } else {
              var G__18612 = stack;
              var G__18613 = t.left;
              stack = G__18612;
              t = G__18613;
              continue;
            }
          }
        }
      } else {
        if (stack == null) {
          return null;
        } else {
          return new cljs.core.PersistentTreeMapSeq(null, stack, ascending_QMARK_, -1, null);
        }
      }
      break;
    }
  } else {
    return null;
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  var G__18584 = entry;
  return cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__18584) : cljs.core.key.call(null, G__18584);
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.comp;
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";
cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/PersistentTreeMap");
};
cljs.core.__GT_PersistentTreeMap = function cljs$core$__GT_PersistentTreeMap(comp, tree, cnt, meta, __hash) {
  return new cljs.core.PersistentTreeMap(comp, tree, cnt, meta, __hash);
};
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, cljs.core.empty_unordered_hash);
cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.hash_map = function cljs$core$hash_map() {
  var argseq__5316__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
};
cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (in$) {
      var G__18615 = cljs.core.nnext(in$);
      var G__18616 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__18615;
      out = G__18616;
      continue;
    } else {
      return cljs.core.persistent_BANG_(out);
    }
    break;
  }
};
cljs.core.hash_map.cljs$lang$maxFixedArity = 0;
cljs.core.hash_map.cljs$lang$applyTo = function(seq18614) {
  return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18614));
};
cljs.core.array_map = function cljs$core$array_map() {
  var argseq__5316__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
};
cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var arr = keyvals instanceof cljs.core.IndexedSeq ? keyvals.arr : cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals);
  return cljs.core.PersistentArrayMap.fromArray(arr, true, false);
};
cljs.core.array_map.cljs$lang$maxFixedArity = 0;
cljs.core.array_map.cljs$lang$applyTo = function(seq18617) {
  return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18617));
};
cljs.core.obj_map = function cljs$core$obj_map() {
  var argseq__5316__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
};
cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var ks = [];
  var obj = function() {
    var obj18620 = {};
    return obj18620;
  }();
  var kvs = cljs.core.seq(keyvals);
  while (true) {
    if (kvs) {
      ks.push(cljs.core.first(kvs));
      obj[cljs.core.first(kvs)] = cljs.core.second(kvs);
      var G__18621 = cljs.core.nnext(kvs);
      kvs = G__18621;
      continue;
    } else {
      return cljs.core.ObjMap.fromObject(ks, obj);
    }
    break;
  }
};
cljs.core.obj_map.cljs$lang$maxFixedArity = 0;
cljs.core.obj_map.cljs$lang$applyTo = function(seq18618) {
  return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18618));
};
cljs.core.sorted_map = function cljs$core$sorted_map() {
  var argseq__5316__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
};
cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = cljs.core.PersistentTreeMap.EMPTY;
  while (true) {
    if (in$) {
      var G__18623 = cljs.core.nnext(in$);
      var G__18624 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__18623;
      out = G__18624;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.sorted_map.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_map.cljs$lang$applyTo = function(seq18622) {
  return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18622));
};
cljs.core.sorted_map_by = function cljs$core$sorted_map_by() {
  var argseq__5316__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5316__auto__);
};
cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = function(comparator, keyvals) {
  var in$ = cljs.core.seq(keyvals);
  var out = new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator), null, 0, null, 0);
  while (true) {
    if (in$) {
      var G__18627 = cljs.core.nnext(in$);
      var G__18628 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out, cljs.core.first(in$), cljs.core.second(in$));
      in$ = G__18627;
      out = G__18628;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.sorted_map_by.cljs$lang$maxFixedArity = 1;
cljs.core.sorted_map_by.cljs$lang$applyTo = function(seq18625) {
  var G__18626 = cljs.core.first(seq18625);
  var seq18625__$1 = cljs.core.next(seq18625);
  return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__18626, seq18625__$1);
};
cljs.core.KeySeq = function(mseq, _meta) {
  this.mseq = mseq;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
};
cljs.core.KeySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.KeySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__18629 = self__.mseq;
    if (G__18629) {
      var bit__4950__auto__ = G__18629.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4950__auto__ || G__18629.cljs$core$INext$) {
        return true;
      } else {
        if (!G__18629.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__18629);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__18629);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (nseq == null) {
    return null;
  } else {
    return new cljs.core.KeySeq(nseq, self__._meta);
  }
};
cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
  return me.cljs$core$IMapEntry$_key$arity$1(null);
};
cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__18630 = self__.mseq;
    if (G__18630) {
      var bit__4950__auto__ = G__18630.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4950__auto__ || G__18630.cljs$core$INext$) {
        return true;
      } else {
        if (!G__18630.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__18630);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__18630);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (!(nseq == null)) {
    return new cljs.core.KeySeq(nseq, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.KeySeq(self__.mseq, new_meta);
};
cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.KeySeq.cljs$lang$type = true;
cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";
cljs.core.KeySeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/KeySeq");
};
cljs.core.__GT_KeySeq = function cljs$core$__GT_KeySeq(mseq, _meta) {
  return new cljs.core.KeySeq(mseq, _meta);
};
cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.keys = function cljs$core$keys(hash_map) {
  var temp__4126__auto__ = cljs.core.seq(hash_map);
  if (temp__4126__auto__) {
    var mseq = temp__4126__auto__;
    return new cljs.core.KeySeq(mseq, null);
  } else {
    return null;
  }
};
cljs.core.key = function cljs$core$key(map_entry) {
  return cljs.core._key(map_entry);
};
cljs.core.ValSeq = function(mseq, _meta) {
  this.mseq = mseq;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
};
cljs.core.ValSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ValSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__18631 = self__.mseq;
    if (G__18631) {
      var bit__4950__auto__ = G__18631.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4950__auto__ || G__18631.cljs$core$INext$) {
        return true;
      } else {
        if (!G__18631.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__18631);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__18631);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (nseq == null) {
    return null;
  } else {
    return new cljs.core.ValSeq(nseq, self__._meta);
  }
};
cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
  return me.cljs$core$IMapEntry$_val$arity$1(null);
};
cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var nseq = function() {
    var G__18632 = self__.mseq;
    if (G__18632) {
      var bit__4950__auto__ = G__18632.cljs$lang$protocol_mask$partition0$ & 128;
      if (bit__4950__auto__ || G__18632.cljs$core$INext$) {
        return true;
      } else {
        if (!G__18632.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__18632);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.INext, G__18632);
    }
  }() ? self__.mseq.cljs$core$INext$_next$arity$1(null) : cljs.core.next(self__.mseq);
  if (!(nseq == null)) {
    return new cljs.core.ValSeq(nseq, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ValSeq(self__.mseq, new_meta);
};
cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ValSeq.cljs$lang$type = true;
cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";
cljs.core.ValSeq.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ValSeq");
};
cljs.core.__GT_ValSeq = function cljs$core$__GT_ValSeq(mseq, _meta) {
  return new cljs.core.ValSeq(mseq, _meta);
};
cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.vals = function cljs$core$vals(hash_map) {
  var temp__4126__auto__ = cljs.core.seq(hash_map);
  if (temp__4126__auto__) {
    var mseq = temp__4126__auto__;
    return new cljs.core.ValSeq(mseq, null);
  } else {
    return null;
  }
};
cljs.core.val = function cljs$core$val(map_entry) {
  return cljs.core._val(map_entry);
};
cljs.core.merge = function cljs$core$merge() {
  var argseq__5316__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
};
cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = function(maps) {
  if (cljs.core.truth_(cljs.core.some(cljs.core.identity, maps))) {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(function(p1__18633_SHARP_, p2__18634_SHARP_) {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
        var or__4276__auto__ = p1__18633_SHARP_;
        if (cljs.core.truth_(or__4276__auto__)) {
          return or__4276__auto__;
        } else {
          return cljs.core.PersistentArrayMap.EMPTY;
        }
      }(), p2__18634_SHARP_);
    }, maps);
  } else {
    return null;
  }
};
cljs.core.merge.cljs$lang$maxFixedArity = 0;
cljs.core.merge.cljs$lang$applyTo = function(seq18635) {
  return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18635));
};
cljs.core.merge_with = function cljs$core$merge_with() {
  var argseq__5316__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5316__auto__);
};
cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = function(f, maps) {
  if (cljs.core.truth_(cljs.core.some(cljs.core.identity, maps))) {
    var merge_entry = function(m, e) {
      var k = cljs.core.first(e);
      var v = cljs.core.second(e);
      if (cljs.core.contains_QMARK_(m, k)) {
        return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
          var G__18638 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
          var G__18639 = v;
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18638, G__18639) : f.call(null, G__18638, G__18639);
        }());
      } else {
        return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
      }
    };
    var merge2 = function(merge_entry) {
      return function(m1, m2) {
        return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry, function() {
          var or__4276__auto__ = m1;
          if (cljs.core.truth_(or__4276__auto__)) {
            return or__4276__auto__;
          } else {
            return cljs.core.PersistentArrayMap.EMPTY;
          }
        }(), cljs.core.seq(m2));
      };
    }(merge_entry);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2, maps);
  } else {
    return null;
  }
};
cljs.core.merge_with.cljs$lang$maxFixedArity = 1;
cljs.core.merge_with.cljs$lang$applyTo = function(seq18636) {
  var G__18637 = cljs.core.first(seq18636);
  var seq18636__$1 = cljs.core.next(seq18636);
  return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__18637, seq18636__$1);
};
cljs.core.select_keys = function cljs$core$select_keys(map, keyseq) {
  var ret = cljs.core.PersistentArrayMap.EMPTY;
  var keys = cljs.core.seq(keyseq);
  while (true) {
    if (keys) {
      var key = cljs.core.first(keys);
      var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map, key, new cljs.core.Keyword("cljs.core", "not-found", "cljs.core/not-found", -1572889185));
      var G__18640 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry, new cljs.core.Keyword("cljs.core", "not-found", "cljs.core/not-found", -1572889185)) ? cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret, key, entry) : ret;
      var G__18641 = cljs.core.next(keys);
      ret = G__18640;
      keys = G__18641;
      continue;
    } else {
      return cljs.core.with_meta(ret, cljs.core.meta(map));
    }
    break;
  }
};
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 15077647;
  this.cljs$lang$protocol_mask$partition1$ = 8196;
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentHashSet.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentHashSet.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentHashSet.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentHashSet.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__18644 = cljs.core.seq(coll);
  var chunk__18645 = null;
  var count__18646 = 0;
  var i__18647 = 0;
  while (true) {
    if (i__18647 < count__18646) {
      var vec__18648 = chunk__18645.cljs$core$IIndexed$_nth$arity$2(null, i__18647);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18648, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18648, 1, null);
      var G__18649_18654 = v;
      var G__18650_18655 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18649_18654, G__18650_18655) : f.call(null, G__18649_18654, G__18650_18655);
      var G__18656 = seq__18644;
      var G__18657 = chunk__18645;
      var G__18658 = count__18646;
      var G__18659 = i__18647 + 1;
      seq__18644 = G__18656;
      chunk__18645 = G__18657;
      count__18646 = G__18658;
      i__18647 = G__18659;
      continue;
    } else {
      var temp__4126__auto__ = cljs.core.seq(seq__18644);
      if (temp__4126__auto__) {
        var seq__18644__$1 = temp__4126__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__18644__$1)) {
          var c__5061__auto__ = cljs.core.chunk_first(seq__18644__$1);
          var G__18660 = cljs.core.chunk_rest(seq__18644__$1);
          var G__18661 = c__5061__auto__;
          var G__18662 = cljs.core.count(c__5061__auto__);
          var G__18663 = 0;
          seq__18644 = G__18660;
          chunk__18645 = G__18661;
          count__18646 = G__18662;
          i__18647 = G__18663;
          continue;
        } else {
          var vec__18651 = cljs.core.first(seq__18644__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18651, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18651, 1, null);
          var G__18652_18664 = v;
          var G__18653_18665 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18652_18664, G__18653_18665) : f.call(null, G__18652_18664, G__18653_18665);
          var G__18666 = cljs.core.next(seq__18644__$1);
          var G__18667 = null;
          var G__18668 = 0;
          var G__18669 = 0;
          seq__18644 = G__18666;
          chunk__18645 = G__18667;
          count__18646 = G__18668;
          i__18647 = G__18669;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, v, null);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._contains_key_QMARK_(self__.hash_map, v)) {
    return v;
  } else {
    return not_found;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, self__.hash_map, self__.__hash);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._count(self__.hash_map);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.set_QMARK_(other) && cljs.core.count(coll__$1) === cljs.core.count(other) && cljs.core.every_QMARK_(function(coll__$1) {
    return function(p1__18642_SHARP_) {
      return cljs.core.contains_QMARK_(coll__$1, p1__18642_SHARP_);
    };
  }(coll__$1), other);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map));
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY, self__.meta);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, cljs.core._dissoc(self__.hash_map, v), null);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.keys(self__.hash_map);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(meta__$1, self__.hash_map, self__.__hash);
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentHashSet(self__.meta, cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map, o, null), null);
};
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__18670 = null;
  var G__18670__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__18670__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__18670 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18670__2.call(this, self__, k);
      case 3:
        return G__18670__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18670.cljs$core$IFn$_invoke$arity$2 = G__18670__2;
  G__18670.cljs$core$IFn$_invoke$arity$3 = G__18670__3;
  return G__18670;
}();
cljs.core.PersistentHashSet.prototype.apply = function(self__, args18643) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18643)));
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";
cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/PersistentHashSet");
};
cljs.core.__GT_PersistentHashSet = function cljs$core$__GT_PersistentHashSet(meta, hash_map, __hash) {
  return new cljs.core.PersistentHashSet(meta, hash_map, __hash);
};
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.PersistentArrayMap.EMPTY, cljs.core.empty_unordered_hash);
cljs.core.PersistentHashSet.fromArray = function(items, no_clone) {
  var len = items.length;
  if (len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
    var arr = no_clone ? items : cljs.core.aclone(items);
    var i = 0;
    var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
    while (true) {
      if (i < len) {
        var G__18671 = i + 1;
        var G__18672 = cljs.core._assoc_BANG_(out, items[i], null);
        i = G__18671;
        out = G__18672;
        continue;
      } else {
        return new cljs.core.PersistentHashSet(null, cljs.core._persistent_BANG_(out), null);
      }
      break;
    }
  } else {
    var i = 0;
    var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
    while (true) {
      if (i < len) {
        var G__18673 = i + 1;
        var G__18674 = cljs.core._conj_BANG_(out, items[i]);
        i = G__18673;
        out = G__18674;
        continue;
      } else {
        return cljs.core._persistent_BANG_(out);
      }
      break;
    }
  }
};
cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 259;
  this.cljs$lang$protocol_mask$partition1$ = 136;
};
cljs.core.TransientHashSet.prototype.call = function() {
  var G__18676 = null;
  var G__18676__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var tcoll = self____$1;
    if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null;
    } else {
      return k;
    }
  };
  var G__18676__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var tcoll = self____$1;
    if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found;
    } else {
      return k;
    }
  };
  G__18676 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18676__2.call(this, self__, k);
      case 3:
        return G__18676__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18676.cljs$core$IFn$_invoke$arity$2 = G__18676__2;
  G__18676.cljs$core$IFn$_invoke$arity$3 = G__18676__3;
  return G__18676;
}();
cljs.core.TransientHashSet.prototype.apply = function(self__, args18675) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18675)));
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var tcoll = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return null;
  } else {
    return k;
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var tcoll = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found;
  } else {
    return k;
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1, v, null);
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found;
  } else {
    return v;
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return cljs.core.count(self__.transient_map);
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var self__ = this;
  var tcoll__$1 = this;
  self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map, v);
  return tcoll__$1;
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map, o, null);
  return tcoll__$1;
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_(self__.transient_map), null);
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";
cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/TransientHashSet");
};
cljs.core.__GT_TransientHashSet = function cljs$core$__GT_TransientHashSet(transient_map) {
  return new cljs.core.TransientHashSet(transient_map);
};
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 417730831;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentTreeSet.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentTreeSet.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentTreeSet.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentTreeSet.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__18679 = cljs.core.seq(coll);
  var chunk__18680 = null;
  var count__18681 = 0;
  var i__18682 = 0;
  while (true) {
    if (i__18682 < count__18681) {
      var vec__18683 = chunk__18680.cljs$core$IIndexed$_nth$arity$2(null, i__18682);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18683, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18683, 1, null);
      var G__18684_18689 = v;
      var G__18685_18690 = k;
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18684_18689, G__18685_18690) : f.call(null, G__18684_18689, G__18685_18690);
      var G__18691 = seq__18679;
      var G__18692 = chunk__18680;
      var G__18693 = count__18681;
      var G__18694 = i__18682 + 1;
      seq__18679 = G__18691;
      chunk__18680 = G__18692;
      count__18681 = G__18693;
      i__18682 = G__18694;
      continue;
    } else {
      var temp__4126__auto__ = cljs.core.seq(seq__18679);
      if (temp__4126__auto__) {
        var seq__18679__$1 = temp__4126__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__18679__$1)) {
          var c__5061__auto__ = cljs.core.chunk_first(seq__18679__$1);
          var G__18695 = cljs.core.chunk_rest(seq__18679__$1);
          var G__18696 = c__5061__auto__;
          var G__18697 = cljs.core.count(c__5061__auto__);
          var G__18698 = 0;
          seq__18679 = G__18695;
          chunk__18680 = G__18696;
          count__18681 = G__18697;
          i__18682 = G__18698;
          continue;
        } else {
          var vec__18686 = cljs.core.first(seq__18679__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18686, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18686, 1, null);
          var G__18687_18699 = v;
          var G__18688_18700 = k;
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18687_18699, G__18688_18700) : f.call(null, G__18687_18699, G__18688_18700);
          var G__18701 = cljs.core.next(seq__18679__$1);
          var G__18702 = null;
          var G__18703 = 0;
          var G__18704 = 0;
          seq__18679 = G__18701;
          chunk__18680 = G__18702;
          count__18681 = G__18703;
          i__18682 = G__18704;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1, v, null);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var n = self__.tree_map.entry_at(v);
  if (!(n == null)) {
    return n.key;
  } else {
    return not_found;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, self__.tree_map, self__.__hash);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.count(self__.tree_map);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.count(self__.tree_map) > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core.rseq(self__.tree_map));
  } else {
    return null;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.set_QMARK_(other) && cljs.core.count(coll__$1) === cljs.core.count(other) && cljs.core.every_QMARK_(function(coll__$1) {
    return function(p1__18677_SHARP_) {
      return cljs.core.contains_QMARK_(coll__$1, p1__18677_SHARP_);
    };
  }(coll__$1), other);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core._empty(self__.tree_map), 0);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map, v), null);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.keys(self__.tree_map);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(meta__$1, self__.tree_map, self__.__hash);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentTreeSet(self__.meta, cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map, o, null), null);
};
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__18705 = null;
  var G__18705__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__18705__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__18705 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__18705__2.call(this, self__, k);
      case 3:
        return G__18705__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + arguments.length);
  };
  G__18705.cljs$core$IFn$_invoke$arity$2 = G__18705__2;
  G__18705.cljs$core$IFn$_invoke$arity$3 = G__18705__3;
  return G__18705;
}();
cljs.core.PersistentTreeSet.prototype.apply = function(self__, args18678) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args18678)));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core._sorted_seq(self__.tree_map, ascending_QMARK_));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key, cljs.core._sorted_seq_from(self__.tree_map, k, ascending_QMARK_));
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  return entry;
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._comparator(self__.tree_map);
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";
cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/PersistentTreeSet");
};
cljs.core.__GT_PersistentTreeSet = function cljs$core$__GT_PersistentTreeSet(meta, tree_map, __hash) {
  return new cljs.core.PersistentTreeSet(meta, tree_map, __hash);
};
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.PersistentTreeMap.EMPTY, cljs.core.empty_unordered_hash);
cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.set_from_indexed_seq = function cljs$core$set_from_indexed_seq(iseq) {
  var arr = iseq.arr;
  var ret = function() {
    var a__5155__auto__ = arr;
    var i = 0;
    var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
    while (true) {
      if (i < a__5155__auto__.length) {
        var G__18706 = i + 1;
        var G__18707 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null, arr[i]);
        i = G__18706;
        res = G__18707;
        continue;
      } else {
        return res;
      }
      break;
    }
  }();
  return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
};
cljs.core.set = function cljs$core$set(coll) {
  var in$ = cljs.core.seq(coll);
  if (in$ == null) {
    return cljs.core.PersistentHashSet.EMPTY;
  } else {
    if (in$ instanceof cljs.core.IndexedSeq && in$.i === 0) {
      return cljs.core.set_from_indexed_seq(in$);
    } else {
      var in$__$1 = in$;
      var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
      while (true) {
        if (!(in$__$1 == null)) {
          var G__18708 = in$__$1.cljs$core$INext$_next$arity$1(null);
          var G__18709 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null, in$__$1.cljs$core$ISeq$_first$arity$1(null));
          in$__$1 = G__18708;
          out = G__18709;
          continue;
        } else {
          return out.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
        }
        break;
      }
    }
  }
};
cljs.core.hash_set = function cljs$core$hash_set() {
  var G__18712 = arguments.length;
  switch(G__18712) {
    case 0:
      return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0);
      return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5328__auto__);
  }
};
cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentHashSet.EMPTY;
};
cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = function(keys) {
  return cljs.core.set(keys);
};
cljs.core.hash_set.cljs$lang$applyTo = function(seq18710) {
  return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18710));
};
cljs.core.hash_set.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_set = function cljs$core$sorted_set() {
  var argseq__5316__auto__ = 0 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 0), 0) : null;
  return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5316__auto__);
};
cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = function(keys) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys);
};
cljs.core.sorted_set.cljs$lang$maxFixedArity = 0;
cljs.core.sorted_set.cljs$lang$applyTo = function(seq18714) {
  return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq18714));
};
cljs.core.sorted_set_by = function cljs$core$sorted_set_by() {
  var argseq__5316__auto__ = 1 < arguments.length ? new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 1), 0) : null;
  return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__5316__auto__);
};
cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = function(comparator, keys) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by(comparator), 0), keys);
};
cljs.core.sorted_set_by.cljs$lang$maxFixedArity = 1;
cljs.core.sorted_set_by.cljs$lang$applyTo = function(seq18715) {
  var G__18716 = cljs.core.first(seq18715);
  var seq18715__$1 = cljs.core.next(seq18715);
  return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__18716, seq18715__$1);
};
cljs.core.replace = function cljs$core$replace() {
  var G__18720 = arguments.length;
  switch(G__18720) {
    case 1:
      return cljs.core.replace.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.replace.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = function(smap) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$1(function(p1__18717_SHARP_) {
    var temp__4124__auto__ = cljs.core.find(smap, p1__18717_SHARP_);
    if (cljs.core.truth_(temp__4124__auto__)) {
      var e = temp__4124__auto__;
      return cljs.core.val(e);
    } else {
      return p1__18717_SHARP_;
    }
  });
};
cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = function(smap, coll) {
  if (cljs.core.vector_QMARK_(coll)) {
    var n = cljs.core.count(coll);
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(n) {
      return function(v, i) {
        var temp__4124__auto__ = cljs.core.find(smap, cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v, i));
        if (cljs.core.truth_(temp__4124__auto__)) {
          var e = temp__4124__auto__;
          return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v, i, cljs.core.second(e));
        } else {
          return v;
        }
      };
    }(n), coll, cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.iterate(cljs.core.inc, 0)));
  } else {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(p1__18718_SHARP_) {
      var temp__4124__auto__ = cljs.core.find(smap, p1__18718_SHARP_);
      if (cljs.core.truth_(temp__4124__auto__)) {
        var e = temp__4124__auto__;
        return cljs.core.second(e);
      } else {
        return p1__18718_SHARP_;
      }
    }, coll);
  }
};
cljs.core.replace.cljs$lang$maxFixedArity = 2;
cljs.core.distinct = function cljs$core$distinct() {
  var G__18723 = arguments.length;
  switch(G__18723) {
    case 0:
      return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = function() {
  return function(rf) {
    var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
    return function(seen) {
      return function() {
        var G__18735 = null;
        var G__18735__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__18735__1 = function(result) {
          var G__18724 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18724) : rf.call(null, G__18724);
        };
        var G__18735__2 = function(result, input) {
          if (cljs.core.contains_QMARK_(function() {
            var G__18725 = seen;
            return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18725) : cljs.core.deref.call(null, G__18725);
          }(), input)) {
            return result;
          } else {
            cljs.core._vreset_BANG_(seen, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen), input));
            var G__18726 = result;
            var G__18727 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18726, G__18727) : rf.call(null, G__18726, G__18727);
          }
        };
        G__18735 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__18735__0.call(this);
            case 1:
              return G__18735__1.call(this, result);
            case 2:
              return G__18735__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__18735.cljs$core$IFn$_invoke$arity$0 = G__18735__0;
        G__18735.cljs$core$IFn$_invoke$arity$1 = G__18735__1;
        G__18735.cljs$core$IFn$_invoke$arity$2 = G__18735__2;
        return G__18735;
      }();
    }(seen);
  };
};
cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var step = function cljs$core$step(xs, seen) {
    return new cljs.core.LazySeq(null, function() {
      return function(p__18732, seen__$1) {
        while (true) {
          var vec__18733 = p__18732;
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18733, 0, null);
          var xs__$1 = vec__18733;
          var temp__4126__auto__ = cljs.core.seq(xs__$1);
          if (temp__4126__auto__) {
            var s = temp__4126__auto__;
            if (cljs.core.contains_QMARK_(seen__$1, f)) {
              var G__18736 = cljs.core.rest(s);
              var G__18737 = seen__$1;
              p__18732 = G__18736;
              seen__$1 = G__18737;
              continue;
            } else {
              return cljs.core.cons(f, cljs$core$step(cljs.core.rest(s), cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1, f)));
            }
          } else {
            return null;
          }
          break;
        }
      }.call(null, xs, seen);
    }, null, null);
  };
  return step(coll, cljs.core.PersistentHashSet.EMPTY);
};
cljs.core.distinct.cljs$lang$maxFixedArity = 1;
cljs.core.butlast = function cljs$core$butlast(s) {
  var ret = cljs.core.PersistentVector.EMPTY;
  var s__$1 = s;
  while (true) {
    if (cljs.core.next(s__$1)) {
      var G__18738 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret, cljs.core.first(s__$1));
      var G__18739 = cljs.core.next(s__$1);
      ret = G__18738;
      s__$1 = G__18739;
      continue;
    } else {
      return cljs.core.seq(ret);
    }
    break;
  }
};
cljs.core.name = function cljs$core$name(x) {
  if (function() {
    var G__18741 = x;
    if (G__18741) {
      var bit__4943__auto__ = G__18741.cljs$lang$protocol_mask$partition1$ & 4096;
      if (bit__4943__auto__ || G__18741.cljs$core$INamed$) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  }()) {
    return x.cljs$core$INamed$_name$arity$1(null);
  } else {
    if (typeof x === "string") {
      return x;
    } else {
      throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
    }
  }
};
cljs.core.zipmap = function cljs$core$zipmap(keys, vals) {
  var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
  var ks = cljs.core.seq(keys);
  var vs = cljs.core.seq(vals);
  while (true) {
    if (ks && vs) {
      var G__18742 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map, cljs.core.first(ks), cljs.core.first(vs));
      var G__18743 = cljs.core.next(ks);
      var G__18744 = cljs.core.next(vs);
      map = G__18742;
      ks = G__18743;
      vs = G__18744;
      continue;
    } else {
      return cljs.core.persistent_BANG_(map);
    }
    break;
  }
};
cljs.core.max_key = function cljs$core$max_key() {
  var G__18752 = arguments.length;
  switch(G__18752) {
    case 2:
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5328__auto__);
  }
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = function(k, x) {
  return x;
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = function(k, x, y) {
  if (function() {
    var G__18753 = x;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__18753) : k.call(null, G__18753);
  }() > function() {
    var G__18754 = y;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__18754) : k.call(null, G__18754);
  }()) {
    return x;
  } else {
    return y;
  }
};
cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = function(k, x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(p1__18745_SHARP_, p2__18746_SHARP_) {
    return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k, p1__18745_SHARP_, p2__18746_SHARP_);
  }, cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k, x, y), more);
};
cljs.core.max_key.cljs$lang$applyTo = function(seq18747) {
  var G__18748 = cljs.core.first(seq18747);
  var seq18747__$1 = cljs.core.next(seq18747);
  var G__18749 = cljs.core.first(seq18747__$1);
  var seq18747__$2 = cljs.core.next(seq18747__$1);
  var G__18750 = cljs.core.first(seq18747__$2);
  var seq18747__$3 = cljs.core.next(seq18747__$2);
  return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__18748, G__18749, G__18750, seq18747__$3);
};
cljs.core.max_key.cljs$lang$maxFixedArity = 3;
cljs.core.min_key = function cljs$core$min_key() {
  var G__18763 = arguments.length;
  switch(G__18763) {
    case 2:
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5328__auto__);
  }
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = function(k, x) {
  return x;
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = function(k, x, y) {
  if (function() {
    var G__18764 = x;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__18764) : k.call(null, G__18764);
  }() < function() {
    var G__18765 = y;
    return k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__18765) : k.call(null, G__18765);
  }()) {
    return x;
  } else {
    return y;
  }
};
cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = function(k, x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(p1__18756_SHARP_, p2__18757_SHARP_) {
    return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k, p1__18756_SHARP_, p2__18757_SHARP_);
  }, cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k, x, y), more);
};
cljs.core.min_key.cljs$lang$applyTo = function(seq18758) {
  var G__18759 = cljs.core.first(seq18758);
  var seq18758__$1 = cljs.core.next(seq18758);
  var G__18760 = cljs.core.first(seq18758__$1);
  var seq18758__$2 = cljs.core.next(seq18758__$1);
  var G__18761 = cljs.core.first(seq18758__$2);
  var seq18758__$3 = cljs.core.next(seq18758__$2);
  return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__18759, G__18760, G__18761, seq18758__$3);
};
cljs.core.min_key.cljs$lang$maxFixedArity = 3;
cljs.core.ArrayList = function(arr) {
  this.arr = arr;
};
cljs.core.ArrayList.prototype.add = function(x) {
  var self__ = this;
  var _ = this;
  return self__.arr.push(x);
};
cljs.core.ArrayList.prototype.size = function() {
  var self__ = this;
  var _ = this;
  return self__.arr.length;
};
cljs.core.ArrayList.prototype.clear = function() {
  var self__ = this;
  var _ = this;
  return self__.arr = [];
};
cljs.core.ArrayList.prototype.isEmpty = function() {
  var self__ = this;
  var _ = this;
  return self__.arr.length === 0;
};
cljs.core.ArrayList.prototype.toArray = function() {
  var self__ = this;
  var _ = this;
  return self__.arr;
};
cljs.core.ArrayList.cljs$lang$type = true;
cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";
cljs.core.ArrayList.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/ArrayList");
};
cljs.core.__GT_ArrayList = function cljs$core$__GT_ArrayList(arr) {
  return new cljs.core.ArrayList(arr);
};
cljs.core.array_list = function cljs$core$array_list() {
  return new cljs.core.ArrayList([]);
};
cljs.core.partition_all = function cljs$core$partition_all() {
  var G__18768 = arguments.length;
  switch(G__18768) {
    case 1:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var a = cljs.core.array_list();
    return function(a) {
      return function() {
        var G__18775 = null;
        var G__18775__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__18775__1 = function(result) {
          var result__$1 = cljs.core.truth_(a.isEmpty()) ? result : function() {
            var v = cljs.core.vec(a.toArray());
            a.clear();
            return cljs.core.unreduced(function() {
              var G__18769 = result;
              var G__18770 = v;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18769, G__18770) : rf.call(null, G__18769, G__18770);
            }());
          }();
          var G__18771 = result__$1;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18771) : rf.call(null, G__18771);
        };
        var G__18775__2 = function(result, input) {
          a.add(input);
          if (n === a.size()) {
            var v = cljs.core.vec(a.toArray());
            a.clear();
            var G__18772 = result;
            var G__18773 = v;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18772, G__18773) : rf.call(null, G__18772, G__18773);
          } else {
            return result;
          }
        };
        G__18775 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__18775__0.call(this);
            case 1:
              return G__18775__1.call(this, result);
            case 2:
              return G__18775__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__18775.cljs$core$IFn$_invoke$arity$0 = G__18775__0;
        G__18775.cljs$core$IFn$_invoke$arity$1 = G__18775__1;
        G__18775.cljs$core$IFn$_invoke$arity$2 = G__18775__2;
        return G__18775;
      }();
    }(a);
  };
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4126__auto__ = cljs.core.seq(coll);
    if (temp__4126__auto__) {
      var s = temp__4126__auto__;
      return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s), cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition_all.cljs$lang$maxFixedArity = 3;
cljs.core.take_while = function cljs$core$take_while() {
  var G__18777 = arguments.length;
  switch(G__18777) {
    case 1:
      return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__18784 = null;
      var G__18784__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__18784__1 = function(result) {
        var G__18778 = result;
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18778) : rf.call(null, G__18778);
      };
      var G__18784__2 = function(result, input) {
        if (cljs.core.truth_(function() {
          var G__18779 = input;
          return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18779) : pred.call(null, G__18779);
        }())) {
          var G__18780 = result;
          var G__18781 = input;
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18780, G__18781) : rf.call(null, G__18780, G__18781);
        } else {
          return cljs.core.reduced(result);
        }
      };
      G__18784 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__18784__0.call(this);
          case 1:
            return G__18784__1.call(this, result);
          case 2:
            return G__18784__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__18784.cljs$core$IFn$_invoke$arity$0 = G__18784__0;
      G__18784.cljs$core$IFn$_invoke$arity$1 = G__18784__1;
      G__18784.cljs$core$IFn$_invoke$arity$2 = G__18784__2;
      return G__18784;
    }();
  };
};
cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4126__auto__ = cljs.core.seq(coll);
    if (temp__4126__auto__) {
      var s = temp__4126__auto__;
      if (cljs.core.truth_(function() {
        var G__18782 = cljs.core.first(s);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__18782) : pred.call(null, G__18782);
      }())) {
        return cljs.core.cons(cljs.core.first(s), cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take_while.cljs$lang$maxFixedArity = 2;
cljs.core.mk_bound_fn = function cljs$core$mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp = cljs.core._comparator(sc);
    var G__18789 = function() {
      var G__18791 = cljs.core._entry_key(sc, e);
      var G__18792 = key;
      return comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__18791, G__18792) : comp.call(null, G__18791, G__18792);
    }();
    var G__18790 = 0;
    return test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__18789, G__18790) : test.call(null, G__18789, G__18790);
  };
};
cljs.core.subseq = function cljs$core$subseq() {
  var G__18794 = arguments.length;
  switch(G__18794) {
    case 3:
      return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = function(sc, test, key) {
  var include = cljs.core.mk_bound_fn(sc, test, key);
  if (cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_, cljs.core._GT__EQ_], true).call(null, test))) {
    var temp__4126__auto__ = cljs.core._sorted_seq_from(sc, key, true);
    if (cljs.core.truth_(temp__4126__auto__)) {
      var vec__18795 = temp__4126__auto__;
      var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18795, 0, null);
      var s = vec__18795;
      if (cljs.core.truth_(function() {
        var G__18796 = e;
        return include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__18796) : include.call(null, G__18796);
      }())) {
        return s;
      } else {
        return cljs.core.next(s);
      }
    } else {
      return null;
    }
  } else {
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include, cljs.core._sorted_seq(sc, true));
  }
};
cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = function(sc, start_test, start_key, end_test, end_key) {
  var temp__4126__auto__ = cljs.core._sorted_seq_from(sc, start_key, true);
  if (cljs.core.truth_(temp__4126__auto__)) {
    var vec__18797 = temp__4126__auto__;
    var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18797, 0, null);
    var s = vec__18797;
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn(sc, start_test, start_key).call(null, e)) ? s : cljs.core.next(s));
  } else {
    return null;
  }
};
cljs.core.subseq.cljs$lang$maxFixedArity = 5;
cljs.core.rsubseq = function cljs$core$rsubseq() {
  var G__18800 = arguments.length;
  switch(G__18800) {
    case 3:
      return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = function(sc, test, key) {
  var include = cljs.core.mk_bound_fn(sc, test, key);
  if (cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_, cljs.core._LT__EQ_], true).call(null, test))) {
    var temp__4126__auto__ = cljs.core._sorted_seq_from(sc, key, false);
    if (cljs.core.truth_(temp__4126__auto__)) {
      var vec__18801 = temp__4126__auto__;
      var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18801, 0, null);
      var s = vec__18801;
      if (cljs.core.truth_(function() {
        var G__18802 = e;
        return include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__18802) : include.call(null, G__18802);
      }())) {
        return s;
      } else {
        return cljs.core.next(s);
      }
    } else {
      return null;
    }
  } else {
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include, cljs.core._sorted_seq(sc, false));
  }
};
cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = function(sc, start_test, start_key, end_test, end_key) {
  var temp__4126__auto__ = cljs.core._sorted_seq_from(sc, end_key, false);
  if (cljs.core.truth_(temp__4126__auto__)) {
    var vec__18803 = temp__4126__auto__;
    var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18803, 0, null);
    var s = vec__18803;
    return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn(sc, end_test, end_key).call(null, e)) ? s : cljs.core.next(s));
  } else {
    return null;
  }
};
cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;
cljs.core.RangeIterator = function(i, end, step) {
  this.i = i;
  this.end = end;
  this.step = step;
};
cljs.core.RangeIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__.step > 0) {
    return self__.i < self__.end;
  } else {
    return self__.i > self__.end;
  }
};
cljs.core.RangeIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.i;
  self__.i = self__.i + self__.step;
  return ret;
};
cljs.core.RangeIterator.cljs$lang$type = true;
cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";
cljs.core.RangeIterator.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/RangeIterator");
};
cljs.core.__GT_RangeIterator = function cljs$core$__GT_RangeIterator(i, end, step) {
  return new cljs.core.RangeIterator(i, end, step);
};
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375006;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Range.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Range.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var self__ = this;
  var rng__$1 = this;
  if (n < cljs.core._count(rng__$1)) {
    return self__.start + n * self__.step;
  } else {
    if (self__.start > self__.end && self__.step === 0) {
      return self__.start;
    } else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var self__ = this;
  var rng__$1 = this;
  if (n < cljs.core._count(rng__$1)) {
    return self__.start + n * self__.step;
  } else {
    if (self__.start > self__.end && self__.step === 0) {
      return self__.start;
    } else {
      return not_found;
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIterable$ = true;
cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RangeIterator(self__.start, self__.end, self__.step);
};
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  return self__.meta;
};
cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Range(self__.meta, self__.start, self__.end, self__.step, self__.__hash);
};
cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (self__.step > 0) {
    if (self__.start + self__.step < self__.end) {
      return new cljs.core.Range(self__.meta, self__.start + self__.step, self__.end, self__.step, null);
    } else {
      return null;
    }
  } else {
    if (self__.start + self__.step > self__.end) {
      return new cljs.core.Range(self__.meta, self__.start + self__.step, self__.end, self__.step, null);
    } else {
      return null;
    }
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (cljs.core.not(cljs.core._seq(rng__$1))) {
    return 0;
  } else {
    var G__18805 = (self__.end - self__.start) / self__.step;
    return Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__18805) : Math.ceil.call(null, G__18805);
  }
};
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  var h__4692__auto__ = self__.__hash;
  if (!(h__4692__auto__ == null)) {
    return h__4692__auto__;
  } else {
    var h__4692__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
    self__.__hash = h__4692__auto____$1;
    return h__4692__auto____$1;
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.equiv_sequential(rng__$1, other);
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1, f);
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, init) {
  var self__ = this;
  var rng__$1 = this;
  var i = self__.start;
  var ret = init;
  while (true) {
    if (self__.step > 0 ? i < self__.end : i > self__.end) {
      var ret__$1 = function() {
        var G__18806 = ret;
        var G__18807 = i;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18806, G__18807) : f.call(null, G__18806, G__18807);
      }();
      if (cljs.core.reduced_QMARK_(ret__$1)) {
        var G__18808 = ret__$1;
        return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18808) : cljs.core.deref.call(null, G__18808);
      } else {
        var G__18809 = i + self__.step;
        var G__18810 = ret__$1;
        i = G__18809;
        ret = G__18810;
        continue;
      }
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (cljs.core._seq(rng__$1) == null) {
    return null;
  } else {
    return self__.start;
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (!(cljs.core._seq(rng__$1) == null)) {
    return new cljs.core.Range(self__.meta, self__.start + self__.step, self__.end, self__.step, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var self__ = this;
  var rng__$1 = this;
  if (self__.step > 0) {
    if (self__.start < self__.end) {
      return rng__$1;
    } else {
      return null;
    }
  } else {
    if (self__.start > self__.end) {
      return rng__$1;
    } else {
      return null;
    }
  }
};
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta__$1) {
  var self__ = this;
  var rng__$1 = this;
  return new cljs.core.Range(meta__$1, self__.start, self__.end, self__.step, self__.__hash);
};
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var self__ = this;
  var rng__$1 = this;
  return cljs.core.cons(o, rng__$1);
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";
cljs.core.Range.cljs$lang$ctorPrWriter = function(this__4855__auto__, writer__4856__auto__, opt__4857__auto__) {
  return cljs.core._write(writer__4856__auto__, "cljs.core/Range");
};
cljs.core.__GT_Range = function cljs$core$__GT_Range(meta, start, end, step, __hash) {
  return new cljs.core.Range(meta, start, end, step, __hash);
};
cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = function() {
  var this__5252__auto__ = this;
  return cljs.core.es6_iterator(this__5252__auto__);
};
cljs.core.range = function cljs$core$range() {
  var G__18812 = arguments.length;
  switch(G__18812) {
    case 0:
      return cljs.core.range.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.range.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.range.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.range.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.range.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.range.cljs$core$IFn$_invoke$arity$3(0, Number.MAX_VALUE, 1);
};
cljs.core.range.cljs$core$IFn$_invoke$arity$1 = function(end) {
  return cljs.core.range.cljs$core$IFn$_invoke$arity$3(0, end, 1);
};
cljs.core.range.cljs$core$IFn$_invoke$arity$2 = function(start, end) {
  return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start, end, 1);
};
cljs.core.range.cljs$core$IFn$_invoke$arity$3 = function(start, end, step) {
  return new cljs.core.Range(null, start, end, step, null);
};
cljs.core.range.cljs$lang$maxFixedArity = 3;
cljs.core.take_nth = function cljs$core$take_nth() {
  var G__18815 = arguments.length;
  switch(G__18815) {
    case 1:
      return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1 = function(n) {
  return function(rf) {
    var ia = cljs.core.volatile_BANG_(-1);
    return function(ia) {
      return function() {
        var G__18820 = null;
        var G__18820__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__18820__1 = function(result) {
          var G__18816 = result;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18816) : rf.call(null, G__18816);
        };
        var G__18820__2 = function(result, input) {
          var i = cljs.core._vreset_BANG_(ia, cljs.core._deref(ia) + 1);
          if (cljs.core.rem(i, n) === 0) {
            var G__18817 = result;
            var G__18818 = input;
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18817, G__18818) : rf.call(null, G__18817, G__18818);
          } else {
            return result;
          }
        };
        G__18820 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__18820__0.call(this);
            case 1:
              return G__18820__1.call(this, result);
            case 2:
              return G__18820__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__18820.cljs$core$IFn$_invoke$arity$0 = G__18820__0;
        G__18820.cljs$core$IFn$_invoke$arity$1 = G__18820__1;
        G__18820.cljs$core$IFn$_invoke$arity$2 = G__18820__2;
        return G__18820;
      }();
    }(ia);
  };
};
cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4126__auto__ = cljs.core.seq(coll);
    if (temp__4126__auto__) {
      var s = temp__4126__auto__;
      return cljs.core.cons(cljs.core.first(s), cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(n, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, s)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take_nth.cljs$lang$maxFixedArity = 2;
cljs.core.split_with = function cljs$core$split_with(pred, coll) {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred, coll), cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred, coll)], null);
};
cljs.core.partition_by = function cljs$core$partition_by() {
  var G__18823 = arguments.length;
  switch(G__18823) {
    case 1:
      return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var a = cljs.core.array_list();
    var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core", "none", "cljs.core/none", 926646439));
    return function(a, pa) {
      return function() {
        var G__18834 = null;
        var G__18834__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__18834__1 = function(result) {
          var result__$1 = cljs.core.truth_(a.isEmpty()) ? result : function() {
            var v = cljs.core.vec(a.toArray());
            a.clear();
            return cljs.core.unreduced(function() {
              var G__18824 = result;
              var G__18825 = v;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18824, G__18825) : rf.call(null, G__18824, G__18825);
            }());
          }();
          var G__18826 = result__$1;
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__18826) : rf.call(null, G__18826);
        };
        var G__18834__2 = function(result, input) {
          var pval = function() {
            var G__18827 = pa;
            return cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__18827) : cljs.core.deref.call(null, G__18827);
          }();
          var val = function() {
            var G__18828 = input;
            return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18828) : f.call(null, G__18828);
          }();
          cljs.core.vreset_BANG_(pa, val);
          if (cljs.core.keyword_identical_QMARK_(pval, new cljs.core.Keyword("cljs.core", "none", "cljs.core/none", 926646439)) || cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val, pval)) {
            a.add(input);
            return result;
          } else {
            var v = cljs.core.vec(a.toArray());
            a.clear();
            var ret = function() {
              var G__18829 = result;
              var G__18830 = v;
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__18829, G__18830) : rf.call(null, G__18829, G__18830);
            }();
            if (cljs.core.reduced_QMARK_(ret)) {
            } else {
              a.add(input);
            }
            return ret;
          }
        };
        G__18834 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__18834__0.call(this);
            case 1:
              return G__18834__1.call(this, result);
            case 2:
              return G__18834__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + arguments.length);
        };
        G__18834.cljs$core$IFn$_invoke$arity$0 = G__18834__0;
        G__18834.cljs$core$IFn$_invoke$arity$1 = G__18834__1;
        G__18834.cljs$core$IFn$_invoke$arity$2 = G__18834__2;
        return G__18834;
      }();
    }(a, pa);
  };
};
cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4126__auto__ = cljs.core.seq(coll);
    if (temp__4126__auto__) {
      var s = temp__4126__auto__;
      var fst = cljs.core.first(s);
      var fv = function() {
        var G__18831 = fst;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18831) : f.call(null, G__18831);
      }();
      var run = cljs.core.cons(fst, cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(function(fst, fv, s, temp__4126__auto__) {
        return function(p1__18821_SHARP_) {
          return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv, function() {
            var G__18832 = p1__18821_SHARP_;
            return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18832) : f.call(null, G__18832);
          }());
        };
      }(fst, fv, s, temp__4126__auto__), cljs.core.next(s)));
      return cljs.core.cons(run, cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(f, cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run), s))));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition_by.cljs$lang$maxFixedArity = 2;
cljs.core.frequencies = function cljs$core$frequencies(coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(counts, x) {
    return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts, x, cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts, x, 0) + 1);
  }, cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY), coll));
};
cljs.core.reductions = function cljs$core$reductions() {
  var G__18836 = arguments.length;
  switch(G__18836) {
    case 2:
      return cljs.core.reductions.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error([cljs.core.str("Invalid arity: "), cljs.core.str(arguments.length)].join(""));;
  }
};
cljs.core.reductions.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__4124__auto__ = cljs.core.seq(coll);
    if (temp__4124__auto__) {
      var s = temp__4124__auto__;
      return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f, cljs.core.first(s), cljs.core.rest(s));
    } else {
      return cljs.core._conj(cljs.core.List.EMPTY, function() {
        return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
      }());
    }
  }, null, null);
};
cljs.core.reductions.cljs$core$IFn$_invoke$arity$3 = function(f, init, coll) {
  return cljs.core.cons(init, new cljs.core.LazySeq(null, function() {
    var temp__4126__auto__ = cljs.core.seq(coll);
    if (temp__4126__auto__) {
      var s = temp__4126__auto__;
      return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f, function() {
        var G__18837 = init;
        var G__18838 = cljs.core.first(s);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18837, G__18838) : f.call(null, G__18837, G__18838);
      }(), cljs.core.rest(s));
    } else {
      return null;
    }
  }, null, null));
};
cljs.core.reductions.cljs$lang$maxFixedArity = 3;
cljs.core.juxt = function cljs$core$juxt() {
  var G__18855 = arguments.length;
  switch(G__18855) {
    case 1:
      return cljs.core.juxt.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var argseq__5328__auto__ = new cljs.core.IndexedSeq(Array.prototype.slice.call(arguments, 3), 0);
      return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__5328__auto__);
  }
};
cljs.core.juxt.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function() {
    var G__18899 = null;
    var G__18899__0 = function() {
      return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
      }()], null);
    };
    var G__18899__1 = function(x) {
      return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        var G__18856 = x;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18856) : f.call(null, G__18856);
      }()], null);
    };
    var G__18899__2 = function(x, y) {
      return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        var G__18857 = x;
        var G__18858 = y;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18857, G__18858) : f.call(null, G__18857, G__18858);
      }()], null);
    };
    var G__18899__3 = function(x, y, z) {
      return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        var G__18859 = x;
        var G__18860 = y;
        var G__18861 = z;
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18859, G__18860, G__18861) : f.call(null, G__18859, G__18860, G__18861);
      }()], null);
    };
    var G__18899__4 = function() {
      var G__18900__delegate = function(x, y, z, args) {
        return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, x, y, z, args)], null);
      };
      var G__18900 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__18901__i = 0, G__18901__a = new Array(arguments.length - 3);
          while (G__18901__i < G__18901__a.length) {
            G__18901__a[G__18901__i] = arguments[G__18901__i + 3];
            ++G__18901__i;
          }
          args = new cljs.core.IndexedSeq(G__18901__a, 0);
        }
        return G__18900__delegate.call(this, x, y, z, args);
      };
      G__18900.cljs$lang$maxFixedArity = 3;
      G__18900.cljs$lang$applyTo = function(arglist__18902) {
        var x = cljs.core.first(arglist__18902);
        arglist__18902 = cljs.core.next(arglist__18902);
        var y = cljs.core.first(arglist__18902);
        arglist__18902 = cljs.core.next(arglist__18902);
        var z = cljs.core.first(arglist__18902);
        var args = cljs.core.rest(arglist__18902);
        return G__18900__delegate(x, y, z, args);
      };
      G__18900.cljs$core$IFn$_invoke$arity$variadic = G__18900__delegate;
      return G__18900;
    }();
    G__18899 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__18899__0.call(this);
        case 1:
          return G__18899__1.call(this, x);
        case 2:
          return G__18899__2.call(this, x, y);
        case 3:
          return G__18899__3.call(this, x, y, z);
        default:
          var G__18903 = null;
          if (arguments.length > 3) {
            var G__18904__i = 0, G__18904__a = new Array(arguments.length - 3);
            while (G__18904__i < G__18904__a.length) {
              G__18904__a[G__18904__i] = arguments[G__18904__i + 3];
              ++G__18904__i;
            }
            G__18903 = new cljs.core.IndexedSeq(G__18904__a, 0);
          }
          return G__18899__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__18903);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__18899.cljs$lang$maxFixedArity = 3;
    G__18899.cljs$lang$applyTo = G__18899__4.cljs$lang$applyTo;
    G__18899.cljs$core$IFn$_invoke$arity$0 = G__18899__0;
    G__18899.cljs$core$IFn$_invoke$arity$1 = G__18899__1;
    G__18899.cljs$core$IFn$_invoke$arity$2 = G__18899__2;
    G__18899.cljs$core$IFn$_invoke$arity$3 = G__18899__3;
    G__18899.cljs$core$IFn$_invoke$arity$variadic = G__18899__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__18899;
  }();
};
cljs.core.juxt.cljs$core$IFn$_invoke$arity$2 = function(f, g) {
  return function() {
    var G__18905 = null;
    var G__18905__0 = function() {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
      }(), function() {
        return g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null);
      }()], null);
    };
    var G__18905__1 = function(x) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        var G__18862 = x;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18862) : f.call(null, G__18862);
      }(), function() {
        var G__18863 = x;
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__18863) : g.call(null, G__18863);
      }()], null);
    };
    var G__18905__2 = function(x, y) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        var G__18864 = x;
        var G__18865 = y;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18864, G__18865) : f.call(null, G__18864, G__18865);
      }(), function() {
        var G__18866 = x;
        var G__18867 = y;
        return g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__18866, G__18867) : g.call(null, G__18866, G__18867);
      }()], null);
    };
    var G__18905__3 = function(x, y, z) {
      return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        var G__18868 = x;
        var G__18869 = y;
        var G__18870 = z;
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18868, G__18869, G__18870) : f.call(null, G__18868, G__18869, G__18870);
      }(), function() {
        var G__18871 = x;
        var G__18872 = y;
        var G__18873 = z;
        return g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__18871, G__18872, G__18873) : g.call(null, G__18871, G__18872, G__18873);
      }()], null);
    };
    var G__18905__4 = function() {
      var G__18906__delegate = function(x, y, z, args) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, x, y, z, args), cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g, x, y, z, args)], null);
      };
      var G__18906 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__18907__i = 0, G__18907__a = new Array(arguments.length - 3);
          while (G__18907__i < G__18907__a.length) {
            G__18907__a[G__18907__i] = arguments[G__18907__i + 3];
            ++G__18907__i;
          }
          args = new cljs.core.IndexedSeq(G__18907__a, 0);
        }
        return G__18906__delegate.call(this, x, y, z, args);
      };
      G__18906.cljs$lang$maxFixedArity = 3;
      G__18906.cljs$lang$applyTo = function(arglist__18908) {
        var x = cljs.core.first(arglist__18908);
        arglist__18908 = cljs.core.next(arglist__18908);
        var y = cljs.core.first(arglist__18908);
        arglist__18908 = cljs.core.next(arglist__18908);
        var z = cljs.core.first(arglist__18908);
        var args = cljs.core.rest(arglist__18908);
        return G__18906__delegate(x, y, z, args);
      };
      G__18906.cljs$core$IFn$_invoke$arity$variadic = G__18906__delegate;
      return G__18906;
    }();
    G__18905 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__18905__0.call(this);
        case 1:
          return G__18905__1.call(this, x);
        case 2:
          return G__18905__2.call(this, x, y);
        case 3:
          return G__18905__3.call(this, x, y, z);
        default:
          var G__18909 = null;
          if (arguments.length > 3) {
            var G__18910__i = 0, G__18910__a = new Array(arguments.length - 3);
            while (G__18910__i < G__18910__a.length) {
              G__18910__a[G__18910__i] = arguments[G__18910__i + 3];
              ++G__18910__i;
            }
            G__18909 = new cljs.core.IndexedSeq(G__18910__a, 0);
          }
          return G__18905__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__18909);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__18905.cljs$lang$maxFixedArity = 3;
    G__18905.cljs$lang$applyTo = G__18905__4.cljs$lang$applyTo;
    G__18905.cljs$core$IFn$_invoke$arity$0 = G__18905__0;
    G__18905.cljs$core$IFn$_invoke$arity$1 = G__18905__1;
    G__18905.cljs$core$IFn$_invoke$arity$2 = G__18905__2;
    G__18905.cljs$core$IFn$_invoke$arity$3 = G__18905__3;
    G__18905.cljs$core$IFn$_invoke$arity$variadic = G__18905__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__18905;
  }();
};
cljs.core.juxt.cljs$core$IFn$_invoke$arity$3 = function(f, g, h) {
  return function() {
    var G__18911 = null;
    var G__18911__0 = function() {
      return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
      }(), function() {
        return g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null);
      }(), function() {
        return h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null);
      }()], null);
    };
    var G__18911__1 = function(x) {
      return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        var G__18874 = x;
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__18874) : f.call(null, G__18874);
      }(), function() {
        var G__18875 = x;
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__18875) : g.call(null, G__18875);
      }(), function() {
        var G__18876 = x;
        return h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__18876) : h.call(null, G__18876);
      }()], null);
    };
    var G__18911__2 = function(x, y) {
      return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        var G__18877 = x;
        var G__18878 = y;
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__18877, G__18878) : f.call(null, G__18877, G__18878);
      }(), function() {
        var G__18879 = x;
        var G__18880 = y;
        return g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__18879, G__18880) : g.call(null, G__18879, G__18880);
      }(), function() {
        var G__18881 = x;
        var G__18882 = y;
        return h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__18881, G__18882) : h.call(null, G__18881, G__18882);
      }()], null);
    };
    var G__18911__3 = function(x, y, z) {
      return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [function() {
        var G__18883 = x;
        var G__18884 = y;
        var G__18885 = z;
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__18883, G__18884, G__18885) : f.call(null, G__18883, G__18884, G__18885);
      }(), function() {
        var G__18886 = x;
        var G__18887 = y;
        var G__18888 = z;
        return g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__18886, G__18887, G__18888) : g.call(null, G__18886, G__18887, G__18888);
      }(), function() {
        var G__18889 = x;
        var G__18890 = y;
        var G__18891 = z;
        return h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__18889, G__18890, G__18891) : h.call(null, G__18889, G__18890, G__18891);
      }()], null);
    };
    var G__18911__4 = function() {
      var G__18912__delegate = function(x, y, z, args) {
        return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, x, y, z, args), cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g, x, y, z, args), cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h, x, y, z, args)], null);
      };
      var G__18912 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__18913__i = 0, G__18913__a = new Array(arguments.length - 3);
          while (G__18913__i < G__18913__a.length) {
            G__18913__a[G__18913__i] = arguments[G__18913__i + 3];
            ++G__18913__i;
          }
          args = new cljs.core.IndexedSeq(G__18913__a, 0);
        }
        return G__18912__delegate.call(this, x, y, z, args);
      };
      G__18912.cljs$lang$maxFixedArity = 3;
      G__18912.cljs$lang$applyTo = function(arglist__18914) {
        var x = cljs.core.first(arglist__18914);
        arglist__18914 = cljs.core.next(arglist__18914);
        var y = cljs.core.first(arglist__18914);
        arglist__18914 = cljs.core.next(arglist__18914);
        var z = cljs.core.first(arglist__18914);
        var args = cljs.core.rest(arglist__18914);
        return G__18912__delegate(x, y, z, args);
      };
      G__18912.cljs$core$IFn$_invoke$arity$variadic = G__18912__delegate;
      return G__18912;
    }();
    G__18911 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__18911__0.call(this);
        case 1:
          return G__18911__1.call(this, x);
        case 2:
          return G__18911__2.call(this, x, y);
        case 3:
          return G__18911__3.call(this, x, y, z);
        default:
          var G__18915 = null;
          if (arguments.length > 3) {
            var G__18916__i = 0, G__18916__a = new Array(arguments.length - 3);
            while (G__18916__i < G__18916__a.length) {
              G__18916__a[G__18916__i] = arguments[G__18916__i + 3];
              ++G__18916__i;
            }
            G__18915 = new cljs.core.IndexedSeq(G__18916__a, 0);
          }
          return G__18911__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__18915);
      }
      throw new Error("Invalid arity: " + arguments.length);
    };
    G__18911.cljs$lang$maxFixedArity = 3;
    G__18911.cljs$lang$applyTo = G__18911__4.cljs$lang$applyTo;
    G__18911.cljs$core$IFn$_invoke$arity$0 = G__18911__0;
    G__18911.cljs$core$IFn$_invoke$arity$1 = G__18911__1;
    G__18911.cljs$core$IFn$_invoke$arity$2 = G__18911__2;
    G__18911.cljs$core$IFn$_invoke$arity$3 = G__18911__3;
    G__18911.cljs$core$IFn$_invoke$arity$variadic = G__18911__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__18911;
  }();
};
cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic = function(f, g, h, fs) {
  var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f, g, h, fs);
  return function(fs__$1) {
    return function() {
      var G__18917 = null;
      var G__18917__0 = function() {
        return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(fs__$1) {
          return function(p1__18840_SHARP_, p2__18841_SHARP_) {
            return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18840_SHARP_, function() {
              return p2__18841_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__18841_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__18841_SHARP_.call(null);
            }());
          };
        }(fs__$1), cljs.core.PersistentVector.EMPTY, fs__$1);
      };
      var G__18917__1 = function(x) {
        return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(fs__$1) {
          return function(p1__18842_SHARP_, p2__18843_SHARP_) {
            return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18842_SHARP_, function() {
              var G__18892 = x;
              return p2__18843_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__18843_SHARP_.cljs$core$IFn$_invoke$arity$1(G__18892) : p2__18843_SHARP_.call(null, G__18892);
            }());
          };
        }(fs__$1), cljs.core.PersistentVector.EMPTY, fs__$1);
      };
      var G__18917__2 = function(x, y) {
        return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(fs__$1) {
          return function(p1__18844_SHARP_, p2__18845_SHARP_) {
            return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18844_SHARP_, function() {
              var G__18893 = x;
              var G__18894 = y;
              return p2__18845_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__18845_SHARP_.cljs$core$IFn$_invoke$arity$2(G__18893, G__18894) : p2__18845_SHARP_.call(null, G__18893, G__18894);
            }());
          };
        }(fs__$1), cljs.core.PersistentVector.EMPTY, fs__$1);
      };
      var G__18917__3 = function(x, y, z) {
        return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(fs__$1) {
          return function(p1__18846_SHARP_, p2__18847_SHARP_) {
            return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18846_SHARP_, function() {
              var G__18895 = x;
              var G__18896 = y;
              var G__18897 = z;
              return p2__18847_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__18847_SHARP_.cljs$core$IFn$_invoke$arity$3(G__18895, G__18896, G__18897) : p2__18847_SHARP_.call(null, G__18895, G__18896, G__18897);
            }());
          };
        }(fs__$1), cljs.core.PersistentVector.EMPTY, fs__$1);
      };
      var G__18917__4 = function() {
        var G__18918__delegate = function(x, y, z, args) {
          return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(fs__$1) {
            return function(p1__18848_SHARP_, p2__18849_SHARP_) {
              return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18848_SHARP_, cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__18849_SHARP_, x, y, z, args));
            };
          }(fs__$1), cljs.core.PersistentVector.EMPTY, fs__$1);
        };
        var G__18918 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__18919__i = 0, G__18919__a = new Array(arguments.length - 3);
            while (G__18919__i < G__18919__a.length) {
              G__18919__a[G__18919__i] = arguments[G__18919__i + 3];
              ++G__18919__i;
            }
            args = new cljs.core.IndexedSeq(G__18919__a, 0);
          }
          return G__18918__delegate.call(this, x, y, z, args);
        };
        G__18918.cljs$lang$maxFixedArity = 3;
        G__18918.cljs$lang$applyTo = function(arglist__18920) {
          var x = cljs.core.first(arglist__18920);
          arglist__18920 = cljs.core.next(arglist__18920);
          var y = cljs.core.first(arglist__18920);
          arglist__18920 = cljs.core.next(arglist__18920);
          var z = cljs.core.first(arglist__18920);
          var args = cljs.core.rest(arglist__18920);
          return G__18918__delegate(x, y, z, args);
        };
        G__18918.cljs$core$IFn$_invoke$arity$variadic = G__18918__delegate;
        return G__18918;
      }();
      G__18917 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__18917__0.call(this);
          case 1:
            return G__18917__1.call(this, x);
          case 2:
            return G__18917__2.call(this, x, y);
          case 3:
            return G__18917__3.call(this, x, y, z);
          default:
            var G__18921 = null;
            if (arguments.length > 3) {
              var G__18922__i = 0, G__18922__a = new Array(arguments.length - 3);
              while (G__18922__i < G__18922__a.length) {
                G__18922__a[G__18922__i] = arguments[G__18922__i + 3];
                ++G__18922__i;
              }
              G__18921 = new cljs.core.IndexedSeq(G__18922__a, 0);
            }
            return G__18917__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__18921);
        }
        throw new Error("Invalid arity: " + arguments.length);
      };
      G__18917.cljs$lang$maxFixedArity = 3;
      G__18917.cljs$lang$applyTo = G__18917__4.cljs$lang$applyTo;
      G__18917.cljs$core$IFn$_invoke$arity$0 = G__18917__0;
      G__18917.cljs$core$IFn$_invoke$arity$1 = G__18917__1;
      G__18917.cljs$core$IFn$_invoke$arity$2 = G__18917__2;
      G__18917.cljs$core$IF