// Compiled by ClojureScript 1.9.229 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__11380__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__11377 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__11378 = cljs.core.seq.call(null,vec__11377);
var first__11379 = cljs.core.first.call(null,seq__11378);
var seq__11378__$1 = cljs.core.next.call(null,seq__11378);
var tag = first__11379;
var body = seq__11378__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__11380 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__11381__i = 0, G__11381__a = new Array(arguments.length -  0);
while (G__11381__i < G__11381__a.length) {G__11381__a[G__11381__i] = arguments[G__11381__i + 0]; ++G__11381__i;}
  args = new cljs.core.IndexedSeq(G__11381__a,0);
} 
return G__11380__delegate.call(this,args);};
G__11380.cljs$lang$maxFixedArity = 0;
G__11380.cljs$lang$applyTo = (function (arglist__11382){
var args = cljs.core.seq(arglist__11382);
return G__11380__delegate(args);
});
G__11380.cljs$core$IFn$_invoke$arity$variadic = G__11380__delegate;
return G__11380;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__11387(s__11388){
return (new cljs.core.LazySeq(null,(function (){
var s__11388__$1 = s__11388;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11388__$1);
if(temp__4657__auto__){
var s__11388__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11388__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__11388__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__11390 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__11389 = (0);
while(true){
if((i__11389 < size__7188__auto__)){
var args = cljs.core._nth.call(null,c__7187__auto__,i__11389);
cljs.core.chunk_append.call(null,b__11390,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__11391 = (i__11389 + (1));
i__11389 = G__11391;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11390),sablono$core$update_arglists_$_iter__11387.call(null,cljs.core.chunk_rest.call(null,s__11388__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11390),null);
}
} else {
var args = cljs.core.first.call(null,s__11388__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__11387.call(null,cljs.core.rest.call(null,s__11388__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___11397 = arguments.length;
var i__7485__auto___11398 = (0);
while(true){
if((i__7485__auto___11398 < len__7484__auto___11397)){
args__7491__auto__.push((arguments[i__7485__auto___11398]));

var G__11399 = (i__7485__auto___11398 + (1));
i__7485__auto___11398 = G__11399;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__11393(s__11394){
return (new cljs.core.LazySeq(null,(function (){
var s__11394__$1 = s__11394;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11394__$1);
if(temp__4657__auto__){
var s__11394__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11394__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__11394__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__11396 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__11395 = (0);
while(true){
if((i__11395 < size__7188__auto__)){
var style = cljs.core._nth.call(null,c__7187__auto__,i__11395);
cljs.core.chunk_append.call(null,b__11396,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__11400 = (i__11395 + (1));
i__11395 = G__11400;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11396),sablono$core$iter__11393.call(null,cljs.core.chunk_rest.call(null,s__11394__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11396),null);
}
} else {
var style = cljs.core.first.call(null,s__11394__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__11393.call(null,cljs.core.rest.call(null,s__11394__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq11392){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11392));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to11401 = (function sablono$core$link_to11401(var_args){
var args__7491__auto__ = [];
var len__7484__auto___11404 = arguments.length;
var i__7485__auto___11405 = (0);
while(true){
if((i__7485__auto___11405 < len__7484__auto___11404)){
args__7491__auto__.push((arguments[i__7485__auto___11405]));

var G__11406 = (i__7485__auto___11405 + (1));
i__7485__auto___11405 = G__11406;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to11401.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to11401.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to11401.cljs$lang$maxFixedArity = (1);

sablono.core.link_to11401.cljs$lang$applyTo = (function (seq11402){
var G__11403 = cljs.core.first.call(null,seq11402);
var seq11402__$1 = cljs.core.next.call(null,seq11402);
return sablono.core.link_to11401.cljs$core$IFn$_invoke$arity$variadic(G__11403,seq11402__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to11401);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to11407 = (function sablono$core$mail_to11407(var_args){
var args__7491__auto__ = [];
var len__7484__auto___11414 = arguments.length;
var i__7485__auto___11415 = (0);
while(true){
if((i__7485__auto___11415 < len__7484__auto___11414)){
args__7491__auto__.push((arguments[i__7485__auto___11415]));

var G__11416 = (i__7485__auto___11415 + (1));
i__7485__auto___11415 = G__11416;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to11407.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to11407.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__11410){
var vec__11411 = p__11410;
var content = cljs.core.nth.call(null,vec__11411,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to11407.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to11407.cljs$lang$applyTo = (function (seq11408){
var G__11409 = cljs.core.first.call(null,seq11408);
var seq11408__$1 = cljs.core.next.call(null,seq11408);
return sablono.core.mail_to11407.cljs$core$IFn$_invoke$arity$variadic(G__11409,seq11408__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to11407);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list11417 = (function sablono$core$unordered_list11417(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__7189__auto__ = (function sablono$core$unordered_list11417_$_iter__11422(s__11423){
return (new cljs.core.LazySeq(null,(function (){
var s__11423__$1 = s__11423;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11423__$1);
if(temp__4657__auto__){
var s__11423__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11423__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__11423__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__11425 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__11424 = (0);
while(true){
if((i__11424 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__11424);
cljs.core.chunk_append.call(null,b__11425,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__11426 = (i__11424 + (1));
i__11424 = G__11426;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11425),sablono$core$unordered_list11417_$_iter__11422.call(null,cljs.core.chunk_rest.call(null,s__11423__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11425),null);
}
} else {
var x = cljs.core.first.call(null,s__11423__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list11417_$_iter__11422.call(null,cljs.core.rest.call(null,s__11423__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list11417);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list11427 = (function sablono$core$ordered_list11427(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__7189__auto__ = (function sablono$core$ordered_list11427_$_iter__11432(s__11433){
return (new cljs.core.LazySeq(null,(function (){
var s__11433__$1 = s__11433;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11433__$1);
if(temp__4657__auto__){
var s__11433__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11433__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__11433__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__11435 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__11434 = (0);
while(true){
if((i__11434 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__11434);
cljs.core.chunk_append.call(null,b__11435,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__11436 = (i__11434 + (1));
i__11434 = G__11436;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11435),sablono$core$ordered_list11427_$_iter__11432.call(null,cljs.core.chunk_rest.call(null,s__11433__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11435),null);
}
} else {
var x = cljs.core.first.call(null,s__11433__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list11427_$_iter__11432.call(null,cljs.core.rest.call(null,s__11433__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list11427);
/**
 * Create an image element.
 */
sablono.core.image11437 = (function sablono$core$image11437(var_args){
var args11438 = [];
var len__7484__auto___11441 = arguments.length;
var i__7485__auto___11442 = (0);
while(true){
if((i__7485__auto___11442 < len__7484__auto___11441)){
args11438.push((arguments[i__7485__auto___11442]));

var G__11443 = (i__7485__auto___11442 + (1));
i__7485__auto___11442 = G__11443;
continue;
} else {
}
break;
}

var G__11440 = args11438.length;
switch (G__11440) {
case 1:
return sablono.core.image11437.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image11437.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11438.length)].join('')));

}
});

sablono.core.image11437.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image11437.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image11437.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image11437);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__11445_SHARP_,p2__11446_SHARP_){
return [cljs.core.str(p1__11445_SHARP_),cljs.core.str("["),cljs.core.str(p2__11446_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__11447_SHARP_,p2__11448_SHARP_){
return [cljs.core.str(p1__11447_SHARP_),cljs.core.str("-"),cljs.core.str(p2__11448_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field11449 = (function sablono$core$color_field11449(var_args){
var args11450 = [];
var len__7484__auto___11517 = arguments.length;
var i__7485__auto___11518 = (0);
while(true){
if((i__7485__auto___11518 < len__7484__auto___11517)){
args11450.push((arguments[i__7485__auto___11518]));

var G__11519 = (i__7485__auto___11518 + (1));
i__7485__auto___11518 = G__11519;
continue;
} else {
}
break;
}

var G__11452 = args11450.length;
switch (G__11452) {
case 1:
return sablono.core.color_field11449.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field11449.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11450.length)].join('')));

}
});

sablono.core.color_field11449.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.color_field11449.call(null,name__11294__auto__,null);
});

sablono.core.color_field11449.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.color_field11449.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field11449);

/**
 * Creates a date input field.
 */
sablono.core.date_field11453 = (function sablono$core$date_field11453(var_args){
var args11454 = [];
var len__7484__auto___11521 = arguments.length;
var i__7485__auto___11522 = (0);
while(true){
if((i__7485__auto___11522 < len__7484__auto___11521)){
args11454.push((arguments[i__7485__auto___11522]));

var G__11523 = (i__7485__auto___11522 + (1));
i__7485__auto___11522 = G__11523;
continue;
} else {
}
break;
}

var G__11456 = args11454.length;
switch (G__11456) {
case 1:
return sablono.core.date_field11453.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field11453.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11454.length)].join('')));

}
});

sablono.core.date_field11453.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.date_field11453.call(null,name__11294__auto__,null);
});

sablono.core.date_field11453.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.date_field11453.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field11453);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field11457 = (function sablono$core$datetime_field11457(var_args){
var args11458 = [];
var len__7484__auto___11525 = arguments.length;
var i__7485__auto___11526 = (0);
while(true){
if((i__7485__auto___11526 < len__7484__auto___11525)){
args11458.push((arguments[i__7485__auto___11526]));

var G__11527 = (i__7485__auto___11526 + (1));
i__7485__auto___11526 = G__11527;
continue;
} else {
}
break;
}

var G__11460 = args11458.length;
switch (G__11460) {
case 1:
return sablono.core.datetime_field11457.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field11457.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11458.length)].join('')));

}
});

sablono.core.datetime_field11457.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.datetime_field11457.call(null,name__11294__auto__,null);
});

sablono.core.datetime_field11457.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.datetime_field11457.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field11457);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field11461 = (function sablono$core$datetime_local_field11461(var_args){
var args11462 = [];
var len__7484__auto___11529 = arguments.length;
var i__7485__auto___11530 = (0);
while(true){
if((i__7485__auto___11530 < len__7484__auto___11529)){
args11462.push((arguments[i__7485__auto___11530]));

var G__11531 = (i__7485__auto___11530 + (1));
i__7485__auto___11530 = G__11531;
continue;
} else {
}
break;
}

var G__11464 = args11462.length;
switch (G__11464) {
case 1:
return sablono.core.datetime_local_field11461.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field11461.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11462.length)].join('')));

}
});

sablono.core.datetime_local_field11461.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.datetime_local_field11461.call(null,name__11294__auto__,null);
});

sablono.core.datetime_local_field11461.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.datetime_local_field11461.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field11461);

/**
 * Creates a email input field.
 */
sablono.core.email_field11465 = (function sablono$core$email_field11465(var_args){
var args11466 = [];
var len__7484__auto___11533 = arguments.length;
var i__7485__auto___11534 = (0);
while(true){
if((i__7485__auto___11534 < len__7484__auto___11533)){
args11466.push((arguments[i__7485__auto___11534]));

var G__11535 = (i__7485__auto___11534 + (1));
i__7485__auto___11534 = G__11535;
continue;
} else {
}
break;
}

var G__11468 = args11466.length;
switch (G__11468) {
case 1:
return sablono.core.email_field11465.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field11465.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11466.length)].join('')));

}
});

sablono.core.email_field11465.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.email_field11465.call(null,name__11294__auto__,null);
});

sablono.core.email_field11465.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.email_field11465.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field11465);

/**
 * Creates a file input field.
 */
sablono.core.file_field11469 = (function sablono$core$file_field11469(var_args){
var args11470 = [];
var len__7484__auto___11537 = arguments.length;
var i__7485__auto___11538 = (0);
while(true){
if((i__7485__auto___11538 < len__7484__auto___11537)){
args11470.push((arguments[i__7485__auto___11538]));

var G__11539 = (i__7485__auto___11538 + (1));
i__7485__auto___11538 = G__11539;
continue;
} else {
}
break;
}

var G__11472 = args11470.length;
switch (G__11472) {
case 1:
return sablono.core.file_field11469.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field11469.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11470.length)].join('')));

}
});

sablono.core.file_field11469.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.file_field11469.call(null,name__11294__auto__,null);
});

sablono.core.file_field11469.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.file_field11469.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field11469);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field11473 = (function sablono$core$hidden_field11473(var_args){
var args11474 = [];
var len__7484__auto___11541 = arguments.length;
var i__7485__auto___11542 = (0);
while(true){
if((i__7485__auto___11542 < len__7484__auto___11541)){
args11474.push((arguments[i__7485__auto___11542]));

var G__11543 = (i__7485__auto___11542 + (1));
i__7485__auto___11542 = G__11543;
continue;
} else {
}
break;
}

var G__11476 = args11474.length;
switch (G__11476) {
case 1:
return sablono.core.hidden_field11473.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field11473.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11474.length)].join('')));

}
});

sablono.core.hidden_field11473.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.hidden_field11473.call(null,name__11294__auto__,null);
});

sablono.core.hidden_field11473.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.hidden_field11473.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field11473);

/**
 * Creates a month input field.
 */
sablono.core.month_field11477 = (function sablono$core$month_field11477(var_args){
var args11478 = [];
var len__7484__auto___11545 = arguments.length;
var i__7485__auto___11546 = (0);
while(true){
if((i__7485__auto___11546 < len__7484__auto___11545)){
args11478.push((arguments[i__7485__auto___11546]));

var G__11547 = (i__7485__auto___11546 + (1));
i__7485__auto___11546 = G__11547;
continue;
} else {
}
break;
}

var G__11480 = args11478.length;
switch (G__11480) {
case 1:
return sablono.core.month_field11477.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field11477.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11478.length)].join('')));

}
});

sablono.core.month_field11477.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.month_field11477.call(null,name__11294__auto__,null);
});

sablono.core.month_field11477.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.month_field11477.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field11477);

/**
 * Creates a number input field.
 */
sablono.core.number_field11481 = (function sablono$core$number_field11481(var_args){
var args11482 = [];
var len__7484__auto___11549 = arguments.length;
var i__7485__auto___11550 = (0);
while(true){
if((i__7485__auto___11550 < len__7484__auto___11549)){
args11482.push((arguments[i__7485__auto___11550]));

var G__11551 = (i__7485__auto___11550 + (1));
i__7485__auto___11550 = G__11551;
continue;
} else {
}
break;
}

var G__11484 = args11482.length;
switch (G__11484) {
case 1:
return sablono.core.number_field11481.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field11481.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11482.length)].join('')));

}
});

sablono.core.number_field11481.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.number_field11481.call(null,name__11294__auto__,null);
});

sablono.core.number_field11481.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.number_field11481.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field11481);

/**
 * Creates a password input field.
 */
sablono.core.password_field11485 = (function sablono$core$password_field11485(var_args){
var args11486 = [];
var len__7484__auto___11553 = arguments.length;
var i__7485__auto___11554 = (0);
while(true){
if((i__7485__auto___11554 < len__7484__auto___11553)){
args11486.push((arguments[i__7485__auto___11554]));

var G__11555 = (i__7485__auto___11554 + (1));
i__7485__auto___11554 = G__11555;
continue;
} else {
}
break;
}

var G__11488 = args11486.length;
switch (G__11488) {
case 1:
return sablono.core.password_field11485.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field11485.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11486.length)].join('')));

}
});

sablono.core.password_field11485.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.password_field11485.call(null,name__11294__auto__,null);
});

sablono.core.password_field11485.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.password_field11485.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field11485);

/**
 * Creates a range input field.
 */
sablono.core.range_field11489 = (function sablono$core$range_field11489(var_args){
var args11490 = [];
var len__7484__auto___11557 = arguments.length;
var i__7485__auto___11558 = (0);
while(true){
if((i__7485__auto___11558 < len__7484__auto___11557)){
args11490.push((arguments[i__7485__auto___11558]));

var G__11559 = (i__7485__auto___11558 + (1));
i__7485__auto___11558 = G__11559;
continue;
} else {
}
break;
}

var G__11492 = args11490.length;
switch (G__11492) {
case 1:
return sablono.core.range_field11489.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field11489.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11490.length)].join('')));

}
});

sablono.core.range_field11489.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.range_field11489.call(null,name__11294__auto__,null);
});

sablono.core.range_field11489.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.range_field11489.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field11489);

/**
 * Creates a search input field.
 */
sablono.core.search_field11493 = (function sablono$core$search_field11493(var_args){
var args11494 = [];
var len__7484__auto___11561 = arguments.length;
var i__7485__auto___11562 = (0);
while(true){
if((i__7485__auto___11562 < len__7484__auto___11561)){
args11494.push((arguments[i__7485__auto___11562]));

var G__11563 = (i__7485__auto___11562 + (1));
i__7485__auto___11562 = G__11563;
continue;
} else {
}
break;
}

var G__11496 = args11494.length;
switch (G__11496) {
case 1:
return sablono.core.search_field11493.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field11493.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11494.length)].join('')));

}
});

sablono.core.search_field11493.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.search_field11493.call(null,name__11294__auto__,null);
});

sablono.core.search_field11493.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.search_field11493.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field11493);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field11497 = (function sablono$core$tel_field11497(var_args){
var args11498 = [];
var len__7484__auto___11565 = arguments.length;
var i__7485__auto___11566 = (0);
while(true){
if((i__7485__auto___11566 < len__7484__auto___11565)){
args11498.push((arguments[i__7485__auto___11566]));

var G__11567 = (i__7485__auto___11566 + (1));
i__7485__auto___11566 = G__11567;
continue;
} else {
}
break;
}

var G__11500 = args11498.length;
switch (G__11500) {
case 1:
return sablono.core.tel_field11497.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field11497.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11498.length)].join('')));

}
});

sablono.core.tel_field11497.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.tel_field11497.call(null,name__11294__auto__,null);
});

sablono.core.tel_field11497.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.tel_field11497.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field11497);

/**
 * Creates a text input field.
 */
sablono.core.text_field11501 = (function sablono$core$text_field11501(var_args){
var args11502 = [];
var len__7484__auto___11569 = arguments.length;
var i__7485__auto___11570 = (0);
while(true){
if((i__7485__auto___11570 < len__7484__auto___11569)){
args11502.push((arguments[i__7485__auto___11570]));

var G__11571 = (i__7485__auto___11570 + (1));
i__7485__auto___11570 = G__11571;
continue;
} else {
}
break;
}

var G__11504 = args11502.length;
switch (G__11504) {
case 1:
return sablono.core.text_field11501.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field11501.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11502.length)].join('')));

}
});

sablono.core.text_field11501.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.text_field11501.call(null,name__11294__auto__,null);
});

sablono.core.text_field11501.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.text_field11501.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field11501);

/**
 * Creates a time input field.
 */
sablono.core.time_field11505 = (function sablono$core$time_field11505(var_args){
var args11506 = [];
var len__7484__auto___11573 = arguments.length;
var i__7485__auto___11574 = (0);
while(true){
if((i__7485__auto___11574 < len__7484__auto___11573)){
args11506.push((arguments[i__7485__auto___11574]));

var G__11575 = (i__7485__auto___11574 + (1));
i__7485__auto___11574 = G__11575;
continue;
} else {
}
break;
}

var G__11508 = args11506.length;
switch (G__11508) {
case 1:
return sablono.core.time_field11505.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field11505.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11506.length)].join('')));

}
});

sablono.core.time_field11505.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.time_field11505.call(null,name__11294__auto__,null);
});

sablono.core.time_field11505.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.time_field11505.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field11505);

/**
 * Creates a url input field.
 */
sablono.core.url_field11509 = (function sablono$core$url_field11509(var_args){
var args11510 = [];
var len__7484__auto___11577 = arguments.length;
var i__7485__auto___11578 = (0);
while(true){
if((i__7485__auto___11578 < len__7484__auto___11577)){
args11510.push((arguments[i__7485__auto___11578]));

var G__11579 = (i__7485__auto___11578 + (1));
i__7485__auto___11578 = G__11579;
continue;
} else {
}
break;
}

var G__11512 = args11510.length;
switch (G__11512) {
case 1:
return sablono.core.url_field11509.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field11509.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11510.length)].join('')));

}
});

sablono.core.url_field11509.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.url_field11509.call(null,name__11294__auto__,null);
});

sablono.core.url_field11509.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.url_field11509.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field11509);

/**
 * Creates a week input field.
 */
sablono.core.week_field11513 = (function sablono$core$week_field11513(var_args){
var args11514 = [];
var len__7484__auto___11581 = arguments.length;
var i__7485__auto___11582 = (0);
while(true){
if((i__7485__auto___11582 < len__7484__auto___11581)){
args11514.push((arguments[i__7485__auto___11582]));

var G__11583 = (i__7485__auto___11582 + (1));
i__7485__auto___11582 = G__11583;
continue;
} else {
}
break;
}

var G__11516 = args11514.length;
switch (G__11516) {
case 1:
return sablono.core.week_field11513.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field11513.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11514.length)].join('')));

}
});

sablono.core.week_field11513.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.week_field11513.call(null,name__11294__auto__,null);
});

sablono.core.week_field11513.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.week_field11513.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field11513);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box11585 = (function sablono$core$check_box11585(var_args){
var args11586 = [];
var len__7484__auto___11589 = arguments.length;
var i__7485__auto___11590 = (0);
while(true){
if((i__7485__auto___11590 < len__7484__auto___11589)){
args11586.push((arguments[i__7485__auto___11590]));

var G__11591 = (i__7485__auto___11590 + (1));
i__7485__auto___11590 = G__11591;
continue;
} else {
}
break;
}

var G__11588 = args11586.length;
switch (G__11588) {
case 1:
return sablono.core.check_box11585.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box11585.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box11585.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11586.length)].join('')));

}
});

sablono.core.check_box11585.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box11585.call(null,name,null);
});

sablono.core.check_box11585.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box11585.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box11585.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box11585.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box11585);
/**
 * Creates a radio button.
 */
sablono.core.radio_button11593 = (function sablono$core$radio_button11593(var_args){
var args11594 = [];
var len__7484__auto___11597 = arguments.length;
var i__7485__auto___11598 = (0);
while(true){
if((i__7485__auto___11598 < len__7484__auto___11597)){
args11594.push((arguments[i__7485__auto___11598]));

var G__11599 = (i__7485__auto___11598 + (1));
i__7485__auto___11598 = G__11599;
continue;
} else {
}
break;
}

var G__11596 = args11594.length;
switch (G__11596) {
case 1:
return sablono.core.radio_button11593.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button11593.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button11593.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11594.length)].join('')));

}
});

sablono.core.radio_button11593.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button11593.call(null,group,null);
});

sablono.core.radio_button11593.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button11593.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button11593.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button11593.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button11593);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options11601 = (function sablono$core$select_options11601(var_args){
var args11602 = [];
var len__7484__auto___11621 = arguments.length;
var i__7485__auto___11622 = (0);
while(true){
if((i__7485__auto___11622 < len__7484__auto___11621)){
args11602.push((arguments[i__7485__auto___11622]));

var G__11623 = (i__7485__auto___11622 + (1));
i__7485__auto___11622 = G__11623;
continue;
} else {
}
break;
}

var G__11604 = args11602.length;
switch (G__11604) {
case 1:
return sablono.core.select_options11601.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options11601.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11602.length)].join('')));

}
});

sablono.core.select_options11601.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options11601.call(null,coll,null);
});

sablono.core.select_options11601.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__11605(s__11606){
return (new cljs.core.LazySeq(null,(function (){
var s__11606__$1 = s__11606;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11606__$1);
if(temp__4657__auto__){
var s__11606__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11606__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__11606__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__11608 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__11607 = (0);
while(true){
if((i__11607 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__11607);
cljs.core.chunk_append.call(null,b__11608,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__11615 = x;
var text = cljs.core.nth.call(null,vec__11615,(0),null);
var val = cljs.core.nth.call(null,vec__11615,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__11615,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options11601.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__11625 = (i__11607 + (1));
i__11607 = G__11625;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11608),sablono$core$iter__11605.call(null,cljs.core.chunk_rest.call(null,s__11606__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11608),null);
}
} else {
var x = cljs.core.first.call(null,s__11606__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__11618 = x;
var text = cljs.core.nth.call(null,vec__11618,(0),null);
var val = cljs.core.nth.call(null,vec__11618,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__11618,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options11601.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__11605.call(null,cljs.core.rest.call(null,s__11606__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
});

sablono.core.select_options11601.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options11601);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down11626 = (function sablono$core$drop_down11626(var_args){
var args11627 = [];
var len__7484__auto___11630 = arguments.length;
var i__7485__auto___11631 = (0);
while(true){
if((i__7485__auto___11631 < len__7484__auto___11630)){
args11627.push((arguments[i__7485__auto___11631]));

var G__11632 = (i__7485__auto___11631 + (1));
i__7485__auto___11631 = G__11632;
continue;
} else {
}
break;
}

var G__11629 = args11627.length;
switch (G__11629) {
case 2:
return sablono.core.drop_down11626.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down11626.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11627.length)].join('')));

}
});

sablono.core.drop_down11626.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down11626.call(null,name,options,null);
});

sablono.core.drop_down11626.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down11626.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down11626);
/**
 * Creates a text area element.
 */
sablono.core.text_area11634 = (function sablono$core$text_area11634(var_args){
var args11635 = [];
var len__7484__auto___11638 = arguments.length;
var i__7485__auto___11639 = (0);
while(true){
if((i__7485__auto___11639 < len__7484__auto___11638)){
args11635.push((arguments[i__7485__auto___11639]));

var G__11640 = (i__7485__auto___11639 + (1));
i__7485__auto___11639 = G__11640;
continue;
} else {
}
break;
}

var G__11637 = args11635.length;
switch (G__11637) {
case 1:
return sablono.core.text_area11634.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area11634.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args11635.length)].join('')));

}
});

sablono.core.text_area11634.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area11634.call(null,name,null);
});

sablono.core.text_area11634.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area11634.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area11634);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label11642 = (function sablono$core$label11642(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label11642);
/**
 * Creates a submit button.
 */
sablono.core.submit_button11643 = (function sablono$core$submit_button11643(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button11643);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button11644 = (function sablono$core$reset_button11644(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button11644);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to11645 = (function sablono$core$form_to11645(var_args){
var args__7491__auto__ = [];
var len__7484__auto___11652 = arguments.length;
var i__7485__auto___11653 = (0);
while(true){
if((i__7485__auto___11653 < len__7484__auto___11652)){
args__7491__auto__.push((arguments[i__7485__auto___11653]));

var G__11654 = (i__7485__auto___11653 + (1));
i__7485__auto___11653 = G__11654;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to11645.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to11645.cljs$core$IFn$_invoke$arity$variadic = (function (p__11648,body){
var vec__11649 = p__11648;
var method = cljs.core.nth.call(null,vec__11649,(0),null);
var action = cljs.core.nth.call(null,vec__11649,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to11645.cljs$lang$maxFixedArity = (1);

sablono.core.form_to11645.cljs$lang$applyTo = (function (seq11646){
var G__11647 = cljs.core.first.call(null,seq11646);
var seq11646__$1 = cljs.core.next.call(null,seq11646);
return sablono.core.form_to11645.cljs$core$IFn$_invoke$arity$variadic(G__11647,seq11646__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to11645);
