// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.layout.histogram');
goog.require('cljs.core');
goog.require('c2.maths');
c2.layout.histogram.binary_search = (function c2$layout$histogram$binary_search(v,target){

var low = (0);
var high = (cljs.core.count.call(null,v) - (1));
while(true){
if((low > high)){
return (- (low + (1)));
} else {
var mid = cljs.core.quot.call(null,(low + high),(2));
var mid_val = v.call(null,mid);
if((mid_val < target)){
var G__20795 = (mid + (1));
var G__20796 = high;
low = G__20795;
high = G__20796;
continue;
} else {
if((target < mid_val)){
var G__20797 = low;
var G__20798 = (mid - (1));
low = G__20797;
high = G__20798;
continue;
} else {
return mid;

}
}
}
break;
}
});
/**
 * Calulate reasonable number of bins assuming an approximately normal
 *   distribution
 */
c2.layout.histogram.sturges = (function c2$layout$histogram$sturges(values){
return ((c2.maths.log.call(null,cljs.core.count.call(null,values),(2)) | (0)) + (1));
});
/**
 * Return the inclusive upper threshold of all bins
 */
c2.layout.histogram.fixed_size_bins = (function c2$layout$histogram$fixed_size_bins(p__20799,n){
var vec__20807 = p__20799;
var mn = cljs.core.nth.call(null,vec__20807,(0),null);
var mx = cljs.core.nth.call(null,vec__20807,(1),null);
var size = ((mx - mn) / n);
return cljs.core.vec.call(null,(function (){var iter__7189__auto__ = ((function (size,vec__20807,mn,mx){
return (function c2$layout$histogram$fixed_size_bins_$_iter__20810(s__20811){
return (new cljs.core.LazySeq(null,((function (size,vec__20807,mn,mx){
return (function (){
var s__20811__$1 = s__20811;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20811__$1);
if(temp__4657__auto__){
var s__20811__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20811__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20811__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20813 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20812 = (0);
while(true){
if((i__20812 < size__7188__auto__)){
var step = cljs.core._nth.call(null,c__7187__auto__,i__20812);
cljs.core.chunk_append.call(null,b__20813,(mn + (size * step)));

var G__20814 = (i__20812 + (1));
i__20812 = G__20814;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20813),c2$layout$histogram$fixed_size_bins_$_iter__20810.call(null,cljs.core.chunk_rest.call(null,s__20811__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20813),null);
}
} else {
var step = cljs.core.first.call(null,s__20811__$2);
return cljs.core.cons.call(null,(mn + (size * step)),c2$layout$histogram$fixed_size_bins_$_iter__20810.call(null,cljs.core.rest.call(null,s__20811__$2)));
}
} else {
return null;
}
break;
}
});})(size,vec__20807,mn,mx))
,null,null));
});})(size,vec__20807,mn,mx))
;
return iter__7189__auto__.call(null,cljs.core.range.call(null,(n + (1))));
})());
});
/**
 * The histogram layout transforms data by grouping descrete data points into
 *   bins. Returns a collection of values with the following metadata set:
 * 
 *   > *:x* the lower bound of the bin (inclusive).
 * 
 *   > *:dx* the width of the bin; x + dx is the upper bound (exclusive).
 * 
 *   > *:y* the count
 * 
 * Kwargs:
 * 
 * > *:value* fn that calculates value of node, defaults to `:value`
 * 
 * > *:index* opaque value passed to `:bins` and `:range`
 * 
 * > *:range* fn which calculates the minimum and maximum values given the array of values
 * 
 * > *:bins* Number of bins /or/ fn that takes the range, array of values, and current index
 */
c2.layout.histogram.histogram = (function c2$layout$histogram$histogram(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20824 = arguments.length;
var i__7485__auto___20825 = (0);
while(true){
if((i__7485__auto___20825 < len__7484__auto___20824)){
args__7491__auto__.push((arguments[i__7485__auto___20825]));

var G__20826 = (i__7485__auto___20825 + (1));
i__7485__auto___20825 = G__20826;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic = (function (data,p__20817){
var map__20818 = p__20817;
var map__20818__$1 = ((((!((map__20818 == null)))?((((map__20818.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20818.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20818):map__20818);
var value = cljs.core.get.call(null,map__20818__$1,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217));
var index = cljs.core.get.call(null,map__20818__$1,new cljs.core.Keyword(null,"index","index",-1531685915));
var range = cljs.core.get.call(null,map__20818__$1,new cljs.core.Keyword(null,"range","range",1639692286),((function (map__20818,map__20818__$1,value,index){
return (function (xs,_){
return cljs.core.juxt.call(null,cljs.core.partial.call(null,cljs.core.reduce,cljs.core.min),cljs.core.partial.call(null,cljs.core.reduce,cljs.core.max)).call(null,xs);
});})(map__20818,map__20818__$1,value,index))
);
var bins = cljs.core.get.call(null,map__20818__$1,new cljs.core.Keyword(null,"bins","bins",1670395210),((function (map__20818,map__20818__$1,value,index,range){
return (function (r,xs,_){
return c2.layout.histogram.fixed_size_bins.call(null,r,c2.layout.histogram.sturges.call(null,xs));
});})(map__20818,map__20818__$1,value,index,range))
);
var values = cljs.core.map.call(null,value,data);
var r = ((cljs.core.fn_QMARK_.call(null,range))?range.call(null,values,index):range
);
var thresholds = ((cljs.core.fn_QMARK_.call(null,bins))?bins.call(null,r,values,index):((typeof bins === 'number')?c2.layout.histogram.fixed_size_bins.call(null,r,bins):bins
));
var binner = ((function (values,r,thresholds,map__20818,map__20818__$1,value,index,range,bins){
return (function (e){
return (Math.abs((c2.layout.histogram.binary_search.call(null,cljs.core.subvec.call(null,thresholds,(0),(cljs.core.count.call(null,thresholds) - (1))),value.call(null,e)) + (1))) - (1));
});})(values,r,thresholds,map__20818,map__20818__$1,value,index,range,bins))
;
var groups = cljs.core.group_by.call(null,binner,cljs.core.filter.call(null,((function (values,r,thresholds,binner,map__20818,map__20818__$1,value,index,range,bins){
return (function (p1__109951_SHARP_){
return ((value.call(null,p1__109951_SHARP_) >= r.call(null,(0)))) && ((value.call(null,p1__109951_SHARP_) <= r.call(null,(1))));
});})(values,r,thresholds,binner,map__20818,map__20818__$1,value,index,range,bins))
,data));
return cljs.core.map_indexed.call(null,((function (values,r,thresholds,binner,groups,map__20818,map__20818__$1,value,index,range,bins){
return (function (index__$1,p__20820){
var vec__20821 = p__20820;
var mn = cljs.core.nth.call(null,vec__20821,(0),null);
var mx = cljs.core.nth.call(null,vec__20821,(1),null);
var group = (function (){var or__6409__auto__ = groups.call(null,index__$1);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})();
return cljs.core.with_meta.call(null,group,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"x","x",2099068185),mn,new cljs.core.Keyword(null,"dx","dx",-381796732),(mx - mn),new cljs.core.Keyword(null,"y","y",-1757859776),cljs.core.count.call(null,group)], null));
});})(values,r,thresholds,binner,groups,map__20818,map__20818__$1,value,index,range,bins))
,cljs.core.partition.call(null,(2),(1),thresholds));
});

c2.layout.histogram.histogram.cljs$lang$maxFixedArity = (1);

c2.layout.histogram.histogram.cljs$lang$applyTo = (function (seq20815){
var G__20816 = cljs.core.first.call(null,seq20815);
var seq20815__$1 = cljs.core.next.call(null,seq20815);
return c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic(G__20816,seq20815__$1);
});

