// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto__.call(null,x));
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7073__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return (c2.dom.select.cljs$core$IFn$_invoke$arity$1 ? c2.dom.select.cljs$core$IFn$_invoke$arity$1(selector) : c2.dom.select.call(null,selector));
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render(v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args40099 = [];
var len__7484__auto___40102 = arguments.length;
var i__7485__auto___40103 = (0);
while(true){
if((i__7485__auto___40103 < len__7484__auto___40102)){
args40099.push((arguments[i__7485__auto___40103]));

var G__40104 = (i__7485__auto___40103 + (1));
i__7485__auto___40103 = G__40104;
continue;
} else {
}
break;
}

var G__40101 = args40099.length;
switch (G__40101) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40099.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args40106 = [];
var len__7484__auto___40109 = arguments.length;
var i__7485__auto___40110 = (0);
while(true){
if((i__7485__auto___40110 < len__7484__auto___40109)){
args40106.push((arguments[i__7485__auto___40110]));

var G__40111 = (i__7485__auto___40110 + (1));
i__7485__auto___40110 = G__40111;
continue;
} else {
}
break;
}

var G__40108 = args40106.length;
switch (G__40108) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40106.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom(container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom(node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom(node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__40115_40117 = c2.dom.__GT_dom(container);
var G__40116_40118 = el__$1;
goog.dom.appendChild(G__40115_40117,G__40116_40118);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom(el);
var G__40122_40125 = c2.dom.__GT_dom(container);
var G__40123_40126 = el__$1;
var G__40124_40127 = (0);
goog.dom.insertChildAt(G__40122_40125,G__40123_40126,G__40124_40127);

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
var G__40129 = c2.dom.__GT_dom(el);
return goog.dom.removeNode(G__40129);
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom(new$);
var G__40132_40134 = new$__$1;
var G__40133_40135 = c2.dom.__GT_dom(old);
goog.dom.replaceNode(G__40132_40134,G__40133_40135);

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args40136 = [];
var len__7484__auto___40154 = arguments.length;
var i__7485__auto___40155 = (0);
while(true){
if((i__7485__auto___40155 < len__7484__auto___40154)){
args40136.push((arguments[i__7485__auto___40155]));

var G__40156 = (i__7485__auto___40155 + (1));
i__7485__auto___40155 = G__40156;
continue;
} else {
}
break;
}

var G__40138 = args40136.length;
switch (G__40138) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40136.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
var G__40139 = el__$1;
var G__40140 = cljs.core.name(x);
return goog.style.getComputedStyle(G__40139,G__40140);
} else {
if(cljs.core.map_QMARK_(x)){
var seq__40141_40158 = cljs.core.seq(x);
var chunk__40142_40159 = null;
var count__40143_40160 = (0);
var i__40144_40161 = (0);
while(true){
if((i__40144_40161 < count__40143_40160)){
var vec__40145_40162 = chunk__40142_40159.cljs$core$IIndexed$_nth$arity$2(null,i__40144_40161);
var k_40163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40145_40162,(0),null);
var v_40164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40145_40162,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_40163,v_40164);

var G__40165 = seq__40141_40158;
var G__40166 = chunk__40142_40159;
var G__40167 = count__40143_40160;
var G__40168 = (i__40144_40161 + (1));
seq__40141_40158 = G__40165;
chunk__40142_40159 = G__40166;
count__40143_40160 = G__40167;
i__40144_40161 = G__40168;
continue;
} else {
var temp__4657__auto___40169 = cljs.core.seq(seq__40141_40158);
if(temp__4657__auto___40169){
var seq__40141_40170__$1 = temp__4657__auto___40169;
if(cljs.core.chunked_seq_QMARK_(seq__40141_40170__$1)){
var c__7220__auto___40171 = cljs.core.chunk_first(seq__40141_40170__$1);
var G__40172 = cljs.core.chunk_rest(seq__40141_40170__$1);
var G__40173 = c__7220__auto___40171;
var G__40174 = cljs.core.count(c__7220__auto___40171);
var G__40175 = (0);
seq__40141_40158 = G__40172;
chunk__40142_40159 = G__40173;
count__40143_40160 = G__40174;
i__40144_40161 = G__40175;
continue;
} else {
var vec__40148_40176 = cljs.core.first(seq__40141_40170__$1);
var k_40177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40148_40176,(0),null);
var v_40178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40148_40176,(1),null);
c2.dom.style.cljs$core$IFn$_invoke$arity$3(el__$1,k_40177,v_40178);

var G__40179 = cljs.core.next(seq__40141_40170__$1);
var G__40180 = null;
var G__40181 = (0);
var G__40182 = (0);
seq__40141_40158 = G__40179;
chunk__40142_40159 = G__40180;
count__40143_40160 = G__40181;
i__40144_40161 = G__40182;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var G__40151_40183 = c2.dom.__GT_dom(el);
var G__40152_40184 = cljs.core.name(k);
var G__40153_40185 = ((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$bottom,null,cljs.core.cst$kw$top,null,cljs.core.cst$kw$width,null,cljs.core.cst$kw$right,null,cljs.core.cst$kw$height,null,cljs.core.cst$kw$left,null], null), null).call(null,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null));
goog.style.setStyle(G__40151_40183,G__40152_40184,G__40153_40185);

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args40186 = [];
var len__7484__auto___40205 = arguments.length;
var i__7485__auto___40206 = (0);
while(true){
if((i__7485__auto___40206 < len__7484__auto___40205)){
args40186.push((arguments[i__7485__auto___40206]));

var G__40207 = (i__7485__auto___40206 + (1));
i__7485__auto___40206 = G__40207;
continue;
} else {
}
break;
}

var G__40188 = args40186.length;
switch (G__40188) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40186.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom(el).attributes;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__40189(s__40190){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__40190__$1 = s__40190;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40190__$1);
if(temp__4657__auto__){
var s__40190__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__40190__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__40190__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__40192 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__40191 = (0);
while(true){
if((i__40191 < size__7188__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__40191);
cljs.core.chunk_append(b__40192,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null));

var G__40209 = (i__40191 + (1));
i__40191 = G__40209;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40192),c2$dom$iter__40189(cljs.core.chunk_rest(s__40190__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40192),null);
}
} else {
var i = cljs.core.first(s__40190__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__40189(cljs.core.rest(s__40190__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom(el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name(x));
} else {
if(cljs.core.map_QMARK_(x)){
var seq__40195_40210 = cljs.core.seq(x);
var chunk__40196_40211 = null;
var count__40197_40212 = (0);
var i__40198_40213 = (0);
while(true){
if((i__40198_40213 < count__40197_40212)){
var vec__40199_40214 = chunk__40196_40211.cljs$core$IIndexed$_nth$arity$2(null,i__40198_40213);
var k_40215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40199_40214,(0),null);
var v_40216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40199_40214,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_40215,v_40216);

var G__40217 = seq__40195_40210;
var G__40218 = chunk__40196_40211;
var G__40219 = count__40197_40212;
var G__40220 = (i__40198_40213 + (1));
seq__40195_40210 = G__40217;
chunk__40196_40211 = G__40218;
count__40197_40212 = G__40219;
i__40198_40213 = G__40220;
continue;
} else {
var temp__4657__auto___40221 = cljs.core.seq(seq__40195_40210);
if(temp__4657__auto___40221){
var seq__40195_40222__$1 = temp__4657__auto___40221;
if(cljs.core.chunked_seq_QMARK_(seq__40195_40222__$1)){
var c__7220__auto___40223 = cljs.core.chunk_first(seq__40195_40222__$1);
var G__40224 = cljs.core.chunk_rest(seq__40195_40222__$1);
var G__40225 = c__7220__auto___40223;
var G__40226 = cljs.core.count(c__7220__auto___40223);
var G__40227 = (0);
seq__40195_40210 = G__40224;
chunk__40196_40211 = G__40225;
count__40197_40212 = G__40226;
i__40198_40213 = G__40227;
continue;
} else {
var vec__40202_40228 = cljs.core.first(seq__40195_40222__$1);
var k_40229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40202_40228,(0),null);
var v_40230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40202_40228,(1),null);
c2.dom.attr.cljs$core$IFn$_invoke$arity$3(el__$1,k_40229,v_40230);

var G__40231 = cljs.core.next(seq__40195_40222__$1);
var G__40232 = null;
var G__40233 = (0);
var G__40234 = (0);
seq__40195_40210 = G__40231;
chunk__40196_40211 = G__40232;
count__40197_40212 = G__40233;
i__40198_40213 = G__40234;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom(el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name(k));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$style,k)){
c2.dom.style.cljs$core$IFn$_invoke$arity$2(el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name(k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args40235 = [];
var len__7484__auto___40239 = arguments.length;
var i__7485__auto___40240 = (0);
while(true){
if((i__7485__auto___40240 < len__7484__auto___40239)){
args40235.push((arguments[i__7485__auto___40240]));

var G__40241 = (i__7485__auto___40240 + (1));
i__7485__auto___40240 = G__40241;
continue;
} else {
}
break;
}

var G__40237 = args40235.length;
switch (G__40237) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40235.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__40238 = c2.dom.__GT_dom(el);
return goog.dom.getTextContent(G__40238);
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args40243 = [];
var len__7484__auto___40247 = arguments.length;
var i__7485__auto___40248 = (0);
while(true){
if((i__7485__auto___40248 < len__7484__auto___40247)){
args40243.push((arguments[i__7485__auto___40248]));

var G__40249 = (i__7485__auto___40248 + (1));
i__7485__auto___40248 = G__40249;
continue;
} else {
}
break;
}

var G__40245 = args40243.length;
switch (G__40245) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40243.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__40246 = c2.dom.__GT_dom(el);
return goog.dom.forms.getValue(G__40246);
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom(el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
var G__40254_40257 = c2.dom.__GT_dom(el);
var G__40255_40258 = cljs.core.name(class$);
var G__40256_40259 = classed_QMARK_;
goog.dom.classes.enable(G__40254_40257,G__40255_40258,G__40256_40259);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_(el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__40260_SHARP_){
var G__40261 = ((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return (p1__40260_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p1__40260_SHARP_.cljs$core$IFn$_invoke$arity$0() : p1__40260_SHARP_.call(null));
});})(or__6409__auto____$1,or__6409__auto__))
;
var G__40262 = (10);
return setTimeout(G__40261,G__40262);
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
