// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.forms');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.urls');
goog.require('chimera.date');
goog.require('cljs.pprint');
goog.require('clojure.string');
goog.require('hatti.constants');
hatti.ona.forms.currency_regex = /£|$/;
hatti.ona.forms.newline_regex = /[\n\r]/;
hatti.ona.forms.no_answer = "No Answer";
hatti.ona.forms.submission_time_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._submission_time,cljs.core.cst$kw$full_DASH_name,hatti.constants._submission_time,cljs.core.cst$kw$label,"Submission Time",cljs.core.cst$kw$type,"dateTime"], null);
hatti.ona.forms.id_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$full_DASH_name,hatti.constants._id,cljs.core.cst$kw$label,"ID",cljs.core.cst$kw$name,hatti.constants._id,cljs.core.cst$kw$type,"integer"], null);
hatti.ona.forms.submitted_by_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._submitted_by,cljs.core.cst$kw$full_DASH_name,hatti.constants._submitted_by,cljs.core.cst$kw$label,"Submitted by",cljs.core.cst$kw$type,"text"], null);
hatti.ona.forms.last_edited = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._last_edited,cljs.core.cst$kw$full_DASH_name,hatti.constants._last_edited,cljs.core.cst$kw$label,"Last Edited",cljs.core.cst$kw$type,"date"], null);
hatti.ona.forms.media_received_field = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$name,hatti.constants._media_all_received,cljs.core.cst$kw$full_DASH_name,hatti.constants._media_all_received,cljs.core.cst$kw$label,"Media attachments received",cljs.core.cst$kw$type,"text"], null);
hatti.ona.forms.extra_submission_details = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.ona.forms.last_edited,hatti.ona.forms.submission_time_field,hatti.ona.forms.submitted_by_field,hatti.ona.forms.media_received_field], null);
/**
 * Format multiline answer by introducing html line breaks
 */
hatti.ona.forms.format_multiline_answer = (function hatti$ona$forms$format_multiline_answer(answer){
if(cljs.core.truth_((function (){var and__6397__auto__ = typeof answer === 'string';
if(and__6397__auto__){
return cljs.core.re_find(hatti.ona.forms.newline_regex,answer);
} else {
return and__6397__auto__;
}
})())){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32046_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$p,p1__32046_SHARP_],null));
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(answer,hatti.ona.forms.newline_regex));
} else {
return answer;
}
});
/**
 * Helper function: is the :type of a field among a set of types
 */
hatti.ona.forms.field_type_in_set_QMARK_ = (function hatti$ona$forms$field_type_in_set_QMARK_(types,field){
return cljs.core.contains_QMARK_(types,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Helper function: is the :name of a field among a set of names
 */
hatti.ona.forms.field_name_in_set_QMARK_ = (function hatti$ona$forms$field_name_in_set_QMARK_(names,field){
return cljs.core.contains_QMARK_(names,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Checks whether a field in a form (ie, a field) is a group field
 */
hatti.ona.forms.group_QMARK_ = (function hatti$ona$forms$group_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["group",null], null), null),field);
});
/**
 * Checks whether a field in a form (ie, a field) is a repeat field
 */
hatti.ona.forms.repeat_QMARK_ = (function hatti$ona$forms$repeat_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["repeat",null], null), null),field);
});
/**
 * Checks whether a field is a numeric field
 */
hatti.ona.forms.numeric_QMARK_ = (function hatti$ona$forms$numeric_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["integer",null,"decimal",null], null), null),field);
});
/**
 * Checks whether a field is a date or a time field
 */
hatti.ona.forms.time_based_QMARK_ = (function hatti$ona$forms$time_based_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["today",null,"dateTime",null,"start",null,"time",null,"date",null,"end",null], null), null),field);
});
/**
 * Checks whether a field is a category field (select one or multiple)
 */
hatti.ona.forms.categorical_QMARK_ = (function hatti$ona$forms$categorical_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["select all that apply",null,"select one",null], null), null),field);
});
/**
 * Checks whether a field is a select one field
 */
hatti.ona.forms.select_one_QMARK_ = (function hatti$ona$forms$select_one_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select one",null], null), null),field);
});
/**
 * Checks whether a field is a select multiple (select all that apply) field
 */
hatti.ona.forms.select_all_QMARK_ = (function hatti$ona$forms$select_all_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select all that apply",null], null), null),field);
});
/**
 * Checks whether a field is a text / string field.
 */
hatti.ona.forms.text_QMARK_ = (function hatti$ona$forms$text_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["string",null,"text",null], null), null),field);
});
/**
 * Checks whether a field in a form (a field) is a group field
 */
hatti.ona.forms.note_QMARK_ = (function hatti$ona$forms$note_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["note",null], null), null),field);
});
hatti.ona.forms.meta_QMARK_ = (function hatti$ona$forms$meta_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_name_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["instanceID",null,"_media_all_received",null,"_duration",null,"meta",null,"__version__",null,"_submitted_by",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, ["subscriberid",null,"phonenumber",null,"instanceID",null,"today",null,"deviceid",null,"_media_all_received",null,"uuid",null,"start",null,"imei",null,"simserial",null,"end",null], null), null),field);
}
});
hatti.ona.forms.geofield_QMARK_ = (function hatti$ona$forms$geofield_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["geoshape",null,"geotrace",null,"geopoint",null,"osm",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
var map__32049 = field;
var map__32049__$1 = ((((!((map__32049 == null)))?((((map__32049.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32049.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32049):map__32049);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32049__$1,cljs.core.cst$kw$children);
return cljs.core.some(hatti$ona$forms$geofield_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geopoint_QMARK_ = (function hatti$ona$forms$geopoint_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["geopoint",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
var map__32053 = field;
var map__32053__$1 = ((((!((map__32053 == null)))?((((map__32053.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32053.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32053):map__32053);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32053__$1,cljs.core.cst$kw$children);
return cljs.core.some(hatti$ona$forms$geopoint_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geoshape_QMARK_ = (function hatti$ona$forms$geoshape_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geoshape",null], null), null),field);
});
hatti.ona.forms.geotrace_QMARK_ = (function hatti$ona$forms$geotrace_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geotrace",null], null), null),field);
});
hatti.ona.forms.image_QMARK_ = (function hatti$ona$forms$image_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["image",null,"photo",null], null), null),field);
});
hatti.ona.forms.audio_QMARK_ = (function hatti$ona$forms$audio_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["audio",null], null), null),field);
});
hatti.ona.forms.video_QMARK_ = (function hatti$ona$forms$video_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["video",null], null), null),field);
});
hatti.ona.forms.osm_QMARK_ = (function hatti$ona$forms$osm_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["osm",null], null), null),field);
});
/**
 * Checks whether a field is a calculate field
 */
hatti.ona.forms.calculate_QMARK_ = (function hatti$ona$forms$calculate_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["calculate",null], null), null),field);
});
/**
 * Returns false for fields such as note, group, etc. which don't have data
 */
hatti.ona.forms.has_data_QMARK_ = (function hatti$ona$forms$has_data_QMARK_(field){
return cljs.core.not((function (){var or__6409__auto__ = hatti.ona.forms.note_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.group_QMARK_(field);
}
})());
});
/**
 * Get the icon relevant to the given field (depending on its type).
 */
hatti.ona.forms.get_icon = (function hatti$ona$forms$get_icon(field){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))?"fa fa-font":(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))?"fa fa-clock-o":(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_(field))?"fa fa-bar-chart fa-flip-h-rotate-90":""
)))))], null)], null);
});
/**
 * Assign class according to field type category, e.g. integer & decimals are
 * both in the numeric category
 */
hatti.ona.forms.get_column_class = (function hatti$ona$forms$get_column_class(field){
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(field,cljs.core.cst$kw$full_DASH_name),"_media_all_received")){
return "column-string media-attachment";
} else {
return "column-string";
}
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return "column-numeric";
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return "column-datetime";
} else {
if(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_(field))){
return "column-categorical";
} else {
if(cljs.core.truth_(hatti.ona.forms.geofield_QMARK_(field))){
return "column-geofield";
} else {
if(cljs.core.truth_(hatti.ona.forms.image_QMARK_(field))){
return "column-image";
} else {
if(cljs.core.truth_(hatti.ona.forms.audio_QMARK_(field))){
return "column-audio";
} else {
if(cljs.core.truth_(hatti.ona.forms.video_QMARK_(field))){
return "column-video";
} else {
if(cljs.core.truth_(hatti.ona.forms.meta_QMARK_(field))){
return "column-metadata";
} else {
return "";

}
}
}
}
}
}
}
}
}
});
/**
 * Gets the label object out of a map with key :label (eg. a field).
 * If multiple languages, and none specified, picks out alphabetically first.
 */
hatti.ona.forms.get_label = (function hatti$ona$forms$get_label(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32065 = arguments.length;
var i__7485__auto___32066 = (0);
while(true){
if((i__7485__auto___32066 < len__7484__auto___32065)){
args__7491__auto__.push((arguments[i__7485__auto___32066]));

var G__32067 = (i__7485__auto___32066 + (1));
i__7485__auto___32066 = G__32067;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic = (function (p__32057,p__32058){
var map__32059 = p__32057;
var map__32059__$1 = ((((!((map__32059 == null)))?((((map__32059.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32059.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32059):map__32059);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32059__$1,cljs.core.cst$kw$label);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32059__$1,cljs.core.cst$kw$name);
var vec__32060 = p__32058;
var language = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32060,(0),null);
if(!(cljs.core.map_QMARK_(label))){
var or__6409__auto__ = label;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return name;
}
} else {
if(cljs.core.contains_QMARK_(cljs.core.set(cljs.core.keys(label)),language)){
return (label.cljs$core$IFn$_invoke$arity$1 ? label.cljs$core$IFn$_invoke$arity$1(language) : label.call(null,language));
} else {
var G__32064 = cljs.core.first(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(label)));
return (label.cljs$core$IFn$_invoke$arity$1 ? label.cljs$core$IFn$_invoke$arity$1(G__32064) : label.call(null,G__32064));
}
}
});

hatti.ona.forms.get_label.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.get_label.cljs$lang$applyTo = (function (seq32055){
var G__32056 = cljs.core.first(seq32055);
var seq32055__$1 = cljs.core.next(seq32055);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(G__32056,seq32055__$1);
});

/**
 * Checks if the appearance-value has the search expression
 */
hatti.ona.forms.uses_search_expression_QMARK_ = (function hatti$ona$forms$uses_search_expression_QMARK_(appearance_value){
var and__6397__auto__ = typeof appearance_value === 'string';
if(and__6397__auto__){
return cljs.core.re_matches(/^search\(.*\)$/,appearance_value);
} else {
return and__6397__auto__;
}
});
/**
 * Displays tip question and tooltip msg for failed media files uploads
 */
hatti.ona.forms.media_files_upload_error_component = (function hatti$ona$forms$media_files_upload_error_component(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32073 = arguments.length;
var i__7485__auto___32074 = (0);
while(true){
if((i__7485__auto___32074 < len__7484__auto___32073)){
args__7491__auto__.push((arguments[i__7485__auto___32074]));

var G__32075 = (i__7485__auto___32074 + (1));
i__7485__auto___32074 = G__32075;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.media_files_upload_error_component.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.media_files_upload_error_component.cljs$core$IFn$_invoke$arity$variadic = (function (answer,p__32070){
var map__32071 = p__32070;
var map__32071__$1 = ((((!((map__32071 == null)))?((((map__32071.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32071.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32071):map__32071);
var help_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32071__$1,cljs.core.cst$kw$help_DASH_url);
var error_message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32071__$1,cljs.core.cst$kw$error_DASH_message);
var record_modal_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32071__$1,cljs.core.cst$kw$record_DASH_modal_QMARK_);
if(cljs.core.truth_(record_modal_QMARK_)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$image_DASH_name,answer,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$tooltip,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,help_url,cljs.core.cst$kw$target,"_blank"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,error_message], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_question,"?"], null)], null)], null);
} else {
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("<span class='image-name'> %s </span>\n          <a class='tooltip' href=%s target='_blank'>\n          <span class='tip-info'>%s</span>\n          <span class='tip-question'>?</span></a>",cljs.core.array_seq([answer,help_url,error_message], 0));
}
});

hatti.ona.forms.media_files_upload_error_component.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.media_files_upload_error_component.cljs$lang$applyTo = (function (seq32068){
var G__32069 = cljs.core.first(seq32068);
var seq32068__$1 = cljs.core.next(seq32068);
return hatti.ona.forms.media_files_upload_error_component.cljs$core$IFn$_invoke$arity$variadic(G__32069,seq32068__$1);
});

/**
 * Returns an infor icon with a tooltip message
 */
hatti.ona.forms.infor_icon_component = (function hatti$ona$forms$infor_icon_component(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32081 = arguments.length;
var i__7485__auto___32082 = (0);
while(true){
if((i__7485__auto___32082 < len__7484__auto___32081)){
args__7491__auto__.push((arguments[i__7485__auto___32082]));

var G__32083 = (i__7485__auto___32082 + (1));
i__7485__auto___32082 = G__32083;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.infor_icon_component.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.infor_icon_component.cljs$core$IFn$_invoke$arity$variadic = (function (answer,p__32078){
var map__32079 = p__32078;
var map__32079__$1 = ((((!((map__32079 == null)))?((((map__32079.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32079.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32079):map__32079);
var media_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32079__$1,cljs.core.cst$kw$media_DASH_count);
var total_media = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32079__$1,cljs.core.cst$kw$total_DASH_media);
var help_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32079__$1,cljs.core.cst$kw$help_DASH_url);
return [cljs.core.str("<span>"),cljs.core.str(answer),cljs.core.str("<a class=\"tooltip top-right\" href="),cljs.core.str(help_url),cljs.core.str(" target=\"_blank\">\n       <span class=\"media-status tip-info\">\n       <p><b>Total media files expected</b><span> : </span><span>"),cljs.core.str(total_media),cljs.core.str("</span></p>\n       <p><b>Total media files received</b><span> : </span><span>"),cljs.core.str(media_count),cljs.core.str("</span></p></span><i class='fa fa-info-circle'></i></a></span>")].join('');
});

hatti.ona.forms.infor_icon_component.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.infor_icon_component.cljs$lang$applyTo = (function (seq32076){
var G__32077 = cljs.core.first(seq32076);
var seq32076__$1 = cljs.core.next(seq32076);
return hatti.ona.forms.infor_icon_component.cljs$core$IFn$_invoke$arity$variadic(G__32077,seq32076__$1);
});

/**
 * String representation for a particular field datapoint (answer).
 * re-formatting depends on field type, eg. name->label substitution.
 * Optional: compact? should be true if a short string needs to be returned.
 */
hatti.ona.forms.format_answer = (function hatti$ona$forms$format_answer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32101 = arguments.length;
var i__7485__auto___32102 = (0);
while(true){
if((i__7485__auto___32102 < len__7484__auto___32101)){
args__7491__auto__.push((arguments[i__7485__auto___32102]));

var G__32103 = (i__7485__auto___32102 + (1));
i__7485__auto___32102 = G__32103;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic = (function (field,answer,p__32091){
var map__32092 = p__32091;
var map__32092__$1 = ((((!((map__32092 == null)))?((((map__32092.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32092.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32092):map__32092);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32092__$1,cljs.core.cst$kw$language);
var compact_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32092__$1,cljs.core.cst$kw$compact_QMARK_);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32092__$1,cljs.core.cst$kw$label);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32092__$1,cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$name);
var media = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32092__$1,cljs.core.cst$kw$media);
var record_modal_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32092__$1,cljs.core.cst$kw$record_DASH_modal_QMARK_,false);
var media_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32092__$1,cljs.core.cst$kw$media_DASH_count);
var total_media = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32092__$1,cljs.core.cst$kw$total_DASH_media);
if(clojure.string.blank_QMARK_(answer)){
return hatti.ona.forms.no_answer;
} else {
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
var option = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__32092,map__32092__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__32084_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(answer,(field_key.cljs$core$IFn$_invoke$arity$1 ? field_key.cljs$core$IFn$_invoke$arity$1(p1__32084_SHARP_) : field_key.call(null,p1__32084_SHARP_)));
});})(map__32092,map__32092__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field)));
var formatted = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(option,cljs.core.array_seq([language], 0));
var or__6409__auto__ = formatted;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return answer;
}
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
var names = cljs.core.set(clojure.string.split.cljs$core$IFn$_invoke$arity$2(answer,/ /));
var appearance_value = cljs.core.cst$kw$appearance.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$control.cljs$core$IFn$_invoke$arity$1(field));
var multiple_select_values = (cljs.core.truth_(hatti.ona.forms.uses_search_expression_QMARK_(appearance_value))?cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (names,appearance_value,map__32092,map__32092__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__32085_SHARP_){
return cljs.core.identity(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,p1__32085_SHARP_], null));
});})(names,appearance_value,map__32092,map__32092__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,names):cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (names,appearance_value,map__32092,map__32092__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__32086_SHARP_){
return cljs.core.contains_QMARK_(names,(field_key.cljs$core$IFn$_invoke$arity$1 ? field_key.cljs$core$IFn$_invoke$arity$1(p1__32086_SHARP_) : field_key.call(null,p1__32086_SHARP_)));
});})(names,appearance_value,map__32092,map__32092__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(field)));
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (names,appearance_value,multiple_select_values,map__32092,map__32092__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__32087_SHARP_){
return [cljs.core.str("\u2611 "),cljs.core.str(hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(p1__32087_SHARP_,cljs.core.array_seq([language], 0))),cljs.core.str(" ")].join('');
});})(names,appearance_value,multiple_select_values,map__32092,map__32092__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,multiple_select_values));
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return chimera.date.format_date(answer);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.image_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.audio_QMARK_(field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.video_QMARK_(field);
}
}
})())){
var image = cljs.core.cst$kw$download_url.cljs$core$IFn$_invoke$arity$1(answer);
var thumb = (function (){var or__6409__auto__ = cljs.core.cst$kw$small_download_url.cljs$core$IFn$_invoke$arity$1(answer);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return image;
}
})();
var fname = chimera.urls.last_url_param(cljs.core.cst$kw$filename.cljs$core$IFn$_invoke$arity$1(answer));
if((typeof answer === 'string') && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(answer,"null")) && ((thumb == null))){
return hatti.ona.forms.media_files_upload_error_component.cljs$core$IFn$_invoke$arity$variadic(answer,cljs.core.array_seq([cljs.core.cst$kw$help_DASH_url,hatti.constants.help_base_url(hatti.constants.failed_media_upload_help_url),cljs.core.cst$kw$error_DASH_message,hatti.constants.failed_media_upload_error_message,cljs.core.cst$kw$record_DASH_modal_QMARK_,record_modal_QMARK_], 0));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(answer,"null")){
return answer;
} else {
if(cljs.core.truth_(compact_QMARK_)){
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("<a href='%s' target='_blank'>\n                                      <i class='fa fa-external-link'></i>\n                                      %s </a>",cljs.core.array_seq([image,fname], 0));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,image,cljs.core.cst$kw$target,"_blank"], null),(cljs.core.truth_(hatti.ona.forms.image_QMARK_(field))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,"80px",cljs.core.cst$kw$src,thumb], null)], null):new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_file_DASH_video_DASH_o], null)," ",fname], null))], null);

}
}
}
} else {
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(field))){
var kw__GT_name = cljs.core.name;
var map__32094 = answer;
var map__32094__$1 = ((((!((map__32094 == null)))?((((map__32094.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32094.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32094):map__32094);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32094__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32094__$1,cljs.core.cst$kw$type);
var osm_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32094__$1,cljs.core.cst$kw$osm_DASH_id);
var type_cap = (cljs.core.truth_(type)?clojure.string.capitalize(type):null);
var title = [cljs.core.str("OSM "),cljs.core.str(type_cap),cljs.core.str(": "),cljs.core.str(name),cljs.core.str(" ("),cljs.core.str(osm_id),cljs.core.str(")")].join('');
if(cljs.core.truth_(compact_QMARK_)){
return title;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$osm_DASH_data,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),title], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (kw__GT_name,map__32094,map__32094__$1,name,type,osm_id,type_cap,title,map__32092,map__32092__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p__32096){
var vec__32097 = p__32096;
var tk = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32097,(0),null);
var tv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32097,(1),null);
if(clojure.string.blank_QMARK_(tv)){
return null;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$question,(kw__GT_name.cljs$core$IFn$_invoke$arity$1 ? kw__GT_name.cljs$core$IFn$_invoke$arity$1(tk) : kw__GT_name.call(null,tk))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$answer,tv], null)], null);
}
});})(kw__GT_name,map__32094,map__32094__$1,name,type,osm_id,type_cap,title,map__32092,map__32092__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(answer))], null)], null);
}
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
if(cljs.core.empty_QMARK_(answer)){
return hatti.ona.forms.no_answer;
} else {
return [cljs.core.str("Repeated data with "),cljs.core.str(cljs.core.count(answer)),cljs.core.str(" answers.")].join('');
}
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
var temp__4655__auto__ = (function (){var G__32100 = label;
if((G__32100 == null)){
return null;
} else {
return cljs.core.re_find(hatti.ona.forms.currency_regex,G__32100);
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var currency = temp__4655__auto__;
return [cljs.core.str(currency),cljs.core.str(cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~:d",cljs.core.array_seq([answer], 0)))].join('');
} else {
return answer;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2([cljs.core.str(answer)].join(''),"false")){
return hatti.ona.forms.infor_icon_component.cljs$core$IFn$_invoke$arity$variadic(answer,cljs.core.array_seq([cljs.core.cst$kw$media_DASH_count,media_count,cljs.core.cst$kw$total_DASH_media,total_media,cljs.core.cst$kw$help_DASH_url,hatti.constants.help_base_url(hatti.constants.failed_media_upload_help_url)], 0));
} else {
return hatti.ona.forms.format_multiline_answer(answer);
}
}

}
}
}
}
}
}
}
});

hatti.ona.forms.format_answer.cljs$lang$maxFixedArity = (2);

hatti.ona.forms.format_answer.cljs$lang$applyTo = (function (seq32088){
var G__32089 = cljs.core.first(seq32088);
var seq32088__$1 = cljs.core.next(seq32088);
var G__32090 = cljs.core.first(seq32088__$1);
var seq32088__$2 = cljs.core.next(seq32088__$1);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(G__32089,G__32090,seq32088__$2);
});

/**
 * Try and produce a label for meta field if non-existent.
 */
hatti.ona.forms.relabel_meta_field = (function hatti$ona$forms$relabel_meta_field(p__32104){
var map__32110 = p__32104;
var map__32110__$1 = ((((!((map__32110 == null)))?((((map__32110.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32110.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32110):map__32110);
var field = map__32110__$1;
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32110__$1,cljs.core.cst$kw$label);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32110__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32110__$1,cljs.core.cst$kw$type);
var label__$1 = (cljs.core.truth_(type)?(function (){var G__32112 = type;
switch (G__32112) {
case "start":
return "Start time";

break;
case "end":
return "End time";

break;
case "today":
return "Day of survey";

break;
case "deviceid":
return "Device ID (IMEI)";

break;
case "imei":
return "IMEI";

break;
case "subscriberid":
return "IMSI";

break;
case "simserial":
return "SIM serial number";

break;
case "uuid":
return "UUID";

break;
case "instanceID":
return "Instance ID";

break;
case "phonenumber":
return "Phone number";

break;
case "_media_all_received":
return "Media attachments received";

break;
default:
return name;

}
})():(function (){var G__32113 = name;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$_submission_time,G__32113)){
return "Submission time";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$_submitted_by,G__32113)){
return "Submitted by";
} else {
return "";

}
}
})());
var G__32114 = field;
if(cljs.core.not(label__$1)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__32114,cljs.core.cst$kw$label,label__$1);
} else {
return G__32114;
}
});
hatti.ona.forms.name_label_map = (function hatti$ona$forms$name_label_map(p__32117,prefix,acc,flatten_repeats_QMARK_){
var map__32124 = p__32117;
var map__32124__$1 = ((((!((map__32124 == null)))?((((map__32124.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32124.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32124):map__32124);
var child = map__32124__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32124__$1,cljs.core.cst$kw$children);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32124__$1,cljs.core.cst$kw$name);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32124__$1,cljs.core.cst$kw$label);
var full_name = (cljs.core.truth_(prefix)?[cljs.core.str(prefix),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
var langs = ((cljs.core.map_QMARK_(label))?cljs.core.keys(label):null);
var updated_child = cljs.core.with_meta(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(child,cljs.core.cst$kw$full_DASH_name,full_name),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$langs,langs], null));
var childless_child = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated_child,cljs.core.cst$kw$children);
var make_new_children = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (full_name,langs,updated_child,childless_child,map__32124,map__32124__$1,child,children,name,label){
return (function (p1__32116_SHARP_){
return hatti$ona$forms$name_label_map(p1__32116_SHARP_,full_name,cljs.core.PersistentVector.EMPTY,flatten_repeats_QMARK_);
});})(full_name,langs,updated_child,childless_child,map__32124,map__32124__$1,child,children,name,label))
,children);
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.group_QMARK_(updated_child);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var and__6397__auto__ = flatten_repeats_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.ona.forms.repeat_QMARK_(updated_child);
} else {
return and__6397__auto__;
}
}
})())){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,childless_child),make_new_children);
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(updated_child))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(updated_child,cljs.core.cst$kw$children,cljs.core.flatten(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,make_new_children))));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,updated_child);

}
}
});
/**
 * Input: map derived from form.json. Output: a flattened vector;
 * each element is a field; a field is a {:name .. :label .. :type ..} map.
 * By default, REPEAT BLOCKS ARE NOT FLATTENED, repeat blocks represent
 * subforms, which need special handling in most cases.
 * :flatten-repeats? overrides default behavior, also flattens repeats.
 */
hatti.ona.forms.flatten_form = (function hatti$ona$forms$flatten_form(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32136 = arguments.length;
var i__7485__auto___32137 = (0);
while(true){
if((i__7485__auto___32137 < len__7484__auto___32136)){
args__7491__auto__.push((arguments[i__7485__auto___32137]));

var G__32138 = (i__7485__auto___32137 + (1));
i__7485__auto___32137 = G__32138;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic = (function (p__32130,p__32131){
var map__32132 = p__32130;
var map__32132__$1 = ((((!((map__32132 == null)))?((((map__32132.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32132.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32132):map__32132);
var form = map__32132__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32132__$1,cljs.core.cst$kw$children);
var map__32133 = p__32131;
var map__32133__$1 = ((((!((map__32133 == null)))?((((map__32133.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32133.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32133):map__32133);
var flatten_repeats_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32133__$1,cljs.core.cst$kw$flatten_DASH_repeats_QMARK_);
var nodes = cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__32132,map__32132__$1,form,children,map__32133,map__32133__$1,flatten_repeats_QMARK_){
return (function (p1__32126_SHARP_){
return hatti.ona.forms.name_label_map(p1__32126_SHARP_,null,cljs.core.PersistentVector.EMPTY,flatten_repeats_QMARK_);
});})(map__32132,map__32132__$1,form,children,map__32133,map__32133__$1,flatten_repeats_QMARK_))
,children));
var langs = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (nodes,map__32132,map__32132__$1,form,children,map__32133,map__32133__$1,flatten_repeats_QMARK_){
return (function (p1__32127_SHARP_){
return cljs.core.cst$kw$langs.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__32127_SHARP_));
});})(nodes,map__32132,map__32132__$1,form,children,map__32133,map__32133__$1,flatten_repeats_QMARK_))
,nodes)));
return cljs.core.with_meta(nodes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$languages,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,langs)], null));
});

hatti.ona.forms.flatten_form.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.flatten_form.cljs$lang$applyTo = (function (seq32128){
var G__32129 = cljs.core.first(seq32128);
var seq32128__$1 = cljs.core.next(seq32128);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic(G__32129,seq32128__$1);
});

/**
 * Get just the meta fields out of the form.
 * Options to re-label meta fields, or include submission time in meta list.
 */
hatti.ona.forms.meta_fields = (function hatti$ona$forms$meta_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32146 = arguments.length;
var i__7485__auto___32147 = (0);
while(true){
if((i__7485__auto___32147 < len__7484__auto___32146)){
args__7491__auto__.push((arguments[i__7485__auto___32147]));

var G__32148 = (i__7485__auto___32147 + (1));
i__7485__auto___32147 = G__32148;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,p__32142){
var map__32143 = p__32142;
var map__32143__$1 = ((((!((map__32143 == null)))?((((map__32143.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32143.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32143):map__32143);
var relabel_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__32143__$1,cljs.core.cst$kw$relabel_QMARK_,true);
var with_submission_details_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32143__$1,cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_);
var meta_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.meta_QMARK_,flat_form);
var include_extra_sub_details = (cljs.core.truth_(with_submission_details_QMARK_)?((function (meta_fields,map__32143,map__32143__$1,relabel_QMARK_,with_submission_details_QMARK_){
return (function (p1__32139_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__32139_SHARP_),hatti.ona.forms.extra_submission_details);
});})(meta_fields,map__32143,map__32143__$1,relabel_QMARK_,with_submission_details_QMARK_))
:cljs.core.identity);
var relabel = (cljs.core.truth_(relabel_QMARK_)?hatti.ona.forms.relabel_meta_field:cljs.core.identity);
var G__32145 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(relabel,meta_fields);
return (include_extra_sub_details.cljs$core$IFn$_invoke$arity$1 ? include_extra_sub_details.cljs$core$IFn$_invoke$arity$1(G__32145) : include_extra_sub_details.call(null,G__32145));
});

hatti.ona.forms.meta_fields.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.meta_fields.cljs$lang$applyTo = (function (seq32140){
var G__32141 = cljs.core.first(seq32140);
var seq32140__$1 = cljs.core.next(seq32140);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(G__32141,seq32140__$1);
});

/**
 * Get just the fields in this form that are not meta fields.
 */
hatti.ona.forms.non_meta_fields = (function hatti$ona$forms$non_meta_fields(flat_form){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.meta_QMARK_,flat_form);
});
/**
 * Get just the geofields from the form.
 */
hatti.ona.forms.geofields = (function hatti$ona$forms$geofields(flat_form){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,flat_form);
});
/**
 * From a list of geofields, get the default one to map.
 * Implementation: pick first geoshape if any, else pick first geofield.
 */
hatti.ona.forms.default_geofield = (function hatti$ona$forms$default_geofield(flat_form){
var repeats = cljs.core.flatten(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form));
var geofields = hatti.ona.forms.geofields(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(flat_form,repeats));
var geoshapes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geoshape_QMARK_,geofields);
var geopoints = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geopoint_QMARK_,geofields);
if(cljs.core.seq(geoshapes)){
return cljs.core.first(geoshapes);
} else {
if(cljs.core.seq(geopoints)){
return cljs.core.first(geopoints);
} else {
return cljs.core.first(geofields);

}
}
});
hatti.ona.forms.english_QMARK_ = (function hatti$ona$forms$english_QMARK_(language){
return cljs.core.re_find(/english/i,[cljs.core.str(language)].join(''));
});
/**
 * Get the languages for a given form.
 */
hatti.ona.forms.get_languages = (function hatti$ona$forms$get_languages(form){
return cljs.core.cst$kw$languages.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(form));
});
/**
 * Does this form contain labels in multiple languages?
 */
hatti.ona.forms.multilingual_QMARK_ = (function hatti$ona$forms$multilingual_QMARK_(form){
return cljs.core.seq(hatti.ona.forms.get_languages(form));
});
/**
 * Get default language (English or alphabetical first) from within a list.
 */
hatti.ona.forms.default_lang = (function hatti$ona$forms$default_lang(languages){
var temp__4655__auto__ = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.english_QMARK_,languages));
if(cljs.core.truth_(temp__4655__auto__)){
var eng = temp__4655__auto__;
return eng;
} else {
return cljs.core.first(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(languages));
}
});
