// Compiled by ClojureScript 1.9.229 {}
goog.provide('inflections.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('no.en.core');
/**
 * Coerce the string `s` to the type of `obj`.
 */
inflections.core.coerce = (function inflections$core$coerce(obj,s){
if((obj instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,s);
} else {
if((obj instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,s);
} else {
return s;

}
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
inflections.core.Rule = (function (pattern,replacement,__meta,__extmap,__hash){
this.pattern = pattern;
this.replacement = replacement;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
inflections.core.Rule.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.call(null,this__7031__auto____$1,k__7032__auto__,null);
});

inflections.core.Rule.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k20027,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__20029 = (((k20027 instanceof cljs.core.Keyword))?k20027.fqn:null);
switch (G__20029) {
case "pattern":
return self__.pattern;

break;
case "replacement":
return self__.replacement;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k20027,else__7034__auto__);

}
});

inflections.core.Rule.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7046__auto__,pr_pair__7048__auto__,"#inflections.core.Rule{",", ","}",opts__7047__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pattern","pattern",242135423),self__.pattern],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"replacement","replacement",-1836238839),self__.replacement],null))], null),self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IIterable$ = true;

inflections.core.Rule.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__20026){
var self__ = this;
var G__20026__$1 = this;
return (new cljs.core.RecordIter((0),G__20026__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pattern","pattern",242135423),new cljs.core.Keyword(null,"replacement","replacement",-1836238839)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

inflections.core.Rule.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

inflections.core.Rule.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,self__.__extmap,self__.__hash));
});

inflections.core.Rule.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap.call(null,this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

inflections.core.Rule.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map.call(null,this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

inflections.core.Rule.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"replacement","replacement",-1836238839),null,new cljs.core.Keyword(null,"pattern","pattern",242135423),null], null), null),k__7041__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7041__auto__)),null));
}
});

inflections.core.Rule.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__20026){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__20030 = cljs.core.keyword_identical_QMARK_;
var expr__20031 = k__7039__auto__;
if(cljs.core.truth_(pred__20030.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423),expr__20031))){
return (new inflections.core.Rule(G__20026,self__.replacement,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__20030.call(null,new cljs.core.Keyword(null,"replacement","replacement",-1836238839),expr__20031))){
return (new inflections.core.Rule(self__.pattern,G__20026,self__.__meta,self__.__extmap,null));
} else {
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7039__auto__,G__20026),null));
}
}
});

inflections.core.Rule.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pattern","pattern",242135423),self__.pattern],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"replacement","replacement",-1836238839),self__.replacement],null))], null),self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__20026){
var self__ = this;
var this__7030__auto____$1 = this;
return (new inflections.core.Rule(self__.pattern,self__.replacement,G__20026,self__.__extmap,self__.__hash));
});

inflections.core.Rule.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7037__auto__)){
return cljs.core._assoc.call(null,this__7036__auto____$1,cljs.core._nth.call(null,entry__7037__auto__,(0)),cljs.core._nth.call(null,entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

inflections.core.Rule.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"replacement","replacement",-195707312,null)], null);
});

inflections.core.Rule.cljs$lang$type = true;

inflections.core.Rule.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"inflections.core/Rule");
});

inflections.core.Rule.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write.call(null,writer__7066__auto__,"inflections.core/Rule");
});

inflections.core.__GT_Rule = (function inflections$core$__GT_Rule(pattern,replacement){
return (new inflections.core.Rule(pattern,replacement,null,null,null));
});

inflections.core.map__GT_Rule = (function inflections$core$map__GT_Rule(G__20028){
return (new inflections.core.Rule(new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(G__20028),new cljs.core.Keyword(null,"replacement","replacement",-1836238839).cljs$core$IFn$_invoke$arity$1(G__20028),null,cljs.core.dissoc.call(null,G__20028,new cljs.core.Keyword(null,"pattern","pattern",242135423),new cljs.core.Keyword(null,"replacement","replacement",-1836238839)),null));
});

inflections.core.add_rule_BANG_ = (function inflections$core$add_rule_BANG_(rules,rule){
if(!(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,cljs.core.deref.call(null,rules)),rule))){
return cljs.core.swap_BANG_.call(null,rules,cljs.core.conj,rule);
} else {
return null;
}
});
/**
 * Returns a seq of rules, where the pattern and replacement must be
 *   given in pairs of two elements.
 */
inflections.core.slurp_rules = (function inflections$core$slurp_rules(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20036 = arguments.length;
var i__7485__auto___20037 = (0);
while(true){
if((i__7485__auto___20037 < len__7484__auto___20036)){
args__7491__auto__.push((arguments[i__7485__auto___20037]));

var G__20038 = (i__7485__auto___20037 + (1));
i__7485__auto___20037 = G__20038;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return inflections.core.slurp_rules.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

inflections.core.slurp_rules.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
return cljs.core.map.call(null,(function (p1__20034_SHARP_){
return cljs.core.apply.call(null,inflections.core.__GT_Rule,p1__20034_SHARP_);
}),cljs.core.partition.call(null,(2),patterns_and_replacements));
});

inflections.core.slurp_rules.cljs$lang$maxFixedArity = (0);

inflections.core.slurp_rules.cljs$lang$applyTo = (function (seq20035){
return inflections.core.slurp_rules.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20035));
});

inflections.core.resolve_rule = (function inflections$core$resolve_rule(rule,word){
if(cljs.core.truth_((function (){var and__6397__auto__ = rule;
if(cljs.core.truth_(and__6397__auto__)){
return word;
} else {
return and__6397__auto__;
}
})())){
var pattern = new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(rule);
var replacement = new cljs.core.Keyword(null,"replacement","replacement",-1836238839).cljs$core$IFn$_invoke$arity$1(rule);
if(cljs.core.truth_(cljs.core.re_find.call(null,pattern,word))){
return clojure.string.replace.call(null,word,pattern,replacement);
} else {
return null;
}
} else {
return null;
}
});
inflections.core.resolve_rules = (function inflections$core$resolve_rules(rules,word){
return cljs.core.first.call(null,cljs.core.keep.call(null,(function (p1__20039_SHARP_){
return inflections.core.resolve_rule.call(null,p1__20039_SHARP_,word);
}),rules));
});
/**
 * Resets the list of plural rules.
 */
inflections.core.reset_rules_BANG_ = (function inflections$core$reset_rules_BANG_(rules){
return cljs.core.reset_BANG_.call(null,rules,cljs.core.PersistentVector.EMPTY);
});
/**
 * Same as `clojure.core/name`, but keeps the namespace for keywords
 *   and symbols.
 */
inflections.core.str_name = (function inflections$core$str_name(x){
if((x == null)){
return x;
} else {
if(typeof x === 'string'){
return x;
} else {
if(((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol))){
var temp__4655__auto__ = cljs.core.namespace.call(null,x);
if(cljs.core.truth_(temp__4655__auto__)){
var ns = temp__4655__auto__;
return [cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(cljs.core.name.call(null,x))].join('');
} else {
return cljs.core.name.call(null,x);
}
} else {
return null;
}
}
}
});
inflections.core._STAR_uncountable_words_STAR_ = cljs.core.atom.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 81, ["gossip",null,"sadness",null,"space",null,"happiness",null,"blood",null,"silver",null,"cotton",null,"species",null,"mist",null,"paper",null,"education",null,"wine",null,"up",null,"food",null,"sugar",null,"gold",null,"literature",null,"pork",null,"lightning",null,"sheep",null,"shopping",null,"fresh",null,"news",null,"pepper",null,"experience",null,"milk",null,"honey",null,"oxygen",null,"fiction",null,"luck",null,"vinegar",null,"coffee",null,"ground",null,"peanut",null,"confusion",null,"tennis",null,"power",null,"meat",null,"butter",null,"music",null,"luggage",null,"love",null,"grass",null,"knowledge",null,"time",null,"cheese",null,"jam",null,"thunder",null,"electricity",null,"gum",null,"sunshine",null,"history",null,"snow",null,"money",null,"wool",null,"rice",null,"series",null,"liquid",null,"equipment",null,"pressure",null,"oil",null,"information",null,"steam",null,"chewing",null,"petrol",null,"research",null,"patience",null,"toothpaste",null,"speed",null,"entertainment",null,"wood",null,"tea",null,"art",null,"washing",null,"forgiveness",null,"traffic",null,"alcohol",null,"ice",null,"homework",null,"fish",null,"air",null], null), null));
inflections.core._STAR_acronyms_STAR_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, ["hst","HST","nasa","NASA"], null));
/**
 * Returns the the acronym for `s` if it is one, otherwise nil.
 */
inflections.core.acronym = (function inflections$core$acronym(s){
if(cljs.core.truth_(s)){
var G__20041 = inflections.core.str_name.call(null,s);
var G__20041__$1 = (((G__20041 == null))?null:clojure.string.lower_case.call(null,G__20041));
var G__20041__$2 = (((G__20041__$1 == null))?null:cljs.core.get.call(null,cljs.core.deref.call(null,inflections.core._STAR_acronyms_STAR_),G__20041__$1));
if((G__20041__$2 == null)){
return null;
} else {
return inflections.core.coerce.call(null,s,G__20041__$2);
}
} else {
return null;
}
});
/**
 * Adds `word` to the set of `*acronyms*`.
 */
inflections.core.add_acronym_BANG_ = (function inflections$core$add_acronym_BANG_(word){
return cljs.core.swap_BANG_.call(null,inflections.core._STAR_acronyms_STAR_,cljs.core.assoc,clojure.string.lower_case.call(null,inflections.core.str_name.call(null,word)),inflections.core.str_name.call(null,word));
});
/**
 * Delete `word` from the set of `*acronyms*`.
 */
inflections.core.delete_acronym_BANG_ = (function inflections$core$delete_acronym_BANG_(word){
return cljs.core.swap_BANG_.call(null,inflections.core._STAR_acronyms_STAR_,cljs.core.dissoc,clojure.string.lower_case.call(null,inflections.core.str_name.call(null,word)));
});
/**
 * Returns true if `s` is countable, otherwise false.
 */
inflections.core.countable_QMARK_ = (function inflections$core$countable_QMARK_(s){
if(cljs.core.truth_(s)){
return !(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,inflections.core._STAR_uncountable_words_STAR_),clojure.string.lower_case.call(null,inflections.core.str_name.call(null,s))));
} else {
return null;
}
});
/**
 * Returns true if `x` is uncountable, otherwise false.
 */
inflections.core.uncountable_QMARK_ = (function inflections$core$uncountable_QMARK_(x){
if(cljs.core.truth_(x)){
return cljs.core.not.call(null,inflections.core.countable_QMARK_.call(null,x));
} else {
return null;
}
});
/**
 * Adds `word` to the set of `*uncountable-words*`.
 */
inflections.core.add_uncountable_BANG_ = (function inflections$core$add_uncountable_BANG_(word){
return cljs.core.swap_BANG_.call(null,inflections.core._STAR_uncountable_words_STAR_,cljs.core.conj,clojure.string.lower_case.call(null,inflections.core.str_name.call(null,word)));
});
/**
 * Delete `word` from the set of `*uncountable-words*`.
 */
inflections.core.delete_uncountable_BANG_ = (function inflections$core$delete_uncountable_BANG_(word){
return cljs.core.swap_BANG_.call(null,inflections.core._STAR_uncountable_words_STAR_,cljs.core.disj,clojure.string.lower_case.call(null,inflections.core.str_name.call(null,word)));
});
inflections.core._STAR_plural_rules_STAR_ = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
/**
 * Returns the plural of s.
 */
inflections.core.plural = (function inflections$core$plural(s){
var s__$1 = inflections.core.str_name.call(null,s);
if(cljs.core.truth_((function (){var or__6409__auto__ = clojure.string.blank_QMARK_.call(null,s__$1);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return inflections.core.uncountable_QMARK_.call(null,s__$1);
}
})())){
return s__$1;
} else {
return inflections.core.resolve_rules.call(null,cljs.core.rseq.call(null,cljs.core.deref.call(null,inflections.core._STAR_plural_rules_STAR_)),s__$1);
}
});
/**
 * Define rule(s) to map words from singular to plural.
 * 
 *   Examples: (plural! #"$(?i)" "s")
 *          (plural! #"(ax|test)is$(?i)" "$1es"
 *                   #"(octop|vir)us$(?i)" "$1i")
 */
inflections.core.plural_BANG_ = (function inflections$core$plural_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20047 = arguments.length;
var i__7485__auto___20048 = (0);
while(true){
if((i__7485__auto___20048 < len__7484__auto___20047)){
args__7491__auto__.push((arguments[i__7485__auto___20048]));

var G__20049 = (i__7485__auto___20048 + (1));
i__7485__auto___20048 = G__20049;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
var seq__20043 = cljs.core.seq.call(null,cljs.core.apply.call(null,inflections.core.slurp_rules,patterns_and_replacements));
var chunk__20044 = null;
var count__20045 = (0);
var i__20046 = (0);
while(true){
if((i__20046 < count__20045)){
var rule = cljs.core._nth.call(null,chunk__20044,i__20046);
inflections.core.add_rule_BANG_.call(null,inflections.core._STAR_plural_rules_STAR_,rule);

var G__20050 = seq__20043;
var G__20051 = chunk__20044;
var G__20052 = count__20045;
var G__20053 = (i__20046 + (1));
seq__20043 = G__20050;
chunk__20044 = G__20051;
count__20045 = G__20052;
i__20046 = G__20053;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__20043);
if(temp__4657__auto__){
var seq__20043__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20043__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__20043__$1);
var G__20054 = cljs.core.chunk_rest.call(null,seq__20043__$1);
var G__20055 = c__7220__auto__;
var G__20056 = cljs.core.count.call(null,c__7220__auto__);
var G__20057 = (0);
seq__20043 = G__20054;
chunk__20044 = G__20055;
count__20045 = G__20056;
i__20046 = G__20057;
continue;
} else {
var rule = cljs.core.first.call(null,seq__20043__$1);
inflections.core.add_rule_BANG_.call(null,inflections.core._STAR_plural_rules_STAR_,rule);

var G__20058 = cljs.core.next.call(null,seq__20043__$1);
var G__20059 = null;
var G__20060 = (0);
var G__20061 = (0);
seq__20043 = G__20058;
chunk__20044 = G__20059;
count__20045 = G__20060;
i__20046 = G__20061;
continue;
}
} else {
return null;
}
}
break;
}
});

inflections.core.plural_BANG_.cljs$lang$maxFixedArity = (0);

inflections.core.plural_BANG_.cljs$lang$applyTo = (function (seq20042){
return inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20042));
});

inflections.core.init_plural_rules_BANG_ = (function inflections$core$init_plural_rules_BANG_(){
return inflections.core.plural_BANG_.call(null,/$/i,"s",/s$/i,"s",/(ax|test)is$/i,"$1es",/(octop|vir)us$/i,"$1i",/(alias|status)$/i,"$1es",/(bu)s$/i,"$1ses",/(buffal|tomat)o$/i,"$1oes",/([ti])um$/i,"$1a",/sis$/i,"ses",/(?:([^f])fe|([lr])f)$/i,"$1$2ves",/(hive)$/i,"$1s",/([^aeiouy]|qu)y$/i,"$1ies",/(x|ch|ss|sh)$/i,"$1es",/(matr|vert|ind)(?:ix|ex)$/i,"$1ices",/([m|l])ouse$/i,"$1ice",/^(ox)$/i,"$1en",/(quiz)$/i,"$1zes");
});
inflections.core._STAR_singular_rules_STAR_ = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
/**
 * Returns the singular of s.
 */
inflections.core.singular = (function inflections$core$singular(s){
var s_SINGLEQUOTE_ = inflections.core.str_name.call(null,s);
if(cljs.core.not.call(null,inflections.core.uncountable_QMARK_.call(null,s_SINGLEQUOTE_))){
return inflections.core.coerce.call(null,s,(function (){var or__6409__auto__ = inflections.core.resolve_rules.call(null,cljs.core.rseq.call(null,cljs.core.deref.call(null,inflections.core._STAR_singular_rules_STAR_)),s_SINGLEQUOTE_);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return s_SINGLEQUOTE_;
}
})());
} else {
return s;
}
});
/**
 * Define rule(s) to map words from singular to plural.
 * 
 *   Examples: (singular! #"(n)ews$(?i)" "$1ews")
 *          (singular! #"(m)ovies$(?i)" "$1ovie"
 *                     #"([m|l])ice$(?i)" "$1ouse")
 */
inflections.core.singular_BANG_ = (function inflections$core$singular_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20067 = arguments.length;
var i__7485__auto___20068 = (0);
while(true){
if((i__7485__auto___20068 < len__7484__auto___20067)){
args__7491__auto__.push((arguments[i__7485__auto___20068]));

var G__20069 = (i__7485__auto___20068 + (1));
i__7485__auto___20068 = G__20069;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
var seq__20063 = cljs.core.seq.call(null,cljs.core.apply.call(null,inflections.core.slurp_rules,patterns_and_replacements));
var chunk__20064 = null;
var count__20065 = (0);
var i__20066 = (0);
while(true){
if((i__20066 < count__20065)){
var rule = cljs.core._nth.call(null,chunk__20064,i__20066);
inflections.core.add_rule_BANG_.call(null,inflections.core._STAR_singular_rules_STAR_,rule);

var G__20070 = seq__20063;
var G__20071 = chunk__20064;
var G__20072 = count__20065;
var G__20073 = (i__20066 + (1));
seq__20063 = G__20070;
chunk__20064 = G__20071;
count__20065 = G__20072;
i__20066 = G__20073;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__20063);
if(temp__4657__auto__){
var seq__20063__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20063__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__20063__$1);
var G__20074 = cljs.core.chunk_rest.call(null,seq__20063__$1);
var G__20075 = c__7220__auto__;
var G__20076 = cljs.core.count.call(null,c__7220__auto__);
var G__20077 = (0);
seq__20063 = G__20074;
chunk__20064 = G__20075;
count__20065 = G__20076;
i__20066 = G__20077;
continue;
} else {
var rule = cljs.core.first.call(null,seq__20063__$1);
inflections.core.add_rule_BANG_.call(null,inflections.core._STAR_singular_rules_STAR_,rule);

var G__20078 = cljs.core.next.call(null,seq__20063__$1);
var G__20079 = null;
var G__20080 = (0);
var G__20081 = (0);
seq__20063 = G__20078;
chunk__20064 = G__20079;
count__20065 = G__20080;
i__20066 = G__20081;
continue;
}
} else {
return null;
}
}
break;
}
});

inflections.core.singular_BANG_.cljs$lang$maxFixedArity = (0);

inflections.core.singular_BANG_.cljs$lang$applyTo = (function (seq20062){
return inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20062));
});

inflections.core.init_singular_rules_BANG_ = (function inflections$core$init_singular_rules_BANG_(){
return inflections.core.singular_BANG_.call(null,/s$/i,"",/(ss)$/i,"$1",/(n)ews$/i,"$1ews",/([ti])a$/i,"$1um",/((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)(sis|ses)$/i,"$1$2sis",/(^analy)(sis|ses)$/i,"$1sis",/([^f])ves$/i,"$1fe",/(hive)s$/i,"$1",/(tive)s$/i,"$1",/([lr])ves$/i,"$1f",/([^aeiouy]|qu)ies$/i,"$1y",/(s)eries$/i,"$1eries",/(m)ovies$/i,"$1ovie",/(x|ch|ss|sh)es$/i,"$1",/([m|l])ice$/i,"$1ouse",/(bus)(es)?$/i,"$1",/(o)es$/i,"$1",/(shoe)s$/i,"$1",/(cris|ax|test)(is|es)$/i,"$1is",/(octop|vir)(us|i)$/i,"$1us",/(alias|status)(es)?$/i,"$1",/^(ox)en/i,"$1",/(vert|ind)ices$/i,"$1ex",/(matr)ices$/i,"$1ix",/(quiz)zes$/i,"$1",/(database)s$/i,"$1");
});
inflections.core._STAR_irregular_words_STAR_ = cljs.core.atom.call(null,cljs.core.sorted_set.call(null));
/**
 * Returns true if `word` is an irregular word, otherwise false.
 */
inflections.core.irregular_QMARK_ = (function inflections$core$irregular_QMARK_(word){
if(cljs.core.truth_(word)){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,inflections.core._STAR_irregular_words_STAR_),clojure.string.lower_case.call(null,inflections.core.str_name.call(null,word)));
} else {
return null;
}
});
/**
 * Add `singular` and `plural` to the set of `*irregular-words*`.
 */
inflections.core.add_irregular_BANG_ = (function inflections$core$add_irregular_BANG_(singular,plural){
var singular__$1 = clojure.string.lower_case.call(null,inflections.core.str_name.call(null,singular));
var plural__$1 = clojure.string.lower_case.call(null,inflections.core.str_name.call(null,plural));
inflections.core.delete_uncountable_BANG_.call(null,singular__$1);

inflections.core.delete_uncountable_BANG_.call(null,plural__$1);

inflections.core.singular_BANG_.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("^"),cljs.core.str(plural__$1),cljs.core.str("$")].join('')),singular__$1);

inflections.core.plural_BANG_.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("^"),cljs.core.str(singular__$1),cljs.core.str("$")].join('')),plural__$1);

cljs.core.swap_BANG_.call(null,inflections.core._STAR_irregular_words_STAR_,cljs.core.conj,singular__$1);

return cljs.core.swap_BANG_.call(null,inflections.core._STAR_irregular_words_STAR_,cljs.core.conj,plural__$1);
});
/**
 * Delete `singular` and `plural` from the set of *irregular-words*.
 */
inflections.core.delete_irregular_BANG_ = (function inflections$core$delete_irregular_BANG_(singular,plural){
var singular__$1 = clojure.string.lower_case.call(null,inflections.core.str_name.call(null,singular));
var plural__$1 = clojure.string.lower_case.call(null,inflections.core.str_name.call(null,plural));
cljs.core.swap_BANG_.call(null,inflections.core._STAR_irregular_words_STAR_,cljs.core.disj,singular__$1);

return cljs.core.swap_BANG_.call(null,inflections.core._STAR_irregular_words_STAR_,cljs.core.disj,plural__$1);
});
inflections.core.init_irregular_words_BANG_ = (function inflections$core$init_irregular_words_BANG_(){
return cljs.core.doall.call(null,cljs.core.map.call(null,(function (p1__20082_SHARP_){
return inflections.core.add_irregular_BANG_.call(null,cljs.core.first.call(null,p1__20082_SHARP_),cljs.core.second.call(null,p1__20082_SHARP_));
}),new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["amenity","amenities"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["child","children"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["cow","kine"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["foot","feet"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["louse","lice"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["mailman","mailmen"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["man","men"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["mouse","mice"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["move","moves"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ox","oxen"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["person","people"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["sex","sexes"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tooth","teeth"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["woman","women"], null)], null)));
});
/**
 * Convert `word` to camel case. By default, camel-case converts to
 *   UpperCamelCase. If the argument to camel-case is set to :lower then
 *   camel-case produces lowerCamelCase. The camel-case fn will also
 *   convert "/" to "::" which is useful for converting paths to
 *   namespaces.
 * 
 *   Examples:
 * 
 *  (camel-case "active_record")
 *  ;=> "ActiveRecord"
 * 
 *  (camel-case "active_record" :lower)
 *  ;=> "activeRecord"
 * 
 *  (camel-case "active_record/errors")
 *  ;=> "ActiveRecord::Errors"
 * 
 *  (camel-case "active_record/errors" :lower)
 *  ;=> "activeRecord::Errors"
 */
inflections.core.camel_case = (function inflections$core$camel_case(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20095 = arguments.length;
var i__7485__auto___20096 = (0);
while(true){
if((i__7485__auto___20096 < len__7484__auto___20095)){
args__7491__auto__.push((arguments[i__7485__auto___20096]));

var G__20097 = (i__7485__auto___20096 + (1));
i__7485__auto___20096 = G__20097;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic = (function (word,p__20088){
var vec__20089 = p__20088;
var mode = cljs.core.nth.call(null,vec__20089,(0),null);
if(cljs.core.truth_(word)){
return inflections.core.coerce.call(null,word,(function (){var word__$1 = inflections.core.str_name.call(null,word);
if(cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"lower","lower",1120320821))){
return inflections.core.camel_case.call(null,word__$1,clojure.string.lower_case);
} else {
if(cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"upper","upper",246243906))){
return inflections.core.camel_case.call(null,word__$1,clojure.string.upper_case);
} else {
if(cljs.core.fn_QMARK_.call(null,mode)){
return [cljs.core.str(mode.call(null,[cljs.core.str(cljs.core.first.call(null,word__$1))].join(''))),cljs.core.str(cljs.core.apply.call(null,cljs.core.str,cljs.core.rest.call(null,inflections.core.camel_case.call(null,word__$1,null))))].join('');
} else {
return clojure.string.replace.call(null,clojure.string.replace.call(null,word__$1,/\/(.?)/,((function (word__$1,vec__20089,mode){
return (function (p1__20083_SHARP_){
return [cljs.core.str("::"),cljs.core.str(clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__20083_SHARP_,(1))))].join('');
});})(word__$1,vec__20089,mode))
),/(^|_|-)(.)/,((function (word__$1,vec__20089,mode){
return (function (p1__20085_SHARP_){
var vec__20092 = p1__20085_SHARP_;
var _ = cljs.core.nth.call(null,vec__20092,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__20092,(1),null);
var letter_to_uppercase = cljs.core.nth.call(null,vec__20092,(2),null);
return clojure.string.upper_case.call(null,letter_to_uppercase);
});})(word__$1,vec__20089,mode))
);

}
}
}
})());
} else {
return null;
}
});

inflections.core.camel_case.cljs$lang$maxFixedArity = (1);

inflections.core.camel_case.cljs$lang$applyTo = (function (seq20086){
var G__20087 = cljs.core.first.call(null,seq20086);
var seq20086__$1 = cljs.core.next.call(null,seq20086);
return inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic(G__20087,seq20086__$1);
});

/**
 * Convert the first letter in `word` to upper case.
 * 
 *   Examples:
 * 
 *  (capitalize "hello")
 *  ;=> "Hello"
 * 
 *  (capitalize "HELLO")
 *  ;=> "Hello"
 * 
 *  (capitalize "abc123")
 *  ;=> "Abc123"
 */
inflections.core.capitalize = (function inflections$core$capitalize(word){
if(cljs.core.truth_(word)){
var temp__4655__auto__ = inflections.core.acronym.call(null,word);
if(cljs.core.truth_(temp__4655__auto__)){
var acronym = temp__4655__auto__;
return acronym;
} else {
var word_SINGLEQUOTE_ = inflections.core.str_name.call(null,word);
return inflections.core.coerce.call(null,word,[cljs.core.str(clojure.string.upper_case.call(null,[cljs.core.str(cljs.core.first.call(null,word_SINGLEQUOTE_))].join(''))),cljs.core.str(((cljs.core.next.call(null,word_SINGLEQUOTE_))?clojure.string.lower_case.call(null,cljs.core.subs.call(null,word_SINGLEQUOTE_,(1))):null))].join(''));
}
} else {
return null;
}
});
/**
 * Convert `s` into a title.
 */
inflections.core.titleize = (function inflections$core$titleize(s){
if(cljs.core.truth_(s)){
return clojure.string.join.call(null," ",cljs.core.map.call(null,inflections.core.capitalize,clojure.string.split.call(null,inflections.core.str_name.call(null,s),/[-_.\/ ]/)));
} else {
return null;
}
});
/**
 * Replaces all underscores in `s` with dashes.
 * 
 *   Examples:
 * 
 *  (dasherize "puni_puni")
 *  ;=> "puni-puni"
 */
inflections.core.dasherize = (function inflections$core$dasherize(s){
if(cljs.core.truth_(s)){
return inflections.core.coerce.call(null,s,clojure.string.replace.call(null,inflections.core.str_name.call(null,s),/_/,"-"));
} else {
return null;
}
});
/**
 * Removes the module part from `x`.
 * 
 *   Examples:
 * 
 *  (demodulize "inflections.MyRecord")
 *  ;=> "MyRecord"
 * 
 *  (demodulize "ActiveRecord::CoreExtensions::String::Inflections")
 *  ;=> "Inflections"
 * 
 *  (demodulize "Inflections")
 *  ;=> "Inflections"
 */
inflections.core.demodulize = (function inflections$core$demodulize(x){
if(cljs.core.truth_(x)){
return inflections.core.coerce.call(null,x,clojure.string.replace.call(null,inflections.core.str_name.call(null,x),/^.*(::|\.)/,""));
} else {
return null;
}
});
/**
 * Hyphenate x, which is the same as threading `x` through the str,
 *   underscore and dasherize fns.
 * 
 *   Examples:
 * 
 *  (hyphenate 'Continent)
 *  ; => "continent"
 * 
 *  (hyphenate "CountryFlag")
 *  ; => "country-flag"
 */
inflections.core.hyphenate = (function inflections$core$hyphenate(x){
if(cljs.core.truth_(x)){
return inflections.core.coerce.call(null,x,clojure.string.lower_case.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,inflections.core.str_name.call(null,x),/::/,"/"),/([A-Z]+)([A-Z][a-z])/,"$1-$2"),/([a-z\d])([A-Z])/,"$1-$2"),/\s+/,"-"),/_/,"-")));
} else {
return null;
}
});
/**
 * Turns `x` into an ordinal string used to denote the position in an
 *   ordered sequence such as 1st, 2nd, 3rd, 4th, etc.
 * 
 *   Examples:
 * 
 *  (ordinalize "1")
 *  ;=> "1st"
 * 
 *  (ordinalize "23")
 *  ;=> "23rd"
 */
inflections.core.ordinalize = (function inflections$core$ordinalize(x){
var temp__4655__auto__ = no.en.core.parse_integer.call(null,x);
if(cljs.core.truth_(temp__4655__auto__)){
var number = temp__4655__auto__;
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,cljs.core.range.call(null,(11),(14))),cljs.core.mod.call(null,number,(100)))){
return [cljs.core.str(number),cljs.core.str("th")].join('');
} else {
var modulus = cljs.core.mod.call(null,number,(10));
if(cljs.core._EQ_.call(null,modulus,(1))){
return [cljs.core.str(number),cljs.core.str("st")].join('');
} else {
if(cljs.core._EQ_.call(null,modulus,(2))){
return [cljs.core.str(number),cljs.core.str("nd")].join('');
} else {
if(cljs.core._EQ_.call(null,modulus,(3))){
return [cljs.core.str(number),cljs.core.str("rd")].join('');
} else {
return [cljs.core.str(number),cljs.core.str("th")].join('');

}
}
}
}
} else {
return null;
}
});
/**
 * Replaces special characters in `x` with the default separator
 *   "-". so that it may be used as part of a pretty URL.
 * 
 *   Examples:
 * 
 *  (parameterize "Donald E. Knuth")
 *  ; => "donald-e-knuth"
 * 
 *  (parameterize "Donald E. Knuth" "_")
 *  ; => "donald_e_knuth"
 */
inflections.core.parameterize = (function inflections$core$parameterize(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20104 = arguments.length;
var i__7485__auto___20105 = (0);
while(true){
if((i__7485__auto___20105 < len__7484__auto___20104)){
args__7491__auto__.push((arguments[i__7485__auto___20105]));

var G__20106 = (i__7485__auto___20105 + (1));
i__7485__auto___20105 = G__20106;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return inflections.core.parameterize.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

inflections.core.parameterize.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__20100){
var vec__20101 = p__20100;
var sep = cljs.core.nth.call(null,vec__20101,(0),null);
if(cljs.core.truth_(x)){
var sep__$1 = (function (){var or__6409__auto__ = sep;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return "-";
}
})();
return clojure.string.lower_case.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,inflections.core.str_name.call(null,x),/[^A-Za-z0-9]+/,sep__$1),/\++/,sep__$1),cljs.core.re_pattern.call(null,[cljs.core.str(sep__$1),cljs.core.str("{2,}")].join('')),sep__$1),cljs.core.re_pattern.call(null,[cljs.core.str("(?i)(^"),cljs.core.str(sep__$1),cljs.core.str(")|("),cljs.core.str(sep__$1),cljs.core.str("$)")].join('')),""));
} else {
return null;
}
});

inflections.core.parameterize.cljs$lang$maxFixedArity = (1);

inflections.core.parameterize.cljs$lang$applyTo = (function (seq20098){
var G__20099 = cljs.core.first.call(null,seq20098);
var seq20098__$1 = cljs.core.next.call(null,seq20098);
return inflections.core.parameterize.cljs$core$IFn$_invoke$arity$variadic(G__20099,seq20098__$1);
});

/**
 * Attempts to pluralize the word unless count is 1. If plural is
 *   supplied, it will use that when count is > 1, otherwise it will use
 *   the inflector to determine the plural form.
 */
inflections.core.pluralize = (function inflections$core$pluralize(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20114 = arguments.length;
var i__7485__auto___20115 = (0);
while(true){
if((i__7485__auto___20115 < len__7484__auto___20114)){
args__7491__auto__.push((arguments[i__7485__auto___20115]));

var G__20116 = (i__7485__auto___20115 + (1));
i__7485__auto___20115 = G__20116;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return inflections.core.pluralize.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

inflections.core.pluralize.cljs$core$IFn$_invoke$arity$variadic = (function (count,singular,p__20110){
var vec__20111 = p__20110;
var plural = cljs.core.nth.call(null,vec__20111,(0),null);
return [cljs.core.str(count),cljs.core.str(" "),cljs.core.str(((cljs.core._EQ_.call(null,(1),count))?singular:(function (){var or__6409__auto__ = plural;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return inflections.core.plural.call(null,singular);
}
})()))].join('');
});

inflections.core.pluralize.cljs$lang$maxFixedArity = (2);

inflections.core.pluralize.cljs$lang$applyTo = (function (seq20107){
var G__20108 = cljs.core.first.call(null,seq20107);
var seq20107__$1 = cljs.core.next.call(null,seq20107);
var G__20109 = cljs.core.first.call(null,seq20107__$1);
var seq20107__$2 = cljs.core.next.call(null,seq20107__$1);
return inflections.core.pluralize.cljs$core$IFn$_invoke$arity$variadic(G__20108,G__20109,seq20107__$2);
});

/**
 * The reverse of camel-case. Makes an underscored, lowercase form from
 *   the expression in the string. Changes "::" to "/" to convert
 *   namespaces to paths.
 * 
 *   Examples:
 * 
 *  (underscore "ActiveRecord")
 *  ;=> "active_record"
 * 
 *  (underscore "ActiveRecord::Errors")
 *  ;=> "active_record/errors"
 */
inflections.core.underscore = (function inflections$core$underscore(x){
if(cljs.core.truth_(x)){
return inflections.core.coerce.call(null,x,clojure.string.lower_case.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,inflections.core.str_name.call(null,x),/::/,"/"),/([A-Z\d]+)([A-Z][a-z])/,"$1_$2"),/([a-z\d])([A-Z])/,"$1_$2"),/-/,"_")));
} else {
return null;
}
});
/**
 * Converts `x` into a foreign key. The default separator "_" is
 *   placed between the name and "id".
 * 
 * 
 *   Examples:
 * 
 *  (foreign-key "Message")
 *  ;=> "message_id"
 * 
 *  (foreign-key "Message" false)
 *  ;=> "messageid"
 * 
 *  (foreign-key "Admin::Post")
 *  ;=> "post_id"
 */
inflections.core.foreign_key = (function inflections$core$foreign_key(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20123 = arguments.length;
var i__7485__auto___20124 = (0);
while(true){
if((i__7485__auto___20124 < len__7484__auto___20123)){
args__7491__auto__.push((arguments[i__7485__auto___20124]));

var G__20125 = (i__7485__auto___20124 + (1));
i__7485__auto___20124 = G__20125;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return inflections.core.foreign_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

inflections.core.foreign_key.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__20119){
var vec__20120 = p__20119;
var sep = cljs.core.nth.call(null,vec__20120,(0),null);
var x_SINGLEQUOTE_ = inflections.core.str_name.call(null,x);
if(clojure.string.blank_QMARK_.call(null,x_SINGLEQUOTE_)){
return null;
} else {
return inflections.core.coerce.call(null,x,[cljs.core.str(inflections.core.underscore.call(null,inflections.core.hyphenate.call(null,inflections.core.singular.call(null,inflections.core.demodulize.call(null,x_SINGLEQUOTE_))))),cljs.core.str((function (){var or__6409__auto__ = sep;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return "_";
}
})()),cljs.core.str("id")].join(''));
}
});

inflections.core.foreign_key.cljs$lang$maxFixedArity = (1);

inflections.core.foreign_key.cljs$lang$applyTo = (function (seq20117){
var G__20118 = cljs.core.first.call(null,seq20117);
var seq20117__$1 = cljs.core.next.call(null,seq20117);
return inflections.core.foreign_key.cljs$core$IFn$_invoke$arity$variadic(G__20118,seq20117__$1);
});

/**
 * Recursively transform all keys in the map `m` by applying `f` on them.
 */
inflections.core.transform_keys = (function inflections$core$transform_keys(m,f){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (memo,key){
var value = cljs.core.get.call(null,m,key);
return cljs.core.assoc.call(null,cljs.core.dissoc.call(null,memo,key),f.call(null,key),((cljs.core.map_QMARK_.call(null,value))?inflections$core$transform_keys.call(null,value,f):((cljs.core.sequential_QMARK_.call(null,value))?cljs.core.map.call(null,((function (value){
return (function (p1__20126_SHARP_){
return inflections$core$transform_keys.call(null,p1__20126_SHARP_,f);
});})(value))
,value):value
)));
}),m,cljs.core.keys.call(null,m));
} else {
return m;
}
});
/**
 * Recursively transform all map values of m by applying f on them.
 */
inflections.core.transform_values = (function inflections$core$transform_values(m,f){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (memo,key){
var value = cljs.core.get.call(null,m,key);
return cljs.core.assoc.call(null,memo,key,((cljs.core.map_QMARK_.call(null,value))?inflections$core$transform_values.call(null,value,f):f.call(null,value)));
}),m,cljs.core.keys.call(null,m));
} else {
return m;
}
});
/**
 * Recursively apply camel-case on all keys of m.
 */
inflections.core.camel_case_keys = (function inflections$core$camel_case_keys(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20134 = arguments.length;
var i__7485__auto___20135 = (0);
while(true){
if((i__7485__auto___20135 < len__7484__auto___20134)){
args__7491__auto__.push((arguments[i__7485__auto___20135]));

var G__20136 = (i__7485__auto___20135 + (1));
i__7485__auto___20135 = G__20136;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return inflections.core.camel_case_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

inflections.core.camel_case_keys.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__20130){
var vec__20131 = p__20130;
var mode = cljs.core.nth.call(null,vec__20131,(0),null);
return clojure.walk.keywordize_keys.call(null,inflections.core.transform_keys.call(null,m,((function (vec__20131,mode){
return (function (p1__20127_SHARP_){
return inflections.core.camel_case.call(null,p1__20127_SHARP_,mode);
});})(vec__20131,mode))
));
});

inflections.core.camel_case_keys.cljs$lang$maxFixedArity = (1);

inflections.core.camel_case_keys.cljs$lang$applyTo = (function (seq20128){
var G__20129 = cljs.core.first.call(null,seq20128);
var seq20128__$1 = cljs.core.next.call(null,seq20128);
return inflections.core.camel_case_keys.cljs$core$IFn$_invoke$arity$variadic(G__20129,seq20128__$1);
});

/**
 * Recursively apply hyphenate on all keys of m.
 */
inflections.core.hyphenate_keys = (function inflections$core$hyphenate_keys(m){
return inflections.core.transform_keys.call(null,m,inflections.core.hyphenate);
});
/**
 * Recursively apply hyphenate on all values of m.
 */
inflections.core.hyphenate_values = (function inflections$core$hyphenate_values(m){
return inflections.core.transform_values.call(null,m,inflections.core.hyphenate);
});
/**
 * Recursively transform all keys of m into strings.
 */
inflections.core.stringify_keys = (function inflections$core$stringify_keys(m){
return inflections.core.transform_keys.call(null,m,(function (p1__20137_SHARP_){
if((p1__20137_SHARP_ instanceof cljs.core.Keyword)){
return inflections.core.str_name.call(null,p1__20137_SHARP_);
} else {
return [cljs.core.str(p1__20137_SHARP_)].join('');
}
}));
});
/**
 * Recursively transform all values of m into strings.
 */
inflections.core.stringify_values = (function inflections$core$stringify_values(m){
return inflections.core.transform_values.call(null,m,(function (p1__20138_SHARP_){
if((p1__20138_SHARP_ instanceof cljs.core.Keyword)){
return inflections.core.str_name.call(null,p1__20138_SHARP_);
} else {
return [cljs.core.str(p1__20138_SHARP_)].join('');
}
}));
});
/**
 * Recursively apply underscore on all keys of m.
 */
inflections.core.underscore_keys = (function inflections$core$underscore_keys(m){
return inflections.core.transform_keys.call(null,m,inflections.core.underscore);
});
/**
 * Initialize the Inflections library with defaults.
 */
inflections.core.init_inflections_BANG_ = (function inflections$core$init_inflections_BANG_(){
inflections.core.init_plural_rules_BANG_.call(null);

inflections.core.init_singular_rules_BANG_.call(null);

return inflections.core.init_irregular_words_BANG_.call(null);
});
inflections.core.init_inflections_BANG_.call(null);
