// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args31186 = [];
var len__7484__auto___31192 = arguments.length;
var i__7485__auto___31193 = (0);
while(true){
if((i__7485__auto___31193 < len__7484__auto___31192)){
args31186.push((arguments[i__7485__auto___31193]));

var G__31194 = (i__7485__auto___31193 + (1));
i__7485__auto___31193 = G__31194;
continue;
} else {
}
break;
}

var G__31188 = args31186.length;
switch (G__31188) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31186.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async31189 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31189 = (function (f,blockable,meta31190){
this.f = f;
this.blockable = blockable;
this.meta31190 = meta31190;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31189.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31191,meta31190__$1){
var self__ = this;
var _31191__$1 = this;
return (new cljs.core.async.t_cljs$core$async31189(self__.f,self__.blockable,meta31190__$1));
});

cljs.core.async.t_cljs$core$async31189.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31191){
var self__ = this;
var _31191__$1 = this;
return self__.meta31190;
});

cljs.core.async.t_cljs$core$async31189.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31189.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31189.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31189.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31189.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta31190], null);
});

cljs.core.async.t_cljs$core$async31189.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31189.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31189";

cljs.core.async.t_cljs$core$async31189.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31189");
});

cljs.core.async.__GT_t_cljs$core$async31189 = (function cljs$core$async$__GT_t_cljs$core$async31189(f__$1,blockable__$1,meta31190){
return (new cljs.core.async.t_cljs$core$async31189(f__$1,blockable__$1,meta31190));
});

}

return (new cljs.core.async.t_cljs$core$async31189(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args31198 = [];
var len__7484__auto___31201 = arguments.length;
var i__7485__auto___31202 = (0);
while(true){
if((i__7485__auto___31202 < len__7484__auto___31201)){
args31198.push((arguments[i__7485__auto___31202]));

var G__31203 = (i__7485__auto___31202 + (1));
i__7485__auto___31202 = G__31203;
continue;
} else {
}
break;
}

var G__31200 = args31198.length;
switch (G__31200) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31198.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args31205 = [];
var len__7484__auto___31208 = arguments.length;
var i__7485__auto___31209 = (0);
while(true){
if((i__7485__auto___31209 < len__7484__auto___31208)){
args31205.push((arguments[i__7485__auto___31209]));

var G__31210 = (i__7485__auto___31209 + (1));
i__7485__auto___31209 = G__31210;
continue;
} else {
}
break;
}

var G__31207 = args31205.length;
switch (G__31207) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31205.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args31212 = [];
var len__7484__auto___31215 = arguments.length;
var i__7485__auto___31216 = (0);
while(true){
if((i__7485__auto___31216 < len__7484__auto___31215)){
args31212.push((arguments[i__7485__auto___31216]));

var G__31217 = (i__7485__auto___31216 + (1));
i__7485__auto___31216 = G__31217;
continue;
} else {
}
break;
}

var G__31214 = args31212.length;
switch (G__31214) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31212.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_31219 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31219) : fn1.call(null,val_31219));
} else {
cljs.core.async.impl.dispatch.run(((function (val_31219,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31219) : fn1.call(null,val_31219));
});})(val_31219,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args31220 = [];
var len__7484__auto___31223 = arguments.length;
var i__7485__auto___31224 = (0);
while(true){
if((i__7485__auto___31224 < len__7484__auto___31223)){
args31220.push((arguments[i__7485__auto___31224]));

var G__31225 = (i__7485__auto___31224 + (1));
i__7485__auto___31224 = G__31225;
continue;
} else {
}
break;
}

var G__31222 = args31220.length;
switch (G__31222) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31220.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___31227 = n;
var x_31228 = (0);
while(true){
if((x_31228 < n__7324__auto___31227)){
(a[x_31228] = (0));

var G__31229 = (x_31228 + (1));
x_31228 = G__31229;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__31230 = (i + (1));
i = G__31230;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async31234 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31234 = (function (alt_flag,flag,meta31235){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta31235 = meta31235;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31234.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31236,meta31235__$1){
var self__ = this;
var _31236__$1 = this;
return (new cljs.core.async.t_cljs$core$async31234(self__.alt_flag,self__.flag,meta31235__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31234.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31236){
var self__ = this;
var _31236__$1 = this;
return self__.meta31235;
});})(flag))
;

cljs.core.async.t_cljs$core$async31234.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31234.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async31234.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31234.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31234.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta31235], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31234.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31234.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31234";

cljs.core.async.t_cljs$core$async31234.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31234");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31234 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31234(alt_flag__$1,flag__$1,meta31235){
return (new cljs.core.async.t_cljs$core$async31234(alt_flag__$1,flag__$1,meta31235));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31234(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31240 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31240 = (function (alt_handler,flag,cb,meta31241){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta31241 = meta31241;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31240.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31242,meta31241__$1){
var self__ = this;
var _31242__$1 = this;
return (new cljs.core.async.t_cljs$core$async31240(self__.alt_handler,self__.flag,self__.cb,meta31241__$1));
});

cljs.core.async.t_cljs$core$async31240.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31242){
var self__ = this;
var _31242__$1 = this;
return self__.meta31241;
});

cljs.core.async.t_cljs$core$async31240.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31240.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async31240.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31240.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31240.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta31241], null);
});

cljs.core.async.t_cljs$core$async31240.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31240.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31240";

cljs.core.async.t_cljs$core$async31240.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31240");
});

cljs.core.async.__GT_t_cljs$core$async31240 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31240(alt_handler__$1,flag__$1,cb__$1,meta31241){
return (new cljs.core.async.t_cljs$core$async31240(alt_handler__$1,flag__$1,cb__$1,meta31241));
});

}

return (new cljs.core.async.t_cljs$core$async31240(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31243_SHARP_){
var G__31247 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31243_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31247) : fret.call(null,G__31247));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31244_SHARP_){
var G__31248 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31244_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31248) : fret.call(null,G__31248));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31249 = (i + (1));
i = G__31249;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31255 = arguments.length;
var i__7485__auto___31256 = (0);
while(true){
if((i__7485__auto___31256 < len__7484__auto___31255)){
args__7491__auto__.push((arguments[i__7485__auto___31256]));

var G__31257 = (i__7485__auto___31256 + (1));
i__7485__auto___31256 = G__31257;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31252){
var map__31253 = p__31252;
var map__31253__$1 = ((((!((map__31253 == null)))?((((map__31253.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31253.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31253):map__31253);
var opts = map__31253__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31250){
var G__31251 = cljs.core.first(seq31250);
var seq31250__$1 = cljs.core.next(seq31250);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31251,seq31250__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args31258 = [];
var len__7484__auto___31308 = arguments.length;
var i__7485__auto___31309 = (0);
while(true){
if((i__7485__auto___31309 < len__7484__auto___31308)){
args31258.push((arguments[i__7485__auto___31309]));

var G__31310 = (i__7485__auto___31309 + (1));
i__7485__auto___31309 = G__31310;
continue;
} else {
}
break;
}

var G__31260 = args31258.length;
switch (G__31260) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31258.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12283__auto___31312 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___31312){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___31312){
return (function (state_31284){
var state_val_31285 = (state_31284[(1)]);
if((state_val_31285 === (7))){
var inst_31280 = (state_31284[(2)]);
var state_31284__$1 = state_31284;
var statearr_31286_31313 = state_31284__$1;
(statearr_31286_31313[(2)] = inst_31280);

(statearr_31286_31313[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31285 === (1))){
var state_31284__$1 = state_31284;
var statearr_31287_31314 = state_31284__$1;
(statearr_31287_31314[(2)] = null);

(statearr_31287_31314[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31285 === (4))){
var inst_31263 = (state_31284[(7)]);
var inst_31263__$1 = (state_31284[(2)]);
var inst_31264 = (inst_31263__$1 == null);
var state_31284__$1 = (function (){var statearr_31288 = state_31284;
(statearr_31288[(7)] = inst_31263__$1);

return statearr_31288;
})();
if(cljs.core.truth_(inst_31264)){
var statearr_31289_31315 = state_31284__$1;
(statearr_31289_31315[(1)] = (5));

} else {
var statearr_31290_31316 = state_31284__$1;
(statearr_31290_31316[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31285 === (13))){
var state_31284__$1 = state_31284;
var statearr_31291_31317 = state_31284__$1;
(statearr_31291_31317[(2)] = null);

(statearr_31291_31317[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31285 === (6))){
var inst_31263 = (state_31284[(7)]);
var state_31284__$1 = state_31284;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31284__$1,(11),to,inst_31263);
} else {
if((state_val_31285 === (3))){
var inst_31282 = (state_31284[(2)]);
var state_31284__$1 = state_31284;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31284__$1,inst_31282);
} else {
if((state_val_31285 === (12))){
var state_31284__$1 = state_31284;
var statearr_31292_31318 = state_31284__$1;
(statearr_31292_31318[(2)] = null);

(statearr_31292_31318[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31285 === (2))){
var state_31284__$1 = state_31284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31284__$1,(4),from);
} else {
if((state_val_31285 === (11))){
var inst_31273 = (state_31284[(2)]);
var state_31284__$1 = state_31284;
if(cljs.core.truth_(inst_31273)){
var statearr_31293_31319 = state_31284__$1;
(statearr_31293_31319[(1)] = (12));

} else {
var statearr_31294_31320 = state_31284__$1;
(statearr_31294_31320[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31285 === (9))){
var state_31284__$1 = state_31284;
var statearr_31295_31321 = state_31284__$1;
(statearr_31295_31321[(2)] = null);

(statearr_31295_31321[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31285 === (5))){
var state_31284__$1 = state_31284;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31296_31322 = state_31284__$1;
(statearr_31296_31322[(1)] = (8));

} else {
var statearr_31297_31323 = state_31284__$1;
(statearr_31297_31323[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31285 === (14))){
var inst_31278 = (state_31284[(2)]);
var state_31284__$1 = state_31284;
var statearr_31298_31324 = state_31284__$1;
(statearr_31298_31324[(2)] = inst_31278);

(statearr_31298_31324[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31285 === (10))){
var inst_31270 = (state_31284[(2)]);
var state_31284__$1 = state_31284;
var statearr_31299_31325 = state_31284__$1;
(statearr_31299_31325[(2)] = inst_31270);

(statearr_31299_31325[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31285 === (8))){
var inst_31267 = cljs.core.async.close_BANG_(to);
var state_31284__$1 = state_31284;
var statearr_31300_31326 = state_31284__$1;
(statearr_31300_31326[(2)] = inst_31267);

(statearr_31300_31326[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___31312))
;
return ((function (switch__12171__auto__,c__12283__auto___31312){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_31304 = [null,null,null,null,null,null,null,null];
(statearr_31304[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_31304[(1)] = (1));

return statearr_31304;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_31284){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_31284);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e31305){if((e31305 instanceof Object)){
var ex__12175__auto__ = e31305;
var statearr_31306_31327 = state_31284;
(statearr_31306_31327[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31284);

return cljs.core.cst$kw$recur;
} else {
throw e31305;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__31328 = state_31284;
state_31284 = G__31328;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_31284){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_31284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___31312))
})();
var state__12285__auto__ = (function (){var statearr_31307 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_31307[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___31312);

return statearr_31307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___31312))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__31516){
var vec__31517 = p__31516;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31517,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31517,(1),null);
var job = vec__31517;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__12283__auto___31703 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___31703,res,vec__31517,v,p,job,jobs,results){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___31703,res,vec__31517,v,p,job,jobs,results){
return (function (state_31524){
var state_val_31525 = (state_31524[(1)]);
if((state_val_31525 === (1))){
var state_31524__$1 = state_31524;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31524__$1,(2),res,v);
} else {
if((state_val_31525 === (2))){
var inst_31521 = (state_31524[(2)]);
var inst_31522 = cljs.core.async.close_BANG_(res);
var state_31524__$1 = (function (){var statearr_31526 = state_31524;
(statearr_31526[(7)] = inst_31521);

return statearr_31526;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31524__$1,inst_31522);
} else {
return null;
}
}
});})(c__12283__auto___31703,res,vec__31517,v,p,job,jobs,results))
;
return ((function (switch__12171__auto__,c__12283__auto___31703,res,vec__31517,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_31530 = [null,null,null,null,null,null,null,null];
(statearr_31530[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__);

(statearr_31530[(1)] = (1));

return statearr_31530;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1 = (function (state_31524){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_31524);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e31531){if((e31531 instanceof Object)){
var ex__12175__auto__ = e31531;
var statearr_31532_31704 = state_31524;
(statearr_31532_31704[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31524);

return cljs.core.cst$kw$recur;
} else {
throw e31531;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__31705 = state_31524;
state_31524 = G__31705;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = function(state_31524){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1.call(this,state_31524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___31703,res,vec__31517,v,p,job,jobs,results))
})();
var state__12285__auto__ = (function (){var statearr_31533 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_31533[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___31703);

return statearr_31533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___31703,res,vec__31517,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31534){
var vec__31535 = p__31534;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31535,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31535,(1),null);
var job = vec__31535;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___31706 = n;
var __31707 = (0);
while(true){
if((__31707 < n__7324__auto___31706)){
var G__31538_31708 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__31538_31708) {
case "compute":
var c__12283__auto___31710 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31707,c__12283__auto___31710,G__31538_31708,n__7324__auto___31706,jobs,results,process,async){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (__31707,c__12283__auto___31710,G__31538_31708,n__7324__auto___31706,jobs,results,process,async){
return (function (state_31551){
var state_val_31552 = (state_31551[(1)]);
if((state_val_31552 === (1))){
var state_31551__$1 = state_31551;
var statearr_31553_31711 = state_31551__$1;
(statearr_31553_31711[(2)] = null);

(statearr_31553_31711[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31552 === (2))){
var state_31551__$1 = state_31551;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31551__$1,(4),jobs);
} else {
if((state_val_31552 === (3))){
var inst_31549 = (state_31551[(2)]);
var state_31551__$1 = state_31551;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31551__$1,inst_31549);
} else {
if((state_val_31552 === (4))){
var inst_31541 = (state_31551[(2)]);
var inst_31542 = process(inst_31541);
var state_31551__$1 = state_31551;
if(cljs.core.truth_(inst_31542)){
var statearr_31554_31712 = state_31551__$1;
(statearr_31554_31712[(1)] = (5));

} else {
var statearr_31555_31713 = state_31551__$1;
(statearr_31555_31713[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31552 === (5))){
var state_31551__$1 = state_31551;
var statearr_31556_31714 = state_31551__$1;
(statearr_31556_31714[(2)] = null);

(statearr_31556_31714[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31552 === (6))){
var state_31551__$1 = state_31551;
var statearr_31557_31715 = state_31551__$1;
(statearr_31557_31715[(2)] = null);

(statearr_31557_31715[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31552 === (7))){
var inst_31547 = (state_31551[(2)]);
var state_31551__$1 = state_31551;
var statearr_31558_31716 = state_31551__$1;
(statearr_31558_31716[(2)] = inst_31547);

(statearr_31558_31716[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31707,c__12283__auto___31710,G__31538_31708,n__7324__auto___31706,jobs,results,process,async))
;
return ((function (__31707,switch__12171__auto__,c__12283__auto___31710,G__31538_31708,n__7324__auto___31706,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_31562 = [null,null,null,null,null,null,null];
(statearr_31562[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__);

(statearr_31562[(1)] = (1));

return statearr_31562;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1 = (function (state_31551){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_31551);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e31563){if((e31563 instanceof Object)){
var ex__12175__auto__ = e31563;
var statearr_31564_31717 = state_31551;
(statearr_31564_31717[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31551);

return cljs.core.cst$kw$recur;
} else {
throw e31563;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__31718 = state_31551;
state_31551 = G__31718;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = function(state_31551){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1.call(this,state_31551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__;
})()
;})(__31707,switch__12171__auto__,c__12283__auto___31710,G__31538_31708,n__7324__auto___31706,jobs,results,process,async))
})();
var state__12285__auto__ = (function (){var statearr_31565 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_31565[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___31710);

return statearr_31565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(__31707,c__12283__auto___31710,G__31538_31708,n__7324__auto___31706,jobs,results,process,async))
);


break;
case "async":
var c__12283__auto___31719 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31707,c__12283__auto___31719,G__31538_31708,n__7324__auto___31706,jobs,results,process,async){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (__31707,c__12283__auto___31719,G__31538_31708,n__7324__auto___31706,jobs,results,process,async){
return (function (state_31578){
var state_val_31579 = (state_31578[(1)]);
if((state_val_31579 === (1))){
var state_31578__$1 = state_31578;
var statearr_31580_31720 = state_31578__$1;
(statearr_31580_31720[(2)] = null);

(statearr_31580_31720[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31579 === (2))){
var state_31578__$1 = state_31578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31578__$1,(4),jobs);
} else {
if((state_val_31579 === (3))){
var inst_31576 = (state_31578[(2)]);
var state_31578__$1 = state_31578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31578__$1,inst_31576);
} else {
if((state_val_31579 === (4))){
var inst_31568 = (state_31578[(2)]);
var inst_31569 = async(inst_31568);
var state_31578__$1 = state_31578;
if(cljs.core.truth_(inst_31569)){
var statearr_31581_31721 = state_31578__$1;
(statearr_31581_31721[(1)] = (5));

} else {
var statearr_31582_31722 = state_31578__$1;
(statearr_31582_31722[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31579 === (5))){
var state_31578__$1 = state_31578;
var statearr_31583_31723 = state_31578__$1;
(statearr_31583_31723[(2)] = null);

(statearr_31583_31723[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31579 === (6))){
var state_31578__$1 = state_31578;
var statearr_31584_31724 = state_31578__$1;
(statearr_31584_31724[(2)] = null);

(statearr_31584_31724[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31579 === (7))){
var inst_31574 = (state_31578[(2)]);
var state_31578__$1 = state_31578;
var statearr_31585_31725 = state_31578__$1;
(statearr_31585_31725[(2)] = inst_31574);

(statearr_31585_31725[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31707,c__12283__auto___31719,G__31538_31708,n__7324__auto___31706,jobs,results,process,async))
;
return ((function (__31707,switch__12171__auto__,c__12283__auto___31719,G__31538_31708,n__7324__auto___31706,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_31589 = [null,null,null,null,null,null,null];
(statearr_31589[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__);

(statearr_31589[(1)] = (1));

return statearr_31589;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1 = (function (state_31578){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_31578);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e31590){if((e31590 instanceof Object)){
var ex__12175__auto__ = e31590;
var statearr_31591_31726 = state_31578;
(statearr_31591_31726[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31578);

return cljs.core.cst$kw$recur;
} else {
throw e31590;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__31727 = state_31578;
state_31578 = G__31727;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = function(state_31578){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1.call(this,state_31578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__;
})()
;})(__31707,switch__12171__auto__,c__12283__auto___31719,G__31538_31708,n__7324__auto___31706,jobs,results,process,async))
})();
var state__12285__auto__ = (function (){var statearr_31592 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_31592[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___31719);

return statearr_31592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(__31707,c__12283__auto___31719,G__31538_31708,n__7324__auto___31706,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__31728 = (__31707 + (1));
__31707 = G__31728;
continue;
} else {
}
break;
}

var c__12283__auto___31729 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___31729,jobs,results,process,async){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___31729,jobs,results,process,async){
return (function (state_31614){
var state_val_31615 = (state_31614[(1)]);
if((state_val_31615 === (1))){
var state_31614__$1 = state_31614;
var statearr_31616_31730 = state_31614__$1;
(statearr_31616_31730[(2)] = null);

(statearr_31616_31730[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31615 === (2))){
var state_31614__$1 = state_31614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31614__$1,(4),from);
} else {
if((state_val_31615 === (3))){
var inst_31612 = (state_31614[(2)]);
var state_31614__$1 = state_31614;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31614__$1,inst_31612);
} else {
if((state_val_31615 === (4))){
var inst_31595 = (state_31614[(7)]);
var inst_31595__$1 = (state_31614[(2)]);
var inst_31596 = (inst_31595__$1 == null);
var state_31614__$1 = (function (){var statearr_31617 = state_31614;
(statearr_31617[(7)] = inst_31595__$1);

return statearr_31617;
})();
if(cljs.core.truth_(inst_31596)){
var statearr_31618_31731 = state_31614__$1;
(statearr_31618_31731[(1)] = (5));

} else {
var statearr_31619_31732 = state_31614__$1;
(statearr_31619_31732[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31615 === (5))){
var inst_31598 = cljs.core.async.close_BANG_(jobs);
var state_31614__$1 = state_31614;
var statearr_31620_31733 = state_31614__$1;
(statearr_31620_31733[(2)] = inst_31598);

(statearr_31620_31733[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31615 === (6))){
var inst_31595 = (state_31614[(7)]);
var inst_31600 = (state_31614[(8)]);
var inst_31600__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31602 = [inst_31595,inst_31600__$1];
var inst_31603 = (new cljs.core.PersistentVector(null,2,(5),inst_31601,inst_31602,null));
var state_31614__$1 = (function (){var statearr_31621 = state_31614;
(statearr_31621[(8)] = inst_31600__$1);

return statearr_31621;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31614__$1,(8),jobs,inst_31603);
} else {
if((state_val_31615 === (7))){
var inst_31610 = (state_31614[(2)]);
var state_31614__$1 = state_31614;
var statearr_31622_31734 = state_31614__$1;
(statearr_31622_31734[(2)] = inst_31610);

(statearr_31622_31734[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31615 === (8))){
var inst_31600 = (state_31614[(8)]);
var inst_31605 = (state_31614[(2)]);
var state_31614__$1 = (function (){var statearr_31623 = state_31614;
(statearr_31623[(9)] = inst_31605);

return statearr_31623;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31614__$1,(9),results,inst_31600);
} else {
if((state_val_31615 === (9))){
var inst_31607 = (state_31614[(2)]);
var state_31614__$1 = (function (){var statearr_31624 = state_31614;
(statearr_31624[(10)] = inst_31607);

return statearr_31624;
})();
var statearr_31625_31735 = state_31614__$1;
(statearr_31625_31735[(2)] = null);

(statearr_31625_31735[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___31729,jobs,results,process,async))
;
return ((function (switch__12171__auto__,c__12283__auto___31729,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_31629 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31629[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__);

(statearr_31629[(1)] = (1));

return statearr_31629;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1 = (function (state_31614){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_31614);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e31630){if((e31630 instanceof Object)){
var ex__12175__auto__ = e31630;
var statearr_31631_31736 = state_31614;
(statearr_31631_31736[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31614);

return cljs.core.cst$kw$recur;
} else {
throw e31630;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__31737 = state_31614;
state_31614 = G__31737;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = function(state_31614){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1.call(this,state_31614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___31729,jobs,results,process,async))
})();
var state__12285__auto__ = (function (){var statearr_31632 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_31632[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___31729);

return statearr_31632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___31729,jobs,results,process,async))
);


var c__12283__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto__,jobs,results,process,async){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__,jobs,results,process,async){
return (function (state_31670){
var state_val_31671 = (state_31670[(1)]);
if((state_val_31671 === (7))){
var inst_31666 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31672_31738 = state_31670__$1;
(statearr_31672_31738[(2)] = inst_31666);

(statearr_31672_31738[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (20))){
var state_31670__$1 = state_31670;
var statearr_31673_31739 = state_31670__$1;
(statearr_31673_31739[(2)] = null);

(statearr_31673_31739[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (1))){
var state_31670__$1 = state_31670;
var statearr_31674_31740 = state_31670__$1;
(statearr_31674_31740[(2)] = null);

(statearr_31674_31740[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (4))){
var inst_31635 = (state_31670[(7)]);
var inst_31635__$1 = (state_31670[(2)]);
var inst_31636 = (inst_31635__$1 == null);
var state_31670__$1 = (function (){var statearr_31675 = state_31670;
(statearr_31675[(7)] = inst_31635__$1);

return statearr_31675;
})();
if(cljs.core.truth_(inst_31636)){
var statearr_31676_31741 = state_31670__$1;
(statearr_31676_31741[(1)] = (5));

} else {
var statearr_31677_31742 = state_31670__$1;
(statearr_31677_31742[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (15))){
var inst_31648 = (state_31670[(8)]);
var state_31670__$1 = state_31670;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31670__$1,(18),to,inst_31648);
} else {
if((state_val_31671 === (21))){
var inst_31661 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31678_31743 = state_31670__$1;
(statearr_31678_31743[(2)] = inst_31661);

(statearr_31678_31743[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (13))){
var inst_31663 = (state_31670[(2)]);
var state_31670__$1 = (function (){var statearr_31679 = state_31670;
(statearr_31679[(9)] = inst_31663);

return statearr_31679;
})();
var statearr_31680_31744 = state_31670__$1;
(statearr_31680_31744[(2)] = null);

(statearr_31680_31744[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (6))){
var inst_31635 = (state_31670[(7)]);
var state_31670__$1 = state_31670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31670__$1,(11),inst_31635);
} else {
if((state_val_31671 === (17))){
var inst_31656 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
if(cljs.core.truth_(inst_31656)){
var statearr_31681_31745 = state_31670__$1;
(statearr_31681_31745[(1)] = (19));

} else {
var statearr_31682_31746 = state_31670__$1;
(statearr_31682_31746[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (3))){
var inst_31668 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31670__$1,inst_31668);
} else {
if((state_val_31671 === (12))){
var inst_31645 = (state_31670[(10)]);
var state_31670__$1 = state_31670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31670__$1,(14),inst_31645);
} else {
if((state_val_31671 === (2))){
var state_31670__$1 = state_31670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31670__$1,(4),results);
} else {
if((state_val_31671 === (19))){
var state_31670__$1 = state_31670;
var statearr_31683_31747 = state_31670__$1;
(statearr_31683_31747[(2)] = null);

(statearr_31683_31747[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (11))){
var inst_31645 = (state_31670[(2)]);
var state_31670__$1 = (function (){var statearr_31684 = state_31670;
(statearr_31684[(10)] = inst_31645);

return statearr_31684;
})();
var statearr_31685_31748 = state_31670__$1;
(statearr_31685_31748[(2)] = null);

(statearr_31685_31748[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (9))){
var state_31670__$1 = state_31670;
var statearr_31686_31749 = state_31670__$1;
(statearr_31686_31749[(2)] = null);

(statearr_31686_31749[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (5))){
var state_31670__$1 = state_31670;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31687_31750 = state_31670__$1;
(statearr_31687_31750[(1)] = (8));

} else {
var statearr_31688_31751 = state_31670__$1;
(statearr_31688_31751[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (14))){
var inst_31650 = (state_31670[(11)]);
var inst_31648 = (state_31670[(8)]);
var inst_31648__$1 = (state_31670[(2)]);
var inst_31649 = (inst_31648__$1 == null);
var inst_31650__$1 = cljs.core.not(inst_31649);
var state_31670__$1 = (function (){var statearr_31689 = state_31670;
(statearr_31689[(11)] = inst_31650__$1);

(statearr_31689[(8)] = inst_31648__$1);

return statearr_31689;
})();
if(inst_31650__$1){
var statearr_31690_31752 = state_31670__$1;
(statearr_31690_31752[(1)] = (15));

} else {
var statearr_31691_31753 = state_31670__$1;
(statearr_31691_31753[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (16))){
var inst_31650 = (state_31670[(11)]);
var state_31670__$1 = state_31670;
var statearr_31692_31754 = state_31670__$1;
(statearr_31692_31754[(2)] = inst_31650);

(statearr_31692_31754[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (10))){
var inst_31642 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31693_31755 = state_31670__$1;
(statearr_31693_31755[(2)] = inst_31642);

(statearr_31693_31755[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (18))){
var inst_31653 = (state_31670[(2)]);
var state_31670__$1 = state_31670;
var statearr_31694_31756 = state_31670__$1;
(statearr_31694_31756[(2)] = inst_31653);

(statearr_31694_31756[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31671 === (8))){
var inst_31639 = cljs.core.async.close_BANG_(to);
var state_31670__$1 = state_31670;
var statearr_31695_31757 = state_31670__$1;
(statearr_31695_31757[(2)] = inst_31639);

(statearr_31695_31757[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__,jobs,results,process,async))
;
return ((function (switch__12171__auto__,c__12283__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_31699 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31699[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__);

(statearr_31699[(1)] = (1));

return statearr_31699;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1 = (function (state_31670){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_31670);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e31700){if((e31700 instanceof Object)){
var ex__12175__auto__ = e31700;
var statearr_31701_31758 = state_31670;
(statearr_31701_31758[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31670);

return cljs.core.cst$kw$recur;
} else {
throw e31700;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__31759 = state_31670;
state_31670 = G__31759;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__ = function(state_31670){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1.call(this,state_31670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__,jobs,results,process,async))
})();
var state__12285__auto__ = (function (){var statearr_31702 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_31702[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_31702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto__,jobs,results,process,async))
);

return c__12283__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args31760 = [];
var len__7484__auto___31763 = arguments.length;
var i__7485__auto___31764 = (0);
while(true){
if((i__7485__auto___31764 < len__7484__auto___31763)){
args31760.push((arguments[i__7485__auto___31764]));

var G__31765 = (i__7485__auto___31764 + (1));
i__7485__auto___31764 = G__31765;
continue;
} else {
}
break;
}

var G__31762 = args31760.length;
switch (G__31762) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31760.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args31767 = [];
var len__7484__auto___31770 = arguments.length;
var i__7485__auto___31771 = (0);
while(true){
if((i__7485__auto___31771 < len__7484__auto___31770)){
args31767.push((arguments[i__7485__auto___31771]));

var G__31772 = (i__7485__auto___31771 + (1));
i__7485__auto___31771 = G__31772;
continue;
} else {
}
break;
}

var G__31769 = args31767.length;
switch (G__31769) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31767.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args31774 = [];
var len__7484__auto___31827 = arguments.length;
var i__7485__auto___31828 = (0);
while(true){
if((i__7485__auto___31828 < len__7484__auto___31827)){
args31774.push((arguments[i__7485__auto___31828]));

var G__31829 = (i__7485__auto___31828 + (1));
i__7485__auto___31828 = G__31829;
continue;
} else {
}
break;
}

var G__31776 = args31774.length;
switch (G__31776) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31774.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__12283__auto___31831 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___31831,tc,fc){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___31831,tc,fc){
return (function (state_31802){
var state_val_31803 = (state_31802[(1)]);
if((state_val_31803 === (7))){
var inst_31798 = (state_31802[(2)]);
var state_31802__$1 = state_31802;
var statearr_31804_31832 = state_31802__$1;
(statearr_31804_31832[(2)] = inst_31798);

(statearr_31804_31832[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31803 === (1))){
var state_31802__$1 = state_31802;
var statearr_31805_31833 = state_31802__$1;
(statearr_31805_31833[(2)] = null);

(statearr_31805_31833[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31803 === (4))){
var inst_31779 = (state_31802[(7)]);
var inst_31779__$1 = (state_31802[(2)]);
var inst_31780 = (inst_31779__$1 == null);
var state_31802__$1 = (function (){var statearr_31806 = state_31802;
(statearr_31806[(7)] = inst_31779__$1);

return statearr_31806;
})();
if(cljs.core.truth_(inst_31780)){
var statearr_31807_31834 = state_31802__$1;
(statearr_31807_31834[(1)] = (5));

} else {
var statearr_31808_31835 = state_31802__$1;
(statearr_31808_31835[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31803 === (13))){
var state_31802__$1 = state_31802;
var statearr_31809_31836 = state_31802__$1;
(statearr_31809_31836[(2)] = null);

(statearr_31809_31836[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31803 === (6))){
var inst_31779 = (state_31802[(7)]);
var inst_31785 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31779) : p.call(null,inst_31779));
var state_31802__$1 = state_31802;
if(cljs.core.truth_(inst_31785)){
var statearr_31810_31837 = state_31802__$1;
(statearr_31810_31837[(1)] = (9));

} else {
var statearr_31811_31838 = state_31802__$1;
(statearr_31811_31838[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31803 === (3))){
var inst_31800 = (state_31802[(2)]);
var state_31802__$1 = state_31802;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31802__$1,inst_31800);
} else {
if((state_val_31803 === (12))){
var state_31802__$1 = state_31802;
var statearr_31812_31839 = state_31802__$1;
(statearr_31812_31839[(2)] = null);

(statearr_31812_31839[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31803 === (2))){
var state_31802__$1 = state_31802;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31802__$1,(4),ch);
} else {
if((state_val_31803 === (11))){
var inst_31779 = (state_31802[(7)]);
var inst_31789 = (state_31802[(2)]);
var state_31802__$1 = state_31802;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31802__$1,(8),inst_31789,inst_31779);
} else {
if((state_val_31803 === (9))){
var state_31802__$1 = state_31802;
var statearr_31813_31840 = state_31802__$1;
(statearr_31813_31840[(2)] = tc);

(statearr_31813_31840[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31803 === (5))){
var inst_31782 = cljs.core.async.close_BANG_(tc);
var inst_31783 = cljs.core.async.close_BANG_(fc);
var state_31802__$1 = (function (){var statearr_31814 = state_31802;
(statearr_31814[(8)] = inst_31782);

return statearr_31814;
})();
var statearr_31815_31841 = state_31802__$1;
(statearr_31815_31841[(2)] = inst_31783);

(statearr_31815_31841[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31803 === (14))){
var inst_31796 = (state_31802[(2)]);
var state_31802__$1 = state_31802;
var statearr_31816_31842 = state_31802__$1;
(statearr_31816_31842[(2)] = inst_31796);

(statearr_31816_31842[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31803 === (10))){
var state_31802__$1 = state_31802;
var statearr_31817_31843 = state_31802__$1;
(statearr_31817_31843[(2)] = fc);

(statearr_31817_31843[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31803 === (8))){
var inst_31791 = (state_31802[(2)]);
var state_31802__$1 = state_31802;
if(cljs.core.truth_(inst_31791)){
var statearr_31818_31844 = state_31802__$1;
(statearr_31818_31844[(1)] = (12));

} else {
var statearr_31819_31845 = state_31802__$1;
(statearr_31819_31845[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___31831,tc,fc))
;
return ((function (switch__12171__auto__,c__12283__auto___31831,tc,fc){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_31823 = [null,null,null,null,null,null,null,null,null];
(statearr_31823[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_31823[(1)] = (1));

return statearr_31823;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_31802){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_31802);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e31824){if((e31824 instanceof Object)){
var ex__12175__auto__ = e31824;
var statearr_31825_31846 = state_31802;
(statearr_31825_31846[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31802);

return cljs.core.cst$kw$recur;
} else {
throw e31824;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__31847 = state_31802;
state_31802 = G__31847;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_31802){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_31802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___31831,tc,fc))
})();
var state__12285__auto__ = (function (){var statearr_31826 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_31826[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___31831);

return statearr_31826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___31831,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12283__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto__){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__){
return (function (state_31911){
var state_val_31912 = (state_31911[(1)]);
if((state_val_31912 === (7))){
var inst_31907 = (state_31911[(2)]);
var state_31911__$1 = state_31911;
var statearr_31913_31934 = state_31911__$1;
(statearr_31913_31934[(2)] = inst_31907);

(statearr_31913_31934[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31912 === (1))){
var inst_31891 = init;
var state_31911__$1 = (function (){var statearr_31914 = state_31911;
(statearr_31914[(7)] = inst_31891);

return statearr_31914;
})();
var statearr_31915_31935 = state_31911__$1;
(statearr_31915_31935[(2)] = null);

(statearr_31915_31935[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31912 === (4))){
var inst_31894 = (state_31911[(8)]);
var inst_31894__$1 = (state_31911[(2)]);
var inst_31895 = (inst_31894__$1 == null);
var state_31911__$1 = (function (){var statearr_31916 = state_31911;
(statearr_31916[(8)] = inst_31894__$1);

return statearr_31916;
})();
if(cljs.core.truth_(inst_31895)){
var statearr_31917_31936 = state_31911__$1;
(statearr_31917_31936[(1)] = (5));

} else {
var statearr_31918_31937 = state_31911__$1;
(statearr_31918_31937[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31912 === (6))){
var inst_31898 = (state_31911[(9)]);
var inst_31891 = (state_31911[(7)]);
var inst_31894 = (state_31911[(8)]);
var inst_31898__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_31891,inst_31894) : f.call(null,inst_31891,inst_31894));
var inst_31899 = cljs.core.reduced_QMARK_(inst_31898__$1);
var state_31911__$1 = (function (){var statearr_31919 = state_31911;
(statearr_31919[(9)] = inst_31898__$1);

return statearr_31919;
})();
if(inst_31899){
var statearr_31920_31938 = state_31911__$1;
(statearr_31920_31938[(1)] = (8));

} else {
var statearr_31921_31939 = state_31911__$1;
(statearr_31921_31939[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31912 === (3))){
var inst_31909 = (state_31911[(2)]);
var state_31911__$1 = state_31911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31911__$1,inst_31909);
} else {
if((state_val_31912 === (2))){
var state_31911__$1 = state_31911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31911__$1,(4),ch);
} else {
if((state_val_31912 === (9))){
var inst_31898 = (state_31911[(9)]);
var inst_31891 = inst_31898;
var state_31911__$1 = (function (){var statearr_31922 = state_31911;
(statearr_31922[(7)] = inst_31891);

return statearr_31922;
})();
var statearr_31923_31940 = state_31911__$1;
(statearr_31923_31940[(2)] = null);

(statearr_31923_31940[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31912 === (5))){
var inst_31891 = (state_31911[(7)]);
var state_31911__$1 = state_31911;
var statearr_31924_31941 = state_31911__$1;
(statearr_31924_31941[(2)] = inst_31891);

(statearr_31924_31941[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31912 === (10))){
var inst_31905 = (state_31911[(2)]);
var state_31911__$1 = state_31911;
var statearr_31925_31942 = state_31911__$1;
(statearr_31925_31942[(2)] = inst_31905);

(statearr_31925_31942[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31912 === (8))){
var inst_31898 = (state_31911[(9)]);
var inst_31901 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_31898) : cljs.core.deref.call(null,inst_31898));
var state_31911__$1 = state_31911;
var statearr_31926_31943 = state_31911__$1;
(statearr_31926_31943[(2)] = inst_31901);

(statearr_31926_31943[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__))
;
return ((function (switch__12171__auto__,c__12283__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__12172__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12172__auto____0 = (function (){
var statearr_31930 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31930[(0)] = cljs$core$async$reduce_$_state_machine__12172__auto__);

(statearr_31930[(1)] = (1));

return statearr_31930;
});
var cljs$core$async$reduce_$_state_machine__12172__auto____1 = (function (state_31911){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_31911);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e31931){if((e31931 instanceof Object)){
var ex__12175__auto__ = e31931;
var statearr_31932_31944 = state_31911;
(statearr_31932_31944[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31911);

return cljs.core.cst$kw$recur;
} else {
throw e31931;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__31945 = state_31911;
state_31911 = G__31945;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12172__auto__ = function(state_31911){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12172__auto____1.call(this,state_31911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12172__auto____0;
cljs$core$async$reduce_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12172__auto____1;
return cljs$core$async$reduce_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__))
})();
var state__12285__auto__ = (function (){var statearr_31933 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_31933[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_31933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto__))
);

return c__12283__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__12283__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto__,f__$1){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__,f__$1){
return (function (state_31965){
var state_val_31966 = (state_31965[(1)]);
if((state_val_31966 === (1))){
var inst_31960 = cljs.core.async.reduce(f__$1,init,ch);
var state_31965__$1 = state_31965;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31965__$1,(2),inst_31960);
} else {
if((state_val_31966 === (2))){
var inst_31962 = (state_31965[(2)]);
var inst_31963 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_31962) : f__$1.call(null,inst_31962));
var state_31965__$1 = state_31965;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31965__$1,inst_31963);
} else {
return null;
}
}
});})(c__12283__auto__,f__$1))
;
return ((function (switch__12171__auto__,c__12283__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__12172__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12172__auto____0 = (function (){
var statearr_31970 = [null,null,null,null,null,null,null];
(statearr_31970[(0)] = cljs$core$async$transduce_$_state_machine__12172__auto__);

(statearr_31970[(1)] = (1));

return statearr_31970;
});
var cljs$core$async$transduce_$_state_machine__12172__auto____1 = (function (state_31965){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_31965);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e31971){if((e31971 instanceof Object)){
var ex__12175__auto__ = e31971;
var statearr_31972_31974 = state_31965;
(statearr_31972_31974[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31965);

return cljs.core.cst$kw$recur;
} else {
throw e31971;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__31975 = state_31965;
state_31965 = G__31975;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12172__auto__ = function(state_31965){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12172__auto____1.call(this,state_31965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12172__auto____0;
cljs$core$async$transduce_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12172__auto____1;
return cljs$core$async$transduce_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__,f__$1))
})();
var state__12285__auto__ = (function (){var statearr_31973 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_31973[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_31973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto__,f__$1))
);

return c__12283__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args31976 = [];
var len__7484__auto___32028 = arguments.length;
var i__7485__auto___32029 = (0);
while(true){
if((i__7485__auto___32029 < len__7484__auto___32028)){
args31976.push((arguments[i__7485__auto___32029]));

var G__32030 = (i__7485__auto___32029 + (1));
i__7485__auto___32029 = G__32030;
continue;
} else {
}
break;
}

var G__31978 = args31976.length;
switch (G__31978) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31976.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12283__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto__){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__){
return (function (state_32003){
var state_val_32004 = (state_32003[(1)]);
if((state_val_32004 === (7))){
var inst_31985 = (state_32003[(2)]);
var state_32003__$1 = state_32003;
var statearr_32005_32032 = state_32003__$1;
(statearr_32005_32032[(2)] = inst_31985);

(statearr_32005_32032[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32004 === (1))){
var inst_31979 = cljs.core.seq(coll);
var inst_31980 = inst_31979;
var state_32003__$1 = (function (){var statearr_32006 = state_32003;
(statearr_32006[(7)] = inst_31980);

return statearr_32006;
})();
var statearr_32007_32033 = state_32003__$1;
(statearr_32007_32033[(2)] = null);

(statearr_32007_32033[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32004 === (4))){
var inst_31980 = (state_32003[(7)]);
var inst_31983 = cljs.core.first(inst_31980);
var state_32003__$1 = state_32003;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32003__$1,(7),ch,inst_31983);
} else {
if((state_val_32004 === (13))){
var inst_31997 = (state_32003[(2)]);
var state_32003__$1 = state_32003;
var statearr_32008_32034 = state_32003__$1;
(statearr_32008_32034[(2)] = inst_31997);

(statearr_32008_32034[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32004 === (6))){
var inst_31988 = (state_32003[(2)]);
var state_32003__$1 = state_32003;
if(cljs.core.truth_(inst_31988)){
var statearr_32009_32035 = state_32003__$1;
(statearr_32009_32035[(1)] = (8));

} else {
var statearr_32010_32036 = state_32003__$1;
(statearr_32010_32036[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32004 === (3))){
var inst_32001 = (state_32003[(2)]);
var state_32003__$1 = state_32003;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32003__$1,inst_32001);
} else {
if((state_val_32004 === (12))){
var state_32003__$1 = state_32003;
var statearr_32011_32037 = state_32003__$1;
(statearr_32011_32037[(2)] = null);

(statearr_32011_32037[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32004 === (2))){
var inst_31980 = (state_32003[(7)]);
var state_32003__$1 = state_32003;
if(cljs.core.truth_(inst_31980)){
var statearr_32012_32038 = state_32003__$1;
(statearr_32012_32038[(1)] = (4));

} else {
var statearr_32013_32039 = state_32003__$1;
(statearr_32013_32039[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32004 === (11))){
var inst_31994 = cljs.core.async.close_BANG_(ch);
var state_32003__$1 = state_32003;
var statearr_32014_32040 = state_32003__$1;
(statearr_32014_32040[(2)] = inst_31994);

(statearr_32014_32040[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32004 === (9))){
var state_32003__$1 = state_32003;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32015_32041 = state_32003__$1;
(statearr_32015_32041[(1)] = (11));

} else {
var statearr_32016_32042 = state_32003__$1;
(statearr_32016_32042[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32004 === (5))){
var inst_31980 = (state_32003[(7)]);
var state_32003__$1 = state_32003;
var statearr_32017_32043 = state_32003__$1;
(statearr_32017_32043[(2)] = inst_31980);

(statearr_32017_32043[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32004 === (10))){
var inst_31999 = (state_32003[(2)]);
var state_32003__$1 = state_32003;
var statearr_32018_32044 = state_32003__$1;
(statearr_32018_32044[(2)] = inst_31999);

(statearr_32018_32044[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32004 === (8))){
var inst_31980 = (state_32003[(7)]);
var inst_31990 = cljs.core.next(inst_31980);
var inst_31980__$1 = inst_31990;
var state_32003__$1 = (function (){var statearr_32019 = state_32003;
(statearr_32019[(7)] = inst_31980__$1);

return statearr_32019;
})();
var statearr_32020_32045 = state_32003__$1;
(statearr_32020_32045[(2)] = null);

(statearr_32020_32045[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__))
;
return ((function (switch__12171__auto__,c__12283__auto__){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_32024 = [null,null,null,null,null,null,null,null];
(statearr_32024[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_32024[(1)] = (1));

return statearr_32024;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_32003){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_32003);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e32025){if((e32025 instanceof Object)){
var ex__12175__auto__ = e32025;
var statearr_32026_32046 = state_32003;
(statearr_32026_32046[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32003);

return cljs.core.cst$kw$recur;
} else {
throw e32025;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__32047 = state_32003;
state_32003 = G__32047;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_32003){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_32003);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__))
})();
var state__12285__auto__ = (function (){var statearr_32027 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_32027[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_32027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto__))
);

return c__12283__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto__.call(null,_));
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__32276 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32276) : cljs.core.atom.call(null,G__32276));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32277 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32277 = (function (mult,ch,cs,meta32278){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta32278 = meta32278;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32277.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32279,meta32278__$1){
var self__ = this;
var _32279__$1 = this;
return (new cljs.core.async.t_cljs$core$async32277(self__.mult,self__.ch,self__.cs,meta32278__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32277.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32279){
var self__ = this;
var _32279__$1 = this;
return self__.meta32278;
});})(cs))
;

cljs.core.async.t_cljs$core$async32277.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32277.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32277.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async32277.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32277.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32277.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32280_32504 = self__.cs;
var G__32281_32505 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32280_32504,G__32281_32505) : cljs.core.reset_BANG_.call(null,G__32280_32504,G__32281_32505));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32277.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta32278], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32277.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32277.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32277";

cljs.core.async.t_cljs$core$async32277.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32277");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async32277 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32277(mult__$1,ch__$1,cs__$1,meta32278){
return (new cljs.core.async.t_cljs$core$async32277(mult__$1,ch__$1,cs__$1,meta32278));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32277(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__12283__auto___32506 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___32506,cs,m,dchan,dctr,done){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___32506,cs,m,dchan,dctr,done){
return (function (state_32416){
var state_val_32417 = (state_32416[(1)]);
if((state_val_32417 === (7))){
var inst_32412 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
var statearr_32418_32507 = state_32416__$1;
(statearr_32418_32507[(2)] = inst_32412);

(statearr_32418_32507[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (20))){
var inst_32315 = (state_32416[(7)]);
var inst_32327 = cljs.core.first(inst_32315);
var inst_32328 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32327,(0),null);
var inst_32329 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32327,(1),null);
var state_32416__$1 = (function (){var statearr_32419 = state_32416;
(statearr_32419[(8)] = inst_32328);

return statearr_32419;
})();
if(cljs.core.truth_(inst_32329)){
var statearr_32420_32508 = state_32416__$1;
(statearr_32420_32508[(1)] = (22));

} else {
var statearr_32421_32509 = state_32416__$1;
(statearr_32421_32509[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (27))){
var inst_32357 = (state_32416[(9)]);
var inst_32284 = (state_32416[(10)]);
var inst_32364 = (state_32416[(11)]);
var inst_32359 = (state_32416[(12)]);
var inst_32364__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32357,inst_32359);
var inst_32365 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32364__$1,inst_32284,done);
var state_32416__$1 = (function (){var statearr_32422 = state_32416;
(statearr_32422[(11)] = inst_32364__$1);

return statearr_32422;
})();
if(cljs.core.truth_(inst_32365)){
var statearr_32423_32510 = state_32416__$1;
(statearr_32423_32510[(1)] = (30));

} else {
var statearr_32424_32511 = state_32416__$1;
(statearr_32424_32511[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (1))){
var state_32416__$1 = state_32416;
var statearr_32425_32512 = state_32416__$1;
(statearr_32425_32512[(2)] = null);

(statearr_32425_32512[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (24))){
var inst_32315 = (state_32416[(7)]);
var inst_32334 = (state_32416[(2)]);
var inst_32335 = cljs.core.next(inst_32315);
var inst_32293 = inst_32335;
var inst_32294 = null;
var inst_32295 = (0);
var inst_32296 = (0);
var state_32416__$1 = (function (){var statearr_32426 = state_32416;
(statearr_32426[(13)] = inst_32295);

(statearr_32426[(14)] = inst_32294);

(statearr_32426[(15)] = inst_32293);

(statearr_32426[(16)] = inst_32334);

(statearr_32426[(17)] = inst_32296);

return statearr_32426;
})();
var statearr_32427_32513 = state_32416__$1;
(statearr_32427_32513[(2)] = null);

(statearr_32427_32513[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (39))){
var state_32416__$1 = state_32416;
var statearr_32431_32514 = state_32416__$1;
(statearr_32431_32514[(2)] = null);

(statearr_32431_32514[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (4))){
var inst_32284 = (state_32416[(10)]);
var inst_32284__$1 = (state_32416[(2)]);
var inst_32285 = (inst_32284__$1 == null);
var state_32416__$1 = (function (){var statearr_32432 = state_32416;
(statearr_32432[(10)] = inst_32284__$1);

return statearr_32432;
})();
if(cljs.core.truth_(inst_32285)){
var statearr_32433_32515 = state_32416__$1;
(statearr_32433_32515[(1)] = (5));

} else {
var statearr_32434_32516 = state_32416__$1;
(statearr_32434_32516[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (15))){
var inst_32295 = (state_32416[(13)]);
var inst_32294 = (state_32416[(14)]);
var inst_32293 = (state_32416[(15)]);
var inst_32296 = (state_32416[(17)]);
var inst_32311 = (state_32416[(2)]);
var inst_32312 = (inst_32296 + (1));
var tmp32428 = inst_32295;
var tmp32429 = inst_32294;
var tmp32430 = inst_32293;
var inst_32293__$1 = tmp32430;
var inst_32294__$1 = tmp32429;
var inst_32295__$1 = tmp32428;
var inst_32296__$1 = inst_32312;
var state_32416__$1 = (function (){var statearr_32435 = state_32416;
(statearr_32435[(13)] = inst_32295__$1);

(statearr_32435[(14)] = inst_32294__$1);

(statearr_32435[(18)] = inst_32311);

(statearr_32435[(15)] = inst_32293__$1);

(statearr_32435[(17)] = inst_32296__$1);

return statearr_32435;
})();
var statearr_32436_32517 = state_32416__$1;
(statearr_32436_32517[(2)] = null);

(statearr_32436_32517[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (21))){
var inst_32338 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
var statearr_32440_32518 = state_32416__$1;
(statearr_32440_32518[(2)] = inst_32338);

(statearr_32440_32518[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (31))){
var inst_32364 = (state_32416[(11)]);
var inst_32368 = done(null);
var inst_32369 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32364);
var state_32416__$1 = (function (){var statearr_32441 = state_32416;
(statearr_32441[(19)] = inst_32368);

return statearr_32441;
})();
var statearr_32442_32519 = state_32416__$1;
(statearr_32442_32519[(2)] = inst_32369);

(statearr_32442_32519[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (32))){
var inst_32357 = (state_32416[(9)]);
var inst_32358 = (state_32416[(20)]);
var inst_32356 = (state_32416[(21)]);
var inst_32359 = (state_32416[(12)]);
var inst_32371 = (state_32416[(2)]);
var inst_32372 = (inst_32359 + (1));
var tmp32437 = inst_32357;
var tmp32438 = inst_32358;
var tmp32439 = inst_32356;
var inst_32356__$1 = tmp32439;
var inst_32357__$1 = tmp32437;
var inst_32358__$1 = tmp32438;
var inst_32359__$1 = inst_32372;
var state_32416__$1 = (function (){var statearr_32443 = state_32416;
(statearr_32443[(9)] = inst_32357__$1);

(statearr_32443[(20)] = inst_32358__$1);

(statearr_32443[(21)] = inst_32356__$1);

(statearr_32443[(22)] = inst_32371);

(statearr_32443[(12)] = inst_32359__$1);

return statearr_32443;
})();
var statearr_32444_32520 = state_32416__$1;
(statearr_32444_32520[(2)] = null);

(statearr_32444_32520[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (40))){
var inst_32384 = (state_32416[(23)]);
var inst_32388 = done(null);
var inst_32389 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32384);
var state_32416__$1 = (function (){var statearr_32445 = state_32416;
(statearr_32445[(24)] = inst_32388);

return statearr_32445;
})();
var statearr_32446_32521 = state_32416__$1;
(statearr_32446_32521[(2)] = inst_32389);

(statearr_32446_32521[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (33))){
var inst_32375 = (state_32416[(25)]);
var inst_32377 = cljs.core.chunked_seq_QMARK_(inst_32375);
var state_32416__$1 = state_32416;
if(inst_32377){
var statearr_32447_32522 = state_32416__$1;
(statearr_32447_32522[(1)] = (36));

} else {
var statearr_32448_32523 = state_32416__$1;
(statearr_32448_32523[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (13))){
var inst_32305 = (state_32416[(26)]);
var inst_32308 = cljs.core.async.close_BANG_(inst_32305);
var state_32416__$1 = state_32416;
var statearr_32449_32524 = state_32416__$1;
(statearr_32449_32524[(2)] = inst_32308);

(statearr_32449_32524[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (22))){
var inst_32328 = (state_32416[(8)]);
var inst_32331 = cljs.core.async.close_BANG_(inst_32328);
var state_32416__$1 = state_32416;
var statearr_32450_32525 = state_32416__$1;
(statearr_32450_32525[(2)] = inst_32331);

(statearr_32450_32525[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (36))){
var inst_32375 = (state_32416[(25)]);
var inst_32379 = cljs.core.chunk_first(inst_32375);
var inst_32380 = cljs.core.chunk_rest(inst_32375);
var inst_32381 = cljs.core.count(inst_32379);
var inst_32356 = inst_32380;
var inst_32357 = inst_32379;
var inst_32358 = inst_32381;
var inst_32359 = (0);
var state_32416__$1 = (function (){var statearr_32451 = state_32416;
(statearr_32451[(9)] = inst_32357);

(statearr_32451[(20)] = inst_32358);

(statearr_32451[(21)] = inst_32356);

(statearr_32451[(12)] = inst_32359);

return statearr_32451;
})();
var statearr_32452_32526 = state_32416__$1;
(statearr_32452_32526[(2)] = null);

(statearr_32452_32526[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (41))){
var inst_32375 = (state_32416[(25)]);
var inst_32391 = (state_32416[(2)]);
var inst_32392 = cljs.core.next(inst_32375);
var inst_32356 = inst_32392;
var inst_32357 = null;
var inst_32358 = (0);
var inst_32359 = (0);
var state_32416__$1 = (function (){var statearr_32453 = state_32416;
(statearr_32453[(9)] = inst_32357);

(statearr_32453[(20)] = inst_32358);

(statearr_32453[(27)] = inst_32391);

(statearr_32453[(21)] = inst_32356);

(statearr_32453[(12)] = inst_32359);

return statearr_32453;
})();
var statearr_32454_32527 = state_32416__$1;
(statearr_32454_32527[(2)] = null);

(statearr_32454_32527[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (43))){
var state_32416__$1 = state_32416;
var statearr_32455_32528 = state_32416__$1;
(statearr_32455_32528[(2)] = null);

(statearr_32455_32528[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (29))){
var inst_32400 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
var statearr_32456_32529 = state_32416__$1;
(statearr_32456_32529[(2)] = inst_32400);

(statearr_32456_32529[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (44))){
var inst_32409 = (state_32416[(2)]);
var state_32416__$1 = (function (){var statearr_32457 = state_32416;
(statearr_32457[(28)] = inst_32409);

return statearr_32457;
})();
var statearr_32458_32530 = state_32416__$1;
(statearr_32458_32530[(2)] = null);

(statearr_32458_32530[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (6))){
var inst_32348 = (state_32416[(29)]);
var inst_32347 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32348__$1 = cljs.core.keys(inst_32347);
var inst_32349 = cljs.core.count(inst_32348__$1);
var inst_32350 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_32349) : cljs.core.reset_BANG_.call(null,dctr,inst_32349));
var inst_32355 = cljs.core.seq(inst_32348__$1);
var inst_32356 = inst_32355;
var inst_32357 = null;
var inst_32358 = (0);
var inst_32359 = (0);
var state_32416__$1 = (function (){var statearr_32459 = state_32416;
(statearr_32459[(30)] = inst_32350);

(statearr_32459[(9)] = inst_32357);

(statearr_32459[(20)] = inst_32358);

(statearr_32459[(21)] = inst_32356);

(statearr_32459[(29)] = inst_32348__$1);

(statearr_32459[(12)] = inst_32359);

return statearr_32459;
})();
var statearr_32460_32531 = state_32416__$1;
(statearr_32460_32531[(2)] = null);

(statearr_32460_32531[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (28))){
var inst_32356 = (state_32416[(21)]);
var inst_32375 = (state_32416[(25)]);
var inst_32375__$1 = cljs.core.seq(inst_32356);
var state_32416__$1 = (function (){var statearr_32461 = state_32416;
(statearr_32461[(25)] = inst_32375__$1);

return statearr_32461;
})();
if(inst_32375__$1){
var statearr_32462_32532 = state_32416__$1;
(statearr_32462_32532[(1)] = (33));

} else {
var statearr_32463_32533 = state_32416__$1;
(statearr_32463_32533[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (25))){
var inst_32358 = (state_32416[(20)]);
var inst_32359 = (state_32416[(12)]);
var inst_32361 = (inst_32359 < inst_32358);
var inst_32362 = inst_32361;
var state_32416__$1 = state_32416;
if(cljs.core.truth_(inst_32362)){
var statearr_32464_32534 = state_32416__$1;
(statearr_32464_32534[(1)] = (27));

} else {
var statearr_32465_32535 = state_32416__$1;
(statearr_32465_32535[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (34))){
var state_32416__$1 = state_32416;
var statearr_32466_32536 = state_32416__$1;
(statearr_32466_32536[(2)] = null);

(statearr_32466_32536[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (17))){
var state_32416__$1 = state_32416;
var statearr_32467_32537 = state_32416__$1;
(statearr_32467_32537[(2)] = null);

(statearr_32467_32537[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (3))){
var inst_32414 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32416__$1,inst_32414);
} else {
if((state_val_32417 === (12))){
var inst_32343 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
var statearr_32468_32538 = state_32416__$1;
(statearr_32468_32538[(2)] = inst_32343);

(statearr_32468_32538[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (2))){
var state_32416__$1 = state_32416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32416__$1,(4),ch);
} else {
if((state_val_32417 === (23))){
var state_32416__$1 = state_32416;
var statearr_32469_32539 = state_32416__$1;
(statearr_32469_32539[(2)] = null);

(statearr_32469_32539[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (35))){
var inst_32398 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
var statearr_32470_32540 = state_32416__$1;
(statearr_32470_32540[(2)] = inst_32398);

(statearr_32470_32540[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (19))){
var inst_32315 = (state_32416[(7)]);
var inst_32319 = cljs.core.chunk_first(inst_32315);
var inst_32320 = cljs.core.chunk_rest(inst_32315);
var inst_32321 = cljs.core.count(inst_32319);
var inst_32293 = inst_32320;
var inst_32294 = inst_32319;
var inst_32295 = inst_32321;
var inst_32296 = (0);
var state_32416__$1 = (function (){var statearr_32471 = state_32416;
(statearr_32471[(13)] = inst_32295);

(statearr_32471[(14)] = inst_32294);

(statearr_32471[(15)] = inst_32293);

(statearr_32471[(17)] = inst_32296);

return statearr_32471;
})();
var statearr_32472_32541 = state_32416__$1;
(statearr_32472_32541[(2)] = null);

(statearr_32472_32541[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (11))){
var inst_32315 = (state_32416[(7)]);
var inst_32293 = (state_32416[(15)]);
var inst_32315__$1 = cljs.core.seq(inst_32293);
var state_32416__$1 = (function (){var statearr_32473 = state_32416;
(statearr_32473[(7)] = inst_32315__$1);

return statearr_32473;
})();
if(inst_32315__$1){
var statearr_32474_32542 = state_32416__$1;
(statearr_32474_32542[(1)] = (16));

} else {
var statearr_32475_32543 = state_32416__$1;
(statearr_32475_32543[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (9))){
var inst_32345 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
var statearr_32476_32544 = state_32416__$1;
(statearr_32476_32544[(2)] = inst_32345);

(statearr_32476_32544[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (5))){
var inst_32291 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32292 = cljs.core.seq(inst_32291);
var inst_32293 = inst_32292;
var inst_32294 = null;
var inst_32295 = (0);
var inst_32296 = (0);
var state_32416__$1 = (function (){var statearr_32477 = state_32416;
(statearr_32477[(13)] = inst_32295);

(statearr_32477[(14)] = inst_32294);

(statearr_32477[(15)] = inst_32293);

(statearr_32477[(17)] = inst_32296);

return statearr_32477;
})();
var statearr_32478_32545 = state_32416__$1;
(statearr_32478_32545[(2)] = null);

(statearr_32478_32545[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (14))){
var state_32416__$1 = state_32416;
var statearr_32479_32546 = state_32416__$1;
(statearr_32479_32546[(2)] = null);

(statearr_32479_32546[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (45))){
var inst_32406 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
var statearr_32480_32547 = state_32416__$1;
(statearr_32480_32547[(2)] = inst_32406);

(statearr_32480_32547[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (26))){
var inst_32348 = (state_32416[(29)]);
var inst_32402 = (state_32416[(2)]);
var inst_32403 = cljs.core.seq(inst_32348);
var state_32416__$1 = (function (){var statearr_32481 = state_32416;
(statearr_32481[(31)] = inst_32402);

return statearr_32481;
})();
if(inst_32403){
var statearr_32482_32548 = state_32416__$1;
(statearr_32482_32548[(1)] = (42));

} else {
var statearr_32483_32549 = state_32416__$1;
(statearr_32483_32549[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (16))){
var inst_32315 = (state_32416[(7)]);
var inst_32317 = cljs.core.chunked_seq_QMARK_(inst_32315);
var state_32416__$1 = state_32416;
if(inst_32317){
var statearr_32484_32550 = state_32416__$1;
(statearr_32484_32550[(1)] = (19));

} else {
var statearr_32485_32551 = state_32416__$1;
(statearr_32485_32551[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (38))){
var inst_32395 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
var statearr_32486_32552 = state_32416__$1;
(statearr_32486_32552[(2)] = inst_32395);

(statearr_32486_32552[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (30))){
var state_32416__$1 = state_32416;
var statearr_32487_32553 = state_32416__$1;
(statearr_32487_32553[(2)] = null);

(statearr_32487_32553[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (10))){
var inst_32294 = (state_32416[(14)]);
var inst_32296 = (state_32416[(17)]);
var inst_32304 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32294,inst_32296);
var inst_32305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32304,(0),null);
var inst_32306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32304,(1),null);
var state_32416__$1 = (function (){var statearr_32488 = state_32416;
(statearr_32488[(26)] = inst_32305);

return statearr_32488;
})();
if(cljs.core.truth_(inst_32306)){
var statearr_32489_32554 = state_32416__$1;
(statearr_32489_32554[(1)] = (13));

} else {
var statearr_32490_32555 = state_32416__$1;
(statearr_32490_32555[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (18))){
var inst_32341 = (state_32416[(2)]);
var state_32416__$1 = state_32416;
var statearr_32491_32556 = state_32416__$1;
(statearr_32491_32556[(2)] = inst_32341);

(statearr_32491_32556[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (42))){
var state_32416__$1 = state_32416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32416__$1,(45),dchan);
} else {
if((state_val_32417 === (37))){
var inst_32284 = (state_32416[(10)]);
var inst_32375 = (state_32416[(25)]);
var inst_32384 = (state_32416[(23)]);
var inst_32384__$1 = cljs.core.first(inst_32375);
var inst_32385 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32384__$1,inst_32284,done);
var state_32416__$1 = (function (){var statearr_32492 = state_32416;
(statearr_32492[(23)] = inst_32384__$1);

return statearr_32492;
})();
if(cljs.core.truth_(inst_32385)){
var statearr_32493_32557 = state_32416__$1;
(statearr_32493_32557[(1)] = (39));

} else {
var statearr_32494_32558 = state_32416__$1;
(statearr_32494_32558[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32417 === (8))){
var inst_32295 = (state_32416[(13)]);
var inst_32296 = (state_32416[(17)]);
var inst_32298 = (inst_32296 < inst_32295);
var inst_32299 = inst_32298;
var state_32416__$1 = state_32416;
if(cljs.core.truth_(inst_32299)){
var statearr_32495_32559 = state_32416__$1;
(statearr_32495_32559[(1)] = (10));

} else {
var statearr_32496_32560 = state_32416__$1;
(statearr_32496_32560[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___32506,cs,m,dchan,dctr,done))
;
return ((function (switch__12171__auto__,c__12283__auto___32506,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__12172__auto__ = null;
var cljs$core$async$mult_$_state_machine__12172__auto____0 = (function (){
var statearr_32500 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32500[(0)] = cljs$core$async$mult_$_state_machine__12172__auto__);

(statearr_32500[(1)] = (1));

return statearr_32500;
});
var cljs$core$async$mult_$_state_machine__12172__auto____1 = (function (state_32416){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_32416);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e32501){if((e32501 instanceof Object)){
var ex__12175__auto__ = e32501;
var statearr_32502_32561 = state_32416;
(statearr_32502_32561[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32416);

return cljs.core.cst$kw$recur;
} else {
throw e32501;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__32562 = state_32416;
state_32416 = G__32562;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12172__auto__ = function(state_32416){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12172__auto____1.call(this,state_32416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12172__auto____0;
cljs$core$async$mult_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12172__auto____1;
return cljs$core$async$mult_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___32506,cs,m,dchan,dctr,done))
})();
var state__12285__auto__ = (function (){var statearr_32503 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_32503[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___32506);

return statearr_32503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___32506,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args32563 = [];
var len__7484__auto___32566 = arguments.length;
var i__7485__auto___32567 = (0);
while(true){
if((i__7485__auto___32567 < len__7484__auto___32566)){
args32563.push((arguments[i__7485__auto___32567]));

var G__32568 = (i__7485__auto___32567 + (1));
i__7485__auto___32567 = G__32568;
continue;
} else {
}
break;
}

var G__32565 = args32563.length;
switch (G__32565) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32563.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto__.call(null,m,state_map));
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto__.call(null,m,mode));
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32580 = arguments.length;
var i__7485__auto___32581 = (0);
while(true){
if((i__7485__auto___32581 < len__7484__auto___32580)){
args__7491__auto__.push((arguments[i__7485__auto___32581]));

var G__32582 = (i__7485__auto___32581 + (1));
i__7485__auto___32581 = G__32582;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32574){
var map__32575 = p__32574;
var map__32575__$1 = ((((!((map__32575 == null)))?((((map__32575.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32575.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32575):map__32575);
var opts = map__32575__$1;
var statearr_32577_32583 = state;
(statearr_32577_32583[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__32575,map__32575__$1,opts){
return (function (val){
var statearr_32578_32584 = state;
(statearr_32578_32584[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__32575,map__32575__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_32579_32585 = state;
(statearr_32579_32585[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32570){
var G__32571 = cljs.core.first(seq32570);
var seq32570__$1 = cljs.core.next(seq32570);
var G__32572 = cljs.core.first(seq32570__$1);
var seq32570__$2 = cljs.core.next(seq32570__$1);
var G__32573 = cljs.core.first(seq32570__$2);
var seq32570__$3 = cljs.core.next(seq32570__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32571,G__32572,G__32573,seq32570__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__32755 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32755) : cljs.core.atom.call(null,G__32755));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__32756 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32756) : cljs.core.atom.call(null,G__32756));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32757 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32757 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32758){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32758 = meta32758;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32757.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32759,meta32758__$1){
var self__ = this;
var _32759__$1 = this;
return (new cljs.core.async.t_cljs$core$async32757(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32758__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32757.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32759){
var self__ = this;
var _32759__$1 = this;
return self__.meta32758;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32757.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32757.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32757.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async32757.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32757.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32757.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32760_32924 = self__.cs;
var G__32761_32925 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32760_32924,G__32761_32925) : cljs.core.reset_BANG_.call(null,G__32760_32924,G__32761_32925));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32757.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32757.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32757.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta32758], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32757.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32757.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32757";

cljs.core.async.t_cljs$core$async32757.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32757");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async32757 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async32757(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32758){
return (new cljs.core.async.t_cljs$core$async32757(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32758));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async32757(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12283__auto___32926 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___32926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___32926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32861){
var state_val_32862 = (state_32861[(1)]);
if((state_val_32862 === (7))){
var inst_32777 = (state_32861[(2)]);
var state_32861__$1 = state_32861;
var statearr_32863_32927 = state_32861__$1;
(statearr_32863_32927[(2)] = inst_32777);

(statearr_32863_32927[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (20))){
var inst_32789 = (state_32861[(7)]);
var state_32861__$1 = state_32861;
var statearr_32864_32928 = state_32861__$1;
(statearr_32864_32928[(2)] = inst_32789);

(statearr_32864_32928[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (27))){
var state_32861__$1 = state_32861;
var statearr_32865_32929 = state_32861__$1;
(statearr_32865_32929[(2)] = null);

(statearr_32865_32929[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (1))){
var inst_32765 = (state_32861[(8)]);
var inst_32765__$1 = calc_state();
var inst_32767 = (inst_32765__$1 == null);
var inst_32768 = cljs.core.not(inst_32767);
var state_32861__$1 = (function (){var statearr_32866 = state_32861;
(statearr_32866[(8)] = inst_32765__$1);

return statearr_32866;
})();
if(inst_32768){
var statearr_32867_32930 = state_32861__$1;
(statearr_32867_32930[(1)] = (2));

} else {
var statearr_32868_32931 = state_32861__$1;
(statearr_32868_32931[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (24))){
var inst_32821 = (state_32861[(9)]);
var inst_32835 = (state_32861[(10)]);
var inst_32812 = (state_32861[(11)]);
var inst_32835__$1 = (inst_32812.cljs$core$IFn$_invoke$arity$1 ? inst_32812.cljs$core$IFn$_invoke$arity$1(inst_32821) : inst_32812.call(null,inst_32821));
var state_32861__$1 = (function (){var statearr_32869 = state_32861;
(statearr_32869[(10)] = inst_32835__$1);

return statearr_32869;
})();
if(cljs.core.truth_(inst_32835__$1)){
var statearr_32870_32932 = state_32861__$1;
(statearr_32870_32932[(1)] = (29));

} else {
var statearr_32871_32933 = state_32861__$1;
(statearr_32871_32933[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (4))){
var inst_32780 = (state_32861[(2)]);
var state_32861__$1 = state_32861;
if(cljs.core.truth_(inst_32780)){
var statearr_32872_32934 = state_32861__$1;
(statearr_32872_32934[(1)] = (8));

} else {
var statearr_32873_32935 = state_32861__$1;
(statearr_32873_32935[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (15))){
var inst_32806 = (state_32861[(2)]);
var state_32861__$1 = state_32861;
if(cljs.core.truth_(inst_32806)){
var statearr_32874_32936 = state_32861__$1;
(statearr_32874_32936[(1)] = (19));

} else {
var statearr_32875_32937 = state_32861__$1;
(statearr_32875_32937[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (21))){
var inst_32811 = (state_32861[(12)]);
var inst_32811__$1 = (state_32861[(2)]);
var inst_32812 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32811__$1,cljs.core.cst$kw$solos);
var inst_32813 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32811__$1,cljs.core.cst$kw$mutes);
var inst_32814 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32811__$1,cljs.core.cst$kw$reads);
var state_32861__$1 = (function (){var statearr_32876 = state_32861;
(statearr_32876[(11)] = inst_32812);

(statearr_32876[(12)] = inst_32811__$1);

(statearr_32876[(13)] = inst_32813);

return statearr_32876;
})();
return cljs.core.async.ioc_alts_BANG_(state_32861__$1,(22),inst_32814);
} else {
if((state_val_32862 === (31))){
var inst_32843 = (state_32861[(2)]);
var state_32861__$1 = state_32861;
if(cljs.core.truth_(inst_32843)){
var statearr_32877_32938 = state_32861__$1;
(statearr_32877_32938[(1)] = (32));

} else {
var statearr_32878_32939 = state_32861__$1;
(statearr_32878_32939[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (32))){
var inst_32820 = (state_32861[(14)]);
var state_32861__$1 = state_32861;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32861__$1,(35),out,inst_32820);
} else {
if((state_val_32862 === (33))){
var inst_32811 = (state_32861[(12)]);
var inst_32789 = inst_32811;
var state_32861__$1 = (function (){var statearr_32879 = state_32861;
(statearr_32879[(7)] = inst_32789);

return statearr_32879;
})();
var statearr_32880_32940 = state_32861__$1;
(statearr_32880_32940[(2)] = null);

(statearr_32880_32940[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (13))){
var inst_32789 = (state_32861[(7)]);
var inst_32796 = inst_32789.cljs$lang$protocol_mask$partition0$;
var inst_32797 = (inst_32796 & (64));
var inst_32798 = inst_32789.cljs$core$ISeq$;
var inst_32799 = (inst_32797) || (inst_32798);
var state_32861__$1 = state_32861;
if(cljs.core.truth_(inst_32799)){
var statearr_32881_32941 = state_32861__$1;
(statearr_32881_32941[(1)] = (16));

} else {
var statearr_32882_32942 = state_32861__$1;
(statearr_32882_32942[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (22))){
var inst_32821 = (state_32861[(9)]);
var inst_32820 = (state_32861[(14)]);
var inst_32819 = (state_32861[(2)]);
var inst_32820__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32819,(0),null);
var inst_32821__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32819,(1),null);
var inst_32822 = (inst_32820__$1 == null);
var inst_32823 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32821__$1,change);
var inst_32824 = (inst_32822) || (inst_32823);
var state_32861__$1 = (function (){var statearr_32883 = state_32861;
(statearr_32883[(9)] = inst_32821__$1);

(statearr_32883[(14)] = inst_32820__$1);

return statearr_32883;
})();
if(cljs.core.truth_(inst_32824)){
var statearr_32884_32943 = state_32861__$1;
(statearr_32884_32943[(1)] = (23));

} else {
var statearr_32885_32944 = state_32861__$1;
(statearr_32885_32944[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (36))){
var inst_32811 = (state_32861[(12)]);
var inst_32789 = inst_32811;
var state_32861__$1 = (function (){var statearr_32886 = state_32861;
(statearr_32886[(7)] = inst_32789);

return statearr_32886;
})();
var statearr_32887_32945 = state_32861__$1;
(statearr_32887_32945[(2)] = null);

(statearr_32887_32945[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (29))){
var inst_32835 = (state_32861[(10)]);
var state_32861__$1 = state_32861;
var statearr_32888_32946 = state_32861__$1;
(statearr_32888_32946[(2)] = inst_32835);

(statearr_32888_32946[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (6))){
var state_32861__$1 = state_32861;
var statearr_32889_32947 = state_32861__$1;
(statearr_32889_32947[(2)] = false);

(statearr_32889_32947[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (28))){
var inst_32831 = (state_32861[(2)]);
var inst_32832 = calc_state();
var inst_32789 = inst_32832;
var state_32861__$1 = (function (){var statearr_32890 = state_32861;
(statearr_32890[(15)] = inst_32831);

(statearr_32890[(7)] = inst_32789);

return statearr_32890;
})();
var statearr_32891_32948 = state_32861__$1;
(statearr_32891_32948[(2)] = null);

(statearr_32891_32948[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (25))){
var inst_32857 = (state_32861[(2)]);
var state_32861__$1 = state_32861;
var statearr_32892_32949 = state_32861__$1;
(statearr_32892_32949[(2)] = inst_32857);

(statearr_32892_32949[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (34))){
var inst_32855 = (state_32861[(2)]);
var state_32861__$1 = state_32861;
var statearr_32893_32950 = state_32861__$1;
(statearr_32893_32950[(2)] = inst_32855);

(statearr_32893_32950[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (17))){
var state_32861__$1 = state_32861;
var statearr_32894_32951 = state_32861__$1;
(statearr_32894_32951[(2)] = false);

(statearr_32894_32951[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (3))){
var state_32861__$1 = state_32861;
var statearr_32895_32952 = state_32861__$1;
(statearr_32895_32952[(2)] = false);

(statearr_32895_32952[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (12))){
var inst_32859 = (state_32861[(2)]);
var state_32861__$1 = state_32861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32861__$1,inst_32859);
} else {
if((state_val_32862 === (2))){
var inst_32765 = (state_32861[(8)]);
var inst_32770 = inst_32765.cljs$lang$protocol_mask$partition0$;
var inst_32771 = (inst_32770 & (64));
var inst_32772 = inst_32765.cljs$core$ISeq$;
var inst_32773 = (inst_32771) || (inst_32772);
var state_32861__$1 = state_32861;
if(cljs.core.truth_(inst_32773)){
var statearr_32896_32953 = state_32861__$1;
(statearr_32896_32953[(1)] = (5));

} else {
var statearr_32897_32954 = state_32861__$1;
(statearr_32897_32954[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (23))){
var inst_32820 = (state_32861[(14)]);
var inst_32826 = (inst_32820 == null);
var state_32861__$1 = state_32861;
if(cljs.core.truth_(inst_32826)){
var statearr_32898_32955 = state_32861__$1;
(statearr_32898_32955[(1)] = (26));

} else {
var statearr_32899_32956 = state_32861__$1;
(statearr_32899_32956[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (35))){
var inst_32846 = (state_32861[(2)]);
var state_32861__$1 = state_32861;
if(cljs.core.truth_(inst_32846)){
var statearr_32900_32957 = state_32861__$1;
(statearr_32900_32957[(1)] = (36));

} else {
var statearr_32901_32958 = state_32861__$1;
(statearr_32901_32958[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (19))){
var inst_32789 = (state_32861[(7)]);
var inst_32808 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32789);
var state_32861__$1 = state_32861;
var statearr_32902_32959 = state_32861__$1;
(statearr_32902_32959[(2)] = inst_32808);

(statearr_32902_32959[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (11))){
var inst_32789 = (state_32861[(7)]);
var inst_32793 = (inst_32789 == null);
var inst_32794 = cljs.core.not(inst_32793);
var state_32861__$1 = state_32861;
if(inst_32794){
var statearr_32903_32960 = state_32861__$1;
(statearr_32903_32960[(1)] = (13));

} else {
var statearr_32904_32961 = state_32861__$1;
(statearr_32904_32961[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (9))){
var inst_32765 = (state_32861[(8)]);
var state_32861__$1 = state_32861;
var statearr_32905_32962 = state_32861__$1;
(statearr_32905_32962[(2)] = inst_32765);

(statearr_32905_32962[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (5))){
var state_32861__$1 = state_32861;
var statearr_32906_32963 = state_32861__$1;
(statearr_32906_32963[(2)] = true);

(statearr_32906_32963[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (14))){
var state_32861__$1 = state_32861;
var statearr_32907_32964 = state_32861__$1;
(statearr_32907_32964[(2)] = false);

(statearr_32907_32964[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (26))){
var inst_32821 = (state_32861[(9)]);
var inst_32828 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32821);
var state_32861__$1 = state_32861;
var statearr_32908_32965 = state_32861__$1;
(statearr_32908_32965[(2)] = inst_32828);

(statearr_32908_32965[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (16))){
var state_32861__$1 = state_32861;
var statearr_32909_32966 = state_32861__$1;
(statearr_32909_32966[(2)] = true);

(statearr_32909_32966[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (38))){
var inst_32851 = (state_32861[(2)]);
var state_32861__$1 = state_32861;
var statearr_32910_32967 = state_32861__$1;
(statearr_32910_32967[(2)] = inst_32851);

(statearr_32910_32967[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (30))){
var inst_32821 = (state_32861[(9)]);
var inst_32812 = (state_32861[(11)]);
var inst_32813 = (state_32861[(13)]);
var inst_32838 = cljs.core.empty_QMARK_(inst_32812);
var inst_32839 = (inst_32813.cljs$core$IFn$_invoke$arity$1 ? inst_32813.cljs$core$IFn$_invoke$arity$1(inst_32821) : inst_32813.call(null,inst_32821));
var inst_32840 = cljs.core.not(inst_32839);
var inst_32841 = (inst_32838) && (inst_32840);
var state_32861__$1 = state_32861;
var statearr_32911_32968 = state_32861__$1;
(statearr_32911_32968[(2)] = inst_32841);

(statearr_32911_32968[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (10))){
var inst_32765 = (state_32861[(8)]);
var inst_32785 = (state_32861[(2)]);
var inst_32786 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32785,cljs.core.cst$kw$solos);
var inst_32787 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32785,cljs.core.cst$kw$mutes);
var inst_32788 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32785,cljs.core.cst$kw$reads);
var inst_32789 = inst_32765;
var state_32861__$1 = (function (){var statearr_32912 = state_32861;
(statearr_32912[(16)] = inst_32787);

(statearr_32912[(17)] = inst_32788);

(statearr_32912[(18)] = inst_32786);

(statearr_32912[(7)] = inst_32789);

return statearr_32912;
})();
var statearr_32913_32969 = state_32861__$1;
(statearr_32913_32969[(2)] = null);

(statearr_32913_32969[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (18))){
var inst_32803 = (state_32861[(2)]);
var state_32861__$1 = state_32861;
var statearr_32914_32970 = state_32861__$1;
(statearr_32914_32970[(2)] = inst_32803);

(statearr_32914_32970[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (37))){
var state_32861__$1 = state_32861;
var statearr_32915_32971 = state_32861__$1;
(statearr_32915_32971[(2)] = null);

(statearr_32915_32971[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32862 === (8))){
var inst_32765 = (state_32861[(8)]);
var inst_32782 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32765);
var state_32861__$1 = state_32861;
var statearr_32916_32972 = state_32861__$1;
(statearr_32916_32972[(2)] = inst_32782);

(statearr_32916_32972[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___32926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__12171__auto__,c__12283__auto___32926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__12172__auto__ = null;
var cljs$core$async$mix_$_state_machine__12172__auto____0 = (function (){
var statearr_32920 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32920[(0)] = cljs$core$async$mix_$_state_machine__12172__auto__);

(statearr_32920[(1)] = (1));

return statearr_32920;
});
var cljs$core$async$mix_$_state_machine__12172__auto____1 = (function (state_32861){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_32861);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e32921){if((e32921 instanceof Object)){
var ex__12175__auto__ = e32921;
var statearr_32922_32973 = state_32861;
(statearr_32922_32973[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32861);

return cljs.core.cst$kw$recur;
} else {
throw e32921;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__32974 = state_32861;
state_32861 = G__32974;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12172__auto__ = function(state_32861){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12172__auto____1.call(this,state_32861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12172__auto____0;
cljs$core$async$mix_$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12172__auto____1;
return cljs$core$async$mix_$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___32926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__12285__auto__ = (function (){var statearr_32923 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_32923[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___32926);

return statearr_32923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___32926,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto__.call(null,p,v,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args32975 = [];
var len__7484__auto___32978 = arguments.length;
var i__7485__auto___32979 = (0);
while(true){
if((i__7485__auto___32979 < len__7484__auto___32978)){
args32975.push((arguments[i__7485__auto___32979]));

var G__32980 = (i__7485__auto___32979 + (1));
i__7485__auto___32979 = G__32980;
continue;
} else {
}
break;
}

var G__32977 = args32975.length;
switch (G__32977) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32975.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto__.call(null,p));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto__.call(null,p,v));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args32983 = [];
var len__7484__auto___33111 = arguments.length;
var i__7485__auto___33112 = (0);
while(true){
if((i__7485__auto___33112 < len__7484__auto___33111)){
args32983.push((arguments[i__7485__auto___33112]));

var G__33113 = (i__7485__auto___33112 + (1));
i__7485__auto___33112 = G__33113;
continue;
} else {
}
break;
}

var G__32985 = args32983.length;
switch (G__32985) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32983.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__32986 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32986) : cljs.core.atom.call(null,G__32986));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6409__auto__,mults){
return (function (p1__32982_SHARP_){
if(cljs.core.truth_((p1__32982_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__32982_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__32982_SHARP_.call(null,topic)))){
return p1__32982_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32982_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async32987 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32987 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32988){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32988 = meta32988;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32987.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32989,meta32988__$1){
var self__ = this;
var _32989__$1 = this;
return (new cljs.core.async.t_cljs$core$async32987(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32988__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32987.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32989){
var self__ = this;
var _32989__$1 = this;
return self__.meta32988;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32987.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32987.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32987.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async32987.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32987.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32987.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32990 = self__.mults;
var G__32991 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32990,G__32991) : cljs.core.reset_BANG_.call(null,G__32990,G__32991));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32987.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32987.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta32988], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32987.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32987.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32987";

cljs.core.async.t_cljs$core$async32987.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32987");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async32987 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32987(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32988){
return (new cljs.core.async.t_cljs$core$async32987(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32988));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32987(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12283__auto___33115 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___33115,mults,ensure_mult,p){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___33115,mults,ensure_mult,p){
return (function (state_33063){
var state_val_33064 = (state_33063[(1)]);
if((state_val_33064 === (7))){
var inst_33059 = (state_33063[(2)]);
var state_33063__$1 = state_33063;
var statearr_33065_33116 = state_33063__$1;
(statearr_33065_33116[(2)] = inst_33059);

(statearr_33065_33116[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (20))){
var state_33063__$1 = state_33063;
var statearr_33066_33117 = state_33063__$1;
(statearr_33066_33117[(2)] = null);

(statearr_33066_33117[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (1))){
var state_33063__$1 = state_33063;
var statearr_33067_33118 = state_33063__$1;
(statearr_33067_33118[(2)] = null);

(statearr_33067_33118[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (24))){
var inst_33042 = (state_33063[(7)]);
var inst_33051 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_33042);
var state_33063__$1 = state_33063;
var statearr_33068_33119 = state_33063__$1;
(statearr_33068_33119[(2)] = inst_33051);

(statearr_33068_33119[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (4))){
var inst_32994 = (state_33063[(8)]);
var inst_32994__$1 = (state_33063[(2)]);
var inst_32995 = (inst_32994__$1 == null);
var state_33063__$1 = (function (){var statearr_33069 = state_33063;
(statearr_33069[(8)] = inst_32994__$1);

return statearr_33069;
})();
if(cljs.core.truth_(inst_32995)){
var statearr_33070_33120 = state_33063__$1;
(statearr_33070_33120[(1)] = (5));

} else {
var statearr_33071_33121 = state_33063__$1;
(statearr_33071_33121[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (15))){
var inst_33036 = (state_33063[(2)]);
var state_33063__$1 = state_33063;
var statearr_33072_33122 = state_33063__$1;
(statearr_33072_33122[(2)] = inst_33036);

(statearr_33072_33122[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (21))){
var inst_33056 = (state_33063[(2)]);
var state_33063__$1 = (function (){var statearr_33073 = state_33063;
(statearr_33073[(9)] = inst_33056);

return statearr_33073;
})();
var statearr_33074_33123 = state_33063__$1;
(statearr_33074_33123[(2)] = null);

(statearr_33074_33123[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (13))){
var inst_33018 = (state_33063[(10)]);
var inst_33020 = cljs.core.chunked_seq_QMARK_(inst_33018);
var state_33063__$1 = state_33063;
if(inst_33020){
var statearr_33075_33124 = state_33063__$1;
(statearr_33075_33124[(1)] = (16));

} else {
var statearr_33076_33125 = state_33063__$1;
(statearr_33076_33125[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (22))){
var inst_33048 = (state_33063[(2)]);
var state_33063__$1 = state_33063;
if(cljs.core.truth_(inst_33048)){
var statearr_33077_33126 = state_33063__$1;
(statearr_33077_33126[(1)] = (23));

} else {
var statearr_33078_33127 = state_33063__$1;
(statearr_33078_33127[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (6))){
var inst_33042 = (state_33063[(7)]);
var inst_33044 = (state_33063[(11)]);
var inst_32994 = (state_33063[(8)]);
var inst_33042__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_32994) : topic_fn.call(null,inst_32994));
var inst_33043 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33044__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33043,inst_33042__$1);
var state_33063__$1 = (function (){var statearr_33079 = state_33063;
(statearr_33079[(7)] = inst_33042__$1);

(statearr_33079[(11)] = inst_33044__$1);

return statearr_33079;
})();
if(cljs.core.truth_(inst_33044__$1)){
var statearr_33080_33128 = state_33063__$1;
(statearr_33080_33128[(1)] = (19));

} else {
var statearr_33081_33129 = state_33063__$1;
(statearr_33081_33129[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (25))){
var inst_33053 = (state_33063[(2)]);
var state_33063__$1 = state_33063;
var statearr_33082_33130 = state_33063__$1;
(statearr_33082_33130[(2)] = inst_33053);

(statearr_33082_33130[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (17))){
var inst_33018 = (state_33063[(10)]);
var inst_33027 = cljs.core.first(inst_33018);
var inst_33028 = cljs.core.async.muxch_STAR_(inst_33027);
var inst_33029 = cljs.core.async.close_BANG_(inst_33028);
var inst_33030 = cljs.core.next(inst_33018);
var inst_33004 = inst_33030;
var inst_33005 = null;
var inst_33006 = (0);
var inst_33007 = (0);
var state_33063__$1 = (function (){var statearr_33083 = state_33063;
(statearr_33083[(12)] = inst_33006);

(statearr_33083[(13)] = inst_33004);

(statearr_33083[(14)] = inst_33029);

(statearr_33083[(15)] = inst_33005);

(statearr_33083[(16)] = inst_33007);

return statearr_33083;
})();
var statearr_33084_33131 = state_33063__$1;
(statearr_33084_33131[(2)] = null);

(statearr_33084_33131[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (3))){
var inst_33061 = (state_33063[(2)]);
var state_33063__$1 = state_33063;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33063__$1,inst_33061);
} else {
if((state_val_33064 === (12))){
var inst_33038 = (state_33063[(2)]);
var state_33063__$1 = state_33063;
var statearr_33085_33132 = state_33063__$1;
(statearr_33085_33132[(2)] = inst_33038);

(statearr_33085_33132[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (2))){
var state_33063__$1 = state_33063;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33063__$1,(4),ch);
} else {
if((state_val_33064 === (23))){
var state_33063__$1 = state_33063;
var statearr_33086_33133 = state_33063__$1;
(statearr_33086_33133[(2)] = null);

(statearr_33086_33133[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (19))){
var inst_33044 = (state_33063[(11)]);
var inst_32994 = (state_33063[(8)]);
var inst_33046 = cljs.core.async.muxch_STAR_(inst_33044);
var state_33063__$1 = state_33063;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33063__$1,(22),inst_33046,inst_32994);
} else {
if((state_val_33064 === (11))){
var inst_33004 = (state_33063[(13)]);
var inst_33018 = (state_33063[(10)]);
var inst_33018__$1 = cljs.core.seq(inst_33004);
var state_33063__$1 = (function (){var statearr_33087 = state_33063;
(statearr_33087[(10)] = inst_33018__$1);

return statearr_33087;
})();
if(inst_33018__$1){
var statearr_33088_33134 = state_33063__$1;
(statearr_33088_33134[(1)] = (13));

} else {
var statearr_33089_33135 = state_33063__$1;
(statearr_33089_33135[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (9))){
var inst_33040 = (state_33063[(2)]);
var state_33063__$1 = state_33063;
var statearr_33090_33136 = state_33063__$1;
(statearr_33090_33136[(2)] = inst_33040);

(statearr_33090_33136[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (5))){
var inst_33001 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33002 = cljs.core.vals(inst_33001);
var inst_33003 = cljs.core.seq(inst_33002);
var inst_33004 = inst_33003;
var inst_33005 = null;
var inst_33006 = (0);
var inst_33007 = (0);
var state_33063__$1 = (function (){var statearr_33091 = state_33063;
(statearr_33091[(12)] = inst_33006);

(statearr_33091[(13)] = inst_33004);

(statearr_33091[(15)] = inst_33005);

(statearr_33091[(16)] = inst_33007);

return statearr_33091;
})();
var statearr_33092_33137 = state_33063__$1;
(statearr_33092_33137[(2)] = null);

(statearr_33092_33137[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (14))){
var state_33063__$1 = state_33063;
var statearr_33096_33138 = state_33063__$1;
(statearr_33096_33138[(2)] = null);

(statearr_33096_33138[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (16))){
var inst_33018 = (state_33063[(10)]);
var inst_33022 = cljs.core.chunk_first(inst_33018);
var inst_33023 = cljs.core.chunk_rest(inst_33018);
var inst_33024 = cljs.core.count(inst_33022);
var inst_33004 = inst_33023;
var inst_33005 = inst_33022;
var inst_33006 = inst_33024;
var inst_33007 = (0);
var state_33063__$1 = (function (){var statearr_33097 = state_33063;
(statearr_33097[(12)] = inst_33006);

(statearr_33097[(13)] = inst_33004);

(statearr_33097[(15)] = inst_33005);

(statearr_33097[(16)] = inst_33007);

return statearr_33097;
})();
var statearr_33098_33139 = state_33063__$1;
(statearr_33098_33139[(2)] = null);

(statearr_33098_33139[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (10))){
var inst_33006 = (state_33063[(12)]);
var inst_33004 = (state_33063[(13)]);
var inst_33005 = (state_33063[(15)]);
var inst_33007 = (state_33063[(16)]);
var inst_33012 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33005,inst_33007);
var inst_33013 = cljs.core.async.muxch_STAR_(inst_33012);
var inst_33014 = cljs.core.async.close_BANG_(inst_33013);
var inst_33015 = (inst_33007 + (1));
var tmp33093 = inst_33006;
var tmp33094 = inst_33004;
var tmp33095 = inst_33005;
var inst_33004__$1 = tmp33094;
var inst_33005__$1 = tmp33095;
var inst_33006__$1 = tmp33093;
var inst_33007__$1 = inst_33015;
var state_33063__$1 = (function (){var statearr_33099 = state_33063;
(statearr_33099[(12)] = inst_33006__$1);

(statearr_33099[(13)] = inst_33004__$1);

(statearr_33099[(17)] = inst_33014);

(statearr_33099[(15)] = inst_33005__$1);

(statearr_33099[(16)] = inst_33007__$1);

return statearr_33099;
})();
var statearr_33100_33140 = state_33063__$1;
(statearr_33100_33140[(2)] = null);

(statearr_33100_33140[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (18))){
var inst_33033 = (state_33063[(2)]);
var state_33063__$1 = state_33063;
var statearr_33101_33141 = state_33063__$1;
(statearr_33101_33141[(2)] = inst_33033);

(statearr_33101_33141[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33064 === (8))){
var inst_33006 = (state_33063[(12)]);
var inst_33007 = (state_33063[(16)]);
var inst_33009 = (inst_33007 < inst_33006);
var inst_33010 = inst_33009;
var state_33063__$1 = state_33063;
if(cljs.core.truth_(inst_33010)){
var statearr_33102_33142 = state_33063__$1;
(statearr_33102_33142[(1)] = (10));

} else {
var statearr_33103_33143 = state_33063__$1;
(statearr_33103_33143[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___33115,mults,ensure_mult,p))
;
return ((function (switch__12171__auto__,c__12283__auto___33115,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_33107 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33107[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_33107[(1)] = (1));

return statearr_33107;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_33063){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_33063);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e33108){if((e33108 instanceof Object)){
var ex__12175__auto__ = e33108;
var statearr_33109_33144 = state_33063;
(statearr_33109_33144[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33063);

return cljs.core.cst$kw$recur;
} else {
throw e33108;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__33145 = state_33063;
state_33063 = G__33145;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_33063){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_33063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___33115,mults,ensure_mult,p))
})();
var state__12285__auto__ = (function (){var statearr_33110 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_33110[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___33115);

return statearr_33110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___33115,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args33146 = [];
var len__7484__auto___33149 = arguments.length;
var i__7485__auto___33150 = (0);
while(true){
if((i__7485__auto___33150 < len__7484__auto___33149)){
args33146.push((arguments[i__7485__auto___33150]));

var G__33151 = (i__7485__auto___33150 + (1));
i__7485__auto___33150 = G__33151;
continue;
} else {
}
break;
}

var G__33148 = args33146.length;
switch (G__33148) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33146.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args33153 = [];
var len__7484__auto___33156 = arguments.length;
var i__7485__auto___33157 = (0);
while(true){
if((i__7485__auto___33157 < len__7484__auto___33156)){
args33153.push((arguments[i__7485__auto___33157]));

var G__33158 = (i__7485__auto___33157 + (1));
i__7485__auto___33157 = G__33158;
continue;
} else {
}
break;
}

var G__33155 = args33153.length;
switch (G__33155) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33153.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args33160 = [];
var len__7484__auto___33231 = arguments.length;
var i__7485__auto___33232 = (0);
while(true){
if((i__7485__auto___33232 < len__7484__auto___33231)){
args33160.push((arguments[i__7485__auto___33232]));

var G__33233 = (i__7485__auto___33232 + (1));
i__7485__auto___33232 = G__33233;
continue;
} else {
}
break;
}

var G__33162 = args33160.length;
switch (G__33162) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33160.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__12283__auto___33235 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___33235,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___33235,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33201){
var state_val_33202 = (state_33201[(1)]);
if((state_val_33202 === (7))){
var state_33201__$1 = state_33201;
var statearr_33203_33236 = state_33201__$1;
(statearr_33203_33236[(2)] = null);

(statearr_33203_33236[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (1))){
var state_33201__$1 = state_33201;
var statearr_33204_33237 = state_33201__$1;
(statearr_33204_33237[(2)] = null);

(statearr_33204_33237[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (4))){
var inst_33165 = (state_33201[(7)]);
var inst_33167 = (inst_33165 < cnt);
var state_33201__$1 = state_33201;
if(cljs.core.truth_(inst_33167)){
var statearr_33205_33238 = state_33201__$1;
(statearr_33205_33238[(1)] = (6));

} else {
var statearr_33206_33239 = state_33201__$1;
(statearr_33206_33239[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (15))){
var inst_33197 = (state_33201[(2)]);
var state_33201__$1 = state_33201;
var statearr_33207_33240 = state_33201__$1;
(statearr_33207_33240[(2)] = inst_33197);

(statearr_33207_33240[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (13))){
var inst_33190 = cljs.core.async.close_BANG_(out);
var state_33201__$1 = state_33201;
var statearr_33208_33241 = state_33201__$1;
(statearr_33208_33241[(2)] = inst_33190);

(statearr_33208_33241[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (6))){
var state_33201__$1 = state_33201;
var statearr_33209_33242 = state_33201__$1;
(statearr_33209_33242[(2)] = null);

(statearr_33209_33242[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (3))){
var inst_33199 = (state_33201[(2)]);
var state_33201__$1 = state_33201;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33201__$1,inst_33199);
} else {
if((state_val_33202 === (12))){
var inst_33187 = (state_33201[(8)]);
var inst_33187__$1 = (state_33201[(2)]);
var inst_33188 = cljs.core.some(cljs.core.nil_QMARK_,inst_33187__$1);
var state_33201__$1 = (function (){var statearr_33210 = state_33201;
(statearr_33210[(8)] = inst_33187__$1);

return statearr_33210;
})();
if(cljs.core.truth_(inst_33188)){
var statearr_33211_33243 = state_33201__$1;
(statearr_33211_33243[(1)] = (13));

} else {
var statearr_33212_33244 = state_33201__$1;
(statearr_33212_33244[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (2))){
var inst_33164 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_33165 = (0);
var state_33201__$1 = (function (){var statearr_33213 = state_33201;
(statearr_33213[(7)] = inst_33165);

(statearr_33213[(9)] = inst_33164);

return statearr_33213;
})();
var statearr_33214_33245 = state_33201__$1;
(statearr_33214_33245[(2)] = null);

(statearr_33214_33245[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (11))){
var inst_33165 = (state_33201[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_33201,(10),Object,null,(9));
var inst_33174 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_33165) : chs__$1.call(null,inst_33165));
var inst_33175 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_33165) : done.call(null,inst_33165));
var inst_33176 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33174,inst_33175);
var state_33201__$1 = state_33201;
var statearr_33215_33246 = state_33201__$1;
(statearr_33215_33246[(2)] = inst_33176);


cljs.core.async.impl.ioc_helpers.process_exception(state_33201__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (9))){
var inst_33165 = (state_33201[(7)]);
var inst_33178 = (state_33201[(2)]);
var inst_33179 = (inst_33165 + (1));
var inst_33165__$1 = inst_33179;
var state_33201__$1 = (function (){var statearr_33216 = state_33201;
(statearr_33216[(7)] = inst_33165__$1);

(statearr_33216[(10)] = inst_33178);

return statearr_33216;
})();
var statearr_33217_33247 = state_33201__$1;
(statearr_33217_33247[(2)] = null);

(statearr_33217_33247[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (5))){
var inst_33185 = (state_33201[(2)]);
var state_33201__$1 = (function (){var statearr_33218 = state_33201;
(statearr_33218[(11)] = inst_33185);

return statearr_33218;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33201__$1,(12),dchan);
} else {
if((state_val_33202 === (14))){
var inst_33187 = (state_33201[(8)]);
var inst_33192 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33187);
var state_33201__$1 = state_33201;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33201__$1,(16),out,inst_33192);
} else {
if((state_val_33202 === (16))){
var inst_33194 = (state_33201[(2)]);
var state_33201__$1 = (function (){var statearr_33219 = state_33201;
(statearr_33219[(12)] = inst_33194);

return statearr_33219;
})();
var statearr_33220_33248 = state_33201__$1;
(statearr_33220_33248[(2)] = null);

(statearr_33220_33248[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (10))){
var inst_33169 = (state_33201[(2)]);
var inst_33170 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33201__$1 = (function (){var statearr_33221 = state_33201;
(statearr_33221[(13)] = inst_33169);

return statearr_33221;
})();
var statearr_33222_33249 = state_33201__$1;
(statearr_33222_33249[(2)] = inst_33170);


cljs.core.async.impl.ioc_helpers.process_exception(state_33201__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33202 === (8))){
var inst_33183 = (state_33201[(2)]);
var state_33201__$1 = state_33201;
var statearr_33223_33250 = state_33201__$1;
(statearr_33223_33250[(2)] = inst_33183);

(statearr_33223_33250[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___33235,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__12171__auto__,c__12283__auto___33235,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_33227 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33227[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_33227[(1)] = (1));

return statearr_33227;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_33201){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_33201);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e33228){if((e33228 instanceof Object)){
var ex__12175__auto__ = e33228;
var statearr_33229_33251 = state_33201;
(statearr_33229_33251[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33201);

return cljs.core.cst$kw$recur;
} else {
throw e33228;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__33252 = state_33201;
state_33201 = G__33252;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_33201){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_33201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___33235,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__12285__auto__ = (function (){var statearr_33230 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_33230[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___33235);

return statearr_33230;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___33235,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args33254 = [];
var len__7484__auto___33312 = arguments.length;
var i__7485__auto___33313 = (0);
while(true){
if((i__7485__auto___33313 < len__7484__auto___33312)){
args33254.push((arguments[i__7485__auto___33313]));

var G__33314 = (i__7485__auto___33313 + (1));
i__7485__auto___33313 = G__33314;
continue;
} else {
}
break;
}

var G__33256 = args33254.length;
switch (G__33256) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33254.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12283__auto___33316 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___33316,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___33316,out){
return (function (state_33288){
var state_val_33289 = (state_33288[(1)]);
if((state_val_33289 === (7))){
var inst_33267 = (state_33288[(7)]);
var inst_33268 = (state_33288[(8)]);
var inst_33267__$1 = (state_33288[(2)]);
var inst_33268__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33267__$1,(0),null);
var inst_33269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33267__$1,(1),null);
var inst_33270 = (inst_33268__$1 == null);
var state_33288__$1 = (function (){var statearr_33290 = state_33288;
(statearr_33290[(9)] = inst_33269);

(statearr_33290[(7)] = inst_33267__$1);

(statearr_33290[(8)] = inst_33268__$1);

return statearr_33290;
})();
if(cljs.core.truth_(inst_33270)){
var statearr_33291_33317 = state_33288__$1;
(statearr_33291_33317[(1)] = (8));

} else {
var statearr_33292_33318 = state_33288__$1;
(statearr_33292_33318[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (1))){
var inst_33257 = cljs.core.vec(chs);
var inst_33258 = inst_33257;
var state_33288__$1 = (function (){var statearr_33293 = state_33288;
(statearr_33293[(10)] = inst_33258);

return statearr_33293;
})();
var statearr_33294_33319 = state_33288__$1;
(statearr_33294_33319[(2)] = null);

(statearr_33294_33319[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (4))){
var inst_33258 = (state_33288[(10)]);
var state_33288__$1 = state_33288;
return cljs.core.async.ioc_alts_BANG_(state_33288__$1,(7),inst_33258);
} else {
if((state_val_33289 === (6))){
var inst_33284 = (state_33288[(2)]);
var state_33288__$1 = state_33288;
var statearr_33295_33320 = state_33288__$1;
(statearr_33295_33320[(2)] = inst_33284);

(statearr_33295_33320[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (3))){
var inst_33286 = (state_33288[(2)]);
var state_33288__$1 = state_33288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33288__$1,inst_33286);
} else {
if((state_val_33289 === (2))){
var inst_33258 = (state_33288[(10)]);
var inst_33260 = cljs.core.count(inst_33258);
var inst_33261 = (inst_33260 > (0));
var state_33288__$1 = state_33288;
if(cljs.core.truth_(inst_33261)){
var statearr_33297_33321 = state_33288__$1;
(statearr_33297_33321[(1)] = (4));

} else {
var statearr_33298_33322 = state_33288__$1;
(statearr_33298_33322[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (11))){
var inst_33258 = (state_33288[(10)]);
var inst_33277 = (state_33288[(2)]);
var tmp33296 = inst_33258;
var inst_33258__$1 = tmp33296;
var state_33288__$1 = (function (){var statearr_33299 = state_33288;
(statearr_33299[(11)] = inst_33277);

(statearr_33299[(10)] = inst_33258__$1);

return statearr_33299;
})();
var statearr_33300_33323 = state_33288__$1;
(statearr_33300_33323[(2)] = null);

(statearr_33300_33323[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (9))){
var inst_33268 = (state_33288[(8)]);
var state_33288__$1 = state_33288;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33288__$1,(11),out,inst_33268);
} else {
if((state_val_33289 === (5))){
var inst_33282 = cljs.core.async.close_BANG_(out);
var state_33288__$1 = state_33288;
var statearr_33301_33324 = state_33288__$1;
(statearr_33301_33324[(2)] = inst_33282);

(statearr_33301_33324[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (10))){
var inst_33280 = (state_33288[(2)]);
var state_33288__$1 = state_33288;
var statearr_33302_33325 = state_33288__$1;
(statearr_33302_33325[(2)] = inst_33280);

(statearr_33302_33325[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33289 === (8))){
var inst_33269 = (state_33288[(9)]);
var inst_33267 = (state_33288[(7)]);
var inst_33268 = (state_33288[(8)]);
var inst_33258 = (state_33288[(10)]);
var inst_33272 = (function (){var cs = inst_33258;
var vec__33263 = inst_33267;
var v = inst_33268;
var c = inst_33269;
return ((function (cs,vec__33263,v,c,inst_33269,inst_33267,inst_33268,inst_33258,state_val_33289,c__12283__auto___33316,out){
return (function (p1__33253_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33253_SHARP_);
});
;})(cs,vec__33263,v,c,inst_33269,inst_33267,inst_33268,inst_33258,state_val_33289,c__12283__auto___33316,out))
})();
var inst_33273 = cljs.core.filterv(inst_33272,inst_33258);
var inst_33258__$1 = inst_33273;
var state_33288__$1 = (function (){var statearr_33303 = state_33288;
(statearr_33303[(10)] = inst_33258__$1);

return statearr_33303;
})();
var statearr_33304_33326 = state_33288__$1;
(statearr_33304_33326[(2)] = null);

(statearr_33304_33326[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___33316,out))
;
return ((function (switch__12171__auto__,c__12283__auto___33316,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_33308 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33308[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_33308[(1)] = (1));

return statearr_33308;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_33288){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_33288);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e33309){if((e33309 instanceof Object)){
var ex__12175__auto__ = e33309;
var statearr_33310_33327 = state_33288;
(statearr_33310_33327[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33288);

return cljs.core.cst$kw$recur;
} else {
throw e33309;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__33328 = state_33288;
state_33288 = G__33328;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_33288){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_33288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___33316,out))
})();
var state__12285__auto__ = (function (){var statearr_33311 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_33311[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___33316);

return statearr_33311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___33316,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args33329 = [];
var len__7484__auto___33378 = arguments.length;
var i__7485__auto___33379 = (0);
while(true){
if((i__7485__auto___33379 < len__7484__auto___33378)){
args33329.push((arguments[i__7485__auto___33379]));

var G__33380 = (i__7485__auto___33379 + (1));
i__7485__auto___33379 = G__33380;
continue;
} else {
}
break;
}

var G__33331 = args33329.length;
switch (G__33331) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33329.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12283__auto___33382 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___33382,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___33382,out){
return (function (state_33355){
var state_val_33356 = (state_33355[(1)]);
if((state_val_33356 === (7))){
var inst_33337 = (state_33355[(7)]);
var inst_33337__$1 = (state_33355[(2)]);
var inst_33338 = (inst_33337__$1 == null);
var inst_33339 = cljs.core.not(inst_33338);
var state_33355__$1 = (function (){var statearr_33357 = state_33355;
(statearr_33357[(7)] = inst_33337__$1);

return statearr_33357;
})();
if(inst_33339){
var statearr_33358_33383 = state_33355__$1;
(statearr_33358_33383[(1)] = (8));

} else {
var statearr_33359_33384 = state_33355__$1;
(statearr_33359_33384[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33356 === (1))){
var inst_33332 = (0);
var state_33355__$1 = (function (){var statearr_33360 = state_33355;
(statearr_33360[(8)] = inst_33332);

return statearr_33360;
})();
var statearr_33361_33385 = state_33355__$1;
(statearr_33361_33385[(2)] = null);

(statearr_33361_33385[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33356 === (4))){
var state_33355__$1 = state_33355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33355__$1,(7),ch);
} else {
if((state_val_33356 === (6))){
var inst_33350 = (state_33355[(2)]);
var state_33355__$1 = state_33355;
var statearr_33362_33386 = state_33355__$1;
(statearr_33362_33386[(2)] = inst_33350);

(statearr_33362_33386[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33356 === (3))){
var inst_33352 = (state_33355[(2)]);
var inst_33353 = cljs.core.async.close_BANG_(out);
var state_33355__$1 = (function (){var statearr_33363 = state_33355;
(statearr_33363[(9)] = inst_33352);

return statearr_33363;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33355__$1,inst_33353);
} else {
if((state_val_33356 === (2))){
var inst_33332 = (state_33355[(8)]);
var inst_33334 = (inst_33332 < n);
var state_33355__$1 = state_33355;
if(cljs.core.truth_(inst_33334)){
var statearr_33364_33387 = state_33355__$1;
(statearr_33364_33387[(1)] = (4));

} else {
var statearr_33365_33388 = state_33355__$1;
(statearr_33365_33388[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33356 === (11))){
var inst_33332 = (state_33355[(8)]);
var inst_33342 = (state_33355[(2)]);
var inst_33343 = (inst_33332 + (1));
var inst_33332__$1 = inst_33343;
var state_33355__$1 = (function (){var statearr_33366 = state_33355;
(statearr_33366[(10)] = inst_33342);

(statearr_33366[(8)] = inst_33332__$1);

return statearr_33366;
})();
var statearr_33367_33389 = state_33355__$1;
(statearr_33367_33389[(2)] = null);

(statearr_33367_33389[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33356 === (9))){
var state_33355__$1 = state_33355;
var statearr_33368_33390 = state_33355__$1;
(statearr_33368_33390[(2)] = null);

(statearr_33368_33390[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33356 === (5))){
var state_33355__$1 = state_33355;
var statearr_33369_33391 = state_33355__$1;
(statearr_33369_33391[(2)] = null);

(statearr_33369_33391[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33356 === (10))){
var inst_33347 = (state_33355[(2)]);
var state_33355__$1 = state_33355;
var statearr_33370_33392 = state_33355__$1;
(statearr_33370_33392[(2)] = inst_33347);

(statearr_33370_33392[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33356 === (8))){
var inst_33337 = (state_33355[(7)]);
var state_33355__$1 = state_33355;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33355__$1,(11),out,inst_33337);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___33382,out))
;
return ((function (switch__12171__auto__,c__12283__auto___33382,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_33374 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33374[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_33374[(1)] = (1));

return statearr_33374;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_33355){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_33355);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e33375){if((e33375 instanceof Object)){
var ex__12175__auto__ = e33375;
var statearr_33376_33393 = state_33355;
(statearr_33376_33393[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33355);

return cljs.core.cst$kw$recur;
} else {
throw e33375;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__33394 = state_33355;
state_33355 = G__33394;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_33355){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_33355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___33382,out))
})();
var state__12285__auto__ = (function (){var statearr_33377 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_33377[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___33382);

return statearr_33377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___33382,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33404 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33404 = (function (map_LT_,f,ch,meta33405){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta33405 = meta33405;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33404.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33406,meta33405__$1){
var self__ = this;
var _33406__$1 = this;
return (new cljs.core.async.t_cljs$core$async33404(self__.map_LT_,self__.f,self__.ch,meta33405__$1));
});

cljs.core.async.t_cljs$core$async33404.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33406){
var self__ = this;
var _33406__$1 = this;
return self__.meta33405;
});

cljs.core.async.t_cljs$core$async33404.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33404.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33404.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33404.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33404.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async33407 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33407 = (function (map_LT_,f,ch,meta33405,_,fn1,meta33408){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta33405 = meta33405;
this._ = _;
this.fn1 = fn1;
this.meta33408 = meta33408;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33407.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33409,meta33408__$1){
var self__ = this;
var _33409__$1 = this;
return (new cljs.core.async.t_cljs$core$async33407(self__.map_LT_,self__.f,self__.ch,self__.meta33405,self__._,self__.fn1,meta33408__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async33407.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33409){
var self__ = this;
var _33409__$1 = this;
return self__.meta33408;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33407.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async33407.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33407.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33407.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__33395_SHARP_){
var G__33410 = (((p1__33395_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33395_SHARP_) : self__.f.call(null,p1__33395_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33410) : f1.call(null,G__33410));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async33407.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33405,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async33404], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta33408], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33407.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33407.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33407";

cljs.core.async.t_cljs$core$async33407.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33407");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async33407 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33407(map_LT___$1,f__$1,ch__$1,meta33405__$1,___$2,fn1__$1,meta33408){
return (new cljs.core.async.t_cljs$core$async33407(map_LT___$1,f__$1,ch__$1,meta33405__$1,___$2,fn1__$1,meta33408));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async33407(self__.map_LT_,self__.f,self__.ch,self__.meta33405,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33411 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33411) : self__.f.call(null,G__33411));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async33404.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33404.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async33404.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33405], null);
});

cljs.core.async.t_cljs$core$async33404.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33404.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33404";

cljs.core.async.t_cljs$core$async33404.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33404");
});

cljs.core.async.__GT_t_cljs$core$async33404 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33404(map_LT___$1,f__$1,ch__$1,meta33405){
return (new cljs.core.async.t_cljs$core$async33404(map_LT___$1,f__$1,ch__$1,meta33405));
});

}

return (new cljs.core.async.t_cljs$core$async33404(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33415 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33415 = (function (map_GT_,f,ch,meta33416){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta33416 = meta33416;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33417,meta33416__$1){
var self__ = this;
var _33417__$1 = this;
return (new cljs.core.async.t_cljs$core$async33415(self__.map_GT_,self__.f,self__.ch,meta33416__$1));
});

cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33417){
var self__ = this;
var _33417__$1 = this;
return self__.meta33416;
});

cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33415.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async33415.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33416], null);
});

cljs.core.async.t_cljs$core$async33415.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33415.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33415";

cljs.core.async.t_cljs$core$async33415.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33415");
});

cljs.core.async.__GT_t_cljs$core$async33415 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33415(map_GT___$1,f__$1,ch__$1,meta33416){
return (new cljs.core.async.t_cljs$core$async33415(map_GT___$1,f__$1,ch__$1,meta33416));
});

}

return (new cljs.core.async.t_cljs$core$async33415(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async33421 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33421 = (function (filter_GT_,p,ch,meta33422){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta33422 = meta33422;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33421.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33423,meta33422__$1){
var self__ = this;
var _33423__$1 = this;
return (new cljs.core.async.t_cljs$core$async33421(self__.filter_GT_,self__.p,self__.ch,meta33422__$1));
});

cljs.core.async.t_cljs$core$async33421.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33423){
var self__ = this;
var _33423__$1 = this;
return self__.meta33422;
});

cljs.core.async.t_cljs$core$async33421.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33421.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33421.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33421.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33421.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33421.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33421.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async33421.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33422], null);
});

cljs.core.async.t_cljs$core$async33421.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33421.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33421";

cljs.core.async.t_cljs$core$async33421.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33421");
});

cljs.core.async.__GT_t_cljs$core$async33421 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33421(filter_GT___$1,p__$1,ch__$1,meta33422){
return (new cljs.core.async.t_cljs$core$async33421(filter_GT___$1,p__$1,ch__$1,meta33422));
});

}

return (new cljs.core.async.t_cljs$core$async33421(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args33424 = [];
var len__7484__auto___33468 = arguments.length;
var i__7485__auto___33469 = (0);
while(true){
if((i__7485__auto___33469 < len__7484__auto___33468)){
args33424.push((arguments[i__7485__auto___33469]));

var G__33470 = (i__7485__auto___33469 + (1));
i__7485__auto___33469 = G__33470;
continue;
} else {
}
break;
}

var G__33426 = args33424.length;
switch (G__33426) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33424.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12283__auto___33472 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___33472,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___33472,out){
return (function (state_33447){
var state_val_33448 = (state_33447[(1)]);
if((state_val_33448 === (7))){
var inst_33443 = (state_33447[(2)]);
var state_33447__$1 = state_33447;
var statearr_33449_33473 = state_33447__$1;
(statearr_33449_33473[(2)] = inst_33443);

(statearr_33449_33473[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33448 === (1))){
var state_33447__$1 = state_33447;
var statearr_33450_33474 = state_33447__$1;
(statearr_33450_33474[(2)] = null);

(statearr_33450_33474[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33448 === (4))){
var inst_33429 = (state_33447[(7)]);
var inst_33429__$1 = (state_33447[(2)]);
var inst_33430 = (inst_33429__$1 == null);
var state_33447__$1 = (function (){var statearr_33451 = state_33447;
(statearr_33451[(7)] = inst_33429__$1);

return statearr_33451;
})();
if(cljs.core.truth_(inst_33430)){
var statearr_33452_33475 = state_33447__$1;
(statearr_33452_33475[(1)] = (5));

} else {
var statearr_33453_33476 = state_33447__$1;
(statearr_33453_33476[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33448 === (6))){
var inst_33429 = (state_33447[(7)]);
var inst_33434 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33429) : p.call(null,inst_33429));
var state_33447__$1 = state_33447;
if(cljs.core.truth_(inst_33434)){
var statearr_33454_33477 = state_33447__$1;
(statearr_33454_33477[(1)] = (8));

} else {
var statearr_33455_33478 = state_33447__$1;
(statearr_33455_33478[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33448 === (3))){
var inst_33445 = (state_33447[(2)]);
var state_33447__$1 = state_33447;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33447__$1,inst_33445);
} else {
if((state_val_33448 === (2))){
var state_33447__$1 = state_33447;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33447__$1,(4),ch);
} else {
if((state_val_33448 === (11))){
var inst_33437 = (state_33447[(2)]);
var state_33447__$1 = state_33447;
var statearr_33456_33479 = state_33447__$1;
(statearr_33456_33479[(2)] = inst_33437);

(statearr_33456_33479[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33448 === (9))){
var state_33447__$1 = state_33447;
var statearr_33457_33480 = state_33447__$1;
(statearr_33457_33480[(2)] = null);

(statearr_33457_33480[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33448 === (5))){
var inst_33432 = cljs.core.async.close_BANG_(out);
var state_33447__$1 = state_33447;
var statearr_33458_33481 = state_33447__$1;
(statearr_33458_33481[(2)] = inst_33432);

(statearr_33458_33481[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33448 === (10))){
var inst_33440 = (state_33447[(2)]);
var state_33447__$1 = (function (){var statearr_33459 = state_33447;
(statearr_33459[(8)] = inst_33440);

return statearr_33459;
})();
var statearr_33460_33482 = state_33447__$1;
(statearr_33460_33482[(2)] = null);

(statearr_33460_33482[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33448 === (8))){
var inst_33429 = (state_33447[(7)]);
var state_33447__$1 = state_33447;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33447__$1,(11),out,inst_33429);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___33472,out))
;
return ((function (switch__12171__auto__,c__12283__auto___33472,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_33464 = [null,null,null,null,null,null,null,null,null];
(statearr_33464[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_33464[(1)] = (1));

return statearr_33464;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_33447){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_33447);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e33465){if((e33465 instanceof Object)){
var ex__12175__auto__ = e33465;
var statearr_33466_33483 = state_33447;
(statearr_33466_33483[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33447);

return cljs.core.cst$kw$recur;
} else {
throw e33465;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__33484 = state_33447;
state_33447 = G__33484;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_33447){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_33447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___33472,out))
})();
var state__12285__auto__ = (function (){var statearr_33467 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_33467[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___33472);

return statearr_33467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___33472,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args33485 = [];
var len__7484__auto___33488 = arguments.length;
var i__7485__auto___33489 = (0);
while(true){
if((i__7485__auto___33489 < len__7484__auto___33488)){
args33485.push((arguments[i__7485__auto___33489]));

var G__33490 = (i__7485__auto___33489 + (1));
i__7485__auto___33489 = G__33490;
continue;
} else {
}
break;
}

var G__33487 = args33485.length;
switch (G__33487) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33485.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12283__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto__){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto__){
return (function (state_33657){
var state_val_33658 = (state_33657[(1)]);
if((state_val_33658 === (7))){
var inst_33653 = (state_33657[(2)]);
var state_33657__$1 = state_33657;
var statearr_33659_33700 = state_33657__$1;
(statearr_33659_33700[(2)] = inst_33653);

(statearr_33659_33700[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (20))){
var inst_33623 = (state_33657[(7)]);
var inst_33634 = (state_33657[(2)]);
var inst_33635 = cljs.core.next(inst_33623);
var inst_33609 = inst_33635;
var inst_33610 = null;
var inst_33611 = (0);
var inst_33612 = (0);
var state_33657__$1 = (function (){var statearr_33660 = state_33657;
(statearr_33660[(8)] = inst_33610);

(statearr_33660[(9)] = inst_33611);

(statearr_33660[(10)] = inst_33609);

(statearr_33660[(11)] = inst_33634);

(statearr_33660[(12)] = inst_33612);

return statearr_33660;
})();
var statearr_33661_33701 = state_33657__$1;
(statearr_33661_33701[(2)] = null);

(statearr_33661_33701[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (1))){
var state_33657__$1 = state_33657;
var statearr_33662_33702 = state_33657__$1;
(statearr_33662_33702[(2)] = null);

(statearr_33662_33702[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (4))){
var inst_33598 = (state_33657[(13)]);
var inst_33598__$1 = (state_33657[(2)]);
var inst_33599 = (inst_33598__$1 == null);
var state_33657__$1 = (function (){var statearr_33663 = state_33657;
(statearr_33663[(13)] = inst_33598__$1);

return statearr_33663;
})();
if(cljs.core.truth_(inst_33599)){
var statearr_33664_33703 = state_33657__$1;
(statearr_33664_33703[(1)] = (5));

} else {
var statearr_33665_33704 = state_33657__$1;
(statearr_33665_33704[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (15))){
var state_33657__$1 = state_33657;
var statearr_33669_33705 = state_33657__$1;
(statearr_33669_33705[(2)] = null);

(statearr_33669_33705[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (21))){
var state_33657__$1 = state_33657;
var statearr_33670_33706 = state_33657__$1;
(statearr_33670_33706[(2)] = null);

(statearr_33670_33706[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (13))){
var inst_33610 = (state_33657[(8)]);
var inst_33611 = (state_33657[(9)]);
var inst_33609 = (state_33657[(10)]);
var inst_33612 = (state_33657[(12)]);
var inst_33619 = (state_33657[(2)]);
var inst_33620 = (inst_33612 + (1));
var tmp33666 = inst_33610;
var tmp33667 = inst_33611;
var tmp33668 = inst_33609;
var inst_33609__$1 = tmp33668;
var inst_33610__$1 = tmp33666;
var inst_33611__$1 = tmp33667;
var inst_33612__$1 = inst_33620;
var state_33657__$1 = (function (){var statearr_33671 = state_33657;
(statearr_33671[(14)] = inst_33619);

(statearr_33671[(8)] = inst_33610__$1);

(statearr_33671[(9)] = inst_33611__$1);

(statearr_33671[(10)] = inst_33609__$1);

(statearr_33671[(12)] = inst_33612__$1);

return statearr_33671;
})();
var statearr_33672_33707 = state_33657__$1;
(statearr_33672_33707[(2)] = null);

(statearr_33672_33707[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (22))){
var state_33657__$1 = state_33657;
var statearr_33673_33708 = state_33657__$1;
(statearr_33673_33708[(2)] = null);

(statearr_33673_33708[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (6))){
var inst_33598 = (state_33657[(13)]);
var inst_33607 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33598) : f.call(null,inst_33598));
var inst_33608 = cljs.core.seq(inst_33607);
var inst_33609 = inst_33608;
var inst_33610 = null;
var inst_33611 = (0);
var inst_33612 = (0);
var state_33657__$1 = (function (){var statearr_33674 = state_33657;
(statearr_33674[(8)] = inst_33610);

(statearr_33674[(9)] = inst_33611);

(statearr_33674[(10)] = inst_33609);

(statearr_33674[(12)] = inst_33612);

return statearr_33674;
})();
var statearr_33675_33709 = state_33657__$1;
(statearr_33675_33709[(2)] = null);

(statearr_33675_33709[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (17))){
var inst_33623 = (state_33657[(7)]);
var inst_33627 = cljs.core.chunk_first(inst_33623);
var inst_33628 = cljs.core.chunk_rest(inst_33623);
var inst_33629 = cljs.core.count(inst_33627);
var inst_33609 = inst_33628;
var inst_33610 = inst_33627;
var inst_33611 = inst_33629;
var inst_33612 = (0);
var state_33657__$1 = (function (){var statearr_33676 = state_33657;
(statearr_33676[(8)] = inst_33610);

(statearr_33676[(9)] = inst_33611);

(statearr_33676[(10)] = inst_33609);

(statearr_33676[(12)] = inst_33612);

return statearr_33676;
})();
var statearr_33677_33710 = state_33657__$1;
(statearr_33677_33710[(2)] = null);

(statearr_33677_33710[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (3))){
var inst_33655 = (state_33657[(2)]);
var state_33657__$1 = state_33657;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33657__$1,inst_33655);
} else {
if((state_val_33658 === (12))){
var inst_33643 = (state_33657[(2)]);
var state_33657__$1 = state_33657;
var statearr_33678_33711 = state_33657__$1;
(statearr_33678_33711[(2)] = inst_33643);

(statearr_33678_33711[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (2))){
var state_33657__$1 = state_33657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33657__$1,(4),in$);
} else {
if((state_val_33658 === (23))){
var inst_33651 = (state_33657[(2)]);
var state_33657__$1 = state_33657;
var statearr_33679_33712 = state_33657__$1;
(statearr_33679_33712[(2)] = inst_33651);

(statearr_33679_33712[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (19))){
var inst_33638 = (state_33657[(2)]);
var state_33657__$1 = state_33657;
var statearr_33680_33713 = state_33657__$1;
(statearr_33680_33713[(2)] = inst_33638);

(statearr_33680_33713[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (11))){
var inst_33609 = (state_33657[(10)]);
var inst_33623 = (state_33657[(7)]);
var inst_33623__$1 = cljs.core.seq(inst_33609);
var state_33657__$1 = (function (){var statearr_33681 = state_33657;
(statearr_33681[(7)] = inst_33623__$1);

return statearr_33681;
})();
if(inst_33623__$1){
var statearr_33682_33714 = state_33657__$1;
(statearr_33682_33714[(1)] = (14));

} else {
var statearr_33683_33715 = state_33657__$1;
(statearr_33683_33715[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (9))){
var inst_33645 = (state_33657[(2)]);
var inst_33646 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33657__$1 = (function (){var statearr_33684 = state_33657;
(statearr_33684[(15)] = inst_33645);

return statearr_33684;
})();
if(cljs.core.truth_(inst_33646)){
var statearr_33685_33716 = state_33657__$1;
(statearr_33685_33716[(1)] = (21));

} else {
var statearr_33686_33717 = state_33657__$1;
(statearr_33686_33717[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (5))){
var inst_33601 = cljs.core.async.close_BANG_(out);
var state_33657__$1 = state_33657;
var statearr_33687_33718 = state_33657__$1;
(statearr_33687_33718[(2)] = inst_33601);

(statearr_33687_33718[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (14))){
var inst_33623 = (state_33657[(7)]);
var inst_33625 = cljs.core.chunked_seq_QMARK_(inst_33623);
var state_33657__$1 = state_33657;
if(inst_33625){
var statearr_33688_33719 = state_33657__$1;
(statearr_33688_33719[(1)] = (17));

} else {
var statearr_33689_33720 = state_33657__$1;
(statearr_33689_33720[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (16))){
var inst_33641 = (state_33657[(2)]);
var state_33657__$1 = state_33657;
var statearr_33690_33721 = state_33657__$1;
(statearr_33690_33721[(2)] = inst_33641);

(statearr_33690_33721[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33658 === (10))){
var inst_33610 = (state_33657[(8)]);
var inst_33612 = (state_33657[(12)]);
var inst_33617 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33610,inst_33612);
var state_33657__$1 = state_33657;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33657__$1,(13),out,inst_33617);
} else {
if((state_val_33658 === (18))){
var inst_33623 = (state_33657[(7)]);
var inst_33632 = cljs.core.first(inst_33623);
var state_33657__$1 = state_33657;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33657__$1,(20),out,inst_33632);
} else {
if((state_val_33658 === (8))){
var inst_33611 = (state_33657[(9)]);
var inst_33612 = (state_33657[(12)]);
var inst_33614 = (inst_33612 < inst_33611);
var inst_33615 = inst_33614;
var state_33657__$1 = state_33657;
if(cljs.core.truth_(inst_33615)){
var statearr_33691_33722 = state_33657__$1;
(statearr_33691_33722[(1)] = (10));

} else {
var statearr_33692_33723 = state_33657__$1;
(statearr_33692_33723[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto__))
;
return ((function (switch__12171__auto__,c__12283__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____0 = (function (){
var statearr_33696 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33696[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__);

(statearr_33696[(1)] = (1));

return statearr_33696;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____1 = (function (state_33657){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_33657);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e33697){if((e33697 instanceof Object)){
var ex__12175__auto__ = e33697;
var statearr_33698_33724 = state_33657;
(statearr_33698_33724[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33657);

return cljs.core.cst$kw$recur;
} else {
throw e33697;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__33725 = state_33657;
state_33657 = G__33725;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__ = function(state_33657){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____1.call(this,state_33657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12172__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto__))
})();
var state__12285__auto__ = (function (){var statearr_33699 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_33699[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto__);

return statearr_33699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto__))
);

return c__12283__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args33726 = [];
var len__7484__auto___33729 = arguments.length;
var i__7485__auto___33730 = (0);
while(true){
if((i__7485__auto___33730 < len__7484__auto___33729)){
args33726.push((arguments[i__7485__auto___33730]));

var G__33731 = (i__7485__auto___33730 + (1));
i__7485__auto___33730 = G__33731;
continue;
} else {
}
break;
}

var G__33728 = args33726.length;
switch (G__33728) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33726.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args33733 = [];
var len__7484__auto___33736 = arguments.length;
var i__7485__auto___33737 = (0);
while(true){
if((i__7485__auto___33737 < len__7484__auto___33736)){
args33733.push((arguments[i__7485__auto___33737]));

var G__33738 = (i__7485__auto___33737 + (1));
i__7485__auto___33737 = G__33738;
continue;
} else {
}
break;
}

var G__33735 = args33733.length;
switch (G__33735) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33733.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args33740 = [];
var len__7484__auto___33791 = arguments.length;
var i__7485__auto___33792 = (0);
while(true){
if((i__7485__auto___33792 < len__7484__auto___33791)){
args33740.push((arguments[i__7485__auto___33792]));

var G__33793 = (i__7485__auto___33792 + (1));
i__7485__auto___33792 = G__33793;
continue;
} else {
}
break;
}

var G__33742 = args33740.length;
switch (G__33742) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33740.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12283__auto___33795 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___33795,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___33795,out){
return (function (state_33766){
var state_val_33767 = (state_33766[(1)]);
if((state_val_33767 === (7))){
var inst_33761 = (state_33766[(2)]);
var state_33766__$1 = state_33766;
var statearr_33768_33796 = state_33766__$1;
(statearr_33768_33796[(2)] = inst_33761);

(statearr_33768_33796[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33767 === (1))){
var inst_33743 = null;
var state_33766__$1 = (function (){var statearr_33769 = state_33766;
(statearr_33769[(7)] = inst_33743);

return statearr_33769;
})();
var statearr_33770_33797 = state_33766__$1;
(statearr_33770_33797[(2)] = null);

(statearr_33770_33797[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33767 === (4))){
var inst_33746 = (state_33766[(8)]);
var inst_33746__$1 = (state_33766[(2)]);
var inst_33747 = (inst_33746__$1 == null);
var inst_33748 = cljs.core.not(inst_33747);
var state_33766__$1 = (function (){var statearr_33771 = state_33766;
(statearr_33771[(8)] = inst_33746__$1);

return statearr_33771;
})();
if(inst_33748){
var statearr_33772_33798 = state_33766__$1;
(statearr_33772_33798[(1)] = (5));

} else {
var statearr_33773_33799 = state_33766__$1;
(statearr_33773_33799[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33767 === (6))){
var state_33766__$1 = state_33766;
var statearr_33774_33800 = state_33766__$1;
(statearr_33774_33800[(2)] = null);

(statearr_33774_33800[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33767 === (3))){
var inst_33763 = (state_33766[(2)]);
var inst_33764 = cljs.core.async.close_BANG_(out);
var state_33766__$1 = (function (){var statearr_33775 = state_33766;
(statearr_33775[(9)] = inst_33763);

return statearr_33775;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33766__$1,inst_33764);
} else {
if((state_val_33767 === (2))){
var state_33766__$1 = state_33766;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33766__$1,(4),ch);
} else {
if((state_val_33767 === (11))){
var inst_33746 = (state_33766[(8)]);
var inst_33755 = (state_33766[(2)]);
var inst_33743 = inst_33746;
var state_33766__$1 = (function (){var statearr_33776 = state_33766;
(statearr_33776[(7)] = inst_33743);

(statearr_33776[(10)] = inst_33755);

return statearr_33776;
})();
var statearr_33777_33801 = state_33766__$1;
(statearr_33777_33801[(2)] = null);

(statearr_33777_33801[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33767 === (9))){
var inst_33746 = (state_33766[(8)]);
var state_33766__$1 = state_33766;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33766__$1,(11),out,inst_33746);
} else {
if((state_val_33767 === (5))){
var inst_33743 = (state_33766[(7)]);
var inst_33746 = (state_33766[(8)]);
var inst_33750 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33746,inst_33743);
var state_33766__$1 = state_33766;
if(inst_33750){
var statearr_33779_33802 = state_33766__$1;
(statearr_33779_33802[(1)] = (8));

} else {
var statearr_33780_33803 = state_33766__$1;
(statearr_33780_33803[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33767 === (10))){
var inst_33758 = (state_33766[(2)]);
var state_33766__$1 = state_33766;
var statearr_33781_33804 = state_33766__$1;
(statearr_33781_33804[(2)] = inst_33758);

(statearr_33781_33804[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33767 === (8))){
var inst_33743 = (state_33766[(7)]);
var tmp33778 = inst_33743;
var inst_33743__$1 = tmp33778;
var state_33766__$1 = (function (){var statearr_33782 = state_33766;
(statearr_33782[(7)] = inst_33743__$1);

return statearr_33782;
})();
var statearr_33783_33805 = state_33766__$1;
(statearr_33783_33805[(2)] = null);

(statearr_33783_33805[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___33795,out))
;
return ((function (switch__12171__auto__,c__12283__auto___33795,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_33787 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33787[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_33787[(1)] = (1));

return statearr_33787;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_33766){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_33766);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e33788){if((e33788 instanceof Object)){
var ex__12175__auto__ = e33788;
var statearr_33789_33806 = state_33766;
(statearr_33789_33806[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33766);

return cljs.core.cst$kw$recur;
} else {
throw e33788;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__33807 = state_33766;
state_33766 = G__33807;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_33766){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_33766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___33795,out))
})();
var state__12285__auto__ = (function (){var statearr_33790 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_33790[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___33795);

return statearr_33790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___33795,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args33808 = [];
var len__7484__auto___33878 = arguments.length;
var i__7485__auto___33879 = (0);
while(true){
if((i__7485__auto___33879 < len__7484__auto___33878)){
args33808.push((arguments[i__7485__auto___33879]));

var G__33880 = (i__7485__auto___33879 + (1));
i__7485__auto___33879 = G__33880;
continue;
} else {
}
break;
}

var G__33810 = args33808.length;
switch (G__33810) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33808.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12283__auto___33882 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___33882,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___33882,out){
return (function (state_33848){
var state_val_33849 = (state_33848[(1)]);
if((state_val_33849 === (7))){
var inst_33844 = (state_33848[(2)]);
var state_33848__$1 = state_33848;
var statearr_33850_33883 = state_33848__$1;
(statearr_33850_33883[(2)] = inst_33844);

(statearr_33850_33883[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33849 === (1))){
var inst_33811 = (new Array(n));
var inst_33812 = inst_33811;
var inst_33813 = (0);
var state_33848__$1 = (function (){var statearr_33851 = state_33848;
(statearr_33851[(7)] = inst_33813);

(statearr_33851[(8)] = inst_33812);

return statearr_33851;
})();
var statearr_33852_33884 = state_33848__$1;
(statearr_33852_33884[(2)] = null);

(statearr_33852_33884[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33849 === (4))){
var inst_33816 = (state_33848[(9)]);
var inst_33816__$1 = (state_33848[(2)]);
var inst_33817 = (inst_33816__$1 == null);
var inst_33818 = cljs.core.not(inst_33817);
var state_33848__$1 = (function (){var statearr_33853 = state_33848;
(statearr_33853[(9)] = inst_33816__$1);

return statearr_33853;
})();
if(inst_33818){
var statearr_33854_33885 = state_33848__$1;
(statearr_33854_33885[(1)] = (5));

} else {
var statearr_33855_33886 = state_33848__$1;
(statearr_33855_33886[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33849 === (15))){
var inst_33838 = (state_33848[(2)]);
var state_33848__$1 = state_33848;
var statearr_33856_33887 = state_33848__$1;
(statearr_33856_33887[(2)] = inst_33838);

(statearr_33856_33887[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33849 === (13))){
var state_33848__$1 = state_33848;
var statearr_33857_33888 = state_33848__$1;
(statearr_33857_33888[(2)] = null);

(statearr_33857_33888[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33849 === (6))){
var inst_33813 = (state_33848[(7)]);
var inst_33834 = (inst_33813 > (0));
var state_33848__$1 = state_33848;
if(cljs.core.truth_(inst_33834)){
var statearr_33858_33889 = state_33848__$1;
(statearr_33858_33889[(1)] = (12));

} else {
var statearr_33859_33890 = state_33848__$1;
(statearr_33859_33890[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33849 === (3))){
var inst_33846 = (state_33848[(2)]);
var state_33848__$1 = state_33848;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33848__$1,inst_33846);
} else {
if((state_val_33849 === (12))){
var inst_33812 = (state_33848[(8)]);
var inst_33836 = cljs.core.vec(inst_33812);
var state_33848__$1 = state_33848;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33848__$1,(15),out,inst_33836);
} else {
if((state_val_33849 === (2))){
var state_33848__$1 = state_33848;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33848__$1,(4),ch);
} else {
if((state_val_33849 === (11))){
var inst_33828 = (state_33848[(2)]);
var inst_33829 = (new Array(n));
var inst_33812 = inst_33829;
var inst_33813 = (0);
var state_33848__$1 = (function (){var statearr_33860 = state_33848;
(statearr_33860[(7)] = inst_33813);

(statearr_33860[(8)] = inst_33812);

(statearr_33860[(10)] = inst_33828);

return statearr_33860;
})();
var statearr_33861_33891 = state_33848__$1;
(statearr_33861_33891[(2)] = null);

(statearr_33861_33891[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33849 === (9))){
var inst_33812 = (state_33848[(8)]);
var inst_33826 = cljs.core.vec(inst_33812);
var state_33848__$1 = state_33848;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33848__$1,(11),out,inst_33826);
} else {
if((state_val_33849 === (5))){
var inst_33816 = (state_33848[(9)]);
var inst_33821 = (state_33848[(11)]);
var inst_33813 = (state_33848[(7)]);
var inst_33812 = (state_33848[(8)]);
var inst_33820 = (inst_33812[inst_33813] = inst_33816);
var inst_33821__$1 = (inst_33813 + (1));
var inst_33822 = (inst_33821__$1 < n);
var state_33848__$1 = (function (){var statearr_33862 = state_33848;
(statearr_33862[(12)] = inst_33820);

(statearr_33862[(11)] = inst_33821__$1);

return statearr_33862;
})();
if(cljs.core.truth_(inst_33822)){
var statearr_33863_33892 = state_33848__$1;
(statearr_33863_33892[(1)] = (8));

} else {
var statearr_33864_33893 = state_33848__$1;
(statearr_33864_33893[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33849 === (14))){
var inst_33841 = (state_33848[(2)]);
var inst_33842 = cljs.core.async.close_BANG_(out);
var state_33848__$1 = (function (){var statearr_33866 = state_33848;
(statearr_33866[(13)] = inst_33841);

return statearr_33866;
})();
var statearr_33867_33894 = state_33848__$1;
(statearr_33867_33894[(2)] = inst_33842);

(statearr_33867_33894[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33849 === (10))){
var inst_33832 = (state_33848[(2)]);
var state_33848__$1 = state_33848;
var statearr_33868_33895 = state_33848__$1;
(statearr_33868_33895[(2)] = inst_33832);

(statearr_33868_33895[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33849 === (8))){
var inst_33821 = (state_33848[(11)]);
var inst_33812 = (state_33848[(8)]);
var tmp33865 = inst_33812;
var inst_33812__$1 = tmp33865;
var inst_33813 = inst_33821;
var state_33848__$1 = (function (){var statearr_33869 = state_33848;
(statearr_33869[(7)] = inst_33813);

(statearr_33869[(8)] = inst_33812__$1);

return statearr_33869;
})();
var statearr_33870_33896 = state_33848__$1;
(statearr_33870_33896[(2)] = null);

(statearr_33870_33896[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___33882,out))
;
return ((function (switch__12171__auto__,c__12283__auto___33882,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_33874 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33874[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_33874[(1)] = (1));

return statearr_33874;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_33848){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_33848);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e33875){if((e33875 instanceof Object)){
var ex__12175__auto__ = e33875;
var statearr_33876_33897 = state_33848;
(statearr_33876_33897[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33848);

return cljs.core.cst$kw$recur;
} else {
throw e33875;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__33898 = state_33848;
state_33848 = G__33898;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_33848){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_33848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___33882,out))
})();
var state__12285__auto__ = (function (){var statearr_33877 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_33877[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___33882);

return statearr_33877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___33882,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args33899 = [];
var len__7484__auto___33973 = arguments.length;
var i__7485__auto___33974 = (0);
while(true){
if((i__7485__auto___33974 < len__7484__auto___33973)){
args33899.push((arguments[i__7485__auto___33974]));

var G__33975 = (i__7485__auto___33974 + (1));
i__7485__auto___33974 = G__33975;
continue;
} else {
}
break;
}

var G__33901 = args33899.length;
switch (G__33901) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33899.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12283__auto___33977 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12283__auto___33977,out){
return (function (){
var f__12284__auto__ = (function (){var switch__12171__auto__ = ((function (c__12283__auto___33977,out){
return (function (state_33943){
var state_val_33944 = (state_33943[(1)]);
if((state_val_33944 === (7))){
var inst_33939 = (state_33943[(2)]);
var state_33943__$1 = state_33943;
var statearr_33945_33978 = state_33943__$1;
(statearr_33945_33978[(2)] = inst_33939);

(statearr_33945_33978[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (1))){
var inst_33902 = [];
var inst_33903 = inst_33902;
var inst_33904 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_33943__$1 = (function (){var statearr_33946 = state_33943;
(statearr_33946[(7)] = inst_33904);

(statearr_33946[(8)] = inst_33903);

return statearr_33946;
})();
var statearr_33947_33979 = state_33943__$1;
(statearr_33947_33979[(2)] = null);

(statearr_33947_33979[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (4))){
var inst_33907 = (state_33943[(9)]);
var inst_33907__$1 = (state_33943[(2)]);
var inst_33908 = (inst_33907__$1 == null);
var inst_33909 = cljs.core.not(inst_33908);
var state_33943__$1 = (function (){var statearr_33948 = state_33943;
(statearr_33948[(9)] = inst_33907__$1);

return statearr_33948;
})();
if(inst_33909){
var statearr_33949_33980 = state_33943__$1;
(statearr_33949_33980[(1)] = (5));

} else {
var statearr_33950_33981 = state_33943__$1;
(statearr_33950_33981[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (15))){
var inst_33933 = (state_33943[(2)]);
var state_33943__$1 = state_33943;
var statearr_33951_33982 = state_33943__$1;
(statearr_33951_33982[(2)] = inst_33933);

(statearr_33951_33982[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (13))){
var state_33943__$1 = state_33943;
var statearr_33952_33983 = state_33943__$1;
(statearr_33952_33983[(2)] = null);

(statearr_33952_33983[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (6))){
var inst_33903 = (state_33943[(8)]);
var inst_33928 = inst_33903.length;
var inst_33929 = (inst_33928 > (0));
var state_33943__$1 = state_33943;
if(cljs.core.truth_(inst_33929)){
var statearr_33953_33984 = state_33943__$1;
(statearr_33953_33984[(1)] = (12));

} else {
var statearr_33954_33985 = state_33943__$1;
(statearr_33954_33985[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (3))){
var inst_33941 = (state_33943[(2)]);
var state_33943__$1 = state_33943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33943__$1,inst_33941);
} else {
if((state_val_33944 === (12))){
var inst_33903 = (state_33943[(8)]);
var inst_33931 = cljs.core.vec(inst_33903);
var state_33943__$1 = state_33943;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33943__$1,(15),out,inst_33931);
} else {
if((state_val_33944 === (2))){
var state_33943__$1 = state_33943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33943__$1,(4),ch);
} else {
if((state_val_33944 === (11))){
var inst_33907 = (state_33943[(9)]);
var inst_33911 = (state_33943[(10)]);
var inst_33921 = (state_33943[(2)]);
var inst_33922 = [];
var inst_33923 = inst_33922.push(inst_33907);
var inst_33903 = inst_33922;
var inst_33904 = inst_33911;
var state_33943__$1 = (function (){var statearr_33955 = state_33943;
(statearr_33955[(11)] = inst_33921);

(statearr_33955[(7)] = inst_33904);

(statearr_33955[(12)] = inst_33923);

(statearr_33955[(8)] = inst_33903);

return statearr_33955;
})();
var statearr_33956_33986 = state_33943__$1;
(statearr_33956_33986[(2)] = null);

(statearr_33956_33986[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (9))){
var inst_33903 = (state_33943[(8)]);
var inst_33919 = cljs.core.vec(inst_33903);
var state_33943__$1 = state_33943;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33943__$1,(11),out,inst_33919);
} else {
if((state_val_33944 === (5))){
var inst_33907 = (state_33943[(9)]);
var inst_33904 = (state_33943[(7)]);
var inst_33911 = (state_33943[(10)]);
var inst_33911__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33907) : f.call(null,inst_33907));
var inst_33912 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33911__$1,inst_33904);
var inst_33913 = cljs.core.keyword_identical_QMARK_(inst_33904,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_33914 = (inst_33912) || (inst_33913);
var state_33943__$1 = (function (){var statearr_33957 = state_33943;
(statearr_33957[(10)] = inst_33911__$1);

return statearr_33957;
})();
if(cljs.core.truth_(inst_33914)){
var statearr_33958_33987 = state_33943__$1;
(statearr_33958_33987[(1)] = (8));

} else {
var statearr_33959_33988 = state_33943__$1;
(statearr_33959_33988[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (14))){
var inst_33936 = (state_33943[(2)]);
var inst_33937 = cljs.core.async.close_BANG_(out);
var state_33943__$1 = (function (){var statearr_33961 = state_33943;
(statearr_33961[(13)] = inst_33936);

return statearr_33961;
})();
var statearr_33962_33989 = state_33943__$1;
(statearr_33962_33989[(2)] = inst_33937);

(statearr_33962_33989[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (10))){
var inst_33926 = (state_33943[(2)]);
var state_33943__$1 = state_33943;
var statearr_33963_33990 = state_33943__$1;
(statearr_33963_33990[(2)] = inst_33926);

(statearr_33963_33990[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33944 === (8))){
var inst_33907 = (state_33943[(9)]);
var inst_33911 = (state_33943[(10)]);
var inst_33903 = (state_33943[(8)]);
var inst_33916 = inst_33903.push(inst_33907);
var tmp33960 = inst_33903;
var inst_33903__$1 = tmp33960;
var inst_33904 = inst_33911;
var state_33943__$1 = (function (){var statearr_33964 = state_33943;
(statearr_33964[(7)] = inst_33904);

(statearr_33964[(14)] = inst_33916);

(statearr_33964[(8)] = inst_33903__$1);

return statearr_33964;
})();
var statearr_33965_33991 = state_33943__$1;
(statearr_33965_33991[(2)] = null);

(statearr_33965_33991[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12283__auto___33977,out))
;
return ((function (switch__12171__auto__,c__12283__auto___33977,out){
return (function() {
var cljs$core$async$state_machine__12172__auto__ = null;
var cljs$core$async$state_machine__12172__auto____0 = (function (){
var statearr_33969 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33969[(0)] = cljs$core$async$state_machine__12172__auto__);

(statearr_33969[(1)] = (1));

return statearr_33969;
});
var cljs$core$async$state_machine__12172__auto____1 = (function (state_33943){
while(true){
var ret_value__12173__auto__ = (function (){try{while(true){
var result__12174__auto__ = switch__12171__auto__(state_33943);
if(cljs.core.keyword_identical_QMARK_(result__12174__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12174__auto__;
}
break;
}
}catch (e33970){if((e33970 instanceof Object)){
var ex__12175__auto__ = e33970;
var statearr_33971_33992 = state_33943;
(statearr_33971_33992[(5)] = ex__12175__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33943);

return cljs.core.cst$kw$recur;
} else {
throw e33970;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12173__auto__,cljs.core.cst$kw$recur)){
var G__33993 = state_33943;
state_33943 = G__33993;
continue;
} else {
return ret_value__12173__auto__;
}
break;
}
});
cljs$core$async$state_machine__12172__auto__ = function(state_33943){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12172__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12172__auto____1.call(this,state_33943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12172__auto____0;
cljs$core$async$state_machine__12172__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12172__auto____1;
return cljs$core$async$state_machine__12172__auto__;
})()
;})(switch__12171__auto__,c__12283__auto___33977,out))
})();
var state__12285__auto__ = (function (){var statearr_33972 = (f__12284__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12284__auto__.cljs$core$IFn$_invoke$arity$0() : f__12284__auto__.call(null));
(statearr_33972[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12283__auto___33977);

return statearr_33972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12285__auto__);
});})(c__12283__auto___33977,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

