// Compiled by ClojureScript 1.9.229 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__19553__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__19550 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__19551 = cljs.core.seq.call(null,vec__19550);
var first__19552 = cljs.core.first.call(null,seq__19551);
var seq__19551__$1 = cljs.core.next.call(null,seq__19551);
var tag = first__19552;
var body = seq__19551__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__19553 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__19554__i = 0, G__19554__a = new Array(arguments.length -  0);
while (G__19554__i < G__19554__a.length) {G__19554__a[G__19554__i] = arguments[G__19554__i + 0]; ++G__19554__i;}
  args = new cljs.core.IndexedSeq(G__19554__a,0);
} 
return G__19553__delegate.call(this,args);};
G__19553.cljs$lang$maxFixedArity = 0;
G__19553.cljs$lang$applyTo = (function (arglist__19555){
var args = cljs.core.seq(arglist__19555);
return G__19553__delegate(args);
});
G__19553.cljs$core$IFn$_invoke$arity$variadic = G__19553__delegate;
return G__19553;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__19560(s__19561){
return (new cljs.core.LazySeq(null,(function (){
var s__19561__$1 = s__19561;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19561__$1);
if(temp__4657__auto__){
var s__19561__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19561__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19561__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19563 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19562 = (0);
while(true){
if((i__19562 < size__7188__auto__)){
var args = cljs.core._nth.call(null,c__7187__auto__,i__19562);
cljs.core.chunk_append.call(null,b__19563,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__19564 = (i__19562 + (1));
i__19562 = G__19564;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19563),sablono$core$update_arglists_$_iter__19560.call(null,cljs.core.chunk_rest.call(null,s__19561__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19563),null);
}
} else {
var args = cljs.core.first.call(null,s__19561__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__19560.call(null,cljs.core.rest.call(null,s__19561__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19570 = arguments.length;
var i__7485__auto___19571 = (0);
while(true){
if((i__7485__auto___19571 < len__7484__auto___19570)){
args__7491__auto__.push((arguments[i__7485__auto___19571]));

var G__19572 = (i__7485__auto___19571 + (1));
i__7485__auto___19571 = G__19572;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__19566(s__19567){
return (new cljs.core.LazySeq(null,(function (){
var s__19567__$1 = s__19567;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19567__$1);
if(temp__4657__auto__){
var s__19567__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19567__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19567__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19569 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19568 = (0);
while(true){
if((i__19568 < size__7188__auto__)){
var style = cljs.core._nth.call(null,c__7187__auto__,i__19568);
cljs.core.chunk_append.call(null,b__19569,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__19573 = (i__19568 + (1));
i__19568 = G__19573;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19569),sablono$core$iter__19566.call(null,cljs.core.chunk_rest.call(null,s__19567__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19569),null);
}
} else {
var style = cljs.core.first.call(null,s__19567__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__19566.call(null,cljs.core.rest.call(null,s__19567__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq19565){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq19565));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to19574 = (function sablono$core$link_to19574(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19577 = arguments.length;
var i__7485__auto___19578 = (0);
while(true){
if((i__7485__auto___19578 < len__7484__auto___19577)){
args__7491__auto__.push((arguments[i__7485__auto___19578]));

var G__19579 = (i__7485__auto___19578 + (1));
i__7485__auto___19578 = G__19579;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to19574.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to19574.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to19574.cljs$lang$maxFixedArity = (1);

sablono.core.link_to19574.cljs$lang$applyTo = (function (seq19575){
var G__19576 = cljs.core.first.call(null,seq19575);
var seq19575__$1 = cljs.core.next.call(null,seq19575);
return sablono.core.link_to19574.cljs$core$IFn$_invoke$arity$variadic(G__19576,seq19575__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to19574);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to19580 = (function sablono$core$mail_to19580(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19587 = arguments.length;
var i__7485__auto___19588 = (0);
while(true){
if((i__7485__auto___19588 < len__7484__auto___19587)){
args__7491__auto__.push((arguments[i__7485__auto___19588]));

var G__19589 = (i__7485__auto___19588 + (1));
i__7485__auto___19588 = G__19589;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to19580.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to19580.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__19583){
var vec__19584 = p__19583;
var content = cljs.core.nth.call(null,vec__19584,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to19580.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to19580.cljs$lang$applyTo = (function (seq19581){
var G__19582 = cljs.core.first.call(null,seq19581);
var seq19581__$1 = cljs.core.next.call(null,seq19581);
return sablono.core.mail_to19580.cljs$core$IFn$_invoke$arity$variadic(G__19582,seq19581__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to19580);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list19590 = (function sablono$core$unordered_list19590(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__7189__auto__ = (function sablono$core$unordered_list19590_$_iter__19595(s__19596){
return (new cljs.core.LazySeq(null,(function (){
var s__19596__$1 = s__19596;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19596__$1);
if(temp__4657__auto__){
var s__19596__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19596__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19596__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19598 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19597 = (0);
while(true){
if((i__19597 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19597);
cljs.core.chunk_append.call(null,b__19598,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19599 = (i__19597 + (1));
i__19597 = G__19599;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19598),sablono$core$unordered_list19590_$_iter__19595.call(null,cljs.core.chunk_rest.call(null,s__19596__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19598),null);
}
} else {
var x = cljs.core.first.call(null,s__19596__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list19590_$_iter__19595.call(null,cljs.core.rest.call(null,s__19596__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list19590);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list19600 = (function sablono$core$ordered_list19600(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__7189__auto__ = (function sablono$core$ordered_list19600_$_iter__19605(s__19606){
return (new cljs.core.LazySeq(null,(function (){
var s__19606__$1 = s__19606;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19606__$1);
if(temp__4657__auto__){
var s__19606__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19606__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19606__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19608 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19607 = (0);
while(true){
if((i__19607 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19607);
cljs.core.chunk_append.call(null,b__19608,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__19609 = (i__19607 + (1));
i__19607 = G__19609;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19608),sablono$core$ordered_list19600_$_iter__19605.call(null,cljs.core.chunk_rest.call(null,s__19606__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19608),null);
}
} else {
var x = cljs.core.first.call(null,s__19606__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list19600_$_iter__19605.call(null,cljs.core.rest.call(null,s__19606__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list19600);
/**
 * Create an image element.
 */
sablono.core.image19610 = (function sablono$core$image19610(var_args){
var args19611 = [];
var len__7484__auto___19614 = arguments.length;
var i__7485__auto___19615 = (0);
while(true){
if((i__7485__auto___19615 < len__7484__auto___19614)){
args19611.push((arguments[i__7485__auto___19615]));

var G__19616 = (i__7485__auto___19615 + (1));
i__7485__auto___19615 = G__19616;
continue;
} else {
}
break;
}

var G__19613 = args19611.length;
switch (G__19613) {
case 1:
return sablono.core.image19610.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image19610.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19611.length)].join('')));

}
});

sablono.core.image19610.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image19610.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image19610.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image19610);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__19618_SHARP_,p2__19619_SHARP_){
return [cljs.core.str(p1__19618_SHARP_),cljs.core.str("["),cljs.core.str(p2__19619_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__19620_SHARP_,p2__19621_SHARP_){
return [cljs.core.str(p1__19620_SHARP_),cljs.core.str("-"),cljs.core.str(p2__19621_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field19622 = (function sablono$core$color_field19622(var_args){
var args19623 = [];
var len__7484__auto___19690 = arguments.length;
var i__7485__auto___19691 = (0);
while(true){
if((i__7485__auto___19691 < len__7484__auto___19690)){
args19623.push((arguments[i__7485__auto___19691]));

var G__19692 = (i__7485__auto___19691 + (1));
i__7485__auto___19691 = G__19692;
continue;
} else {
}
break;
}

var G__19625 = args19623.length;
switch (G__19625) {
case 1:
return sablono.core.color_field19622.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field19622.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19623.length)].join('')));

}
});

sablono.core.color_field19622.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.color_field19622.call(null,name__19467__auto__,null);
});

sablono.core.color_field19622.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.color_field19622.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field19622);

/**
 * Creates a date input field.
 */
sablono.core.date_field19626 = (function sablono$core$date_field19626(var_args){
var args19627 = [];
var len__7484__auto___19694 = arguments.length;
var i__7485__auto___19695 = (0);
while(true){
if((i__7485__auto___19695 < len__7484__auto___19694)){
args19627.push((arguments[i__7485__auto___19695]));

var G__19696 = (i__7485__auto___19695 + (1));
i__7485__auto___19695 = G__19696;
continue;
} else {
}
break;
}

var G__19629 = args19627.length;
switch (G__19629) {
case 1:
return sablono.core.date_field19626.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field19626.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19627.length)].join('')));

}
});

sablono.core.date_field19626.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.date_field19626.call(null,name__19467__auto__,null);
});

sablono.core.date_field19626.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.date_field19626.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field19626);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field19630 = (function sablono$core$datetime_field19630(var_args){
var args19631 = [];
var len__7484__auto___19698 = arguments.length;
var i__7485__auto___19699 = (0);
while(true){
if((i__7485__auto___19699 < len__7484__auto___19698)){
args19631.push((arguments[i__7485__auto___19699]));

var G__19700 = (i__7485__auto___19699 + (1));
i__7485__auto___19699 = G__19700;
continue;
} else {
}
break;
}

var G__19633 = args19631.length;
switch (G__19633) {
case 1:
return sablono.core.datetime_field19630.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field19630.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19631.length)].join('')));

}
});

sablono.core.datetime_field19630.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.datetime_field19630.call(null,name__19467__auto__,null);
});

sablono.core.datetime_field19630.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.datetime_field19630.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field19630);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field19634 = (function sablono$core$datetime_local_field19634(var_args){
var args19635 = [];
var len__7484__auto___19702 = arguments.length;
var i__7485__auto___19703 = (0);
while(true){
if((i__7485__auto___19703 < len__7484__auto___19702)){
args19635.push((arguments[i__7485__auto___19703]));

var G__19704 = (i__7485__auto___19703 + (1));
i__7485__auto___19703 = G__19704;
continue;
} else {
}
break;
}

var G__19637 = args19635.length;
switch (G__19637) {
case 1:
return sablono.core.datetime_local_field19634.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field19634.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19635.length)].join('')));

}
});

sablono.core.datetime_local_field19634.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.datetime_local_field19634.call(null,name__19467__auto__,null);
});

sablono.core.datetime_local_field19634.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.datetime_local_field19634.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field19634);

/**
 * Creates a email input field.
 */
sablono.core.email_field19638 = (function sablono$core$email_field19638(var_args){
var args19639 = [];
var len__7484__auto___19706 = arguments.length;
var i__7485__auto___19707 = (0);
while(true){
if((i__7485__auto___19707 < len__7484__auto___19706)){
args19639.push((arguments[i__7485__auto___19707]));

var G__19708 = (i__7485__auto___19707 + (1));
i__7485__auto___19707 = G__19708;
continue;
} else {
}
break;
}

var G__19641 = args19639.length;
switch (G__19641) {
case 1:
return sablono.core.email_field19638.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field19638.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19639.length)].join('')));

}
});

sablono.core.email_field19638.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.email_field19638.call(null,name__19467__auto__,null);
});

sablono.core.email_field19638.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.email_field19638.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field19638);

/**
 * Creates a file input field.
 */
sablono.core.file_field19642 = (function sablono$core$file_field19642(var_args){
var args19643 = [];
var len__7484__auto___19710 = arguments.length;
var i__7485__auto___19711 = (0);
while(true){
if((i__7485__auto___19711 < len__7484__auto___19710)){
args19643.push((arguments[i__7485__auto___19711]));

var G__19712 = (i__7485__auto___19711 + (1));
i__7485__auto___19711 = G__19712;
continue;
} else {
}
break;
}

var G__19645 = args19643.length;
switch (G__19645) {
case 1:
return sablono.core.file_field19642.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field19642.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19643.length)].join('')));

}
});

sablono.core.file_field19642.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.file_field19642.call(null,name__19467__auto__,null);
});

sablono.core.file_field19642.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.file_field19642.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field19642);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field19646 = (function sablono$core$hidden_field19646(var_args){
var args19647 = [];
var len__7484__auto___19714 = arguments.length;
var i__7485__auto___19715 = (0);
while(true){
if((i__7485__auto___19715 < len__7484__auto___19714)){
args19647.push((arguments[i__7485__auto___19715]));

var G__19716 = (i__7485__auto___19715 + (1));
i__7485__auto___19715 = G__19716;
continue;
} else {
}
break;
}

var G__19649 = args19647.length;
switch (G__19649) {
case 1:
return sablono.core.hidden_field19646.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field19646.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19647.length)].join('')));

}
});

sablono.core.hidden_field19646.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.hidden_field19646.call(null,name__19467__auto__,null);
});

sablono.core.hidden_field19646.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.hidden_field19646.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field19646);

/**
 * Creates a month input field.
 */
sablono.core.month_field19650 = (function sablono$core$month_field19650(var_args){
var args19651 = [];
var len__7484__auto___19718 = arguments.length;
var i__7485__auto___19719 = (0);
while(true){
if((i__7485__auto___19719 < len__7484__auto___19718)){
args19651.push((arguments[i__7485__auto___19719]));

var G__19720 = (i__7485__auto___19719 + (1));
i__7485__auto___19719 = G__19720;
continue;
} else {
}
break;
}

var G__19653 = args19651.length;
switch (G__19653) {
case 1:
return sablono.core.month_field19650.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field19650.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19651.length)].join('')));

}
});

sablono.core.month_field19650.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.month_field19650.call(null,name__19467__auto__,null);
});

sablono.core.month_field19650.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.month_field19650.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field19650);

/**
 * Creates a number input field.
 */
sablono.core.number_field19654 = (function sablono$core$number_field19654(var_args){
var args19655 = [];
var len__7484__auto___19722 = arguments.length;
var i__7485__auto___19723 = (0);
while(true){
if((i__7485__auto___19723 < len__7484__auto___19722)){
args19655.push((arguments[i__7485__auto___19723]));

var G__19724 = (i__7485__auto___19723 + (1));
i__7485__auto___19723 = G__19724;
continue;
} else {
}
break;
}

var G__19657 = args19655.length;
switch (G__19657) {
case 1:
return sablono.core.number_field19654.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field19654.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19655.length)].join('')));

}
});

sablono.core.number_field19654.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.number_field19654.call(null,name__19467__auto__,null);
});

sablono.core.number_field19654.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.number_field19654.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field19654);

/**
 * Creates a password input field.
 */
sablono.core.password_field19658 = (function sablono$core$password_field19658(var_args){
var args19659 = [];
var len__7484__auto___19726 = arguments.length;
var i__7485__auto___19727 = (0);
while(true){
if((i__7485__auto___19727 < len__7484__auto___19726)){
args19659.push((arguments[i__7485__auto___19727]));

var G__19728 = (i__7485__auto___19727 + (1));
i__7485__auto___19727 = G__19728;
continue;
} else {
}
break;
}

var G__19661 = args19659.length;
switch (G__19661) {
case 1:
return sablono.core.password_field19658.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field19658.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19659.length)].join('')));

}
});

sablono.core.password_field19658.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.password_field19658.call(null,name__19467__auto__,null);
});

sablono.core.password_field19658.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.password_field19658.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field19658);

/**
 * Creates a range input field.
 */
sablono.core.range_field19662 = (function sablono$core$range_field19662(var_args){
var args19663 = [];
var len__7484__auto___19730 = arguments.length;
var i__7485__auto___19731 = (0);
while(true){
if((i__7485__auto___19731 < len__7484__auto___19730)){
args19663.push((arguments[i__7485__auto___19731]));

var G__19732 = (i__7485__auto___19731 + (1));
i__7485__auto___19731 = G__19732;
continue;
} else {
}
break;
}

var G__19665 = args19663.length;
switch (G__19665) {
case 1:
return sablono.core.range_field19662.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field19662.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19663.length)].join('')));

}
});

sablono.core.range_field19662.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.range_field19662.call(null,name__19467__auto__,null);
});

sablono.core.range_field19662.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.range_field19662.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field19662);

/**
 * Creates a search input field.
 */
sablono.core.search_field19666 = (function sablono$core$search_field19666(var_args){
var args19667 = [];
var len__7484__auto___19734 = arguments.length;
var i__7485__auto___19735 = (0);
while(true){
if((i__7485__auto___19735 < len__7484__auto___19734)){
args19667.push((arguments[i__7485__auto___19735]));

var G__19736 = (i__7485__auto___19735 + (1));
i__7485__auto___19735 = G__19736;
continue;
} else {
}
break;
}

var G__19669 = args19667.length;
switch (G__19669) {
case 1:
return sablono.core.search_field19666.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field19666.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19667.length)].join('')));

}
});

sablono.core.search_field19666.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.search_field19666.call(null,name__19467__auto__,null);
});

sablono.core.search_field19666.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.search_field19666.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field19666);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field19670 = (function sablono$core$tel_field19670(var_args){
var args19671 = [];
var len__7484__auto___19738 = arguments.length;
var i__7485__auto___19739 = (0);
while(true){
if((i__7485__auto___19739 < len__7484__auto___19738)){
args19671.push((arguments[i__7485__auto___19739]));

var G__19740 = (i__7485__auto___19739 + (1));
i__7485__auto___19739 = G__19740;
continue;
} else {
}
break;
}

var G__19673 = args19671.length;
switch (G__19673) {
case 1:
return sablono.core.tel_field19670.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field19670.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19671.length)].join('')));

}
});

sablono.core.tel_field19670.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.tel_field19670.call(null,name__19467__auto__,null);
});

sablono.core.tel_field19670.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.tel_field19670.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field19670);

/**
 * Creates a text input field.
 */
sablono.core.text_field19674 = (function sablono$core$text_field19674(var_args){
var args19675 = [];
var len__7484__auto___19742 = arguments.length;
var i__7485__auto___19743 = (0);
while(true){
if((i__7485__auto___19743 < len__7484__auto___19742)){
args19675.push((arguments[i__7485__auto___19743]));

var G__19744 = (i__7485__auto___19743 + (1));
i__7485__auto___19743 = G__19744;
continue;
} else {
}
break;
}

var G__19677 = args19675.length;
switch (G__19677) {
case 1:
return sablono.core.text_field19674.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field19674.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19675.length)].join('')));

}
});

sablono.core.text_field19674.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.text_field19674.call(null,name__19467__auto__,null);
});

sablono.core.text_field19674.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.text_field19674.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field19674);

/**
 * Creates a time input field.
 */
sablono.core.time_field19678 = (function sablono$core$time_field19678(var_args){
var args19679 = [];
var len__7484__auto___19746 = arguments.length;
var i__7485__auto___19747 = (0);
while(true){
if((i__7485__auto___19747 < len__7484__auto___19746)){
args19679.push((arguments[i__7485__auto___19747]));

var G__19748 = (i__7485__auto___19747 + (1));
i__7485__auto___19747 = G__19748;
continue;
} else {
}
break;
}

var G__19681 = args19679.length;
switch (G__19681) {
case 1:
return sablono.core.time_field19678.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field19678.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19679.length)].join('')));

}
});

sablono.core.time_field19678.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.time_field19678.call(null,name__19467__auto__,null);
});

sablono.core.time_field19678.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.time_field19678.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field19678);

/**
 * Creates a url input field.
 */
sablono.core.url_field19682 = (function sablono$core$url_field19682(var_args){
var args19683 = [];
var len__7484__auto___19750 = arguments.length;
var i__7485__auto___19751 = (0);
while(true){
if((i__7485__auto___19751 < len__7484__auto___19750)){
args19683.push((arguments[i__7485__auto___19751]));

var G__19752 = (i__7485__auto___19751 + (1));
i__7485__auto___19751 = G__19752;
continue;
} else {
}
break;
}

var G__19685 = args19683.length;
switch (G__19685) {
case 1:
return sablono.core.url_field19682.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field19682.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19683.length)].join('')));

}
});

sablono.core.url_field19682.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.url_field19682.call(null,name__19467__auto__,null);
});

sablono.core.url_field19682.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.url_field19682.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field19682);

/**
 * Creates a week input field.
 */
sablono.core.week_field19686 = (function sablono$core$week_field19686(var_args){
var args19687 = [];
var len__7484__auto___19754 = arguments.length;
var i__7485__auto___19755 = (0);
while(true){
if((i__7485__auto___19755 < len__7484__auto___19754)){
args19687.push((arguments[i__7485__auto___19755]));

var G__19756 = (i__7485__auto___19755 + (1));
i__7485__auto___19755 = G__19756;
continue;
} else {
}
break;
}

var G__19689 = args19687.length;
switch (G__19689) {
case 1:
return sablono.core.week_field19686.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field19686.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19687.length)].join('')));

}
});

sablono.core.week_field19686.cljs$core$IFn$_invoke$arity$1 = (function (name__19467__auto__){
return sablono.core.week_field19686.call(null,name__19467__auto__,null);
});

sablono.core.week_field19686.cljs$core$IFn$_invoke$arity$2 = (function (name__19467__auto__,value__19468__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__19467__auto__,value__19468__auto__);
});

sablono.core.week_field19686.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field19686);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box19758 = (function sablono$core$check_box19758(var_args){
var args19759 = [];
var len__7484__auto___19762 = arguments.length;
var i__7485__auto___19763 = (0);
while(true){
if((i__7485__auto___19763 < len__7484__auto___19762)){
args19759.push((arguments[i__7485__auto___19763]));

var G__19764 = (i__7485__auto___19763 + (1));
i__7485__auto___19763 = G__19764;
continue;
} else {
}
break;
}

var G__19761 = args19759.length;
switch (G__19761) {
case 1:
return sablono.core.check_box19758.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box19758.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box19758.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19759.length)].join('')));

}
});

sablono.core.check_box19758.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box19758.call(null,name,null);
});

sablono.core.check_box19758.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box19758.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box19758.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box19758.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box19758);
/**
 * Creates a radio button.
 */
sablono.core.radio_button19766 = (function sablono$core$radio_button19766(var_args){
var args19767 = [];
var len__7484__auto___19770 = arguments.length;
var i__7485__auto___19771 = (0);
while(true){
if((i__7485__auto___19771 < len__7484__auto___19770)){
args19767.push((arguments[i__7485__auto___19771]));

var G__19772 = (i__7485__auto___19771 + (1));
i__7485__auto___19771 = G__19772;
continue;
} else {
}
break;
}

var G__19769 = args19767.length;
switch (G__19769) {
case 1:
return sablono.core.radio_button19766.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button19766.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button19766.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19767.length)].join('')));

}
});

sablono.core.radio_button19766.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button19766.call(null,group,null);
});

sablono.core.radio_button19766.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button19766.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button19766.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button19766.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button19766);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options19774 = (function sablono$core$select_options19774(var_args){
var args19775 = [];
var len__7484__auto___19794 = arguments.length;
var i__7485__auto___19795 = (0);
while(true){
if((i__7485__auto___19795 < len__7484__auto___19794)){
args19775.push((arguments[i__7485__auto___19795]));

var G__19796 = (i__7485__auto___19795 + (1));
i__7485__auto___19795 = G__19796;
continue;
} else {
}
break;
}

var G__19777 = args19775.length;
switch (G__19777) {
case 1:
return sablono.core.select_options19774.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options19774.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19775.length)].join('')));

}
});

sablono.core.select_options19774.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options19774.call(null,coll,null);
});

sablono.core.select_options19774.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__19778(s__19779){
return (new cljs.core.LazySeq(null,(function (){
var s__19779__$1 = s__19779;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__19779__$1);
if(temp__4657__auto__){
var s__19779__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__19779__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__19779__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__19781 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__19780 = (0);
while(true){
if((i__19780 < size__7188__auto__)){
var x = cljs.core._nth.call(null,c__7187__auto__,i__19780);
cljs.core.chunk_append.call(null,b__19781,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19788 = x;
var text = cljs.core.nth.call(null,vec__19788,(0),null);
var val = cljs.core.nth.call(null,vec__19788,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19788,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19774.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)));

var G__19798 = (i__19780 + (1));
i__19780 = G__19798;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19781),sablono$core$iter__19778.call(null,cljs.core.chunk_rest.call(null,s__19779__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__19781),null);
}
} else {
var x = cljs.core.first.call(null,s__19779__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__19791 = x;
var text = cljs.core.nth.call(null,vec__19791,(0),null);
var val = cljs.core.nth.call(null,vec__19791,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__19791,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options19774.call(null,val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",574897764),cljs.core._EQ_.call(null,x,selected)], null),x], null)),sablono$core$iter__19778.call(null,cljs.core.rest.call(null,s__19779__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,coll);
});

sablono.core.select_options19774.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options19774);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down19799 = (function sablono$core$drop_down19799(var_args){
var args19800 = [];
var len__7484__auto___19803 = arguments.length;
var i__7485__auto___19804 = (0);
while(true){
if((i__7485__auto___19804 < len__7484__auto___19803)){
args19800.push((arguments[i__7485__auto___19804]));

var G__19805 = (i__7485__auto___19804 + (1));
i__7485__auto___19804 = G__19805;
continue;
} else {
}
break;
}

var G__19802 = args19800.length;
switch (G__19802) {
case 2:
return sablono.core.drop_down19799.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down19799.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19800.length)].join('')));

}
});

sablono.core.drop_down19799.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down19799.call(null,name,options,null);
});

sablono.core.drop_down19799.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down19799.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down19799);
/**
 * Creates a text area element.
 */
sablono.core.text_area19807 = (function sablono$core$text_area19807(var_args){
var args19808 = [];
var len__7484__auto___19811 = arguments.length;
var i__7485__auto___19812 = (0);
while(true){
if((i__7485__auto___19812 < len__7484__auto___19811)){
args19808.push((arguments[i__7485__auto___19812]));

var G__19813 = (i__7485__auto___19812 + (1));
i__7485__auto___19812 = G__19813;
continue;
} else {
}
break;
}

var G__19810 = args19808.length;
switch (G__19810) {
case 1:
return sablono.core.text_area19807.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area19807.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19808.length)].join('')));

}
});

sablono.core.text_area19807.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area19807.call(null,name,null);
});

sablono.core.text_area19807.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),value], null)], null);
});

sablono.core.text_area19807.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area19807);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label19815 = (function sablono$core$label19815(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label19815);
/**
 * Creates a submit button.
 */
sablono.core.submit_button19816 = (function sablono$core$submit_button19816(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button19816);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button19817 = (function sablono$core$reset_button19817(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button19817);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to19818 = (function sablono$core$form_to19818(var_args){
var args__7491__auto__ = [];
var len__7484__auto___19825 = arguments.length;
var i__7485__auto___19826 = (0);
while(true){
if((i__7485__auto___19826 < len__7484__auto___19825)){
args__7491__auto__.push((arguments[i__7485__auto___19826]));

var G__19827 = (i__7485__auto___19826 + (1));
i__7485__auto___19826 = G__19827;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to19818.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to19818.cljs$core$IFn$_invoke$arity$variadic = (function (p__19821,body){
var vec__19822 = p__19821;
var method = cljs.core.nth.call(null,vec__19822,(0),null);
var action = cljs.core.nth.call(null,vec__19822,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
});

sablono.core.form_to19818.cljs$lang$maxFixedArity = (1);

sablono.core.form_to19818.cljs$lang$applyTo = (function (seq19819){
var G__19820 = cljs.core.first.call(null,seq19819);
var seq19819__$1 = cljs.core.next.call(null,seq19819);
return sablono.core.form_to19818.cljs$core$IFn$_invoke$arity$variadic(G__19820,seq19819__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to19818);
