// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('hatti.utils.submission_review');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),true))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__25329_SHARP_){
if(typeof p1__25329_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__25329_SHARP_);
} else {
return p1__25329_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__25335){
var vec__25336 = p__25335;
var fname = cljs.core.nth.call(null,vec__25336,(0),null);
var answer = cljs.core.nth.call(null,vec__25336,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__25330_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__25330_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var media_count = (dataContext["_media_count"]);
var total_media = (dataContext["_total_media"]);
return hatti.ona.forms.format_answer.call(null,field,chimera.string.escape_for_type.call(null,clj_value),new cljs.core.Keyword(null,"language","language",-1591107564),language,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true,new cljs.core.Keyword(null,"field-key","field-key",313262601),field_key,new cljs.core.Keyword(null,"media-count","media-count",1579124405),media_count,new cljs.core.Keyword(null,"total-media","total-media",1031250100),total_media);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__25339 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__25339__$1 = ((((!((map__25339 == null)))?((((map__25339.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25339.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25339):map__25339);
var owner__$1 = cljs.core.get.call(null,map__25339__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__25339__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__25339__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input.delete-record","input.delete-record",-1708576930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip.middle-right","li.tooltip.middle-right",-548323211),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-eye","i.fa.fa-eye",-1428531423),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil","i.fa.fa-pencil",1547895857)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.table.submission_review_fields = (function hatti$views$table$submission_review_fields(cols){
var vec__25344 = cljs.core.split_at.call(null,(1),cols);
var actions = cljs.core.nth.call(null,vec__25344,(0),null);
var data = cljs.core.nth.call(null,vec__25344,(1),null);
return cljs.core.vec.call(null,cljs.core.flatten.call(null,cljs.core.conj.call(null,data,hatti.ona.forms.review_comment_field,hatti.ona.forms.review_status_field,actions)));
});
cljs.core._add_method.call(null,hatti.views.actions_column,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
}));
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___25375 = arguments.length;
var i__7485__auto___25376 = (0);
while(true){
if((i__7485__auto___25376 < len__7484__auto___25375)){
args__7491__auto__.push((arguments[i__7485__auto___25376]));

var G__25377 = (i__7485__auto___25376 + (1));
i__7485__auto___25376 = G__25377;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__25350){
var map__25351 = p__25350;
var map__25351__$1 = ((((!((map__25351 == null)))?((((map__25351.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25351.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25351):map__25351);
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25351__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var submission_review_QMARK_ = cljs.core.get.call(null,map__25351__$1,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375));
var get_label_QMARK_ = cljs.core.get.call(null,map__25351__$1,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),true);
var language = cljs.core.get.call(null,map__25351__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var owner = cljs.core.get.call(null,map__25351__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = chimera.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__25351,map__25351__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__25347_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__25347_SHARP_)) == null);
});})(map__25351,map__25351__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__25351,map__25351__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__25353(s__25354){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__25351,map__25351__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__25354__$1 = s__25354;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25354__$1);
if(temp__4657__auto__){
var s__25354__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25354__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25354__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25356 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25355 = (0);
while(true){
if((i__25355 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__25355);
cljs.core.chunk_append.call(null,b__25356,(function (){var map__25365 = field;
var map__25365__$1 = ((((!((map__25365 == null)))?((((map__25365.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25365.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25365):map__25365);
var map__25366 = cljs.core.get.call(null,map__25365__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25366__$1 = ((((!((map__25366 == null)))?((((map__25366.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25366.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25366):map__25366);
var hxl = cljs.core.get.call(null,map__25366__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25365__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25365__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25365__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__25378 = (i__25355 + (1));
i__25355 = G__25378;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25356),hatti$views$table$iter__25353.call(null,cljs.core.chunk_rest.call(null,s__25354__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25356),null);
}
} else {
var field = cljs.core.first.call(null,s__25354__$2);
return cljs.core.cons.call(null,(function (){var map__25369 = field;
var map__25369__$1 = ((((!((map__25369 == null)))?((((map__25369.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25369.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25369):map__25369);
var map__25370 = cljs.core.get.call(null,map__25369__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25370__$1 = ((((!((map__25370 == null)))?((((map__25370.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25370.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25370):map__25370);
var hxl = cljs.core.get.call(null,map__25370__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25369__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25369__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25369__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__25353.call(null,cljs.core.rest.call(null,s__25354__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__25351,map__25351__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__25351,map__25351__$1,hide_actions_column_QMARK_,submission_review_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__.call(null,(function (){var G__25373 = hatti.views.table.all_fields.call(null,form);
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.submission_review_fields.call(null,G__25373);
} else {
return G__25373;
}
})());
})();
return cljs.core.clj__GT_js.call(null,(function (){var G__25374 = columns;
if(cljs.core.not.call(null,hide_actions_column_QMARK_)){
return cljs.core.conj.call(null,G__25374,hatti.views.actions_column.call(null,owner,has_hxl_QMARK_));
} else {
return G__25374;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq25348){
var G__25349 = cljs.core.first.call(null,seq25348);
var seq25348__$1 = cljs.core.next.call(null,seq25348);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__25349,seq25348__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25395(s__25396){
return (new cljs.core.LazySeq(null,(function (){
var s__25396__$1 = s__25396;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25396__$1);
if(temp__4657__auto__){
var s__25396__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25396__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25396__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25398 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25397 = (0);
while(true){
if((i__25397 < size__7188__auto__)){
var vec__25405 = cljs.core._nth.call(null,c__7187__auto__,i__25397);
var handler_key = cljs.core.nth.call(null,vec__25405,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25405,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__25398,event.subscribe(handler_function));

var G__25411 = (i__25397 + (1));
i__25397 = G__25411;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25398),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25395.call(null,cljs.core.chunk_rest.call(null,s__25396__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25398),null);
}
} else {
var vec__25408 = cljs.core.first.call(null,s__25396__$2);
var handler_key = cljs.core.nth.call(null,vec__25408,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25408,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25395.call(null,cljs.core.rest.call(null,s__25396__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25428(s__25429){
return (new cljs.core.LazySeq(null,(function (){
var s__25429__$1 = s__25429;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25429__$1);
if(temp__4657__auto__){
var s__25429__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25429__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25429__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25431 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25430 = (0);
while(true){
if((i__25430 < size__7188__auto__)){
var vec__25438 = cljs.core._nth.call(null,c__7187__auto__,i__25430);
var handler_key = cljs.core.nth.call(null,vec__25438,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25438,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__25431,event.subscribe(handler_function));

var G__25444 = (i__25430 + (1));
i__25430 = G__25444;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25431),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25428.call(null,cljs.core.chunk_rest.call(null,s__25429__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25431),null);
}
} else {
var vec__25441 = cljs.core.first.call(null,s__25429__$2);
var handler_key = cljs.core.nth.call(null,vec__25441,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25441,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25428.call(null,cljs.core.rest.call(null,s__25429__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__25447 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25447__$1 = ((((!((map__25447 == null)))?((((map__25447.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25447.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25447):map__25447);
var data_to_be_deleted = cljs.core.get.call(null,map__25447__$1,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634));
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634)], null),((function (map__25447,map__25447__$1,data_to_be_deleted,fn){
return (function (){
return fn.call(null,data_to_be_deleted,data_id);
});})(map__25447,map__25447__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,[cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.call(null,selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector.call(null,data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__25453 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
var chunk__25454 = null;
var count__25455 = (0);
var i__25456 = (0);
while(true){
if((i__25456 < count__25455)){
var data_id = cljs.core._nth.call(null,chunk__25454,i__25456);
var element_25457 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25457.checked = true;

var G__25458 = seq__25453;
var G__25459 = chunk__25454;
var G__25460 = count__25455;
var G__25461 = (i__25456 + (1));
seq__25453 = G__25458;
chunk__25454 = G__25459;
count__25455 = G__25460;
i__25456 = G__25461;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__25453);
if(temp__4657__auto__){
var seq__25453__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25453__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__25453__$1);
var G__25462 = cljs.core.chunk_rest.call(null,seq__25453__$1);
var G__25463 = c__7220__auto__;
var G__25464 = cljs.core.count.call(null,c__7220__auto__);
var G__25465 = (0);
seq__25453 = G__25462;
chunk__25454 = G__25463;
count__25455 = G__25464;
i__25456 = G__25465;
continue;
} else {
var data_id = cljs.core.first.call(null,seq__25453__$1);
var element_25466 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25466.checked = true;

var G__25467 = cljs.core.next.call(null,seq__25453__$1);
var G__25468 = null;
var G__25469 = (0);
var G__25470 = (0);
seq__25453 = G__25467;
chunk__25454 = G__25468;
count__25455 = G__25469;
i__25456 = G__25470;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map_indexed.call(null,((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity.call(null,indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,indexes_of_selected_checkboxes));
});
hatti.views.table.replace_review_num_status_with_text_status = (function hatti$views$table$replace_review_num_status_with_text_status(data){
return cljs.core.map.call(null,(function (row_map){
return cljs.core.assoc.call(null,row_map,"_review_status",hatti.utils.submission_review.get_submission_review_text.call(null,row_map));
}),data);
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__25471){
var map__25487 = p__25471;
var map__25487__$1 = ((((!((map__25487 == null)))?((((map__25487.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25487.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25487):map__25487);
var grid_event_handlers = cljs.core.get.call(null,map__25487__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__25487__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var map__25489 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25489__$1 = ((((!((map__25489 == null)))?((((map__25489.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25489.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25489):map__25489);
var map__25490 = cljs.core.get.call(null,map__25489__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25490__$1 = ((((!((map__25490 == null)))?((((map__25490.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25490.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25490):map__25490);
var map__25491 = cljs.core.get.call(null,map__25490__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__25491__$1 = ((((!((map__25491 == null)))?((((map__25491.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25491.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25491):map__25491);
var num_displayed_records = cljs.core.get.call(null,map__25491__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__25491__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25490__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var submission_review_QMARK_ = cljs.core.get.call(null,map__25489__$1,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,new cljs.core.Keyword(null,"language","language",-1591107564),current_language,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),hide_actions_column_QMARK_,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375),submission_review_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selectActiveRow","selectActiveRow",-841772687),false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted.call(null);

return hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
});})(map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
if(cljs.core._EQ_.call(null,hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__25495_25502 = cljs.core.seq.call(null,records_to_be_deleted);
var chunk__25496_25503 = null;
var count__25497_25504 = (0);
var i__25498_25505 = (0);
while(true){
if((i__25498_25505 < count__25497_25504)){
var record_25506 = cljs.core._nth.call(null,chunk__25496_25503,i__25498_25505);
record_25506.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25506.getAttribute("data-id")));

var G__25507 = seq__25495_25502;
var G__25508 = chunk__25496_25503;
var G__25509 = count__25497_25504;
var G__25510 = (i__25498_25505 + (1));
seq__25495_25502 = G__25507;
chunk__25496_25503 = G__25508;
count__25497_25504 = G__25509;
i__25498_25505 = G__25510;
continue;
} else {
var temp__4657__auto___25511 = cljs.core.seq.call(null,seq__25495_25502);
if(temp__4657__auto___25511){
var seq__25495_25512__$1 = temp__4657__auto___25511;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25495_25512__$1)){
var c__7220__auto___25513 = cljs.core.chunk_first.call(null,seq__25495_25512__$1);
var G__25514 = cljs.core.chunk_rest.call(null,seq__25495_25512__$1);
var G__25515 = c__7220__auto___25513;
var G__25516 = cljs.core.count.call(null,c__7220__auto___25513);
var G__25517 = (0);
seq__25495_25502 = G__25514;
chunk__25496_25503 = G__25515;
count__25497_25504 = G__25516;
i__25498_25505 = G__25517;
continue;
} else {
var record_25518 = cljs.core.first.call(null,seq__25495_25512__$1);
record_25518.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25518.getAttribute("data-id")));

var G__25519 = cljs.core.next.call(null,seq__25495_25512__$1);
var G__25520 = null;
var G__25521 = (0);
var G__25522 = (0);
seq__25495_25502 = G__25519;
chunk__25496_25503 = G__25520;
count__25497_25504 = G__25521;
i__25498_25505 = G__25522;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.call(null,total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
return null;
}
});})(map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__25499 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25499__$1 = ((((!((map__25499 == null)))?((((map__25499.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25499.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25499):map__25499);
var selected_table_rows = cljs.core.get.call(null,map__25499__$1,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745));
if(cljs.core._EQ_.call(null,class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = parseInt(grid.getCellFromEvent(e).row);
hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_.call(null);

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25499,map__25499__$1,selected_table_rows,map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return fn.call(null,selected_table_rows,row__$1);
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25499,map__25499__$1,selected_table_rows,map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
}
});})(map__25489,map__25489__$1,map__25490,map__25490__$1,map__25491,map__25491__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,submission_review_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25487,map__25487__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,(function (){var G__25501 = data;
if(cljs.core.truth_(submission_review_QMARK_)){
return hatti.views.table.replace_review_num_status_with_text_status.call(null,G__25501);
} else {
return G__25501;
}
})()),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__13879__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__,event_chan){
return (function (state_25814){
var state_val_25815 = (state_25814[(1)]);
if((state_val_25815 === (7))){
var inst_25712 = (state_25814[(7)]);
var inst_25712__$1 = (state_25814[(2)]);
var inst_25714 = (inst_25712__$1 == null);
var inst_25715 = cljs.core.not.call(null,inst_25714);
var state_25814__$1 = (function (){var statearr_25816 = state_25814;
(statearr_25816[(7)] = inst_25712__$1);

return statearr_25816;
})();
if(inst_25715){
var statearr_25817_25892 = state_25814__$1;
(statearr_25817_25892[(1)] = (8));

} else {
var statearr_25818_25893 = state_25814__$1;
(statearr_25818_25893[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (20))){
var inst_25734 = (state_25814[(8)]);
var inst_25742 = (state_25814[(9)]);
var inst_25751 = inst_25742.call(null,inst_25734);
var state_25814__$1 = state_25814;
var statearr_25819_25894 = state_25814__$1;
(statearr_25819_25894[(2)] = inst_25751);

(statearr_25819_25894[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (27))){
var state_25814__$1 = state_25814;
var statearr_25820_25895 = state_25814__$1;
(statearr_25820_25895[(2)] = null);

(statearr_25820_25895[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (1))){
var state_25814__$1 = state_25814;
var statearr_25821_25896 = state_25814__$1;
(statearr_25821_25896[(2)] = null);

(statearr_25821_25896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (24))){
var state_25814__$1 = state_25814;
var statearr_25822_25897 = state_25814__$1;
(statearr_25822_25897[(2)] = null);

(statearr_25822_25897[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (4))){
var state_25814__$1 = state_25814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25814__$1,(7),event_chan);
} else {
if((state_val_25815 === (15))){
var inst_25712 = (state_25814[(7)]);
var state_25814__$1 = state_25814;
var statearr_25823_25898 = state_25814__$1;
(statearr_25823_25898[(2)] = inst_25712);

(statearr_25823_25898[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (21))){
var state_25814__$1 = state_25814;
var statearr_25824_25899 = state_25814__$1;
(statearr_25824_25899[(2)] = null);

(statearr_25824_25899[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (31))){
var inst_25738 = (state_25814[(10)]);
var inst_25787 = (state_25814[(2)]);
var inst_25788 = cljs.core._EQ_.call(null,inst_25738,new cljs.core.Keyword(null,"table","table",-564943036));
var state_25814__$1 = (function (){var statearr_25825 = state_25814;
(statearr_25825[(11)] = inst_25787);

return statearr_25825;
})();
if(inst_25788){
var statearr_25826_25900 = state_25814__$1;
(statearr_25826_25900[(1)] = (32));

} else {
var statearr_25827_25901 = state_25814__$1;
(statearr_25827_25901[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (32))){
var inst_25743 = (state_25814[(12)]);
var inst_25736 = (state_25814[(13)]);
var inst_25735 = (state_25814[(14)]);
var inst_25734 = (state_25814[(8)]);
var inst_25737 = (state_25814[(15)]);
var inst_25738 = (state_25814[(10)]);
var inst_25732 = (state_25814[(16)]);
var inst_25742 = (state_25814[(9)]);
var inst_25733 = (state_25814[(17)]);
var inst_25801 = cljs.core.async.chan.call(null,(1));
var inst_25802 = (function (){var new_columns = inst_25737;
var submission_clicked = inst_25734;
var submission_unclicked = inst_25735;
var get_submission_data = inst_25743;
var re_render = inst_25738;
var update_data_BANG_ = inst_25742;
var map__25710 = inst_25732;
var submission_to_rank = inst_25733;
var filter_by = inst_25736;
var c__13879__auto____$1 = inst_25801;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25801,state_val_25815,c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25801,state_val_25815,c__13879__auto__,event_chan){
return (function (state_25799){
var state_val_25800 = (state_25799[(1)]);
if((state_val_25800 === (1))){
var inst_25790 = cljs.core.async.timeout.call(null,(20));
var state_25799__$1 = state_25799;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25799__$1,(2),inst_25790);
} else {
if((state_val_25800 === (2))){
var inst_25792 = (state_25799[(2)]);
var inst_25793 = grid.resizeCanvas();
var inst_25794 = grid.invalidateAllRows();
var inst_25795 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25796 = grid.render();
var inst_25797 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_25799__$1 = (function (){var statearr_25828 = state_25799;
(statearr_25828[(7)] = inst_25796);

(statearr_25828[(8)] = inst_25793);

(statearr_25828[(9)] = inst_25792);

(statearr_25828[(10)] = inst_25795);

(statearr_25828[(11)] = inst_25794);

return statearr_25828;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25799__$1,inst_25797);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25801,state_val_25815,c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25801,state_val_25815,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_25832 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25832[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_25832[(1)] = (1));

return statearr_25832;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_25799){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_25799);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e25833){if((e25833 instanceof Object)){
var ex__13771__auto__ = e25833;
var statearr_25834_25902 = state_25799;
(statearr_25834_25902[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25799);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25833;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25903 = state_25799;
state_25799 = G__25903;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_25799){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_25799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25801,state_val_25815,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_25835 = f__13880__auto__.call(null);
(statearr_25835[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto____$1);

return statearr_25835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25801,state_val_25815,c__13879__auto__,event_chan))
})();
var inst_25803 = cljs.core.async.impl.dispatch.run.call(null,inst_25802);
var state_25814__$1 = (function (){var statearr_25836 = state_25814;
(statearr_25836[(18)] = inst_25803);

return statearr_25836;
})();
var statearr_25837_25904 = state_25814__$1;
(statearr_25837_25904[(2)] = inst_25801);

(statearr_25837_25904[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (33))){
var state_25814__$1 = state_25814;
var statearr_25838_25905 = state_25814__$1;
(statearr_25838_25905[(2)] = null);

(statearr_25838_25905[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (13))){
var inst_25724 = (state_25814[(2)]);
var state_25814__$1 = state_25814;
var statearr_25839_25906 = state_25814__$1;
(statearr_25839_25906[(2)] = inst_25724);

(statearr_25839_25906[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (22))){
var inst_25735 = (state_25814[(14)]);
var inst_25754 = (state_25814[(2)]);
var state_25814__$1 = (function (){var statearr_25840 = state_25814;
(statearr_25840[(19)] = inst_25754);

return statearr_25840;
})();
if(cljs.core.truth_(inst_25735)){
var statearr_25841_25907 = state_25814__$1;
(statearr_25841_25907[(1)] = (23));

} else {
var statearr_25842_25908 = state_25814__$1;
(statearr_25842_25908[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (29))){
var inst_25736 = (state_25814[(13)]);
var inst_25779 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_25780 = [inst_25736];
var inst_25781 = cljs.core.PersistentHashMap.fromArrays(inst_25779,inst_25780);
var inst_25782 = cljs.core.clj__GT_js.call(null,inst_25781);
var inst_25783 = dataview.setFilterArgs(inst_25782);
var inst_25784 = dataview.refresh();
var state_25814__$1 = (function (){var statearr_25843 = state_25814;
(statearr_25843[(20)] = inst_25783);

return statearr_25843;
})();
var statearr_25844_25909 = state_25814__$1;
(statearr_25844_25909[(2)] = inst_25784);

(statearr_25844_25909[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (6))){
var inst_25810 = (state_25814[(2)]);
var state_25814__$1 = state_25814;
var statearr_25845_25910 = state_25814__$1;
(statearr_25845_25910[(2)] = inst_25810);

(statearr_25845_25910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (28))){
var inst_25736 = (state_25814[(13)]);
var inst_25777 = (state_25814[(2)]);
var state_25814__$1 = (function (){var statearr_25846 = state_25814;
(statearr_25846[(21)] = inst_25777);

return statearr_25846;
})();
if(cljs.core.truth_(inst_25736)){
var statearr_25847_25911 = state_25814__$1;
(statearr_25847_25911[(1)] = (29));

} else {
var statearr_25848_25912 = state_25814__$1;
(statearr_25848_25912[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (25))){
var inst_25737 = (state_25814[(15)]);
var inst_25759 = (state_25814[(2)]);
var state_25814__$1 = (function (){var statearr_25849 = state_25814;
(statearr_25849[(22)] = inst_25759);

return statearr_25849;
})();
if(cljs.core.truth_(inst_25737)){
var statearr_25850_25913 = state_25814__$1;
(statearr_25850_25913[(1)] = (26));

} else {
var statearr_25851_25914 = state_25814__$1;
(statearr_25851_25914[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (34))){
var inst_25806 = (state_25814[(2)]);
var state_25814__$1 = (function (){var statearr_25852 = state_25814;
(statearr_25852[(23)] = inst_25806);

return statearr_25852;
})();
var statearr_25853_25915 = state_25814__$1;
(statearr_25853_25915[(2)] = null);

(statearr_25853_25915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (17))){
var inst_25743 = (state_25814[(12)]);
var inst_25742 = (state_25814[(9)]);
var inst_25733 = (state_25814[(17)]);
var inst_25745 = inst_25743.call(null,hatti.constants._rank,inst_25733);
var inst_25746 = inst_25742.call(null,inst_25745);
var state_25814__$1 = state_25814;
var statearr_25854_25916 = state_25814__$1;
(statearr_25854_25916[(2)] = inst_25746);

(statearr_25854_25916[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (3))){
var inst_25812 = (state_25814[(2)]);
var state_25814__$1 = state_25814;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25814__$1,inst_25812);
} else {
if((state_val_25815 === (12))){
var state_25814__$1 = state_25814;
var statearr_25855_25917 = state_25814__$1;
(statearr_25855_25917[(2)] = false);

(statearr_25855_25917[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (2))){
var state_25814__$1 = state_25814;
var statearr_25856_25918 = state_25814__$1;
(statearr_25856_25918[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (23))){
var inst_25742 = (state_25814[(9)]);
var inst_25756 = inst_25742.call(null,null);
var state_25814__$1 = state_25814;
var statearr_25858_25919 = state_25814__$1;
(statearr_25858_25919[(2)] = inst_25756);

(statearr_25858_25919[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (19))){
var inst_25734 = (state_25814[(8)]);
var inst_25749 = (state_25814[(2)]);
var state_25814__$1 = (function (){var statearr_25859 = state_25814;
(statearr_25859[(24)] = inst_25749);

return statearr_25859;
})();
if(cljs.core.truth_(inst_25734)){
var statearr_25860_25920 = state_25814__$1;
(statearr_25860_25920[(1)] = (20));

} else {
var statearr_25861_25921 = state_25814__$1;
(statearr_25861_25921[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (11))){
var state_25814__$1 = state_25814;
var statearr_25862_25922 = state_25814__$1;
(statearr_25862_25922[(2)] = true);

(statearr_25862_25922[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (9))){
var state_25814__$1 = state_25814;
var statearr_25863_25923 = state_25814__$1;
(statearr_25863_25923[(2)] = false);

(statearr_25863_25923[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (5))){
var state_25814__$1 = state_25814;
var statearr_25864_25924 = state_25814__$1;
(statearr_25864_25924[(2)] = null);

(statearr_25864_25924[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (14))){
var inst_25712 = (state_25814[(7)]);
var inst_25729 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25712);
var state_25814__$1 = state_25814;
var statearr_25865_25925 = state_25814__$1;
(statearr_25865_25925[(2)] = inst_25729);

(statearr_25865_25925[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (26))){
var inst_25743 = (state_25814[(12)]);
var inst_25736 = (state_25814[(13)]);
var inst_25735 = (state_25814[(14)]);
var inst_25734 = (state_25814[(8)]);
var inst_25737 = (state_25814[(15)]);
var inst_25738 = (state_25814[(10)]);
var inst_25732 = (state_25814[(16)]);
var inst_25742 = (state_25814[(9)]);
var inst_25733 = (state_25814[(17)]);
var inst_25772 = cljs.core.async.chan.call(null,(1));
var inst_25773 = (function (){var new_columns = inst_25737;
var submission_clicked = inst_25734;
var submission_unclicked = inst_25735;
var get_submission_data = inst_25743;
var re_render = inst_25738;
var update_data_BANG_ = inst_25742;
var map__25710 = inst_25732;
var submission_to_rank = inst_25733;
var filter_by = inst_25736;
var c__13879__auto____$1 = inst_25772;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25772,state_val_25815,c__13879__auto__,event_chan){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25772,state_val_25815,c__13879__auto__,event_chan){
return (function (state_25770){
var state_val_25771 = (state_25770[(1)]);
if((state_val_25771 === (1))){
var inst_25761 = cljs.core.async.timeout.call(null,(20));
var state_25770__$1 = state_25770;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25770__$1,(2),inst_25761);
} else {
if((state_val_25771 === (2))){
var inst_25763 = (state_25770[(2)]);
var inst_25764 = grid.setColumns(new_columns);
var inst_25765 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25766 = grid.render();
var inst_25767 = hatti.views.table.select_rows_marked_to_be_deleted.call(null);
var inst_25768 = hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
var state_25770__$1 = (function (){var statearr_25866 = state_25770;
(statearr_25866[(7)] = inst_25766);

(statearr_25866[(8)] = inst_25765);

(statearr_25866[(9)] = inst_25767);

(statearr_25866[(10)] = inst_25764);

(statearr_25866[(11)] = inst_25763);

return statearr_25866;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25770__$1,inst_25768);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25772,state_val_25815,c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25772,state_val_25815,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_25870 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25870[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_25870[(1)] = (1));

return statearr_25870;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_25770){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_25770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e25871){if((e25871 instanceof Object)){
var ex__13771__auto__ = e25871;
var statearr_25872_25926 = state_25770;
(statearr_25872_25926[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25770);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25871;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25927 = state_25770;
state_25770 = G__25927;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_25770){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_25770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25772,state_val_25815,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_25873 = f__13880__auto__.call(null);
(statearr_25873[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto____$1);

return statearr_25873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,map__25710,submission_to_rank,filter_by,c__13879__auto____$1,inst_25743,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25772,state_val_25815,c__13879__auto__,event_chan))
})();
var inst_25774 = cljs.core.async.impl.dispatch.run.call(null,inst_25773);
var state_25814__$1 = (function (){var statearr_25874 = state_25814;
(statearr_25874[(25)] = inst_25774);

return statearr_25874;
})();
var statearr_25875_25928 = state_25814__$1;
(statearr_25875_25928[(2)] = inst_25772);

(statearr_25875_25928[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (16))){
var inst_25736 = (state_25814[(13)]);
var inst_25735 = (state_25814[(14)]);
var inst_25734 = (state_25814[(8)]);
var inst_25737 = (state_25814[(15)]);
var inst_25738 = (state_25814[(10)]);
var inst_25732 = (state_25814[(16)]);
var inst_25742 = (state_25814[(9)]);
var inst_25733 = (state_25814[(17)]);
var inst_25732__$1 = (state_25814[(2)]);
var inst_25733__$1 = cljs.core.get.call(null,inst_25732__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_25734__$1 = cljs.core.get.call(null,inst_25732__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_25735__$1 = cljs.core.get.call(null,inst_25732__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_25736__$1 = cljs.core.get.call(null,inst_25732__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_25737__$1 = cljs.core.get.call(null,inst_25732__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_25738__$1 = cljs.core.get.call(null,inst_25732__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_25739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25740 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_25741 = (new cljs.core.PersistentVector(null,3,(5),inst_25739,inst_25740,null));
var inst_25742__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_25741);
var inst_25743 = (function (){var map__25710 = inst_25732__$1;
var submission_to_rank = inst_25733__$1;
var submission_clicked = inst_25734__$1;
var submission_unclicked = inst_25735__$1;
var filter_by = inst_25736__$1;
var new_columns = inst_25737__$1;
var re_render = inst_25738__$1;
var update_data_BANG_ = inst_25742__$1;
return ((function (map__25710,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736__$1,inst_25737__$1,inst_25738__$1,inst_25739,inst_25740,inst_25741,inst_25742__$1,state_val_25815,c__13879__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__25710,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736__$1,inst_25737__$1,inst_25738__$1,inst_25739,inst_25740,inst_25741,inst_25742__$1,state_val_25815,c__13879__auto__,event_chan){
return (function (p1__25523_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__25523_SHARP_,field));
});})(map__25710,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736__$1,inst_25737__$1,inst_25738__$1,inst_25739,inst_25740,inst_25741,inst_25742__$1,state_val_25815,c__13879__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(map__25710,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25736,inst_25735,inst_25734,inst_25737,inst_25738,inst_25732,inst_25742,inst_25733,inst_25732__$1,inst_25733__$1,inst_25734__$1,inst_25735__$1,inst_25736__$1,inst_25737__$1,inst_25738__$1,inst_25739,inst_25740,inst_25741,inst_25742__$1,state_val_25815,c__13879__auto__,event_chan))
})();
var state_25814__$1 = (function (){var statearr_25876 = state_25814;
(statearr_25876[(12)] = inst_25743);

(statearr_25876[(13)] = inst_25736__$1);

(statearr_25876[(14)] = inst_25735__$1);

(statearr_25876[(8)] = inst_25734__$1);

(statearr_25876[(15)] = inst_25737__$1);

(statearr_25876[(10)] = inst_25738__$1);

(statearr_25876[(16)] = inst_25732__$1);

(statearr_25876[(9)] = inst_25742__$1);

(statearr_25876[(17)] = inst_25733__$1);

return statearr_25876;
})();
if(cljs.core.truth_(inst_25733__$1)){
var statearr_25877_25929 = state_25814__$1;
(statearr_25877_25929[(1)] = (17));

} else {
var statearr_25878_25930 = state_25814__$1;
(statearr_25878_25930[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (30))){
var state_25814__$1 = state_25814;
var statearr_25879_25931 = state_25814__$1;
(statearr_25879_25931[(2)] = null);

(statearr_25879_25931[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (10))){
var inst_25727 = (state_25814[(2)]);
var state_25814__$1 = state_25814;
if(cljs.core.truth_(inst_25727)){
var statearr_25880_25932 = state_25814__$1;
(statearr_25880_25932[(1)] = (14));

} else {
var statearr_25881_25933 = state_25814__$1;
(statearr_25881_25933[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (18))){
var state_25814__$1 = state_25814;
var statearr_25882_25934 = state_25814__$1;
(statearr_25882_25934[(2)] = null);

(statearr_25882_25934[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25815 === (8))){
var inst_25712 = (state_25814[(7)]);
var inst_25717 = inst_25712.cljs$lang$protocol_mask$partition0$;
var inst_25718 = (inst_25717 & (64));
var inst_25719 = inst_25712.cljs$core$ISeq$;
var inst_25720 = (inst_25718) || (inst_25719);
var state_25814__$1 = state_25814;
if(cljs.core.truth_(inst_25720)){
var statearr_25883_25935 = state_25814__$1;
(statearr_25883_25935[(1)] = (11));

} else {
var statearr_25884_25936 = state_25814__$1;
(statearr_25884_25936[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13879__auto__,event_chan))
;
return ((function (switch__13767__auto__,c__13879__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____0 = (function (){
var statearr_25888 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25888[(0)] = hatti$views$table$handle_table_events_$_state_machine__13768__auto__);

(statearr_25888[(1)] = (1));

return statearr_25888;
});
var hatti$views$table$handle_table_events_$_state_machine__13768__auto____1 = (function (state_25814){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_25814);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e25889){if((e25889 instanceof Object)){
var ex__13771__auto__ = e25889;
var statearr_25890_25937 = state_25814;
(statearr_25890_25937[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25814);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25889;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25938 = state_25814;
state_25814 = G__25938;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13768__auto__ = function(state_25814){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13768__auto____1.call(this,state_25814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13768__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__,event_chan))
})();
var state__13881__auto__ = (function (){var statearr_25891 = f__13880__auto__.call(null);
(statearr_25891[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_25891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto__,event_chan))
);

return c__13879__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"field-key","field-key",313262601),k);

return colset_BANG_.call(null,k);
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__25955(s__25956){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__25956__$1 = s__25956;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25956__$1);
if(temp__4657__auto__){
var s__25956__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25956__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25956__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25958 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25957 = (0);
while(true){
if((i__25957 < size__7188__auto__)){
var vec__25965 = cljs.core._nth.call(null,c__7187__auto__,i__25957);
var k = cljs.core.nth.call(null,vec__25965,(0),null);
var v = cljs.core.nth.call(null,vec__25965,(1),null);
cljs.core.chunk_append.call(null,b__25958,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__25957,vec__25965,k,v,c__7187__auto__,size__7188__auto__,b__25958,s__25956__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__25957,vec__25965,k,v,c__7187__auto__,size__7188__auto__,b__25958,s__25956__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__25971 = (i__25957 + (1));
i__25957 = G__25971;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25958),hatti$views$table$render_options_$_iter__25955.call(null,cljs.core.chunk_rest.call(null,s__25956__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25958),null);
}
} else {
var vec__25968 = cljs.core.first.call(null,s__25956__$2);
var k = cljs.core.nth.call(null,vec__25968,(0),null);
var v = cljs.core.nth.call(null,vec__25968,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__25968,k,v,s__25956__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__25968,k,v,s__25956__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__25955.call(null,cljs.core.rest.call(null,s__25956__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table25973 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25973 = (function (_,owner,meta25974){
this._ = _;
this.owner = owner;
this.meta25974 = meta25974;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25973.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25975,meta25974__$1){
var self__ = this;
var _25975__$1 = this;
return (new hatti.views.table.t_hatti$views$table25973(self__._,self__.owner,meta25974__$1));
});

hatti.views.table.t_hatti$views$table25973.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25975){
var self__ = this;
var _25975__$1 = this;
return self__.meta25974;
});

hatti.views.table.t_hatti$views$table25973.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table25973.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field-key","field-key",313262601),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table25973.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25973.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__25976){
var self__ = this;
var map__25977 = p__25976;
var map__25977__$1 = ((((!((map__25977 == null)))?((((map__25977.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25977.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25977):map__25977);
var field_key = cljs.core.get.call(null,map__25977__$1,new cljs.core.Keyword(null,"field-key","field-key",313262601));
var language = cljs.core.get.call(null,map__25977__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__25979 = om.core.get_shared.call(null,self__.owner);
var map__25979__$1 = ((((!((map__25979 == null)))?((((map__25979.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25979.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25979):map__25979);
var flat_form = cljs.core.get.call(null,map__25979__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var map__25980 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25980__$1 = ((((!((map__25980 == null)))?((((map__25980.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25980.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25980):map__25980);
var submission_review_QMARK_ = cljs.core.get.call(null,map__25980__$1,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375));
var colset_BANG_ = ((function (options,map__25979,map__25979__$1,flat_form,new_language,map__25980,map__25980__$1,submission_review_QMARK_,___$2,map__25977,map__25977__$1,field_key,language){
return (function (p1__25972_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__25972_SHARP_),new cljs.core.Keyword(null,"language","language",-1591107564),new_language,new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375),submission_review_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),self__.owner)], null));
});})(options,map__25979,map__25979__$1,flat_form,new_language,map__25980,map__25980__$1,submission_review_QMARK_,___$2,map__25977,map__25977__$1,field_key,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,field_key);
} else {
}

return React.DOM.div(({"className": "label-changer"}),React.DOM.span(({"className": "label-changer-label"}),"Show:"),React.DOM.div(({"id": "header-display-dropdown", "className": "drop-hover"}),(function (){var attrs25985 = options.call(null,field_key);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs25985))?sablono.interpreter.attributes.call(null,attrs25985):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25985))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i(({"className": "fa fa-angle-down"}))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25985),React.DOM.i(({"className": "fa fa-angle-down"}))], null))));
})(),(function (){var attrs25990 = hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_);
return cljs.core.apply.call(null,React.DOM.ul,((cljs.core.map_QMARK_.call(null,attrs25990))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs25990)):({"className": "submenu no-dot"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25990))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25990)], null))));
})()));
});

hatti.views.table.t_hatti$views$table25973.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25974","meta25974",-236071838,null)], null);
});

hatti.views.table.t_hatti$views$table25973.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25973.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25973";

hatti.views.table.t_hatti$views$table25973.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25973");
});

hatti.views.table.__GT_t_hatti$views$table25973 = (function hatti$views$table$__GT_t_hatti$views$table25973(___$1,owner__$1,meta25974){
return (new hatti.views.table.t_hatti$views$table25973(___$1,owner__$1,meta25974));
});

}

return (new hatti.views.table.t_hatti$views$table25973(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__13879__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13879__auto__,query){
return (function (){
var f__13880__auto__ = (function (){var switch__13767__auto__ = ((function (c__13879__auto__,query){
return (function (state_26033){
var state_val_26034 = (state_26033[(1)]);
if((state_val_26034 === (1))){
var inst_26019 = cljs.core.async.timeout.call(null,(150));
var state_26033__$1 = state_26033;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26033__$1,(2),inst_26019);
} else {
if((state_val_26034 === (2))){
var inst_26021 = (state_26033[(2)]);
var inst_26022 = input.value;
var inst_26023 = cljs.core._EQ_.call(null,query,inst_26022);
var state_26033__$1 = (function (){var statearr_26035 = state_26033;
(statearr_26035[(7)] = inst_26021);

return statearr_26035;
})();
if(inst_26023){
var statearr_26036_26047 = state_26033__$1;
(statearr_26036_26047[(1)] = (3));

} else {
var statearr_26037_26048 = state_26033__$1;
(statearr_26037_26048[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26034 === (3))){
var inst_26025 = [query_event_key];
var inst_26026 = [query];
var inst_26027 = cljs.core.PersistentHashMap.fromArrays(inst_26025,inst_26026);
var inst_26028 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_26027);
var state_26033__$1 = state_26033;
var statearr_26038_26049 = state_26033__$1;
(statearr_26038_26049[(2)] = inst_26028);

(statearr_26038_26049[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26034 === (4))){
var state_26033__$1 = state_26033;
var statearr_26039_26050 = state_26033__$1;
(statearr_26039_26050[(2)] = null);

(statearr_26039_26050[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26034 === (5))){
var inst_26031 = (state_26033[(2)]);
var state_26033__$1 = state_26033;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26033__$1,inst_26031);
} else {
return null;
}
}
}
}
}
});})(c__13879__auto__,query))
;
return ((function (switch__13767__auto__,c__13879__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__13768__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__13768__auto____0 = (function (){
var statearr_26043 = [null,null,null,null,null,null,null,null];
(statearr_26043[(0)] = hatti$views$table$delayed_search_$_state_machine__13768__auto__);

(statearr_26043[(1)] = (1));

return statearr_26043;
});
var hatti$views$table$delayed_search_$_state_machine__13768__auto____1 = (function (state_26033){
while(true){
var ret_value__13769__auto__ = (function (){try{while(true){
var result__13770__auto__ = switch__13767__auto__.call(null,state_26033);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13770__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13770__auto__;
}
break;
}
}catch (e26044){if((e26044 instanceof Object)){
var ex__13771__auto__ = e26044;
var statearr_26045_26051 = state_26033;
(statearr_26045_26051[(5)] = ex__13771__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26033);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26044;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13769__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26052 = state_26033;
state_26033 = G__26052;
continue;
} else {
return ret_value__13769__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__13768__auto__ = function(state_26033){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__13768__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__13768__auto____1.call(this,state_26033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__13768__auto____0;
hatti$views$table$delayed_search_$_state_machine__13768__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__13768__auto____1;
return hatti$views$table$delayed_search_$_state_machine__13768__auto__;
})()
;})(switch__13767__auto__,c__13879__auto__,query))
})();
var state__13881__auto__ = (function (){var statearr_26046 = f__13880__auto__.call(null);
(statearr_26046[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13879__auto__);

return statearr_26046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13881__auto__);
});})(c__13879__auto__,query))
);

return c__13879__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table26054 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26054 = (function (_,owner,meta26055){
this._ = _;
this.owner = owner;
this.meta26055 = meta26055;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26054.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26056,meta26055__$1){
var self__ = this;
var _26056__$1 = this;
return (new hatti.views.table.t_hatti$views$table26054(self__._,self__.owner,meta26055__$1));
});

hatti.views.table.t_hatti$views$table26054.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26056){
var self__ = this;
var _26056__$1 = this;
return self__.meta26055;
});

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
return React.DOM.div(({"className": "table-search"}),React.DOM.i(({"className": "fa fa-search"})),sablono.interpreter.input.call(null,({"type": "text", "placeholder": "Search", "onChange": ((function (this__18222__auto____$1){
return (function (p1__26053_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__26053_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__18222__auto____$1))
})));
});

hatti.views.table.t_hatti$views$table26054.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26055","meta26055",-562425111,null)], null);
});

hatti.views.table.t_hatti$views$table26054.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26054.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26054";

hatti.views.table.t_hatti$views$table26054.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26054");
});

hatti.views.table.__GT_t_hatti$views$table26054 = (function hatti$views$table$__GT_t_hatti$views$table26054(___$1,owner__$1,meta26055){
return (new hatti.views.table.t_hatti$views$table26054(___$1,owner__$1,meta26055));
});

}

return (new hatti.views.table.t_hatti$views$table26054(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table26059 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26059 = (function (cursor,owner,meta26060){
this.cursor = cursor;
this.owner = owner;
this.meta26060 = meta26060;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26059.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26061,meta26060__$1){
var self__ = this;
var _26061__$1 = this;
return (new hatti.views.table.t_hatti$views$table26059(self__.cursor,self__.owner,meta26060__$1));
});

hatti.views.table.t_hatti$views$table26059.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26061){
var self__ = this;
var _26061__$1 = this;
return self__.meta26060;
});

hatti.views.table.t_hatti$views$table26059.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26059.prototype.om$core$IRender$render$arity$1 = (function (this__18222__auto__){
var self__ = this;
var this__18222__auto____$1 = this;
return React.DOM.div(({"className": "topbar"}),React.DOM.div(({"id": hatti.views.table.pager_id})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,self__.cursor)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.cursor)),React.DOM.div(({"style": ({"clear": "both"})})));
});

hatti.views.table.t_hatti$views$table26059.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26060","meta26060",-69354236,null)], null);
});

hatti.views.table.t_hatti$views$table26059.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26059.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26059";

hatti.views.table.t_hatti$views$table26059.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26059");
});

hatti.views.table.__GT_t_hatti$views$table26059 = (function hatti$views$table$__GT_t_hatti$views$table26059(cursor__$1,owner__$1,meta26060){
return (new hatti.views.table.t_hatti$views$table26059(cursor__$1,owner__$1,meta26060));
});

}

return (new hatti.views.table.t_hatti$views$table26059(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq.call(null,data)){
var map__26069 = om.core.get_shared.call(null,owner);
var map__26069__$1 = ((((!((map__26069 == null)))?((((map__26069.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26069.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26069):map__26069);
var flat_form = cljs.core.get.call(null,map__26069__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__26070 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__26070,(0),null);
var dataview = cljs.core.nth.call(null,vec__26070,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".table-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901),hatti.views.table.get_table_view_height.call(null));
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__26075,owner,p__26076){
var map__26077 = p__26075;
var map__26077__$1 = ((((!((map__26077 == null)))?((((map__26077.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26077.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26077):map__26077);
var cursor = map__26077__$1;
var map__26078 = cljs.core.get.call(null,map__26077__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__26078__$1 = ((((!((map__26078 == null)))?((((map__26078.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26078.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26078):map__26078);
var active = cljs.core.get.call(null,map__26078__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var map__26079 = p__26076;
var map__26079__$1 = ((((!((map__26079 == null)))?((((map__26079.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26079.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26079):map__26079);
var opts = map__26079__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__26079__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

var active_QMARK_ = chimera.seq.in_QMARK_.call(null,active,new cljs.core.Keyword(null,"table","table",-564943036));
if(typeof hatti.views.table.t_hatti$views$table26083 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26083 = (function (map__26078,map__26079,owner,active_QMARK_,map__26077,slick_grid_event_handlers,cursor,p__26075,active,p__26076,opts,meta26084){
this.map__26078 = map__26078;
this.map__26079 = map__26079;
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.map__26077 = map__26077;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.cursor = cursor;
this.p__26075 = p__26075;
this.active = active;
this.p__26076 = p__26076;
this.opts = opts;
this.meta26084 = meta26084;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26083.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers){
return (function (_26085,meta26084__$1){
var self__ = this;
var _26085__$1 = this;
return (new hatti.views.table.t_hatti$views$table26083(self__.map__26078,self__.map__26079,self__.owner,self__.active_QMARK_,self__.map__26077,self__.slick_grid_event_handlers,self__.cursor,self__.p__26075,self__.active,self__.p__26076,self__.opts,meta26084__$1));
});})(active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26083.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers){
return (function (_26085){
var self__ = this;
var _26085__$1 = this;
return self__.meta26084;
});})(active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26083.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table26083.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers){
return (function (_,p__26086){
var self__ = this;
var map__26087 = p__26086;
var map__26087__$1 = ((((!((map__26087 == null)))?((((map__26087.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26087.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26087):map__26087);
var table_view_height = cljs.core.get.call(null,map__26087__$1,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901));
var ___$1 = this;
var map__26089 = self__.cursor;
var map__26089__$1 = ((((!((map__26089 == null)))?((((map__26089.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26089.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26089):map__26089);
var map__26090 = cljs.core.get.call(null,map__26089__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__26090__$1 = ((((!((map__26090 == null)))?((((map__26090.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26090.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26090):map__26090);
var submission_clicked = cljs.core.get.call(null,map__26090__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var data = cljs.core.get.call(null,map__26089__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__26089__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var map__26091 = dataset_info;
var map__26091__$1 = ((((!((map__26091 == null)))?((((map__26091.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26091.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26091):map__26091);
var num_of_submissions = cljs.core.get.call(null,map__26091__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,data);
var with_info = ((function (map__26089,map__26089__$1,map__26090,map__26090__$1,submission_clicked,data,dataset_info,map__26091,map__26091__$1,num_of_submissions,no_data_QMARK_,___$1,map__26087,map__26087__$1,table_view_height,active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers){
return (function (p1__26074_SHARP_){
return cljs.core.merge.call(null,self__.cursor,p1__26074_SHARP_);
});})(map__26089,map__26089__$1,map__26090,map__26090__$1,submission_clicked,data,dataset_info,map__26091,map__26091__$1,num_of_submissions,no_data_QMARK_,___$1,map__26087,map__26087__$1,table_view_height,active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers))
;
cljs.core.swap_BANG_.call(null,hatti.shared.app_state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901)], null),(((document.querySelector(".table-page") == null))?null:hatti.views.table.get_table_view_height.call(null)));

if(cljs.core.truth_(self__.active_QMARK_)){
return React.DOM.div(({"style": ({"overflow": "initial"}), "className": "table-view"}),sablono.interpreter.interpret.call(null,(cljs.core.truth_(new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.call(null,hatti.views.submission_view,with_info.call(null,submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null)):null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.cursor)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.p(({"className": "alert alert-warning"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading..."))));
} else {
return null;
}
});})(active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26083.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table26083.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler.call(null,self__.owner);

var data = cljs.core.get_in.call(null,self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26099 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__26099,(0),null);
var dataview = cljs.core.nth.call(null,vec__26099,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26083.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table26083.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.call(null,self__.owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881)));
});})(active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26083.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table26083.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__26102 = om.core.get_state.call(null,self__.owner);
var map__26102__$1 = ((((!((map__26102 == null)))?((((map__26102.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26102.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26102):map__26102);
var grid = cljs.core.get.call(null,map__26102__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__26102__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26104 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__26104,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__26104,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,(function (){var G__26107 = new_data;
if(cljs.core.truth_(new cljs.core.Keyword(null,"submission-review?","submission-review?",-315484375).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)))){
return hatti.views.table.replace_review_num_status_with_text_status.call(null,G__26107);
} else {
return G__26107;
}
})()),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26083.getBasis = ((function (active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"map__26078","map__26078",-1879814013,null),new cljs.core.Symbol(null,"map__26079","map__26079",1677510788,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"active?","active?",2100031303,null),new cljs.core.Symbol(null,"map__26077","map__26077",117600232,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"p__26075","p__26075",-593040139,null),new cljs.core.Symbol(null,"active","active",-758473701,null),new cljs.core.Symbol(null,"p__26076","p__26076",-1523205636,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"meta26084","meta26084",-656267727,null)], null);
});})(active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26083.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26083.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26083";

hatti.views.table.t_hatti$views$table26083.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26083");
});})(active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table26083 = ((function (active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table26083(map__26078__$2,map__26079__$2,owner__$1,active_QMARK___$1,map__26077__$2,slick_grid_event_handlers__$1,cursor__$1,p__26075__$1,active__$1,p__26076__$1,opts__$1,meta26084){
return (new hatti.views.table.t_hatti$views$table26083(map__26078__$2,map__26079__$2,owner__$1,active_QMARK___$1,map__26077__$2,slick_grid_event_handlers__$1,cursor__$1,p__26075__$1,active__$1,p__26076__$1,opts__$1,meta26084));
});})(active_QMARK_,map__26077,map__26077__$1,cursor,map__26078,map__26078__$1,active,map__26079,map__26079__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table26083(map__26078__$1,map__26079__$1,owner,active_QMARK_,map__26077__$1,slick_grid_event_handlers,cursor,p__26075,active,p__26076,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
