// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__37786__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__37783 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__37784 = cljs.core.seq(vec__37783);
var first__37785 = cljs.core.first(seq__37784);
var seq__37784__$1 = cljs.core.next(seq__37784);
var tag = first__37785;
var body = seq__37784__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__37786 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__37787__i = 0, G__37787__a = new Array(arguments.length -  0);
while (G__37787__i < G__37787__a.length) {G__37787__a[G__37787__i] = arguments[G__37787__i + 0]; ++G__37787__i;}
  args = new cljs.core.IndexedSeq(G__37787__a,0);
} 
return G__37786__delegate.call(this,args);};
G__37786.cljs$lang$maxFixedArity = 0;
G__37786.cljs$lang$applyTo = (function (arglist__37788){
var args = cljs.core.seq(arglist__37788);
return G__37786__delegate(args);
});
G__37786.cljs$core$IFn$_invoke$arity$variadic = G__37786__delegate;
return G__37786;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__37795(s__37796){
return (new cljs.core.LazySeq(null,(function (){
var s__37796__$1 = s__37796;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37796__$1);
if(temp__4657__auto__){
var s__37796__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37796__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37796__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37798 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37797 = (0);
while(true){
if((i__37797 < size__7188__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37797);
cljs.core.chunk_append(b__37798,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__37801 = (i__37797 + (1));
i__37797 = G__37801;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37798),sablono$core$update_arglists_$_iter__37795(cljs.core.chunk_rest(s__37796__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37798),null);
}
} else {
var args = cljs.core.first(s__37796__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__37795(cljs.core.rest(s__37796__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37809 = arguments.length;
var i__7485__auto___37810 = (0);
while(true){
if((i__7485__auto___37810 < len__7484__auto___37809)){
args__7491__auto__.push((arguments[i__7485__auto___37810]));

var G__37811 = (i__7485__auto___37810 + (1));
i__7485__auto___37810 = G__37811;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__37803(s__37804){
return (new cljs.core.LazySeq(null,(function (){
var s__37804__$1 = s__37804;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37804__$1);
if(temp__4657__auto__){
var s__37804__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37804__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37804__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37806 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37805 = (0);
while(true){
if((i__37805 < size__7188__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37805);
cljs.core.chunk_append(b__37806,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__37812 = (i__37805 + (1));
i__37805 = G__37812;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37806),sablono$core$iter__37803(cljs.core.chunk_rest(s__37804__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37806),null);
}
} else {
var style = cljs.core.first(s__37804__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__37803(cljs.core.rest(s__37804__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq37802){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37802));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__37817 = goog.dom.getDocument().body;
var G__37818 = (function (){var G__37819 = "script";
var G__37820 = ({"src": src});
return goog.dom.createDom(G__37819,G__37820);
})();
return goog.dom.appendChild(G__37817,G__37818);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to37821 = (function sablono$core$link_to37821(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37824 = arguments.length;
var i__7485__auto___37825 = (0);
while(true){
if((i__7485__auto___37825 < len__7484__auto___37824)){
args__7491__auto__.push((arguments[i__7485__auto___37825]));

var G__37826 = (i__7485__auto___37825 + (1));
i__7485__auto___37825 = G__37826;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to37821.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to37821.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to37821.cljs$lang$maxFixedArity = (1);

sablono.core.link_to37821.cljs$lang$applyTo = (function (seq37822){
var G__37823 = cljs.core.first(seq37822);
var seq37822__$1 = cljs.core.next(seq37822);
return sablono.core.link_to37821.cljs$core$IFn$_invoke$arity$variadic(G__37823,seq37822__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to37821);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to37827 = (function sablono$core$mail_to37827(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37834 = arguments.length;
var i__7485__auto___37835 = (0);
while(true){
if((i__7485__auto___37835 < len__7484__auto___37834)){
args__7491__auto__.push((arguments[i__7485__auto___37835]));

var G__37836 = (i__7485__auto___37835 + (1));
i__7485__auto___37835 = G__37836;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to37827.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to37827.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__37830){
var vec__37831 = p__37830;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37831,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to37827.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to37827.cljs$lang$applyTo = (function (seq37828){
var G__37829 = cljs.core.first(seq37828);
var seq37828__$1 = cljs.core.next(seq37828);
return sablono.core.mail_to37827.cljs$core$IFn$_invoke$arity$variadic(G__37829,seq37828__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to37827);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list37837 = (function sablono$core$unordered_list37837(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__7189__auto__ = (function sablono$core$unordered_list37837_$_iter__37844(s__37845){
return (new cljs.core.LazySeq(null,(function (){
var s__37845__$1 = s__37845;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37845__$1);
if(temp__4657__auto__){
var s__37845__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37845__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37845__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37847 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37846 = (0);
while(true){
if((i__37846 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37846);
cljs.core.chunk_append(b__37847,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37850 = (i__37846 + (1));
i__37846 = G__37850;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37847),sablono$core$unordered_list37837_$_iter__37844(cljs.core.chunk_rest(s__37845__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37847),null);
}
} else {
var x = cljs.core.first(s__37845__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list37837_$_iter__37844(cljs.core.rest(s__37845__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list37837);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list37851 = (function sablono$core$ordered_list37851(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__7189__auto__ = (function sablono$core$ordered_list37851_$_iter__37858(s__37859){
return (new cljs.core.LazySeq(null,(function (){
var s__37859__$1 = s__37859;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37859__$1);
if(temp__4657__auto__){
var s__37859__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37859__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37859__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37861 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37860 = (0);
while(true){
if((i__37860 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37860);
cljs.core.chunk_append(b__37861,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37864 = (i__37860 + (1));
i__37860 = G__37864;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37861),sablono$core$ordered_list37851_$_iter__37858(cljs.core.chunk_rest(s__37859__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37861),null);
}
} else {
var x = cljs.core.first(s__37859__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list37851_$_iter__37858(cljs.core.rest(s__37859__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list37851);
/**
 * Create an image element.
 */
sablono.core.image37865 = (function sablono$core$image37865(var_args){
var args37866 = [];
var len__7484__auto___37869 = arguments.length;
var i__7485__auto___37870 = (0);
while(true){
if((i__7485__auto___37870 < len__7484__auto___37869)){
args37866.push((arguments[i__7485__auto___37870]));

var G__37871 = (i__7485__auto___37870 + (1));
i__7485__auto___37870 = G__37871;
continue;
} else {
}
break;
}

var G__37868 = args37866.length;
switch (G__37868) {
case 1:
return sablono.core.image37865.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image37865.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37866.length)].join('')));

}
});

sablono.core.image37865.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image37865.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image37865.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image37865);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37873_SHARP_,p2__37874_SHARP_){
return [cljs.core.str(p1__37873_SHARP_),cljs.core.str("["),cljs.core.str(p2__37874_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37875_SHARP_,p2__37876_SHARP_){
return [cljs.core.str(p1__37875_SHARP_),cljs.core.str("-"),cljs.core.str(p2__37876_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field37877 = (function sablono$core$color_field37877(var_args){
var args37878 = [];
var len__7484__auto___37945 = arguments.length;
var i__7485__auto___37946 = (0);
while(true){
if((i__7485__auto___37946 < len__7484__auto___37945)){
args37878.push((arguments[i__7485__auto___37946]));

var G__37947 = (i__7485__auto___37946 + (1));
i__7485__auto___37946 = G__37947;
continue;
} else {
}
break;
}

var G__37880 = args37878.length;
switch (G__37880) {
case 1:
return sablono.core.color_field37877.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field37877.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37878.length)].join('')));

}
});

sablono.core.color_field37877.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.color_field37877.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.color_field37877.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.color_field37877.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field37877);

/**
 * Creates a date input field.
 */
sablono.core.date_field37881 = (function sablono$core$date_field37881(var_args){
var args37882 = [];
var len__7484__auto___37949 = arguments.length;
var i__7485__auto___37950 = (0);
while(true){
if((i__7485__auto___37950 < len__7484__auto___37949)){
args37882.push((arguments[i__7485__auto___37950]));

var G__37951 = (i__7485__auto___37950 + (1));
i__7485__auto___37950 = G__37951;
continue;
} else {
}
break;
}

var G__37884 = args37882.length;
switch (G__37884) {
case 1:
return sablono.core.date_field37881.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field37881.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37882.length)].join('')));

}
});

sablono.core.date_field37881.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.date_field37881.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.date_field37881.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.date_field37881.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field37881);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field37885 = (function sablono$core$datetime_field37885(var_args){
var args37886 = [];
var len__7484__auto___37953 = arguments.length;
var i__7485__auto___37954 = (0);
while(true){
if((i__7485__auto___37954 < len__7484__auto___37953)){
args37886.push((arguments[i__7485__auto___37954]));

var G__37955 = (i__7485__auto___37954 + (1));
i__7485__auto___37954 = G__37955;
continue;
} else {
}
break;
}

var G__37888 = args37886.length;
switch (G__37888) {
case 1:
return sablono.core.datetime_field37885.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field37885.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37886.length)].join('')));

}
});

sablono.core.datetime_field37885.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.datetime_field37885.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.datetime_field37885.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.datetime_field37885.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field37885);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field37889 = (function sablono$core$datetime_local_field37889(var_args){
var args37890 = [];
var len__7484__auto___37957 = arguments.length;
var i__7485__auto___37958 = (0);
while(true){
if((i__7485__auto___37958 < len__7484__auto___37957)){
args37890.push((arguments[i__7485__auto___37958]));

var G__37959 = (i__7485__auto___37958 + (1));
i__7485__auto___37958 = G__37959;
continue;
} else {
}
break;
}

var G__37892 = args37890.length;
switch (G__37892) {
case 1:
return sablono.core.datetime_local_field37889.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field37889.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37890.length)].join('')));

}
});

sablono.core.datetime_local_field37889.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.datetime_local_field37889.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.datetime_local_field37889.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.datetime_local_field37889.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field37889);

/**
 * Creates a email input field.
 */
sablono.core.email_field37893 = (function sablono$core$email_field37893(var_args){
var args37894 = [];
var len__7484__auto___37961 = arguments.length;
var i__7485__auto___37962 = (0);
while(true){
if((i__7485__auto___37962 < len__7484__auto___37961)){
args37894.push((arguments[i__7485__auto___37962]));

var G__37963 = (i__7485__auto___37962 + (1));
i__7485__auto___37962 = G__37963;
continue;
} else {
}
break;
}

var G__37896 = args37894.length;
switch (G__37896) {
case 1:
return sablono.core.email_field37893.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field37893.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37894.length)].join('')));

}
});

sablono.core.email_field37893.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.email_field37893.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.email_field37893.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.email_field37893.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field37893);

/**
 * Creates a file input field.
 */
sablono.core.file_field37897 = (function sablono$core$file_field37897(var_args){
var args37898 = [];
var len__7484__auto___37965 = arguments.length;
var i__7485__auto___37966 = (0);
while(true){
if((i__7485__auto___37966 < len__7484__auto___37965)){
args37898.push((arguments[i__7485__auto___37966]));

var G__37967 = (i__7485__auto___37966 + (1));
i__7485__auto___37966 = G__37967;
continue;
} else {
}
break;
}

var G__37900 = args37898.length;
switch (G__37900) {
case 1:
return sablono.core.file_field37897.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field37897.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37898.length)].join('')));

}
});

sablono.core.file_field37897.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.file_field37897.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.file_field37897.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.file_field37897.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field37897);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field37901 = (function sablono$core$hidden_field37901(var_args){
var args37902 = [];
var len__7484__auto___37969 = arguments.length;
var i__7485__auto___37970 = (0);
while(true){
if((i__7485__auto___37970 < len__7484__auto___37969)){
args37902.push((arguments[i__7485__auto___37970]));

var G__37971 = (i__7485__auto___37970 + (1));
i__7485__auto___37970 = G__37971;
continue;
} else {
}
break;
}

var G__37904 = args37902.length;
switch (G__37904) {
case 1:
return sablono.core.hidden_field37901.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field37901.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37902.length)].join('')));

}
});

sablono.core.hidden_field37901.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.hidden_field37901.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.hidden_field37901.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.hidden_field37901.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field37901);

/**
 * Creates a month input field.
 */
sablono.core.month_field37905 = (function sablono$core$month_field37905(var_args){
var args37906 = [];
var len__7484__auto___37973 = arguments.length;
var i__7485__auto___37974 = (0);
while(true){
if((i__7485__auto___37974 < len__7484__auto___37973)){
args37906.push((arguments[i__7485__auto___37974]));

var G__37975 = (i__7485__auto___37974 + (1));
i__7485__auto___37974 = G__37975;
continue;
} else {
}
break;
}

var G__37908 = args37906.length;
switch (G__37908) {
case 1:
return sablono.core.month_field37905.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field37905.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37906.length)].join('')));

}
});

sablono.core.month_field37905.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.month_field37905.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.month_field37905.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.month_field37905.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field37905);

/**
 * Creates a number input field.
 */
sablono.core.number_field37909 = (function sablono$core$number_field37909(var_args){
var args37910 = [];
var len__7484__auto___37977 = arguments.length;
var i__7485__auto___37978 = (0);
while(true){
if((i__7485__auto___37978 < len__7484__auto___37977)){
args37910.push((arguments[i__7485__auto___37978]));

var G__37979 = (i__7485__auto___37978 + (1));
i__7485__auto___37978 = G__37979;
continue;
} else {
}
break;
}

var G__37912 = args37910.length;
switch (G__37912) {
case 1:
return sablono.core.number_field37909.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field37909.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37910.length)].join('')));

}
});

sablono.core.number_field37909.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.number_field37909.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.number_field37909.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.number_field37909.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field37909);

/**
 * Creates a password input field.
 */
sablono.core.password_field37913 = (function sablono$core$password_field37913(var_args){
var args37914 = [];
var len__7484__auto___37981 = arguments.length;
var i__7485__auto___37982 = (0);
while(true){
if((i__7485__auto___37982 < len__7484__auto___37981)){
args37914.push((arguments[i__7485__auto___37982]));

var G__37983 = (i__7485__auto___37982 + (1));
i__7485__auto___37982 = G__37983;
continue;
} else {
}
break;
}

var G__37916 = args37914.length;
switch (G__37916) {
case 1:
return sablono.core.password_field37913.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field37913.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37914.length)].join('')));

}
});

sablono.core.password_field37913.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.password_field37913.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.password_field37913.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.password_field37913.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field37913);

/**
 * Creates a range input field.
 */
sablono.core.range_field37917 = (function sablono$core$range_field37917(var_args){
var args37918 = [];
var len__7484__auto___37985 = arguments.length;
var i__7485__auto___37986 = (0);
while(true){
if((i__7485__auto___37986 < len__7484__auto___37985)){
args37918.push((arguments[i__7485__auto___37986]));

var G__37987 = (i__7485__auto___37986 + (1));
i__7485__auto___37986 = G__37987;
continue;
} else {
}
break;
}

var G__37920 = args37918.length;
switch (G__37920) {
case 1:
return sablono.core.range_field37917.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field37917.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37918.length)].join('')));

}
});

sablono.core.range_field37917.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.range_field37917.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.range_field37917.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.range_field37917.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field37917);

/**
 * Creates a search input field.
 */
sablono.core.search_field37921 = (function sablono$core$search_field37921(var_args){
var args37922 = [];
var len__7484__auto___37989 = arguments.length;
var i__7485__auto___37990 = (0);
while(true){
if((i__7485__auto___37990 < len__7484__auto___37989)){
args37922.push((arguments[i__7485__auto___37990]));

var G__37991 = (i__7485__auto___37990 + (1));
i__7485__auto___37990 = G__37991;
continue;
} else {
}
break;
}

var G__37924 = args37922.length;
switch (G__37924) {
case 1:
return sablono.core.search_field37921.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field37921.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37922.length)].join('')));

}
});

sablono.core.search_field37921.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.search_field37921.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.search_field37921.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.search_field37921.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field37921);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field37925 = (function sablono$core$tel_field37925(var_args){
var args37926 = [];
var len__7484__auto___37993 = arguments.length;
var i__7485__auto___37994 = (0);
while(true){
if((i__7485__auto___37994 < len__7484__auto___37993)){
args37926.push((arguments[i__7485__auto___37994]));

var G__37995 = (i__7485__auto___37994 + (1));
i__7485__auto___37994 = G__37995;
continue;
} else {
}
break;
}

var G__37928 = args37926.length;
switch (G__37928) {
case 1:
return sablono.core.tel_field37925.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field37925.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37926.length)].join('')));

}
});

sablono.core.tel_field37925.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.tel_field37925.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.tel_field37925.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.tel_field37925.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field37925);

/**
 * Creates a text input field.
 */
sablono.core.text_field37929 = (function sablono$core$text_field37929(var_args){
var args37930 = [];
var len__7484__auto___37997 = arguments.length;
var i__7485__auto___37998 = (0);
while(true){
if((i__7485__auto___37998 < len__7484__auto___37997)){
args37930.push((arguments[i__7485__auto___37998]));

var G__37999 = (i__7485__auto___37998 + (1));
i__7485__auto___37998 = G__37999;
continue;
} else {
}
break;
}

var G__37932 = args37930.length;
switch (G__37932) {
case 1:
return sablono.core.text_field37929.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field37929.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37930.length)].join('')));

}
});

sablono.core.text_field37929.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.text_field37929.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.text_field37929.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.text_field37929.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field37929);

/**
 * Creates a time input field.
 */
sablono.core.time_field37933 = (function sablono$core$time_field37933(var_args){
var args37934 = [];
var len__7484__auto___38001 = arguments.length;
var i__7485__auto___38002 = (0);
while(true){
if((i__7485__auto___38002 < len__7484__auto___38001)){
args37934.push((arguments[i__7485__auto___38002]));

var G__38003 = (i__7485__auto___38002 + (1));
i__7485__auto___38002 = G__38003;
continue;
} else {
}
break;
}

var G__37936 = args37934.length;
switch (G__37936) {
case 1:
return sablono.core.time_field37933.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field37933.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37934.length)].join('')));

}
});

sablono.core.time_field37933.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.time_field37933.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.time_field37933.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.time_field37933.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field37933);

/**
 * Creates a url input field.
 */
sablono.core.url_field37937 = (function sablono$core$url_field37937(var_args){
var args37938 = [];
var len__7484__auto___38005 = arguments.length;
var i__7485__auto___38006 = (0);
while(true){
if((i__7485__auto___38006 < len__7484__auto___38005)){
args37938.push((arguments[i__7485__auto___38006]));

var G__38007 = (i__7485__auto___38006 + (1));
i__7485__auto___38006 = G__38007;
continue;
} else {
}
break;
}

var G__37940 = args37938.length;
switch (G__37940) {
case 1:
return sablono.core.url_field37937.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field37937.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37938.length)].join('')));

}
});

sablono.core.url_field37937.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.url_field37937.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.url_field37937.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.url_field37937.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field37937);

/**
 * Creates a week input field.
 */
sablono.core.week_field37941 = (function sablono$core$week_field37941(var_args){
var args37942 = [];
var len__7484__auto___38009 = arguments.length;
var i__7485__auto___38010 = (0);
while(true){
if((i__7485__auto___38010 < len__7484__auto___38009)){
args37942.push((arguments[i__7485__auto___38010]));

var G__38011 = (i__7485__auto___38010 + (1));
i__7485__auto___38010 = G__38011;
continue;
} else {
}
break;
}

var G__37944 = args37942.length;
switch (G__37944) {
case 1:
return sablono.core.week_field37941.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field37941.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37942.length)].join('')));

}
});

sablono.core.week_field37941.cljs$core$IFn$_invoke$arity$1 = (function (name__19611__auto__){
return sablono.core.week_field37941.cljs$core$IFn$_invoke$arity$2(name__19611__auto__,null);
});

sablono.core.week_field37941.cljs$core$IFn$_invoke$arity$2 = (function (name__19611__auto__,value__19612__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__19611__auto__,value__19612__auto__);
});

sablono.core.week_field37941.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field37941);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box38013 = (function sablono$core$check_box38013(var_args){
var args38014 = [];
var len__7484__auto___38017 = arguments.length;
var i__7485__auto___38018 = (0);
while(true){
if((i__7485__auto___38018 < len__7484__auto___38017)){
args38014.push((arguments[i__7485__auto___38018]));

var G__38019 = (i__7485__auto___38018 + (1));
i__7485__auto___38018 = G__38019;
continue;
} else {
}
break;
}

var G__38016 = args38014.length;
switch (G__38016) {
case 1:
return sablono.core.check_box38013.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box38013.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box38013.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38014.length)].join('')));

}
});

sablono.core.check_box38013.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box38013.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box38013.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box38013.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box38013.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box38013.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box38013);
/**
 * Creates a radio button.
 */
sablono.core.radio_button38021 = (function sablono$core$radio_button38021(var_args){
var args38022 = [];
var len__7484__auto___38025 = arguments.length;
var i__7485__auto___38026 = (0);
while(true){
if((i__7485__auto___38026 < len__7484__auto___38025)){
args38022.push((arguments[i__7485__auto___38026]));

var G__38027 = (i__7485__auto___38026 + (1));
i__7485__auto___38026 = G__38027;
continue;
} else {
}
break;
}

var G__38024 = args38022.length;
switch (G__38024) {
case 1:
return sablono.core.radio_button38021.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button38021.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button38021.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38022.length)].join('')));

}
});

sablono.core.radio_button38021.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button38021.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button38021.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button38021.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button38021.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button38021.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button38021);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options38029 = (function sablono$core$select_options38029(var_args){
var args38030 = [];
var len__7484__auto___38051 = arguments.length;
var i__7485__auto___38052 = (0);
while(true){
if((i__7485__auto___38052 < len__7484__auto___38051)){
args38030.push((arguments[i__7485__auto___38052]));

var G__38053 = (i__7485__auto___38052 + (1));
i__7485__auto___38052 = G__38053;
continue;
} else {
}
break;
}

var G__38032 = args38030.length;
switch (G__38032) {
case 1:
return sablono.core.select_options38029.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options38029.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38030.length)].join('')));

}
});

sablono.core.select_options38029.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options38029.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options38029.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__38033(s__38034){
return (new cljs.core.LazySeq(null,(function (){
var s__38034__$1 = s__38034;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38034__$1);
if(temp__4657__auto__){
var s__38034__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38034__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38034__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38036 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38035 = (0);
while(true){
if((i__38035 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38035);
cljs.core.chunk_append(b__38036,((cljs.core.sequential_QMARK_(x))?(function (){var vec__38045 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38045,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38045,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38045,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options38029.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__38055 = (i__38035 + (1));
i__38035 = G__38055;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38036),sablono$core$iter__38033(cljs.core.chunk_rest(s__38034__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38036),null);
}
} else {
var x = cljs.core.first(s__38034__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__38048 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38048,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38048,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38048,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options38029.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__38033(cljs.core.rest(s__38034__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
});

sablono.core.select_options38029.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options38029);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down38056 = (function sablono$core$drop_down38056(var_args){
var args38057 = [];
var len__7484__auto___38060 = arguments.length;
var i__7485__auto___38061 = (0);
while(true){
if((i__7485__auto___38061 < len__7484__auto___38060)){
args38057.push((arguments[i__7485__auto___38061]));

var G__38062 = (i__7485__auto___38061 + (1));
i__7485__auto___38061 = G__38062;
continue;
} else {
}
break;
}

var G__38059 = args38057.length;
switch (G__38059) {
case 2:
return sablono.core.drop_down38056.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down38056.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38057.length)].join('')));

}
});

sablono.core.drop_down38056.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down38056.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down38056.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down38056.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down38056);
/**
 * Creates a text area element.
 */
sablono.core.text_area38064 = (function sablono$core$text_area38064(var_args){
var args38065 = [];
var len__7484__auto___38068 = arguments.length;
var i__7485__auto___38069 = (0);
while(true){
if((i__7485__auto___38069 < len__7484__auto___38068)){
args38065.push((arguments[i__7485__auto___38069]));

var G__38070 = (i__7485__auto___38069 + (1));
i__7485__auto___38069 = G__38070;
continue;
} else {
}
break;
}

var G__38067 = args38065.length;
switch (G__38067) {
case 1:
return sablono.core.text_area38064.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area38064.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38065.length)].join('')));

}
});

sablono.core.text_area38064.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area38064.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area38064.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area38064.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area38064);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label38072 = (function sablono$core$label38072(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label38072);
/**
 * Creates a submit button.
 */
sablono.core.submit_button38073 = (function sablono$core$submit_button38073(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button38073);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button38074 = (function sablono$core$reset_button38074(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button38074);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to38075 = (function sablono$core$form_to38075(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38082 = arguments.length;
var i__7485__auto___38083 = (0);
while(true){
if((i__7485__auto___38083 < len__7484__auto___38082)){
args__7491__auto__.push((arguments[i__7485__auto___38083]));

var G__38084 = (i__7485__auto___38083 + (1));
i__7485__auto___38083 = G__38084;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to38075.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to38075.cljs$core$IFn$_invoke$arity$variadic = (function (p__38078,body){
var vec__38079 = p__38078;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38079,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38079,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to38075.cljs$lang$maxFixedArity = (1);

sablono.core.form_to38075.cljs$lang$applyTo = (function (seq38076){
var G__38077 = cljs.core.first(seq38076);
var seq38076__$1 = cljs.core.next(seq38076);
return sablono.core.form_to38075.cljs$core$IFn$_invoke$arity$variadic(G__38077,seq38076__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to38075);
