// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('cljs_time.coerce');
goog.require('cljs.core');
goog.require('cljs_time.core');
goog.require('cljs_time.format');
goog.require('goog.date.UtcDateTime');

/**
 * @interface
 */
cljs_time.coerce.ICoerce = function(){};

/**
 * Convert `obj` to a goog.date.DateTime instance.
 */
cljs_time.coerce.to_date_time = (function cljs_time$coerce$to_date_time(obj){
if((!((obj == null))) && (!((obj.cljs_time$coerce$ICoerce$to_date_time$arity$1 == null)))){
return obj.cljs_time$coerce$ICoerce$to_date_time$arity$1(obj);
} else {
var x__7072__auto__ = (((obj == null))?null:obj);
var m__7073__auto__ = (cljs_time.coerce.to_date_time[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(obj) : m__7073__auto__.call(null,obj));
} else {
var m__7073__auto____$1 = (cljs_time.coerce.to_date_time["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(obj) : m__7073__auto____$1.call(null,obj));
} else {
throw cljs.core.missing_protocol("ICoerce.to-date-time",obj);
}
}
}
});

/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.from_long = (function cljs_time$coerce$from_long(millis){
var G__39760 = millis;
if((G__39760 == null)){
return null;
} else {
return (goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1 ? goog.date.UtcDateTime.fromTimestamp.cljs$core$IFn$_invoke$arity$1(G__39760) : goog.date.UtcDateTime.fromTimestamp.call(null,G__39760));
}
});
/**
 * Returns DateTime instance from string using formatters in cljs-time.format,
 *   returning first which parses
 */
cljs_time.coerce.from_string = (function cljs_time$coerce$from_string(s){
if(cljs.core.truth_(s)){
return cljs.core.first((function (){var iter__7189__auto__ = (function cljs_time$coerce$from_string_$_iter__39771(s__39772){
return (new cljs.core.LazySeq(null,(function (){
var s__39772__$1 = s__39772;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39772__$1);
if(temp__4657__auto__){
var s__39772__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39772__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39772__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39774 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39773 = (0);
while(true){
if((i__39773 < size__7188__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39773);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e39779){if((e39779 instanceof Error)){
var _ = e39779;
return null;
} else {
throw e39779;

}
}})();
if(cljs.core.truth_(d)){
cljs.core.chunk_append(b__39774,d);

var G__39781 = (i__39773 + (1));
i__39773 = G__39781;
continue;
} else {
var G__39782 = (i__39773 + (1));
i__39773 = G__39782;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39774),cljs_time$coerce$from_string_$_iter__39771(cljs.core.chunk_rest(s__39772__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39774),null);
}
} else {
var f = cljs.core.first(s__39772__$2);
var d = (function (){try{return cljs_time.format.parse.cljs$core$IFn$_invoke$arity$2(f,s);
}catch (e39780){if((e39780 instanceof Error)){
var _ = e39780;
return null;
} else {
throw e39780;

}
}})();
if(cljs.core.truth_(d)){
return cljs.core.cons(d,cljs_time$coerce$from_string_$_iter__39771(cljs.core.rest(s__39772__$2)));
} else {
var G__39783 = cljs.core.rest(s__39772__$2);
s__39772__$1 = G__39783;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(cljs.core.vals(cljs_time.format.formatters));
})());
} else {
return null;
}
});
/**
 * Returns a DateTime instance in the UTC time zone corresponding to the given
 *   js Date object.
 */
cljs_time.coerce.from_date = (function cljs_time$coerce$from_date(date){
var G__39785 = date;
var G__39785__$1 = (((G__39785 == null))?null:G__39785.getTime());
if((G__39785__$1 == null)){
return null;
} else {
return cljs_time.coerce.from_long(G__39785__$1);
}
});
/**
 * Convert `obj` to the number of milliseconds after the Unix epoch.
 */
cljs_time.coerce.to_long = (function cljs_time$coerce$to_long(obj){
var G__39787 = obj;
var G__39787__$1 = (((G__39787 == null))?null:cljs_time.coerce.to_date_time(G__39787));
if((G__39787__$1 == null)){
return null;
} else {
return G__39787__$1.getTime();
}
});
/**
 * Convert `obj` to Unix epoch.
 */
cljs_time.coerce.to_epoch = (function cljs_time$coerce$to_epoch(obj){
var G__39789 = obj;
var G__39789__$1 = (((G__39789 == null))?null:cljs_time.coerce.to_long(G__39789));
if((G__39789__$1 == null)){
return null;
} else {
return (G__39789__$1 / (1000));
}
});
/**
 * Convert `obj` to a JavaScript Date instance.
 */
cljs_time.coerce.to_date = (function cljs_time$coerce$to_date(obj){
var G__39791 = obj;
var G__39791__$1 = (((G__39791 == null))?null:cljs_time.coerce.to_date_time(G__39791));
var G__39791__$2 = (((G__39791__$1 == null))?null:G__39791__$1.getTime());
if((G__39791__$2 == null)){
return null;
} else {
return (new Date(G__39791__$2));
}
});
/**
 * Returns a string representation of obj in UTC time-zone
 *   using "yyyy-MM-dd'T'HH:mm:ss.SSSZZ" date-time representation.
 */
cljs_time.coerce.to_string = (function cljs_time$coerce$to_string(obj){
var G__39793 = obj;
var G__39793__$1 = (((G__39793 == null))?null:cljs_time.coerce.to_date_time(G__39793));
if((G__39793__$1 == null)){
return null;
} else {
return cljs_time.format.unparse(cljs.core.cst$kw$date_DASH_time.cljs$core$IFn$_invoke$arity$1(cljs_time.format.formatters),G__39793__$1);
}
});
/**
 * Convert `obj` to a goog.date.Date instance
 */
cljs_time.coerce.to_local_date = (function cljs_time$coerce$to_local_date(obj){
if(cljs.core.truth_(obj)){
var temp__4655__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
return (new goog.date.Date(dt.getYear(),dt.getMonth(),dt.getDate()));
} else {
return null;
}
} else {
return null;
}
});
/**
 * Convert `obj` to a goog.date.DateTime instance
 */
cljs_time.coerce.to_local_date_time = (function cljs_time$coerce$to_local_date_time(obj){
if(cljs.core.truth_(obj)){
var temp__4655__auto__ = cljs_time.coerce.to_date_time(obj);
if(cljs.core.truth_(temp__4655__auto__)){
var dt = temp__4655__auto__;
var G__39795 = (new goog.date.DateTime(dt.getYear(),dt.getMonth(),dt.getDate()));
G__39795.setHours(dt.getHours());

G__39795.setMinutes(dt.getMinutes());

G__39795.setSeconds(dt.getSeconds());

G__39795.setMilliseconds(dt.getMilliseconds());

return G__39795;
} else {
return null;
}
} else {
return null;
}
});
(cljs_time.coerce.ICoerce["null"] = true);

(cljs_time.coerce.to_date_time["null"] = (function (_){
return null;
}));

Date.prototype.cljs_time$coerce$ICoerce$ = true;

Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date){
var date__$1 = this;
return cljs_time.coerce.from_date(date__$1);
});

goog.date.Date.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.Date.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date){
var local_date__$1 = this;
if(cljs.core.truth_(local_date__$1)){
var G__39796 = (new goog.date.UtcDateTime());
G__39796.set(local_date__$1);

return G__39796;
} else {
return null;
}
});

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.DateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (local_date_time){
var local_date_time__$1 = this;
if(cljs.core.truth_(local_date_time__$1)){
var G__39797 = (new goog.date.UtcDateTime());
G__39797.setTime(local_date_time__$1.getTime());

return G__39797;
} else {
return null;
}
});

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$ = true;

goog.date.UtcDateTime.prototype.cljs_time$coerce$ICoerce$to_date_time$arity$1 = (function (date_time){
var date_time__$1 = this;
return date_time__$1;
});

(cljs_time.coerce.ICoerce["number"] = true);

(cljs_time.coerce.to_date_time["number"] = (function (long$){
return cljs_time.coerce.from_long(long$);
}));

(cljs_time.coerce.ICoerce["string"] = true);

(cljs_time.coerce.to_date_time["string"] = (function (string){
return cljs_time.coerce.from_string(string);
}));
