// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args13261 = [];
var len__7484__auto___13267 = arguments.length;
var i__7485__auto___13268 = (0);
while(true){
if((i__7485__auto___13268 < len__7484__auto___13267)){
args13261.push((arguments[i__7485__auto___13268]));

var G__13269 = (i__7485__auto___13268 + (1));
i__7485__auto___13268 = G__13269;
continue;
} else {
}
break;
}

var G__13263 = args13261.length;
switch (G__13263) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13261.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async13264 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13264 = (function (f,blockable,meta13265){
this.f = f;
this.blockable = blockable;
this.meta13265 = meta13265;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13266,meta13265__$1){
var self__ = this;
var _13266__$1 = this;
return (new cljs.core.async.t_cljs$core$async13264(self__.f,self__.blockable,meta13265__$1));
});

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13266){
var self__ = this;
var _13266__$1 = this;
return self__.meta13265;
});

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async13264.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async13264.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta13265","meta13265",1268174886,null)], null);
});

cljs.core.async.t_cljs$core$async13264.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13264.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13264";

cljs.core.async.t_cljs$core$async13264.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13264");
});

cljs.core.async.__GT_t_cljs$core$async13264 = (function cljs$core$async$__GT_t_cljs$core$async13264(f__$1,blockable__$1,meta13265){
return (new cljs.core.async.t_cljs$core$async13264(f__$1,blockable__$1,meta13265));
});

}

return (new cljs.core.async.t_cljs$core$async13264(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args13273 = [];
var len__7484__auto___13276 = arguments.length;
var i__7485__auto___13277 = (0);
while(true){
if((i__7485__auto___13277 < len__7484__auto___13276)){
args13273.push((arguments[i__7485__auto___13277]));

var G__13278 = (i__7485__auto___13277 + (1));
i__7485__auto___13277 = G__13278;
continue;
} else {
}
break;
}

var G__13275 = args13273.length;
switch (G__13275) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13273.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args13280 = [];
var len__7484__auto___13283 = arguments.length;
var i__7485__auto___13284 = (0);
while(true){
if((i__7485__auto___13284 < len__7484__auto___13283)){
args13280.push((arguments[i__7485__auto___13284]));

var G__13285 = (i__7485__auto___13284 + (1));
i__7485__auto___13284 = G__13285;
continue;
} else {
}
break;
}

var G__13282 = args13280.length;
switch (G__13282) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13280.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args13287 = [];
var len__7484__auto___13290 = arguments.length;
var i__7485__auto___13291 = (0);
while(true){
if((i__7485__auto___13291 < len__7484__auto___13290)){
args13287.push((arguments[i__7485__auto___13291]));

var G__13292 = (i__7485__auto___13291 + (1));
i__7485__auto___13291 = G__13292;
continue;
} else {
}
break;
}

var G__13289 = args13287.length;
switch (G__13289) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13287.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_13294 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_13294);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_13294,ret){
return (function (){
return fn1.call(null,val_13294);
});})(val_13294,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args13295 = [];
var len__7484__auto___13298 = arguments.length;
var i__7485__auto___13299 = (0);
while(true){
if((i__7485__auto___13299 < len__7484__auto___13298)){
args13295.push((arguments[i__7485__auto___13299]));

var G__13300 = (i__7485__auto___13299 + (1));
i__7485__auto___13299 = G__13300;
continue;
} else {
}
break;
}

var G__13297 = args13295.length;
switch (G__13297) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13295.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___13302 = n;
var x_13303 = (0);
while(true){
if((x_13303 < n__7324__auto___13302)){
(a[x_13303] = (0));

var G__13304 = (x_13303 + (1));
x_13303 = G__13304;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__13305 = (i + (1));
i = G__13305;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async13309 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13309 = (function (alt_flag,flag,meta13310){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta13310 = meta13310;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13309.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_13311,meta13310__$1){
var self__ = this;
var _13311__$1 = this;
return (new cljs.core.async.t_cljs$core$async13309(self__.alt_flag,self__.flag,meta13310__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async13309.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_13311){
var self__ = this;
var _13311__$1 = this;
return self__.meta13310;
});})(flag))
;

cljs.core.async.t_cljs$core$async13309.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13309.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async13309.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async13309.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async13309.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta13310","meta13310",491876408,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async13309.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13309.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13309";

cljs.core.async.t_cljs$core$async13309.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13309");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async13309 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async13309(alt_flag__$1,flag__$1,meta13310){
return (new cljs.core.async.t_cljs$core$async13309(alt_flag__$1,flag__$1,meta13310));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async13309(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async13315 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13315 = (function (alt_handler,flag,cb,meta13316){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta13316 = meta13316;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13315.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13317,meta13316__$1){
var self__ = this;
var _13317__$1 = this;
return (new cljs.core.async.t_cljs$core$async13315(self__.alt_handler,self__.flag,self__.cb,meta13316__$1));
});

cljs.core.async.t_cljs$core$async13315.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13317){
var self__ = this;
var _13317__$1 = this;
return self__.meta13316;
});

cljs.core.async.t_cljs$core$async13315.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async13315.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async13315.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async13315.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async13315.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta13316","meta13316",299257274,null)], null);
});

cljs.core.async.t_cljs$core$async13315.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13315.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13315";

cljs.core.async.t_cljs$core$async13315.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async13315");
});

cljs.core.async.__GT_t_cljs$core$async13315 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async13315(alt_handler__$1,flag__$1,cb__$1,meta13316){
return (new cljs.core.async.t_cljs$core$async13315(alt_handler__$1,flag__$1,cb__$1,meta13316));
});

}

return (new cljs.core.async.t_cljs$core$async13315(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13318_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13318_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__13319_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__13319_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__13320 = (i + (1));
i = G__13320;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___13326 = arguments.length;
var i__7485__auto___13327 = (0);
while(true){
if((i__7485__auto___13327 < len__7484__auto___13326)){
args__7491__auto__.push((arguments[i__7485__auto___13327]));

var G__13328 = (i__7485__auto___13327 + (1));
i__7485__auto___13327 = G__13328;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__13323){
var map__13324 = p__13323;
var map__13324__$1 = ((((!((map__13324 == null)))?((((map__13324.cljs$lang$protocol_mask$partition0$ & (64))) || (map__13324.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13324):map__13324);
var opts = map__13324__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq13321){
var G__13322 = cljs.core.first.call(null,seq13321);
var seq13321__$1 = cljs.core.next.call(null,seq13321);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13322,seq13321__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args13329 = [];
var len__7484__auto___13379 = arguments.length;
var i__7485__auto___13380 = (0);
while(true){
if((i__7485__auto___13380 < len__7484__auto___13379)){
args13329.push((arguments[i__7485__auto___13380]));

var G__13381 = (i__7485__auto___13380 + (1));
i__7485__auto___13380 = G__13381;
continue;
} else {
}
break;
}

var G__13331 = args13329.length;
switch (G__13331) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13329.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__13216__auto___13383 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___13383){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___13383){
return (function (state_13355){
var state_val_13356 = (state_13355[(1)]);
if((state_val_13356 === (7))){
var inst_13351 = (state_13355[(2)]);
var state_13355__$1 = state_13355;
var statearr_13357_13384 = state_13355__$1;
(statearr_13357_13384[(2)] = inst_13351);

(statearr_13357_13384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13356 === (1))){
var state_13355__$1 = state_13355;
var statearr_13358_13385 = state_13355__$1;
(statearr_13358_13385[(2)] = null);

(statearr_13358_13385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13356 === (4))){
var inst_13334 = (state_13355[(7)]);
var inst_13334__$1 = (state_13355[(2)]);
var inst_13335 = (inst_13334__$1 == null);
var state_13355__$1 = (function (){var statearr_13359 = state_13355;
(statearr_13359[(7)] = inst_13334__$1);

return statearr_13359;
})();
if(cljs.core.truth_(inst_13335)){
var statearr_13360_13386 = state_13355__$1;
(statearr_13360_13386[(1)] = (5));

} else {
var statearr_13361_13387 = state_13355__$1;
(statearr_13361_13387[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13356 === (13))){
var state_13355__$1 = state_13355;
var statearr_13362_13388 = state_13355__$1;
(statearr_13362_13388[(2)] = null);

(statearr_13362_13388[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13356 === (6))){
var inst_13334 = (state_13355[(7)]);
var state_13355__$1 = state_13355;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13355__$1,(11),to,inst_13334);
} else {
if((state_val_13356 === (3))){
var inst_13353 = (state_13355[(2)]);
var state_13355__$1 = state_13355;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13355__$1,inst_13353);
} else {
if((state_val_13356 === (12))){
var state_13355__$1 = state_13355;
var statearr_13363_13389 = state_13355__$1;
(statearr_13363_13389[(2)] = null);

(statearr_13363_13389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13356 === (2))){
var state_13355__$1 = state_13355;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13355__$1,(4),from);
} else {
if((state_val_13356 === (11))){
var inst_13344 = (state_13355[(2)]);
var state_13355__$1 = state_13355;
if(cljs.core.truth_(inst_13344)){
var statearr_13364_13390 = state_13355__$1;
(statearr_13364_13390[(1)] = (12));

} else {
var statearr_13365_13391 = state_13355__$1;
(statearr_13365_13391[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13356 === (9))){
var state_13355__$1 = state_13355;
var statearr_13366_13392 = state_13355__$1;
(statearr_13366_13392[(2)] = null);

(statearr_13366_13392[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13356 === (5))){
var state_13355__$1 = state_13355;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13367_13393 = state_13355__$1;
(statearr_13367_13393[(1)] = (8));

} else {
var statearr_13368_13394 = state_13355__$1;
(statearr_13368_13394[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13356 === (14))){
var inst_13349 = (state_13355[(2)]);
var state_13355__$1 = state_13355;
var statearr_13369_13395 = state_13355__$1;
(statearr_13369_13395[(2)] = inst_13349);

(statearr_13369_13395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13356 === (10))){
var inst_13341 = (state_13355[(2)]);
var state_13355__$1 = state_13355;
var statearr_13370_13396 = state_13355__$1;
(statearr_13370_13396[(2)] = inst_13341);

(statearr_13370_13396[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13356 === (8))){
var inst_13338 = cljs.core.async.close_BANG_.call(null,to);
var state_13355__$1 = state_13355;
var statearr_13371_13397 = state_13355__$1;
(statearr_13371_13397[(2)] = inst_13338);

(statearr_13371_13397[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___13383))
;
return ((function (switch__13104__auto__,c__13216__auto___13383){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_13375 = [null,null,null,null,null,null,null,null];
(statearr_13375[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_13375[(1)] = (1));

return statearr_13375;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_13355){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_13355);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e13376){if((e13376 instanceof Object)){
var ex__13108__auto__ = e13376;
var statearr_13377_13398 = state_13355;
(statearr_13377_13398[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13355);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13376;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13399 = state_13355;
state_13355 = G__13399;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_13355){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_13355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___13383))
})();
var state__13218__auto__ = (function (){var statearr_13378 = f__13217__auto__.call(null);
(statearr_13378[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___13383);

return statearr_13378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___13383))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__13587){
var vec__13588 = p__13587;
var v = cljs.core.nth.call(null,vec__13588,(0),null);
var p = cljs.core.nth.call(null,vec__13588,(1),null);
var job = vec__13588;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__13216__auto___13774 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___13774,res,vec__13588,v,p,job,jobs,results){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___13774,res,vec__13588,v,p,job,jobs,results){
return (function (state_13595){
var state_val_13596 = (state_13595[(1)]);
if((state_val_13596 === (1))){
var state_13595__$1 = state_13595;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13595__$1,(2),res,v);
} else {
if((state_val_13596 === (2))){
var inst_13592 = (state_13595[(2)]);
var inst_13593 = cljs.core.async.close_BANG_.call(null,res);
var state_13595__$1 = (function (){var statearr_13597 = state_13595;
(statearr_13597[(7)] = inst_13592);

return statearr_13597;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13595__$1,inst_13593);
} else {
return null;
}
}
});})(c__13216__auto___13774,res,vec__13588,v,p,job,jobs,results))
;
return ((function (switch__13104__auto__,c__13216__auto___13774,res,vec__13588,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_13601 = [null,null,null,null,null,null,null,null];
(statearr_13601[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__);

(statearr_13601[(1)] = (1));

return statearr_13601;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1 = (function (state_13595){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_13595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e13602){if((e13602 instanceof Object)){
var ex__13108__auto__ = e13602;
var statearr_13603_13775 = state_13595;
(statearr_13603_13775[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13595);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13602;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13776 = state_13595;
state_13595 = G__13776;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = function(state_13595){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1.call(this,state_13595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___13774,res,vec__13588,v,p,job,jobs,results))
})();
var state__13218__auto__ = (function (){var statearr_13604 = f__13217__auto__.call(null);
(statearr_13604[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___13774);

return statearr_13604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___13774,res,vec__13588,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__13605){
var vec__13606 = p__13605;
var v = cljs.core.nth.call(null,vec__13606,(0),null);
var p = cljs.core.nth.call(null,vec__13606,(1),null);
var job = vec__13606;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___13777 = n;
var __13778 = (0);
while(true){
if((__13778 < n__7324__auto___13777)){
var G__13609_13779 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__13609_13779) {
case "compute":
var c__13216__auto___13781 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__13778,c__13216__auto___13781,G__13609_13779,n__7324__auto___13777,jobs,results,process,async){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (__13778,c__13216__auto___13781,G__13609_13779,n__7324__auto___13777,jobs,results,process,async){
return (function (state_13622){
var state_val_13623 = (state_13622[(1)]);
if((state_val_13623 === (1))){
var state_13622__$1 = state_13622;
var statearr_13624_13782 = state_13622__$1;
(statearr_13624_13782[(2)] = null);

(statearr_13624_13782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13623 === (2))){
var state_13622__$1 = state_13622;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13622__$1,(4),jobs);
} else {
if((state_val_13623 === (3))){
var inst_13620 = (state_13622[(2)]);
var state_13622__$1 = state_13622;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13622__$1,inst_13620);
} else {
if((state_val_13623 === (4))){
var inst_13612 = (state_13622[(2)]);
var inst_13613 = process.call(null,inst_13612);
var state_13622__$1 = state_13622;
if(cljs.core.truth_(inst_13613)){
var statearr_13625_13783 = state_13622__$1;
(statearr_13625_13783[(1)] = (5));

} else {
var statearr_13626_13784 = state_13622__$1;
(statearr_13626_13784[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13623 === (5))){
var state_13622__$1 = state_13622;
var statearr_13627_13785 = state_13622__$1;
(statearr_13627_13785[(2)] = null);

(statearr_13627_13785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13623 === (6))){
var state_13622__$1 = state_13622;
var statearr_13628_13786 = state_13622__$1;
(statearr_13628_13786[(2)] = null);

(statearr_13628_13786[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13623 === (7))){
var inst_13618 = (state_13622[(2)]);
var state_13622__$1 = state_13622;
var statearr_13629_13787 = state_13622__$1;
(statearr_13629_13787[(2)] = inst_13618);

(statearr_13629_13787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__13778,c__13216__auto___13781,G__13609_13779,n__7324__auto___13777,jobs,results,process,async))
;
return ((function (__13778,switch__13104__auto__,c__13216__auto___13781,G__13609_13779,n__7324__auto___13777,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_13633 = [null,null,null,null,null,null,null];
(statearr_13633[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__);

(statearr_13633[(1)] = (1));

return statearr_13633;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1 = (function (state_13622){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_13622);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e13634){if((e13634 instanceof Object)){
var ex__13108__auto__ = e13634;
var statearr_13635_13788 = state_13622;
(statearr_13635_13788[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13622);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13634;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13789 = state_13622;
state_13622 = G__13789;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = function(state_13622){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1.call(this,state_13622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__;
})()
;})(__13778,switch__13104__auto__,c__13216__auto___13781,G__13609_13779,n__7324__auto___13777,jobs,results,process,async))
})();
var state__13218__auto__ = (function (){var statearr_13636 = f__13217__auto__.call(null);
(statearr_13636[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___13781);

return statearr_13636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(__13778,c__13216__auto___13781,G__13609_13779,n__7324__auto___13777,jobs,results,process,async))
);


break;
case "async":
var c__13216__auto___13790 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__13778,c__13216__auto___13790,G__13609_13779,n__7324__auto___13777,jobs,results,process,async){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (__13778,c__13216__auto___13790,G__13609_13779,n__7324__auto___13777,jobs,results,process,async){
return (function (state_13649){
var state_val_13650 = (state_13649[(1)]);
if((state_val_13650 === (1))){
var state_13649__$1 = state_13649;
var statearr_13651_13791 = state_13649__$1;
(statearr_13651_13791[(2)] = null);

(statearr_13651_13791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13650 === (2))){
var state_13649__$1 = state_13649;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13649__$1,(4),jobs);
} else {
if((state_val_13650 === (3))){
var inst_13647 = (state_13649[(2)]);
var state_13649__$1 = state_13649;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13649__$1,inst_13647);
} else {
if((state_val_13650 === (4))){
var inst_13639 = (state_13649[(2)]);
var inst_13640 = async.call(null,inst_13639);
var state_13649__$1 = state_13649;
if(cljs.core.truth_(inst_13640)){
var statearr_13652_13792 = state_13649__$1;
(statearr_13652_13792[(1)] = (5));

} else {
var statearr_13653_13793 = state_13649__$1;
(statearr_13653_13793[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13650 === (5))){
var state_13649__$1 = state_13649;
var statearr_13654_13794 = state_13649__$1;
(statearr_13654_13794[(2)] = null);

(statearr_13654_13794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13650 === (6))){
var state_13649__$1 = state_13649;
var statearr_13655_13795 = state_13649__$1;
(statearr_13655_13795[(2)] = null);

(statearr_13655_13795[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13650 === (7))){
var inst_13645 = (state_13649[(2)]);
var state_13649__$1 = state_13649;
var statearr_13656_13796 = state_13649__$1;
(statearr_13656_13796[(2)] = inst_13645);

(statearr_13656_13796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__13778,c__13216__auto___13790,G__13609_13779,n__7324__auto___13777,jobs,results,process,async))
;
return ((function (__13778,switch__13104__auto__,c__13216__auto___13790,G__13609_13779,n__7324__auto___13777,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_13660 = [null,null,null,null,null,null,null];
(statearr_13660[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__);

(statearr_13660[(1)] = (1));

return statearr_13660;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1 = (function (state_13649){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_13649);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e13661){if((e13661 instanceof Object)){
var ex__13108__auto__ = e13661;
var statearr_13662_13797 = state_13649;
(statearr_13662_13797[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13649);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13661;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13798 = state_13649;
state_13649 = G__13798;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = function(state_13649){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1.call(this,state_13649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__;
})()
;})(__13778,switch__13104__auto__,c__13216__auto___13790,G__13609_13779,n__7324__auto___13777,jobs,results,process,async))
})();
var state__13218__auto__ = (function (){var statearr_13663 = f__13217__auto__.call(null);
(statearr_13663[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___13790);

return statearr_13663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(__13778,c__13216__auto___13790,G__13609_13779,n__7324__auto___13777,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__13799 = (__13778 + (1));
__13778 = G__13799;
continue;
} else {
}
break;
}

var c__13216__auto___13800 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___13800,jobs,results,process,async){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___13800,jobs,results,process,async){
return (function (state_13685){
var state_val_13686 = (state_13685[(1)]);
if((state_val_13686 === (1))){
var state_13685__$1 = state_13685;
var statearr_13687_13801 = state_13685__$1;
(statearr_13687_13801[(2)] = null);

(statearr_13687_13801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (2))){
var state_13685__$1 = state_13685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13685__$1,(4),from);
} else {
if((state_val_13686 === (3))){
var inst_13683 = (state_13685[(2)]);
var state_13685__$1 = state_13685;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13685__$1,inst_13683);
} else {
if((state_val_13686 === (4))){
var inst_13666 = (state_13685[(7)]);
var inst_13666__$1 = (state_13685[(2)]);
var inst_13667 = (inst_13666__$1 == null);
var state_13685__$1 = (function (){var statearr_13688 = state_13685;
(statearr_13688[(7)] = inst_13666__$1);

return statearr_13688;
})();
if(cljs.core.truth_(inst_13667)){
var statearr_13689_13802 = state_13685__$1;
(statearr_13689_13802[(1)] = (5));

} else {
var statearr_13690_13803 = state_13685__$1;
(statearr_13690_13803[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (5))){
var inst_13669 = cljs.core.async.close_BANG_.call(null,jobs);
var state_13685__$1 = state_13685;
var statearr_13691_13804 = state_13685__$1;
(statearr_13691_13804[(2)] = inst_13669);

(statearr_13691_13804[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (6))){
var inst_13671 = (state_13685[(8)]);
var inst_13666 = (state_13685[(7)]);
var inst_13671__$1 = cljs.core.async.chan.call(null,(1));
var inst_13672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13673 = [inst_13666,inst_13671__$1];
var inst_13674 = (new cljs.core.PersistentVector(null,2,(5),inst_13672,inst_13673,null));
var state_13685__$1 = (function (){var statearr_13692 = state_13685;
(statearr_13692[(8)] = inst_13671__$1);

return statearr_13692;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13685__$1,(8),jobs,inst_13674);
} else {
if((state_val_13686 === (7))){
var inst_13681 = (state_13685[(2)]);
var state_13685__$1 = state_13685;
var statearr_13693_13805 = state_13685__$1;
(statearr_13693_13805[(2)] = inst_13681);

(statearr_13693_13805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13686 === (8))){
var inst_13671 = (state_13685[(8)]);
var inst_13676 = (state_13685[(2)]);
var state_13685__$1 = (function (){var statearr_13694 = state_13685;
(statearr_13694[(9)] = inst_13676);

return statearr_13694;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13685__$1,(9),results,inst_13671);
} else {
if((state_val_13686 === (9))){
var inst_13678 = (state_13685[(2)]);
var state_13685__$1 = (function (){var statearr_13695 = state_13685;
(statearr_13695[(10)] = inst_13678);

return statearr_13695;
})();
var statearr_13696_13806 = state_13685__$1;
(statearr_13696_13806[(2)] = null);

(statearr_13696_13806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___13800,jobs,results,process,async))
;
return ((function (switch__13104__auto__,c__13216__auto___13800,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_13700 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13700[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__);

(statearr_13700[(1)] = (1));

return statearr_13700;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1 = (function (state_13685){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_13685);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e13701){if((e13701 instanceof Object)){
var ex__13108__auto__ = e13701;
var statearr_13702_13807 = state_13685;
(statearr_13702_13807[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13685);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13701;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13808 = state_13685;
state_13685 = G__13808;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = function(state_13685){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1.call(this,state_13685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___13800,jobs,results,process,async))
})();
var state__13218__auto__ = (function (){var statearr_13703 = f__13217__auto__.call(null);
(statearr_13703[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___13800);

return statearr_13703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___13800,jobs,results,process,async))
);


var c__13216__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto__,jobs,results,process,async){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,jobs,results,process,async){
return (function (state_13741){
var state_val_13742 = (state_13741[(1)]);
if((state_val_13742 === (7))){
var inst_13737 = (state_13741[(2)]);
var state_13741__$1 = state_13741;
var statearr_13743_13809 = state_13741__$1;
(statearr_13743_13809[(2)] = inst_13737);

(statearr_13743_13809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (20))){
var state_13741__$1 = state_13741;
var statearr_13744_13810 = state_13741__$1;
(statearr_13744_13810[(2)] = null);

(statearr_13744_13810[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (1))){
var state_13741__$1 = state_13741;
var statearr_13745_13811 = state_13741__$1;
(statearr_13745_13811[(2)] = null);

(statearr_13745_13811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (4))){
var inst_13706 = (state_13741[(7)]);
var inst_13706__$1 = (state_13741[(2)]);
var inst_13707 = (inst_13706__$1 == null);
var state_13741__$1 = (function (){var statearr_13746 = state_13741;
(statearr_13746[(7)] = inst_13706__$1);

return statearr_13746;
})();
if(cljs.core.truth_(inst_13707)){
var statearr_13747_13812 = state_13741__$1;
(statearr_13747_13812[(1)] = (5));

} else {
var statearr_13748_13813 = state_13741__$1;
(statearr_13748_13813[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (15))){
var inst_13719 = (state_13741[(8)]);
var state_13741__$1 = state_13741;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13741__$1,(18),to,inst_13719);
} else {
if((state_val_13742 === (21))){
var inst_13732 = (state_13741[(2)]);
var state_13741__$1 = state_13741;
var statearr_13749_13814 = state_13741__$1;
(statearr_13749_13814[(2)] = inst_13732);

(statearr_13749_13814[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (13))){
var inst_13734 = (state_13741[(2)]);
var state_13741__$1 = (function (){var statearr_13750 = state_13741;
(statearr_13750[(9)] = inst_13734);

return statearr_13750;
})();
var statearr_13751_13815 = state_13741__$1;
(statearr_13751_13815[(2)] = null);

(statearr_13751_13815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (6))){
var inst_13706 = (state_13741[(7)]);
var state_13741__$1 = state_13741;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13741__$1,(11),inst_13706);
} else {
if((state_val_13742 === (17))){
var inst_13727 = (state_13741[(2)]);
var state_13741__$1 = state_13741;
if(cljs.core.truth_(inst_13727)){
var statearr_13752_13816 = state_13741__$1;
(statearr_13752_13816[(1)] = (19));

} else {
var statearr_13753_13817 = state_13741__$1;
(statearr_13753_13817[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (3))){
var inst_13739 = (state_13741[(2)]);
var state_13741__$1 = state_13741;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13741__$1,inst_13739);
} else {
if((state_val_13742 === (12))){
var inst_13716 = (state_13741[(10)]);
var state_13741__$1 = state_13741;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13741__$1,(14),inst_13716);
} else {
if((state_val_13742 === (2))){
var state_13741__$1 = state_13741;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13741__$1,(4),results);
} else {
if((state_val_13742 === (19))){
var state_13741__$1 = state_13741;
var statearr_13754_13818 = state_13741__$1;
(statearr_13754_13818[(2)] = null);

(statearr_13754_13818[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (11))){
var inst_13716 = (state_13741[(2)]);
var state_13741__$1 = (function (){var statearr_13755 = state_13741;
(statearr_13755[(10)] = inst_13716);

return statearr_13755;
})();
var statearr_13756_13819 = state_13741__$1;
(statearr_13756_13819[(2)] = null);

(statearr_13756_13819[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (9))){
var state_13741__$1 = state_13741;
var statearr_13757_13820 = state_13741__$1;
(statearr_13757_13820[(2)] = null);

(statearr_13757_13820[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (5))){
var state_13741__$1 = state_13741;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13758_13821 = state_13741__$1;
(statearr_13758_13821[(1)] = (8));

} else {
var statearr_13759_13822 = state_13741__$1;
(statearr_13759_13822[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (14))){
var inst_13719 = (state_13741[(8)]);
var inst_13721 = (state_13741[(11)]);
var inst_13719__$1 = (state_13741[(2)]);
var inst_13720 = (inst_13719__$1 == null);
var inst_13721__$1 = cljs.core.not.call(null,inst_13720);
var state_13741__$1 = (function (){var statearr_13760 = state_13741;
(statearr_13760[(8)] = inst_13719__$1);

(statearr_13760[(11)] = inst_13721__$1);

return statearr_13760;
})();
if(inst_13721__$1){
var statearr_13761_13823 = state_13741__$1;
(statearr_13761_13823[(1)] = (15));

} else {
var statearr_13762_13824 = state_13741__$1;
(statearr_13762_13824[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (16))){
var inst_13721 = (state_13741[(11)]);
var state_13741__$1 = state_13741;
var statearr_13763_13825 = state_13741__$1;
(statearr_13763_13825[(2)] = inst_13721);

(statearr_13763_13825[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (10))){
var inst_13713 = (state_13741[(2)]);
var state_13741__$1 = state_13741;
var statearr_13764_13826 = state_13741__$1;
(statearr_13764_13826[(2)] = inst_13713);

(statearr_13764_13826[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (18))){
var inst_13724 = (state_13741[(2)]);
var state_13741__$1 = state_13741;
var statearr_13765_13827 = state_13741__$1;
(statearr_13765_13827[(2)] = inst_13724);

(statearr_13765_13827[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13742 === (8))){
var inst_13710 = cljs.core.async.close_BANG_.call(null,to);
var state_13741__$1 = state_13741;
var statearr_13766_13828 = state_13741__$1;
(statearr_13766_13828[(2)] = inst_13710);

(statearr_13766_13828[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__,jobs,results,process,async))
;
return ((function (switch__13104__auto__,c__13216__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_13770 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13770[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__);

(statearr_13770[(1)] = (1));

return statearr_13770;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1 = (function (state_13741){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_13741);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e13771){if((e13771 instanceof Object)){
var ex__13108__auto__ = e13771;
var statearr_13772_13829 = state_13741;
(statearr_13772_13829[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13741);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13771;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13830 = state_13741;
state_13741 = G__13830;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = function(state_13741){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1.call(this,state_13741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,jobs,results,process,async))
})();
var state__13218__auto__ = (function (){var statearr_13773 = f__13217__auto__.call(null);
(statearr_13773[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_13773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto__,jobs,results,process,async))
);

return c__13216__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args13831 = [];
var len__7484__auto___13834 = arguments.length;
var i__7485__auto___13835 = (0);
while(true){
if((i__7485__auto___13835 < len__7484__auto___13834)){
args13831.push((arguments[i__7485__auto___13835]));

var G__13836 = (i__7485__auto___13835 + (1));
i__7485__auto___13835 = G__13836;
continue;
} else {
}
break;
}

var G__13833 = args13831.length;
switch (G__13833) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13831.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args13838 = [];
var len__7484__auto___13841 = arguments.length;
var i__7485__auto___13842 = (0);
while(true){
if((i__7485__auto___13842 < len__7484__auto___13841)){
args13838.push((arguments[i__7485__auto___13842]));

var G__13843 = (i__7485__auto___13842 + (1));
i__7485__auto___13842 = G__13843;
continue;
} else {
}
break;
}

var G__13840 = args13838.length;
switch (G__13840) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13838.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args13845 = [];
var len__7484__auto___13898 = arguments.length;
var i__7485__auto___13899 = (0);
while(true){
if((i__7485__auto___13899 < len__7484__auto___13898)){
args13845.push((arguments[i__7485__auto___13899]));

var G__13900 = (i__7485__auto___13899 + (1));
i__7485__auto___13899 = G__13900;
continue;
} else {
}
break;
}

var G__13847 = args13845.length;
switch (G__13847) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args13845.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__13216__auto___13902 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___13902,tc,fc){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___13902,tc,fc){
return (function (state_13873){
var state_val_13874 = (state_13873[(1)]);
if((state_val_13874 === (7))){
var inst_13869 = (state_13873[(2)]);
var state_13873__$1 = state_13873;
var statearr_13875_13903 = state_13873__$1;
(statearr_13875_13903[(2)] = inst_13869);

(statearr_13875_13903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (1))){
var state_13873__$1 = state_13873;
var statearr_13876_13904 = state_13873__$1;
(statearr_13876_13904[(2)] = null);

(statearr_13876_13904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (4))){
var inst_13850 = (state_13873[(7)]);
var inst_13850__$1 = (state_13873[(2)]);
var inst_13851 = (inst_13850__$1 == null);
var state_13873__$1 = (function (){var statearr_13877 = state_13873;
(statearr_13877[(7)] = inst_13850__$1);

return statearr_13877;
})();
if(cljs.core.truth_(inst_13851)){
var statearr_13878_13905 = state_13873__$1;
(statearr_13878_13905[(1)] = (5));

} else {
var statearr_13879_13906 = state_13873__$1;
(statearr_13879_13906[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (13))){
var state_13873__$1 = state_13873;
var statearr_13880_13907 = state_13873__$1;
(statearr_13880_13907[(2)] = null);

(statearr_13880_13907[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (6))){
var inst_13850 = (state_13873[(7)]);
var inst_13856 = p.call(null,inst_13850);
var state_13873__$1 = state_13873;
if(cljs.core.truth_(inst_13856)){
var statearr_13881_13908 = state_13873__$1;
(statearr_13881_13908[(1)] = (9));

} else {
var statearr_13882_13909 = state_13873__$1;
(statearr_13882_13909[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (3))){
var inst_13871 = (state_13873[(2)]);
var state_13873__$1 = state_13873;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13873__$1,inst_13871);
} else {
if((state_val_13874 === (12))){
var state_13873__$1 = state_13873;
var statearr_13883_13910 = state_13873__$1;
(statearr_13883_13910[(2)] = null);

(statearr_13883_13910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (2))){
var state_13873__$1 = state_13873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13873__$1,(4),ch);
} else {
if((state_val_13874 === (11))){
var inst_13850 = (state_13873[(7)]);
var inst_13860 = (state_13873[(2)]);
var state_13873__$1 = state_13873;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13873__$1,(8),inst_13860,inst_13850);
} else {
if((state_val_13874 === (9))){
var state_13873__$1 = state_13873;
var statearr_13884_13911 = state_13873__$1;
(statearr_13884_13911[(2)] = tc);

(statearr_13884_13911[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (5))){
var inst_13853 = cljs.core.async.close_BANG_.call(null,tc);
var inst_13854 = cljs.core.async.close_BANG_.call(null,fc);
var state_13873__$1 = (function (){var statearr_13885 = state_13873;
(statearr_13885[(8)] = inst_13853);

return statearr_13885;
})();
var statearr_13886_13912 = state_13873__$1;
(statearr_13886_13912[(2)] = inst_13854);

(statearr_13886_13912[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (14))){
var inst_13867 = (state_13873[(2)]);
var state_13873__$1 = state_13873;
var statearr_13887_13913 = state_13873__$1;
(statearr_13887_13913[(2)] = inst_13867);

(statearr_13887_13913[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (10))){
var state_13873__$1 = state_13873;
var statearr_13888_13914 = state_13873__$1;
(statearr_13888_13914[(2)] = fc);

(statearr_13888_13914[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (8))){
var inst_13862 = (state_13873[(2)]);
var state_13873__$1 = state_13873;
if(cljs.core.truth_(inst_13862)){
var statearr_13889_13915 = state_13873__$1;
(statearr_13889_13915[(1)] = (12));

} else {
var statearr_13890_13916 = state_13873__$1;
(statearr_13890_13916[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___13902,tc,fc))
;
return ((function (switch__13104__auto__,c__13216__auto___13902,tc,fc){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_13894 = [null,null,null,null,null,null,null,null,null];
(statearr_13894[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_13894[(1)] = (1));

return statearr_13894;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_13873){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_13873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e13895){if((e13895 instanceof Object)){
var ex__13108__auto__ = e13895;
var statearr_13896_13917 = state_13873;
(statearr_13896_13917[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13873);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13895;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13918 = state_13873;
state_13873 = G__13918;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_13873){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_13873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___13902,tc,fc))
})();
var state__13218__auto__ = (function (){var statearr_13897 = f__13217__auto__.call(null);
(statearr_13897[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___13902);

return statearr_13897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___13902,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__13216__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto__){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__){
return (function (state_13982){
var state_val_13983 = (state_13982[(1)]);
if((state_val_13983 === (7))){
var inst_13978 = (state_13982[(2)]);
var state_13982__$1 = state_13982;
var statearr_13984_14005 = state_13982__$1;
(statearr_13984_14005[(2)] = inst_13978);

(statearr_13984_14005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13983 === (1))){
var inst_13962 = init;
var state_13982__$1 = (function (){var statearr_13985 = state_13982;
(statearr_13985[(7)] = inst_13962);

return statearr_13985;
})();
var statearr_13986_14006 = state_13982__$1;
(statearr_13986_14006[(2)] = null);

(statearr_13986_14006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13983 === (4))){
var inst_13965 = (state_13982[(8)]);
var inst_13965__$1 = (state_13982[(2)]);
var inst_13966 = (inst_13965__$1 == null);
var state_13982__$1 = (function (){var statearr_13987 = state_13982;
(statearr_13987[(8)] = inst_13965__$1);

return statearr_13987;
})();
if(cljs.core.truth_(inst_13966)){
var statearr_13988_14007 = state_13982__$1;
(statearr_13988_14007[(1)] = (5));

} else {
var statearr_13989_14008 = state_13982__$1;
(statearr_13989_14008[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13983 === (6))){
var inst_13965 = (state_13982[(8)]);
var inst_13969 = (state_13982[(9)]);
var inst_13962 = (state_13982[(7)]);
var inst_13969__$1 = f.call(null,inst_13962,inst_13965);
var inst_13970 = cljs.core.reduced_QMARK_.call(null,inst_13969__$1);
var state_13982__$1 = (function (){var statearr_13990 = state_13982;
(statearr_13990[(9)] = inst_13969__$1);

return statearr_13990;
})();
if(inst_13970){
var statearr_13991_14009 = state_13982__$1;
(statearr_13991_14009[(1)] = (8));

} else {
var statearr_13992_14010 = state_13982__$1;
(statearr_13992_14010[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13983 === (3))){
var inst_13980 = (state_13982[(2)]);
var state_13982__$1 = state_13982;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13982__$1,inst_13980);
} else {
if((state_val_13983 === (2))){
var state_13982__$1 = state_13982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13982__$1,(4),ch);
} else {
if((state_val_13983 === (9))){
var inst_13969 = (state_13982[(9)]);
var inst_13962 = inst_13969;
var state_13982__$1 = (function (){var statearr_13993 = state_13982;
(statearr_13993[(7)] = inst_13962);

return statearr_13993;
})();
var statearr_13994_14011 = state_13982__$1;
(statearr_13994_14011[(2)] = null);

(statearr_13994_14011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13983 === (5))){
var inst_13962 = (state_13982[(7)]);
var state_13982__$1 = state_13982;
var statearr_13995_14012 = state_13982__$1;
(statearr_13995_14012[(2)] = inst_13962);

(statearr_13995_14012[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13983 === (10))){
var inst_13976 = (state_13982[(2)]);
var state_13982__$1 = state_13982;
var statearr_13996_14013 = state_13982__$1;
(statearr_13996_14013[(2)] = inst_13976);

(statearr_13996_14013[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13983 === (8))){
var inst_13969 = (state_13982[(9)]);
var inst_13972 = cljs.core.deref.call(null,inst_13969);
var state_13982__$1 = state_13982;
var statearr_13997_14014 = state_13982__$1;
(statearr_13997_14014[(2)] = inst_13972);

(statearr_13997_14014[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__))
;
return ((function (switch__13104__auto__,c__13216__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__13105__auto__ = null;
var cljs$core$async$reduce_$_state_machine__13105__auto____0 = (function (){
var statearr_14001 = [null,null,null,null,null,null,null,null,null,null];
(statearr_14001[(0)] = cljs$core$async$reduce_$_state_machine__13105__auto__);

(statearr_14001[(1)] = (1));

return statearr_14001;
});
var cljs$core$async$reduce_$_state_machine__13105__auto____1 = (function (state_13982){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_13982);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e14002){if((e14002 instanceof Object)){
var ex__13108__auto__ = e14002;
var statearr_14003_14015 = state_13982;
(statearr_14003_14015[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13982);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14002;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14016 = state_13982;
state_13982 = G__14016;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__13105__auto__ = function(state_13982){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__13105__auto____1.call(this,state_13982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__13105__auto____0;
cljs$core$async$reduce_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__13105__auto____1;
return cljs$core$async$reduce_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__))
})();
var state__13218__auto__ = (function (){var statearr_14004 = f__13217__auto__.call(null);
(statearr_14004[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_14004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto__))
);

return c__13216__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__13216__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto__,f__$1){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,f__$1){
return (function (state_14036){
var state_val_14037 = (state_14036[(1)]);
if((state_val_14037 === (1))){
var inst_14031 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_14036__$1 = state_14036;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14036__$1,(2),inst_14031);
} else {
if((state_val_14037 === (2))){
var inst_14033 = (state_14036[(2)]);
var inst_14034 = f__$1.call(null,inst_14033);
var state_14036__$1 = state_14036;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14036__$1,inst_14034);
} else {
return null;
}
}
});})(c__13216__auto__,f__$1))
;
return ((function (switch__13104__auto__,c__13216__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__13105__auto__ = null;
var cljs$core$async$transduce_$_state_machine__13105__auto____0 = (function (){
var statearr_14041 = [null,null,null,null,null,null,null];
(statearr_14041[(0)] = cljs$core$async$transduce_$_state_machine__13105__auto__);

(statearr_14041[(1)] = (1));

return statearr_14041;
});
var cljs$core$async$transduce_$_state_machine__13105__auto____1 = (function (state_14036){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_14036);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e14042){if((e14042 instanceof Object)){
var ex__13108__auto__ = e14042;
var statearr_14043_14045 = state_14036;
(statearr_14043_14045[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14036);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14042;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14046 = state_14036;
state_14036 = G__14046;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__13105__auto__ = function(state_14036){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__13105__auto____1.call(this,state_14036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__13105__auto____0;
cljs$core$async$transduce_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__13105__auto____1;
return cljs$core$async$transduce_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,f__$1))
})();
var state__13218__auto__ = (function (){var statearr_14044 = f__13217__auto__.call(null);
(statearr_14044[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_14044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto__,f__$1))
);

return c__13216__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args14047 = [];
var len__7484__auto___14099 = arguments.length;
var i__7485__auto___14100 = (0);
while(true){
if((i__7485__auto___14100 < len__7484__auto___14099)){
args14047.push((arguments[i__7485__auto___14100]));

var G__14101 = (i__7485__auto___14100 + (1));
i__7485__auto___14100 = G__14101;
continue;
} else {
}
break;
}

var G__14049 = args14047.length;
switch (G__14049) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14047.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__13216__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto__){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__){
return (function (state_14074){
var state_val_14075 = (state_14074[(1)]);
if((state_val_14075 === (7))){
var inst_14056 = (state_14074[(2)]);
var state_14074__$1 = state_14074;
var statearr_14076_14103 = state_14074__$1;
(statearr_14076_14103[(2)] = inst_14056);

(statearr_14076_14103[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14075 === (1))){
var inst_14050 = cljs.core.seq.call(null,coll);
var inst_14051 = inst_14050;
var state_14074__$1 = (function (){var statearr_14077 = state_14074;
(statearr_14077[(7)] = inst_14051);

return statearr_14077;
})();
var statearr_14078_14104 = state_14074__$1;
(statearr_14078_14104[(2)] = null);

(statearr_14078_14104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14075 === (4))){
var inst_14051 = (state_14074[(7)]);
var inst_14054 = cljs.core.first.call(null,inst_14051);
var state_14074__$1 = state_14074;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14074__$1,(7),ch,inst_14054);
} else {
if((state_val_14075 === (13))){
var inst_14068 = (state_14074[(2)]);
var state_14074__$1 = state_14074;
var statearr_14079_14105 = state_14074__$1;
(statearr_14079_14105[(2)] = inst_14068);

(statearr_14079_14105[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14075 === (6))){
var inst_14059 = (state_14074[(2)]);
var state_14074__$1 = state_14074;
if(cljs.core.truth_(inst_14059)){
var statearr_14080_14106 = state_14074__$1;
(statearr_14080_14106[(1)] = (8));

} else {
var statearr_14081_14107 = state_14074__$1;
(statearr_14081_14107[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14075 === (3))){
var inst_14072 = (state_14074[(2)]);
var state_14074__$1 = state_14074;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14074__$1,inst_14072);
} else {
if((state_val_14075 === (12))){
var state_14074__$1 = state_14074;
var statearr_14082_14108 = state_14074__$1;
(statearr_14082_14108[(2)] = null);

(statearr_14082_14108[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14075 === (2))){
var inst_14051 = (state_14074[(7)]);
var state_14074__$1 = state_14074;
if(cljs.core.truth_(inst_14051)){
var statearr_14083_14109 = state_14074__$1;
(statearr_14083_14109[(1)] = (4));

} else {
var statearr_14084_14110 = state_14074__$1;
(statearr_14084_14110[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14075 === (11))){
var inst_14065 = cljs.core.async.close_BANG_.call(null,ch);
var state_14074__$1 = state_14074;
var statearr_14085_14111 = state_14074__$1;
(statearr_14085_14111[(2)] = inst_14065);

(statearr_14085_14111[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14075 === (9))){
var state_14074__$1 = state_14074;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14086_14112 = state_14074__$1;
(statearr_14086_14112[(1)] = (11));

} else {
var statearr_14087_14113 = state_14074__$1;
(statearr_14087_14113[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14075 === (5))){
var inst_14051 = (state_14074[(7)]);
var state_14074__$1 = state_14074;
var statearr_14088_14114 = state_14074__$1;
(statearr_14088_14114[(2)] = inst_14051);

(statearr_14088_14114[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14075 === (10))){
var inst_14070 = (state_14074[(2)]);
var state_14074__$1 = state_14074;
var statearr_14089_14115 = state_14074__$1;
(statearr_14089_14115[(2)] = inst_14070);

(statearr_14089_14115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14075 === (8))){
var inst_14051 = (state_14074[(7)]);
var inst_14061 = cljs.core.next.call(null,inst_14051);
var inst_14051__$1 = inst_14061;
var state_14074__$1 = (function (){var statearr_14090 = state_14074;
(statearr_14090[(7)] = inst_14051__$1);

return statearr_14090;
})();
var statearr_14091_14116 = state_14074__$1;
(statearr_14091_14116[(2)] = null);

(statearr_14091_14116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__))
;
return ((function (switch__13104__auto__,c__13216__auto__){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_14095 = [null,null,null,null,null,null,null,null];
(statearr_14095[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_14095[(1)] = (1));

return statearr_14095;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_14074){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_14074);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e14096){if((e14096 instanceof Object)){
var ex__13108__auto__ = e14096;
var statearr_14097_14117 = state_14074;
(statearr_14097_14117[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14074);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14096;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14118 = state_14074;
state_14074 = G__14118;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_14074){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_14074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__))
})();
var state__13218__auto__ = (function (){var statearr_14098 = f__13217__auto__.call(null);
(statearr_14098[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_14098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto__))
);

return c__13216__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,_);
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async14344 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14344 = (function (mult,ch,cs,meta14345){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta14345 = meta14345;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14344.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_14346,meta14345__$1){
var self__ = this;
var _14346__$1 = this;
return (new cljs.core.async.t_cljs$core$async14344(self__.mult,self__.ch,self__.cs,meta14345__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async14344.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_14346){
var self__ = this;
var _14346__$1 = this;
return self__.meta14345;
});})(cs))
;

cljs.core.async.t_cljs$core$async14344.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async14344.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async14344.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async14344.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14344.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14344.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async14344.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta14345","meta14345",-592973992,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async14344.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14344.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14344";

cljs.core.async.t_cljs$core$async14344.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14344");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async14344 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async14344(mult__$1,ch__$1,cs__$1,meta14345){
return (new cljs.core.async.t_cljs$core$async14344(mult__$1,ch__$1,cs__$1,meta14345));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async14344(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__13216__auto___14569 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___14569,cs,m,dchan,dctr,done){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___14569,cs,m,dchan,dctr,done){
return (function (state_14481){
var state_val_14482 = (state_14481[(1)]);
if((state_val_14482 === (7))){
var inst_14477 = (state_14481[(2)]);
var state_14481__$1 = state_14481;
var statearr_14483_14570 = state_14481__$1;
(statearr_14483_14570[(2)] = inst_14477);

(statearr_14483_14570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (20))){
var inst_14380 = (state_14481[(7)]);
var inst_14392 = cljs.core.first.call(null,inst_14380);
var inst_14393 = cljs.core.nth.call(null,inst_14392,(0),null);
var inst_14394 = cljs.core.nth.call(null,inst_14392,(1),null);
var state_14481__$1 = (function (){var statearr_14484 = state_14481;
(statearr_14484[(8)] = inst_14393);

return statearr_14484;
})();
if(cljs.core.truth_(inst_14394)){
var statearr_14485_14571 = state_14481__$1;
(statearr_14485_14571[(1)] = (22));

} else {
var statearr_14486_14572 = state_14481__$1;
(statearr_14486_14572[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (27))){
var inst_14349 = (state_14481[(9)]);
var inst_14424 = (state_14481[(10)]);
var inst_14422 = (state_14481[(11)]);
var inst_14429 = (state_14481[(12)]);
var inst_14429__$1 = cljs.core._nth.call(null,inst_14422,inst_14424);
var inst_14430 = cljs.core.async.put_BANG_.call(null,inst_14429__$1,inst_14349,done);
var state_14481__$1 = (function (){var statearr_14487 = state_14481;
(statearr_14487[(12)] = inst_14429__$1);

return statearr_14487;
})();
if(cljs.core.truth_(inst_14430)){
var statearr_14488_14573 = state_14481__$1;
(statearr_14488_14573[(1)] = (30));

} else {
var statearr_14489_14574 = state_14481__$1;
(statearr_14489_14574[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (1))){
var state_14481__$1 = state_14481;
var statearr_14490_14575 = state_14481__$1;
(statearr_14490_14575[(2)] = null);

(statearr_14490_14575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (24))){
var inst_14380 = (state_14481[(7)]);
var inst_14399 = (state_14481[(2)]);
var inst_14400 = cljs.core.next.call(null,inst_14380);
var inst_14358 = inst_14400;
var inst_14359 = null;
var inst_14360 = (0);
var inst_14361 = (0);
var state_14481__$1 = (function (){var statearr_14491 = state_14481;
(statearr_14491[(13)] = inst_14360);

(statearr_14491[(14)] = inst_14359);

(statearr_14491[(15)] = inst_14399);

(statearr_14491[(16)] = inst_14358);

(statearr_14491[(17)] = inst_14361);

return statearr_14491;
})();
var statearr_14492_14576 = state_14481__$1;
(statearr_14492_14576[(2)] = null);

(statearr_14492_14576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (39))){
var state_14481__$1 = state_14481;
var statearr_14496_14577 = state_14481__$1;
(statearr_14496_14577[(2)] = null);

(statearr_14496_14577[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (4))){
var inst_14349 = (state_14481[(9)]);
var inst_14349__$1 = (state_14481[(2)]);
var inst_14350 = (inst_14349__$1 == null);
var state_14481__$1 = (function (){var statearr_14497 = state_14481;
(statearr_14497[(9)] = inst_14349__$1);

return statearr_14497;
})();
if(cljs.core.truth_(inst_14350)){
var statearr_14498_14578 = state_14481__$1;
(statearr_14498_14578[(1)] = (5));

} else {
var statearr_14499_14579 = state_14481__$1;
(statearr_14499_14579[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (15))){
var inst_14360 = (state_14481[(13)]);
var inst_14359 = (state_14481[(14)]);
var inst_14358 = (state_14481[(16)]);
var inst_14361 = (state_14481[(17)]);
var inst_14376 = (state_14481[(2)]);
var inst_14377 = (inst_14361 + (1));
var tmp14493 = inst_14360;
var tmp14494 = inst_14359;
var tmp14495 = inst_14358;
var inst_14358__$1 = tmp14495;
var inst_14359__$1 = tmp14494;
var inst_14360__$1 = tmp14493;
var inst_14361__$1 = inst_14377;
var state_14481__$1 = (function (){var statearr_14500 = state_14481;
(statearr_14500[(13)] = inst_14360__$1);

(statearr_14500[(14)] = inst_14359__$1);

(statearr_14500[(18)] = inst_14376);

(statearr_14500[(16)] = inst_14358__$1);

(statearr_14500[(17)] = inst_14361__$1);

return statearr_14500;
})();
var statearr_14501_14580 = state_14481__$1;
(statearr_14501_14580[(2)] = null);

(statearr_14501_14580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (21))){
var inst_14403 = (state_14481[(2)]);
var state_14481__$1 = state_14481;
var statearr_14505_14581 = state_14481__$1;
(statearr_14505_14581[(2)] = inst_14403);

(statearr_14505_14581[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (31))){
var inst_14429 = (state_14481[(12)]);
var inst_14433 = done.call(null,null);
var inst_14434 = cljs.core.async.untap_STAR_.call(null,m,inst_14429);
var state_14481__$1 = (function (){var statearr_14506 = state_14481;
(statearr_14506[(19)] = inst_14433);

return statearr_14506;
})();
var statearr_14507_14582 = state_14481__$1;
(statearr_14507_14582[(2)] = inst_14434);

(statearr_14507_14582[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (32))){
var inst_14423 = (state_14481[(20)]);
var inst_14424 = (state_14481[(10)]);
var inst_14422 = (state_14481[(11)]);
var inst_14421 = (state_14481[(21)]);
var inst_14436 = (state_14481[(2)]);
var inst_14437 = (inst_14424 + (1));
var tmp14502 = inst_14423;
var tmp14503 = inst_14422;
var tmp14504 = inst_14421;
var inst_14421__$1 = tmp14504;
var inst_14422__$1 = tmp14503;
var inst_14423__$1 = tmp14502;
var inst_14424__$1 = inst_14437;
var state_14481__$1 = (function (){var statearr_14508 = state_14481;
(statearr_14508[(22)] = inst_14436);

(statearr_14508[(20)] = inst_14423__$1);

(statearr_14508[(10)] = inst_14424__$1);

(statearr_14508[(11)] = inst_14422__$1);

(statearr_14508[(21)] = inst_14421__$1);

return statearr_14508;
})();
var statearr_14509_14583 = state_14481__$1;
(statearr_14509_14583[(2)] = null);

(statearr_14509_14583[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (40))){
var inst_14449 = (state_14481[(23)]);
var inst_14453 = done.call(null,null);
var inst_14454 = cljs.core.async.untap_STAR_.call(null,m,inst_14449);
var state_14481__$1 = (function (){var statearr_14510 = state_14481;
(statearr_14510[(24)] = inst_14453);

return statearr_14510;
})();
var statearr_14511_14584 = state_14481__$1;
(statearr_14511_14584[(2)] = inst_14454);

(statearr_14511_14584[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (33))){
var inst_14440 = (state_14481[(25)]);
var inst_14442 = cljs.core.chunked_seq_QMARK_.call(null,inst_14440);
var state_14481__$1 = state_14481;
if(inst_14442){
var statearr_14512_14585 = state_14481__$1;
(statearr_14512_14585[(1)] = (36));

} else {
var statearr_14513_14586 = state_14481__$1;
(statearr_14513_14586[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (13))){
var inst_14370 = (state_14481[(26)]);
var inst_14373 = cljs.core.async.close_BANG_.call(null,inst_14370);
var state_14481__$1 = state_14481;
var statearr_14514_14587 = state_14481__$1;
(statearr_14514_14587[(2)] = inst_14373);

(statearr_14514_14587[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (22))){
var inst_14393 = (state_14481[(8)]);
var inst_14396 = cljs.core.async.close_BANG_.call(null,inst_14393);
var state_14481__$1 = state_14481;
var statearr_14515_14588 = state_14481__$1;
(statearr_14515_14588[(2)] = inst_14396);

(statearr_14515_14588[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (36))){
var inst_14440 = (state_14481[(25)]);
var inst_14444 = cljs.core.chunk_first.call(null,inst_14440);
var inst_14445 = cljs.core.chunk_rest.call(null,inst_14440);
var inst_14446 = cljs.core.count.call(null,inst_14444);
var inst_14421 = inst_14445;
var inst_14422 = inst_14444;
var inst_14423 = inst_14446;
var inst_14424 = (0);
var state_14481__$1 = (function (){var statearr_14516 = state_14481;
(statearr_14516[(20)] = inst_14423);

(statearr_14516[(10)] = inst_14424);

(statearr_14516[(11)] = inst_14422);

(statearr_14516[(21)] = inst_14421);

return statearr_14516;
})();
var statearr_14517_14589 = state_14481__$1;
(statearr_14517_14589[(2)] = null);

(statearr_14517_14589[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (41))){
var inst_14440 = (state_14481[(25)]);
var inst_14456 = (state_14481[(2)]);
var inst_14457 = cljs.core.next.call(null,inst_14440);
var inst_14421 = inst_14457;
var inst_14422 = null;
var inst_14423 = (0);
var inst_14424 = (0);
var state_14481__$1 = (function (){var statearr_14518 = state_14481;
(statearr_14518[(20)] = inst_14423);

(statearr_14518[(27)] = inst_14456);

(statearr_14518[(10)] = inst_14424);

(statearr_14518[(11)] = inst_14422);

(statearr_14518[(21)] = inst_14421);

return statearr_14518;
})();
var statearr_14519_14590 = state_14481__$1;
(statearr_14519_14590[(2)] = null);

(statearr_14519_14590[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (43))){
var state_14481__$1 = state_14481;
var statearr_14520_14591 = state_14481__$1;
(statearr_14520_14591[(2)] = null);

(statearr_14520_14591[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (29))){
var inst_14465 = (state_14481[(2)]);
var state_14481__$1 = state_14481;
var statearr_14521_14592 = state_14481__$1;
(statearr_14521_14592[(2)] = inst_14465);

(statearr_14521_14592[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (44))){
var inst_14474 = (state_14481[(2)]);
var state_14481__$1 = (function (){var statearr_14522 = state_14481;
(statearr_14522[(28)] = inst_14474);

return statearr_14522;
})();
var statearr_14523_14593 = state_14481__$1;
(statearr_14523_14593[(2)] = null);

(statearr_14523_14593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (6))){
var inst_14413 = (state_14481[(29)]);
var inst_14412 = cljs.core.deref.call(null,cs);
var inst_14413__$1 = cljs.core.keys.call(null,inst_14412);
var inst_14414 = cljs.core.count.call(null,inst_14413__$1);
var inst_14415 = cljs.core.reset_BANG_.call(null,dctr,inst_14414);
var inst_14420 = cljs.core.seq.call(null,inst_14413__$1);
var inst_14421 = inst_14420;
var inst_14422 = null;
var inst_14423 = (0);
var inst_14424 = (0);
var state_14481__$1 = (function (){var statearr_14524 = state_14481;
(statearr_14524[(20)] = inst_14423);

(statearr_14524[(10)] = inst_14424);

(statearr_14524[(11)] = inst_14422);

(statearr_14524[(29)] = inst_14413__$1);

(statearr_14524[(21)] = inst_14421);

(statearr_14524[(30)] = inst_14415);

return statearr_14524;
})();
var statearr_14525_14594 = state_14481__$1;
(statearr_14525_14594[(2)] = null);

(statearr_14525_14594[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (28))){
var inst_14421 = (state_14481[(21)]);
var inst_14440 = (state_14481[(25)]);
var inst_14440__$1 = cljs.core.seq.call(null,inst_14421);
var state_14481__$1 = (function (){var statearr_14526 = state_14481;
(statearr_14526[(25)] = inst_14440__$1);

return statearr_14526;
})();
if(inst_14440__$1){
var statearr_14527_14595 = state_14481__$1;
(statearr_14527_14595[(1)] = (33));

} else {
var statearr_14528_14596 = state_14481__$1;
(statearr_14528_14596[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (25))){
var inst_14423 = (state_14481[(20)]);
var inst_14424 = (state_14481[(10)]);
var inst_14426 = (inst_14424 < inst_14423);
var inst_14427 = inst_14426;
var state_14481__$1 = state_14481;
if(cljs.core.truth_(inst_14427)){
var statearr_14529_14597 = state_14481__$1;
(statearr_14529_14597[(1)] = (27));

} else {
var statearr_14530_14598 = state_14481__$1;
(statearr_14530_14598[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (34))){
var state_14481__$1 = state_14481;
var statearr_14531_14599 = state_14481__$1;
(statearr_14531_14599[(2)] = null);

(statearr_14531_14599[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (17))){
var state_14481__$1 = state_14481;
var statearr_14532_14600 = state_14481__$1;
(statearr_14532_14600[(2)] = null);

(statearr_14532_14600[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (3))){
var inst_14479 = (state_14481[(2)]);
var state_14481__$1 = state_14481;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14481__$1,inst_14479);
} else {
if((state_val_14482 === (12))){
var inst_14408 = (state_14481[(2)]);
var state_14481__$1 = state_14481;
var statearr_14533_14601 = state_14481__$1;
(statearr_14533_14601[(2)] = inst_14408);

(statearr_14533_14601[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (2))){
var state_14481__$1 = state_14481;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14481__$1,(4),ch);
} else {
if((state_val_14482 === (23))){
var state_14481__$1 = state_14481;
var statearr_14534_14602 = state_14481__$1;
(statearr_14534_14602[(2)] = null);

(statearr_14534_14602[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (35))){
var inst_14463 = (state_14481[(2)]);
var state_14481__$1 = state_14481;
var statearr_14535_14603 = state_14481__$1;
(statearr_14535_14603[(2)] = inst_14463);

(statearr_14535_14603[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (19))){
var inst_14380 = (state_14481[(7)]);
var inst_14384 = cljs.core.chunk_first.call(null,inst_14380);
var inst_14385 = cljs.core.chunk_rest.call(null,inst_14380);
var inst_14386 = cljs.core.count.call(null,inst_14384);
var inst_14358 = inst_14385;
var inst_14359 = inst_14384;
var inst_14360 = inst_14386;
var inst_14361 = (0);
var state_14481__$1 = (function (){var statearr_14536 = state_14481;
(statearr_14536[(13)] = inst_14360);

(statearr_14536[(14)] = inst_14359);

(statearr_14536[(16)] = inst_14358);

(statearr_14536[(17)] = inst_14361);

return statearr_14536;
})();
var statearr_14537_14604 = state_14481__$1;
(statearr_14537_14604[(2)] = null);

(statearr_14537_14604[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (11))){
var inst_14380 = (state_14481[(7)]);
var inst_14358 = (state_14481[(16)]);
var inst_14380__$1 = cljs.core.seq.call(null,inst_14358);
var state_14481__$1 = (function (){var statearr_14538 = state_14481;
(statearr_14538[(7)] = inst_14380__$1);

return statearr_14538;
})();
if(inst_14380__$1){
var statearr_14539_14605 = state_14481__$1;
(statearr_14539_14605[(1)] = (16));

} else {
var statearr_14540_14606 = state_14481__$1;
(statearr_14540_14606[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (9))){
var inst_14410 = (state_14481[(2)]);
var state_14481__$1 = state_14481;
var statearr_14541_14607 = state_14481__$1;
(statearr_14541_14607[(2)] = inst_14410);

(statearr_14541_14607[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (5))){
var inst_14356 = cljs.core.deref.call(null,cs);
var inst_14357 = cljs.core.seq.call(null,inst_14356);
var inst_14358 = inst_14357;
var inst_14359 = null;
var inst_14360 = (0);
var inst_14361 = (0);
var state_14481__$1 = (function (){var statearr_14542 = state_14481;
(statearr_14542[(13)] = inst_14360);

(statearr_14542[(14)] = inst_14359);

(statearr_14542[(16)] = inst_14358);

(statearr_14542[(17)] = inst_14361);

return statearr_14542;
})();
var statearr_14543_14608 = state_14481__$1;
(statearr_14543_14608[(2)] = null);

(statearr_14543_14608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (14))){
var state_14481__$1 = state_14481;
var statearr_14544_14609 = state_14481__$1;
(statearr_14544_14609[(2)] = null);

(statearr_14544_14609[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (45))){
var inst_14471 = (state_14481[(2)]);
var state_14481__$1 = state_14481;
var statearr_14545_14610 = state_14481__$1;
(statearr_14545_14610[(2)] = inst_14471);

(statearr_14545_14610[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (26))){
var inst_14413 = (state_14481[(29)]);
var inst_14467 = (state_14481[(2)]);
var inst_14468 = cljs.core.seq.call(null,inst_14413);
var state_14481__$1 = (function (){var statearr_14546 = state_14481;
(statearr_14546[(31)] = inst_14467);

return statearr_14546;
})();
if(inst_14468){
var statearr_14547_14611 = state_14481__$1;
(statearr_14547_14611[(1)] = (42));

} else {
var statearr_14548_14612 = state_14481__$1;
(statearr_14548_14612[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (16))){
var inst_14380 = (state_14481[(7)]);
var inst_14382 = cljs.core.chunked_seq_QMARK_.call(null,inst_14380);
var state_14481__$1 = state_14481;
if(inst_14382){
var statearr_14549_14613 = state_14481__$1;
(statearr_14549_14613[(1)] = (19));

} else {
var statearr_14550_14614 = state_14481__$1;
(statearr_14550_14614[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (38))){
var inst_14460 = (state_14481[(2)]);
var state_14481__$1 = state_14481;
var statearr_14551_14615 = state_14481__$1;
(statearr_14551_14615[(2)] = inst_14460);

(statearr_14551_14615[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (30))){
var state_14481__$1 = state_14481;
var statearr_14552_14616 = state_14481__$1;
(statearr_14552_14616[(2)] = null);

(statearr_14552_14616[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (10))){
var inst_14359 = (state_14481[(14)]);
var inst_14361 = (state_14481[(17)]);
var inst_14369 = cljs.core._nth.call(null,inst_14359,inst_14361);
var inst_14370 = cljs.core.nth.call(null,inst_14369,(0),null);
var inst_14371 = cljs.core.nth.call(null,inst_14369,(1),null);
var state_14481__$1 = (function (){var statearr_14553 = state_14481;
(statearr_14553[(26)] = inst_14370);

return statearr_14553;
})();
if(cljs.core.truth_(inst_14371)){
var statearr_14554_14617 = state_14481__$1;
(statearr_14554_14617[(1)] = (13));

} else {
var statearr_14555_14618 = state_14481__$1;
(statearr_14555_14618[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (18))){
var inst_14406 = (state_14481[(2)]);
var state_14481__$1 = state_14481;
var statearr_14556_14619 = state_14481__$1;
(statearr_14556_14619[(2)] = inst_14406);

(statearr_14556_14619[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (42))){
var state_14481__$1 = state_14481;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14481__$1,(45),dchan);
} else {
if((state_val_14482 === (37))){
var inst_14449 = (state_14481[(23)]);
var inst_14349 = (state_14481[(9)]);
var inst_14440 = (state_14481[(25)]);
var inst_14449__$1 = cljs.core.first.call(null,inst_14440);
var inst_14450 = cljs.core.async.put_BANG_.call(null,inst_14449__$1,inst_14349,done);
var state_14481__$1 = (function (){var statearr_14557 = state_14481;
(statearr_14557[(23)] = inst_14449__$1);

return statearr_14557;
})();
if(cljs.core.truth_(inst_14450)){
var statearr_14558_14620 = state_14481__$1;
(statearr_14558_14620[(1)] = (39));

} else {
var statearr_14559_14621 = state_14481__$1;
(statearr_14559_14621[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14482 === (8))){
var inst_14360 = (state_14481[(13)]);
var inst_14361 = (state_14481[(17)]);
var inst_14363 = (inst_14361 < inst_14360);
var inst_14364 = inst_14363;
var state_14481__$1 = state_14481;
if(cljs.core.truth_(inst_14364)){
var statearr_14560_14622 = state_14481__$1;
(statearr_14560_14622[(1)] = (10));

} else {
var statearr_14561_14623 = state_14481__$1;
(statearr_14561_14623[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___14569,cs,m,dchan,dctr,done))
;
return ((function (switch__13104__auto__,c__13216__auto___14569,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__13105__auto__ = null;
var cljs$core$async$mult_$_state_machine__13105__auto____0 = (function (){
var statearr_14565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14565[(0)] = cljs$core$async$mult_$_state_machine__13105__auto__);

(statearr_14565[(1)] = (1));

return statearr_14565;
});
var cljs$core$async$mult_$_state_machine__13105__auto____1 = (function (state_14481){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_14481);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e14566){if((e14566 instanceof Object)){
var ex__13108__auto__ = e14566;
var statearr_14567_14624 = state_14481;
(statearr_14567_14624[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14481);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14566;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14625 = state_14481;
state_14481 = G__14625;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__13105__auto__ = function(state_14481){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__13105__auto____1.call(this,state_14481);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__13105__auto____0;
cljs$core$async$mult_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__13105__auto____1;
return cljs$core$async$mult_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___14569,cs,m,dchan,dctr,done))
})();
var state__13218__auto__ = (function (){var statearr_14568 = f__13217__auto__.call(null);
(statearr_14568[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___14569);

return statearr_14568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___14569,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args14626 = [];
var len__7484__auto___14629 = arguments.length;
var i__7485__auto___14630 = (0);
while(true){
if((i__7485__auto___14630 < len__7484__auto___14629)){
args14626.push((arguments[i__7485__auto___14630]));

var G__14631 = (i__7485__auto___14630 + (1));
i__7485__auto___14630 = G__14631;
continue;
} else {
}
break;
}

var G__14628 = args14626.length;
switch (G__14628) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14626.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m);
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,state_map);
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,m,mode);
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___14643 = arguments.length;
var i__7485__auto___14644 = (0);
while(true){
if((i__7485__auto___14644 < len__7484__auto___14643)){
args__7491__auto__.push((arguments[i__7485__auto___14644]));

var G__14645 = (i__7485__auto___14644 + (1));
i__7485__auto___14644 = G__14645;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__14637){
var map__14638 = p__14637;
var map__14638__$1 = ((((!((map__14638 == null)))?((((map__14638.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14638.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14638):map__14638);
var opts = map__14638__$1;
var statearr_14640_14646 = state;
(statearr_14640_14646[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__14638,map__14638__$1,opts){
return (function (val){
var statearr_14641_14647 = state;
(statearr_14641_14647[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__14638,map__14638__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_14642_14648 = state;
(statearr_14642_14648[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq14633){
var G__14634 = cljs.core.first.call(null,seq14633);
var seq14633__$1 = cljs.core.next.call(null,seq14633);
var G__14635 = cljs.core.first.call(null,seq14633__$1);
var seq14633__$2 = cljs.core.next.call(null,seq14633__$1);
var G__14636 = cljs.core.first.call(null,seq14633__$2);
var seq14633__$3 = cljs.core.next.call(null,seq14633__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__14634,G__14635,G__14636,seq14633__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async14814 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14814 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta14815){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta14815 = meta14815;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14814.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_14816,meta14815__$1){
var self__ = this;
var _14816__$1 = this;
return (new cljs.core.async.t_cljs$core$async14814(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta14815__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14814.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_14816){
var self__ = this;
var _14816__$1 = this;
return self__.meta14815;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14814.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async14814.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14814.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async14814.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14814.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14814.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14814.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14814.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14814.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta14815","meta14815",-1100571250,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async14814.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14814.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14814";

cljs.core.async.t_cljs$core$async14814.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async14814");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async14814 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async14814(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta14815){
return (new cljs.core.async.t_cljs$core$async14814(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta14815));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async14814(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13216__auto___14979 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___14979,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___14979,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_14916){
var state_val_14917 = (state_14916[(1)]);
if((state_val_14917 === (7))){
var inst_14832 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14918_14980 = state_14916__$1;
(statearr_14918_14980[(2)] = inst_14832);

(statearr_14918_14980[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (20))){
var inst_14844 = (state_14916[(7)]);
var state_14916__$1 = state_14916;
var statearr_14919_14981 = state_14916__$1;
(statearr_14919_14981[(2)] = inst_14844);

(statearr_14919_14981[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (27))){
var state_14916__$1 = state_14916;
var statearr_14920_14982 = state_14916__$1;
(statearr_14920_14982[(2)] = null);

(statearr_14920_14982[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (1))){
var inst_14820 = (state_14916[(8)]);
var inst_14820__$1 = calc_state.call(null);
var inst_14822 = (inst_14820__$1 == null);
var inst_14823 = cljs.core.not.call(null,inst_14822);
var state_14916__$1 = (function (){var statearr_14921 = state_14916;
(statearr_14921[(8)] = inst_14820__$1);

return statearr_14921;
})();
if(inst_14823){
var statearr_14922_14983 = state_14916__$1;
(statearr_14922_14983[(1)] = (2));

} else {
var statearr_14923_14984 = state_14916__$1;
(statearr_14923_14984[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (24))){
var inst_14867 = (state_14916[(9)]);
var inst_14890 = (state_14916[(10)]);
var inst_14876 = (state_14916[(11)]);
var inst_14890__$1 = inst_14867.call(null,inst_14876);
var state_14916__$1 = (function (){var statearr_14924 = state_14916;
(statearr_14924[(10)] = inst_14890__$1);

return statearr_14924;
})();
if(cljs.core.truth_(inst_14890__$1)){
var statearr_14925_14985 = state_14916__$1;
(statearr_14925_14985[(1)] = (29));

} else {
var statearr_14926_14986 = state_14916__$1;
(statearr_14926_14986[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (4))){
var inst_14835 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
if(cljs.core.truth_(inst_14835)){
var statearr_14927_14987 = state_14916__$1;
(statearr_14927_14987[(1)] = (8));

} else {
var statearr_14928_14988 = state_14916__$1;
(statearr_14928_14988[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (15))){
var inst_14861 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
if(cljs.core.truth_(inst_14861)){
var statearr_14929_14989 = state_14916__$1;
(statearr_14929_14989[(1)] = (19));

} else {
var statearr_14930_14990 = state_14916__$1;
(statearr_14930_14990[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (21))){
var inst_14866 = (state_14916[(12)]);
var inst_14866__$1 = (state_14916[(2)]);
var inst_14867 = cljs.core.get.call(null,inst_14866__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_14868 = cljs.core.get.call(null,inst_14866__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_14869 = cljs.core.get.call(null,inst_14866__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_14916__$1 = (function (){var statearr_14931 = state_14916;
(statearr_14931[(9)] = inst_14867);

(statearr_14931[(13)] = inst_14868);

(statearr_14931[(12)] = inst_14866__$1);

return statearr_14931;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_14916__$1,(22),inst_14869);
} else {
if((state_val_14917 === (31))){
var inst_14898 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
if(cljs.core.truth_(inst_14898)){
var statearr_14932_14991 = state_14916__$1;
(statearr_14932_14991[(1)] = (32));

} else {
var statearr_14933_14992 = state_14916__$1;
(statearr_14933_14992[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (32))){
var inst_14875 = (state_14916[(14)]);
var state_14916__$1 = state_14916;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14916__$1,(35),out,inst_14875);
} else {
if((state_val_14917 === (33))){
var inst_14866 = (state_14916[(12)]);
var inst_14844 = inst_14866;
var state_14916__$1 = (function (){var statearr_14934 = state_14916;
(statearr_14934[(7)] = inst_14844);

return statearr_14934;
})();
var statearr_14935_14993 = state_14916__$1;
(statearr_14935_14993[(2)] = null);

(statearr_14935_14993[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (13))){
var inst_14844 = (state_14916[(7)]);
var inst_14851 = inst_14844.cljs$lang$protocol_mask$partition0$;
var inst_14852 = (inst_14851 & (64));
var inst_14853 = inst_14844.cljs$core$ISeq$;
var inst_14854 = (inst_14852) || (inst_14853);
var state_14916__$1 = state_14916;
if(cljs.core.truth_(inst_14854)){
var statearr_14936_14994 = state_14916__$1;
(statearr_14936_14994[(1)] = (16));

} else {
var statearr_14937_14995 = state_14916__$1;
(statearr_14937_14995[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (22))){
var inst_14875 = (state_14916[(14)]);
var inst_14876 = (state_14916[(11)]);
var inst_14874 = (state_14916[(2)]);
var inst_14875__$1 = cljs.core.nth.call(null,inst_14874,(0),null);
var inst_14876__$1 = cljs.core.nth.call(null,inst_14874,(1),null);
var inst_14877 = (inst_14875__$1 == null);
var inst_14878 = cljs.core._EQ_.call(null,inst_14876__$1,change);
var inst_14879 = (inst_14877) || (inst_14878);
var state_14916__$1 = (function (){var statearr_14938 = state_14916;
(statearr_14938[(14)] = inst_14875__$1);

(statearr_14938[(11)] = inst_14876__$1);

return statearr_14938;
})();
if(cljs.core.truth_(inst_14879)){
var statearr_14939_14996 = state_14916__$1;
(statearr_14939_14996[(1)] = (23));

} else {
var statearr_14940_14997 = state_14916__$1;
(statearr_14940_14997[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (36))){
var inst_14866 = (state_14916[(12)]);
var inst_14844 = inst_14866;
var state_14916__$1 = (function (){var statearr_14941 = state_14916;
(statearr_14941[(7)] = inst_14844);

return statearr_14941;
})();
var statearr_14942_14998 = state_14916__$1;
(statearr_14942_14998[(2)] = null);

(statearr_14942_14998[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (29))){
var inst_14890 = (state_14916[(10)]);
var state_14916__$1 = state_14916;
var statearr_14943_14999 = state_14916__$1;
(statearr_14943_14999[(2)] = inst_14890);

(statearr_14943_14999[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (6))){
var state_14916__$1 = state_14916;
var statearr_14944_15000 = state_14916__$1;
(statearr_14944_15000[(2)] = false);

(statearr_14944_15000[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (28))){
var inst_14886 = (state_14916[(2)]);
var inst_14887 = calc_state.call(null);
var inst_14844 = inst_14887;
var state_14916__$1 = (function (){var statearr_14945 = state_14916;
(statearr_14945[(15)] = inst_14886);

(statearr_14945[(7)] = inst_14844);

return statearr_14945;
})();
var statearr_14946_15001 = state_14916__$1;
(statearr_14946_15001[(2)] = null);

(statearr_14946_15001[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (25))){
var inst_14912 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14947_15002 = state_14916__$1;
(statearr_14947_15002[(2)] = inst_14912);

(statearr_14947_15002[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (34))){
var inst_14910 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14948_15003 = state_14916__$1;
(statearr_14948_15003[(2)] = inst_14910);

(statearr_14948_15003[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (17))){
var state_14916__$1 = state_14916;
var statearr_14949_15004 = state_14916__$1;
(statearr_14949_15004[(2)] = false);

(statearr_14949_15004[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (3))){
var state_14916__$1 = state_14916;
var statearr_14950_15005 = state_14916__$1;
(statearr_14950_15005[(2)] = false);

(statearr_14950_15005[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (12))){
var inst_14914 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14916__$1,inst_14914);
} else {
if((state_val_14917 === (2))){
var inst_14820 = (state_14916[(8)]);
var inst_14825 = inst_14820.cljs$lang$protocol_mask$partition0$;
var inst_14826 = (inst_14825 & (64));
var inst_14827 = inst_14820.cljs$core$ISeq$;
var inst_14828 = (inst_14826) || (inst_14827);
var state_14916__$1 = state_14916;
if(cljs.core.truth_(inst_14828)){
var statearr_14951_15006 = state_14916__$1;
(statearr_14951_15006[(1)] = (5));

} else {
var statearr_14952_15007 = state_14916__$1;
(statearr_14952_15007[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (23))){
var inst_14875 = (state_14916[(14)]);
var inst_14881 = (inst_14875 == null);
var state_14916__$1 = state_14916;
if(cljs.core.truth_(inst_14881)){
var statearr_14953_15008 = state_14916__$1;
(statearr_14953_15008[(1)] = (26));

} else {
var statearr_14954_15009 = state_14916__$1;
(statearr_14954_15009[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (35))){
var inst_14901 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
if(cljs.core.truth_(inst_14901)){
var statearr_14955_15010 = state_14916__$1;
(statearr_14955_15010[(1)] = (36));

} else {
var statearr_14956_15011 = state_14916__$1;
(statearr_14956_15011[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (19))){
var inst_14844 = (state_14916[(7)]);
var inst_14863 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14844);
var state_14916__$1 = state_14916;
var statearr_14957_15012 = state_14916__$1;
(statearr_14957_15012[(2)] = inst_14863);

(statearr_14957_15012[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (11))){
var inst_14844 = (state_14916[(7)]);
var inst_14848 = (inst_14844 == null);
var inst_14849 = cljs.core.not.call(null,inst_14848);
var state_14916__$1 = state_14916;
if(inst_14849){
var statearr_14958_15013 = state_14916__$1;
(statearr_14958_15013[(1)] = (13));

} else {
var statearr_14959_15014 = state_14916__$1;
(statearr_14959_15014[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (9))){
var inst_14820 = (state_14916[(8)]);
var state_14916__$1 = state_14916;
var statearr_14960_15015 = state_14916__$1;
(statearr_14960_15015[(2)] = inst_14820);

(statearr_14960_15015[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (5))){
var state_14916__$1 = state_14916;
var statearr_14961_15016 = state_14916__$1;
(statearr_14961_15016[(2)] = true);

(statearr_14961_15016[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (14))){
var state_14916__$1 = state_14916;
var statearr_14962_15017 = state_14916__$1;
(statearr_14962_15017[(2)] = false);

(statearr_14962_15017[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (26))){
var inst_14876 = (state_14916[(11)]);
var inst_14883 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_14876);
var state_14916__$1 = state_14916;
var statearr_14963_15018 = state_14916__$1;
(statearr_14963_15018[(2)] = inst_14883);

(statearr_14963_15018[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (16))){
var state_14916__$1 = state_14916;
var statearr_14964_15019 = state_14916__$1;
(statearr_14964_15019[(2)] = true);

(statearr_14964_15019[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (38))){
var inst_14906 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14965_15020 = state_14916__$1;
(statearr_14965_15020[(2)] = inst_14906);

(statearr_14965_15020[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (30))){
var inst_14867 = (state_14916[(9)]);
var inst_14868 = (state_14916[(13)]);
var inst_14876 = (state_14916[(11)]);
var inst_14893 = cljs.core.empty_QMARK_.call(null,inst_14867);
var inst_14894 = inst_14868.call(null,inst_14876);
var inst_14895 = cljs.core.not.call(null,inst_14894);
var inst_14896 = (inst_14893) && (inst_14895);
var state_14916__$1 = state_14916;
var statearr_14966_15021 = state_14916__$1;
(statearr_14966_15021[(2)] = inst_14896);

(statearr_14966_15021[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (10))){
var inst_14820 = (state_14916[(8)]);
var inst_14840 = (state_14916[(2)]);
var inst_14841 = cljs.core.get.call(null,inst_14840,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_14842 = cljs.core.get.call(null,inst_14840,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_14843 = cljs.core.get.call(null,inst_14840,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_14844 = inst_14820;
var state_14916__$1 = (function (){var statearr_14967 = state_14916;
(statearr_14967[(7)] = inst_14844);

(statearr_14967[(16)] = inst_14843);

(statearr_14967[(17)] = inst_14841);

(statearr_14967[(18)] = inst_14842);

return statearr_14967;
})();
var statearr_14968_15022 = state_14916__$1;
(statearr_14968_15022[(2)] = null);

(statearr_14968_15022[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (18))){
var inst_14858 = (state_14916[(2)]);
var state_14916__$1 = state_14916;
var statearr_14969_15023 = state_14916__$1;
(statearr_14969_15023[(2)] = inst_14858);

(statearr_14969_15023[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (37))){
var state_14916__$1 = state_14916;
var statearr_14970_15024 = state_14916__$1;
(statearr_14970_15024[(2)] = null);

(statearr_14970_15024[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14917 === (8))){
var inst_14820 = (state_14916[(8)]);
var inst_14837 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14820);
var state_14916__$1 = state_14916;
var statearr_14971_15025 = state_14916__$1;
(statearr_14971_15025[(2)] = inst_14837);

(statearr_14971_15025[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___14979,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__13104__auto__,c__13216__auto___14979,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__13105__auto__ = null;
var cljs$core$async$mix_$_state_machine__13105__auto____0 = (function (){
var statearr_14975 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14975[(0)] = cljs$core$async$mix_$_state_machine__13105__auto__);

(statearr_14975[(1)] = (1));

return statearr_14975;
});
var cljs$core$async$mix_$_state_machine__13105__auto____1 = (function (state_14916){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_14916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e14976){if((e14976 instanceof Object)){
var ex__13108__auto__ = e14976;
var statearr_14977_15026 = state_14916;
(statearr_14977_15026[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14916);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14976;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15027 = state_14916;
state_14916 = G__15027;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__13105__auto__ = function(state_14916){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__13105__auto____1.call(this,state_14916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__13105__auto____0;
cljs$core$async$mix_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__13105__auto____1;
return cljs$core$async$mix_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___14979,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__13218__auto__ = (function (){var statearr_14978 = f__13217__auto__.call(null);
(statearr_14978[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___14979);

return statearr_14978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___14979,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v,ch);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args15028 = [];
var len__7484__auto___15031 = arguments.length;
var i__7485__auto___15032 = (0);
while(true){
if((i__7485__auto___15032 < len__7484__auto___15031)){
args15028.push((arguments[i__7485__auto___15032]));

var G__15033 = (i__7485__auto___15032 + (1));
i__7485__auto___15032 = G__15033;
continue;
} else {
}
break;
}

var G__15030 = args15028.length;
switch (G__15030) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15028.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,p,v);
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args15036 = [];
var len__7484__auto___15161 = arguments.length;
var i__7485__auto___15162 = (0);
while(true){
if((i__7485__auto___15162 < len__7484__auto___15161)){
args15036.push((arguments[i__7485__auto___15162]));

var G__15163 = (i__7485__auto___15162 + (1));
i__7485__auto___15162 = G__15163;
continue;
} else {
}
break;
}

var G__15038 = args15036.length;
switch (G__15038) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15036.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6409__auto__,mults){
return (function (p1__15035_SHARP_){
if(cljs.core.truth_(p1__15035_SHARP_.call(null,topic))){
return p1__15035_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__15035_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async15039 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15039 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta15040){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta15040 = meta15040;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15039.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_15041,meta15040__$1){
var self__ = this;
var _15041__$1 = this;
return (new cljs.core.async.t_cljs$core$async15039(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta15040__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15039.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_15041){
var self__ = this;
var _15041__$1 = this;
return self__.meta15040;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15039.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async15039.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15039.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async15039.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15039.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15039.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15039.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15039.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta15040","meta15040",-1586635989,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async15039.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15039.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15039";

cljs.core.async.t_cljs$core$async15039.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async15039");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async15039 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async15039(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15040){
return (new cljs.core.async.t_cljs$core$async15039(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15040));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async15039(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13216__auto___15165 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___15165,mults,ensure_mult,p){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___15165,mults,ensure_mult,p){
return (function (state_15113){
var state_val_15114 = (state_15113[(1)]);
if((state_val_15114 === (7))){
var inst_15109 = (state_15113[(2)]);
var state_15113__$1 = state_15113;
var statearr_15115_15166 = state_15113__$1;
(statearr_15115_15166[(2)] = inst_15109);

(statearr_15115_15166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (20))){
var state_15113__$1 = state_15113;
var statearr_15116_15167 = state_15113__$1;
(statearr_15116_15167[(2)] = null);

(statearr_15116_15167[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (1))){
var state_15113__$1 = state_15113;
var statearr_15117_15168 = state_15113__$1;
(statearr_15117_15168[(2)] = null);

(statearr_15117_15168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (24))){
var inst_15092 = (state_15113[(7)]);
var inst_15101 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_15092);
var state_15113__$1 = state_15113;
var statearr_15118_15169 = state_15113__$1;
(statearr_15118_15169[(2)] = inst_15101);

(statearr_15118_15169[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (4))){
var inst_15044 = (state_15113[(8)]);
var inst_15044__$1 = (state_15113[(2)]);
var inst_15045 = (inst_15044__$1 == null);
var state_15113__$1 = (function (){var statearr_15119 = state_15113;
(statearr_15119[(8)] = inst_15044__$1);

return statearr_15119;
})();
if(cljs.core.truth_(inst_15045)){
var statearr_15120_15170 = state_15113__$1;
(statearr_15120_15170[(1)] = (5));

} else {
var statearr_15121_15171 = state_15113__$1;
(statearr_15121_15171[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (15))){
var inst_15086 = (state_15113[(2)]);
var state_15113__$1 = state_15113;
var statearr_15122_15172 = state_15113__$1;
(statearr_15122_15172[(2)] = inst_15086);

(statearr_15122_15172[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (21))){
var inst_15106 = (state_15113[(2)]);
var state_15113__$1 = (function (){var statearr_15123 = state_15113;
(statearr_15123[(9)] = inst_15106);

return statearr_15123;
})();
var statearr_15124_15173 = state_15113__$1;
(statearr_15124_15173[(2)] = null);

(statearr_15124_15173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (13))){
var inst_15068 = (state_15113[(10)]);
var inst_15070 = cljs.core.chunked_seq_QMARK_.call(null,inst_15068);
var state_15113__$1 = state_15113;
if(inst_15070){
var statearr_15125_15174 = state_15113__$1;
(statearr_15125_15174[(1)] = (16));

} else {
var statearr_15126_15175 = state_15113__$1;
(statearr_15126_15175[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (22))){
var inst_15098 = (state_15113[(2)]);
var state_15113__$1 = state_15113;
if(cljs.core.truth_(inst_15098)){
var statearr_15127_15176 = state_15113__$1;
(statearr_15127_15176[(1)] = (23));

} else {
var statearr_15128_15177 = state_15113__$1;
(statearr_15128_15177[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (6))){
var inst_15092 = (state_15113[(7)]);
var inst_15044 = (state_15113[(8)]);
var inst_15094 = (state_15113[(11)]);
var inst_15092__$1 = topic_fn.call(null,inst_15044);
var inst_15093 = cljs.core.deref.call(null,mults);
var inst_15094__$1 = cljs.core.get.call(null,inst_15093,inst_15092__$1);
var state_15113__$1 = (function (){var statearr_15129 = state_15113;
(statearr_15129[(7)] = inst_15092__$1);

(statearr_15129[(11)] = inst_15094__$1);

return statearr_15129;
})();
if(cljs.core.truth_(inst_15094__$1)){
var statearr_15130_15178 = state_15113__$1;
(statearr_15130_15178[(1)] = (19));

} else {
var statearr_15131_15179 = state_15113__$1;
(statearr_15131_15179[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (25))){
var inst_15103 = (state_15113[(2)]);
var state_15113__$1 = state_15113;
var statearr_15132_15180 = state_15113__$1;
(statearr_15132_15180[(2)] = inst_15103);

(statearr_15132_15180[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (17))){
var inst_15068 = (state_15113[(10)]);
var inst_15077 = cljs.core.first.call(null,inst_15068);
var inst_15078 = cljs.core.async.muxch_STAR_.call(null,inst_15077);
var inst_15079 = cljs.core.async.close_BANG_.call(null,inst_15078);
var inst_15080 = cljs.core.next.call(null,inst_15068);
var inst_15054 = inst_15080;
var inst_15055 = null;
var inst_15056 = (0);
var inst_15057 = (0);
var state_15113__$1 = (function (){var statearr_15133 = state_15113;
(statearr_15133[(12)] = inst_15079);

(statearr_15133[(13)] = inst_15054);

(statearr_15133[(14)] = inst_15057);

(statearr_15133[(15)] = inst_15056);

(statearr_15133[(16)] = inst_15055);

return statearr_15133;
})();
var statearr_15134_15181 = state_15113__$1;
(statearr_15134_15181[(2)] = null);

(statearr_15134_15181[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (3))){
var inst_15111 = (state_15113[(2)]);
var state_15113__$1 = state_15113;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15113__$1,inst_15111);
} else {
if((state_val_15114 === (12))){
var inst_15088 = (state_15113[(2)]);
var state_15113__$1 = state_15113;
var statearr_15135_15182 = state_15113__$1;
(statearr_15135_15182[(2)] = inst_15088);

(statearr_15135_15182[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (2))){
var state_15113__$1 = state_15113;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15113__$1,(4),ch);
} else {
if((state_val_15114 === (23))){
var state_15113__$1 = state_15113;
var statearr_15136_15183 = state_15113__$1;
(statearr_15136_15183[(2)] = null);

(statearr_15136_15183[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (19))){
var inst_15044 = (state_15113[(8)]);
var inst_15094 = (state_15113[(11)]);
var inst_15096 = cljs.core.async.muxch_STAR_.call(null,inst_15094);
var state_15113__$1 = state_15113;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15113__$1,(22),inst_15096,inst_15044);
} else {
if((state_val_15114 === (11))){
var inst_15068 = (state_15113[(10)]);
var inst_15054 = (state_15113[(13)]);
var inst_15068__$1 = cljs.core.seq.call(null,inst_15054);
var state_15113__$1 = (function (){var statearr_15137 = state_15113;
(statearr_15137[(10)] = inst_15068__$1);

return statearr_15137;
})();
if(inst_15068__$1){
var statearr_15138_15184 = state_15113__$1;
(statearr_15138_15184[(1)] = (13));

} else {
var statearr_15139_15185 = state_15113__$1;
(statearr_15139_15185[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (9))){
var inst_15090 = (state_15113[(2)]);
var state_15113__$1 = state_15113;
var statearr_15140_15186 = state_15113__$1;
(statearr_15140_15186[(2)] = inst_15090);

(statearr_15140_15186[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (5))){
var inst_15051 = cljs.core.deref.call(null,mults);
var inst_15052 = cljs.core.vals.call(null,inst_15051);
var inst_15053 = cljs.core.seq.call(null,inst_15052);
var inst_15054 = inst_15053;
var inst_15055 = null;
var inst_15056 = (0);
var inst_15057 = (0);
var state_15113__$1 = (function (){var statearr_15141 = state_15113;
(statearr_15141[(13)] = inst_15054);

(statearr_15141[(14)] = inst_15057);

(statearr_15141[(15)] = inst_15056);

(statearr_15141[(16)] = inst_15055);

return statearr_15141;
})();
var statearr_15142_15187 = state_15113__$1;
(statearr_15142_15187[(2)] = null);

(statearr_15142_15187[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (14))){
var state_15113__$1 = state_15113;
var statearr_15146_15188 = state_15113__$1;
(statearr_15146_15188[(2)] = null);

(statearr_15146_15188[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (16))){
var inst_15068 = (state_15113[(10)]);
var inst_15072 = cljs.core.chunk_first.call(null,inst_15068);
var inst_15073 = cljs.core.chunk_rest.call(null,inst_15068);
var inst_15074 = cljs.core.count.call(null,inst_15072);
var inst_15054 = inst_15073;
var inst_15055 = inst_15072;
var inst_15056 = inst_15074;
var inst_15057 = (0);
var state_15113__$1 = (function (){var statearr_15147 = state_15113;
(statearr_15147[(13)] = inst_15054);

(statearr_15147[(14)] = inst_15057);

(statearr_15147[(15)] = inst_15056);

(statearr_15147[(16)] = inst_15055);

return statearr_15147;
})();
var statearr_15148_15189 = state_15113__$1;
(statearr_15148_15189[(2)] = null);

(statearr_15148_15189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (10))){
var inst_15054 = (state_15113[(13)]);
var inst_15057 = (state_15113[(14)]);
var inst_15056 = (state_15113[(15)]);
var inst_15055 = (state_15113[(16)]);
var inst_15062 = cljs.core._nth.call(null,inst_15055,inst_15057);
var inst_15063 = cljs.core.async.muxch_STAR_.call(null,inst_15062);
var inst_15064 = cljs.core.async.close_BANG_.call(null,inst_15063);
var inst_15065 = (inst_15057 + (1));
var tmp15143 = inst_15054;
var tmp15144 = inst_15056;
var tmp15145 = inst_15055;
var inst_15054__$1 = tmp15143;
var inst_15055__$1 = tmp15145;
var inst_15056__$1 = tmp15144;
var inst_15057__$1 = inst_15065;
var state_15113__$1 = (function (){var statearr_15149 = state_15113;
(statearr_15149[(17)] = inst_15064);

(statearr_15149[(13)] = inst_15054__$1);

(statearr_15149[(14)] = inst_15057__$1);

(statearr_15149[(15)] = inst_15056__$1);

(statearr_15149[(16)] = inst_15055__$1);

return statearr_15149;
})();
var statearr_15150_15190 = state_15113__$1;
(statearr_15150_15190[(2)] = null);

(statearr_15150_15190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (18))){
var inst_15083 = (state_15113[(2)]);
var state_15113__$1 = state_15113;
var statearr_15151_15191 = state_15113__$1;
(statearr_15151_15191[(2)] = inst_15083);

(statearr_15151_15191[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15114 === (8))){
var inst_15057 = (state_15113[(14)]);
var inst_15056 = (state_15113[(15)]);
var inst_15059 = (inst_15057 < inst_15056);
var inst_15060 = inst_15059;
var state_15113__$1 = state_15113;
if(cljs.core.truth_(inst_15060)){
var statearr_15152_15192 = state_15113__$1;
(statearr_15152_15192[(1)] = (10));

} else {
var statearr_15153_15193 = state_15113__$1;
(statearr_15153_15193[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___15165,mults,ensure_mult,p))
;
return ((function (switch__13104__auto__,c__13216__auto___15165,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_15157 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15157[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_15157[(1)] = (1));

return statearr_15157;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_15113){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_15113);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e15158){if((e15158 instanceof Object)){
var ex__13108__auto__ = e15158;
var statearr_15159_15194 = state_15113;
(statearr_15159_15194[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15113);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15158;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15195 = state_15113;
state_15113 = G__15195;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_15113){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_15113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___15165,mults,ensure_mult,p))
})();
var state__13218__auto__ = (function (){var statearr_15160 = f__13217__auto__.call(null);
(statearr_15160[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___15165);

return statearr_15160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___15165,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args15196 = [];
var len__7484__auto___15199 = arguments.length;
var i__7485__auto___15200 = (0);
while(true){
if((i__7485__auto___15200 < len__7484__auto___15199)){
args15196.push((arguments[i__7485__auto___15200]));

var G__15201 = (i__7485__auto___15200 + (1));
i__7485__auto___15200 = G__15201;
continue;
} else {
}
break;
}

var G__15198 = args15196.length;
switch (G__15198) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15196.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args15203 = [];
var len__7484__auto___15206 = arguments.length;
var i__7485__auto___15207 = (0);
while(true){
if((i__7485__auto___15207 < len__7484__auto___15206)){
args15203.push((arguments[i__7485__auto___15207]));

var G__15208 = (i__7485__auto___15207 + (1));
i__7485__auto___15207 = G__15208;
continue;
} else {
}
break;
}

var G__15205 = args15203.length;
switch (G__15205) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15203.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args15210 = [];
var len__7484__auto___15281 = arguments.length;
var i__7485__auto___15282 = (0);
while(true){
if((i__7485__auto___15282 < len__7484__auto___15281)){
args15210.push((arguments[i__7485__auto___15282]));

var G__15283 = (i__7485__auto___15282 + (1));
i__7485__auto___15282 = G__15283;
continue;
} else {
}
break;
}

var G__15212 = args15210.length;
switch (G__15212) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15210.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__13216__auto___15285 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___15285,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___15285,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_15251){
var state_val_15252 = (state_15251[(1)]);
if((state_val_15252 === (7))){
var state_15251__$1 = state_15251;
var statearr_15253_15286 = state_15251__$1;
(statearr_15253_15286[(2)] = null);

(statearr_15253_15286[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (1))){
var state_15251__$1 = state_15251;
var statearr_15254_15287 = state_15251__$1;
(statearr_15254_15287[(2)] = null);

(statearr_15254_15287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (4))){
var inst_15215 = (state_15251[(7)]);
var inst_15217 = (inst_15215 < cnt);
var state_15251__$1 = state_15251;
if(cljs.core.truth_(inst_15217)){
var statearr_15255_15288 = state_15251__$1;
(statearr_15255_15288[(1)] = (6));

} else {
var statearr_15256_15289 = state_15251__$1;
(statearr_15256_15289[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (15))){
var inst_15247 = (state_15251[(2)]);
var state_15251__$1 = state_15251;
var statearr_15257_15290 = state_15251__$1;
(statearr_15257_15290[(2)] = inst_15247);

(statearr_15257_15290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (13))){
var inst_15240 = cljs.core.async.close_BANG_.call(null,out);
var state_15251__$1 = state_15251;
var statearr_15258_15291 = state_15251__$1;
(statearr_15258_15291[(2)] = inst_15240);

(statearr_15258_15291[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (6))){
var state_15251__$1 = state_15251;
var statearr_15259_15292 = state_15251__$1;
(statearr_15259_15292[(2)] = null);

(statearr_15259_15292[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (3))){
var inst_15249 = (state_15251[(2)]);
var state_15251__$1 = state_15251;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15251__$1,inst_15249);
} else {
if((state_val_15252 === (12))){
var inst_15237 = (state_15251[(8)]);
var inst_15237__$1 = (state_15251[(2)]);
var inst_15238 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_15237__$1);
var state_15251__$1 = (function (){var statearr_15260 = state_15251;
(statearr_15260[(8)] = inst_15237__$1);

return statearr_15260;
})();
if(cljs.core.truth_(inst_15238)){
var statearr_15261_15293 = state_15251__$1;
(statearr_15261_15293[(1)] = (13));

} else {
var statearr_15262_15294 = state_15251__$1;
(statearr_15262_15294[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (2))){
var inst_15214 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_15215 = (0);
var state_15251__$1 = (function (){var statearr_15263 = state_15251;
(statearr_15263[(7)] = inst_15215);

(statearr_15263[(9)] = inst_15214);

return statearr_15263;
})();
var statearr_15264_15295 = state_15251__$1;
(statearr_15264_15295[(2)] = null);

(statearr_15264_15295[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (11))){
var inst_15215 = (state_15251[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_15251,(10),Object,null,(9));
var inst_15224 = chs__$1.call(null,inst_15215);
var inst_15225 = done.call(null,inst_15215);
var inst_15226 = cljs.core.async.take_BANG_.call(null,inst_15224,inst_15225);
var state_15251__$1 = state_15251;
var statearr_15265_15296 = state_15251__$1;
(statearr_15265_15296[(2)] = inst_15226);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15251__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (9))){
var inst_15215 = (state_15251[(7)]);
var inst_15228 = (state_15251[(2)]);
var inst_15229 = (inst_15215 + (1));
var inst_15215__$1 = inst_15229;
var state_15251__$1 = (function (){var statearr_15266 = state_15251;
(statearr_15266[(7)] = inst_15215__$1);

(statearr_15266[(10)] = inst_15228);

return statearr_15266;
})();
var statearr_15267_15297 = state_15251__$1;
(statearr_15267_15297[(2)] = null);

(statearr_15267_15297[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (5))){
var inst_15235 = (state_15251[(2)]);
var state_15251__$1 = (function (){var statearr_15268 = state_15251;
(statearr_15268[(11)] = inst_15235);

return statearr_15268;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15251__$1,(12),dchan);
} else {
if((state_val_15252 === (14))){
var inst_15237 = (state_15251[(8)]);
var inst_15242 = cljs.core.apply.call(null,f,inst_15237);
var state_15251__$1 = state_15251;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15251__$1,(16),out,inst_15242);
} else {
if((state_val_15252 === (16))){
var inst_15244 = (state_15251[(2)]);
var state_15251__$1 = (function (){var statearr_15269 = state_15251;
(statearr_15269[(12)] = inst_15244);

return statearr_15269;
})();
var statearr_15270_15298 = state_15251__$1;
(statearr_15270_15298[(2)] = null);

(statearr_15270_15298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (10))){
var inst_15219 = (state_15251[(2)]);
var inst_15220 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_15251__$1 = (function (){var statearr_15271 = state_15251;
(statearr_15271[(13)] = inst_15219);

return statearr_15271;
})();
var statearr_15272_15299 = state_15251__$1;
(statearr_15272_15299[(2)] = inst_15220);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15251__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15252 === (8))){
var inst_15233 = (state_15251[(2)]);
var state_15251__$1 = state_15251;
var statearr_15273_15300 = state_15251__$1;
(statearr_15273_15300[(2)] = inst_15233);

(statearr_15273_15300[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___15285,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__13104__auto__,c__13216__auto___15285,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_15277 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15277[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_15277[(1)] = (1));

return statearr_15277;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_15251){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_15251);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e15278){if((e15278 instanceof Object)){
var ex__13108__auto__ = e15278;
var statearr_15279_15301 = state_15251;
(statearr_15279_15301[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15251);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15278;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15302 = state_15251;
state_15251 = G__15302;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_15251){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_15251);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___15285,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__13218__auto__ = (function (){var statearr_15280 = f__13217__auto__.call(null);
(statearr_15280[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___15285);

return statearr_15280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___15285,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args15304 = [];
var len__7484__auto___15362 = arguments.length;
var i__7485__auto___15363 = (0);
while(true){
if((i__7485__auto___15363 < len__7484__auto___15362)){
args15304.push((arguments[i__7485__auto___15363]));

var G__15364 = (i__7485__auto___15363 + (1));
i__7485__auto___15363 = G__15364;
continue;
} else {
}
break;
}

var G__15306 = args15304.length;
switch (G__15306) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15304.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13216__auto___15366 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___15366,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___15366,out){
return (function (state_15338){
var state_val_15339 = (state_15338[(1)]);
if((state_val_15339 === (7))){
var inst_15318 = (state_15338[(7)]);
var inst_15317 = (state_15338[(8)]);
var inst_15317__$1 = (state_15338[(2)]);
var inst_15318__$1 = cljs.core.nth.call(null,inst_15317__$1,(0),null);
var inst_15319 = cljs.core.nth.call(null,inst_15317__$1,(1),null);
var inst_15320 = (inst_15318__$1 == null);
var state_15338__$1 = (function (){var statearr_15340 = state_15338;
(statearr_15340[(9)] = inst_15319);

(statearr_15340[(7)] = inst_15318__$1);

(statearr_15340[(8)] = inst_15317__$1);

return statearr_15340;
})();
if(cljs.core.truth_(inst_15320)){
var statearr_15341_15367 = state_15338__$1;
(statearr_15341_15367[(1)] = (8));

} else {
var statearr_15342_15368 = state_15338__$1;
(statearr_15342_15368[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15339 === (1))){
var inst_15307 = cljs.core.vec.call(null,chs);
var inst_15308 = inst_15307;
var state_15338__$1 = (function (){var statearr_15343 = state_15338;
(statearr_15343[(10)] = inst_15308);

return statearr_15343;
})();
var statearr_15344_15369 = state_15338__$1;
(statearr_15344_15369[(2)] = null);

(statearr_15344_15369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15339 === (4))){
var inst_15308 = (state_15338[(10)]);
var state_15338__$1 = state_15338;
return cljs.core.async.ioc_alts_BANG_.call(null,state_15338__$1,(7),inst_15308);
} else {
if((state_val_15339 === (6))){
var inst_15334 = (state_15338[(2)]);
var state_15338__$1 = state_15338;
var statearr_15345_15370 = state_15338__$1;
(statearr_15345_15370[(2)] = inst_15334);

(statearr_15345_15370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15339 === (3))){
var inst_15336 = (state_15338[(2)]);
var state_15338__$1 = state_15338;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15338__$1,inst_15336);
} else {
if((state_val_15339 === (2))){
var inst_15308 = (state_15338[(10)]);
var inst_15310 = cljs.core.count.call(null,inst_15308);
var inst_15311 = (inst_15310 > (0));
var state_15338__$1 = state_15338;
if(cljs.core.truth_(inst_15311)){
var statearr_15347_15371 = state_15338__$1;
(statearr_15347_15371[(1)] = (4));

} else {
var statearr_15348_15372 = state_15338__$1;
(statearr_15348_15372[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15339 === (11))){
var inst_15308 = (state_15338[(10)]);
var inst_15327 = (state_15338[(2)]);
var tmp15346 = inst_15308;
var inst_15308__$1 = tmp15346;
var state_15338__$1 = (function (){var statearr_15349 = state_15338;
(statearr_15349[(10)] = inst_15308__$1);

(statearr_15349[(11)] = inst_15327);

return statearr_15349;
})();
var statearr_15350_15373 = state_15338__$1;
(statearr_15350_15373[(2)] = null);

(statearr_15350_15373[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15339 === (9))){
var inst_15318 = (state_15338[(7)]);
var state_15338__$1 = state_15338;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15338__$1,(11),out,inst_15318);
} else {
if((state_val_15339 === (5))){
var inst_15332 = cljs.core.async.close_BANG_.call(null,out);
var state_15338__$1 = state_15338;
var statearr_15351_15374 = state_15338__$1;
(statearr_15351_15374[(2)] = inst_15332);

(statearr_15351_15374[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15339 === (10))){
var inst_15330 = (state_15338[(2)]);
var state_15338__$1 = state_15338;
var statearr_15352_15375 = state_15338__$1;
(statearr_15352_15375[(2)] = inst_15330);

(statearr_15352_15375[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15339 === (8))){
var inst_15308 = (state_15338[(10)]);
var inst_15319 = (state_15338[(9)]);
var inst_15318 = (state_15338[(7)]);
var inst_15317 = (state_15338[(8)]);
var inst_15322 = (function (){var cs = inst_15308;
var vec__15313 = inst_15317;
var v = inst_15318;
var c = inst_15319;
return ((function (cs,vec__15313,v,c,inst_15308,inst_15319,inst_15318,inst_15317,state_val_15339,c__13216__auto___15366,out){
return (function (p1__15303_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__15303_SHARP_);
});
;})(cs,vec__15313,v,c,inst_15308,inst_15319,inst_15318,inst_15317,state_val_15339,c__13216__auto___15366,out))
})();
var inst_15323 = cljs.core.filterv.call(null,inst_15322,inst_15308);
var inst_15308__$1 = inst_15323;
var state_15338__$1 = (function (){var statearr_15353 = state_15338;
(statearr_15353[(10)] = inst_15308__$1);

return statearr_15353;
})();
var statearr_15354_15376 = state_15338__$1;
(statearr_15354_15376[(2)] = null);

(statearr_15354_15376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___15366,out))
;
return ((function (switch__13104__auto__,c__13216__auto___15366,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_15358 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15358[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_15358[(1)] = (1));

return statearr_15358;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_15338){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_15338);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e15359){if((e15359 instanceof Object)){
var ex__13108__auto__ = e15359;
var statearr_15360_15377 = state_15338;
(statearr_15360_15377[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15338);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15359;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15378 = state_15338;
state_15338 = G__15378;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_15338){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_15338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___15366,out))
})();
var state__13218__auto__ = (function (){var statearr_15361 = f__13217__auto__.call(null);
(statearr_15361[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___15366);

return statearr_15361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___15366,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args15379 = [];
var len__7484__auto___15428 = arguments.length;
var i__7485__auto___15429 = (0);
while(true){
if((i__7485__auto___15429 < len__7484__auto___15428)){
args15379.push((arguments[i__7485__auto___15429]));

var G__15430 = (i__7485__auto___15429 + (1));
i__7485__auto___15429 = G__15430;
continue;
} else {
}
break;
}

var G__15381 = args15379.length;
switch (G__15381) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15379.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13216__auto___15432 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___15432,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___15432,out){
return (function (state_15405){
var state_val_15406 = (state_15405[(1)]);
if((state_val_15406 === (7))){
var inst_15387 = (state_15405[(7)]);
var inst_15387__$1 = (state_15405[(2)]);
var inst_15388 = (inst_15387__$1 == null);
var inst_15389 = cljs.core.not.call(null,inst_15388);
var state_15405__$1 = (function (){var statearr_15407 = state_15405;
(statearr_15407[(7)] = inst_15387__$1);

return statearr_15407;
})();
if(inst_15389){
var statearr_15408_15433 = state_15405__$1;
(statearr_15408_15433[(1)] = (8));

} else {
var statearr_15409_15434 = state_15405__$1;
(statearr_15409_15434[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (1))){
var inst_15382 = (0);
var state_15405__$1 = (function (){var statearr_15410 = state_15405;
(statearr_15410[(8)] = inst_15382);

return statearr_15410;
})();
var statearr_15411_15435 = state_15405__$1;
(statearr_15411_15435[(2)] = null);

(statearr_15411_15435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (4))){
var state_15405__$1 = state_15405;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15405__$1,(7),ch);
} else {
if((state_val_15406 === (6))){
var inst_15400 = (state_15405[(2)]);
var state_15405__$1 = state_15405;
var statearr_15412_15436 = state_15405__$1;
(statearr_15412_15436[(2)] = inst_15400);

(statearr_15412_15436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (3))){
var inst_15402 = (state_15405[(2)]);
var inst_15403 = cljs.core.async.close_BANG_.call(null,out);
var state_15405__$1 = (function (){var statearr_15413 = state_15405;
(statearr_15413[(9)] = inst_15402);

return statearr_15413;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15405__$1,inst_15403);
} else {
if((state_val_15406 === (2))){
var inst_15382 = (state_15405[(8)]);
var inst_15384 = (inst_15382 < n);
var state_15405__$1 = state_15405;
if(cljs.core.truth_(inst_15384)){
var statearr_15414_15437 = state_15405__$1;
(statearr_15414_15437[(1)] = (4));

} else {
var statearr_15415_15438 = state_15405__$1;
(statearr_15415_15438[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (11))){
var inst_15382 = (state_15405[(8)]);
var inst_15392 = (state_15405[(2)]);
var inst_15393 = (inst_15382 + (1));
var inst_15382__$1 = inst_15393;
var state_15405__$1 = (function (){var statearr_15416 = state_15405;
(statearr_15416[(10)] = inst_15392);

(statearr_15416[(8)] = inst_15382__$1);

return statearr_15416;
})();
var statearr_15417_15439 = state_15405__$1;
(statearr_15417_15439[(2)] = null);

(statearr_15417_15439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (9))){
var state_15405__$1 = state_15405;
var statearr_15418_15440 = state_15405__$1;
(statearr_15418_15440[(2)] = null);

(statearr_15418_15440[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (5))){
var state_15405__$1 = state_15405;
var statearr_15419_15441 = state_15405__$1;
(statearr_15419_15441[(2)] = null);

(statearr_15419_15441[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (10))){
var inst_15397 = (state_15405[(2)]);
var state_15405__$1 = state_15405;
var statearr_15420_15442 = state_15405__$1;
(statearr_15420_15442[(2)] = inst_15397);

(statearr_15420_15442[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15406 === (8))){
var inst_15387 = (state_15405[(7)]);
var state_15405__$1 = state_15405;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15405__$1,(11),out,inst_15387);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___15432,out))
;
return ((function (switch__13104__auto__,c__13216__auto___15432,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_15424 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15424[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_15424[(1)] = (1));

return statearr_15424;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_15405){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_15405);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e15425){if((e15425 instanceof Object)){
var ex__13108__auto__ = e15425;
var statearr_15426_15443 = state_15405;
(statearr_15426_15443[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15405);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15425;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15444 = state_15405;
state_15405 = G__15444;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_15405){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_15405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___15432,out))
})();
var state__13218__auto__ = (function (){var statearr_15427 = f__13217__auto__.call(null);
(statearr_15427[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___15432);

return statearr_15427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___15432,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async15452 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15452 = (function (map_LT_,f,ch,meta15453){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta15453 = meta15453;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15452.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15454,meta15453__$1){
var self__ = this;
var _15454__$1 = this;
return (new cljs.core.async.t_cljs$core$async15452(self__.map_LT_,self__.f,self__.ch,meta15453__$1));
});

cljs.core.async.t_cljs$core$async15452.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15454){
var self__ = this;
var _15454__$1 = this;
return self__.meta15453;
});

cljs.core.async.t_cljs$core$async15452.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15452.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15452.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15452.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15452.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async15455 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15455 = (function (map_LT_,f,ch,meta15453,_,fn1,meta15456){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta15453 = meta15453;
this._ = _;
this.fn1 = fn1;
this.meta15456 = meta15456;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15455.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_15457,meta15456__$1){
var self__ = this;
var _15457__$1 = this;
return (new cljs.core.async.t_cljs$core$async15455(self__.map_LT_,self__.f,self__.ch,self__.meta15453,self__._,self__.fn1,meta15456__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async15455.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_15457){
var self__ = this;
var _15457__$1 = this;
return self__.meta15456;
});})(___$1))
;

cljs.core.async.t_cljs$core$async15455.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async15455.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async15455.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async15455.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__15445_SHARP_){
return f1.call(null,(((p1__15445_SHARP_ == null))?null:self__.f.call(null,p1__15445_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async15455.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15453","meta15453",513766925,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async15452","cljs.core.async/t_cljs$core$async15452",-1754554471,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta15456","meta15456",658660616,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async15455.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15455.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15455";

cljs.core.async.t_cljs$core$async15455.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async15455");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async15455 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15455(map_LT___$1,f__$1,ch__$1,meta15453__$1,___$2,fn1__$1,meta15456){
return (new cljs.core.async.t_cljs$core$async15455(map_LT___$1,f__$1,ch__$1,meta15453__$1,___$2,fn1__$1,meta15456));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async15455(self__.map_LT_,self__.f,self__.ch,self__.meta15453,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async15452.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15452.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async15452.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15453","meta15453",513766925,null)], null);
});

cljs.core.async.t_cljs$core$async15452.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15452.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15452";

cljs.core.async.t_cljs$core$async15452.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async15452");
});

cljs.core.async.__GT_t_cljs$core$async15452 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15452(map_LT___$1,f__$1,ch__$1,meta15453){
return (new cljs.core.async.t_cljs$core$async15452(map_LT___$1,f__$1,ch__$1,meta15453));
});

}

return (new cljs.core.async.t_cljs$core$async15452(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async15461 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15461 = (function (map_GT_,f,ch,meta15462){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta15462 = meta15462;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15461.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15463,meta15462__$1){
var self__ = this;
var _15463__$1 = this;
return (new cljs.core.async.t_cljs$core$async15461(self__.map_GT_,self__.f,self__.ch,meta15462__$1));
});

cljs.core.async.t_cljs$core$async15461.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15463){
var self__ = this;
var _15463__$1 = this;
return self__.meta15462;
});

cljs.core.async.t_cljs$core$async15461.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15461.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15461.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15461.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async15461.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15461.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async15461.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15462","meta15462",823026694,null)], null);
});

cljs.core.async.t_cljs$core$async15461.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15461.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15461";

cljs.core.async.t_cljs$core$async15461.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async15461");
});

cljs.core.async.__GT_t_cljs$core$async15461 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async15461(map_GT___$1,f__$1,ch__$1,meta15462){
return (new cljs.core.async.t_cljs$core$async15461(map_GT___$1,f__$1,ch__$1,meta15462));
});

}

return (new cljs.core.async.t_cljs$core$async15461(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async15467 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15467 = (function (filter_GT_,p,ch,meta15468){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta15468 = meta15468;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15467.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15469,meta15468__$1){
var self__ = this;
var _15469__$1 = this;
return (new cljs.core.async.t_cljs$core$async15467(self__.filter_GT_,self__.p,self__.ch,meta15468__$1));
});

cljs.core.async.t_cljs$core$async15467.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15469){
var self__ = this;
var _15469__$1 = this;
return self__.meta15468;
});

cljs.core.async.t_cljs$core$async15467.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async15467.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15467.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async15467.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async15467.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async15467.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async15467.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async15467.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta15468","meta15468",1443935899,null)], null);
});

cljs.core.async.t_cljs$core$async15467.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15467.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15467";

cljs.core.async.t_cljs$core$async15467.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"cljs.core.async/t_cljs$core$async15467");
});

cljs.core.async.__GT_t_cljs$core$async15467 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async15467(filter_GT___$1,p__$1,ch__$1,meta15468){
return (new cljs.core.async.t_cljs$core$async15467(filter_GT___$1,p__$1,ch__$1,meta15468));
});

}

return (new cljs.core.async.t_cljs$core$async15467(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args15470 = [];
var len__7484__auto___15514 = arguments.length;
var i__7485__auto___15515 = (0);
while(true){
if((i__7485__auto___15515 < len__7484__auto___15514)){
args15470.push((arguments[i__7485__auto___15515]));

var G__15516 = (i__7485__auto___15515 + (1));
i__7485__auto___15515 = G__15516;
continue;
} else {
}
break;
}

var G__15472 = args15470.length;
switch (G__15472) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15470.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13216__auto___15518 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___15518,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___15518,out){
return (function (state_15493){
var state_val_15494 = (state_15493[(1)]);
if((state_val_15494 === (7))){
var inst_15489 = (state_15493[(2)]);
var state_15493__$1 = state_15493;
var statearr_15495_15519 = state_15493__$1;
(statearr_15495_15519[(2)] = inst_15489);

(statearr_15495_15519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (1))){
var state_15493__$1 = state_15493;
var statearr_15496_15520 = state_15493__$1;
(statearr_15496_15520[(2)] = null);

(statearr_15496_15520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (4))){
var inst_15475 = (state_15493[(7)]);
var inst_15475__$1 = (state_15493[(2)]);
var inst_15476 = (inst_15475__$1 == null);
var state_15493__$1 = (function (){var statearr_15497 = state_15493;
(statearr_15497[(7)] = inst_15475__$1);

return statearr_15497;
})();
if(cljs.core.truth_(inst_15476)){
var statearr_15498_15521 = state_15493__$1;
(statearr_15498_15521[(1)] = (5));

} else {
var statearr_15499_15522 = state_15493__$1;
(statearr_15499_15522[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (6))){
var inst_15475 = (state_15493[(7)]);
var inst_15480 = p.call(null,inst_15475);
var state_15493__$1 = state_15493;
if(cljs.core.truth_(inst_15480)){
var statearr_15500_15523 = state_15493__$1;
(statearr_15500_15523[(1)] = (8));

} else {
var statearr_15501_15524 = state_15493__$1;
(statearr_15501_15524[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (3))){
var inst_15491 = (state_15493[(2)]);
var state_15493__$1 = state_15493;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15493__$1,inst_15491);
} else {
if((state_val_15494 === (2))){
var state_15493__$1 = state_15493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15493__$1,(4),ch);
} else {
if((state_val_15494 === (11))){
var inst_15483 = (state_15493[(2)]);
var state_15493__$1 = state_15493;
var statearr_15502_15525 = state_15493__$1;
(statearr_15502_15525[(2)] = inst_15483);

(statearr_15502_15525[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (9))){
var state_15493__$1 = state_15493;
var statearr_15503_15526 = state_15493__$1;
(statearr_15503_15526[(2)] = null);

(statearr_15503_15526[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (5))){
var inst_15478 = cljs.core.async.close_BANG_.call(null,out);
var state_15493__$1 = state_15493;
var statearr_15504_15527 = state_15493__$1;
(statearr_15504_15527[(2)] = inst_15478);

(statearr_15504_15527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (10))){
var inst_15486 = (state_15493[(2)]);
var state_15493__$1 = (function (){var statearr_15505 = state_15493;
(statearr_15505[(8)] = inst_15486);

return statearr_15505;
})();
var statearr_15506_15528 = state_15493__$1;
(statearr_15506_15528[(2)] = null);

(statearr_15506_15528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15494 === (8))){
var inst_15475 = (state_15493[(7)]);
var state_15493__$1 = state_15493;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15493__$1,(11),out,inst_15475);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___15518,out))
;
return ((function (switch__13104__auto__,c__13216__auto___15518,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_15510 = [null,null,null,null,null,null,null,null,null];
(statearr_15510[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_15510[(1)] = (1));

return statearr_15510;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_15493){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_15493);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e15511){if((e15511 instanceof Object)){
var ex__13108__auto__ = e15511;
var statearr_15512_15529 = state_15493;
(statearr_15512_15529[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15493);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15511;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15530 = state_15493;
state_15493 = G__15530;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_15493){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_15493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___15518,out))
})();
var state__13218__auto__ = (function (){var statearr_15513 = f__13217__auto__.call(null);
(statearr_15513[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___15518);

return statearr_15513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___15518,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args15531 = [];
var len__7484__auto___15534 = arguments.length;
var i__7485__auto___15535 = (0);
while(true){
if((i__7485__auto___15535 < len__7484__auto___15534)){
args15531.push((arguments[i__7485__auto___15535]));

var G__15536 = (i__7485__auto___15535 + (1));
i__7485__auto___15535 = G__15536;
continue;
} else {
}
break;
}

var G__15533 = args15531.length;
switch (G__15533) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15531.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__13216__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto__){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__){
return (function (state_15703){
var state_val_15704 = (state_15703[(1)]);
if((state_val_15704 === (7))){
var inst_15699 = (state_15703[(2)]);
var state_15703__$1 = state_15703;
var statearr_15705_15746 = state_15703__$1;
(statearr_15705_15746[(2)] = inst_15699);

(statearr_15705_15746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (20))){
var inst_15669 = (state_15703[(7)]);
var inst_15680 = (state_15703[(2)]);
var inst_15681 = cljs.core.next.call(null,inst_15669);
var inst_15655 = inst_15681;
var inst_15656 = null;
var inst_15657 = (0);
var inst_15658 = (0);
var state_15703__$1 = (function (){var statearr_15706 = state_15703;
(statearr_15706[(8)] = inst_15656);

(statearr_15706[(9)] = inst_15658);

(statearr_15706[(10)] = inst_15655);

(statearr_15706[(11)] = inst_15680);

(statearr_15706[(12)] = inst_15657);

return statearr_15706;
})();
var statearr_15707_15747 = state_15703__$1;
(statearr_15707_15747[(2)] = null);

(statearr_15707_15747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (1))){
var state_15703__$1 = state_15703;
var statearr_15708_15748 = state_15703__$1;
(statearr_15708_15748[(2)] = null);

(statearr_15708_15748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (4))){
var inst_15644 = (state_15703[(13)]);
var inst_15644__$1 = (state_15703[(2)]);
var inst_15645 = (inst_15644__$1 == null);
var state_15703__$1 = (function (){var statearr_15709 = state_15703;
(statearr_15709[(13)] = inst_15644__$1);

return statearr_15709;
})();
if(cljs.core.truth_(inst_15645)){
var statearr_15710_15749 = state_15703__$1;
(statearr_15710_15749[(1)] = (5));

} else {
var statearr_15711_15750 = state_15703__$1;
(statearr_15711_15750[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (15))){
var state_15703__$1 = state_15703;
var statearr_15715_15751 = state_15703__$1;
(statearr_15715_15751[(2)] = null);

(statearr_15715_15751[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (21))){
var state_15703__$1 = state_15703;
var statearr_15716_15752 = state_15703__$1;
(statearr_15716_15752[(2)] = null);

(statearr_15716_15752[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (13))){
var inst_15656 = (state_15703[(8)]);
var inst_15658 = (state_15703[(9)]);
var inst_15655 = (state_15703[(10)]);
var inst_15657 = (state_15703[(12)]);
var inst_15665 = (state_15703[(2)]);
var inst_15666 = (inst_15658 + (1));
var tmp15712 = inst_15656;
var tmp15713 = inst_15655;
var tmp15714 = inst_15657;
var inst_15655__$1 = tmp15713;
var inst_15656__$1 = tmp15712;
var inst_15657__$1 = tmp15714;
var inst_15658__$1 = inst_15666;
var state_15703__$1 = (function (){var statearr_15717 = state_15703;
(statearr_15717[(8)] = inst_15656__$1);

(statearr_15717[(9)] = inst_15658__$1);

(statearr_15717[(10)] = inst_15655__$1);

(statearr_15717[(14)] = inst_15665);

(statearr_15717[(12)] = inst_15657__$1);

return statearr_15717;
})();
var statearr_15718_15753 = state_15703__$1;
(statearr_15718_15753[(2)] = null);

(statearr_15718_15753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (22))){
var state_15703__$1 = state_15703;
var statearr_15719_15754 = state_15703__$1;
(statearr_15719_15754[(2)] = null);

(statearr_15719_15754[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (6))){
var inst_15644 = (state_15703[(13)]);
var inst_15653 = f.call(null,inst_15644);
var inst_15654 = cljs.core.seq.call(null,inst_15653);
var inst_15655 = inst_15654;
var inst_15656 = null;
var inst_15657 = (0);
var inst_15658 = (0);
var state_15703__$1 = (function (){var statearr_15720 = state_15703;
(statearr_15720[(8)] = inst_15656);

(statearr_15720[(9)] = inst_15658);

(statearr_15720[(10)] = inst_15655);

(statearr_15720[(12)] = inst_15657);

return statearr_15720;
})();
var statearr_15721_15755 = state_15703__$1;
(statearr_15721_15755[(2)] = null);

(statearr_15721_15755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (17))){
var inst_15669 = (state_15703[(7)]);
var inst_15673 = cljs.core.chunk_first.call(null,inst_15669);
var inst_15674 = cljs.core.chunk_rest.call(null,inst_15669);
var inst_15675 = cljs.core.count.call(null,inst_15673);
var inst_15655 = inst_15674;
var inst_15656 = inst_15673;
var inst_15657 = inst_15675;
var inst_15658 = (0);
var state_15703__$1 = (function (){var statearr_15722 = state_15703;
(statearr_15722[(8)] = inst_15656);

(statearr_15722[(9)] = inst_15658);

(statearr_15722[(10)] = inst_15655);

(statearr_15722[(12)] = inst_15657);

return statearr_15722;
})();
var statearr_15723_15756 = state_15703__$1;
(statearr_15723_15756[(2)] = null);

(statearr_15723_15756[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (3))){
var inst_15701 = (state_15703[(2)]);
var state_15703__$1 = state_15703;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15703__$1,inst_15701);
} else {
if((state_val_15704 === (12))){
var inst_15689 = (state_15703[(2)]);
var state_15703__$1 = state_15703;
var statearr_15724_15757 = state_15703__$1;
(statearr_15724_15757[(2)] = inst_15689);

(statearr_15724_15757[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (2))){
var state_15703__$1 = state_15703;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15703__$1,(4),in$);
} else {
if((state_val_15704 === (23))){
var inst_15697 = (state_15703[(2)]);
var state_15703__$1 = state_15703;
var statearr_15725_15758 = state_15703__$1;
(statearr_15725_15758[(2)] = inst_15697);

(statearr_15725_15758[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (19))){
var inst_15684 = (state_15703[(2)]);
var state_15703__$1 = state_15703;
var statearr_15726_15759 = state_15703__$1;
(statearr_15726_15759[(2)] = inst_15684);

(statearr_15726_15759[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (11))){
var inst_15655 = (state_15703[(10)]);
var inst_15669 = (state_15703[(7)]);
var inst_15669__$1 = cljs.core.seq.call(null,inst_15655);
var state_15703__$1 = (function (){var statearr_15727 = state_15703;
(statearr_15727[(7)] = inst_15669__$1);

return statearr_15727;
})();
if(inst_15669__$1){
var statearr_15728_15760 = state_15703__$1;
(statearr_15728_15760[(1)] = (14));

} else {
var statearr_15729_15761 = state_15703__$1;
(statearr_15729_15761[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (9))){
var inst_15691 = (state_15703[(2)]);
var inst_15692 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_15703__$1 = (function (){var statearr_15730 = state_15703;
(statearr_15730[(15)] = inst_15691);

return statearr_15730;
})();
if(cljs.core.truth_(inst_15692)){
var statearr_15731_15762 = state_15703__$1;
(statearr_15731_15762[(1)] = (21));

} else {
var statearr_15732_15763 = state_15703__$1;
(statearr_15732_15763[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (5))){
var inst_15647 = cljs.core.async.close_BANG_.call(null,out);
var state_15703__$1 = state_15703;
var statearr_15733_15764 = state_15703__$1;
(statearr_15733_15764[(2)] = inst_15647);

(statearr_15733_15764[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (14))){
var inst_15669 = (state_15703[(7)]);
var inst_15671 = cljs.core.chunked_seq_QMARK_.call(null,inst_15669);
var state_15703__$1 = state_15703;
if(inst_15671){
var statearr_15734_15765 = state_15703__$1;
(statearr_15734_15765[(1)] = (17));

} else {
var statearr_15735_15766 = state_15703__$1;
(statearr_15735_15766[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (16))){
var inst_15687 = (state_15703[(2)]);
var state_15703__$1 = state_15703;
var statearr_15736_15767 = state_15703__$1;
(statearr_15736_15767[(2)] = inst_15687);

(statearr_15736_15767[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15704 === (10))){
var inst_15656 = (state_15703[(8)]);
var inst_15658 = (state_15703[(9)]);
var inst_15663 = cljs.core._nth.call(null,inst_15656,inst_15658);
var state_15703__$1 = state_15703;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15703__$1,(13),out,inst_15663);
} else {
if((state_val_15704 === (18))){
var inst_15669 = (state_15703[(7)]);
var inst_15678 = cljs.core.first.call(null,inst_15669);
var state_15703__$1 = state_15703;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15703__$1,(20),out,inst_15678);
} else {
if((state_val_15704 === (8))){
var inst_15658 = (state_15703[(9)]);
var inst_15657 = (state_15703[(12)]);
var inst_15660 = (inst_15658 < inst_15657);
var inst_15661 = inst_15660;
var state_15703__$1 = state_15703;
if(cljs.core.truth_(inst_15661)){
var statearr_15737_15768 = state_15703__$1;
(statearr_15737_15768[(1)] = (10));

} else {
var statearr_15738_15769 = state_15703__$1;
(statearr_15738_15769[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__))
;
return ((function (switch__13104__auto__,c__13216__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_15742 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15742[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__);

(statearr_15742[(1)] = (1));

return statearr_15742;
});
var cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____1 = (function (state_15703){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_15703);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e15743){if((e15743 instanceof Object)){
var ex__13108__auto__ = e15743;
var statearr_15744_15770 = state_15703;
(statearr_15744_15770[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15703);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15743;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15771 = state_15703;
state_15703 = G__15771;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__ = function(state_15703){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____1.call(this,state_15703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__))
})();
var state__13218__auto__ = (function (){var statearr_15745 = f__13217__auto__.call(null);
(statearr_15745[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_15745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto__))
);

return c__13216__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args15772 = [];
var len__7484__auto___15775 = arguments.length;
var i__7485__auto___15776 = (0);
while(true){
if((i__7485__auto___15776 < len__7484__auto___15775)){
args15772.push((arguments[i__7485__auto___15776]));

var G__15777 = (i__7485__auto___15776 + (1));
i__7485__auto___15776 = G__15777;
continue;
} else {
}
break;
}

var G__15774 = args15772.length;
switch (G__15774) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15772.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args15779 = [];
var len__7484__auto___15782 = arguments.length;
var i__7485__auto___15783 = (0);
while(true){
if((i__7485__auto___15783 < len__7484__auto___15782)){
args15779.push((arguments[i__7485__auto___15783]));

var G__15784 = (i__7485__auto___15783 + (1));
i__7485__auto___15783 = G__15784;
continue;
} else {
}
break;
}

var G__15781 = args15779.length;
switch (G__15781) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15779.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args15786 = [];
var len__7484__auto___15837 = arguments.length;
var i__7485__auto___15838 = (0);
while(true){
if((i__7485__auto___15838 < len__7484__auto___15837)){
args15786.push((arguments[i__7485__auto___15838]));

var G__15839 = (i__7485__auto___15838 + (1));
i__7485__auto___15838 = G__15839;
continue;
} else {
}
break;
}

var G__15788 = args15786.length;
switch (G__15788) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15786.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13216__auto___15841 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___15841,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___15841,out){
return (function (state_15812){
var state_val_15813 = (state_15812[(1)]);
if((state_val_15813 === (7))){
var inst_15807 = (state_15812[(2)]);
var state_15812__$1 = state_15812;
var statearr_15814_15842 = state_15812__$1;
(statearr_15814_15842[(2)] = inst_15807);

(statearr_15814_15842[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15813 === (1))){
var inst_15789 = null;
var state_15812__$1 = (function (){var statearr_15815 = state_15812;
(statearr_15815[(7)] = inst_15789);

return statearr_15815;
})();
var statearr_15816_15843 = state_15812__$1;
(statearr_15816_15843[(2)] = null);

(statearr_15816_15843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15813 === (4))){
var inst_15792 = (state_15812[(8)]);
var inst_15792__$1 = (state_15812[(2)]);
var inst_15793 = (inst_15792__$1 == null);
var inst_15794 = cljs.core.not.call(null,inst_15793);
var state_15812__$1 = (function (){var statearr_15817 = state_15812;
(statearr_15817[(8)] = inst_15792__$1);

return statearr_15817;
})();
if(inst_15794){
var statearr_15818_15844 = state_15812__$1;
(statearr_15818_15844[(1)] = (5));

} else {
var statearr_15819_15845 = state_15812__$1;
(statearr_15819_15845[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15813 === (6))){
var state_15812__$1 = state_15812;
var statearr_15820_15846 = state_15812__$1;
(statearr_15820_15846[(2)] = null);

(statearr_15820_15846[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15813 === (3))){
var inst_15809 = (state_15812[(2)]);
var inst_15810 = cljs.core.async.close_BANG_.call(null,out);
var state_15812__$1 = (function (){var statearr_15821 = state_15812;
(statearr_15821[(9)] = inst_15809);

return statearr_15821;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15812__$1,inst_15810);
} else {
if((state_val_15813 === (2))){
var state_15812__$1 = state_15812;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15812__$1,(4),ch);
} else {
if((state_val_15813 === (11))){
var inst_15792 = (state_15812[(8)]);
var inst_15801 = (state_15812[(2)]);
var inst_15789 = inst_15792;
var state_15812__$1 = (function (){var statearr_15822 = state_15812;
(statearr_15822[(7)] = inst_15789);

(statearr_15822[(10)] = inst_15801);

return statearr_15822;
})();
var statearr_15823_15847 = state_15812__$1;
(statearr_15823_15847[(2)] = null);

(statearr_15823_15847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15813 === (9))){
var inst_15792 = (state_15812[(8)]);
var state_15812__$1 = state_15812;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15812__$1,(11),out,inst_15792);
} else {
if((state_val_15813 === (5))){
var inst_15789 = (state_15812[(7)]);
var inst_15792 = (state_15812[(8)]);
var inst_15796 = cljs.core._EQ_.call(null,inst_15792,inst_15789);
var state_15812__$1 = state_15812;
if(inst_15796){
var statearr_15825_15848 = state_15812__$1;
(statearr_15825_15848[(1)] = (8));

} else {
var statearr_15826_15849 = state_15812__$1;
(statearr_15826_15849[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15813 === (10))){
var inst_15804 = (state_15812[(2)]);
var state_15812__$1 = state_15812;
var statearr_15827_15850 = state_15812__$1;
(statearr_15827_15850[(2)] = inst_15804);

(statearr_15827_15850[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15813 === (8))){
var inst_15789 = (state_15812[(7)]);
var tmp15824 = inst_15789;
var inst_15789__$1 = tmp15824;
var state_15812__$1 = (function (){var statearr_15828 = state_15812;
(statearr_15828[(7)] = inst_15789__$1);

return statearr_15828;
})();
var statearr_15829_15851 = state_15812__$1;
(statearr_15829_15851[(2)] = null);

(statearr_15829_15851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___15841,out))
;
return ((function (switch__13104__auto__,c__13216__auto___15841,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_15833 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15833[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_15833[(1)] = (1));

return statearr_15833;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_15812){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_15812);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e15834){if((e15834 instanceof Object)){
var ex__13108__auto__ = e15834;
var statearr_15835_15852 = state_15812;
(statearr_15835_15852[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15812);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15834;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15853 = state_15812;
state_15812 = G__15853;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_15812){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_15812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___15841,out))
})();
var state__13218__auto__ = (function (){var statearr_15836 = f__13217__auto__.call(null);
(statearr_15836[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___15841);

return statearr_15836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___15841,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args15854 = [];
var len__7484__auto___15924 = arguments.length;
var i__7485__auto___15925 = (0);
while(true){
if((i__7485__auto___15925 < len__7484__auto___15924)){
args15854.push((arguments[i__7485__auto___15925]));

var G__15926 = (i__7485__auto___15925 + (1));
i__7485__auto___15925 = G__15926;
continue;
} else {
}
break;
}

var G__15856 = args15854.length;
switch (G__15856) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15854.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13216__auto___15928 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___15928,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___15928,out){
return (function (state_15894){
var state_val_15895 = (state_15894[(1)]);
if((state_val_15895 === (7))){
var inst_15890 = (state_15894[(2)]);
var state_15894__$1 = state_15894;
var statearr_15896_15929 = state_15894__$1;
(statearr_15896_15929[(2)] = inst_15890);

(statearr_15896_15929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15895 === (1))){
var inst_15857 = (new Array(n));
var inst_15858 = inst_15857;
var inst_15859 = (0);
var state_15894__$1 = (function (){var statearr_15897 = state_15894;
(statearr_15897[(7)] = inst_15858);

(statearr_15897[(8)] = inst_15859);

return statearr_15897;
})();
var statearr_15898_15930 = state_15894__$1;
(statearr_15898_15930[(2)] = null);

(statearr_15898_15930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15895 === (4))){
var inst_15862 = (state_15894[(9)]);
var inst_15862__$1 = (state_15894[(2)]);
var inst_15863 = (inst_15862__$1 == null);
var inst_15864 = cljs.core.not.call(null,inst_15863);
var state_15894__$1 = (function (){var statearr_15899 = state_15894;
(statearr_15899[(9)] = inst_15862__$1);

return statearr_15899;
})();
if(inst_15864){
var statearr_15900_15931 = state_15894__$1;
(statearr_15900_15931[(1)] = (5));

} else {
var statearr_15901_15932 = state_15894__$1;
(statearr_15901_15932[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15895 === (15))){
var inst_15884 = (state_15894[(2)]);
var state_15894__$1 = state_15894;
var statearr_15902_15933 = state_15894__$1;
(statearr_15902_15933[(2)] = inst_15884);

(statearr_15902_15933[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15895 === (13))){
var state_15894__$1 = state_15894;
var statearr_15903_15934 = state_15894__$1;
(statearr_15903_15934[(2)] = null);

(statearr_15903_15934[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15895 === (6))){
var inst_15859 = (state_15894[(8)]);
var inst_15880 = (inst_15859 > (0));
var state_15894__$1 = state_15894;
if(cljs.core.truth_(inst_15880)){
var statearr_15904_15935 = state_15894__$1;
(statearr_15904_15935[(1)] = (12));

} else {
var statearr_15905_15936 = state_15894__$1;
(statearr_15905_15936[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15895 === (3))){
var inst_15892 = (state_15894[(2)]);
var state_15894__$1 = state_15894;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15894__$1,inst_15892);
} else {
if((state_val_15895 === (12))){
var inst_15858 = (state_15894[(7)]);
var inst_15882 = cljs.core.vec.call(null,inst_15858);
var state_15894__$1 = state_15894;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15894__$1,(15),out,inst_15882);
} else {
if((state_val_15895 === (2))){
var state_15894__$1 = state_15894;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15894__$1,(4),ch);
} else {
if((state_val_15895 === (11))){
var inst_15874 = (state_15894[(2)]);
var inst_15875 = (new Array(n));
var inst_15858 = inst_15875;
var inst_15859 = (0);
var state_15894__$1 = (function (){var statearr_15906 = state_15894;
(statearr_15906[(7)] = inst_15858);

(statearr_15906[(8)] = inst_15859);

(statearr_15906[(10)] = inst_15874);

return statearr_15906;
})();
var statearr_15907_15937 = state_15894__$1;
(statearr_15907_15937[(2)] = null);

(statearr_15907_15937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15895 === (9))){
var inst_15858 = (state_15894[(7)]);
var inst_15872 = cljs.core.vec.call(null,inst_15858);
var state_15894__$1 = state_15894;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15894__$1,(11),out,inst_15872);
} else {
if((state_val_15895 === (5))){
var inst_15858 = (state_15894[(7)]);
var inst_15862 = (state_15894[(9)]);
var inst_15859 = (state_15894[(8)]);
var inst_15867 = (state_15894[(11)]);
var inst_15866 = (inst_15858[inst_15859] = inst_15862);
var inst_15867__$1 = (inst_15859 + (1));
var inst_15868 = (inst_15867__$1 < n);
var state_15894__$1 = (function (){var statearr_15908 = state_15894;
(statearr_15908[(12)] = inst_15866);

(statearr_15908[(11)] = inst_15867__$1);

return statearr_15908;
})();
if(cljs.core.truth_(inst_15868)){
var statearr_15909_15938 = state_15894__$1;
(statearr_15909_15938[(1)] = (8));

} else {
var statearr_15910_15939 = state_15894__$1;
(statearr_15910_15939[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15895 === (14))){
var inst_15887 = (state_15894[(2)]);
var inst_15888 = cljs.core.async.close_BANG_.call(null,out);
var state_15894__$1 = (function (){var statearr_15912 = state_15894;
(statearr_15912[(13)] = inst_15887);

return statearr_15912;
})();
var statearr_15913_15940 = state_15894__$1;
(statearr_15913_15940[(2)] = inst_15888);

(statearr_15913_15940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15895 === (10))){
var inst_15878 = (state_15894[(2)]);
var state_15894__$1 = state_15894;
var statearr_15914_15941 = state_15894__$1;
(statearr_15914_15941[(2)] = inst_15878);

(statearr_15914_15941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15895 === (8))){
var inst_15858 = (state_15894[(7)]);
var inst_15867 = (state_15894[(11)]);
var tmp15911 = inst_15858;
var inst_15858__$1 = tmp15911;
var inst_15859 = inst_15867;
var state_15894__$1 = (function (){var statearr_15915 = state_15894;
(statearr_15915[(7)] = inst_15858__$1);

(statearr_15915[(8)] = inst_15859);

return statearr_15915;
})();
var statearr_15916_15942 = state_15894__$1;
(statearr_15916_15942[(2)] = null);

(statearr_15916_15942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___15928,out))
;
return ((function (switch__13104__auto__,c__13216__auto___15928,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_15920 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15920[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_15920[(1)] = (1));

return statearr_15920;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_15894){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_15894);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e15921){if((e15921 instanceof Object)){
var ex__13108__auto__ = e15921;
var statearr_15922_15943 = state_15894;
(statearr_15922_15943[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15894);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15921;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15944 = state_15894;
state_15894 = G__15944;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_15894){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_15894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___15928,out))
})();
var state__13218__auto__ = (function (){var statearr_15923 = f__13217__auto__.call(null);
(statearr_15923[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___15928);

return statearr_15923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___15928,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args15945 = [];
var len__7484__auto___16019 = arguments.length;
var i__7485__auto___16020 = (0);
while(true){
if((i__7485__auto___16020 < len__7484__auto___16019)){
args15945.push((arguments[i__7485__auto___16020]));

var G__16021 = (i__7485__auto___16020 + (1));
i__7485__auto___16020 = G__16021;
continue;
} else {
}
break;
}

var G__15947 = args15945.length;
switch (G__15947) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15945.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__13216__auto___16023 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto___16023,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___16023,out){
return (function (state_15989){
var state_val_15990 = (state_15989[(1)]);
if((state_val_15990 === (7))){
var inst_15985 = (state_15989[(2)]);
var state_15989__$1 = state_15989;
var statearr_15991_16024 = state_15989__$1;
(statearr_15991_16024[(2)] = inst_15985);

(statearr_15991_16024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15990 === (1))){
var inst_15948 = [];
var inst_15949 = inst_15948;
var inst_15950 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_15989__$1 = (function (){var statearr_15992 = state_15989;
(statearr_15992[(7)] = inst_15950);

(statearr_15992[(8)] = inst_15949);

return statearr_15992;
})();
var statearr_15993_16025 = state_15989__$1;
(statearr_15993_16025[(2)] = null);

(statearr_15993_16025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15990 === (4))){
var inst_15953 = (state_15989[(9)]);
var inst_15953__$1 = (state_15989[(2)]);
var inst_15954 = (inst_15953__$1 == null);
var inst_15955 = cljs.core.not.call(null,inst_15954);
var state_15989__$1 = (function (){var statearr_15994 = state_15989;
(statearr_15994[(9)] = inst_15953__$1);

return statearr_15994;
})();
if(inst_15955){
var statearr_15995_16026 = state_15989__$1;
(statearr_15995_16026[(1)] = (5));

} else {
var statearr_15996_16027 = state_15989__$1;
(statearr_15996_16027[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15990 === (15))){
var inst_15979 = (state_15989[(2)]);
var state_15989__$1 = state_15989;
var statearr_15997_16028 = state_15989__$1;
(statearr_15997_16028[(2)] = inst_15979);

(statearr_15997_16028[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15990 === (13))){
var state_15989__$1 = state_15989;
var statearr_15998_16029 = state_15989__$1;
(statearr_15998_16029[(2)] = null);

(statearr_15998_16029[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15990 === (6))){
var inst_15949 = (state_15989[(8)]);
var inst_15974 = inst_15949.length;
var inst_15975 = (inst_15974 > (0));
var state_15989__$1 = state_15989;
if(cljs.core.truth_(inst_15975)){
var statearr_15999_16030 = state_15989__$1;
(statearr_15999_16030[(1)] = (12));

} else {
var statearr_16000_16031 = state_15989__$1;
(statearr_16000_16031[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15990 === (3))){
var inst_15987 = (state_15989[(2)]);
var state_15989__$1 = state_15989;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15989__$1,inst_15987);
} else {
if((state_val_15990 === (12))){
var inst_15949 = (state_15989[(8)]);
var inst_15977 = cljs.core.vec.call(null,inst_15949);
var state_15989__$1 = state_15989;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15989__$1,(15),out,inst_15977);
} else {
if((state_val_15990 === (2))){
var state_15989__$1 = state_15989;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15989__$1,(4),ch);
} else {
if((state_val_15990 === (11))){
var inst_15953 = (state_15989[(9)]);
var inst_15957 = (state_15989[(10)]);
var inst_15967 = (state_15989[(2)]);
var inst_15968 = [];
var inst_15969 = inst_15968.push(inst_15953);
var inst_15949 = inst_15968;
var inst_15950 = inst_15957;
var state_15989__$1 = (function (){var statearr_16001 = state_15989;
(statearr_16001[(11)] = inst_15969);

(statearr_16001[(7)] = inst_15950);

(statearr_16001[(8)] = inst_15949);

(statearr_16001[(12)] = inst_15967);

return statearr_16001;
})();
var statearr_16002_16032 = state_15989__$1;
(statearr_16002_16032[(2)] = null);

(statearr_16002_16032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15990 === (9))){
var inst_15949 = (state_15989[(8)]);
var inst_15965 = cljs.core.vec.call(null,inst_15949);
var state_15989__$1 = state_15989;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15989__$1,(11),out,inst_15965);
} else {
if((state_val_15990 === (5))){
var inst_15953 = (state_15989[(9)]);
var inst_15950 = (state_15989[(7)]);
var inst_15957 = (state_15989[(10)]);
var inst_15957__$1 = f.call(null,inst_15953);
var inst_15958 = cljs.core._EQ_.call(null,inst_15957__$1,inst_15950);
var inst_15959 = cljs.core.keyword_identical_QMARK_.call(null,inst_15950,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_15960 = (inst_15958) || (inst_15959);
var state_15989__$1 = (function (){var statearr_16003 = state_15989;
(statearr_16003[(10)] = inst_15957__$1);

return statearr_16003;
})();
if(cljs.core.truth_(inst_15960)){
var statearr_16004_16033 = state_15989__$1;
(statearr_16004_16033[(1)] = (8));

} else {
var statearr_16005_16034 = state_15989__$1;
(statearr_16005_16034[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15990 === (14))){
var inst_15982 = (state_15989[(2)]);
var inst_15983 = cljs.core.async.close_BANG_.call(null,out);
var state_15989__$1 = (function (){var statearr_16007 = state_15989;
(statearr_16007[(13)] = inst_15982);

return statearr_16007;
})();
var statearr_16008_16035 = state_15989__$1;
(statearr_16008_16035[(2)] = inst_15983);

(statearr_16008_16035[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15990 === (10))){
var inst_15972 = (state_15989[(2)]);
var state_15989__$1 = state_15989;
var statearr_16009_16036 = state_15989__$1;
(statearr_16009_16036[(2)] = inst_15972);

(statearr_16009_16036[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15990 === (8))){
var inst_15953 = (state_15989[(9)]);
var inst_15957 = (state_15989[(10)]);
var inst_15949 = (state_15989[(8)]);
var inst_15962 = inst_15949.push(inst_15953);
var tmp16006 = inst_15949;
var inst_15949__$1 = tmp16006;
var inst_15950 = inst_15957;
var state_15989__$1 = (function (){var statearr_16010 = state_15989;
(statearr_16010[(7)] = inst_15950);

(statearr_16010[(14)] = inst_15962);

(statearr_16010[(8)] = inst_15949__$1);

return statearr_16010;
})();
var statearr_16011_16037 = state_15989__$1;
(statearr_16011_16037[(2)] = null);

(statearr_16011_16037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___16023,out))
;
return ((function (switch__13104__auto__,c__13216__auto___16023,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_16015 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16015[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_16015[(1)] = (1));

return statearr_16015;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_15989){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_15989);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e16016){if((e16016 instanceof Object)){
var ex__13108__auto__ = e16016;
var statearr_16017_16038 = state_15989;
(statearr_16017_16038[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15989);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16016;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16039 = state_15989;
state_15989 = G__16039;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_15989){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_15989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___16023,out))
})();
var state__13218__auto__ = (function (){var statearr_16018 = f__13217__auto__.call(null);
(statearr_16018[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___16023);

return statearr_16018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto___16023,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

