// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('c2.scale');
goog.require('cljs.core');
goog.require('c2.maths');

/**
 * @interface
 */
c2.scale.IInvertable = function(){};

/**
 * Inverted scale
 */
c2.scale.invert = (function c2$scale$invert(scale){
if((!((scale == null))) && (!((scale.c2$scale$IInvertable$invert$arity$1 == null)))){
return scale.c2$scale$IInvertable$invert$arity$1(scale);
} else {
var x__7072__auto__ = (((scale == null))?null:scale);
var m__7073__auto__ = (c2.scale.invert[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(scale) : m__7073__auto__.call(null,scale));
} else {
var m__7073__auto____$1 = (c2.scale.invert["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(scale) : m__7073__auto____$1.call(null,scale));
} else {
throw cljs.core.missing_protocol("IInvertable.invert",scale);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {c2.scale.IInvertable}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._linear = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7031__auto____$1,k__7032__auto__,null);
});

c2.scale._linear.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k39203,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__39206 = (((k39203 instanceof cljs.core.Keyword))?k39203.fqn:null);
switch (G__39206) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39203,else__7034__auto__);

}
});

c2.scale._linear.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer(writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7046__auto__,pr_pair__7048__auto__,"#c2.scale._linear{",", ","}",opts__7047__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IIterable$ = true;

c2.scale._linear.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39202){
var self__ = this;
var G__39202__$1 = this;
return (new cljs.core.RecordIter((0),G__39202__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._linear.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

c2.scale._linear.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap(this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

c2.scale._linear.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map(this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._linear.prototype.c2$scale$IInvertable$ = true;

c2.scale._linear.prototype.c2$scale$IInvertable$invert$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$__$1,cljs.core.cst$kw$domain,self__.range,cljs.core.array_seq([cljs.core.cst$kw$range,self__.domain], 0));
});

c2.scale._linear.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__7041__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7041__auto__)),null));
}
});

c2.scale._linear.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__39202){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__39207 = cljs.core.keyword_identical_QMARK_;
var expr__39208 = k__7039__auto__;
if(cljs.core.truth_((function (){var G__39210 = cljs.core.cst$kw$domain;
var G__39211 = expr__39208;
return (pred__39207.cljs$core$IFn$_invoke$arity$2 ? pred__39207.cljs$core$IFn$_invoke$arity$2(G__39210,G__39211) : pred__39207.call(null,G__39210,G__39211));
})())){
return (new c2.scale._linear(G__39202,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39212 = cljs.core.cst$kw$range;
var G__39213 = expr__39208;
return (pred__39207.cljs$core$IFn$_invoke$arity$2 ? pred__39207.cljs$core$IFn$_invoke$arity$2(G__39212,G__39213) : pred__39207.call(null,G__39212,G__39213));
})())){
return (new c2.scale._linear(self__.domain,G__39202,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._linear(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7039__auto__,G__39202),null));
}
}
});

c2.scale._linear.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._linear.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__39202){
var self__ = this;
var this__7030__auto____$1 = this;
return (new c2.scale._linear(self__.domain,self__.range,G__39202,self__.__extmap,self__.__hash));
});

c2.scale._linear.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7037__auto__)){
return cljs.core._assoc(this__7036__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

c2.scale._linear.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var domain_length = (cljs.core.last(self__.domain) - cljs.core.first(self__.domain));
var range_length = (cljs.core.last(self__.range) - cljs.core.first(self__.range));
return (cljs.core.first(self__.range) + (range_length * ((x - cljs.core.first(self__.domain)) / domain_length)));
});

c2.scale._linear.prototype.apply = (function (self__,args39205){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args39205)));
});

c2.scale._linear.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
var domain_length = (cljs.core.last(self__.domain) - cljs.core.first(self__.domain));
var range_length = (cljs.core.last(self__.range) - cljs.core.first(self__.range));
return (cljs.core.first(self__.range) + (range_length * ((x - cljs.core.first(self__.domain)) / domain_length)));
});

c2.scale._linear.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._linear.cljs$lang$type = true;

c2.scale._linear.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_linear");
});

c2.scale._linear.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write(writer__7066__auto__,"c2.scale/_linear");
});

c2.scale.__GT__linear = (function c2$scale$__GT__linear(domain,range){
return (new c2.scale._linear(domain,range,null,null,null));
});

c2.scale.map__GT__linear = (function c2$scale$map__GT__linear(G__39204){
return (new c2.scale._linear(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__39204),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__39204),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39204,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.linear = (function c2$scale$linear(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39216 = arguments.length;
var i__7485__auto___39217 = (0);
while(true){
if((i__7485__auto___39217 < len__7484__auto___39216)){
args__7491__auto__.push((arguments[i__7485__auto___39217]));

var G__39218 = (i__7485__auto___39217 + (1));
i__7485__auto___39217 = G__39218;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__linear(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.linear.cljs$lang$maxFixedArity = (0);

c2.scale.linear.cljs$lang$applyTo = (function (seq39214){
return c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39214));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._power = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7031__auto____$1,k__7032__auto__,null);
});

c2.scale._power.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k39220,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__39223 = (((k39220 instanceof cljs.core.Keyword))?k39220.fqn:null);
switch (G__39223) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39220,else__7034__auto__);

}
});

c2.scale._power.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer(writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7046__auto__,pr_pair__7048__auto__,"#c2.scale._power{",", ","}",opts__7047__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IIterable$ = true;

c2.scale._power.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39219){
var self__ = this;
var G__39219__$1 = this;
return (new cljs.core.RecordIter((0),G__39219__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._power.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

c2.scale._power.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap(this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

c2.scale._power.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map(this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._power.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__7041__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7041__auto__)),null));
}
});

c2.scale._power.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__39219){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__39224 = cljs.core.keyword_identical_QMARK_;
var expr__39225 = k__7039__auto__;
if(cljs.core.truth_((function (){var G__39227 = cljs.core.cst$kw$domain;
var G__39228 = expr__39225;
return (pred__39224.cljs$core$IFn$_invoke$arity$2 ? pred__39224.cljs$core$IFn$_invoke$arity$2(G__39227,G__39228) : pred__39224.call(null,G__39227,G__39228));
})())){
return (new c2.scale._power(G__39219,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39229 = cljs.core.cst$kw$range;
var G__39230 = expr__39225;
return (pred__39224.cljs$core$IFn$_invoke$arity$2 ? pred__39224.cljs$core$IFn$_invoke$arity$2(G__39229,G__39230) : pred__39224.call(null,G__39229,G__39230));
})())){
return (new c2.scale._power(self__.domain,G__39219,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._power(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7039__auto__,G__39219),null));
}
}
});

c2.scale._power.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._power.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__39219){
var self__ = this;
var this__7030__auto____$1 = this;
return (new c2.scale._power(self__.domain,self__.range,G__39219,self__.__extmap,self__.__hash));
});

c2.scale._power.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7037__auto__)){
return cljs.core._assoc(this__7036__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

c2.scale._power.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.expt,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.expt).call(null,x);
});

c2.scale._power.prototype.apply = (function (self__,args39222){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args39222)));
});

c2.scale._power.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.expt,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.expt).call(null,x);
});

c2.scale._power.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._power.cljs$lang$type = true;

c2.scale._power.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_power");
});

c2.scale._power.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write(writer__7066__auto__,"c2.scale/_power");
});

c2.scale.__GT__power = (function c2$scale$__GT__power(domain,range){
return (new c2.scale._power(domain,range,null,null,null));
});

c2.scale.map__GT__power = (function c2$scale$map__GT__power(G__39221){
return (new c2.scale._power(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__39221),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__39221),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39221,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.power = (function c2$scale$power(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39233 = arguments.length;
var i__7485__auto___39234 = (0);
while(true){
if((i__7485__auto___39234 < len__7484__auto___39233)){
args__7491__auto__.push((arguments[i__7485__auto___39234]));

var G__39235 = (i__7485__auto___39234 + (1));
i__7485__auto___39234 = G__39235;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.scale.power.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__power(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.power.cljs$lang$maxFixedArity = (0);

c2.scale.power.cljs$lang$applyTo = (function (seq39231){
return c2.scale.power.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39231));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
c2.scale._log = (function (domain,range,__meta,__extmap,__hash){
this.domain = domain;
this.range = range;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7031__auto__,k__7032__auto__){
var self__ = this;
var this__7031__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7031__auto____$1,k__7032__auto__,null);
});

c2.scale._log.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7033__auto__,k39237,else__7034__auto__){
var self__ = this;
var this__7033__auto____$1 = this;
var G__39240 = (((k39237 instanceof cljs.core.Keyword))?k39237.fqn:null);
switch (G__39240) {
case "domain":
return self__.domain;

break;
case "range":
return self__.range;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39237,else__7034__auto__);

}
});

c2.scale._log.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7045__auto__,writer__7046__auto__,opts__7047__auto__){
var self__ = this;
var this__7045__auto____$1 = this;
var pr_pair__7048__auto__ = ((function (this__7045__auto____$1){
return (function (keyval__7049__auto__){
return cljs.core.pr_sequential_writer(writer__7046__auto__,cljs.core.pr_writer,""," ","",opts__7047__auto__,keyval__7049__auto__);
});})(this__7045__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7046__auto__,pr_pair__7048__auto__,"#c2.scale._log{",", ","}",opts__7047__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IIterable$ = true;

c2.scale._log.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39236){
var self__ = this;
var G__39236__$1 = this;
return (new cljs.core.RecordIter((0),G__39236__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$domain,cljs.core.cst$kw$range], null),cljs.core._iterator(self__.__extmap)));
});

c2.scale._log.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7029__auto__){
var self__ = this;
var this__7029__auto____$1 = this;
return self__.__meta;
});

c2.scale._log.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7025__auto__){
var self__ = this;
var this__7025__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7035__auto__){
var self__ = this;
var this__7035__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7026__auto__){
var self__ = this;
var this__7026__auto____$1 = this;
var h__6844__auto__ = self__.__hash;
if(!((h__6844__auto__ == null))){
return h__6844__auto__;
} else {
var h__6844__auto____$1 = cljs.core.hash_imap(this__7026__auto____$1);
self__.__hash = h__6844__auto____$1;

return h__6844__auto____$1;
}
});

c2.scale._log.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7027__auto__,other__7028__auto__){
var self__ = this;
var this__7027__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6397__auto__ = other__7028__auto__;
if(cljs.core.truth_(and__6397__auto__)){
var and__6397__auto____$1 = (this__7027__auto____$1.constructor === other__7028__auto__.constructor);
if(and__6397__auto____$1){
return cljs.core.equiv_map(this__7027__auto____$1,other__7028__auto__);
} else {
return and__6397__auto____$1;
}
} else {
return and__6397__auto__;
}
})())){
return true;
} else {
return false;
}
});

c2.scale._log.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7040__auto__,k__7041__auto__){
var self__ = this;
var this__7040__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,null,cljs.core.cst$kw$range,null], null), null),k__7041__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7040__auto____$1),self__.__meta),k__7041__auto__);
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7041__auto__)),null));
}
});

c2.scale._log.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7038__auto__,k__7039__auto__,G__39236){
var self__ = this;
var this__7038__auto____$1 = this;
var pred__39241 = cljs.core.keyword_identical_QMARK_;
var expr__39242 = k__7039__auto__;
if(cljs.core.truth_((function (){var G__39244 = cljs.core.cst$kw$domain;
var G__39245 = expr__39242;
return (pred__39241.cljs$core$IFn$_invoke$arity$2 ? pred__39241.cljs$core$IFn$_invoke$arity$2(G__39244,G__39245) : pred__39241.call(null,G__39244,G__39245));
})())){
return (new c2.scale._log(G__39236,self__.range,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39246 = cljs.core.cst$kw$range;
var G__39247 = expr__39242;
return (pred__39241.cljs$core$IFn$_invoke$arity$2 ? pred__39241.cljs$core$IFn$_invoke$arity$2(G__39246,G__39247) : pred__39241.call(null,G__39246,G__39247));
})())){
return (new c2.scale._log(self__.domain,G__39236,self__.__meta,self__.__extmap,null));
} else {
return (new c2.scale._log(self__.domain,self__.range,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7039__auto__,G__39236),null));
}
}
});

c2.scale._log.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7043__auto__){
var self__ = this;
var this__7043__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$domain,self__.domain],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$range,self__.range],null))], null),self__.__extmap));
});

c2.scale._log.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7030__auto__,G__39236){
var self__ = this;
var this__7030__auto____$1 = this;
return (new c2.scale._log(self__.domain,self__.range,G__39236,self__.__extmap,self__.__hash));
});

c2.scale._log.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7036__auto__,entry__7037__auto__){
var self__ = this;
var this__7036__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7037__auto__)){
return cljs.core._assoc(this__7036__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7037__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7036__auto____$1,entry__7037__auto__);
}
});

c2.scale._log.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.log,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.log).call(null,x);
});

c2.scale._log.prototype.apply = (function (self__,args39239){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args39239)));
});

c2.scale._log.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var _ = this;
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,cljs.core.map.cljs$core$IFn$_invoke$arity$2(c2.maths.log,self__.domain),cljs.core.cst$kw$range,self__.range], 0)),c2.maths.log).call(null,x);
});

c2.scale._log.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$domain,cljs.core.cst$sym$range], null);
});

c2.scale._log.cljs$lang$type = true;

c2.scale._log.cljs$lang$ctorPrSeq = (function (this__7065__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"c2.scale/_log");
});

c2.scale._log.cljs$lang$ctorPrWriter = (function (this__7065__auto__,writer__7066__auto__){
return cljs.core._write(writer__7066__auto__,"c2.scale/_log");
});

c2.scale.__GT__log = (function c2$scale$__GT__log(domain,range){
return (new c2.scale._log(domain,range,null,null,null));
});

c2.scale.map__GT__log = (function c2$scale$map__GT__log(G__39238){
return (new c2.scale._log(cljs.core.cst$kw$domain.cljs$core$IFn$_invoke$arity$1(G__39238),cljs.core.cst$kw$range.cljs$core$IFn$_invoke$arity$1(G__39238),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39238,cljs.core.cst$kw$domain,cljs.core.array_seq([cljs.core.cst$kw$range], 0)),null));
});


c2.scale.log = (function c2$scale$log(var_args){
var args__7491__auto__ = [];
var len__7484__auto___39250 = arguments.length;
var i__7485__auto___39251 = (0);
while(true){
if((i__7485__auto___39251 < len__7484__auto___39250)){
args__7491__auto__.push((arguments[i__7485__auto___39251]));

var G__39252 = (i__7485__auto___39251 + (1));
i__7485__auto___39251 = G__39252;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

c2.scale.log.cljs$core$IFn$_invoke$arity$variadic = (function (kwargs){
return c2.scale.map__GT__log(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(10)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(1)], null)], null),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,kwargs)], 0)));
});

c2.scale.log.cljs$lang$maxFixedArity = (0);

c2.scale.log.cljs$lang$applyTo = (function (seq39248){
return c2.scale.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39248));
});

