// Compiled by ClojureScript 1.9.229 {}
goog.provide('c2.dom');
goog.require('cljs.core');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('singult.core');
goog.require('goog.style');
goog.require('clojure.string');
Element.prototype.matchesSelector = Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector;
if(cljs.core.truth_(typeof NodeList != "undefined")){
NodeList.prototype.cljs$core$ISeqable$ = true;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
} else {
}
HTMLCollection.prototype.cljs$core$ISeqable$ = true;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});

/**
 * @interface
 */
c2.dom.IDom = function(){};

/**
 * Converts x to a live DOM node
 */
c2.dom.__GT_dom = (function c2$dom$__GT_dom(x){
if((!((x == null))) && (!((x.c2$dom$IDom$__GT_dom$arity$1 == null)))){
return x.c2$dom$IDom$__GT_dom$arity$1(x);
} else {
var x__7072__auto__ = (((x == null))?null:x);
var m__7073__auto__ = (c2.dom.__GT_dom[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return m__7073__auto__.call(null,x);
} else {
var m__7073__auto____$1 = (c2.dom.__GT_dom["_"]);
if(!((m__7073__auto____$1 == null))){
return m__7073__auto____$1.call(null,x);
} else {
throw cljs.core.missing_protocol.call(null,"IDom.->dom",x);
}
}
}
});

(c2.dom.IDom["string"] = true);

(c2.dom.__GT_dom["string"] = (function (selector){
return c2.dom.select.call(null,selector);
}));

cljs.core.PersistentVector.prototype.c2$dom$IDom$ = true;

cljs.core.PersistentVector.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (v){
var v__$1 = this;
return singult.core.render.call(null,v__$1);
});
if(cljs.core.truth_(typeof Node != "undefined")){
Node.prototype.c2$dom$IDom$ = true;

Node.prototype.c2$dom$IDom$__GT_dom$arity$1 = (function (node){
var node__$1 = this;
return node__$1;
});
} else {
}
/**
 * Select a single DOM node via CSS selector, optionally scoped by second arg.
 */
c2.dom.select = (function c2$dom$select(var_args){
var args21624 = [];
var len__7484__auto___21627 = arguments.length;
var i__7485__auto___21628 = (0);
while(true){
if((i__7485__auto___21628 < len__7484__auto___21627)){
args21624.push((arguments[i__7485__auto___21628]));

var G__21629 = (i__7485__auto___21628 + (1));
i__7485__auto___21628 = G__21629;
continue;
} else {
}
break;
}

var G__21626 = args21624.length;
switch (G__21626) {
case 1:
return c2.dom.select.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21624.length)].join('')));

}
});

c2.dom.select.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelector(selector);
});

c2.dom.select.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelector(selector);
});

c2.dom.select.cljs$lang$maxFixedArity = 2;

/**
 * Like select, but returns a collection of nodes.
 */
c2.dom.select_all = (function c2$dom$select_all(var_args){
var args21631 = [];
var len__7484__auto___21634 = arguments.length;
var i__7485__auto___21635 = (0);
while(true){
if((i__7485__auto___21635 < len__7484__auto___21634)){
args21631.push((arguments[i__7485__auto___21635]));

var G__21636 = (i__7485__auto___21635 + (1));
i__7485__auto___21635 = G__21636;
continue;
} else {
}
break;
}

var G__21633 = args21631.length;
switch (G__21633) {
case 1:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.select_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21631.length)].join('')));

}
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return document.querySelectorAll(selector);
});

c2.dom.select_all.cljs$core$IFn$_invoke$arity$2 = (function (selector,container){
return c2.dom.__GT_dom.call(null,container).querySelectorAll(selector);
});

c2.dom.select_all.cljs$lang$maxFixedArity = 2;

/**
 * Does live `node` match CSS `selector`?
 */
c2.dom.matches_selector_QMARK_ = (function c2$dom$matches_selector_QMARK_(node,selector){
if(cljs.core.truth_(node)){
return node.matchesSelector(selector);
} else {
return null;
}
});
/**
 * Return the children of a live DOM element.
 */
c2.dom.children = (function c2$dom$children(node){
if(cljs.core.truth_(node)){
return c2.dom.__GT_dom.call(null,node).children;
} else {
return null;
}
});
/**
 * Return parent of a live DOM node.
 */
c2.dom.parent = (function c2$dom$parent(node){
if(cljs.core.truth_(c2$dom$parent)){
return c2.dom.__GT_dom.call(null,node).parentNode;
} else {
return null;
}
});
/**
 * Make element last child of container.
 * Returns live child.
 */
c2.dom.append_BANG_ = (function c2$dom$append_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.appendChild(c2.dom.__GT_dom.call(null,container),el__$1);

return el__$1;
});
/**
 * Make element first child of container.
 * Returns live DOM child.
 */
c2.dom.prepend_BANG_ = (function c2$dom$prepend_BANG_(container,el){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.insertChildAt(c2.dom.__GT_dom.call(null,container),el__$1,(0));

return el__$1;
});
/**
 * Remove element from DOM and return it.
 * > *el* CSS selector or live DOM node
 */
c2.dom.remove_BANG_ = (function c2$dom$remove_BANG_(el){
return goog.dom.removeNode(c2.dom.__GT_dom.call(null,el));
});
/**
 * Replace live DOM node with a new one, returning the latter.
 * > *old* CSS selector or live DOM node
 * > *new* CSS selector, live DOM node, or hiccup vector
 */
c2.dom.replace_BANG_ = (function c2$dom$replace_BANG_(old,new$){
var new$__$1 = c2.dom.__GT_dom.call(null,new$);
goog.dom.replaceNode(new$__$1,c2.dom.__GT_dom.call(null,old));

return new$__$1;
});
/**
 * Get or set inline element style.
 * 
 * `(style el)`                map of inline element styles
 * 
 * `(style el :keyword)`       value of style :keyword
 * 
 * `(style el {:keyword val})` sets inline style according to map, returns element
 * 
 * `(style el :keyword val)`   sets single style, returns element
 */
c2.dom.style = (function c2$dom$style(var_args){
var args21638 = [];
var len__7484__auto___21651 = arguments.length;
var i__7485__auto___21652 = (0);
while(true){
if((i__7485__auto___21652 < len__7484__auto___21651)){
args21638.push((arguments[i__7485__auto___21652]));

var G__21653 = (i__7485__auto___21652 + (1));
i__7485__auto___21652 = G__21653;
continue;
} else {
}
break;
}

var G__21640 = args21638.length;
switch (G__21640) {
case 1:
return c2.dom.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.style.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21638.length)].join('')));

}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$1 = (function (el){
throw (new Error("TODO: return map of element styles"));
});

c2.dom.style.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return goog.style.getComputedStyle(el__$1,cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__21641_21655 = cljs.core.seq.call(null,x);
var chunk__21642_21656 = null;
var count__21643_21657 = (0);
var i__21644_21658 = (0);
while(true){
if((i__21644_21658 < count__21643_21657)){
var vec__21645_21659 = cljs.core._nth.call(null,chunk__21642_21656,i__21644_21658);
var k_21660 = cljs.core.nth.call(null,vec__21645_21659,(0),null);
var v_21661 = cljs.core.nth.call(null,vec__21645_21659,(1),null);
c2.dom.style.call(null,el__$1,k_21660,v_21661);

var G__21662 = seq__21641_21655;
var G__21663 = chunk__21642_21656;
var G__21664 = count__21643_21657;
var G__21665 = (i__21644_21658 + (1));
seq__21641_21655 = G__21662;
chunk__21642_21656 = G__21663;
count__21643_21657 = G__21664;
i__21644_21658 = G__21665;
continue;
} else {
var temp__4657__auto___21666 = cljs.core.seq.call(null,seq__21641_21655);
if(temp__4657__auto___21666){
var seq__21641_21667__$1 = temp__4657__auto___21666;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21641_21667__$1)){
var c__7220__auto___21668 = cljs.core.chunk_first.call(null,seq__21641_21667__$1);
var G__21669 = cljs.core.chunk_rest.call(null,seq__21641_21667__$1);
var G__21670 = c__7220__auto___21668;
var G__21671 = cljs.core.count.call(null,c__7220__auto___21668);
var G__21672 = (0);
seq__21641_21655 = G__21669;
chunk__21642_21656 = G__21670;
count__21643_21657 = G__21671;
i__21644_21658 = G__21672;
continue;
} else {
var vec__21648_21673 = cljs.core.first.call(null,seq__21641_21667__$1);
var k_21674 = cljs.core.nth.call(null,vec__21648_21673,(0),null);
var v_21675 = cljs.core.nth.call(null,vec__21648_21673,(1),null);
c2.dom.style.call(null,el__$1,k_21674,v_21675);

var G__21676 = cljs.core.next.call(null,seq__21641_21667__$1);
var G__21677 = null;
var G__21678 = (0);
var G__21679 = (0);
seq__21641_21655 = G__21676;
chunk__21642_21656 = G__21677;
count__21643_21657 = G__21678;
i__21644_21658 = G__21679;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.style.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
goog.style.setStyle(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,k),((typeof v === 'string')?v:((typeof v === 'number')?(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"height","height",1025178622),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null).call(null,cljs.core.keyword.call(null,k)))?[cljs.core.str(v),cljs.core.str("px")].join(''):v):null)));

return el;
});

c2.dom.style.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element attributes.
 * 
 * `(attr el)`                map of element attributes
 * 
 * `(attr el :keyword)`       value of attr :keyword
 * 
 * `(attr el {:keyword val})` sets element attributes according to map, returns element
 * 
 * `(attr el :keyword val)`   sets single attr, returns element
 */
c2.dom.attr = (function c2$dom$attr(var_args){
var args21680 = [];
var len__7484__auto___21697 = arguments.length;
var i__7485__auto___21698 = (0);
while(true){
if((i__7485__auto___21698 < len__7484__auto___21697)){
args21680.push((arguments[i__7485__auto___21698]));

var G__21699 = (i__7485__auto___21698 + (1));
i__7485__auto___21698 = G__21699;
continue;
} else {
}
break;
}

var G__21682 = args21680.length;
switch (G__21682) {
case 1:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return c2.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21680.length)].join('')));

}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$1 = (function (el){
var attrs = c2.dom.__GT_dom.call(null,el).attributes;
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (attrs){
return (function c2$dom$iter__21683(s__21684){
return (new cljs.core.LazySeq(null,((function (attrs){
return (function (){
var s__21684__$1 = s__21684;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__21684__$1);
if(temp__4657__auto__){
var s__21684__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21684__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__21684__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__21686 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__21685 = (0);
while(true){
if((i__21685 < size__7188__auto__)){
var i = cljs.core._nth.call(null,c__7187__auto__,i__21685);
cljs.core.chunk_append.call(null,b__21686,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null));

var G__21701 = (i__21685 + (1));
i__21685 = G__21701;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21686),c2$dom$iter__21683.call(null,cljs.core.chunk_rest.call(null,s__21684__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21686),null);
}
} else {
var i = cljs.core.first.call(null,s__21684__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,(attrs[i]).name),(attrs[i]).value], null),c2$dom$iter__21683.call(null,cljs.core.rest.call(null,s__21684__$2)));
}
} else {
return null;
}
break;
}
});})(attrs))
,null,null));
});})(attrs))
;
return iter__7189__auto__.call(null,cljs.core.range.call(null,attrs.length));
})());
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,x){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((x instanceof cljs.core.Keyword)){
return el__$1.getAttribute(cljs.core.name.call(null,x));
} else {
if(cljs.core.map_QMARK_.call(null,x)){
var seq__21687_21702 = cljs.core.seq.call(null,x);
var chunk__21688_21703 = null;
var count__21689_21704 = (0);
var i__21690_21705 = (0);
while(true){
if((i__21690_21705 < count__21689_21704)){
var vec__21691_21706 = cljs.core._nth.call(null,chunk__21688_21703,i__21690_21705);
var k_21707 = cljs.core.nth.call(null,vec__21691_21706,(0),null);
var v_21708 = cljs.core.nth.call(null,vec__21691_21706,(1),null);
c2.dom.attr.call(null,el__$1,k_21707,v_21708);

var G__21709 = seq__21687_21702;
var G__21710 = chunk__21688_21703;
var G__21711 = count__21689_21704;
var G__21712 = (i__21690_21705 + (1));
seq__21687_21702 = G__21709;
chunk__21688_21703 = G__21710;
count__21689_21704 = G__21711;
i__21690_21705 = G__21712;
continue;
} else {
var temp__4657__auto___21713 = cljs.core.seq.call(null,seq__21687_21702);
if(temp__4657__auto___21713){
var seq__21687_21714__$1 = temp__4657__auto___21713;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21687_21714__$1)){
var c__7220__auto___21715 = cljs.core.chunk_first.call(null,seq__21687_21714__$1);
var G__21716 = cljs.core.chunk_rest.call(null,seq__21687_21714__$1);
var G__21717 = c__7220__auto___21715;
var G__21718 = cljs.core.count.call(null,c__7220__auto___21715);
var G__21719 = (0);
seq__21687_21702 = G__21716;
chunk__21688_21703 = G__21717;
count__21689_21704 = G__21718;
i__21690_21705 = G__21719;
continue;
} else {
var vec__21694_21720 = cljs.core.first.call(null,seq__21687_21714__$1);
var k_21721 = cljs.core.nth.call(null,vec__21694_21720,(0),null);
var v_21722 = cljs.core.nth.call(null,vec__21694_21720,(1),null);
c2.dom.attr.call(null,el__$1,k_21721,v_21722);

var G__21723 = cljs.core.next.call(null,seq__21687_21714__$1);
var G__21724 = null;
var G__21725 = (0);
var G__21726 = (0);
seq__21687_21702 = G__21723;
chunk__21688_21703 = G__21724;
count__21689_21704 = G__21725;
i__21690_21705 = G__21726;
continue;
}
} else {
}
}
break;
}

return el__$1;
} else {
return null;
}
}
});

c2.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,k,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
if((v == null)){
el__$1.removeAttribute(cljs.core.name.call(null,k));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"style","style",-496642736),k)){
c2.dom.style.call(null,el__$1,v);
} else {
el__$1.setAttribute(cljs.core.name.call(null,k),v);
}
}

return el__$1;
});

c2.dom.attr.cljs$lang$maxFixedArity = 3;

/**
 * Get or set element text, returning element
 */
c2.dom.text = (function c2$dom$text(var_args){
var args21727 = [];
var len__7484__auto___21730 = arguments.length;
var i__7485__auto___21731 = (0);
while(true){
if((i__7485__auto___21731 < len__7484__auto___21730)){
args21727.push((arguments[i__7485__auto___21731]));

var G__21732 = (i__7485__auto___21731 + (1));
i__7485__auto___21731 = G__21732;
continue;
} else {
}
break;
}

var G__21729 = args21727.length;
switch (G__21729) {
case 1:
return c2.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21727.length)].join('')));

}
});

c2.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.getTextContent(c2.dom.__GT_dom.call(null,el));
});

c2.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.setTextContent(el__$1,v);

return el__$1;
});

c2.dom.text.cljs$lang$maxFixedArity = 2;

/**
 * Get or set element value.
 */
c2.dom.val = (function c2$dom$val(var_args){
var args21734 = [];
var len__7484__auto___21737 = arguments.length;
var i__7485__auto___21738 = (0);
while(true){
if((i__7485__auto___21738 < len__7484__auto___21737)){
args21734.push((arguments[i__7485__auto___21738]));

var G__21739 = (i__7485__auto___21738 + (1));
i__7485__auto___21738 = G__21739;
continue;
} else {
}
break;
}

var G__21736 = args21734.length;
switch (G__21736) {
case 1:
return c2.dom.val.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return c2.dom.val.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21734.length)].join('')));

}
});

c2.dom.val.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.forms.getValue(c2.dom.__GT_dom.call(null,el));
});

c2.dom.val.cljs$core$IFn$_invoke$arity$2 = (function (el,v){
var el__$1 = c2.dom.__GT_dom.call(null,el);
goog.dom.forms.setValue(el__$1,v);

return el__$1;
});

c2.dom.val.cljs$lang$maxFixedArity = 2;

/**
 * Add or remove `class` to element based on boolean `classed?`, returning element.
 */
c2.dom.classed_BANG_ = (function c2$dom$classed_BANG_(el,class$,classed_QMARK_){
goog.dom.classes.enable(c2.dom.__GT_dom.call(null,el),cljs.core.name.call(null,class$),classed_QMARK_);

return el;
});
c2.dom.add_class_BANG_ = (function c2$dom$add_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,true);
});
c2.dom.remove_class_BANG_ = (function c2$dom$remove_class_BANG_(el,class$){
return c2.dom.classed_BANG_.call(null,el,class$,false);
});
c2.dom.request_animation_frame = (function (){var or__6409__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return ((function (or__6409__auto____$1,or__6409__auto__){
return (function (p1__21741_SHARP_){
return setTimeout(((function (or__6409__auto____$1,or__6409__auto__){
return (function (){
return p1__21741_SHARP_.call(null);
});})(or__6409__auto____$1,or__6409__auto__))
,(10));
});
;})(or__6409__auto____$1,or__6409__auto__))
}
}
})();
