// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),true))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__25327_SHARP_){
if(typeof p1__25327_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__25327_SHARP_);
} else {
return p1__25327_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__25333){
var vec__25334 = p__25333;
var fname = cljs.core.nth.call(null,vec__25334,(0),null);
var answer = cljs.core.nth.call(null,vec__25334,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__25328_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__25328_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var media_count = (dataContext["_media_count"]);
var total_media = (dataContext["_total_media"]);
return hatti.ona.forms.format_answer.call(null,field,chimera.string.escape_for_type.call(null,clj_value),new cljs.core.Keyword(null,"language","language",-1591107564),language,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true,new cljs.core.Keyword(null,"field-key","field-key",313262601),field_key,new cljs.core.Keyword(null,"media-count","media-count",1579124405),media_count,new cljs.core.Keyword(null,"total-media","total-media",1031250100),total_media);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__25337 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__25337__$1 = ((((!((map__25337 == null)))?((((map__25337.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25337.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25337):map__25337);
var owner__$1 = cljs.core.get.call(null,map__25337__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__25337__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__25337__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input.delete-record","input.delete-record",-1708576930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip.middle-right","li.tooltip.middle-right",-548323211),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-eye","i.fa.fa-eye",-1428531423),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil","i.fa.fa-pencil",1547895857)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
cljs.core._add_method.call(null,hatti.views.actions_column,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
}));
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___25366 = arguments.length;
var i__7485__auto___25367 = (0);
while(true){
if((i__7485__auto___25367 < len__7484__auto___25366)){
args__7491__auto__.push((arguments[i__7485__auto___25367]));

var G__25368 = (i__7485__auto___25367 + (1));
i__7485__auto___25367 = G__25368;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__25342){
var map__25343 = p__25342;
var map__25343__$1 = ((((!((map__25343 == null)))?((((map__25343.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25343.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25343):map__25343);
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25343__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var get_label_QMARK_ = cljs.core.get.call(null,map__25343__$1,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),true);
var language = cljs.core.get.call(null,map__25343__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var owner = cljs.core.get.call(null,map__25343__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = chimera.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__25343,map__25343__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__25339_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__25339_SHARP_)) == null);
});})(map__25343,map__25343__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__25343,map__25343__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__25345(s__25346){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__25343,map__25343__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__25346__$1 = s__25346;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25346__$1);
if(temp__4657__auto__){
var s__25346__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25346__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25346__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25348 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25347 = (0);
while(true){
if((i__25347 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__25347);
cljs.core.chunk_append.call(null,b__25348,(function (){var map__25357 = field;
var map__25357__$1 = ((((!((map__25357 == null)))?((((map__25357.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25357.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25357):map__25357);
var map__25358 = cljs.core.get.call(null,map__25357__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25358__$1 = ((((!((map__25358 == null)))?((((map__25358.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25358.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25358):map__25358);
var hxl = cljs.core.get.call(null,map__25358__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25357__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25357__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25357__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__25369 = (i__25347 + (1));
i__25347 = G__25369;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25348),hatti$views$table$iter__25345.call(null,cljs.core.chunk_rest.call(null,s__25346__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25348),null);
}
} else {
var field = cljs.core.first.call(null,s__25346__$2);
return cljs.core.cons.call(null,(function (){var map__25361 = field;
var map__25361__$1 = ((((!((map__25361 == null)))?((((map__25361.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25361.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25361):map__25361);
var map__25362 = cljs.core.get.call(null,map__25361__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25362__$1 = ((((!((map__25362 == null)))?((((map__25362.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25362.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25362):map__25362);
var hxl = cljs.core.get.call(null,map__25362__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25361__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25361__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25361__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__25345.call(null,cljs.core.rest.call(null,s__25346__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__25343,map__25343__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__25343,map__25343__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__.call(null,hatti.views.table.all_fields.call(null,form));
})();
return cljs.core.clj__GT_js.call(null,(function (){var G__25365 = columns;
if(cljs.core.not.call(null,hide_actions_column_QMARK_)){
return cljs.core.conj.call(null,G__25365,hatti.views.actions_column.call(null,owner,has_hxl_QMARK_));
} else {
return G__25365;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq25340){
var G__25341 = cljs.core.first.call(null,seq25340);
var seq25340__$1 = cljs.core.next.call(null,seq25340);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__25341,seq25340__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25386(s__25387){
return (new cljs.core.LazySeq(null,(function (){
var s__25387__$1 = s__25387;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25387__$1);
if(temp__4657__auto__){
var s__25387__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25387__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25387__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25389 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25388 = (0);
while(true){
if((i__25388 < size__7188__auto__)){
var vec__25396 = cljs.core._nth.call(null,c__7187__auto__,i__25388);
var handler_key = cljs.core.nth.call(null,vec__25396,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25396,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__25389,event.subscribe(handler_function));

var G__25402 = (i__25388 + (1));
i__25388 = G__25402;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25389),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25386.call(null,cljs.core.chunk_rest.call(null,s__25387__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25389),null);
}
} else {
var vec__25399 = cljs.core.first.call(null,s__25387__$2);
var handler_key = cljs.core.nth.call(null,vec__25399,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25399,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25386.call(null,cljs.core.rest.call(null,s__25387__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25419(s__25420){
return (new cljs.core.LazySeq(null,(function (){
var s__25420__$1 = s__25420;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25420__$1);
if(temp__4657__auto__){
var s__25420__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25420__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25420__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25422 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25421 = (0);
while(true){
if((i__25421 < size__7188__auto__)){
var vec__25429 = cljs.core._nth.call(null,c__7187__auto__,i__25421);
var handler_key = cljs.core.nth.call(null,vec__25429,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25429,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__25422,event.subscribe(handler_function));

var G__25435 = (i__25421 + (1));
i__25421 = G__25435;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25422),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25419.call(null,cljs.core.chunk_rest.call(null,s__25420__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25422),null);
}
} else {
var vec__25432 = cljs.core.first.call(null,s__25420__$2);
var handler_key = cljs.core.nth.call(null,vec__25432,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25432,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25419.call(null,cljs.core.rest.call(null,s__25420__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__25438 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25438__$1 = ((((!((map__25438 == null)))?((((map__25438.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25438.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25438):map__25438);
var data_to_be_deleted = cljs.core.get.call(null,map__25438__$1,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634));
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634)], null),((function (map__25438,map__25438__$1,data_to_be_deleted,fn){
return (function (){
return fn.call(null,data_to_be_deleted,data_id);
});})(map__25438,map__25438__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,[cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.call(null,selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector.call(null,data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__25444 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
var chunk__25445 = null;
var count__25446 = (0);
var i__25447 = (0);
while(true){
if((i__25447 < count__25446)){
var data_id = cljs.core._nth.call(null,chunk__25445,i__25447);
var element_25448 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25448.checked = true;

var G__25449 = seq__25444;
var G__25450 = chunk__25445;
var G__25451 = count__25446;
var G__25452 = (i__25447 + (1));
seq__25444 = G__25449;
chunk__25445 = G__25450;
count__25446 = G__25451;
i__25447 = G__25452;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__25444);
if(temp__4657__auto__){
var seq__25444__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25444__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__25444__$1);
var G__25453 = cljs.core.chunk_rest.call(null,seq__25444__$1);
var G__25454 = c__7220__auto__;
var G__25455 = cljs.core.count.call(null,c__7220__auto__);
var G__25456 = (0);
seq__25444 = G__25453;
chunk__25445 = G__25454;
count__25446 = G__25455;
i__25447 = G__25456;
continue;
} else {
var data_id = cljs.core.first.call(null,seq__25444__$1);
var element_25457 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25457.checked = true;

var G__25458 = cljs.core.next.call(null,seq__25444__$1);
var G__25459 = null;
var G__25460 = (0);
var G__25461 = (0);
seq__25444 = G__25458;
chunk__25445 = G__25459;
count__25446 = G__25460;
i__25447 = G__25461;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map_indexed.call(null,((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity.call(null,indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,indexes_of_selected_checkboxes));
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__25462){
var map__25477 = p__25462;
var map__25477__$1 = ((((!((map__25477 == null)))?((((map__25477.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25477.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25477):map__25477);
var grid_event_handlers = cljs.core.get.call(null,map__25477__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__25477__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var map__25479 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25479__$1 = ((((!((map__25479 == null)))?((((map__25479.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25479.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25479):map__25479);
var map__25480 = cljs.core.get.call(null,map__25479__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25480__$1 = ((((!((map__25480 == null)))?((((map__25480.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25480.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25480):map__25480);
var map__25481 = cljs.core.get.call(null,map__25480__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__25481__$1 = ((((!((map__25481 == null)))?((((map__25481.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25481.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25481):map__25481);
var num_displayed_records = cljs.core.get.call(null,map__25481__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__25481__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25480__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,new cljs.core.Keyword(null,"language","language",-1591107564),current_language,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),hide_actions_column_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selectActiveRow","selectActiveRow",-841772687),false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted.call(null);

return hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
});})(map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
if(cljs.core._EQ_.call(null,hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__25485_25491 = cljs.core.seq.call(null,records_to_be_deleted);
var chunk__25486_25492 = null;
var count__25487_25493 = (0);
var i__25488_25494 = (0);
while(true){
if((i__25488_25494 < count__25487_25493)){
var record_25495 = cljs.core._nth.call(null,chunk__25486_25492,i__25488_25494);
record_25495.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25495.getAttribute("data-id")));

var G__25496 = seq__25485_25491;
var G__25497 = chunk__25486_25492;
var G__25498 = count__25487_25493;
var G__25499 = (i__25488_25494 + (1));
seq__25485_25491 = G__25496;
chunk__25486_25492 = G__25497;
count__25487_25493 = G__25498;
i__25488_25494 = G__25499;
continue;
} else {
var temp__4657__auto___25500 = cljs.core.seq.call(null,seq__25485_25491);
if(temp__4657__auto___25500){
var seq__25485_25501__$1 = temp__4657__auto___25500;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25485_25501__$1)){
var c__7220__auto___25502 = cljs.core.chunk_first.call(null,seq__25485_25501__$1);
var G__25503 = cljs.core.chunk_rest.call(null,seq__25485_25501__$1);
var G__25504 = c__7220__auto___25502;
var G__25505 = cljs.core.count.call(null,c__7220__auto___25502);
var G__25506 = (0);
seq__25485_25491 = G__25503;
chunk__25486_25492 = G__25504;
count__25487_25493 = G__25505;
i__25488_25494 = G__25506;
continue;
} else {
var record_25507 = cljs.core.first.call(null,seq__25485_25501__$1);
record_25507.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25507.getAttribute("data-id")));

var G__25508 = cljs.core.next.call(null,seq__25485_25501__$1);
var G__25509 = null;
var G__25510 = (0);
var G__25511 = (0);
seq__25485_25491 = G__25508;
chunk__25486_25492 = G__25509;
count__25487_25493 = G__25510;
i__25488_25494 = G__25511;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.call(null,total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
return null;
}
});})(map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__25489 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25489__$1 = ((((!((map__25489 == null)))?((((map__25489.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25489.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25489):map__25489);
var selected_table_rows = cljs.core.get.call(null,map__25489__$1,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745));
if(cljs.core._EQ_.call(null,class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = parseInt(grid.getCellFromEvent(e).row);
hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_.call(null);

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25489,map__25489__$1,selected_table_rows,map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return fn.call(null,selected_table_rows,row__$1);
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25489,map__25489__$1,selected_table_rows,map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
}
});})(map__25479,map__25479__$1,map__25480,map__25480__$1,map__25481,map__25481__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25477,map__25477__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__13216__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,event_chan){
return (function (state_25803){
var state_val_25804 = (state_25803[(1)]);
if((state_val_25804 === (7))){
var inst_25701 = (state_25803[(7)]);
var inst_25701__$1 = (state_25803[(2)]);
var inst_25703 = (inst_25701__$1 == null);
var inst_25704 = cljs.core.not.call(null,inst_25703);
var state_25803__$1 = (function (){var statearr_25805 = state_25803;
(statearr_25805[(7)] = inst_25701__$1);

return statearr_25805;
})();
if(inst_25704){
var statearr_25806_25881 = state_25803__$1;
(statearr_25806_25881[(1)] = (8));

} else {
var statearr_25807_25882 = state_25803__$1;
(statearr_25807_25882[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (20))){
var inst_25731 = (state_25803[(8)]);
var inst_25723 = (state_25803[(9)]);
var inst_25740 = inst_25731.call(null,inst_25723);
var state_25803__$1 = state_25803;
var statearr_25808_25883 = state_25803__$1;
(statearr_25808_25883[(2)] = inst_25740);

(statearr_25808_25883[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (27))){
var state_25803__$1 = state_25803;
var statearr_25809_25884 = state_25803__$1;
(statearr_25809_25884[(2)] = null);

(statearr_25809_25884[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (1))){
var state_25803__$1 = state_25803;
var statearr_25810_25885 = state_25803__$1;
(statearr_25810_25885[(2)] = null);

(statearr_25810_25885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (24))){
var state_25803__$1 = state_25803;
var statearr_25811_25886 = state_25803__$1;
(statearr_25811_25886[(2)] = null);

(statearr_25811_25886[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (4))){
var state_25803__$1 = state_25803;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25803__$1,(7),event_chan);
} else {
if((state_val_25804 === (15))){
var inst_25701 = (state_25803[(7)]);
var state_25803__$1 = state_25803;
var statearr_25812_25887 = state_25803__$1;
(statearr_25812_25887[(2)] = inst_25701);

(statearr_25812_25887[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (21))){
var state_25803__$1 = state_25803;
var statearr_25813_25888 = state_25803__$1;
(statearr_25813_25888[(2)] = null);

(statearr_25813_25888[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (31))){
var inst_25727 = (state_25803[(10)]);
var inst_25776 = (state_25803[(2)]);
var inst_25777 = cljs.core._EQ_.call(null,inst_25727,new cljs.core.Keyword(null,"table","table",-564943036));
var state_25803__$1 = (function (){var statearr_25814 = state_25803;
(statearr_25814[(11)] = inst_25776);

return statearr_25814;
})();
if(inst_25777){
var statearr_25815_25889 = state_25803__$1;
(statearr_25815_25889[(1)] = (32));

} else {
var statearr_25816_25890 = state_25803__$1;
(statearr_25816_25890[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (32))){
var inst_25731 = (state_25803[(8)]);
var inst_25724 = (state_25803[(12)]);
var inst_25725 = (state_25803[(13)]);
var inst_25721 = (state_25803[(14)]);
var inst_25727 = (state_25803[(10)]);
var inst_25732 = (state_25803[(15)]);
var inst_25723 = (state_25803[(9)]);
var inst_25726 = (state_25803[(16)]);
var inst_25722 = (state_25803[(17)]);
var inst_25790 = cljs.core.async.chan.call(null,(1));
var inst_25791 = (function (){var new_columns = inst_25726;
var submission_clicked = inst_25723;
var submission_unclicked = inst_25724;
var get_submission_data = inst_25732;
var re_render = inst_25727;
var update_data_BANG_ = inst_25731;
var submission_to_rank = inst_25722;
var map__25699 = inst_25721;
var c__13216__auto____$1 = inst_25790;
var filter_by = inst_25725;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25790,state_val_25804,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25790,state_val_25804,c__13216__auto__,event_chan){
return (function (state_25788){
var state_val_25789 = (state_25788[(1)]);
if((state_val_25789 === (1))){
var inst_25779 = cljs.core.async.timeout.call(null,(20));
var state_25788__$1 = state_25788;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25788__$1,(2),inst_25779);
} else {
if((state_val_25789 === (2))){
var inst_25781 = (state_25788[(2)]);
var inst_25782 = grid.resizeCanvas();
var inst_25783 = grid.invalidateAllRows();
var inst_25784 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25785 = grid.render();
var inst_25786 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_25788__$1 = (function (){var statearr_25817 = state_25788;
(statearr_25817[(7)] = inst_25781);

(statearr_25817[(8)] = inst_25783);

(statearr_25817[(9)] = inst_25784);

(statearr_25817[(10)] = inst_25785);

(statearr_25817[(11)] = inst_25782);

return statearr_25817;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25788__$1,inst_25786);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25790,state_val_25804,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25790,state_val_25804,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_25821 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25821[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_25821[(1)] = (1));

return statearr_25821;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_25788){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_25788);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e25822){if((e25822 instanceof Object)){
var ex__13108__auto__ = e25822;
var statearr_25823_25891 = state_25788;
(statearr_25823_25891[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25788);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25822;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25892 = state_25788;
state_25788 = G__25892;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_25788){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_25788);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25790,state_val_25804,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_25824 = f__13217__auto__.call(null);
(statearr_25824[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_25824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25790,state_val_25804,c__13216__auto__,event_chan))
})();
var inst_25792 = cljs.core.async.impl.dispatch.run.call(null,inst_25791);
var state_25803__$1 = (function (){var statearr_25825 = state_25803;
(statearr_25825[(18)] = inst_25792);

return statearr_25825;
})();
var statearr_25826_25893 = state_25803__$1;
(statearr_25826_25893[(2)] = inst_25790);

(statearr_25826_25893[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (33))){
var state_25803__$1 = state_25803;
var statearr_25827_25894 = state_25803__$1;
(statearr_25827_25894[(2)] = null);

(statearr_25827_25894[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (13))){
var inst_25713 = (state_25803[(2)]);
var state_25803__$1 = state_25803;
var statearr_25828_25895 = state_25803__$1;
(statearr_25828_25895[(2)] = inst_25713);

(statearr_25828_25895[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (22))){
var inst_25724 = (state_25803[(12)]);
var inst_25743 = (state_25803[(2)]);
var state_25803__$1 = (function (){var statearr_25829 = state_25803;
(statearr_25829[(19)] = inst_25743);

return statearr_25829;
})();
if(cljs.core.truth_(inst_25724)){
var statearr_25830_25896 = state_25803__$1;
(statearr_25830_25896[(1)] = (23));

} else {
var statearr_25831_25897 = state_25803__$1;
(statearr_25831_25897[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (29))){
var inst_25725 = (state_25803[(13)]);
var inst_25768 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_25769 = [inst_25725];
var inst_25770 = cljs.core.PersistentHashMap.fromArrays(inst_25768,inst_25769);
var inst_25771 = cljs.core.clj__GT_js.call(null,inst_25770);
var inst_25772 = dataview.setFilterArgs(inst_25771);
var inst_25773 = dataview.refresh();
var state_25803__$1 = (function (){var statearr_25832 = state_25803;
(statearr_25832[(20)] = inst_25772);

return statearr_25832;
})();
var statearr_25833_25898 = state_25803__$1;
(statearr_25833_25898[(2)] = inst_25773);

(statearr_25833_25898[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (6))){
var inst_25799 = (state_25803[(2)]);
var state_25803__$1 = state_25803;
var statearr_25834_25899 = state_25803__$1;
(statearr_25834_25899[(2)] = inst_25799);

(statearr_25834_25899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (28))){
var inst_25725 = (state_25803[(13)]);
var inst_25766 = (state_25803[(2)]);
var state_25803__$1 = (function (){var statearr_25835 = state_25803;
(statearr_25835[(21)] = inst_25766);

return statearr_25835;
})();
if(cljs.core.truth_(inst_25725)){
var statearr_25836_25900 = state_25803__$1;
(statearr_25836_25900[(1)] = (29));

} else {
var statearr_25837_25901 = state_25803__$1;
(statearr_25837_25901[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (25))){
var inst_25726 = (state_25803[(16)]);
var inst_25748 = (state_25803[(2)]);
var state_25803__$1 = (function (){var statearr_25838 = state_25803;
(statearr_25838[(22)] = inst_25748);

return statearr_25838;
})();
if(cljs.core.truth_(inst_25726)){
var statearr_25839_25902 = state_25803__$1;
(statearr_25839_25902[(1)] = (26));

} else {
var statearr_25840_25903 = state_25803__$1;
(statearr_25840_25903[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (34))){
var inst_25795 = (state_25803[(2)]);
var state_25803__$1 = (function (){var statearr_25841 = state_25803;
(statearr_25841[(23)] = inst_25795);

return statearr_25841;
})();
var statearr_25842_25904 = state_25803__$1;
(statearr_25842_25904[(2)] = null);

(statearr_25842_25904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (17))){
var inst_25731 = (state_25803[(8)]);
var inst_25732 = (state_25803[(15)]);
var inst_25722 = (state_25803[(17)]);
var inst_25734 = inst_25732.call(null,hatti.constants._rank,inst_25722);
var inst_25735 = inst_25731.call(null,inst_25734);
var state_25803__$1 = state_25803;
var statearr_25843_25905 = state_25803__$1;
(statearr_25843_25905[(2)] = inst_25735);

(statearr_25843_25905[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (3))){
var inst_25801 = (state_25803[(2)]);
var state_25803__$1 = state_25803;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25803__$1,inst_25801);
} else {
if((state_val_25804 === (12))){
var state_25803__$1 = state_25803;
var statearr_25844_25906 = state_25803__$1;
(statearr_25844_25906[(2)] = false);

(statearr_25844_25906[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (2))){
var state_25803__$1 = state_25803;
var statearr_25845_25907 = state_25803__$1;
(statearr_25845_25907[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (23))){
var inst_25731 = (state_25803[(8)]);
var inst_25745 = inst_25731.call(null,null);
var state_25803__$1 = state_25803;
var statearr_25847_25908 = state_25803__$1;
(statearr_25847_25908[(2)] = inst_25745);

(statearr_25847_25908[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (19))){
var inst_25723 = (state_25803[(9)]);
var inst_25738 = (state_25803[(2)]);
var state_25803__$1 = (function (){var statearr_25848 = state_25803;
(statearr_25848[(24)] = inst_25738);

return statearr_25848;
})();
if(cljs.core.truth_(inst_25723)){
var statearr_25849_25909 = state_25803__$1;
(statearr_25849_25909[(1)] = (20));

} else {
var statearr_25850_25910 = state_25803__$1;
(statearr_25850_25910[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (11))){
var state_25803__$1 = state_25803;
var statearr_25851_25911 = state_25803__$1;
(statearr_25851_25911[(2)] = true);

(statearr_25851_25911[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (9))){
var state_25803__$1 = state_25803;
var statearr_25852_25912 = state_25803__$1;
(statearr_25852_25912[(2)] = false);

(statearr_25852_25912[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (5))){
var state_25803__$1 = state_25803;
var statearr_25853_25913 = state_25803__$1;
(statearr_25853_25913[(2)] = null);

(statearr_25853_25913[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (14))){
var inst_25701 = (state_25803[(7)]);
var inst_25718 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25701);
var state_25803__$1 = state_25803;
var statearr_25854_25914 = state_25803__$1;
(statearr_25854_25914[(2)] = inst_25718);

(statearr_25854_25914[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (26))){
var inst_25731 = (state_25803[(8)]);
var inst_25724 = (state_25803[(12)]);
var inst_25725 = (state_25803[(13)]);
var inst_25721 = (state_25803[(14)]);
var inst_25727 = (state_25803[(10)]);
var inst_25732 = (state_25803[(15)]);
var inst_25723 = (state_25803[(9)]);
var inst_25726 = (state_25803[(16)]);
var inst_25722 = (state_25803[(17)]);
var inst_25761 = cljs.core.async.chan.call(null,(1));
var inst_25762 = (function (){var new_columns = inst_25726;
var submission_clicked = inst_25723;
var submission_unclicked = inst_25724;
var get_submission_data = inst_25732;
var re_render = inst_25727;
var update_data_BANG_ = inst_25731;
var submission_to_rank = inst_25722;
var map__25699 = inst_25721;
var c__13216__auto____$1 = inst_25761;
var filter_by = inst_25725;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25761,state_val_25804,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25761,state_val_25804,c__13216__auto__,event_chan){
return (function (state_25759){
var state_val_25760 = (state_25759[(1)]);
if((state_val_25760 === (1))){
var inst_25750 = cljs.core.async.timeout.call(null,(20));
var state_25759__$1 = state_25759;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25759__$1,(2),inst_25750);
} else {
if((state_val_25760 === (2))){
var inst_25752 = (state_25759[(2)]);
var inst_25753 = grid.setColumns(new_columns);
var inst_25754 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25755 = grid.render();
var inst_25756 = hatti.views.table.select_rows_marked_to_be_deleted.call(null);
var inst_25757 = hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
var state_25759__$1 = (function (){var statearr_25855 = state_25759;
(statearr_25855[(7)] = inst_25756);

(statearr_25855[(8)] = inst_25755);

(statearr_25855[(9)] = inst_25753);

(statearr_25855[(10)] = inst_25752);

(statearr_25855[(11)] = inst_25754);

return statearr_25855;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25759__$1,inst_25757);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25761,state_val_25804,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25761,state_val_25804,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_25859 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25859[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_25859[(1)] = (1));

return statearr_25859;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_25759){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_25759);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e25860){if((e25860 instanceof Object)){
var ex__13108__auto__ = e25860;
var statearr_25861_25915 = state_25759;
(statearr_25861_25915[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25759);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25860;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25916 = state_25759;
state_25759 = G__25916;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_25759){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_25759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25761,state_val_25804,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_25862 = f__13217__auto__.call(null);
(statearr_25862[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_25862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__25699,c__13216__auto____$1,filter_by,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25732,inst_25723,inst_25726,inst_25722,inst_25761,state_val_25804,c__13216__auto__,event_chan))
})();
var inst_25763 = cljs.core.async.impl.dispatch.run.call(null,inst_25762);
var state_25803__$1 = (function (){var statearr_25863 = state_25803;
(statearr_25863[(25)] = inst_25763);

return statearr_25863;
})();
var statearr_25864_25917 = state_25803__$1;
(statearr_25864_25917[(2)] = inst_25761);

(statearr_25864_25917[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (16))){
var inst_25731 = (state_25803[(8)]);
var inst_25724 = (state_25803[(12)]);
var inst_25725 = (state_25803[(13)]);
var inst_25721 = (state_25803[(14)]);
var inst_25727 = (state_25803[(10)]);
var inst_25723 = (state_25803[(9)]);
var inst_25726 = (state_25803[(16)]);
var inst_25722 = (state_25803[(17)]);
var inst_25721__$1 = (state_25803[(2)]);
var inst_25722__$1 = cljs.core.get.call(null,inst_25721__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_25723__$1 = cljs.core.get.call(null,inst_25721__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_25724__$1 = cljs.core.get.call(null,inst_25721__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_25725__$1 = cljs.core.get.call(null,inst_25721__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_25726__$1 = cljs.core.get.call(null,inst_25721__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_25727__$1 = cljs.core.get.call(null,inst_25721__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_25728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25729 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_25730 = (new cljs.core.PersistentVector(null,3,(5),inst_25728,inst_25729,null));
var inst_25731__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_25730);
var inst_25732 = (function (){var map__25699 = inst_25721__$1;
var submission_to_rank = inst_25722__$1;
var submission_clicked = inst_25723__$1;
var submission_unclicked = inst_25724__$1;
var filter_by = inst_25725__$1;
var new_columns = inst_25726__$1;
var re_render = inst_25727__$1;
var update_data_BANG_ = inst_25731__$1;
return ((function (map__25699,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25723,inst_25726,inst_25722,inst_25721__$1,inst_25722__$1,inst_25723__$1,inst_25724__$1,inst_25725__$1,inst_25726__$1,inst_25727__$1,inst_25728,inst_25729,inst_25730,inst_25731__$1,state_val_25804,c__13216__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__25699,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25723,inst_25726,inst_25722,inst_25721__$1,inst_25722__$1,inst_25723__$1,inst_25724__$1,inst_25725__$1,inst_25726__$1,inst_25727__$1,inst_25728,inst_25729,inst_25730,inst_25731__$1,state_val_25804,c__13216__auto__,event_chan){
return (function (p1__25512_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__25512_SHARP_,field));
});})(map__25699,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25723,inst_25726,inst_25722,inst_25721__$1,inst_25722__$1,inst_25723__$1,inst_25724__$1,inst_25725__$1,inst_25726__$1,inst_25727__$1,inst_25728,inst_25729,inst_25730,inst_25731__$1,state_val_25804,c__13216__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(map__25699,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25731,inst_25724,inst_25725,inst_25721,inst_25727,inst_25723,inst_25726,inst_25722,inst_25721__$1,inst_25722__$1,inst_25723__$1,inst_25724__$1,inst_25725__$1,inst_25726__$1,inst_25727__$1,inst_25728,inst_25729,inst_25730,inst_25731__$1,state_val_25804,c__13216__auto__,event_chan))
})();
var state_25803__$1 = (function (){var statearr_25865 = state_25803;
(statearr_25865[(8)] = inst_25731__$1);

(statearr_25865[(12)] = inst_25724__$1);

(statearr_25865[(13)] = inst_25725__$1);

(statearr_25865[(14)] = inst_25721__$1);

(statearr_25865[(10)] = inst_25727__$1);

(statearr_25865[(15)] = inst_25732);

(statearr_25865[(9)] = inst_25723__$1);

(statearr_25865[(16)] = inst_25726__$1);

(statearr_25865[(17)] = inst_25722__$1);

return statearr_25865;
})();
if(cljs.core.truth_(inst_25722__$1)){
var statearr_25866_25918 = state_25803__$1;
(statearr_25866_25918[(1)] = (17));

} else {
var statearr_25867_25919 = state_25803__$1;
(statearr_25867_25919[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (30))){
var state_25803__$1 = state_25803;
var statearr_25868_25920 = state_25803__$1;
(statearr_25868_25920[(2)] = null);

(statearr_25868_25920[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (10))){
var inst_25716 = (state_25803[(2)]);
var state_25803__$1 = state_25803;
if(cljs.core.truth_(inst_25716)){
var statearr_25869_25921 = state_25803__$1;
(statearr_25869_25921[(1)] = (14));

} else {
var statearr_25870_25922 = state_25803__$1;
(statearr_25870_25922[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (18))){
var state_25803__$1 = state_25803;
var statearr_25871_25923 = state_25803__$1;
(statearr_25871_25923[(2)] = null);

(statearr_25871_25923[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25804 === (8))){
var inst_25701 = (state_25803[(7)]);
var inst_25706 = inst_25701.cljs$lang$protocol_mask$partition0$;
var inst_25707 = (inst_25706 & (64));
var inst_25708 = inst_25701.cljs$core$ISeq$;
var inst_25709 = (inst_25707) || (inst_25708);
var state_25803__$1 = state_25803;
if(cljs.core.truth_(inst_25709)){
var statearr_25872_25924 = state_25803__$1;
(statearr_25872_25924[(1)] = (11));

} else {
var statearr_25873_25925 = state_25803__$1;
(statearr_25873_25925[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_25877 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25877[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_25877[(1)] = (1));

return statearr_25877;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_25803){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_25803);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e25878){if((e25878 instanceof Object)){
var ex__13108__auto__ = e25878;
var statearr_25879_25926 = state_25803;
(statearr_25879_25926[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25803);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25878;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25927 = state_25803;
state_25803 = G__25927;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_25803){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_25803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_25880 = f__13217__auto__.call(null);
(statearr_25880[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_25880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto__,event_chan))
);

return c__13216__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"field-key","field-key",313262601),k);

return colset_BANG_.call(null,k);
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__25944(s__25945){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__25945__$1 = s__25945;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25945__$1);
if(temp__4657__auto__){
var s__25945__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25945__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25945__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25947 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25946 = (0);
while(true){
if((i__25946 < size__7188__auto__)){
var vec__25954 = cljs.core._nth.call(null,c__7187__auto__,i__25946);
var k = cljs.core.nth.call(null,vec__25954,(0),null);
var v = cljs.core.nth.call(null,vec__25954,(1),null);
cljs.core.chunk_append.call(null,b__25947,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__25946,vec__25954,k,v,c__7187__auto__,size__7188__auto__,b__25947,s__25945__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__25946,vec__25954,k,v,c__7187__auto__,size__7188__auto__,b__25947,s__25945__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__25960 = (i__25946 + (1));
i__25946 = G__25960;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25947),hatti$views$table$render_options_$_iter__25944.call(null,cljs.core.chunk_rest.call(null,s__25945__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25947),null);
}
} else {
var vec__25957 = cljs.core.first.call(null,s__25945__$2);
var k = cljs.core.nth.call(null,vec__25957,(0),null);
var v = cljs.core.nth.call(null,vec__25957,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__25957,k,v,s__25945__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__25957,k,v,s__25945__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__25944.call(null,cljs.core.rest.call(null,s__25945__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table25962 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25962 = (function (_,owner,meta25963){
this._ = _;
this.owner = owner;
this.meta25963 = meta25963;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25962.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25964,meta25963__$1){
var self__ = this;
var _25964__$1 = this;
return (new hatti.views.table.t_hatti$views$table25962(self__._,self__.owner,meta25963__$1));
});

hatti.views.table.t_hatti$views$table25962.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25964){
var self__ = this;
var _25964__$1 = this;
return self__.meta25963;
});

hatti.views.table.t_hatti$views$table25962.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table25962.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field-key","field-key",313262601),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table25962.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25962.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__25965){
var self__ = this;
var map__25966 = p__25965;
var map__25966__$1 = ((((!((map__25966 == null)))?((((map__25966.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25966.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25966):map__25966);
var field_key = cljs.core.get.call(null,map__25966__$1,new cljs.core.Keyword(null,"field-key","field-key",313262601));
var language = cljs.core.get.call(null,map__25966__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__25968 = om.core.get_shared.call(null,self__.owner);
var map__25968__$1 = ((((!((map__25968 == null)))?((((map__25968.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25968.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25968):map__25968);
var flat_form = cljs.core.get.call(null,map__25968__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__25968,map__25968__$1,flat_form,new_language,___$2,map__25966,map__25966__$1,field_key,language){
return (function (p1__25961_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__25961_SHARP_),new cljs.core.Keyword(null,"language","language",-1591107564),new_language,new cljs.core.Keyword(null,"owner","owner",-392611939),self__.owner)], null));
});})(options,map__25968,map__25968__$1,flat_form,new_language,___$2,map__25966,map__25966__$1,field_key,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,field_key);
} else {
}

return React.DOM.div(({"className": "label-changer"}),React.DOM.span(({"className": "label-changer-label"}),"Show:"),React.DOM.div(({"id": "header-display-dropdown", "className": "drop-hover"}),(function (){var attrs25972 = options.call(null,field_key);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs25972))?sablono.interpreter.attributes.call(null,attrs25972):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25972))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i(({"className": "fa fa-angle-down"}))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25972),React.DOM.i(({"className": "fa fa-angle-down"}))], null))));
})(),(function (){var attrs25977 = hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_);
return cljs.core.apply.call(null,React.DOM.ul,((cljs.core.map_QMARK_.call(null,attrs25977))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs25977)):({"className": "submenu no-dot"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25977))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25977)], null))));
})()));
});

hatti.views.table.t_hatti$views$table25962.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25963","meta25963",-29395519,null)], null);
});

hatti.views.table.t_hatti$views$table25962.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25962.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25962";

hatti.views.table.t_hatti$views$table25962.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25962");
});

hatti.views.table.__GT_t_hatti$views$table25962 = (function hatti$views$table$__GT_t_hatti$views$table25962(___$1,owner__$1,meta25963){
return (new hatti.views.table.t_hatti$views$table25962(___$1,owner__$1,meta25963));
});

}

return (new hatti.views.table.t_hatti$views$table25962(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__13216__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto__,query){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,query){
return (function (state_26020){
var state_val_26021 = (state_26020[(1)]);
if((state_val_26021 === (1))){
var inst_26006 = cljs.core.async.timeout.call(null,(150));
var state_26020__$1 = state_26020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26020__$1,(2),inst_26006);
} else {
if((state_val_26021 === (2))){
var inst_26008 = (state_26020[(2)]);
var inst_26009 = input.value;
var inst_26010 = cljs.core._EQ_.call(null,query,inst_26009);
var state_26020__$1 = (function (){var statearr_26022 = state_26020;
(statearr_26022[(7)] = inst_26008);

return statearr_26022;
})();
if(inst_26010){
var statearr_26023_26034 = state_26020__$1;
(statearr_26023_26034[(1)] = (3));

} else {
var statearr_26024_26035 = state_26020__$1;
(statearr_26024_26035[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26021 === (3))){
var inst_26012 = [query_event_key];
var inst_26013 = [query];
var inst_26014 = cljs.core.PersistentHashMap.fromArrays(inst_26012,inst_26013);
var inst_26015 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_26014);
var state_26020__$1 = state_26020;
var statearr_26025_26036 = state_26020__$1;
(statearr_26025_26036[(2)] = inst_26015);

(statearr_26025_26036[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26021 === (4))){
var state_26020__$1 = state_26020;
var statearr_26026_26037 = state_26020__$1;
(statearr_26026_26037[(2)] = null);

(statearr_26026_26037[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26021 === (5))){
var inst_26018 = (state_26020[(2)]);
var state_26020__$1 = state_26020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26020__$1,inst_26018);
} else {
return null;
}
}
}
}
}
});})(c__13216__auto__,query))
;
return ((function (switch__13104__auto__,c__13216__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__13105__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__13105__auto____0 = (function (){
var statearr_26030 = [null,null,null,null,null,null,null,null];
(statearr_26030[(0)] = hatti$views$table$delayed_search_$_state_machine__13105__auto__);

(statearr_26030[(1)] = (1));

return statearr_26030;
});
var hatti$views$table$delayed_search_$_state_machine__13105__auto____1 = (function (state_26020){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_26020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e26031){if((e26031 instanceof Object)){
var ex__13108__auto__ = e26031;
var statearr_26032_26038 = state_26020;
(statearr_26032_26038[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26020);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26031;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26039 = state_26020;
state_26020 = G__26039;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__13105__auto__ = function(state_26020){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____1.call(this,state_26020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__13105__auto____0;
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__13105__auto____1;
return hatti$views$table$delayed_search_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,query))
})();
var state__13218__auto__ = (function (){var statearr_26033 = f__13217__auto__.call(null);
(statearr_26033[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_26033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto__,query))
);

return c__13216__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table26041 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26041 = (function (_,owner,meta26042){
this._ = _;
this.owner = owner;
this.meta26042 = meta26042;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26041.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26043,meta26042__$1){
var self__ = this;
var _26043__$1 = this;
return (new hatti.views.table.t_hatti$views$table26041(self__._,self__.owner,meta26042__$1));
});

hatti.views.table.t_hatti$views$table26041.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26043){
var self__ = this;
var _26043__$1 = this;
return self__.meta26042;
});

hatti.views.table.t_hatti$views$table26041.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26041.prototype.om$core$IRender$render$arity$1 = (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
return React.DOM.div(({"className": "table-search"}),React.DOM.i(({"className": "fa fa-search"})),sablono.interpreter.input.call(null,({"type": "text", "placeholder": "Search", "onChange": ((function (this__19159__auto____$1){
return (function (p1__26040_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__26040_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__19159__auto____$1))
})));
});

hatti.views.table.t_hatti$views$table26041.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26042","meta26042",1320546557,null)], null);
});

hatti.views.table.t_hatti$views$table26041.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26041.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26041";

hatti.views.table.t_hatti$views$table26041.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26041");
});

hatti.views.table.__GT_t_hatti$views$table26041 = (function hatti$views$table$__GT_t_hatti$views$table26041(___$1,owner__$1,meta26042){
return (new hatti.views.table.t_hatti$views$table26041(___$1,owner__$1,meta26042));
});

}

return (new hatti.views.table.t_hatti$views$table26041(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table26046 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26046 = (function (cursor,owner,meta26047){
this.cursor = cursor;
this.owner = owner;
this.meta26047 = meta26047;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26046.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26048,meta26047__$1){
var self__ = this;
var _26048__$1 = this;
return (new hatti.views.table.t_hatti$views$table26046(self__.cursor,self__.owner,meta26047__$1));
});

hatti.views.table.t_hatti$views$table26046.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26048){
var self__ = this;
var _26048__$1 = this;
return self__.meta26047;
});

hatti.views.table.t_hatti$views$table26046.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26046.prototype.om$core$IRender$render$arity$1 = (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
return React.DOM.div(({"className": "topbar"}),React.DOM.div(({"id": hatti.views.table.pager_id})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,self__.cursor)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.cursor)),React.DOM.div(({"style": ({"clear": "both"})})));
});

hatti.views.table.t_hatti$views$table26046.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26047","meta26047",-1137362442,null)], null);
});

hatti.views.table.t_hatti$views$table26046.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26046.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26046";

hatti.views.table.t_hatti$views$table26046.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26046");
});

hatti.views.table.__GT_t_hatti$views$table26046 = (function hatti$views$table$__GT_t_hatti$views$table26046(cursor__$1,owner__$1,meta26047){
return (new hatti.views.table.t_hatti$views$table26046(cursor__$1,owner__$1,meta26047));
});

}

return (new hatti.views.table.t_hatti$views$table26046(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq.call(null,data)){
var map__26056 = om.core.get_shared.call(null,owner);
var map__26056__$1 = ((((!((map__26056 == null)))?((((map__26056.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26056.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26056):map__26056);
var flat_form = cljs.core.get.call(null,map__26056__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__26057 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__26057,(0),null);
var dataview = cljs.core.nth.call(null,vec__26057,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901),hatti.views.table.get_table_view_height.call(null));
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__26062,owner,p__26063){
var map__26064 = p__26062;
var map__26064__$1 = ((((!((map__26064 == null)))?((((map__26064.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26064.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26064):map__26064);
var cursor = map__26064__$1;
var map__26065 = cljs.core.get.call(null,map__26064__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__26065__$1 = ((((!((map__26065 == null)))?((((map__26065.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26065.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26065):map__26065);
var active = cljs.core.get.call(null,map__26065__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var map__26066 = p__26063;
var map__26066__$1 = ((((!((map__26066 == null)))?((((map__26066.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26066.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26066):map__26066);
var opts = map__26066__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__26066__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

var active_QMARK_ = chimera.seq.in_QMARK_.call(null,active,new cljs.core.Keyword(null,"table","table",-564943036));
if(typeof hatti.views.table.t_hatti$views$table26070 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26070 = (function (p__26062,owner,active_QMARK_,map__26064,slick_grid_event_handlers,map__26066,p__26063,cursor,map__26065,active,opts,meta26071){
this.p__26062 = p__26062;
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.map__26064 = map__26064;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__26066 = map__26066;
this.p__26063 = p__26063;
this.cursor = cursor;
this.map__26065 = map__26065;
this.active = active;
this.opts = opts;
this.meta26071 = meta26071;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26070.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers){
return (function (_26072,meta26071__$1){
var self__ = this;
var _26072__$1 = this;
return (new hatti.views.table.t_hatti$views$table26070(self__.p__26062,self__.owner,self__.active_QMARK_,self__.map__26064,self__.slick_grid_event_handlers,self__.map__26066,self__.p__26063,self__.cursor,self__.map__26065,self__.active,self__.opts,meta26071__$1));
});})(active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26070.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers){
return (function (_26072){
var self__ = this;
var _26072__$1 = this;
return self__.meta26071;
});})(active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26070.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table26070.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers){
return (function (_,p__26073){
var self__ = this;
var map__26074 = p__26073;
var map__26074__$1 = ((((!((map__26074 == null)))?((((map__26074.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26074.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26074):map__26074);
var table_view_height = cljs.core.get.call(null,map__26074__$1,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901));
var ___$1 = this;
var map__26076 = self__.cursor;
var map__26076__$1 = ((((!((map__26076 == null)))?((((map__26076.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26076.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26076):map__26076);
var map__26077 = cljs.core.get.call(null,map__26076__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__26077__$1 = ((((!((map__26077 == null)))?((((map__26077.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26077.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26077):map__26077);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.call(null,map__26077__$1,new cljs.core.Keyword(null,"prevent-scrolling-in-table-view?","prevent-scrolling-in-table-view?",2053296532));
var submission_clicked = cljs.core.get.call(null,map__26077__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var data = cljs.core.get.call(null,map__26076__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__26076__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var map__26078 = dataset_info;
var map__26078__$1 = ((((!((map__26078 == null)))?((((map__26078.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26078.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26078):map__26078);
var num_of_submissions = cljs.core.get.call(null,map__26078__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,data);
var with_info = ((function (map__26076,map__26076__$1,map__26077,map__26077__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__26078,map__26078__$1,num_of_submissions,no_data_QMARK_,___$1,map__26074,map__26074__$1,table_view_height,active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers){
return (function (p1__26061_SHARP_){
return cljs.core.merge.call(null,self__.cursor,p1__26061_SHARP_);
});})(map__26076,map__26076__$1,map__26077,map__26077__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__26078,map__26078__$1,num_of_submissions,no_data_QMARK_,___$1,map__26074,map__26074__$1,table_view_height,active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
return React.DOM.div(({"style": cljs.core.clj__GT_js.call(null,(cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"height","height",1025178622),(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height.call(null);
}
})(),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null):null)), "className": "table-view"}),sablono.interpreter.interpret.call(null,(cljs.core.truth_(new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.call(null,hatti.views.submission_view,with_info.call(null,submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null)):null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.cursor)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.p(({"className": "alert alert-warning"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading..."))));
} else {
return null;
}
});})(active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26070.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table26070.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler.call(null,self__.owner);

var data = cljs.core.get_in.call(null,self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26086 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__26086,(0),null);
var dataview = cljs.core.nth.call(null,vec__26086,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26070.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table26070.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.call(null,self__.owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881)));
});})(active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26070.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table26070.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__26089 = om.core.get_state.call(null,self__.owner);
var map__26089__$1 = ((((!((map__26089 == null)))?((((map__26089.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26089.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26089):map__26089);
var grid = cljs.core.get.call(null,map__26089__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__26089__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26091 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__26091,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__26091,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26070.getBasis = ((function (active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__26062","p__26062",-242565950,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"active?","active?",2100031303,null),new cljs.core.Symbol(null,"map__26064","map__26064",-2043184054,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"map__26066","map__26066",-144730197,null),new cljs.core.Symbol(null,"p__26063","p__26063",-113445329,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"map__26065","map__26065",1012993306,null),new cljs.core.Symbol(null,"active","active",-758473701,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"meta26071","meta26071",1395940289,null)], null);
});})(active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26070.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26070.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26070";

hatti.views.table.t_hatti$views$table26070.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26070");
});})(active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table26070 = ((function (active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table26070(p__26062__$1,owner__$1,active_QMARK___$1,map__26064__$2,slick_grid_event_handlers__$1,map__26066__$2,p__26063__$1,cursor__$1,map__26065__$2,active__$1,opts__$1,meta26071){
return (new hatti.views.table.t_hatti$views$table26070(p__26062__$1,owner__$1,active_QMARK___$1,map__26064__$2,slick_grid_event_handlers__$1,map__26066__$2,p__26063__$1,cursor__$1,map__26065__$2,active__$1,opts__$1,meta26071));
});})(active_QMARK_,map__26064,map__26064__$1,cursor,map__26065,map__26065__$1,active,map__26066,map__26066__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table26070(p__26062,owner,active_QMARK_,map__26064__$1,slick_grid_event_handlers,map__26066__$1,p__26063,cursor,map__26065__$1,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
