// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('hatti.constants');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.ona.forms');
goog.require('clojure.string');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('cljs.reader');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"point","point",1813198264),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),({"radius": (6), "fillColor": "#f30", "reset": ({"fillColor": "#f30"}), "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9}),new cljs.core.Keyword(null,"hover","hover",-341141711),({"fillColor": "#631400"}),new cljs.core.Keyword(null,"clicked","clicked",114423720),({"fillColor": "#ad2300"})], null),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),({"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8}),new cljs.core.Keyword(null,"hover","hover",-341141711),({"fillColor": "#631400", "color": "#222"}),new cljs.core.Keyword(null,"clicked","clicked",114423720),({"fillColor": "#ad2300", "color": "#222"})], null),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),({"color": "#f30", "opacity": (1), "weight": (6), "reset": ({"color": "#f30"})}),new cljs.core.Keyword(null,"hover","hover",-341141711),({"color": "#631400"}),new cljs.core.Keyword(null,"clicked","clicked",114423720),({"color": "#ad2300"})], null)], null);
hatti.map.utils.circle_border_id = "point-casting";
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20173 = arguments.length;
var i__7485__auto___20174 = (0);
while(true){
if((i__7485__auto___20174 < len__7484__auto___20173)){
args__7491__auto__.push((arguments[i__7485__auto___20174]));

var G__20175 = (i__7485__auto___20174 + (1));
i__7485__auto___20174 = G__20175;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic = (function (marker_or_keyword,style_type,p__20170){
var map__20171 = p__20170;
var map__20171__$1 = ((((!((map__20171 == null)))?((((map__20171.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20171.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20171):map__20171);
var custom_styles = cljs.core.get.call(null,map__20171__$1,new cljs.core.Keyword(null,"custom-styles","custom-styles",-1687569839),hatti.map.utils.ona_styles);
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype.call(null,marker_or_keyword));
return style_type.call(null,kw.call(null,custom_styles));
});

hatti.map.utils.get_ona_style.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_ona_style.cljs$lang$applyTo = (function (seq20167){
var G__20168 = cljs.core.first.call(null,seq20167);
var seq20167__$1 = cljs.core.next.call(null,seq20167);
var G__20169 = cljs.core.first.call(null,seq20167__$1);
var seq20167__$2 = cljs.core.next.call(null,seq20167__$1);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic(G__20168,G__20169,seq20167__$2);
});

hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.call(null,s);
var tc = cljs.core.js__GT_clj.call(null,t);
return cljs.core._EQ_.call(null,cljs.core.select_keys.call(null,sc,cljs.core.keys.call(null,tc)),cljs.core.select_keys.call(null,tc,cljs.core.keys.call(null,sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args20176 = [];
var len__7484__auto___20179 = arguments.length;
var i__7485__auto___20180 = (0);
while(true){
if((i__7485__auto___20180 < len__7484__auto___20179)){
args20176.push((arguments[i__7485__auto___20180]));

var G__20181 = (i__7485__auto___20180 + (1));
i__7485__auto___20180 = G__20181;
continue;
} else {
}
break;
}

var G__20178 = args20176.length;
switch (G__20178) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20176.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
return kw.call(null,cljs.core.js__GT_clj.call(null,hatti.map.utils.get_style.call(null,marker)));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;

/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style.call(null,hatti.map.utils.get_style.call(null,marker),hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = marker__GT_style.call(null,marker);
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return marker.setStyle(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"reset","reset",-800929946),style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,style,new cljs.core.Keyword(null,"reset","reset",-800929946),style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.map.utils.is_clicked_QMARK_.call(null,marker);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_selected_QMARK_.call(null,hatti.map.utils.get_id.call(null,marker));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style.call(null,marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"hover","hover",-341141711)));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20192 = arguments.length;
var i__7485__auto___20193 = (0);
while(true){
if((i__7485__auto___20193 < len__7484__auto___20192)){
args__7491__auto__.push((arguments[i__7485__auto___20193]));

var G__20194 = (i__7485__auto___20193 + (1));
i__7485__auto___20193 = G__20194;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__20185){
var map__20186 = p__20185;
var map__20186__$1 = ((((!((map__20186 == null)))?((((map__20186.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20186.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20186):map__20186);
var preserve_clicked_QMARK_ = cljs.core.get.call(null,map__20186__$1,new cljs.core.Keyword(null,"preserve-clicked?","preserve-clicked?",-727263842),true);
var seq__20188 = cljs.core.seq.call(null,markers);
var chunk__20189 = null;
var count__20190 = (0);
var i__20191 = (0);
while(true){
if((i__20191 < count__20190)){
var marker = cljs.core._nth.call(null,chunk__20189,i__20191);
if(cljs.core.not.call(null,(function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__20195 = seq__20188;
var G__20196 = chunk__20189;
var G__20197 = count__20190;
var G__20198 = (i__20191 + (1));
seq__20188 = G__20195;
chunk__20189 = G__20196;
count__20190 = G__20197;
i__20191 = G__20198;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__20188);
if(temp__4657__auto__){
var seq__20188__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20188__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__20188__$1);
var G__20199 = cljs.core.chunk_rest.call(null,seq__20188__$1);
var G__20200 = c__7220__auto__;
var G__20201 = cljs.core.count.call(null,c__7220__auto__);
var G__20202 = (0);
seq__20188 = G__20199;
chunk__20189 = G__20200;
count__20190 = G__20201;
i__20191 = G__20202;
continue;
} else {
var marker = cljs.core.first.call(null,seq__20188__$1);
if(cljs.core.not.call(null,(function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__20203 = cljs.core.next.call(null,seq__20188__$1);
var G__20204 = null;
var G__20205 = (0);
var G__20206 = (0);
seq__20188 = G__20203;
chunk__20189 = G__20204;
count__20190 = G__20205;
i__20191 = G__20206;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq20183){
var G__20184 = cljs.core.first.call(null,seq20183);
var seq20183__$1 = cljs.core.next.call(null,seq20183);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__20184,seq20183__$1);
});

hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string.call(null,maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"Feature",new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.call(null,hatti.constants._rank),(index + (1)),new cljs.core.Keyword(null,"id","id",-1388402092),record_id,cljs.core.keyword.call(null,hatti.constants._id),record_id], true, false),new cljs.core.Keyword(null,"geometry","geometry",-405034994),geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__7334__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__7335__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__7336__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__7337__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__7338__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"hatti.map.utils","get-as-geom"),((function (method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__){
return (function() { 
var G__20211__delegate = function (record,field,p__20207){
var vec__20208 = p__20207;
var repeat_child_index = cljs.core.nth.call(null,vec__20208,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
return new cljs.core.Keyword(null,"repeat","repeat",832692087);
} else {
return new cljs.core.Keyword(null,"default","default",-1987822328);

}
};
var G__20211 = function (record,field,var_args){
var p__20207 = null;
if (arguments.length > 2) {
var G__20212__i = 0, G__20212__a = new Array(arguments.length -  2);
while (G__20212__i < G__20212__a.length) {G__20212__a[G__20212__i] = arguments[G__20212__i + 2]; ++G__20212__i;}
  p__20207 = new cljs.core.IndexedSeq(G__20212__a,0);
} 
return G__20211__delegate.call(this,record,field,p__20207);};
G__20211.cljs$lang$maxFixedArity = 2;
G__20211.cljs$lang$applyTo = (function (arglist__20213){
var record = cljs.core.first(arglist__20213);
arglist__20213 = cljs.core.next(arglist__20213);
var field = cljs.core.first(arglist__20213);
var p__20207 = cljs.core.rest(arglist__20213);
return G__20211__delegate(record,field,p__20207);
});
G__20211.cljs$core$IFn$_invoke$arity$variadic = G__20211__delegate;
return G__20211;
})()
;})(method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__7338__auto__,method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__));
})();
}
cljs.core._add_method.call(null,hatti.map.utils.get_as_geom,new cljs.core.Keyword(null,"repeat","repeat",832692087),(function (record,p__20214){
var map__20215 = p__20214;
var map__20215__$1 = ((((!((map__20215 == null)))?((((map__20215.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20215.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20215):map__20215);
var field = map__20215__$1;
var children = cljs.core.get.call(null,map__20215__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var full_name = cljs.core.get.call(null,map__20215__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var iter__7189__auto__ = ((function (map__20215,map__20215__$1,field,children,full_name){
return (function hatti$map$utils$iter__20217(s__20218){
return (new cljs.core.LazySeq(null,((function (map__20215,map__20215__$1,field,children,full_name){
return (function (){
var s__20218__$1 = s__20218;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20218__$1);
if(temp__4657__auto__){
var s__20218__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20218__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20218__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20220 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20219 = (0);
while(true){
if((i__20219 < size__7188__auto__)){
var child_record = cljs.core._nth.call(null,c__7187__auto__,i__20219);
cljs.core.chunk_append.call(null,b__20220,(function (){var iter__7189__auto__ = ((function (i__20219,child_record,c__7187__auto__,size__7188__auto__,b__20220,s__20218__$2,temp__4657__auto__,map__20215,map__20215__$1,field,children,full_name){
return (function hatti$map$utils$iter__20217_$_iter__20229(s__20230){
return (new cljs.core.LazySeq(null,((function (i__20219,child_record,c__7187__auto__,size__7188__auto__,b__20220,s__20218__$2,temp__4657__auto__,map__20215,map__20215__$1,field,children,full_name){
return (function (){
var s__20230__$1 = s__20230;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__20230__$1);
if(temp__4657__auto____$1){
var s__20230__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20230__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first.call(null,s__20230__$2);
var size__7188__auto____$1 = cljs.core.count.call(null,c__7187__auto____$1);
var b__20232 = cljs.core.chunk_buffer.call(null,size__7188__auto____$1);
if((function (){var i__20231 = (0);
while(true){
if((i__20231 < size__7188__auto____$1)){
var child = cljs.core._nth.call(null,c__7187__auto____$1,i__20231);
cljs.core.chunk_append.call(null,b__20232,hatti.map.utils.get_as_geom.call(null,child_record,child));

var G__20237 = (i__20231 + (1));
i__20231 = G__20237;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20232),hatti$map$utils$iter__20217_$_iter__20229.call(null,cljs.core.chunk_rest.call(null,s__20230__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20232),null);
}
} else {
var child = cljs.core.first.call(null,s__20230__$2);
return cljs.core.cons.call(null,hatti.map.utils.get_as_geom.call(null,child_record,child),hatti$map$utils$iter__20217_$_iter__20229.call(null,cljs.core.rest.call(null,s__20230__$2)));
}
} else {
return null;
}
break;
}
});})(i__20219,child_record,c__7187__auto__,size__7188__auto__,b__20220,s__20218__$2,temp__4657__auto__,map__20215,map__20215__$1,field,children,full_name))
,null,null));
});})(i__20219,child_record,c__7187__auto__,size__7188__auto__,b__20220,s__20218__$2,temp__4657__auto__,map__20215,map__20215__$1,field,children,full_name))
;
return iter__7189__auto__.call(null,cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,children));
})());

var G__20238 = (i__20219 + (1));
i__20219 = G__20238;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20220),hatti$map$utils$iter__20217.call(null,cljs.core.chunk_rest.call(null,s__20218__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20220),null);
}
} else {
var child_record = cljs.core.first.call(null,s__20218__$2);
return cljs.core.cons.call(null,(function (){var iter__7189__auto__ = ((function (child_record,s__20218__$2,temp__4657__auto__,map__20215,map__20215__$1,field,children,full_name){
return (function hatti$map$utils$iter__20217_$_iter__20233(s__20234){
return (new cljs.core.LazySeq(null,((function (child_record,s__20218__$2,temp__4657__auto__,map__20215,map__20215__$1,field,children,full_name){
return (function (){
var s__20234__$1 = s__20234;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__20234__$1);
if(temp__4657__auto____$1){
var s__20234__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20234__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20234__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20236 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20235 = (0);
while(true){
if((i__20235 < size__7188__auto__)){
var child = cljs.core._nth.call(null,c__7187__auto__,i__20235);
cljs.core.chunk_append.call(null,b__20236,hatti.map.utils.get_as_geom.call(null,child_record,child));

var G__20239 = (i__20235 + (1));
i__20235 = G__20239;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20236),hatti$map$utils$iter__20217_$_iter__20233.call(null,cljs.core.chunk_rest.call(null,s__20234__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20236),null);
}
} else {
var child = cljs.core.first.call(null,s__20234__$2);
return cljs.core.cons.call(null,hatti.map.utils.get_as_geom.call(null,child_record,child),hatti$map$utils$iter__20217_$_iter__20233.call(null,cljs.core.rest.call(null,s__20234__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__20218__$2,temp__4657__auto__,map__20215,map__20215__$1,field,children,full_name))
,null,null));
});})(child_record,s__20218__$2,temp__4657__auto__,map__20215,map__20215__$1,field,children,full_name))
;
return iter__7189__auto__.call(null,cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__20217.call(null,cljs.core.rest.call(null,s__20218__$2)));
}
} else {
return null;
}
break;
}
});})(map__20215,map__20215__$1,field,children,full_name))
,null,null));
});})(map__20215,map__20215__$1,field,children,full_name))
;
return iter__7189__auto__.call(null,cljs.core.get.call(null,record,full_name));
}));
cljs.core._add_method.call(null,hatti.map.utils.get_as_geom,new cljs.core.Keyword(null,"default","default",-1987822328),(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq.call(null,s)) && (cljs.core.not_EQ_.call(null,s,"n/a"))){
var iter__7189__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__20242(s__20243){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__20243__$1 = s__20243;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20243__$1);
if(temp__4657__auto__){
var s__20243__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20243__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20243__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20245 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20244 = (0);
while(true){
if((i__20244 < size__7188__auto__)){
var coord_string = cljs.core._nth.call(null,c__7187__auto__,i__20244);
cljs.core.chunk_append.call(null,b__20245,(function (){var vec__20252 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__20252,(0),null);
var lng = cljs.core.nth.call(null,vec__20252,(1),null);
var _ = cljs.core.nth.call(null,vec__20252,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__20252,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})());

var G__20259 = (i__20244 + (1));
i__20244 = G__20259;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20245),hatti$map$utils$iter__20242.call(null,cljs.core.chunk_rest.call(null,s__20243__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20245),null);
}
} else {
var coord_string = cljs.core.first.call(null,s__20243__$2);
return cljs.core.cons.call(null,(function (){var vec__20255 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__20255,(0),null);
var lng = cljs.core.nth.call(null,vec__20255,(1),null);
var _ = cljs.core.nth.call(null,vec__20255,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__20255,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})(),hatti$map$utils$iter__20242.call(null,cljs.core.rest.call(null,s__20243__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__7189__auto__.call(null,clojure.string.split.call(null,s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__20258 = geotype;
switch (G__20258) {
case "Point":
return ((function (G__20258,geotype,parse){
return (function (p1__20240_SHARP_){
return cljs.core.first.call(null,parse.call(null,p1__20240_SHARP_));
});
;})(G__20258,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__20258,geotype,parse){
return (function (p1__20241_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse.call(null,p1__20241_SHARP_)],null));
});
;})(G__20258,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.call(null,record,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(geofield));
var coords = coordfn.call(null,value);
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_.call(null,geofield))){
return new cljs.core.Keyword(null,"geom","geom",1207084371).cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = (coords == null);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return cljs.core.some.call(null,cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),geotype,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668),coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args20262 = [];
var len__7484__auto___20281 = arguments.length;
var i__7485__auto___20282 = (0);
while(true){
if((i__7485__auto___20282 < len__7484__auto___20281)){
args20262.push((arguments[i__7485__auto___20282]));

var G__20283 = (i__7485__auto___20282 + (1));
i__7485__auto___20282 = G__20283;
continue;
} else {
}
break;
}

var G__20264 = args20262.length;
switch (G__20264) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20262.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.call(null,dataset,form,hatti.ona.forms.default_geofield.call(null,form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__7189__auto__ = (function hatti$map$utils$iter__20265(s__20266){
return (new cljs.core.LazySeq(null,(function (){
var s__20266__$1 = s__20266;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20266__$1);
if(temp__4657__auto__){
var s__20266__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20266__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20266__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20268 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20267 = (0);
while(true){
if((i__20267 < size__7188__auto__)){
var vec__20275 = cljs.core._nth.call(null,c__7187__auto__,i__20267);
var idx = cljs.core.nth.call(null,vec__20275,(0),null);
var record = cljs.core.nth.call(null,vec__20275,(1),null);
var geom_or_geoms = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append.call(null,b__20268,((cljs.core.map_QMARK_.call(null,geom_or_geoms))?hatti.map.utils.make_feature.call(null,geom_or_geoms,record.call(null,hatti.constants._id),idx):cljs.core.map.call(null,((function (i__20267,s__20266__$1,geom_or_geoms,vec__20275,idx,record,c__7187__auto__,size__7188__auto__,b__20268,s__20266__$2,temp__4657__auto__){
return (function (p1__20261_SHARP_){
return hatti.map.utils.make_feature.call(null,p1__20261_SHARP_,record.call(null,hatti.constants._id),idx);
});})(i__20267,s__20266__$1,geom_or_geoms,vec__20275,idx,record,c__7187__auto__,size__7188__auto__,b__20268,s__20266__$2,temp__4657__auto__))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,geom_or_geoms)))));

var G__20285 = (i__20267 + (1));
i__20267 = G__20285;
continue;
} else {
var G__20286 = (i__20267 + (1));
i__20267 = G__20286;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20268),hatti$map$utils$iter__20265.call(null,cljs.core.chunk_rest.call(null,s__20266__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20268),null);
}
} else {
var vec__20278 = cljs.core.first.call(null,s__20266__$2);
var idx = cljs.core.nth.call(null,vec__20278,(0),null);
var record = cljs.core.nth.call(null,vec__20278,(1),null);
var geom_or_geoms = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons.call(null,((cljs.core.map_QMARK_.call(null,geom_or_geoms))?hatti.map.utils.make_feature.call(null,geom_or_geoms,record.call(null,hatti.constants._id),idx):cljs.core.map.call(null,((function (s__20266__$1,geom_or_geoms,vec__20278,idx,record,s__20266__$2,temp__4657__auto__){
return (function (p1__20261_SHARP_){
return hatti.map.utils.make_feature.call(null,p1__20261_SHARP_,record.call(null,hatti.constants._id),idx);
});})(s__20266__$1,geom_or_geoms,vec__20278,idx,record,s__20266__$2,temp__4657__auto__))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,geom_or_geoms)))),hatti$map$utils$iter__20265.call(null,cljs.core.rest.call(null,s__20266__$2)));
} else {
var G__20287 = cljs.core.rest.call(null,s__20266__$2);
s__20266__$1 = G__20287;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,hatti.utils.indexed.call(null,dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"FeatureCollection",new cljs.core.Keyword(null,"features","features",-1146962336),cljs.core.flatten.call(null,features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;

/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__20289){
var map__20292 = p__20289;
var map__20292__$1 = ((((!((map__20292 == null)))?((((map__20292.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20292.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20292):map__20292);
var mapbox_tiles = cljs.core.get.call(null,map__20292__$1,new cljs.core.Keyword(null,"mapbox-tiles","mapbox-tiles",69952469));
var include_google_maps_QMARK_ = cljs.core.get.call(null,map__20292__$1,new cljs.core.Keyword(null,"include-google-maps?","include-google-maps?",1820261665));
var layers = cljs.core.map.call(null,((function (map__20292,map__20292__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__20288_SHARP_){
return L.tileLayer(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(p1__20288_SHARP_));
});})(map__20292,map__20292__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js.call(null,nlayers));
var m = L.map(id,({"layers": cljs.core.first.call(null,layers), "zoomControl": false}));
var z = L.control.zoom.call(null,({"position": "bottomleft"}));
z.addTo(m);

L.control.layers.call(null,named_layers,null,({"position": "bottomleft"})).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return cljs.core.async.put_BANG_.call(null,event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mapped-submission-to-rank","mapped-submission-to-rank",-1281314361),((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style.call(null,marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style.call(null,marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not.call(null,layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20306 = arguments.length;
var i__7485__auto___20307 = (0);
while(true){
if((i__7485__auto___20307 < len__7484__auto___20306)){
args__7491__auto__.push((arguments[i__7485__auto___20307]));

var G__20308 = (i__7485__auto___20307 + (1));
i__7485__auto___20307 = G__20308;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__20303){
var map__20304 = p__20303;
var map__20304__$1 = ((((!((map__20304 == null)))?((((map__20304.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20304.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20304):map__20304);
var rezoom_QMARK_ = cljs.core.get.call(null,map__20304__$1,new cljs.core.Keyword(null,"rezoom?","rezoom?",746240707));
var on_events = ((function (map__20304,map__20304__$1,rezoom_QMARK_){
return (function (p1__20294_SHARP_,p2__20295_SHARP_){
return hatti.map.utils.register_mouse_events.call(null,p1__20294_SHARP_,p2__20295_SHARP_,event_chan);
});})(map__20304,map__20304__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__20304,map__20304__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style.call(null,geometry_type,new cljs.core.Keyword(null,"normal","normal",-1519123858));
});})(on_events,geometry_type,map__20304,map__20304__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__20304,map__20304__$1,rezoom_QMARK_){
return (function (p1__20297_SHARP_,p2__20296_SHARP_){
return L.circleMarker(p2__20296_SHARP_);
});})(on_events,geometry_type,stylefn,map__20304,map__20304__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js.call(null,geojson),({"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn}));
var ids = cljs.core.map.call(null,((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__20304,map__20304__$1,rezoom_QMARK_){
return (function (p1__20298_SHARP_){
return cljs.core.get_in.call(null,p1__20298_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.keyword.call(null,hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__20304,map__20304__$1,rezoom_QMARK_))
,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"feature-layer","feature-layer",2086639246),feature_layer,new cljs.core.Keyword(null,"markers","markers",-246919693),markers,new cljs.core.Keyword(null,"id->marker","id->marker",-1702427771),cljs.core.zipmap.call(null,ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq20299){
var G__20300 = cljs.core.first.call(null,seq20299);
var seq20299__$1 = cljs.core.next.call(null,seq20299);
var G__20301 = cljs.core.first.call(null,seq20299__$1);
var seq20299__$2 = cljs.core.next.call(null,seq20299__$1);
var G__20302 = cljs.core.first.call(null,seq20299__$2);
var seq20299__$3 = cljs.core.next.call(null,seq20299__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__20300,G__20301,G__20302,seq20299__$3);
});

/**
 * Creates a mapboxgl map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_mapboxgl_map = (function hatti$map$utils$create_mapboxgl_map(id){
mapboxgl.accessToken = hatti.constants.mapboxgl_access_token;

var Map = mapboxgl.Map;
var NavigationControl = mapboxgl.NavigationControl;
var ScaleControl = mapboxgl.ScaleControl;
var m = (new Map(({"container": id, "style": "mapbox://styles/mapbox/streets-v9"})));
m.addControl((new ScaleControl(({"maxWidth": (100), "unit": "metric"}))),"bottom-left");

return m.addControl((new NavigationControl()),"bottom-left");
});
/**
 * Gets query filter and returns filters based on field type
 */
hatti.map.utils.get_filter = (function hatti$map$utils$get_filter(p__20309,flat_form){
var map__20315 = p__20309;
var map__20315__$1 = ((((!((map__20315 == null)))?((((map__20315.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20315.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20315):map__20315);
var column = cljs.core.get.call(null,map__20315__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var filter = cljs.core.get.call(null,map__20315__$1,new cljs.core.Keyword(null,"filter","filter",-948537934));
var value = cljs.core.get.call(null,map__20315__$1,new cljs.core.Keyword(null,"value","value",305978217));
var field = cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__20315,map__20315__$1,column,filter,value){
return (function (p__20317){
var map__20318 = p__20317;
var map__20318__$1 = ((((!((map__20318 == null)))?((((map__20318.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20318.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20318):map__20318);
var full_name = cljs.core.get.call(null,map__20318__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
return cljs.core._EQ_.call(null,full_name,column);
});})(map__20315,map__20315__$1,column,filter,value))
,flat_form));
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS INT) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS AS TIMESTAMP) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
return [cljs.core.str("json->>'"),cljs.core.str(column),cljs.core.str("' "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');

}
}
});
/**
 * Generates query params filters for filtered datasets 
 */
hatti.map.utils.generate_filter_string = (function hatti$map$utils$generate_filter_string(query,flat_form){
if(cljs.core.truth_(cljs.core.not_empty.call(null,query))){
return [cljs.core.str(" and "),cljs.core.str(clojure.string.join.call(null," and ",cljs.core.map.call(null,(function (p1__20320_SHARP_){
return hatti.map.utils.get_filter.call(null,p1__20320_SHARP_,flat_form);
}),query)))].join('');
} else {
return null;
}
});
/**
 * Generates tiles url with appropriate filters as query params
 */
hatti.map.utils.get_tiles_endpoint = (function hatti$map$utils$get_tiles_endpoint(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20330 = arguments.length;
var i__7485__auto___20331 = (0);
while(true){
if((i__7485__auto___20331 < len__7484__auto___20330)){
args__7491__auto__.push((arguments[i__7485__auto___20331]));

var G__20332 = (i__7485__auto___20331 + (1));
i__7485__auto___20331 = G__20332;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((4) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((4)),(0),null)):null);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7492__auto__);
});

hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic = (function (tiles_server,formid,fields,flat_form,p__20326){
var vec__20327 = p__20326;
var query = cljs.core.nth.call(null,vec__20327,(0),null);
return [cljs.core.str(tiles_server),cljs.core.str(hatti.constants.tiles_endpoint),cljs.core.str("?where=deleted_at is null and xform_id ="),cljs.core.str(formid),cljs.core.str(hatti.map.utils.generate_filter_string.call(null,query,flat_form)),cljs.core.str("&fields="),cljs.core.str(clojure.string.join.call(null,",",fields))].join('');
});

hatti.map.utils.get_tiles_endpoint.cljs$lang$maxFixedArity = (4);

hatti.map.utils.get_tiles_endpoint.cljs$lang$applyTo = (function (seq20321){
var G__20322 = cljs.core.first.call(null,seq20321);
var seq20321__$1 = cljs.core.next.call(null,seq20321);
var G__20323 = cljs.core.first.call(null,seq20321__$1);
var seq20321__$2 = cljs.core.next.call(null,seq20321__$1);
var G__20324 = cljs.core.first.call(null,seq20321__$2);
var seq20321__$3 = cljs.core.next.call(null,seq20321__$2);
var G__20325 = cljs.core.first.call(null,seq20321__$3);
var seq20321__$4 = cljs.core.next.call(null,seq20321__$3);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic(G__20322,G__20323,G__20324,G__20325,seq20321__$4);
});

/**
 * Add map source. This is called with either tiles-url or geoson which
 *   determins the source type (Vector or  GeosJSON). 
 */
hatti.map.utils.add_mapboxgl_source = (function hatti$map$utils$add_mapboxgl_source(map,id_string,p__20333){
var map__20337 = p__20333;
var map__20337__$1 = ((((!((map__20337 == null)))?((((map__20337.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20337.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20337):map__20337);
var tiles_url = cljs.core.get.call(null,map__20337__$1,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944));
var geojson = cljs.core.get.call(null,map__20337__$1,new cljs.core.Keyword(null,"geojson","geojson",-719473398));
var cluster = cljs.core.get.call(null,map__20337__$1,new cljs.core.Keyword(null,"cluster","cluster",535175621),false);
var clusterRadius = cljs.core.get.call(null,map__20337__$1,new cljs.core.Keyword(null,"clusterRadius","clusterRadius",-1512735857));
var clusterMaxZoom = cljs.core.get.call(null,map__20337__$1,new cljs.core.Keyword(null,"clusterMaxZoom","clusterMaxZoom",-627685763));
var geojson_source_defn = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"geojson",new cljs.core.Keyword(null,"data","data",-232669377),geojson,new cljs.core.Keyword(null,"cluster","cluster",535175621),cluster], null);
var source = (cljs.core.truth_(geojson)?cljs.core.clj__GT_js.call(null,(function (){var G__20339 = geojson_source_defn;
var G__20339__$1 = (cljs.core.truth_(clusterRadius)?cljs.core.assoc.call(null,G__20339,new cljs.core.Keyword(null,"clusterRadius","clusterRadius",-1512735857),clusterRadius):G__20339);
if(cljs.core.truth_(clusterMaxZoom)){
return cljs.core.assoc.call(null,G__20339__$1,new cljs.core.Keyword(null,"clusterMaxZoom","clusterMaxZoom",-627685763),clusterMaxZoom);
} else {
return G__20339__$1;
}
})()):(cljs.core.truth_(tiles_url)?cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"vector",new cljs.core.Keyword(null,"tiles","tiles",178505240),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tiles_url], null)], null)):null));
if(cljs.core.truth_(map.getSource(id_string))){
return null;
} else {
return map.addSource(id_string,source);
}
});
/**
 * Add map layer from available sources.
 */
hatti.map.utils.add_mapboxgl_layer = (function hatti$map$utils$add_mapboxgl_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20348 = arguments.length;
var i__7485__auto___20349 = (0);
while(true){
if((i__7485__auto___20349 < len__7484__auto___20348)){
args__7491__auto__.push((arguments[i__7485__auto___20349]));

var G__20350 = (i__7485__auto___20349 + (1));
i__7485__auto___20349 = G__20350;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id_string,layer_type,p__20344){
var map__20345 = p__20344;
var map__20345__$1 = ((((!((map__20345 == null)))?((((map__20345.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20345.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20345):map__20345);
var layer_id = cljs.core.get.call(null,map__20345__$1,new cljs.core.Keyword(null,"layer-id","layer-id",576786958));
var layout = cljs.core.get.call(null,map__20345__$1,new cljs.core.Keyword(null,"layout","layout",-2120940921));
var paint = cljs.core.get.call(null,map__20345__$1,new cljs.core.Keyword(null,"paint","paint",1531901299));
var filter = cljs.core.get.call(null,map__20345__$1,new cljs.core.Keyword(null,"filter","filter",-948537934));
var tiles_url = cljs.core.get.call(null,map__20345__$1,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944));
var l_id = (function (){var or__6409__auto__ = layer_id;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_string;
}
})();
var layer_def = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),l_id,new cljs.core.Keyword(null,"type","type",1174270348),layer_type,new cljs.core.Keyword(null,"source","source",-433931539),id_string], null);
var layer = cljs.core.clj__GT_js.call(null,(function (){var G__20347 = layer_def;
var G__20347__$1 = (cljs.core.truth_(tiles_url)?cljs.core.assoc.call(null,G__20347,new cljs.core.Keyword(null,"source-layer","source-layer",-637591060),hatti.constants.vector_source_layer):G__20347);
var G__20347__$2 = (cljs.core.truth_(paint)?cljs.core.assoc.call(null,G__20347__$1,new cljs.core.Keyword(null,"paint","paint",1531901299),paint):G__20347__$1);
var G__20347__$3 = (cljs.core.truth_(layout)?cljs.core.assoc.call(null,G__20347__$2,new cljs.core.Keyword(null,"layout","layout",-2120940921),layout):G__20347__$2);
if(cljs.core.truth_(filter)){
return cljs.core.assoc.call(null,G__20347__$3,new cljs.core.Keyword(null,"filter","filter",-948537934),filter);
} else {
return G__20347__$3;
}
})());
if(cljs.core.truth_(map.getLayer(l_id))){
return null;
} else {
return map.addLayer(layer,id_string);
}
});

hatti.map.utils.add_mapboxgl_layer.cljs$lang$maxFixedArity = (3);

hatti.map.utils.add_mapboxgl_layer.cljs$lang$applyTo = (function (seq20340){
var G__20341 = cljs.core.first.call(null,seq20340);
var seq20340__$1 = cljs.core.next.call(null,seq20340);
var G__20342 = cljs.core.first.call(null,seq20340__$1);
var seq20340__$2 = cljs.core.next.call(null,seq20340__$1);
var G__20343 = cljs.core.first.call(null,seq20340__$2);
var seq20340__$3 = cljs.core.next.call(null,seq20340__$2);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(G__20341,G__20342,G__20343,seq20340__$3);
});

/**
 * Generates a collection of input - output value pairs known
 * as stops. These stops are used by get-styles function to decide the style
 * output based on an input vaue from the dataset. e.g. _id. By defauly this
 *  function purely generates color stops.
 */
hatti.map.utils.generate_stops = (function hatti$map$utils$generate_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Generates cirlce size property stops base on values from dataset.
 */
hatti.map.utils.generate_size_stops = (function hatti$map$utils$generate_size_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(4)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Gets predefined styles for diffent layer types and states.
 */
hatti.map.utils.get_styles = (function hatti$map$utils$get_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20356 = arguments.length;
var i__7485__auto___20357 = (0);
while(true){
if((i__7485__auto___20357 < len__7484__auto___20356)){
args__7491__auto__.push((arguments[i__7485__auto___20357]));

var G__20358 = (i__7485__auto___20357 + (1));
i__7485__auto___20357 = G__20358;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic = (function (p__20352){
var vec__20353 = p__20352;
var selected_id = cljs.core.nth.call(null,vec__20353,(0),null);
var stops = cljs.core.nth.call(null,vec__20353,(1),null);
var size_stops = cljs.core.nth.call(null,vec__20353,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"point","point",1813198264),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",(4)], null)], null),new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#631400")], null))], null)], null),new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#ad2300")], null))], null)], null),new cljs.core.Keyword(null,"sized","sized",1886245611),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),(cljs.core.truth_(size_stops)?size_stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(6)], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-opacity",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"stops","stops",-1205459005),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),0.2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(15),0.8], null)], null)], null))], null)], null)], null),new cljs.core.Keyword(null,"fill","fill",883462889),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-opacity",0.7], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-outline-color","#666"], null)], null),new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#631400")], null))], null)], null),new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#ad2300")], null))], null)], null)], null),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-opacity",0.8], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-width",(7)], null)], null),new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#631400")], null))], null)], null),new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#ad2300")], null))], null)], null)], null)], null);
});

hatti.map.utils.get_styles.cljs$lang$maxFixedArity = (0);

hatti.map.utils.get_styles.cljs$lang$applyTo = (function (seq20351){
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20351));
});

/**
 * Get style properties for layer.
 */
hatti.map.utils.get_style_properties = (function hatti$map$utils$get_style_properties(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20365 = arguments.length;
var i__7485__auto___20366 = (0);
while(true){
if((i__7485__auto___20366 < len__7484__auto___20365)){
args__7491__auto__.push((arguments[i__7485__auto___20366]));

var G__20367 = (i__7485__auto___20366 + (1));
i__7485__auto___20366 = G__20367;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic = (function (style_type,style_state,p__20362){
var map__20363 = p__20362;
var map__20363__$1 = ((((!((map__20363 == null)))?((((map__20363.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20363.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20363):map__20363);
var selected_id = cljs.core.get.call(null,map__20363__$1,new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044));
var stops = cljs.core.get.call(null,map__20363__$1,new cljs.core.Keyword(null,"stops","stops",-1205459005));
return style_state.call(null,style_type.call(null,hatti.map.utils.get_styles.call(null,selected_id,stops)));
});

hatti.map.utils.get_style_properties.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_style_properties.cljs$lang$applyTo = (function (seq20359){
var G__20360 = cljs.core.first.call(null,seq20359);
var seq20359__$1 = cljs.core.next.call(null,seq20359);
var G__20361 = cljs.core.first.call(null,seq20359__$1);
var seq20359__$2 = cljs.core.next.call(null,seq20359__$1);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(G__20360,G__20361,seq20359__$2);
});

/**
 * Sets maps paint properties given layer-id and list of properties to set.
 *   properties should be a list of properties that contains the propery name
 *   and value in a vector. e.g. [[property1 value1] [property2 value2]
 */
hatti.map.utils.set_mapboxgl_paint_property = (function hatti$map$utils$set_mapboxgl_paint_property(map,layer_id,properties){
var seq__20378 = cljs.core.seq.call(null,properties);
var chunk__20379 = null;
var count__20380 = (0);
var i__20381 = (0);
while(true){
if((i__20381 < count__20380)){
var vec__20382 = cljs.core._nth.call(null,chunk__20379,i__20381);
var p = cljs.core.nth.call(null,vec__20382,(0),null);
var v = cljs.core.nth.call(null,vec__20382,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__20388 = seq__20378;
var G__20389 = chunk__20379;
var G__20390 = count__20380;
var G__20391 = (i__20381 + (1));
seq__20378 = G__20388;
chunk__20379 = G__20389;
count__20380 = G__20390;
i__20381 = G__20391;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__20378);
if(temp__4657__auto__){
var seq__20378__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20378__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__20378__$1);
var G__20392 = cljs.core.chunk_rest.call(null,seq__20378__$1);
var G__20393 = c__7220__auto__;
var G__20394 = cljs.core.count.call(null,c__7220__auto__);
var G__20395 = (0);
seq__20378 = G__20392;
chunk__20379 = G__20393;
count__20380 = G__20394;
i__20381 = G__20395;
continue;
} else {
var vec__20385 = cljs.core.first.call(null,seq__20378__$1);
var p = cljs.core.nth.call(null,vec__20385,(0),null);
var v = cljs.core.nth.call(null,vec__20385,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__20396 = cljs.core.next.call(null,seq__20378__$1);
var G__20397 = null;
var G__20398 = (0);
var G__20399 = (0);
seq__20378 = G__20396;
chunk__20379 = G__20397;
count__20380 = G__20398;
i__20381 = G__20399;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.utils.get_id_property = (function hatti$map$utils$get_id_property(features){
var properties = (cljs.core.first.call(null,features)["properties"]);
var or__6409__auto__ = (properties["id"]);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return (properties[hatti.constants._id]);
}
});
/**
 * Register map mouse events.
 */
hatti.map.utils.register_mapboxgl_mouse_events = (function hatti$map$utils$register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style){
var layer_id = id_string;
var mousemove_fn = ((function (layer_id){
return (function (e){
if(cljs.core.truth_(map.getLayer(layer_id))){
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"layers","layers",1944875032),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.call(null,owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"view-by","view-by",1005248583)], null));
var selected_id = om.core.get_props.call(null,owner,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
map.getCanvas().style.cursor = (((features.length > (0)))?"pointer":"");

if(cljs.core.truth_(view_by)){
return null;
} else {
if(cljs.core._EQ_.call(null,no_of_features,(1))){
return hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044),hatti.map.utils.get_id_property.call(null,features)));
} else {
hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"normal","normal",-1519123858)));

if(cljs.core.truth_(selected_id)){
return hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044),selected_id));
} else {
return null;
}
}
}
} else {
return null;
}
});})(layer_id))
;
var click_fn = ((function (layer_id,mousemove_fn){
return (function (e){
if(cljs.core.truth_(map.getLayer(layer_id))){
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"layers","layers",1944875032),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.call(null,owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"view-by","view-by",1005248583)], null));
if((no_of_features > (0))){
var feature_id = hatti.map.utils.get_id_property.call(null,features);
cljs.core.async.put_BANG_.call(null,event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mapped-submission-to-id","mapped-submission-to-id",-1148058736),feature_id], null));

if(cljs.core.truth_(view_by)){
return null;
} else {
return hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044),feature_id));
}
} else {
return null;
}
} else {
return null;
}
});})(layer_id,mousemove_fn))
;
map.off("mousemove",om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"mousemove-fn","mousemove-fn",288658931)));

map.off("click",om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"click-fn","click-fn",2099562548)));

map.on("mousemove",mousemove_fn);

map.on("click",click_fn);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"mousemove-fn","mousemove-fn",288658931),mousemove_fn);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"click-fn","click-fn",2099562548),click_fn);
});
/**
 * Fits map boundaries on rendered features.
 */
hatti.map.utils.fitMapBounds = (function hatti$map$utils$fitMapBounds(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20407 = arguments.length;
var i__7485__auto___20408 = (0);
while(true){
if((i__7485__auto___20408 < len__7484__auto___20407)){
args__7491__auto__.push((arguments[i__7485__auto___20408]));

var G__20409 = (i__7485__auto___20408 + (1));
i__7485__auto___20408 = G__20409;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__20403){
var vec__20404 = p__20403;
var geojson = cljs.core.nth.call(null,vec__20404,(0),null);
var features = (function (){var or__6409__auto__ = new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = (cljs.core.truth_(map.getLayer(layer_id))?map.queryRenderedFeatures(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"layers","layers",1944875032),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null))):null);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return cljs.core.PersistentVector.EMPTY;
}
}
})();
var layer_data = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"FeatureCollection",new cljs.core.Keyword(null,"features","features",-1146962336),features], null));
}
})();
var bbox = turf.bbox(cljs.core.clj__GT_js.call(null,layer_data));
if((cljs.core.count.call(null,features) > (0))){
return map.fitBounds(bbox,({"padding": "15", "linear": true}));
} else {
return null;
}
});

hatti.map.utils.fitMapBounds.cljs$lang$maxFixedArity = (2);

hatti.map.utils.fitMapBounds.cljs$lang$applyTo = (function (seq20400){
var G__20401 = cljs.core.first.call(null,seq20400);
var seq20400__$1 = cljs.core.next.call(null,seq20400);
var G__20402 = cljs.core.first.call(null,seq20400__$1);
var seq20400__$2 = cljs.core.next.call(null,seq20400__$1);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic(G__20401,G__20402,seq20400__$2);
});

/**
 * Get marker style for field type.
 */
hatti.map.utils.geotype__GT_marker_style = (function hatti$map$utils$geotype__GT_marker_style(p__20410){
var map__20413 = p__20410;
var map__20413__$1 = ((((!((map__20413 == null)))?((((map__20413.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20413.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20413):map__20413);
var field = map__20413__$1;
var children = cljs.core.get.call(null,map__20413__$1,new cljs.core.Keyword(null,"children","children",-940561982));
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.geoshape_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.osm_QMARK_.call(null,field);
}
})())){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"layer-type","layer-type",816560917),"fill",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"fill","fill",883462889)], null);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.geotrace_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var and__6397__auto__ = hatti.ona.forms.repeat_QMARK_.call(null,field);
if(cljs.core.truth_(and__6397__auto__)){
return hatti.ona.forms.geotrace_QMARK_.call(null,cljs.core.first.call(null,children));
} else {
return and__6397__auto__;
}
}
})())){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"layer-type","layer-type",816560917),"line",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"layout","layout",-2120940921),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line-join","line-join",-1560936092),"round",new cljs.core.Keyword(null,"line-cap","line-cap",448406012),"round"], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"layer-type","layer-type",816560917),"circle",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"point","point",1813198264)], null);

}
}
});
/**
 * Filter features and return only selected features. Returns all features
 *   features if selected-ids is nil. 
 */
hatti.map.utils.filter_selected_features = (function hatti$map$utils$filter_selected_features(features,selected_ids){
var G__20421 = features;
if(cljs.core.truth_(selected_ids)){
return cljs.core.filter.call(null,((function (G__20421){
return (function (p__20422){
var map__20423 = p__20422;
var map__20423__$1 = ((((!((map__20423 == null)))?((((map__20423.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20423.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20423):map__20423);
var map__20424 = cljs.core.get.call(null,map__20423__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var map__20424__$1 = ((((!((map__20424 == null)))?((((map__20424.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20424.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20424):map__20424);
var _id = cljs.core.get.call(null,map__20424__$1,new cljs.core.Keyword(null,"_id","_id",-789960287));
return chimera.seq.in_QMARK_.call(null,selected_ids,_id);
});})(G__20421))
,G__20421);
} else {
return G__20421;
}
});
/**
 * Counts points collected into hexbins.
 */
hatti.map.utils.count_hexbin_points = (function hatti$map$utils$count_hexbin_points(hexbins){
var iter__7189__auto__ = (function hatti$map$utils$count_hexbin_points_$_iter__20447(s__20448){
return (new cljs.core.LazySeq(null,(function (){
var s__20448__$1 = s__20448;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20448__$1);
if(temp__4657__auto__){
var s__20448__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20448__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20448__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20450 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20449 = (0);
while(true){
if((i__20449 < size__7188__auto__)){
var map__20459 = cljs.core._nth.call(null,c__7187__auto__,i__20449);
var map__20459__$1 = ((((!((map__20459 == null)))?((((map__20459.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20459.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20459):map__20459);
var feature = map__20459__$1;
var map__20460 = cljs.core.get.call(null,map__20459__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var map__20460__$1 = ((((!((map__20460 == null)))?((((map__20460.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20460.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20460):map__20460);
var points = cljs.core.get.call(null,map__20460__$1,new cljs.core.Keyword(null,"points","points",-1486596883));
var point_count = cljs.core.count.call(null,points);
cljs.core.chunk_append.call(null,b__20450,(((point_count > (0)))?cljs.core.assoc.call(null,feature,new cljs.core.Keyword(null,"properties","properties",685819552),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"point-count","point-count",-234732819),point_count], null)):null));

var G__20467 = (i__20449 + (1));
i__20449 = G__20467;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20450),hatti$map$utils$count_hexbin_points_$_iter__20447.call(null,cljs.core.chunk_rest.call(null,s__20448__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20450),null);
}
} else {
var map__20463 = cljs.core.first.call(null,s__20448__$2);
var map__20463__$1 = ((((!((map__20463 == null)))?((((map__20463.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20463.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20463):map__20463);
var feature = map__20463__$1;
var map__20464 = cljs.core.get.call(null,map__20463__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var map__20464__$1 = ((((!((map__20464 == null)))?((((map__20464.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20464.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20464):map__20464);
var points = cljs.core.get.call(null,map__20464__$1,new cljs.core.Keyword(null,"points","points",-1486596883));
var point_count = cljs.core.count.call(null,points);
return cljs.core.cons.call(null,(((point_count > (0)))?cljs.core.assoc.call(null,feature,new cljs.core.Keyword(null,"properties","properties",685819552),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"point-count","point-count",-234732819),point_count], null)):null),hatti$map$utils$count_hexbin_points_$_iter__20447.call(null,cljs.core.rest.call(null,s__20448__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(hexbins));
});
hatti.map.utils.get_rendered_features = (function hatti$map$utils$get_rendered_features(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20475 = arguments.length;
var i__7485__auto___20476 = (0);
while(true){
if((i__7485__auto___20476 < len__7484__auto___20475)){
args__7491__auto__.push((arguments[i__7485__auto___20476]));

var G__20477 = (i__7485__auto___20476 + (1));
i__7485__auto___20476 = G__20477;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__20472){
var map__20473 = p__20472;
var map__20473__$1 = ((((!((map__20473 == null)))?((((map__20473.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20473.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20473):map__20473);
var geojson = cljs.core.get.call(null,map__20473__$1,new cljs.core.Keyword(null,"geojson","geojson",-719473398));
var selected_ids = cljs.core.get.call(null,map__20473__$1,new cljs.core.Keyword(null,"selected-ids","selected-ids",-1154760141));

var get_rendered_features = ((function (map__20473,map__20473__$1,geojson,selected_ids){
return (function (){
return map.queryRenderedFeatures(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"layers","layers",1944875032),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
});})(map__20473,map__20473__$1,geojson,selected_ids))
;
var rendered_features = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"FeatureCollection",new cljs.core.Keyword(null,"features","features",-1146962336),get_rendered_features.call(null)], null);
}
})();
return cljs.core.update_in.call(null,rendered_features,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"features","features",-1146962336)], null),((function (get_rendered_features,rendered_features,map__20473,map__20473__$1,geojson,selected_ids){
return (function (p1__20468_SHARP_){
return hatti.map.utils.filter_selected_features.call(null,p1__20468_SHARP_,selected_ids);
});})(get_rendered_features,rendered_features,map__20473,map__20473__$1,geojson,selected_ids))
);
});

hatti.map.utils.get_rendered_features.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_rendered_features.cljs$lang$applyTo = (function (seq20469){
var G__20470 = cljs.core.first.call(null,seq20469);
var seq20469__$1 = cljs.core.next.call(null,seq20469);
var G__20471 = cljs.core.first.call(null,seq20469__$1);
var seq20469__$2 = cljs.core.next.call(null,seq20469__$1);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(G__20470,G__20471,seq20469__$2);
});

/**
 * Generates hexbins with point count aggregation given rendered
 *   layer-id or geojson.
 */
hatti.map.utils.generate_hexgrid = (function hatti$map$utils$generate_hexgrid(map,layer_id,geojson,p__20478){
var map__20485 = p__20478;
var map__20485__$1 = ((((!((map__20485 == null)))?((((map__20485.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20485.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20485):map__20485);
var cell_width = cljs.core.get.call(null,map__20485__$1,new cljs.core.Keyword(null,"cell-width","cell-width",1767835816));
var selected_ids = cljs.core.get.call(null,map__20485__$1,new cljs.core.Keyword(null,"selected-ids","selected-ids",-1154760141));
var rendered_features = hatti.map.utils.get_rendered_features.call(null,map,layer_id,new cljs.core.Keyword(null,"geojson","geojson",-719473398),geojson,new cljs.core.Keyword(null,"selected-ids","selected-ids",-1154760141),selected_ids);
var js_rendered_features = cljs.core.clj__GT_js.call(null,rendered_features);
var bbox = turf.bbox(js_rendered_features);
var cellWidth = (function (){var or__6409__auto__ = cell_width;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.hexbin_cell_width;
}
})();
var units = "kilometers";
var hexgrid = turf.hexGrid(bbox,cellWidth,units);
var hex_collection = turf.collect(hexgrid,js_rendered_features,"_id","points");
var hexbins = cljs.core.js__GT_clj.call(null,hex_collection,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var features_w_count = cljs.core.remove.call(null,cljs.core.nil_QMARK_,hatti.map.utils.count_hexbin_points.call(null,hexbins));
var point_counts = (function (){var iter__7189__auto__ = ((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__20485,map__20485__$1,cell_width,selected_ids){
return (function hatti$map$utils$generate_hexgrid_$_iter__20487(s__20488){
return (new cljs.core.LazySeq(null,((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__20485,map__20485__$1,cell_width,selected_ids){
return (function (){
var s__20488__$1 = s__20488;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20488__$1);
if(temp__4657__auto__){
var s__20488__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20488__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20488__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20490 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20489 = (0);
while(true){
if((i__20489 < size__7188__auto__)){
var f = cljs.core._nth.call(null,c__7187__auto__,i__20489);
cljs.core.chunk_append.call(null,b__20490,new cljs.core.Keyword(null,"point-count","point-count",-234732819).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(f)));

var G__20491 = (i__20489 + (1));
i__20489 = G__20491;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20490),hatti$map$utils$generate_hexgrid_$_iter__20487.call(null,cljs.core.chunk_rest.call(null,s__20488__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20490),null);
}
} else {
var f = cljs.core.first.call(null,s__20488__$2);
return cljs.core.cons.call(null,new cljs.core.Keyword(null,"point-count","point-count",-234732819).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(f)),hatti$map$utils$generate_hexgrid_$_iter__20487.call(null,cljs.core.rest.call(null,s__20488__$2)));
}
} else {
return null;
}
break;
}
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__20485,map__20485__$1,cell_width,selected_ids))
,null,null));
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__20485,map__20485__$1,cell_width,selected_ids))
;
return iter__7189__auto__.call(null,features_w_count);
})();
return cljs.core.assoc.call(null,hexbins,new cljs.core.Keyword(null,"features","features",-1146962336),features_w_count,new cljs.core.Keyword(null,"properties","properties",685819552),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"min-count","min-count",1594709013),cljs.core.apply.call(null,cljs.core.min,point_counts),new cljs.core.Keyword(null,"max-count","max-count",1539185305),cljs.core.apply.call(null,cljs.core.max,point_counts)], null));
});
/**
 * Show/or hide geopoints. Hide geopoints if hide-points is true.
 */
hatti.map.utils.show_hide_points = (function hatti$map$utils$show_hide_points(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20499 = arguments.length;
var i__7485__auto___20500 = (0);
while(true){
if((i__7485__auto___20500 < len__7484__auto___20499)){
args__7491__auto__.push((arguments[i__7485__auto___20500]));

var G__20501 = (i__7485__auto___20500 + (1));
i__7485__auto___20500 = G__20501;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__20495){
var vec__20496 = p__20495;
var hide_points_QMARK_ = cljs.core.nth.call(null,vec__20496,(0),null);
var visibility = (cljs.core.truth_(hide_points_QMARK_)?"none":"visible");
if(cljs.core.truth_(map.getLayer(layer_id))){
map.setLayoutProperty(layer_id,"visibility",visibility);
} else {
}

if(cljs.core.truth_(map.getLayer(hatti.map.utils.circle_border_id))){
return map.setLayoutProperty(hatti.map.utils.circle_border_id,"visibility",visibility);
} else {
return null;
}
});

hatti.map.utils.show_hide_points.cljs$lang$maxFixedArity = (2);

hatti.map.utils.show_hide_points.cljs$lang$applyTo = (function (seq20492){
var G__20493 = cljs.core.first.call(null,seq20492);
var seq20492__$1 = cljs.core.next.call(null,seq20492);
var G__20494 = cljs.core.first.call(null,seq20492__$1);
var seq20492__$2 = cljs.core.next.call(null,seq20492__$1);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(G__20493,G__20494,seq20492__$2);
});

/**
 * Remove layer from map and it's source from map.
 */
hatti.map.utils.remove_layer = (function hatti$map$utils$remove_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20508 = arguments.length;
var i__7485__auto___20509 = (0);
while(true){
if((i__7485__auto___20509 < len__7484__auto___20508)){
args__7491__auto__.push((arguments[i__7485__auto___20509]));

var G__20510 = (i__7485__auto___20509 + (1));
i__7485__auto___20509 = G__20510;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id,p__20505){
var map__20506 = p__20505;
var map__20506__$1 = ((((!((map__20506 == null)))?((((map__20506.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20506.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20506):map__20506);
var keep_source_QMARK_ = cljs.core.get.call(null,map__20506__$1,new cljs.core.Keyword(null,"keep-source?","keep-source?",1217063318));
if(cljs.core.truth_(map.getLayer(id))){
map.removeLayer(id);
} else {
}

if(cljs.core.truth_((function (){var and__6397__auto__ = map.getSource(id);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not.call(null,keep_source_QMARK_);
} else {
return and__6397__auto__;
}
})())){
return map.removeSource(id);
} else {
return null;
}
});

hatti.map.utils.remove_layer.cljs$lang$maxFixedArity = (2);

hatti.map.utils.remove_layer.cljs$lang$applyTo = (function (seq20502){
var G__20503 = cljs.core.first.call(null,seq20502);
var seq20502__$1 = cljs.core.next.call(null,seq20502);
var G__20504 = cljs.core.first.call(null,seq20502__$1);
var seq20502__$2 = cljs.core.next.call(null,seq20502__$1);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(G__20503,G__20504,seq20502__$2);
});

/**
 * Renders hexbin layer on map.
 */
hatti.map.utils.show_hexbins = (function hatti$map$utils$show_hexbins(owner,map,id_string,geojson,p__20511){
var map__20516 = p__20511;
var map__20516__$1 = ((((!((map__20516 == null)))?((((map__20516.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20516.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20516):map__20516);
var opts = map__20516__$1;
var cell_color = cljs.core.get.call(null,map__20516__$1,new cljs.core.Keyword(null,"cell-color","cell-color",83713438));
var extrusion_QMARK_ = cljs.core.get.call(null,map__20516__$1,new cljs.core.Keyword(null,"extrusion?","extrusion?",-220604176));
var hide_points_QMARK_ = cljs.core.get.call(null,map__20516__$1,new cljs.core.Keyword(null,"hide-points?","hide-points?",-532207870));
var hexgrid = hatti.map.utils.generate_hexgrid.call(null,map,id_string,geojson,opts);
var map__20518 = new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(hexgrid);
var map__20518__$1 = ((((!((map__20518 == null)))?((((map__20518.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20518.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20518):map__20518);
var min_count = cljs.core.get.call(null,map__20518__$1,new cljs.core.Keyword(null,"min-count","min-count",1594709013));
var max_count = cljs.core.get.call(null,map__20518__$1,new cljs.core.Keyword(null,"max-count","max-count",1539185305));
var max_color = (function (){var or__6409__auto__ = cell_color;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.max_count_color;
}
})();
var min_color = ((cljs.core._EQ_.call(null,min_count,max_count))?max_color:hatti.constants.min_count_color);
var property = "point-count";
var fill_color = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"property","property",-1114278232),"point-count",new cljs.core.Keyword(null,"stops","stops",-1205459005),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,min_color], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,max_color], null)], null)], null);
var fill_opacity = 0.6;
var paint = (cljs.core.truth_(extrusion_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fill-extrusion-color","fill-extrusion-color",-825219524),fill_color,new cljs.core.Keyword(null,"fill-extrusion-opacity","fill-extrusion-opacity",-457270565),fill_opacity,new cljs.core.Keyword(null,"fill-extrusion-height","fill-extrusion-height",933696521),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),property,new cljs.core.Keyword(null,"stops","stops",-1205459005),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,(10)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,(25000)], null)], null),new cljs.core.Keyword(null,"base","base",185279322),(1)], null)], null):new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fill-outline-color","fill-outline-color",1960554289),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"property","property",-1114278232),property,new cljs.core.Keyword(null,"stops","stops",-1205459005),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,"white"], null)], null)], null),new cljs.core.Keyword(null,"fill-color","fill-color",-1156875903),fill_color,new cljs.core.Keyword(null,"fill-opacity","fill-opacity",-537571170),fill_opacity], null));
var layer_type = (cljs.core.truth_(extrusion_QMARK_)?"fill-extrusion":"fill");
var extrusion_layer_id = [cljs.core.str(hatti.constants.hexgrid_id),cljs.core.str("-extrusion")].join('');
if(cljs.core.truth_((function (){var and__6397__auto__ = min_count;
if(cljs.core.truth_(and__6397__auto__)){
return max_count;
} else {
return and__6397__auto__;
}
})())){
hatti.map.utils.add_mapboxgl_source.call(null,map,hatti.constants.hexgrid_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"geojson","geojson",-719473398),hexgrid], null));

hatti.map.utils.add_mapboxgl_layer.call(null,map,hatti.constants.hexgrid_id,layer_type,new cljs.core.Keyword(null,"paint","paint",1531901299),paint);

if(cljs.core.truth_(extrusion_QMARK_)){
hatti.map.utils.add_mapboxgl_layer.call(null,map,hatti.constants.hexgrid_id,layer_type,new cljs.core.Keyword(null,"paint","paint",1531901299),paint,new cljs.core.Keyword(null,"layer-id","layer-id",576786958),extrusion_layer_id);

map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","none");
} else {
map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","visible");

hatti.map.utils.remove_layer.call(null,map,extrusion_layer_id,new cljs.core.Keyword(null,"keep-source?","keep-source?",1217063318),true);
}

map.setPitch((cljs.core.truth_(extrusion_QMARK_)?(50):(0)));

hatti.map.utils.show_hide_points.call(null,map,id_string,hide_points_QMARK_);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"show-hexbins?","show-hexbins?",1460257258),true);
} else {
return null;
}
});
/**
 * Renders heatmap layer on map.
 */
hatti.map.utils.show_heatmap = (function hatti$map$utils$show_heatmap(owner,map,id_string,geojson,p__20520){
var map__20539 = p__20520;
var map__20539__$1 = ((((!((map__20539 == null)))?((((map__20539.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20539.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20539):map__20539);
var selected_ids = cljs.core.get.call(null,map__20539__$1,new cljs.core.Keyword(null,"selected-ids","selected-ids",-1154760141));
var rendered_features = hatti.map.utils.get_rendered_features.call(null,map,id_string,new cljs.core.Keyword(null,"geojson","geojson",-719473398),geojson,new cljs.core.Keyword(null,"selected-ids","selected-ids",-1154760141),selected_ids);
var layers = cljs.core.map_indexed.call(null,((function (rendered_features,map__20539,map__20539__$1,selected_ids){
return (function (idx,item){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,item], null);
});})(rendered_features,map__20539,map__20539__$1,selected_ids))
,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"green"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(30),"#ffeda0"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(80),"orange"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),"red"], null)], null));
var layer_count = cljs.core.count.call(null,layers);
hatti.map.utils.add_mapboxgl_source.call(null,map,"heatmap",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"geojson","geojson",-719473398),rendered_features,new cljs.core.Keyword(null,"cluster","cluster",535175621),true,new cljs.core.Keyword(null,"clusterRadius","clusterRadius",-1512735857),(20),new cljs.core.Keyword(null,"clusterMaxZoom","clusterMaxZoom",-627685763),(15)], null));

var seq__20541_20557 = cljs.core.seq.call(null,layers);
var chunk__20542_20558 = null;
var count__20543_20559 = (0);
var i__20544_20560 = (0);
while(true){
if((i__20544_20560 < count__20543_20559)){
var vec__20545_20561 = cljs.core._nth.call(null,chunk__20542_20558,i__20544_20560);
var i_20562 = cljs.core.nth.call(null,vec__20545_20561,(0),null);
var vec__20548_20563 = cljs.core.nth.call(null,vec__20545_20561,(1),null);
var point_count_20564 = cljs.core.nth.call(null,vec__20548_20563,(0),null);
var color_20565 = cljs.core.nth.call(null,vec__20548_20563,(1),null);
hatti.map.utils.add_mapboxgl_layer.call(null,map,"heatmap","circle",new cljs.core.Keyword(null,"layer-id","layer-id",576786958),[cljs.core.str("cluster-"),cljs.core.str(i_20562)].join(''),new cljs.core.Keyword(null,"paint","paint",1531901299),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"circle-color","circle-color",-304052871),color_20565,new cljs.core.Keyword(null,"circle-radius","circle-radius",-1126504347),(70),new cljs.core.Keyword(null,"circle-blur","circle-blur",-1977913481),(1),new cljs.core.Keyword(null,"circle-opacity","circle-opacity",-1772785627),0.7], null),new cljs.core.Keyword(null,"filter","filter",-948537934),((cljs.core._EQ_.call(null,i_20562,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_20564], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_20564], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first.call(null,cljs.core.second.call(null,cljs.core.nth.call(null,layers,(i_20562 + (1)))))], null)], null)));

var G__20566 = seq__20541_20557;
var G__20567 = chunk__20542_20558;
var G__20568 = count__20543_20559;
var G__20569 = (i__20544_20560 + (1));
seq__20541_20557 = G__20566;
chunk__20542_20558 = G__20567;
count__20543_20559 = G__20568;
i__20544_20560 = G__20569;
continue;
} else {
var temp__4657__auto___20570 = cljs.core.seq.call(null,seq__20541_20557);
if(temp__4657__auto___20570){
var seq__20541_20571__$1 = temp__4657__auto___20570;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20541_20571__$1)){
var c__7220__auto___20572 = cljs.core.chunk_first.call(null,seq__20541_20571__$1);
var G__20573 = cljs.core.chunk_rest.call(null,seq__20541_20571__$1);
var G__20574 = c__7220__auto___20572;
var G__20575 = cljs.core.count.call(null,c__7220__auto___20572);
var G__20576 = (0);
seq__20541_20557 = G__20573;
chunk__20542_20558 = G__20574;
count__20543_20559 = G__20575;
i__20544_20560 = G__20576;
continue;
} else {
var vec__20551_20577 = cljs.core.first.call(null,seq__20541_20571__$1);
var i_20578 = cljs.core.nth.call(null,vec__20551_20577,(0),null);
var vec__20554_20579 = cljs.core.nth.call(null,vec__20551_20577,(1),null);
var point_count_20580 = cljs.core.nth.call(null,vec__20554_20579,(0),null);
var color_20581 = cljs.core.nth.call(null,vec__20554_20579,(1),null);
hatti.map.utils.add_mapboxgl_layer.call(null,map,"heatmap","circle",new cljs.core.Keyword(null,"layer-id","layer-id",576786958),[cljs.core.str("cluster-"),cljs.core.str(i_20578)].join(''),new cljs.core.Keyword(null,"paint","paint",1531901299),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"circle-color","circle-color",-304052871),color_20581,new cljs.core.Keyword(null,"circle-radius","circle-radius",-1126504347),(70),new cljs.core.Keyword(null,"circle-blur","circle-blur",-1977913481),(1),new cljs.core.Keyword(null,"circle-opacity","circle-opacity",-1772785627),0.7], null),new cljs.core.Keyword(null,"filter","filter",-948537934),((cljs.core._EQ_.call(null,i_20578,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_20580], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_20580], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first.call(null,cljs.core.second.call(null,cljs.core.nth.call(null,layers,(i_20578 + (1)))))], null)], null)));

var G__20582 = cljs.core.next.call(null,seq__20541_20571__$1);
var G__20583 = null;
var G__20584 = (0);
var G__20585 = (0);
seq__20541_20557 = G__20582;
chunk__20542_20558 = G__20583;
count__20543_20559 = G__20584;
i__20544_20560 = G__20585;
continue;
}
} else {
}
}
break;
}

hatti.map.utils.show_hide_points.call(null,map,id_string,true);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"show-heatmap?","show-heatmap?",-1605811668),true);
});
/**
 * Functions that are called after map is loaded in DOM.
 */
hatti.map.utils.map_on_load = (function hatti$map$utils$map_on_load(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20597 = arguments.length;
var i__7485__auto___20598 = (0);
while(true){
if((i__7485__auto___20598 < len__7484__auto___20597)){
args__7491__auto__.push((arguments[i__7485__auto___20598]));

var G__20599 = (i__7485__auto___20598 + (1));
i__7485__auto___20598 = G__20599;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic = (function (map,event_chan,id_string,p__20590){
var map__20591 = p__20590;
var map__20591__$1 = ((((!((map__20591 == null)))?((((map__20591.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20591.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20591):map__20591);
var map_data = map__20591__$1;
var geofield = cljs.core.get.call(null,map__20591__$1,new cljs.core.Keyword(null,"geofield","geofield",578715548));
var owner = cljs.core.get.call(null,map__20591__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var tiles_url = cljs.core.get.call(null,map__20591__$1,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944));
var geojson = cljs.core.get.call(null,map__20591__$1,new cljs.core.Keyword(null,"geojson","geojson",-719473398));
var map__20593 = hatti.map.utils.geotype__GT_marker_style.call(null,geofield);
var map__20593__$1 = ((((!((map__20593 == null)))?((((map__20593.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20593.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20593):map__20593);
var layer_type = cljs.core.get.call(null,map__20593__$1,new cljs.core.Keyword(null,"layer-type","layer-type",816560917));
var layout = cljs.core.get.call(null,map__20593__$1,new cljs.core.Keyword(null,"layout","layout",-2120940921));
var style = cljs.core.get.call(null,map__20593__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var map__20594 = om.core.get_state.call(null,owner);
var map__20594__$1 = ((((!((map__20594 == null)))?((((map__20594.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20594.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20594):map__20594);
var stops = cljs.core.get.call(null,map__20594__$1,new cljs.core.Keyword(null,"stops","stops",-1205459005));
var layer_opts = cljs.core.get.call(null,map__20594__$1,new cljs.core.Keyword(null,"layer-opts","layer-opts",1764398639));
var show_hexbins_QMARK_ = cljs.core.get.call(null,map__20594__$1,new cljs.core.Keyword(null,"show-hexbins?","show-hexbins?",1460257258));
var show_heatmap_QMARK_ = cljs.core.get.call(null,map__20594__$1,new cljs.core.Keyword(null,"show-heatmap?","show-heatmap?",-1605811668));
if(cljs.core.truth_((function (){var or__6409__auto__ = (cljs.core.count.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson)) > (0));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return tiles_url;
}
})())){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"loaded?","loaded?",-1108015206),false);

hatti.map.utils.add_mapboxgl_source.call(null,map,id_string,map_data);

hatti.map.utils.add_mapboxgl_layer.call(null,map,id_string,layer_type,new cljs.core.Keyword(null,"layout","layout",-2120940921),layout,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944),tiles_url);

hatti.map.utils.register_mapboxgl_mouse_events.call(null,owner,map,event_chan,id_string,style);

hatti.map.utils.set_mapboxgl_paint_property.call(null,map,id_string,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"stops","stops",-1205459005),stops));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"point","point",1813198264),style)){
hatti.map.utils.add_mapboxgl_layer.call(null,map,id_string,layer_type,new cljs.core.Keyword(null,"layer-id","layer-id",576786958),hatti.map.utils.circle_border_id,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944),tiles_url,new cljs.core.Keyword(null,"paint","paint",1531901299),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"circle-color","circle-color",-304052871),"#fff",new cljs.core.Keyword(null,"circle-radius","circle-radius",-1126504347),(6)], null));
} else {
if(cljs.core.truth_(map.getLayer(hatti.map.utils.circle_border_id))){
map.removeLayer(hatti.map.utils.circle_border_id);
} else {
}
}

if(cljs.core.truth_(show_hexbins_QMARK_)){
hatti.map.utils.show_hexbins.call(null,owner,map,id_string,geojson,layer_opts);
} else {
}

if(cljs.core.truth_(show_heatmap_QMARK_)){
hatti.map.utils.show_heatmap.call(null,owner,map,id_string,geojson,layer_opts);
} else {
}

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"geojson","geojson",-719473398),geojson);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"style","style",-496642736),style);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"loaded?","loaded?",-1108015206),true);
} else {
return null;
}
});

hatti.map.utils.map_on_load.cljs$lang$maxFixedArity = (3);

hatti.map.utils.map_on_load.cljs$lang$applyTo = (function (seq20586){
var G__20587 = cljs.core.first.call(null,seq20586);
var seq20586__$1 = cljs.core.next.call(null,seq20586);
var G__20588 = cljs.core.first.call(null,seq20586__$1);
var seq20586__$2 = cljs.core.next.call(null,seq20586__$1);
var G__20589 = cljs.core.first.call(null,seq20586__$2);
var seq20586__$3 = cljs.core.next.call(null,seq20586__$2);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic(G__20587,G__20588,G__20589,seq20586__$3);
});

/**
 * Set default style
 */
hatti.map.utils.clear_map_styles = (function hatti$map$utils$clear_map_styles(owner){
return hatti.map.utils.set_mapboxgl_paint_property.call(null,om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"mapboxgl-map","mapboxgl-map",1585466246)),om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"layer-id","layer-id",576786958)),hatti.map.utils.get_style_properties.call(null,om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"style","style",-496642736)),new cljs.core.Keyword(null,"normal","normal",-1519123858)));
});
/**
 * Update map zoom level in local component state on zoom event.
 */
hatti.map.utils.set_zoom_level = (function hatti$map$utils$set_zoom_level(owner){
var map__20602 = om.core.get_state.call(null,owner);
var map__20602__$1 = ((((!((map__20602 == null)))?((((map__20602.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20602.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20602):map__20602);
var mapboxgl_map = cljs.core.get.call(null,map__20602__$1,new cljs.core.Keyword(null,"mapboxgl-map","mapboxgl-map",1585466246));
var zoom = cljs.core.get.call(null,map__20602__$1,new cljs.core.Keyword(null,"zoom","zoom",-1827487038));
var next_zoom = mapboxgl_map.getZoom();
if(cljs.core.not_EQ_.call(null,zoom,next_zoom)){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"zoom","zoom",-1827487038),next_zoom);
} else {
return null;
}
});
