// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0))], 0))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__38447_SHARP_){
if(typeof p1__38447_SHARP_ === 'string'){
return clojure.string.lower_case(p1__38447_SHARP_);
} else {
return p1__38447_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__38453){
var vec__38454 = p__38453;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38454,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38454,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__38448_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__38448_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var media_count = (dataContext["_media_count"]);
var total_media = (dataContext["_total_media"]);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,chimera.string.escape_for_type(clj_value),cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true,cljs.core.cst$kw$field_DASH_key,field_key,cljs.core.cst$kw$media_DASH_count,media_count,cljs.core.cst$kw$total_DASH_media,total_media], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__38457 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__38457__$1 = ((((!((map__38457 == null)))?((((map__38457.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38457.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38457):map__38457);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38457__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38457__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38457__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$delete_DASH_record,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$data_DASH_id,value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_eye,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.actions_column.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
}));
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38490 = arguments.length;
var i__7485__auto___38491 = (0);
while(true){
if((i__7485__auto___38491 < len__7484__auto___38490)){
args__7491__auto__.push((arguments[i__7485__auto___38491]));

var G__38492 = (i__7485__auto___38491 + (1));
i__7485__auto___38491 = G__38492;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__38462){
var map__38463 = p__38462;
var map__38463__$1 = ((((!((map__38463 == null)))?((((map__38463.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38463.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38463):map__38463);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38463__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38463__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38463__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38463__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__38465 = cljs.core.false_QMARK_;
var G__38466 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__38465,map__38463,map__38463__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__38459_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__38459_SHARP_)) == null);
});})(G__38465,map__38463,map__38463__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__38465,G__38466) : chimera.core.any_QMARK_.call(null,G__38465,G__38466));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__38463,map__38463__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__38467(s__38468){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__38463,map__38463__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__38468__$1 = s__38468;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38468__$1);
if(temp__4657__auto__){
var s__38468__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38468__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38468__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38470 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38469 = (0);
while(true){
if((i__38469 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38469);
cljs.core.chunk_append(b__38470,(function (){var map__38481 = field;
var map__38481__$1 = ((((!((map__38481 == null)))?((((map__38481.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38481.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38481):map__38481);
var map__38482 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38481__$1,cljs.core.cst$kw$instance);
var map__38482__$1 = ((((!((map__38482 == null)))?((((map__38482.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38482.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38482):map__38482);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38482__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38481__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38481__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38481__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__38493 = (i__38469 + (1));
i__38469 = G__38493;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38470),hatti$views$table$iter__38467(cljs.core.chunk_rest(s__38468__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38470),null);
}
} else {
var field = cljs.core.first(s__38468__$2);
return cljs.core.cons((function (){var map__38485 = field;
var map__38485__$1 = ((((!((map__38485 == null)))?((((map__38485.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38485.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38485):map__38485);
var map__38486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38485__$1,cljs.core.cst$kw$instance);
var map__38486__$1 = ((((!((map__38486 == null)))?((((map__38486.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38486.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38486):map__38486);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38486__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38485__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38485__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38485__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__38467(cljs.core.rest(s__38468__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__38463,map__38463__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__38463,map__38463__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields(form));
})();
return cljs.core.clj__GT_js((function (){var G__38489 = columns;
if(cljs.core.not(hide_actions_column_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__38489,(hatti.views.actions_column.cljs$core$IFn$_invoke$arity$2 ? hatti.views.actions_column.cljs$core$IFn$_invoke$arity$2(owner,has_hxl_QMARK_) : hatti.views.actions_column.call(null,owner,has_hxl_QMARK_)));
} else {
return G__38489;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq38460){
var G__38461 = cljs.core.first(seq38460);
var seq38460__$1 = cljs.core.next(seq38460);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__38461,seq38460__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__38495 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__38495);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38514(s__38515){
return (new cljs.core.LazySeq(null,(function (){
var s__38515__$1 = s__38515;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38515__$1);
if(temp__4657__auto__){
var s__38515__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38515__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38515__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38517 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38516 = (0);
while(true){
if((i__38516 < size__7188__auto__)){
var vec__38526 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38516);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38526,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38526,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__38517,event.subscribe(handler_function));

var G__38532 = (i__38516 + (1));
i__38516 = G__38532;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38517),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38514(cljs.core.chunk_rest(s__38515__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38517),null);
}
} else {
var vec__38529 = cljs.core.first(s__38515__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38529,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38529,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38514(cljs.core.rest(s__38515__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38551(s__38552){
return (new cljs.core.LazySeq(null,(function (){
var s__38552__$1 = s__38552;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38552__$1);
if(temp__4657__auto__){
var s__38552__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38552__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38552__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38554 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38553 = (0);
while(true){
if((i__38553 < size__7188__auto__)){
var vec__38563 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38553);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38563,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38563,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__38554,event.subscribe(handler_function));

var G__38569 = (i__38553 + (1));
i__38553 = G__38569;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38554),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38551(cljs.core.chunk_rest(s__38552__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38554),null);
}
} else {
var vec__38566 = cljs.core.first(s__38552__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38566,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38566,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38551(cljs.core.rest(s__38552__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__38572 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38572__$1 = ((((!((map__38572 == null)))?((((map__38572.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38572.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38572):map__38572);
var data_to_be_deleted = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38572__$1,cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted);
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted], null),((function (map__38572,map__38572__$1,data_to_be_deleted,fn){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(data_to_be_deleted,data_id) : fn.call(null,data_to_be_deleted,data_id));
});})(map__38572,map__38572__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector([cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector(data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__38578 = cljs.core.seq(cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var chunk__38579 = null;
var count__38580 = (0);
var i__38581 = (0);
while(true){
if((i__38581 < count__38580)){
var data_id = chunk__38579.cljs$core$IIndexed$_nth$arity$2(null,i__38581);
var element_38582 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38582.checked = true;

var G__38583 = seq__38578;
var G__38584 = chunk__38579;
var G__38585 = count__38580;
var G__38586 = (i__38581 + (1));
seq__38578 = G__38583;
chunk__38579 = G__38584;
count__38580 = G__38585;
i__38581 = G__38586;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38578);
if(temp__4657__auto__){
var seq__38578__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38578__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38578__$1);
var G__38587 = cljs.core.chunk_rest(seq__38578__$1);
var G__38588 = c__7220__auto__;
var G__38589 = cljs.core.count(c__7220__auto__);
var G__38590 = (0);
seq__38578 = G__38587;
chunk__38579 = G__38588;
count__38580 = G__38589;
i__38581 = G__38590;
continue;
} else {
var data_id = cljs.core.first(seq__38578__$1);
var element_38591 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38591.checked = true;

var G__38592 = cljs.core.next(seq__38578__$1);
var G__38593 = null;
var G__38594 = (0);
var G__38595 = (0);
seq__38578 = G__38592;
chunk__38579 = G__38593;
count__38580 = G__38594;
i__38581 = G__38595;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity(indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(indexes_of_selected_checkboxes));
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__38596){
var map__38615 = p__38596;
var map__38615__$1 = ((((!((map__38615 == null)))?((((map__38615.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38615.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38615):map__38615);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38615__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38615__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__38617 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38617__$1 = ((((!((map__38617 == null)))?((((map__38617.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38617.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38617):map__38617);
var map__38618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38617__$1,cljs.core.cst$kw$table_DASH_page);
var map__38618__$1 = ((((!((map__38618 == null)))?((((map__38618.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38618.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38618):map__38618);
var map__38619 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38618__$1,cljs.core.cst$kw$paging);
var map__38619__$1 = ((((!((map__38619 == null)))?((((map__38619.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38619.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38619):map__38619);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38619__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38619__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38618__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selectActiveRow,false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted();

return hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
});})(map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__38623_38633 = cljs.core.seq(records_to_be_deleted);
var chunk__38624_38634 = null;
var count__38625_38635 = (0);
var i__38626_38636 = (0);
while(true){
if((i__38626_38636 < count__38625_38635)){
var record_38637 = chunk__38624_38634.cljs$core$IIndexed$_nth$arity$2(null,i__38626_38636);
record_38637.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38627 = record_38637.getAttribute("data-id");
return parseInt(G__38627);
})());

var G__38638 = seq__38623_38633;
var G__38639 = chunk__38624_38634;
var G__38640 = count__38625_38635;
var G__38641 = (i__38626_38636 + (1));
seq__38623_38633 = G__38638;
chunk__38624_38634 = G__38639;
count__38625_38635 = G__38640;
i__38626_38636 = G__38641;
continue;
} else {
var temp__4657__auto___38642 = cljs.core.seq(seq__38623_38633);
if(temp__4657__auto___38642){
var seq__38623_38643__$1 = temp__4657__auto___38642;
if(cljs.core.chunked_seq_QMARK_(seq__38623_38643__$1)){
var c__7220__auto___38644 = cljs.core.chunk_first(seq__38623_38643__$1);
var G__38645 = cljs.core.chunk_rest(seq__38623_38643__$1);
var G__38646 = c__7220__auto___38644;
var G__38647 = cljs.core.count(c__7220__auto___38644);
var G__38648 = (0);
seq__38623_38633 = G__38645;
chunk__38624_38634 = G__38646;
count__38625_38635 = G__38647;
i__38626_38636 = G__38648;
continue;
} else {
var record_38649 = cljs.core.first(seq__38623_38643__$1);
record_38649.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38628 = record_38649.getAttribute("data-id");
return parseInt(G__38628);
})());

var G__38650 = cljs.core.next(seq__38623_38643__$1);
var G__38651 = null;
var G__38652 = (0);
var G__38653 = (0);
seq__38623_38633 = G__38650;
chunk__38624_38634 = G__38651;
count__38625_38635 = G__38652;
i__38626_38636 = G__38653;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
return null;
}
});})(map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__38630 = elem.getAttribute("data-id");
return parseInt(G__38630);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__38629 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38629__$1 = ((((!((map__38629 == null)))?((((map__38629.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38629.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38629):map__38629);
var selected_table_rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38629__$1,cljs.core.cst$kw$selected_DASH_table_DASH_rows);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = (function (){var G__38632 = grid.getCellFromEvent(e).row;
return parseInt(G__38632);
})();
hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_();

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38629,map__38629__$1,selected_table_rows,map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(selected_table_rows,row__$1) : fn.call(null,selected_table_rows,row__$1));
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38629,map__38629__$1,selected_table_rows,map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
}
});})(map__38617,map__38617__$1,map__38618,map__38618__$1,map__38619,map__38619__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38615,map__38615__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,event_chan){
return (function (state_38945){
var state_val_38946 = (state_38945[(1)]);
if((state_val_38946 === (7))){
var inst_38843 = (state_38945[(7)]);
var inst_38843__$1 = (state_38945[(2)]);
var inst_38845 = (inst_38843__$1 == null);
var inst_38846 = cljs.core.not(inst_38845);
var state_38945__$1 = (function (){var statearr_38947 = state_38945;
(statearr_38947[(7)] = inst_38843__$1);

return statearr_38947;
})();
if(inst_38846){
var statearr_38948_39023 = state_38945__$1;
(statearr_38948_39023[(1)] = (8));

} else {
var statearr_38949_39024 = state_38945__$1;
(statearr_38949_39024[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (20))){
var inst_38873 = (state_38945[(8)]);
var inst_38865 = (state_38945[(9)]);
var inst_38882 = (inst_38873.cljs$core$IFn$_invoke$arity$1 ? inst_38873.cljs$core$IFn$_invoke$arity$1(inst_38865) : inst_38873.call(null,inst_38865));
var state_38945__$1 = state_38945;
var statearr_38950_39025 = state_38945__$1;
(statearr_38950_39025[(2)] = inst_38882);

(statearr_38950_39025[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (27))){
var state_38945__$1 = state_38945;
var statearr_38951_39026 = state_38945__$1;
(statearr_38951_39026[(2)] = null);

(statearr_38951_39026[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (1))){
var state_38945__$1 = state_38945;
var statearr_38952_39027 = state_38945__$1;
(statearr_38952_39027[(2)] = null);

(statearr_38952_39027[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (24))){
var state_38945__$1 = state_38945;
var statearr_38953_39028 = state_38945__$1;
(statearr_38953_39028[(2)] = null);

(statearr_38953_39028[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (4))){
var state_38945__$1 = state_38945;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38945__$1,(7),event_chan);
} else {
if((state_val_38946 === (15))){
var inst_38843 = (state_38945[(7)]);
var state_38945__$1 = state_38945;
var statearr_38954_39029 = state_38945__$1;
(statearr_38954_39029[(2)] = inst_38843);

(statearr_38954_39029[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (21))){
var state_38945__$1 = state_38945;
var statearr_38955_39030 = state_38945__$1;
(statearr_38955_39030[(2)] = null);

(statearr_38955_39030[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (31))){
var inst_38869 = (state_38945[(10)]);
var inst_38918 = (state_38945[(2)]);
var inst_38919 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38869,cljs.core.cst$kw$table);
var state_38945__$1 = (function (){var statearr_38956 = state_38945;
(statearr_38956[(11)] = inst_38918);

return statearr_38956;
})();
if(inst_38919){
var statearr_38957_39031 = state_38945__$1;
(statearr_38957_39031[(1)] = (32));

} else {
var statearr_38958_39032 = state_38945__$1;
(statearr_38958_39032[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (32))){
var inst_38868 = (state_38945[(12)]);
var inst_38866 = (state_38945[(13)]);
var inst_38873 = (state_38945[(8)]);
var inst_38874 = (state_38945[(14)]);
var inst_38867 = (state_38945[(15)]);
var inst_38864 = (state_38945[(16)]);
var inst_38865 = (state_38945[(9)]);
var inst_38869 = (state_38945[(10)]);
var inst_38863 = (state_38945[(17)]);
var inst_38932 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38933 = (function (){var new_columns = inst_38868;
var submission_clicked = inst_38865;
var submission_unclicked = inst_38866;
var get_submission_data = inst_38874;
var re_render = inst_38869;
var update_data_BANG_ = inst_38873;
var submission_to_rank = inst_38864;
var map__38841 = inst_38863;
var c__13216__auto____$1 = inst_38932;
var filter_by = inst_38867;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38932,state_val_38946,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38932,state_val_38946,c__13216__auto__,event_chan){
return (function (state_38930){
var state_val_38931 = (state_38930[(1)]);
if((state_val_38931 === (1))){
var inst_38921 = cljs.core.async.timeout((20));
var state_38930__$1 = state_38930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38930__$1,(2),inst_38921);
} else {
if((state_val_38931 === (2))){
var inst_38923 = (state_38930[(2)]);
var inst_38924 = grid.resizeCanvas();
var inst_38925 = grid.invalidateAllRows();
var inst_38926 = hatti.views.table.resizeColumns(grid);
var inst_38927 = grid.render();
var inst_38928 = hatti.views.table.init_sg_pager(grid,dataview);
var state_38930__$1 = (function (){var statearr_38959 = state_38930;
(statearr_38959[(7)] = inst_38925);

(statearr_38959[(8)] = inst_38926);

(statearr_38959[(9)] = inst_38923);

(statearr_38959[(10)] = inst_38927);

(statearr_38959[(11)] = inst_38924);

return statearr_38959;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38930__$1,inst_38928);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38932,state_val_38946,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38932,state_val_38946,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_38963 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38963[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_38963[(1)] = (1));

return statearr_38963;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38930){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38930);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e38964){if((e38964 instanceof Object)){
var ex__13108__auto__ = e38964;
var statearr_38965_39033 = state_38930;
(statearr_38965_39033[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38930);

return cljs.core.cst$kw$recur;
} else {
throw e38964;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39034 = state_38930;
state_38930 = G__39034;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38930){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38932,state_val_38946,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_38966 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_38966[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_38966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38932,state_val_38946,c__13216__auto__,event_chan))
})();
var inst_38934 = cljs.core.async.impl.dispatch.run(inst_38933);
var state_38945__$1 = (function (){var statearr_38967 = state_38945;
(statearr_38967[(18)] = inst_38934);

return statearr_38967;
})();
var statearr_38968_39035 = state_38945__$1;
(statearr_38968_39035[(2)] = inst_38932);

(statearr_38968_39035[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (33))){
var state_38945__$1 = state_38945;
var statearr_38969_39036 = state_38945__$1;
(statearr_38969_39036[(2)] = null);

(statearr_38969_39036[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (13))){
var inst_38855 = (state_38945[(2)]);
var state_38945__$1 = state_38945;
var statearr_38970_39037 = state_38945__$1;
(statearr_38970_39037[(2)] = inst_38855);

(statearr_38970_39037[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (22))){
var inst_38866 = (state_38945[(13)]);
var inst_38885 = (state_38945[(2)]);
var state_38945__$1 = (function (){var statearr_38971 = state_38945;
(statearr_38971[(19)] = inst_38885);

return statearr_38971;
})();
if(cljs.core.truth_(inst_38866)){
var statearr_38972_39038 = state_38945__$1;
(statearr_38972_39038[(1)] = (23));

} else {
var statearr_38973_39039 = state_38945__$1;
(statearr_38973_39039[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (29))){
var inst_38867 = (state_38945[(15)]);
var inst_38910 = [cljs.core.cst$kw$query];
var inst_38911 = [inst_38867];
var inst_38912 = cljs.core.PersistentHashMap.fromArrays(inst_38910,inst_38911);
var inst_38913 = cljs.core.clj__GT_js(inst_38912);
var inst_38914 = dataview.setFilterArgs(inst_38913);
var inst_38915 = dataview.refresh();
var state_38945__$1 = (function (){var statearr_38974 = state_38945;
(statearr_38974[(20)] = inst_38914);

return statearr_38974;
})();
var statearr_38975_39040 = state_38945__$1;
(statearr_38975_39040[(2)] = inst_38915);

(statearr_38975_39040[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (6))){
var inst_38941 = (state_38945[(2)]);
var state_38945__$1 = state_38945;
var statearr_38976_39041 = state_38945__$1;
(statearr_38976_39041[(2)] = inst_38941);

(statearr_38976_39041[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (28))){
var inst_38867 = (state_38945[(15)]);
var inst_38908 = (state_38945[(2)]);
var state_38945__$1 = (function (){var statearr_38977 = state_38945;
(statearr_38977[(21)] = inst_38908);

return statearr_38977;
})();
if(cljs.core.truth_(inst_38867)){
var statearr_38978_39042 = state_38945__$1;
(statearr_38978_39042[(1)] = (29));

} else {
var statearr_38979_39043 = state_38945__$1;
(statearr_38979_39043[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (25))){
var inst_38868 = (state_38945[(12)]);
var inst_38890 = (state_38945[(2)]);
var state_38945__$1 = (function (){var statearr_38980 = state_38945;
(statearr_38980[(22)] = inst_38890);

return statearr_38980;
})();
if(cljs.core.truth_(inst_38868)){
var statearr_38981_39044 = state_38945__$1;
(statearr_38981_39044[(1)] = (26));

} else {
var statearr_38982_39045 = state_38945__$1;
(statearr_38982_39045[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (34))){
var inst_38937 = (state_38945[(2)]);
var state_38945__$1 = (function (){var statearr_38983 = state_38945;
(statearr_38983[(23)] = inst_38937);

return statearr_38983;
})();
var statearr_38984_39046 = state_38945__$1;
(statearr_38984_39046[(2)] = null);

(statearr_38984_39046[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (17))){
var inst_38873 = (state_38945[(8)]);
var inst_38874 = (state_38945[(14)]);
var inst_38864 = (state_38945[(16)]);
var inst_38876 = (inst_38874.cljs$core$IFn$_invoke$arity$2 ? inst_38874.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_38864) : inst_38874.call(null,hatti.constants._rank,inst_38864));
var inst_38877 = (inst_38873.cljs$core$IFn$_invoke$arity$1 ? inst_38873.cljs$core$IFn$_invoke$arity$1(inst_38876) : inst_38873.call(null,inst_38876));
var state_38945__$1 = state_38945;
var statearr_38985_39047 = state_38945__$1;
(statearr_38985_39047[(2)] = inst_38877);

(statearr_38985_39047[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (3))){
var inst_38943 = (state_38945[(2)]);
var state_38945__$1 = state_38945;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38945__$1,inst_38943);
} else {
if((state_val_38946 === (12))){
var state_38945__$1 = state_38945;
var statearr_38986_39048 = state_38945__$1;
(statearr_38986_39048[(2)] = false);

(statearr_38986_39048[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (2))){
var state_38945__$1 = state_38945;
var statearr_38987_39049 = state_38945__$1;
(statearr_38987_39049[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (23))){
var inst_38873 = (state_38945[(8)]);
var inst_38887 = (inst_38873.cljs$core$IFn$_invoke$arity$1 ? inst_38873.cljs$core$IFn$_invoke$arity$1(null) : inst_38873.call(null,null));
var state_38945__$1 = state_38945;
var statearr_38989_39050 = state_38945__$1;
(statearr_38989_39050[(2)] = inst_38887);

(statearr_38989_39050[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (19))){
var inst_38865 = (state_38945[(9)]);
var inst_38880 = (state_38945[(2)]);
var state_38945__$1 = (function (){var statearr_38990 = state_38945;
(statearr_38990[(24)] = inst_38880);

return statearr_38990;
})();
if(cljs.core.truth_(inst_38865)){
var statearr_38991_39051 = state_38945__$1;
(statearr_38991_39051[(1)] = (20));

} else {
var statearr_38992_39052 = state_38945__$1;
(statearr_38992_39052[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (11))){
var state_38945__$1 = state_38945;
var statearr_38993_39053 = state_38945__$1;
(statearr_38993_39053[(2)] = true);

(statearr_38993_39053[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (9))){
var state_38945__$1 = state_38945;
var statearr_38994_39054 = state_38945__$1;
(statearr_38994_39054[(2)] = false);

(statearr_38994_39054[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (5))){
var state_38945__$1 = state_38945;
var statearr_38995_39055 = state_38945__$1;
(statearr_38995_39055[(2)] = null);

(statearr_38995_39055[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (14))){
var inst_38843 = (state_38945[(7)]);
var inst_38860 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38843);
var state_38945__$1 = state_38945;
var statearr_38996_39056 = state_38945__$1;
(statearr_38996_39056[(2)] = inst_38860);

(statearr_38996_39056[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (26))){
var inst_38868 = (state_38945[(12)]);
var inst_38866 = (state_38945[(13)]);
var inst_38873 = (state_38945[(8)]);
var inst_38874 = (state_38945[(14)]);
var inst_38867 = (state_38945[(15)]);
var inst_38864 = (state_38945[(16)]);
var inst_38865 = (state_38945[(9)]);
var inst_38869 = (state_38945[(10)]);
var inst_38863 = (state_38945[(17)]);
var inst_38903 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38904 = (function (){var new_columns = inst_38868;
var submission_clicked = inst_38865;
var submission_unclicked = inst_38866;
var get_submission_data = inst_38874;
var re_render = inst_38869;
var update_data_BANG_ = inst_38873;
var submission_to_rank = inst_38864;
var map__38841 = inst_38863;
var c__13216__auto____$1 = inst_38903;
var filter_by = inst_38867;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38903,state_val_38946,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38903,state_val_38946,c__13216__auto__,event_chan){
return (function (state_38901){
var state_val_38902 = (state_38901[(1)]);
if((state_val_38902 === (1))){
var inst_38892 = cljs.core.async.timeout((20));
var state_38901__$1 = state_38901;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38901__$1,(2),inst_38892);
} else {
if((state_val_38902 === (2))){
var inst_38894 = (state_38901[(2)]);
var inst_38895 = grid.setColumns(new_columns);
var inst_38896 = hatti.views.table.resizeColumns(grid);
var inst_38897 = grid.render();
var inst_38898 = hatti.views.table.select_rows_marked_to_be_deleted();
var inst_38899 = hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
var state_38901__$1 = (function (){var statearr_38997 = state_38901;
(statearr_38997[(7)] = inst_38897);

(statearr_38997[(8)] = inst_38898);

(statearr_38997[(9)] = inst_38894);

(statearr_38997[(10)] = inst_38895);

(statearr_38997[(11)] = inst_38896);

return statearr_38997;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38901__$1,inst_38899);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38903,state_val_38946,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38903,state_val_38946,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_39001 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39001[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_39001[(1)] = (1));

return statearr_39001;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38901){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38901);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e39002){if((e39002 instanceof Object)){
var ex__13108__auto__ = e39002;
var statearr_39003_39057 = state_38901;
(statearr_39003_39057[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38901);

return cljs.core.cst$kw$recur;
} else {
throw e39002;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39058 = state_38901;
state_38901 = G__39058;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38901){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38903,state_val_38946,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_39004 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_39004[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_39004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,map__38841,c__13216__auto____$1,filter_by,inst_38868,inst_38866,inst_38873,inst_38874,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38903,state_val_38946,c__13216__auto__,event_chan))
})();
var inst_38905 = cljs.core.async.impl.dispatch.run(inst_38904);
var state_38945__$1 = (function (){var statearr_39005 = state_38945;
(statearr_39005[(25)] = inst_38905);

return statearr_39005;
})();
var statearr_39006_39059 = state_38945__$1;
(statearr_39006_39059[(2)] = inst_38903);

(statearr_39006_39059[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (16))){
var inst_38868 = (state_38945[(12)]);
var inst_38866 = (state_38945[(13)]);
var inst_38873 = (state_38945[(8)]);
var inst_38867 = (state_38945[(15)]);
var inst_38864 = (state_38945[(16)]);
var inst_38865 = (state_38945[(9)]);
var inst_38869 = (state_38945[(10)]);
var inst_38863 = (state_38945[(17)]);
var inst_38863__$1 = (state_38945[(2)]);
var inst_38864__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38863__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_38865__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38863__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_38866__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38863__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_38867__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38863__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_38868__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38863__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_38869__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38863__$1,cljs.core.cst$kw$re_DASH_render);
var inst_38870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38871 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_38872 = (new cljs.core.PersistentVector(null,3,(5),inst_38870,inst_38871,null));
var inst_38873__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_38872);
var inst_38874 = (function (){var map__38841 = inst_38863__$1;
var submission_to_rank = inst_38864__$1;
var submission_clicked = inst_38865__$1;
var submission_unclicked = inst_38866__$1;
var filter_by = inst_38867__$1;
var new_columns = inst_38868__$1;
var re_render = inst_38869__$1;
var update_data_BANG_ = inst_38873__$1;
return ((function (map__38841,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38868,inst_38866,inst_38873,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38863__$1,inst_38864__$1,inst_38865__$1,inst_38866__$1,inst_38867__$1,inst_38868__$1,inst_38869__$1,inst_38870,inst_38871,inst_38872,inst_38873__$1,state_val_38946,c__13216__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__38841,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38868,inst_38866,inst_38873,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38863__$1,inst_38864__$1,inst_38865__$1,inst_38866__$1,inst_38867__$1,inst_38868__$1,inst_38869__$1,inst_38870,inst_38871,inst_38872,inst_38873__$1,state_val_38946,c__13216__auto__,event_chan){
return (function (p1__38654_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__38654_SHARP_,field));
});})(map__38841,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38868,inst_38866,inst_38873,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38863__$1,inst_38864__$1,inst_38865__$1,inst_38866__$1,inst_38867__$1,inst_38868__$1,inst_38869__$1,inst_38870,inst_38871,inst_38872,inst_38873__$1,state_val_38946,c__13216__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__38841,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38868,inst_38866,inst_38873,inst_38867,inst_38864,inst_38865,inst_38869,inst_38863,inst_38863__$1,inst_38864__$1,inst_38865__$1,inst_38866__$1,inst_38867__$1,inst_38868__$1,inst_38869__$1,inst_38870,inst_38871,inst_38872,inst_38873__$1,state_val_38946,c__13216__auto__,event_chan))
})();
var state_38945__$1 = (function (){var statearr_39007 = state_38945;
(statearr_39007[(12)] = inst_38868__$1);

(statearr_39007[(13)] = inst_38866__$1);

(statearr_39007[(8)] = inst_38873__$1);

(statearr_39007[(14)] = inst_38874);

(statearr_39007[(15)] = inst_38867__$1);

(statearr_39007[(16)] = inst_38864__$1);

(statearr_39007[(9)] = inst_38865__$1);

(statearr_39007[(10)] = inst_38869__$1);

(statearr_39007[(17)] = inst_38863__$1);

return statearr_39007;
})();
if(cljs.core.truth_(inst_38864__$1)){
var statearr_39008_39060 = state_38945__$1;
(statearr_39008_39060[(1)] = (17));

} else {
var statearr_39009_39061 = state_38945__$1;
(statearr_39009_39061[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (30))){
var state_38945__$1 = state_38945;
var statearr_39010_39062 = state_38945__$1;
(statearr_39010_39062[(2)] = null);

(statearr_39010_39062[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (10))){
var inst_38858 = (state_38945[(2)]);
var state_38945__$1 = state_38945;
if(cljs.core.truth_(inst_38858)){
var statearr_39011_39063 = state_38945__$1;
(statearr_39011_39063[(1)] = (14));

} else {
var statearr_39012_39064 = state_38945__$1;
(statearr_39012_39064[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (18))){
var state_38945__$1 = state_38945;
var statearr_39013_39065 = state_38945__$1;
(statearr_39013_39065[(2)] = null);

(statearr_39013_39065[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38946 === (8))){
var inst_38843 = (state_38945[(7)]);
var inst_38848 = inst_38843.cljs$lang$protocol_mask$partition0$;
var inst_38849 = (inst_38848 & (64));
var inst_38850 = inst_38843.cljs$core$ISeq$;
var inst_38851 = (inst_38849) || (inst_38850);
var state_38945__$1 = state_38945;
if(cljs.core.truth_(inst_38851)){
var statearr_39014_39066 = state_38945__$1;
(statearr_39014_39066[(1)] = (11));

} else {
var statearr_39015_39067 = state_38945__$1;
(statearr_39015_39067[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_39019 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39019[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_39019[(1)] = (1));

return statearr_39019;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38945){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38945);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e39020){if((e39020 instanceof Object)){
var ex__13108__auto__ = e39020;
var statearr_39021_39068 = state_38945;
(statearr_39021_39068[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38945);

return cljs.core.cst$kw$recur;
} else {
throw e39020;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39069 = state_38945;
state_38945 = G__39069;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38945){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_39022 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_39022[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_39022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__,event_chan))
);

return c__13216__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$field_DASH_key,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__39088(s__39089){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__39089__$1 = s__39089;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39089__$1);
if(temp__4657__auto__){
var s__39089__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39089__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39089__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39091 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39090 = (0);
while(true){
if((i__39090 < size__7188__auto__)){
var vec__39100 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39090);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39100,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39100,(1),null);
cljs.core.chunk_append(b__39091,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__39090,vec__39100,k,v,c__7187__auto__,size__7188__auto__,b__39091,s__39089__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__39090,vec__39100,k,v,c__7187__auto__,size__7188__auto__,b__39091,s__39089__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__39106 = (i__39090 + (1));
i__39090 = G__39106;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39091),hatti$views$table$render_options_$_iter__39088(cljs.core.chunk_rest(s__39089__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39091),null);
}
} else {
var vec__39103 = cljs.core.first(s__39089__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39103,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39103,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__39103,k,v,s__39089__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__39103,k,v,s__39089__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__39088(cljs.core.rest(s__39089__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39108 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39108 = (function (_,owner,meta39109){
this._ = _;
this.owner = owner;
this.meta39109 = meta39109;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39108.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39110,meta39109__$1){
var self__ = this;
var _39110__$1 = this;
return (new hatti.views.table.t_hatti$views$table39108(self__._,self__.owner,meta39109__$1));
});

hatti.views.table.t_hatti$views$table39108.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39110){
var self__ = this;
var _39110__$1 = this;
return self__.meta39109;
});

hatti.views.table.t_hatti$views$table39108.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table39108.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table39108.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39108.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__39111){
var self__ = this;
var map__39112 = p__39111;
var map__39112__$1 = ((((!((map__39112 == null)))?((((map__39112.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39112.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39112):map__39112);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39112__$1,cljs.core.cst$kw$field_DASH_key);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39112__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__39114 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39114__$1 = ((((!((map__39114 == null)))?((((map__39114.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39114.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39114):map__39114);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39114__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__39114,map__39114__$1,flat_form,new_language,___$2,map__39112,map__39112__$1,field_key,language){
return (function (p1__39107_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__39107_SHARP_),cljs.core.cst$kw$language,new_language,cljs.core.cst$kw$owner,self__.owner], 0))], null));
});})(options,map__39114,map__39114__$1,flat_form,new_language,___$2,map__39112,map__39112__$1,field_key,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(field_key);
} else {
}

var G__39124 = ({"className": "label-changer"});
var G__39125 = (function (){var G__39127 = ({"className": "label-changer-label"});
var G__39128 = "Show:";
return React.DOM.span(G__39127,G__39128);
})();
var G__39126 = (function (){var G__39129 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__39130 = (function (){var attrs39118 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(field_key) : options.call(null,field_key));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39118))?sablono.interpreter.attributes(attrs39118):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39118))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39132 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39132);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39118),(function (){var G__39133 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39133);
})()], null))));
})();
var G__39131 = (function (){var attrs39123 = hatti.views.table.render_options(options,self__.owner,colset_BANG_);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.ul,((cljs.core.map_QMARK_(attrs39123))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs39123], 0))):({"className": "submenu no-dot"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39123))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39123)], null))));
})();
return React.DOM.div(G__39129,G__39130,G__39131);
})();
return React.DOM.div(G__39124,G__39125,G__39126);
});

hatti.views.table.t_hatti$views$table39108.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39109], null);
});

hatti.views.table.t_hatti$views$table39108.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39108.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39108";

hatti.views.table.t_hatti$views$table39108.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39108");
});

hatti.views.table.__GT_t_hatti$views$table39108 = (function hatti$views$table$__GT_t_hatti$views$table39108(___$1,owner__$1,meta39109){
return (new hatti.views.table.t_hatti$views$table39108(___$1,owner__$1,meta39109));
});

}

return (new hatti.views.table.t_hatti$views$table39108(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__,query){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,query){
return (function (state_39176){
var state_val_39177 = (state_39176[(1)]);
if((state_val_39177 === (1))){
var inst_39162 = cljs.core.async.timeout((150));
var state_39176__$1 = state_39176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39176__$1,(2),inst_39162);
} else {
if((state_val_39177 === (2))){
var inst_39164 = (state_39176[(2)]);
var inst_39165 = input.value;
var inst_39166 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_39165);
var state_39176__$1 = (function (){var statearr_39178 = state_39176;
(statearr_39178[(7)] = inst_39164);

return statearr_39178;
})();
if(inst_39166){
var statearr_39179_39190 = state_39176__$1;
(statearr_39179_39190[(1)] = (3));

} else {
var statearr_39180_39191 = state_39176__$1;
(statearr_39180_39191[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39177 === (3))){
var inst_39168 = [query_event_key];
var inst_39169 = [query];
var inst_39170 = cljs.core.PersistentHashMap.fromArrays(inst_39168,inst_39169);
var inst_39171 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_39170);
var state_39176__$1 = state_39176;
var statearr_39181_39192 = state_39176__$1;
(statearr_39181_39192[(2)] = inst_39171);

(statearr_39181_39192[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39177 === (4))){
var state_39176__$1 = state_39176;
var statearr_39182_39193 = state_39176__$1;
(statearr_39182_39193[(2)] = null);

(statearr_39182_39193[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39177 === (5))){
var inst_39174 = (state_39176[(2)]);
var state_39176__$1 = state_39176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39176__$1,inst_39174);
} else {
return null;
}
}
}
}
}
});})(c__13216__auto__,query))
;
return ((function (switch__13104__auto__,c__13216__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__13105__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__13105__auto____0 = (function (){
var statearr_39186 = [null,null,null,null,null,null,null,null];
(statearr_39186[(0)] = hatti$views$table$delayed_search_$_state_machine__13105__auto__);

(statearr_39186[(1)] = (1));

return statearr_39186;
});
var hatti$views$table$delayed_search_$_state_machine__13105__auto____1 = (function (state_39176){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_39176);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e39187){if((e39187 instanceof Object)){
var ex__13108__auto__ = e39187;
var statearr_39188_39194 = state_39176;
(statearr_39188_39194[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39176);

return cljs.core.cst$kw$recur;
} else {
throw e39187;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39195 = state_39176;
state_39176 = G__39195;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__13105__auto__ = function(state_39176){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____1.call(this,state_39176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__13105__auto____0;
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__13105__auto____1;
return hatti$views$table$delayed_search_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,query))
})();
var state__13218__auto__ = (function (){var statearr_39189 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_39189[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_39189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__,query))
);

return c__13216__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39197 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39197 = (function (_,owner,meta39198){
this._ = _;
this.owner = owner;
this.meta39198 = meta39198;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39197.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39199,meta39198__$1){
var self__ = this;
var _39199__$1 = this;
return (new hatti.views.table.t_hatti$views$table39197(self__._,self__.owner,meta39198__$1));
});

hatti.views.table.t_hatti$views$table39197.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39199){
var self__ = this;
var _39199__$1 = this;
return self__.meta39198;
});

hatti.views.table.t_hatti$views$table39197.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39197.prototype.om$core$IRender$render$arity$1 = (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
var G__39202 = ({"className": "table-search"});
var G__39203 = (function (){var G__39205 = ({"className": "fa fa-search"});
return React.DOM.i(G__39205);
})();
var G__39204 = (function (){var G__39206 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__39202,G__39203,this__19159__auto____$1){
return (function (p1__39196_SHARP_){
return hatti.views.table.delayed_search(p1__39196_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__39202,G__39203,this__19159__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__39206) : sablono.interpreter.input.call(null,G__39206));
})();
return React.DOM.div(G__39202,G__39203,G__39204);
});

hatti.views.table.t_hatti$views$table39197.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39198], null);
});

hatti.views.table.t_hatti$views$table39197.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39197.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39197";

hatti.views.table.t_hatti$views$table39197.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39197");
});

hatti.views.table.__GT_t_hatti$views$table39197 = (function hatti$views$table$__GT_t_hatti$views$table39197(___$1,owner__$1,meta39198){
return (new hatti.views.table.t_hatti$views$table39197(___$1,owner__$1,meta39198));
});

}

return (new hatti.views.table.t_hatti$views$table39197(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table39207 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39207 = (function (cursor,owner,meta39208){
this.cursor = cursor;
this.owner = owner;
this.meta39208 = meta39208;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39207.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39209,meta39208__$1){
var self__ = this;
var _39209__$1 = this;
return (new hatti.views.table.t_hatti$views$table39207(self__.cursor,self__.owner,meta39208__$1));
});

hatti.views.table.t_hatti$views$table39207.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39209){
var self__ = this;
var _39209__$1 = this;
return self__.meta39208;
});

hatti.views.table.t_hatti$views$table39207.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39207.prototype.om$core$IRender$render$arity$1 = (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
var G__39212 = ({"className": "topbar"});
var G__39213 = (function (){var G__39217 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__39217);
})();
var G__39214 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__39215 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__39216 = (function (){var G__39218 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__39218);
})();
return React.DOM.div(G__39212,G__39213,G__39214,G__39215,G__39216);
});

hatti.views.table.t_hatti$views$table39207.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39208], null);
});

hatti.views.table.t_hatti$views$table39207.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39207.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39207";

hatti.views.table.t_hatti$views$table39207.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39207");
});

hatti.views.table.__GT_t_hatti$views$table39207 = (function hatti$views$table$__GT_t_hatti$views$table39207(cursor__$1,owner__$1,meta39208){
return (new hatti.views.table.t_hatti$views$table39207(cursor__$1,owner__$1,meta39208));
});

}

return (new hatti.views.table.t_hatti$views$table39207(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__39224 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__39224__$1 = ((((!((map__39224 == null)))?((((map__39224.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39224.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39224):map__39224);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39224__$1,cljs.core.cst$kw$flat_DASH_form);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__39225 = hatti.views.table.sg_init(data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39225,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39225,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39230,owner,p__39231){
var map__39232 = p__39230;
var map__39232__$1 = ((((!((map__39232 == null)))?((((map__39232.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39232.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39232):map__39232);
var cursor = map__39232__$1;
var map__39233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39232__$1,cljs.core.cst$kw$views);
var map__39233__$1 = ((((!((map__39233 == null)))?((((map__39233.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39233.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39233):map__39233);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39233__$1,cljs.core.cst$kw$active);
var map__39234 = p__39231;
var map__39234__$1 = ((((!((map__39234 == null)))?((((map__39234.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39234.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39234):map__39234);
var opts = map__39234__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39234__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table39238 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39238 = (function (p__39230,owner,p__39231,active_QMARK_,map__39232,map__39234,slick_grid_event_handlers,map__39233,cursor,active,opts,meta39239){
this.p__39230 = p__39230;
this.owner = owner;
this.p__39231 = p__39231;
this.active_QMARK_ = active_QMARK_;
this.map__39232 = map__39232;
this.map__39234 = map__39234;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__39233 = map__39233;
this.cursor = cursor;
this.active = active;
this.opts = opts;
this.meta39239 = meta39239;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39238.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers){
return (function (_39240,meta39239__$1){
var self__ = this;
var _39240__$1 = this;
return (new hatti.views.table.t_hatti$views$table39238(self__.p__39230,self__.owner,self__.p__39231,self__.active_QMARK_,self__.map__39232,self__.map__39234,self__.slick_grid_event_handlers,self__.map__39233,self__.cursor,self__.active,self__.opts,meta39239__$1));
});})(active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39238.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers){
return (function (_39240){
var self__ = this;
var _39240__$1 = this;
return self__.meta39239;
});})(active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39238.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39238.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers){
return (function (_,p__39241){
var self__ = this;
var map__39242 = p__39241;
var map__39242__$1 = ((((!((map__39242 == null)))?((((map__39242.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39242.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39242):map__39242);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39242__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__39244 = self__.cursor;
var map__39244__$1 = ((((!((map__39244 == null)))?((((map__39244.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39244.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39244):map__39244);
var map__39245 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39244__$1,cljs.core.cst$kw$table_DASH_page);
var map__39245__$1 = ((((!((map__39245 == null)))?((((map__39245.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39245.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39245):map__39245);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39245__$1,cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39245__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39244__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39244__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__39246 = dataset_info;
var map__39246__$1 = ((((!((map__39246 == null)))?((((map__39246.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39246.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39246):map__39246);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39246__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__39244,map__39244__$1,map__39245,map__39245__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__39246,map__39246__$1,num_of_submissions,no_data_QMARK_,___$1,map__39242,map__39242__$1,table_view_height,active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers){
return (function (p1__39229_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__39229_SHARP_], 0));
});})(map__39244,map__39244__$1,map__39245,map__39245__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__39246,map__39246__$1,num_of_submissions,no_data_QMARK_,___$1,map__39242,map__39242__$1,table_view_height,active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var G__39250 = ({"style": cljs.core.clj__GT_js((cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$height,(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height();
}
})(),cljs.core.cst$kw$overflow,"hidden"], null):null)), "className": "table-view"});
var G__39251 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__39252 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__39253 = (function (){var G__39254 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__39255 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__39260 = ({"className": "alert alert-warning"});
var G__39261 = "No data";
return React.DOM.p(G__39260,G__39261);
})():(function (){var G__39262 = null;
var G__39263 = (function (){var G__39265 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__39265);
})();
var G__39264 = "Loading...";
return React.DOM.span(G__39262,G__39263,G__39264);
})());
return React.DOM.div(G__39254,G__39255);
})();
return React.DOM.div(G__39250,G__39251,G__39252,G__39253);
} else {
return null;
}
});})(active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39238.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table39238.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39266 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39266,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39266,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39238.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table39238.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39238.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table39238.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__39269 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39269__$1 = ((((!((map__39269 == null)))?((((map__39269.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39269.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39269):map__39269);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39269__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39269__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39271 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39271,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39271,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39238.getBasis = ((function (active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__39230,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__39231,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$map__39232,cljs.core.cst$sym$map__39234,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$map__39233,cljs.core.cst$sym$cursor,cljs.core.cst$sym$active,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta39239], null);
});})(active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39238.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39238.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39238";

hatti.views.table.t_hatti$views$table39238.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39238");
});})(active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table39238 = ((function (active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table39238(p__39230__$1,owner__$1,p__39231__$1,active_QMARK___$1,map__39232__$2,map__39234__$2,slick_grid_event_handlers__$1,map__39233__$2,cursor__$1,active__$1,opts__$1,meta39239){
return (new hatti.views.table.t_hatti$views$table39238(p__39230__$1,owner__$1,p__39231__$1,active_QMARK___$1,map__39232__$2,map__39234__$2,slick_grid_event_handlers__$1,map__39233__$2,cursor__$1,active__$1,opts__$1,meta39239));
});})(active_QMARK_,map__39232,map__39232__$1,cursor,map__39233,map__39233__$1,active,map__39234,map__39234__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table39238(p__39230,owner,p__39231,active_QMARK_,map__39232__$1,map__39234__$1,slick_grid_event_handlers,map__39233__$1,cursor,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
