// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args31302 = [];
var len__7484__auto___31308 = arguments.length;
var i__7485__auto___31309 = (0);
while(true){
if((i__7485__auto___31309 < len__7484__auto___31308)){
args31302.push((arguments[i__7485__auto___31309]));

var G__31310 = (i__7485__auto___31309 + (1));
i__7485__auto___31309 = G__31310;
continue;
} else {
}
break;
}

var G__31304 = args31302.length;
switch (G__31304) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31302.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async31305 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31305 = (function (f,blockable,meta31306){
this.f = f;
this.blockable = blockable;
this.meta31306 = meta31306;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31305.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31307,meta31306__$1){
var self__ = this;
var _31307__$1 = this;
return (new cljs.core.async.t_cljs$core$async31305(self__.f,self__.blockable,meta31306__$1));
});

cljs.core.async.t_cljs$core$async31305.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31307){
var self__ = this;
var _31307__$1 = this;
return self__.meta31306;
});

cljs.core.async.t_cljs$core$async31305.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31305.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31305.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31305.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31305.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta31306], null);
});

cljs.core.async.t_cljs$core$async31305.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31305.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31305";

cljs.core.async.t_cljs$core$async31305.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31305");
});

cljs.core.async.__GT_t_cljs$core$async31305 = (function cljs$core$async$__GT_t_cljs$core$async31305(f__$1,blockable__$1,meta31306){
return (new cljs.core.async.t_cljs$core$async31305(f__$1,blockable__$1,meta31306));
});

}

return (new cljs.core.async.t_cljs$core$async31305(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args31314 = [];
var len__7484__auto___31317 = arguments.length;
var i__7485__auto___31318 = (0);
while(true){
if((i__7485__auto___31318 < len__7484__auto___31317)){
args31314.push((arguments[i__7485__auto___31318]));

var G__31319 = (i__7485__auto___31318 + (1));
i__7485__auto___31318 = G__31319;
continue;
} else {
}
break;
}

var G__31316 = args31314.length;
switch (G__31316) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31314.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args31321 = [];
var len__7484__auto___31324 = arguments.length;
var i__7485__auto___31325 = (0);
while(true){
if((i__7485__auto___31325 < len__7484__auto___31324)){
args31321.push((arguments[i__7485__auto___31325]));

var G__31326 = (i__7485__auto___31325 + (1));
i__7485__auto___31325 = G__31326;
continue;
} else {
}
break;
}

var G__31323 = args31321.length;
switch (G__31323) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31321.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args31328 = [];
var len__7484__auto___31331 = arguments.length;
var i__7485__auto___31332 = (0);
while(true){
if((i__7485__auto___31332 < len__7484__auto___31331)){
args31328.push((arguments[i__7485__auto___31332]));

var G__31333 = (i__7485__auto___31332 + (1));
i__7485__auto___31332 = G__31333;
continue;
} else {
}
break;
}

var G__31330 = args31328.length;
switch (G__31330) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31328.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_31335 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31335) : fn1.call(null,val_31335));
} else {
cljs.core.async.impl.dispatch.run(((function (val_31335,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31335) : fn1.call(null,val_31335));
});})(val_31335,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args31336 = [];
var len__7484__auto___31339 = arguments.length;
var i__7485__auto___31340 = (0);
while(true){
if((i__7485__auto___31340 < len__7484__auto___31339)){
args31336.push((arguments[i__7485__auto___31340]));

var G__31341 = (i__7485__auto___31340 + (1));
i__7485__auto___31340 = G__31341;
continue;
} else {
}
break;
}

var G__31338 = args31336.length;
switch (G__31338) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31336.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7324__auto___31343 = n;
var x_31344 = (0);
while(true){
if((x_31344 < n__7324__auto___31343)){
(a[x_31344] = (0));

var G__31345 = (x_31344 + (1));
x_31344 = G__31345;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__31346 = (i + (1));
i = G__31346;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async31350 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31350 = (function (alt_flag,flag,meta31351){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta31351 = meta31351;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31350.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31352,meta31351__$1){
var self__ = this;
var _31352__$1 = this;
return (new cljs.core.async.t_cljs$core$async31350(self__.alt_flag,self__.flag,meta31351__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31350.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31352){
var self__ = this;
var _31352__$1 = this;
return self__.meta31351;
});})(flag))
;

cljs.core.async.t_cljs$core$async31350.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31350.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async31350.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31350.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31350.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta31351], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31350.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31350.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31350";

cljs.core.async.t_cljs$core$async31350.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31350");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31350 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31350(alt_flag__$1,flag__$1,meta31351){
return (new cljs.core.async.t_cljs$core$async31350(alt_flag__$1,flag__$1,meta31351));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31350(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31356 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31356 = (function (alt_handler,flag,cb,meta31357){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta31357 = meta31357;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31356.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31358,meta31357__$1){
var self__ = this;
var _31358__$1 = this;
return (new cljs.core.async.t_cljs$core$async31356(self__.alt_handler,self__.flag,self__.cb,meta31357__$1));
});

cljs.core.async.t_cljs$core$async31356.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31358){
var self__ = this;
var _31358__$1 = this;
return self__.meta31357;
});

cljs.core.async.t_cljs$core$async31356.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31356.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async31356.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31356.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31356.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta31357], null);
});

cljs.core.async.t_cljs$core$async31356.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31356.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31356";

cljs.core.async.t_cljs$core$async31356.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async31356");
});

cljs.core.async.__GT_t_cljs$core$async31356 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31356(alt_handler__$1,flag__$1,cb__$1,meta31357){
return (new cljs.core.async.t_cljs$core$async31356(alt_handler__$1,flag__$1,cb__$1,meta31357));
});

}

return (new cljs.core.async.t_cljs$core$async31356(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31359_SHARP_){
var G__31363 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31359_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31363) : fret.call(null,G__31363));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31360_SHARP_){
var G__31364 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31360_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31364) : fret.call(null,G__31364));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6409__auto__ = wport;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31365 = (i + (1));
i = G__31365;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6409__auto__ = ret;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6397__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___31371 = arguments.length;
var i__7485__auto___31372 = (0);
while(true){
if((i__7485__auto___31372 < len__7484__auto___31371)){
args__7491__auto__.push((arguments[i__7485__auto___31372]));

var G__31373 = (i__7485__auto___31372 + (1));
i__7485__auto___31372 = G__31373;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31368){
var map__31369 = p__31368;
var map__31369__$1 = ((((!((map__31369 == null)))?((((map__31369.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31369.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31369):map__31369);
var opts = map__31369__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31366){
var G__31367 = cljs.core.first(seq31366);
var seq31366__$1 = cljs.core.next(seq31366);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31367,seq31366__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args31374 = [];
var len__7484__auto___31424 = arguments.length;
var i__7485__auto___31425 = (0);
while(true){
if((i__7485__auto___31425 < len__7484__auto___31424)){
args31374.push((arguments[i__7485__auto___31425]));

var G__31426 = (i__7485__auto___31425 + (1));
i__7485__auto___31425 = G__31426;
continue;
} else {
}
break;
}

var G__31376 = args31374.length;
switch (G__31376) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31374.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__13216__auto___31428 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___31428){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___31428){
return (function (state_31400){
var state_val_31401 = (state_31400[(1)]);
if((state_val_31401 === (7))){
var inst_31396 = (state_31400[(2)]);
var state_31400__$1 = state_31400;
var statearr_31402_31429 = state_31400__$1;
(statearr_31402_31429[(2)] = inst_31396);

(statearr_31402_31429[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31401 === (1))){
var state_31400__$1 = state_31400;
var statearr_31403_31430 = state_31400__$1;
(statearr_31403_31430[(2)] = null);

(statearr_31403_31430[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31401 === (4))){
var inst_31379 = (state_31400[(7)]);
var inst_31379__$1 = (state_31400[(2)]);
var inst_31380 = (inst_31379__$1 == null);
var state_31400__$1 = (function (){var statearr_31404 = state_31400;
(statearr_31404[(7)] = inst_31379__$1);

return statearr_31404;
})();
if(cljs.core.truth_(inst_31380)){
var statearr_31405_31431 = state_31400__$1;
(statearr_31405_31431[(1)] = (5));

} else {
var statearr_31406_31432 = state_31400__$1;
(statearr_31406_31432[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31401 === (13))){
var state_31400__$1 = state_31400;
var statearr_31407_31433 = state_31400__$1;
(statearr_31407_31433[(2)] = null);

(statearr_31407_31433[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31401 === (6))){
var inst_31379 = (state_31400[(7)]);
var state_31400__$1 = state_31400;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31400__$1,(11),to,inst_31379);
} else {
if((state_val_31401 === (3))){
var inst_31398 = (state_31400[(2)]);
var state_31400__$1 = state_31400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31400__$1,inst_31398);
} else {
if((state_val_31401 === (12))){
var state_31400__$1 = state_31400;
var statearr_31408_31434 = state_31400__$1;
(statearr_31408_31434[(2)] = null);

(statearr_31408_31434[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31401 === (2))){
var state_31400__$1 = state_31400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31400__$1,(4),from);
} else {
if((state_val_31401 === (11))){
var inst_31389 = (state_31400[(2)]);
var state_31400__$1 = state_31400;
if(cljs.core.truth_(inst_31389)){
var statearr_31409_31435 = state_31400__$1;
(statearr_31409_31435[(1)] = (12));

} else {
var statearr_31410_31436 = state_31400__$1;
(statearr_31410_31436[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31401 === (9))){
var state_31400__$1 = state_31400;
var statearr_31411_31437 = state_31400__$1;
(statearr_31411_31437[(2)] = null);

(statearr_31411_31437[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31401 === (5))){
var state_31400__$1 = state_31400;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31412_31438 = state_31400__$1;
(statearr_31412_31438[(1)] = (8));

} else {
var statearr_31413_31439 = state_31400__$1;
(statearr_31413_31439[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31401 === (14))){
var inst_31394 = (state_31400[(2)]);
var state_31400__$1 = state_31400;
var statearr_31414_31440 = state_31400__$1;
(statearr_31414_31440[(2)] = inst_31394);

(statearr_31414_31440[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31401 === (10))){
var inst_31386 = (state_31400[(2)]);
var state_31400__$1 = state_31400;
var statearr_31415_31441 = state_31400__$1;
(statearr_31415_31441[(2)] = inst_31386);

(statearr_31415_31441[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31401 === (8))){
var inst_31383 = cljs.core.async.close_BANG_(to);
var state_31400__$1 = state_31400;
var statearr_31416_31442 = state_31400__$1;
(statearr_31416_31442[(2)] = inst_31383);

(statearr_31416_31442[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___31428))
;
return ((function (switch__13104__auto__,c__13216__auto___31428){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_31420 = [null,null,null,null,null,null,null,null];
(statearr_31420[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_31420[(1)] = (1));

return statearr_31420;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_31400){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_31400);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e31421){if((e31421 instanceof Object)){
var ex__13108__auto__ = e31421;
var statearr_31422_31443 = state_31400;
(statearr_31422_31443[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31400);

return cljs.core.cst$kw$recur;
} else {
throw e31421;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__31444 = state_31400;
state_31400 = G__31444;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_31400){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_31400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___31428))
})();
var state__13218__auto__ = (function (){var statearr_31423 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_31423[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___31428);

return statearr_31423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___31428))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__31632){
var vec__31633 = p__31632;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31633,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31633,(1),null);
var job = vec__31633;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__13216__auto___31819 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___31819,res,vec__31633,v,p,job,jobs,results){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___31819,res,vec__31633,v,p,job,jobs,results){
return (function (state_31640){
var state_val_31641 = (state_31640[(1)]);
if((state_val_31641 === (1))){
var state_31640__$1 = state_31640;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31640__$1,(2),res,v);
} else {
if((state_val_31641 === (2))){
var inst_31637 = (state_31640[(2)]);
var inst_31638 = cljs.core.async.close_BANG_(res);
var state_31640__$1 = (function (){var statearr_31642 = state_31640;
(statearr_31642[(7)] = inst_31637);

return statearr_31642;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31640__$1,inst_31638);
} else {
return null;
}
}
});})(c__13216__auto___31819,res,vec__31633,v,p,job,jobs,results))
;
return ((function (switch__13104__auto__,c__13216__auto___31819,res,vec__31633,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_31646 = [null,null,null,null,null,null,null,null];
(statearr_31646[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__);

(statearr_31646[(1)] = (1));

return statearr_31646;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1 = (function (state_31640){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_31640);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e31647){if((e31647 instanceof Object)){
var ex__13108__auto__ = e31647;
var statearr_31648_31820 = state_31640;
(statearr_31648_31820[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31640);

return cljs.core.cst$kw$recur;
} else {
throw e31647;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__31821 = state_31640;
state_31640 = G__31821;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = function(state_31640){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1.call(this,state_31640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___31819,res,vec__31633,v,p,job,jobs,results))
})();
var state__13218__auto__ = (function (){var statearr_31649 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_31649[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___31819);

return statearr_31649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___31819,res,vec__31633,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31650){
var vec__31651 = p__31650;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31651,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31651,(1),null);
var job = vec__31651;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7324__auto___31822 = n;
var __31823 = (0);
while(true){
if((__31823 < n__7324__auto___31822)){
var G__31654_31824 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__31654_31824) {
case "compute":
var c__13216__auto___31826 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31823,c__13216__auto___31826,G__31654_31824,n__7324__auto___31822,jobs,results,process,async){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (__31823,c__13216__auto___31826,G__31654_31824,n__7324__auto___31822,jobs,results,process,async){
return (function (state_31667){
var state_val_31668 = (state_31667[(1)]);
if((state_val_31668 === (1))){
var state_31667__$1 = state_31667;
var statearr_31669_31827 = state_31667__$1;
(statearr_31669_31827[(2)] = null);

(statearr_31669_31827[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31668 === (2))){
var state_31667__$1 = state_31667;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31667__$1,(4),jobs);
} else {
if((state_val_31668 === (3))){
var inst_31665 = (state_31667[(2)]);
var state_31667__$1 = state_31667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31667__$1,inst_31665);
} else {
if((state_val_31668 === (4))){
var inst_31657 = (state_31667[(2)]);
var inst_31658 = process(inst_31657);
var state_31667__$1 = state_31667;
if(cljs.core.truth_(inst_31658)){
var statearr_31670_31828 = state_31667__$1;
(statearr_31670_31828[(1)] = (5));

} else {
var statearr_31671_31829 = state_31667__$1;
(statearr_31671_31829[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31668 === (5))){
var state_31667__$1 = state_31667;
var statearr_31672_31830 = state_31667__$1;
(statearr_31672_31830[(2)] = null);

(statearr_31672_31830[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31668 === (6))){
var state_31667__$1 = state_31667;
var statearr_31673_31831 = state_31667__$1;
(statearr_31673_31831[(2)] = null);

(statearr_31673_31831[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31668 === (7))){
var inst_31663 = (state_31667[(2)]);
var state_31667__$1 = state_31667;
var statearr_31674_31832 = state_31667__$1;
(statearr_31674_31832[(2)] = inst_31663);

(statearr_31674_31832[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31823,c__13216__auto___31826,G__31654_31824,n__7324__auto___31822,jobs,results,process,async))
;
return ((function (__31823,switch__13104__auto__,c__13216__auto___31826,G__31654_31824,n__7324__auto___31822,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_31678 = [null,null,null,null,null,null,null];
(statearr_31678[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__);

(statearr_31678[(1)] = (1));

return statearr_31678;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1 = (function (state_31667){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_31667);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e31679){if((e31679 instanceof Object)){
var ex__13108__auto__ = e31679;
var statearr_31680_31833 = state_31667;
(statearr_31680_31833[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31667);

return cljs.core.cst$kw$recur;
} else {
throw e31679;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__31834 = state_31667;
state_31667 = G__31834;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = function(state_31667){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1.call(this,state_31667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__;
})()
;})(__31823,switch__13104__auto__,c__13216__auto___31826,G__31654_31824,n__7324__auto___31822,jobs,results,process,async))
})();
var state__13218__auto__ = (function (){var statearr_31681 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_31681[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___31826);

return statearr_31681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(__31823,c__13216__auto___31826,G__31654_31824,n__7324__auto___31822,jobs,results,process,async))
);


break;
case "async":
var c__13216__auto___31835 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31823,c__13216__auto___31835,G__31654_31824,n__7324__auto___31822,jobs,results,process,async){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (__31823,c__13216__auto___31835,G__31654_31824,n__7324__auto___31822,jobs,results,process,async){
return (function (state_31694){
var state_val_31695 = (state_31694[(1)]);
if((state_val_31695 === (1))){
var state_31694__$1 = state_31694;
var statearr_31696_31836 = state_31694__$1;
(statearr_31696_31836[(2)] = null);

(statearr_31696_31836[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31695 === (2))){
var state_31694__$1 = state_31694;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31694__$1,(4),jobs);
} else {
if((state_val_31695 === (3))){
var inst_31692 = (state_31694[(2)]);
var state_31694__$1 = state_31694;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31694__$1,inst_31692);
} else {
if((state_val_31695 === (4))){
var inst_31684 = (state_31694[(2)]);
var inst_31685 = async(inst_31684);
var state_31694__$1 = state_31694;
if(cljs.core.truth_(inst_31685)){
var statearr_31697_31837 = state_31694__$1;
(statearr_31697_31837[(1)] = (5));

} else {
var statearr_31698_31838 = state_31694__$1;
(statearr_31698_31838[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31695 === (5))){
var state_31694__$1 = state_31694;
var statearr_31699_31839 = state_31694__$1;
(statearr_31699_31839[(2)] = null);

(statearr_31699_31839[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31695 === (6))){
var state_31694__$1 = state_31694;
var statearr_31700_31840 = state_31694__$1;
(statearr_31700_31840[(2)] = null);

(statearr_31700_31840[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31695 === (7))){
var inst_31690 = (state_31694[(2)]);
var state_31694__$1 = state_31694;
var statearr_31701_31841 = state_31694__$1;
(statearr_31701_31841[(2)] = inst_31690);

(statearr_31701_31841[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31823,c__13216__auto___31835,G__31654_31824,n__7324__auto___31822,jobs,results,process,async))
;
return ((function (__31823,switch__13104__auto__,c__13216__auto___31835,G__31654_31824,n__7324__auto___31822,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_31705 = [null,null,null,null,null,null,null];
(statearr_31705[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__);

(statearr_31705[(1)] = (1));

return statearr_31705;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1 = (function (state_31694){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_31694);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e31706){if((e31706 instanceof Object)){
var ex__13108__auto__ = e31706;
var statearr_31707_31842 = state_31694;
(statearr_31707_31842[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31694);

return cljs.core.cst$kw$recur;
} else {
throw e31706;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__31843 = state_31694;
state_31694 = G__31843;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = function(state_31694){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1.call(this,state_31694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__;
})()
;})(__31823,switch__13104__auto__,c__13216__auto___31835,G__31654_31824,n__7324__auto___31822,jobs,results,process,async))
})();
var state__13218__auto__ = (function (){var statearr_31708 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_31708[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___31835);

return statearr_31708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(__31823,c__13216__auto___31835,G__31654_31824,n__7324__auto___31822,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__31844 = (__31823 + (1));
__31823 = G__31844;
continue;
} else {
}
break;
}

var c__13216__auto___31845 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___31845,jobs,results,process,async){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___31845,jobs,results,process,async){
return (function (state_31730){
var state_val_31731 = (state_31730[(1)]);
if((state_val_31731 === (1))){
var state_31730__$1 = state_31730;
var statearr_31732_31846 = state_31730__$1;
(statearr_31732_31846[(2)] = null);

(statearr_31732_31846[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31731 === (2))){
var state_31730__$1 = state_31730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31730__$1,(4),from);
} else {
if((state_val_31731 === (3))){
var inst_31728 = (state_31730[(2)]);
var state_31730__$1 = state_31730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31730__$1,inst_31728);
} else {
if((state_val_31731 === (4))){
var inst_31711 = (state_31730[(7)]);
var inst_31711__$1 = (state_31730[(2)]);
var inst_31712 = (inst_31711__$1 == null);
var state_31730__$1 = (function (){var statearr_31733 = state_31730;
(statearr_31733[(7)] = inst_31711__$1);

return statearr_31733;
})();
if(cljs.core.truth_(inst_31712)){
var statearr_31734_31847 = state_31730__$1;
(statearr_31734_31847[(1)] = (5));

} else {
var statearr_31735_31848 = state_31730__$1;
(statearr_31735_31848[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31731 === (5))){
var inst_31714 = cljs.core.async.close_BANG_(jobs);
var state_31730__$1 = state_31730;
var statearr_31736_31849 = state_31730__$1;
(statearr_31736_31849[(2)] = inst_31714);

(statearr_31736_31849[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31731 === (6))){
var inst_31716 = (state_31730[(8)]);
var inst_31711 = (state_31730[(7)]);
var inst_31716__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31718 = [inst_31711,inst_31716__$1];
var inst_31719 = (new cljs.core.PersistentVector(null,2,(5),inst_31717,inst_31718,null));
var state_31730__$1 = (function (){var statearr_31737 = state_31730;
(statearr_31737[(8)] = inst_31716__$1);

return statearr_31737;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31730__$1,(8),jobs,inst_31719);
} else {
if((state_val_31731 === (7))){
var inst_31726 = (state_31730[(2)]);
var state_31730__$1 = state_31730;
var statearr_31738_31850 = state_31730__$1;
(statearr_31738_31850[(2)] = inst_31726);

(statearr_31738_31850[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31731 === (8))){
var inst_31716 = (state_31730[(8)]);
var inst_31721 = (state_31730[(2)]);
var state_31730__$1 = (function (){var statearr_31739 = state_31730;
(statearr_31739[(9)] = inst_31721);

return statearr_31739;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31730__$1,(9),results,inst_31716);
} else {
if((state_val_31731 === (9))){
var inst_31723 = (state_31730[(2)]);
var state_31730__$1 = (function (){var statearr_31740 = state_31730;
(statearr_31740[(10)] = inst_31723);

return statearr_31740;
})();
var statearr_31741_31851 = state_31730__$1;
(statearr_31741_31851[(2)] = null);

(statearr_31741_31851[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___31845,jobs,results,process,async))
;
return ((function (switch__13104__auto__,c__13216__auto___31845,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_31745 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31745[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__);

(statearr_31745[(1)] = (1));

return statearr_31745;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1 = (function (state_31730){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_31730);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e31746){if((e31746 instanceof Object)){
var ex__13108__auto__ = e31746;
var statearr_31747_31852 = state_31730;
(statearr_31747_31852[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31730);

return cljs.core.cst$kw$recur;
} else {
throw e31746;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__31853 = state_31730;
state_31730 = G__31853;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = function(state_31730){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1.call(this,state_31730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___31845,jobs,results,process,async))
})();
var state__13218__auto__ = (function (){var statearr_31748 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_31748[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___31845);

return statearr_31748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___31845,jobs,results,process,async))
);


var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__,jobs,results,process,async){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,jobs,results,process,async){
return (function (state_31786){
var state_val_31787 = (state_31786[(1)]);
if((state_val_31787 === (7))){
var inst_31782 = (state_31786[(2)]);
var state_31786__$1 = state_31786;
var statearr_31788_31854 = state_31786__$1;
(statearr_31788_31854[(2)] = inst_31782);

(statearr_31788_31854[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (20))){
var state_31786__$1 = state_31786;
var statearr_31789_31855 = state_31786__$1;
(statearr_31789_31855[(2)] = null);

(statearr_31789_31855[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (1))){
var state_31786__$1 = state_31786;
var statearr_31790_31856 = state_31786__$1;
(statearr_31790_31856[(2)] = null);

(statearr_31790_31856[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (4))){
var inst_31751 = (state_31786[(7)]);
var inst_31751__$1 = (state_31786[(2)]);
var inst_31752 = (inst_31751__$1 == null);
var state_31786__$1 = (function (){var statearr_31791 = state_31786;
(statearr_31791[(7)] = inst_31751__$1);

return statearr_31791;
})();
if(cljs.core.truth_(inst_31752)){
var statearr_31792_31857 = state_31786__$1;
(statearr_31792_31857[(1)] = (5));

} else {
var statearr_31793_31858 = state_31786__$1;
(statearr_31793_31858[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (15))){
var inst_31764 = (state_31786[(8)]);
var state_31786__$1 = state_31786;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31786__$1,(18),to,inst_31764);
} else {
if((state_val_31787 === (21))){
var inst_31777 = (state_31786[(2)]);
var state_31786__$1 = state_31786;
var statearr_31794_31859 = state_31786__$1;
(statearr_31794_31859[(2)] = inst_31777);

(statearr_31794_31859[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (13))){
var inst_31779 = (state_31786[(2)]);
var state_31786__$1 = (function (){var statearr_31795 = state_31786;
(statearr_31795[(9)] = inst_31779);

return statearr_31795;
})();
var statearr_31796_31860 = state_31786__$1;
(statearr_31796_31860[(2)] = null);

(statearr_31796_31860[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (6))){
var inst_31751 = (state_31786[(7)]);
var state_31786__$1 = state_31786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31786__$1,(11),inst_31751);
} else {
if((state_val_31787 === (17))){
var inst_31772 = (state_31786[(2)]);
var state_31786__$1 = state_31786;
if(cljs.core.truth_(inst_31772)){
var statearr_31797_31861 = state_31786__$1;
(statearr_31797_31861[(1)] = (19));

} else {
var statearr_31798_31862 = state_31786__$1;
(statearr_31798_31862[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (3))){
var inst_31784 = (state_31786[(2)]);
var state_31786__$1 = state_31786;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31786__$1,inst_31784);
} else {
if((state_val_31787 === (12))){
var inst_31761 = (state_31786[(10)]);
var state_31786__$1 = state_31786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31786__$1,(14),inst_31761);
} else {
if((state_val_31787 === (2))){
var state_31786__$1 = state_31786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31786__$1,(4),results);
} else {
if((state_val_31787 === (19))){
var state_31786__$1 = state_31786;
var statearr_31799_31863 = state_31786__$1;
(statearr_31799_31863[(2)] = null);

(statearr_31799_31863[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (11))){
var inst_31761 = (state_31786[(2)]);
var state_31786__$1 = (function (){var statearr_31800 = state_31786;
(statearr_31800[(10)] = inst_31761);

return statearr_31800;
})();
var statearr_31801_31864 = state_31786__$1;
(statearr_31801_31864[(2)] = null);

(statearr_31801_31864[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (9))){
var state_31786__$1 = state_31786;
var statearr_31802_31865 = state_31786__$1;
(statearr_31802_31865[(2)] = null);

(statearr_31802_31865[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (5))){
var state_31786__$1 = state_31786;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31803_31866 = state_31786__$1;
(statearr_31803_31866[(1)] = (8));

} else {
var statearr_31804_31867 = state_31786__$1;
(statearr_31804_31867[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (14))){
var inst_31764 = (state_31786[(8)]);
var inst_31766 = (state_31786[(11)]);
var inst_31764__$1 = (state_31786[(2)]);
var inst_31765 = (inst_31764__$1 == null);
var inst_31766__$1 = cljs.core.not(inst_31765);
var state_31786__$1 = (function (){var statearr_31805 = state_31786;
(statearr_31805[(8)] = inst_31764__$1);

(statearr_31805[(11)] = inst_31766__$1);

return statearr_31805;
})();
if(inst_31766__$1){
var statearr_31806_31868 = state_31786__$1;
(statearr_31806_31868[(1)] = (15));

} else {
var statearr_31807_31869 = state_31786__$1;
(statearr_31807_31869[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (16))){
var inst_31766 = (state_31786[(11)]);
var state_31786__$1 = state_31786;
var statearr_31808_31870 = state_31786__$1;
(statearr_31808_31870[(2)] = inst_31766);

(statearr_31808_31870[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (10))){
var inst_31758 = (state_31786[(2)]);
var state_31786__$1 = state_31786;
var statearr_31809_31871 = state_31786__$1;
(statearr_31809_31871[(2)] = inst_31758);

(statearr_31809_31871[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (18))){
var inst_31769 = (state_31786[(2)]);
var state_31786__$1 = state_31786;
var statearr_31810_31872 = state_31786__$1;
(statearr_31810_31872[(2)] = inst_31769);

(statearr_31810_31872[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31787 === (8))){
var inst_31755 = cljs.core.async.close_BANG_(to);
var state_31786__$1 = state_31786;
var statearr_31811_31873 = state_31786__$1;
(statearr_31811_31873[(2)] = inst_31755);

(statearr_31811_31873[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__,jobs,results,process,async))
;
return ((function (switch__13104__auto__,c__13216__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_31815 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31815[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__);

(statearr_31815[(1)] = (1));

return statearr_31815;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1 = (function (state_31786){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_31786);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e31816){if((e31816 instanceof Object)){
var ex__13108__auto__ = e31816;
var statearr_31817_31874 = state_31786;
(statearr_31817_31874[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31786);

return cljs.core.cst$kw$recur;
} else {
throw e31816;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__31875 = state_31786;
state_31786 = G__31875;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__ = function(state_31786){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1.call(this,state_31786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,jobs,results,process,async))
})();
var state__13218__auto__ = (function (){var statearr_31818 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_31818[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_31818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__,jobs,results,process,async))
);

return c__13216__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args31876 = [];
var len__7484__auto___31879 = arguments.length;
var i__7485__auto___31880 = (0);
while(true){
if((i__7485__auto___31880 < len__7484__auto___31879)){
args31876.push((arguments[i__7485__auto___31880]));

var G__31881 = (i__7485__auto___31880 + (1));
i__7485__auto___31880 = G__31881;
continue;
} else {
}
break;
}

var G__31878 = args31876.length;
switch (G__31878) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31876.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args31883 = [];
var len__7484__auto___31886 = arguments.length;
var i__7485__auto___31887 = (0);
while(true){
if((i__7485__auto___31887 < len__7484__auto___31886)){
args31883.push((arguments[i__7485__auto___31887]));

var G__31888 = (i__7485__auto___31887 + (1));
i__7485__auto___31887 = G__31888;
continue;
} else {
}
break;
}

var G__31885 = args31883.length;
switch (G__31885) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31883.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args31890 = [];
var len__7484__auto___31943 = arguments.length;
var i__7485__auto___31944 = (0);
while(true){
if((i__7485__auto___31944 < len__7484__auto___31943)){
args31890.push((arguments[i__7485__auto___31944]));

var G__31945 = (i__7485__auto___31944 + (1));
i__7485__auto___31944 = G__31945;
continue;
} else {
}
break;
}

var G__31892 = args31890.length;
switch (G__31892) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31890.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__13216__auto___31947 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___31947,tc,fc){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___31947,tc,fc){
return (function (state_31918){
var state_val_31919 = (state_31918[(1)]);
if((state_val_31919 === (7))){
var inst_31914 = (state_31918[(2)]);
var state_31918__$1 = state_31918;
var statearr_31920_31948 = state_31918__$1;
(statearr_31920_31948[(2)] = inst_31914);

(statearr_31920_31948[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31919 === (1))){
var state_31918__$1 = state_31918;
var statearr_31921_31949 = state_31918__$1;
(statearr_31921_31949[(2)] = null);

(statearr_31921_31949[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31919 === (4))){
var inst_31895 = (state_31918[(7)]);
var inst_31895__$1 = (state_31918[(2)]);
var inst_31896 = (inst_31895__$1 == null);
var state_31918__$1 = (function (){var statearr_31922 = state_31918;
(statearr_31922[(7)] = inst_31895__$1);

return statearr_31922;
})();
if(cljs.core.truth_(inst_31896)){
var statearr_31923_31950 = state_31918__$1;
(statearr_31923_31950[(1)] = (5));

} else {
var statearr_31924_31951 = state_31918__$1;
(statearr_31924_31951[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31919 === (13))){
var state_31918__$1 = state_31918;
var statearr_31925_31952 = state_31918__$1;
(statearr_31925_31952[(2)] = null);

(statearr_31925_31952[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31919 === (6))){
var inst_31895 = (state_31918[(7)]);
var inst_31901 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31895) : p.call(null,inst_31895));
var state_31918__$1 = state_31918;
if(cljs.core.truth_(inst_31901)){
var statearr_31926_31953 = state_31918__$1;
(statearr_31926_31953[(1)] = (9));

} else {
var statearr_31927_31954 = state_31918__$1;
(statearr_31927_31954[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31919 === (3))){
var inst_31916 = (state_31918[(2)]);
var state_31918__$1 = state_31918;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31918__$1,inst_31916);
} else {
if((state_val_31919 === (12))){
var state_31918__$1 = state_31918;
var statearr_31928_31955 = state_31918__$1;
(statearr_31928_31955[(2)] = null);

(statearr_31928_31955[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31919 === (2))){
var state_31918__$1 = state_31918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31918__$1,(4),ch);
} else {
if((state_val_31919 === (11))){
var inst_31895 = (state_31918[(7)]);
var inst_31905 = (state_31918[(2)]);
var state_31918__$1 = state_31918;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31918__$1,(8),inst_31905,inst_31895);
} else {
if((state_val_31919 === (9))){
var state_31918__$1 = state_31918;
var statearr_31929_31956 = state_31918__$1;
(statearr_31929_31956[(2)] = tc);

(statearr_31929_31956[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31919 === (5))){
var inst_31898 = cljs.core.async.close_BANG_(tc);
var inst_31899 = cljs.core.async.close_BANG_(fc);
var state_31918__$1 = (function (){var statearr_31930 = state_31918;
(statearr_31930[(8)] = inst_31898);

return statearr_31930;
})();
var statearr_31931_31957 = state_31918__$1;
(statearr_31931_31957[(2)] = inst_31899);

(statearr_31931_31957[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31919 === (14))){
var inst_31912 = (state_31918[(2)]);
var state_31918__$1 = state_31918;
var statearr_31932_31958 = state_31918__$1;
(statearr_31932_31958[(2)] = inst_31912);

(statearr_31932_31958[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31919 === (10))){
var state_31918__$1 = state_31918;
var statearr_31933_31959 = state_31918__$1;
(statearr_31933_31959[(2)] = fc);

(statearr_31933_31959[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31919 === (8))){
var inst_31907 = (state_31918[(2)]);
var state_31918__$1 = state_31918;
if(cljs.core.truth_(inst_31907)){
var statearr_31934_31960 = state_31918__$1;
(statearr_31934_31960[(1)] = (12));

} else {
var statearr_31935_31961 = state_31918__$1;
(statearr_31935_31961[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___31947,tc,fc))
;
return ((function (switch__13104__auto__,c__13216__auto___31947,tc,fc){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_31939 = [null,null,null,null,null,null,null,null,null];
(statearr_31939[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_31939[(1)] = (1));

return statearr_31939;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_31918){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_31918);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e31940){if((e31940 instanceof Object)){
var ex__13108__auto__ = e31940;
var statearr_31941_31962 = state_31918;
(statearr_31941_31962[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31918);

return cljs.core.cst$kw$recur;
} else {
throw e31940;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__31963 = state_31918;
state_31918 = G__31963;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_31918){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_31918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___31947,tc,fc))
})();
var state__13218__auto__ = (function (){var statearr_31942 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_31942[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___31947);

return statearr_31942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___31947,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__){
return (function (state_32027){
var state_val_32028 = (state_32027[(1)]);
if((state_val_32028 === (7))){
var inst_32023 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
var statearr_32029_32050 = state_32027__$1;
(statearr_32029_32050[(2)] = inst_32023);

(statearr_32029_32050[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32028 === (1))){
var inst_32007 = init;
var state_32027__$1 = (function (){var statearr_32030 = state_32027;
(statearr_32030[(7)] = inst_32007);

return statearr_32030;
})();
var statearr_32031_32051 = state_32027__$1;
(statearr_32031_32051[(2)] = null);

(statearr_32031_32051[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32028 === (4))){
var inst_32010 = (state_32027[(8)]);
var inst_32010__$1 = (state_32027[(2)]);
var inst_32011 = (inst_32010__$1 == null);
var state_32027__$1 = (function (){var statearr_32032 = state_32027;
(statearr_32032[(8)] = inst_32010__$1);

return statearr_32032;
})();
if(cljs.core.truth_(inst_32011)){
var statearr_32033_32052 = state_32027__$1;
(statearr_32033_32052[(1)] = (5));

} else {
var statearr_32034_32053 = state_32027__$1;
(statearr_32034_32053[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32028 === (6))){
var inst_32014 = (state_32027[(9)]);
var inst_32007 = (state_32027[(7)]);
var inst_32010 = (state_32027[(8)]);
var inst_32014__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_32007,inst_32010) : f.call(null,inst_32007,inst_32010));
var inst_32015 = cljs.core.reduced_QMARK_(inst_32014__$1);
var state_32027__$1 = (function (){var statearr_32035 = state_32027;
(statearr_32035[(9)] = inst_32014__$1);

return statearr_32035;
})();
if(inst_32015){
var statearr_32036_32054 = state_32027__$1;
(statearr_32036_32054[(1)] = (8));

} else {
var statearr_32037_32055 = state_32027__$1;
(statearr_32037_32055[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32028 === (3))){
var inst_32025 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32027__$1,inst_32025);
} else {
if((state_val_32028 === (2))){
var state_32027__$1 = state_32027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32027__$1,(4),ch);
} else {
if((state_val_32028 === (9))){
var inst_32014 = (state_32027[(9)]);
var inst_32007 = inst_32014;
var state_32027__$1 = (function (){var statearr_32038 = state_32027;
(statearr_32038[(7)] = inst_32007);

return statearr_32038;
})();
var statearr_32039_32056 = state_32027__$1;
(statearr_32039_32056[(2)] = null);

(statearr_32039_32056[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32028 === (5))){
var inst_32007 = (state_32027[(7)]);
var state_32027__$1 = state_32027;
var statearr_32040_32057 = state_32027__$1;
(statearr_32040_32057[(2)] = inst_32007);

(statearr_32040_32057[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32028 === (10))){
var inst_32021 = (state_32027[(2)]);
var state_32027__$1 = state_32027;
var statearr_32041_32058 = state_32027__$1;
(statearr_32041_32058[(2)] = inst_32021);

(statearr_32041_32058[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32028 === (8))){
var inst_32014 = (state_32027[(9)]);
var inst_32017 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_32014) : cljs.core.deref.call(null,inst_32014));
var state_32027__$1 = state_32027;
var statearr_32042_32059 = state_32027__$1;
(statearr_32042_32059[(2)] = inst_32017);

(statearr_32042_32059[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__))
;
return ((function (switch__13104__auto__,c__13216__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__13105__auto__ = null;
var cljs$core$async$reduce_$_state_machine__13105__auto____0 = (function (){
var statearr_32046 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32046[(0)] = cljs$core$async$reduce_$_state_machine__13105__auto__);

(statearr_32046[(1)] = (1));

return statearr_32046;
});
var cljs$core$async$reduce_$_state_machine__13105__auto____1 = (function (state_32027){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_32027);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e32047){if((e32047 instanceof Object)){
var ex__13108__auto__ = e32047;
var statearr_32048_32060 = state_32027;
(statearr_32048_32060[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32027);

return cljs.core.cst$kw$recur;
} else {
throw e32047;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__32061 = state_32027;
state_32027 = G__32061;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__13105__auto__ = function(state_32027){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__13105__auto____1.call(this,state_32027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__13105__auto____0;
cljs$core$async$reduce_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__13105__auto____1;
return cljs$core$async$reduce_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__))
})();
var state__13218__auto__ = (function (){var statearr_32049 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_32049[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_32049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__))
);

return c__13216__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__,f__$1){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,f__$1){
return (function (state_32081){
var state_val_32082 = (state_32081[(1)]);
if((state_val_32082 === (1))){
var inst_32076 = cljs.core.async.reduce(f__$1,init,ch);
var state_32081__$1 = state_32081;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32081__$1,(2),inst_32076);
} else {
if((state_val_32082 === (2))){
var inst_32078 = (state_32081[(2)]);
var inst_32079 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_32078) : f__$1.call(null,inst_32078));
var state_32081__$1 = state_32081;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32081__$1,inst_32079);
} else {
return null;
}
}
});})(c__13216__auto__,f__$1))
;
return ((function (switch__13104__auto__,c__13216__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__13105__auto__ = null;
var cljs$core$async$transduce_$_state_machine__13105__auto____0 = (function (){
var statearr_32086 = [null,null,null,null,null,null,null];
(statearr_32086[(0)] = cljs$core$async$transduce_$_state_machine__13105__auto__);

(statearr_32086[(1)] = (1));

return statearr_32086;
});
var cljs$core$async$transduce_$_state_machine__13105__auto____1 = (function (state_32081){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_32081);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e32087){if((e32087 instanceof Object)){
var ex__13108__auto__ = e32087;
var statearr_32088_32090 = state_32081;
(statearr_32088_32090[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32081);

return cljs.core.cst$kw$recur;
} else {
throw e32087;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__32091 = state_32081;
state_32081 = G__32091;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__13105__auto__ = function(state_32081){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__13105__auto____1.call(this,state_32081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__13105__auto____0;
cljs$core$async$transduce_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__13105__auto____1;
return cljs$core$async$transduce_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,f__$1))
})();
var state__13218__auto__ = (function (){var statearr_32089 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_32089[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_32089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__,f__$1))
);

return c__13216__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args32092 = [];
var len__7484__auto___32144 = arguments.length;
var i__7485__auto___32145 = (0);
while(true){
if((i__7485__auto___32145 < len__7484__auto___32144)){
args32092.push((arguments[i__7485__auto___32145]));

var G__32146 = (i__7485__auto___32145 + (1));
i__7485__auto___32145 = G__32146;
continue;
} else {
}
break;
}

var G__32094 = args32092.length;
switch (G__32094) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32092.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__){
return (function (state_32119){
var state_val_32120 = (state_32119[(1)]);
if((state_val_32120 === (7))){
var inst_32101 = (state_32119[(2)]);
var state_32119__$1 = state_32119;
var statearr_32121_32148 = state_32119__$1;
(statearr_32121_32148[(2)] = inst_32101);

(statearr_32121_32148[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32120 === (1))){
var inst_32095 = cljs.core.seq(coll);
var inst_32096 = inst_32095;
var state_32119__$1 = (function (){var statearr_32122 = state_32119;
(statearr_32122[(7)] = inst_32096);

return statearr_32122;
})();
var statearr_32123_32149 = state_32119__$1;
(statearr_32123_32149[(2)] = null);

(statearr_32123_32149[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32120 === (4))){
var inst_32096 = (state_32119[(7)]);
var inst_32099 = cljs.core.first(inst_32096);
var state_32119__$1 = state_32119;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32119__$1,(7),ch,inst_32099);
} else {
if((state_val_32120 === (13))){
var inst_32113 = (state_32119[(2)]);
var state_32119__$1 = state_32119;
var statearr_32124_32150 = state_32119__$1;
(statearr_32124_32150[(2)] = inst_32113);

(statearr_32124_32150[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32120 === (6))){
var inst_32104 = (state_32119[(2)]);
var state_32119__$1 = state_32119;
if(cljs.core.truth_(inst_32104)){
var statearr_32125_32151 = state_32119__$1;
(statearr_32125_32151[(1)] = (8));

} else {
var statearr_32126_32152 = state_32119__$1;
(statearr_32126_32152[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32120 === (3))){
var inst_32117 = (state_32119[(2)]);
var state_32119__$1 = state_32119;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32119__$1,inst_32117);
} else {
if((state_val_32120 === (12))){
var state_32119__$1 = state_32119;
var statearr_32127_32153 = state_32119__$1;
(statearr_32127_32153[(2)] = null);

(statearr_32127_32153[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32120 === (2))){
var inst_32096 = (state_32119[(7)]);
var state_32119__$1 = state_32119;
if(cljs.core.truth_(inst_32096)){
var statearr_32128_32154 = state_32119__$1;
(statearr_32128_32154[(1)] = (4));

} else {
var statearr_32129_32155 = state_32119__$1;
(statearr_32129_32155[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32120 === (11))){
var inst_32110 = cljs.core.async.close_BANG_(ch);
var state_32119__$1 = state_32119;
var statearr_32130_32156 = state_32119__$1;
(statearr_32130_32156[(2)] = inst_32110);

(statearr_32130_32156[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32120 === (9))){
var state_32119__$1 = state_32119;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32131_32157 = state_32119__$1;
(statearr_32131_32157[(1)] = (11));

} else {
var statearr_32132_32158 = state_32119__$1;
(statearr_32132_32158[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32120 === (5))){
var inst_32096 = (state_32119[(7)]);
var state_32119__$1 = state_32119;
var statearr_32133_32159 = state_32119__$1;
(statearr_32133_32159[(2)] = inst_32096);

(statearr_32133_32159[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32120 === (10))){
var inst_32115 = (state_32119[(2)]);
var state_32119__$1 = state_32119;
var statearr_32134_32160 = state_32119__$1;
(statearr_32134_32160[(2)] = inst_32115);

(statearr_32134_32160[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32120 === (8))){
var inst_32096 = (state_32119[(7)]);
var inst_32106 = cljs.core.next(inst_32096);
var inst_32096__$1 = inst_32106;
var state_32119__$1 = (function (){var statearr_32135 = state_32119;
(statearr_32135[(7)] = inst_32096__$1);

return statearr_32135;
})();
var statearr_32136_32161 = state_32119__$1;
(statearr_32136_32161[(2)] = null);

(statearr_32136_32161[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__))
;
return ((function (switch__13104__auto__,c__13216__auto__){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_32140 = [null,null,null,null,null,null,null,null];
(statearr_32140[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_32140[(1)] = (1));

return statearr_32140;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_32119){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_32119);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e32141){if((e32141 instanceof Object)){
var ex__13108__auto__ = e32141;
var statearr_32142_32162 = state_32119;
(statearr_32142_32162[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32119);

return cljs.core.cst$kw$recur;
} else {
throw e32141;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__32163 = state_32119;
state_32119 = G__32163;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_32119){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_32119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__))
})();
var state__13218__auto__ = (function (){var statearr_32143 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_32143[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_32143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__))
);

return c__13216__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7072__auto__ = (((_ == null))?null:_);
var m__7073__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto__.call(null,_));
} else {
var m__7073__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7073__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7073__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__32392 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32392) : cljs.core.atom.call(null,G__32392));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32393 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32393 = (function (mult,ch,cs,meta32394){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta32394 = meta32394;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32393.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32395,meta32394__$1){
var self__ = this;
var _32395__$1 = this;
return (new cljs.core.async.t_cljs$core$async32393(self__.mult,self__.ch,self__.cs,meta32394__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32393.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32395){
var self__ = this;
var _32395__$1 = this;
return self__.meta32394;
});})(cs))
;

cljs.core.async.t_cljs$core$async32393.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32393.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32393.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async32393.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32393.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32393.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32396_32620 = self__.cs;
var G__32397_32621 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32396_32620,G__32397_32621) : cljs.core.reset_BANG_.call(null,G__32396_32620,G__32397_32621));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32393.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta32394], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32393.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32393.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32393";

cljs.core.async.t_cljs$core$async32393.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32393");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async32393 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32393(mult__$1,ch__$1,cs__$1,meta32394){
return (new cljs.core.async.t_cljs$core$async32393(mult__$1,ch__$1,cs__$1,meta32394));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32393(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__13216__auto___32622 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___32622,cs,m,dchan,dctr,done){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___32622,cs,m,dchan,dctr,done){
return (function (state_32532){
var state_val_32533 = (state_32532[(1)]);
if((state_val_32533 === (7))){
var inst_32528 = (state_32532[(2)]);
var state_32532__$1 = state_32532;
var statearr_32534_32623 = state_32532__$1;
(statearr_32534_32623[(2)] = inst_32528);

(statearr_32534_32623[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (20))){
var inst_32431 = (state_32532[(7)]);
var inst_32443 = cljs.core.first(inst_32431);
var inst_32444 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32443,(0),null);
var inst_32445 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32443,(1),null);
var state_32532__$1 = (function (){var statearr_32535 = state_32532;
(statearr_32535[(8)] = inst_32444);

return statearr_32535;
})();
if(cljs.core.truth_(inst_32445)){
var statearr_32536_32624 = state_32532__$1;
(statearr_32536_32624[(1)] = (22));

} else {
var statearr_32537_32625 = state_32532__$1;
(statearr_32537_32625[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (27))){
var inst_32400 = (state_32532[(9)]);
var inst_32475 = (state_32532[(10)]);
var inst_32473 = (state_32532[(11)]);
var inst_32480 = (state_32532[(12)]);
var inst_32480__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32473,inst_32475);
var inst_32481 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32480__$1,inst_32400,done);
var state_32532__$1 = (function (){var statearr_32538 = state_32532;
(statearr_32538[(12)] = inst_32480__$1);

return statearr_32538;
})();
if(cljs.core.truth_(inst_32481)){
var statearr_32539_32626 = state_32532__$1;
(statearr_32539_32626[(1)] = (30));

} else {
var statearr_32540_32627 = state_32532__$1;
(statearr_32540_32627[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (1))){
var state_32532__$1 = state_32532;
var statearr_32541_32628 = state_32532__$1;
(statearr_32541_32628[(2)] = null);

(statearr_32541_32628[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (24))){
var inst_32431 = (state_32532[(7)]);
var inst_32450 = (state_32532[(2)]);
var inst_32451 = cljs.core.next(inst_32431);
var inst_32409 = inst_32451;
var inst_32410 = null;
var inst_32411 = (0);
var inst_32412 = (0);
var state_32532__$1 = (function (){var statearr_32542 = state_32532;
(statearr_32542[(13)] = inst_32411);

(statearr_32542[(14)] = inst_32412);

(statearr_32542[(15)] = inst_32410);

(statearr_32542[(16)] = inst_32409);

(statearr_32542[(17)] = inst_32450);

return statearr_32542;
})();
var statearr_32543_32629 = state_32532__$1;
(statearr_32543_32629[(2)] = null);

(statearr_32543_32629[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (39))){
var state_32532__$1 = state_32532;
var statearr_32547_32630 = state_32532__$1;
(statearr_32547_32630[(2)] = null);

(statearr_32547_32630[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (4))){
var inst_32400 = (state_32532[(9)]);
var inst_32400__$1 = (state_32532[(2)]);
var inst_32401 = (inst_32400__$1 == null);
var state_32532__$1 = (function (){var statearr_32548 = state_32532;
(statearr_32548[(9)] = inst_32400__$1);

return statearr_32548;
})();
if(cljs.core.truth_(inst_32401)){
var statearr_32549_32631 = state_32532__$1;
(statearr_32549_32631[(1)] = (5));

} else {
var statearr_32550_32632 = state_32532__$1;
(statearr_32550_32632[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (15))){
var inst_32411 = (state_32532[(13)]);
var inst_32412 = (state_32532[(14)]);
var inst_32410 = (state_32532[(15)]);
var inst_32409 = (state_32532[(16)]);
var inst_32427 = (state_32532[(2)]);
var inst_32428 = (inst_32412 + (1));
var tmp32544 = inst_32411;
var tmp32545 = inst_32410;
var tmp32546 = inst_32409;
var inst_32409__$1 = tmp32546;
var inst_32410__$1 = tmp32545;
var inst_32411__$1 = tmp32544;
var inst_32412__$1 = inst_32428;
var state_32532__$1 = (function (){var statearr_32551 = state_32532;
(statearr_32551[(13)] = inst_32411__$1);

(statearr_32551[(14)] = inst_32412__$1);

(statearr_32551[(15)] = inst_32410__$1);

(statearr_32551[(18)] = inst_32427);

(statearr_32551[(16)] = inst_32409__$1);

return statearr_32551;
})();
var statearr_32552_32633 = state_32532__$1;
(statearr_32552_32633[(2)] = null);

(statearr_32552_32633[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (21))){
var inst_32454 = (state_32532[(2)]);
var state_32532__$1 = state_32532;
var statearr_32556_32634 = state_32532__$1;
(statearr_32556_32634[(2)] = inst_32454);

(statearr_32556_32634[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (31))){
var inst_32480 = (state_32532[(12)]);
var inst_32484 = done(null);
var inst_32485 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32480);
var state_32532__$1 = (function (){var statearr_32557 = state_32532;
(statearr_32557[(19)] = inst_32484);

return statearr_32557;
})();
var statearr_32558_32635 = state_32532__$1;
(statearr_32558_32635[(2)] = inst_32485);

(statearr_32558_32635[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (32))){
var inst_32474 = (state_32532[(20)]);
var inst_32475 = (state_32532[(10)]);
var inst_32473 = (state_32532[(11)]);
var inst_32472 = (state_32532[(21)]);
var inst_32487 = (state_32532[(2)]);
var inst_32488 = (inst_32475 + (1));
var tmp32553 = inst_32474;
var tmp32554 = inst_32473;
var tmp32555 = inst_32472;
var inst_32472__$1 = tmp32555;
var inst_32473__$1 = tmp32554;
var inst_32474__$1 = tmp32553;
var inst_32475__$1 = inst_32488;
var state_32532__$1 = (function (){var statearr_32559 = state_32532;
(statearr_32559[(20)] = inst_32474__$1);

(statearr_32559[(10)] = inst_32475__$1);

(statearr_32559[(22)] = inst_32487);

(statearr_32559[(11)] = inst_32473__$1);

(statearr_32559[(21)] = inst_32472__$1);

return statearr_32559;
})();
var statearr_32560_32636 = state_32532__$1;
(statearr_32560_32636[(2)] = null);

(statearr_32560_32636[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (40))){
var inst_32500 = (state_32532[(23)]);
var inst_32504 = done(null);
var inst_32505 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32500);
var state_32532__$1 = (function (){var statearr_32561 = state_32532;
(statearr_32561[(24)] = inst_32504);

return statearr_32561;
})();
var statearr_32562_32637 = state_32532__$1;
(statearr_32562_32637[(2)] = inst_32505);

(statearr_32562_32637[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (33))){
var inst_32491 = (state_32532[(25)]);
var inst_32493 = cljs.core.chunked_seq_QMARK_(inst_32491);
var state_32532__$1 = state_32532;
if(inst_32493){
var statearr_32563_32638 = state_32532__$1;
(statearr_32563_32638[(1)] = (36));

} else {
var statearr_32564_32639 = state_32532__$1;
(statearr_32564_32639[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (13))){
var inst_32421 = (state_32532[(26)]);
var inst_32424 = cljs.core.async.close_BANG_(inst_32421);
var state_32532__$1 = state_32532;
var statearr_32565_32640 = state_32532__$1;
(statearr_32565_32640[(2)] = inst_32424);

(statearr_32565_32640[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (22))){
var inst_32444 = (state_32532[(8)]);
var inst_32447 = cljs.core.async.close_BANG_(inst_32444);
var state_32532__$1 = state_32532;
var statearr_32566_32641 = state_32532__$1;
(statearr_32566_32641[(2)] = inst_32447);

(statearr_32566_32641[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (36))){
var inst_32491 = (state_32532[(25)]);
var inst_32495 = cljs.core.chunk_first(inst_32491);
var inst_32496 = cljs.core.chunk_rest(inst_32491);
var inst_32497 = cljs.core.count(inst_32495);
var inst_32472 = inst_32496;
var inst_32473 = inst_32495;
var inst_32474 = inst_32497;
var inst_32475 = (0);
var state_32532__$1 = (function (){var statearr_32567 = state_32532;
(statearr_32567[(20)] = inst_32474);

(statearr_32567[(10)] = inst_32475);

(statearr_32567[(11)] = inst_32473);

(statearr_32567[(21)] = inst_32472);

return statearr_32567;
})();
var statearr_32568_32642 = state_32532__$1;
(statearr_32568_32642[(2)] = null);

(statearr_32568_32642[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (41))){
var inst_32491 = (state_32532[(25)]);
var inst_32507 = (state_32532[(2)]);
var inst_32508 = cljs.core.next(inst_32491);
var inst_32472 = inst_32508;
var inst_32473 = null;
var inst_32474 = (0);
var inst_32475 = (0);
var state_32532__$1 = (function (){var statearr_32569 = state_32532;
(statearr_32569[(20)] = inst_32474);

(statearr_32569[(10)] = inst_32475);

(statearr_32569[(11)] = inst_32473);

(statearr_32569[(27)] = inst_32507);

(statearr_32569[(21)] = inst_32472);

return statearr_32569;
})();
var statearr_32570_32643 = state_32532__$1;
(statearr_32570_32643[(2)] = null);

(statearr_32570_32643[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (43))){
var state_32532__$1 = state_32532;
var statearr_32571_32644 = state_32532__$1;
(statearr_32571_32644[(2)] = null);

(statearr_32571_32644[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (29))){
var inst_32516 = (state_32532[(2)]);
var state_32532__$1 = state_32532;
var statearr_32572_32645 = state_32532__$1;
(statearr_32572_32645[(2)] = inst_32516);

(statearr_32572_32645[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (44))){
var inst_32525 = (state_32532[(2)]);
var state_32532__$1 = (function (){var statearr_32573 = state_32532;
(statearr_32573[(28)] = inst_32525);

return statearr_32573;
})();
var statearr_32574_32646 = state_32532__$1;
(statearr_32574_32646[(2)] = null);

(statearr_32574_32646[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (6))){
var inst_32464 = (state_32532[(29)]);
var inst_32463 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32464__$1 = cljs.core.keys(inst_32463);
var inst_32465 = cljs.core.count(inst_32464__$1);
var inst_32466 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_32465) : cljs.core.reset_BANG_.call(null,dctr,inst_32465));
var inst_32471 = cljs.core.seq(inst_32464__$1);
var inst_32472 = inst_32471;
var inst_32473 = null;
var inst_32474 = (0);
var inst_32475 = (0);
var state_32532__$1 = (function (){var statearr_32575 = state_32532;
(statearr_32575[(20)] = inst_32474);

(statearr_32575[(10)] = inst_32475);

(statearr_32575[(29)] = inst_32464__$1);

(statearr_32575[(11)] = inst_32473);

(statearr_32575[(30)] = inst_32466);

(statearr_32575[(21)] = inst_32472);

return statearr_32575;
})();
var statearr_32576_32647 = state_32532__$1;
(statearr_32576_32647[(2)] = null);

(statearr_32576_32647[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (28))){
var inst_32491 = (state_32532[(25)]);
var inst_32472 = (state_32532[(21)]);
var inst_32491__$1 = cljs.core.seq(inst_32472);
var state_32532__$1 = (function (){var statearr_32577 = state_32532;
(statearr_32577[(25)] = inst_32491__$1);

return statearr_32577;
})();
if(inst_32491__$1){
var statearr_32578_32648 = state_32532__$1;
(statearr_32578_32648[(1)] = (33));

} else {
var statearr_32579_32649 = state_32532__$1;
(statearr_32579_32649[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (25))){
var inst_32474 = (state_32532[(20)]);
var inst_32475 = (state_32532[(10)]);
var inst_32477 = (inst_32475 < inst_32474);
var inst_32478 = inst_32477;
var state_32532__$1 = state_32532;
if(cljs.core.truth_(inst_32478)){
var statearr_32580_32650 = state_32532__$1;
(statearr_32580_32650[(1)] = (27));

} else {
var statearr_32581_32651 = state_32532__$1;
(statearr_32581_32651[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (34))){
var state_32532__$1 = state_32532;
var statearr_32582_32652 = state_32532__$1;
(statearr_32582_32652[(2)] = null);

(statearr_32582_32652[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (17))){
var state_32532__$1 = state_32532;
var statearr_32583_32653 = state_32532__$1;
(statearr_32583_32653[(2)] = null);

(statearr_32583_32653[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (3))){
var inst_32530 = (state_32532[(2)]);
var state_32532__$1 = state_32532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32532__$1,inst_32530);
} else {
if((state_val_32533 === (12))){
var inst_32459 = (state_32532[(2)]);
var state_32532__$1 = state_32532;
var statearr_32584_32654 = state_32532__$1;
(statearr_32584_32654[(2)] = inst_32459);

(statearr_32584_32654[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (2))){
var state_32532__$1 = state_32532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32532__$1,(4),ch);
} else {
if((state_val_32533 === (23))){
var state_32532__$1 = state_32532;
var statearr_32585_32655 = state_32532__$1;
(statearr_32585_32655[(2)] = null);

(statearr_32585_32655[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (35))){
var inst_32514 = (state_32532[(2)]);
var state_32532__$1 = state_32532;
var statearr_32586_32656 = state_32532__$1;
(statearr_32586_32656[(2)] = inst_32514);

(statearr_32586_32656[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (19))){
var inst_32431 = (state_32532[(7)]);
var inst_32435 = cljs.core.chunk_first(inst_32431);
var inst_32436 = cljs.core.chunk_rest(inst_32431);
var inst_32437 = cljs.core.count(inst_32435);
var inst_32409 = inst_32436;
var inst_32410 = inst_32435;
var inst_32411 = inst_32437;
var inst_32412 = (0);
var state_32532__$1 = (function (){var statearr_32587 = state_32532;
(statearr_32587[(13)] = inst_32411);

(statearr_32587[(14)] = inst_32412);

(statearr_32587[(15)] = inst_32410);

(statearr_32587[(16)] = inst_32409);

return statearr_32587;
})();
var statearr_32588_32657 = state_32532__$1;
(statearr_32588_32657[(2)] = null);

(statearr_32588_32657[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (11))){
var inst_32431 = (state_32532[(7)]);
var inst_32409 = (state_32532[(16)]);
var inst_32431__$1 = cljs.core.seq(inst_32409);
var state_32532__$1 = (function (){var statearr_32589 = state_32532;
(statearr_32589[(7)] = inst_32431__$1);

return statearr_32589;
})();
if(inst_32431__$1){
var statearr_32590_32658 = state_32532__$1;
(statearr_32590_32658[(1)] = (16));

} else {
var statearr_32591_32659 = state_32532__$1;
(statearr_32591_32659[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (9))){
var inst_32461 = (state_32532[(2)]);
var state_32532__$1 = state_32532;
var statearr_32592_32660 = state_32532__$1;
(statearr_32592_32660[(2)] = inst_32461);

(statearr_32592_32660[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (5))){
var inst_32407 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32408 = cljs.core.seq(inst_32407);
var inst_32409 = inst_32408;
var inst_32410 = null;
var inst_32411 = (0);
var inst_32412 = (0);
var state_32532__$1 = (function (){var statearr_32593 = state_32532;
(statearr_32593[(13)] = inst_32411);

(statearr_32593[(14)] = inst_32412);

(statearr_32593[(15)] = inst_32410);

(statearr_32593[(16)] = inst_32409);

return statearr_32593;
})();
var statearr_32594_32661 = state_32532__$1;
(statearr_32594_32661[(2)] = null);

(statearr_32594_32661[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (14))){
var state_32532__$1 = state_32532;
var statearr_32595_32662 = state_32532__$1;
(statearr_32595_32662[(2)] = null);

(statearr_32595_32662[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (45))){
var inst_32522 = (state_32532[(2)]);
var state_32532__$1 = state_32532;
var statearr_32596_32663 = state_32532__$1;
(statearr_32596_32663[(2)] = inst_32522);

(statearr_32596_32663[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (26))){
var inst_32464 = (state_32532[(29)]);
var inst_32518 = (state_32532[(2)]);
var inst_32519 = cljs.core.seq(inst_32464);
var state_32532__$1 = (function (){var statearr_32597 = state_32532;
(statearr_32597[(31)] = inst_32518);

return statearr_32597;
})();
if(inst_32519){
var statearr_32598_32664 = state_32532__$1;
(statearr_32598_32664[(1)] = (42));

} else {
var statearr_32599_32665 = state_32532__$1;
(statearr_32599_32665[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (16))){
var inst_32431 = (state_32532[(7)]);
var inst_32433 = cljs.core.chunked_seq_QMARK_(inst_32431);
var state_32532__$1 = state_32532;
if(inst_32433){
var statearr_32600_32666 = state_32532__$1;
(statearr_32600_32666[(1)] = (19));

} else {
var statearr_32601_32667 = state_32532__$1;
(statearr_32601_32667[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (38))){
var inst_32511 = (state_32532[(2)]);
var state_32532__$1 = state_32532;
var statearr_32602_32668 = state_32532__$1;
(statearr_32602_32668[(2)] = inst_32511);

(statearr_32602_32668[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (30))){
var state_32532__$1 = state_32532;
var statearr_32603_32669 = state_32532__$1;
(statearr_32603_32669[(2)] = null);

(statearr_32603_32669[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (10))){
var inst_32412 = (state_32532[(14)]);
var inst_32410 = (state_32532[(15)]);
var inst_32420 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32410,inst_32412);
var inst_32421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32420,(0),null);
var inst_32422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32420,(1),null);
var state_32532__$1 = (function (){var statearr_32604 = state_32532;
(statearr_32604[(26)] = inst_32421);

return statearr_32604;
})();
if(cljs.core.truth_(inst_32422)){
var statearr_32605_32670 = state_32532__$1;
(statearr_32605_32670[(1)] = (13));

} else {
var statearr_32606_32671 = state_32532__$1;
(statearr_32606_32671[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (18))){
var inst_32457 = (state_32532[(2)]);
var state_32532__$1 = state_32532;
var statearr_32607_32672 = state_32532__$1;
(statearr_32607_32672[(2)] = inst_32457);

(statearr_32607_32672[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (42))){
var state_32532__$1 = state_32532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32532__$1,(45),dchan);
} else {
if((state_val_32533 === (37))){
var inst_32400 = (state_32532[(9)]);
var inst_32500 = (state_32532[(23)]);
var inst_32491 = (state_32532[(25)]);
var inst_32500__$1 = cljs.core.first(inst_32491);
var inst_32501 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32500__$1,inst_32400,done);
var state_32532__$1 = (function (){var statearr_32608 = state_32532;
(statearr_32608[(23)] = inst_32500__$1);

return statearr_32608;
})();
if(cljs.core.truth_(inst_32501)){
var statearr_32609_32673 = state_32532__$1;
(statearr_32609_32673[(1)] = (39));

} else {
var statearr_32610_32674 = state_32532__$1;
(statearr_32610_32674[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32533 === (8))){
var inst_32411 = (state_32532[(13)]);
var inst_32412 = (state_32532[(14)]);
var inst_32414 = (inst_32412 < inst_32411);
var inst_32415 = inst_32414;
var state_32532__$1 = state_32532;
if(cljs.core.truth_(inst_32415)){
var statearr_32611_32675 = state_32532__$1;
(statearr_32611_32675[(1)] = (10));

} else {
var statearr_32612_32676 = state_32532__$1;
(statearr_32612_32676[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___32622,cs,m,dchan,dctr,done))
;
return ((function (switch__13104__auto__,c__13216__auto___32622,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__13105__auto__ = null;
var cljs$core$async$mult_$_state_machine__13105__auto____0 = (function (){
var statearr_32616 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32616[(0)] = cljs$core$async$mult_$_state_machine__13105__auto__);

(statearr_32616[(1)] = (1));

return statearr_32616;
});
var cljs$core$async$mult_$_state_machine__13105__auto____1 = (function (state_32532){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_32532);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e32617){if((e32617 instanceof Object)){
var ex__13108__auto__ = e32617;
var statearr_32618_32677 = state_32532;
(statearr_32618_32677[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32532);

return cljs.core.cst$kw$recur;
} else {
throw e32617;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__32678 = state_32532;
state_32532 = G__32678;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__13105__auto__ = function(state_32532){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__13105__auto____1.call(this,state_32532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__13105__auto____0;
cljs$core$async$mult_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__13105__auto____1;
return cljs$core$async$mult_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___32622,cs,m,dchan,dctr,done))
})();
var state__13218__auto__ = (function (){var statearr_32619 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_32619[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___32622);

return statearr_32619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___32622,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args32679 = [];
var len__7484__auto___32682 = arguments.length;
var i__7485__auto___32683 = (0);
while(true){
if((i__7485__auto___32683 < len__7484__auto___32682)){
args32679.push((arguments[i__7485__auto___32683]));

var G__32684 = (i__7485__auto___32683 + (1));
i__7485__auto___32683 = G__32684;
continue;
} else {
}
break;
}

var G__32681 = args32679.length;
switch (G__32681) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32679.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto__.call(null,m,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7073__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto__.call(null,m));
} else {
var m__7073__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7073__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto__.call(null,m,state_map));
} else {
var m__7073__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7073__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7072__auto__ = (((m == null))?null:m);
var m__7073__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto__.call(null,m,mode));
} else {
var m__7073__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7073__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___32696 = arguments.length;
var i__7485__auto___32697 = (0);
while(true){
if((i__7485__auto___32697 < len__7484__auto___32696)){
args__7491__auto__.push((arguments[i__7485__auto___32697]));

var G__32698 = (i__7485__auto___32697 + (1));
i__7485__auto___32697 = G__32698;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32690){
var map__32691 = p__32690;
var map__32691__$1 = ((((!((map__32691 == null)))?((((map__32691.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32691.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32691):map__32691);
var opts = map__32691__$1;
var statearr_32693_32699 = state;
(statearr_32693_32699[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__32691,map__32691__$1,opts){
return (function (val){
var statearr_32694_32700 = state;
(statearr_32694_32700[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__32691,map__32691__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_32695_32701 = state;
(statearr_32695_32701[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32686){
var G__32687 = cljs.core.first(seq32686);
var seq32686__$1 = cljs.core.next(seq32686);
var G__32688 = cljs.core.first(seq32686__$1);
var seq32686__$2 = cljs.core.next(seq32686__$1);
var G__32689 = cljs.core.first(seq32686__$2);
var seq32686__$3 = cljs.core.next(seq32686__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32687,G__32688,G__32689,seq32686__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__32871 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32871) : cljs.core.atom.call(null,G__32871));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__32872 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32872) : cljs.core.atom.call(null,G__32872));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32873 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32873 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta32874){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta32874 = meta32874;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32873.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32875,meta32874__$1){
var self__ = this;
var _32875__$1 = this;
return (new cljs.core.async.t_cljs$core$async32873(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta32874__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32873.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32875){
var self__ = this;
var _32875__$1 = this;
return self__.meta32874;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32873.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async32873.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32873.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async32873.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32873.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32873.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32876_33040 = self__.cs;
var G__32877_33041 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32876_33040,G__32877_33041) : cljs.core.reset_BANG_.call(null,G__32876_33040,G__32877_33041));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32873.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32873.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32873.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta32874], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32873.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32873.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32873";

cljs.core.async.t_cljs$core$async32873.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async32873");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async32873 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async32873(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32874){
return (new cljs.core.async.t_cljs$core$async32873(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta32874));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async32873(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13216__auto___33042 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___33042,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___33042,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32977){
var state_val_32978 = (state_32977[(1)]);
if((state_val_32978 === (7))){
var inst_32893 = (state_32977[(2)]);
var state_32977__$1 = state_32977;
var statearr_32979_33043 = state_32977__$1;
(statearr_32979_33043[(2)] = inst_32893);

(statearr_32979_33043[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (20))){
var inst_32905 = (state_32977[(7)]);
var state_32977__$1 = state_32977;
var statearr_32980_33044 = state_32977__$1;
(statearr_32980_33044[(2)] = inst_32905);

(statearr_32980_33044[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (27))){
var state_32977__$1 = state_32977;
var statearr_32981_33045 = state_32977__$1;
(statearr_32981_33045[(2)] = null);

(statearr_32981_33045[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (1))){
var inst_32881 = (state_32977[(8)]);
var inst_32881__$1 = calc_state();
var inst_32883 = (inst_32881__$1 == null);
var inst_32884 = cljs.core.not(inst_32883);
var state_32977__$1 = (function (){var statearr_32982 = state_32977;
(statearr_32982[(8)] = inst_32881__$1);

return statearr_32982;
})();
if(inst_32884){
var statearr_32983_33046 = state_32977__$1;
(statearr_32983_33046[(1)] = (2));

} else {
var statearr_32984_33047 = state_32977__$1;
(statearr_32984_33047[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (24))){
var inst_32951 = (state_32977[(9)]);
var inst_32928 = (state_32977[(10)]);
var inst_32937 = (state_32977[(11)]);
var inst_32951__$1 = (inst_32928.cljs$core$IFn$_invoke$arity$1 ? inst_32928.cljs$core$IFn$_invoke$arity$1(inst_32937) : inst_32928.call(null,inst_32937));
var state_32977__$1 = (function (){var statearr_32985 = state_32977;
(statearr_32985[(9)] = inst_32951__$1);

return statearr_32985;
})();
if(cljs.core.truth_(inst_32951__$1)){
var statearr_32986_33048 = state_32977__$1;
(statearr_32986_33048[(1)] = (29));

} else {
var statearr_32987_33049 = state_32977__$1;
(statearr_32987_33049[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (4))){
var inst_32896 = (state_32977[(2)]);
var state_32977__$1 = state_32977;
if(cljs.core.truth_(inst_32896)){
var statearr_32988_33050 = state_32977__$1;
(statearr_32988_33050[(1)] = (8));

} else {
var statearr_32989_33051 = state_32977__$1;
(statearr_32989_33051[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (15))){
var inst_32922 = (state_32977[(2)]);
var state_32977__$1 = state_32977;
if(cljs.core.truth_(inst_32922)){
var statearr_32990_33052 = state_32977__$1;
(statearr_32990_33052[(1)] = (19));

} else {
var statearr_32991_33053 = state_32977__$1;
(statearr_32991_33053[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (21))){
var inst_32927 = (state_32977[(12)]);
var inst_32927__$1 = (state_32977[(2)]);
var inst_32928 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32927__$1,cljs.core.cst$kw$solos);
var inst_32929 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32927__$1,cljs.core.cst$kw$mutes);
var inst_32930 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32927__$1,cljs.core.cst$kw$reads);
var state_32977__$1 = (function (){var statearr_32992 = state_32977;
(statearr_32992[(13)] = inst_32929);

(statearr_32992[(10)] = inst_32928);

(statearr_32992[(12)] = inst_32927__$1);

return statearr_32992;
})();
return cljs.core.async.ioc_alts_BANG_(state_32977__$1,(22),inst_32930);
} else {
if((state_val_32978 === (31))){
var inst_32959 = (state_32977[(2)]);
var state_32977__$1 = state_32977;
if(cljs.core.truth_(inst_32959)){
var statearr_32993_33054 = state_32977__$1;
(statearr_32993_33054[(1)] = (32));

} else {
var statearr_32994_33055 = state_32977__$1;
(statearr_32994_33055[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (32))){
var inst_32936 = (state_32977[(14)]);
var state_32977__$1 = state_32977;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32977__$1,(35),out,inst_32936);
} else {
if((state_val_32978 === (33))){
var inst_32927 = (state_32977[(12)]);
var inst_32905 = inst_32927;
var state_32977__$1 = (function (){var statearr_32995 = state_32977;
(statearr_32995[(7)] = inst_32905);

return statearr_32995;
})();
var statearr_32996_33056 = state_32977__$1;
(statearr_32996_33056[(2)] = null);

(statearr_32996_33056[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (13))){
var inst_32905 = (state_32977[(7)]);
var inst_32912 = inst_32905.cljs$lang$protocol_mask$partition0$;
var inst_32913 = (inst_32912 & (64));
var inst_32914 = inst_32905.cljs$core$ISeq$;
var inst_32915 = (inst_32913) || (inst_32914);
var state_32977__$1 = state_32977;
if(cljs.core.truth_(inst_32915)){
var statearr_32997_33057 = state_32977__$1;
(statearr_32997_33057[(1)] = (16));

} else {
var statearr_32998_33058 = state_32977__$1;
(statearr_32998_33058[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (22))){
var inst_32936 = (state_32977[(14)]);
var inst_32937 = (state_32977[(11)]);
var inst_32935 = (state_32977[(2)]);
var inst_32936__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32935,(0),null);
var inst_32937__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32935,(1),null);
var inst_32938 = (inst_32936__$1 == null);
var inst_32939 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32937__$1,change);
var inst_32940 = (inst_32938) || (inst_32939);
var state_32977__$1 = (function (){var statearr_32999 = state_32977;
(statearr_32999[(14)] = inst_32936__$1);

(statearr_32999[(11)] = inst_32937__$1);

return statearr_32999;
})();
if(cljs.core.truth_(inst_32940)){
var statearr_33000_33059 = state_32977__$1;
(statearr_33000_33059[(1)] = (23));

} else {
var statearr_33001_33060 = state_32977__$1;
(statearr_33001_33060[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (36))){
var inst_32927 = (state_32977[(12)]);
var inst_32905 = inst_32927;
var state_32977__$1 = (function (){var statearr_33002 = state_32977;
(statearr_33002[(7)] = inst_32905);

return statearr_33002;
})();
var statearr_33003_33061 = state_32977__$1;
(statearr_33003_33061[(2)] = null);

(statearr_33003_33061[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (29))){
var inst_32951 = (state_32977[(9)]);
var state_32977__$1 = state_32977;
var statearr_33004_33062 = state_32977__$1;
(statearr_33004_33062[(2)] = inst_32951);

(statearr_33004_33062[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (6))){
var state_32977__$1 = state_32977;
var statearr_33005_33063 = state_32977__$1;
(statearr_33005_33063[(2)] = false);

(statearr_33005_33063[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (28))){
var inst_32947 = (state_32977[(2)]);
var inst_32948 = calc_state();
var inst_32905 = inst_32948;
var state_32977__$1 = (function (){var statearr_33006 = state_32977;
(statearr_33006[(15)] = inst_32947);

(statearr_33006[(7)] = inst_32905);

return statearr_33006;
})();
var statearr_33007_33064 = state_32977__$1;
(statearr_33007_33064[(2)] = null);

(statearr_33007_33064[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (25))){
var inst_32973 = (state_32977[(2)]);
var state_32977__$1 = state_32977;
var statearr_33008_33065 = state_32977__$1;
(statearr_33008_33065[(2)] = inst_32973);

(statearr_33008_33065[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (34))){
var inst_32971 = (state_32977[(2)]);
var state_32977__$1 = state_32977;
var statearr_33009_33066 = state_32977__$1;
(statearr_33009_33066[(2)] = inst_32971);

(statearr_33009_33066[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (17))){
var state_32977__$1 = state_32977;
var statearr_33010_33067 = state_32977__$1;
(statearr_33010_33067[(2)] = false);

(statearr_33010_33067[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (3))){
var state_32977__$1 = state_32977;
var statearr_33011_33068 = state_32977__$1;
(statearr_33011_33068[(2)] = false);

(statearr_33011_33068[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (12))){
var inst_32975 = (state_32977[(2)]);
var state_32977__$1 = state_32977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32977__$1,inst_32975);
} else {
if((state_val_32978 === (2))){
var inst_32881 = (state_32977[(8)]);
var inst_32886 = inst_32881.cljs$lang$protocol_mask$partition0$;
var inst_32887 = (inst_32886 & (64));
var inst_32888 = inst_32881.cljs$core$ISeq$;
var inst_32889 = (inst_32887) || (inst_32888);
var state_32977__$1 = state_32977;
if(cljs.core.truth_(inst_32889)){
var statearr_33012_33069 = state_32977__$1;
(statearr_33012_33069[(1)] = (5));

} else {
var statearr_33013_33070 = state_32977__$1;
(statearr_33013_33070[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (23))){
var inst_32936 = (state_32977[(14)]);
var inst_32942 = (inst_32936 == null);
var state_32977__$1 = state_32977;
if(cljs.core.truth_(inst_32942)){
var statearr_33014_33071 = state_32977__$1;
(statearr_33014_33071[(1)] = (26));

} else {
var statearr_33015_33072 = state_32977__$1;
(statearr_33015_33072[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (35))){
var inst_32962 = (state_32977[(2)]);
var state_32977__$1 = state_32977;
if(cljs.core.truth_(inst_32962)){
var statearr_33016_33073 = state_32977__$1;
(statearr_33016_33073[(1)] = (36));

} else {
var statearr_33017_33074 = state_32977__$1;
(statearr_33017_33074[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (19))){
var inst_32905 = (state_32977[(7)]);
var inst_32924 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32905);
var state_32977__$1 = state_32977;
var statearr_33018_33075 = state_32977__$1;
(statearr_33018_33075[(2)] = inst_32924);

(statearr_33018_33075[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (11))){
var inst_32905 = (state_32977[(7)]);
var inst_32909 = (inst_32905 == null);
var inst_32910 = cljs.core.not(inst_32909);
var state_32977__$1 = state_32977;
if(inst_32910){
var statearr_33019_33076 = state_32977__$1;
(statearr_33019_33076[(1)] = (13));

} else {
var statearr_33020_33077 = state_32977__$1;
(statearr_33020_33077[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (9))){
var inst_32881 = (state_32977[(8)]);
var state_32977__$1 = state_32977;
var statearr_33021_33078 = state_32977__$1;
(statearr_33021_33078[(2)] = inst_32881);

(statearr_33021_33078[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (5))){
var state_32977__$1 = state_32977;
var statearr_33022_33079 = state_32977__$1;
(statearr_33022_33079[(2)] = true);

(statearr_33022_33079[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (14))){
var state_32977__$1 = state_32977;
var statearr_33023_33080 = state_32977__$1;
(statearr_33023_33080[(2)] = false);

(statearr_33023_33080[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (26))){
var inst_32937 = (state_32977[(11)]);
var inst_32944 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32937);
var state_32977__$1 = state_32977;
var statearr_33024_33081 = state_32977__$1;
(statearr_33024_33081[(2)] = inst_32944);

(statearr_33024_33081[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (16))){
var state_32977__$1 = state_32977;
var statearr_33025_33082 = state_32977__$1;
(statearr_33025_33082[(2)] = true);

(statearr_33025_33082[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (38))){
var inst_32967 = (state_32977[(2)]);
var state_32977__$1 = state_32977;
var statearr_33026_33083 = state_32977__$1;
(statearr_33026_33083[(2)] = inst_32967);

(statearr_33026_33083[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (30))){
var inst_32929 = (state_32977[(13)]);
var inst_32928 = (state_32977[(10)]);
var inst_32937 = (state_32977[(11)]);
var inst_32954 = cljs.core.empty_QMARK_(inst_32928);
var inst_32955 = (inst_32929.cljs$core$IFn$_invoke$arity$1 ? inst_32929.cljs$core$IFn$_invoke$arity$1(inst_32937) : inst_32929.call(null,inst_32937));
var inst_32956 = cljs.core.not(inst_32955);
var inst_32957 = (inst_32954) && (inst_32956);
var state_32977__$1 = state_32977;
var statearr_33027_33084 = state_32977__$1;
(statearr_33027_33084[(2)] = inst_32957);

(statearr_33027_33084[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (10))){
var inst_32881 = (state_32977[(8)]);
var inst_32901 = (state_32977[(2)]);
var inst_32902 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32901,cljs.core.cst$kw$solos);
var inst_32903 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32901,cljs.core.cst$kw$mutes);
var inst_32904 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32901,cljs.core.cst$kw$reads);
var inst_32905 = inst_32881;
var state_32977__$1 = (function (){var statearr_33028 = state_32977;
(statearr_33028[(16)] = inst_32902);

(statearr_33028[(17)] = inst_32904);

(statearr_33028[(7)] = inst_32905);

(statearr_33028[(18)] = inst_32903);

return statearr_33028;
})();
var statearr_33029_33085 = state_32977__$1;
(statearr_33029_33085[(2)] = null);

(statearr_33029_33085[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (18))){
var inst_32919 = (state_32977[(2)]);
var state_32977__$1 = state_32977;
var statearr_33030_33086 = state_32977__$1;
(statearr_33030_33086[(2)] = inst_32919);

(statearr_33030_33086[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (37))){
var state_32977__$1 = state_32977;
var statearr_33031_33087 = state_32977__$1;
(statearr_33031_33087[(2)] = null);

(statearr_33031_33087[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32978 === (8))){
var inst_32881 = (state_32977[(8)]);
var inst_32898 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32881);
var state_32977__$1 = state_32977;
var statearr_33032_33088 = state_32977__$1;
(statearr_33032_33088[(2)] = inst_32898);

(statearr_33032_33088[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___33042,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__13104__auto__,c__13216__auto___33042,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__13105__auto__ = null;
var cljs$core$async$mix_$_state_machine__13105__auto____0 = (function (){
var statearr_33036 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33036[(0)] = cljs$core$async$mix_$_state_machine__13105__auto__);

(statearr_33036[(1)] = (1));

return statearr_33036;
});
var cljs$core$async$mix_$_state_machine__13105__auto____1 = (function (state_32977){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_32977);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e33037){if((e33037 instanceof Object)){
var ex__13108__auto__ = e33037;
var statearr_33038_33089 = state_32977;
(statearr_33038_33089[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32977);

return cljs.core.cst$kw$recur;
} else {
throw e33037;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__33090 = state_32977;
state_32977 = G__33090;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__13105__auto__ = function(state_32977){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__13105__auto____1.call(this,state_32977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__13105__auto____0;
cljs$core$async$mix_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__13105__auto____1;
return cljs$core$async$mix_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___33042,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__13218__auto__ = (function (){var statearr_33039 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_33039[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___33042);

return statearr_33039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___33042,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7073__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7073__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto__.call(null,p,v,ch));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7073__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args33091 = [];
var len__7484__auto___33094 = arguments.length;
var i__7485__auto___33095 = (0);
while(true){
if((i__7485__auto___33095 < len__7484__auto___33094)){
args33091.push((arguments[i__7485__auto___33095]));

var G__33096 = (i__7485__auto___33095 + (1));
i__7485__auto___33095 = G__33096;
continue;
} else {
}
break;
}

var G__33093 = args33091.length;
switch (G__33093) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33091.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto__.call(null,p));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7073__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7072__auto__ = (((p == null))?null:p);
var m__7073__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7072__auto__)]);
if(!((m__7073__auto__ == null))){
return (m__7073__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto__.call(null,p,v));
} else {
var m__7073__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7073__auto____$1 == null))){
return (m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7073__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7073__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args33099 = [];
var len__7484__auto___33227 = arguments.length;
var i__7485__auto___33228 = (0);
while(true){
if((i__7485__auto___33228 < len__7484__auto___33227)){
args33099.push((arguments[i__7485__auto___33228]));

var G__33229 = (i__7485__auto___33228 + (1));
i__7485__auto___33228 = G__33229;
continue;
} else {
}
break;
}

var G__33101 = args33099.length;
switch (G__33101) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33099.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__33102 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33102) : cljs.core.atom.call(null,G__33102));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6409__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6409__auto__,mults){
return (function (p1__33098_SHARP_){
if(cljs.core.truth_((p1__33098_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33098_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__33098_SHARP_.call(null,topic)))){
return p1__33098_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__33098_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6409__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async33103 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33103 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta33104){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta33104 = meta33104;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33103.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33105,meta33104__$1){
var self__ = this;
var _33105__$1 = this;
return (new cljs.core.async.t_cljs$core$async33103(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta33104__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33103.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33105){
var self__ = this;
var _33105__$1 = this;
return self__.meta33104;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33103.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async33103.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33103.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async33103.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33103.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33103.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__33106 = self__.mults;
var G__33107 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33106,G__33107) : cljs.core.reset_BANG_.call(null,G__33106,G__33107));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33103.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33103.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta33104], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33103.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33103.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33103";

cljs.core.async.t_cljs$core$async33103.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33103");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async33103 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async33103(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33104){
return (new cljs.core.async.t_cljs$core$async33103(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33104));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async33103(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13216__auto___33231 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___33231,mults,ensure_mult,p){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___33231,mults,ensure_mult,p){
return (function (state_33179){
var state_val_33180 = (state_33179[(1)]);
if((state_val_33180 === (7))){
var inst_33175 = (state_33179[(2)]);
var state_33179__$1 = state_33179;
var statearr_33181_33232 = state_33179__$1;
(statearr_33181_33232[(2)] = inst_33175);

(statearr_33181_33232[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (20))){
var state_33179__$1 = state_33179;
var statearr_33182_33233 = state_33179__$1;
(statearr_33182_33233[(2)] = null);

(statearr_33182_33233[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (1))){
var state_33179__$1 = state_33179;
var statearr_33183_33234 = state_33179__$1;
(statearr_33183_33234[(2)] = null);

(statearr_33183_33234[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (24))){
var inst_33158 = (state_33179[(7)]);
var inst_33167 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_33158);
var state_33179__$1 = state_33179;
var statearr_33184_33235 = state_33179__$1;
(statearr_33184_33235[(2)] = inst_33167);

(statearr_33184_33235[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (4))){
var inst_33110 = (state_33179[(8)]);
var inst_33110__$1 = (state_33179[(2)]);
var inst_33111 = (inst_33110__$1 == null);
var state_33179__$1 = (function (){var statearr_33185 = state_33179;
(statearr_33185[(8)] = inst_33110__$1);

return statearr_33185;
})();
if(cljs.core.truth_(inst_33111)){
var statearr_33186_33236 = state_33179__$1;
(statearr_33186_33236[(1)] = (5));

} else {
var statearr_33187_33237 = state_33179__$1;
(statearr_33187_33237[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (15))){
var inst_33152 = (state_33179[(2)]);
var state_33179__$1 = state_33179;
var statearr_33188_33238 = state_33179__$1;
(statearr_33188_33238[(2)] = inst_33152);

(statearr_33188_33238[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (21))){
var inst_33172 = (state_33179[(2)]);
var state_33179__$1 = (function (){var statearr_33189 = state_33179;
(statearr_33189[(9)] = inst_33172);

return statearr_33189;
})();
var statearr_33190_33239 = state_33179__$1;
(statearr_33190_33239[(2)] = null);

(statearr_33190_33239[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (13))){
var inst_33134 = (state_33179[(10)]);
var inst_33136 = cljs.core.chunked_seq_QMARK_(inst_33134);
var state_33179__$1 = state_33179;
if(inst_33136){
var statearr_33191_33240 = state_33179__$1;
(statearr_33191_33240[(1)] = (16));

} else {
var statearr_33192_33241 = state_33179__$1;
(statearr_33192_33241[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (22))){
var inst_33164 = (state_33179[(2)]);
var state_33179__$1 = state_33179;
if(cljs.core.truth_(inst_33164)){
var statearr_33193_33242 = state_33179__$1;
(statearr_33193_33242[(1)] = (23));

} else {
var statearr_33194_33243 = state_33179__$1;
(statearr_33194_33243[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (6))){
var inst_33158 = (state_33179[(7)]);
var inst_33160 = (state_33179[(11)]);
var inst_33110 = (state_33179[(8)]);
var inst_33158__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_33110) : topic_fn.call(null,inst_33110));
var inst_33159 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33160__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33159,inst_33158__$1);
var state_33179__$1 = (function (){var statearr_33195 = state_33179;
(statearr_33195[(7)] = inst_33158__$1);

(statearr_33195[(11)] = inst_33160__$1);

return statearr_33195;
})();
if(cljs.core.truth_(inst_33160__$1)){
var statearr_33196_33244 = state_33179__$1;
(statearr_33196_33244[(1)] = (19));

} else {
var statearr_33197_33245 = state_33179__$1;
(statearr_33197_33245[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (25))){
var inst_33169 = (state_33179[(2)]);
var state_33179__$1 = state_33179;
var statearr_33198_33246 = state_33179__$1;
(statearr_33198_33246[(2)] = inst_33169);

(statearr_33198_33246[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (17))){
var inst_33134 = (state_33179[(10)]);
var inst_33143 = cljs.core.first(inst_33134);
var inst_33144 = cljs.core.async.muxch_STAR_(inst_33143);
var inst_33145 = cljs.core.async.close_BANG_(inst_33144);
var inst_33146 = cljs.core.next(inst_33134);
var inst_33120 = inst_33146;
var inst_33121 = null;
var inst_33122 = (0);
var inst_33123 = (0);
var state_33179__$1 = (function (){var statearr_33199 = state_33179;
(statearr_33199[(12)] = inst_33145);

(statearr_33199[(13)] = inst_33123);

(statearr_33199[(14)] = inst_33120);

(statearr_33199[(15)] = inst_33121);

(statearr_33199[(16)] = inst_33122);

return statearr_33199;
})();
var statearr_33200_33247 = state_33179__$1;
(statearr_33200_33247[(2)] = null);

(statearr_33200_33247[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (3))){
var inst_33177 = (state_33179[(2)]);
var state_33179__$1 = state_33179;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33179__$1,inst_33177);
} else {
if((state_val_33180 === (12))){
var inst_33154 = (state_33179[(2)]);
var state_33179__$1 = state_33179;
var statearr_33201_33248 = state_33179__$1;
(statearr_33201_33248[(2)] = inst_33154);

(statearr_33201_33248[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (2))){
var state_33179__$1 = state_33179;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33179__$1,(4),ch);
} else {
if((state_val_33180 === (23))){
var state_33179__$1 = state_33179;
var statearr_33202_33249 = state_33179__$1;
(statearr_33202_33249[(2)] = null);

(statearr_33202_33249[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (19))){
var inst_33160 = (state_33179[(11)]);
var inst_33110 = (state_33179[(8)]);
var inst_33162 = cljs.core.async.muxch_STAR_(inst_33160);
var state_33179__$1 = state_33179;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33179__$1,(22),inst_33162,inst_33110);
} else {
if((state_val_33180 === (11))){
var inst_33134 = (state_33179[(10)]);
var inst_33120 = (state_33179[(14)]);
var inst_33134__$1 = cljs.core.seq(inst_33120);
var state_33179__$1 = (function (){var statearr_33203 = state_33179;
(statearr_33203[(10)] = inst_33134__$1);

return statearr_33203;
})();
if(inst_33134__$1){
var statearr_33204_33250 = state_33179__$1;
(statearr_33204_33250[(1)] = (13));

} else {
var statearr_33205_33251 = state_33179__$1;
(statearr_33205_33251[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (9))){
var inst_33156 = (state_33179[(2)]);
var state_33179__$1 = state_33179;
var statearr_33206_33252 = state_33179__$1;
(statearr_33206_33252[(2)] = inst_33156);

(statearr_33206_33252[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (5))){
var inst_33117 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33118 = cljs.core.vals(inst_33117);
var inst_33119 = cljs.core.seq(inst_33118);
var inst_33120 = inst_33119;
var inst_33121 = null;
var inst_33122 = (0);
var inst_33123 = (0);
var state_33179__$1 = (function (){var statearr_33207 = state_33179;
(statearr_33207[(13)] = inst_33123);

(statearr_33207[(14)] = inst_33120);

(statearr_33207[(15)] = inst_33121);

(statearr_33207[(16)] = inst_33122);

return statearr_33207;
})();
var statearr_33208_33253 = state_33179__$1;
(statearr_33208_33253[(2)] = null);

(statearr_33208_33253[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (14))){
var state_33179__$1 = state_33179;
var statearr_33212_33254 = state_33179__$1;
(statearr_33212_33254[(2)] = null);

(statearr_33212_33254[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (16))){
var inst_33134 = (state_33179[(10)]);
var inst_33138 = cljs.core.chunk_first(inst_33134);
var inst_33139 = cljs.core.chunk_rest(inst_33134);
var inst_33140 = cljs.core.count(inst_33138);
var inst_33120 = inst_33139;
var inst_33121 = inst_33138;
var inst_33122 = inst_33140;
var inst_33123 = (0);
var state_33179__$1 = (function (){var statearr_33213 = state_33179;
(statearr_33213[(13)] = inst_33123);

(statearr_33213[(14)] = inst_33120);

(statearr_33213[(15)] = inst_33121);

(statearr_33213[(16)] = inst_33122);

return statearr_33213;
})();
var statearr_33214_33255 = state_33179__$1;
(statearr_33214_33255[(2)] = null);

(statearr_33214_33255[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (10))){
var inst_33123 = (state_33179[(13)]);
var inst_33120 = (state_33179[(14)]);
var inst_33121 = (state_33179[(15)]);
var inst_33122 = (state_33179[(16)]);
var inst_33128 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33121,inst_33123);
var inst_33129 = cljs.core.async.muxch_STAR_(inst_33128);
var inst_33130 = cljs.core.async.close_BANG_(inst_33129);
var inst_33131 = (inst_33123 + (1));
var tmp33209 = inst_33120;
var tmp33210 = inst_33121;
var tmp33211 = inst_33122;
var inst_33120__$1 = tmp33209;
var inst_33121__$1 = tmp33210;
var inst_33122__$1 = tmp33211;
var inst_33123__$1 = inst_33131;
var state_33179__$1 = (function (){var statearr_33215 = state_33179;
(statearr_33215[(13)] = inst_33123__$1);

(statearr_33215[(14)] = inst_33120__$1);

(statearr_33215[(15)] = inst_33121__$1);

(statearr_33215[(17)] = inst_33130);

(statearr_33215[(16)] = inst_33122__$1);

return statearr_33215;
})();
var statearr_33216_33256 = state_33179__$1;
(statearr_33216_33256[(2)] = null);

(statearr_33216_33256[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (18))){
var inst_33149 = (state_33179[(2)]);
var state_33179__$1 = state_33179;
var statearr_33217_33257 = state_33179__$1;
(statearr_33217_33257[(2)] = inst_33149);

(statearr_33217_33257[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33180 === (8))){
var inst_33123 = (state_33179[(13)]);
var inst_33122 = (state_33179[(16)]);
var inst_33125 = (inst_33123 < inst_33122);
var inst_33126 = inst_33125;
var state_33179__$1 = state_33179;
if(cljs.core.truth_(inst_33126)){
var statearr_33218_33258 = state_33179__$1;
(statearr_33218_33258[(1)] = (10));

} else {
var statearr_33219_33259 = state_33179__$1;
(statearr_33219_33259[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___33231,mults,ensure_mult,p))
;
return ((function (switch__13104__auto__,c__13216__auto___33231,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_33223 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33223[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_33223[(1)] = (1));

return statearr_33223;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_33179){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_33179);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e33224){if((e33224 instanceof Object)){
var ex__13108__auto__ = e33224;
var statearr_33225_33260 = state_33179;
(statearr_33225_33260[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33179);

return cljs.core.cst$kw$recur;
} else {
throw e33224;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__33261 = state_33179;
state_33179 = G__33261;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_33179){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_33179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___33231,mults,ensure_mult,p))
})();
var state__13218__auto__ = (function (){var statearr_33226 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_33226[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___33231);

return statearr_33226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___33231,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args33262 = [];
var len__7484__auto___33265 = arguments.length;
var i__7485__auto___33266 = (0);
while(true){
if((i__7485__auto___33266 < len__7484__auto___33265)){
args33262.push((arguments[i__7485__auto___33266]));

var G__33267 = (i__7485__auto___33266 + (1));
i__7485__auto___33266 = G__33267;
continue;
} else {
}
break;
}

var G__33264 = args33262.length;
switch (G__33264) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33262.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args33269 = [];
var len__7484__auto___33272 = arguments.length;
var i__7485__auto___33273 = (0);
while(true){
if((i__7485__auto___33273 < len__7484__auto___33272)){
args33269.push((arguments[i__7485__auto___33273]));

var G__33274 = (i__7485__auto___33273 + (1));
i__7485__auto___33273 = G__33274;
continue;
} else {
}
break;
}

var G__33271 = args33269.length;
switch (G__33271) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33269.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args33276 = [];
var len__7484__auto___33347 = arguments.length;
var i__7485__auto___33348 = (0);
while(true){
if((i__7485__auto___33348 < len__7484__auto___33347)){
args33276.push((arguments[i__7485__auto___33348]));

var G__33349 = (i__7485__auto___33348 + (1));
i__7485__auto___33348 = G__33349;
continue;
} else {
}
break;
}

var G__33278 = args33276.length;
switch (G__33278) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33276.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__13216__auto___33351 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___33351,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___33351,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33317){
var state_val_33318 = (state_33317[(1)]);
if((state_val_33318 === (7))){
var state_33317__$1 = state_33317;
var statearr_33319_33352 = state_33317__$1;
(statearr_33319_33352[(2)] = null);

(statearr_33319_33352[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (1))){
var state_33317__$1 = state_33317;
var statearr_33320_33353 = state_33317__$1;
(statearr_33320_33353[(2)] = null);

(statearr_33320_33353[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (4))){
var inst_33281 = (state_33317[(7)]);
var inst_33283 = (inst_33281 < cnt);
var state_33317__$1 = state_33317;
if(cljs.core.truth_(inst_33283)){
var statearr_33321_33354 = state_33317__$1;
(statearr_33321_33354[(1)] = (6));

} else {
var statearr_33322_33355 = state_33317__$1;
(statearr_33322_33355[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (15))){
var inst_33313 = (state_33317[(2)]);
var state_33317__$1 = state_33317;
var statearr_33323_33356 = state_33317__$1;
(statearr_33323_33356[(2)] = inst_33313);

(statearr_33323_33356[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (13))){
var inst_33306 = cljs.core.async.close_BANG_(out);
var state_33317__$1 = state_33317;
var statearr_33324_33357 = state_33317__$1;
(statearr_33324_33357[(2)] = inst_33306);

(statearr_33324_33357[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (6))){
var state_33317__$1 = state_33317;
var statearr_33325_33358 = state_33317__$1;
(statearr_33325_33358[(2)] = null);

(statearr_33325_33358[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (3))){
var inst_33315 = (state_33317[(2)]);
var state_33317__$1 = state_33317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33317__$1,inst_33315);
} else {
if((state_val_33318 === (12))){
var inst_33303 = (state_33317[(8)]);
var inst_33303__$1 = (state_33317[(2)]);
var inst_33304 = cljs.core.some(cljs.core.nil_QMARK_,inst_33303__$1);
var state_33317__$1 = (function (){var statearr_33326 = state_33317;
(statearr_33326[(8)] = inst_33303__$1);

return statearr_33326;
})();
if(cljs.core.truth_(inst_33304)){
var statearr_33327_33359 = state_33317__$1;
(statearr_33327_33359[(1)] = (13));

} else {
var statearr_33328_33360 = state_33317__$1;
(statearr_33328_33360[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (2))){
var inst_33280 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_33281 = (0);
var state_33317__$1 = (function (){var statearr_33329 = state_33317;
(statearr_33329[(9)] = inst_33280);

(statearr_33329[(7)] = inst_33281);

return statearr_33329;
})();
var statearr_33330_33361 = state_33317__$1;
(statearr_33330_33361[(2)] = null);

(statearr_33330_33361[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (11))){
var inst_33281 = (state_33317[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_33317,(10),Object,null,(9));
var inst_33290 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_33281) : chs__$1.call(null,inst_33281));
var inst_33291 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_33281) : done.call(null,inst_33281));
var inst_33292 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33290,inst_33291);
var state_33317__$1 = state_33317;
var statearr_33331_33362 = state_33317__$1;
(statearr_33331_33362[(2)] = inst_33292);


cljs.core.async.impl.ioc_helpers.process_exception(state_33317__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (9))){
var inst_33281 = (state_33317[(7)]);
var inst_33294 = (state_33317[(2)]);
var inst_33295 = (inst_33281 + (1));
var inst_33281__$1 = inst_33295;
var state_33317__$1 = (function (){var statearr_33332 = state_33317;
(statearr_33332[(7)] = inst_33281__$1);

(statearr_33332[(10)] = inst_33294);

return statearr_33332;
})();
var statearr_33333_33363 = state_33317__$1;
(statearr_33333_33363[(2)] = null);

(statearr_33333_33363[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (5))){
var inst_33301 = (state_33317[(2)]);
var state_33317__$1 = (function (){var statearr_33334 = state_33317;
(statearr_33334[(11)] = inst_33301);

return statearr_33334;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33317__$1,(12),dchan);
} else {
if((state_val_33318 === (14))){
var inst_33303 = (state_33317[(8)]);
var inst_33308 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33303);
var state_33317__$1 = state_33317;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33317__$1,(16),out,inst_33308);
} else {
if((state_val_33318 === (16))){
var inst_33310 = (state_33317[(2)]);
var state_33317__$1 = (function (){var statearr_33335 = state_33317;
(statearr_33335[(12)] = inst_33310);

return statearr_33335;
})();
var statearr_33336_33364 = state_33317__$1;
(statearr_33336_33364[(2)] = null);

(statearr_33336_33364[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (10))){
var inst_33285 = (state_33317[(2)]);
var inst_33286 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33317__$1 = (function (){var statearr_33337 = state_33317;
(statearr_33337[(13)] = inst_33285);

return statearr_33337;
})();
var statearr_33338_33365 = state_33317__$1;
(statearr_33338_33365[(2)] = inst_33286);


cljs.core.async.impl.ioc_helpers.process_exception(state_33317__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33318 === (8))){
var inst_33299 = (state_33317[(2)]);
var state_33317__$1 = state_33317;
var statearr_33339_33366 = state_33317__$1;
(statearr_33339_33366[(2)] = inst_33299);

(statearr_33339_33366[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___33351,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__13104__auto__,c__13216__auto___33351,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_33343 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33343[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_33343[(1)] = (1));

return statearr_33343;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_33317){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_33317);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e33344){if((e33344 instanceof Object)){
var ex__13108__auto__ = e33344;
var statearr_33345_33367 = state_33317;
(statearr_33345_33367[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33317);

return cljs.core.cst$kw$recur;
} else {
throw e33344;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__33368 = state_33317;
state_33317 = G__33368;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_33317){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_33317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___33351,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__13218__auto__ = (function (){var statearr_33346 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_33346[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___33351);

return statearr_33346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___33351,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args33370 = [];
var len__7484__auto___33428 = arguments.length;
var i__7485__auto___33429 = (0);
while(true){
if((i__7485__auto___33429 < len__7484__auto___33428)){
args33370.push((arguments[i__7485__auto___33429]));

var G__33430 = (i__7485__auto___33429 + (1));
i__7485__auto___33429 = G__33430;
continue;
} else {
}
break;
}

var G__33372 = args33370.length;
switch (G__33372) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33370.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13216__auto___33432 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___33432,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___33432,out){
return (function (state_33404){
var state_val_33405 = (state_33404[(1)]);
if((state_val_33405 === (7))){
var inst_33383 = (state_33404[(7)]);
var inst_33384 = (state_33404[(8)]);
var inst_33383__$1 = (state_33404[(2)]);
var inst_33384__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33383__$1,(0),null);
var inst_33385 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33383__$1,(1),null);
var inst_33386 = (inst_33384__$1 == null);
var state_33404__$1 = (function (){var statearr_33406 = state_33404;
(statearr_33406[(7)] = inst_33383__$1);

(statearr_33406[(8)] = inst_33384__$1);

(statearr_33406[(9)] = inst_33385);

return statearr_33406;
})();
if(cljs.core.truth_(inst_33386)){
var statearr_33407_33433 = state_33404__$1;
(statearr_33407_33433[(1)] = (8));

} else {
var statearr_33408_33434 = state_33404__$1;
(statearr_33408_33434[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33405 === (1))){
var inst_33373 = cljs.core.vec(chs);
var inst_33374 = inst_33373;
var state_33404__$1 = (function (){var statearr_33409 = state_33404;
(statearr_33409[(10)] = inst_33374);

return statearr_33409;
})();
var statearr_33410_33435 = state_33404__$1;
(statearr_33410_33435[(2)] = null);

(statearr_33410_33435[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33405 === (4))){
var inst_33374 = (state_33404[(10)]);
var state_33404__$1 = state_33404;
return cljs.core.async.ioc_alts_BANG_(state_33404__$1,(7),inst_33374);
} else {
if((state_val_33405 === (6))){
var inst_33400 = (state_33404[(2)]);
var state_33404__$1 = state_33404;
var statearr_33411_33436 = state_33404__$1;
(statearr_33411_33436[(2)] = inst_33400);

(statearr_33411_33436[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33405 === (3))){
var inst_33402 = (state_33404[(2)]);
var state_33404__$1 = state_33404;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33404__$1,inst_33402);
} else {
if((state_val_33405 === (2))){
var inst_33374 = (state_33404[(10)]);
var inst_33376 = cljs.core.count(inst_33374);
var inst_33377 = (inst_33376 > (0));
var state_33404__$1 = state_33404;
if(cljs.core.truth_(inst_33377)){
var statearr_33413_33437 = state_33404__$1;
(statearr_33413_33437[(1)] = (4));

} else {
var statearr_33414_33438 = state_33404__$1;
(statearr_33414_33438[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33405 === (11))){
var inst_33374 = (state_33404[(10)]);
var inst_33393 = (state_33404[(2)]);
var tmp33412 = inst_33374;
var inst_33374__$1 = tmp33412;
var state_33404__$1 = (function (){var statearr_33415 = state_33404;
(statearr_33415[(11)] = inst_33393);

(statearr_33415[(10)] = inst_33374__$1);

return statearr_33415;
})();
var statearr_33416_33439 = state_33404__$1;
(statearr_33416_33439[(2)] = null);

(statearr_33416_33439[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33405 === (9))){
var inst_33384 = (state_33404[(8)]);
var state_33404__$1 = state_33404;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33404__$1,(11),out,inst_33384);
} else {
if((state_val_33405 === (5))){
var inst_33398 = cljs.core.async.close_BANG_(out);
var state_33404__$1 = state_33404;
var statearr_33417_33440 = state_33404__$1;
(statearr_33417_33440[(2)] = inst_33398);

(statearr_33417_33440[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33405 === (10))){
var inst_33396 = (state_33404[(2)]);
var state_33404__$1 = state_33404;
var statearr_33418_33441 = state_33404__$1;
(statearr_33418_33441[(2)] = inst_33396);

(statearr_33418_33441[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33405 === (8))){
var inst_33383 = (state_33404[(7)]);
var inst_33384 = (state_33404[(8)]);
var inst_33385 = (state_33404[(9)]);
var inst_33374 = (state_33404[(10)]);
var inst_33388 = (function (){var cs = inst_33374;
var vec__33379 = inst_33383;
var v = inst_33384;
var c = inst_33385;
return ((function (cs,vec__33379,v,c,inst_33383,inst_33384,inst_33385,inst_33374,state_val_33405,c__13216__auto___33432,out){
return (function (p1__33369_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33369_SHARP_);
});
;})(cs,vec__33379,v,c,inst_33383,inst_33384,inst_33385,inst_33374,state_val_33405,c__13216__auto___33432,out))
})();
var inst_33389 = cljs.core.filterv(inst_33388,inst_33374);
var inst_33374__$1 = inst_33389;
var state_33404__$1 = (function (){var statearr_33419 = state_33404;
(statearr_33419[(10)] = inst_33374__$1);

return statearr_33419;
})();
var statearr_33420_33442 = state_33404__$1;
(statearr_33420_33442[(2)] = null);

(statearr_33420_33442[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___33432,out))
;
return ((function (switch__13104__auto__,c__13216__auto___33432,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_33424 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33424[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_33424[(1)] = (1));

return statearr_33424;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_33404){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_33404);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e33425){if((e33425 instanceof Object)){
var ex__13108__auto__ = e33425;
var statearr_33426_33443 = state_33404;
(statearr_33426_33443[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33404);

return cljs.core.cst$kw$recur;
} else {
throw e33425;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__33444 = state_33404;
state_33404 = G__33444;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_33404){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_33404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___33432,out))
})();
var state__13218__auto__ = (function (){var statearr_33427 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_33427[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___33432);

return statearr_33427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___33432,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args33445 = [];
var len__7484__auto___33494 = arguments.length;
var i__7485__auto___33495 = (0);
while(true){
if((i__7485__auto___33495 < len__7484__auto___33494)){
args33445.push((arguments[i__7485__auto___33495]));

var G__33496 = (i__7485__auto___33495 + (1));
i__7485__auto___33495 = G__33496;
continue;
} else {
}
break;
}

var G__33447 = args33445.length;
switch (G__33447) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33445.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13216__auto___33498 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___33498,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___33498,out){
return (function (state_33471){
var state_val_33472 = (state_33471[(1)]);
if((state_val_33472 === (7))){
var inst_33453 = (state_33471[(7)]);
var inst_33453__$1 = (state_33471[(2)]);
var inst_33454 = (inst_33453__$1 == null);
var inst_33455 = cljs.core.not(inst_33454);
var state_33471__$1 = (function (){var statearr_33473 = state_33471;
(statearr_33473[(7)] = inst_33453__$1);

return statearr_33473;
})();
if(inst_33455){
var statearr_33474_33499 = state_33471__$1;
(statearr_33474_33499[(1)] = (8));

} else {
var statearr_33475_33500 = state_33471__$1;
(statearr_33475_33500[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33472 === (1))){
var inst_33448 = (0);
var state_33471__$1 = (function (){var statearr_33476 = state_33471;
(statearr_33476[(8)] = inst_33448);

return statearr_33476;
})();
var statearr_33477_33501 = state_33471__$1;
(statearr_33477_33501[(2)] = null);

(statearr_33477_33501[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33472 === (4))){
var state_33471__$1 = state_33471;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33471__$1,(7),ch);
} else {
if((state_val_33472 === (6))){
var inst_33466 = (state_33471[(2)]);
var state_33471__$1 = state_33471;
var statearr_33478_33502 = state_33471__$1;
(statearr_33478_33502[(2)] = inst_33466);

(statearr_33478_33502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33472 === (3))){
var inst_33468 = (state_33471[(2)]);
var inst_33469 = cljs.core.async.close_BANG_(out);
var state_33471__$1 = (function (){var statearr_33479 = state_33471;
(statearr_33479[(9)] = inst_33468);

return statearr_33479;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33471__$1,inst_33469);
} else {
if((state_val_33472 === (2))){
var inst_33448 = (state_33471[(8)]);
var inst_33450 = (inst_33448 < n);
var state_33471__$1 = state_33471;
if(cljs.core.truth_(inst_33450)){
var statearr_33480_33503 = state_33471__$1;
(statearr_33480_33503[(1)] = (4));

} else {
var statearr_33481_33504 = state_33471__$1;
(statearr_33481_33504[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33472 === (11))){
var inst_33448 = (state_33471[(8)]);
var inst_33458 = (state_33471[(2)]);
var inst_33459 = (inst_33448 + (1));
var inst_33448__$1 = inst_33459;
var state_33471__$1 = (function (){var statearr_33482 = state_33471;
(statearr_33482[(8)] = inst_33448__$1);

(statearr_33482[(10)] = inst_33458);

return statearr_33482;
})();
var statearr_33483_33505 = state_33471__$1;
(statearr_33483_33505[(2)] = null);

(statearr_33483_33505[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33472 === (9))){
var state_33471__$1 = state_33471;
var statearr_33484_33506 = state_33471__$1;
(statearr_33484_33506[(2)] = null);

(statearr_33484_33506[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33472 === (5))){
var state_33471__$1 = state_33471;
var statearr_33485_33507 = state_33471__$1;
(statearr_33485_33507[(2)] = null);

(statearr_33485_33507[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33472 === (10))){
var inst_33463 = (state_33471[(2)]);
var state_33471__$1 = state_33471;
var statearr_33486_33508 = state_33471__$1;
(statearr_33486_33508[(2)] = inst_33463);

(statearr_33486_33508[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33472 === (8))){
var inst_33453 = (state_33471[(7)]);
var state_33471__$1 = state_33471;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33471__$1,(11),out,inst_33453);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___33498,out))
;
return ((function (switch__13104__auto__,c__13216__auto___33498,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_33490 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33490[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_33490[(1)] = (1));

return statearr_33490;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_33471){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_33471);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e33491){if((e33491 instanceof Object)){
var ex__13108__auto__ = e33491;
var statearr_33492_33509 = state_33471;
(statearr_33492_33509[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33471);

return cljs.core.cst$kw$recur;
} else {
throw e33491;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__33510 = state_33471;
state_33471 = G__33510;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_33471){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_33471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___33498,out))
})();
var state__13218__auto__ = (function (){var statearr_33493 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_33493[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___33498);

return statearr_33493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___33498,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33520 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33520 = (function (map_LT_,f,ch,meta33521){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta33521 = meta33521;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33522,meta33521__$1){
var self__ = this;
var _33522__$1 = this;
return (new cljs.core.async.t_cljs$core$async33520(self__.map_LT_,self__.f,self__.ch,meta33521__$1));
});

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33522){
var self__ = this;
var _33522__$1 = this;
return self__.meta33521;
});

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async33523 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33523 = (function (map_LT_,f,ch,meta33521,_,fn1,meta33524){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta33521 = meta33521;
this._ = _;
this.fn1 = fn1;
this.meta33524 = meta33524;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33523.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33525,meta33524__$1){
var self__ = this;
var _33525__$1 = this;
return (new cljs.core.async.t_cljs$core$async33523(self__.map_LT_,self__.f,self__.ch,self__.meta33521,self__._,self__.fn1,meta33524__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async33523.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33525){
var self__ = this;
var _33525__$1 = this;
return self__.meta33524;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33523.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async33523.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33523.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33523.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__33511_SHARP_){
var G__33526 = (((p1__33511_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33511_SHARP_) : self__.f.call(null,p1__33511_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33526) : f1.call(null,G__33526));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async33523.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33521,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async33520], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta33524], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33523.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33523.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33523";

cljs.core.async.t_cljs$core$async33523.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33523");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async33523 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33523(map_LT___$1,f__$1,ch__$1,meta33521__$1,___$2,fn1__$1,meta33524){
return (new cljs.core.async.t_cljs$core$async33523(map_LT___$1,f__$1,ch__$1,meta33521__$1,___$2,fn1__$1,meta33524));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async33523(self__.map_LT_,self__.f,self__.ch,self__.meta33521,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6397__auto__ = ret;
if(cljs.core.truth_(and__6397__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6397__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33527 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33527) : self__.f.call(null,G__33527));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33520.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async33520.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33521], null);
});

cljs.core.async.t_cljs$core$async33520.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33520.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33520";

cljs.core.async.t_cljs$core$async33520.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33520");
});

cljs.core.async.__GT_t_cljs$core$async33520 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33520(map_LT___$1,f__$1,ch__$1,meta33521){
return (new cljs.core.async.t_cljs$core$async33520(map_LT___$1,f__$1,ch__$1,meta33521));
});

}

return (new cljs.core.async.t_cljs$core$async33520(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33531 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33531 = (function (map_GT_,f,ch,meta33532){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta33532 = meta33532;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33531.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33533,meta33532__$1){
var self__ = this;
var _33533__$1 = this;
return (new cljs.core.async.t_cljs$core$async33531(self__.map_GT_,self__.f,self__.ch,meta33532__$1));
});

cljs.core.async.t_cljs$core$async33531.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33533){
var self__ = this;
var _33533__$1 = this;
return self__.meta33532;
});

cljs.core.async.t_cljs$core$async33531.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33531.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33531.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33531.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33531.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33531.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async33531.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33532], null);
});

cljs.core.async.t_cljs$core$async33531.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33531.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33531";

cljs.core.async.t_cljs$core$async33531.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33531");
});

cljs.core.async.__GT_t_cljs$core$async33531 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33531(map_GT___$1,f__$1,ch__$1,meta33532){
return (new cljs.core.async.t_cljs$core$async33531(map_GT___$1,f__$1,ch__$1,meta33532));
});

}

return (new cljs.core.async.t_cljs$core$async33531(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async33537 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33537 = (function (filter_GT_,p,ch,meta33538){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta33538 = meta33538;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33537.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33539,meta33538__$1){
var self__ = this;
var _33539__$1 = this;
return (new cljs.core.async.t_cljs$core$async33537(self__.filter_GT_,self__.p,self__.ch,meta33538__$1));
});

cljs.core.async.t_cljs$core$async33537.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33539){
var self__ = this;
var _33539__$1 = this;
return self__.meta33538;
});

cljs.core.async.t_cljs$core$async33537.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async33537.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33537.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33537.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async33537.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33537.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async33537.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async33537.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33538], null);
});

cljs.core.async.t_cljs$core$async33537.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33537.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33537";

cljs.core.async.t_cljs$core$async33537.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"cljs.core.async/t_cljs$core$async33537");
});

cljs.core.async.__GT_t_cljs$core$async33537 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33537(filter_GT___$1,p__$1,ch__$1,meta33538){
return (new cljs.core.async.t_cljs$core$async33537(filter_GT___$1,p__$1,ch__$1,meta33538));
});

}

return (new cljs.core.async.t_cljs$core$async33537(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args33540 = [];
var len__7484__auto___33584 = arguments.length;
var i__7485__auto___33585 = (0);
while(true){
if((i__7485__auto___33585 < len__7484__auto___33584)){
args33540.push((arguments[i__7485__auto___33585]));

var G__33586 = (i__7485__auto___33585 + (1));
i__7485__auto___33585 = G__33586;
continue;
} else {
}
break;
}

var G__33542 = args33540.length;
switch (G__33542) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33540.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13216__auto___33588 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___33588,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___33588,out){
return (function (state_33563){
var state_val_33564 = (state_33563[(1)]);
if((state_val_33564 === (7))){
var inst_33559 = (state_33563[(2)]);
var state_33563__$1 = state_33563;
var statearr_33565_33589 = state_33563__$1;
(statearr_33565_33589[(2)] = inst_33559);

(statearr_33565_33589[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (1))){
var state_33563__$1 = state_33563;
var statearr_33566_33590 = state_33563__$1;
(statearr_33566_33590[(2)] = null);

(statearr_33566_33590[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (4))){
var inst_33545 = (state_33563[(7)]);
var inst_33545__$1 = (state_33563[(2)]);
var inst_33546 = (inst_33545__$1 == null);
var state_33563__$1 = (function (){var statearr_33567 = state_33563;
(statearr_33567[(7)] = inst_33545__$1);

return statearr_33567;
})();
if(cljs.core.truth_(inst_33546)){
var statearr_33568_33591 = state_33563__$1;
(statearr_33568_33591[(1)] = (5));

} else {
var statearr_33569_33592 = state_33563__$1;
(statearr_33569_33592[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (6))){
var inst_33545 = (state_33563[(7)]);
var inst_33550 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33545) : p.call(null,inst_33545));
var state_33563__$1 = state_33563;
if(cljs.core.truth_(inst_33550)){
var statearr_33570_33593 = state_33563__$1;
(statearr_33570_33593[(1)] = (8));

} else {
var statearr_33571_33594 = state_33563__$1;
(statearr_33571_33594[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (3))){
var inst_33561 = (state_33563[(2)]);
var state_33563__$1 = state_33563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33563__$1,inst_33561);
} else {
if((state_val_33564 === (2))){
var state_33563__$1 = state_33563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33563__$1,(4),ch);
} else {
if((state_val_33564 === (11))){
var inst_33553 = (state_33563[(2)]);
var state_33563__$1 = state_33563;
var statearr_33572_33595 = state_33563__$1;
(statearr_33572_33595[(2)] = inst_33553);

(statearr_33572_33595[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (9))){
var state_33563__$1 = state_33563;
var statearr_33573_33596 = state_33563__$1;
(statearr_33573_33596[(2)] = null);

(statearr_33573_33596[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (5))){
var inst_33548 = cljs.core.async.close_BANG_(out);
var state_33563__$1 = state_33563;
var statearr_33574_33597 = state_33563__$1;
(statearr_33574_33597[(2)] = inst_33548);

(statearr_33574_33597[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (10))){
var inst_33556 = (state_33563[(2)]);
var state_33563__$1 = (function (){var statearr_33575 = state_33563;
(statearr_33575[(8)] = inst_33556);

return statearr_33575;
})();
var statearr_33576_33598 = state_33563__$1;
(statearr_33576_33598[(2)] = null);

(statearr_33576_33598[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33564 === (8))){
var inst_33545 = (state_33563[(7)]);
var state_33563__$1 = state_33563;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33563__$1,(11),out,inst_33545);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___33588,out))
;
return ((function (switch__13104__auto__,c__13216__auto___33588,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_33580 = [null,null,null,null,null,null,null,null,null];
(statearr_33580[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_33580[(1)] = (1));

return statearr_33580;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_33563){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_33563);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e33581){if((e33581 instanceof Object)){
var ex__13108__auto__ = e33581;
var statearr_33582_33599 = state_33563;
(statearr_33582_33599[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33563);

return cljs.core.cst$kw$recur;
} else {
throw e33581;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__33600 = state_33563;
state_33563 = G__33600;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_33563){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_33563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___33588,out))
})();
var state__13218__auto__ = (function (){var statearr_33583 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_33583[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___33588);

return statearr_33583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___33588,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args33601 = [];
var len__7484__auto___33604 = arguments.length;
var i__7485__auto___33605 = (0);
while(true){
if((i__7485__auto___33605 < len__7484__auto___33604)){
args33601.push((arguments[i__7485__auto___33605]));

var G__33606 = (i__7485__auto___33605 + (1));
i__7485__auto___33605 = G__33606;
continue;
} else {
}
break;
}

var G__33603 = args33601.length;
switch (G__33603) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33601.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__){
return (function (state_33773){
var state_val_33774 = (state_33773[(1)]);
if((state_val_33774 === (7))){
var inst_33769 = (state_33773[(2)]);
var state_33773__$1 = state_33773;
var statearr_33775_33816 = state_33773__$1;
(statearr_33775_33816[(2)] = inst_33769);

(statearr_33775_33816[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (20))){
var inst_33739 = (state_33773[(7)]);
var inst_33750 = (state_33773[(2)]);
var inst_33751 = cljs.core.next(inst_33739);
var inst_33725 = inst_33751;
var inst_33726 = null;
var inst_33727 = (0);
var inst_33728 = (0);
var state_33773__$1 = (function (){var statearr_33776 = state_33773;
(statearr_33776[(8)] = inst_33725);

(statearr_33776[(9)] = inst_33727);

(statearr_33776[(10)] = inst_33750);

(statearr_33776[(11)] = inst_33726);

(statearr_33776[(12)] = inst_33728);

return statearr_33776;
})();
var statearr_33777_33817 = state_33773__$1;
(statearr_33777_33817[(2)] = null);

(statearr_33777_33817[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (1))){
var state_33773__$1 = state_33773;
var statearr_33778_33818 = state_33773__$1;
(statearr_33778_33818[(2)] = null);

(statearr_33778_33818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (4))){
var inst_33714 = (state_33773[(13)]);
var inst_33714__$1 = (state_33773[(2)]);
var inst_33715 = (inst_33714__$1 == null);
var state_33773__$1 = (function (){var statearr_33779 = state_33773;
(statearr_33779[(13)] = inst_33714__$1);

return statearr_33779;
})();
if(cljs.core.truth_(inst_33715)){
var statearr_33780_33819 = state_33773__$1;
(statearr_33780_33819[(1)] = (5));

} else {
var statearr_33781_33820 = state_33773__$1;
(statearr_33781_33820[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (15))){
var state_33773__$1 = state_33773;
var statearr_33785_33821 = state_33773__$1;
(statearr_33785_33821[(2)] = null);

(statearr_33785_33821[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (21))){
var state_33773__$1 = state_33773;
var statearr_33786_33822 = state_33773__$1;
(statearr_33786_33822[(2)] = null);

(statearr_33786_33822[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (13))){
var inst_33725 = (state_33773[(8)]);
var inst_33727 = (state_33773[(9)]);
var inst_33726 = (state_33773[(11)]);
var inst_33728 = (state_33773[(12)]);
var inst_33735 = (state_33773[(2)]);
var inst_33736 = (inst_33728 + (1));
var tmp33782 = inst_33725;
var tmp33783 = inst_33727;
var tmp33784 = inst_33726;
var inst_33725__$1 = tmp33782;
var inst_33726__$1 = tmp33784;
var inst_33727__$1 = tmp33783;
var inst_33728__$1 = inst_33736;
var state_33773__$1 = (function (){var statearr_33787 = state_33773;
(statearr_33787[(8)] = inst_33725__$1);

(statearr_33787[(9)] = inst_33727__$1);

(statearr_33787[(11)] = inst_33726__$1);

(statearr_33787[(12)] = inst_33728__$1);

(statearr_33787[(14)] = inst_33735);

return statearr_33787;
})();
var statearr_33788_33823 = state_33773__$1;
(statearr_33788_33823[(2)] = null);

(statearr_33788_33823[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (22))){
var state_33773__$1 = state_33773;
var statearr_33789_33824 = state_33773__$1;
(statearr_33789_33824[(2)] = null);

(statearr_33789_33824[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (6))){
var inst_33714 = (state_33773[(13)]);
var inst_33723 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33714) : f.call(null,inst_33714));
var inst_33724 = cljs.core.seq(inst_33723);
var inst_33725 = inst_33724;
var inst_33726 = null;
var inst_33727 = (0);
var inst_33728 = (0);
var state_33773__$1 = (function (){var statearr_33790 = state_33773;
(statearr_33790[(8)] = inst_33725);

(statearr_33790[(9)] = inst_33727);

(statearr_33790[(11)] = inst_33726);

(statearr_33790[(12)] = inst_33728);

return statearr_33790;
})();
var statearr_33791_33825 = state_33773__$1;
(statearr_33791_33825[(2)] = null);

(statearr_33791_33825[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (17))){
var inst_33739 = (state_33773[(7)]);
var inst_33743 = cljs.core.chunk_first(inst_33739);
var inst_33744 = cljs.core.chunk_rest(inst_33739);
var inst_33745 = cljs.core.count(inst_33743);
var inst_33725 = inst_33744;
var inst_33726 = inst_33743;
var inst_33727 = inst_33745;
var inst_33728 = (0);
var state_33773__$1 = (function (){var statearr_33792 = state_33773;
(statearr_33792[(8)] = inst_33725);

(statearr_33792[(9)] = inst_33727);

(statearr_33792[(11)] = inst_33726);

(statearr_33792[(12)] = inst_33728);

return statearr_33792;
})();
var statearr_33793_33826 = state_33773__$1;
(statearr_33793_33826[(2)] = null);

(statearr_33793_33826[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (3))){
var inst_33771 = (state_33773[(2)]);
var state_33773__$1 = state_33773;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33773__$1,inst_33771);
} else {
if((state_val_33774 === (12))){
var inst_33759 = (state_33773[(2)]);
var state_33773__$1 = state_33773;
var statearr_33794_33827 = state_33773__$1;
(statearr_33794_33827[(2)] = inst_33759);

(statearr_33794_33827[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (2))){
var state_33773__$1 = state_33773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33773__$1,(4),in$);
} else {
if((state_val_33774 === (23))){
var inst_33767 = (state_33773[(2)]);
var state_33773__$1 = state_33773;
var statearr_33795_33828 = state_33773__$1;
(statearr_33795_33828[(2)] = inst_33767);

(statearr_33795_33828[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (19))){
var inst_33754 = (state_33773[(2)]);
var state_33773__$1 = state_33773;
var statearr_33796_33829 = state_33773__$1;
(statearr_33796_33829[(2)] = inst_33754);

(statearr_33796_33829[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (11))){
var inst_33725 = (state_33773[(8)]);
var inst_33739 = (state_33773[(7)]);
var inst_33739__$1 = cljs.core.seq(inst_33725);
var state_33773__$1 = (function (){var statearr_33797 = state_33773;
(statearr_33797[(7)] = inst_33739__$1);

return statearr_33797;
})();
if(inst_33739__$1){
var statearr_33798_33830 = state_33773__$1;
(statearr_33798_33830[(1)] = (14));

} else {
var statearr_33799_33831 = state_33773__$1;
(statearr_33799_33831[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (9))){
var inst_33761 = (state_33773[(2)]);
var inst_33762 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33773__$1 = (function (){var statearr_33800 = state_33773;
(statearr_33800[(15)] = inst_33761);

return statearr_33800;
})();
if(cljs.core.truth_(inst_33762)){
var statearr_33801_33832 = state_33773__$1;
(statearr_33801_33832[(1)] = (21));

} else {
var statearr_33802_33833 = state_33773__$1;
(statearr_33802_33833[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (5))){
var inst_33717 = cljs.core.async.close_BANG_(out);
var state_33773__$1 = state_33773;
var statearr_33803_33834 = state_33773__$1;
(statearr_33803_33834[(2)] = inst_33717);

(statearr_33803_33834[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (14))){
var inst_33739 = (state_33773[(7)]);
var inst_33741 = cljs.core.chunked_seq_QMARK_(inst_33739);
var state_33773__$1 = state_33773;
if(inst_33741){
var statearr_33804_33835 = state_33773__$1;
(statearr_33804_33835[(1)] = (17));

} else {
var statearr_33805_33836 = state_33773__$1;
(statearr_33805_33836[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (16))){
var inst_33757 = (state_33773[(2)]);
var state_33773__$1 = state_33773;
var statearr_33806_33837 = state_33773__$1;
(statearr_33806_33837[(2)] = inst_33757);

(statearr_33806_33837[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33774 === (10))){
var inst_33726 = (state_33773[(11)]);
var inst_33728 = (state_33773[(12)]);
var inst_33733 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33726,inst_33728);
var state_33773__$1 = state_33773;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33773__$1,(13),out,inst_33733);
} else {
if((state_val_33774 === (18))){
var inst_33739 = (state_33773[(7)]);
var inst_33748 = cljs.core.first(inst_33739);
var state_33773__$1 = state_33773;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33773__$1,(20),out,inst_33748);
} else {
if((state_val_33774 === (8))){
var inst_33727 = (state_33773[(9)]);
var inst_33728 = (state_33773[(12)]);
var inst_33730 = (inst_33728 < inst_33727);
var inst_33731 = inst_33730;
var state_33773__$1 = state_33773;
if(cljs.core.truth_(inst_33731)){
var statearr_33807_33838 = state_33773__$1;
(statearr_33807_33838[(1)] = (10));

} else {
var statearr_33808_33839 = state_33773__$1;
(statearr_33808_33839[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__))
;
return ((function (switch__13104__auto__,c__13216__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____0 = (function (){
var statearr_33812 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33812[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__);

(statearr_33812[(1)] = (1));

return statearr_33812;
});
var cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____1 = (function (state_33773){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_33773);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e33813){if((e33813 instanceof Object)){
var ex__13108__auto__ = e33813;
var statearr_33814_33840 = state_33773;
(statearr_33814_33840[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33773);

return cljs.core.cst$kw$recur;
} else {
throw e33813;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__33841 = state_33773;
state_33773 = G__33841;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__ = function(state_33773){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____1.call(this,state_33773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__13105__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__))
})();
var state__13218__auto__ = (function (){var statearr_33815 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_33815[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_33815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__))
);

return c__13216__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args33842 = [];
var len__7484__auto___33845 = arguments.length;
var i__7485__auto___33846 = (0);
while(true){
if((i__7485__auto___33846 < len__7484__auto___33845)){
args33842.push((arguments[i__7485__auto___33846]));

var G__33847 = (i__7485__auto___33846 + (1));
i__7485__auto___33846 = G__33847;
continue;
} else {
}
break;
}

var G__33844 = args33842.length;
switch (G__33844) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33842.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args33849 = [];
var len__7484__auto___33852 = arguments.length;
var i__7485__auto___33853 = (0);
while(true){
if((i__7485__auto___33853 < len__7484__auto___33852)){
args33849.push((arguments[i__7485__auto___33853]));

var G__33854 = (i__7485__auto___33853 + (1));
i__7485__auto___33853 = G__33854;
continue;
} else {
}
break;
}

var G__33851 = args33849.length;
switch (G__33851) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33849.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args33856 = [];
var len__7484__auto___33907 = arguments.length;
var i__7485__auto___33908 = (0);
while(true){
if((i__7485__auto___33908 < len__7484__auto___33907)){
args33856.push((arguments[i__7485__auto___33908]));

var G__33909 = (i__7485__auto___33908 + (1));
i__7485__auto___33908 = G__33909;
continue;
} else {
}
break;
}

var G__33858 = args33856.length;
switch (G__33858) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33856.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13216__auto___33911 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___33911,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___33911,out){
return (function (state_33882){
var state_val_33883 = (state_33882[(1)]);
if((state_val_33883 === (7))){
var inst_33877 = (state_33882[(2)]);
var state_33882__$1 = state_33882;
var statearr_33884_33912 = state_33882__$1;
(statearr_33884_33912[(2)] = inst_33877);

(statearr_33884_33912[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33883 === (1))){
var inst_33859 = null;
var state_33882__$1 = (function (){var statearr_33885 = state_33882;
(statearr_33885[(7)] = inst_33859);

return statearr_33885;
})();
var statearr_33886_33913 = state_33882__$1;
(statearr_33886_33913[(2)] = null);

(statearr_33886_33913[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33883 === (4))){
var inst_33862 = (state_33882[(8)]);
var inst_33862__$1 = (state_33882[(2)]);
var inst_33863 = (inst_33862__$1 == null);
var inst_33864 = cljs.core.not(inst_33863);
var state_33882__$1 = (function (){var statearr_33887 = state_33882;
(statearr_33887[(8)] = inst_33862__$1);

return statearr_33887;
})();
if(inst_33864){
var statearr_33888_33914 = state_33882__$1;
(statearr_33888_33914[(1)] = (5));

} else {
var statearr_33889_33915 = state_33882__$1;
(statearr_33889_33915[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33883 === (6))){
var state_33882__$1 = state_33882;
var statearr_33890_33916 = state_33882__$1;
(statearr_33890_33916[(2)] = null);

(statearr_33890_33916[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33883 === (3))){
var inst_33879 = (state_33882[(2)]);
var inst_33880 = cljs.core.async.close_BANG_(out);
var state_33882__$1 = (function (){var statearr_33891 = state_33882;
(statearr_33891[(9)] = inst_33879);

return statearr_33891;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33882__$1,inst_33880);
} else {
if((state_val_33883 === (2))){
var state_33882__$1 = state_33882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33882__$1,(4),ch);
} else {
if((state_val_33883 === (11))){
var inst_33862 = (state_33882[(8)]);
var inst_33871 = (state_33882[(2)]);
var inst_33859 = inst_33862;
var state_33882__$1 = (function (){var statearr_33892 = state_33882;
(statearr_33892[(7)] = inst_33859);

(statearr_33892[(10)] = inst_33871);

return statearr_33892;
})();
var statearr_33893_33917 = state_33882__$1;
(statearr_33893_33917[(2)] = null);

(statearr_33893_33917[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33883 === (9))){
var inst_33862 = (state_33882[(8)]);
var state_33882__$1 = state_33882;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33882__$1,(11),out,inst_33862);
} else {
if((state_val_33883 === (5))){
var inst_33859 = (state_33882[(7)]);
var inst_33862 = (state_33882[(8)]);
var inst_33866 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33862,inst_33859);
var state_33882__$1 = state_33882;
if(inst_33866){
var statearr_33895_33918 = state_33882__$1;
(statearr_33895_33918[(1)] = (8));

} else {
var statearr_33896_33919 = state_33882__$1;
(statearr_33896_33919[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33883 === (10))){
var inst_33874 = (state_33882[(2)]);
var state_33882__$1 = state_33882;
var statearr_33897_33920 = state_33882__$1;
(statearr_33897_33920[(2)] = inst_33874);

(statearr_33897_33920[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33883 === (8))){
var inst_33859 = (state_33882[(7)]);
var tmp33894 = inst_33859;
var inst_33859__$1 = tmp33894;
var state_33882__$1 = (function (){var statearr_33898 = state_33882;
(statearr_33898[(7)] = inst_33859__$1);

return statearr_33898;
})();
var statearr_33899_33921 = state_33882__$1;
(statearr_33899_33921[(2)] = null);

(statearr_33899_33921[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___33911,out))
;
return ((function (switch__13104__auto__,c__13216__auto___33911,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_33903 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33903[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_33903[(1)] = (1));

return statearr_33903;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_33882){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_33882);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e33904){if((e33904 instanceof Object)){
var ex__13108__auto__ = e33904;
var statearr_33905_33922 = state_33882;
(statearr_33905_33922[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33882);

return cljs.core.cst$kw$recur;
} else {
throw e33904;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__33923 = state_33882;
state_33882 = G__33923;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_33882){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_33882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___33911,out))
})();
var state__13218__auto__ = (function (){var statearr_33906 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_33906[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___33911);

return statearr_33906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___33911,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args33924 = [];
var len__7484__auto___33994 = arguments.length;
var i__7485__auto___33995 = (0);
while(true){
if((i__7485__auto___33995 < len__7484__auto___33994)){
args33924.push((arguments[i__7485__auto___33995]));

var G__33996 = (i__7485__auto___33995 + (1));
i__7485__auto___33995 = G__33996;
continue;
} else {
}
break;
}

var G__33926 = args33924.length;
switch (G__33926) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33924.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13216__auto___33998 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___33998,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___33998,out){
return (function (state_33964){
var state_val_33965 = (state_33964[(1)]);
if((state_val_33965 === (7))){
var inst_33960 = (state_33964[(2)]);
var state_33964__$1 = state_33964;
var statearr_33966_33999 = state_33964__$1;
(statearr_33966_33999[(2)] = inst_33960);

(statearr_33966_33999[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33965 === (1))){
var inst_33927 = (new Array(n));
var inst_33928 = inst_33927;
var inst_33929 = (0);
var state_33964__$1 = (function (){var statearr_33967 = state_33964;
(statearr_33967[(7)] = inst_33929);

(statearr_33967[(8)] = inst_33928);

return statearr_33967;
})();
var statearr_33968_34000 = state_33964__$1;
(statearr_33968_34000[(2)] = null);

(statearr_33968_34000[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33965 === (4))){
var inst_33932 = (state_33964[(9)]);
var inst_33932__$1 = (state_33964[(2)]);
var inst_33933 = (inst_33932__$1 == null);
var inst_33934 = cljs.core.not(inst_33933);
var state_33964__$1 = (function (){var statearr_33969 = state_33964;
(statearr_33969[(9)] = inst_33932__$1);

return statearr_33969;
})();
if(inst_33934){
var statearr_33970_34001 = state_33964__$1;
(statearr_33970_34001[(1)] = (5));

} else {
var statearr_33971_34002 = state_33964__$1;
(statearr_33971_34002[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33965 === (15))){
var inst_33954 = (state_33964[(2)]);
var state_33964__$1 = state_33964;
var statearr_33972_34003 = state_33964__$1;
(statearr_33972_34003[(2)] = inst_33954);

(statearr_33972_34003[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33965 === (13))){
var state_33964__$1 = state_33964;
var statearr_33973_34004 = state_33964__$1;
(statearr_33973_34004[(2)] = null);

(statearr_33973_34004[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33965 === (6))){
var inst_33929 = (state_33964[(7)]);
var inst_33950 = (inst_33929 > (0));
var state_33964__$1 = state_33964;
if(cljs.core.truth_(inst_33950)){
var statearr_33974_34005 = state_33964__$1;
(statearr_33974_34005[(1)] = (12));

} else {
var statearr_33975_34006 = state_33964__$1;
(statearr_33975_34006[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33965 === (3))){
var inst_33962 = (state_33964[(2)]);
var state_33964__$1 = state_33964;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33964__$1,inst_33962);
} else {
if((state_val_33965 === (12))){
var inst_33928 = (state_33964[(8)]);
var inst_33952 = cljs.core.vec(inst_33928);
var state_33964__$1 = state_33964;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33964__$1,(15),out,inst_33952);
} else {
if((state_val_33965 === (2))){
var state_33964__$1 = state_33964;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33964__$1,(4),ch);
} else {
if((state_val_33965 === (11))){
var inst_33944 = (state_33964[(2)]);
var inst_33945 = (new Array(n));
var inst_33928 = inst_33945;
var inst_33929 = (0);
var state_33964__$1 = (function (){var statearr_33976 = state_33964;
(statearr_33976[(7)] = inst_33929);

(statearr_33976[(10)] = inst_33944);

(statearr_33976[(8)] = inst_33928);

return statearr_33976;
})();
var statearr_33977_34007 = state_33964__$1;
(statearr_33977_34007[(2)] = null);

(statearr_33977_34007[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33965 === (9))){
var inst_33928 = (state_33964[(8)]);
var inst_33942 = cljs.core.vec(inst_33928);
var state_33964__$1 = state_33964;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33964__$1,(11),out,inst_33942);
} else {
if((state_val_33965 === (5))){
var inst_33929 = (state_33964[(7)]);
var inst_33932 = (state_33964[(9)]);
var inst_33937 = (state_33964[(11)]);
var inst_33928 = (state_33964[(8)]);
var inst_33936 = (inst_33928[inst_33929] = inst_33932);
var inst_33937__$1 = (inst_33929 + (1));
var inst_33938 = (inst_33937__$1 < n);
var state_33964__$1 = (function (){var statearr_33978 = state_33964;
(statearr_33978[(11)] = inst_33937__$1);

(statearr_33978[(12)] = inst_33936);

return statearr_33978;
})();
if(cljs.core.truth_(inst_33938)){
var statearr_33979_34008 = state_33964__$1;
(statearr_33979_34008[(1)] = (8));

} else {
var statearr_33980_34009 = state_33964__$1;
(statearr_33980_34009[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33965 === (14))){
var inst_33957 = (state_33964[(2)]);
var inst_33958 = cljs.core.async.close_BANG_(out);
var state_33964__$1 = (function (){var statearr_33982 = state_33964;
(statearr_33982[(13)] = inst_33957);

return statearr_33982;
})();
var statearr_33983_34010 = state_33964__$1;
(statearr_33983_34010[(2)] = inst_33958);

(statearr_33983_34010[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33965 === (10))){
var inst_33948 = (state_33964[(2)]);
var state_33964__$1 = state_33964;
var statearr_33984_34011 = state_33964__$1;
(statearr_33984_34011[(2)] = inst_33948);

(statearr_33984_34011[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33965 === (8))){
var inst_33937 = (state_33964[(11)]);
var inst_33928 = (state_33964[(8)]);
var tmp33981 = inst_33928;
var inst_33928__$1 = tmp33981;
var inst_33929 = inst_33937;
var state_33964__$1 = (function (){var statearr_33985 = state_33964;
(statearr_33985[(7)] = inst_33929);

(statearr_33985[(8)] = inst_33928__$1);

return statearr_33985;
})();
var statearr_33986_34012 = state_33964__$1;
(statearr_33986_34012[(2)] = null);

(statearr_33986_34012[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___33998,out))
;
return ((function (switch__13104__auto__,c__13216__auto___33998,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_33990 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33990[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_33990[(1)] = (1));

return statearr_33990;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_33964){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_33964);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e33991){if((e33991 instanceof Object)){
var ex__13108__auto__ = e33991;
var statearr_33992_34013 = state_33964;
(statearr_33992_34013[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33964);

return cljs.core.cst$kw$recur;
} else {
throw e33991;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__34014 = state_33964;
state_33964 = G__34014;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_33964){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_33964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___33998,out))
})();
var state__13218__auto__ = (function (){var statearr_33993 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_33993[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___33998);

return statearr_33993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___33998,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args34015 = [];
var len__7484__auto___34089 = arguments.length;
var i__7485__auto___34090 = (0);
while(true){
if((i__7485__auto___34090 < len__7484__auto___34089)){
args34015.push((arguments[i__7485__auto___34090]));

var G__34091 = (i__7485__auto___34090 + (1));
i__7485__auto___34090 = G__34091;
continue;
} else {
}
break;
}

var G__34017 = args34015.length;
switch (G__34017) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34015.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13216__auto___34093 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto___34093,out){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto___34093,out){
return (function (state_34059){
var state_val_34060 = (state_34059[(1)]);
if((state_val_34060 === (7))){
var inst_34055 = (state_34059[(2)]);
var state_34059__$1 = state_34059;
var statearr_34061_34094 = state_34059__$1;
(statearr_34061_34094[(2)] = inst_34055);

(statearr_34061_34094[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34060 === (1))){
var inst_34018 = [];
var inst_34019 = inst_34018;
var inst_34020 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_34059__$1 = (function (){var statearr_34062 = state_34059;
(statearr_34062[(7)] = inst_34020);

(statearr_34062[(8)] = inst_34019);

return statearr_34062;
})();
var statearr_34063_34095 = state_34059__$1;
(statearr_34063_34095[(2)] = null);

(statearr_34063_34095[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34060 === (4))){
var inst_34023 = (state_34059[(9)]);
var inst_34023__$1 = (state_34059[(2)]);
var inst_34024 = (inst_34023__$1 == null);
var inst_34025 = cljs.core.not(inst_34024);
var state_34059__$1 = (function (){var statearr_34064 = state_34059;
(statearr_34064[(9)] = inst_34023__$1);

return statearr_34064;
})();
if(inst_34025){
var statearr_34065_34096 = state_34059__$1;
(statearr_34065_34096[(1)] = (5));

} else {
var statearr_34066_34097 = state_34059__$1;
(statearr_34066_34097[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34060 === (15))){
var inst_34049 = (state_34059[(2)]);
var state_34059__$1 = state_34059;
var statearr_34067_34098 = state_34059__$1;
(statearr_34067_34098[(2)] = inst_34049);

(statearr_34067_34098[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34060 === (13))){
var state_34059__$1 = state_34059;
var statearr_34068_34099 = state_34059__$1;
(statearr_34068_34099[(2)] = null);

(statearr_34068_34099[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34060 === (6))){
var inst_34019 = (state_34059[(8)]);
var inst_34044 = inst_34019.length;
var inst_34045 = (inst_34044 > (0));
var state_34059__$1 = state_34059;
if(cljs.core.truth_(inst_34045)){
var statearr_34069_34100 = state_34059__$1;
(statearr_34069_34100[(1)] = (12));

} else {
var statearr_34070_34101 = state_34059__$1;
(statearr_34070_34101[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34060 === (3))){
var inst_34057 = (state_34059[(2)]);
var state_34059__$1 = state_34059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34059__$1,inst_34057);
} else {
if((state_val_34060 === (12))){
var inst_34019 = (state_34059[(8)]);
var inst_34047 = cljs.core.vec(inst_34019);
var state_34059__$1 = state_34059;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34059__$1,(15),out,inst_34047);
} else {
if((state_val_34060 === (2))){
var state_34059__$1 = state_34059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34059__$1,(4),ch);
} else {
if((state_val_34060 === (11))){
var inst_34027 = (state_34059[(10)]);
var inst_34023 = (state_34059[(9)]);
var inst_34037 = (state_34059[(2)]);
var inst_34038 = [];
var inst_34039 = inst_34038.push(inst_34023);
var inst_34019 = inst_34038;
var inst_34020 = inst_34027;
var state_34059__$1 = (function (){var statearr_34071 = state_34059;
(statearr_34071[(7)] = inst_34020);

(statearr_34071[(11)] = inst_34039);

(statearr_34071[(12)] = inst_34037);

(statearr_34071[(8)] = inst_34019);

return statearr_34071;
})();
var statearr_34072_34102 = state_34059__$1;
(statearr_34072_34102[(2)] = null);

(statearr_34072_34102[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34060 === (9))){
var inst_34019 = (state_34059[(8)]);
var inst_34035 = cljs.core.vec(inst_34019);
var state_34059__$1 = state_34059;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34059__$1,(11),out,inst_34035);
} else {
if((state_val_34060 === (5))){
var inst_34020 = (state_34059[(7)]);
var inst_34027 = (state_34059[(10)]);
var inst_34023 = (state_34059[(9)]);
var inst_34027__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34023) : f.call(null,inst_34023));
var inst_34028 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34027__$1,inst_34020);
var inst_34029 = cljs.core.keyword_identical_QMARK_(inst_34020,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_34030 = (inst_34028) || (inst_34029);
var state_34059__$1 = (function (){var statearr_34073 = state_34059;
(statearr_34073[(10)] = inst_34027__$1);

return statearr_34073;
})();
if(cljs.core.truth_(inst_34030)){
var statearr_34074_34103 = state_34059__$1;
(statearr_34074_34103[(1)] = (8));

} else {
var statearr_34075_34104 = state_34059__$1;
(statearr_34075_34104[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34060 === (14))){
var inst_34052 = (state_34059[(2)]);
var inst_34053 = cljs.core.async.close_BANG_(out);
var state_34059__$1 = (function (){var statearr_34077 = state_34059;
(statearr_34077[(13)] = inst_34052);

return statearr_34077;
})();
var statearr_34078_34105 = state_34059__$1;
(statearr_34078_34105[(2)] = inst_34053);

(statearr_34078_34105[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34060 === (10))){
var inst_34042 = (state_34059[(2)]);
var state_34059__$1 = state_34059;
var statearr_34079_34106 = state_34059__$1;
(statearr_34079_34106[(2)] = inst_34042);

(statearr_34079_34106[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34060 === (8))){
var inst_34027 = (state_34059[(10)]);
var inst_34019 = (state_34059[(8)]);
var inst_34023 = (state_34059[(9)]);
var inst_34032 = inst_34019.push(inst_34023);
var tmp34076 = inst_34019;
var inst_34019__$1 = tmp34076;
var inst_34020 = inst_34027;
var state_34059__$1 = (function (){var statearr_34080 = state_34059;
(statearr_34080[(7)] = inst_34020);

(statearr_34080[(14)] = inst_34032);

(statearr_34080[(8)] = inst_34019__$1);

return statearr_34080;
})();
var statearr_34081_34107 = state_34059__$1;
(statearr_34081_34107[(2)] = null);

(statearr_34081_34107[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto___34093,out))
;
return ((function (switch__13104__auto__,c__13216__auto___34093,out){
return (function() {
var cljs$core$async$state_machine__13105__auto__ = null;
var cljs$core$async$state_machine__13105__auto____0 = (function (){
var statearr_34085 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34085[(0)] = cljs$core$async$state_machine__13105__auto__);

(statearr_34085[(1)] = (1));

return statearr_34085;
});
var cljs$core$async$state_machine__13105__auto____1 = (function (state_34059){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_34059);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e34086){if((e34086 instanceof Object)){
var ex__13108__auto__ = e34086;
var statearr_34087_34108 = state_34059;
(statearr_34087_34108[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34059);

return cljs.core.cst$kw$recur;
} else {
throw e34086;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__34109 = state_34059;
state_34059 = G__34109;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
cljs$core$async$state_machine__13105__auto__ = function(state_34059){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13105__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13105__auto____1.call(this,state_34059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13105__auto____0;
cljs$core$async$state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13105__auto____1;
return cljs$core$async$state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto___34093,out))
})();
var state__13218__auto__ = (function (){var statearr_34088 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_34088[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto___34093);

return statearr_34088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto___34093,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

