// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.forms');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.urls');
goog.require('chimera.date');
goog.require('cljs.pprint');
goog.require('clojure.string');
goog.require('hatti.constants');
hatti.ona.forms.currency_regex = /£|$/;
hatti.ona.forms.newline_regex = /[\n\r]/;
hatti.ona.forms.no_answer = "No Answer";
hatti.ona.forms.submission_time_field = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._submission_time,new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._submission_time,new cljs.core.Keyword(null,"label","label",1718410804),"Submission Time",new cljs.core.Keyword(null,"type","type",1174270348),"dateTime"], null);
hatti.ona.forms.id_field = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._id,new cljs.core.Keyword(null,"label","label",1718410804),"ID",new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._id,new cljs.core.Keyword(null,"type","type",1174270348),"integer"], null);
hatti.ona.forms.submitted_by_field = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._submitted_by,new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._submitted_by,new cljs.core.Keyword(null,"label","label",1718410804),"Submitted by",new cljs.core.Keyword(null,"type","type",1174270348),"text"], null);
hatti.ona.forms.last_edited = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._last_edited,new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._last_edited,new cljs.core.Keyword(null,"label","label",1718410804),"Last Edited",new cljs.core.Keyword(null,"type","type",1174270348),"date"], null);
hatti.ona.forms.media_received_field = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),hatti.constants._media_all_received,new cljs.core.Keyword(null,"full-name","full-name",408178550),hatti.constants._media_all_received,new cljs.core.Keyword(null,"label","label",1718410804),"Media attachments received",new cljs.core.Keyword(null,"type","type",1174270348),"text"], null);
hatti.ona.forms.extra_submission_details = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.ona.forms.last_edited,hatti.ona.forms.submission_time_field,hatti.ona.forms.submitted_by_field,hatti.ona.forms.media_received_field], null);
/**
 * Format multiline answer by introducing html line breaks
 */
hatti.ona.forms.format_multiline_answer = (function hatti$ona$forms$format_multiline_answer(answer){
if(cljs.core.truth_((function (){var and__6397__auto__ = typeof answer === 'string';
if(and__6397__auto__){
return cljs.core.re_find.call(null,hatti.ona.forms.newline_regex,answer);
} else {
return and__6397__auto__;
}
})())){
return cljs.core.map.call(null,(function (p1__17804_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p","p",151049309),p1__17804_SHARP_],null));
}),clojure.string.split.call(null,answer,hatti.ona.forms.newline_regex));
} else {
return answer;
}
});
/**
 * Helper function: is the :type of a field among a set of types
 */
hatti.ona.forms.field_type_in_set_QMARK_ = (function hatti$ona$forms$field_type_in_set_QMARK_(types,field){
return cljs.core.contains_QMARK_.call(null,types,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Helper function: is the :name of a field among a set of names
 */
hatti.ona.forms.field_name_in_set_QMARK_ = (function hatti$ona$forms$field_name_in_set_QMARK_(names,field){
return cljs.core.contains_QMARK_.call(null,names,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(field));
});
/**
 * Checks whether a field in a form (ie, a field) is a group field
 */
hatti.ona.forms.group_QMARK_ = (function hatti$ona$forms$group_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["group",null], null), null),field);
});
/**
 * Checks whether a field in a form (ie, a field) is a repeat field
 */
hatti.ona.forms.repeat_QMARK_ = (function hatti$ona$forms$repeat_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["repeat",null], null), null),field);
});
/**
 * Checks whether a field is a numeric field
 */
hatti.ona.forms.numeric_QMARK_ = (function hatti$ona$forms$numeric_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["integer",null,"decimal",null], null), null),field);
});
/**
 * Checks whether a field is a date or a time field
 */
hatti.ona.forms.time_based_QMARK_ = (function hatti$ona$forms$time_based_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["today",null,"dateTime",null,"start",null,"time",null,"date",null,"end",null], null), null),field);
});
/**
 * Checks whether a field is a category field (select one or multiple)
 */
hatti.ona.forms.categorical_QMARK_ = (function hatti$ona$forms$categorical_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["select all that apply",null,"select one",null], null), null),field);
});
/**
 * Checks whether a field is a select one field
 */
hatti.ona.forms.select_one_QMARK_ = (function hatti$ona$forms$select_one_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select one",null], null), null),field);
});
/**
 * Checks whether a field is a select multiple (select all that apply) field
 */
hatti.ona.forms.select_all_QMARK_ = (function hatti$ona$forms$select_all_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["select all that apply",null], null), null),field);
});
/**
 * Checks whether a field is a text / string field.
 */
hatti.ona.forms.text_QMARK_ = (function hatti$ona$forms$text_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["string",null,"text",null], null), null),field);
});
/**
 * Checks whether a field in a form (a field) is a group field
 */
hatti.ona.forms.note_QMARK_ = (function hatti$ona$forms$note_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["note",null], null), null),field);
});
hatti.ona.forms.meta_QMARK_ = (function hatti$ona$forms$meta_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_name_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, ["instanceID",null,"_media_all_received",null,"_duration",null,"meta",null,"__version__",null,"_submitted_by",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, ["subscriberid",null,"phonenumber",null,"instanceID",null,"today",null,"deviceid",null,"_media_all_received",null,"uuid",null,"start",null,"imei",null,"simserial",null,"end",null], null), null),field);
}
});
hatti.ona.forms.geofield_QMARK_ = (function hatti$ona$forms$geofield_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["geoshape",null,"geotrace",null,"geopoint",null,"osm",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
var map__17807 = field;
var map__17807__$1 = ((((!((map__17807 == null)))?((((map__17807.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17807.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17807):map__17807);
var children = cljs.core.get.call(null,map__17807__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.some.call(null,hatti$ona$forms$geofield_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geopoint_QMARK_ = (function hatti$ona$forms$geopoint_QMARK_(field){
var or__6409__auto__ = hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["geopoint",null,"gps",null], null), null),field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
var map__17811 = field;
var map__17811__$1 = ((((!((map__17811 == null)))?((((map__17811.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17811.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17811):map__17811);
var children = cljs.core.get.call(null,map__17811__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.some.call(null,hatti$ona$forms$geopoint_QMARK_,children);
} else {
return null;
}
}
});
hatti.ona.forms.geoshape_QMARK_ = (function hatti$ona$forms$geoshape_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geoshape",null], null), null),field);
});
hatti.ona.forms.geotrace_QMARK_ = (function hatti$ona$forms$geotrace_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["geotrace",null], null), null),field);
});
hatti.ona.forms.image_QMARK_ = (function hatti$ona$forms$image_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["image",null,"photo",null], null), null),field);
});
hatti.ona.forms.video_QMARK_ = (function hatti$ona$forms$video_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["video",null], null), null),field);
});
hatti.ona.forms.osm_QMARK_ = (function hatti$ona$forms$osm_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["osm",null], null), null),field);
});
/**
 * Checks whether a field is a calculate field
 */
hatti.ona.forms.calculate_QMARK_ = (function hatti$ona$forms$calculate_QMARK_(field){
return hatti.ona.forms.field_type_in_set_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["calculate",null], null), null),field);
});
/**
 * Returns false for fields such as note, group, etc. which don't have data
 */
hatti.ona.forms.has_data_QMARK_ = (function hatti$ona$forms$has_data_QMARK_(field){
return cljs.core.not.call(null,(function (){var or__6409__auto__ = hatti.ona.forms.note_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.group_QMARK_.call(null,field);
}
})());
});
/**
 * Get the icon relevant to the given field (depending on its type).
 */
hatti.ona.forms.get_icon = (function hatti$ona$forms$get_icon(field){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(hatti.ona.forms.text_QMARK_.call(null,field))?"fa fa-font":(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))?"fa fa-clock-o":(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_.call(null,field))?"fa fa-bar-chart":(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_.call(null,field))?"fa fa-bar-chart fa-flip-h-rotate-90":""
)))))], null)], null);
});
/**
 * Assign class according to field type category, e.g. integer & decimals are
 * both in the numeric category
 */
hatti.ona.forms.get_column_class = (function hatti$ona$forms$get_column_class(field){
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_.call(null,field))){
if(cljs.core._EQ_.call(null,cljs.core.get.call(null,field,new cljs.core.Keyword(null,"full-name","full-name",408178550)),"_media_all_received")){
return "column-string media-attachment";
} else {
return "column-string";
}
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return "column-numeric";
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return "column-datetime";
} else {
if(cljs.core.truth_(hatti.ona.forms.categorical_QMARK_.call(null,field))){
return "column-categorical";
} else {
if(cljs.core.truth_(hatti.ona.forms.geofield_QMARK_.call(null,field))){
return "column-geofield";
} else {
if(cljs.core.truth_(hatti.ona.forms.image_QMARK_.call(null,field))){
return "column-image";
} else {
if(cljs.core.truth_(hatti.ona.forms.video_QMARK_.call(null,field))){
return "column-video";
} else {
if(cljs.core.truth_(hatti.ona.forms.meta_QMARK_.call(null,field))){
return "column-metadata";
} else {
return "";

}
}
}
}
}
}
}
}
});
/**
 * Gets the label object out of a map with key :label (eg. a field).
 * If multiple languages, and none specified, picks out alphabetically first.
 */
hatti.ona.forms.get_label = (function hatti$ona$forms$get_label(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17822 = arguments.length;
var i__7485__auto___17823 = (0);
while(true){
if((i__7485__auto___17823 < len__7484__auto___17822)){
args__7491__auto__.push((arguments[i__7485__auto___17823]));

var G__17824 = (i__7485__auto___17823 + (1));
i__7485__auto___17823 = G__17824;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic = (function (p__17815,p__17816){
var map__17817 = p__17815;
var map__17817__$1 = ((((!((map__17817 == null)))?((((map__17817.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17817.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17817):map__17817);
var label = cljs.core.get.call(null,map__17817__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var name = cljs.core.get.call(null,map__17817__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var vec__17818 = p__17816;
var language = cljs.core.nth.call(null,vec__17818,(0),null);
if(!(cljs.core.map_QMARK_.call(null,label))){
var or__6409__auto__ = label;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return name;
}
} else {
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,label)),language)){
return label.call(null,language);
} else {
return label.call(null,cljs.core.first.call(null,cljs.core.sort.call(null,cljs.core.keys.call(null,label))));
}
}
});

hatti.ona.forms.get_label.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.get_label.cljs$lang$applyTo = (function (seq17813){
var G__17814 = cljs.core.first.call(null,seq17813);
var seq17813__$1 = cljs.core.next.call(null,seq17813);
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(G__17814,seq17813__$1);
});

/**
 * Checks if the appearance-value has the search expression
 */
hatti.ona.forms.uses_search_expression_QMARK_ = (function hatti$ona$forms$uses_search_expression_QMARK_(appearance_value){
var and__6397__auto__ = typeof appearance_value === 'string';
if(and__6397__auto__){
return cljs.core.re_matches.call(null,/^search\(.*\)$/,appearance_value);
} else {
return and__6397__auto__;
}
});
/**
 * Displays tip question and tooltip msg for failed media files uploads
 */
hatti.ona.forms.media_files_upload_error_component = (function hatti$ona$forms$media_files_upload_error_component(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17830 = arguments.length;
var i__7485__auto___17831 = (0);
while(true){
if((i__7485__auto___17831 < len__7484__auto___17830)){
args__7491__auto__.push((arguments[i__7485__auto___17831]));

var G__17832 = (i__7485__auto___17831 + (1));
i__7485__auto___17831 = G__17832;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.media_files_upload_error_component.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.media_files_upload_error_component.cljs$core$IFn$_invoke$arity$variadic = (function (answer,p__17827){
var map__17828 = p__17827;
var map__17828__$1 = ((((!((map__17828 == null)))?((((map__17828.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17828.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17828):map__17828);
var help_url = cljs.core.get.call(null,map__17828__$1,new cljs.core.Keyword(null,"help-url","help-url",766245588));
var error_message = cljs.core.get.call(null,map__17828__$1,new cljs.core.Keyword(null,"error-message","error-message",1756021561));
var record_modal_QMARK_ = cljs.core.get.call(null,map__17828__$1,new cljs.core.Keyword(null,"record-modal?","record-modal?",1430355331));
if(cljs.core.truth_(record_modal_QMARK_)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.image-name","span.image-name",-1896102049),answer,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.tooltip","a.tooltip",-732155535),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"href","href",-793805698),help_url,new cljs.core.Keyword(null,"target","target",253001721),"_blank"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),error_message], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-question","span.tip-question",1059090371),"?"], null)], null)], null);
} else {
return chimera.js_interop.format.call(null,"<span class='image-name'> %s </span>\n          <a class='tooltip' href=%s target='_blank'>\n          <span class='tip-info'>%s</span>\n          <span class='tip-question'>?</span></a>",answer,help_url,error_message);
}
});

hatti.ona.forms.media_files_upload_error_component.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.media_files_upload_error_component.cljs$lang$applyTo = (function (seq17825){
var G__17826 = cljs.core.first.call(null,seq17825);
var seq17825__$1 = cljs.core.next.call(null,seq17825);
return hatti.ona.forms.media_files_upload_error_component.cljs$core$IFn$_invoke$arity$variadic(G__17826,seq17825__$1);
});

/**
 * Returns an infor icon with a tooltip message
 */
hatti.ona.forms.infor_icon_component = (function hatti$ona$forms$infor_icon_component(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17838 = arguments.length;
var i__7485__auto___17839 = (0);
while(true){
if((i__7485__auto___17839 < len__7484__auto___17838)){
args__7491__auto__.push((arguments[i__7485__auto___17839]));

var G__17840 = (i__7485__auto___17839 + (1));
i__7485__auto___17839 = G__17840;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.infor_icon_component.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.infor_icon_component.cljs$core$IFn$_invoke$arity$variadic = (function (answer,p__17835){
var map__17836 = p__17835;
var map__17836__$1 = ((((!((map__17836 == null)))?((((map__17836.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17836.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17836):map__17836);
var media_count = cljs.core.get.call(null,map__17836__$1,new cljs.core.Keyword(null,"media-count","media-count",1579124405));
var total_media = cljs.core.get.call(null,map__17836__$1,new cljs.core.Keyword(null,"total-media","total-media",1031250100));
return [cljs.core.str("<span>"),cljs.core.str(answer),cljs.core.str("<a class=\"tooltip top-right\" href=\"#\" target=\"_blank\">\n       <span class=\"media-status tip-info\">\n       <p><b>Total media files expected</b><span> : </span><span>"),cljs.core.str(total_media),cljs.core.str("</span></p>\n       <p><b>Total media files received</b><span> : </span><span>"),cljs.core.str(media_count),cljs.core.str("</span></p></span><i class='fa fa-info-circle'></i></a></span>")].join('');
});

hatti.ona.forms.infor_icon_component.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.infor_icon_component.cljs$lang$applyTo = (function (seq17833){
var G__17834 = cljs.core.first.call(null,seq17833);
var seq17833__$1 = cljs.core.next.call(null,seq17833);
return hatti.ona.forms.infor_icon_component.cljs$core$IFn$_invoke$arity$variadic(G__17834,seq17833__$1);
});

/**
 * String representation for a particular field datapoint (answer).
 * re-formatting depends on field type, eg. name->label substitution.
 * Optional: compact? should be true if a short string needs to be returned.
 */
hatti.ona.forms.format_answer = (function hatti$ona$forms$format_answer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17858 = arguments.length;
var i__7485__auto___17859 = (0);
while(true){
if((i__7485__auto___17859 < len__7484__auto___17858)){
args__7491__auto__.push((arguments[i__7485__auto___17859]));

var G__17860 = (i__7485__auto___17859 + (1));
i__7485__auto___17859 = G__17860;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic = (function (field,answer,p__17848){
var map__17849 = p__17848;
var map__17849__$1 = ((((!((map__17849 == null)))?((((map__17849.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17849.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17849):map__17849);
var language = cljs.core.get.call(null,map__17849__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var compact_QMARK_ = cljs.core.get.call(null,map__17849__$1,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var label = cljs.core.get.call(null,map__17849__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var field_key = cljs.core.get.call(null,map__17849__$1,new cljs.core.Keyword(null,"field-key","field-key",313262601),new cljs.core.Keyword(null,"name","name",1843675177));
var media = cljs.core.get.call(null,map__17849__$1,new cljs.core.Keyword(null,"media","media",-1066138403));
var record_modal_QMARK_ = cljs.core.get.call(null,map__17849__$1,new cljs.core.Keyword(null,"record-modal?","record-modal?",1430355331),false);
var media_count = cljs.core.get.call(null,map__17849__$1,new cljs.core.Keyword(null,"media-count","media-count",1579124405));
var total_media = cljs.core.get.call(null,map__17849__$1,new cljs.core.Keyword(null,"total-media","total-media",1031250100));
if(clojure.string.blank_QMARK_.call(null,answer)){
return hatti.ona.forms.no_answer;
} else {
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_.call(null,field))){
var option = cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__17849,map__17849__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__17841_SHARP_){
return cljs.core._EQ_.call(null,answer,field_key.call(null,p1__17841_SHARP_));
});})(map__17849,map__17849__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(field)));
var formatted = hatti.ona.forms.get_label.call(null,option,language);
var or__6409__auto__ = formatted;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return answer;
}
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_.call(null,field))){
var names = cljs.core.set.call(null,clojure.string.split.call(null,answer,/ /));
var appearance_value = new cljs.core.Keyword(null,"appearance","appearance",-216383432).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"control","control",1892578036).cljs$core$IFn$_invoke$arity$1(field));
var multiple_select_values = (cljs.core.truth_(hatti.ona.forms.uses_search_expression_QMARK_.call(null,appearance_value))?cljs.core.map.call(null,((function (names,appearance_value,map__17849,map__17849__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__17842_SHARP_){
return cljs.core.identity.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),p1__17842_SHARP_], null));
});})(names,appearance_value,map__17849,map__17849__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,names):cljs.core.filter.call(null,((function (names,appearance_value,map__17849,map__17849__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__17843_SHARP_){
return cljs.core.contains_QMARK_.call(null,names,field_key.call(null,p1__17843_SHARP_));
});})(names,appearance_value,map__17849,map__17849__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(field)));
return clojure.string.join.call(null,cljs.core.map.call(null,((function (names,appearance_value,multiple_select_values,map__17849,map__17849__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p1__17844_SHARP_){
return [cljs.core.str("\u2611 "),cljs.core.str(hatti.ona.forms.get_label.call(null,p1__17844_SHARP_,language)),cljs.core.str(" ")].join('');
});})(names,appearance_value,multiple_select_values,map__17849,map__17849__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,multiple_select_values));
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return chimera.date.format_date.call(null,answer);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.image_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.video_QMARK_.call(null,field);
}
})())){
var image = new cljs.core.Keyword(null,"download_url","download_url",-2115471203).cljs$core$IFn$_invoke$arity$1(answer);
var thumb = (function (){var or__6409__auto__ = new cljs.core.Keyword(null,"small_download_url","small_download_url",1654303565).cljs$core$IFn$_invoke$arity$1(answer);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return image;
}
})();
var fname = chimera.urls.last_url_param.call(null,new cljs.core.Keyword(null,"filename","filename",-1428840783).cljs$core$IFn$_invoke$arity$1(answer));
if((typeof answer === 'string') && (cljs.core.not_EQ_.call(null,answer,"null")) && ((thumb == null))){
return hatti.ona.forms.media_files_upload_error_component.call(null,answer,new cljs.core.Keyword(null,"help-url","help-url",766245588),hatti.constants.help_base_url.call(null,hatti.constants.failed_media_upload_help_url),new cljs.core.Keyword(null,"error-message","error-message",1756021561),hatti.constants.failed_media_upload_error_message,new cljs.core.Keyword(null,"record-modal?","record-modal?",1430355331),record_modal_QMARK_);
} else {
if(cljs.core._EQ_.call(null,answer,"null")){
return answer;
} else {
if(cljs.core.truth_(compact_QMARK_)){
return chimera.js_interop.format.call(null,"<a href='%s' target='_blank'>\n                                      <i class='fa fa-external-link'></i>\n                                      %s </a>",image,fname);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"href","href",-793805698),image,new cljs.core.Keyword(null,"target","target",253001721),"_blank"], null),(cljs.core.truth_(hatti.ona.forms.image_QMARK_.call(null,field))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),"80px",new cljs.core.Keyword(null,"src","src",-1651076051),thumb], null)], null):new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-file-video-o","i.fa.fa-file-video-o",450800431)], null)," ",fname], null))], null);

}
}
}
} else {
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_.call(null,field))){
var kw__GT_name = cljs.core.name;
var map__17851 = answer;
var map__17851__$1 = ((((!((map__17851 == null)))?((((map__17851.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17851.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17851):map__17851);
var name = cljs.core.get.call(null,map__17851__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__17851__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var osm_id = cljs.core.get.call(null,map__17851__$1,new cljs.core.Keyword(null,"osm-id","osm-id",-1125866420));
var type_cap = (cljs.core.truth_(type)?clojure.string.capitalize.call(null,type):null);
var title = [cljs.core.str("OSM "),cljs.core.str(type_cap),cljs.core.str(": "),cljs.core.str(name),cljs.core.str(" ("),cljs.core.str(osm_id),cljs.core.str(")")].join('');
if(cljs.core.truth_(compact_QMARK_)){
return title;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.osm-data","table.osm-data",-2112963294),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(2)], null),title], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),cljs.core.map.call(null,((function (kw__GT_name,map__17851,map__17851__$1,name,type,osm_id,type_cap,title,map__17849,map__17849__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media){
return (function (p__17853){
var vec__17854 = p__17853;
var tk = cljs.core.nth.call(null,vec__17854,(0),null);
var tv = cljs.core.nth.call(null,vec__17854,(1),null);
if(clojure.string.blank_QMARK_.call(null,tv)){
return null;
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.question","td.question",-381922608),kw__GT_name.call(null,tk)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.answer","td.answer",1235375692),tv], null)], null);
}
});})(kw__GT_name,map__17851,map__17851__$1,name,type,osm_id,type_cap,title,map__17849,map__17849__$1,language,compact_QMARK_,label,field_key,media,record_modal_QMARK_,media_count,total_media))
,new cljs.core.Keyword(null,"tags","tags",1771418977).cljs$core$IFn$_invoke$arity$1(answer))], null)], null);
}
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
if(cljs.core.empty_QMARK_.call(null,answer)){
return hatti.ona.forms.no_answer;
} else {
return [cljs.core.str("Repeated data with "),cljs.core.str(cljs.core.count.call(null,answer)),cljs.core.str(" answers.")].join('');
}
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
var temp__4655__auto__ = (function (){var G__17857 = label;
if((G__17857 == null)){
return null;
} else {
return cljs.core.re_find.call(null,hatti.ona.forms.currency_regex,G__17857);
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var currency = temp__4655__auto__;
return [cljs.core.str(currency),cljs.core.str(cljs.pprint.cl_format.call(null,null,"~:d",answer))].join('');
} else {
return answer;
}
} else {
if(cljs.core._EQ_.call(null,[cljs.core.str(answer)].join(''),"false")){
return hatti.ona.forms.infor_icon_component.call(null,answer,new cljs.core.Keyword(null,"media-count","media-count",1579124405),media_count,new cljs.core.Keyword(null,"total-media","total-media",1031250100),total_media);
} else {
return hatti.ona.forms.format_multiline_answer.call(null,answer);
}
}

}
}
}
}
}
}
}
});

hatti.ona.forms.format_answer.cljs$lang$maxFixedArity = (2);

hatti.ona.forms.format_answer.cljs$lang$applyTo = (function (seq17845){
var G__17846 = cljs.core.first.call(null,seq17845);
var seq17845__$1 = cljs.core.next.call(null,seq17845);
var G__17847 = cljs.core.first.call(null,seq17845__$1);
var seq17845__$2 = cljs.core.next.call(null,seq17845__$1);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(G__17846,G__17847,seq17845__$2);
});

/**
 * Try and produce a label for meta field if non-existent.
 */
hatti.ona.forms.relabel_meta_field = (function hatti$ona$forms$relabel_meta_field(p__17861){
var map__17867 = p__17861;
var map__17867__$1 = ((((!((map__17867 == null)))?((((map__17867.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17867.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17867):map__17867);
var field = map__17867__$1;
var label = cljs.core.get.call(null,map__17867__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var name = cljs.core.get.call(null,map__17867__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__17867__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var label__$1 = (cljs.core.truth_(type)?(function (){var G__17869 = type;
switch (G__17869) {
case "start":
return "Start time";

break;
case "end":
return "End time";

break;
case "today":
return "Day of survey";

break;
case "deviceid":
return "Device ID (IMEI)";

break;
case "imei":
return "IMEI";

break;
case "subscriberid":
return "IMSI";

break;
case "simserial":
return "SIM serial number";

break;
case "uuid":
return "UUID";

break;
case "instanceID":
return "Instance ID";

break;
case "phonenumber":
return "Phone number";

break;
case "_media_all_received":
return "Media attachments received";

break;
default:
return name;

}
})():(function (){var G__17870 = name;
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"_submission_time","_submission_time",83724637,null),G__17870)){
return "Submission time";
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"_submitted_by","_submitted_by",1753216498,null),G__17870)){
return "Submitted by";
} else {
return "";

}
}
})());
var G__17871 = field;
if(cljs.core.not.call(null,label__$1)){
return cljs.core.assoc.call(null,G__17871,new cljs.core.Keyword(null,"label","label",1718410804),label__$1);
} else {
return G__17871;
}
});
hatti.ona.forms.name_label_map = (function hatti$ona$forms$name_label_map(p__17874,prefix,acc,flatten_repeats_QMARK_){
var map__17877 = p__17874;
var map__17877__$1 = ((((!((map__17877 == null)))?((((map__17877.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17877.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17877):map__17877);
var child = map__17877__$1;
var children = cljs.core.get.call(null,map__17877__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var name = cljs.core.get.call(null,map__17877__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var label = cljs.core.get.call(null,map__17877__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var full_name = (cljs.core.truth_(prefix)?[cljs.core.str(prefix),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
var langs = ((cljs.core.map_QMARK_.call(null,label))?cljs.core.keys.call(null,label):null);
var updated_child = cljs.core.with_meta.call(null,cljs.core.assoc.call(null,child,new cljs.core.Keyword(null,"full-name","full-name",408178550),full_name),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"langs","langs",1700794362),langs], null));
var childless_child = cljs.core.dissoc.call(null,updated_child,new cljs.core.Keyword(null,"children","children",-940561982));
var make_new_children = cljs.core.map.call(null,((function (full_name,langs,updated_child,childless_child,map__17877,map__17877__$1,child,children,name,label){
return (function (p1__17873_SHARP_){
return hatti$ona$forms$name_label_map.call(null,p1__17873_SHARP_,full_name,cljs.core.PersistentVector.EMPTY,flatten_repeats_QMARK_);
});})(full_name,langs,updated_child,childless_child,map__17877,map__17877__$1,child,children,name,label))
,children);
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.group_QMARK_.call(null,updated_child);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var and__6397__auto__ = flatten_repeats_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.ona.forms.repeat_QMARK_.call(null,updated_child);
} else {
return and__6397__auto__;
}
}
})())){
return cljs.core.concat.call(null,cljs.core.conj.call(null,acc,childless_child),make_new_children);
} else {
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,updated_child))){
return cljs.core.conj.call(null,acc,cljs.core.assoc.call(null,updated_child,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.flatten.call(null,cljs.core.apply.call(null,cljs.core.concat,make_new_children))));
} else {
return cljs.core.conj.call(null,acc,updated_child);

}
}
});
/**
 * Input: map derived from form.json. Output: a flattened vector;
 * each element is a field; a field is a {:name .. :label .. :type ..} map.
 * By default, REPEAT BLOCKS ARE NOT FLATTENED, repeat blocks represent
 * subforms, which need special handling in most cases.
 * :flatten-repeats? overrides default behavior, also flattens repeats.
 */
hatti.ona.forms.flatten_form = (function hatti$ona$forms$flatten_form(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17889 = arguments.length;
var i__7485__auto___17890 = (0);
while(true){
if((i__7485__auto___17890 < len__7484__auto___17889)){
args__7491__auto__.push((arguments[i__7485__auto___17890]));

var G__17891 = (i__7485__auto___17890 + (1));
i__7485__auto___17890 = G__17891;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic = (function (p__17883,p__17884){
var map__17885 = p__17883;
var map__17885__$1 = ((((!((map__17885 == null)))?((((map__17885.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17885.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17885):map__17885);
var form = map__17885__$1;
var children = cljs.core.get.call(null,map__17885__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var map__17886 = p__17884;
var map__17886__$1 = ((((!((map__17886 == null)))?((((map__17886.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17886.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17886):map__17886);
var flatten_repeats_QMARK_ = cljs.core.get.call(null,map__17886__$1,new cljs.core.Keyword(null,"flatten-repeats?","flatten-repeats?",2012911394));
var nodes = cljs.core.flatten.call(null,cljs.core.map.call(null,((function (map__17885,map__17885__$1,form,children,map__17886,map__17886__$1,flatten_repeats_QMARK_){
return (function (p1__17879_SHARP_){
return hatti.ona.forms.name_label_map.call(null,p1__17879_SHARP_,null,cljs.core.PersistentVector.EMPTY,flatten_repeats_QMARK_);
});})(map__17885,map__17885__$1,form,children,map__17886,map__17886__$1,flatten_repeats_QMARK_))
,children));
var langs = cljs.core.distinct.call(null,cljs.core.flatten.call(null,cljs.core.map.call(null,((function (nodes,map__17885,map__17885__$1,form,children,map__17886,map__17886__$1,flatten_repeats_QMARK_){
return (function (p1__17880_SHARP_){
return new cljs.core.Keyword(null,"langs","langs",1700794362).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__17880_SHARP_));
});})(nodes,map__17885,map__17885__$1,form,children,map__17886,map__17886__$1,flatten_repeats_QMARK_))
,nodes)));
return cljs.core.with_meta.call(null,nodes,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"languages","languages",1471910331),cljs.core.remove.call(null,cljs.core.nil_QMARK_,langs)], null));
});

hatti.ona.forms.flatten_form.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.flatten_form.cljs$lang$applyTo = (function (seq17881){
var G__17882 = cljs.core.first.call(null,seq17881);
var seq17881__$1 = cljs.core.next.call(null,seq17881);
return hatti.ona.forms.flatten_form.cljs$core$IFn$_invoke$arity$variadic(G__17882,seq17881__$1);
});

/**
 * Get just the meta fields out of the form.
 * Options to re-label meta fields, or include submission time in meta list.
 */
hatti.ona.forms.meta_fields = (function hatti$ona$forms$meta_fields(var_args){
var args__7491__auto__ = [];
var len__7484__auto___17898 = arguments.length;
var i__7485__auto___17899 = (0);
while(true){
if((i__7485__auto___17899 < len__7484__auto___17898)){
args__7491__auto__.push((arguments[i__7485__auto___17899]));

var G__17900 = (i__7485__auto___17899 + (1));
i__7485__auto___17899 = G__17900;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,p__17895){
var map__17896 = p__17895;
var map__17896__$1 = ((((!((map__17896 == null)))?((((map__17896.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17896.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17896):map__17896);
var relabel_QMARK_ = cljs.core.get.call(null,map__17896__$1,new cljs.core.Keyword(null,"relabel?","relabel?",898608477),true);
var with_submission_details_QMARK_ = cljs.core.get.call(null,map__17896__$1,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549));
var meta_fields = cljs.core.filter.call(null,hatti.ona.forms.meta_QMARK_,flat_form);
var include_extra_sub_details = (cljs.core.truth_(with_submission_details_QMARK_)?((function (meta_fields,map__17896,map__17896__$1,relabel_QMARK_,with_submission_details_QMARK_){
return (function (p1__17892_SHARP_){
return cljs.core.into.call(null,cljs.core.vec.call(null,p1__17892_SHARP_),hatti.ona.forms.extra_submission_details);
});})(meta_fields,map__17896,map__17896__$1,relabel_QMARK_,with_submission_details_QMARK_))
:cljs.core.identity);
var relabel = (cljs.core.truth_(relabel_QMARK_)?hatti.ona.forms.relabel_meta_field:cljs.core.identity);
return include_extra_sub_details.call(null,cljs.core.map.call(null,relabel,meta_fields));
});

hatti.ona.forms.meta_fields.cljs$lang$maxFixedArity = (1);

hatti.ona.forms.meta_fields.cljs$lang$applyTo = (function (seq17893){
var G__17894 = cljs.core.first.call(null,seq17893);
var seq17893__$1 = cljs.core.next.call(null,seq17893);
return hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(G__17894,seq17893__$1);
});

/**
 * Get just the fields in this form that are not meta fields.
 */
hatti.ona.forms.non_meta_fields = (function hatti$ona$forms$non_meta_fields(flat_form){
return cljs.core.remove.call(null,hatti.ona.forms.meta_QMARK_,flat_form);
});
/**
 * Get just the geofields from the form.
 */
hatti.ona.forms.geofields = (function hatti$ona$forms$geofields(flat_form){
return cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,flat_form);
});
/**
 * From a list of geofields, get the default one to map.
 * Implementation: pick first geoshape if any, else pick first geofield.
 */
hatti.ona.forms.default_geofield = (function hatti$ona$forms$default_geofield(flat_form){
var repeats = cljs.core.flatten.call(null,cljs.core.filter.call(null,hatti.ona.forms.repeat_QMARK_,flat_form));
var geofields = hatti.ona.forms.geofields.call(null,cljs.core.concat.call(null,flat_form,repeats));
var geoshapes = cljs.core.filter.call(null,hatti.ona.forms.geoshape_QMARK_,geofields);
var geopoints = cljs.core.filter.call(null,hatti.ona.forms.geopoint_QMARK_,geofields);
if(cljs.core.seq.call(null,geoshapes)){
return cljs.core.first.call(null,geoshapes);
} else {
if(cljs.core.seq.call(null,geopoints)){
return cljs.core.first.call(null,geopoints);
} else {
return cljs.core.first.call(null,geofields);

}
}
});
hatti.ona.forms.english_QMARK_ = (function hatti$ona$forms$english_QMARK_(language){
return cljs.core.re_find.call(null,/english/i,[cljs.core.str(language)].join(''));
});
/**
 * Get the languages for a given form.
 */
hatti.ona.forms.get_languages = (function hatti$ona$forms$get_languages(form){
return new cljs.core.Keyword(null,"languages","languages",1471910331).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,form));
});
/**
 * Does this form contain labels in multiple languages?
 */
hatti.ona.forms.multilingual_QMARK_ = (function hatti$ona$forms$multilingual_QMARK_(form){
return cljs.core.seq.call(null,hatti.ona.forms.get_languages.call(null,form));
});
/**
 * Get default language (English or alphabetical first) from within a list.
 */
hatti.ona.forms.default_lang = (function hatti$ona$forms$default_lang(languages){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,hatti.ona.forms.english_QMARK_,languages));
if(cljs.core.truth_(temp__4655__auto__)){
var eng = temp__4655__auto__;
return eng;
} else {
return cljs.core.first.call(null,cljs.core.sort.call(null,languages));
}
});
