// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.ona.post_process');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.ona.forms');
goog.require('hatti.ona.urls');
goog.require('chimera.seq');
goog.require('hatti.constants');
goog.require('chimera.urls');
goog.require('clojure.string');
/**
 * Given some data in Ona format, builds a data structure that we will use
 * to link osm data to Ona data.
 */
hatti.ona.post_process.ona_osm_link = (function hatti$ona$post_process$ona_osm_link(data,form){
var osmfields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.flatten((function (){var iter__7189__auto__ = ((function (osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__35556(s__35557){
return (new cljs.core.LazySeq(null,((function (osmfields){
return (function (){
var s__35557__$1 = s__35557;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35557__$1);
if(temp__4657__auto__){
var s__35557__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35557__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35557__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35559 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35558 = (0);
while(true){
if((i__35558 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35558);
cljs.core.chunk_append(b__35559,(function (){var iter__7189__auto__ = ((function (i__35558,datum,c__7187__auto__,size__7188__auto__,b__35559,s__35557__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__35556_$_iter__35574(s__35575){
return (new cljs.core.LazySeq(null,((function (i__35558,datum,c__7187__auto__,size__7188__auto__,b__35559,s__35557__$2,temp__4657__auto__,osmfields){
return (function (){
var s__35575__$1 = s__35575;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__35575__$1);
if(temp__4657__auto____$1){
var s__35575__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__35575__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__35575__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__35577 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__35576 = (0);
while(true){
if((i__35576 < size__7188__auto____$1)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__35576);
cljs.core.chunk_append(b__35577,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__35586 = (i__35576 + (1));
i__35576 = G__35586;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35577),hatti$ona$post_process$ona_osm_link_$_iter__35556_$_iter__35574(cljs.core.chunk_rest(s__35575__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35577),null);
}
} else {
var field = cljs.core.first(s__35575__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__35556_$_iter__35574(cljs.core.rest(s__35575__$2)));
}
} else {
return null;
}
break;
}
});})(i__35558,datum,c__7187__auto__,size__7188__auto__,b__35559,s__35557__$2,temp__4657__auto__,osmfields))
,null,null));
});})(i__35558,datum,c__7187__auto__,size__7188__auto__,b__35559,s__35557__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})());

var G__35587 = (i__35558 + (1));
i__35558 = G__35587;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35559),hatti$ona$post_process$ona_osm_link_$_iter__35556(cljs.core.chunk_rest(s__35557__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35559),null);
}
} else {
var datum = cljs.core.first(s__35557__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (datum,s__35557__$2,temp__4657__auto__,osmfields){
return (function hatti$ona$post_process$ona_osm_link_$_iter__35556_$_iter__35580(s__35581){
return (new cljs.core.LazySeq(null,((function (datum,s__35557__$2,temp__4657__auto__,osmfields){
return (function (){
var s__35581__$1 = s__35581;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__35581__$1);
if(temp__4657__auto____$1){
var s__35581__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__35581__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35581__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35583 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35582 = (0);
while(true){
if((i__35582 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35582);
cljs.core.chunk_append(b__35583,(function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})());

var G__35588 = (i__35582 + (1));
i__35582 = G__35588;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35583),hatti$ona$post_process$ona_osm_link_$_iter__35556_$_iter__35580(cljs.core.chunk_rest(s__35581__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35583),null);
}
} else {
var field = cljs.core.first(s__35581__$2);
return cljs.core.cons((function (){var osmkey = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var osmdatum = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,osmkey);
var osmid = (function (){var and__6397__auto__ = osmdatum;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.re_find(/[0-9]+/,osmdatum);
} else {
return and__6397__auto__;
}
})();
if(cljs.core.truth_(osmid)){
return cljs.core.PersistentArrayMap.fromArray([osmid,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field,field], null),cljs.core.select_keys(datum,cljs.core.PersistentHashSet.fromArray([hatti.constants._rank,hatti.constants._id], true))], 0))], true, false);
} else {
return null;
}
})(),hatti$ona$post_process$ona_osm_link_$_iter__35556_$_iter__35580(cljs.core.rest(s__35581__$2)));
}
} else {
return null;
}
break;
}
});})(datum,s__35557__$2,temp__4657__auto__,osmfields))
,null,null));
});})(datum,s__35557__$2,temp__4657__auto__,osmfields))
;
return iter__7189__auto__(osmfields);
})(),hatti$ona$post_process$ona_osm_link_$_iter__35556(cljs.core.rest(s__35557__$2)));
}
} else {
return null;
}
break;
}
});})(osmfields))
,null,null));
});})(osmfields))
;
return iter__7189__auto__(data);
})()));
});
/**
 * Takes OSM XML in string form, and returns cljs geojson.
 */
hatti.ona.post_process.osm_xml__GT_geojson = (function hatti$ona$post_process$osm_xml__GT_geojson(osm_xml_string){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic((function (){var G__35590 = jQuery.parseXML(osm_xml_string);
return osmtogeojson(G__35590);
})(),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Given some data in OSM format, an Ona Form, and osm xml string,
 * return a map from OSM ID to each osm feature. The map contains:
 * :osm-id, :name, :tags from osm xml,
 * :type, :geom from osm feature's geojson equivalent.
 */
hatti.ona.post_process.osm_id__GT_osm_data = (function hatti$ona$post_process$osm_id__GT_osm_data(data,form,osm_xml){
var ona_osm_link = hatti.ona.post_process.ona_osm_link(data,form);
var osmgeo = hatti.ona.post_process.osm_xml__GT_geojson(osm_xml);
var featureset = (function (){var G__35614 = cljs.core.cst$kw$features;
return (osmgeo.cljs$core$IFn$_invoke$arity$1 ? osmgeo.cljs$core$IFn$_invoke$arity$1(G__35614) : osmgeo.call(null,G__35614));
})();
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7189__auto__ = ((function (ona_osm_link,osmgeo,featureset){
return (function hatti$ona$post_process$osm_id__GT_osm_data_$_iter__35615(s__35616){
return (new cljs.core.LazySeq(null,((function (ona_osm_link,osmgeo,featureset){
return (function (){
var s__35616__$1 = s__35616;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35616__$1);
if(temp__4657__auto__){
var s__35616__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35616__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35616__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35618 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35617 = (0);
while(true){
if((i__35617 < size__7188__auto__)){
var map__35629 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35617);
var map__35629__$1 = ((((!((map__35629 == null)))?((((map__35629.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35629.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35629):map__35629);
var feature = map__35629__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35629__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35629__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35629__$1,cljs.core.cst$kw$geometry);
cljs.core.chunk_append(b__35618,(function (){var map__35631 = properties;
var map__35631__$1 = ((((!((map__35631 == null)))?((((map__35631.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35631.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35631):map__35631);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35631__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35631__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35631__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})());

var G__35637 = (i__35617 + (1));
i__35617 = G__35637;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35618),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__35615(cljs.core.chunk_rest(s__35616__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35618),null);
}
} else {
var map__35633 = cljs.core.first(s__35616__$2);
var map__35633__$1 = ((((!((map__35633 == null)))?((((map__35633.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35633.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35633):map__35633);
var feature = map__35633__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35633__$1,cljs.core.cst$kw$type);
var properties = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35633__$1,cljs.core.cst$kw$properties);
var geometry = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35633__$1,cljs.core.cst$kw$geometry);
return cljs.core.cons((function (){var map__35635 = properties;
var map__35635__$1 = ((((!((map__35635 == null)))?((((map__35635.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35635.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35635):map__35635);
var type__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35635__$1,cljs.core.cst$kw$type);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35635__$1,cljs.core.cst$kw$id);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35635__$1,cljs.core.cst$kw$tags);
return cljs.core.PersistentArrayMap.fromArray([id,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$osm_DASH_id,id,cljs.core.cst$kw$type,type__$1,cljs.core.cst$kw$geom,geometry,cljs.core.cst$kw$name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(tags),cljs.core.cst$kw$tags,tags], null)], true, false);
})(),hatti$ona$post_process$osm_id__GT_osm_data_$_iter__35615(cljs.core.rest(s__35616__$2)));
}
} else {
return null;
}
break;
}
});})(ona_osm_link,osmgeo,featureset))
,null,null));
});})(ona_osm_link,osmgeo,featureset))
;
return iter__7189__auto__(featureset);
})());
});
/**
 * Given some data post-processed from the ona server
 * (ie, containing _id, _rank), and a string of osm-xml, produce a version with
 * relevant osm data injected in.
 */
hatti.ona.post_process.integrate_osm_data_BANG_ = (function hatti$ona$post_process$integrate_osm_data_BANG_(app_state,form,osm_xml,app_state_keys){
var osm_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.osm_QMARK_,form);
if(cljs.core.seq(osm_fields)){
var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(app_state,app_state_keys);
var osm_data = hatti.ona.post_process.osm_id__GT_osm_data(data,form,osm_xml);
var osm_val__GT_osm_id = ((function (data,osm_data,osm_fields){
return (function (p1__35638_SHARP_){
return cljs.core.re_find(/[-]?[0-9]+/,p1__35638_SHARP_);
});})(data,osm_data,osm_fields))
;
var osm_val__GT_osm_data = ((function (data,osm_data,osm_val__GT_osm_id,osm_fields){
return (function (osm_val,osm_id){
if(typeof osm_val === 'string'){
var temp__4655__auto__ = (osm_data.cljs$core$IFn$_invoke$arity$1 ? osm_data.cljs$core$IFn$_invoke$arity$1(osm_id) : osm_data.call(null,osm_id));
if(cljs.core.truth_(temp__4655__auto__)){
var osm_submission_data = temp__4655__auto__;
return osm_submission_data;
} else {
return osm_val;
}
} else {
return osm_val;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_fields))
;
var updater = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (osm_key){
return ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (data__$1){
var iter__7189__auto__ = ((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function hatti$ona$post_process$integrate_osm_data_BANG__$_iter__35650(s__35651){
return (new cljs.core.LazySeq(null,((function (data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (){
var s__35651__$1 = s__35651;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35651__$1);
if(temp__4657__auto__){
var s__35651__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35651__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35651__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35653 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35652 = (0);
while(true){
if((i__35652 < size__7188__auto__)){
var datum = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35652);
cljs.core.chunk_append(b__35653,(function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (i__35652,osm_id,datum,c__7187__auto__,size__7188__auto__,b__35653,s__35651__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__35639_SHARP_){
return osm_val__GT_osm_data(p1__35639_SHARP_,osm_id);
});})(i__35652,osm_id,datum,c__7187__auto__,size__7188__auto__,b__35653,s__35651__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})());

var G__35660 = (i__35652 + (1));
i__35652 = G__35660;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35653),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__35650(cljs.core.chunk_rest(s__35651__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35653),null);
}
} else {
var datum = cljs.core.first(s__35651__$2);
return cljs.core.cons((function (){var osm_id = (function (){var or__6409__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":way:id")].join('')], null));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(osm_key),cljs.core.str(":node:id")].join('')], null));
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(datum,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [osm_key], null),((function (osm_id,datum,s__35651__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields){
return (function (p1__35639_SHARP_){
return osm_val__GT_osm_data(p1__35639_SHARP_,osm_id);
});})(osm_id,datum,s__35651__$2,temp__4657__auto__,data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
);
})(),hatti$ona$post_process$integrate_osm_data_BANG__$_iter__35650(cljs.core.rest(s__35651__$2)));
}
} else {
return null;
}
break;
}
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
,null,null));
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
return iter__7189__auto__(data__$1);
});
;})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
});})(data,osm_data,osm_val__GT_osm_id,osm_val__GT_osm_data,osm_fields))
;
var seq__35656 = cljs.core.seq(osm_fields);
var chunk__35657 = null;
var count__35658 = (0);
var i__35659 = (0);
while(true){
if((i__35659 < count__35658)){
var osm_field = chunk__35657.cljs$core$IIndexed$_nth$arity$2(null,i__35659);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__35661 = seq__35656;
var G__35662 = chunk__35657;
var G__35663 = count__35658;
var G__35664 = (i__35659 + (1));
seq__35656 = G__35661;
chunk__35657 = G__35662;
count__35658 = G__35663;
i__35659 = G__35664;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__35656);
if(temp__4657__auto__){
var seq__35656__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35656__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__35656__$1);
var G__35665 = cljs.core.chunk_rest(seq__35656__$1);
var G__35666 = c__7220__auto__;
var G__35667 = cljs.core.count(c__7220__auto__);
var G__35668 = (0);
seq__35656 = G__35665;
chunk__35657 = G__35666;
count__35658 = G__35667;
i__35659 = G__35668;
continue;
} else {
var osm_field = cljs.core.first(seq__35656__$1);
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_state_keys,updater(cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(osm_field)));

var G__35669 = cljs.core.next(seq__35656__$1);
var G__35670 = null;
var G__35671 = (0);
var G__35672 = (0);
seq__35656 = G__35669;
chunk__35657 = G__35670;
count__35658 = G__35671;
i__35659 = G__35672;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
});
/**
 * Calculate full image and thumbnail urls given attachment information.
 */
hatti.ona.post_process.url_obj = (function hatti$ona$post_process$url_obj(media_obj){
var media_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"id");
var fname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(media_obj,"filename");
var file_url = hatti.ona.urls.media_url(media_id,fname);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$filename,fname,cljs.core.cst$kw$download_url,file_url,cljs.core.cst$kw$small_download_url,[cljs.core.str(file_url),cljs.core.str("&suffix=small")].join('')], null);
});
/**
 * Gets and returns matching name for an attachment that was renamed by
 *   appending a hash on the S3 server to avoid duplicating names.
 *   e.g. if 1478203839187.jpg was renamed to 1478203839187_wijUzUf.jpg,
 *   it returns 1478203839187_wijUzUf.jpg.
 */
hatti.ona.post_process.get_matching_name = (function hatti$ona$post_process$get_matching_name(fname,fnames){
if(typeof fname === 'string'){
try{var or__6409__auto__ = (function (){var G__35682 = (function (p1__35673_SHARP_){
return cljs.core.re_find(cljs.core.re_pattern(cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(fname,cljs.core.re_pattern("\\.")))),p1__35673_SHARP_);
});
var G__35683 = fnames;
return (chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2 ? chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2(G__35682,G__35683) : chimera.seq.filter_first.call(null,G__35682,G__35683));
})();
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return fname;
}
}catch (e35679){if((e35679 instanceof SyntaxError)){
var e = e35679;
return fname;
} else {
throw e35679;

}
}} else {
return fname;
}
});
/**
 * Helper function for integrate attachments; returns a function from
 * a filename to a `url-obj` (see specs in `url-obj` function).
 */
hatti.ona.post_process.get_attach_map = (function hatti$ona$post_process$get_attach_map(record,attachments){
var attachments__$1 = (function (){var or__6409__auto__ = attachments;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments);
}
})();
var fnames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (attachments__$1){
return (function (p1__35684_SHARP_){
return chimera.urls.last_url_param(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35684_SHARP_,"filename"));
});})(attachments__$1))
,attachments__$1);
var fname__GT_urlobj = cljs.core.zipmap(fnames,cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.ona.post_process.url_obj,attachments__$1));
return ((function (attachments__$1,fnames,fname__GT_urlobj){
return (function (fname){
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(fname__GT_urlobj,hatti.ona.post_process.get_matching_name(fname,fnames),fname);
});
;})(attachments__$1,fnames,fname__GT_urlobj))
});
/**
 * Coll -> Coll
 */
hatti.ona.post_process.filter_media = (function hatti$ona$post_process$filter_media(flat_form){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__35685_SHARP_){
var or__6409__auto__ = hatti.ona.forms.video_QMARK_(p1__35685_SHARP_);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.image_QMARK_(p1__35685_SHARP_);
}
}),flat_form);
});
/**
 * Inlines media data from within _attachments into each record.
 * Coll Coll -> Coll
 */
hatti.ona.post_process.integrate_attachments = (function hatti$ona$post_process$integrate_attachments(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35698 = arguments.length;
var i__7485__auto___35699 = (0);
while(true){
if((i__7485__auto___35699 < len__7484__auto___35698)){
args__7491__auto__.push((arguments[i__7485__auto___35699]));

var G__35700 = (i__7485__auto___35699 + (1));
i__7485__auto___35699 = G__35700;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic = (function (flat_form,data,p__35689){
var map__35690 = p__35689;
var map__35690__$1 = ((((!((map__35690 == null)))?((((map__35690.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35690.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35690):map__35690);
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35690__$1,cljs.core.cst$kw$attachments);
var image_fields = hatti.ona.post_process.filter_media(flat_form);
var iter__7189__auto__ = ((function (image_fields,map__35690,map__35690__$1,attachments){
return (function hatti$ona$post_process$iter__35692(s__35693){
return (new cljs.core.LazySeq(null,((function (image_fields,map__35690,map__35690__$1,attachments){
return (function (){
var s__35693__$1 = s__35693;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35693__$1);
if(temp__4657__auto__){
var s__35693__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35693__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35693__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35695 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35694 = (0);
while(true){
if((i__35694 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35694);
cljs.core.chunk_append(b__35695,(function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__35694,attach_map,record,c__7187__auto__,size__7188__auto__,b__35695,s__35693__$2,temp__4657__auto__,image_fields,map__35690,map__35690__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(i__35694,attach_map,record,c__7187__auto__,size__7188__auto__,b__35695,s__35693__$2,temp__4657__auto__,image_fields,map__35690,map__35690__$1,attachments))
,record,image_fields);
})());

var G__35701 = (i__35694 + (1));
i__35694 = G__35701;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35695),hatti$ona$post_process$iter__35692(cljs.core.chunk_rest(s__35693__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35695),null);
}
} else {
var record = cljs.core.first(s__35693__$2);
return cljs.core.cons((function (){var attach_map = hatti.ona.post_process.get_attach_map(record,attachments);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attach_map,record,s__35693__$2,temp__4657__auto__,image_fields,map__35690,map__35690__$1,attachments){
return (function (record__$1,img_field){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(record__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(img_field)], null),attach_map);
});})(attach_map,record,s__35693__$2,temp__4657__auto__,image_fields,map__35690,map__35690__$1,attachments))
,record,image_fields);
})(),hatti$ona$post_process$iter__35692(cljs.core.rest(s__35693__$2)));
}
} else {
return null;
}
break;
}
});})(image_fields,map__35690,map__35690__$1,attachments))
,null,null));
});})(image_fields,map__35690,map__35690__$1,attachments))
;
return iter__7189__auto__(data);
});

hatti.ona.post_process.integrate_attachments.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments.cljs$lang$applyTo = (function (seq35686){
var G__35687 = cljs.core.first(seq35686);
var seq35686__$1 = cljs.core.next(seq35686);
var G__35688 = cljs.core.first(seq35686__$1);
var seq35686__$2 = cljs.core.next(seq35686__$1);
return hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(G__35687,G__35688,seq35686__$2);
});

/**
 * Inlines data from within _attachments into each datapoint within repeats.
 */
hatti.ona.post_process.integrate_attachments_in_repeats = (function hatti$ona$post_process$integrate_attachments_in_repeats(flat_form,data){
var repeat_fields = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.repeat_QMARK_,flat_form);
var integrate = ((function (repeat_fields){
return (function (record,rpt_field){
var key = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(rpt_field);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(record,key,hatti.ona.post_process.integrate_attachments.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(rpt_field),cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,key),cljs.core.array_seq([cljs.core.cst$kw$attachments,cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,hatti.constants._attachments)], 0)));
});})(repeat_fields))
;
var iter__7189__auto__ = ((function (repeat_fields,integrate){
return (function hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__35708(s__35709){
return (new cljs.core.LazySeq(null,((function (repeat_fields,integrate){
return (function (){
var s__35709__$1 = s__35709;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35709__$1);
if(temp__4657__auto__){
var s__35709__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35709__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35709__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35711 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35710 = (0);
while(true){
if((i__35710 < size__7188__auto__)){
var record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35710);
cljs.core.chunk_append(b__35711,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields));

var G__35714 = (i__35710 + (1));
i__35710 = G__35714;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35711),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__35708(cljs.core.chunk_rest(s__35709__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35711),null);
}
} else {
var record = cljs.core.first(s__35709__$2);
return cljs.core.cons(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(integrate,record,repeat_fields),hatti$ona$post_process$integrate_attachments_in_repeats_$_iter__35708(cljs.core.rest(s__35709__$2)));
}
} else {
return null;
}
break;
}
});})(repeat_fields,integrate))
,null,null));
});})(repeat_fields,integrate))
;
return iter__7189__auto__(data);
});
/**
 * Inlines data from within _attachments into each record within app-state.
 */
hatti.ona.post_process.integrate_attachments_BANG_ = (function hatti$ona$post_process$integrate_attachments_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___35722 = arguments.length;
var i__7485__auto___35723 = (0);
while(true){
if((i__7485__auto___35723 < len__7484__auto___35722)){
args__7491__auto__.push((arguments[i__7485__auto___35723]));

var G__35724 = (i__7485__auto___35723 + (1));
i__7485__auto___35723 = G__35724;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (app_state,flat_form,p__35719){
var map__35720 = p__35719;
var map__35720__$1 = ((((!((map__35720 == null)))?((((map__35720.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35720.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35720):map__35720);
var app_data_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35720__$1,cljs.core.cst$kw$app_DASH_data_DASH_keys,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(app_state,app_data_keys,((function (map__35720,map__35720__$1,app_data_keys){
return (function (p1__35715_SHARP_){
return hatti.ona.post_process.integrate_attachments_in_repeats(flat_form,hatti.ona.post_process.integrate_attachments(flat_form,p1__35715_SHARP_));
});})(map__35720,map__35720__$1,app_data_keys))
);
});

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.post_process.integrate_attachments_BANG_.cljs$lang$applyTo = (function (seq35716){
var G__35717 = cljs.core.first(seq35716);
var seq35716__$1 = cljs.core.next(seq35716);
var G__35718 = cljs.core.first(seq35716__$1);
var seq35716__$2 = cljs.core.next(seq35716__$1);
return hatti.ona.post_process.integrate_attachments_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35717,G__35718,seq35716__$2);
});

