// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.viewby');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('hatti.map.utils');
goog.require('chimera.seq');
goog.require('hatti.utils.style');
goog.require('hatti.charting');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('om.core');
goog.require('clojure.string');
hatti.map.viewby.marker_styler = (function hatti$map$viewby$marker_styler(id_color,id_selected_QMARK_){
return (function (marker){
var id = hatti.map.utils.get_id(marker);
var geotype = hatti.map.utils.marker__GT_geotype(marker);
var color_key = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$line,geotype))?cljs.core.cst$kw$color:cljs.core.cst$kw$fillColor);
return cljs.core.PersistentArrayMap.fromArray([color_key,(cljs.core.truth_((id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(id) : id_selected_QMARK_.call(null,id)))?(id_color.cljs$core$IFn$_invoke$arity$1 ? id_color.cljs$core$IFn$_invoke$arity$1(id) : id_color.call(null,id)):hatti.utils.style.grey)], true, false);
});
});
hatti.map.viewby.move_nil_to_end = (function hatti$map$viewby$move_nil_to_end(s){
var no_nil = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,s));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s,no_nil)){
return s;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(no_nil,null);
}
});
hatti.map.viewby.all_but_nil_selected = (function hatti$map$viewby$all_but_nil_selected(answers){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(true)),new cljs.core.PersistentArrayMap(null, 1, [null,false], null)], 0));
});
/**
 * Preproccesses answers depending on the field. For multi-selects, return type
 * is a list of list of strings. For other types, a list of strings.
 */
hatti.map.viewby.preprocess_answers = (function hatti$map$viewby$preprocess_answers(field,raw_answers){
if(cljs.core.truth_(hatti.ona.forms.select_one_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.text_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.calculate_QMARK_(field))){
return raw_answers;
} else {
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return hatti.charting.evenly_spaced_bins(raw_answers,(5),"int");
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return hatti.charting.evenly_spaced_bins(raw_answers,(5),(cljs.core.truth_(cljs.core.re_find(/^..:..$/,cljs.core.first(raw_answers)))?"time":"date"));
} else {
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34808_SHARP_){
if(cljs.core.truth_(p1__34808_SHARP_)){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__34808_SHARP_,/ /);
} else {
return null;
}
}),raw_answers);
} else {
return null;
}
}
}
}
}
}
});
hatti.map.viewby.has_geolocation_QMARK_ = (function hatti$map$viewby$has_geolocation_QMARK_(p__34809){
var map__34815 = p__34809;
var map__34815__$1 = ((((!((map__34815 == null)))?((((map__34815.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34815.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34815):map__34815);
var vec__34816 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34815__$1,"_geolocation");
var lattitude = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34816,(0),null);
var longitude = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34816,(1),null);
var and__6397__auto__ = lattitude;
if(cljs.core.truth_(and__6397__auto__)){
return lattitude;
} else {
return and__6397__auto__;
}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_info = (function hatti$map$viewby$viewby_info(p__34823,data){
var map__34826 = p__34823;
var map__34826__$1 = ((((!((map__34826 == null)))?((((map__34826.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34826.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34826):map__34826);
var field = map__34826__$1;
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34826__$1,cljs.core.cst$kw$full_DASH_name);
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__34826,map__34826__$1,field,full_name){
return (function (p1__34820_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34820_SHARP_,hatti.constants._id);
});})(map__34826,map__34826__$1,field,full_name))
,data);
var raw_answers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,map__34826,map__34826__$1,field,full_name){
return (function (p1__34821_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34821_SHARP_,full_name);
});})(ids,map__34826,map__34826__$1,field,full_name))
,data);
var submissions_with_geolocation = cljs.core.filterv(hatti.map.viewby.has_geolocation_QMARK_,data);
var raw_answers_with_geolocation = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,raw_answers,submissions_with_geolocation,map__34826,map__34826__$1,field,full_name){
return (function (p1__34822_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34822_SHARP_,full_name);
});})(ids,raw_answers,submissions_with_geolocation,map__34826,map__34826__$1,field,full_name))
,submissions_with_geolocation);
var preprocessed_answers = hatti.map.viewby.preprocess_answers(field,raw_answers);
var answer__GT_count = cljs.core.frequencies(cljs.core.flatten(preprocessed_answers));
var answer__GT_count_with_geolocations = cljs.core.frequencies(cljs.core.flatten(hatti.map.viewby.preprocess_answers(field,raw_answers_with_geolocation)));
var sorted_answers = (cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.categorical_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.text_QMARK_(field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_(field);
}
}
})())?cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.time_based_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_(field);
}
})())?cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end(sorted_answers);
var answer__GT_color_map = hatti.utils.style.answer__GT_color(field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$id_DASH__GT_answers,cljs.core.zipmap(ids,preprocessed_answers),cljs.core.cst$kw$answer_DASH__GT_count,answer__GT_count,cljs.core.cst$kw$answer_DASH__GT_count_DASH_with_DASH_geolocations,answer__GT_count_with_geolocations,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,hatti.map.viewby.all_but_nil_selected(sorted_answers),cljs.core.cst$kw$answer_DASH__GT_color,answer__GT_color_map,cljs.core.cst$kw$visible_DASH_answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$field,field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([defaults,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id_DASH_color,((function (ids,raw_answers,submissions_with_geolocation,raw_answers_with_geolocation,preprocessed_answers,answer__GT_count,answer__GT_count_with_geolocations,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__34826,map__34826__$1,field,full_name){
return (function (){
return cljs.core.first(cljs.core.vals(answer__GT_color_map));
});})(ids,raw_answers,submissions_with_geolocation,raw_answers_with_geolocation,preprocessed_answers,answer__GT_count,answer__GT_count_with_geolocations,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__34826,map__34826__$1,field,full_name))
], null)], 0));
} else {
return defaults;

}
});
/**
 * Produces a set of data structures / functions for view-by.
 * answers are a list of answers, sorted by count;
 * id->answers is a mapping from id to either one or many answers
 * answer->count, answer->selected?, answer->color are maps from answer;
 * used for the legend rendering. An 'answer' is mapped from a data element,
 * eg. a bin for numbers/dates, an option for multiple/single selects.
 */
hatti.map.viewby.viewby_data = (function hatti$map$viewby$viewby_data(p__34830,data){
var map__34833 = p__34830;
var map__34833__$1 = ((((!((map__34833 == null)))?((((map__34833.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34833.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34833):map__34833);
var field = map__34833__$1;
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34833__$1,cljs.core.cst$kw$full_DASH_name);
if(cljs.core.seq_QMARK_(cljs.core.seq(data))){
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__34833,map__34833__$1,field,full_name){
return (function (p1__34828_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34828_SHARP_,hatti.constants._id);
});})(map__34833,map__34833__$1,field,full_name))
,data);
var raw_answers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ids,map__34833,map__34833__$1,field,full_name){
return (function (p1__34829_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34829_SHARP_,full_name);
});})(ids,map__34833,map__34833__$1,field,full_name))
,data);
var preprocessed_answers = hatti.map.viewby.preprocess_answers(field,raw_answers);
var answer__GT_count = cljs.core.frequencies(cljs.core.flatten(preprocessed_answers));
var sorted_answers = (cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.categorical_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = hatti.ona.forms.text_QMARK_(field);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return hatti.ona.forms.calculate_QMARK_(field);
}
}
})())?cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.second,cljs.core._GT_,answer__GT_count)):(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.time_based_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.numeric_QMARK_(field);
}
})())?cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(preprocessed_answers)):null));
var sorted_answers_with_nil_at_end = hatti.map.viewby.move_nil_to_end(sorted_answers);
var answer__GT_color_map = hatti.utils.style.answer__GT_color(field,sorted_answers);
var defaults = new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$ids,ids,cljs.core.cst$kw$answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$id_DASH__GT_answers,cljs.core.zipmap(ids,preprocessed_answers),cljs.core.cst$kw$answer_DASH__GT_count,answer__GT_count,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,hatti.map.viewby.all_but_nil_selected(sorted_answers),cljs.core.cst$kw$answer_DASH__GT_color,answer__GT_color_map,cljs.core.cst$kw$visible_DASH_answers,sorted_answers_with_nil_at_end,cljs.core.cst$kw$field,field], null);
if(cljs.core.truth_(hatti.ona.forms.select_all_QMARK_(field))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([defaults,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id_DASH_color,((function (ids,raw_answers,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__34833,map__34833__$1,field,full_name){
return (function (){
return cljs.core.first(cljs.core.vals(answer__GT_color_map));
});})(ids,raw_answers,preprocessed_answers,answer__GT_count,sorted_answers,sorted_answers_with_nil_at_end,answer__GT_color_map,defaults,map__34833,map__34833__$1,field,full_name))
], null)], 0));
} else {
return defaults;

}
} else {
return null;
}
});
/**
 * Generates id-color and id-selected? functions based on viewby-info.
 */
hatti.map.viewby.id_color_selected = (function hatti$map$viewby$id_color_selected(p__34837){
var map__34843 = p__34837;
var map__34843__$1 = ((((!((map__34843 == null)))?((((map__34843.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34843.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34843):map__34843);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34843__$1,cljs.core.cst$kw$field);
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34843__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var answer__GT_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34843__$1,cljs.core.cst$kw$answer_DASH__GT_color);
var answer__GT_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34843__$1,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_);
var G__34845 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(field);
switch (G__34845) {
case "select all that apply":
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id_DASH_color,((function (G__34845,map__34843,map__34843__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (){
return cljs.core.first(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#f30"], null));
});})(G__34845,map__34843,map__34843__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,cljs.core.cst$kw$id_DASH_selected_QMARK_,((function (G__34845,map__34843,map__34843__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (id){
var answers = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(id) : id__GT_answers.call(null,id));
if((answers == null)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(answer__GT_selected_QMARK_,answers);
} else {
return cljs.core.some(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(answer__GT_selected_QMARK_,answers));
}
});})(G__34845,map__34843,map__34843__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

break;
default:
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$id_DASH_color,((function (G__34845,map__34843,map__34843__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__34835_SHARP_){
var G__34846 = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(p1__34835_SHARP_) : id__GT_answers.call(null,p1__34835_SHARP_));
return (answer__GT_color.cljs$core$IFn$_invoke$arity$1 ? answer__GT_color.cljs$core$IFn$_invoke$arity$1(G__34846) : answer__GT_color.call(null,G__34846));
});})(G__34845,map__34843,map__34843__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
,cljs.core.cst$kw$id_DASH_selected_QMARK_,((function (G__34845,map__34843,map__34843__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_){
return (function (p1__34836_SHARP_){
var G__34847 = (id__GT_answers.cljs$core$IFn$_invoke$arity$1 ? id__GT_answers.cljs$core$IFn$_invoke$arity$1(p1__34836_SHARP_) : id__GT_answers.call(null,p1__34836_SHARP_));
return (answer__GT_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? answer__GT_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__34847) : answer__GT_selected_QMARK_.call(null,G__34847));
});})(G__34845,map__34843,map__34843__$1,field,id__GT_answers,answer__GT_color,answer__GT_selected_QMARK_))
], null);

}
});
hatti.map.viewby.view_by_BANG_ = (function hatti$map$viewby$view_by_BANG_(view_by_info,markers){
var map__34855 = hatti.map.viewby.id_color_selected(view_by_info);
var map__34855__$1 = ((((!((map__34855 == null)))?((((map__34855.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34855.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34855):map__34855);
var id_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34855__$1,cljs.core.cst$kw$id_DASH_selected_QMARK_);
var id_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34855__$1,cljs.core.cst$kw$id_DASH_color);
var m__GT_s = hatti.map.viewby.marker_styler(id_color,id_selected_QMARK_);
var seq__34857 = cljs.core.seq(markers);
var chunk__34858 = null;
var count__34859 = (0);
var i__34860 = (0);
while(true){
if((i__34860 < count__34859)){
var marker = chunk__34858.cljs$core$IIndexed$_nth$arity$2(null,i__34860);
hatti.map.utils.re_style_marker(m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected(id_selected_QMARK_,marker);

var G__34861 = seq__34857;
var G__34862 = chunk__34858;
var G__34863 = count__34859;
var G__34864 = (i__34860 + (1));
seq__34857 = G__34861;
chunk__34858 = G__34862;
count__34859 = G__34863;
i__34860 = G__34864;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__34857);
if(temp__4657__auto__){
var seq__34857__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34857__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__34857__$1);
var G__34865 = cljs.core.chunk_rest(seq__34857__$1);
var G__34866 = c__7220__auto__;
var G__34867 = cljs.core.count(c__7220__auto__);
var G__34868 = (0);
seq__34857 = G__34865;
chunk__34858 = G__34866;
count__34859 = G__34867;
i__34860 = G__34868;
continue;
} else {
var marker = cljs.core.first(seq__34857__$1);
hatti.map.utils.re_style_marker(m__GT_s,marker);

hatti.map.utils.bring_to_top_if_selected(id_selected_QMARK_,marker);

var G__34869 = cljs.core.next(seq__34857__$1);
var G__34870 = null;
var G__34871 = (0);
var G__34872 = (0);
seq__34857 = G__34869;
chunk__34858 = G__34870;
count__34859 = G__34871;
i__34860 = G__34872;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.viewby.apply_view_by_BANG_ = (function hatti$map$viewby$apply_view_by_BANG_(p__34874,owner){
var map__34879 = p__34874;
var map__34879__$1 = ((((!((map__34879 == null)))?((((map__34879.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34879.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34879):map__34879);
var view_by_info = map__34879__$1;
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34879__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var map__34881 = hatti.map.viewby.id_color_selected(view_by_info);
var map__34881__$1 = ((((!((map__34881 == null)))?((((map__34881.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34881.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34881):map__34881);
var id_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34881__$1,cljs.core.cst$kw$id_DASH_selected_QMARK_);
var id_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34881__$1,cljs.core.cst$kw$id_DASH_color);
var ids = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(id__GT_answers));
var stops = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (map__34881,map__34881__$1,id_selected_QMARK_,id_color,ids,map__34879,map__34879__$1,view_by_info,id__GT_answers){
return (function (p1__34873_SHARP_){
if(cljs.core.truth_((id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(p1__34873_SHARP_) : id_selected_QMARK_.call(null,p1__34873_SHARP_)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34873_SHARP_,(id_color.cljs$core$IFn$_invoke$arity$1 ? id_color.cljs$core$IFn$_invoke$arity$1(p1__34873_SHARP_) : id_color.call(null,p1__34873_SHARP_))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34873_SHARP_,hatti.utils.style.grey], null);
}
});})(map__34881,map__34881__$1,id_selected_QMARK_,id_color,ids,map__34879,map__34879__$1,view_by_info,id__GT_answers))
,ids);
var id_string = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$id_string], null));
var style = om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$style], null));
if(cljs.core.seq_QMARK_(cljs.core.seq(stops))){
hatti.map.utils.set_mapboxgl_paint_property(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mapboxgl_DASH_map),id_string,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$normal,cljs.core.array_seq([cljs.core.cst$kw$stops,stops], 0)));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$stops,stops);
} else {
return null;
}
});
/**
 * Given a list of answers + query, returns map from answers to true/false.
 * True if query is in the answer, false if not.
 */
hatti.map.viewby.filter_answer_data_structures = (function hatti$map$viewby$filter_answer_data_structures(answers,query,field,language){
var query_present_QMARK_ = (function (ans){
if(cljs.core.truth_(ans)){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,ans,cljs.core.array_seq([cljs.core.cst$kw$language,language], 0)));
} else {
return null;
}
});
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$visible_DASH_answers,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(query_present_QMARK_,answers),cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_,cljs.core.zipmap(answers,cljs.core.map.cljs$core$IFn$_invoke$arity$2(query_present_QMARK_,answers))], null);
});
/**
 * This function appropriately toggles answer->selected? when answer is clicked
 * answer->selected? is a map from answers to true/false. Special rules:
 * First click = select the answer. If nothing clicked, make everything
 * clicked.
 */
hatti.map.viewby.toggle_answer_selected = (function hatti$map$viewby$toggle_answer_selected(answer__GT_selected_QMARK_,visible_answers,answer){
var all_answers = cljs.core.vals(answer__GT_selected_QMARK_);
var all_visible_selected_QMARK_ = ((function (all_answers){
return (function (a__GT_s,visible){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.set(visible),cljs.core.set(cljs.core.keys(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.second,a__GT_s))));
});})(all_answers))
;
if((answer == null)){
return answer__GT_selected_QMARK_;
} else {
if(cljs.core.truth_(all_visible_selected_QMARK_(answer__GT_selected_QMARK_,visible_answers))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(all_answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(false)),cljs.core.PersistentArrayMap.fromArray([answer,true], true, false)], 0));
} else {
var toggled = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(answer__GT_selected_QMARK_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer], null),cljs.core.not);
if(cljs.core.every_QMARK_(cljs.core.false_QMARK_,cljs.core.vals(toggled))){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.zipmap(all_answers,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(false)),hatti.map.viewby.all_but_nil_selected(visible_answers)], 0));
} else {
return toggled;
}
}
}
});
/**
 * Returns selected ids from view-by data
 */
hatti.map.viewby.get_selected_ids = (function hatti$map$viewby$get_selected_ids(view_by){
var map__34894 = view_by;
var map__34894__$1 = ((((!((map__34894 == null)))?((((map__34894.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34894.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34894):map__34894);
var answer__GT_selected_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34894__$1,cljs.core.cst$kw$answer_DASH__GT_selected_QMARK_);
var id__GT_answers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34894__$1,cljs.core.cst$kw$id_DASH__GT_answers);
var answer__GT_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34894__$1,cljs.core.cst$kw$answer_DASH__GT_color);
var into_map = ((function (map__34894,map__34894__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color){
return (function (p1__34883_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,p1__34883_SHARP_);
});})(map__34894,map__34894__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color))
;
var selected_answers = cljs.core.keys(into_map(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__34894,map__34894__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map){
return (function (p__34896){
var vec__34897 = p__34896;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34897,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34897,(1),null);
return v;
});})(map__34894,map__34894__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map))
,answer__GT_selected_QMARK_)));
var selected_ids = cljs.core.keys(into_map(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__34894,map__34894__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map,selected_answers){
return (function (p__34900){
var vec__34901 = p__34900;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34901,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34901,(1),null);
return chimera.seq.in_QMARK_(selected_answers,v);
});})(map__34894,map__34894__$1,answer__GT_selected_QMARK_,id__GT_answers,answer__GT_color,into_map,selected_answers))
,id__GT_answers)));
var color = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(selected_answers)))?cljs.core.get.cljs$core$IFn$_invoke$arity$2(answer__GT_color,cljs.core.first(selected_answers)):null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$selected_DASH_ids,selected_ids,cljs.core.cst$kw$cell_DASH_color,color], null);
});
