// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('hatti.views.user_guide');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.views.report_view');
goog.require('hatti.shared');
goog.require('chimera.metrics');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$table,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings,cljs.core.cst$kw$overview,cljs.core.cst$kw$chart,cljs.core.cst$kw$photos,cljs.core.cst$kw$map],[new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$label,"User Guide",cljs.core.cst$kw$component,hatti.views.user_guide_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$table,cljs.core.cst$kw$label,"Table",cljs.core.cst$kw$component,hatti.views.table_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$label,"Reports",cljs.core.cst$kw$component,hatti.views.report_view_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$label,"Dashboard",cljs.core.cst$kw$component,hatti.views.saved_charts_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$label,"Settings",cljs.core.cst$kw$component,hatti.views.settings_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$overview,cljs.core.cst$kw$label,"Overview",cljs.core.cst$kw$component,hatti.views.overview_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$chart,cljs.core.cst$kw$label,"Charts",cljs.core.cst$kw$component,hatti.views.chart_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$photos,cljs.core.cst$kw$label,"Photos",cljs.core.cst$kw$component,hatti.views.photos_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$map,cljs.core.cst$kw$label,"Map",cljs.core.cst$kw$component,hatti.views.map_page], null)]);
/**
 * Initial Dataview State
 */
hatti.views.dataview.default_dataviews = (function hatti$views$dataview$default_dataviews(){
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.dataview_map) : cljs.core.atom.call(null,hatti.views.dataview.dataview_map));
});
hatti.views.dataview.view_state = hatti.views.dataview.default_dataviews();
/**
 * Build and set the tooltips for inactive views based on why they are
 * inactive.
 */
hatti.views.dataview.view__GT_inactive_tab = (function hatti$views$dataview$view__GT_inactive_tab(view,label,is_encrypted_QMARK_,not_within_pricing_limits_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$inactive,[cljs.core.str(label),cljs.core.str(" ")].join(''),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$tooltip,(cljs.core.truth_(is_encrypted_QMARK_)?"This tab is disabled because this form is encrypted.":(cljs.core.truth_(not_within_pricing_limits_QMARK_)?"This tab is disabled because you are over the pricing limits.":(function (){var pred__39271 = cljs.core._EQ_;
var expr__39272 = view;
if(cljs.core.truth_((function (){var G__39274 = cljs.core.cst$kw$map;
var G__39275 = expr__39272;
return (pred__39271.cljs$core$IFn$_invoke$arity$2 ? pred__39271.cljs$core$IFn$_invoke$arity$2(G__39274,G__39275) : pred__39271.call(null,G__39274,G__39275));
})())){
return [cljs.core.str("The Map tab is disabled because this form "),cljs.core.str("has no location questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39276 = cljs.core.cst$kw$photos;
var G__39277 = expr__39272;
return (pred__39271.cljs$core$IFn$_invoke$arity$2 ? pred__39271.cljs$core$IFn$_invoke$arity$2(G__39276,G__39277) : pred__39271.call(null,G__39276,G__39277));
})())){
return [cljs.core.str("The Photos tab is disabled because this form has no "),cljs.core.str("photo questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39278 = cljs.core.cst$kw$table;
var G__39279 = expr__39272;
return (pred__39271.cljs$core$IFn$_invoke$arity$2 ? pred__39271.cljs$core$IFn$_invoke$arity$2(G__39278,G__39279) : pred__39271.call(null,G__39278,G__39279));
})())){
return [cljs.core.str("The table tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39280 = cljs.core.cst$kw$chart;
var G__39281 = expr__39272;
return (pred__39271.cljs$core$IFn$_invoke$arity$2 ? pred__39271.cljs$core$IFn$_invoke$arity$2(G__39280,G__39281) : pred__39271.call(null,G__39280,G__39281));
})())){
return [cljs.core.str("The charts tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39282 = cljs.core.cst$kw$saved_DASH_charts;
var G__39283 = expr__39272;
return (pred__39271.cljs$core$IFn$_invoke$arity$2 ? pred__39271.cljs$core$IFn$_invoke$arity$2(G__39282,G__39283) : pred__39271.call(null,G__39282,G__39283));
})())){
return [cljs.core.str("The dashboards tab is disabled because "),cljs.core.str("you do not have permission to view it.")].join('');
} else {
return "This tab is disabled.";
}
}
}
}
}
})()
))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_question,"?"], null)], null)], null);
});
hatti.views.dataview_actions.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview39284 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39284 = (function (cursor,owner,meta39285){
this.cursor = cursor;
this.owner = owner;
this.meta39285 = meta39285;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39284.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39286,meta39285__$1){
var self__ = this;
var _39286__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39284(self__.cursor,self__.owner,meta39285__$1));
});

hatti.views.dataview.t_hatti$views$dataview39284.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39286){
var self__ = this;
var _39286__$1 = this;
return self__.meta39285;
});

hatti.views.dataview.t_hatti$views$dataview39284.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39284.prototype.om$core$IRender$render$arity$1 = (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview39284.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39285], null);
});

hatti.views.dataview.t_hatti$views$dataview39284.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39284.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39284";

hatti.views.dataview.t_hatti$views$dataview39284.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39284");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39284 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39284(cursor__$1,owner__$1,meta39285){
return (new hatti.views.dataview.t_hatti$views$dataview39284(cursor__$1,owner__$1,meta39285));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39284(cursor,owner,null));
}));
hatti.views.dataview_infobar.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39287,owner){
var map__39288 = p__39287;
var map__39288__$1 = ((((!((map__39288 == null)))?((((map__39288.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39288.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39288):map__39288);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39288__$1,cljs.core.cst$kw$dataset_DASH_info);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39288__$1,cljs.core.cst$kw$status);
if(typeof hatti.views.dataview.t_hatti$views$dataview39290 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39290 = (function (p__39287,owner,map__39288,dataset_info,status,meta39291){
this.p__39287 = p__39287;
this.owner = owner;
this.map__39288 = map__39288;
this.dataset_info = dataset_info;
this.status = status;
this.meta39291 = meta39291;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39290.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__39288,map__39288__$1,dataset_info,status){
return (function (_39292,meta39291__$1){
var self__ = this;
var _39292__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39290(self__.p__39287,self__.owner,self__.map__39288,self__.dataset_info,self__.status,meta39291__$1));
});})(map__39288,map__39288__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39290.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__39288,map__39288__$1,dataset_info,status){
return (function (_39292){
var self__ = this;
var _39292__$1 = this;
return self__.meta39291;
});})(map__39288,map__39288__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39290.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview39290.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__39288,map__39288__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
return hatti.shared.maybe_merge_languages_BANG_(om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form));
});})(map__39288,map__39288__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39290.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39290.prototype.om$core$IRender$render$arity$1 = ((function (map__39288,map__39288__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var map__39293 = self__.dataset_info;
var map__39293__$1 = ((((!((map__39293 == null)))?((((map__39293.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39293.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39293):map__39293);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39293__$1,cljs.core.cst$kw$num_of_submissions);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39293__$1,cljs.core.cst$kw$formid);
var map__39294 = self__.status;
var map__39294__$1 = ((((!((map__39294 == null)))?((((map__39294.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39294.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39294):map__39294);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39294__$1,cljs.core.cst$kw$loading_QMARK_);
var total_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39294__$1,cljs.core.cst$kw$total_DASH_records);
var G__39301 = ({"className": "right rec-summary rec-margin"});
var G__39302 = (function (){var attrs39297 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))?om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.shared.language_selector,null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39297))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"language-selector"], null),attrs39297], 0))):({"id": "language-selector"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39297))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39297)], null))));
})();
var G__39303 = (function (){var G__39306 = ({"id": "data-status"});
var G__39307 = (function (){var attrs39298 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39298))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs39298], 0))):({"className": "rec"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39298))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39298),sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null))));
})();
return React.DOM.div(G__39306,G__39307);
})();
var G__39304 = (function (){var G__39308 = ({"className": "divider"});
return React.DOM.div(G__39308);
})();
var G__39305 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_actions,formid));
return React.DOM.div(G__39301,G__39302,G__39303,G__39304,G__39305);
});})(map__39288,map__39288__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39290.getBasis = ((function (map__39288,map__39288__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__39287,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__39288,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$status,cljs.core.cst$sym$meta39291], null);
});})(map__39288,map__39288__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39290.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39290.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39290";

hatti.views.dataview.t_hatti$views$dataview39290.cljs$lang$ctorPrWriter = ((function (map__39288,map__39288__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39290");
});})(map__39288,map__39288__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview39290 = ((function (map__39288,map__39288__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview39290(p__39287__$1,owner__$1,map__39288__$2,dataset_info__$1,status__$1,meta39291){
return (new hatti.views.dataview.t_hatti$views$dataview39290(p__39287__$1,owner__$1,map__39288__$2,dataset_info__$1,status__$1,meta39291));
});})(map__39288,map__39288__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview39290(p__39287,owner,map__39288__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Strip off ampersand suffixes then switch to view if result is a valid view
 */
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((function (){var or__6409__auto__ = cljs.core.last(cljs.core.re_find(/(.*?)&/,view));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return view;
}
})());
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_(cljs.core.set(views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$active_DASH_tab,settings_section__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$active_DASH_tab], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$active_DASH_section], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$add_QMARK_,true], null));
} else {
}

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.tabbed_dataview.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview39312 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39312 = (function (app_state,owner,opts,meta39313){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta39313 = meta39313;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39312.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39314,meta39313__$1){
var self__ = this;
var _39314__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39312(self__.app_state,self__.owner,self__.opts,meta39313__$1));
});

hatti.views.dataview.t_hatti$views$dataview39312.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39314){
var self__ = this;
var _39314__$1 = this;
return self__.meta39313;
});

hatti.views.dataview.t_hatti$views$dataview39312.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39312.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var map__39315 = self__.app_state;
var map__39315__$1 = ((((!((map__39315 == null)))?((((map__39315.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39315.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39315):map__39315);
var map__39316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39315__$1,cljs.core.cst$kw$views);
var map__39316__$1 = ((((!((map__39316 == null)))?((((map__39316.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39316.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39316):map__39316);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39316__$1,cljs.core.cst$kw$active);
var disabled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39316__$1,cljs.core.cst$kw$disabled);
var selected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39316__$1,cljs.core.cst$kw$selected);
var is_encrypted_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39315__$1,cljs.core.cst$kw$is_DASH_encrypted_QMARK_);
var is_within_pricing_limits_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39315__$1,cljs.core.cst$kw$is_DASH_within_DASH_pricing_DASH_limits_QMARK_);
var view__GT_display = ((function (map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1){
return (function (p1__39309_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__39309_SHARP_)){
return "block";
} else {
return "none";
}
});})(map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1))
;
var view__GT_cls = ((function (map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1){
return (function (p1__39310_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__39310_SHARP_)){
return "clicked";
} else {
return null;
}
});})(map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1))
;
var dataviews = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.view_state) : cljs.core.deref.call(null,hatti.views.dataview.view_state)),cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p__39319){
var map__39320 = p__39319;
var map__39320__$1 = ((((!((map__39320 == null)))?((((map__39320.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39320.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39320):map__39320);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39320__$1,cljs.core.cst$kw$view);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39320__$1,cljs.core.cst$kw$label);
if(cljs.core.truth_((function (){var and__6397__auto__ = cljs.core.some(((function (map__39320,map__39320__$1,view,label,map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p1__39311_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,p1__39311_SHARP_);
});})(map__39320,map__39320__$1,view,label,map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
,active);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not(chimera.seq.in_QMARK_(disabled,view));
} else {
return and__6397__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,view__GT_cls(view),cljs.core.cst$kw$href,[cljs.core.str("#/"),cljs.core.str(cljs.core.name(view))].join('')], null),label], null);
} else {
return hatti.views.dataview.view__GT_inactive_tab(view,label,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_);
}
});})(map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
;
var G__39323 = ({"className": "tab-container dataset-tabs"});
var G__39324 = (function (){var attrs39322 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(dv__GT_link,dataviews);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39322))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs39322], 0))):({"className": "tab-bar"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39322))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39322),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})();
var G__39325 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__39323,G__39324,map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function hatti$views$dataview$iter__39326(s__39327){
return (new cljs.core.LazySeq(null,((function (G__39323,G__39324,map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function (){
var s__39327__$1 = s__39327;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39327__$1);
if(temp__4657__auto__){
var s__39327__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39327__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39327__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39329 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39328 = (0);
while(true){
if((i__39328 < size__7188__auto__)){
var map__39340 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39328);
var map__39340__$1 = ((((!((map__39340 == null)))?((((map__39340.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39340.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39340):map__39340);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39340__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39340__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
cljs.core.chunk_append(b__39329,(function (){var G__39342 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__39343 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__39342,G__39343);
})());

var G__39348 = (i__39328 + (1));
i__39328 = G__39348;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39329),hatti$views$dataview$iter__39326(cljs.core.chunk_rest(s__39327__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39329),null);
}
} else {
var map__39344 = cljs.core.first(s__39327__$2);
var map__39344__$1 = ((((!((map__39344 == null)))?((((map__39344.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39344.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39344):map__39344);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39344__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39344__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
return cljs.core.cons((function (){var G__39346 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__39347 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__39346,G__39347);
})(),hatti$views$dataview$iter__39326(cljs.core.rest(s__39327__$2)));
}
} else {
return null;
}
break;
}
});})(G__39323,G__39324,map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
,null,null));
});})(G__39323,G__39324,map__39315,map__39315__$1,map__39316,map__39316__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
;
return iter__7189__auto__(dataviews);
})());
return React.DOM.div(G__39323,G__39324,G__39325);
});

hatti.views.dataview.t_hatti$views$dataview39312.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta39313], null);
});

hatti.views.dataview.t_hatti$views$dataview39312.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39312.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39312";

hatti.views.dataview.t_hatti$views$dataview39312.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39312");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39312 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39312(app_state__$1,owner__$1,opts__$1,meta39313){
return (new hatti.views.dataview.t_hatti$views$dataview39312(app_state__$1,owner__$1,opts__$1,meta39313));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39312(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
