// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.record');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('hatti.shared');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('clojure.string');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.urls');
/**
 * Wrap-with produces a partial to wrap a set of children.
 * ((wrap-with :div) 1 2 3) => [:div [1 2 3]]
 * ((wrap-with [:div {:class 0}]) 1 2 3) => [:div {:class 0} [1 2 3]]
 */
hatti.views.record.wrap_with = (function hatti$views$record$wrap_with(root){
return (function() { 
var G__35389__delegate = function (children){
if((root instanceof cljs.core.Keyword)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),children);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(root,children);
}
};
var G__35389 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__35390__i = 0, G__35390__a = new Array(arguments.length -  0);
while (G__35390__i < G__35390__a.length) {G__35390__a[G__35390__i] = arguments[G__35390__i + 0]; ++G__35390__i;}
  children = new cljs.core.IndexedSeq(G__35390__a,0);
} 
return G__35389__delegate.call(this,children);};
G__35389.cljs$lang$maxFixedArity = 0;
G__35389.cljs$lang$applyTo = (function (arglist__35391){
var children = cljs.core.seq(arglist__35391);
return G__35389__delegate(children);
});
G__35389.cljs$core$IFn$_invoke$arity$variadic = G__35389__delegate;
return G__35389;
})()
;
});
hatti.views.record.submission_arrow = (function hatti$views$record$submission_arrow(dir,cur_rank,view){
var icon = [cljs.core.str("fa fa-arrow-"),cljs.core.str(cljs.core.name(dir))].join('');
var new_rank = (function (){var G__35400 = (((dir instanceof cljs.core.Keyword))?dir.fqn:null);
switch (G__35400) {
case "left":
return cljs.core.dec;

break;
case "right":
return cljs.core.inc;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(dir)].join('')));

}
})().call(null,cur_rank);
var event_key = (function (){var pred__35401 = cljs.core._EQ_;
var expr__35402 = view;
if(cljs.core.truth_((function (){var G__35404 = cljs.core.cst$kw$map;
var G__35405 = expr__35402;
return (pred__35401.cljs$core$IFn$_invoke$arity$2 ? pred__35401.cljs$core$IFn$_invoke$arity$2(G__35404,G__35405) : pred__35401.call(null,G__35404,G__35405));
})())){
return cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank;
} else {
if(cljs.core.truth_((function (){var G__35406 = cljs.core.cst$kw$table;
var G__35407 = expr__35402;
return (pred__35401.cljs$core$IFn$_invoke$arity$2 ? pred__35401.cljs$core$IFn$_invoke$arity$2(G__35406,G__35407) : pred__35401.call(null,G__35406,G__35407));
})())){
return cljs.core.cst$kw$submission_DASH_to_DASH_rank;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__35402)].join('')));
}
}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$pure_DASH_button$btn_DASH_default,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (icon,new_rank,event_key){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,cljs.core.PersistentArrayMap.fromArray([event_key,new_rank], true, false));
});})(icon,new_rank,event_key))
),cljs.core.cst$kw$href,"#"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,icon], null)], null)], null);
});
hatti.views.record.submission_closer = (function hatti$views$record$submission_closer(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$btn_DASH_close$right,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn((function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_unclicked,true], null));
})),cljs.core.cst$kw$href,"#"], null),"\u00D7"], null);
});
hatti.views.print_xls_report_btn.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.record.t_hatti$views$record35409 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record35409 = (function (cursor,owner,meta35410){
this.cursor = cursor;
this.owner = owner;
this.meta35410 = meta35410;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record35409.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35411,meta35410__$1){
var self__ = this;
var _35411__$1 = this;
return (new hatti.views.record.t_hatti$views$record35409(self__.cursor,self__.owner,meta35410__$1));
});

hatti.views.record.t_hatti$views$record35409.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35411){
var self__ = this;
var _35411__$1 = this;
return self__.meta35410;
});

hatti.views.record.t_hatti$views$record35409.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record35409.prototype.om$core$IRender$render$arity$1 = (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
var G__35414 = ({"id": "print-xls-report"});
return React.DOM.div(G__35414);
});

hatti.views.record.t_hatti$views$record35409.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta35410], null);
});

hatti.views.record.t_hatti$views$record35409.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record35409.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record35409";

hatti.views.record.t_hatti$views$record35409.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record35409");
});

hatti.views.record.__GT_t_hatti$views$record35409 = (function hatti$views$record$__GT_t_hatti$views$record35409(cursor__$1,owner__$1,meta35410){
return (new hatti.views.record.t_hatti$views$record35409(cursor__$1,owner__$1,meta35410));
});

}

return (new hatti.views.record.t_hatti$views$record35409(cursor,owner,null));
}));
hatti.views.record.qa_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$div$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$span$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$span$answer], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$row_DASH_el,cljs.core.cst$kw$tr$question_DASH_answer,cljs.core.cst$kw$question_DASH_el,cljs.core.cst$kw$td$question,cljs.core.cst$kw$answer_DASH_el,cljs.core.cst$kw$td$answer], null)], null);
hatti.views.record.format_as_question_answer = (function hatti$views$record$format_as_question_answer(view,field,data,lang){
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(field);
var flabel = hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([lang], 0));
var answer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,fname);
var alabel = hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,answer,cljs.core.array_seq([cljs.core.cst$kw$language,lang], 0));
var map__35417 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(view) : hatti.views.record.qa_elements.call(null,view));
var map__35417__$1 = ((((!((map__35417 == null)))?((((map__35417.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35417.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35417):map__35417);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35417__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35417__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35417__$1,cljs.core.cst$kw$answer_DASH_el);
if(cljs.core.truth_((function (){var and__6397__auto__ = alabel;
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(alabel,hatti.ona.forms.no_answer);
} else {
return and__6397__auto__;
}
})())){
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.repeat_view,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data,answer,cljs.core.cst$kw$repeat_DASH_field,field,cljs.core.cst$kw$lang,lang], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,view], null)], null));
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,flabel], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,alabel], null)], null);
}
} else {
return null;
}
});
hatti.views.record.submission_elements = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$legend$infobar$submission$top$right),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$legend_DASH_topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom$submission_DASH_header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$submission$info_DASH_scroll),cljs.core.cst$kw$section_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$border_DASH_bottom),cljs.core.cst$kw$h4_DASH_cls,"t-red"], null),cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$top_DASH_level_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$widget_DASH_info_SHARP_single_DASH_submission_DASH_info),cljs.core.cst$kw$topbar_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$topbar),cljs.core.cst$kw$header_DASH_wrap,hatti.views.record.wrap_with(cljs.core.cst$kw$div$header),cljs.core.cst$kw$submission_DASH_info_DASH_wrap,(function() { 
var G__35419__delegate = function (tbody){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$submission,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$pure_DASH_table$pure_DASH_table_DASH_bordered,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Question"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Response"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,tbody], null)], null)], null);
};
var G__35419 = function (var_args){
var tbody = null;
if (arguments.length > 0) {
var G__35420__i = 0, G__35420__a = new Array(arguments.length -  0);
while (G__35420__i < G__35420__a.length) {G__35420__a[G__35420__i] = arguments[G__35420__i + 0]; ++G__35420__i;}
  tbody = new cljs.core.IndexedSeq(G__35420__a,0);
} 
return G__35419__delegate.call(this,tbody);};
G__35419.cljs$lang$maxFixedArity = 0;
G__35419.cljs$lang$applyTo = (function (arglist__35421){
var tbody = cljs.core.seq(arglist__35421);
return G__35419__delegate(tbody);
});
G__35419.cljs$core$IFn$_invoke$arity$variadic = G__35419__delegate;
return G__35419;
})()
,cljs.core.cst$kw$section_DASH_wrap,cljs.core.identity,cljs.core.cst$kw$show_DASH_instance_DASH_id,true,cljs.core.cst$kw$h4_DASH_cls,""], null)], null);
hatti.views.repeat_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__35423,owner,p__35424){
var map__35425 = p__35423;
var map__35425__$1 = ((((!((map__35425 == null)))?((((map__35425.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35425.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35425):map__35425);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35425__$1,cljs.core.cst$kw$data);
var repeat_field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35425__$1,cljs.core.cst$kw$repeat_DASH_field);
var lang = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35425__$1,cljs.core.cst$kw$lang);
var map__35426 = p__35424;
var map__35426__$1 = ((((!((map__35426 == null)))?((((map__35426.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35426.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35426):map__35426);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35426__$1,cljs.core.cst$kw$view);

if(typeof hatti.views.record.t_hatti$views$record35429 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record35429 = (function (p__35423,owner,p__35424,map__35425,data,repeat_field,lang,map__35426,view,meta35430){
this.p__35423 = p__35423;
this.owner = owner;
this.p__35424 = p__35424;
this.map__35425 = map__35425;
this.data = data;
this.repeat_field = repeat_field;
this.lang = lang;
this.map__35426 = map__35426;
this.view = view;
this.meta35430 = meta35430;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record35429.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (_35431,meta35430__$1){
var self__ = this;
var _35431__$1 = this;
return (new hatti.views.record.t_hatti$views$record35429(self__.p__35423,self__.owner,self__.p__35424,self__.map__35425,self__.data,self__.repeat_field,self__.lang,self__.map__35426,self__.view,meta35430__$1));
});})(map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;

hatti.views.record.t_hatti$views$record35429.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (_35431){
var self__ = this;
var _35431__$1 = this;
return self__.meta35430;
});})(map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;

hatti.views.record.t_hatti$views$record35429.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record35429.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$collapsed_QMARK_,true], null);
});})(map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;

hatti.views.record.t_hatti$views$record35429.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record35429.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (_,p__35432){
var self__ = this;
var map__35433 = p__35432;
var map__35433__$1 = ((((!((map__35433 == null)))?((((map__35433.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35433.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35433):map__35433);
var collapsed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35433__$1,cljs.core.cst$kw$collapsed_QMARK_);
var ___$1 = this;
if(cljs.core.seq(self__.data)){
var collapse_BANG_ = ((function (___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (p1__35422_SHARP_){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$collapsed_QMARK_,p1__35422_SHARP_);
});})(___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;
var map__35435 = (hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.qa_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.qa_elements.call(null,self__.view));
var map__35435__$1 = ((((!((map__35435 == null)))?((((map__35435.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35435.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35435):map__35435);
var row_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35435__$1,cljs.core.cst$kw$row_DASH_el);
var question_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35435__$1,cljs.core.cst$kw$question_DASH_el);
var answer_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35435__$1,cljs.core.cst$kw$answer_DASH_el);
var header = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [row_el,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [question_el,hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(self__.repeat_field,cljs.core.array_seq([self__.lang], 0))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [answer_el,[cljs.core.str(hatti.utils.pluralize_number(cljs.core.count(self__.data)," Repeat")),cljs.core.str(" - ")].join(''),(cljs.core.truth_(collapsed_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (){
return collapse_BANG_(false);
});})(collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Show Repeats"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (){
return collapse_BANG_(true);
});})(collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
),cljs.core.cst$kw$href,"#"], null),"Hide Repeats"], null))], null)], null);
var fname = cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(self__.repeat_field);
var render_child = ((function (collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (d){
var iter__7189__auto__ = ((function (collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function hatti$views$record$iter__35437(s__35438){
return (new cljs.core.LazySeq(null,((function (collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (){
var s__35438__$1 = s__35438;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35438__$1);
if(temp__4657__auto__){
var s__35438__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35438__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35438__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35440 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35439 = (0);
while(true){
if((i__35439 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35439);
cljs.core.chunk_append(b__35440,hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang));

var G__35456 = (i__35439 + (1));
i__35439 = G__35456;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35440),hatti$views$record$iter__35437(cljs.core.chunk_rest(s__35438__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35440),null);
}
} else {
var field = cljs.core.first(s__35438__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,field,d,self__.lang),hatti$views$record$iter__35437(cljs.core.rest(s__35438__$2)));
}
} else {
return null;
}
break;
}
});})(collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
,null,null));
});})(collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;
return iter__7189__auto__(cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(self__.repeat_field));
});})(collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;
var tbl = ((function (collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function() { 
var G__35457__delegate = function (cls,body){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$no_DASH_pad,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(2)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cls], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,body], null)], null)], null)], null);
};
var G__35457 = function (cls,var_args){
var body = null;
if (arguments.length > 1) {
var G__35458__i = 0, G__35458__a = new Array(arguments.length -  1);
while (G__35458__i < G__35458__a.length) {G__35458__a[G__35458__i] = arguments[G__35458__i + 1]; ++G__35458__i;}
  body = new cljs.core.IndexedSeq(G__35458__a,0);
} 
return G__35457__delegate.call(this,cls,body);};
G__35457.cljs$lang$maxFixedArity = 1;
G__35457.cljs$lang$applyTo = (function (arglist__35459){
var cls = cljs.core.first(arglist__35459);
var body = cljs.core.rest(arglist__35459);
return G__35457__delegate(cls,body);
});
G__35457.cljs$core$IFn$_invoke$arity$variadic = G__35457__delegate;
return G__35457;
})()
;})(collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,render_child,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;
if(cljs.core.truth_(collapsed_QMARK_)){
return sablono.interpreter.interpret(header);
} else {
return sablono.interpreter.interpret((function (){var G__35443 = (((self__.view instanceof cljs.core.Keyword))?self__.view.fqn:null);
switch (G__35443) {
case "map":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$repeat_DASH_block,header,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol$repeat,(function (){var iter__7189__auto__ = ((function (G__35443,collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function hatti$views$record$iter__35444(s__35445){
return (new cljs.core.LazySeq(null,((function (G__35443,collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (){
var s__35445__$1 = s__35445;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35445__$1);
if(temp__4657__auto__){
var s__35445__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35445__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35445__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35447 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35446 = (0);
while(true){
if((i__35446 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35446);
cljs.core.chunk_append(b__35447,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null));

var G__35461 = (i__35446 + (1));
i__35446 = G__35461;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35447),hatti$views$record$iter__35444(cljs.core.chunk_rest(s__35445__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35447),null);
}
} else {
var d = cljs.core.first(s__35445__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,render_child(d)], null),hatti$views$record$iter__35444(cljs.core.rest(s__35445__$2)));
}
} else {
return null;
}
break;
}
});})(G__35443,collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
,null,null));
});})(G__35443,collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;
return iter__7189__auto__(self__.data);
})()], null)], null);

break;
case "table":
return tbl.cljs$core$IFn$_invoke$arity$variadic("repeat-block",cljs.core.array_seq([header,(function (){var iter__7189__auto__ = ((function (G__35443,collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function hatti$views$record$iter__35450(s__35451){
return (new cljs.core.LazySeq(null,((function (G__35443,collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (){
var s__35451__$1 = s__35451;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35451__$1);
if(temp__4657__auto__){
var s__35451__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35451__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35451__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35453 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35452 = (0);
while(true){
if((i__35452 < size__7188__auto__)){
var d = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35452);
cljs.core.chunk_append(b__35453,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null));

var G__35462 = (i__35452 + (1));
i__35452 = G__35462;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35453),hatti$views$record$iter__35450(cljs.core.chunk_rest(s__35451__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35453),null);
}
} else {
var d = cljs.core.first(s__35451__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody$repeat,render_child(d)], null),hatti$views$record$iter__35450(cljs.core.rest(s__35451__$2)));
}
} else {
return null;
}
break;
}
});})(G__35443,collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
,null,null));
});})(G__35443,collapse_BANG_,map__35435,map__35435__$1,row_el,question_el,answer_el,header,fname,render_child,tbl,___$1,map__35433,map__35433__$1,collapsed_QMARK_,map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;
return iter__7189__auto__(self__.data);
})()], 0));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(self__.view)].join('')));

}
})());
}
} else {
return null;
}
});})(map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;

hatti.views.record.t_hatti$views$record35429.getBasis = ((function (map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__35423,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__35424,cljs.core.cst$sym$map__35425,cljs.core.cst$sym$data,cljs.core.cst$sym$repeat_DASH_field,cljs.core.cst$sym$lang,cljs.core.cst$sym$map__35426,cljs.core.cst$sym$view,cljs.core.cst$sym$meta35430], null);
});})(map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;

hatti.views.record.t_hatti$views$record35429.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record35429.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record35429";

hatti.views.record.t_hatti$views$record35429.cljs$lang$ctorPrWriter = ((function (map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record35429");
});})(map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;

hatti.views.record.__GT_t_hatti$views$record35429 = ((function (map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view){
return (function hatti$views$record$__GT_t_hatti$views$record35429(p__35423__$1,owner__$1,p__35424__$1,map__35425__$2,data__$1,repeat_field__$1,lang__$1,map__35426__$2,view__$1,meta35430){
return (new hatti.views.record.t_hatti$views$record35429(p__35423__$1,owner__$1,p__35424__$1,map__35425__$2,data__$1,repeat_field__$1,lang__$1,map__35426__$2,view__$1,meta35430));
});})(map__35425,map__35425__$1,data,repeat_field,lang,map__35426,map__35426__$1,view))
;

}

return (new hatti.views.record.t_hatti$views$record35429(p__35423,owner,p__35424,map__35425__$1,data,repeat_field,lang,map__35426__$1,view,cljs.core.PersistentArrayMap.EMPTY));
}));
hatti.views.record.header_note = (function hatti$views$record$header_note(view,p__35463){
var map__35466 = p__35463;
var map__35466__$1 = ((((!((map__35466 == null)))?((((map__35466.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35466.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35466):map__35466);
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35466__$1,cljs.core.cst$kw$geofield);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35466__$1,cljs.core.cst$kw$data);
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$map)) && (cljs.core.not(cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$no_DASH_geo$t_DASH_normal$right,"No geodata"], null);
} else {
return null;
}
});
hatti.views.edit_delete.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (instance_id,owner,p__35468){
var map__35469 = p__35468;
var map__35469__$1 = ((((!((map__35469 == null)))?((((map__35469.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35469.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35469):map__35469);
var delete_record_BANG_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35469__$1,cljs.core.cst$kw$delete_DASH_record_BANG_);
if(typeof hatti.views.record.t_hatti$views$record35471 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record35471 = (function (instance_id,owner,p__35468,map__35469,delete_record_BANG_,meta35472){
this.instance_id = instance_id;
this.owner = owner;
this.p__35468 = p__35468;
this.map__35469 = map__35469;
this.delete_record_BANG_ = delete_record_BANG_;
this.meta35472 = meta35472;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record35471.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__35469,map__35469__$1,delete_record_BANG_){
return (function (_35473,meta35472__$1){
var self__ = this;
var _35473__$1 = this;
return (new hatti.views.record.t_hatti$views$record35471(self__.instance_id,self__.owner,self__.p__35468,self__.map__35469,self__.delete_record_BANG_,meta35472__$1));
});})(map__35469,map__35469__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record35471.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__35469,map__35469__$1,delete_record_BANG_){
return (function (_35473){
var self__ = this;
var _35473__$1 = this;
return self__.meta35472;
});})(map__35469,map__35469__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record35471.prototype.om$core$IRender$ = true;

hatti.views.record.t_hatti$views$record35471.prototype.om$core$IRender$render$arity$1 = ((function (map__35469,map__35469__$1,delete_record_BANG_){
return (function (this__19159__auto__){
var self__ = this;
var this__19159__auto____$1 = this;
return null;
});})(map__35469,map__35469__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record35471.getBasis = ((function (map__35469,map__35469__$1,delete_record_BANG_){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$instance_DASH_id,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__35468,cljs.core.cst$sym$map__35469,cljs.core.cst$sym$delete_DASH_record_BANG_,cljs.core.cst$sym$meta35472], null);
});})(map__35469,map__35469__$1,delete_record_BANG_))
;

hatti.views.record.t_hatti$views$record35471.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record35471.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record35471";

hatti.views.record.t_hatti$views$record35471.cljs$lang$ctorPrWriter = ((function (map__35469,map__35469__$1,delete_record_BANG_){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record35471");
});})(map__35469,map__35469__$1,delete_record_BANG_))
;

hatti.views.record.__GT_t_hatti$views$record35471 = ((function (map__35469,map__35469__$1,delete_record_BANG_){
return (function hatti$views$record$__GT_t_hatti$views$record35471(instance_id__$1,owner__$1,p__35468__$1,map__35469__$2,delete_record_BANG___$1,meta35472){
return (new hatti.views.record.t_hatti$views$record35471(instance_id__$1,owner__$1,p__35468__$1,map__35469__$2,delete_record_BANG___$1,meta35472));
});})(map__35469,map__35469__$1,delete_record_BANG_))
;

}

return (new hatti.views.record.t_hatti$views$record35471(instance_id,owner,p__35468,map__35469__$1,delete_record_BANG_,null));
}));
hatti.views.submission_view.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner,p__35474){
var map__35475 = p__35474;
var map__35475__$1 = ((((!((map__35475 == null)))?((((map__35475.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35475.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35475):map__35475);
var opts = map__35475__$1;
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35475__$1,cljs.core.cst$kw$view);
if(typeof hatti.views.record.t_hatti$views$record35477 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.record.t_hatti$views$record35477 = (function (cursor,owner,p__35474,map__35475,opts,view,meta35478){
this.cursor = cursor;
this.owner = owner;
this.p__35474 = p__35474;
this.map__35475 = map__35475;
this.opts = opts;
this.view = view;
this.meta35478 = meta35478;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.record.t_hatti$views$record35477.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__35475,map__35475__$1,opts,view){
return (function (_35479,meta35478__$1){
var self__ = this;
var _35479__$1 = this;
return (new hatti.views.record.t_hatti$views$record35477(self__.cursor,self__.owner,self__.p__35474,self__.map__35475,self__.opts,self__.view,meta35478__$1));
});})(map__35475,map__35475__$1,opts,view))
;

hatti.views.record.t_hatti$views$record35477.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__35475,map__35475__$1,opts,view){
return (function (_35479){
var self__ = this;
var _35479__$1 = this;
return self__.meta35478;
});})(map__35475,map__35475__$1,opts,view))
;

hatti.views.record.t_hatti$views$record35477.prototype.om$core$IInitState$ = true;

hatti.views.record.t_hatti$views$record35477.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__35475,map__35475__$1,opts,view){
return (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$expand_DASH_meta_QMARK_,false], null);
});})(map__35475,map__35475__$1,opts,view))
;

hatti.views.record.t_hatti$views$record35477.prototype.om$core$IRenderState$ = true;

hatti.views.record.t_hatti$views$record35477.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__35475,map__35475__$1,opts,view){
return (function (_,p__35480){
var self__ = this;
var map__35481 = p__35480;
var map__35481__$1 = ((((!((map__35481 == null)))?((((map__35481.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35481.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35481):map__35481);
var expand_meta_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35481__$1,cljs.core.cst$kw$expand_DASH_meta_QMARK_);
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flat_DASH_form], null));
var language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var map__35483 = self__.cursor;
var map__35483__$1 = ((((!((map__35483 == null)))?((((map__35483.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35483.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35483):map__35483);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35483__$1,cljs.core.cst$kw$id);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35483__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35483__$1,cljs.core.cst$kw$dataset_DASH_info);
var cur_rank = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,hatti.constants._rank);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_id");
var sdatetime = (function (){var G__35486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data,"_submission_time");
return moment(G__35486);
})();
var map__35484 = (hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1 ? hatti.views.record.submission_elements.cljs$core$IFn$_invoke$arity$1(self__.view) : hatti.views.record.submission_elements.call(null,self__.view));
var map__35484__$1 = ((((!((map__35484 == null)))?((((map__35484.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35484.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35484):map__35484);
var top_level_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35484__$1,cljs.core.cst$kw$top_DASH_level_DASH_wrap);
var topbar_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35484__$1,cljs.core.cst$kw$topbar_DASH_wrap);
var header_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35484__$1,cljs.core.cst$kw$header_DASH_wrap);
var section_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35484__$1,cljs.core.cst$kw$section_DASH_wrap);
var submission_info_wrap = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35484__$1,cljs.core.cst$kw$submission_DASH_info_DASH_wrap);
var h4_cls = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35484__$1,cljs.core.cst$kw$h4_DASH_cls);
return sablono.interpreter.interpret((cljs.core.truth_((function (){var or__6409__auto__ = data;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id;
}
})())?(function (){var G__35488 = (function (){var G__35490 = hatti.views.record.submission_arrow(cljs.core.cst$kw$left,cur_rank,self__.view);
var G__35491 = hatti.views.record.submission_arrow(cljs.core.cst$kw$right,cur_rank,self__.view);
var G__35492 = om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.print_xls_report_btn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$instance_DASH_id,instance_id,cljs.core.cst$kw$dataset_DASH_info,dataset_info], null));
var G__35493 = hatti.views.record.submission_closer();
return (topbar_wrap.cljs$core$IFn$_invoke$arity$4 ? topbar_wrap.cljs$core$IFn$_invoke$arity$4(G__35490,G__35491,G__35492,G__35493) : topbar_wrap.call(null,G__35490,G__35491,G__35492,G__35493));
})();
var G__35489 = (cljs.core.truth_(data)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,(function (){var G__35494 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,h4_cls], null),[cljs.core.str("ID: "),cljs.core.str(instance_id)].join(''),hatti.views.record.header_note(self__.view,self__.cursor)], null);
var G__35495 = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,[cljs.core.str("Submitted at "),cljs.core.str(sdatetime.format("LT")),cljs.core.str(" on "),cljs.core.str(sdatetime.format("ll"))].join(''),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.edit_delete,instance_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$expand_DASH_meta$right,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (G__35494,G__35488,form,language,map__35483,map__35483__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35484,map__35484__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35481,map__35481__$1,expand_meta_QMARK_,map__35475,map__35475__$1,opts,view){
return (function (){
return om.core.update_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$expand_DASH_meta_QMARK_,cljs.core.not);
});})(G__35494,G__35488,form,language,map__35483,map__35483__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35484,map__35484__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35481,map__35481__$1,expand_meta_QMARK_,map__35475,map__35475__$1,opts,view))
)], null),(cljs.core.truth_(expand_meta_QMARK_)?"Hide Metadata":"Show Metadata")], null)], null)], null);
return (header_wrap.cljs$core$IFn$_invoke$arity$2 ? header_wrap.cljs$core$IFn$_invoke$arity$2(G__35494,G__35495) : header_wrap.call(null,G__35494,G__35495));
})(),(function (){var G__35496 = (cljs.core.truth_(expand_meta_QMARK_)?(function (){var G__35498 = (function (){var iter__7189__auto__ = ((function (G__35488,form,language,map__35483,map__35483__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35484,map__35484__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35481,map__35481__$1,expand_meta_QMARK_,map__35475,map__35475__$1,opts,view){
return (function hatti$views$record$iter__35499(s__35500){
return (new cljs.core.LazySeq(null,((function (G__35488,form,language,map__35483,map__35483__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35484,map__35484__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35481,map__35481__$1,expand_meta_QMARK_,map__35475,map__35475__$1,opts,view){
return (function (){
var s__35500__$1 = s__35500;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35500__$1);
if(temp__4657__auto__){
var s__35500__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35500__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35500__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35502 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35501 = (0);
while(true){
if((i__35501 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35501);
cljs.core.chunk_append(b__35502,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__35512 = (i__35501 + (1));
i__35501 = G__35512;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35502),hatti$views$record$iter__35499(cljs.core.chunk_rest(s__35500__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35502),null);
}
} else {
var q = cljs.core.first(s__35500__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__35499(cljs.core.rest(s__35500__$2)));
}
} else {
return null;
}
break;
}
});})(G__35488,form,language,map__35483,map__35483__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35484,map__35484__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35481,map__35481__$1,expand_meta_QMARK_,map__35475,map__35475__$1,opts,view))
,null,null));
});})(G__35488,form,language,map__35483,map__35483__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35484,map__35484__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35481,map__35481__$1,expand_meta_QMARK_,map__35475,map__35475__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0)));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__35498) : section_wrap.call(null,G__35498));
})():null);
var G__35497 = (function (){var G__35505 = (function (){var iter__7189__auto__ = ((function (G__35496,G__35488,form,language,map__35483,map__35483__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35484,map__35484__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35481,map__35481__$1,expand_meta_QMARK_,map__35475,map__35475__$1,opts,view){
return (function hatti$views$record$iter__35506(s__35507){
return (new cljs.core.LazySeq(null,((function (G__35496,G__35488,form,language,map__35483,map__35483__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35484,map__35484__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35481,map__35481__$1,expand_meta_QMARK_,map__35475,map__35475__$1,opts,view){
return (function (){
var s__35507__$1 = s__35507;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35507__$1);
if(temp__4657__auto__){
var s__35507__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35507__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35507__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35509 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35508 = (0);
while(true){
if((i__35508 < size__7188__auto__)){
var q = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35508);
cljs.core.chunk_append(b__35509,hatti.views.record.format_as_question_answer(self__.view,q,data,language));

var G__35513 = (i__35508 + (1));
i__35508 = G__35513;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35509),hatti$views$record$iter__35506(cljs.core.chunk_rest(s__35507__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35509),null);
}
} else {
var q = cljs.core.first(s__35507__$2);
return cljs.core.cons(hatti.views.record.format_as_question_answer(self__.view,q,data,language),hatti$views$record$iter__35506(cljs.core.rest(s__35507__$2)));
}
} else {
return null;
}
break;
}
});})(G__35496,G__35488,form,language,map__35483,map__35483__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35484,map__35484__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35481,map__35481__$1,expand_meta_QMARK_,map__35475,map__35475__$1,opts,view))
,null,null));
});})(G__35496,G__35488,form,language,map__35483,map__35483__$1,id,data,dataset_info,cur_rank,instance_id,sdatetime,map__35484,map__35484__$1,top_level_wrap,topbar_wrap,header_wrap,section_wrap,submission_info_wrap,h4_cls,___$1,map__35481,map__35481__$1,expand_meta_QMARK_,map__35475,map__35475__$1,opts,view))
;
return iter__7189__auto__(hatti.ona.forms.non_meta_fields(form));
})();
return (section_wrap.cljs$core$IFn$_invoke$arity$1 ? section_wrap.cljs$core$IFn$_invoke$arity$1(G__35505) : section_wrap.call(null,G__35505));
})();
return (submission_info_wrap.cljs$core$IFn$_invoke$arity$2 ? submission_info_wrap.cljs$core$IFn$_invoke$arity$2(G__35496,G__35497) : submission_info_wrap.call(null,G__35496,G__35497));
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_center,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null),"Loading data..."], null)], null));
return (top_level_wrap.cljs$core$IFn$_invoke$arity$2 ? top_level_wrap.cljs$core$IFn$_invoke$arity$2(G__35488,G__35489) : top_level_wrap.call(null,G__35488,G__35489));
})():null));
});})(map__35475,map__35475__$1,opts,view))
;

hatti.views.record.t_hatti$views$record35477.getBasis = ((function (map__35475,map__35475__$1,opts,view){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$p__35474,cljs.core.cst$sym$map__35475,cljs.core.cst$sym$opts,cljs.core.cst$sym$view,cljs.core.cst$sym$meta35478], null);
});})(map__35475,map__35475__$1,opts,view))
;

hatti.views.record.t_hatti$views$record35477.cljs$lang$type = true;

hatti.views.record.t_hatti$views$record35477.cljs$lang$ctorStr = "hatti.views.record/t_hatti$views$record35477";

hatti.views.record.t_hatti$views$record35477.cljs$lang$ctorPrWriter = ((function (map__35475,map__35475__$1,opts,view){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.record/t_hatti$views$record35477");
});})(map__35475,map__35475__$1,opts,view))
;

hatti.views.record.__GT_t_hatti$views$record35477 = ((function (map__35475,map__35475__$1,opts,view){
return (function hatti$views$record$__GT_t_hatti$views$record35477(cursor__$1,owner__$1,p__35474__$1,map__35475__$2,opts__$1,view__$1,meta35478){
return (new hatti.views.record.t_hatti$views$record35477(cursor__$1,owner__$1,p__35474__$1,map__35475__$2,opts__$1,view__$1,meta35478));
});})(map__35475,map__35475__$1,opts,view))
;

}

return (new hatti.views.record.t_hatti$views$record35477(cursor,owner,p__35474,map__35475__$1,opts,view,cljs.core.PersistentArrayMap.EMPTY));
}));
