// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),true))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__25319_SHARP_){
if(typeof p1__25319_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__25319_SHARP_);
} else {
return p1__25319_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__25325){
var vec__25326 = p__25325;
var fname = cljs.core.nth.call(null,vec__25326,(0),null);
var answer = cljs.core.nth.call(null,vec__25326,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__25320_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__25320_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,chimera.string.escape_for_type.call(null,clj_value),new cljs.core.Keyword(null,"language","language",-1591107564),language,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true,new cljs.core.Keyword(null,"field-key","field-key",313262601),field_key);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__25329 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__25329__$1 = ((((!((map__25329 == null)))?((((map__25329.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25329.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25329):map__25329);
var owner__$1 = cljs.core.get.call(null,map__25329__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__25329__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__25329__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input.delete-record","input.delete-record",-1708576930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip.middle-right","li.tooltip.middle-right",-548323211),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-eye","i.fa.fa-eye",-1428531423),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil","i.fa.fa-pencil",1547895857)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___25358 = arguments.length;
var i__7485__auto___25359 = (0);
while(true){
if((i__7485__auto___25359 < len__7484__auto___25358)){
args__7491__auto__.push((arguments[i__7485__auto___25359]));

var G__25360 = (i__7485__auto___25359 + (1));
i__7485__auto___25359 = G__25360;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__25334){
var map__25335 = p__25334;
var map__25335__$1 = ((((!((map__25335 == null)))?((((map__25335.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25335.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25335):map__25335);
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25335__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var get_label_QMARK_ = cljs.core.get.call(null,map__25335__$1,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),true);
var language = cljs.core.get.call(null,map__25335__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var owner = cljs.core.get.call(null,map__25335__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = chimera.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__25335,map__25335__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__25331_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__25331_SHARP_)) == null);
});})(map__25335,map__25335__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__25335,map__25335__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__25337(s__25338){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__25335,map__25335__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__25338__$1 = s__25338;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25338__$1);
if(temp__4657__auto__){
var s__25338__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25338__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25338__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25340 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25339 = (0);
while(true){
if((i__25339 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__25339);
cljs.core.chunk_append.call(null,b__25340,(function (){var map__25349 = field;
var map__25349__$1 = ((((!((map__25349 == null)))?((((map__25349.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25349.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25349):map__25349);
var map__25350 = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25350__$1 = ((((!((map__25350 == null)))?((((map__25350.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25350.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25350):map__25350);
var hxl = cljs.core.get.call(null,map__25350__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25349__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__25361 = (i__25339 + (1));
i__25339 = G__25361;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25340),hatti$views$table$iter__25337.call(null,cljs.core.chunk_rest.call(null,s__25338__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25340),null);
}
} else {
var field = cljs.core.first.call(null,s__25338__$2);
return cljs.core.cons.call(null,(function (){var map__25353 = field;
var map__25353__$1 = ((((!((map__25353 == null)))?((((map__25353.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25353.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25353):map__25353);
var map__25354 = cljs.core.get.call(null,map__25353__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25354__$1 = ((((!((map__25354 == null)))?((((map__25354.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25354.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25354):map__25354);
var hxl = cljs.core.get.call(null,map__25354__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25353__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25353__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25353__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__25337.call(null,cljs.core.rest.call(null,s__25338__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__25335,map__25335__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__25335,map__25335__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__.call(null,hatti.views.table.all_fields.call(null,form));
})();
return cljs.core.clj__GT_js.call(null,(function (){var G__25357 = columns;
if(cljs.core.not.call(null,hide_actions_column_QMARK_)){
return cljs.core.conj.call(null,G__25357,hatti.views.table.actions_column.call(null,owner,has_hxl_QMARK_));
} else {
return G__25357;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq25332){
var G__25333 = cljs.core.first.call(null,seq25332);
var seq25332__$1 = cljs.core.next.call(null,seq25332);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__25333,seq25332__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25378(s__25379){
return (new cljs.core.LazySeq(null,(function (){
var s__25379__$1 = s__25379;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25379__$1);
if(temp__4657__auto__){
var s__25379__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25379__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25379__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25381 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25380 = (0);
while(true){
if((i__25380 < size__7188__auto__)){
var vec__25388 = cljs.core._nth.call(null,c__7187__auto__,i__25380);
var handler_key = cljs.core.nth.call(null,vec__25388,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25388,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__25381,event.subscribe(handler_function));

var G__25394 = (i__25380 + (1));
i__25380 = G__25394;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25381),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25378.call(null,cljs.core.chunk_rest.call(null,s__25379__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25381),null);
}
} else {
var vec__25391 = cljs.core.first.call(null,s__25379__$2);
var handler_key = cljs.core.nth.call(null,vec__25391,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25391,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25378.call(null,cljs.core.rest.call(null,s__25379__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25411(s__25412){
return (new cljs.core.LazySeq(null,(function (){
var s__25412__$1 = s__25412;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25412__$1);
if(temp__4657__auto__){
var s__25412__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25412__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25412__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25414 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25413 = (0);
while(true){
if((i__25413 < size__7188__auto__)){
var vec__25421 = cljs.core._nth.call(null,c__7187__auto__,i__25413);
var handler_key = cljs.core.nth.call(null,vec__25421,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25421,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__25414,event.subscribe(handler_function));

var G__25427 = (i__25413 + (1));
i__25413 = G__25427;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25414),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25411.call(null,cljs.core.chunk_rest.call(null,s__25412__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25414),null);
}
} else {
var vec__25424 = cljs.core.first.call(null,s__25412__$2);
var handler_key = cljs.core.nth.call(null,vec__25424,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25424,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25411.call(null,cljs.core.rest.call(null,s__25412__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__25430 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25430__$1 = ((((!((map__25430 == null)))?((((map__25430.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25430.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25430):map__25430);
var data_to_be_deleted = cljs.core.get.call(null,map__25430__$1,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634));
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634)], null),((function (map__25430,map__25430__$1,data_to_be_deleted,fn){
return (function (){
return fn.call(null,data_to_be_deleted,data_id);
});})(map__25430,map__25430__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,[cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.call(null,selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector.call(null,data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__25436 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
var chunk__25437 = null;
var count__25438 = (0);
var i__25439 = (0);
while(true){
if((i__25439 < count__25438)){
var data_id = cljs.core._nth.call(null,chunk__25437,i__25439);
var element_25440 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25440.checked = true;

var G__25441 = seq__25436;
var G__25442 = chunk__25437;
var G__25443 = count__25438;
var G__25444 = (i__25439 + (1));
seq__25436 = G__25441;
chunk__25437 = G__25442;
count__25438 = G__25443;
i__25439 = G__25444;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__25436);
if(temp__4657__auto__){
var seq__25436__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25436__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__25436__$1);
var G__25445 = cljs.core.chunk_rest.call(null,seq__25436__$1);
var G__25446 = c__7220__auto__;
var G__25447 = cljs.core.count.call(null,c__7220__auto__);
var G__25448 = (0);
seq__25436 = G__25445;
chunk__25437 = G__25446;
count__25438 = G__25447;
i__25439 = G__25448;
continue;
} else {
var data_id = cljs.core.first.call(null,seq__25436__$1);
var element_25449 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25449.checked = true;

var G__25450 = cljs.core.next.call(null,seq__25436__$1);
var G__25451 = null;
var G__25452 = (0);
var G__25453 = (0);
seq__25436 = G__25450;
chunk__25437 = G__25451;
count__25438 = G__25452;
i__25439 = G__25453;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map_indexed.call(null,((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity.call(null,indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,indexes_of_selected_checkboxes));
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__25454){
var map__25469 = p__25454;
var map__25469__$1 = ((((!((map__25469 == null)))?((((map__25469.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25469.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25469):map__25469);
var grid_event_handlers = cljs.core.get.call(null,map__25469__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__25469__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var map__25471 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25471__$1 = ((((!((map__25471 == null)))?((((map__25471.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25471.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25471):map__25471);
var map__25472 = cljs.core.get.call(null,map__25471__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25472__$1 = ((((!((map__25472 == null)))?((((map__25472.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25472.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25472):map__25472);
var map__25473 = cljs.core.get.call(null,map__25472__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__25473__$1 = ((((!((map__25473 == null)))?((((map__25473.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25473.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25473):map__25473);
var num_displayed_records = cljs.core.get.call(null,map__25473__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__25473__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25472__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,new cljs.core.Keyword(null,"language","language",-1591107564),current_language,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),hide_actions_column_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selectActiveRow","selectActiveRow",-841772687),false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted.call(null);

return hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
});})(map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
if(cljs.core._EQ_.call(null,hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__25477_25483 = cljs.core.seq.call(null,records_to_be_deleted);
var chunk__25478_25484 = null;
var count__25479_25485 = (0);
var i__25480_25486 = (0);
while(true){
if((i__25480_25486 < count__25479_25485)){
var record_25487 = cljs.core._nth.call(null,chunk__25478_25484,i__25480_25486);
record_25487.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25487.getAttribute("data-id")));

var G__25488 = seq__25477_25483;
var G__25489 = chunk__25478_25484;
var G__25490 = count__25479_25485;
var G__25491 = (i__25480_25486 + (1));
seq__25477_25483 = G__25488;
chunk__25478_25484 = G__25489;
count__25479_25485 = G__25490;
i__25480_25486 = G__25491;
continue;
} else {
var temp__4657__auto___25492 = cljs.core.seq.call(null,seq__25477_25483);
if(temp__4657__auto___25492){
var seq__25477_25493__$1 = temp__4657__auto___25492;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25477_25493__$1)){
var c__7220__auto___25494 = cljs.core.chunk_first.call(null,seq__25477_25493__$1);
var G__25495 = cljs.core.chunk_rest.call(null,seq__25477_25493__$1);
var G__25496 = c__7220__auto___25494;
var G__25497 = cljs.core.count.call(null,c__7220__auto___25494);
var G__25498 = (0);
seq__25477_25483 = G__25495;
chunk__25478_25484 = G__25496;
count__25479_25485 = G__25497;
i__25480_25486 = G__25498;
continue;
} else {
var record_25499 = cljs.core.first.call(null,seq__25477_25493__$1);
record_25499.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25499.getAttribute("data-id")));

var G__25500 = cljs.core.next.call(null,seq__25477_25493__$1);
var G__25501 = null;
var G__25502 = (0);
var G__25503 = (0);
seq__25477_25483 = G__25500;
chunk__25478_25484 = G__25501;
count__25479_25485 = G__25502;
i__25480_25486 = G__25503;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.call(null,total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
return null;
}
});})(map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__25481 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25481__$1 = ((((!((map__25481 == null)))?((((map__25481.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25481.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25481):map__25481);
var selected_table_rows = cljs.core.get.call(null,map__25481__$1,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745));
if(cljs.core._EQ_.call(null,class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = parseInt(grid.getCellFromEvent(e).row);
hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_.call(null);

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25481,map__25481__$1,selected_table_rows,map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return fn.call(null,selected_table_rows,row__$1);
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25481,map__25481__$1,selected_table_rows,map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
}
});})(map__25471,map__25471__$1,map__25472,map__25472__$1,map__25473,map__25473__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25469,map__25469__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__13216__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,event_chan){
return (function (state_25795){
var state_val_25796 = (state_25795[(1)]);
if((state_val_25796 === (7))){
var inst_25693 = (state_25795[(7)]);
var inst_25693__$1 = (state_25795[(2)]);
var inst_25695 = (inst_25693__$1 == null);
var inst_25696 = cljs.core.not.call(null,inst_25695);
var state_25795__$1 = (function (){var statearr_25797 = state_25795;
(statearr_25797[(7)] = inst_25693__$1);

return statearr_25797;
})();
if(inst_25696){
var statearr_25798_25873 = state_25795__$1;
(statearr_25798_25873[(1)] = (8));

} else {
var statearr_25799_25874 = state_25795__$1;
(statearr_25799_25874[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (20))){
var inst_25715 = (state_25795[(8)]);
var inst_25723 = (state_25795[(9)]);
var inst_25732 = inst_25723.call(null,inst_25715);
var state_25795__$1 = state_25795;
var statearr_25800_25875 = state_25795__$1;
(statearr_25800_25875[(2)] = inst_25732);

(statearr_25800_25875[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (27))){
var state_25795__$1 = state_25795;
var statearr_25801_25876 = state_25795__$1;
(statearr_25801_25876[(2)] = null);

(statearr_25801_25876[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (1))){
var state_25795__$1 = state_25795;
var statearr_25802_25877 = state_25795__$1;
(statearr_25802_25877[(2)] = null);

(statearr_25802_25877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (24))){
var state_25795__$1 = state_25795;
var statearr_25803_25878 = state_25795__$1;
(statearr_25803_25878[(2)] = null);

(statearr_25803_25878[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (4))){
var state_25795__$1 = state_25795;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25795__$1,(7),event_chan);
} else {
if((state_val_25796 === (15))){
var inst_25693 = (state_25795[(7)]);
var state_25795__$1 = state_25795;
var statearr_25804_25879 = state_25795__$1;
(statearr_25804_25879[(2)] = inst_25693);

(statearr_25804_25879[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (21))){
var state_25795__$1 = state_25795;
var statearr_25805_25880 = state_25795__$1;
(statearr_25805_25880[(2)] = null);

(statearr_25805_25880[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (31))){
var inst_25719 = (state_25795[(10)]);
var inst_25768 = (state_25795[(2)]);
var inst_25769 = cljs.core._EQ_.call(null,inst_25719,new cljs.core.Keyword(null,"table","table",-564943036));
var state_25795__$1 = (function (){var statearr_25806 = state_25795;
(statearr_25806[(11)] = inst_25768);

return statearr_25806;
})();
if(inst_25769){
var statearr_25807_25881 = state_25795__$1;
(statearr_25807_25881[(1)] = (32));

} else {
var statearr_25808_25882 = state_25795__$1;
(statearr_25808_25882[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (32))){
var inst_25718 = (state_25795[(12)]);
var inst_25724 = (state_25795[(13)]);
var inst_25713 = (state_25795[(14)]);
var inst_25714 = (state_25795[(15)]);
var inst_25719 = (state_25795[(10)]);
var inst_25717 = (state_25795[(16)]);
var inst_25716 = (state_25795[(17)]);
var inst_25715 = (state_25795[(8)]);
var inst_25723 = (state_25795[(9)]);
var inst_25782 = cljs.core.async.chan.call(null,(1));
var inst_25783 = (function (){var new_columns = inst_25718;
var submission_clicked = inst_25715;
var submission_unclicked = inst_25716;
var get_submission_data = inst_25724;
var re_render = inst_25719;
var update_data_BANG_ = inst_25723;
var submission_to_rank = inst_25714;
var c__13216__auto____$1 = inst_25782;
var filter_by = inst_25717;
var map__25691 = inst_25713;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25782,state_val_25796,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25782,state_val_25796,c__13216__auto__,event_chan){
return (function (state_25780){
var state_val_25781 = (state_25780[(1)]);
if((state_val_25781 === (1))){
var inst_25771 = cljs.core.async.timeout.call(null,(20));
var state_25780__$1 = state_25780;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25780__$1,(2),inst_25771);
} else {
if((state_val_25781 === (2))){
var inst_25773 = (state_25780[(2)]);
var inst_25774 = grid.resizeCanvas();
var inst_25775 = grid.invalidateAllRows();
var inst_25776 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25777 = grid.render();
var inst_25778 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_25780__$1 = (function (){var statearr_25809 = state_25780;
(statearr_25809[(7)] = inst_25777);

(statearr_25809[(8)] = inst_25775);

(statearr_25809[(9)] = inst_25774);

(statearr_25809[(10)] = inst_25773);

(statearr_25809[(11)] = inst_25776);

return statearr_25809;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25780__$1,inst_25778);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25782,state_val_25796,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25782,state_val_25796,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_25813 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25813[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_25813[(1)] = (1));

return statearr_25813;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_25780){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_25780);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e25814){if((e25814 instanceof Object)){
var ex__13108__auto__ = e25814;
var statearr_25815_25883 = state_25780;
(statearr_25815_25883[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25780);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25814;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25884 = state_25780;
state_25780 = G__25884;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_25780){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_25780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25782,state_val_25796,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_25816 = f__13217__auto__.call(null);
(statearr_25816[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_25816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25782,state_val_25796,c__13216__auto__,event_chan))
})();
var inst_25784 = cljs.core.async.impl.dispatch.run.call(null,inst_25783);
var state_25795__$1 = (function (){var statearr_25817 = state_25795;
(statearr_25817[(18)] = inst_25784);

return statearr_25817;
})();
var statearr_25818_25885 = state_25795__$1;
(statearr_25818_25885[(2)] = inst_25782);

(statearr_25818_25885[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (33))){
var state_25795__$1 = state_25795;
var statearr_25819_25886 = state_25795__$1;
(statearr_25819_25886[(2)] = null);

(statearr_25819_25886[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (13))){
var inst_25705 = (state_25795[(2)]);
var state_25795__$1 = state_25795;
var statearr_25820_25887 = state_25795__$1;
(statearr_25820_25887[(2)] = inst_25705);

(statearr_25820_25887[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (22))){
var inst_25716 = (state_25795[(17)]);
var inst_25735 = (state_25795[(2)]);
var state_25795__$1 = (function (){var statearr_25821 = state_25795;
(statearr_25821[(19)] = inst_25735);

return statearr_25821;
})();
if(cljs.core.truth_(inst_25716)){
var statearr_25822_25888 = state_25795__$1;
(statearr_25822_25888[(1)] = (23));

} else {
var statearr_25823_25889 = state_25795__$1;
(statearr_25823_25889[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (29))){
var inst_25717 = (state_25795[(16)]);
var inst_25760 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_25761 = [inst_25717];
var inst_25762 = cljs.core.PersistentHashMap.fromArrays(inst_25760,inst_25761);
var inst_25763 = cljs.core.clj__GT_js.call(null,inst_25762);
var inst_25764 = dataview.setFilterArgs(inst_25763);
var inst_25765 = dataview.refresh();
var state_25795__$1 = (function (){var statearr_25824 = state_25795;
(statearr_25824[(20)] = inst_25764);

return statearr_25824;
})();
var statearr_25825_25890 = state_25795__$1;
(statearr_25825_25890[(2)] = inst_25765);

(statearr_25825_25890[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (6))){
var inst_25791 = (state_25795[(2)]);
var state_25795__$1 = state_25795;
var statearr_25826_25891 = state_25795__$1;
(statearr_25826_25891[(2)] = inst_25791);

(statearr_25826_25891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (28))){
var inst_25717 = (state_25795[(16)]);
var inst_25758 = (state_25795[(2)]);
var state_25795__$1 = (function (){var statearr_25827 = state_25795;
(statearr_25827[(21)] = inst_25758);

return statearr_25827;
})();
if(cljs.core.truth_(inst_25717)){
var statearr_25828_25892 = state_25795__$1;
(statearr_25828_25892[(1)] = (29));

} else {
var statearr_25829_25893 = state_25795__$1;
(statearr_25829_25893[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (25))){
var inst_25718 = (state_25795[(12)]);
var inst_25740 = (state_25795[(2)]);
var state_25795__$1 = (function (){var statearr_25830 = state_25795;
(statearr_25830[(22)] = inst_25740);

return statearr_25830;
})();
if(cljs.core.truth_(inst_25718)){
var statearr_25831_25894 = state_25795__$1;
(statearr_25831_25894[(1)] = (26));

} else {
var statearr_25832_25895 = state_25795__$1;
(statearr_25832_25895[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (34))){
var inst_25787 = (state_25795[(2)]);
var state_25795__$1 = (function (){var statearr_25833 = state_25795;
(statearr_25833[(23)] = inst_25787);

return statearr_25833;
})();
var statearr_25834_25896 = state_25795__$1;
(statearr_25834_25896[(2)] = null);

(statearr_25834_25896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (17))){
var inst_25724 = (state_25795[(13)]);
var inst_25714 = (state_25795[(15)]);
var inst_25723 = (state_25795[(9)]);
var inst_25726 = inst_25724.call(null,hatti.constants._rank,inst_25714);
var inst_25727 = inst_25723.call(null,inst_25726);
var state_25795__$1 = state_25795;
var statearr_25835_25897 = state_25795__$1;
(statearr_25835_25897[(2)] = inst_25727);

(statearr_25835_25897[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (3))){
var inst_25793 = (state_25795[(2)]);
var state_25795__$1 = state_25795;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25795__$1,inst_25793);
} else {
if((state_val_25796 === (12))){
var state_25795__$1 = state_25795;
var statearr_25836_25898 = state_25795__$1;
(statearr_25836_25898[(2)] = false);

(statearr_25836_25898[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (2))){
var state_25795__$1 = state_25795;
var statearr_25837_25899 = state_25795__$1;
(statearr_25837_25899[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (23))){
var inst_25723 = (state_25795[(9)]);
var inst_25737 = inst_25723.call(null,null);
var state_25795__$1 = state_25795;
var statearr_25839_25900 = state_25795__$1;
(statearr_25839_25900[(2)] = inst_25737);

(statearr_25839_25900[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (19))){
var inst_25715 = (state_25795[(8)]);
var inst_25730 = (state_25795[(2)]);
var state_25795__$1 = (function (){var statearr_25840 = state_25795;
(statearr_25840[(24)] = inst_25730);

return statearr_25840;
})();
if(cljs.core.truth_(inst_25715)){
var statearr_25841_25901 = state_25795__$1;
(statearr_25841_25901[(1)] = (20));

} else {
var statearr_25842_25902 = state_25795__$1;
(statearr_25842_25902[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (11))){
var state_25795__$1 = state_25795;
var statearr_25843_25903 = state_25795__$1;
(statearr_25843_25903[(2)] = true);

(statearr_25843_25903[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (9))){
var state_25795__$1 = state_25795;
var statearr_25844_25904 = state_25795__$1;
(statearr_25844_25904[(2)] = false);

(statearr_25844_25904[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (5))){
var state_25795__$1 = state_25795;
var statearr_25845_25905 = state_25795__$1;
(statearr_25845_25905[(2)] = null);

(statearr_25845_25905[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (14))){
var inst_25693 = (state_25795[(7)]);
var inst_25710 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25693);
var state_25795__$1 = state_25795;
var statearr_25846_25906 = state_25795__$1;
(statearr_25846_25906[(2)] = inst_25710);

(statearr_25846_25906[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (26))){
var inst_25718 = (state_25795[(12)]);
var inst_25724 = (state_25795[(13)]);
var inst_25713 = (state_25795[(14)]);
var inst_25714 = (state_25795[(15)]);
var inst_25719 = (state_25795[(10)]);
var inst_25717 = (state_25795[(16)]);
var inst_25716 = (state_25795[(17)]);
var inst_25715 = (state_25795[(8)]);
var inst_25723 = (state_25795[(9)]);
var inst_25753 = cljs.core.async.chan.call(null,(1));
var inst_25754 = (function (){var new_columns = inst_25718;
var submission_clicked = inst_25715;
var submission_unclicked = inst_25716;
var get_submission_data = inst_25724;
var re_render = inst_25719;
var update_data_BANG_ = inst_25723;
var submission_to_rank = inst_25714;
var c__13216__auto____$1 = inst_25753;
var filter_by = inst_25717;
var map__25691 = inst_25713;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25753,state_val_25796,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25753,state_val_25796,c__13216__auto__,event_chan){
return (function (state_25751){
var state_val_25752 = (state_25751[(1)]);
if((state_val_25752 === (1))){
var inst_25742 = cljs.core.async.timeout.call(null,(20));
var state_25751__$1 = state_25751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25751__$1,(2),inst_25742);
} else {
if((state_val_25752 === (2))){
var inst_25744 = (state_25751[(2)]);
var inst_25745 = grid.setColumns(new_columns);
var inst_25746 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25747 = grid.render();
var inst_25748 = hatti.views.table.select_rows_marked_to_be_deleted.call(null);
var inst_25749 = hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
var state_25751__$1 = (function (){var statearr_25847 = state_25751;
(statearr_25847[(7)] = inst_25748);

(statearr_25847[(8)] = inst_25744);

(statearr_25847[(9)] = inst_25747);

(statearr_25847[(10)] = inst_25745);

(statearr_25847[(11)] = inst_25746);

return statearr_25847;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25751__$1,inst_25749);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25753,state_val_25796,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25753,state_val_25796,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_25851 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25851[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_25851[(1)] = (1));

return statearr_25851;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_25751){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_25751);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e25852){if((e25852 instanceof Object)){
var ex__13108__auto__ = e25852;
var statearr_25853_25907 = state_25751;
(statearr_25853_25907[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25751);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25852;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25908 = state_25751;
state_25751 = G__25908;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_25751){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_25751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25753,state_val_25796,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_25854 = f__13217__auto__.call(null);
(statearr_25854[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_25854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__25691,inst_25718,inst_25724,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25753,state_val_25796,c__13216__auto__,event_chan))
})();
var inst_25755 = cljs.core.async.impl.dispatch.run.call(null,inst_25754);
var state_25795__$1 = (function (){var statearr_25855 = state_25795;
(statearr_25855[(25)] = inst_25755);

return statearr_25855;
})();
var statearr_25856_25909 = state_25795__$1;
(statearr_25856_25909[(2)] = inst_25753);

(statearr_25856_25909[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (16))){
var inst_25718 = (state_25795[(12)]);
var inst_25713 = (state_25795[(14)]);
var inst_25714 = (state_25795[(15)]);
var inst_25719 = (state_25795[(10)]);
var inst_25717 = (state_25795[(16)]);
var inst_25716 = (state_25795[(17)]);
var inst_25715 = (state_25795[(8)]);
var inst_25723 = (state_25795[(9)]);
var inst_25713__$1 = (state_25795[(2)]);
var inst_25714__$1 = cljs.core.get.call(null,inst_25713__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_25715__$1 = cljs.core.get.call(null,inst_25713__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_25716__$1 = cljs.core.get.call(null,inst_25713__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_25717__$1 = cljs.core.get.call(null,inst_25713__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_25718__$1 = cljs.core.get.call(null,inst_25713__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_25719__$1 = cljs.core.get.call(null,inst_25713__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_25720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25721 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_25722 = (new cljs.core.PersistentVector(null,3,(5),inst_25720,inst_25721,null));
var inst_25723__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_25722);
var inst_25724 = (function (){var map__25691 = inst_25713__$1;
var submission_to_rank = inst_25714__$1;
var submission_clicked = inst_25715__$1;
var submission_unclicked = inst_25716__$1;
var filter_by = inst_25717__$1;
var new_columns = inst_25718__$1;
var re_render = inst_25719__$1;
var update_data_BANG_ = inst_25723__$1;
return ((function (map__25691,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25718,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25713__$1,inst_25714__$1,inst_25715__$1,inst_25716__$1,inst_25717__$1,inst_25718__$1,inst_25719__$1,inst_25720,inst_25721,inst_25722,inst_25723__$1,state_val_25796,c__13216__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__25691,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25718,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25713__$1,inst_25714__$1,inst_25715__$1,inst_25716__$1,inst_25717__$1,inst_25718__$1,inst_25719__$1,inst_25720,inst_25721,inst_25722,inst_25723__$1,state_val_25796,c__13216__auto__,event_chan){
return (function (p1__25504_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__25504_SHARP_,field));
});})(map__25691,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25718,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25713__$1,inst_25714__$1,inst_25715__$1,inst_25716__$1,inst_25717__$1,inst_25718__$1,inst_25719__$1,inst_25720,inst_25721,inst_25722,inst_25723__$1,state_val_25796,c__13216__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(map__25691,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25718,inst_25713,inst_25714,inst_25719,inst_25717,inst_25716,inst_25715,inst_25723,inst_25713__$1,inst_25714__$1,inst_25715__$1,inst_25716__$1,inst_25717__$1,inst_25718__$1,inst_25719__$1,inst_25720,inst_25721,inst_25722,inst_25723__$1,state_val_25796,c__13216__auto__,event_chan))
})();
var state_25795__$1 = (function (){var statearr_25857 = state_25795;
(statearr_25857[(12)] = inst_25718__$1);

(statearr_25857[(13)] = inst_25724);

(statearr_25857[(14)] = inst_25713__$1);

(statearr_25857[(15)] = inst_25714__$1);

(statearr_25857[(10)] = inst_25719__$1);

(statearr_25857[(16)] = inst_25717__$1);

(statearr_25857[(17)] = inst_25716__$1);

(statearr_25857[(8)] = inst_25715__$1);

(statearr_25857[(9)] = inst_25723__$1);

return statearr_25857;
})();
if(cljs.core.truth_(inst_25714__$1)){
var statearr_25858_25910 = state_25795__$1;
(statearr_25858_25910[(1)] = (17));

} else {
var statearr_25859_25911 = state_25795__$1;
(statearr_25859_25911[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (30))){
var state_25795__$1 = state_25795;
var statearr_25860_25912 = state_25795__$1;
(statearr_25860_25912[(2)] = null);

(statearr_25860_25912[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (10))){
var inst_25708 = (state_25795[(2)]);
var state_25795__$1 = state_25795;
if(cljs.core.truth_(inst_25708)){
var statearr_25861_25913 = state_25795__$1;
(statearr_25861_25913[(1)] = (14));

} else {
var statearr_25862_25914 = state_25795__$1;
(statearr_25862_25914[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (18))){
var state_25795__$1 = state_25795;
var statearr_25863_25915 = state_25795__$1;
(statearr_25863_25915[(2)] = null);

(statearr_25863_25915[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25796 === (8))){
var inst_25693 = (state_25795[(7)]);
var inst_25698 = inst_25693.cljs$lang$protocol_mask$partition0$;
var inst_25699 = (inst_25698 & (64));
var inst_25700 = inst_25693.cljs$core$ISeq$;
var inst_25701 = (inst_25699) || (inst_25700);
var state_25795__$1 = state_25795;
if(cljs.core.truth_(inst_25701)){
var statearr_25864_25916 = state_25795__$1;
(statearr_25864_25916[(1)] = (11));

} else {
var statearr_25865_25917 = state_25795__$1;
(statearr_25865_25917[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_25869 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25869[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_25869[(1)] = (1));

return statearr_25869;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_25795){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_25795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e25870){if((e25870 instanceof Object)){
var ex__13108__auto__ = e25870;
var statearr_25871_25918 = state_25795;
(statearr_25871_25918[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25795);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25870;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25919 = state_25795;
state_25795 = G__25919;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_25795){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_25795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_25872 = f__13217__auto__.call(null);
(statearr_25872[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_25872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto__,event_chan))
);

return c__13216__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"field-key","field-key",313262601),k);

return colset_BANG_.call(null,k);
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__25936(s__25937){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__25937__$1 = s__25937;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25937__$1);
if(temp__4657__auto__){
var s__25937__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25937__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25937__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25939 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25938 = (0);
while(true){
if((i__25938 < size__7188__auto__)){
var vec__25946 = cljs.core._nth.call(null,c__7187__auto__,i__25938);
var k = cljs.core.nth.call(null,vec__25946,(0),null);
var v = cljs.core.nth.call(null,vec__25946,(1),null);
cljs.core.chunk_append.call(null,b__25939,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__25938,vec__25946,k,v,c__7187__auto__,size__7188__auto__,b__25939,s__25937__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__25938,vec__25946,k,v,c__7187__auto__,size__7188__auto__,b__25939,s__25937__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__25952 = (i__25938 + (1));
i__25938 = G__25952;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25939),hatti$views$table$render_options_$_iter__25936.call(null,cljs.core.chunk_rest.call(null,s__25937__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25939),null);
}
} else {
var vec__25949 = cljs.core.first.call(null,s__25937__$2);
var k = cljs.core.nth.call(null,vec__25949,(0),null);
var v = cljs.core.nth.call(null,vec__25949,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__25949,k,v,s__25937__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__25949,k,v,s__25937__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__25936.call(null,cljs.core.rest.call(null,s__25937__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table25954 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25954 = (function (_,owner,meta25955){
this._ = _;
this.owner = owner;
this.meta25955 = meta25955;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25954.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25956,meta25955__$1){
var self__ = this;
var _25956__$1 = this;
return (new hatti.views.table.t_hatti$views$table25954(self__._,self__.owner,meta25955__$1));
});

hatti.views.table.t_hatti$views$table25954.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25956){
var self__ = this;
var _25956__$1 = this;
return self__.meta25955;
});

hatti.views.table.t_hatti$views$table25954.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table25954.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field-key","field-key",313262601),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table25954.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25954.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__25957){
var self__ = this;
var map__25958 = p__25957;
var map__25958__$1 = ((((!((map__25958 == null)))?((((map__25958.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25958.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25958):map__25958);
var field_key = cljs.core.get.call(null,map__25958__$1,new cljs.core.Keyword(null,"field-key","field-key",313262601));
var language = cljs.core.get.call(null,map__25958__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__25960 = om.core.get_shared.call(null,self__.owner);
var map__25960__$1 = ((((!((map__25960 == null)))?((((map__25960.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25960.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25960):map__25960);
var flat_form = cljs.core.get.call(null,map__25960__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__25960,map__25960__$1,flat_form,new_language,___$2,map__25958,map__25958__$1,field_key,language){
return (function (p1__25953_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__25953_SHARP_),new cljs.core.Keyword(null,"language","language",-1591107564),new_language)], null));
});})(options,map__25960,map__25960__$1,flat_form,new_language,___$2,map__25958,map__25958__$1,field_key,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,field_key);
} else {
}

return React.DOM.div(({"className": "label-changer"}),React.DOM.span(({"className": "label-changer-label"}),"Show:"),React.DOM.div(({"id": "header-display-dropdown", "className": "drop-hover"}),(function (){var attrs25964 = options.call(null,field_key);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs25964))?sablono.interpreter.attributes.call(null,attrs25964):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25964))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i(({"className": "fa fa-angle-down"}))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25964),React.DOM.i(({"className": "fa fa-angle-down"}))], null))));
})(),(function (){var attrs25969 = hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_);
return cljs.core.apply.call(null,React.DOM.ul,((cljs.core.map_QMARK_.call(null,attrs25969))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs25969)):({"className": "submenu no-dot"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25969))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25969)], null))));
})()));
});

hatti.views.table.t_hatti$views$table25954.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25955","meta25955",1233314138,null)], null);
});

hatti.views.table.t_hatti$views$table25954.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25954.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25954";

hatti.views.table.t_hatti$views$table25954.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25954");
});

hatti.views.table.__GT_t_hatti$views$table25954 = (function hatti$views$table$__GT_t_hatti$views$table25954(___$1,owner__$1,meta25955){
return (new hatti.views.table.t_hatti$views$table25954(___$1,owner__$1,meta25955));
});

}

return (new hatti.views.table.t_hatti$views$table25954(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__13216__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto__,query){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,query){
return (function (state_26012){
var state_val_26013 = (state_26012[(1)]);
if((state_val_26013 === (1))){
var inst_25998 = cljs.core.async.timeout.call(null,(150));
var state_26012__$1 = state_26012;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26012__$1,(2),inst_25998);
} else {
if((state_val_26013 === (2))){
var inst_26000 = (state_26012[(2)]);
var inst_26001 = input.value;
var inst_26002 = cljs.core._EQ_.call(null,query,inst_26001);
var state_26012__$1 = (function (){var statearr_26014 = state_26012;
(statearr_26014[(7)] = inst_26000);

return statearr_26014;
})();
if(inst_26002){
var statearr_26015_26026 = state_26012__$1;
(statearr_26015_26026[(1)] = (3));

} else {
var statearr_26016_26027 = state_26012__$1;
(statearr_26016_26027[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26013 === (3))){
var inst_26004 = [query_event_key];
var inst_26005 = [query];
var inst_26006 = cljs.core.PersistentHashMap.fromArrays(inst_26004,inst_26005);
var inst_26007 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_26006);
var state_26012__$1 = state_26012;
var statearr_26017_26028 = state_26012__$1;
(statearr_26017_26028[(2)] = inst_26007);

(statearr_26017_26028[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26013 === (4))){
var state_26012__$1 = state_26012;
var statearr_26018_26029 = state_26012__$1;
(statearr_26018_26029[(2)] = null);

(statearr_26018_26029[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26013 === (5))){
var inst_26010 = (state_26012[(2)]);
var state_26012__$1 = state_26012;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26012__$1,inst_26010);
} else {
return null;
}
}
}
}
}
});})(c__13216__auto__,query))
;
return ((function (switch__13104__auto__,c__13216__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__13105__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__13105__auto____0 = (function (){
var statearr_26022 = [null,null,null,null,null,null,null,null];
(statearr_26022[(0)] = hatti$views$table$delayed_search_$_state_machine__13105__auto__);

(statearr_26022[(1)] = (1));

return statearr_26022;
});
var hatti$views$table$delayed_search_$_state_machine__13105__auto____1 = (function (state_26012){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_26012);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e26023){if((e26023 instanceof Object)){
var ex__13108__auto__ = e26023;
var statearr_26024_26030 = state_26012;
(statearr_26024_26030[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26012);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26023;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26031 = state_26012;
state_26012 = G__26031;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__13105__auto__ = function(state_26012){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____1.call(this,state_26012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__13105__auto____0;
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__13105__auto____1;
return hatti$views$table$delayed_search_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,query))
})();
var state__13218__auto__ = (function (){var statearr_26025 = f__13217__auto__.call(null);
(statearr_26025[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_26025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto__,query))
);

return c__13216__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table26033 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26033 = (function (_,owner,meta26034){
this._ = _;
this.owner = owner;
this.meta26034 = meta26034;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26033.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26035,meta26034__$1){
var self__ = this;
var _26035__$1 = this;
return (new hatti.views.table.t_hatti$views$table26033(self__._,self__.owner,meta26034__$1));
});

hatti.views.table.t_hatti$views$table26033.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26035){
var self__ = this;
var _26035__$1 = this;
return self__.meta26034;
});

hatti.views.table.t_hatti$views$table26033.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26033.prototype.om$core$IRender$render$arity$1 = (function (this__19151__auto__){
var self__ = this;
var this__19151__auto____$1 = this;
return React.DOM.div(({"className": "table-search"}),React.DOM.i(({"className": "fa fa-search"})),sablono.interpreter.input.call(null,({"type": "text", "placeholder": "Search", "onChange": ((function (this__19151__auto____$1){
return (function (p1__26032_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__26032_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__19151__auto____$1))
})));
});

hatti.views.table.t_hatti$views$table26033.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26034","meta26034",794176983,null)], null);
});

hatti.views.table.t_hatti$views$table26033.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26033.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26033";

hatti.views.table.t_hatti$views$table26033.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26033");
});

hatti.views.table.__GT_t_hatti$views$table26033 = (function hatti$views$table$__GT_t_hatti$views$table26033(___$1,owner__$1,meta26034){
return (new hatti.views.table.t_hatti$views$table26033(___$1,owner__$1,meta26034));
});

}

return (new hatti.views.table.t_hatti$views$table26033(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table26038 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26038 = (function (cursor,owner,meta26039){
this.cursor = cursor;
this.owner = owner;
this.meta26039 = meta26039;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26038.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26040,meta26039__$1){
var self__ = this;
var _26040__$1 = this;
return (new hatti.views.table.t_hatti$views$table26038(self__.cursor,self__.owner,meta26039__$1));
});

hatti.views.table.t_hatti$views$table26038.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26040){
var self__ = this;
var _26040__$1 = this;
return self__.meta26039;
});

hatti.views.table.t_hatti$views$table26038.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26038.prototype.om$core$IRender$render$arity$1 = (function (this__19151__auto__){
var self__ = this;
var this__19151__auto____$1 = this;
return React.DOM.div(({"className": "topbar"}),React.DOM.div(({"id": hatti.views.table.pager_id})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,self__.cursor)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.cursor)),React.DOM.div(({"style": ({"clear": "both"})})));
});

hatti.views.table.t_hatti$views$table26038.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26039","meta26039",1982497457,null)], null);
});

hatti.views.table.t_hatti$views$table26038.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26038.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26038";

hatti.views.table.t_hatti$views$table26038.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26038");
});

hatti.views.table.__GT_t_hatti$views$table26038 = (function hatti$views$table$__GT_t_hatti$views$table26038(cursor__$1,owner__$1,meta26039){
return (new hatti.views.table.t_hatti$views$table26038(cursor__$1,owner__$1,meta26039));
});

}

return (new hatti.views.table.t_hatti$views$table26038(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq.call(null,data)){
var map__26048 = om.core.get_shared.call(null,owner);
var map__26048__$1 = ((((!((map__26048 == null)))?((((map__26048.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26048.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26048):map__26048);
var flat_form = cljs.core.get.call(null,map__26048__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__26049 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__26049,(0),null);
var dataview = cljs.core.nth.call(null,vec__26049,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901),hatti.views.table.get_table_view_height.call(null));
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__26054,owner,p__26055){
var map__26056 = p__26054;
var map__26056__$1 = ((((!((map__26056 == null)))?((((map__26056.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26056.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26056):map__26056);
var cursor = map__26056__$1;
var map__26057 = cljs.core.get.call(null,map__26056__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__26057__$1 = ((((!((map__26057 == null)))?((((map__26057.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26057.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26057):map__26057);
var active = cljs.core.get.call(null,map__26057__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var map__26058 = p__26055;
var map__26058__$1 = ((((!((map__26058 == null)))?((((map__26058.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26058.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26058):map__26058);
var opts = map__26058__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__26058__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

var active_QMARK_ = chimera.seq.in_QMARK_.call(null,active,new cljs.core.Keyword(null,"table","table",-564943036));
if(typeof hatti.views.table.t_hatti$views$table26062 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26062 = (function (owner,active_QMARK_,map__26057,slick_grid_event_handlers,map__26058,p__26055,cursor,active,opts,map__26056,p__26054,meta26063){
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.map__26057 = map__26057;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.map__26058 = map__26058;
this.p__26055 = p__26055;
this.cursor = cursor;
this.active = active;
this.opts = opts;
this.map__26056 = map__26056;
this.p__26054 = p__26054;
this.meta26063 = meta26063;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26062.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers){
return (function (_26064,meta26063__$1){
var self__ = this;
var _26064__$1 = this;
return (new hatti.views.table.t_hatti$views$table26062(self__.owner,self__.active_QMARK_,self__.map__26057,self__.slick_grid_event_handlers,self__.map__26058,self__.p__26055,self__.cursor,self__.active,self__.opts,self__.map__26056,self__.p__26054,meta26063__$1));
});})(active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26062.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers){
return (function (_26064){
var self__ = this;
var _26064__$1 = this;
return self__.meta26063;
});})(active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26062.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table26062.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers){
return (function (_,p__26065){
var self__ = this;
var map__26066 = p__26065;
var map__26066__$1 = ((((!((map__26066 == null)))?((((map__26066.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26066.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26066):map__26066);
var table_view_height = cljs.core.get.call(null,map__26066__$1,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901));
var ___$1 = this;
var map__26068 = self__.cursor;
var map__26068__$1 = ((((!((map__26068 == null)))?((((map__26068.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26068.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26068):map__26068);
var map__26069 = cljs.core.get.call(null,map__26068__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__26069__$1 = ((((!((map__26069 == null)))?((((map__26069.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26069.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26069):map__26069);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.call(null,map__26069__$1,new cljs.core.Keyword(null,"prevent-scrolling-in-table-view?","prevent-scrolling-in-table-view?",2053296532));
var submission_clicked = cljs.core.get.call(null,map__26069__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var data = cljs.core.get.call(null,map__26068__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__26068__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var map__26070 = dataset_info;
var map__26070__$1 = ((((!((map__26070 == null)))?((((map__26070.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26070.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26070):map__26070);
var num_of_submissions = cljs.core.get.call(null,map__26070__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,data);
var with_info = ((function (map__26068,map__26068__$1,map__26069,map__26069__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__26070,map__26070__$1,num_of_submissions,no_data_QMARK_,___$1,map__26066,map__26066__$1,table_view_height,active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers){
return (function (p1__26053_SHARP_){
return cljs.core.merge.call(null,self__.cursor,p1__26053_SHARP_);
});})(map__26068,map__26068__$1,map__26069,map__26069__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__26070,map__26070__$1,num_of_submissions,no_data_QMARK_,___$1,map__26066,map__26066__$1,table_view_height,active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
return React.DOM.div(({"style": cljs.core.clj__GT_js.call(null,(cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"height","height",1025178622),(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height.call(null);
}
})(),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null):null)), "className": "table-view"}),sablono.interpreter.interpret.call(null,(cljs.core.truth_(new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.call(null,hatti.views.submission_view,with_info.call(null,submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null)):null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.cursor)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.p(({"className": "alert alert-warning"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading..."))));
} else {
return null;
}
});})(active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26062.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table26062.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler.call(null,self__.owner);

var data = cljs.core.get_in.call(null,self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26078 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__26078,(0),null);
var dataview = cljs.core.nth.call(null,vec__26078,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26062.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table26062.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.call(null,self__.owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881)));
});})(active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26062.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table26062.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__26081 = om.core.get_state.call(null,self__.owner);
var map__26081__$1 = ((((!((map__26081 == null)))?((((map__26081.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26081.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26081):map__26081);
var grid = cljs.core.get.call(null,map__26081__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__26081__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26083 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__26083,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__26083,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26062.getBasis = ((function (active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"active?","active?",2100031303,null),new cljs.core.Symbol(null,"map__26057","map__26057",-332578069,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"map__26058","map__26058",-849696114,null),new cljs.core.Symbol(null,"p__26055","p__26055",-562754286,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"active","active",-758473701,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"map__26056","map__26056",1082255070,null),new cljs.core.Symbol(null,"p__26054","p__26054",1087464991,null),new cljs.core.Symbol(null,"meta26063","meta26063",-1222896173,null)], null);
});})(active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26062.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26062.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26062";

hatti.views.table.t_hatti$views$table26062.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26062");
});})(active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table26062 = ((function (active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table26062(owner__$1,active_QMARK___$1,map__26057__$2,slick_grid_event_handlers__$1,map__26058__$2,p__26055__$1,cursor__$1,active__$1,opts__$1,map__26056__$2,p__26054__$1,meta26063){
return (new hatti.views.table.t_hatti$views$table26062(owner__$1,active_QMARK___$1,map__26057__$2,slick_grid_event_handlers__$1,map__26058__$2,p__26055__$1,cursor__$1,active__$1,opts__$1,map__26056__$2,p__26054__$1,meta26063));
});})(active_QMARK_,map__26056,map__26056__$1,cursor,map__26057,map__26057__$1,active,map__26058,map__26058__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table26062(owner,active_QMARK_,map__26057__$1,slick_grid_event_handlers,map__26058__$1,p__26055,cursor,active,opts,map__26056__$1,p__26054,cljs.core.PersistentArrayMap.EMPTY));
}));
