// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__13216__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__13216__auto__){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__){
return (function (state_22344){
var state_val_22345 = (state_22344[(1)]);
if((state_val_22345 === (7))){
var inst_22301 = (state_22344[(7)]);
var inst_22301__$1 = (state_22344[(2)]);
var inst_22303 = (inst_22301__$1 == null);
var inst_22304 = cljs.core.not.call(null,inst_22303);
var state_22344__$1 = (function (){var statearr_22346 = state_22344;
(statearr_22346[(7)] = inst_22301__$1);

return statearr_22346;
})();
if(inst_22304){
var statearr_22347_22384 = state_22344__$1;
(statearr_22347_22384[(1)] = (8));

} else {
var statearr_22348_22385 = state_22344__$1;
(statearr_22348_22385[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (20))){
var inst_22323 = (state_22344[(8)]);
var inst_22331 = (state_22344[(2)]);
var state_22344__$1 = (function (){var statearr_22349 = state_22344;
(statearr_22349[(9)] = inst_22331);

return statearr_22349;
})();
if(cljs.core.truth_(inst_22323)){
var statearr_22350_22386 = state_22344__$1;
(statearr_22350_22386[(1)] = (21));

} else {
var statearr_22351_22387 = state_22344__$1;
(statearr_22351_22387[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (1))){
var state_22344__$1 = state_22344;
var statearr_22352_22388 = state_22344__$1;
(statearr_22352_22388[(2)] = null);

(statearr_22352_22388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (4))){
var state_22344__$1 = state_22344;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22344__$1,(7),agg_data_channel);
} else {
if((state_val_22345 === (15))){
var inst_22301 = (state_22344[(7)]);
var state_22344__$1 = state_22344;
var statearr_22353_22389 = state_22344__$1;
(statearr_22353_22389[(2)] = inst_22301);

(statearr_22353_22389[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (21))){
var inst_22333 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_22344__$1 = state_22344;
var statearr_22354_22390 = state_22344__$1;
(statearr_22354_22390[(2)] = inst_22333);

(statearr_22354_22390[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (13))){
var inst_22313 = (state_22344[(2)]);
var state_22344__$1 = state_22344;
var statearr_22355_22391 = state_22344__$1;
(statearr_22355_22391[(2)] = inst_22313);

(statearr_22355_22391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (22))){
var state_22344__$1 = state_22344;
var statearr_22356_22392 = state_22344__$1;
(statearr_22356_22392[(2)] = null);

(statearr_22356_22392[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (6))){
var inst_22340 = (state_22344[(2)]);
var state_22344__$1 = state_22344;
var statearr_22357_22393 = state_22344__$1;
(statearr_22357_22393[(2)] = inst_22340);

(statearr_22357_22393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (17))){
var inst_22322 = (state_22344[(10)]);
var inst_22323 = (state_22344[(8)]);
var inst_22325 = callback.call(null,inst_22322,inst_22323);
var state_22344__$1 = state_22344;
var statearr_22358_22394 = state_22344__$1;
(statearr_22358_22394[(2)] = inst_22325);

(statearr_22358_22394[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (3))){
var inst_22342 = (state_22344[(2)]);
var state_22344__$1 = state_22344;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22344__$1,inst_22342);
} else {
if((state_val_22345 === (12))){
var state_22344__$1 = state_22344;
var statearr_22359_22395 = state_22344__$1;
(statearr_22359_22395[(2)] = false);

(statearr_22359_22395[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (2))){
var state_22344__$1 = state_22344;
var statearr_22360_22396 = state_22344__$1;
(statearr_22360_22396[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (23))){
var inst_22336 = (state_22344[(2)]);
var state_22344__$1 = (function (){var statearr_22362 = state_22344;
(statearr_22362[(11)] = inst_22336);

return statearr_22362;
})();
var statearr_22363_22397 = state_22344__$1;
(statearr_22363_22397[(2)] = null);

(statearr_22363_22397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (19))){
var inst_22328 = (state_22344[(2)]);
var inst_22329 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_22344__$1 = (function (){var statearr_22364 = state_22344;
(statearr_22364[(12)] = inst_22328);

return statearr_22364;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22344__$1,(20),inst_22329);
} else {
if((state_val_22345 === (11))){
var state_22344__$1 = state_22344;
var statearr_22365_22398 = state_22344__$1;
(statearr_22365_22398[(2)] = true);

(statearr_22365_22398[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (9))){
var state_22344__$1 = state_22344;
var statearr_22366_22399 = state_22344__$1;
(statearr_22366_22399[(2)] = false);

(statearr_22366_22399[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (5))){
var state_22344__$1 = state_22344;
var statearr_22367_22400 = state_22344__$1;
(statearr_22367_22400[(2)] = null);

(statearr_22367_22400[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (14))){
var inst_22301 = (state_22344[(7)]);
var inst_22318 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22301);
var state_22344__$1 = state_22344;
var statearr_22368_22401 = state_22344__$1;
(statearr_22368_22401[(2)] = inst_22318);

(statearr_22368_22401[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (16))){
var inst_22322 = (state_22344[(10)]);
var inst_22321 = (state_22344[(2)]);
var inst_22322__$1 = cljs.core.get.call(null,inst_22321,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_22323 = cljs.core.get.call(null,inst_22321,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_22344__$1 = (function (){var statearr_22369 = state_22344;
(statearr_22369[(10)] = inst_22322__$1);

(statearr_22369[(8)] = inst_22323);

return statearr_22369;
})();
if(cljs.core.truth_(inst_22322__$1)){
var statearr_22370_22402 = state_22344__$1;
(statearr_22370_22402[(1)] = (17));

} else {
var statearr_22371_22403 = state_22344__$1;
(statearr_22371_22403[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (10))){
var inst_22316 = (state_22344[(2)]);
var state_22344__$1 = state_22344;
if(cljs.core.truth_(inst_22316)){
var statearr_22372_22404 = state_22344__$1;
(statearr_22372_22404[(1)] = (14));

} else {
var statearr_22373_22405 = state_22344__$1;
(statearr_22373_22405[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (18))){
var state_22344__$1 = state_22344;
var statearr_22374_22406 = state_22344__$1;
(statearr_22374_22406[(2)] = null);

(statearr_22374_22406[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22345 === (8))){
var inst_22301 = (state_22344[(7)]);
var inst_22306 = inst_22301.cljs$lang$protocol_mask$partition0$;
var inst_22307 = (inst_22306 & (64));
var inst_22308 = inst_22301.cljs$core$ISeq$;
var inst_22309 = (inst_22307) || (inst_22308);
var state_22344__$1 = state_22344;
if(cljs.core.truth_(inst_22309)){
var statearr_22375_22407 = state_22344__$1;
(statearr_22375_22407[(1)] = (11));

} else {
var statearr_22376_22408 = state_22344__$1;
(statearr_22376_22408[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__))
;
return ((function (switch__13104__auto__,c__13216__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____0 = (function (){
var statearr_22380 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22380[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__);

(statearr_22380[(1)] = (1));

return statearr_22380;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____1 = (function (state_22344){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__.call(null,state_22344);
if(cljs.core.keyword_identical_QMARK_.call(null,result__13107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e22381){if((e22381 instanceof Object)){
var ex__13108__auto__ = e22381;
var statearr_22382_22409 = state_22344;
(statearr_22382_22409[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22344);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__13106__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22410 = state_22344;
state_22344 = G__22410;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__ = function(state_22344){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____1.call(this,state_22344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__))
})();
var state__13218__auto__ = (function (){var statearr_22383 = f__13217__auto__.call(null);
(statearr_22383[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_22383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__13218__auto__);
});})(c__13216__auto__))
);

return c__13216__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22417 = arguments.length;
var i__7485__auto___22418 = (0);
while(true){
if((i__7485__auto___22418 < len__7484__auto___22417)){
args__7491__auto__.push((arguments[i__7485__auto___22418]));

var G__22419 = (i__7485__auto___22418 + (1));
i__7485__auto___22418 = G__22419;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__22414){
var map__22415 = p__22414;
var map__22415__$1 = ((((!((map__22415 == null)))?((((map__22415.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22415.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22415):map__22415);
var oboe_headers = cljs.core.get.call(null,map__22415__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__22415,map__22415__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__22415,map__22415__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__22415,map__22415__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__22415,map__22415__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq22411){
var G__22412 = cljs.core.first.call(null,seq22411);
var seq22411__$1 = cljs.core.next.call(null,seq22411);
var G__22413 = cljs.core.first.call(null,seq22411__$1);
var seq22411__$2 = cljs.core.next.call(null,seq22411__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22412,G__22413,seq22411__$2);
});

