// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0))], 0))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__38413_SHARP_){
if(typeof p1__38413_SHARP_ === 'string'){
return clojure.string.lower_case(p1__38413_SHARP_);
} else {
return p1__38413_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__38419){
var vec__38420 = p__38419;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38420,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38420,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__38414_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__38414_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,chimera.string.escape_for_type(clj_value),cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true,cljs.core.cst$kw$field_DASH_key,field_key], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__38423 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__38423__$1 = ((((!((map__38423 == null)))?((((map__38423.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38423.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38423):map__38423);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38423__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38423__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38423__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$delete_DASH_record,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$data_DASH_id,value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_eye,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38456 = arguments.length;
var i__7485__auto___38457 = (0);
while(true){
if((i__7485__auto___38457 < len__7484__auto___38456)){
args__7491__auto__.push((arguments[i__7485__auto___38457]));

var G__38458 = (i__7485__auto___38457 + (1));
i__7485__auto___38457 = G__38458;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__38428){
var map__38429 = p__38428;
var map__38429__$1 = ((((!((map__38429 == null)))?((((map__38429.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38429.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38429):map__38429);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38429__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38429__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38429__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38429__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__38431 = cljs.core.false_QMARK_;
var G__38432 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__38431,map__38429,map__38429__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__38425_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__38425_SHARP_)) == null);
});})(G__38431,map__38429,map__38429__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__38431,G__38432) : chimera.core.any_QMARK_.call(null,G__38431,G__38432));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__38429,map__38429__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__38433(s__38434){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__38429,map__38429__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__38434__$1 = s__38434;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38434__$1);
if(temp__4657__auto__){
var s__38434__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38434__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38434__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38436 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38435 = (0);
while(true){
if((i__38435 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38435);
cljs.core.chunk_append(b__38436,(function (){var map__38447 = field;
var map__38447__$1 = ((((!((map__38447 == null)))?((((map__38447.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38447.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38447):map__38447);
var map__38448 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38447__$1,cljs.core.cst$kw$instance);
var map__38448__$1 = ((((!((map__38448 == null)))?((((map__38448.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38448.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38448):map__38448);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38448__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38447__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38447__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38447__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__38459 = (i__38435 + (1));
i__38435 = G__38459;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38436),hatti$views$table$iter__38433(cljs.core.chunk_rest(s__38434__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38436),null);
}
} else {
var field = cljs.core.first(s__38434__$2);
return cljs.core.cons((function (){var map__38451 = field;
var map__38451__$1 = ((((!((map__38451 == null)))?((((map__38451.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38451.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38451):map__38451);
var map__38452 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38451__$1,cljs.core.cst$kw$instance);
var map__38452__$1 = ((((!((map__38452 == null)))?((((map__38452.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38452.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38452):map__38452);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38452__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38451__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38451__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38451__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__38433(cljs.core.rest(s__38434__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__38429,map__38429__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__38429,map__38429__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields(form));
})();
return cljs.core.clj__GT_js((function (){var G__38455 = columns;
if(cljs.core.not(hide_actions_column_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__38455,hatti.views.table.actions_column(owner,has_hxl_QMARK_));
} else {
return G__38455;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq38426){
var G__38427 = cljs.core.first(seq38426);
var seq38426__$1 = cljs.core.next(seq38426);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__38427,seq38426__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__38461 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__38461);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38480(s__38481){
return (new cljs.core.LazySeq(null,(function (){
var s__38481__$1 = s__38481;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38481__$1);
if(temp__4657__auto__){
var s__38481__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38481__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38481__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38483 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38482 = (0);
while(true){
if((i__38482 < size__7188__auto__)){
var vec__38492 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38482);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38492,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38492,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__38483,event.subscribe(handler_function));

var G__38498 = (i__38482 + (1));
i__38482 = G__38498;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38483),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38480(cljs.core.chunk_rest(s__38481__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38483),null);
}
} else {
var vec__38495 = cljs.core.first(s__38481__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38495,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38495,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38480(cljs.core.rest(s__38481__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38517(s__38518){
return (new cljs.core.LazySeq(null,(function (){
var s__38518__$1 = s__38518;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38518__$1);
if(temp__4657__auto__){
var s__38518__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38518__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38518__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38520 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38519 = (0);
while(true){
if((i__38519 < size__7188__auto__)){
var vec__38529 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38519);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38529,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38529,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__38520,event.subscribe(handler_function));

var G__38535 = (i__38519 + (1));
i__38519 = G__38535;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38520),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38517(cljs.core.chunk_rest(s__38518__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38520),null);
}
} else {
var vec__38532 = cljs.core.first(s__38518__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38532,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38532,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38517(cljs.core.rest(s__38518__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__38538 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38538__$1 = ((((!((map__38538 == null)))?((((map__38538.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38538.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38538):map__38538);
var data_to_be_deleted = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38538__$1,cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted);
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted], null),((function (map__38538,map__38538__$1,data_to_be_deleted,fn){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(data_to_be_deleted,data_id) : fn.call(null,data_to_be_deleted,data_id));
});})(map__38538,map__38538__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector([cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector(data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__38544 = cljs.core.seq(cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var chunk__38545 = null;
var count__38546 = (0);
var i__38547 = (0);
while(true){
if((i__38547 < count__38546)){
var data_id = chunk__38545.cljs$core$IIndexed$_nth$arity$2(null,i__38547);
var element_38548 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38548.checked = true;

var G__38549 = seq__38544;
var G__38550 = chunk__38545;
var G__38551 = count__38546;
var G__38552 = (i__38547 + (1));
seq__38544 = G__38549;
chunk__38545 = G__38550;
count__38546 = G__38551;
i__38547 = G__38552;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38544);
if(temp__4657__auto__){
var seq__38544__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38544__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38544__$1);
var G__38553 = cljs.core.chunk_rest(seq__38544__$1);
var G__38554 = c__7220__auto__;
var G__38555 = cljs.core.count(c__7220__auto__);
var G__38556 = (0);
seq__38544 = G__38553;
chunk__38545 = G__38554;
count__38546 = G__38555;
i__38547 = G__38556;
continue;
} else {
var data_id = cljs.core.first(seq__38544__$1);
var element_38557 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38557.checked = true;

var G__38558 = cljs.core.next(seq__38544__$1);
var G__38559 = null;
var G__38560 = (0);
var G__38561 = (0);
seq__38544 = G__38558;
chunk__38545 = G__38559;
count__38546 = G__38560;
i__38547 = G__38561;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity(indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(indexes_of_selected_checkboxes));
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__38562){
var map__38581 = p__38562;
var map__38581__$1 = ((((!((map__38581 == null)))?((((map__38581.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38581.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38581):map__38581);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38581__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38581__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__38583 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38583__$1 = ((((!((map__38583 == null)))?((((map__38583.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38583.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38583):map__38583);
var map__38584 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38583__$1,cljs.core.cst$kw$table_DASH_page);
var map__38584__$1 = ((((!((map__38584 == null)))?((((map__38584.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38584.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38584):map__38584);
var map__38585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38584__$1,cljs.core.cst$kw$paging);
var map__38585__$1 = ((((!((map__38585 == null)))?((((map__38585.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38585.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38585):map__38585);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38585__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38585__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38584__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selectActiveRow,false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted();

return hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
});})(map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__38589_38599 = cljs.core.seq(records_to_be_deleted);
var chunk__38590_38600 = null;
var count__38591_38601 = (0);
var i__38592_38602 = (0);
while(true){
if((i__38592_38602 < count__38591_38601)){
var record_38603 = chunk__38590_38600.cljs$core$IIndexed$_nth$arity$2(null,i__38592_38602);
record_38603.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38593 = record_38603.getAttribute("data-id");
return parseInt(G__38593);
})());

var G__38604 = seq__38589_38599;
var G__38605 = chunk__38590_38600;
var G__38606 = count__38591_38601;
var G__38607 = (i__38592_38602 + (1));
seq__38589_38599 = G__38604;
chunk__38590_38600 = G__38605;
count__38591_38601 = G__38606;
i__38592_38602 = G__38607;
continue;
} else {
var temp__4657__auto___38608 = cljs.core.seq(seq__38589_38599);
if(temp__4657__auto___38608){
var seq__38589_38609__$1 = temp__4657__auto___38608;
if(cljs.core.chunked_seq_QMARK_(seq__38589_38609__$1)){
var c__7220__auto___38610 = cljs.core.chunk_first(seq__38589_38609__$1);
var G__38611 = cljs.core.chunk_rest(seq__38589_38609__$1);
var G__38612 = c__7220__auto___38610;
var G__38613 = cljs.core.count(c__7220__auto___38610);
var G__38614 = (0);
seq__38589_38599 = G__38611;
chunk__38590_38600 = G__38612;
count__38591_38601 = G__38613;
i__38592_38602 = G__38614;
continue;
} else {
var record_38615 = cljs.core.first(seq__38589_38609__$1);
record_38615.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38594 = record_38615.getAttribute("data-id");
return parseInt(G__38594);
})());

var G__38616 = cljs.core.next(seq__38589_38609__$1);
var G__38617 = null;
var G__38618 = (0);
var G__38619 = (0);
seq__38589_38599 = G__38616;
chunk__38590_38600 = G__38617;
count__38591_38601 = G__38618;
i__38592_38602 = G__38619;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
return null;
}
});})(map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__38596 = elem.getAttribute("data-id");
return parseInt(G__38596);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__38595 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38595__$1 = ((((!((map__38595 == null)))?((((map__38595.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38595.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38595):map__38595);
var selected_table_rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38595__$1,cljs.core.cst$kw$selected_DASH_table_DASH_rows);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = (function (){var G__38598 = grid.getCellFromEvent(e).row;
return parseInt(G__38598);
})();
hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_();

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38595,map__38595__$1,selected_table_rows,map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(selected_table_rows,row__$1) : fn.call(null,selected_table_rows,row__$1));
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38595,map__38595__$1,selected_table_rows,map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
}
});})(map__38583,map__38583__$1,map__38584,map__38584__$1,map__38585,map__38585__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38581,map__38581__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,event_chan){
return (function (state_38911){
var state_val_38912 = (state_38911[(1)]);
if((state_val_38912 === (7))){
var inst_38809 = (state_38911[(7)]);
var inst_38809__$1 = (state_38911[(2)]);
var inst_38811 = (inst_38809__$1 == null);
var inst_38812 = cljs.core.not(inst_38811);
var state_38911__$1 = (function (){var statearr_38913 = state_38911;
(statearr_38913[(7)] = inst_38809__$1);

return statearr_38913;
})();
if(inst_38812){
var statearr_38914_38989 = state_38911__$1;
(statearr_38914_38989[(1)] = (8));

} else {
var statearr_38915_38990 = state_38911__$1;
(statearr_38915_38990[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (20))){
var inst_38831 = (state_38911[(8)]);
var inst_38839 = (state_38911[(9)]);
var inst_38848 = (inst_38839.cljs$core$IFn$_invoke$arity$1 ? inst_38839.cljs$core$IFn$_invoke$arity$1(inst_38831) : inst_38839.call(null,inst_38831));
var state_38911__$1 = state_38911;
var statearr_38916_38991 = state_38911__$1;
(statearr_38916_38991[(2)] = inst_38848);

(statearr_38916_38991[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (27))){
var state_38911__$1 = state_38911;
var statearr_38917_38992 = state_38911__$1;
(statearr_38917_38992[(2)] = null);

(statearr_38917_38992[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (1))){
var state_38911__$1 = state_38911;
var statearr_38918_38993 = state_38911__$1;
(statearr_38918_38993[(2)] = null);

(statearr_38918_38993[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (24))){
var state_38911__$1 = state_38911;
var statearr_38919_38994 = state_38911__$1;
(statearr_38919_38994[(2)] = null);

(statearr_38919_38994[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (4))){
var state_38911__$1 = state_38911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38911__$1,(7),event_chan);
} else {
if((state_val_38912 === (15))){
var inst_38809 = (state_38911[(7)]);
var state_38911__$1 = state_38911;
var statearr_38920_38995 = state_38911__$1;
(statearr_38920_38995[(2)] = inst_38809);

(statearr_38920_38995[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (21))){
var state_38911__$1 = state_38911;
var statearr_38921_38996 = state_38911__$1;
(statearr_38921_38996[(2)] = null);

(statearr_38921_38996[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (31))){
var inst_38835 = (state_38911[(10)]);
var inst_38884 = (state_38911[(2)]);
var inst_38885 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38835,cljs.core.cst$kw$table);
var state_38911__$1 = (function (){var statearr_38922 = state_38911;
(statearr_38922[(11)] = inst_38884);

return statearr_38922;
})();
if(inst_38885){
var statearr_38923_38997 = state_38911__$1;
(statearr_38923_38997[(1)] = (32));

} else {
var statearr_38924_38998 = state_38911__$1;
(statearr_38924_38998[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (32))){
var inst_38831 = (state_38911[(8)]);
var inst_38840 = (state_38911[(12)]);
var inst_38833 = (state_38911[(13)]);
var inst_38835 = (state_38911[(10)]);
var inst_38829 = (state_38911[(14)]);
var inst_38830 = (state_38911[(15)]);
var inst_38839 = (state_38911[(9)]);
var inst_38832 = (state_38911[(16)]);
var inst_38834 = (state_38911[(17)]);
var inst_38898 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38899 = (function (){var new_columns = inst_38834;
var submission_clicked = inst_38831;
var submission_unclicked = inst_38832;
var get_submission_data = inst_38840;
var re_render = inst_38835;
var update_data_BANG_ = inst_38839;
var submission_to_rank = inst_38830;
var c__13216__auto____$1 = inst_38898;
var filter_by = inst_38833;
var map__38807 = inst_38829;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38898,state_val_38912,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38898,state_val_38912,c__13216__auto__,event_chan){
return (function (state_38896){
var state_val_38897 = (state_38896[(1)]);
if((state_val_38897 === (1))){
var inst_38887 = cljs.core.async.timeout((20));
var state_38896__$1 = state_38896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38896__$1,(2),inst_38887);
} else {
if((state_val_38897 === (2))){
var inst_38889 = (state_38896[(2)]);
var inst_38890 = grid.resizeCanvas();
var inst_38891 = grid.invalidateAllRows();
var inst_38892 = hatti.views.table.resizeColumns(grid);
var inst_38893 = grid.render();
var inst_38894 = hatti.views.table.init_sg_pager(grid,dataview);
var state_38896__$1 = (function (){var statearr_38925 = state_38896;
(statearr_38925[(7)] = inst_38892);

(statearr_38925[(8)] = inst_38889);

(statearr_38925[(9)] = inst_38891);

(statearr_38925[(10)] = inst_38893);

(statearr_38925[(11)] = inst_38890);

return statearr_38925;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38896__$1,inst_38894);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38898,state_val_38912,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38898,state_val_38912,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_38929 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38929[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_38929[(1)] = (1));

return statearr_38929;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38896){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38896);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e38930){if((e38930 instanceof Object)){
var ex__13108__auto__ = e38930;
var statearr_38931_38999 = state_38896;
(statearr_38931_38999[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38896);

return cljs.core.cst$kw$recur;
} else {
throw e38930;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39000 = state_38896;
state_38896 = G__39000;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38896){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38898,state_val_38912,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_38932 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_38932[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_38932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38898,state_val_38912,c__13216__auto__,event_chan))
})();
var inst_38900 = cljs.core.async.impl.dispatch.run(inst_38899);
var state_38911__$1 = (function (){var statearr_38933 = state_38911;
(statearr_38933[(18)] = inst_38900);

return statearr_38933;
})();
var statearr_38934_39001 = state_38911__$1;
(statearr_38934_39001[(2)] = inst_38898);

(statearr_38934_39001[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (33))){
var state_38911__$1 = state_38911;
var statearr_38935_39002 = state_38911__$1;
(statearr_38935_39002[(2)] = null);

(statearr_38935_39002[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (13))){
var inst_38821 = (state_38911[(2)]);
var state_38911__$1 = state_38911;
var statearr_38936_39003 = state_38911__$1;
(statearr_38936_39003[(2)] = inst_38821);

(statearr_38936_39003[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (22))){
var inst_38832 = (state_38911[(16)]);
var inst_38851 = (state_38911[(2)]);
var state_38911__$1 = (function (){var statearr_38937 = state_38911;
(statearr_38937[(19)] = inst_38851);

return statearr_38937;
})();
if(cljs.core.truth_(inst_38832)){
var statearr_38938_39004 = state_38911__$1;
(statearr_38938_39004[(1)] = (23));

} else {
var statearr_38939_39005 = state_38911__$1;
(statearr_38939_39005[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (29))){
var inst_38833 = (state_38911[(13)]);
var inst_38876 = [cljs.core.cst$kw$query];
var inst_38877 = [inst_38833];
var inst_38878 = cljs.core.PersistentHashMap.fromArrays(inst_38876,inst_38877);
var inst_38879 = cljs.core.clj__GT_js(inst_38878);
var inst_38880 = dataview.setFilterArgs(inst_38879);
var inst_38881 = dataview.refresh();
var state_38911__$1 = (function (){var statearr_38940 = state_38911;
(statearr_38940[(20)] = inst_38880);

return statearr_38940;
})();
var statearr_38941_39006 = state_38911__$1;
(statearr_38941_39006[(2)] = inst_38881);

(statearr_38941_39006[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (6))){
var inst_38907 = (state_38911[(2)]);
var state_38911__$1 = state_38911;
var statearr_38942_39007 = state_38911__$1;
(statearr_38942_39007[(2)] = inst_38907);

(statearr_38942_39007[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (28))){
var inst_38833 = (state_38911[(13)]);
var inst_38874 = (state_38911[(2)]);
var state_38911__$1 = (function (){var statearr_38943 = state_38911;
(statearr_38943[(21)] = inst_38874);

return statearr_38943;
})();
if(cljs.core.truth_(inst_38833)){
var statearr_38944_39008 = state_38911__$1;
(statearr_38944_39008[(1)] = (29));

} else {
var statearr_38945_39009 = state_38911__$1;
(statearr_38945_39009[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (25))){
var inst_38834 = (state_38911[(17)]);
var inst_38856 = (state_38911[(2)]);
var state_38911__$1 = (function (){var statearr_38946 = state_38911;
(statearr_38946[(22)] = inst_38856);

return statearr_38946;
})();
if(cljs.core.truth_(inst_38834)){
var statearr_38947_39010 = state_38911__$1;
(statearr_38947_39010[(1)] = (26));

} else {
var statearr_38948_39011 = state_38911__$1;
(statearr_38948_39011[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (34))){
var inst_38903 = (state_38911[(2)]);
var state_38911__$1 = (function (){var statearr_38949 = state_38911;
(statearr_38949[(23)] = inst_38903);

return statearr_38949;
})();
var statearr_38950_39012 = state_38911__$1;
(statearr_38950_39012[(2)] = null);

(statearr_38950_39012[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (17))){
var inst_38840 = (state_38911[(12)]);
var inst_38830 = (state_38911[(15)]);
var inst_38839 = (state_38911[(9)]);
var inst_38842 = (inst_38840.cljs$core$IFn$_invoke$arity$2 ? inst_38840.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_38830) : inst_38840.call(null,hatti.constants._rank,inst_38830));
var inst_38843 = (inst_38839.cljs$core$IFn$_invoke$arity$1 ? inst_38839.cljs$core$IFn$_invoke$arity$1(inst_38842) : inst_38839.call(null,inst_38842));
var state_38911__$1 = state_38911;
var statearr_38951_39013 = state_38911__$1;
(statearr_38951_39013[(2)] = inst_38843);

(statearr_38951_39013[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (3))){
var inst_38909 = (state_38911[(2)]);
var state_38911__$1 = state_38911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38911__$1,inst_38909);
} else {
if((state_val_38912 === (12))){
var state_38911__$1 = state_38911;
var statearr_38952_39014 = state_38911__$1;
(statearr_38952_39014[(2)] = false);

(statearr_38952_39014[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (2))){
var state_38911__$1 = state_38911;
var statearr_38953_39015 = state_38911__$1;
(statearr_38953_39015[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (23))){
var inst_38839 = (state_38911[(9)]);
var inst_38853 = (inst_38839.cljs$core$IFn$_invoke$arity$1 ? inst_38839.cljs$core$IFn$_invoke$arity$1(null) : inst_38839.call(null,null));
var state_38911__$1 = state_38911;
var statearr_38955_39016 = state_38911__$1;
(statearr_38955_39016[(2)] = inst_38853);

(statearr_38955_39016[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (19))){
var inst_38831 = (state_38911[(8)]);
var inst_38846 = (state_38911[(2)]);
var state_38911__$1 = (function (){var statearr_38956 = state_38911;
(statearr_38956[(24)] = inst_38846);

return statearr_38956;
})();
if(cljs.core.truth_(inst_38831)){
var statearr_38957_39017 = state_38911__$1;
(statearr_38957_39017[(1)] = (20));

} else {
var statearr_38958_39018 = state_38911__$1;
(statearr_38958_39018[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (11))){
var state_38911__$1 = state_38911;
var statearr_38959_39019 = state_38911__$1;
(statearr_38959_39019[(2)] = true);

(statearr_38959_39019[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (9))){
var state_38911__$1 = state_38911;
var statearr_38960_39020 = state_38911__$1;
(statearr_38960_39020[(2)] = false);

(statearr_38960_39020[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (5))){
var state_38911__$1 = state_38911;
var statearr_38961_39021 = state_38911__$1;
(statearr_38961_39021[(2)] = null);

(statearr_38961_39021[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (14))){
var inst_38809 = (state_38911[(7)]);
var inst_38826 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38809);
var state_38911__$1 = state_38911;
var statearr_38962_39022 = state_38911__$1;
(statearr_38962_39022[(2)] = inst_38826);

(statearr_38962_39022[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (26))){
var inst_38831 = (state_38911[(8)]);
var inst_38840 = (state_38911[(12)]);
var inst_38833 = (state_38911[(13)]);
var inst_38835 = (state_38911[(10)]);
var inst_38829 = (state_38911[(14)]);
var inst_38830 = (state_38911[(15)]);
var inst_38839 = (state_38911[(9)]);
var inst_38832 = (state_38911[(16)]);
var inst_38834 = (state_38911[(17)]);
var inst_38869 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38870 = (function (){var new_columns = inst_38834;
var submission_clicked = inst_38831;
var submission_unclicked = inst_38832;
var get_submission_data = inst_38840;
var re_render = inst_38835;
var update_data_BANG_ = inst_38839;
var submission_to_rank = inst_38830;
var c__13216__auto____$1 = inst_38869;
var filter_by = inst_38833;
var map__38807 = inst_38829;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38869,state_val_38912,c__13216__auto__,event_chan){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38869,state_val_38912,c__13216__auto__,event_chan){
return (function (state_38867){
var state_val_38868 = (state_38867[(1)]);
if((state_val_38868 === (1))){
var inst_38858 = cljs.core.async.timeout((20));
var state_38867__$1 = state_38867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38867__$1,(2),inst_38858);
} else {
if((state_val_38868 === (2))){
var inst_38860 = (state_38867[(2)]);
var inst_38861 = grid.setColumns(new_columns);
var inst_38862 = hatti.views.table.resizeColumns(grid);
var inst_38863 = grid.render();
var inst_38864 = hatti.views.table.select_rows_marked_to_be_deleted();
var inst_38865 = hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
var state_38867__$1 = (function (){var statearr_38963 = state_38867;
(statearr_38963[(7)] = inst_38861);

(statearr_38963[(8)] = inst_38860);

(statearr_38963[(9)] = inst_38862);

(statearr_38963[(10)] = inst_38864);

(statearr_38963[(11)] = inst_38863);

return statearr_38963;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38867__$1,inst_38865);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38869,state_val_38912,c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38869,state_val_38912,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_38967 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38967[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_38967[(1)] = (1));

return statearr_38967;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38867){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38867);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e38968){if((e38968 instanceof Object)){
var ex__13108__auto__ = e38968;
var statearr_38969_39023 = state_38867;
(statearr_38969_39023[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38867);

return cljs.core.cst$kw$recur;
} else {
throw e38968;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39024 = state_38867;
state_38867 = G__39024;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38867){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38869,state_val_38912,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_38970 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_38970[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto____$1);

return statearr_38970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,re_render,update_data_BANG_,submission_to_rank,c__13216__auto____$1,filter_by,map__38807,inst_38831,inst_38840,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38869,state_val_38912,c__13216__auto__,event_chan))
})();
var inst_38871 = cljs.core.async.impl.dispatch.run(inst_38870);
var state_38911__$1 = (function (){var statearr_38971 = state_38911;
(statearr_38971[(25)] = inst_38871);

return statearr_38971;
})();
var statearr_38972_39025 = state_38911__$1;
(statearr_38972_39025[(2)] = inst_38869);

(statearr_38972_39025[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (16))){
var inst_38831 = (state_38911[(8)]);
var inst_38833 = (state_38911[(13)]);
var inst_38835 = (state_38911[(10)]);
var inst_38829 = (state_38911[(14)]);
var inst_38830 = (state_38911[(15)]);
var inst_38839 = (state_38911[(9)]);
var inst_38832 = (state_38911[(16)]);
var inst_38834 = (state_38911[(17)]);
var inst_38829__$1 = (state_38911[(2)]);
var inst_38830__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38829__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_38831__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38829__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_38832__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38829__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_38833__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38829__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_38834__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38829__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_38835__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38829__$1,cljs.core.cst$kw$re_DASH_render);
var inst_38836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38837 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_38838 = (new cljs.core.PersistentVector(null,3,(5),inst_38836,inst_38837,null));
var inst_38839__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_38838);
var inst_38840 = (function (){var map__38807 = inst_38829__$1;
var submission_to_rank = inst_38830__$1;
var submission_clicked = inst_38831__$1;
var submission_unclicked = inst_38832__$1;
var filter_by = inst_38833__$1;
var new_columns = inst_38834__$1;
var re_render = inst_38835__$1;
var update_data_BANG_ = inst_38839__$1;
return ((function (map__38807,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38831,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38829__$1,inst_38830__$1,inst_38831__$1,inst_38832__$1,inst_38833__$1,inst_38834__$1,inst_38835__$1,inst_38836,inst_38837,inst_38838,inst_38839__$1,state_val_38912,c__13216__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__38807,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38831,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38829__$1,inst_38830__$1,inst_38831__$1,inst_38832__$1,inst_38833__$1,inst_38834__$1,inst_38835__$1,inst_38836,inst_38837,inst_38838,inst_38839__$1,state_val_38912,c__13216__auto__,event_chan){
return (function (p1__38620_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__38620_SHARP_,field));
});})(map__38807,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38831,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38829__$1,inst_38830__$1,inst_38831__$1,inst_38832__$1,inst_38833__$1,inst_38834__$1,inst_38835__$1,inst_38836,inst_38837,inst_38838,inst_38839__$1,state_val_38912,c__13216__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__38807,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38831,inst_38833,inst_38835,inst_38829,inst_38830,inst_38839,inst_38832,inst_38834,inst_38829__$1,inst_38830__$1,inst_38831__$1,inst_38832__$1,inst_38833__$1,inst_38834__$1,inst_38835__$1,inst_38836,inst_38837,inst_38838,inst_38839__$1,state_val_38912,c__13216__auto__,event_chan))
})();
var state_38911__$1 = (function (){var statearr_38973 = state_38911;
(statearr_38973[(8)] = inst_38831__$1);

(statearr_38973[(12)] = inst_38840);

(statearr_38973[(13)] = inst_38833__$1);

(statearr_38973[(10)] = inst_38835__$1);

(statearr_38973[(14)] = inst_38829__$1);

(statearr_38973[(15)] = inst_38830__$1);

(statearr_38973[(9)] = inst_38839__$1);

(statearr_38973[(16)] = inst_38832__$1);

(statearr_38973[(17)] = inst_38834__$1);

return statearr_38973;
})();
if(cljs.core.truth_(inst_38830__$1)){
var statearr_38974_39026 = state_38911__$1;
(statearr_38974_39026[(1)] = (17));

} else {
var statearr_38975_39027 = state_38911__$1;
(statearr_38975_39027[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (30))){
var state_38911__$1 = state_38911;
var statearr_38976_39028 = state_38911__$1;
(statearr_38976_39028[(2)] = null);

(statearr_38976_39028[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (10))){
var inst_38824 = (state_38911[(2)]);
var state_38911__$1 = state_38911;
if(cljs.core.truth_(inst_38824)){
var statearr_38977_39029 = state_38911__$1;
(statearr_38977_39029[(1)] = (14));

} else {
var statearr_38978_39030 = state_38911__$1;
(statearr_38978_39030[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (18))){
var state_38911__$1 = state_38911;
var statearr_38979_39031 = state_38911__$1;
(statearr_38979_39031[(2)] = null);

(statearr_38979_39031[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38912 === (8))){
var inst_38809 = (state_38911[(7)]);
var inst_38814 = inst_38809.cljs$lang$protocol_mask$partition0$;
var inst_38815 = (inst_38814 & (64));
var inst_38816 = inst_38809.cljs$core$ISeq$;
var inst_38817 = (inst_38815) || (inst_38816);
var state_38911__$1 = state_38911;
if(cljs.core.truth_(inst_38817)){
var statearr_38980_39032 = state_38911__$1;
(statearr_38980_39032[(1)] = (11));

} else {
var statearr_38981_39033 = state_38911__$1;
(statearr_38981_39033[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__13216__auto__,event_chan))
;
return ((function (switch__13104__auto__,c__13216__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____0 = (function (){
var statearr_38985 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38985[(0)] = hatti$views$table$handle_table_events_$_state_machine__13105__auto__);

(statearr_38985[(1)] = (1));

return statearr_38985;
});
var hatti$views$table$handle_table_events_$_state_machine__13105__auto____1 = (function (state_38911){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_38911);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e38986){if((e38986 instanceof Object)){
var ex__13108__auto__ = e38986;
var statearr_38987_39034 = state_38911;
(statearr_38987_39034[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38911);

return cljs.core.cst$kw$recur;
} else {
throw e38986;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39035 = state_38911;
state_38911 = G__39035;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__13105__auto__ = function(state_38911){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__13105__auto____1.call(this,state_38911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____0;
hatti$views$table$handle_table_events_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__13105__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,event_chan))
})();
var state__13218__auto__ = (function (){var statearr_38988 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_38988[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_38988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__,event_chan))
);

return c__13216__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$field_DASH_key,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__39054(s__39055){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__39055__$1 = s__39055;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39055__$1);
if(temp__4657__auto__){
var s__39055__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39055__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39055__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39057 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39056 = (0);
while(true){
if((i__39056 < size__7188__auto__)){
var vec__39066 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39056);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39066,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39066,(1),null);
cljs.core.chunk_append(b__39057,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__39056,vec__39066,k,v,c__7187__auto__,size__7188__auto__,b__39057,s__39055__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__39056,vec__39066,k,v,c__7187__auto__,size__7188__auto__,b__39057,s__39055__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__39072 = (i__39056 + (1));
i__39056 = G__39072;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39057),hatti$views$table$render_options_$_iter__39054(cljs.core.chunk_rest(s__39055__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39057),null);
}
} else {
var vec__39069 = cljs.core.first(s__39055__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39069,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39069,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__39069,k,v,s__39055__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__39069,k,v,s__39055__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__39054(cljs.core.rest(s__39055__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39074 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39074 = (function (_,owner,meta39075){
this._ = _;
this.owner = owner;
this.meta39075 = meta39075;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39074.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39076,meta39075__$1){
var self__ = this;
var _39076__$1 = this;
return (new hatti.views.table.t_hatti$views$table39074(self__._,self__.owner,meta39075__$1));
});

hatti.views.table.t_hatti$views$table39074.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39076){
var self__ = this;
var _39076__$1 = this;
return self__.meta39075;
});

hatti.views.table.t_hatti$views$table39074.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table39074.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table39074.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39074.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__39077){
var self__ = this;
var map__39078 = p__39077;
var map__39078__$1 = ((((!((map__39078 == null)))?((((map__39078.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39078.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39078):map__39078);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39078__$1,cljs.core.cst$kw$field_DASH_key);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39078__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__39080 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39080__$1 = ((((!((map__39080 == null)))?((((map__39080.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39080.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39080):map__39080);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39080__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__39080,map__39080__$1,flat_form,new_language,___$2,map__39078,map__39078__$1,field_key,language){
return (function (p1__39073_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__39073_SHARP_),cljs.core.cst$kw$language,new_language], 0))], null));
});})(options,map__39080,map__39080__$1,flat_form,new_language,___$2,map__39078,map__39078__$1,field_key,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(field_key);
} else {
}

var G__39090 = ({"className": "label-changer"});
var G__39091 = (function (){var G__39093 = ({"className": "label-changer-label"});
var G__39094 = "Show:";
return React.DOM.span(G__39093,G__39094);
})();
var G__39092 = (function (){var G__39095 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__39096 = (function (){var attrs39084 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(field_key) : options.call(null,field_key));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39084))?sablono.interpreter.attributes(attrs39084):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39084))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39098 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39098);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39084),(function (){var G__39099 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39099);
})()], null))));
})();
var G__39097 = (function (){var attrs39089 = hatti.views.table.render_options(options,self__.owner,colset_BANG_);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.ul,((cljs.core.map_QMARK_(attrs39089))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs39089], 0))):({"className": "submenu no-dot"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39089))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39089)], null))));
})();
return React.DOM.div(G__39095,G__39096,G__39097);
})();
return React.DOM.div(G__39090,G__39091,G__39092);
});

hatti.views.table.t_hatti$views$table39074.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39075], null);
});

hatti.views.table.t_hatti$views$table39074.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39074.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39074";

hatti.views.table.t_hatti$views$table39074.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39074");
});

hatti.views.table.__GT_t_hatti$views$table39074 = (function hatti$views$table$__GT_t_hatti$views$table39074(___$1,owner__$1,meta39075){
return (new hatti.views.table.t_hatti$views$table39074(___$1,owner__$1,meta39075));
});

}

return (new hatti.views.table.t_hatti$views$table39074(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__13216__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__13216__auto__,query){
return (function (){
var f__13217__auto__ = (function (){var switch__13104__auto__ = ((function (c__13216__auto__,query){
return (function (state_39142){
var state_val_39143 = (state_39142[(1)]);
if((state_val_39143 === (1))){
var inst_39128 = cljs.core.async.timeout((150));
var state_39142__$1 = state_39142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39142__$1,(2),inst_39128);
} else {
if((state_val_39143 === (2))){
var inst_39130 = (state_39142[(2)]);
var inst_39131 = input.value;
var inst_39132 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_39131);
var state_39142__$1 = (function (){var statearr_39144 = state_39142;
(statearr_39144[(7)] = inst_39130);

return statearr_39144;
})();
if(inst_39132){
var statearr_39145_39156 = state_39142__$1;
(statearr_39145_39156[(1)] = (3));

} else {
var statearr_39146_39157 = state_39142__$1;
(statearr_39146_39157[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39143 === (3))){
var inst_39134 = [query_event_key];
var inst_39135 = [query];
var inst_39136 = cljs.core.PersistentHashMap.fromArrays(inst_39134,inst_39135);
var inst_39137 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_39136);
var state_39142__$1 = state_39142;
var statearr_39147_39158 = state_39142__$1;
(statearr_39147_39158[(2)] = inst_39137);

(statearr_39147_39158[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39143 === (4))){
var state_39142__$1 = state_39142;
var statearr_39148_39159 = state_39142__$1;
(statearr_39148_39159[(2)] = null);

(statearr_39148_39159[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39143 === (5))){
var inst_39140 = (state_39142[(2)]);
var state_39142__$1 = state_39142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39142__$1,inst_39140);
} else {
return null;
}
}
}
}
}
});})(c__13216__auto__,query))
;
return ((function (switch__13104__auto__,c__13216__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__13105__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__13105__auto____0 = (function (){
var statearr_39152 = [null,null,null,null,null,null,null,null];
(statearr_39152[(0)] = hatti$views$table$delayed_search_$_state_machine__13105__auto__);

(statearr_39152[(1)] = (1));

return statearr_39152;
});
var hatti$views$table$delayed_search_$_state_machine__13105__auto____1 = (function (state_39142){
while(true){
var ret_value__13106__auto__ = (function (){try{while(true){
var result__13107__auto__ = switch__13104__auto__(state_39142);
if(cljs.core.keyword_identical_QMARK_(result__13107__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13107__auto__;
}
break;
}
}catch (e39153){if((e39153 instanceof Object)){
var ex__13108__auto__ = e39153;
var statearr_39154_39160 = state_39142;
(statearr_39154_39160[(5)] = ex__13108__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39142);

return cljs.core.cst$kw$recur;
} else {
throw e39153;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13106__auto__,cljs.core.cst$kw$recur)){
var G__39161 = state_39142;
state_39142 = G__39161;
continue;
} else {
return ret_value__13106__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__13105__auto__ = function(state_39142){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__13105__auto____1.call(this,state_39142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__13105__auto____0;
hatti$views$table$delayed_search_$_state_machine__13105__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__13105__auto____1;
return hatti$views$table$delayed_search_$_state_machine__13105__auto__;
})()
;})(switch__13104__auto__,c__13216__auto__,query))
})();
var state__13218__auto__ = (function (){var statearr_39155 = (f__13217__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13217__auto__.cljs$core$IFn$_invoke$arity$0() : f__13217__auto__.call(null));
(statearr_39155[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__13216__auto__);

return statearr_39155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13218__auto__);
});})(c__13216__auto__,query))
);

return c__13216__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39163 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39163 = (function (_,owner,meta39164){
this._ = _;
this.owner = owner;
this.meta39164 = meta39164;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39163.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39165,meta39164__$1){
var self__ = this;
var _39165__$1 = this;
return (new hatti.views.table.t_hatti$views$table39163(self__._,self__.owner,meta39164__$1));
});

hatti.views.table.t_hatti$views$table39163.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39165){
var self__ = this;
var _39165__$1 = this;
return self__.meta39164;
});

hatti.views.table.t_hatti$views$table39163.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39163.prototype.om$core$IRender$render$arity$1 = (function (this__19151__auto__){
var self__ = this;
var this__19151__auto____$1 = this;
var G__39168 = ({"className": "table-search"});
var G__39169 = (function (){var G__39171 = ({"className": "fa fa-search"});
return React.DOM.i(G__39171);
})();
var G__39170 = (function (){var G__39172 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__39168,G__39169,this__19151__auto____$1){
return (function (p1__39162_SHARP_){
return hatti.views.table.delayed_search(p1__39162_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__39168,G__39169,this__19151__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__39172) : sablono.interpreter.input.call(null,G__39172));
})();
return React.DOM.div(G__39168,G__39169,G__39170);
});

hatti.views.table.t_hatti$views$table39163.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39164], null);
});

hatti.views.table.t_hatti$views$table39163.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39163.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39163";

hatti.views.table.t_hatti$views$table39163.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39163");
});

hatti.views.table.__GT_t_hatti$views$table39163 = (function hatti$views$table$__GT_t_hatti$views$table39163(___$1,owner__$1,meta39164){
return (new hatti.views.table.t_hatti$views$table39163(___$1,owner__$1,meta39164));
});

}

return (new hatti.views.table.t_hatti$views$table39163(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table39173 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39173 = (function (cursor,owner,meta39174){
this.cursor = cursor;
this.owner = owner;
this.meta39174 = meta39174;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39173.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39175,meta39174__$1){
var self__ = this;
var _39175__$1 = this;
return (new hatti.views.table.t_hatti$views$table39173(self__.cursor,self__.owner,meta39174__$1));
});

hatti.views.table.t_hatti$views$table39173.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39175){
var self__ = this;
var _39175__$1 = this;
return self__.meta39174;
});

hatti.views.table.t_hatti$views$table39173.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39173.prototype.om$core$IRender$render$arity$1 = (function (this__19151__auto__){
var self__ = this;
var this__19151__auto____$1 = this;
var G__39178 = ({"className": "topbar"});
var G__39179 = (function (){var G__39183 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__39183);
})();
var G__39180 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__39181 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__39182 = (function (){var G__39184 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__39184);
})();
return React.DOM.div(G__39178,G__39179,G__39180,G__39181,G__39182);
});

hatti.views.table.t_hatti$views$table39173.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39174], null);
});

hatti.views.table.t_hatti$views$table39173.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39173.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39173";

hatti.views.table.t_hatti$views$table39173.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39173");
});

hatti.views.table.__GT_t_hatti$views$table39173 = (function hatti$views$table$__GT_t_hatti$views$table39173(cursor__$1,owner__$1,meta39174){
return (new hatti.views.table.t_hatti$views$table39173(cursor__$1,owner__$1,meta39174));
});

}

return (new hatti.views.table.t_hatti$views$table39173(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__39190 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__39190__$1 = ((((!((map__39190 == null)))?((((map__39190.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39190.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39190):map__39190);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39190__$1,cljs.core.cst$kw$flat_DASH_form);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__39191 = hatti.views.table.sg_init(data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39191,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39191,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39196,owner,p__39197){
var map__39198 = p__39196;
var map__39198__$1 = ((((!((map__39198 == null)))?((((map__39198.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39198.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39198):map__39198);
var cursor = map__39198__$1;
var map__39199 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39198__$1,cljs.core.cst$kw$views);
var map__39199__$1 = ((((!((map__39199 == null)))?((((map__39199.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39199.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39199):map__39199);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39199__$1,cljs.core.cst$kw$active);
var map__39200 = p__39197;
var map__39200__$1 = ((((!((map__39200 == null)))?((((map__39200.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39200.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39200):map__39200);
var opts = map__39200__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39200__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table39204 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39204 = (function (p__39196,owner,active_QMARK_,slick_grid_event_handlers,cursor,map__39198,map__39200,active,opts,p__39197,map__39199,meta39205){
this.p__39196 = p__39196;
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.cursor = cursor;
this.map__39198 = map__39198;
this.map__39200 = map__39200;
this.active = active;
this.opts = opts;
this.p__39197 = p__39197;
this.map__39199 = map__39199;
this.meta39205 = meta39205;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39204.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers){
return (function (_39206,meta39205__$1){
var self__ = this;
var _39206__$1 = this;
return (new hatti.views.table.t_hatti$views$table39204(self__.p__39196,self__.owner,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.cursor,self__.map__39198,self__.map__39200,self__.active,self__.opts,self__.p__39197,self__.map__39199,meta39205__$1));
});})(active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39204.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers){
return (function (_39206){
var self__ = this;
var _39206__$1 = this;
return self__.meta39205;
});})(active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39204.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39204.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers){
return (function (_,p__39207){
var self__ = this;
var map__39208 = p__39207;
var map__39208__$1 = ((((!((map__39208 == null)))?((((map__39208.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39208.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39208):map__39208);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39208__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__39210 = self__.cursor;
var map__39210__$1 = ((((!((map__39210 == null)))?((((map__39210.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39210.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39210):map__39210);
var map__39211 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39210__$1,cljs.core.cst$kw$table_DASH_page);
var map__39211__$1 = ((((!((map__39211 == null)))?((((map__39211.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39211.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39211):map__39211);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39211__$1,cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39211__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39210__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39210__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__39212 = dataset_info;
var map__39212__$1 = ((((!((map__39212 == null)))?((((map__39212.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39212.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39212):map__39212);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39212__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__39210,map__39210__$1,map__39211,map__39211__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__39212,map__39212__$1,num_of_submissions,no_data_QMARK_,___$1,map__39208,map__39208__$1,table_view_height,active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers){
return (function (p1__39195_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__39195_SHARP_], 0));
});})(map__39210,map__39210__$1,map__39211,map__39211__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__39212,map__39212__$1,num_of_submissions,no_data_QMARK_,___$1,map__39208,map__39208__$1,table_view_height,active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var G__39216 = ({"style": cljs.core.clj__GT_js((cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$height,(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height();
}
})(),cljs.core.cst$kw$overflow,"hidden"], null):null)), "className": "table-view"});
var G__39217 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__39218 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__39219 = (function (){var G__39220 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__39221 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__39226 = ({"className": "alert alert-warning"});
var G__39227 = "No data";
return React.DOM.p(G__39226,G__39227);
})():(function (){var G__39228 = null;
var G__39229 = (function (){var G__39231 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__39231);
})();
var G__39230 = "Loading...";
return React.DOM.span(G__39228,G__39229,G__39230);
})());
return React.DOM.div(G__39220,G__39221);
})();
return React.DOM.div(G__39216,G__39217,G__39218,G__39219);
} else {
return null;
}
});})(active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39204.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table39204.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39232 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39232,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39232,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39204.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table39204.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39204.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table39204.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__39235 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39235__$1 = ((((!((map__39235 == null)))?((((map__39235.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39235.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39235):map__39235);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39235__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39235__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39237 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39237,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39237,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39204.getBasis = ((function (active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__39196,cljs.core.cst$sym$owner,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$cursor,cljs.core.cst$sym$map__39198,cljs.core.cst$sym$map__39200,cljs.core.cst$sym$active,cljs.core.cst$sym$opts,cljs.core.cst$sym$p__39197,cljs.core.cst$sym$map__39199,cljs.core.cst$sym$meta39205], null);
});})(active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39204.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39204.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39204";

hatti.views.table.t_hatti$views$table39204.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39204");
});})(active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table39204 = ((function (active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table39204(p__39196__$1,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,cursor__$1,map__39198__$2,map__39200__$2,active__$1,opts__$1,p__39197__$1,map__39199__$2,meta39205){
return (new hatti.views.table.t_hatti$views$table39204(p__39196__$1,owner__$1,active_QMARK___$1,slick_grid_event_handlers__$1,cursor__$1,map__39198__$2,map__39200__$2,active__$1,opts__$1,p__39197__$1,map__39199__$2,meta39205));
});})(active_QMARK_,map__39198,map__39198__$1,cursor,map__39199,map__39199__$1,active,map__39200,map__39200__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table39204(p__39196,owner,active_QMARK_,slick_grid_event_handlers,cursor,map__39198__$1,map__39200__$1,active,opts,p__39197,map__39199__$1,cljs.core.PersistentArrayMap.EMPTY));
}));
