// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__37894__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__37891 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__37892 = cljs.core.seq(vec__37891);
var first__37893 = cljs.core.first(seq__37892);
var seq__37892__$1 = cljs.core.next(seq__37892);
var tag = first__37893;
var body = seq__37892__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.first(body),cljs.core.first(args)], 0)),cljs.core.rest(body));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.vector,tag,cljs.core.first(args),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__37894 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__37895__i = 0, G__37895__a = new Array(arguments.length -  0);
while (G__37895__i < G__37895__a.length) {G__37895__a[G__37895__i] = arguments[G__37895__i + 0]; ++G__37895__i;}
  args = new cljs.core.IndexedSeq(G__37895__a,0);
} 
return G__37894__delegate.call(this,args);};
G__37894.cljs$lang$maxFixedArity = 0;
G__37894.cljs$lang$applyTo = (function (arglist__37896){
var args = cljs.core.seq(arglist__37896);
return G__37894__delegate(args);
});
G__37894.cljs$core$IFn$_invoke$arity$variadic = G__37894__delegate;
return G__37894;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__7189__auto__ = (function sablono$core$update_arglists_$_iter__37903(s__37904){
return (new cljs.core.LazySeq(null,(function (){
var s__37904__$1 = s__37904;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37904__$1);
if(temp__4657__auto__){
var s__37904__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37904__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37904__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37906 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37905 = (0);
while(true){
if((i__37905 < size__7188__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37905);
cljs.core.chunk_append(b__37906,cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)));

var G__37909 = (i__37905 + (1));
i__37905 = G__37909;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37906),sablono$core$update_arglists_$_iter__37903(cljs.core.chunk_rest(s__37904__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37906),null);
}
} else {
var args = cljs.core.first(s__37904__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(cljs.core.cst$sym$attr_DASH_map_QMARK_,args)),sablono$core$update_arglists_$_iter__37903(cljs.core.rest(s__37904__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(arglists);
});
/**
 * Render `element` as HTML string.
 */
sablono.core.render = (function sablono$core$render(element){
if(cljs.core.truth_(element)){
return React.renderToString(element);
} else {
return null;
}
});
/**
 * Render `element` as HTML string, without React internal attributes.
 */
sablono.core.render_static = (function sablono$core$render_static(element){
if(cljs.core.truth_(element)){
return React.renderToStaticMarkup(element);
} else {
return null;
}
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37917 = arguments.length;
var i__7485__auto___37918 = (0);
while(true){
if((i__7485__auto___37918 < len__7484__auto___37917)){
args__7491__auto__.push((arguments[i__7485__auto___37918]));

var G__37919 = (i__7485__auto___37918 + (1));
i__7485__auto___37918 = G__37919;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__7189__auto__ = (function sablono$core$iter__37911(s__37912){
return (new cljs.core.LazySeq(null,(function (){
var s__37912__$1 = s__37912;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37912__$1);
if(temp__4657__auto__){
var s__37912__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37912__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37912__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37914 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37913 = (0);
while(true){
if((i__37913 < size__7188__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37913);
cljs.core.chunk_append(b__37914,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null));

var G__37920 = (i__37913 + (1));
i__37913 = G__37920;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37914),sablono$core$iter__37911(cljs.core.chunk_rest(s__37912__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37914),null);
}
} else {
var style = cljs.core.first(s__37912__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$link,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text/css",cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([style], 0)),cljs.core.cst$kw$rel,"stylesheet"], null)], null),sablono$core$iter__37911(cljs.core.rest(s__37912__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq37910){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37910));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__37925 = goog.dom.getDocument().body;
var G__37926 = (function (){var G__37927 = "script";
var G__37928 = ({"src": src});
return goog.dom.createDom(G__37927,G__37928);
})();
return goog.dom.appendChild(G__37925,G__37926);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to37929 = (function sablono$core$link_to37929(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37932 = arguments.length;
var i__7485__auto___37933 = (0);
while(true){
if((i__7485__auto___37933 < len__7484__auto___37932)){
args__7491__auto__.push((arguments[i__7485__auto___37933]));

var G__37934 = (i__7485__auto___37933 + (1));
i__7485__auto___37933 = G__37934;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to37929.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.link_to37929.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([url], 0))], null),content], null);
});

sablono.core.link_to37929.cljs$lang$maxFixedArity = (1);

sablono.core.link_to37929.cljs$lang$applyTo = (function (seq37930){
var G__37931 = cljs.core.first(seq37930);
var seq37930__$1 = cljs.core.next(seq37930);
return sablono.core.link_to37929.cljs$core$IFn$_invoke$arity$variadic(G__37931,seq37930__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to37929);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to37935 = (function sablono$core$mail_to37935(var_args){
var args__7491__auto__ = [];
var len__7484__auto___37942 = arguments.length;
var i__7485__auto___37943 = (0);
while(true){
if((i__7485__auto___37943 < len__7484__auto___37942)){
args__7491__auto__.push((arguments[i__7485__auto___37943]));

var G__37944 = (i__7485__auto___37943 + (1));
i__7485__auto___37943 = G__37944;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to37935.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.mail_to37935.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__37938){
var vec__37939 = p__37938;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37939,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__6409__auto__ = content;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to37935.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to37935.cljs$lang$applyTo = (function (seq37936){
var G__37937 = cljs.core.first(seq37936);
var seq37936__$1 = cljs.core.next(seq37936);
return sablono.core.mail_to37935.cljs$core$IFn$_invoke$arity$variadic(G__37937,seq37936__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to37935);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list37945 = (function sablono$core$unordered_list37945(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__7189__auto__ = (function sablono$core$unordered_list37945_$_iter__37952(s__37953){
return (new cljs.core.LazySeq(null,(function (){
var s__37953__$1 = s__37953;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37953__$1);
if(temp__4657__auto__){
var s__37953__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37953__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37953__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37955 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37954 = (0);
while(true){
if((i__37954 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37954);
cljs.core.chunk_append(b__37955,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37958 = (i__37954 + (1));
i__37954 = G__37958;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37955),sablono$core$unordered_list37945_$_iter__37952(cljs.core.chunk_rest(s__37953__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37955),null);
}
} else {
var x = cljs.core.first(s__37953__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$unordered_list37945_$_iter__37952(cljs.core.rest(s__37953__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list37945);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list37959 = (function sablono$core$ordered_list37959(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol,(function (){var iter__7189__auto__ = (function sablono$core$ordered_list37959_$_iter__37966(s__37967){
return (new cljs.core.LazySeq(null,(function (){
var s__37967__$1 = s__37967;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37967__$1);
if(temp__4657__auto__){
var s__37967__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37967__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__37967__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__37969 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__37968 = (0);
while(true){
if((i__37968 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__37968);
cljs.core.chunk_append(b__37969,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null));

var G__37972 = (i__37968 + (1));
i__37968 = G__37972;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37969),sablono$core$ordered_list37959_$_iter__37966(cljs.core.chunk_rest(s__37967__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37969),null);
}
} else {
var x = cljs.core.first(s__37967__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,x], null),sablono$core$ordered_list37959_$_iter__37966(cljs.core.rest(s__37967__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list37959);
/**
 * Create an image element.
 */
sablono.core.image37973 = (function sablono$core$image37973(var_args){
var args37974 = [];
var len__7484__auto___37977 = arguments.length;
var i__7485__auto___37978 = (0);
while(true){
if((i__7485__auto___37978 < len__7484__auto___37977)){
args37974.push((arguments[i__7485__auto___37978]));

var G__37979 = (i__7485__auto___37978 + (1));
i__7485__auto___37978 = G__37979;
continue;
} else {
}
break;
}

var G__37976 = args37974.length;
switch (G__37976) {
case 1:
return sablono.core.image37973.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image37973.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37974.length)].join('')));

}
});

sablono.core.image37973.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0))], null)], null);
});

sablono.core.image37973.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$src,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([src], 0)),cljs.core.cst$kw$alt,alt], null)], null);
});

sablono.core.image37973.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image37973);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37981_SHARP_,p2__37982_SHARP_){
return [cljs.core.str(p1__37981_SHARP_),cljs.core.str("["),cljs.core.str(p2__37982_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__37983_SHARP_,p2__37984_SHARP_){
return [cljs.core.str(p1__37983_SHARP_),cljs.core.str("-"),cljs.core.str(p2__37984_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,type,cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field37985 = (function sablono$core$color_field37985(var_args){
var args37986 = [];
var len__7484__auto___38053 = arguments.length;
var i__7485__auto___38054 = (0);
while(true){
if((i__7485__auto___38054 < len__7484__auto___38053)){
args37986.push((arguments[i__7485__auto___38054]));

var G__38055 = (i__7485__auto___38054 + (1));
i__7485__auto___38054 = G__38055;
continue;
} else {
}
break;
}

var G__37988 = args37986.length;
switch (G__37988) {
case 1:
return sablono.core.color_field37985.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field37985.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37986.length)].join('')));

}
});

sablono.core.color_field37985.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.color_field37985.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.color_field37985.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$color)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.color_field37985.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field37985);

/**
 * Creates a date input field.
 */
sablono.core.date_field37989 = (function sablono$core$date_field37989(var_args){
var args37990 = [];
var len__7484__auto___38057 = arguments.length;
var i__7485__auto___38058 = (0);
while(true){
if((i__7485__auto___38058 < len__7484__auto___38057)){
args37990.push((arguments[i__7485__auto___38058]));

var G__38059 = (i__7485__auto___38058 + (1));
i__7485__auto___38058 = G__38059;
continue;
} else {
}
break;
}

var G__37992 = args37990.length;
switch (G__37992) {
case 1:
return sablono.core.date_field37989.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field37989.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37990.length)].join('')));

}
});

sablono.core.date_field37989.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.date_field37989.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.date_field37989.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$date)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.date_field37989.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field37989);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field37993 = (function sablono$core$datetime_field37993(var_args){
var args37994 = [];
var len__7484__auto___38061 = arguments.length;
var i__7485__auto___38062 = (0);
while(true){
if((i__7485__auto___38062 < len__7484__auto___38061)){
args37994.push((arguments[i__7485__auto___38062]));

var G__38063 = (i__7485__auto___38062 + (1));
i__7485__auto___38062 = G__38063;
continue;
} else {
}
break;
}

var G__37996 = args37994.length;
switch (G__37996) {
case 1:
return sablono.core.datetime_field37993.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field37993.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37994.length)].join('')));

}
});

sablono.core.datetime_field37993.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.datetime_field37993.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.datetime_field37993.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.datetime_field37993.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field37993);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field37997 = (function sablono$core$datetime_local_field37997(var_args){
var args37998 = [];
var len__7484__auto___38065 = arguments.length;
var i__7485__auto___38066 = (0);
while(true){
if((i__7485__auto___38066 < len__7484__auto___38065)){
args37998.push((arguments[i__7485__auto___38066]));

var G__38067 = (i__7485__auto___38066 + (1));
i__7485__auto___38066 = G__38067;
continue;
} else {
}
break;
}

var G__38000 = args37998.length;
switch (G__38000) {
case 1:
return sablono.core.datetime_local_field37997.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field37997.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37998.length)].join('')));

}
});

sablono.core.datetime_local_field37997.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.datetime_local_field37997.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.datetime_local_field37997.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$datetime_DASH_local)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.datetime_local_field37997.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field37997);

/**
 * Creates a email input field.
 */
sablono.core.email_field38001 = (function sablono$core$email_field38001(var_args){
var args38002 = [];
var len__7484__auto___38069 = arguments.length;
var i__7485__auto___38070 = (0);
while(true){
if((i__7485__auto___38070 < len__7484__auto___38069)){
args38002.push((arguments[i__7485__auto___38070]));

var G__38071 = (i__7485__auto___38070 + (1));
i__7485__auto___38070 = G__38071;
continue;
} else {
}
break;
}

var G__38004 = args38002.length;
switch (G__38004) {
case 1:
return sablono.core.email_field38001.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field38001.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38002.length)].join('')));

}
});

sablono.core.email_field38001.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.email_field38001.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.email_field38001.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$email)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.email_field38001.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field38001);

/**
 * Creates a file input field.
 */
sablono.core.file_field38005 = (function sablono$core$file_field38005(var_args){
var args38006 = [];
var len__7484__auto___38073 = arguments.length;
var i__7485__auto___38074 = (0);
while(true){
if((i__7485__auto___38074 < len__7484__auto___38073)){
args38006.push((arguments[i__7485__auto___38074]));

var G__38075 = (i__7485__auto___38074 + (1));
i__7485__auto___38074 = G__38075;
continue;
} else {
}
break;
}

var G__38008 = args38006.length;
switch (G__38008) {
case 1:
return sablono.core.file_field38005.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field38005.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38006.length)].join('')));

}
});

sablono.core.file_field38005.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.file_field38005.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.file_field38005.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$file)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.file_field38005.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field38005);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field38009 = (function sablono$core$hidden_field38009(var_args){
var args38010 = [];
var len__7484__auto___38077 = arguments.length;
var i__7485__auto___38078 = (0);
while(true){
if((i__7485__auto___38078 < len__7484__auto___38077)){
args38010.push((arguments[i__7485__auto___38078]));

var G__38079 = (i__7485__auto___38078 + (1));
i__7485__auto___38078 = G__38079;
continue;
} else {
}
break;
}

var G__38012 = args38010.length;
switch (G__38012) {
case 1:
return sablono.core.hidden_field38009.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field38009.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38010.length)].join('')));

}
});

sablono.core.hidden_field38009.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.hidden_field38009.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.hidden_field38009.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$hidden)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.hidden_field38009.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field38009);

/**
 * Creates a month input field.
 */
sablono.core.month_field38013 = (function sablono$core$month_field38013(var_args){
var args38014 = [];
var len__7484__auto___38081 = arguments.length;
var i__7485__auto___38082 = (0);
while(true){
if((i__7485__auto___38082 < len__7484__auto___38081)){
args38014.push((arguments[i__7485__auto___38082]));

var G__38083 = (i__7485__auto___38082 + (1));
i__7485__auto___38082 = G__38083;
continue;
} else {
}
break;
}

var G__38016 = args38014.length;
switch (G__38016) {
case 1:
return sablono.core.month_field38013.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field38013.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38014.length)].join('')));

}
});

sablono.core.month_field38013.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.month_field38013.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.month_field38013.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$month)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.month_field38013.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field38013);

/**
 * Creates a number input field.
 */
sablono.core.number_field38017 = (function sablono$core$number_field38017(var_args){
var args38018 = [];
var len__7484__auto___38085 = arguments.length;
var i__7485__auto___38086 = (0);
while(true){
if((i__7485__auto___38086 < len__7484__auto___38085)){
args38018.push((arguments[i__7485__auto___38086]));

var G__38087 = (i__7485__auto___38086 + (1));
i__7485__auto___38086 = G__38087;
continue;
} else {
}
break;
}

var G__38020 = args38018.length;
switch (G__38020) {
case 1:
return sablono.core.number_field38017.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field38017.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38018.length)].join('')));

}
});

sablono.core.number_field38017.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.number_field38017.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.number_field38017.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$number)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.number_field38017.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field38017);

/**
 * Creates a password input field.
 */
sablono.core.password_field38021 = (function sablono$core$password_field38021(var_args){
var args38022 = [];
var len__7484__auto___38089 = arguments.length;
var i__7485__auto___38090 = (0);
while(true){
if((i__7485__auto___38090 < len__7484__auto___38089)){
args38022.push((arguments[i__7485__auto___38090]));

var G__38091 = (i__7485__auto___38090 + (1));
i__7485__auto___38090 = G__38091;
continue;
} else {
}
break;
}

var G__38024 = args38022.length;
switch (G__38024) {
case 1:
return sablono.core.password_field38021.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field38021.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38022.length)].join('')));

}
});

sablono.core.password_field38021.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.password_field38021.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.password_field38021.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$password)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.password_field38021.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field38021);

/**
 * Creates a range input field.
 */
sablono.core.range_field38025 = (function sablono$core$range_field38025(var_args){
var args38026 = [];
var len__7484__auto___38093 = arguments.length;
var i__7485__auto___38094 = (0);
while(true){
if((i__7485__auto___38094 < len__7484__auto___38093)){
args38026.push((arguments[i__7485__auto___38094]));

var G__38095 = (i__7485__auto___38094 + (1));
i__7485__auto___38094 = G__38095;
continue;
} else {
}
break;
}

var G__38028 = args38026.length;
switch (G__38028) {
case 1:
return sablono.core.range_field38025.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field38025.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38026.length)].join('')));

}
});

sablono.core.range_field38025.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.range_field38025.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.range_field38025.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$range)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.range_field38025.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field38025);

/**
 * Creates a search input field.
 */
sablono.core.search_field38029 = (function sablono$core$search_field38029(var_args){
var args38030 = [];
var len__7484__auto___38097 = arguments.length;
var i__7485__auto___38098 = (0);
while(true){
if((i__7485__auto___38098 < len__7484__auto___38097)){
args38030.push((arguments[i__7485__auto___38098]));

var G__38099 = (i__7485__auto___38098 + (1));
i__7485__auto___38098 = G__38099;
continue;
} else {
}
break;
}

var G__38032 = args38030.length;
switch (G__38032) {
case 1:
return sablono.core.search_field38029.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field38029.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38030.length)].join('')));

}
});

sablono.core.search_field38029.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.search_field38029.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.search_field38029.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$search)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.search_field38029.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field38029);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field38033 = (function sablono$core$tel_field38033(var_args){
var args38034 = [];
var len__7484__auto___38101 = arguments.length;
var i__7485__auto___38102 = (0);
while(true){
if((i__7485__auto___38102 < len__7484__auto___38101)){
args38034.push((arguments[i__7485__auto___38102]));

var G__38103 = (i__7485__auto___38102 + (1));
i__7485__auto___38102 = G__38103;
continue;
} else {
}
break;
}

var G__38036 = args38034.length;
switch (G__38036) {
case 1:
return sablono.core.tel_field38033.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field38033.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38034.length)].join('')));

}
});

sablono.core.tel_field38033.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.tel_field38033.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.tel_field38033.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$tel)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.tel_field38033.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field38033);

/**
 * Creates a text input field.
 */
sablono.core.text_field38037 = (function sablono$core$text_field38037(var_args){
var args38038 = [];
var len__7484__auto___38105 = arguments.length;
var i__7485__auto___38106 = (0);
while(true){
if((i__7485__auto___38106 < len__7484__auto___38105)){
args38038.push((arguments[i__7485__auto___38106]));

var G__38107 = (i__7485__auto___38106 + (1));
i__7485__auto___38106 = G__38107;
continue;
} else {
}
break;
}

var G__38040 = args38038.length;
switch (G__38040) {
case 1:
return sablono.core.text_field38037.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field38037.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38038.length)].join('')));

}
});

sablono.core.text_field38037.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.text_field38037.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.text_field38037.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$text)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.text_field38037.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field38037);

/**
 * Creates a time input field.
 */
sablono.core.time_field38041 = (function sablono$core$time_field38041(var_args){
var args38042 = [];
var len__7484__auto___38109 = arguments.length;
var i__7485__auto___38110 = (0);
while(true){
if((i__7485__auto___38110 < len__7484__auto___38109)){
args38042.push((arguments[i__7485__auto___38110]));

var G__38111 = (i__7485__auto___38110 + (1));
i__7485__auto___38110 = G__38111;
continue;
} else {
}
break;
}

var G__38044 = args38042.length;
switch (G__38044) {
case 1:
return sablono.core.time_field38041.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field38041.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38042.length)].join('')));

}
});

sablono.core.time_field38041.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.time_field38041.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.time_field38041.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$time)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.time_field38041.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field38041);

/**
 * Creates a url input field.
 */
sablono.core.url_field38045 = (function sablono$core$url_field38045(var_args){
var args38046 = [];
var len__7484__auto___38113 = arguments.length;
var i__7485__auto___38114 = (0);
while(true){
if((i__7485__auto___38114 < len__7484__auto___38113)){
args38046.push((arguments[i__7485__auto___38114]));

var G__38115 = (i__7485__auto___38114 + (1));
i__7485__auto___38114 = G__38115;
continue;
} else {
}
break;
}

var G__38048 = args38046.length;
switch (G__38048) {
case 1:
return sablono.core.url_field38045.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field38045.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38046.length)].join('')));

}
});

sablono.core.url_field38045.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.url_field38045.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.url_field38045.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$url)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.url_field38045.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field38045);

/**
 * Creates a week input field.
 */
sablono.core.week_field38049 = (function sablono$core$week_field38049(var_args){
var args38050 = [];
var len__7484__auto___38117 = arguments.length;
var i__7485__auto___38118 = (0);
while(true){
if((i__7485__auto___38118 < len__7484__auto___38117)){
args38050.push((arguments[i__7485__auto___38118]));

var G__38119 = (i__7485__auto___38118 + (1));
i__7485__auto___38118 = G__38119;
continue;
} else {
}
break;
}

var G__38052 = args38050.length;
switch (G__38052) {
case 1:
return sablono.core.week_field38049.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field38049.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38050.length)].join('')));

}
});

sablono.core.week_field38049.cljs$core$IFn$_invoke$arity$1 = (function (name__11294__auto__){
return sablono.core.week_field38049.cljs$core$IFn$_invoke$arity$2(name__11294__auto__,null);
});

sablono.core.week_field38049.cljs$core$IFn$_invoke$arity$2 = (function (name__11294__auto__,value__11295__auto__){
return sablono.core.input_field_STAR_([cljs.core.str(cljs.core.cst$sym$week)].join(''),name__11294__auto__,value__11295__auto__);
});

sablono.core.week_field38049.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field38049);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box38121 = (function sablono$core$check_box38121(var_args){
var args38122 = [];
var len__7484__auto___38125 = arguments.length;
var i__7485__auto___38126 = (0);
while(true){
if((i__7485__auto___38126 < len__7484__auto___38125)){
args38122.push((arguments[i__7485__auto___38126]));

var G__38127 = (i__7485__auto___38126 + (1));
i__7485__auto___38126 = G__38127;
continue;
} else {
}
break;
}

var G__38124 = args38122.length;
switch (G__38124) {
case 1:
return sablono.core.check_box38121.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box38121.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box38121.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38122.length)].join('')));

}
});

sablono.core.check_box38121.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box38121.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.check_box38121.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box38121.cljs$core$IFn$_invoke$arity$3(name,checked_QMARK_,"true");
});

sablono.core.check_box38121.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.check_box38121.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box38121);
/**
 * Creates a radio button.
 */
sablono.core.radio_button38129 = (function sablono$core$radio_button38129(var_args){
var args38130 = [];
var len__7484__auto___38133 = arguments.length;
var i__7485__auto___38134 = (0);
while(true){
if((i__7485__auto___38134 < len__7484__auto___38133)){
args38130.push((arguments[i__7485__auto___38134]));

var G__38135 = (i__7485__auto___38134 + (1));
i__7485__auto___38134 = G__38135;
continue;
} else {
}
break;
}

var G__38132 = args38130.length;
switch (G__38132) {
case 1:
return sablono.core.radio_button38129.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button38129.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button38129.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38130.length)].join('')));

}
});

sablono.core.radio_button38129.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button38129.cljs$core$IFn$_invoke$arity$2(group,null);
});

sablono.core.radio_button38129.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button38129.cljs$core$IFn$_invoke$arity$3(group,checked_QMARK_,"true");
});

sablono.core.radio_button38129.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"radio",cljs.core.cst$kw$name,sablono.core.make_name(group),cljs.core.cst$kw$id,sablono.core.make_id([cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([group], 0))),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([value], 0)))].join('')),cljs.core.cst$kw$value,value,cljs.core.cst$kw$checked,checked_QMARK_], null)], null);
});

sablono.core.radio_button38129.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button38129);
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options38137 = (function sablono$core$select_options38137(var_args){
var args38138 = [];
var len__7484__auto___38159 = arguments.length;
var i__7485__auto___38160 = (0);
while(true){
if((i__7485__auto___38160 < len__7484__auto___38159)){
args38138.push((arguments[i__7485__auto___38160]));

var G__38161 = (i__7485__auto___38160 + (1));
i__7485__auto___38160 = G__38161;
continue;
} else {
}
break;
}

var G__38140 = args38138.length;
switch (G__38140) {
case 1:
return sablono.core.select_options38137.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.select_options38137.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38138.length)].join('')));

}
});

sablono.core.select_options38137.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return sablono.core.select_options38137.cljs$core$IFn$_invoke$arity$2(coll,null);
});

sablono.core.select_options38137.cljs$core$IFn$_invoke$arity$2 = (function (coll,selected){
var iter__7189__auto__ = (function sablono$core$iter__38141(s__38142){
return (new cljs.core.LazySeq(null,(function (){
var s__38142__$1 = s__38142;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38142__$1);
if(temp__4657__auto__){
var s__38142__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38142__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38142__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38144 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38143 = (0);
while(true){
if((i__38143 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38143);
cljs.core.chunk_append(b__38144,((cljs.core.sequential_QMARK_(x))?(function (){var vec__38153 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38153,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38153,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38153,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options38137.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)));

var G__38163 = (i__38143 + (1));
i__38143 = G__38163;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38144),sablono$core$iter__38141(cljs.core.chunk_rest(s__38142__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38144),null);
}
} else {
var x = cljs.core.first(s__38142__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__38156 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38156,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38156,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38156,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$optgroup,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,text], null),sablono.core.select_options38137.cljs$core$IFn$_invoke$arity$2(val,selected)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,val,cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,selected),cljs.core.cst$kw$disabled,disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,selected)], null),x], null)),sablono$core$iter__38141(cljs.core.rest(s__38142__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(coll);
});

sablono.core.select_options38137.cljs$lang$maxFixedArity = 2;


sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options38137);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down38164 = (function sablono$core$drop_down38164(var_args){
var args38165 = [];
var len__7484__auto___38168 = arguments.length;
var i__7485__auto___38169 = (0);
while(true){
if((i__7485__auto___38169 < len__7484__auto___38168)){
args38165.push((arguments[i__7485__auto___38169]));

var G__38170 = (i__7485__auto___38169 + (1));
i__7485__auto___38169 = G__38170;
continue;
} else {
}
break;
}

var G__38167 = args38165.length;
switch (G__38167) {
case 2:
return sablono.core.drop_down38164.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down38164.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38165.length)].join('')));

}
});

sablono.core.drop_down38164.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down38164.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down38164.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down38164.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down38164);
/**
 * Creates a text area element.
 */
sablono.core.text_area38172 = (function sablono$core$text_area38172(var_args){
var args38173 = [];
var len__7484__auto___38176 = arguments.length;
var i__7485__auto___38177 = (0);
while(true){
if((i__7485__auto___38177 < len__7484__auto___38176)){
args38173.push((arguments[i__7485__auto___38177]));

var G__38178 = (i__7485__auto___38177 + (1));
i__7485__auto___38177 = G__38178;
continue;
} else {
}
break;
}

var G__38175 = args38173.length;
switch (G__38175) {
case 1:
return sablono.core.text_area38172.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area38172.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38173.length)].join('')));

}
});

sablono.core.text_area38172.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area38172.cljs$core$IFn$_invoke$arity$2(name,null);
});

sablono.core.text_area38172.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$textarea,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,sablono.core.make_name(name),cljs.core.cst$kw$id,sablono.core.make_id(name),cljs.core.cst$kw$value,value], null)], null);
});

sablono.core.text_area38172.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area38172);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label38180 = (function sablono$core$label38180(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$htmlFor,sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label38180);
/**
 * Creates a submit button.
 */
sablono.core.submit_button38181 = (function sablono$core$submit_button38181(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button38181);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button38182 = (function sablono$core$reset_button38182(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"reset",cljs.core.cst$kw$value,text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button38182);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to38183 = (function sablono$core$form_to38183(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38190 = arguments.length;
var i__7485__auto___38191 = (0);
while(true){
if((i__7485__auto___38191 < len__7484__auto___38190)){
args__7491__auto__.push((arguments[i__7485__auto___38191]));

var G__38192 = (i__7485__auto___38191 + (1));
i__7485__auto___38191 = G__38192;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to38183.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

sablono.core.form_to38183.cljs$core$IFn$_invoke$arity$variadic = (function (p__38186,body){
var vec__38187 = p__38186;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38187,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38187,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$get,null,cljs.core.cst$kw$post,null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,method_str,cljs.core.cst$kw$action,action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,"POST",cljs.core.cst$kw$action,action_uri], null),(sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$2("_method",method_str) : sablono.core.hidden_field.call(null,"_method",method_str))], null)),body));
});

sablono.core.form_to38183.cljs$lang$maxFixedArity = (1);

sablono.core.form_to38183.cljs$lang$applyTo = (function (seq38184){
var G__38185 = cljs.core.first(seq38184);
var seq38184__$1 = cljs.core.next(seq38184);
return sablono.core.form_to38183.cljs$core$IFn$_invoke$arity$variadic(G__38185,seq38184__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to38183);
