// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.photos');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('hatti.constants');
goog.require('milia.utils.remote');
goog.require('sablono.core');
goog.require('hatti.shared');
goog.require('hatti.views');
goog.require('om.core');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.photos.data_pswp_id = "data-pswp-id";
hatti.views.photos.pswp_gallery_class = "pswp";
hatti.views.photos.width_px = (1024);
hatti.views.photos.thumb_width_px = (180);
hatti.views.photos.thumb_width_px_str = [cljs.core.str(hatti.views.photos.thumb_width_px),cljs.core.str("px")].join('');
hatti.views.photos.num_columns = (3);
/**
 * Return a URL for this image resized.
 */
hatti.views.photos.resize_image = (function hatti$views$photos$resize_image(image_url,edge_px){
return [cljs.core.str(milia.utils.remote.thumbor_server),cljs.core.str(chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["unsafe","fit-in",[cljs.core.str(edge_px),cljs.core.str("x"),cljs.core.str(edge_px)].join(''),"smart","filters:fill(000)",image_url], 0)))].join('');
});
/**
 * If not a fully qualified URL, remove the API namespace prefix from a URI
 * string and convert to a fully qualified URL.
 */
hatti.views.photos.make_url = (function hatti$views$photos$make_url(s){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),(4)),"http")){
return s;
} else {
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([clojure.string.replace(s,/\/api\/v1/,"")], 0));
}
});
hatti.views.photos.build_caption = (function hatti$views$photos$build_caption(item){
var datetime = item.date;
var date = moment(datetime).format("MMM D, YYYY");
var time = moment(datetime).format("h:mm A");
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%s <br/><small>Submitted at %s on %s</small>",cljs.core.array_seq([item.title,time,date], 0));
});
/**
 * Initiate photoswipe using the index of the image that was just clicked on.
 */
hatti.views.photos.open_photoswipe = (function hatti$views$photos$open_photoswipe(index,photos){
var pswp_element = cljs.core.first(document.querySelectorAll([cljs.core.str("."),cljs.core.str(hatti.views.photos.pswp_gallery_class)].join('')));
var options = (function (){var obj35727 = {"index":(index | (0)),"getThumbBoundsFn":((function (pswp_element){
return (function (index__$1){
var thumbnail = document.querySelector(chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("[%s='%s']",cljs.core.array_seq([hatti.views.photos.data_pswp_id,index__$1], 0)));
var page_y_scroll = (window.pageYOffset + document.documentElement.scrollTop);
var rect = thumbnail.getBoundingClientRect();
var obj35729 = {"x":rect.left,"y":(rect.top + page_y_scroll),"w":rect.width};
return obj35729;
});})(pswp_element))
,"addCaptionHTMLFn":((function (pswp_element){
return (function (item,caption_el,is_fake){
return cljs.core.first(caption_el.children).innerHTML = hatti.views.photos.build_caption(item);
});})(pswp_element))
};
return obj35727;
})();
var gallery = (new PhotoSwipe(pswp_element,PhotoSwipeUI_Default,cljs.core.clj__GT_js(photos),options));
gallery.options.getImageURLForShare = ((function (pswp_element,options,gallery){
return (function (share_button_data){
var or__6409__auto__ = (gallery["currItem"]["original-src"]);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return "";
}
});})(pswp_element,options,gallery))
;

return gallery.init();
});
/**
 * Actions to perform on thumbnail click.
 */
hatti.views.photos.on_thumbnail_click = (function hatti$views$photos$on_thumbnail_click(event,photos){
event.preventDefault();

return hatti.views.photos.open_photoswipe(event.target.getAttribute(hatti.views.photos.data_pswp_id),photos);
});
/**
 * Return True if no mimetype or the mimetype begins with image. Otherwise
 * return nil.
 */
hatti.views.photos.image_or_no_mimetype_QMARK_ = (function hatti$views$photos$image_or_no_mimetype_QMARK_(attachment){
var mimetype = cljs.core.get.cljs$core$IFn$_invoke$arity$2(attachment,hatti.constants.mimetype);
var or__6409__auto__ = cljs.core.not(mimetype);
if(or__6409__auto__){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("image",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(mimetype,(0),(5)));
if(or__6409__auto____$1){
return or__6409__auto____$1;
} else {
return null;
}
}
});
/**
 * Take a datum and return the datum with a new key :attachements that has a
 * list of download URLs for all the attachments.
 */
hatti.views.photos.extract_images = (function hatti$views$photos$extract_images(datum,photo_columns){
var download_url_kw = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants.download_url);
var attachments = (function (){var or__6409__auto__ = (function (){var G__35738 = datum;
var G__35738__$1 = (((G__35738 == null))?null:cljs.core.get.cljs$core$IFn$_invoke$arity$2(G__35738,hatti.constants.photo));
var G__35738__$2 = (((G__35738__$1 == null))?null:(download_url_kw.cljs$core$IFn$_invoke$arity$1 ? download_url_kw.cljs$core$IFn$_invoke$arity$1(G__35738__$1) : download_url_kw.call(null,G__35738__$1)));
if((G__35738__$2 == null)){
return null;
} else {
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[G__35738__$2],null));
}
})();
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (or__6409__auto__,download_url_kw){
return (function (p1__35731_SHARP_,p2__35730_SHARP_){
var G__35740 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,p2__35730_SHARP_);
var G__35740__$1 = (((G__35740 == null))?null:(download_url_kw.cljs$core$IFn$_invoke$arity$1 ? download_url_kw.cljs$core$IFn$_invoke$arity$1(G__35740) : download_url_kw.call(null,G__35740)));
var G__35740__$2 = (((G__35740__$1 == null))?null:cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35731_SHARP_,G__35740__$1));
if((G__35740__$2 == null)){
return null;
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,G__35740__$2);
}
});})(or__6409__auto__,download_url_kw))
,null,photo_columns);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(((function (or__6409__auto____$1,or__6409__auto__,download_url_kw){
return (function (p1__35732_SHARP_){
var and__6397__auto__ = hatti.views.photos.image_or_no_mimetype_QMARK_(p1__35732_SHARP_);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__35732_SHARP_,hatti.constants.download_url);
} else {
return and__6397__auto__;
}
});})(or__6409__auto____$1,or__6409__auto__,download_url_kw))
,cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants._attachments));
}
}
})();
var and__6397__auto__ = cljs.core.seq(attachments);
if(and__6397__auto__){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(datum,cljs.core.cst$kw$attachments,attachments);
} else {
return and__6397__auto__;
}
});
/**
 * Build photos for photoswipe from a set of form data. Ignore submissions that
 * do not have a photo attached. If the photo info is attached directly to the
 * submission and not to the attachments list, use the information attached
 * directly to the submission.
 */
hatti.views.photos.build_photos = (function hatti$views$photos$build_photos(data,photo_columns){
var data_with_attachments = cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__35741_SHARP_){
return hatti.views.photos.extract_images(p1__35741_SHARP_,photo_columns);
}),data);
var attachment_totals = cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(((function (data_with_attachments){
return (function (p1__35742_SHARP_,p2__35743_SHARP_){
return (p1__35742_SHARP_ + cljs.core.count(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p2__35743_SHARP_,cljs.core.cst$kw$attachments)));
});})(data_with_attachments))
,(0),data_with_attachments);
var total = cljs.core.last(attachment_totals);
return cljs.core.flatten((function (){var iter__7189__auto__ = ((function (data_with_attachments,attachment_totals,total){
return (function hatti$views$photos$build_photos_$_iter__35758(s__35759){
return (new cljs.core.LazySeq(null,((function (data_with_attachments,attachment_totals,total){
return (function (){
var s__35759__$1 = s__35759;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35759__$1);
if(temp__4657__auto__){
var s__35759__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35759__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35759__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35761 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35760 = (0);
while(true){
if((i__35760 < size__7188__auto__)){
var photo_index = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35760);
var map__35768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(data_with_attachments,photo_index);
var map__35768__$1 = ((((!((map__35768 == null)))?((((map__35768.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35768.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35768):map__35768);
var datum = map__35768__$1;
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35768__$1,cljs.core.cst$kw$attachments);
var cumulative_sum = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(attachment_totals,photo_index);
var date = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants._submission_time);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants._id);
var photo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants.photo);
var rank = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants._rank);
cljs.core.chunk_append(b__35761,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (i__35760,map__35768,map__35768__$1,datum,attachments,cumulative_sum,date,id,photo,rank,photo_index,c__7187__auto__,size__7188__auto__,b__35761,s__35759__$2,temp__4657__auto__,data_with_attachments,attachment_totals,total){
return (function (j,attachment){
var download_url = hatti.views.photos.make_url(attachment);
var thumbnail = hatti.views.photos.resize_image(download_url,hatti.views.photos.thumb_width_px);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$thumb,cljs.core.cst$kw$date,cljs.core.cst$kw$w,cljs.core.cst$kw$rank,cljs.core.cst$kw$msrc,cljs.core.cst$kw$src,cljs.core.cst$kw$title,cljs.core.cst$kw$h,cljs.core.cst$kw$id,cljs.core.cst$kw$original_DASH_src],[thumbnail,date,hatti.views.photos.width_px,rank,thumbnail,hatti.views.photos.resize_image(hatti.views.photos.make_url(download_url),hatti.views.photos.width_px),chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%s/%s | ID: %s",cljs.core.array_seq([(((1) + cumulative_sum) + j),total,id], 0)),hatti.views.photos.width_px,id,download_url]);
});})(i__35760,map__35768,map__35768__$1,datum,attachments,cumulative_sum,date,id,photo,rank,photo_index,c__7187__auto__,size__7188__auto__,b__35761,s__35759__$2,temp__4657__auto__,data_with_attachments,attachment_totals,total))
,attachments));

var G__35772 = (i__35760 + (1));
i__35760 = G__35772;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35761),hatti$views$photos$build_photos_$_iter__35758(cljs.core.chunk_rest(s__35759__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35761),null);
}
} else {
var photo_index = cljs.core.first(s__35759__$2);
var map__35770 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(data_with_attachments,photo_index);
var map__35770__$1 = ((((!((map__35770 == null)))?((((map__35770.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35770.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35770):map__35770);
var datum = map__35770__$1;
var attachments = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35770__$1,cljs.core.cst$kw$attachments);
var cumulative_sum = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(attachment_totals,photo_index);
var date = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants._submission_time);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants._id);
var photo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants.photo);
var rank = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datum,hatti.constants._rank);
return cljs.core.cons(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (map__35770,map__35770__$1,datum,attachments,cumulative_sum,date,id,photo,rank,photo_index,s__35759__$2,temp__4657__auto__,data_with_attachments,attachment_totals,total){
return (function (j,attachment){
var download_url = hatti.views.photos.make_url(attachment);
var thumbnail = hatti.views.photos.resize_image(download_url,hatti.views.photos.thumb_width_px);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$thumb,cljs.core.cst$kw$date,cljs.core.cst$kw$w,cljs.core.cst$kw$rank,cljs.core.cst$kw$msrc,cljs.core.cst$kw$src,cljs.core.cst$kw$title,cljs.core.cst$kw$h,cljs.core.cst$kw$id,cljs.core.cst$kw$original_DASH_src],[thumbnail,date,hatti.views.photos.width_px,rank,thumbnail,hatti.views.photos.resize_image(hatti.views.photos.make_url(download_url),hatti.views.photos.width_px),chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%s/%s | ID: %s",cljs.core.array_seq([(((1) + cumulative_sum) + j),total,id], 0)),hatti.views.photos.width_px,id,download_url]);
});})(map__35770,map__35770__$1,datum,attachments,cumulative_sum,date,id,photo,rank,photo_index,s__35759__$2,temp__4657__auto__,data_with_attachments,attachment_totals,total))
,attachments),hatti$views$photos$build_photos_$_iter__35758(cljs.core.rest(s__35759__$2)));
}
} else {
return null;
}
break;
}
});})(data_with_attachments,attachment_totals,total))
,null,null));
});})(data_with_attachments,attachment_totals,total))
;
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(data_with_attachments)));
})());
});
/**
 * Return the full-names of all columns with photo type.
 */
hatti.views.photos.get_photo_columns = (function hatti$views$photos$get_photo_columns(form){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__35773_SHARP_){
var and__6397__auto__ = (function (){var or__6409__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("photo",cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(p1__35773_SHARP_));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return null;
}
})();
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(p1__35773_SHARP_);
} else {
return and__6397__auto__;
}
}),form);
});
/**
 * Build markup with actions for a photo gallery.
 */
hatti.views.photos.build_photo_gallery = (function hatti$views$photos$build_photo_gallery(photos,owner){
var iter__7189__auto__ = (function hatti$views$photos$build_photo_gallery_$_iter__35789(s__35790){
return (new cljs.core.LazySeq(null,(function (){
var s__35790__$1 = s__35790;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__35790__$1);
if(temp__4657__auto__){
var s__35790__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__35790__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__35790__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__35792 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__35791 = (0);
while(true){
if((i__35791 < size__7188__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__35791);
var map__35799 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(photos,i);
var map__35799__$1 = ((((!((map__35799 == null)))?((((map__35799.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35799.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35799):map__35799);
var photo = map__35799__$1;
var title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35799__$1,cljs.core.cst$kw$title);
cljs.core.chunk_append(b__35792,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$figure,new cljs.core.PersistentArrayMap(null, 3, ["itemProp","associatedMedia","itemScope","","itemType","http://schema.org/ImageObject"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$href,cljs.core.cst$kw$src.cljs$core$IFn$_invoke$arity$1(photo),"itemProp","contentUrl",cljs.core.cst$kw$data_DASH_size,chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%sx%s",cljs.core.array_seq([hatti.views.photos.width_px,hatti.views.photos.width_px], 0)),cljs.core.cst$kw$on_DASH_click,((function (i__35791,map__35799,map__35799__$1,photo,title,i,c__7187__auto__,size__7188__auto__,b__35792,s__35790__$2,temp__4657__auto__){
return (function (p1__35774_SHARP_){
return hatti.views.photos.on_thumbnail_click(p1__35774_SHARP_,photos);
});})(i__35791,map__35799,map__35799__$1,photo,title,i,c__7187__auto__,size__7188__auto__,b__35792,s__35790__$2,temp__4657__auto__))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,cljs.core.PersistentArrayMap.fromArray([cljs.core.cst$kw$width,hatti.views.photos.thumb_width_px_str,cljs.core.cst$kw$height,hatti.views.photos.thumb_width_px_str,cljs.core.cst$kw$src,cljs.core.cst$kw$thumb.cljs$core$IFn$_invoke$arity$1(photo),"itemProp","thumbnail",cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.views.photos.data_pswp_id),i,cljs.core.cst$kw$alt,title], true, false)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$figcaption,new cljs.core.PersistentArrayMap(null, 1, ["itemProp","caption description"], null),title], null)], null));

var G__35803 = (i__35791 + (1));
i__35791 = G__35803;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__35792),hatti$views$photos$build_photo_gallery_$_iter__35789(cljs.core.chunk_rest(s__35790__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__35792),null);
}
} else {
var i = cljs.core.first(s__35790__$2);
var map__35801 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(photos,i);
var map__35801__$1 = ((((!((map__35801 == null)))?((((map__35801.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35801.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35801):map__35801);
var photo = map__35801__$1;
var title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35801__$1,cljs.core.cst$kw$title);
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$figure,new cljs.core.PersistentArrayMap(null, 3, ["itemProp","associatedMedia","itemScope","","itemType","http://schema.org/ImageObject"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$href,cljs.core.cst$kw$src.cljs$core$IFn$_invoke$arity$1(photo),"itemProp","contentUrl",cljs.core.cst$kw$data_DASH_size,chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%sx%s",cljs.core.array_seq([hatti.views.photos.width_px,hatti.views.photos.width_px], 0)),cljs.core.cst$kw$on_DASH_click,((function (map__35801,map__35801__$1,photo,title,i,s__35790__$2,temp__4657__auto__){
return (function (p1__35774_SHARP_){
return hatti.views.photos.on_thumbnail_click(p1__35774_SHARP_,photos);
});})(map__35801,map__35801__$1,photo,title,i,s__35790__$2,temp__4657__auto__))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$img,cljs.core.PersistentArrayMap.fromArray([cljs.core.cst$kw$width,hatti.views.photos.thumb_width_px_str,cljs.core.cst$kw$height,hatti.views.photos.thumb_width_px_str,cljs.core.cst$kw$src,cljs.core.cst$kw$thumb.cljs$core$IFn$_invoke$arity$1(photo),"itemProp","thumbnail",cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.views.photos.data_pswp_id),i,cljs.core.cst$kw$alt,title], true, false)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$figcaption,new cljs.core.PersistentArrayMap(null, 1, ["itemProp","caption description"], null),title], null)], null),hatti$views$photos$build_photo_gallery_$_iter__35789(cljs.core.rest(s__35790__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(photos)));
});
hatti.views.photos_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__35804,owner){
var map__35805 = p__35804;
var map__35805__$1 = ((((!((map__35805 == null)))?((((map__35805.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35805.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35805):map__35805);
var map__35806 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35805__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__35806__$1 = ((((!((map__35806 == null)))?((((map__35806.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35806.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35806):map__35806);
var dataset_info = map__35806__$1;
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35806__$1,cljs.core.cst$kw$num_of_submissions);

if(typeof hatti.views.photos.t_hatti$views$photos35809 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.photos.t_hatti$views$photos35809 = (function (p__35804,owner,map__35805,map__35806,dataset_info,num_of_submissions,meta35810){
this.p__35804 = p__35804;
this.owner = owner;
this.map__35805 = map__35805;
this.map__35806 = map__35806;
this.dataset_info = dataset_info;
this.num_of_submissions = num_of_submissions;
this.meta35810 = meta35810;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.photos.t_hatti$views$photos35809.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions){
return (function (_35811,meta35810__$1){
var self__ = this;
var _35811__$1 = this;
return (new hatti.views.photos.t_hatti$views$photos35809(self__.p__35804,self__.owner,self__.map__35805,self__.map__35806,self__.dataset_info,self__.num_of_submissions,meta35810__$1));
});})(map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos35809.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions){
return (function (_35811){
var self__ = this;
var _35811__$1 = this;
return self__.meta35810;
});})(map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos35809.prototype.om$core$IInitState$ = true;

hatti.views.photos.t_hatti$views$photos35809.prototype.om$core$IInitState$init_state$arity$1 = ((function (map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$data], null)),cljs.core.cst$kw$photo_DASH_columns,hatti.views.photos.get_photo_columns(om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flat_DASH_form], null))));
});})(map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos35809.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.photos.t_hatti$views$photos35809.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$data,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$map_DASH_page.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
});})(map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos35809.prototype.om$core$IRenderState$ = true;

hatti.views.photos.t_hatti$views$photos35809.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions){
return (function (_,p__35812){
var self__ = this;
var map__35813 = p__35812;
var map__35813__$1 = ((((!((map__35813 == null)))?((((map__35813.cljs$lang$protocol_mask$partition0$ & (64))) || (map__35813.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35813):map__35813);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35813__$1,cljs.core.cst$kw$data);
var photo_columns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35813__$1,cljs.core.cst$kw$photo_DASH_columns);
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$flat_DASH_form], null));
var photos = hatti.views.photos.build_photos(data,photo_columns);
var attrs35815 = ((((self__.num_of_submissions === (0))) || ((cljs.core.seq(data)) && (cljs.core.empty_QMARK_(photos))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$alert$alert_DASH_warning$alert_DASH_photos,"There are no photos in this dataset yet."], null):((cljs.core.seq(photos))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$role,"dialog",cljs.core.cst$kw$aria_DASH_hidden,"true",cljs.core.cst$kw$tab_DASH_index,"-1",cljs.core.cst$kw$class,hatti.views.photos.pswp_gallery_class], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__bg], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__scroll_DASH_wrap,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__container,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__item], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__item_SHARP_active_DASH_image], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__item], null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__ui$pswp__ui_DASH__DASH_hidden,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__top_DASH_bar,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__counter], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_close,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Close (Esc)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_share,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Share"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_fs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Toggle fullscreen"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_zoom,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Zoom in/out"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__preloader,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__preloader__icn,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__preloader__cut,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__preloader__donut], null)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__share_DASH_modal$pswp__share_DASH_modal_DASH__DASH_hidden,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,"pswp__single-tap"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__share_DASH_tooltip], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_arrow_DASH__DASH_left,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Previous (arrow left)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$pswp__button$pswp__button_DASH__DASH_arrow_DASH__DASH_right,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Next (arrow right)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__caption,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pswp__caption__center], null)], null)], null)], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$alert$alert_DASH_photos,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null),"Loading photos ..."], null)
));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs35815))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-content"], null)], null),attrs35815], 0))):({"className": "tab-content"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs35815))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__35818 = ({"itemScope": "", "itemType": "http://schema.org/ImageGallery", "className": "gallery"});
var G__35819 = (function (){var attrs35816 = hatti.views.photos.build_photo_gallery(photos,self__.owner);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.table,((cljs.core.map_QMARK_(attrs35816))?sablono.interpreter.attributes(attrs35816):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs35816))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs35816)], null))));
})();
return React.DOM.div(G__35818,G__35819);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs35815),(function (){var G__35820 = ({"itemScope": "", "itemType": "http://schema.org/ImageGallery", "className": "gallery"});
var G__35821 = (function (){var attrs35817 = hatti.views.photos.build_photo_gallery(photos,self__.owner);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.table,((cljs.core.map_QMARK_(attrs35817))?sablono.interpreter.attributes(attrs35817):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs35817))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs35817)], null))));
})();
return React.DOM.div(G__35820,G__35821);
})()], null))));
});})(map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos35809.getBasis = ((function (map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__35804,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__35805,cljs.core.cst$sym$map__35806,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$num_of_submissions,cljs.core.cst$sym$meta35810], null);
});})(map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.t_hatti$views$photos35809.cljs$lang$type = true;

hatti.views.photos.t_hatti$views$photos35809.cljs$lang$ctorStr = "hatti.views.photos/t_hatti$views$photos35809";

hatti.views.photos.t_hatti$views$photos35809.cljs$lang$ctorPrWriter = ((function (map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.photos/t_hatti$views$photos35809");
});})(map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions))
;

hatti.views.photos.__GT_t_hatti$views$photos35809 = ((function (map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions){
return (function hatti$views$photos$__GT_t_hatti$views$photos35809(p__35804__$1,owner__$1,map__35805__$2,map__35806__$2,dataset_info__$1,num_of_submissions__$1,meta35810){
return (new hatti.views.photos.t_hatti$views$photos35809(p__35804__$1,owner__$1,map__35805__$2,map__35806__$2,dataset_info__$1,num_of_submissions__$1,meta35810));
});})(map__35805,map__35805__$1,map__35806,map__35806__$1,dataset_info,num_of_submissions))
;

}

return (new hatti.views.photos.t_hatti$views$photos35809(p__35804,owner,map__35805__$1,map__35806__$1,dataset_info,num_of_submissions,cljs.core.PersistentArrayMap.EMPTY));
}));
