// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('hatti.constants');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.ona.forms');
goog.require('clojure.string');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('cljs.reader');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"radius": (6), "fillColor": "#f30", "reset": ({"fillColor": "#f30"}), "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9}),cljs.core.cst$kw$hover,({"fillColor": "#631400"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300"})], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8}),cljs.core.cst$kw$hover,({"fillColor": "#631400", "color": "#222"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300", "color": "#222"})], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"color": "#f30", "opacity": (1), "weight": (6), "reset": ({"color": "#f30"})}),cljs.core.cst$kw$hover,({"color": "#631400"}),cljs.core.cst$kw$clicked,({"color": "#ad2300"})], null)], null);
hatti.map.utils.circle_border_id = "point-casting";
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33273 = arguments.length;
var i__7485__auto___33274 = (0);
while(true){
if((i__7485__auto___33274 < len__7484__auto___33273)){
args__7491__auto__.push((arguments[i__7485__auto___33274]));

var G__33275 = (i__7485__auto___33274 + (1));
i__7485__auto___33274 = G__33275;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic = (function (marker_or_keyword,style_type,p__33269){
var map__33270 = p__33269;
var map__33270__$1 = ((((!((map__33270 == null)))?((((map__33270.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33270.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33270):map__33270);
var custom_styles = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33270__$1,cljs.core.cst$kw$custom_DASH_styles,hatti.map.utils.ona_styles);
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__33272 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(custom_styles) : kw.call(null,custom_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__33272) : style_type.call(null,G__33272));
});

hatti.map.utils.get_ona_style.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_ona_style.cljs$lang$applyTo = (function (seq33266){
var G__33267 = cljs.core.first(seq33266);
var seq33266__$1 = cljs.core.next(seq33266);
var G__33268 = cljs.core.first(seq33266__$1);
var seq33266__$2 = cljs.core.next(seq33266__$1);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic(G__33267,G__33268,seq33266__$2);
});

hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args33276 = [];
var len__7484__auto___33280 = arguments.length;
var i__7485__auto___33281 = (0);
while(true){
if((i__7485__auto___33281 < len__7484__auto___33280)){
args33276.push((arguments[i__7485__auto___33281]));

var G__33282 = (i__7485__auto___33281 + (1));
i__7485__auto___33281 = G__33282;
continue;
} else {
}
break;
}

var G__33278 = args33276.length;
switch (G__33278) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33276.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__33279 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__33279) : kw.call(null,G__33279));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;

/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var G__33285 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__33285) : id_selected_QMARK_.call(null,G__33285));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33295 = arguments.length;
var i__7485__auto___33296 = (0);
while(true){
if((i__7485__auto___33296 < len__7484__auto___33295)){
args__7491__auto__.push((arguments[i__7485__auto___33296]));

var G__33297 = (i__7485__auto___33296 + (1));
i__7485__auto___33296 = G__33297;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__33288){
var map__33289 = p__33288;
var map__33289__$1 = ((((!((map__33289 == null)))?((((map__33289.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33289.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33289):map__33289);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33289__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__33291 = cljs.core.seq(markers);
var chunk__33292 = null;
var count__33293 = (0);
var i__33294 = (0);
while(true){
if((i__33294 < count__33293)){
var marker = chunk__33292.cljs$core$IIndexed$_nth$arity$2(null,i__33294);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__33298 = seq__33291;
var G__33299 = chunk__33292;
var G__33300 = count__33293;
var G__33301 = (i__33294 + (1));
seq__33291 = G__33298;
chunk__33292 = G__33299;
count__33293 = G__33300;
i__33294 = G__33301;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__33291);
if(temp__4657__auto__){
var seq__33291__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33291__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__33291__$1);
var G__33302 = cljs.core.chunk_rest(seq__33291__$1);
var G__33303 = c__7220__auto__;
var G__33304 = cljs.core.count(c__7220__auto__);
var G__33305 = (0);
seq__33291 = G__33302;
chunk__33292 = G__33303;
count__33293 = G__33304;
i__33294 = G__33305;
continue;
} else {
var marker = cljs.core.first(seq__33291__$1);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__33306 = cljs.core.next(seq__33291__$1);
var G__33307 = null;
var G__33308 = (0);
var G__33309 = (0);
seq__33291 = G__33306;
chunk__33292 = G__33307;
count__33293 = G__33308;
i__33294 = G__33309;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq33286){
var G__33287 = cljs.core.first(seq33286);
var seq33286__$1 = cljs.core.next(seq33286);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__33287,seq33286__$1);
});

hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(index + (1)),cljs.core.cst$kw$id,record_id,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),record_id], true, false),cljs.core.cst$kw$geometry,geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__7334__auto__ = (function (){var G__33310 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33310) : cljs.core.atom.call(null,G__33310));
})();
var prefer_table__7335__auto__ = (function (){var G__33311 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33311) : cljs.core.atom.call(null,G__33311));
})();
var method_cache__7336__auto__ = (function (){var G__33312 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33312) : cljs.core.atom.call(null,G__33312));
})();
var cached_hierarchy__7337__auto__ = (function (){var G__33313 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33313) : cljs.core.atom.call(null,G__33313));
})();
var hierarchy__7338__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("hatti.map.utils","get-as-geom"),((function (method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__){
return (function() { 
var G__33318__delegate = function (record,field,p__33314){
var vec__33315 = p__33314;
var repeat_child_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33315,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return cljs.core.cst$kw$repeat;
} else {
return cljs.core.cst$kw$default;

}
};
var G__33318 = function (record,field,var_args){
var p__33314 = null;
if (arguments.length > 2) {
var G__33319__i = 0, G__33319__a = new Array(arguments.length -  2);
while (G__33319__i < G__33319__a.length) {G__33319__a[G__33319__i] = arguments[G__33319__i + 2]; ++G__33319__i;}
  p__33314 = new cljs.core.IndexedSeq(G__33319__a,0);
} 
return G__33318__delegate.call(this,record,field,p__33314);};
G__33318.cljs$lang$maxFixedArity = 2;
G__33318.cljs$lang$applyTo = (function (arglist__33320){
var record = cljs.core.first(arglist__33320);
arglist__33320 = cljs.core.next(arglist__33320);
var field = cljs.core.first(arglist__33320);
var p__33314 = cljs.core.rest(arglist__33320);
return G__33318__delegate(record,field,p__33314);
});
G__33318.cljs$core$IFn$_invoke$arity$variadic = G__33318__delegate;
return G__33318;
})()
;})(method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__))
,cljs.core.cst$kw$default,hierarchy__7338__auto__,method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__));
})();
}
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$repeat,(function (record,p__33321){
var map__33322 = p__33321;
var map__33322__$1 = ((((!((map__33322 == null)))?((((map__33322.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33322.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33322):map__33322);
var field = map__33322__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33322__$1,cljs.core.cst$kw$children);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33322__$1,cljs.core.cst$kw$full_DASH_name);
var iter__7189__auto__ = ((function (map__33322,map__33322__$1,field,children,full_name){
return (function hatti$map$utils$iter__33324(s__33325){
return (new cljs.core.LazySeq(null,((function (map__33322,map__33322__$1,field,children,full_name){
return (function (){
var s__33325__$1 = s__33325;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33325__$1);
if(temp__4657__auto__){
var s__33325__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33325__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33325__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33327 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33326 = (0);
while(true){
if((i__33326 < size__7188__auto__)){
var child_record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33326);
cljs.core.chunk_append(b__33327,(function (){var iter__7189__auto__ = ((function (i__33326,child_record,c__7187__auto__,size__7188__auto__,b__33327,s__33325__$2,temp__4657__auto__,map__33322,map__33322__$1,field,children,full_name){
return (function hatti$map$utils$iter__33324_$_iter__33342(s__33343){
return (new cljs.core.LazySeq(null,((function (i__33326,child_record,c__7187__auto__,size__7188__auto__,b__33327,s__33325__$2,temp__4657__auto__,map__33322,map__33322__$1,field,children,full_name){
return (function (){
var s__33343__$1 = s__33343;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__33343__$1);
if(temp__4657__auto____$1){
var s__33343__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__33343__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__33343__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__33345 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__33344 = (0);
while(true){
if((i__33344 < size__7188__auto____$1)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__33344);
cljs.core.chunk_append(b__33345,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__33354 = (i__33344 + (1));
i__33344 = G__33354;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33345),hatti$map$utils$iter__33324_$_iter__33342(cljs.core.chunk_rest(s__33343__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33345),null);
}
} else {
var child = cljs.core.first(s__33343__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__33324_$_iter__33342(cljs.core.rest(s__33343__$2)));
}
} else {
return null;
}
break;
}
});})(i__33326,child_record,c__7187__auto__,size__7188__auto__,b__33327,s__33325__$2,temp__4657__auto__,map__33322,map__33322__$1,field,children,full_name))
,null,null));
});})(i__33326,child_record,c__7187__auto__,size__7188__auto__,b__33327,s__33325__$2,temp__4657__auto__,map__33322,map__33322__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})());

var G__33355 = (i__33326 + (1));
i__33326 = G__33355;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33327),hatti$map$utils$iter__33324(cljs.core.chunk_rest(s__33325__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33327),null);
}
} else {
var child_record = cljs.core.first(s__33325__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (child_record,s__33325__$2,temp__4657__auto__,map__33322,map__33322__$1,field,children,full_name){
return (function hatti$map$utils$iter__33324_$_iter__33348(s__33349){
return (new cljs.core.LazySeq(null,((function (child_record,s__33325__$2,temp__4657__auto__,map__33322,map__33322__$1,field,children,full_name){
return (function (){
var s__33349__$1 = s__33349;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__33349__$1);
if(temp__4657__auto____$1){
var s__33349__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__33349__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33349__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33351 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33350 = (0);
while(true){
if((i__33350 < size__7188__auto__)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33350);
cljs.core.chunk_append(b__33351,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__33356 = (i__33350 + (1));
i__33350 = G__33356;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33351),hatti$map$utils$iter__33324_$_iter__33348(cljs.core.chunk_rest(s__33349__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33351),null);
}
} else {
var child = cljs.core.first(s__33349__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__33324_$_iter__33348(cljs.core.rest(s__33349__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__33325__$2,temp__4657__auto__,map__33322,map__33322__$1,field,children,full_name))
,null,null));
});})(child_record,s__33325__$2,temp__4657__auto__,map__33322,map__33322__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__33324(cljs.core.rest(s__33325__$2)));
}
} else {
return null;
}
break;
}
});})(map__33322,map__33322__$1,field,children,full_name))
,null,null));
});})(map__33322,map__33322__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,full_name));
}));
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__7189__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__33359(s__33360){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__33360__$1 = s__33360;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33360__$1);
if(temp__4657__auto__){
var s__33360__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33360__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33360__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33362 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33361 = (0);
while(true){
if((i__33361 < size__7188__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33361);
cljs.core.chunk_append(b__33362,(function (){var vec__33371 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33371,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33371,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33371,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33371,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__33378 = (i__33361 + (1));
i__33361 = G__33378;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33362),hatti$map$utils$iter__33359(cljs.core.chunk_rest(s__33360__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33362),null);
}
} else {
var coord_string = cljs.core.first(s__33360__$2);
return cljs.core.cons((function (){var vec__33374 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33374,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33374,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33374,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33374,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$iter__33359(cljs.core.rest(s__33360__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__7189__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__33377 = geotype;
switch (G__33377) {
case "Point":
return ((function (G__33377,geotype,parse){
return (function (p1__33357_SHARP_){
return cljs.core.first(parse(p1__33357_SHARP_));
});
;})(G__33377,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__33377,geotype,parse){
return (function (p1__33358_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__33358_SHARP_)],null));
});
;})(G__33377,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield));
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = (coords == null);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args33381 = [];
var len__7484__auto___33402 = arguments.length;
var i__7485__auto___33403 = (0);
while(true){
if((i__7485__auto___33403 < len__7484__auto___33402)){
args33381.push((arguments[i__7485__auto___33403]));

var G__33404 = (i__7485__auto___33403 + (1));
i__7485__auto___33403 = G__33404;
continue;
} else {
}
break;
}

var G__33383 = args33381.length;
switch (G__33383) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33381.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__7189__auto__ = (function hatti$map$utils$iter__33384(s__33385){
return (new cljs.core.LazySeq(null,(function (){
var s__33385__$1 = s__33385;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33385__$1);
if(temp__4657__auto__){
var s__33385__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33385__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33385__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33387 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33386 = (0);
while(true){
if((i__33386 < size__7188__auto__)){
var vec__33396 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33386);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33396,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33396,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append(b__33387,((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__33386,s__33385__$1,geom_or_geoms,vec__33396,idx,record,c__7187__auto__,size__7188__auto__,b__33387,s__33385__$2,temp__4657__auto__){
return (function (p1__33380_SHARP_){
return hatti.map.utils.make_feature(p1__33380_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(i__33386,s__33385__$1,geom_or_geoms,vec__33396,idx,record,c__7187__auto__,size__7188__auto__,b__33387,s__33385__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))));

var G__33406 = (i__33386 + (1));
i__33386 = G__33406;
continue;
} else {
var G__33407 = (i__33386 + (1));
i__33386 = G__33407;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33387),hatti$map$utils$iter__33384(cljs.core.chunk_rest(s__33385__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33387),null);
}
} else {
var vec__33399 = cljs.core.first(s__33385__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33399,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33399,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons(((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__33385__$1,geom_or_geoms,vec__33399,idx,record,s__33385__$2,temp__4657__auto__){
return (function (p1__33380_SHARP_){
return hatti.map.utils.make_feature(p1__33380_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(s__33385__$1,geom_or_geoms,vec__33399,idx,record,s__33385__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))),hatti$map$utils$iter__33384(cljs.core.rest(s__33385__$2)));
} else {
var G__33408 = cljs.core.rest(s__33385__$2);
s__33385__$1 = G__33408;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(hatti.utils.indexed(dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,cljs.core.flatten(features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;

/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__33410){
var map__33413 = p__33410;
var map__33413__$1 = ((((!((map__33413 == null)))?((((map__33413.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33413.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33413):map__33413);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33413__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33413__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__33413,map__33413__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__33409_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__33409_SHARP_));
});})(map__33413,map__33413__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,({"layers": cljs.core.first(layers), "zoomControl": false}));
var z = L.control.zoom.call(null,({"position": "bottomleft"}));
z.addTo(m);

L.control.layers.call(null,named_layers,null,({"position": "bottomleft"})).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33427 = arguments.length;
var i__7485__auto___33428 = (0);
while(true){
if((i__7485__auto___33428 < len__7484__auto___33427)){
args__7491__auto__.push((arguments[i__7485__auto___33428]));

var G__33429 = (i__7485__auto___33428 + (1));
i__7485__auto___33428 = G__33429;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__33424){
var map__33425 = p__33424;
var map__33425__$1 = ((((!((map__33425 == null)))?((((map__33425.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33425.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33425):map__33425);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33425__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__33425,map__33425__$1,rezoom_QMARK_){
return (function (p1__33415_SHARP_,p2__33416_SHARP_){
return hatti.map.utils.register_mouse_events(p1__33415_SHARP_,p2__33416_SHARP_,event_chan);
});})(map__33425,map__33425__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__33425,map__33425__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__33425,map__33425__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__33425,map__33425__$1,rezoom_QMARK_){
return (function (p1__33418_SHARP_,p2__33417_SHARP_){
return L.circleMarker(p2__33417_SHARP_);
});})(on_events,geometry_type,stylefn,map__33425,map__33425__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),({"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn}));
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__33425,map__33425__$1,rezoom_QMARK_){
return (function (p1__33419_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__33419_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__33425,map__33425__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq33420){
var G__33421 = cljs.core.first(seq33420);
var seq33420__$1 = cljs.core.next(seq33420);
var G__33422 = cljs.core.first(seq33420__$1);
var seq33420__$2 = cljs.core.next(seq33420__$1);
var G__33423 = cljs.core.first(seq33420__$2);
var seq33420__$3 = cljs.core.next(seq33420__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__33421,G__33422,G__33423,seq33420__$3);
});

/**
 * Creates a mapboxgl map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_mapboxgl_map = (function hatti$map$utils$create_mapboxgl_map(id){
mapboxgl.accessToken = hatti.constants.mapboxgl_access_token;

var Map = mapboxgl.Map;
var NavigationControl = mapboxgl.NavigationControl;
var ScaleControl = mapboxgl.ScaleControl;
var m = (new Map(({"container": id, "style": "mapbox://styles/mapbox/streets-v9"})));
m.addControl((new ScaleControl(({"maxWidth": (100), "unit": "metric"}))),"bottom-left");

return m.addControl((new NavigationControl()),"bottom-left");
});
/**
 * Gets query filter and returns filters based on field type
 */
hatti.map.utils.get_filter = (function hatti$map$utils$get_filter(p__33430,flat_form){
var map__33436 = p__33430;
var map__33436__$1 = ((((!((map__33436 == null)))?((((map__33436.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33436.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33436):map__33436);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33436__$1,cljs.core.cst$kw$column);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33436__$1,cljs.core.cst$kw$filter);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33436__$1,cljs.core.cst$kw$value);
var field = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__33436,map__33436__$1,column,filter,value){
return (function (p__33438){
var map__33439 = p__33438;
var map__33439__$1 = ((((!((map__33439 == null)))?((((map__33439.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33439.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33439):map__33439);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33439__$1,cljs.core.cst$kw$full_DASH_name);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(full_name,column);
});})(map__33436,map__33436__$1,column,filter,value))
,flat_form));
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS INT) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS AS TIMESTAMP) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
return [cljs.core.str("json->>'"),cljs.core.str(column),cljs.core.str("' "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');

}
}
});
/**
 * Generates query params filters for filtered datasets 
 */
hatti.map.utils.generate_filter_string = (function hatti$map$utils$generate_filter_string(query,flat_form){
if(cljs.core.truth_(cljs.core.not_empty(query))){
return [cljs.core.str(" and "),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" and ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33441_SHARP_){
return hatti.map.utils.get_filter(p1__33441_SHARP_,flat_form);
}),query)))].join('');
} else {
return null;
}
});
/**
 * Generates tiles url with appropriate filters as query params
 */
hatti.map.utils.get_tiles_endpoint = (function hatti$map$utils$get_tiles_endpoint(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33451 = arguments.length;
var i__7485__auto___33452 = (0);
while(true){
if((i__7485__auto___33452 < len__7484__auto___33451)){
args__7491__auto__.push((arguments[i__7485__auto___33452]));

var G__33453 = (i__7485__auto___33452 + (1));
i__7485__auto___33452 = G__33453;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((4) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((4)),(0),null)):null);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7492__auto__);
});

hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic = (function (tiles_server,formid,fields,flat_form,p__33447){
var vec__33448 = p__33447;
var query = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33448,(0),null);
return [cljs.core.str(tiles_server),cljs.core.str(hatti.constants.tiles_endpoint),cljs.core.str("?where=deleted_at is null and xform_id ="),cljs.core.str(formid),cljs.core.str(hatti.map.utils.generate_filter_string(query,flat_form)),cljs.core.str("&fields="),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",fields))].join('');
});

hatti.map.utils.get_tiles_endpoint.cljs$lang$maxFixedArity = (4);

hatti.map.utils.get_tiles_endpoint.cljs$lang$applyTo = (function (seq33442){
var G__33443 = cljs.core.first(seq33442);
var seq33442__$1 = cljs.core.next(seq33442);
var G__33444 = cljs.core.first(seq33442__$1);
var seq33442__$2 = cljs.core.next(seq33442__$1);
var G__33445 = cljs.core.first(seq33442__$2);
var seq33442__$3 = cljs.core.next(seq33442__$2);
var G__33446 = cljs.core.first(seq33442__$3);
var seq33442__$4 = cljs.core.next(seq33442__$3);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic(G__33443,G__33444,G__33445,G__33446,seq33442__$4);
});

/**
 * Add map source. This is called with either tiles-url or geoson which
 *   determins the source type (Vector or  GeosJSON). 
 */
hatti.map.utils.add_mapboxgl_source = (function hatti$map$utils$add_mapboxgl_source(map,id_string,p__33454){
var map__33458 = p__33454;
var map__33458__$1 = ((((!((map__33458 == null)))?((((map__33458.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33458.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33458):map__33458);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33458__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33458__$1,cljs.core.cst$kw$geojson);
var cluster = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33458__$1,cljs.core.cst$kw$cluster,false);
var clusterRadius = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33458__$1,cljs.core.cst$kw$clusterRadius);
var clusterMaxZoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33458__$1,cljs.core.cst$kw$clusterMaxZoom);
var geojson_source_defn = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"geojson",cljs.core.cst$kw$data,geojson,cljs.core.cst$kw$cluster,cluster], null);
var source = (cljs.core.truth_(geojson)?cljs.core.clj__GT_js((function (){var G__33460 = geojson_source_defn;
var G__33460__$1 = (cljs.core.truth_(clusterRadius)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33460,cljs.core.cst$kw$clusterRadius,clusterRadius):G__33460);
if(cljs.core.truth_(clusterMaxZoom)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33460__$1,cljs.core.cst$kw$clusterMaxZoom,clusterMaxZoom);
} else {
return G__33460__$1;
}
})()):(cljs.core.truth_(tiles_url)?cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"vector",cljs.core.cst$kw$tiles,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tiles_url], null)], null)):null));
if(cljs.core.truth_(map.getSource(id_string))){
return null;
} else {
return map.addSource(id_string,source);
}
});
/**
 * Add map layer from available sources.
 */
hatti.map.utils.add_mapboxgl_layer = (function hatti$map$utils$add_mapboxgl_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33469 = arguments.length;
var i__7485__auto___33470 = (0);
while(true){
if((i__7485__auto___33470 < len__7484__auto___33469)){
args__7491__auto__.push((arguments[i__7485__auto___33470]));

var G__33471 = (i__7485__auto___33470 + (1));
i__7485__auto___33470 = G__33471;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id_string,layer_type,p__33465){
var map__33466 = p__33465;
var map__33466__$1 = ((((!((map__33466 == null)))?((((map__33466.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33466.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33466):map__33466);
var layer_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33466__$1,cljs.core.cst$kw$layer_DASH_id);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33466__$1,cljs.core.cst$kw$layout);
var paint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33466__$1,cljs.core.cst$kw$paint);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33466__$1,cljs.core.cst$kw$filter);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33466__$1,cljs.core.cst$kw$tiles_DASH_url);
var l_id = (function (){var or__6409__auto__ = layer_id;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_string;
}
})();
var layer_def = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$id,l_id,cljs.core.cst$kw$type,layer_type,cljs.core.cst$kw$source,id_string], null);
var layer = cljs.core.clj__GT_js((function (){var G__33468 = layer_def;
var G__33468__$1 = (cljs.core.truth_(tiles_url)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33468,cljs.core.cst$kw$source_DASH_layer,hatti.constants.vector_source_layer):G__33468);
var G__33468__$2 = (cljs.core.truth_(paint)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33468__$1,cljs.core.cst$kw$paint,paint):G__33468__$1);
var G__33468__$3 = (cljs.core.truth_(layout)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33468__$2,cljs.core.cst$kw$layout,layout):G__33468__$2);
if(cljs.core.truth_(filter)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33468__$3,cljs.core.cst$kw$filter,filter);
} else {
return G__33468__$3;
}
})());
if(cljs.core.truth_(map.getLayer(l_id))){
return null;
} else {
return map.addLayer(layer,id_string);
}
});

hatti.map.utils.add_mapboxgl_layer.cljs$lang$maxFixedArity = (3);

hatti.map.utils.add_mapboxgl_layer.cljs$lang$applyTo = (function (seq33461){
var G__33462 = cljs.core.first(seq33461);
var seq33461__$1 = cljs.core.next(seq33461);
var G__33463 = cljs.core.first(seq33461__$1);
var seq33461__$2 = cljs.core.next(seq33461__$1);
var G__33464 = cljs.core.first(seq33461__$2);
var seq33461__$3 = cljs.core.next(seq33461__$2);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(G__33462,G__33463,G__33464,seq33461__$3);
});

/**
 * Generates a collection of input - output value pairs known
 * as stops. These stops are used by get-styles function to decide the style
 * output based on an input vaue from the dataset. e.g. _id. By defauly this
 *  function purely generates color stops.
 */
hatti.map.utils.generate_stops = (function hatti$map$utils$generate_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Generates cirlce size property stops base on values from dataset.
 */
hatti.map.utils.generate_size_stops = (function hatti$map$utils$generate_size_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(4)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Gets predefined styles for diffent layer types and states.
 */
hatti.map.utils.get_styles = (function hatti$map$utils$get_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33477 = arguments.length;
var i__7485__auto___33478 = (0);
while(true){
if((i__7485__auto___33478 < len__7484__auto___33477)){
args__7491__auto__.push((arguments[i__7485__auto___33478]));

var G__33479 = (i__7485__auto___33478 + (1));
i__7485__auto___33478 = G__33479;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic = (function (p__33473){
var vec__33474 = p__33473;
var selected_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33474,(0),null);
var stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33474,(1),null);
var size_stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33474,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",(4)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null),cljs.core.cst$kw$sized,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(size_stops)?size_stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(6)], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-opacity",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),0.2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(15),0.8], null)], null)], null))], null)], null)], null),cljs.core.cst$kw$fill,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-opacity",0.7], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-outline-color","#666"], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-opacity",0.8], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-width",(7)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null)], null);
});

hatti.map.utils.get_styles.cljs$lang$maxFixedArity = (0);

hatti.map.utils.get_styles.cljs$lang$applyTo = (function (seq33472){
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33472));
});

/**
 * Get style properties for layer.
 */
hatti.map.utils.get_style_properties = (function hatti$map$utils$get_style_properties(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33488 = arguments.length;
var i__7485__auto___33489 = (0);
while(true){
if((i__7485__auto___33489 < len__7484__auto___33488)){
args__7491__auto__.push((arguments[i__7485__auto___33489]));

var G__33490 = (i__7485__auto___33489 + (1));
i__7485__auto___33489 = G__33490;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic = (function (style_type,style_state,p__33483){
var map__33484 = p__33483;
var map__33484__$1 = ((((!((map__33484 == null)))?((((map__33484.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33484.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33484):map__33484);
var selected_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33484__$1,cljs.core.cst$kw$selected_DASH_id);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33484__$1,cljs.core.cst$kw$stops);
var G__33486 = (function (){var G__33487 = hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([selected_id,stops], 0));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__33487) : style_type.call(null,G__33487));
})();
return (style_state.cljs$core$IFn$_invoke$arity$1 ? style_state.cljs$core$IFn$_invoke$arity$1(G__33486) : style_state.call(null,G__33486));
});

hatti.map.utils.get_style_properties.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_style_properties.cljs$lang$applyTo = (function (seq33480){
var G__33481 = cljs.core.first(seq33480);
var seq33480__$1 = cljs.core.next(seq33480);
var G__33482 = cljs.core.first(seq33480__$1);
var seq33480__$2 = cljs.core.next(seq33480__$1);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(G__33481,G__33482,seq33480__$2);
});

/**
 * Sets maps paint properties given layer-id and list of properties to set.
 *   properties should be a list of properties that contains the propery name
 *   and value in a vector. e.g. [[property1 value1] [property2 value2]
 */
hatti.map.utils.set_mapboxgl_paint_property = (function hatti$map$utils$set_mapboxgl_paint_property(map,layer_id,properties){
var seq__33501 = cljs.core.seq(properties);
var chunk__33502 = null;
var count__33503 = (0);
var i__33504 = (0);
while(true){
if((i__33504 < count__33503)){
var vec__33505 = chunk__33502.cljs$core$IIndexed$_nth$arity$2(null,i__33504);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33505,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33505,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__33511 = seq__33501;
var G__33512 = chunk__33502;
var G__33513 = count__33503;
var G__33514 = (i__33504 + (1));
seq__33501 = G__33511;
chunk__33502 = G__33512;
count__33503 = G__33513;
i__33504 = G__33514;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__33501);
if(temp__4657__auto__){
var seq__33501__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33501__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__33501__$1);
var G__33515 = cljs.core.chunk_rest(seq__33501__$1);
var G__33516 = c__7220__auto__;
var G__33517 = cljs.core.count(c__7220__auto__);
var G__33518 = (0);
seq__33501 = G__33515;
chunk__33502 = G__33516;
count__33503 = G__33517;
i__33504 = G__33518;
continue;
} else {
var vec__33508 = cljs.core.first(seq__33501__$1);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33508,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33508,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__33519 = cljs.core.next(seq__33501__$1);
var G__33520 = null;
var G__33521 = (0);
var G__33522 = (0);
seq__33501 = G__33519;
chunk__33502 = G__33520;
count__33503 = G__33521;
i__33504 = G__33522;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.utils.get_id_property = (function hatti$map$utils$get_id_property(features){
var properties = (cljs.core.first(features)["properties"]);
var or__6409__auto__ = (properties["id"]);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return (properties[hatti.constants._id]);
}
});
/**
 * Register map mouse events.
 */
hatti.map.utils.register_mapboxgl_mouse_events = (function hatti$map$utils$register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style){
var layer_id = id_string;
var mousemove_fn = ((function (layer_id){
return (function (e){
if(cljs.core.truth_(map.getLayer(layer_id))){
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
var selected_id = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$id], null));
map.getCanvas().style.cursor = (((features.length > (0)))?"pointer":"");

if(cljs.core.truth_(view_by)){
return null;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(no_of_features,(1))){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$hover,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,hatti.map.utils.get_id_property(features)], 0)));
} else {
hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties(style,cljs.core.cst$kw$normal));

if(cljs.core.truth_(selected_id)){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,selected_id], 0)));
} else {
return null;
}
}
}
} else {
return null;
}
});})(layer_id))
;
var click_fn = ((function (layer_id,mousemove_fn){
return (function (e){
if(cljs.core.truth_(map.getLayer(layer_id))){
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
if((no_of_features > (0))){
var feature_id = hatti.map.utils.get_id_property(features);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_id,feature_id], null));

if(cljs.core.truth_(view_by)){
return null;
} else {
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,feature_id], 0)));
}
} else {
return null;
}
} else {
return null;
}
});})(layer_id,mousemove_fn))
;
map.off("mousemove",om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mousemove_DASH_fn));

map.off("click",om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$click_DASH_fn));

map.on("mousemove",mousemove_fn);

map.on("click",click_fn);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$mousemove_DASH_fn,mousemove_fn);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$click_DASH_fn,click_fn);
});
/**
 * Fits map boundaries on rendered features.
 */
hatti.map.utils.fitMapBounds = (function hatti$map$utils$fitMapBounds(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33530 = arguments.length;
var i__7485__auto___33531 = (0);
while(true){
if((i__7485__auto___33531 < len__7484__auto___33530)){
args__7491__auto__.push((arguments[i__7485__auto___33531]));

var G__33532 = (i__7485__auto___33531 + (1));
i__7485__auto___33531 = G__33532;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__33526){
var vec__33527 = p__33526;
var geojson = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33527,(0),null);
var features = (function (){var or__6409__auto__ = cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = (cljs.core.truth_(map.getLayer(layer_id))?map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null))):null);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return cljs.core.PersistentVector.EMPTY;
}
}
})();
var layer_data = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,features], null));
}
})();
var bbox = turf.bbox(cljs.core.clj__GT_js(layer_data));
if((cljs.core.count(features) > (0))){
return map.fitBounds(bbox,({"padding": "15", "linear": true}));
} else {
return null;
}
});

hatti.map.utils.fitMapBounds.cljs$lang$maxFixedArity = (2);

hatti.map.utils.fitMapBounds.cljs$lang$applyTo = (function (seq33523){
var G__33524 = cljs.core.first(seq33523);
var seq33523__$1 = cljs.core.next(seq33523);
var G__33525 = cljs.core.first(seq33523__$1);
var seq33523__$2 = cljs.core.next(seq33523__$1);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic(G__33524,G__33525,seq33523__$2);
});

/**
 * Get marker style for field type.
 */
hatti.map.utils.geotype__GT_marker_style = (function hatti$map$utils$geotype__GT_marker_style(p__33533){
var map__33536 = p__33533;
var map__33536__$1 = ((((!((map__33536 == null)))?((((map__33536.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33536.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33536):map__33536);
var field = map__33536__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33536__$1,cljs.core.cst$kw$children);
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.geoshape_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.osm_QMARK_(field);
}
})())){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.geotrace_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var and__6397__auto__ = hatti.ona.forms.repeat_QMARK_(field);
if(cljs.core.truth_(and__6397__auto__)){
return hatti.ona.forms.geotrace_QMARK_(cljs.core.first(children));
} else {
return and__6397__auto__;
}
}
})())){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$layer_DASH_type,"line",cljs.core.cst$kw$style,cljs.core.cst$kw$line,cljs.core.cst$kw$layout,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line_DASH_join,"round",cljs.core.cst$kw$line_DASH_cap,"round"], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"circle",cljs.core.cst$kw$style,cljs.core.cst$kw$point], null);

}
}
});
/**
 * Filter features and return only selected features. Returns all features
 *   features if selected-ids is nil. 
 */
hatti.map.utils.filter_selected_features = (function hatti$map$utils$filter_selected_features(features,selected_ids){
var G__33544 = features;
if(cljs.core.truth_(selected_ids)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__33544){
return (function (p__33545){
var map__33546 = p__33545;
var map__33546__$1 = ((((!((map__33546 == null)))?((((map__33546.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33546.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33546):map__33546);
var map__33547 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33546__$1,cljs.core.cst$kw$properties);
var map__33547__$1 = ((((!((map__33547 == null)))?((((map__33547.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33547.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33547):map__33547);
var _id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33547__$1,cljs.core.cst$kw$_id);
return chimera.seq.in_QMARK_(selected_ids,_id);
});})(G__33544))
,G__33544);
} else {
return G__33544;
}
});
/**
 * Counts points collected into hexbins.
 */
hatti.map.utils.count_hexbin_points = (function hatti$map$utils$count_hexbin_points(hexbins){
var iter__7189__auto__ = (function hatti$map$utils$count_hexbin_points_$_iter__33572(s__33573){
return (new cljs.core.LazySeq(null,(function (){
var s__33573__$1 = s__33573;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33573__$1);
if(temp__4657__auto__){
var s__33573__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33573__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33573__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33575 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33574 = (0);
while(true){
if((i__33574 < size__7188__auto__)){
var map__33586 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33574);
var map__33586__$1 = ((((!((map__33586 == null)))?((((map__33586.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33586.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33586):map__33586);
var feature = map__33586__$1;
var map__33587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33586__$1,cljs.core.cst$kw$properties);
var map__33587__$1 = ((((!((map__33587 == null)))?((((map__33587.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33587.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33587):map__33587);
var points = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33587__$1,cljs.core.cst$kw$points);
var point_count = cljs.core.count(points);
cljs.core.chunk_append(b__33575,(((point_count > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(feature,cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$point_DASH_count,point_count], null)):null));

var G__33594 = (i__33574 + (1));
i__33574 = G__33594;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33575),hatti$map$utils$count_hexbin_points_$_iter__33572(cljs.core.chunk_rest(s__33573__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33575),null);
}
} else {
var map__33590 = cljs.core.first(s__33573__$2);
var map__33590__$1 = ((((!((map__33590 == null)))?((((map__33590.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33590.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33590):map__33590);
var feature = map__33590__$1;
var map__33591 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33590__$1,cljs.core.cst$kw$properties);
var map__33591__$1 = ((((!((map__33591 == null)))?((((map__33591.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33591.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33591):map__33591);
var points = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33591__$1,cljs.core.cst$kw$points);
var point_count = cljs.core.count(points);
return cljs.core.cons((((point_count > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(feature,cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$point_DASH_count,point_count], null)):null),hatti$map$utils$count_hexbin_points_$_iter__33572(cljs.core.rest(s__33573__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(hexbins));
});
hatti.map.utils.get_rendered_features = (function hatti$map$utils$get_rendered_features(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33602 = arguments.length;
var i__7485__auto___33603 = (0);
while(true){
if((i__7485__auto___33603 < len__7484__auto___33602)){
args__7491__auto__.push((arguments[i__7485__auto___33603]));

var G__33604 = (i__7485__auto___33603 + (1));
i__7485__auto___33603 = G__33604;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__33599){
var map__33600 = p__33599;
var map__33600__$1 = ((((!((map__33600 == null)))?((((map__33600.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33600.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33600):map__33600);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33600__$1,cljs.core.cst$kw$geojson);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33600__$1,cljs.core.cst$kw$selected_DASH_ids);

var get_rendered_features = ((function (map__33600,map__33600__$1,geojson,selected_ids){
return (function (){
return map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
});})(map__33600,map__33600__$1,geojson,selected_ids))
;
var rendered_features = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,get_rendered_features()], null);
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(rendered_features,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$features], null),((function (get_rendered_features,rendered_features,map__33600,map__33600__$1,geojson,selected_ids){
return (function (p1__33595_SHARP_){
return hatti.map.utils.filter_selected_features(p1__33595_SHARP_,selected_ids);
});})(get_rendered_features,rendered_features,map__33600,map__33600__$1,geojson,selected_ids))
);
});

hatti.map.utils.get_rendered_features.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_rendered_features.cljs$lang$applyTo = (function (seq33596){
var G__33597 = cljs.core.first(seq33596);
var seq33596__$1 = cljs.core.next(seq33596);
var G__33598 = cljs.core.first(seq33596__$1);
var seq33596__$2 = cljs.core.next(seq33596__$1);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(G__33597,G__33598,seq33596__$2);
});

/**
 * Generates hexbins with point count aggregation given rendered
 *   layer-id or geojson.
 */
hatti.map.utils.generate_hexgrid = (function hatti$map$utils$generate_hexgrid(map,layer_id,geojson,p__33605){
var map__33614 = p__33605;
var map__33614__$1 = ((((!((map__33614 == null)))?((((map__33614.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33614.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33614):map__33614);
var cell_width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33614__$1,cljs.core.cst$kw$cell_DASH_width);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33614__$1,cljs.core.cst$kw$selected_DASH_ids);
var rendered_features = hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(map,layer_id,cljs.core.array_seq([cljs.core.cst$kw$geojson,geojson,cljs.core.cst$kw$selected_DASH_ids,selected_ids], 0));
var js_rendered_features = cljs.core.clj__GT_js(rendered_features);
var bbox = turf.bbox(js_rendered_features);
var cellWidth = (function (){var or__6409__auto__ = cell_width;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.hexbin_cell_width;
}
})();
var units = "kilometers";
var hexgrid = turf.hexGrid(bbox,cellWidth,units);
var hex_collection = turf.collect(hexgrid,js_rendered_features,"_id","points");
var hexbins = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(hex_collection,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var features_w_count = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,hatti.map.utils.count_hexbin_points(hexbins));
var point_counts = (function (){var iter__7189__auto__ = ((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__33614,map__33614__$1,cell_width,selected_ids){
return (function hatti$map$utils$generate_hexgrid_$_iter__33616(s__33617){
return (new cljs.core.LazySeq(null,((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__33614,map__33614__$1,cell_width,selected_ids){
return (function (){
var s__33617__$1 = s__33617;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33617__$1);
if(temp__4657__auto__){
var s__33617__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33617__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33617__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33619 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33618 = (0);
while(true){
if((i__33618 < size__7188__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33618);
cljs.core.chunk_append(b__33619,cljs.core.cst$kw$point_DASH_count.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(f)));

var G__33622 = (i__33618 + (1));
i__33618 = G__33622;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33619),hatti$map$utils$generate_hexgrid_$_iter__33616(cljs.core.chunk_rest(s__33617__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33619),null);
}
} else {
var f = cljs.core.first(s__33617__$2);
return cljs.core.cons(cljs.core.cst$kw$point_DASH_count.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(f)),hatti$map$utils$generate_hexgrid_$_iter__33616(cljs.core.rest(s__33617__$2)));
}
} else {
return null;
}
break;
}
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__33614,map__33614__$1,cell_width,selected_ids))
,null,null));
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__33614,map__33614__$1,cell_width,selected_ids))
;
return iter__7189__auto__(features_w_count);
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(hexbins,cljs.core.cst$kw$features,features_w_count,cljs.core.array_seq([cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$min_DASH_count,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,point_counts),cljs.core.cst$kw$max_DASH_count,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,point_counts)], null)], 0));
});
/**
 * Show/or hide geopoints. Hide geopoints if hide-points is true.
 */
hatti.map.utils.show_hide_points = (function hatti$map$utils$show_hide_points(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33630 = arguments.length;
var i__7485__auto___33631 = (0);
while(true){
if((i__7485__auto___33631 < len__7484__auto___33630)){
args__7491__auto__.push((arguments[i__7485__auto___33631]));

var G__33632 = (i__7485__auto___33631 + (1));
i__7485__auto___33631 = G__33632;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__33626){
var vec__33627 = p__33626;
var hide_points_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33627,(0),null);
var visibility = (cljs.core.truth_(hide_points_QMARK_)?"none":"visible");
if(cljs.core.truth_(map.getLayer(layer_id))){
map.setLayoutProperty(layer_id,"visibility",visibility);
} else {
}

if(cljs.core.truth_(map.getLayer(hatti.map.utils.circle_border_id))){
return map.setLayoutProperty(hatti.map.utils.circle_border_id,"visibility",visibility);
} else {
return null;
}
});

hatti.map.utils.show_hide_points.cljs$lang$maxFixedArity = (2);

hatti.map.utils.show_hide_points.cljs$lang$applyTo = (function (seq33623){
var G__33624 = cljs.core.first(seq33623);
var seq33623__$1 = cljs.core.next(seq33623);
var G__33625 = cljs.core.first(seq33623__$1);
var seq33623__$2 = cljs.core.next(seq33623__$1);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(G__33624,G__33625,seq33623__$2);
});

/**
 * Remove layer from map and it's source from map.
 */
hatti.map.utils.remove_layer = (function hatti$map$utils$remove_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33639 = arguments.length;
var i__7485__auto___33640 = (0);
while(true){
if((i__7485__auto___33640 < len__7484__auto___33639)){
args__7491__auto__.push((arguments[i__7485__auto___33640]));

var G__33641 = (i__7485__auto___33640 + (1));
i__7485__auto___33640 = G__33641;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id,p__33636){
var map__33637 = p__33636;
var map__33637__$1 = ((((!((map__33637 == null)))?((((map__33637.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33637.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33637):map__33637);
var keep_source_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33637__$1,cljs.core.cst$kw$keep_DASH_source_QMARK_);
if(cljs.core.truth_(map.getLayer(id))){
map.removeLayer(id);
} else {
}

if(cljs.core.truth_((function (){var and__6397__auto__ = map.getSource(id);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not(keep_source_QMARK_);
} else {
return and__6397__auto__;
}
})())){
return map.removeSource(id);
} else {
return null;
}
});

hatti.map.utils.remove_layer.cljs$lang$maxFixedArity = (2);

hatti.map.utils.remove_layer.cljs$lang$applyTo = (function (seq33633){
var G__33634 = cljs.core.first(seq33633);
var seq33633__$1 = cljs.core.next(seq33633);
var G__33635 = cljs.core.first(seq33633__$1);
var seq33633__$2 = cljs.core.next(seq33633__$1);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(G__33634,G__33635,seq33633__$2);
});

/**
 * Renders hexbin layer on map.
 */
hatti.map.utils.show_hexbins = (function hatti$map$utils$show_hexbins(owner,map,id_string,geojson,p__33642){
var map__33647 = p__33642;
var map__33647__$1 = ((((!((map__33647 == null)))?((((map__33647.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33647.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33647):map__33647);
var opts = map__33647__$1;
var cell_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33647__$1,cljs.core.cst$kw$cell_DASH_color);
var extrusion_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33647__$1,cljs.core.cst$kw$extrusion_QMARK_);
var hide_points_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33647__$1,cljs.core.cst$kw$hide_DASH_points_QMARK_);
var hexgrid = hatti.map.utils.generate_hexgrid(map,id_string,geojson,opts);
var map__33649 = cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(hexgrid);
var map__33649__$1 = ((((!((map__33649 == null)))?((((map__33649.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33649.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33649):map__33649);
var min_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33649__$1,cljs.core.cst$kw$min_DASH_count);
var max_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33649__$1,cljs.core.cst$kw$max_DASH_count);
var max_color = (function (){var or__6409__auto__ = cell_color;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.max_count_color;
}
})();
var min_color = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(min_count,max_count))?max_color:hatti.constants.min_count_color);
var property = "point-count";
var fill_color = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$property,"point-count",cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,min_color], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,max_color], null)], null)], null);
var fill_opacity = 0.6;
var paint = (cljs.core.truth_(extrusion_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fill_DASH_extrusion_DASH_color,fill_color,cljs.core.cst$kw$fill_DASH_extrusion_DASH_opacity,fill_opacity,cljs.core.cst$kw$fill_DASH_extrusion_DASH_height,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,property,cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,(10)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,(25000)], null)], null),cljs.core.cst$kw$base,(1)], null)], null):new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fill_DASH_outline_DASH_color,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$property,property,cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,"white"], null)], null)], null),cljs.core.cst$kw$fill_DASH_color,fill_color,cljs.core.cst$kw$fill_DASH_opacity,fill_opacity], null));
var layer_type = (cljs.core.truth_(extrusion_QMARK_)?"fill-extrusion":"fill");
var extrusion_layer_id = [cljs.core.str(hatti.constants.hexgrid_id),cljs.core.str("-extrusion")].join('');
if(cljs.core.truth_((function (){var and__6397__auto__ = min_count;
if(cljs.core.truth_(and__6397__auto__)){
return max_count;
} else {
return and__6397__auto__;
}
})())){
hatti.map.utils.add_mapboxgl_source(map,hatti.constants.hexgrid_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$geojson,hexgrid], null));

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,hatti.constants.hexgrid_id,layer_type,cljs.core.array_seq([cljs.core.cst$kw$paint,paint], 0));

if(cljs.core.truth_(extrusion_QMARK_)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,hatti.constants.hexgrid_id,layer_type,cljs.core.array_seq([cljs.core.cst$kw$paint,paint,cljs.core.cst$kw$layer_DASH_id,extrusion_layer_id], 0));

map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","none");
} else {
map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","visible");

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(map,extrusion_layer_id,cljs.core.array_seq([cljs.core.cst$kw$keep_DASH_source_QMARK_,true], 0));
}

map.setPitch((cljs.core.truth_(extrusion_QMARK_)?(50):(0)));

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([hide_points_QMARK_], 0));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$show_DASH_hexbins_QMARK_,true);
} else {
return null;
}
});
/**
 * Renders heatmap layer on map.
 */
hatti.map.utils.show_heatmap = (function hatti$map$utils$show_heatmap(owner,map,id_string,geojson,p__33651){
var map__33670 = p__33651;
var map__33670__$1 = ((((!((map__33670 == null)))?((((map__33670.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33670.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33670):map__33670);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33670__$1,cljs.core.cst$kw$selected_DASH_ids);
var rendered_features = hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([cljs.core.cst$kw$geojson,geojson,cljs.core.cst$kw$selected_DASH_ids,selected_ids], 0));
var layers = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (rendered_features,map__33670,map__33670__$1,selected_ids){
return (function (idx,item){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,item], null);
});})(rendered_features,map__33670,map__33670__$1,selected_ids))
,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"green"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(30),"#ffeda0"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(80),"orange"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),"red"], null)], null));
var layer_count = cljs.core.count(layers);
hatti.map.utils.add_mapboxgl_source(map,"heatmap",new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$geojson,rendered_features,cljs.core.cst$kw$cluster,true,cljs.core.cst$kw$clusterRadius,(20),cljs.core.cst$kw$clusterMaxZoom,(15)], null));

var seq__33672_33688 = cljs.core.seq(layers);
var chunk__33673_33689 = null;
var count__33674_33690 = (0);
var i__33675_33691 = (0);
while(true){
if((i__33675_33691 < count__33674_33690)){
var vec__33676_33692 = chunk__33673_33689.cljs$core$IIndexed$_nth$arity$2(null,i__33675_33691);
var i_33693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33676_33692,(0),null);
var vec__33679_33694 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33676_33692,(1),null);
var point_count_33695 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33679_33694,(0),null);
var color_33696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33679_33694,(1),null);
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,"heatmap","circle",cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,[cljs.core.str("cluster-"),cljs.core.str(i_33693)].join(''),cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$circle_DASH_color,color_33696,cljs.core.cst$kw$circle_DASH_radius,(70),cljs.core.cst$kw$circle_DASH_blur,(1),cljs.core.cst$kw$circle_DASH_opacity,0.7], null),cljs.core.cst$kw$filter,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i_33693,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_33695], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_33695], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first(cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(layers,(i_33693 + (1)))))], null)], null))], 0));

var G__33697 = seq__33672_33688;
var G__33698 = chunk__33673_33689;
var G__33699 = count__33674_33690;
var G__33700 = (i__33675_33691 + (1));
seq__33672_33688 = G__33697;
chunk__33673_33689 = G__33698;
count__33674_33690 = G__33699;
i__33675_33691 = G__33700;
continue;
} else {
var temp__4657__auto___33701 = cljs.core.seq(seq__33672_33688);
if(temp__4657__auto___33701){
var seq__33672_33702__$1 = temp__4657__auto___33701;
if(cljs.core.chunked_seq_QMARK_(seq__33672_33702__$1)){
var c__7220__auto___33703 = cljs.core.chunk_first(seq__33672_33702__$1);
var G__33704 = cljs.core.chunk_rest(seq__33672_33702__$1);
var G__33705 = c__7220__auto___33703;
var G__33706 = cljs.core.count(c__7220__auto___33703);
var G__33707 = (0);
seq__33672_33688 = G__33704;
chunk__33673_33689 = G__33705;
count__33674_33690 = G__33706;
i__33675_33691 = G__33707;
continue;
} else {
var vec__33682_33708 = cljs.core.first(seq__33672_33702__$1);
var i_33709 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33682_33708,(0),null);
var vec__33685_33710 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33682_33708,(1),null);
var point_count_33711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33685_33710,(0),null);
var color_33712 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33685_33710,(1),null);
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,"heatmap","circle",cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,[cljs.core.str("cluster-"),cljs.core.str(i_33709)].join(''),cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$circle_DASH_color,color_33712,cljs.core.cst$kw$circle_DASH_radius,(70),cljs.core.cst$kw$circle_DASH_blur,(1),cljs.core.cst$kw$circle_DASH_opacity,0.7], null),cljs.core.cst$kw$filter,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i_33709,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_33711], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_33711], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first(cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(layers,(i_33709 + (1)))))], null)], null))], 0));

var G__33713 = cljs.core.next(seq__33672_33702__$1);
var G__33714 = null;
var G__33715 = (0);
var G__33716 = (0);
seq__33672_33688 = G__33713;
chunk__33673_33689 = G__33714;
count__33674_33690 = G__33715;
i__33675_33691 = G__33716;
continue;
}
} else {
}
}
break;
}

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([true], 0));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$show_DASH_heatmap_QMARK_,true);
});
/**
 * Functions that are called after map is loaded in DOM.
 */
hatti.map.utils.map_on_load = (function hatti$map$utils$map_on_load(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33728 = arguments.length;
var i__7485__auto___33729 = (0);
while(true){
if((i__7485__auto___33729 < len__7484__auto___33728)){
args__7491__auto__.push((arguments[i__7485__auto___33729]));

var G__33730 = (i__7485__auto___33729 + (1));
i__7485__auto___33729 = G__33730;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic = (function (map,event_chan,id_string,p__33721){
var map__33722 = p__33721;
var map__33722__$1 = ((((!((map__33722 == null)))?((((map__33722.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33722.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33722):map__33722);
var map_data = map__33722__$1;
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33722__$1,cljs.core.cst$kw$geofield);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33722__$1,cljs.core.cst$kw$owner);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33722__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33722__$1,cljs.core.cst$kw$geojson);
var map__33724 = hatti.map.utils.geotype__GT_marker_style(geofield);
var map__33724__$1 = ((((!((map__33724 == null)))?((((map__33724.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33724.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33724):map__33724);
var layer_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33724__$1,cljs.core.cst$kw$layer_DASH_type);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33724__$1,cljs.core.cst$kw$layout);
var style = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33724__$1,cljs.core.cst$kw$style);
var map__33725 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(owner);
var map__33725__$1 = ((((!((map__33725 == null)))?((((map__33725.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33725.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33725):map__33725);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33725__$1,cljs.core.cst$kw$stops);
var layer_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33725__$1,cljs.core.cst$kw$layer_DASH_opts);
var show_hexbins_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33725__$1,cljs.core.cst$kw$show_DASH_hexbins_QMARK_);
var show_heatmap_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33725__$1,cljs.core.cst$kw$show_DASH_heatmap_QMARK_);
if(cljs.core.truth_((function (){var or__6409__auto__ = (cljs.core.count(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)) > (0));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return tiles_url;
}
})())){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,false);

hatti.map.utils.add_mapboxgl_source(map,id_string,map_data);

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layout,layout,cljs.core.cst$kw$tiles_DASH_url,tiles_url], 0));

hatti.map.utils.register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style);

hatti.map.utils.set_mapboxgl_paint_property(map,id_string,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$normal,cljs.core.array_seq([cljs.core.cst$kw$stops,stops], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$point,style)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,hatti.map.utils.circle_border_id,cljs.core.cst$kw$tiles_DASH_url,tiles_url,cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$circle_DASH_color,"#fff",cljs.core.cst$kw$circle_DASH_radius,(6)], null)], 0));
} else {
if(cljs.core.truth_(map.getLayer(hatti.map.utils.circle_border_id))){
map.removeLayer(hatti.map.utils.circle_border_id);
} else {
}
}

if(cljs.core.truth_(show_hexbins_QMARK_)){
hatti.map.utils.show_hexbins(owner,map,id_string,geojson,layer_opts);
} else {
}

if(cljs.core.truth_(show_heatmap_QMARK_)){
hatti.map.utils.show_heatmap(owner,map,id_string,geojson,layer_opts);
} else {
}

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$geojson,geojson);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$style,style);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,true);
} else {
return null;
}
});

hatti.map.utils.map_on_load.cljs$lang$maxFixedArity = (3);

hatti.map.utils.map_on_load.cljs$lang$applyTo = (function (seq33717){
var G__33718 = cljs.core.first(seq33717);
var seq33717__$1 = cljs.core.next(seq33717);
var G__33719 = cljs.core.first(seq33717__$1);
var seq33717__$2 = cljs.core.next(seq33717__$1);
var G__33720 = cljs.core.first(seq33717__$2);
var seq33717__$3 = cljs.core.next(seq33717__$2);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic(G__33718,G__33719,G__33720,seq33717__$3);
});

/**
 * Set default style
 */
hatti.map.utils.clear_map_styles = (function hatti$map$utils$clear_map_styles(owner){
return hatti.map.utils.set_mapboxgl_paint_property(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mapboxgl_DASH_map),om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$layer_DASH_id),hatti.map.utils.get_style_properties(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$style),cljs.core.cst$kw$normal));
});
/**
 * Update map zoom level in local component state on zoom event.
 */
hatti.map.utils.set_zoom_level = (function hatti$map$utils$set_zoom_level(owner){
var map__33733 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(owner);
var map__33733__$1 = ((((!((map__33733 == null)))?((((map__33733.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33733.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33733):map__33733);
var mapboxgl_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33733__$1,cljs.core.cst$kw$mapboxgl_DASH_map);
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33733__$1,cljs.core.cst$kw$zoom);
var next_zoom = mapboxgl_map.getZoom();
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(zoom,next_zoom)){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$zoom,next_zoom);
} else {
return null;
}
});
