// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.call(null,cljs.core.filter.call(null,hatti.ona.forms.has_data_QMARK_,cljs.core.concat.call(null,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields.call(null,form),hatti.ona.forms.meta_fields.call(null,form,new cljs.core.Keyword(null,"with-submission-details?","with-submission-details?",524960549),true))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__25311_SHARP_){
if(typeof p1__25311_SHARP_ === 'string'){
return clojure.string.lower_case.call(null,p1__25311_SHARP_);
} else {
return p1__25311_SHARP_;
}
});})(col))
;
var aval = lower.call(null,(a[(col["field"])]));
var bval = lower.call(null,(b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not.call(null,args)){
return true;
} else {
var indexed_form = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"full-name","full-name",408178550),form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__25317){
var vec__25318 = p__25317;
var fname = cljs.core.nth.call(null,vec__25318,(0),null);
var answer = cljs.core.nth.call(null,vec__25318,(1),null);
return hatti.ona.forms.format_answer.call(null,cljs.core.get.call(null,indexed_form,fname),answer,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true);
});})(indexed_form,query))
;
var filtered = cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,((function (indexed_form,query,fmt_subitem){
return (function (p1__25312_SHARP_){
return cljs.core.re_find.call(null,chimera.js_interop.safe_regex.call(null,query),[cljs.core.str(p1__25312_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.call(null,fmt_subitem,cljs.core.js__GT_clj.call(null,item))));
return cljs.core.seq.call(null,filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.call(null,value,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return hatti.ona.forms.format_answer.call(null,field,chimera.string.escape_for_type.call(null,clj_value),new cljs.core.Keyword(null,"language","language",-1591107564),language,new cljs.core.Keyword(null,"compact?","compact?",1216893298),true,new cljs.core.Keyword(null,"field-key","field-key",313262601),field_key);
});
cljs.core._add_method.call(null,hatti.views.action_buttons,new cljs.core.Keyword(null,"default","default",-1987822328),(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__25321 = new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state));
var map__25321__$1 = ((((!((map__25321 == null)))?((((map__25321.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25321.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25321):map__25321);
var owner__$1 = cljs.core.get.call(null,map__25321__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var project = cljs.core.get.call(null,map__25321__$1,new cljs.core.Keyword(null,"project","project",1124394579));
var formid = cljs.core.get.call(null,map__25321__$1,new cljs.core.Keyword(null,"formid","formid",-2121398991));
var form_owner = chimera.urls.last_url_param.call(null,owner__$1);
var project_id = chimera.urls.last_url_param.call(null,project);
var edit_link = chimera.urls.url.call(null,form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join(''));
return hatti.utils.generate_html.call(null,(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input.delete-record","input.delete-record",-1708576930),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip.middle-right","li.tooltip.middle-right",-548323211),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.view-record","a.view-record",235834372),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-eye","i.fa.fa-eye",-1428531423),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.tooltip","li.tooltip",-1420587330),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.tip-info","span.tip-info",147552832),"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.edit-record","a.edit-record",698797771),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"data-id","data-id",1023855591),value,new cljs.core.Keyword(null,"target","target",253001721),"_blank",new cljs.core.Keyword(null,"href","href",-793805698),edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-pencil","i.fa.fa-pencil",1547895857)], null)], null)], null)], null):null));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"maxWidth","maxWidth",-1375124795),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,hatti.views.action_buttons.call(null,owner),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___25350 = arguments.length;
var i__7485__auto___25351 = (0);
while(true){
if((i__7485__auto___25351 < len__7484__auto___25350)){
args__7491__auto__.push((arguments[i__7485__auto___25351]));

var G__25352 = (i__7485__auto___25351 + (1));
i__7485__auto___25351 = G__25352;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__25326){
var map__25327 = p__25326;
var map__25327__$1 = ((((!((map__25327 == null)))?((((map__25327.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25327.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25327):map__25327);
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25327__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var get_label_QMARK_ = cljs.core.get.call(null,map__25327__$1,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),true);
var language = cljs.core.get.call(null,map__25327__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var owner = cljs.core.get.call(null,map__25327__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var has_hxl_QMARK_ = chimera.core.any_QMARK_.call(null,cljs.core.false_QMARK_,cljs.core.map.call(null,((function (map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__25323_SHARP_){
return (new cljs.core.Keyword(null,"hxl","hxl",-849576989).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"instance","instance",-2121349050).cljs$core$IFn$_invoke$arity$1(p1__25323_SHARP_)) == null);
});})(map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,form));
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__25329(s__25330){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__25330__$1 = s__25330;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25330__$1);
if(temp__4657__auto__){
var s__25330__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25330__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25330__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25332 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25331 = (0);
while(true){
if((i__25331 < size__7188__auto__)){
var field = cljs.core._nth.call(null,c__7187__auto__,i__25331);
cljs.core.chunk_append.call(null,b__25332,(function (){var map__25341 = field;
var map__25341__$1 = ((((!((map__25341 == null)))?((((map__25341.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25341.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25341):map__25341);
var map__25342 = cljs.core.get.call(null,map__25341__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25342__$1 = ((((!((map__25342 == null)))?((((map__25342.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25342.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25342):map__25342);
var hxl = cljs.core.get.call(null,map__25342__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25341__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25341__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25341__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__25353 = (i__25331 + (1));
i__25331 = G__25353;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25332),hatti$views$table$iter__25329.call(null,cljs.core.chunk_rest.call(null,s__25330__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25332),null);
}
} else {
var field = cljs.core.first.call(null,s__25330__$2);
return cljs.core.cons.call(null,(function (){var map__25345 = field;
var map__25345__$1 = ((((!((map__25345 == null)))?((((map__25345.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25345.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25345):map__25345);
var map__25346 = cljs.core.get.call(null,map__25345__$1,new cljs.core.Keyword(null,"instance","instance",-2121349050));
var map__25346__$1 = ((((!((map__25346 == null)))?((((map__25346.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25346.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25346):map__25346);
var hxl = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"hxl","hxl",-849576989));
var name = cljs.core.get.call(null,map__25345__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var type = cljs.core.get.call(null,map__25345__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var full_name = cljs.core.get.call(null,map__25345__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.call(null,field,language):name);
var column_class = hatti.ona.forms.get_column_class.call(null,field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?new cljs.core.Keyword(null,"name","name",1843675177):new cljs.core.Keyword(null,"label","label",1718410804));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"hxl","hxl",-849576989),new cljs.core.Keyword(null,"headerCssClass","headerCssClass",-1721145883),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"formatter","formatter",-483008823),new cljs.core.Keyword(null,"minWidth","minWidth",-204293526),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sortable","sortable",2109633621),new cljs.core.Keyword(null,"cssClass","cssClass",264048890),new cljs.core.Keyword(null,"toolTip","toolTip",-228608737)],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string.call(null,column_class,label,hxl),cljs.core.partial.call(null,hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__25329.call(null,cljs.core.rest.call(null,s__25330__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__25327,map__25327__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__.call(null,hatti.views.table.all_fields.call(null,form));
})();
return cljs.core.clj__GT_js.call(null,(function (){var G__25349 = columns;
if(cljs.core.not.call(null,hide_actions_column_QMARK_)){
return cljs.core.conj.call(null,G__25349,hatti.views.table.actions_column.call(null,owner,has_hxl_QMARK_));
} else {
return G__25349;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq25324){
var G__25325 = cljs.core.first.call(null,seq25324);
var seq25324__$1 = cljs.core.next.call(null,seq25324);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__25325,seq25324__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,jQuery([cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join(''))));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25370(s__25371){
return (new cljs.core.LazySeq(null,(function (){
var s__25371__$1 = s__25371;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25371__$1);
if(temp__4657__auto__){
var s__25371__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25371__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25371__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25373 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25372 = (0);
while(true){
if((i__25372 < size__7188__auto__)){
var vec__25380 = cljs.core._nth.call(null,c__7187__auto__,i__25372);
var handler_key = cljs.core.nth.call(null,vec__25380,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25380,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append.call(null,b__25373,event.subscribe(handler_function));

var G__25386 = (i__25372 + (1));
i__25372 = G__25386;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25373),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25370.call(null,cljs.core.chunk_rest.call(null,s__25371__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25373),null);
}
} else {
var vec__25383 = cljs.core.first.call(null,s__25371__$2);
var handler_key = cljs.core.nth.call(null,vec__25383,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25383,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (grid[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__25370.call(null,cljs.core.rest.call(null,s__25371__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.call(null,(function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25403(s__25404){
return (new cljs.core.LazySeq(null,(function (){
var s__25404__$1 = s__25404;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25404__$1);
if(temp__4657__auto__){
var s__25404__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25404__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25404__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25406 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25405 = (0);
while(true){
if((i__25405 < size__7188__auto__)){
var vec__25413 = cljs.core._nth.call(null,c__7187__auto__,i__25405);
var handler_key = cljs.core.nth.call(null,vec__25413,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25413,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append.call(null,b__25406,event.subscribe(handler_function));

var G__25419 = (i__25405 + (1));
i__25405 = G__25419;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25406),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25403.call(null,cljs.core.chunk_rest.call(null,s__25404__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25406),null);
}
} else {
var vec__25416 = cljs.core.first.call(null,s__25404__$2);
var handler_key = cljs.core.nth.call(null,vec__25416,(0),null);
var handler_function = cljs.core.nth.call(null,vec__25416,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case.call(null,cljs.core.name.call(null,handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons.call(null,event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__25403.call(null,cljs.core.rest.call(null,s__25404__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__25422 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25422__$1 = ((((!((map__25422 == null)))?((((map__25422.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25422.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25422):map__25422);
var data_to_be_deleted = cljs.core.get.call(null,map__25422__$1,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634));
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634)], null),((function (map__25422,map__25422__$1,data_to_be_deleted,fn){
return (function (){
return fn.call(null,data_to_be_deleted,data_id);
});})(map__25422,map__25422__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,[cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.call(null,selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector.call(null,data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__25428 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"data-to-be-deleted","data-to-be-deleted",238665634).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state)));
var chunk__25429 = null;
var count__25430 = (0);
var i__25431 = (0);
while(true){
if((i__25431 < count__25430)){
var data_id = cljs.core._nth.call(null,chunk__25429,i__25431);
var element_25432 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25432.checked = true;

var G__25433 = seq__25428;
var G__25434 = chunk__25429;
var G__25435 = count__25430;
var G__25436 = (i__25431 + (1));
seq__25428 = G__25433;
chunk__25429 = G__25434;
count__25430 = G__25435;
i__25431 = G__25436;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__25428);
if(temp__4657__auto__){
var seq__25428__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25428__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__25428__$1);
var G__25437 = cljs.core.chunk_rest.call(null,seq__25428__$1);
var G__25438 = c__7220__auto__;
var G__25439 = cljs.core.count.call(null,c__7220__auto__);
var G__25440 = (0);
seq__25428 = G__25437;
chunk__25429 = G__25438;
count__25430 = G__25439;
i__25431 = G__25440;
continue;
} else {
var data_id = cljs.core.first.call(null,seq__25428__$1);
var element_25441 = hatti.views.table.get_delete_checkbox_by_data_id.call(null,data_id);
element_25441.checked = true;

var G__25442 = cljs.core.next.call(null,seq__25428__$1);
var G__25443 = null;
var G__25444 = (0);
var G__25445 = (0);
seq__25428 = G__25442;
chunk__25429 = G__25443;
count__25430 = G__25444;
i__25431 = G__25445;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map_indexed.call(null,((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity.call(null,indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,indexes_of_selected_checkboxes));
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__25446){
var map__25461 = p__25446;
var map__25461__$1 = ((((!((map__25461 == null)))?((((map__25461.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25461.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25461):map__25461);
var grid_event_handlers = cljs.core.get.call(null,map__25461__$1,new cljs.core.Keyword(null,"grid-event-handlers","grid-event-handlers",1413592355));
var dataview_event_handlers = cljs.core.get.call(null,map__25461__$1,new cljs.core.Keyword(null,"dataview-event-handlers","dataview-event-handlers",-916375885));
var map__25463 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25463__$1 = ((((!((map__25463 == null)))?((((map__25463.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25463.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25463):map__25463);
var map__25464 = cljs.core.get.call(null,map__25463__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__25464__$1 = ((((!((map__25464 == null)))?((((map__25464.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25464.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25464):map__25464);
var map__25465 = cljs.core.get.call(null,map__25464__$1,new cljs.core.Keyword(null,"paging","paging",1716279728));
var map__25465__$1 = ((((!((map__25465 == null)))?((((map__25465.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25465.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25465):map__25465);
var num_displayed_records = cljs.core.get.call(null,map__25465__$1,new cljs.core.Keyword(null,"num-displayed-records","num-displayed-records",213046400));
var total_page_count = cljs.core.get.call(null,map__25465__$1,new cljs.core.Keyword(null,"total-page-count","total-page-count",582341740));
var hide_actions_column_QMARK_ = cljs.core.get.call(null,map__25464__$1,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754));
var columns = hatti.views.table.flat_form__GT_sg_columns.call(null,form,new cljs.core.Keyword(null,"language","language",-1591107564),current_language,new cljs.core.Keyword(null,"hide-actions-column?","hide-actions-column?",-30644754),hide_actions_column_QMARK_,new cljs.core.Keyword(null,"owner","owner",-392611939),owner);
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers.call(null,grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers.call(null,dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selectActiveRow","selectActiveRow",-841772687),false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted.call(null);

return hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
});})(map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
if((cljs.core._EQ_.call(null,args.column.id,"actions")) && (cljs.core._EQ_.call(null,e.target.type,"checkbox"))){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector.call(null,delete_record_class_selector);
if(cljs.core._EQ_.call(null,hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__25469_25475 = cljs.core.seq.call(null,records_to_be_deleted);
var chunk__25470_25476 = null;
var count__25471_25477 = (0);
var i__25472_25478 = (0);
while(true){
if((i__25472_25478 < count__25471_25477)){
var record_25479 = cljs.core._nth.call(null,chunk__25470_25476,i__25472_25478);
record_25479.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25479.getAttribute("data-id")));

var G__25480 = seq__25469_25475;
var G__25481 = chunk__25470_25476;
var G__25482 = count__25471_25477;
var G__25483 = (i__25472_25478 + (1));
seq__25469_25475 = G__25480;
chunk__25470_25476 = G__25481;
count__25471_25477 = G__25482;
i__25472_25478 = G__25483;
continue;
} else {
var temp__4657__auto___25484 = cljs.core.seq.call(null,seq__25469_25475);
if(temp__4657__auto___25484){
var seq__25469_25485__$1 = temp__4657__auto___25484;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25469_25485__$1)){
var c__7220__auto___25486 = cljs.core.chunk_first.call(null,seq__25469_25485__$1);
var G__25487 = cljs.core.chunk_rest.call(null,seq__25469_25485__$1);
var G__25488 = c__7220__auto___25486;
var G__25489 = cljs.core.count.call(null,c__7220__auto___25486);
var G__25490 = (0);
seq__25469_25475 = G__25487;
chunk__25470_25476 = G__25488;
count__25471_25477 = G__25489;
i__25472_25478 = G__25490;
continue;
} else {
var record_25491 = cljs.core.first.call(null,seq__25469_25485__$1);
record_25491.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,parseInt(record_25491.getAttribute("data-id")));

var G__25492 = cljs.core.next.call(null,seq__25469_25485__$1);
var G__25493 = null;
var G__25494 = (0);
var G__25495 = (0);
seq__25469_25475 = G__25492;
chunk__25470_25476 = G__25493;
count__25471_25477 = G__25494;
i__25472_25478 = G__25495;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.call(null,total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
return null;
}
} else {
return null;
}
});})(map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
});})(map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?parseInt(elem.getAttribute("data-id")):null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__25473 = cljs.core.deref.call(null,hatti.shared.app_state);
var map__25473__$1 = ((((!((map__25473 == null)))?((((map__25473.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25473.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25473):map__25473);
var selected_table_rows = cljs.core.get.call(null,map__25473__$1,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745));
if(cljs.core._EQ_.call(null,class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = parseInt(grid.getCellFromEvent(e).row);
hatti.views.table.update_data_to_be_deleted_vector.call(null,checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_.call(null);

chimera.om.state.transact_BANG_.call(null,hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745)], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25473,map__25473__$1,selected_table_rows,map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return fn.call(null,selected_table_rows,row__$1);
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__25473,map__25473__$1,selected_table_rows,map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"selected-table-rows","selected-table-rows",-864456745).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,hatti.shared.app_state))));
} else {
if(cljs.core._EQ_.call(null,id,data_id)){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797),rank], null));
} else {
return null;
}
}
});})(map__25463,map__25463__$1,map__25464,map__25464__$1,map__25465,map__25465__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__25461,map__25461__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager.call(null,grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.call(null,hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js.call(null,data),hatti.constants._id);

hatti.views.table.resizeColumns.call(null,grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap.call(null);
var c__12309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto__,event_chan){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,event_chan){
return (function (state_25787){
var state_val_25788 = (state_25787[(1)]);
if((state_val_25788 === (7))){
var inst_25685 = (state_25787[(7)]);
var inst_25685__$1 = (state_25787[(2)]);
var inst_25687 = (inst_25685__$1 == null);
var inst_25688 = cljs.core.not.call(null,inst_25687);
var state_25787__$1 = (function (){var statearr_25789 = state_25787;
(statearr_25789[(7)] = inst_25685__$1);

return statearr_25789;
})();
if(inst_25688){
var statearr_25790_25865 = state_25787__$1;
(statearr_25790_25865[(1)] = (8));

} else {
var statearr_25791_25866 = state_25787__$1;
(statearr_25791_25866[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (20))){
var inst_25715 = (state_25787[(8)]);
var inst_25707 = (state_25787[(9)]);
var inst_25724 = inst_25715.call(null,inst_25707);
var state_25787__$1 = state_25787;
var statearr_25792_25867 = state_25787__$1;
(statearr_25792_25867[(2)] = inst_25724);

(statearr_25792_25867[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (27))){
var state_25787__$1 = state_25787;
var statearr_25793_25868 = state_25787__$1;
(statearr_25793_25868[(2)] = null);

(statearr_25793_25868[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (1))){
var state_25787__$1 = state_25787;
var statearr_25794_25869 = state_25787__$1;
(statearr_25794_25869[(2)] = null);

(statearr_25794_25869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (24))){
var state_25787__$1 = state_25787;
var statearr_25795_25870 = state_25787__$1;
(statearr_25795_25870[(2)] = null);

(statearr_25795_25870[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (4))){
var state_25787__$1 = state_25787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25787__$1,(7),event_chan);
} else {
if((state_val_25788 === (15))){
var inst_25685 = (state_25787[(7)]);
var state_25787__$1 = state_25787;
var statearr_25796_25871 = state_25787__$1;
(statearr_25796_25871[(2)] = inst_25685);

(statearr_25796_25871[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (21))){
var state_25787__$1 = state_25787;
var statearr_25797_25872 = state_25787__$1;
(statearr_25797_25872[(2)] = null);

(statearr_25797_25872[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (31))){
var inst_25711 = (state_25787[(10)]);
var inst_25760 = (state_25787[(2)]);
var inst_25761 = cljs.core._EQ_.call(null,inst_25711,new cljs.core.Keyword(null,"table","table",-564943036));
var state_25787__$1 = (function (){var statearr_25798 = state_25787;
(statearr_25798[(11)] = inst_25760);

return statearr_25798;
})();
if(inst_25761){
var statearr_25799_25873 = state_25787__$1;
(statearr_25799_25873[(1)] = (32));

} else {
var statearr_25800_25874 = state_25787__$1;
(statearr_25800_25874[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (32))){
var inst_25705 = (state_25787[(12)]);
var inst_25711 = (state_25787[(10)]);
var inst_25709 = (state_25787[(13)]);
var inst_25708 = (state_25787[(14)]);
var inst_25710 = (state_25787[(15)]);
var inst_25706 = (state_25787[(16)]);
var inst_25716 = (state_25787[(17)]);
var inst_25715 = (state_25787[(8)]);
var inst_25707 = (state_25787[(9)]);
var inst_25774 = cljs.core.async.chan.call(null,(1));
var inst_25775 = (function (){var new_columns = inst_25710;
var submission_clicked = inst_25707;
var submission_unclicked = inst_25708;
var get_submission_data = inst_25716;
var c__12309__auto____$1 = inst_25774;
var re_render = inst_25711;
var update_data_BANG_ = inst_25715;
var submission_to_rank = inst_25706;
var filter_by = inst_25709;
var map__25683 = inst_25705;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25774,state_val_25788,c__12309__auto__,event_chan){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25774,state_val_25788,c__12309__auto__,event_chan){
return (function (state_25772){
var state_val_25773 = (state_25772[(1)]);
if((state_val_25773 === (1))){
var inst_25763 = cljs.core.async.timeout.call(null,(20));
var state_25772__$1 = state_25772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25772__$1,(2),inst_25763);
} else {
if((state_val_25773 === (2))){
var inst_25765 = (state_25772[(2)]);
var inst_25766 = grid.resizeCanvas();
var inst_25767 = grid.invalidateAllRows();
var inst_25768 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25769 = grid.render();
var inst_25770 = hatti.views.table.init_sg_pager.call(null,grid,dataview);
var state_25772__$1 = (function (){var statearr_25801 = state_25772;
(statearr_25801[(7)] = inst_25769);

(statearr_25801[(8)] = inst_25768);

(statearr_25801[(9)] = inst_25766);

(statearr_25801[(10)] = inst_25765);

(statearr_25801[(11)] = inst_25767);

return statearr_25801;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25772__$1,inst_25770);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25774,state_val_25788,c__12309__auto__,event_chan))
;
return ((function (switch__12197__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25774,state_val_25788,c__12309__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____0 = (function (){
var statearr_25805 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25805[(0)] = hatti$views$table$handle_table_events_$_state_machine__12198__auto__);

(statearr_25805[(1)] = (1));

return statearr_25805;
});
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____1 = (function (state_25772){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_25772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e25806){if((e25806 instanceof Object)){
var ex__12201__auto__ = e25806;
var statearr_25807_25875 = state_25772;
(statearr_25807_25875[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25772);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25806;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25876 = state_25772;
state_25772 = G__25876;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = function(state_25772){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____1.call(this,state_25772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25774,state_val_25788,c__12309__auto__,event_chan))
})();
var state__12311__auto__ = (function (){var statearr_25808 = f__12310__auto__.call(null);
(statearr_25808[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto____$1);

return statearr_25808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25774,state_val_25788,c__12309__auto__,event_chan))
})();
var inst_25776 = cljs.core.async.impl.dispatch.run.call(null,inst_25775);
var state_25787__$1 = (function (){var statearr_25809 = state_25787;
(statearr_25809[(18)] = inst_25776);

return statearr_25809;
})();
var statearr_25810_25877 = state_25787__$1;
(statearr_25810_25877[(2)] = inst_25774);

(statearr_25810_25877[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (33))){
var state_25787__$1 = state_25787;
var statearr_25811_25878 = state_25787__$1;
(statearr_25811_25878[(2)] = null);

(statearr_25811_25878[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (13))){
var inst_25697 = (state_25787[(2)]);
var state_25787__$1 = state_25787;
var statearr_25812_25879 = state_25787__$1;
(statearr_25812_25879[(2)] = inst_25697);

(statearr_25812_25879[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (22))){
var inst_25708 = (state_25787[(14)]);
var inst_25727 = (state_25787[(2)]);
var state_25787__$1 = (function (){var statearr_25813 = state_25787;
(statearr_25813[(19)] = inst_25727);

return statearr_25813;
})();
if(cljs.core.truth_(inst_25708)){
var statearr_25814_25880 = state_25787__$1;
(statearr_25814_25880[(1)] = (23));

} else {
var statearr_25815_25881 = state_25787__$1;
(statearr_25815_25881[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (29))){
var inst_25709 = (state_25787[(13)]);
var inst_25752 = [new cljs.core.Keyword(null,"query","query",-1288509510)];
var inst_25753 = [inst_25709];
var inst_25754 = cljs.core.PersistentHashMap.fromArrays(inst_25752,inst_25753);
var inst_25755 = cljs.core.clj__GT_js.call(null,inst_25754);
var inst_25756 = dataview.setFilterArgs(inst_25755);
var inst_25757 = dataview.refresh();
var state_25787__$1 = (function (){var statearr_25816 = state_25787;
(statearr_25816[(20)] = inst_25756);

return statearr_25816;
})();
var statearr_25817_25882 = state_25787__$1;
(statearr_25817_25882[(2)] = inst_25757);

(statearr_25817_25882[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (6))){
var inst_25783 = (state_25787[(2)]);
var state_25787__$1 = state_25787;
var statearr_25818_25883 = state_25787__$1;
(statearr_25818_25883[(2)] = inst_25783);

(statearr_25818_25883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (28))){
var inst_25709 = (state_25787[(13)]);
var inst_25750 = (state_25787[(2)]);
var state_25787__$1 = (function (){var statearr_25819 = state_25787;
(statearr_25819[(21)] = inst_25750);

return statearr_25819;
})();
if(cljs.core.truth_(inst_25709)){
var statearr_25820_25884 = state_25787__$1;
(statearr_25820_25884[(1)] = (29));

} else {
var statearr_25821_25885 = state_25787__$1;
(statearr_25821_25885[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (25))){
var inst_25710 = (state_25787[(15)]);
var inst_25732 = (state_25787[(2)]);
var state_25787__$1 = (function (){var statearr_25822 = state_25787;
(statearr_25822[(22)] = inst_25732);

return statearr_25822;
})();
if(cljs.core.truth_(inst_25710)){
var statearr_25823_25886 = state_25787__$1;
(statearr_25823_25886[(1)] = (26));

} else {
var statearr_25824_25887 = state_25787__$1;
(statearr_25824_25887[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (34))){
var inst_25779 = (state_25787[(2)]);
var state_25787__$1 = (function (){var statearr_25825 = state_25787;
(statearr_25825[(23)] = inst_25779);

return statearr_25825;
})();
var statearr_25826_25888 = state_25787__$1;
(statearr_25826_25888[(2)] = null);

(statearr_25826_25888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (17))){
var inst_25706 = (state_25787[(16)]);
var inst_25716 = (state_25787[(17)]);
var inst_25715 = (state_25787[(8)]);
var inst_25718 = inst_25716.call(null,hatti.constants._rank,inst_25706);
var inst_25719 = inst_25715.call(null,inst_25718);
var state_25787__$1 = state_25787;
var statearr_25827_25889 = state_25787__$1;
(statearr_25827_25889[(2)] = inst_25719);

(statearr_25827_25889[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (3))){
var inst_25785 = (state_25787[(2)]);
var state_25787__$1 = state_25787;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25787__$1,inst_25785);
} else {
if((state_val_25788 === (12))){
var state_25787__$1 = state_25787;
var statearr_25828_25890 = state_25787__$1;
(statearr_25828_25890[(2)] = false);

(statearr_25828_25890[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (2))){
var state_25787__$1 = state_25787;
var statearr_25829_25891 = state_25787__$1;
(statearr_25829_25891[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (23))){
var inst_25715 = (state_25787[(8)]);
var inst_25729 = inst_25715.call(null,null);
var state_25787__$1 = state_25787;
var statearr_25831_25892 = state_25787__$1;
(statearr_25831_25892[(2)] = inst_25729);

(statearr_25831_25892[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (19))){
var inst_25707 = (state_25787[(9)]);
var inst_25722 = (state_25787[(2)]);
var state_25787__$1 = (function (){var statearr_25832 = state_25787;
(statearr_25832[(24)] = inst_25722);

return statearr_25832;
})();
if(cljs.core.truth_(inst_25707)){
var statearr_25833_25893 = state_25787__$1;
(statearr_25833_25893[(1)] = (20));

} else {
var statearr_25834_25894 = state_25787__$1;
(statearr_25834_25894[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (11))){
var state_25787__$1 = state_25787;
var statearr_25835_25895 = state_25787__$1;
(statearr_25835_25895[(2)] = true);

(statearr_25835_25895[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (9))){
var state_25787__$1 = state_25787;
var statearr_25836_25896 = state_25787__$1;
(statearr_25836_25896[(2)] = false);

(statearr_25836_25896[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (5))){
var state_25787__$1 = state_25787;
var statearr_25837_25897 = state_25787__$1;
(statearr_25837_25897[(2)] = null);

(statearr_25837_25897[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (14))){
var inst_25685 = (state_25787[(7)]);
var inst_25702 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25685);
var state_25787__$1 = state_25787;
var statearr_25838_25898 = state_25787__$1;
(statearr_25838_25898[(2)] = inst_25702);

(statearr_25838_25898[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (26))){
var inst_25705 = (state_25787[(12)]);
var inst_25711 = (state_25787[(10)]);
var inst_25709 = (state_25787[(13)]);
var inst_25708 = (state_25787[(14)]);
var inst_25710 = (state_25787[(15)]);
var inst_25706 = (state_25787[(16)]);
var inst_25716 = (state_25787[(17)]);
var inst_25715 = (state_25787[(8)]);
var inst_25707 = (state_25787[(9)]);
var inst_25745 = cljs.core.async.chan.call(null,(1));
var inst_25746 = (function (){var new_columns = inst_25710;
var submission_clicked = inst_25707;
var submission_unclicked = inst_25708;
var get_submission_data = inst_25716;
var c__12309__auto____$1 = inst_25745;
var re_render = inst_25711;
var update_data_BANG_ = inst_25715;
var submission_to_rank = inst_25706;
var filter_by = inst_25709;
var map__25683 = inst_25705;
return ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25745,state_val_25788,c__12309__auto__,event_chan){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25745,state_val_25788,c__12309__auto__,event_chan){
return (function (state_25743){
var state_val_25744 = (state_25743[(1)]);
if((state_val_25744 === (1))){
var inst_25734 = cljs.core.async.timeout.call(null,(20));
var state_25743__$1 = state_25743;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25743__$1,(2),inst_25734);
} else {
if((state_val_25744 === (2))){
var inst_25736 = (state_25743[(2)]);
var inst_25737 = grid.setColumns(new_columns);
var inst_25738 = hatti.views.table.resizeColumns.call(null,grid);
var inst_25739 = grid.render();
var inst_25740 = hatti.views.table.select_rows_marked_to_be_deleted.call(null);
var inst_25741 = hatti.views.table.higlight_rows_marked_to_be_deleted.call(null,grid);
var state_25743__$1 = (function (){var statearr_25839 = state_25743;
(statearr_25839[(7)] = inst_25736);

(statearr_25839[(8)] = inst_25740);

(statearr_25839[(9)] = inst_25737);

(statearr_25839[(10)] = inst_25738);

(statearr_25839[(11)] = inst_25739);

return statearr_25839;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25743__$1,inst_25741);
} else {
return null;
}
}
});})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25745,state_val_25788,c__12309__auto__,event_chan))
;
return ((function (switch__12197__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25745,state_val_25788,c__12309__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____0 = (function (){
var statearr_25843 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25843[(0)] = hatti$views$table$handle_table_events_$_state_machine__12198__auto__);

(statearr_25843[(1)] = (1));

return statearr_25843;
});
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____1 = (function (state_25743){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_25743);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e25844){if((e25844 instanceof Object)){
var ex__12201__auto__ = e25844;
var statearr_25845_25899 = state_25743;
(statearr_25845_25899[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25743);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25844;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25900 = state_25743;
state_25743 = G__25900;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = function(state_25743){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____1.call(this,state_25743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25745,state_val_25788,c__12309__auto__,event_chan))
})();
var state__12311__auto__ = (function (){var statearr_25846 = f__12310__auto__.call(null);
(statearr_25846[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto____$1);

return statearr_25846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});
;})(new_columns,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,map__25683,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25716,inst_25715,inst_25707,inst_25745,state_val_25788,c__12309__auto__,event_chan))
})();
var inst_25747 = cljs.core.async.impl.dispatch.run.call(null,inst_25746);
var state_25787__$1 = (function (){var statearr_25847 = state_25787;
(statearr_25847[(25)] = inst_25747);

return statearr_25847;
})();
var statearr_25848_25901 = state_25787__$1;
(statearr_25848_25901[(2)] = inst_25745);

(statearr_25848_25901[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (16))){
var inst_25705 = (state_25787[(12)]);
var inst_25711 = (state_25787[(10)]);
var inst_25709 = (state_25787[(13)]);
var inst_25708 = (state_25787[(14)]);
var inst_25710 = (state_25787[(15)]);
var inst_25706 = (state_25787[(16)]);
var inst_25715 = (state_25787[(8)]);
var inst_25707 = (state_25787[(9)]);
var inst_25705__$1 = (state_25787[(2)]);
var inst_25706__$1 = cljs.core.get.call(null,inst_25705__$1,new cljs.core.Keyword(null,"submission-to-rank","submission-to-rank",1214938797));
var inst_25707__$1 = cljs.core.get.call(null,inst_25705__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var inst_25708__$1 = cljs.core.get.call(null,inst_25705__$1,new cljs.core.Keyword(null,"submission-unclicked","submission-unclicked",-2099539520));
var inst_25709__$1 = cljs.core.get.call(null,inst_25705__$1,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
var inst_25710__$1 = cljs.core.get.call(null,inst_25705__$1,new cljs.core.Keyword(null,"new-columns","new-columns",-887765797));
var inst_25711__$1 = cljs.core.get.call(null,inst_25705__$1,new cljs.core.Keyword(null,"re-render","re-render",1133553258));
var inst_25712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25713 = [new cljs.core.Keyword(null,"table-page","table-page",1974969102),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"data","data",-232669377)];
var inst_25714 = (new cljs.core.PersistentVector(null,3,(5),inst_25712,inst_25713,null));
var inst_25715__$1 = cljs.core.partial.call(null,om.core.update_BANG_,app_state,inst_25714);
var inst_25716 = (function (){var map__25683 = inst_25705__$1;
var submission_to_rank = inst_25706__$1;
var submission_clicked = inst_25707__$1;
var submission_unclicked = inst_25708__$1;
var filter_by = inst_25709__$1;
var new_columns = inst_25710__$1;
var re_render = inst_25711__$1;
var update_data_BANG_ = inst_25715__$1;
return ((function (map__25683,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25715,inst_25707,inst_25705__$1,inst_25706__$1,inst_25707__$1,inst_25708__$1,inst_25709__$1,inst_25710__$1,inst_25711__$1,inst_25712,inst_25713,inst_25714,inst_25715__$1,state_val_25788,c__12309__auto__,event_chan){
return (function (field,value){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__25683,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25715,inst_25707,inst_25705__$1,inst_25706__$1,inst_25707__$1,inst_25708__$1,inst_25709__$1,inst_25710__$1,inst_25711__$1,inst_25712,inst_25713,inst_25714,inst_25715__$1,state_val_25788,c__12309__auto__,event_chan){
return (function (p1__25496_SHARP_){
return cljs.core._EQ_.call(null,value,cljs.core.get.call(null,p1__25496_SHARP_,field));
});})(map__25683,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25715,inst_25707,inst_25705__$1,inst_25706__$1,inst_25707__$1,inst_25708__$1,inst_25709__$1,inst_25710__$1,inst_25711__$1,inst_25712,inst_25713,inst_25714,inst_25715__$1,state_val_25788,c__12309__auto__,event_chan))
,cljs.core.get_in.call(null,cljs.core.deref.call(null,app_state),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null))));
});
;})(map__25683,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_25705,inst_25711,inst_25709,inst_25708,inst_25710,inst_25706,inst_25715,inst_25707,inst_25705__$1,inst_25706__$1,inst_25707__$1,inst_25708__$1,inst_25709__$1,inst_25710__$1,inst_25711__$1,inst_25712,inst_25713,inst_25714,inst_25715__$1,state_val_25788,c__12309__auto__,event_chan))
})();
var state_25787__$1 = (function (){var statearr_25849 = state_25787;
(statearr_25849[(12)] = inst_25705__$1);

(statearr_25849[(10)] = inst_25711__$1);

(statearr_25849[(13)] = inst_25709__$1);

(statearr_25849[(14)] = inst_25708__$1);

(statearr_25849[(15)] = inst_25710__$1);

(statearr_25849[(16)] = inst_25706__$1);

(statearr_25849[(17)] = inst_25716);

(statearr_25849[(8)] = inst_25715__$1);

(statearr_25849[(9)] = inst_25707__$1);

return statearr_25849;
})();
if(cljs.core.truth_(inst_25706__$1)){
var statearr_25850_25902 = state_25787__$1;
(statearr_25850_25902[(1)] = (17));

} else {
var statearr_25851_25903 = state_25787__$1;
(statearr_25851_25903[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (30))){
var state_25787__$1 = state_25787;
var statearr_25852_25904 = state_25787__$1;
(statearr_25852_25904[(2)] = null);

(statearr_25852_25904[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (10))){
var inst_25700 = (state_25787[(2)]);
var state_25787__$1 = state_25787;
if(cljs.core.truth_(inst_25700)){
var statearr_25853_25905 = state_25787__$1;
(statearr_25853_25905[(1)] = (14));

} else {
var statearr_25854_25906 = state_25787__$1;
(statearr_25854_25906[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (18))){
var state_25787__$1 = state_25787;
var statearr_25855_25907 = state_25787__$1;
(statearr_25855_25907[(2)] = null);

(statearr_25855_25907[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25788 === (8))){
var inst_25685 = (state_25787[(7)]);
var inst_25690 = inst_25685.cljs$lang$protocol_mask$partition0$;
var inst_25691 = (inst_25690 & (64));
var inst_25692 = inst_25685.cljs$core$ISeq$;
var inst_25693 = (inst_25691) || (inst_25692);
var state_25787__$1 = state_25787;
if(cljs.core.truth_(inst_25693)){
var statearr_25856_25908 = state_25787__$1;
(statearr_25856_25908[(1)] = (11));

} else {
var statearr_25857_25909 = state_25787__$1;
(statearr_25857_25909[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__,event_chan))
;
return ((function (switch__12197__auto__,c__12309__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____0 = (function (){
var statearr_25861 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25861[(0)] = hatti$views$table$handle_table_events_$_state_machine__12198__auto__);

(statearr_25861[(1)] = (1));

return statearr_25861;
});
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____1 = (function (state_25787){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_25787);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e25862){if((e25862 instanceof Object)){
var ex__12201__auto__ = e25862;
var statearr_25863_25910 = state_25787;
(statearr_25863_25910[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25787);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25862;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25911 = state_25787;
state_25787 = G__25911;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = function(state_25787){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____1.call(this,state_25787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,event_chan))
})();
var state__12311__auto__ = (function (){var statearr_25864 = f__12310__auto__.call(null);
(statearr_25864[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_25864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto__,event_chan))
);

return c__12309__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"field-key","field-key",313262601),k);

return colset_BANG_.call(null,k);
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__25928(s__25929){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__25929__$1 = s__25929;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__25929__$1);
if(temp__4657__auto__){
var s__25929__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__25929__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__25929__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__25931 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__25930 = (0);
while(true){
if((i__25930 < size__7188__auto__)){
var vec__25938 = cljs.core._nth.call(null,c__7187__auto__,i__25930);
var k = cljs.core.nth.call(null,vec__25938,(0),null);
var v = cljs.core.nth.call(null,vec__25938,(1),null);
cljs.core.chunk_append.call(null,b__25931,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (i__25930,vec__25938,k,v,c__7187__auto__,size__7188__auto__,b__25931,s__25929__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(i__25930,vec__25938,k,v,c__7187__auto__,size__7188__auto__,b__25931,s__25929__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null));

var G__25944 = (i__25930 + (1));
i__25930 = G__25944;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25931),hatti$views$table$render_options_$_iter__25928.call(null,cljs.core.chunk_rest.call(null,s__25929__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__25931),null);
}
} else {
var vec__25941 = cljs.core.first.call(null,s__25929__$2);
var k = cljs.core.nth.call(null,vec__25941,(0),null);
var v = cljs.core.nth.call(null,vec__25941,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),hatti.utils.click_fn.call(null,((function (vec__25941,k,v,s__25929__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key.call(null,k);
});})(vec__25941,k,v,s__25929__$2,temp__4657__auto__,choose_display_key))
),new cljs.core.Keyword(null,"href","href",-793805698),"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__25928.call(null,cljs.core.rest.call(null,s__25929__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__.call(null,options);
});
cljs.core._add_method.call(null,hatti.views.label_changer,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table25946 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table25946 = (function (_,owner,meta25947){
this._ = _;
this.owner = owner;
this.meta25947 = meta25947;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table25946.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25948,meta25947__$1){
var self__ = this;
var _25948__$1 = this;
return (new hatti.views.table.t_hatti$views$table25946(self__._,self__.owner,meta25947__$1));
});

hatti.views.table.t_hatti$views$table25946.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25948){
var self__ = this;
var _25948__$1 = this;
return self__.meta25947;
});

hatti.views.table.t_hatti$views$table25946.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table25946.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"field-key","field-key",313262601),new cljs.core.Keyword(null,"label","label",1718410804)], null);
});

hatti.views.table.t_hatti$views$table25946.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table25946.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__25949){
var self__ = this;
var map__25950 = p__25949;
var map__25950__$1 = ((((!((map__25950 == null)))?((((map__25950.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25950.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25950):map__25950);
var field_key = cljs.core.get.call(null,map__25950__$1,new cljs.core.Keyword(null,"field-key","field-key",313262601));
var language = cljs.core.get.call(null,map__25950__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Label"], null),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Name"], null)], null);
var map__25952 = om.core.get_shared.call(null,self__.owner);
var map__25952__$1 = ((((!((map__25952 == null)))?((((map__25952.cljs$lang$protocol_mask$partition0$ & (64))) || (map__25952.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25952):map__25952);
var flat_form = cljs.core.get.call(null,map__25952__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var new_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,self__.owner,hatti.shared.language_cursor.call(null)));
var colset_BANG_ = ((function (options,map__25952,map__25952__$1,flat_form,new_language,___$2,map__25950,map__25950__$1,field_key,language){
return (function (p1__25945_SHARP_){
return cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-columns","new-columns",-887765797),hatti.views.table.flat_form__GT_sg_columns.call(null,flat_form,new cljs.core.Keyword(null,"get-label?","get-label?",617123530),cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"label","label",1718410804),p1__25945_SHARP_),new cljs.core.Keyword(null,"language","language",-1591107564),new_language)], null));
});})(options,map__25952,map__25952__$1,flat_form,new_language,___$2,map__25950,map__25950__$1,field_key,language))
;
if(cljs.core.not_EQ_.call(null,new_language,language)){
om.core.set_state_BANG_.call(null,self__.owner,new cljs.core.Keyword(null,"language","language",-1591107564),new_language);

colset_BANG_.call(null,field_key);
} else {
}

return React.DOM.div(({"className": "label-changer"}),React.DOM.span(({"className": "label-changer-label"}),"Show:"),React.DOM.div(({"id": "header-display-dropdown", "className": "drop-hover"}),(function (){var attrs25956 = options.call(null,field_key);
return cljs.core.apply.call(null,React.DOM.span,((cljs.core.map_QMARK_.call(null,attrs25956))?sablono.interpreter.attributes.call(null,attrs25956):null),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25956))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [React.DOM.i(({"className": "fa fa-angle-down"}))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25956),React.DOM.i(({"className": "fa fa-angle-down"}))], null))));
})(),(function (){var attrs25961 = hatti.views.table.render_options.call(null,options,self__.owner,colset_BANG_);
return cljs.core.apply.call(null,React.DOM.ul,((cljs.core.map_QMARK_.call(null,attrs25961))?sablono.interpreter.attributes.call(null,sablono.util.merge_with_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs25961)):({"className": "submenu no-dot"})),cljs.core.remove.call(null,cljs.core.nil_QMARK_,((cljs.core.map_QMARK_.call(null,attrs25961))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret.call(null,attrs25961)], null))));
})()));
});

hatti.views.table.t_hatti$views$table25946.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta25947","meta25947",986396064,null)], null);
});

hatti.views.table.t_hatti$views$table25946.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table25946.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table25946";

hatti.views.table.t_hatti$views$table25946.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table25946");
});

hatti.views.table.__GT_t_hatti$views$table25946 = (function hatti$views$table$__GT_t_hatti$views$table25946(___$1,owner__$1,meta25947){
return (new hatti.views.table.t_hatti$views$table25946(___$1,owner__$1,meta25947));
});

}

return (new hatti.views.table.t_hatti$views$table25946(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto__,query){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,query){
return (function (state_26004){
var state_val_26005 = (state_26004[(1)]);
if((state_val_26005 === (1))){
var inst_25990 = cljs.core.async.timeout.call(null,(150));
var state_26004__$1 = state_26004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26004__$1,(2),inst_25990);
} else {
if((state_val_26005 === (2))){
var inst_25992 = (state_26004[(2)]);
var inst_25993 = input.value;
var inst_25994 = cljs.core._EQ_.call(null,query,inst_25993);
var state_26004__$1 = (function (){var statearr_26006 = state_26004;
(statearr_26006[(7)] = inst_25992);

return statearr_26006;
})();
if(inst_25994){
var statearr_26007_26018 = state_26004__$1;
(statearr_26007_26018[(1)] = (3));

} else {
var statearr_26008_26019 = state_26004__$1;
(statearr_26008_26019[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26005 === (3))){
var inst_25996 = [query_event_key];
var inst_25997 = [query];
var inst_25998 = cljs.core.PersistentHashMap.fromArrays(inst_25996,inst_25997);
var inst_25999 = cljs.core.async.put_BANG_.call(null,hatti.shared.event_chan,inst_25998);
var state_26004__$1 = state_26004;
var statearr_26009_26020 = state_26004__$1;
(statearr_26009_26020[(2)] = inst_25999);

(statearr_26009_26020[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26005 === (4))){
var state_26004__$1 = state_26004;
var statearr_26010_26021 = state_26004__$1;
(statearr_26010_26021[(2)] = null);

(statearr_26010_26021[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26005 === (5))){
var inst_26002 = (state_26004[(2)]);
var state_26004__$1 = state_26004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26004__$1,inst_26002);
} else {
return null;
}
}
}
}
}
});})(c__12309__auto__,query))
;
return ((function (switch__12197__auto__,c__12309__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12198__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12198__auto____0 = (function (){
var statearr_26014 = [null,null,null,null,null,null,null,null];
(statearr_26014[(0)] = hatti$views$table$delayed_search_$_state_machine__12198__auto__);

(statearr_26014[(1)] = (1));

return statearr_26014;
});
var hatti$views$table$delayed_search_$_state_machine__12198__auto____1 = (function (state_26004){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_26004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e26015){if((e26015 instanceof Object)){
var ex__12201__auto__ = e26015;
var statearr_26016_26022 = state_26004;
(statearr_26016_26022[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26004);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26015;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26023 = state_26004;
state_26004 = G__26023;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12198__auto__ = function(state_26004){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12198__auto____1.call(this,state_26004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12198__auto____0;
hatti$views$table$delayed_search_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12198__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,query))
})();
var state__12311__auto__ = (function (){var statearr_26017 = f__12310__auto__.call(null);
(statearr_26017[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_26017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto__,query))
);

return c__12309__auto__;
});
cljs.core._add_method.call(null,hatti.views.table_search,new cljs.core.Keyword(null,"default","default",-1987822328),(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table26025 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26025 = (function (_,owner,meta26026){
this._ = _;
this.owner = owner;
this.meta26026 = meta26026;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26025.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26027,meta26026__$1){
var self__ = this;
var _26027__$1 = this;
return (new hatti.views.table.t_hatti$views$table26025(self__._,self__.owner,meta26026__$1));
});

hatti.views.table.t_hatti$views$table26025.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26027){
var self__ = this;
var _26027__$1 = this;
return self__.meta26026;
});

hatti.views.table.t_hatti$views$table26025.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26025.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
return React.DOM.div(({"className": "table-search"}),React.DOM.i(({"className": "fa fa-search"})),sablono.interpreter.input.call(null,({"type": "text", "placeholder": "Search", "onChange": ((function (this__18254__auto____$1){
return (function (p1__26024_SHARP_){
return hatti.views.table.delayed_search.call(null,p1__26024_SHARP_.target,new cljs.core.Keyword(null,"filter-by","filter-by",-1855851983));
});})(this__18254__auto____$1))
})));
});

hatti.views.table.t_hatti$views$table26025.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26026","meta26026",-2086377241,null)], null);
});

hatti.views.table.t_hatti$views$table26025.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26025.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26025";

hatti.views.table.t_hatti$views$table26025.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26025");
});

hatti.views.table.__GT_t_hatti$views$table26025 = (function hatti$views$table$__GT_t_hatti$views$table26025(___$1,owner__$1,meta26026){
return (new hatti.views.table.t_hatti$views$table26025(___$1,owner__$1,meta26026));
});

}

return (new hatti.views.table.t_hatti$views$table26025(_,owner,null));
}));
cljs.core._add_method.call(null,hatti.views.table_header,new cljs.core.Keyword(null,"default","default",-1987822328),(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table26030 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26030 = (function (cursor,owner,meta26031){
this.cursor = cursor;
this.owner = owner;
this.meta26031 = meta26031;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26030.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26032,meta26031__$1){
var self__ = this;
var _26032__$1 = this;
return (new hatti.views.table.t_hatti$views$table26030(self__.cursor,self__.owner,meta26031__$1));
});

hatti.views.table.t_hatti$views$table26030.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26032){
var self__ = this;
var _26032__$1 = this;
return self__.meta26031;
});

hatti.views.table.t_hatti$views$table26030.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table26030.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
return React.DOM.div(({"className": "topbar"}),React.DOM.div(({"id": hatti.views.table.pager_id})),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.label_changer,self__.cursor)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_search,self__.cursor)),React.DOM.div(({"style": ({"clear": "both"})})));
});

hatti.views.table.t_hatti$views$table26030.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"meta26031","meta26031",-741311444,null)], null);
});

hatti.views.table.t_hatti$views$table26030.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26030.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26030";

hatti.views.table.t_hatti$views$table26030.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26030");
});

hatti.views.table.__GT_t_hatti$views$table26030 = (function hatti$views$table$__GT_t_hatti$views$table26030(cursor__$1,owner__$1,meta26031){
return (new hatti.views.table.t_hatti$views$table26030(cursor__$1,owner__$1,meta26031));
});

}

return (new hatti.views.table.t_hatti$views$table26030(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq.call(null,data)){
var map__26040 = om.core.get_shared.call(null,owner);
var map__26040__$1 = ((((!((map__26040 == null)))?((((map__26040.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26040.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26040):map__26040);
var flat_form = cljs.core.get.call(null,map__26040__$1,new cljs.core.Keyword(null,"flat-form","flat-form",-468858211));
var current_language = new cljs.core.Keyword(null,"current","current",-1088038603).cljs$core$IFn$_invoke$arity$1(om.core.observe.call(null,owner,hatti.shared.language_cursor.call(null)));
var vec__26041 = hatti.views.table.sg_init.call(null,data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.call(null,vec__26041,(0),null);
var dataview = cljs.core.nth.call(null,vec__26041,(1),null);
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"grid","grid",402978600),grid);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"dataview","dataview",91765671),dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901),hatti.views.table.get_table_view_height.call(null));
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881),resize_handler);
});
cljs.core._add_method.call(null,hatti.views.table_page,new cljs.core.Keyword(null,"default","default",-1987822328),(function (p__26046,owner,p__26047){
var map__26048 = p__26046;
var map__26048__$1 = ((((!((map__26048 == null)))?((((map__26048.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26048.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26048):map__26048);
var cursor = map__26048__$1;
var map__26049 = cljs.core.get.call(null,map__26048__$1,new cljs.core.Keyword(null,"views","views",1450155487));
var map__26049__$1 = ((((!((map__26049 == null)))?((((map__26049.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26049.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26049):map__26049);
var active = cljs.core.get.call(null,map__26049__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var map__26050 = p__26047;
var map__26050__$1 = ((((!((map__26050 == null)))?((((map__26050.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26050.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26050):map__26050);
var opts = map__26050__$1;
var slick_grid_event_handlers = cljs.core.get.call(null,map__26050__$1,new cljs.core.Keyword(null,"slick-grid-event-handlers","slick-grid-event-handlers",1990034724));

var active_QMARK_ = chimera.seq.in_QMARK_.call(null,active,new cljs.core.Keyword(null,"table","table",-564943036));
if(typeof hatti.views.table.t_hatti$views$table26054 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table26054 = (function (p__26047,map__26049,owner,map__26050,p__26046,active_QMARK_,slick_grid_event_handlers,cursor,map__26048,active,opts,meta26055){
this.p__26047 = p__26047;
this.map__26049 = map__26049;
this.owner = owner;
this.map__26050 = map__26050;
this.p__26046 = p__26046;
this.active_QMARK_ = active_QMARK_;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.cursor = cursor;
this.map__26048 = map__26048;
this.active = active;
this.opts = opts;
this.meta26055 = meta26055;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table26054.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers){
return (function (_26056,meta26055__$1){
var self__ = this;
var _26056__$1 = this;
return (new hatti.views.table.t_hatti$views$table26054(self__.p__26047,self__.map__26049,self__.owner,self__.map__26050,self__.p__26046,self__.active_QMARK_,self__.slick_grid_event_handlers,self__.cursor,self__.map__26048,self__.active,self__.opts,meta26055__$1));
});})(active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26054.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers){
return (function (_26056){
var self__ = this;
var _26056__$1 = this;
return self__.meta26055;
});})(active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers){
return (function (_,p__26057){
var self__ = this;
var map__26058 = p__26057;
var map__26058__$1 = ((((!((map__26058 == null)))?((((map__26058.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26058.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26058):map__26058);
var table_view_height = cljs.core.get.call(null,map__26058__$1,new cljs.core.Keyword(null,"table-view-height","table-view-height",-951800901));
var ___$1 = this;
var map__26060 = self__.cursor;
var map__26060__$1 = ((((!((map__26060 == null)))?((((map__26060.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26060.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26060):map__26060);
var map__26061 = cljs.core.get.call(null,map__26060__$1,new cljs.core.Keyword(null,"table-page","table-page",1974969102));
var map__26061__$1 = ((((!((map__26061 == null)))?((((map__26061.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26061.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26061):map__26061);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.call(null,map__26061__$1,new cljs.core.Keyword(null,"prevent-scrolling-in-table-view?","prevent-scrolling-in-table-view?",2053296532));
var submission_clicked = cljs.core.get.call(null,map__26061__$1,new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855));
var data = cljs.core.get.call(null,map__26060__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var dataset_info = cljs.core.get.call(null,map__26060__$1,new cljs.core.Keyword(null,"dataset-info","dataset-info",-1196999563));
var map__26062 = dataset_info;
var map__26062__$1 = ((((!((map__26062 == null)))?((((map__26062.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26062.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26062):map__26062);
var num_of_submissions = cljs.core.get.call(null,map__26062__$1,new cljs.core.Keyword(null,"num_of_submissions","num_of_submissions",-1720943091));
var no_data_QMARK_ = cljs.core.empty_QMARK_.call(null,data);
var with_info = ((function (map__26060,map__26060__$1,map__26061,map__26061__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__26062,map__26062__$1,num_of_submissions,no_data_QMARK_,___$1,map__26058,map__26058__$1,table_view_height,active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers){
return (function (p1__26045_SHARP_){
return cljs.core.merge.call(null,self__.cursor,p1__26045_SHARP_);
});})(map__26060,map__26060__$1,map__26061,map__26061__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__26062,map__26062__$1,num_of_submissions,no_data_QMARK_,___$1,map__26058,map__26058__$1,table_view_height,active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
return React.DOM.div(({"style": cljs.core.clj__GT_js.call(null,(cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"height","height",1025178622),(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height.call(null);
}
})(),new cljs.core.Keyword(null,"overflow","overflow",2058931880),"hidden"], null):null)), "className": "table-view"}),sablono.interpreter.interpret.call(null,(cljs.core.truth_(new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.call(null,hatti.views.submission_view,with_info.call(null,submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge.call(null,cljs.core.select_keys.call(null,self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"role","role",-736691072),null,new cljs.core.Keyword(null,"delete-record!","delete-record!",1411848194),null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"view","view",1247994814),new cljs.core.Keyword(null,"table","table",-564943036)], null))], null)):null)),sablono.interpreter.interpret.call(null,om.core.build.call(null,hatti.views.table_header,self__.cursor)),React.DOM.div(({"id": hatti.views.table.table_id, "className": "slickgrid"}),(((no_data_QMARK_) && ((num_of_submissions === (0))))?React.DOM.p(({"className": "alert alert-warning"}),"No data"):React.DOM.span(null,React.DOM.i(({"className": "fa fa-spinner fa-pulse"})),"Loading..."))));
} else {
return null;
}
});})(active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler.call(null,self__.owner);

var data = cljs.core.get_in.call(null,self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26070 = temp__4657__auto__;
var grid = cljs.core.nth.call(null,vec__26070,(0),null);
var dataview = cljs.core.nth.call(null,vec__26070,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.call(null,self__.owner,new cljs.core.Keyword(null,"resize-handler","resize-handler",-169459881)));
});})(active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table26054.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.call(null,om.core.get_props.call(null,self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var new_data = cljs.core.get_in.call(null,next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data","data",-232669377)], null));
var map__26073 = om.core.get_state.call(null,self__.owner);
var map__26073__$1 = ((((!((map__26073 == null)))?((((map__26073.cljs$lang$protocol_mask$partition0$ & (64))) || (map__26073.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26073):map__26073);
var grid = cljs.core.get.call(null,map__26073__$1,new cljs.core.Keyword(null,"grid","grid",402978600));
var dataview = cljs.core.get.call(null,map__26073__$1,new cljs.core.Keyword(null,"dataview","dataview",91765671));
if(cljs.core.not_EQ_.call(null,old_data,new_data)){
if(cljs.core.empty_QMARK_.call(null,old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_.call(null,new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26075 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.call(null,vec__26075,(0),null);
var dataview__$1 = cljs.core.nth.call(null,vec__26075,(1),null);
return hatti.views.table.handle_table_events.call(null,self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js.call(null,new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26054.getBasis = ((function (active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__26047","p__26047",-1115495774,null),new cljs.core.Symbol(null,"map__26049","map__26049",-1427071997,null),new cljs.core.Symbol(null,"owner","owner",1247919588,null),new cljs.core.Symbol(null,"map__26050","map__26050",-1780007163,null),new cljs.core.Symbol(null,"p__26046","p__26046",-1031059802,null),new cljs.core.Symbol(null,"active?","active?",2100031303,null),new cljs.core.Symbol(null,"slick-grid-event-handlers","slick-grid-event-handlers",-664401045,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"map__26048","map__26048",-339096583,null),new cljs.core.Symbol(null,"active","active",-758473701,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"meta26055","meta26055",-562425111,null)], null);
});})(active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table26054.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table26054.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table26054";

hatti.views.table.t_hatti$views$table26054.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write.call(null,writer__7016__auto__,"hatti.views.table/t_hatti$views$table26054");
});})(active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table26054 = ((function (active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table26054(p__26047__$1,map__26049__$2,owner__$1,map__26050__$2,p__26046__$1,active_QMARK___$1,slick_grid_event_handlers__$1,cursor__$1,map__26048__$2,active__$1,opts__$1,meta26055){
return (new hatti.views.table.t_hatti$views$table26054(p__26047__$1,map__26049__$2,owner__$1,map__26050__$2,p__26046__$1,active_QMARK___$1,slick_grid_event_handlers__$1,cursor__$1,map__26048__$2,active__$1,opts__$1,meta26055));
});})(active_QMARK_,map__26048,map__26048__$1,cursor,map__26049,map__26049__$1,active,map__26050,map__26050__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table26054(p__26047,map__26049__$1,owner,map__26050__$1,p__26046,active_QMARK_,slick_grid_event_handlers,cursor,map__26048__$1,active,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
