// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.ona.stream');
goog.require('cljs.core');
goog.require('cljs.core.async');
hatti.ona.stream.small_delay = (10);
/**
 * Calls callback on aggregated data that come via messages in channel.
 * Callback accepts two arguments: data (cljs list), and completed? (bool)
 *   If there is a parser in message, resume it after a timeout.
 */
hatti.ona.stream.process_aggregated_data_BANG_ = (function hatti$ona$stream$process_aggregated_data_BANG_(agg_data_channel,callback){
var c__12309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__12309__auto__){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__){
return (function (state_22336){
var state_val_22337 = (state_22336[(1)]);
if((state_val_22337 === (7))){
var inst_22293 = (state_22336[(7)]);
var inst_22293__$1 = (state_22336[(2)]);
var inst_22295 = (inst_22293__$1 == null);
var inst_22296 = cljs.core.not.call(null,inst_22295);
var state_22336__$1 = (function (){var statearr_22338 = state_22336;
(statearr_22338[(7)] = inst_22293__$1);

return statearr_22338;
})();
if(inst_22296){
var statearr_22339_22376 = state_22336__$1;
(statearr_22339_22376[(1)] = (8));

} else {
var statearr_22340_22377 = state_22336__$1;
(statearr_22340_22377[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (20))){
var inst_22315 = (state_22336[(8)]);
var inst_22323 = (state_22336[(2)]);
var state_22336__$1 = (function (){var statearr_22341 = state_22336;
(statearr_22341[(9)] = inst_22323);

return statearr_22341;
})();
if(cljs.core.truth_(inst_22315)){
var statearr_22342_22378 = state_22336__$1;
(statearr_22342_22378[(1)] = (21));

} else {
var statearr_22343_22379 = state_22336__$1;
(statearr_22343_22379[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (1))){
var state_22336__$1 = state_22336;
var statearr_22344_22380 = state_22336__$1;
(statearr_22344_22380[(2)] = null);

(statearr_22344_22380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (4))){
var state_22336__$1 = state_22336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22336__$1,(7),agg_data_channel);
} else {
if((state_val_22337 === (15))){
var inst_22293 = (state_22336[(7)]);
var state_22336__$1 = state_22336;
var statearr_22345_22381 = state_22336__$1;
(statearr_22345_22381[(2)] = inst_22293);

(statearr_22345_22381[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (21))){
var inst_22325 = cljs.core.async.close_BANG_.call(null,agg_data_channel);
var state_22336__$1 = state_22336;
var statearr_22346_22382 = state_22336__$1;
(statearr_22346_22382[(2)] = inst_22325);

(statearr_22346_22382[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (13))){
var inst_22305 = (state_22336[(2)]);
var state_22336__$1 = state_22336;
var statearr_22347_22383 = state_22336__$1;
(statearr_22347_22383[(2)] = inst_22305);

(statearr_22347_22383[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (22))){
var state_22336__$1 = state_22336;
var statearr_22348_22384 = state_22336__$1;
(statearr_22348_22384[(2)] = null);

(statearr_22348_22384[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (6))){
var inst_22332 = (state_22336[(2)]);
var state_22336__$1 = state_22336;
var statearr_22349_22385 = state_22336__$1;
(statearr_22349_22385[(2)] = inst_22332);

(statearr_22349_22385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (17))){
var inst_22314 = (state_22336[(10)]);
var inst_22315 = (state_22336[(8)]);
var inst_22317 = callback.call(null,inst_22314,inst_22315);
var state_22336__$1 = state_22336;
var statearr_22350_22386 = state_22336__$1;
(statearr_22350_22386[(2)] = inst_22317);

(statearr_22350_22386[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (3))){
var inst_22334 = (state_22336[(2)]);
var state_22336__$1 = state_22336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22336__$1,inst_22334);
} else {
if((state_val_22337 === (12))){
var state_22336__$1 = state_22336;
var statearr_22351_22387 = state_22336__$1;
(statearr_22351_22387[(2)] = false);

(statearr_22351_22387[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (2))){
var state_22336__$1 = state_22336;
var statearr_22352_22388 = state_22336__$1;
(statearr_22352_22388[(1)] = (4));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (23))){
var inst_22328 = (state_22336[(2)]);
var state_22336__$1 = (function (){var statearr_22354 = state_22336;
(statearr_22354[(11)] = inst_22328);

return statearr_22354;
})();
var statearr_22355_22389 = state_22336__$1;
(statearr_22355_22389[(2)] = null);

(statearr_22355_22389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (19))){
var inst_22320 = (state_22336[(2)]);
var inst_22321 = cljs.core.async.timeout.call(null,hatti.ona.stream.small_delay);
var state_22336__$1 = (function (){var statearr_22356 = state_22336;
(statearr_22356[(12)] = inst_22320);

return statearr_22356;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22336__$1,(20),inst_22321);
} else {
if((state_val_22337 === (11))){
var state_22336__$1 = state_22336;
var statearr_22357_22390 = state_22336__$1;
(statearr_22357_22390[(2)] = true);

(statearr_22357_22390[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (9))){
var state_22336__$1 = state_22336;
var statearr_22358_22391 = state_22336__$1;
(statearr_22358_22391[(2)] = false);

(statearr_22358_22391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (5))){
var state_22336__$1 = state_22336;
var statearr_22359_22392 = state_22336__$1;
(statearr_22359_22392[(2)] = null);

(statearr_22359_22392[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (14))){
var inst_22293 = (state_22336[(7)]);
var inst_22310 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22293);
var state_22336__$1 = state_22336;
var statearr_22360_22393 = state_22336__$1;
(statearr_22360_22393[(2)] = inst_22310);

(statearr_22360_22393[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (16))){
var inst_22314 = (state_22336[(10)]);
var inst_22313 = (state_22336[(2)]);
var inst_22314__$1 = cljs.core.get.call(null,inst_22313,new cljs.core.Keyword(null,"data","data",-232669377));
var inst_22315 = cljs.core.get.call(null,inst_22313,new cljs.core.Keyword(null,"completed?","completed?",946828354));
var state_22336__$1 = (function (){var statearr_22361 = state_22336;
(statearr_22361[(10)] = inst_22314__$1);

(statearr_22361[(8)] = inst_22315);

return statearr_22361;
})();
if(cljs.core.truth_(inst_22314__$1)){
var statearr_22362_22394 = state_22336__$1;
(statearr_22362_22394[(1)] = (17));

} else {
var statearr_22363_22395 = state_22336__$1;
(statearr_22363_22395[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (10))){
var inst_22308 = (state_22336[(2)]);
var state_22336__$1 = state_22336;
if(cljs.core.truth_(inst_22308)){
var statearr_22364_22396 = state_22336__$1;
(statearr_22364_22396[(1)] = (14));

} else {
var statearr_22365_22397 = state_22336__$1;
(statearr_22365_22397[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (18))){
var state_22336__$1 = state_22336;
var statearr_22366_22398 = state_22336__$1;
(statearr_22366_22398[(2)] = null);

(statearr_22366_22398[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22337 === (8))){
var inst_22293 = (state_22336[(7)]);
var inst_22298 = inst_22293.cljs$lang$protocol_mask$partition0$;
var inst_22299 = (inst_22298 & (64));
var inst_22300 = inst_22293.cljs$core$ISeq$;
var inst_22301 = (inst_22299) || (inst_22300);
var state_22336__$1 = state_22336;
if(cljs.core.truth_(inst_22301)){
var statearr_22367_22399 = state_22336__$1;
(statearr_22367_22399[(1)] = (11));

} else {
var statearr_22368_22400 = state_22336__$1;
(statearr_22368_22400[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__))
;
return ((function (switch__12197__auto__,c__12309__auto__){
return (function() {
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__ = null;
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____0 = (function (){
var statearr_22372 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22372[(0)] = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__);

(statearr_22372[(1)] = (1));

return statearr_22372;
});
var hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____1 = (function (state_22336){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__.call(null,state_22336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__12200__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e22373){if((e22373 instanceof Object)){
var ex__12201__auto__ = e22373;
var statearr_22374_22401 = state_22336;
(statearr_22374_22401[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22336);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22373;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__12199__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22402 = state_22336;
state_22336 = G__22402;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__ = function(state_22336){
switch(arguments.length){
case 0:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____1.call(this,state_22336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____0;
hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto____1;
return hatti$ona$stream$process_aggregated_data_BANG__$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__))
})();
var state__12311__auto__ = (function (){var statearr_22375 = f__12310__auto__.call(null);
(statearr_22375[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_22375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__12311__auto__);
});})(c__12309__auto__))
);

return c__12309__auto__;
});
/**
 * On each step of data, increment read-count atom, and put data in a list agg.
 * After a exponentially increasing # of steps have been processed,
 * the aggregated data gets flushed into a channel, and parser is paused.
 * The channel reader should resume the parser after processing the data.
 */
hatti.ona.stream.read_next_chunk_BANG_ = (function hatti$ona$stream$read_next_chunk_BANG_(data_chunk,read_count,agg,channel){
cljs.core.swap_BANG_.call(null,read_count,cljs.core.inc);

cljs.core.swap_BANG_.call(null,agg,cljs.core.conj,data_chunk);

if(((cljs.core.deref.call(null,read_count) >= (100))) && (cljs.core.integer_QMARK_.call(null,Math.log10(cljs.core.deref.call(null,read_count))))){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg)], null));

cljs.core.reset_BANG_.call(null,agg,cljs.core.PersistentVector.EMPTY);

return oboe.drop();
} else {
return null;
}
});
/**
 * Given url, a node pattern matcher, and a callback, streaming-read json.
 */
hatti.ona.stream.streamingly_read_json_BANG_ = (function hatti$ona$stream$streamingly_read_json_BANG_(var_args){
var args__7491__auto__ = [];
var len__7484__auto___22409 = arguments.length;
var i__7485__auto___22410 = (0);
while(true){
if((i__7485__auto___22410 < len__7484__auto___22409)){
args__7491__auto__.push((arguments[i__7485__auto___22410]));

var G__22411 = (i__7485__auto___22410 + (1));
i__7485__auto___22410 = G__22411;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (url,stepfn,p__22406){
var map__22407 = p__22406;
var map__22407__$1 = ((((!((map__22407 == null)))?((((map__22407.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22407.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22407):map__22407);
var oboe_headers = cljs.core.get.call(null,map__22407__$1,new cljs.core.Keyword(null,"oboe-headers","oboe-headers",-764778163));
var read_count = cljs.core.atom.call(null,(0));
var agg = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var channel = cljs.core.async.chan.call(null);
var return_channel = cljs.core.async.chan.call(null);
var oboe_params = cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"headers","headers",-835030129),oboe_headers,new cljs.core.Keyword(null,"withCredentials","withCredentials",1719959454),true], null));
var step = ((function (read_count,agg,channel,return_channel,oboe_params,map__22407,map__22407__$1,oboe_headers){
return (function (line){
return hatti.ona.stream.read_next_chunk_BANG_.call(null,cljs.core.js__GT_clj.call(null,line),read_count,agg,channel);
});})(read_count,agg,channel,return_channel,oboe_params,map__22407,map__22407__$1,oboe_headers))
;
var done = ((function (read_count,agg,channel,return_channel,oboe_params,step,map__22407,map__22407__$1,oboe_headers){
return (function (){
cljs.core.async.put_BANG_.call(null,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.deref.call(null,agg),new cljs.core.Keyword(null,"completed?","completed?",946828354),true], null));

return cljs.core.async.close_BANG_.call(null,return_channel);
});})(read_count,agg,channel,return_channel,oboe_params,step,map__22407,map__22407__$1,oboe_headers))
;
hatti.ona.stream.process_aggregated_data_BANG_.call(null,channel,stepfn);

window.oboe(oboe_params).node("!.*",step).done(done);

return return_channel;
});

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$maxFixedArity = (2);

hatti.ona.stream.streamingly_read_json_BANG_.cljs$lang$applyTo = (function (seq22403){
var G__22404 = cljs.core.first.call(null,seq22403);
var seq22403__$1 = cljs.core.next.call(null,seq22403);
var G__22405 = cljs.core.first.call(null,seq22403__$1);
var seq22403__$2 = cljs.core.next.call(null,seq22403__$1);
return hatti.ona.stream.streamingly_read_json_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22404,G__22405,seq22403__$2);
});

