// Compiled by ClojureScript 1.9.229 {}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('hatti.constants');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.ona.forms');
goog.require('clojure.string');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('cljs.reader');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"point","point",1813198264),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),({"radius": (6), "fillColor": "#f30", "reset": ({"fillColor": "#f30"}), "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9}),new cljs.core.Keyword(null,"hover","hover",-341141711),({"fillColor": "#631400"}),new cljs.core.Keyword(null,"clicked","clicked",114423720),({"fillColor": "#ad2300"})], null),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),({"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8}),new cljs.core.Keyword(null,"hover","hover",-341141711),({"fillColor": "#631400", "color": "#222"}),new cljs.core.Keyword(null,"clicked","clicked",114423720),({"fillColor": "#ad2300", "color": "#222"})], null),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),({"color": "#f30", "opacity": (1), "weight": (6), "reset": ({"color": "#f30"})}),new cljs.core.Keyword(null,"hover","hover",-341141711),({"color": "#631400"}),new cljs.core.Keyword(null,"clicked","clicked",114423720),({"color": "#ad2300"})], null)], null);
hatti.map.utils.circle_border_id = "point-casting";
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20157 = arguments.length;
var i__7485__auto___20158 = (0);
while(true){
if((i__7485__auto___20158 < len__7484__auto___20157)){
args__7491__auto__.push((arguments[i__7485__auto___20158]));

var G__20159 = (i__7485__auto___20158 + (1));
i__7485__auto___20158 = G__20159;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic = (function (marker_or_keyword,style_type,p__20154){
var map__20155 = p__20154;
var map__20155__$1 = ((((!((map__20155 == null)))?((((map__20155.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20155.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20155):map__20155);
var custom_styles = cljs.core.get.call(null,map__20155__$1,new cljs.core.Keyword(null,"custom-styles","custom-styles",-1687569839),hatti.map.utils.ona_styles);
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype.call(null,marker_or_keyword));
return style_type.call(null,kw.call(null,custom_styles));
});

hatti.map.utils.get_ona_style.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_ona_style.cljs$lang$applyTo = (function (seq20151){
var G__20152 = cljs.core.first.call(null,seq20151);
var seq20151__$1 = cljs.core.next.call(null,seq20151);
var G__20153 = cljs.core.first.call(null,seq20151__$1);
var seq20151__$2 = cljs.core.next.call(null,seq20151__$1);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic(G__20152,G__20153,seq20151__$2);
});

hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.call(null,s);
var tc = cljs.core.js__GT_clj.call(null,t);
return cljs.core._EQ_.call(null,cljs.core.select_keys.call(null,sc,cljs.core.keys.call(null,tc)),cljs.core.select_keys.call(null,tc,cljs.core.keys.call(null,sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args20160 = [];
var len__7484__auto___20163 = arguments.length;
var i__7485__auto___20164 = (0);
while(true){
if((i__7485__auto___20164 < len__7484__auto___20163)){
args20160.push((arguments[i__7485__auto___20164]));

var G__20165 = (i__7485__auto___20164 + (1));
i__7485__auto___20164 = G__20165;
continue;
} else {
}
break;
}

var G__20162 = args20160.length;
switch (G__20162) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20160.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
return kw.call(null,cljs.core.js__GT_clj.call(null,hatti.map.utils.get_style.call(null,marker)));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;

/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style.call(null,hatti.map.utils.get_style.call(null,marker),hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = marker__GT_style.call(null,marker);
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return marker.setStyle(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"reset","reset",-800929946),style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,style,new cljs.core.Keyword(null,"reset","reset",-800929946),style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.map.utils.is_clicked_QMARK_.call(null,marker);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_selected_QMARK_.call(null,hatti.map.utils.get_id.call(null,marker));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"clicked","clicked",114423720)));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style.call(null,marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"hover","hover",-341141711)));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20176 = arguments.length;
var i__7485__auto___20177 = (0);
while(true){
if((i__7485__auto___20177 < len__7484__auto___20176)){
args__7491__auto__.push((arguments[i__7485__auto___20177]));

var G__20178 = (i__7485__auto___20177 + (1));
i__7485__auto___20177 = G__20178;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__20169){
var map__20170 = p__20169;
var map__20170__$1 = ((((!((map__20170 == null)))?((((map__20170.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20170.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20170):map__20170);
var preserve_clicked_QMARK_ = cljs.core.get.call(null,map__20170__$1,new cljs.core.Keyword(null,"preserve-clicked?","preserve-clicked?",-727263842),true);
var seq__20172 = cljs.core.seq.call(null,markers);
var chunk__20173 = null;
var count__20174 = (0);
var i__20175 = (0);
while(true){
if((i__20175 < count__20174)){
var marker = cljs.core._nth.call(null,chunk__20173,i__20175);
if(cljs.core.not.call(null,(function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__20179 = seq__20172;
var G__20180 = chunk__20173;
var G__20181 = count__20174;
var G__20182 = (i__20175 + (1));
seq__20172 = G__20179;
chunk__20173 = G__20180;
count__20174 = G__20181;
i__20175 = G__20182;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__20172);
if(temp__4657__auto__){
var seq__20172__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20172__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__20172__$1);
var G__20183 = cljs.core.chunk_rest.call(null,seq__20172__$1);
var G__20184 = c__7220__auto__;
var G__20185 = cljs.core.count.call(null,c__7220__auto__);
var G__20186 = (0);
seq__20172 = G__20183;
chunk__20173 = G__20184;
count__20174 = G__20185;
i__20175 = G__20186;
continue;
} else {
var marker = cljs.core.first.call(null,seq__20172__$1);
if(cljs.core.not.call(null,(function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_.call(null,marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style.call(null,marker,new cljs.core.Keyword(null,"normal","normal",-1519123858)));
} else {
}

var G__20187 = cljs.core.next.call(null,seq__20172__$1);
var G__20188 = null;
var G__20189 = (0);
var G__20190 = (0);
seq__20172 = G__20187;
chunk__20173 = G__20188;
count__20174 = G__20189;
i__20175 = G__20190;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq20167){
var G__20168 = cljs.core.first.call(null,seq20167);
var seq20167__$1 = cljs.core.next.call(null,seq20167);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__20168,seq20167__$1);
});

hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string.call(null,maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"Feature",new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.call(null,hatti.constants._rank),(index + (1)),new cljs.core.Keyword(null,"id","id",-1388402092),record_id,cljs.core.keyword.call(null,hatti.constants._id),record_id], true, false),new cljs.core.Keyword(null,"geometry","geometry",-405034994),geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__7334__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__7335__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__7336__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__7337__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__7338__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"hatti.map.utils","get-as-geom"),((function (method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__){
return (function() { 
var G__20195__delegate = function (record,field,p__20191){
var vec__20192 = p__20191;
var repeat_child_index = cljs.core.nth.call(null,vec__20192,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_.call(null,field))){
return new cljs.core.Keyword(null,"repeat","repeat",832692087);
} else {
return new cljs.core.Keyword(null,"default","default",-1987822328);

}
};
var G__20195 = function (record,field,var_args){
var p__20191 = null;
if (arguments.length > 2) {
var G__20196__i = 0, G__20196__a = new Array(arguments.length -  2);
while (G__20196__i < G__20196__a.length) {G__20196__a[G__20196__i] = arguments[G__20196__i + 2]; ++G__20196__i;}
  p__20191 = new cljs.core.IndexedSeq(G__20196__a,0);
} 
return G__20195__delegate.call(this,record,field,p__20191);};
G__20195.cljs$lang$maxFixedArity = 2;
G__20195.cljs$lang$applyTo = (function (arglist__20197){
var record = cljs.core.first(arglist__20197);
arglist__20197 = cljs.core.next(arglist__20197);
var field = cljs.core.first(arglist__20197);
var p__20191 = cljs.core.rest(arglist__20197);
return G__20195__delegate(record,field,p__20191);
});
G__20195.cljs$core$IFn$_invoke$arity$variadic = G__20195__delegate;
return G__20195;
})()
;})(method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__7338__auto__,method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__));
})();
}
cljs.core._add_method.call(null,hatti.map.utils.get_as_geom,new cljs.core.Keyword(null,"repeat","repeat",832692087),(function (record,p__20198){
var map__20199 = p__20198;
var map__20199__$1 = ((((!((map__20199 == null)))?((((map__20199.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20199.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20199):map__20199);
var field = map__20199__$1;
var children = cljs.core.get.call(null,map__20199__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var full_name = cljs.core.get.call(null,map__20199__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
var iter__7189__auto__ = ((function (map__20199,map__20199__$1,field,children,full_name){
return (function hatti$map$utils$iter__20201(s__20202){
return (new cljs.core.LazySeq(null,((function (map__20199,map__20199__$1,field,children,full_name){
return (function (){
var s__20202__$1 = s__20202;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20202__$1);
if(temp__4657__auto__){
var s__20202__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20202__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20202__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20204 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20203 = (0);
while(true){
if((i__20203 < size__7188__auto__)){
var child_record = cljs.core._nth.call(null,c__7187__auto__,i__20203);
cljs.core.chunk_append.call(null,b__20204,(function (){var iter__7189__auto__ = ((function (i__20203,child_record,c__7187__auto__,size__7188__auto__,b__20204,s__20202__$2,temp__4657__auto__,map__20199,map__20199__$1,field,children,full_name){
return (function hatti$map$utils$iter__20201_$_iter__20213(s__20214){
return (new cljs.core.LazySeq(null,((function (i__20203,child_record,c__7187__auto__,size__7188__auto__,b__20204,s__20202__$2,temp__4657__auto__,map__20199,map__20199__$1,field,children,full_name){
return (function (){
var s__20214__$1 = s__20214;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__20214__$1);
if(temp__4657__auto____$1){
var s__20214__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20214__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first.call(null,s__20214__$2);
var size__7188__auto____$1 = cljs.core.count.call(null,c__7187__auto____$1);
var b__20216 = cljs.core.chunk_buffer.call(null,size__7188__auto____$1);
if((function (){var i__20215 = (0);
while(true){
if((i__20215 < size__7188__auto____$1)){
var child = cljs.core._nth.call(null,c__7187__auto____$1,i__20215);
cljs.core.chunk_append.call(null,b__20216,hatti.map.utils.get_as_geom.call(null,child_record,child));

var G__20221 = (i__20215 + (1));
i__20215 = G__20221;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20216),hatti$map$utils$iter__20201_$_iter__20213.call(null,cljs.core.chunk_rest.call(null,s__20214__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20216),null);
}
} else {
var child = cljs.core.first.call(null,s__20214__$2);
return cljs.core.cons.call(null,hatti.map.utils.get_as_geom.call(null,child_record,child),hatti$map$utils$iter__20201_$_iter__20213.call(null,cljs.core.rest.call(null,s__20214__$2)));
}
} else {
return null;
}
break;
}
});})(i__20203,child_record,c__7187__auto__,size__7188__auto__,b__20204,s__20202__$2,temp__4657__auto__,map__20199,map__20199__$1,field,children,full_name))
,null,null));
});})(i__20203,child_record,c__7187__auto__,size__7188__auto__,b__20204,s__20202__$2,temp__4657__auto__,map__20199,map__20199__$1,field,children,full_name))
;
return iter__7189__auto__.call(null,cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,children));
})());

var G__20222 = (i__20203 + (1));
i__20203 = G__20222;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20204),hatti$map$utils$iter__20201.call(null,cljs.core.chunk_rest.call(null,s__20202__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20204),null);
}
} else {
var child_record = cljs.core.first.call(null,s__20202__$2);
return cljs.core.cons.call(null,(function (){var iter__7189__auto__ = ((function (child_record,s__20202__$2,temp__4657__auto__,map__20199,map__20199__$1,field,children,full_name){
return (function hatti$map$utils$iter__20201_$_iter__20217(s__20218){
return (new cljs.core.LazySeq(null,((function (child_record,s__20202__$2,temp__4657__auto__,map__20199,map__20199__$1,field,children,full_name){
return (function (){
var s__20218__$1 = s__20218;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__20218__$1);
if(temp__4657__auto____$1){
var s__20218__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20218__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20218__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20220 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20219 = (0);
while(true){
if((i__20219 < size__7188__auto__)){
var child = cljs.core._nth.call(null,c__7187__auto__,i__20219);
cljs.core.chunk_append.call(null,b__20220,hatti.map.utils.get_as_geom.call(null,child_record,child));

var G__20223 = (i__20219 + (1));
i__20219 = G__20223;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20220),hatti$map$utils$iter__20201_$_iter__20217.call(null,cljs.core.chunk_rest.call(null,s__20218__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20220),null);
}
} else {
var child = cljs.core.first.call(null,s__20218__$2);
return cljs.core.cons.call(null,hatti.map.utils.get_as_geom.call(null,child_record,child),hatti$map$utils$iter__20201_$_iter__20217.call(null,cljs.core.rest.call(null,s__20218__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__20202__$2,temp__4657__auto__,map__20199,map__20199__$1,field,children,full_name))
,null,null));
});})(child_record,s__20202__$2,temp__4657__auto__,map__20199,map__20199__$1,field,children,full_name))
;
return iter__7189__auto__.call(null,cljs.core.filter.call(null,hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__20201.call(null,cljs.core.rest.call(null,s__20202__$2)));
}
} else {
return null;
}
break;
}
});})(map__20199,map__20199__$1,field,children,full_name))
,null,null));
});})(map__20199,map__20199__$1,field,children,full_name))
;
return iter__7189__auto__.call(null,cljs.core.get.call(null,record,full_name));
}));
cljs.core._add_method.call(null,hatti.map.utils.get_as_geom,new cljs.core.Keyword(null,"default","default",-1987822328),(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq.call(null,s)) && (cljs.core.not_EQ_.call(null,s,"n/a"))){
var iter__7189__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__20226(s__20227){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__20227__$1 = s__20227;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20227__$1);
if(temp__4657__auto__){
var s__20227__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20227__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20227__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20229 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20228 = (0);
while(true){
if((i__20228 < size__7188__auto__)){
var coord_string = cljs.core._nth.call(null,c__7187__auto__,i__20228);
cljs.core.chunk_append.call(null,b__20229,(function (){var vec__20236 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__20236,(0),null);
var lng = cljs.core.nth.call(null,vec__20236,(1),null);
var _ = cljs.core.nth.call(null,vec__20236,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__20236,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})());

var G__20243 = (i__20228 + (1));
i__20228 = G__20243;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20229),hatti$map$utils$iter__20226.call(null,cljs.core.chunk_rest.call(null,s__20227__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20229),null);
}
} else {
var coord_string = cljs.core.first.call(null,s__20227__$2);
return cljs.core.cons.call(null,(function (){var vec__20239 = clojure.string.split.call(null,coord_string,/ /);
var lat = cljs.core.nth.call(null,vec__20239,(0),null);
var lng = cljs.core.nth.call(null,vec__20239,(1),null);
var _ = cljs.core.nth.call(null,vec__20239,(2),null);
var ___$1 = cljs.core.nth.call(null,vec__20239,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string.call(null,lng),cljs.reader.read_string.call(null,lat)], null);
})(),hatti$map$utils$iter__20226.call(null,cljs.core.rest.call(null,s__20227__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__7189__auto__.call(null,clojure.string.split.call(null,s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__20242 = geotype;
switch (G__20242) {
case "Point":
return ((function (G__20242,geotype,parse){
return (function (p1__20224_SHARP_){
return cljs.core.first.call(null,parse.call(null,p1__20224_SHARP_));
});
;})(G__20242,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__20242,geotype,parse){
return (function (p1__20225_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse.call(null,p1__20225_SHARP_)],null));
});
;})(G__20242,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.call(null,record,new cljs.core.Keyword(null,"full-name","full-name",408178550).cljs$core$IFn$_invoke$arity$1(geofield));
var coords = coordfn.call(null,value);
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_.call(null,geofield))){
return new cljs.core.Keyword(null,"geom","geom",1207084371).cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = (coords == null);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return cljs.core.some.call(null,cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),geotype,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668),coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args20246 = [];
var len__7484__auto___20265 = arguments.length;
var i__7485__auto___20266 = (0);
while(true){
if((i__7485__auto___20266 < len__7484__auto___20265)){
args20246.push((arguments[i__7485__auto___20266]));

var G__20267 = (i__7485__auto___20266 + (1));
i__7485__auto___20266 = G__20267;
continue;
} else {
}
break;
}

var G__20248 = args20246.length;
switch (G__20248) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20246.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.call(null,dataset,form,hatti.ona.forms.default_geofield.call(null,form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__7189__auto__ = (function hatti$map$utils$iter__20249(s__20250){
return (new cljs.core.LazySeq(null,(function (){
var s__20250__$1 = s__20250;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20250__$1);
if(temp__4657__auto__){
var s__20250__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20250__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20250__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20252 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20251 = (0);
while(true){
if((i__20251 < size__7188__auto__)){
var vec__20259 = cljs.core._nth.call(null,c__7187__auto__,i__20251);
var idx = cljs.core.nth.call(null,vec__20259,(0),null);
var record = cljs.core.nth.call(null,vec__20259,(1),null);
var geom_or_geoms = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append.call(null,b__20252,((cljs.core.map_QMARK_.call(null,geom_or_geoms))?hatti.map.utils.make_feature.call(null,geom_or_geoms,record.call(null,hatti.constants._id),idx):cljs.core.map.call(null,((function (i__20251,s__20250__$1,geom_or_geoms,vec__20259,idx,record,c__7187__auto__,size__7188__auto__,b__20252,s__20250__$2,temp__4657__auto__){
return (function (p1__20245_SHARP_){
return hatti.map.utils.make_feature.call(null,p1__20245_SHARP_,record.call(null,hatti.constants._id),idx);
});})(i__20251,s__20250__$1,geom_or_geoms,vec__20259,idx,record,c__7187__auto__,size__7188__auto__,b__20252,s__20250__$2,temp__4657__auto__))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,geom_or_geoms)))));

var G__20269 = (i__20251 + (1));
i__20251 = G__20269;
continue;
} else {
var G__20270 = (i__20251 + (1));
i__20251 = G__20270;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20252),hatti$map$utils$iter__20249.call(null,cljs.core.chunk_rest.call(null,s__20250__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20252),null);
}
} else {
var vec__20262 = cljs.core.first.call(null,s__20250__$2);
var idx = cljs.core.nth.call(null,vec__20262,(0),null);
var record = cljs.core.nth.call(null,vec__20262,(1),null);
var geom_or_geoms = hatti.map.utils.get_as_geom.call(null,record,geofield);
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons.call(null,((cljs.core.map_QMARK_.call(null,geom_or_geoms))?hatti.map.utils.make_feature.call(null,geom_or_geoms,record.call(null,hatti.constants._id),idx):cljs.core.map.call(null,((function (s__20250__$1,geom_or_geoms,vec__20262,idx,record,s__20250__$2,temp__4657__auto__){
return (function (p1__20245_SHARP_){
return hatti.map.utils.make_feature.call(null,p1__20245_SHARP_,record.call(null,hatti.constants._id),idx);
});})(s__20250__$1,geom_or_geoms,vec__20262,idx,record,s__20250__$2,temp__4657__auto__))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,geom_or_geoms)))),hatti$map$utils$iter__20249.call(null,cljs.core.rest.call(null,s__20250__$2)));
} else {
var G__20271 = cljs.core.rest.call(null,s__20250__$2);
s__20250__$1 = G__20271;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,hatti.utils.indexed.call(null,dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"FeatureCollection",new cljs.core.Keyword(null,"features","features",-1146962336),cljs.core.flatten.call(null,features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;

/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__20273){
var map__20276 = p__20273;
var map__20276__$1 = ((((!((map__20276 == null)))?((((map__20276.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20276.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20276):map__20276);
var mapbox_tiles = cljs.core.get.call(null,map__20276__$1,new cljs.core.Keyword(null,"mapbox-tiles","mapbox-tiles",69952469));
var include_google_maps_QMARK_ = cljs.core.get.call(null,map__20276__$1,new cljs.core.Keyword(null,"include-google-maps?","include-google-maps?",1820261665));
var layers = cljs.core.map.call(null,((function (map__20276,map__20276__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__20272_SHARP_){
return L.tileLayer(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(p1__20272_SHARP_));
});})(map__20276,map__20276__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js.call(null,nlayers));
var m = L.map(id,({"layers": cljs.core.first.call(null,layers), "zoomControl": false}));
var z = L.control.zoom.call(null,({"position": "bottomleft"}));
z.addTo(m);

L.control.layers.call(null,named_layers,null,({"position": "bottomleft"})).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return cljs.core.async.put_BANG_.call(null,event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mapped-submission-to-rank","mapped-submission-to-rank",-1281314361),((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style.call(null,marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_.call(null,marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style.call(null,marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not.call(null,layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20290 = arguments.length;
var i__7485__auto___20291 = (0);
while(true){
if((i__7485__auto___20291 < len__7484__auto___20290)){
args__7491__auto__.push((arguments[i__7485__auto___20291]));

var G__20292 = (i__7485__auto___20291 + (1));
i__7485__auto___20291 = G__20292;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__20287){
var map__20288 = p__20287;
var map__20288__$1 = ((((!((map__20288 == null)))?((((map__20288.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20288.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20288):map__20288);
var rezoom_QMARK_ = cljs.core.get.call(null,map__20288__$1,new cljs.core.Keyword(null,"rezoom?","rezoom?",746240707));
var on_events = ((function (map__20288,map__20288__$1,rezoom_QMARK_){
return (function (p1__20278_SHARP_,p2__20279_SHARP_){
return hatti.map.utils.register_mouse_events.call(null,p1__20278_SHARP_,p2__20279_SHARP_,event_chan);
});})(map__20288,map__20288__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",new cljs.core.Keyword(null,"point","point",1813198264),"Polygon",new cljs.core.Keyword(null,"shape","shape",1190694006),"LineString",new cljs.core.Keyword(null,"line","line",212345235)], null).call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__20288,map__20288__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style.call(null,geometry_type,new cljs.core.Keyword(null,"normal","normal",-1519123858));
});})(on_events,geometry_type,map__20288,map__20288__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__20288,map__20288__$1,rezoom_QMARK_){
return (function (p1__20281_SHARP_,p2__20280_SHARP_){
return L.circleMarker(p2__20280_SHARP_);
});})(on_events,geometry_type,stylefn,map__20288,map__20288__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js.call(null,geojson),({"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn}));
var ids = cljs.core.map.call(null,((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__20288,map__20288__$1,rezoom_QMARK_){
return (function (p1__20282_SHARP_){
return cljs.core.get_in.call(null,p1__20282_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"properties","properties",685819552),cljs.core.keyword.call(null,hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__20288,map__20288__$1,rezoom_QMARK_))
,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"feature-layer","feature-layer",2086639246),feature_layer,new cljs.core.Keyword(null,"markers","markers",-246919693),markers,new cljs.core.Keyword(null,"id->marker","id->marker",-1702427771),cljs.core.zipmap.call(null,ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq20283){
var G__20284 = cljs.core.first.call(null,seq20283);
var seq20283__$1 = cljs.core.next.call(null,seq20283);
var G__20285 = cljs.core.first.call(null,seq20283__$1);
var seq20283__$2 = cljs.core.next.call(null,seq20283__$1);
var G__20286 = cljs.core.first.call(null,seq20283__$2);
var seq20283__$3 = cljs.core.next.call(null,seq20283__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__20284,G__20285,G__20286,seq20283__$3);
});

/**
 * Creates a mapboxgl map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_mapboxgl_map = (function hatti$map$utils$create_mapboxgl_map(id){
mapboxgl.accessToken = hatti.constants.mapboxgl_access_token;

var Map = mapboxgl.Map;
var NavigationControl = mapboxgl.NavigationControl;
var ScaleControl = mapboxgl.ScaleControl;
var m = (new Map(({"container": id, "style": "mapbox://styles/mapbox/streets-v9"})));
m.addControl((new ScaleControl(({"maxWidth": (100), "unit": "metric"}))),"bottom-left");

return m.addControl((new NavigationControl()),"bottom-left");
});
/**
 * Gets query filter and returns filters based on field type
 */
hatti.map.utils.get_filter = (function hatti$map$utils$get_filter(p__20293,flat_form){
var map__20299 = p__20293;
var map__20299__$1 = ((((!((map__20299 == null)))?((((map__20299.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20299.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20299):map__20299);
var column = cljs.core.get.call(null,map__20299__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var filter = cljs.core.get.call(null,map__20299__$1,new cljs.core.Keyword(null,"filter","filter",-948537934));
var value = cljs.core.get.call(null,map__20299__$1,new cljs.core.Keyword(null,"value","value",305978217));
var field = cljs.core.first.call(null,cljs.core.filter.call(null,((function (map__20299,map__20299__$1,column,filter,value){
return (function (p__20301){
var map__20302 = p__20301;
var map__20302__$1 = ((((!((map__20302 == null)))?((((map__20302.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20302.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20302):map__20302);
var full_name = cljs.core.get.call(null,map__20302__$1,new cljs.core.Keyword(null,"full-name","full-name",408178550));
return cljs.core._EQ_.call(null,full_name,column);
});})(map__20299,map__20299__$1,column,filter,value))
,flat_form));
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_.call(null,field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS INT) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_.call(null,field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS AS TIMESTAMP) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
return [cljs.core.str("json->>'"),cljs.core.str(column),cljs.core.str("' "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');

}
}
});
/**
 * Generates query params filters for filtered datasets 
 */
hatti.map.utils.generate_filter_string = (function hatti$map$utils$generate_filter_string(query,flat_form){
if(cljs.core.truth_(cljs.core.not_empty.call(null,query))){
return [cljs.core.str(" and "),cljs.core.str(clojure.string.join.call(null," and ",cljs.core.map.call(null,(function (p1__20304_SHARP_){
return hatti.map.utils.get_filter.call(null,p1__20304_SHARP_,flat_form);
}),query)))].join('');
} else {
return null;
}
});
/**
 * Generates tiles url with appropriate filters as query params
 */
hatti.map.utils.get_tiles_endpoint = (function hatti$map$utils$get_tiles_endpoint(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20314 = arguments.length;
var i__7485__auto___20315 = (0);
while(true){
if((i__7485__auto___20315 < len__7484__auto___20314)){
args__7491__auto__.push((arguments[i__7485__auto___20315]));

var G__20316 = (i__7485__auto___20315 + (1));
i__7485__auto___20315 = G__20316;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((4) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((4)),(0),null)):null);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7492__auto__);
});

hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic = (function (tiles_server,formid,fields,flat_form,p__20310){
var vec__20311 = p__20310;
var query = cljs.core.nth.call(null,vec__20311,(0),null);
return [cljs.core.str(tiles_server),cljs.core.str(hatti.constants.tiles_endpoint),cljs.core.str("?where=deleted_at is null and xform_id ="),cljs.core.str(formid),cljs.core.str(hatti.map.utils.generate_filter_string.call(null,query,flat_form)),cljs.core.str("&fields="),cljs.core.str(clojure.string.join.call(null,",",fields))].join('');
});

hatti.map.utils.get_tiles_endpoint.cljs$lang$maxFixedArity = (4);

hatti.map.utils.get_tiles_endpoint.cljs$lang$applyTo = (function (seq20305){
var G__20306 = cljs.core.first.call(null,seq20305);
var seq20305__$1 = cljs.core.next.call(null,seq20305);
var G__20307 = cljs.core.first.call(null,seq20305__$1);
var seq20305__$2 = cljs.core.next.call(null,seq20305__$1);
var G__20308 = cljs.core.first.call(null,seq20305__$2);
var seq20305__$3 = cljs.core.next.call(null,seq20305__$2);
var G__20309 = cljs.core.first.call(null,seq20305__$3);
var seq20305__$4 = cljs.core.next.call(null,seq20305__$3);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic(G__20306,G__20307,G__20308,G__20309,seq20305__$4);
});

/**
 * Add map source. This is called with either tiles-url or geoson which
 *   determins the source type (Vector or  GeosJSON). 
 */
hatti.map.utils.add_mapboxgl_source = (function hatti$map$utils$add_mapboxgl_source(map,id_string,p__20317){
var map__20321 = p__20317;
var map__20321__$1 = ((((!((map__20321 == null)))?((((map__20321.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20321.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20321):map__20321);
var tiles_url = cljs.core.get.call(null,map__20321__$1,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944));
var geojson = cljs.core.get.call(null,map__20321__$1,new cljs.core.Keyword(null,"geojson","geojson",-719473398));
var cluster = cljs.core.get.call(null,map__20321__$1,new cljs.core.Keyword(null,"cluster","cluster",535175621),false);
var clusterRadius = cljs.core.get.call(null,map__20321__$1,new cljs.core.Keyword(null,"clusterRadius","clusterRadius",-1512735857));
var clusterMaxZoom = cljs.core.get.call(null,map__20321__$1,new cljs.core.Keyword(null,"clusterMaxZoom","clusterMaxZoom",-627685763));
var geojson_source_defn = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"geojson",new cljs.core.Keyword(null,"data","data",-232669377),geojson,new cljs.core.Keyword(null,"cluster","cluster",535175621),cluster], null);
var source = (cljs.core.truth_(geojson)?cljs.core.clj__GT_js.call(null,(function (){var G__20323 = geojson_source_defn;
var G__20323__$1 = (cljs.core.truth_(clusterRadius)?cljs.core.assoc.call(null,G__20323,new cljs.core.Keyword(null,"clusterRadius","clusterRadius",-1512735857),clusterRadius):G__20323);
if(cljs.core.truth_(clusterMaxZoom)){
return cljs.core.assoc.call(null,G__20323__$1,new cljs.core.Keyword(null,"clusterMaxZoom","clusterMaxZoom",-627685763),clusterMaxZoom);
} else {
return G__20323__$1;
}
})()):(cljs.core.truth_(tiles_url)?cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"vector",new cljs.core.Keyword(null,"tiles","tiles",178505240),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tiles_url], null)], null)):null));
if(cljs.core.truth_(map.getSource(id_string))){
return null;
} else {
return map.addSource(id_string,source);
}
});
/**
 * Add map layer from available sources.
 */
hatti.map.utils.add_mapboxgl_layer = (function hatti$map$utils$add_mapboxgl_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20332 = arguments.length;
var i__7485__auto___20333 = (0);
while(true){
if((i__7485__auto___20333 < len__7484__auto___20332)){
args__7491__auto__.push((arguments[i__7485__auto___20333]));

var G__20334 = (i__7485__auto___20333 + (1));
i__7485__auto___20333 = G__20334;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id_string,layer_type,p__20328){
var map__20329 = p__20328;
var map__20329__$1 = ((((!((map__20329 == null)))?((((map__20329.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20329.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20329):map__20329);
var layer_id = cljs.core.get.call(null,map__20329__$1,new cljs.core.Keyword(null,"layer-id","layer-id",576786958));
var layout = cljs.core.get.call(null,map__20329__$1,new cljs.core.Keyword(null,"layout","layout",-2120940921));
var paint = cljs.core.get.call(null,map__20329__$1,new cljs.core.Keyword(null,"paint","paint",1531901299));
var filter = cljs.core.get.call(null,map__20329__$1,new cljs.core.Keyword(null,"filter","filter",-948537934));
var tiles_url = cljs.core.get.call(null,map__20329__$1,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944));
var l_id = (function (){var or__6409__auto__ = layer_id;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_string;
}
})();
var layer_def = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),l_id,new cljs.core.Keyword(null,"type","type",1174270348),layer_type,new cljs.core.Keyword(null,"source","source",-433931539),id_string], null);
var layer = cljs.core.clj__GT_js.call(null,(function (){var G__20331 = layer_def;
var G__20331__$1 = (cljs.core.truth_(tiles_url)?cljs.core.assoc.call(null,G__20331,new cljs.core.Keyword(null,"source-layer","source-layer",-637591060),hatti.constants.vector_source_layer):G__20331);
var G__20331__$2 = (cljs.core.truth_(paint)?cljs.core.assoc.call(null,G__20331__$1,new cljs.core.Keyword(null,"paint","paint",1531901299),paint):G__20331__$1);
var G__20331__$3 = (cljs.core.truth_(layout)?cljs.core.assoc.call(null,G__20331__$2,new cljs.core.Keyword(null,"layout","layout",-2120940921),layout):G__20331__$2);
if(cljs.core.truth_(filter)){
return cljs.core.assoc.call(null,G__20331__$3,new cljs.core.Keyword(null,"filter","filter",-948537934),filter);
} else {
return G__20331__$3;
}
})());
if(cljs.core.truth_(map.getLayer(l_id))){
return null;
} else {
return map.addLayer(layer,id_string);
}
});

hatti.map.utils.add_mapboxgl_layer.cljs$lang$maxFixedArity = (3);

hatti.map.utils.add_mapboxgl_layer.cljs$lang$applyTo = (function (seq20324){
var G__20325 = cljs.core.first.call(null,seq20324);
var seq20324__$1 = cljs.core.next.call(null,seq20324);
var G__20326 = cljs.core.first.call(null,seq20324__$1);
var seq20324__$2 = cljs.core.next.call(null,seq20324__$1);
var G__20327 = cljs.core.first.call(null,seq20324__$2);
var seq20324__$3 = cljs.core.next.call(null,seq20324__$2);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(G__20325,G__20326,G__20327,seq20324__$3);
});

/**
 * Generates a collection of input - output value pairs known
 * as stops. These stops are used by get-styles function to decide the style
 * output based on an input vaue from the dataset. e.g. _id. By defauly this
 *  function purely generates color stops.
 */
hatti.map.utils.generate_stops = (function hatti$map$utils$generate_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Generates cirlce size property stops base on values from dataset.
 */
hatti.map.utils.generate_size_stops = (function hatti$map$utils$generate_size_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(4)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Gets predefined styles for diffent layer types and states.
 */
hatti.map.utils.get_styles = (function hatti$map$utils$get_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20340 = arguments.length;
var i__7485__auto___20341 = (0);
while(true){
if((i__7485__auto___20341 < len__7484__auto___20340)){
args__7491__auto__.push((arguments[i__7485__auto___20341]));

var G__20342 = (i__7485__auto___20341 + (1));
i__7485__auto___20341 = G__20342;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic = (function (p__20336){
var vec__20337 = p__20336;
var selected_id = cljs.core.nth.call(null,vec__20337,(0),null);
var stops = cljs.core.nth.call(null,vec__20337,(1),null);
var size_stops = cljs.core.nth.call(null,vec__20337,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"point","point",1813198264),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",(4)], null)], null),new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#631400")], null))], null)], null),new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#ad2300")], null))], null)], null),new cljs.core.Keyword(null,"sized","sized",1886245611),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),(cljs.core.truth_(size_stops)?size_stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(6)], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-opacity",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"stops","stops",-1205459005),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),0.2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(15),0.8], null)], null)], null))], null)], null)], null),new cljs.core.Keyword(null,"fill","fill",883462889),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-opacity",0.7], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-outline-color","#666"], null)], null),new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#631400")], null))], null)], null),new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#ad2300")], null))], null)], null)], null),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-opacity",0.8], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-width",(7)], null)], null),new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#631400")], null))], null)], null),new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),"_id",new cljs.core.Keyword(null,"type","type",1174270348),"categorical",new cljs.core.Keyword(null,"stops","stops",-1205459005),hatti.map.utils.generate_stops.call(null,selected_id,"#ad2300")], null))], null)], null)], null)], null);
});

hatti.map.utils.get_styles.cljs$lang$maxFixedArity = (0);

hatti.map.utils.get_styles.cljs$lang$applyTo = (function (seq20335){
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20335));
});

/**
 * Get style properties for layer.
 */
hatti.map.utils.get_style_properties = (function hatti$map$utils$get_style_properties(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20349 = arguments.length;
var i__7485__auto___20350 = (0);
while(true){
if((i__7485__auto___20350 < len__7484__auto___20349)){
args__7491__auto__.push((arguments[i__7485__auto___20350]));

var G__20351 = (i__7485__auto___20350 + (1));
i__7485__auto___20350 = G__20351;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic = (function (style_type,style_state,p__20346){
var map__20347 = p__20346;
var map__20347__$1 = ((((!((map__20347 == null)))?((((map__20347.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20347.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20347):map__20347);
var selected_id = cljs.core.get.call(null,map__20347__$1,new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044));
var stops = cljs.core.get.call(null,map__20347__$1,new cljs.core.Keyword(null,"stops","stops",-1205459005));
return style_state.call(null,style_type.call(null,hatti.map.utils.get_styles.call(null,selected_id,stops)));
});

hatti.map.utils.get_style_properties.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_style_properties.cljs$lang$applyTo = (function (seq20343){
var G__20344 = cljs.core.first.call(null,seq20343);
var seq20343__$1 = cljs.core.next.call(null,seq20343);
var G__20345 = cljs.core.first.call(null,seq20343__$1);
var seq20343__$2 = cljs.core.next.call(null,seq20343__$1);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(G__20344,G__20345,seq20343__$2);
});

/**
 * Sets maps paint properties given layer-id and list of properties to set.
 *   properties should be a list of properties that contains the propery name
 *   and value in a vector. e.g. [[property1 value1] [property2 value2]
 */
hatti.map.utils.set_mapboxgl_paint_property = (function hatti$map$utils$set_mapboxgl_paint_property(map,layer_id,properties){
var seq__20362 = cljs.core.seq.call(null,properties);
var chunk__20363 = null;
var count__20364 = (0);
var i__20365 = (0);
while(true){
if((i__20365 < count__20364)){
var vec__20366 = cljs.core._nth.call(null,chunk__20363,i__20365);
var p = cljs.core.nth.call(null,vec__20366,(0),null);
var v = cljs.core.nth.call(null,vec__20366,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__20372 = seq__20362;
var G__20373 = chunk__20363;
var G__20374 = count__20364;
var G__20375 = (i__20365 + (1));
seq__20362 = G__20372;
chunk__20363 = G__20373;
count__20364 = G__20374;
i__20365 = G__20375;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__20362);
if(temp__4657__auto__){
var seq__20362__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20362__$1)){
var c__7220__auto__ = cljs.core.chunk_first.call(null,seq__20362__$1);
var G__20376 = cljs.core.chunk_rest.call(null,seq__20362__$1);
var G__20377 = c__7220__auto__;
var G__20378 = cljs.core.count.call(null,c__7220__auto__);
var G__20379 = (0);
seq__20362 = G__20376;
chunk__20363 = G__20377;
count__20364 = G__20378;
i__20365 = G__20379;
continue;
} else {
var vec__20369 = cljs.core.first.call(null,seq__20362__$1);
var p = cljs.core.nth.call(null,vec__20369,(0),null);
var v = cljs.core.nth.call(null,vec__20369,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__20380 = cljs.core.next.call(null,seq__20362__$1);
var G__20381 = null;
var G__20382 = (0);
var G__20383 = (0);
seq__20362 = G__20380;
chunk__20363 = G__20381;
count__20364 = G__20382;
i__20365 = G__20383;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.utils.get_id_property = (function hatti$map$utils$get_id_property(features){
var properties = (cljs.core.first.call(null,features)["properties"]);
var or__6409__auto__ = (properties["id"]);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return (properties[hatti.constants._id]);
}
});
/**
 * Register map mouse events.
 */
hatti.map.utils.register_mapboxgl_mouse_events = (function hatti$map$utils$register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style){
var layer_id = id_string;
var mousemove_fn = ((function (layer_id){
return (function (e){
if(cljs.core.truth_(map.getLayer(layer_id))){
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"layers","layers",1944875032),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.call(null,owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"view-by","view-by",1005248583)], null));
var selected_id = om.core.get_props.call(null,owner,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"submission-clicked","submission-clicked",1228953855),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
map.getCanvas().style.cursor = (((features.length > (0)))?"pointer":"");

if(cljs.core.truth_(view_by)){
return null;
} else {
if(cljs.core._EQ_.call(null,no_of_features,(1))){
return hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"hover","hover",-341141711),new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044),hatti.map.utils.get_id_property.call(null,features)));
} else {
hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"normal","normal",-1519123858)));

if(cljs.core.truth_(selected_id)){
return hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044),selected_id));
} else {
return null;
}
}
}
} else {
return null;
}
});})(layer_id))
;
var click_fn = ((function (layer_id,mousemove_fn){
return (function (e){
if(cljs.core.truth_(map.getLayer(layer_id))){
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"layers","layers",1944875032),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.call(null,owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map-page","map-page",108547100),new cljs.core.Keyword(null,"view-by","view-by",1005248583)], null));
if((no_of_features > (0))){
var feature_id = hatti.map.utils.get_id_property.call(null,features);
cljs.core.async.put_BANG_.call(null,event_chan,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mapped-submission-to-id","mapped-submission-to-id",-1148058736),feature_id], null));

if(cljs.core.truth_(view_by)){
return null;
} else {
return hatti.map.utils.set_mapboxgl_paint_property.call(null,map,layer_id,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"clicked","clicked",114423720),new cljs.core.Keyword(null,"selected-id","selected-id",-1028389044),feature_id));
}
} else {
return null;
}
} else {
return null;
}
});})(layer_id,mousemove_fn))
;
map.off("mousemove",om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"mousemove-fn","mousemove-fn",288658931)));

map.off("click",om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"click-fn","click-fn",2099562548)));

map.on("mousemove",mousemove_fn);

map.on("click",click_fn);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"mousemove-fn","mousemove-fn",288658931),mousemove_fn);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"click-fn","click-fn",2099562548),click_fn);
});
/**
 * Fits map boundaries on rendered features.
 */
hatti.map.utils.fitMapBounds = (function hatti$map$utils$fitMapBounds(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20391 = arguments.length;
var i__7485__auto___20392 = (0);
while(true){
if((i__7485__auto___20392 < len__7484__auto___20391)){
args__7491__auto__.push((arguments[i__7485__auto___20392]));

var G__20393 = (i__7485__auto___20392 + (1));
i__7485__auto___20392 = G__20393;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__20387){
var vec__20388 = p__20387;
var geojson = cljs.core.nth.call(null,vec__20388,(0),null);
var features = (function (){var or__6409__auto__ = new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = (cljs.core.truth_(map.getLayer(layer_id))?map.queryRenderedFeatures(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"layers","layers",1944875032),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null))):null);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return cljs.core.PersistentVector.EMPTY;
}
}
})();
var layer_data = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"FeatureCollection",new cljs.core.Keyword(null,"features","features",-1146962336),features], null));
}
})();
var bbox = turf.bbox(cljs.core.clj__GT_js.call(null,layer_data));
if((cljs.core.count.call(null,features) > (0))){
return map.fitBounds(bbox,({"padding": "15", "linear": true}));
} else {
return null;
}
});

hatti.map.utils.fitMapBounds.cljs$lang$maxFixedArity = (2);

hatti.map.utils.fitMapBounds.cljs$lang$applyTo = (function (seq20384){
var G__20385 = cljs.core.first.call(null,seq20384);
var seq20384__$1 = cljs.core.next.call(null,seq20384);
var G__20386 = cljs.core.first.call(null,seq20384__$1);
var seq20384__$2 = cljs.core.next.call(null,seq20384__$1);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic(G__20385,G__20386,seq20384__$2);
});

/**
 * Get marker style for field type.
 */
hatti.map.utils.geotype__GT_marker_style = (function hatti$map$utils$geotype__GT_marker_style(p__20394){
var map__20397 = p__20394;
var map__20397__$1 = ((((!((map__20397 == null)))?((((map__20397.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20397.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20397):map__20397);
var field = map__20397__$1;
var children = cljs.core.get.call(null,map__20397__$1,new cljs.core.Keyword(null,"children","children",-940561982));
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.geoshape_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.osm_QMARK_.call(null,field);
}
})())){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"layer-type","layer-type",816560917),"fill",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"fill","fill",883462889)], null);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.geotrace_QMARK_.call(null,field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var and__6397__auto__ = hatti.ona.forms.repeat_QMARK_.call(null,field);
if(cljs.core.truth_(and__6397__auto__)){
return hatti.ona.forms.geotrace_QMARK_.call(null,cljs.core.first.call(null,children));
} else {
return and__6397__auto__;
}
}
})())){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"layer-type","layer-type",816560917),"line",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"layout","layout",-2120940921),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"line-join","line-join",-1560936092),"round",new cljs.core.Keyword(null,"line-cap","line-cap",448406012),"round"], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"layer-type","layer-type",816560917),"circle",new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"point","point",1813198264)], null);

}
}
});
/**
 * Filter features and return only selected features. Returns all features
 *   features if selected-ids is nil. 
 */
hatti.map.utils.filter_selected_features = (function hatti$map$utils$filter_selected_features(features,selected_ids){
var G__20405 = features;
if(cljs.core.truth_(selected_ids)){
return cljs.core.filter.call(null,((function (G__20405){
return (function (p__20406){
var map__20407 = p__20406;
var map__20407__$1 = ((((!((map__20407 == null)))?((((map__20407.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20407.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20407):map__20407);
var map__20408 = cljs.core.get.call(null,map__20407__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var map__20408__$1 = ((((!((map__20408 == null)))?((((map__20408.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20408.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20408):map__20408);
var _id = cljs.core.get.call(null,map__20408__$1,new cljs.core.Keyword(null,"_id","_id",-789960287));
return chimera.seq.in_QMARK_.call(null,selected_ids,_id);
});})(G__20405))
,G__20405);
} else {
return G__20405;
}
});
/**
 * Counts points collected into hexbins.
 */
hatti.map.utils.count_hexbin_points = (function hatti$map$utils$count_hexbin_points(hexbins){
var iter__7189__auto__ = (function hatti$map$utils$count_hexbin_points_$_iter__20431(s__20432){
return (new cljs.core.LazySeq(null,(function (){
var s__20432__$1 = s__20432;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20432__$1);
if(temp__4657__auto__){
var s__20432__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20432__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20432__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20434 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20433 = (0);
while(true){
if((i__20433 < size__7188__auto__)){
var map__20443 = cljs.core._nth.call(null,c__7187__auto__,i__20433);
var map__20443__$1 = ((((!((map__20443 == null)))?((((map__20443.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20443.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20443):map__20443);
var feature = map__20443__$1;
var map__20444 = cljs.core.get.call(null,map__20443__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var map__20444__$1 = ((((!((map__20444 == null)))?((((map__20444.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20444.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20444):map__20444);
var points = cljs.core.get.call(null,map__20444__$1,new cljs.core.Keyword(null,"points","points",-1486596883));
var point_count = cljs.core.count.call(null,points);
cljs.core.chunk_append.call(null,b__20434,(((point_count > (0)))?cljs.core.assoc.call(null,feature,new cljs.core.Keyword(null,"properties","properties",685819552),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"point-count","point-count",-234732819),point_count], null)):null));

var G__20451 = (i__20433 + (1));
i__20433 = G__20451;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20434),hatti$map$utils$count_hexbin_points_$_iter__20431.call(null,cljs.core.chunk_rest.call(null,s__20432__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20434),null);
}
} else {
var map__20447 = cljs.core.first.call(null,s__20432__$2);
var map__20447__$1 = ((((!((map__20447 == null)))?((((map__20447.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20447.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20447):map__20447);
var feature = map__20447__$1;
var map__20448 = cljs.core.get.call(null,map__20447__$1,new cljs.core.Keyword(null,"properties","properties",685819552));
var map__20448__$1 = ((((!((map__20448 == null)))?((((map__20448.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20448.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20448):map__20448);
var points = cljs.core.get.call(null,map__20448__$1,new cljs.core.Keyword(null,"points","points",-1486596883));
var point_count = cljs.core.count.call(null,points);
return cljs.core.cons.call(null,(((point_count > (0)))?cljs.core.assoc.call(null,feature,new cljs.core.Keyword(null,"properties","properties",685819552),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"point-count","point-count",-234732819),point_count], null)):null),hatti$map$utils$count_hexbin_points_$_iter__20431.call(null,cljs.core.rest.call(null,s__20432__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(hexbins));
});
hatti.map.utils.get_rendered_features = (function hatti$map$utils$get_rendered_features(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20459 = arguments.length;
var i__7485__auto___20460 = (0);
while(true){
if((i__7485__auto___20460 < len__7484__auto___20459)){
args__7491__auto__.push((arguments[i__7485__auto___20460]));

var G__20461 = (i__7485__auto___20460 + (1));
i__7485__auto___20460 = G__20461;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__20456){
var map__20457 = p__20456;
var map__20457__$1 = ((((!((map__20457 == null)))?((((map__20457.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20457.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20457):map__20457);
var geojson = cljs.core.get.call(null,map__20457__$1,new cljs.core.Keyword(null,"geojson","geojson",-719473398));
var selected_ids = cljs.core.get.call(null,map__20457__$1,new cljs.core.Keyword(null,"selected-ids","selected-ids",-1154760141));

var get_rendered_features = ((function (map__20457,map__20457__$1,geojson,selected_ids){
return (function (){
return map.queryRenderedFeatures(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"layers","layers",1944875032),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
});})(map__20457,map__20457__$1,geojson,selected_ids))
;
var rendered_features = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"FeatureCollection",new cljs.core.Keyword(null,"features","features",-1146962336),get_rendered_features.call(null)], null);
}
})();
return cljs.core.update_in.call(null,rendered_features,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"features","features",-1146962336)], null),((function (get_rendered_features,rendered_features,map__20457,map__20457__$1,geojson,selected_ids){
return (function (p1__20452_SHARP_){
return hatti.map.utils.filter_selected_features.call(null,p1__20452_SHARP_,selected_ids);
});})(get_rendered_features,rendered_features,map__20457,map__20457__$1,geojson,selected_ids))
);
});

hatti.map.utils.get_rendered_features.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_rendered_features.cljs$lang$applyTo = (function (seq20453){
var G__20454 = cljs.core.first.call(null,seq20453);
var seq20453__$1 = cljs.core.next.call(null,seq20453);
var G__20455 = cljs.core.first.call(null,seq20453__$1);
var seq20453__$2 = cljs.core.next.call(null,seq20453__$1);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(G__20454,G__20455,seq20453__$2);
});

/**
 * Generates hexbins with point count aggregation given rendered
 *   layer-id or geojson.
 */
hatti.map.utils.generate_hexgrid = (function hatti$map$utils$generate_hexgrid(map,layer_id,geojson,p__20462){
var map__20469 = p__20462;
var map__20469__$1 = ((((!((map__20469 == null)))?((((map__20469.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20469.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20469):map__20469);
var cell_width = cljs.core.get.call(null,map__20469__$1,new cljs.core.Keyword(null,"cell-width","cell-width",1767835816));
var selected_ids = cljs.core.get.call(null,map__20469__$1,new cljs.core.Keyword(null,"selected-ids","selected-ids",-1154760141));
var rendered_features = hatti.map.utils.get_rendered_features.call(null,map,layer_id,new cljs.core.Keyword(null,"geojson","geojson",-719473398),geojson,new cljs.core.Keyword(null,"selected-ids","selected-ids",-1154760141),selected_ids);
var js_rendered_features = cljs.core.clj__GT_js.call(null,rendered_features);
var bbox = turf.bbox(js_rendered_features);
var cellWidth = (function (){var or__6409__auto__ = cell_width;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.hexbin_cell_width;
}
})();
var units = "kilometers";
var hexgrid = turf.hexGrid(bbox,cellWidth,units);
var hex_collection = turf.collect(hexgrid,js_rendered_features,"_id","points");
var hexbins = cljs.core.js__GT_clj.call(null,hex_collection,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var features_w_count = cljs.core.remove.call(null,cljs.core.nil_QMARK_,hatti.map.utils.count_hexbin_points.call(null,hexbins));
var point_counts = (function (){var iter__7189__auto__ = ((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__20469,map__20469__$1,cell_width,selected_ids){
return (function hatti$map$utils$generate_hexgrid_$_iter__20471(s__20472){
return (new cljs.core.LazySeq(null,((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__20469,map__20469__$1,cell_width,selected_ids){
return (function (){
var s__20472__$1 = s__20472;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__20472__$1);
if(temp__4657__auto__){
var s__20472__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20472__$2)){
var c__7187__auto__ = cljs.core.chunk_first.call(null,s__20472__$2);
var size__7188__auto__ = cljs.core.count.call(null,c__7187__auto__);
var b__20474 = cljs.core.chunk_buffer.call(null,size__7188__auto__);
if((function (){var i__20473 = (0);
while(true){
if((i__20473 < size__7188__auto__)){
var f = cljs.core._nth.call(null,c__7187__auto__,i__20473);
cljs.core.chunk_append.call(null,b__20474,new cljs.core.Keyword(null,"point-count","point-count",-234732819).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(f)));

var G__20475 = (i__20473 + (1));
i__20473 = G__20475;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20474),hatti$map$utils$generate_hexgrid_$_iter__20471.call(null,cljs.core.chunk_rest.call(null,s__20472__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20474),null);
}
} else {
var f = cljs.core.first.call(null,s__20472__$2);
return cljs.core.cons.call(null,new cljs.core.Keyword(null,"point-count","point-count",-234732819).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(f)),hatti$map$utils$generate_hexgrid_$_iter__20471.call(null,cljs.core.rest.call(null,s__20472__$2)));
}
} else {
return null;
}
break;
}
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__20469,map__20469__$1,cell_width,selected_ids))
,null,null));
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__20469,map__20469__$1,cell_width,selected_ids))
;
return iter__7189__auto__.call(null,features_w_count);
})();
return cljs.core.assoc.call(null,hexbins,new cljs.core.Keyword(null,"features","features",-1146962336),features_w_count,new cljs.core.Keyword(null,"properties","properties",685819552),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"min-count","min-count",1594709013),cljs.core.apply.call(null,cljs.core.min,point_counts),new cljs.core.Keyword(null,"max-count","max-count",1539185305),cljs.core.apply.call(null,cljs.core.max,point_counts)], null));
});
/**
 * Show/or hide geopoints. Hide geopoints if hide-points is true.
 */
hatti.map.utils.show_hide_points = (function hatti$map$utils$show_hide_points(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20483 = arguments.length;
var i__7485__auto___20484 = (0);
while(true){
if((i__7485__auto___20484 < len__7484__auto___20483)){
args__7491__auto__.push((arguments[i__7485__auto___20484]));

var G__20485 = (i__7485__auto___20484 + (1));
i__7485__auto___20484 = G__20485;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__20479){
var vec__20480 = p__20479;
var hide_points_QMARK_ = cljs.core.nth.call(null,vec__20480,(0),null);
var visibility = (cljs.core.truth_(hide_points_QMARK_)?"none":"visible");
if(cljs.core.truth_(map.getLayer(layer_id))){
map.setLayoutProperty(layer_id,"visibility",visibility);
} else {
}

if(cljs.core.truth_(map.getLayer(hatti.map.utils.circle_border_id))){
return map.setLayoutProperty(hatti.map.utils.circle_border_id,"visibility",visibility);
} else {
return null;
}
});

hatti.map.utils.show_hide_points.cljs$lang$maxFixedArity = (2);

hatti.map.utils.show_hide_points.cljs$lang$applyTo = (function (seq20476){
var G__20477 = cljs.core.first.call(null,seq20476);
var seq20476__$1 = cljs.core.next.call(null,seq20476);
var G__20478 = cljs.core.first.call(null,seq20476__$1);
var seq20476__$2 = cljs.core.next.call(null,seq20476__$1);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(G__20477,G__20478,seq20476__$2);
});

/**
 * Remove layer from map and it's source from map.
 */
hatti.map.utils.remove_layer = (function hatti$map$utils$remove_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20492 = arguments.length;
var i__7485__auto___20493 = (0);
while(true){
if((i__7485__auto___20493 < len__7484__auto___20492)){
args__7491__auto__.push((arguments[i__7485__auto___20493]));

var G__20494 = (i__7485__auto___20493 + (1));
i__7485__auto___20493 = G__20494;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id,p__20489){
var map__20490 = p__20489;
var map__20490__$1 = ((((!((map__20490 == null)))?((((map__20490.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20490.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20490):map__20490);
var keep_source_QMARK_ = cljs.core.get.call(null,map__20490__$1,new cljs.core.Keyword(null,"keep-source?","keep-source?",1217063318));
if(cljs.core.truth_(map.getLayer(id))){
map.removeLayer(id);
} else {
}

if(cljs.core.truth_((function (){var and__6397__auto__ = map.getSource(id);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not.call(null,keep_source_QMARK_);
} else {
return and__6397__auto__;
}
})())){
return map.removeSource(id);
} else {
return null;
}
});

hatti.map.utils.remove_layer.cljs$lang$maxFixedArity = (2);

hatti.map.utils.remove_layer.cljs$lang$applyTo = (function (seq20486){
var G__20487 = cljs.core.first.call(null,seq20486);
var seq20486__$1 = cljs.core.next.call(null,seq20486);
var G__20488 = cljs.core.first.call(null,seq20486__$1);
var seq20486__$2 = cljs.core.next.call(null,seq20486__$1);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(G__20487,G__20488,seq20486__$2);
});

/**
 * Renders hexbin layer on map.
 */
hatti.map.utils.show_hexbins = (function hatti$map$utils$show_hexbins(owner,map,id_string,geojson,p__20495){
var map__20500 = p__20495;
var map__20500__$1 = ((((!((map__20500 == null)))?((((map__20500.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20500.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20500):map__20500);
var opts = map__20500__$1;
var cell_color = cljs.core.get.call(null,map__20500__$1,new cljs.core.Keyword(null,"cell-color","cell-color",83713438));
var extrusion_QMARK_ = cljs.core.get.call(null,map__20500__$1,new cljs.core.Keyword(null,"extrusion?","extrusion?",-220604176));
var hide_points_QMARK_ = cljs.core.get.call(null,map__20500__$1,new cljs.core.Keyword(null,"hide-points?","hide-points?",-532207870));
var hexgrid = hatti.map.utils.generate_hexgrid.call(null,map,id_string,geojson,opts);
var map__20502 = new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(hexgrid);
var map__20502__$1 = ((((!((map__20502 == null)))?((((map__20502.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20502.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20502):map__20502);
var min_count = cljs.core.get.call(null,map__20502__$1,new cljs.core.Keyword(null,"min-count","min-count",1594709013));
var max_count = cljs.core.get.call(null,map__20502__$1,new cljs.core.Keyword(null,"max-count","max-count",1539185305));
var max_color = (function (){var or__6409__auto__ = cell_color;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.max_count_color;
}
})();
var min_color = ((cljs.core._EQ_.call(null,min_count,max_count))?max_color:hatti.constants.min_count_color);
var property = "point-count";
var fill_color = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"property","property",-1114278232),"point-count",new cljs.core.Keyword(null,"stops","stops",-1205459005),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,min_color], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,max_color], null)], null)], null);
var fill_opacity = 0.6;
var paint = (cljs.core.truth_(extrusion_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fill-extrusion-color","fill-extrusion-color",-825219524),fill_color,new cljs.core.Keyword(null,"fill-extrusion-opacity","fill-extrusion-opacity",-457270565),fill_opacity,new cljs.core.Keyword(null,"fill-extrusion-height","fill-extrusion-height",933696521),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"property","property",-1114278232),property,new cljs.core.Keyword(null,"stops","stops",-1205459005),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,(10)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,(25000)], null)], null),new cljs.core.Keyword(null,"base","base",185279322),(1)], null)], null):new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fill-outline-color","fill-outline-color",1960554289),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"property","property",-1114278232),property,new cljs.core.Keyword(null,"stops","stops",-1205459005),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,"white"], null)], null)], null),new cljs.core.Keyword(null,"fill-color","fill-color",-1156875903),fill_color,new cljs.core.Keyword(null,"fill-opacity","fill-opacity",-537571170),fill_opacity], null));
var layer_type = (cljs.core.truth_(extrusion_QMARK_)?"fill-extrusion":"fill");
var extrusion_layer_id = [cljs.core.str(hatti.constants.hexgrid_id),cljs.core.str("-extrusion")].join('');
if(cljs.core.truth_((function (){var and__6397__auto__ = min_count;
if(cljs.core.truth_(and__6397__auto__)){
return max_count;
} else {
return and__6397__auto__;
}
})())){
hatti.map.utils.add_mapboxgl_source.call(null,map,hatti.constants.hexgrid_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"geojson","geojson",-719473398),hexgrid], null));

hatti.map.utils.add_mapboxgl_layer.call(null,map,hatti.constants.hexgrid_id,layer_type,new cljs.core.Keyword(null,"paint","paint",1531901299),paint);

if(cljs.core.truth_(extrusion_QMARK_)){
hatti.map.utils.add_mapboxgl_layer.call(null,map,hatti.constants.hexgrid_id,layer_type,new cljs.core.Keyword(null,"paint","paint",1531901299),paint,new cljs.core.Keyword(null,"layer-id","layer-id",576786958),extrusion_layer_id);

map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","none");
} else {
map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","visible");

hatti.map.utils.remove_layer.call(null,map,extrusion_layer_id,new cljs.core.Keyword(null,"keep-source?","keep-source?",1217063318),true);
}

map.setPitch((cljs.core.truth_(extrusion_QMARK_)?(50):(0)));

hatti.map.utils.show_hide_points.call(null,map,id_string,hide_points_QMARK_);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"show-hexbins?","show-hexbins?",1460257258),true);
} else {
return null;
}
});
/**
 * Renders heatmap layer on map.
 */
hatti.map.utils.show_heatmap = (function hatti$map$utils$show_heatmap(owner,map,id_string,geojson,p__20504){
var map__20523 = p__20504;
var map__20523__$1 = ((((!((map__20523 == null)))?((((map__20523.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20523.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20523):map__20523);
var selected_ids = cljs.core.get.call(null,map__20523__$1,new cljs.core.Keyword(null,"selected-ids","selected-ids",-1154760141));
var rendered_features = hatti.map.utils.get_rendered_features.call(null,map,id_string,new cljs.core.Keyword(null,"geojson","geojson",-719473398),geojson,new cljs.core.Keyword(null,"selected-ids","selected-ids",-1154760141),selected_ids);
var layers = cljs.core.map_indexed.call(null,((function (rendered_features,map__20523,map__20523__$1,selected_ids){
return (function (idx,item){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,item], null);
});})(rendered_features,map__20523,map__20523__$1,selected_ids))
,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"green"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(30),"#ffeda0"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(80),"orange"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),"red"], null)], null));
var layer_count = cljs.core.count.call(null,layers);
hatti.map.utils.add_mapboxgl_source.call(null,map,"heatmap",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"geojson","geojson",-719473398),rendered_features,new cljs.core.Keyword(null,"cluster","cluster",535175621),true,new cljs.core.Keyword(null,"clusterRadius","clusterRadius",-1512735857),(20),new cljs.core.Keyword(null,"clusterMaxZoom","clusterMaxZoom",-627685763),(15)], null));

var seq__20525_20541 = cljs.core.seq.call(null,layers);
var chunk__20526_20542 = null;
var count__20527_20543 = (0);
var i__20528_20544 = (0);
while(true){
if((i__20528_20544 < count__20527_20543)){
var vec__20529_20545 = cljs.core._nth.call(null,chunk__20526_20542,i__20528_20544);
var i_20546 = cljs.core.nth.call(null,vec__20529_20545,(0),null);
var vec__20532_20547 = cljs.core.nth.call(null,vec__20529_20545,(1),null);
var point_count_20548 = cljs.core.nth.call(null,vec__20532_20547,(0),null);
var color_20549 = cljs.core.nth.call(null,vec__20532_20547,(1),null);
hatti.map.utils.add_mapboxgl_layer.call(null,map,"heatmap","circle",new cljs.core.Keyword(null,"layer-id","layer-id",576786958),[cljs.core.str("cluster-"),cljs.core.str(i_20546)].join(''),new cljs.core.Keyword(null,"paint","paint",1531901299),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"circle-color","circle-color",-304052871),color_20549,new cljs.core.Keyword(null,"circle-radius","circle-radius",-1126504347),(70),new cljs.core.Keyword(null,"circle-blur","circle-blur",-1977913481),(1),new cljs.core.Keyword(null,"circle-opacity","circle-opacity",-1772785627),0.7], null),new cljs.core.Keyword(null,"filter","filter",-948537934),((cljs.core._EQ_.call(null,i_20546,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_20548], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_20548], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first.call(null,cljs.core.second.call(null,cljs.core.nth.call(null,layers,(i_20546 + (1)))))], null)], null)));

var G__20550 = seq__20525_20541;
var G__20551 = chunk__20526_20542;
var G__20552 = count__20527_20543;
var G__20553 = (i__20528_20544 + (1));
seq__20525_20541 = G__20550;
chunk__20526_20542 = G__20551;
count__20527_20543 = G__20552;
i__20528_20544 = G__20553;
continue;
} else {
var temp__4657__auto___20554 = cljs.core.seq.call(null,seq__20525_20541);
if(temp__4657__auto___20554){
var seq__20525_20555__$1 = temp__4657__auto___20554;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__20525_20555__$1)){
var c__7220__auto___20556 = cljs.core.chunk_first.call(null,seq__20525_20555__$1);
var G__20557 = cljs.core.chunk_rest.call(null,seq__20525_20555__$1);
var G__20558 = c__7220__auto___20556;
var G__20559 = cljs.core.count.call(null,c__7220__auto___20556);
var G__20560 = (0);
seq__20525_20541 = G__20557;
chunk__20526_20542 = G__20558;
count__20527_20543 = G__20559;
i__20528_20544 = G__20560;
continue;
} else {
var vec__20535_20561 = cljs.core.first.call(null,seq__20525_20555__$1);
var i_20562 = cljs.core.nth.call(null,vec__20535_20561,(0),null);
var vec__20538_20563 = cljs.core.nth.call(null,vec__20535_20561,(1),null);
var point_count_20564 = cljs.core.nth.call(null,vec__20538_20563,(0),null);
var color_20565 = cljs.core.nth.call(null,vec__20538_20563,(1),null);
hatti.map.utils.add_mapboxgl_layer.call(null,map,"heatmap","circle",new cljs.core.Keyword(null,"layer-id","layer-id",576786958),[cljs.core.str("cluster-"),cljs.core.str(i_20562)].join(''),new cljs.core.Keyword(null,"paint","paint",1531901299),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"circle-color","circle-color",-304052871),color_20565,new cljs.core.Keyword(null,"circle-radius","circle-radius",-1126504347),(70),new cljs.core.Keyword(null,"circle-blur","circle-blur",-1977913481),(1),new cljs.core.Keyword(null,"circle-opacity","circle-opacity",-1772785627),0.7], null),new cljs.core.Keyword(null,"filter","filter",-948537934),((cljs.core._EQ_.call(null,i_20562,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_20564], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_20564], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first.call(null,cljs.core.second.call(null,cljs.core.nth.call(null,layers,(i_20562 + (1)))))], null)], null)));

var G__20566 = cljs.core.next.call(null,seq__20525_20555__$1);
var G__20567 = null;
var G__20568 = (0);
var G__20569 = (0);
seq__20525_20541 = G__20566;
chunk__20526_20542 = G__20567;
count__20527_20543 = G__20568;
i__20528_20544 = G__20569;
continue;
}
} else {
}
}
break;
}

hatti.map.utils.show_hide_points.call(null,map,id_string,true);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"show-heatmap?","show-heatmap?",-1605811668),true);
});
/**
 * Functions that are called after map is loaded in DOM.
 */
hatti.map.utils.map_on_load = (function hatti$map$utils$map_on_load(var_args){
var args__7491__auto__ = [];
var len__7484__auto___20581 = arguments.length;
var i__7485__auto___20582 = (0);
while(true){
if((i__7485__auto___20582 < len__7484__auto___20581)){
args__7491__auto__.push((arguments[i__7485__auto___20582]));

var G__20583 = (i__7485__auto___20582 + (1));
i__7485__auto___20582 = G__20583;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic = (function (map,event_chan,id_string,p__20574){
var map__20575 = p__20574;
var map__20575__$1 = ((((!((map__20575 == null)))?((((map__20575.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20575.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20575):map__20575);
var map_data = map__20575__$1;
var geofield = cljs.core.get.call(null,map__20575__$1,new cljs.core.Keyword(null,"geofield","geofield",578715548));
var owner = cljs.core.get.call(null,map__20575__$1,new cljs.core.Keyword(null,"owner","owner",-392611939));
var tiles_url = cljs.core.get.call(null,map__20575__$1,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944));
var geojson = cljs.core.get.call(null,map__20575__$1,new cljs.core.Keyword(null,"geojson","geojson",-719473398));
var map__20577 = hatti.map.utils.geotype__GT_marker_style.call(null,geofield);
var map__20577__$1 = ((((!((map__20577 == null)))?((((map__20577.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20577.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20577):map__20577);
var layer_type = cljs.core.get.call(null,map__20577__$1,new cljs.core.Keyword(null,"layer-type","layer-type",816560917));
var layout = cljs.core.get.call(null,map__20577__$1,new cljs.core.Keyword(null,"layout","layout",-2120940921));
var style = cljs.core.get.call(null,map__20577__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var map__20578 = om.core.get_state.call(null,owner);
var map__20578__$1 = ((((!((map__20578 == null)))?((((map__20578.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20578.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20578):map__20578);
var stops = cljs.core.get.call(null,map__20578__$1,new cljs.core.Keyword(null,"stops","stops",-1205459005));
var layer_opts = cljs.core.get.call(null,map__20578__$1,new cljs.core.Keyword(null,"layer-opts","layer-opts",1764398639));
var show_hexbins_QMARK_ = cljs.core.get.call(null,map__20578__$1,new cljs.core.Keyword(null,"show-hexbins?","show-hexbins?",1460257258));
var show_heatmap_QMARK_ = cljs.core.get.call(null,map__20578__$1,new cljs.core.Keyword(null,"show-heatmap?","show-heatmap?",-1605811668));
if(cljs.core.truth_((function (){var or__6409__auto__ = (cljs.core.count.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geojson)) > (0));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return tiles_url;
}
})())){
om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"loaded?","loaded?",-1108015206),false);

hatti.map.utils.add_mapboxgl_source.call(null,map,id_string,map_data);

hatti.map.utils.add_mapboxgl_layer.call(null,map,id_string,layer_type,new cljs.core.Keyword(null,"layout","layout",-2120940921),layout,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944),tiles_url);

hatti.map.utils.register_mapboxgl_mouse_events.call(null,owner,map,event_chan,id_string,style);

hatti.map.utils.set_mapboxgl_paint_property.call(null,map,id_string,hatti.map.utils.get_style_properties.call(null,style,new cljs.core.Keyword(null,"normal","normal",-1519123858),new cljs.core.Keyword(null,"stops","stops",-1205459005),stops));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"point","point",1813198264),style)){
hatti.map.utils.add_mapboxgl_layer.call(null,map,id_string,layer_type,new cljs.core.Keyword(null,"layer-id","layer-id",576786958),hatti.map.utils.circle_border_id,new cljs.core.Keyword(null,"tiles-url","tiles-url",-1343828944),tiles_url,new cljs.core.Keyword(null,"paint","paint",1531901299),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"circle-color","circle-color",-304052871),"#fff",new cljs.core.Keyword(null,"circle-radius","circle-radius",-1126504347),(6)], null));
} else {
if(cljs.core.truth_(map.getLayer(hatti.map.utils.circle_border_id))){
map.removeLayer(hatti.map.utils.circle_border_id);
} else {
}
}

if(cljs.core.truth_(show_hexbins_QMARK_)){
hatti.map.utils.show_hexbins.call(null,owner,map,id_string,geojson,layer_opts);
} else {
}

if(cljs.core.truth_(show_heatmap_QMARK_)){
hatti.map.utils.show_heatmap.call(null,owner,map,id_string,geojson,layer_opts);
} else {
}

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"geojson","geojson",-719473398),geojson);

om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"style","style",-496642736),style);

return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"loaded?","loaded?",-1108015206),true);
} else {
return null;
}
});

hatti.map.utils.map_on_load.cljs$lang$maxFixedArity = (3);

hatti.map.utils.map_on_load.cljs$lang$applyTo = (function (seq20570){
var G__20571 = cljs.core.first.call(null,seq20570);
var seq20570__$1 = cljs.core.next.call(null,seq20570);
var G__20572 = cljs.core.first.call(null,seq20570__$1);
var seq20570__$2 = cljs.core.next.call(null,seq20570__$1);
var G__20573 = cljs.core.first.call(null,seq20570__$2);
var seq20570__$3 = cljs.core.next.call(null,seq20570__$2);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic(G__20571,G__20572,G__20573,seq20570__$3);
});

/**
 * Set default style
 */
hatti.map.utils.clear_map_styles = (function hatti$map$utils$clear_map_styles(owner){
return hatti.map.utils.set_mapboxgl_paint_property.call(null,om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"mapboxgl-map","mapboxgl-map",1585466246)),om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"layer-id","layer-id",576786958)),hatti.map.utils.get_style_properties.call(null,om.core.get_state.call(null,owner,new cljs.core.Keyword(null,"style","style",-496642736)),new cljs.core.Keyword(null,"normal","normal",-1519123858)));
});
/**
 * Update map zoom level in local component state on zoom event.
 */
hatti.map.utils.set_zoom_level = (function hatti$map$utils$set_zoom_level(owner){
var map__20586 = om.core.get_state.call(null,owner);
var map__20586__$1 = ((((!((map__20586 == null)))?((((map__20586.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20586.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20586):map__20586);
var mapboxgl_map = cljs.core.get.call(null,map__20586__$1,new cljs.core.Keyword(null,"mapboxgl-map","mapboxgl-map",1585466246));
var zoom = cljs.core.get.call(null,map__20586__$1,new cljs.core.Keyword(null,"zoom","zoom",-1827487038));
var next_zoom = mapboxgl_map.getZoom();
if(cljs.core.not_EQ_.call(null,zoom,next_zoom)){
return om.core.set_state_BANG_.call(null,owner,new cljs.core.Keyword(null,"zoom","zoom",-1827487038),next_zoom);
} else {
return null;
}
});
