// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.table');
goog.require('cljs.core');
goog.require('hatti.views.record');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('om.dom');
goog.require('hatti.ona.forms');
goog.require('sablono.core');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.shared');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('chimera.urls');
goog.require('clojure.string');
hatti.views.table.default_num_displayed_records = (25);
hatti.views.table.table_id = "submission-grid";
hatti.views.table.pager_id = "pager";
/**
 * Given a (flat-)form, returns fields for table display.
 * Puts extra fields in the beginning, metadata at the end of the table,
 * and drops fields that have no data (eg. group/note).
 */
hatti.views.table.all_fields = (function hatti$views$table$all_fields(form){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.has_data_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[hatti.ona.forms.id_field,hatti.ona.forms.submission_time_field],null)),hatti.ona.forms.non_meta_fields(form),cljs.core.array_seq([hatti.ona.forms.meta_fields.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$with_DASH_submission_DASH_details_QMARK_,true], 0))], 0))));
});
/**
 * Comparator function for the slickgrid dataview.
 * args.sortCol is the column being sorted, a and b are rows to compare.
 * Claims a is bigger (return 1) if value for a > b, or a is null / empty.
 */
hatti.views.table.compfn = (function hatti$views$table$compfn(args){
return (function (a,b){
var col = (args["sortCol"]);
var lower = ((function (col){
return (function (p1__38506_SHARP_){
if(typeof p1__38506_SHARP_ === 'string'){
return clojure.string.lower_case(p1__38506_SHARP_);
} else {
return p1__38506_SHARP_;
}
});})(col))
;
var aval = lower((a[(col["field"])]));
var bval = lower((b[(col["field"])]));
if(((aval == null)) || ((aval > bval))){
return (1);
} else {
return (-1);
}
});
});
/**
 * Filter function for the slickgrid dataview, use as (partial filterfn form)
 * item is the row, args contains query.
 * Return value of false corresponds with exclusion, true with inclusion.
 */
hatti.views.table.filterfn = (function hatti$views$table$filterfn(form,item,args){
if(cljs.core.not(args)){
return true;
} else {
var indexed_form = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full_DASH_name,form),form);
var query = (args["query"]);
var fmt_subitem = ((function (indexed_form,query){
return (function (p__38512){
var vec__38513 = p__38512;
var fname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38513,(0),null);
var answer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38513,(1),null);
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(cljs.core.get.cljs$core$IFn$_invoke$arity$2(indexed_form,fname),answer,cljs.core.array_seq([cljs.core.cst$kw$compact_QMARK_,true], 0));
});})(indexed_form,query))
;
var filtered = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (indexed_form,query,fmt_subitem){
return (function (p1__38507_SHARP_){
return cljs.core.re_find(chimera.js_interop.safe_regex(query),[cljs.core.str(p1__38507_SHARP_)].join(''));
});})(indexed_form,query,fmt_subitem))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fmt_subitem,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(item))));
return cljs.core.seq(filtered);
}
});
/**
 * Formatter for slickgrid columns takes row,cell,value,columnDef,dataContext.
 * Get one with (partial formatter field language).
 */
hatti.views.table.formatter = (function hatti$views$table$formatter(field,language,field_key,row,cell,value,columnDef,dataContext){
var clj_value = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(value,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
return hatti.ona.forms.format_answer.cljs$core$IFn$_invoke$arity$variadic(field,chimera.string.escape_for_type(clj_value),cljs.core.array_seq([cljs.core.cst$kw$language,language,cljs.core.cst$kw$compact_QMARK_,true,cljs.core.cst$kw$field_DASH_key,field_key], 0));
});
hatti.views.action_buttons.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (owner){
return (function (row,cell,value,columnDef,dataContext){
var map__38516 = cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)));
var map__38516__$1 = ((((!((map__38516 == null)))?((((map__38516.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38516.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38516):map__38516);
var owner__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38516__$1,cljs.core.cst$kw$owner);
var project = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38516__$1,cljs.core.cst$kw$project);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38516__$1,cljs.core.cst$kw$formid);
var form_owner = chimera.urls.last_url_param(owner__$1);
var project_id = chimera.urls.last_url_param(project);
var edit_link = chimera.urls.url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([form_owner,project_id,formid,[cljs.core.str("webform?instance-id="),cljs.core.str(value)].join('')], 0));
return hatti.utils.generate_html.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(value)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$delete_DASH_record,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"checkbox",cljs.core.cst$kw$data_DASH_id,value], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip$middle_DASH_right,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"View"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$view_DASH_record,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_eye,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_id,value], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info,"Edit"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$edit_DASH_record,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_id,value,cljs.core.cst$kw$target,"_blank",cljs.core.cst$kw$href,edit_link], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_pencil], null)], null)], null)], null):null)], 0));
});
}));
/**
 * The html needed for a column name as a string.
 * String, String, Bool -> String
 */
hatti.views.table.column_name_html_string = (function hatti$views$table$column_name_html_string(column_class,label,hxl){
return [cljs.core.str("<div class=\""),cljs.core.str(column_class),cljs.core.str("\">"),cljs.core.str(label),cljs.core.str("</div>"),cljs.core.str((cljs.core.truth_(hxl)?[cljs.core.str("<div class=\"hxl-row\">"),cljs.core.str(hxl),cljs.core.str("</div>")].join(''):null))].join('');
});
hatti.views.table.select_unselect_all_records_id = "select-unselect-all-records";
hatti.views.table.select_unselect_all_records_element = [cljs.core.str("<input type=\"checkbox\" id=\""),cljs.core.str(hatti.views.table.select_unselect_all_records_id),cljs.core.str("\">")].join('');
hatti.views.table.delete_record_class = "delete-record";
hatti.views.table.actions_column = (function hatti$views$table$actions_column(owner,has_hxl_QMARK_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$maxWidth,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[[cljs.core.str((cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height ":null)),cljs.core.str("record-actions header")].join(''),(100),hatti.views.table.select_unselect_all_records_element,(hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1 ? hatti.views.action_buttons.cljs$core$IFn$_invoke$arity$1(owner) : hatti.views.action_buttons.call(null,owner)),hatti.constants._id,"text","actions",false,"record-actions",""]);
});
/**
 * Get a set of slick grid column objects when given a flat form.
 */
hatti.views.table.flat_form__GT_sg_columns = (function hatti$views$table$flat_form__GT_sg_columns(var_args){
var args__7491__auto__ = [];
var len__7484__auto___38549 = arguments.length;
var i__7485__auto___38550 = (0);
while(true){
if((i__7485__auto___38550 < len__7484__auto___38549)){
args__7491__auto__.push((arguments[i__7485__auto___38550]));

var G__38551 = (i__7485__auto___38550 + (1));
i__7485__auto___38550 = G__38551;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic = (function (form,p__38521){
var map__38522 = p__38521;
var map__38522__$1 = ((((!((map__38522 == null)))?((((map__38522.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38522.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38522):map__38522);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38522__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var get_label_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38522__$1,cljs.core.cst$kw$get_DASH_label_QMARK_,true);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38522__$1,cljs.core.cst$kw$language);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38522__$1,cljs.core.cst$kw$owner);
var has_hxl_QMARK_ = (function (){var G__38524 = cljs.core.false_QMARK_;
var G__38525 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__38524,map__38522,map__38522__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (p1__38518_SHARP_){
return (cljs.core.cst$kw$hxl.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$instance.cljs$core$IFn$_invoke$arity$1(p1__38518_SHARP_)) == null);
});})(G__38524,map__38522,map__38522__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,form);
return (chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? chimera.core.any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__38524,G__38525) : chimera.core.any_QMARK_.call(null,G__38524,G__38525));
})();
var columns = (function (){var iter__7189__auto__ = ((function (has_hxl_QMARK_,map__38522,map__38522__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function hatti$views$table$iter__38526(s__38527){
return (new cljs.core.LazySeq(null,((function (has_hxl_QMARK_,map__38522,map__38522__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner){
return (function (){
var s__38527__$1 = s__38527;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38527__$1);
if(temp__4657__auto__){
var s__38527__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38527__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38527__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38529 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38528 = (0);
while(true){
if((i__38528 < size__7188__auto__)){
var field = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38528);
cljs.core.chunk_append(b__38529,(function (){var map__38540 = field;
var map__38540__$1 = ((((!((map__38540 == null)))?((((map__38540.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38540.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38540):map__38540);
var map__38541 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38540__$1,cljs.core.cst$kw$instance);
var map__38541__$1 = ((((!((map__38541 == null)))?((((map__38541.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38541.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38541):map__38541);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38541__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38540__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38540__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38540__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})());

var G__38552 = (i__38528 + (1));
i__38528 = G__38552;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38529),hatti$views$table$iter__38526(cljs.core.chunk_rest(s__38527__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38529),null);
}
} else {
var field = cljs.core.first(s__38527__$2);
return cljs.core.cons((function (){var map__38544 = field;
var map__38544__$1 = ((((!((map__38544 == null)))?((((map__38544.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38544.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38544):map__38544);
var map__38545 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38544__$1,cljs.core.cst$kw$instance);
var map__38545__$1 = ((((!((map__38545 == null)))?((((map__38545.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38545.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38545):map__38545);
var hxl = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38545__$1,cljs.core.cst$kw$hxl);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38544__$1,cljs.core.cst$kw$name);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38544__$1,cljs.core.cst$kw$type);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38544__$1,cljs.core.cst$kw$full_DASH_name);
var label = (cljs.core.truth_(get_label_QMARK_)?hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(field,cljs.core.array_seq([language], 0)):name);
var column_class = hatti.ona.forms.get_column_class(field);
var field_key = (cljs.core.truth_(get_label_QMARK_)?cljs.core.cst$kw$name:cljs.core.cst$kw$label);
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$hxl,cljs.core.cst$kw$headerCssClass,cljs.core.cst$kw$name,cljs.core.cst$kw$formatter,cljs.core.cst$kw$minWidth,cljs.core.cst$kw$field,cljs.core.cst$kw$type,cljs.core.cst$kw$id,cljs.core.cst$kw$sortable,cljs.core.cst$kw$cssClass,cljs.core.cst$kw$toolTip],[hxl,(cljs.core.truth_(has_hxl_QMARK_)?"hxl-min-height":null),hatti.views.table.column_name_html_string(column_class,label,hxl),cljs.core.partial.cljs$core$IFn$_invoke$arity$4(hatti.views.table.formatter,field,language,field_key),(50),full_name,type,name,true,column_class,label]);
})(),hatti$views$table$iter__38526(cljs.core.rest(s__38527__$2)));
}
} else {
return null;
}
break;
}
});})(has_hxl_QMARK_,map__38522,map__38522__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
,null,null));
});})(has_hxl_QMARK_,map__38522,map__38522__$1,hide_actions_column_QMARK_,get_label_QMARK_,language,owner))
;
return iter__7189__auto__(hatti.views.table.all_fields(form));
})();
return cljs.core.clj__GT_js((function (){var G__38548 = columns;
if(cljs.core.not(hide_actions_column_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__38548,hatti.views.table.actions_column(owner,has_hxl_QMARK_));
} else {
return G__38548;
}
})());
});

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$maxFixedArity = (1);

hatti.views.table.flat_form__GT_sg_columns.cljs$lang$applyTo = (function (seq38519){
var G__38520 = cljs.core.first(seq38519);
var seq38519__$1 = cljs.core.next(seq38519);
return hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(G__38520,seq38519__$1);
});

hatti.views.table.init_sg_pager = (function hatti$views$table$init_sg_pager(grid,dataview){
var Pager = Slick.Controls.Pager;
return (new Pager(dataview,grid,(function (){var G__38554 = [cljs.core.str("#"),cljs.core.str(hatti.views.table.pager_id)].join('');
return jQuery(G__38554);
})()));
});
hatti.views.table.resizeColumns = (function hatti$views$table$resizeColumns(grid){
return grid.registerPlugin(Slick.AutoColumnSize());
});
/**
 * Options to feed the slickgrid constructor.
 */
hatti.views.table.sg_options = ({"autoHeight": true, "enableColumnReorder": false, "enableTextSelectionOnCells": true, "rowHeight": (40), "syncColumnCellResize": false});
hatti.views.table.bind_external_sg_grid_event_handlers = (function hatti$views$table$bind_external_sg_grid_event_handlers(grid,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38573(s__38574){
return (new cljs.core.LazySeq(null,(function (){
var s__38574__$1 = s__38574;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38574__$1);
if(temp__4657__auto__){
var s__38574__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38574__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38574__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38576 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38575 = (0);
while(true){
if((i__38575 < size__7188__auto__)){
var vec__38585 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38575);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38585,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38585,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
cljs.core.chunk_append(b__38576,event.subscribe(handler_function));

var G__38591 = (i__38575 + (1));
i__38575 = G__38591;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38576),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38573(cljs.core.chunk_rest(s__38574__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38576),null);
}
} else {
var vec__38588 = cljs.core.first(s__38574__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38588,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38588,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (grid[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_event_handlers_$_iter__38573(cljs.core.rest(s__38574__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.bind_external_sg_grid_dataview_handlers = (function hatti$views$table$bind_external_sg_grid_dataview_handlers(dataview,event_handlers){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = (function hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38610(s__38611){
return (new cljs.core.LazySeq(null,(function (){
var s__38611__$1 = s__38611;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38611__$1);
if(temp__4657__auto__){
var s__38611__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38611__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__38611__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__38613 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__38612 = (0);
while(true){
if((i__38612 < size__7188__auto__)){
var vec__38622 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__38612);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38622,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38622,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
cljs.core.chunk_append(b__38613,event.subscribe(handler_function));

var G__38628 = (i__38612 + (1));
i__38612 = G__38628;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38613),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38610(cljs.core.chunk_rest(s__38611__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38613),null);
}
} else {
var vec__38625 = cljs.core.first(s__38611__$2);
var handler_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38625,(0),null);
var handler_function = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38625,(1),null);
var handler_name = hatti.utils.hyphen__GT_camel_case(cljs.core.name(handler_key));
var event = (dataview[handler_name]);
return cljs.core.cons(event.subscribe(handler_function),hatti$views$table$bind_external_sg_grid_dataview_handlers_$_iter__38610(cljs.core.rest(s__38611__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(event_handlers);
})());
});
hatti.views.table.update_data_to_be_deleted_vector = (function hatti$views$table$update_data_to_be_deleted_vector(checked_QMARK_,data_id){
var map__38631 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38631__$1 = ((((!((map__38631 == null)))?((((map__38631.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38631.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38631):map__38631);
var data_to_be_deleted = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38631__$1,cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted);
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
return chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted], null),((function (map__38631,map__38631__$1,data_to_be_deleted,fn){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(data_to_be_deleted,data_id) : fn.call(null,data_to_be_deleted,data_id));
});})(map__38631,map__38631__$1,data_to_be_deleted,fn))
);
});
hatti.views.table.get_elements_count_by_selector = (function hatti$views$table$get_elements_count_by_selector(selector){
return document.querySelectorAll(selector).length;
});
hatti.views.table.check_select_unselect_all_records_element_QMARK_ = (function hatti$views$table$check_select_unselect_all_records_element_QMARK_(){
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
var selected_rows_count = hatti.views.table.get_elements_count_by_selector([cljs.core.str(delete_record_class_selector),cljs.core.str(":checked")].join(''));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected_rows_count,total_rows_count);
});
hatti.views.table.get_checkbox_selector = (function hatti$views$table$get_checkbox_selector(data_id){
return [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class),cljs.core.str("[data-id=\""),cljs.core.str(data_id),cljs.core.str("\"]")].join('');
});
hatti.views.table.get_delete_checkbox_by_data_id = (function hatti$views$table$get_delete_checkbox_by_data_id(data_id){
var selector = hatti.views.table.get_checkbox_selector(data_id);
return document.querySelector(selector);
});
hatti.views.table.select_rows_marked_to_be_deleted = (function hatti$views$table$select_rows_marked_to_be_deleted(){
var seq__38637 = cljs.core.seq(cljs.core.cst$kw$data_DASH_to_DASH_be_DASH_deleted.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var chunk__38638 = null;
var count__38639 = (0);
var i__38640 = (0);
while(true){
if((i__38640 < count__38639)){
var data_id = chunk__38638.cljs$core$IIndexed$_nth$arity$2(null,i__38640);
var element_38641 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38641.checked = true;

var G__38642 = seq__38637;
var G__38643 = chunk__38638;
var G__38644 = count__38639;
var G__38645 = (i__38640 + (1));
seq__38637 = G__38642;
chunk__38638 = G__38643;
count__38639 = G__38644;
i__38640 = G__38645;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__38637);
if(temp__4657__auto__){
var seq__38637__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38637__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__38637__$1);
var G__38646 = cljs.core.chunk_rest(seq__38637__$1);
var G__38647 = c__7220__auto__;
var G__38648 = cljs.core.count(c__7220__auto__);
var G__38649 = (0);
seq__38637 = G__38646;
chunk__38638 = G__38647;
count__38639 = G__38648;
i__38640 = G__38649;
continue;
} else {
var data_id = cljs.core.first(seq__38637__$1);
var element_38650 = hatti.views.table.get_delete_checkbox_by_data_id(data_id);
element_38650.checked = true;

var G__38651 = cljs.core.next(seq__38637__$1);
var G__38652 = null;
var G__38653 = (0);
var G__38654 = (0);
seq__38637 = G__38651;
chunk__38638 = G__38652;
count__38639 = G__38653;
i__38640 = G__38654;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.views.table.higlight_rows_marked_to_be_deleted = (function hatti$views$table$higlight_rows_marked_to_be_deleted(grid){
var checkboxes = document.getElementsByClassName(hatti.views.table.delete_record_class);
var indexes_of_selected_checkboxes = cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (checkboxes){
return (function (index,checkbox){
if(cljs.core.truth_(checkbox.checked)){
return index;
} else {
return null;
}
});})(checkboxes))
,checkboxes)));
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (checkboxes,indexes_of_selected_checkboxes){
return (function (){
return cljs.core.identity(indexes_of_selected_checkboxes);
});})(checkboxes,indexes_of_selected_checkboxes))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(indexes_of_selected_checkboxes));
});
/**
 * Creates a Slick.Grid backed by Slick.Data.DataView from data and fields.
 * Most events are handled by slickgrid. On double-click, event is put on chan.
 * Returns [grid dataview].
 */
hatti.views.table.sg_init = (function hatti$views$table$sg_init(data,form,current_language,owner,p__38655){
var map__38674 = p__38655;
var map__38674__$1 = ((((!((map__38674 == null)))?((((map__38674.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38674.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38674):map__38674);
var grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38674__$1,cljs.core.cst$kw$grid_DASH_event_DASH_handlers);
var dataview_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38674__$1,cljs.core.cst$kw$dataview_DASH_event_DASH_handlers);
var map__38676 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38676__$1 = ((((!((map__38676 == null)))?((((map__38676.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38676.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38676):map__38676);
var map__38677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38676__$1,cljs.core.cst$kw$table_DASH_page);
var map__38677__$1 = ((((!((map__38677 == null)))?((((map__38677.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38677.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38677):map__38677);
var map__38678 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38677__$1,cljs.core.cst$kw$paging);
var map__38678__$1 = ((((!((map__38678 == null)))?((((map__38678.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38678.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38678):map__38678);
var num_displayed_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38678__$1,cljs.core.cst$kw$num_DASH_displayed_DASH_records);
var total_page_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38678__$1,cljs.core.cst$kw$total_DASH_page_DASH_count);
var hide_actions_column_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38677__$1,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_);
var columns = hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(form,cljs.core.array_seq([cljs.core.cst$kw$language,current_language,cljs.core.cst$kw$hide_DASH_actions_DASH_column_QMARK_,hide_actions_column_QMARK_,cljs.core.cst$kw$owner,owner], 0));
var SlickGrid = Slick.Grid;
var DataView = Slick.Data.DataView;
var dataview = (new DataView());
var grid = (new SlickGrid([cljs.core.str("#"),cljs.core.str(hatti.views.table.table_id)].join(''),dataview,columns,hatti.views.table.sg_options));
hatti.views.table.bind_external_sg_grid_event_handlers(grid,grid_event_handlers);

hatti.views.table.bind_external_sg_grid_dataview_handlers(dataview,dataview_event_handlers);

grid.setSelectionModel((new Slick.RowSelectionModel(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selectActiveRow,false], null)))));

dataview.onRowCountChanged.subscribe(((function (map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.updateRowCount();

return grid.render();
});})(map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers))
);

dataview.onRowsChanged.subscribe(((function (map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
grid.invalidateRows((args["rows"]));

grid.render();

hatti.views.table.select_rows_marked_to_be_deleted();

return hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
});})(map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onHeaderClick.subscribe(((function (map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(args.column.id,"actions")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(e.target.type,"checkbox"))){
var target = e.target;
var id = target.id;
var checked_QMARK_ = target.checked;
var delete_record_class_selector = [cljs.core.str("."),cljs.core.str(hatti.views.table.delete_record_class)].join('');
var total_rows_count = hatti.views.table.get_elements_count_by_selector(delete_record_class_selector);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hatti.views.table.select_unselect_all_records_id,id)){
var records_to_be_deleted = document.getElementsByClassName(hatti.views.table.delete_record_class);
var seq__38682_38692 = cljs.core.seq(records_to_be_deleted);
var chunk__38683_38693 = null;
var count__38684_38694 = (0);
var i__38685_38695 = (0);
while(true){
if((i__38685_38695 < count__38684_38694)){
var record_38696 = chunk__38683_38693.cljs$core$IIndexed$_nth$arity$2(null,i__38685_38695);
record_38696.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38686 = record_38696.getAttribute("data-id");
return parseInt(G__38686);
})());

var G__38697 = seq__38682_38692;
var G__38698 = chunk__38683_38693;
var G__38699 = count__38684_38694;
var G__38700 = (i__38685_38695 + (1));
seq__38682_38692 = G__38697;
chunk__38683_38693 = G__38698;
count__38684_38694 = G__38699;
i__38685_38695 = G__38700;
continue;
} else {
var temp__4657__auto___38701 = cljs.core.seq(seq__38682_38692);
if(temp__4657__auto___38701){
var seq__38682_38702__$1 = temp__4657__auto___38701;
if(cljs.core.chunked_seq_QMARK_(seq__38682_38702__$1)){
var c__7220__auto___38703 = cljs.core.chunk_first(seq__38682_38702__$1);
var G__38704 = cljs.core.chunk_rest(seq__38682_38702__$1);
var G__38705 = c__7220__auto___38703;
var G__38706 = cljs.core.count(c__7220__auto___38703);
var G__38707 = (0);
seq__38682_38692 = G__38704;
chunk__38683_38693 = G__38705;
count__38684_38694 = G__38706;
i__38685_38695 = G__38707;
continue;
} else {
var record_38708 = cljs.core.first(seq__38682_38702__$1);
record_38708.checked = checked_QMARK_;

hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,(function (){var G__38687 = record_38708.getAttribute("data-id");
return parseInt(G__38687);
})());

var G__38709 = cljs.core.next(seq__38682_38702__$1);
var G__38710 = null;
var G__38711 = (0);
var G__38712 = (0);
seq__38682_38692 = G__38709;
chunk__38683_38693 = G__38710;
count__38684_38694 = G__38711;
i__38685_38695 = G__38712;
continue;
}
} else {
}
}
break;
}

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
if(cljs.core.truth_(checked_QMARK_)){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1(total_rows_count);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});})(records_to_be_deleted,target,id,checked_QMARK_,delete_record_class_selector,total_rows_count,map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
return null;
}
} else {
return null;
}
});})(map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onDblClick.subscribe(((function (map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var rank = (dataview.getItem((args["row"]))[hatti.constants._rank]);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
});})(map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers))
);

grid.onClick.subscribe(((function (map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers){
return (function (e,args){
var elem = e.target;
var class_name = elem.className;
var checked_QMARK_ = elem.checked;
var row = dataview.getItem((args["row"]));
var elem_data_id = elem.getAttribute("data-id");
var data_id = (cljs.core.truth_(elem_data_id)?(function (){var G__38689 = elem.getAttribute("data-id");
return parseInt(G__38689);
})():null);
var id = (row[hatti.constants._id]);
var rank = (row[hatti.constants._rank]);
var select_unselect_all_records_chkbox = document.getElementById(hatti.views.table.select_unselect_all_records_id);
var map__38688 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state));
var map__38688__$1 = ((((!((map__38688 == null)))?((((map__38688.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38688.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38688):map__38688);
var selected_table_rows = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38688__$1,cljs.core.cst$kw$selected_DASH_table_DASH_rows);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(class_name,hatti.views.table.delete_record_class)){
var fn = (cljs.core.truth_(checked_QMARK_)?chimera.seq.add_element:chimera.seq.remove_element);
var row__$1 = (function (){var G__38691 = grid.getCellFromEvent(e).row;
return parseInt(G__38691);
})();
hatti.views.table.update_data_to_be_deleted_vector(checked_QMARK_,data_id);

select_unselect_all_records_chkbox.checked = hatti.views.table.check_select_unselect_all_records_element_QMARK_();

chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_table_DASH_rows], null),((function (fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38688,map__38688__$1,selected_table_rows,map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers){
return (function (){
return (fn.cljs$core$IFn$_invoke$arity$2 ? fn.cljs$core$IFn$_invoke$arity$2(selected_table_rows,row__$1) : fn.call(null,selected_table_rows,row__$1));
});})(fn,row__$1,elem,class_name,checked_QMARK_,row,elem_data_id,data_id,id,rank,select_unselect_all_records_chkbox,map__38688,map__38688__$1,selected_table_rows,map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers))
);

return grid.setSelectedRows(cljs.core.clj__GT_js(cljs.core.cst$kw$selected_DASH_table_DASH_rows.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,data_id)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$submission_DASH_to_DASH_rank,rank], null));
} else {
return null;
}
}
});})(map__38676,map__38676__$1,map__38677,map__38677__$1,map__38678,map__38678__$1,num_displayed_records,total_page_count,hide_actions_column_QMARK_,columns,SlickGrid,DataView,dataview,grid,map__38674,map__38674__$1,grid_event_handlers,dataview_event_handlers))
);

hatti.views.table.init_sg_pager(grid,dataview);

dataview.setPagingOptions(({"pageSize": (function (){var or__6409__auto__ = num_displayed_records;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.default_num_displayed_records;
}
})(), "totalPages": total_page_count}));

dataview.setFilter(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.views.table.filterfn,form));

dataview.setItems(cljs.core.clj__GT_js(data),hatti.constants._id);

hatti.views.table.resizeColumns(grid);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
});
/**
 * Event loop for the table view. Processes a tap of share/event-chan,
 * and updates app-state/dataview/grid as needed.
 */
hatti.views.table.handle_table_events = (function hatti$views$table$handle_table_events(app_state,grid,dataview){
var event_chan = hatti.shared.event_tap();
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__,event_chan){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,event_chan){
return (function (state_39004){
var state_val_39005 = (state_39004[(1)]);
if((state_val_39005 === (7))){
var inst_38902 = (state_39004[(7)]);
var inst_38902__$1 = (state_39004[(2)]);
var inst_38904 = (inst_38902__$1 == null);
var inst_38905 = cljs.core.not(inst_38904);
var state_39004__$1 = (function (){var statearr_39006 = state_39004;
(statearr_39006[(7)] = inst_38902__$1);

return statearr_39006;
})();
if(inst_38905){
var statearr_39007_39082 = state_39004__$1;
(statearr_39007_39082[(1)] = (8));

} else {
var statearr_39008_39083 = state_39004__$1;
(statearr_39008_39083[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (20))){
var inst_38932 = (state_39004[(8)]);
var inst_38924 = (state_39004[(9)]);
var inst_38941 = (inst_38932.cljs$core$IFn$_invoke$arity$1 ? inst_38932.cljs$core$IFn$_invoke$arity$1(inst_38924) : inst_38932.call(null,inst_38924));
var state_39004__$1 = state_39004;
var statearr_39009_39084 = state_39004__$1;
(statearr_39009_39084[(2)] = inst_38941);

(statearr_39009_39084[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (27))){
var state_39004__$1 = state_39004;
var statearr_39010_39085 = state_39004__$1;
(statearr_39010_39085[(2)] = null);

(statearr_39010_39085[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (1))){
var state_39004__$1 = state_39004;
var statearr_39011_39086 = state_39004__$1;
(statearr_39011_39086[(2)] = null);

(statearr_39011_39086[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (24))){
var state_39004__$1 = state_39004;
var statearr_39012_39087 = state_39004__$1;
(statearr_39012_39087[(2)] = null);

(statearr_39012_39087[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (4))){
var state_39004__$1 = state_39004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39004__$1,(7),event_chan);
} else {
if((state_val_39005 === (15))){
var inst_38902 = (state_39004[(7)]);
var state_39004__$1 = state_39004;
var statearr_39013_39088 = state_39004__$1;
(statearr_39013_39088[(2)] = inst_38902);

(statearr_39013_39088[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (21))){
var state_39004__$1 = state_39004;
var statearr_39014_39089 = state_39004__$1;
(statearr_39014_39089[(2)] = null);

(statearr_39014_39089[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (31))){
var inst_38928 = (state_39004[(10)]);
var inst_38977 = (state_39004[(2)]);
var inst_38978 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38928,cljs.core.cst$kw$table);
var state_39004__$1 = (function (){var statearr_39015 = state_39004;
(statearr_39015[(11)] = inst_38977);

return statearr_39015;
})();
if(inst_38978){
var statearr_39016_39090 = state_39004__$1;
(statearr_39016_39090[(1)] = (32));

} else {
var statearr_39017_39091 = state_39004__$1;
(statearr_39017_39091[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (32))){
var inst_38925 = (state_39004[(12)]);
var inst_38926 = (state_39004[(13)]);
var inst_38932 = (state_39004[(8)]);
var inst_38928 = (state_39004[(10)]);
var inst_38922 = (state_39004[(14)]);
var inst_38923 = (state_39004[(15)]);
var inst_38927 = (state_39004[(16)]);
var inst_38933 = (state_39004[(17)]);
var inst_38924 = (state_39004[(9)]);
var inst_38991 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38992 = (function (){var new_columns = inst_38927;
var map__38900 = inst_38922;
var submission_clicked = inst_38924;
var submission_unclicked = inst_38925;
var get_submission_data = inst_38933;
var c__12309__auto____$1 = inst_38991;
var re_render = inst_38928;
var update_data_BANG_ = inst_38932;
var submission_to_rank = inst_38923;
var filter_by = inst_38926;
return ((function (new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38991,state_val_39005,c__12309__auto__,event_chan){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38991,state_val_39005,c__12309__auto__,event_chan){
return (function (state_38989){
var state_val_38990 = (state_38989[(1)]);
if((state_val_38990 === (1))){
var inst_38980 = cljs.core.async.timeout((20));
var state_38989__$1 = state_38989;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38989__$1,(2),inst_38980);
} else {
if((state_val_38990 === (2))){
var inst_38982 = (state_38989[(2)]);
var inst_38983 = grid.resizeCanvas();
var inst_38984 = grid.invalidateAllRows();
var inst_38985 = hatti.views.table.resizeColumns(grid);
var inst_38986 = grid.render();
var inst_38987 = hatti.views.table.init_sg_pager(grid,dataview);
var state_38989__$1 = (function (){var statearr_39018 = state_38989;
(statearr_39018[(7)] = inst_38983);

(statearr_39018[(8)] = inst_38984);

(statearr_39018[(9)] = inst_38986);

(statearr_39018[(10)] = inst_38985);

(statearr_39018[(11)] = inst_38982);

return statearr_39018;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38989__$1,inst_38987);
} else {
return null;
}
}
});})(new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38991,state_val_39005,c__12309__auto__,event_chan))
;
return ((function (switch__12197__auto__,new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38991,state_val_39005,c__12309__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____0 = (function (){
var statearr_39022 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39022[(0)] = hatti$views$table$handle_table_events_$_state_machine__12198__auto__);

(statearr_39022[(1)] = (1));

return statearr_39022;
});
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____1 = (function (state_38989){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_38989);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e39023){if((e39023 instanceof Object)){
var ex__12201__auto__ = e39023;
var statearr_39024_39092 = state_38989;
(statearr_39024_39092[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38989);

return cljs.core.cst$kw$recur;
} else {
throw e39023;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__39093 = state_38989;
state_38989 = G__39093;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = function(state_38989){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____1.call(this,state_38989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38991,state_val_39005,c__12309__auto__,event_chan))
})();
var state__12311__auto__ = (function (){var statearr_39025 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_39025[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto____$1);

return statearr_39025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});
;})(new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38991,state_val_39005,c__12309__auto__,event_chan))
})();
var inst_38993 = cljs.core.async.impl.dispatch.run(inst_38992);
var state_39004__$1 = (function (){var statearr_39026 = state_39004;
(statearr_39026[(18)] = inst_38993);

return statearr_39026;
})();
var statearr_39027_39094 = state_39004__$1;
(statearr_39027_39094[(2)] = inst_38991);

(statearr_39027_39094[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (33))){
var state_39004__$1 = state_39004;
var statearr_39028_39095 = state_39004__$1;
(statearr_39028_39095[(2)] = null);

(statearr_39028_39095[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (13))){
var inst_38914 = (state_39004[(2)]);
var state_39004__$1 = state_39004;
var statearr_39029_39096 = state_39004__$1;
(statearr_39029_39096[(2)] = inst_38914);

(statearr_39029_39096[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (22))){
var inst_38925 = (state_39004[(12)]);
var inst_38944 = (state_39004[(2)]);
var state_39004__$1 = (function (){var statearr_39030 = state_39004;
(statearr_39030[(19)] = inst_38944);

return statearr_39030;
})();
if(cljs.core.truth_(inst_38925)){
var statearr_39031_39097 = state_39004__$1;
(statearr_39031_39097[(1)] = (23));

} else {
var statearr_39032_39098 = state_39004__$1;
(statearr_39032_39098[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (29))){
var inst_38926 = (state_39004[(13)]);
var inst_38969 = [cljs.core.cst$kw$query];
var inst_38970 = [inst_38926];
var inst_38971 = cljs.core.PersistentHashMap.fromArrays(inst_38969,inst_38970);
var inst_38972 = cljs.core.clj__GT_js(inst_38971);
var inst_38973 = dataview.setFilterArgs(inst_38972);
var inst_38974 = dataview.refresh();
var state_39004__$1 = (function (){var statearr_39033 = state_39004;
(statearr_39033[(20)] = inst_38973);

return statearr_39033;
})();
var statearr_39034_39099 = state_39004__$1;
(statearr_39034_39099[(2)] = inst_38974);

(statearr_39034_39099[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (6))){
var inst_39000 = (state_39004[(2)]);
var state_39004__$1 = state_39004;
var statearr_39035_39100 = state_39004__$1;
(statearr_39035_39100[(2)] = inst_39000);

(statearr_39035_39100[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (28))){
var inst_38926 = (state_39004[(13)]);
var inst_38967 = (state_39004[(2)]);
var state_39004__$1 = (function (){var statearr_39036 = state_39004;
(statearr_39036[(21)] = inst_38967);

return statearr_39036;
})();
if(cljs.core.truth_(inst_38926)){
var statearr_39037_39101 = state_39004__$1;
(statearr_39037_39101[(1)] = (29));

} else {
var statearr_39038_39102 = state_39004__$1;
(statearr_39038_39102[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (25))){
var inst_38927 = (state_39004[(16)]);
var inst_38949 = (state_39004[(2)]);
var state_39004__$1 = (function (){var statearr_39039 = state_39004;
(statearr_39039[(22)] = inst_38949);

return statearr_39039;
})();
if(cljs.core.truth_(inst_38927)){
var statearr_39040_39103 = state_39004__$1;
(statearr_39040_39103[(1)] = (26));

} else {
var statearr_39041_39104 = state_39004__$1;
(statearr_39041_39104[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (34))){
var inst_38996 = (state_39004[(2)]);
var state_39004__$1 = (function (){var statearr_39042 = state_39004;
(statearr_39042[(23)] = inst_38996);

return statearr_39042;
})();
var statearr_39043_39105 = state_39004__$1;
(statearr_39043_39105[(2)] = null);

(statearr_39043_39105[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (17))){
var inst_38932 = (state_39004[(8)]);
var inst_38923 = (state_39004[(15)]);
var inst_38933 = (state_39004[(17)]);
var inst_38935 = (inst_38933.cljs$core$IFn$_invoke$arity$2 ? inst_38933.cljs$core$IFn$_invoke$arity$2(hatti.constants._rank,inst_38923) : inst_38933.call(null,hatti.constants._rank,inst_38923));
var inst_38936 = (inst_38932.cljs$core$IFn$_invoke$arity$1 ? inst_38932.cljs$core$IFn$_invoke$arity$1(inst_38935) : inst_38932.call(null,inst_38935));
var state_39004__$1 = state_39004;
var statearr_39044_39106 = state_39004__$1;
(statearr_39044_39106[(2)] = inst_38936);

(statearr_39044_39106[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (3))){
var inst_39002 = (state_39004[(2)]);
var state_39004__$1 = state_39004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39004__$1,inst_39002);
} else {
if((state_val_39005 === (12))){
var state_39004__$1 = state_39004;
var statearr_39045_39107 = state_39004__$1;
(statearr_39045_39107[(2)] = false);

(statearr_39045_39107[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (2))){
var state_39004__$1 = state_39004;
var statearr_39046_39108 = state_39004__$1;
(statearr_39046_39108[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (23))){
var inst_38932 = (state_39004[(8)]);
var inst_38946 = (inst_38932.cljs$core$IFn$_invoke$arity$1 ? inst_38932.cljs$core$IFn$_invoke$arity$1(null) : inst_38932.call(null,null));
var state_39004__$1 = state_39004;
var statearr_39048_39109 = state_39004__$1;
(statearr_39048_39109[(2)] = inst_38946);

(statearr_39048_39109[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (19))){
var inst_38924 = (state_39004[(9)]);
var inst_38939 = (state_39004[(2)]);
var state_39004__$1 = (function (){var statearr_39049 = state_39004;
(statearr_39049[(24)] = inst_38939);

return statearr_39049;
})();
if(cljs.core.truth_(inst_38924)){
var statearr_39050_39110 = state_39004__$1;
(statearr_39050_39110[(1)] = (20));

} else {
var statearr_39051_39111 = state_39004__$1;
(statearr_39051_39111[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (11))){
var state_39004__$1 = state_39004;
var statearr_39052_39112 = state_39004__$1;
(statearr_39052_39112[(2)] = true);

(statearr_39052_39112[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (9))){
var state_39004__$1 = state_39004;
var statearr_39053_39113 = state_39004__$1;
(statearr_39053_39113[(2)] = false);

(statearr_39053_39113[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (5))){
var state_39004__$1 = state_39004;
var statearr_39054_39114 = state_39004__$1;
(statearr_39054_39114[(2)] = null);

(statearr_39054_39114[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (14))){
var inst_38902 = (state_39004[(7)]);
var inst_38919 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38902);
var state_39004__$1 = state_39004;
var statearr_39055_39115 = state_39004__$1;
(statearr_39055_39115[(2)] = inst_38919);

(statearr_39055_39115[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (26))){
var inst_38925 = (state_39004[(12)]);
var inst_38926 = (state_39004[(13)]);
var inst_38932 = (state_39004[(8)]);
var inst_38928 = (state_39004[(10)]);
var inst_38922 = (state_39004[(14)]);
var inst_38923 = (state_39004[(15)]);
var inst_38927 = (state_39004[(16)]);
var inst_38933 = (state_39004[(17)]);
var inst_38924 = (state_39004[(9)]);
var inst_38962 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38963 = (function (){var new_columns = inst_38927;
var map__38900 = inst_38922;
var submission_clicked = inst_38924;
var submission_unclicked = inst_38925;
var get_submission_data = inst_38933;
var c__12309__auto____$1 = inst_38962;
var re_render = inst_38928;
var update_data_BANG_ = inst_38932;
var submission_to_rank = inst_38923;
var filter_by = inst_38926;
return ((function (new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38962,state_val_39005,c__12309__auto__,event_chan){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38962,state_val_39005,c__12309__auto__,event_chan){
return (function (state_38960){
var state_val_38961 = (state_38960[(1)]);
if((state_val_38961 === (1))){
var inst_38951 = cljs.core.async.timeout((20));
var state_38960__$1 = state_38960;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38960__$1,(2),inst_38951);
} else {
if((state_val_38961 === (2))){
var inst_38953 = (state_38960[(2)]);
var inst_38954 = grid.setColumns(new_columns);
var inst_38955 = hatti.views.table.resizeColumns(grid);
var inst_38956 = grid.render();
var inst_38957 = hatti.views.table.select_rows_marked_to_be_deleted();
var inst_38958 = hatti.views.table.higlight_rows_marked_to_be_deleted(grid);
var state_38960__$1 = (function (){var statearr_39056 = state_38960;
(statearr_39056[(7)] = inst_38954);

(statearr_39056[(8)] = inst_38956);

(statearr_39056[(9)] = inst_38955);

(statearr_39056[(10)] = inst_38957);

(statearr_39056[(11)] = inst_38953);

return statearr_39056;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38960__$1,inst_38958);
} else {
return null;
}
}
});})(new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38962,state_val_39005,c__12309__auto__,event_chan))
;
return ((function (switch__12197__auto__,new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38962,state_val_39005,c__12309__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____0 = (function (){
var statearr_39060 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39060[(0)] = hatti$views$table$handle_table_events_$_state_machine__12198__auto__);

(statearr_39060[(1)] = (1));

return statearr_39060;
});
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____1 = (function (state_38960){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_38960);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e39061){if((e39061 instanceof Object)){
var ex__12201__auto__ = e39061;
var statearr_39062_39116 = state_38960;
(statearr_39062_39116[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38960);

return cljs.core.cst$kw$recur;
} else {
throw e39061;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__39117 = state_38960;
state_38960 = G__39117;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = function(state_38960){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____1.call(this,state_38960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38962,state_val_39005,c__12309__auto__,event_chan))
})();
var state__12311__auto__ = (function (){var statearr_39063 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_39063[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto____$1);

return statearr_39063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});
;})(new_columns,map__38900,submission_clicked,submission_unclicked,get_submission_data,c__12309__auto____$1,re_render,update_data_BANG_,submission_to_rank,filter_by,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38933,inst_38924,inst_38962,state_val_39005,c__12309__auto__,event_chan))
})();
var inst_38964 = cljs.core.async.impl.dispatch.run(inst_38963);
var state_39004__$1 = (function (){var statearr_39064 = state_39004;
(statearr_39064[(25)] = inst_38964);

return statearr_39064;
})();
var statearr_39065_39118 = state_39004__$1;
(statearr_39065_39118[(2)] = inst_38962);

(statearr_39065_39118[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (16))){
var inst_38925 = (state_39004[(12)]);
var inst_38926 = (state_39004[(13)]);
var inst_38932 = (state_39004[(8)]);
var inst_38928 = (state_39004[(10)]);
var inst_38922 = (state_39004[(14)]);
var inst_38923 = (state_39004[(15)]);
var inst_38927 = (state_39004[(16)]);
var inst_38924 = (state_39004[(9)]);
var inst_38922__$1 = (state_39004[(2)]);
var inst_38923__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38922__$1,cljs.core.cst$kw$submission_DASH_to_DASH_rank);
var inst_38924__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38922__$1,cljs.core.cst$kw$submission_DASH_clicked);
var inst_38925__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38922__$1,cljs.core.cst$kw$submission_DASH_unclicked);
var inst_38926__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38922__$1,cljs.core.cst$kw$filter_DASH_by);
var inst_38927__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38922__$1,cljs.core.cst$kw$new_DASH_columns);
var inst_38928__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38922__$1,cljs.core.cst$kw$re_DASH_render);
var inst_38929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38930 = [cljs.core.cst$kw$table_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$data];
var inst_38931 = (new cljs.core.PersistentVector(null,3,(5),inst_38929,inst_38930,null));
var inst_38932__$1 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(om.core.update_BANG_,app_state,inst_38931);
var inst_38933 = (function (){var map__38900 = inst_38922__$1;
var submission_to_rank = inst_38923__$1;
var submission_clicked = inst_38924__$1;
var submission_unclicked = inst_38925__$1;
var filter_by = inst_38926__$1;
var new_columns = inst_38927__$1;
var re_render = inst_38928__$1;
var update_data_BANG_ = inst_38932__$1;
return ((function (map__38900,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38924,inst_38922__$1,inst_38923__$1,inst_38924__$1,inst_38925__$1,inst_38926__$1,inst_38927__$1,inst_38928__$1,inst_38929,inst_38930,inst_38931,inst_38932__$1,state_val_39005,c__12309__auto__,event_chan){
return (function (field,value){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__38900,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38924,inst_38922__$1,inst_38923__$1,inst_38924__$1,inst_38925__$1,inst_38926__$1,inst_38927__$1,inst_38928__$1,inst_38929,inst_38930,inst_38931,inst_38932__$1,state_val_39005,c__12309__auto__,event_chan){
return (function (p1__38713_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__38713_SHARP_,field));
});})(map__38900,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38924,inst_38922__$1,inst_38923__$1,inst_38924__$1,inst_38925__$1,inst_38926__$1,inst_38927__$1,inst_38928__$1,inst_38929,inst_38930,inst_38931,inst_38932__$1,state_val_39005,c__12309__auto__,event_chan))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(app_state) : cljs.core.deref.call(null,app_state)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null))));
});
;})(map__38900,submission_to_rank,submission_clicked,submission_unclicked,filter_by,new_columns,re_render,update_data_BANG_,inst_38925,inst_38926,inst_38932,inst_38928,inst_38922,inst_38923,inst_38927,inst_38924,inst_38922__$1,inst_38923__$1,inst_38924__$1,inst_38925__$1,inst_38926__$1,inst_38927__$1,inst_38928__$1,inst_38929,inst_38930,inst_38931,inst_38932__$1,state_val_39005,c__12309__auto__,event_chan))
})();
var state_39004__$1 = (function (){var statearr_39066 = state_39004;
(statearr_39066[(12)] = inst_38925__$1);

(statearr_39066[(13)] = inst_38926__$1);

(statearr_39066[(8)] = inst_38932__$1);

(statearr_39066[(10)] = inst_38928__$1);

(statearr_39066[(14)] = inst_38922__$1);

(statearr_39066[(15)] = inst_38923__$1);

(statearr_39066[(16)] = inst_38927__$1);

(statearr_39066[(17)] = inst_38933);

(statearr_39066[(9)] = inst_38924__$1);

return statearr_39066;
})();
if(cljs.core.truth_(inst_38923__$1)){
var statearr_39067_39119 = state_39004__$1;
(statearr_39067_39119[(1)] = (17));

} else {
var statearr_39068_39120 = state_39004__$1;
(statearr_39068_39120[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (30))){
var state_39004__$1 = state_39004;
var statearr_39069_39121 = state_39004__$1;
(statearr_39069_39121[(2)] = null);

(statearr_39069_39121[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (10))){
var inst_38917 = (state_39004[(2)]);
var state_39004__$1 = state_39004;
if(cljs.core.truth_(inst_38917)){
var statearr_39070_39122 = state_39004__$1;
(statearr_39070_39122[(1)] = (14));

} else {
var statearr_39071_39123 = state_39004__$1;
(statearr_39071_39123[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (18))){
var state_39004__$1 = state_39004;
var statearr_39072_39124 = state_39004__$1;
(statearr_39072_39124[(2)] = null);

(statearr_39072_39124[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39005 === (8))){
var inst_38902 = (state_39004[(7)]);
var inst_38907 = inst_38902.cljs$lang$protocol_mask$partition0$;
var inst_38908 = (inst_38907 & (64));
var inst_38909 = inst_38902.cljs$core$ISeq$;
var inst_38910 = (inst_38908) || (inst_38909);
var state_39004__$1 = state_39004;
if(cljs.core.truth_(inst_38910)){
var statearr_39073_39125 = state_39004__$1;
(statearr_39073_39125[(1)] = (11));

} else {
var statearr_39074_39126 = state_39004__$1;
(statearr_39074_39126[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12309__auto__,event_chan))
;
return ((function (switch__12197__auto__,c__12309__auto__,event_chan){
return (function() {
var hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = null;
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____0 = (function (){
var statearr_39078 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39078[(0)] = hatti$views$table$handle_table_events_$_state_machine__12198__auto__);

(statearr_39078[(1)] = (1));

return statearr_39078;
});
var hatti$views$table$handle_table_events_$_state_machine__12198__auto____1 = (function (state_39004){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_39004);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e39079){if((e39079 instanceof Object)){
var ex__12201__auto__ = e39079;
var statearr_39080_39127 = state_39004;
(statearr_39080_39127[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39004);

return cljs.core.cst$kw$recur;
} else {
throw e39079;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__39128 = state_39004;
state_39004 = G__39128;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$handle_table_events_$_state_machine__12198__auto__ = function(state_39004){
switch(arguments.length){
case 0:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$handle_table_events_$_state_machine__12198__auto____1.call(this,state_39004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____0;
hatti$views$table$handle_table_events_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$handle_table_events_$_state_machine__12198__auto____1;
return hatti$views$table$handle_table_events_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,event_chan))
})();
var state__12311__auto__ = (function (){var statearr_39081 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_39081[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_39081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__,event_chan))
);

return c__12309__auto__;
});
hatti.views.table.render_options = (function hatti$views$table$render_options(options,owner,colset_BANG_){
var choose_display_key = (function (k){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$field_DASH_key,k);

return (colset_BANG_.cljs$core$IFn$_invoke$arity$1 ? colset_BANG_.cljs$core$IFn$_invoke$arity$1(k) : colset_BANG_.call(null,k));
});
var iter__7189__auto__ = ((function (choose_display_key){
return (function hatti$views$table$render_options_$_iter__39147(s__39148){
return (new cljs.core.LazySeq(null,((function (choose_display_key){
return (function (){
var s__39148__$1 = s__39148;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39148__$1);
if(temp__4657__auto__){
var s__39148__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39148__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39148__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39150 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39149 = (0);
while(true){
if((i__39149 < size__7188__auto__)){
var vec__39159 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39149);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39159,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39159,(1),null);
cljs.core.chunk_append(b__39150,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (i__39149,vec__39159,k,v,c__7187__auto__,size__7188__auto__,b__39150,s__39148__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(i__39149,vec__39159,k,v,c__7187__auto__,size__7188__auto__,b__39150,s__39148__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null));

var G__39165 = (i__39149 + (1));
i__39149 = G__39165;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39150),hatti$views$table$render_options_$_iter__39147(cljs.core.chunk_rest(s__39148__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39150),null);
}
} else {
var vec__39162 = cljs.core.first(s__39148__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39162,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39162,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,hatti.utils.click_fn(((function (vec__39162,k,v,s__39148__$2,temp__4657__auto__,choose_display_key){
return (function (){
return choose_display_key(k);
});})(vec__39162,k,v,s__39148__$2,temp__4657__auto__,choose_display_key))
),cljs.core.cst$kw$href,"#"], null),v], null)], null),hatti$views$table$render_options_$_iter__39147(cljs.core.rest(s__39148__$2)));
}
} else {
return null;
}
break;
}
});})(choose_display_key))
,null,null));
});})(choose_display_key))
;
return iter__7189__auto__(options);
});
hatti.views.label_changer.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39167 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRenderState}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IInitState}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39167 = (function (_,owner,meta39168){
this._ = _;
this.owner = owner;
this.meta39168 = meta39168;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39167.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39169,meta39168__$1){
var self__ = this;
var _39169__$1 = this;
return (new hatti.views.table.t_hatti$views$table39167(self__._,self__.owner,meta39168__$1));
});

hatti.views.table.t_hatti$views$table39167.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39169){
var self__ = this;
var _39169__$1 = this;
return self__.meta39168;
});

hatti.views.table.t_hatti$views$table39167.prototype.om$core$IInitState$ = true;

hatti.views.table.t_hatti$views$table39167.prototype.om$core$IInitState$init_state$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$field_DASH_key,cljs.core.cst$kw$label], null);
});

hatti.views.table.t_hatti$views$table39167.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39167.prototype.om$core$IRenderState$render_state$arity$2 = (function (___$1,p__39170){
var self__ = this;
var map__39171 = p__39170;
var map__39171__$1 = ((((!((map__39171 == null)))?((((map__39171.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39171.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39171):map__39171);
var field_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39171__$1,cljs.core.cst$kw$field_DASH_key);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39171__$1,cljs.core.cst$kw$language);
var ___$2 = this;
var options = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Label"], null),cljs.core.cst$kw$name,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Name"], null)], null);
var map__39173 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39173__$1 = ((((!((map__39173 == null)))?((((map__39173.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39173.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39173):map__39173);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39173__$1,cljs.core.cst$kw$flat_DASH_form);
var new_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(self__.owner,hatti.shared.language_cursor()));
var colset_BANG_ = ((function (options,map__39173,map__39173__$1,flat_form,new_language,___$2,map__39171,map__39171__$1,field_key,language){
return (function (p1__39166_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$new_DASH_columns,hatti.views.table.flat_form__GT_sg_columns.cljs$core$IFn$_invoke$arity$variadic(flat_form,cljs.core.array_seq([cljs.core.cst$kw$get_DASH_label_QMARK_,cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$label,p1__39166_SHARP_),cljs.core.cst$kw$language,new_language], 0))], null));
});})(options,map__39173,map__39173__$1,flat_form,new_language,___$2,map__39171,map__39171__$1,field_key,language))
;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new_language,language)){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(self__.owner,cljs.core.cst$kw$language,new_language);

colset_BANG_(field_key);
} else {
}

var G__39183 = ({"className": "label-changer"});
var G__39184 = (function (){var G__39186 = ({"className": "label-changer-label"});
var G__39187 = "Show:";
return React.DOM.span(G__39186,G__39187);
})();
var G__39185 = (function (){var G__39188 = ({"id": "header-display-dropdown", "className": "drop-hover"});
var G__39189 = (function (){var attrs39177 = (options.cljs$core$IFn$_invoke$arity$1 ? options.cljs$core$IFn$_invoke$arity$1(field_key) : options.call(null,field_key));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39177))?sablono.interpreter.attributes(attrs39177):null),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39177))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39191 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39191);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39177),(function (){var G__39192 = ({"className": "fa fa-angle-down"});
return React.DOM.i(G__39192);
})()], null))));
})();
var G__39190 = (function (){var attrs39182 = hatti.views.table.render_options(options,self__.owner,colset_BANG_);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.ul,((cljs.core.map_QMARK_(attrs39182))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submenu","no-dot"], null)], null),attrs39182], 0))):({"className": "submenu no-dot"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39182))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39182)], null))));
})();
return React.DOM.div(G__39188,G__39189,G__39190);
})();
return React.DOM.div(G__39183,G__39184,G__39185);
});

hatti.views.table.t_hatti$views$table39167.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39168], null);
});

hatti.views.table.t_hatti$views$table39167.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39167.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39167";

hatti.views.table.t_hatti$views$table39167.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39167");
});

hatti.views.table.__GT_t_hatti$views$table39167 = (function hatti$views$table$__GT_t_hatti$views$table39167(___$1,owner__$1,meta39168){
return (new hatti.views.table.t_hatti$views$table39167(___$1,owner__$1,meta39168));
});

}

return (new hatti.views.table.t_hatti$views$table39167(_,owner,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Delayed search fires a query-event on event-chan if the value of the input
 * doesn't change within 150 ms (ie, user is still typing).
 * Call on-change or on-key-up, with (.-target event) as first argument.
 */
hatti.views.table.delayed_search = (function hatti$views$table$delayed_search(input,query_event_key){
var query = input.value;
var c__12309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12309__auto__,query){
return (function (){
var f__12310__auto__ = (function (){var switch__12197__auto__ = ((function (c__12309__auto__,query){
return (function (state_39235){
var state_val_39236 = (state_39235[(1)]);
if((state_val_39236 === (1))){
var inst_39221 = cljs.core.async.timeout((150));
var state_39235__$1 = state_39235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39235__$1,(2),inst_39221);
} else {
if((state_val_39236 === (2))){
var inst_39223 = (state_39235[(2)]);
var inst_39224 = input.value;
var inst_39225 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query,inst_39224);
var state_39235__$1 = (function (){var statearr_39237 = state_39235;
(statearr_39237[(7)] = inst_39223);

return statearr_39237;
})();
if(inst_39225){
var statearr_39238_39249 = state_39235__$1;
(statearr_39238_39249[(1)] = (3));

} else {
var statearr_39239_39250 = state_39235__$1;
(statearr_39239_39250[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39236 === (3))){
var inst_39227 = [query_event_key];
var inst_39228 = [query];
var inst_39229 = cljs.core.PersistentHashMap.fromArrays(inst_39227,inst_39228);
var inst_39230 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,inst_39229);
var state_39235__$1 = state_39235;
var statearr_39240_39251 = state_39235__$1;
(statearr_39240_39251[(2)] = inst_39230);

(statearr_39240_39251[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39236 === (4))){
var state_39235__$1 = state_39235;
var statearr_39241_39252 = state_39235__$1;
(statearr_39241_39252[(2)] = null);

(statearr_39241_39252[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39236 === (5))){
var inst_39233 = (state_39235[(2)]);
var state_39235__$1 = state_39235;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39235__$1,inst_39233);
} else {
return null;
}
}
}
}
}
});})(c__12309__auto__,query))
;
return ((function (switch__12197__auto__,c__12309__auto__,query){
return (function() {
var hatti$views$table$delayed_search_$_state_machine__12198__auto__ = null;
var hatti$views$table$delayed_search_$_state_machine__12198__auto____0 = (function (){
var statearr_39245 = [null,null,null,null,null,null,null,null];
(statearr_39245[(0)] = hatti$views$table$delayed_search_$_state_machine__12198__auto__);

(statearr_39245[(1)] = (1));

return statearr_39245;
});
var hatti$views$table$delayed_search_$_state_machine__12198__auto____1 = (function (state_39235){
while(true){
var ret_value__12199__auto__ = (function (){try{while(true){
var result__12200__auto__ = switch__12197__auto__(state_39235);
if(cljs.core.keyword_identical_QMARK_(result__12200__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12200__auto__;
}
break;
}
}catch (e39246){if((e39246 instanceof Object)){
var ex__12201__auto__ = e39246;
var statearr_39247_39253 = state_39235;
(statearr_39247_39253[(5)] = ex__12201__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39235);

return cljs.core.cst$kw$recur;
} else {
throw e39246;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12199__auto__,cljs.core.cst$kw$recur)){
var G__39254 = state_39235;
state_39235 = G__39254;
continue;
} else {
return ret_value__12199__auto__;
}
break;
}
});
hatti$views$table$delayed_search_$_state_machine__12198__auto__ = function(state_39235){
switch(arguments.length){
case 0:
return hatti$views$table$delayed_search_$_state_machine__12198__auto____0.call(this);
case 1:
return hatti$views$table$delayed_search_$_state_machine__12198__auto____1.call(this,state_39235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hatti$views$table$delayed_search_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$0 = hatti$views$table$delayed_search_$_state_machine__12198__auto____0;
hatti$views$table$delayed_search_$_state_machine__12198__auto__.cljs$core$IFn$_invoke$arity$1 = hatti$views$table$delayed_search_$_state_machine__12198__auto____1;
return hatti$views$table$delayed_search_$_state_machine__12198__auto__;
})()
;})(switch__12197__auto__,c__12309__auto__,query))
})();
var state__12311__auto__ = (function (){var statearr_39248 = (f__12310__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12310__auto__.cljs$core$IFn$_invoke$arity$0() : f__12310__auto__.call(null));
(statearr_39248[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12309__auto__);

return statearr_39248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12311__auto__);
});})(c__12309__auto__,query))
);

return c__12309__auto__;
});
hatti.views.table_search.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,owner){
if(typeof hatti.views.table.t_hatti$views$table39256 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39256 = (function (_,owner,meta39257){
this._ = _;
this.owner = owner;
this.meta39257 = meta39257;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39256.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39258,meta39257__$1){
var self__ = this;
var _39258__$1 = this;
return (new hatti.views.table.t_hatti$views$table39256(self__._,self__.owner,meta39257__$1));
});

hatti.views.table.t_hatti$views$table39256.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39258){
var self__ = this;
var _39258__$1 = this;
return self__.meta39257;
});

hatti.views.table.t_hatti$views$table39256.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39256.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
var G__39261 = ({"className": "table-search"});
var G__39262 = (function (){var G__39264 = ({"className": "fa fa-search"});
return React.DOM.i(G__39264);
})();
var G__39263 = (function (){var G__39265 = ({"type": "text", "placeholder": "Search", "onChange": ((function (G__39261,G__39262,this__18254__auto____$1){
return (function (p1__39255_SHARP_){
return hatti.views.table.delayed_search(p1__39255_SHARP_.target,cljs.core.cst$kw$filter_DASH_by);
});})(G__39261,G__39262,this__18254__auto____$1))
});
return (sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1 ? sablono.interpreter.input.cljs$core$IFn$_invoke$arity$1(G__39265) : sablono.interpreter.input.call(null,G__39265));
})();
return React.DOM.div(G__39261,G__39262,G__39263);
});

hatti.views.table.t_hatti$views$table39256.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39257], null);
});

hatti.views.table.t_hatti$views$table39256.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39256.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39256";

hatti.views.table.t_hatti$views$table39256.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39256");
});

hatti.views.table.__GT_t_hatti$views$table39256 = (function hatti$views$table$__GT_t_hatti$views$table39256(___$1,owner__$1,meta39257){
return (new hatti.views.table.t_hatti$views$table39256(___$1,owner__$1,meta39257));
});

}

return (new hatti.views.table.t_hatti$views$table39256(_,owner,null));
}));
hatti.views.table_header.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.table.t_hatti$views$table39266 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39266 = (function (cursor,owner,meta39267){
this.cursor = cursor;
this.owner = owner;
this.meta39267 = meta39267;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39266.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39268,meta39267__$1){
var self__ = this;
var _39268__$1 = this;
return (new hatti.views.table.t_hatti$views$table39266(self__.cursor,self__.owner,meta39267__$1));
});

hatti.views.table.t_hatti$views$table39266.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39268){
var self__ = this;
var _39268__$1 = this;
return self__.meta39267;
});

hatti.views.table.t_hatti$views$table39266.prototype.om$core$IRender$ = true;

hatti.views.table.t_hatti$views$table39266.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
var G__39271 = ({"className": "topbar"});
var G__39272 = (function (){var G__39276 = ({"id": hatti.views.table.pager_id});
return React.DOM.div(G__39276);
})();
var G__39273 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.label_changer,self__.cursor));
var G__39274 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_search,self__.cursor));
var G__39275 = (function (){var G__39277 = ({"style": ({"clear": "both"})});
return React.DOM.div(G__39277);
})();
return React.DOM.div(G__39271,G__39272,G__39273,G__39274,G__39275);
});

hatti.views.table.t_hatti$views$table39266.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39267], null);
});

hatti.views.table.t_hatti$views$table39266.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39266.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39266";

hatti.views.table.t_hatti$views$table39266.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39266");
});

hatti.views.table.__GT_t_hatti$views$table39266 = (function hatti$views$table$__GT_t_hatti$views$table39266(cursor__$1,owner__$1,meta39267){
return (new hatti.views.table.t_hatti$views$table39266(cursor__$1,owner__$1,meta39267));
});

}

return (new hatti.views.table.t_hatti$views$table39266(cursor,owner,null));
}));
/**
 * Initializes grid + dataview, and stores them in owner's state.
 */
hatti.views.table.init_grid_BANG_ = (function hatti$views$table$init_grid_BANG_(data,owner,slick_grid_event_handlers){
if(cljs.core.seq(data)){
var map__39283 = om.core.get_shared.cljs$core$IFn$_invoke$arity$1(owner);
var map__39283__$1 = ((((!((map__39283 == null)))?((((map__39283.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39283.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39283):map__39283);
var flat_form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39283__$1,cljs.core.cst$kw$flat_DASH_form);
var current_language = cljs.core.cst$kw$current.cljs$core$IFn$_invoke$arity$1(om.core.observe(owner,hatti.shared.language_cursor()));
var vec__39284 = hatti.views.table.sg_init(data,flat_form,current_language,owner,slick_grid_event_handlers);
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39284,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39284,(1),null);
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$grid,grid);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$dataview,dataview);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [grid,dataview], null);
} else {
return null;
}
});
hatti.views.table.get_table_view_height = (function hatti$views$table$get_table_view_height(){
return (document.querySelector("body").clientHeight - document.querySelector(".tab-page").getBoundingClientRect().top);
});
hatti.views.table.set_window_resize_handler = (function hatti$views$table$set_window_resize_handler(owner){
var resize_handler = (function (event){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$table_DASH_view_DASH_height,hatti.views.table.get_table_view_height());
});
window.addEventListener("resize",resize_handler);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$resize_DASH_handler,resize_handler);
});
hatti.views.table_page.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39289,owner,p__39290){
var map__39291 = p__39289;
var map__39291__$1 = ((((!((map__39291 == null)))?((((map__39291.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39291.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39291):map__39291);
var cursor = map__39291__$1;
var map__39292 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39291__$1,cljs.core.cst$kw$views);
var map__39292__$1 = ((((!((map__39292 == null)))?((((map__39292.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39292.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39292):map__39292);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39292__$1,cljs.core.cst$kw$active);
var map__39293 = p__39290;
var map__39293__$1 = ((((!((map__39293 == null)))?((((map__39293.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39293.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39293):map__39293);
var opts = map__39293__$1;
var slick_grid_event_handlers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39293__$1,cljs.core.cst$kw$slick_DASH_grid_DASH_event_DASH_handlers);

var active_QMARK_ = chimera.seq.in_QMARK_(active,cljs.core.cst$kw$table);
if(typeof hatti.views.table.t_hatti$views$table39297 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IWillUnmount}
 * @implements {om.core.IRenderState}
 * @implements {om.core.IWillReceiveProps}
 * @implements {cljs.core.IMeta}
 * @implements {om.core.IDidMount}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.table.t_hatti$views$table39297 = (function (p__39289,owner,active_QMARK_,p__39290,map__39293,slick_grid_event_handlers,cursor,active,map__39292,opts,map__39291,meta39298){
this.p__39289 = p__39289;
this.owner = owner;
this.active_QMARK_ = active_QMARK_;
this.p__39290 = p__39290;
this.map__39293 = map__39293;
this.slick_grid_event_handlers = slick_grid_event_handlers;
this.cursor = cursor;
this.active = active;
this.map__39292 = map__39292;
this.opts = opts;
this.map__39291 = map__39291;
this.meta39298 = meta39298;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.table.t_hatti$views$table39297.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers){
return (function (_39299,meta39298__$1){
var self__ = this;
var _39299__$1 = this;
return (new hatti.views.table.t_hatti$views$table39297(self__.p__39289,self__.owner,self__.active_QMARK_,self__.p__39290,self__.map__39293,self__.slick_grid_event_handlers,self__.cursor,self__.active,self__.map__39292,self__.opts,self__.map__39291,meta39298__$1));
});})(active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39297.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers){
return (function (_39299){
var self__ = this;
var _39299__$1 = this;
return self__.meta39298;
});})(active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39297.prototype.om$core$IRenderState$ = true;

hatti.views.table.t_hatti$views$table39297.prototype.om$core$IRenderState$render_state$arity$2 = ((function (active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers){
return (function (_,p__39300){
var self__ = this;
var map__39301 = p__39300;
var map__39301__$1 = ((((!((map__39301 == null)))?((((map__39301.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39301.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39301):map__39301);
var table_view_height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39301__$1,cljs.core.cst$kw$table_DASH_view_DASH_height);
var ___$1 = this;
var map__39303 = self__.cursor;
var map__39303__$1 = ((((!((map__39303 == null)))?((((map__39303.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39303.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39303):map__39303);
var map__39304 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39303__$1,cljs.core.cst$kw$table_DASH_page);
var map__39304__$1 = ((((!((map__39304 == null)))?((((map__39304.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39304.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39304):map__39304);
var prevent_scrolling_in_table_view_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39304__$1,cljs.core.cst$kw$prevent_DASH_scrolling_DASH_in_DASH_table_DASH_view_QMARK_);
var submission_clicked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39304__$1,cljs.core.cst$kw$submission_DASH_clicked);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39303__$1,cljs.core.cst$kw$data);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39303__$1,cljs.core.cst$kw$dataset_DASH_info);
var map__39305 = dataset_info;
var map__39305__$1 = ((((!((map__39305 == null)))?((((map__39305.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39305.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39305):map__39305);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39305__$1,cljs.core.cst$kw$num_of_submissions);
var no_data_QMARK_ = cljs.core.empty_QMARK_(data);
var with_info = ((function (map__39303,map__39303__$1,map__39304,map__39304__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__39305,map__39305__$1,num_of_submissions,no_data_QMARK_,___$1,map__39301,map__39301__$1,table_view_height,active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers){
return (function (p1__39288_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.cursor,p1__39288_SHARP_], 0));
});})(map__39303,map__39303__$1,map__39304,map__39304__$1,prevent_scrolling_in_table_view_QMARK_,submission_clicked,data,dataset_info,map__39305,map__39305__$1,num_of_submissions,no_data_QMARK_,___$1,map__39301,map__39301__$1,table_view_height,active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers))
;
if(cljs.core.truth_(self__.active_QMARK_)){
var G__39309 = ({"style": cljs.core.clj__GT_js((cljs.core.truth_(prevent_scrolling_in_table_view_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$height,(function (){var or__6409__auto__ = table_view_height;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.views.table.get_table_view_height();
}
})(),cljs.core.cst$kw$overflow,"hidden"], null):null)), "className": "table-view"});
var G__39310 = sablono.interpreter.interpret((cljs.core.truth_(cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(submission_clicked))?om.core.build.cljs$core$IFn$_invoke$arity$3(hatti.views.submission_view,with_info(submission_clicked),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.select_keys(self__.opts,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,null,cljs.core.cst$kw$delete_DASH_record_BANG_,null], null), null)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$view,cljs.core.cst$kw$table], null)], 0))], null)):null));
var G__39311 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.table_header,self__.cursor));
var G__39312 = (function (){var G__39313 = ({"id": hatti.views.table.table_id, "className": "slickgrid"});
var G__39314 = (((no_data_QMARK_) && ((num_of_submissions === (0))))?(function (){var G__39319 = ({"className": "alert alert-warning"});
var G__39320 = "No data";
return React.DOM.p(G__39319,G__39320);
})():(function (){var G__39321 = null;
var G__39322 = (function (){var G__39324 = ({"className": "fa fa-spinner fa-pulse"});
return React.DOM.i(G__39324);
})();
var G__39323 = "Loading...";
return React.DOM.span(G__39321,G__39322,G__39323);
})());
return React.DOM.div(G__39313,G__39314);
})();
return React.DOM.div(G__39309,G__39310,G__39311,G__39312);
} else {
return null;
}
});})(active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39297.prototype.om$core$IDidMount$ = true;

hatti.views.table.t_hatti$views$table39297.prototype.om$core$IDidMount$did_mount$arity$1 = ((function (active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.active_QMARK_)){
hatti.views.table.set_window_resize_handler(self__.owner);

var data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.cursor,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39325 = temp__4657__auto__;
var grid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39325,(0),null);
var dataview = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39325,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid,dataview);
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39297.prototype.om$core$IWillUnmount$ = true;

hatti.views.table.t_hatti$views$table39297.prototype.om$core$IWillUnmount$will_unmount$arity$1 = ((function (active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers){
return (function (_){
var self__ = this;
var ___$1 = this;
return window.removeEventListener("resize",om.core.get_state.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$resize_DASH_handler));
});})(active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39297.prototype.om$core$IWillReceiveProps$ = true;

hatti.views.table.t_hatti$views$table39297.prototype.om$core$IWillReceiveProps$will_receive_props$arity$2 = ((function (active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers){
return (function (_,next_props){
var self__ = this;
var ___$1 = this;

if(cljs.core.truth_(self__.active_QMARK_)){
var old_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(om.core.get_props.cljs$core$IFn$_invoke$arity$1(self__.owner),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var new_data = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(next_props,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$data], null));
var map__39328 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(self__.owner);
var map__39328__$1 = ((((!((map__39328 == null)))?((((map__39328.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39328.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39328):map__39328);
var grid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39328__$1,cljs.core.cst$kw$grid);
var dataview = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39328__$1,cljs.core.cst$kw$dataview);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_data,new_data)){
if(cljs.core.empty_QMARK_(old_data)){
var temp__4657__auto__ = hatti.views.table.init_grid_BANG_(new_data,self__.owner,self__.slick_grid_event_handlers);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__39330 = temp__4657__auto__;
var grid__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39330,(0),null);
var dataview__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39330,(1),null);
return hatti.views.table.handle_table_events(self__.cursor,grid__$1,dataview__$1);
} else {
return null;
}
} else {
grid.invalidateAllRows();

dataview.setItems(cljs.core.clj__GT_js(new_data),hatti.constants._id);

return grid.render();
}
} else {
return null;
}
} else {
return null;
}
});})(active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39297.getBasis = ((function (active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers){
return (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__39289,cljs.core.cst$sym$owner,cljs.core.cst$sym$active_QMARK_,cljs.core.cst$sym$p__39290,cljs.core.cst$sym$map__39293,cljs.core.cst$sym$slick_DASH_grid_DASH_event_DASH_handlers,cljs.core.cst$sym$cursor,cljs.core.cst$sym$active,cljs.core.cst$sym$map__39292,cljs.core.cst$sym$opts,cljs.core.cst$sym$map__39291,cljs.core.cst$sym$meta39298], null);
});})(active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.t_hatti$views$table39297.cljs$lang$type = true;

hatti.views.table.t_hatti$views$table39297.cljs$lang$ctorStr = "hatti.views.table/t_hatti$views$table39297";

hatti.views.table.t_hatti$views$table39297.cljs$lang$ctorPrWriter = ((function (active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.table/t_hatti$views$table39297");
});})(active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers))
;

hatti.views.table.__GT_t_hatti$views$table39297 = ((function (active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers){
return (function hatti$views$table$__GT_t_hatti$views$table39297(p__39289__$1,owner__$1,active_QMARK___$1,p__39290__$1,map__39293__$2,slick_grid_event_handlers__$1,cursor__$1,active__$1,map__39292__$2,opts__$1,map__39291__$2,meta39298){
return (new hatti.views.table.t_hatti$views$table39297(p__39289__$1,owner__$1,active_QMARK___$1,p__39290__$1,map__39293__$2,slick_grid_event_handlers__$1,cursor__$1,active__$1,map__39292__$2,opts__$1,map__39291__$2,meta39298));
});})(active_QMARK_,map__39291,map__39291__$1,cursor,map__39292,map__39292__$1,active,map__39293,map__39293__$1,opts,slick_grid_event_handlers))
;

}

return (new hatti.views.table.t_hatti$views$table39297(p__39289,owner,active_QMARK_,p__39290,map__39293__$1,slick_grid_event_handlers,cursor,active,map__39292__$1,opts,map__39291__$1,cljs.core.PersistentArrayMap.EMPTY));
}));
