// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.views.dataview');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('chimera.om.state');
goog.require('hatti.views.photos');
goog.require('sablono.core');
goog.require('hatti.views.user_guide');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.views.map');
goog.require('hatti.views.chart');
goog.require('hatti.views.report_view');
goog.require('hatti.shared');
goog.require('chimera.metrics');
goog.require('hatti.views.saved_charts');
goog.require('hatti.ona.forms');
goog.require('hatti.constants');
goog.require('hatti.views');
goog.require('hatti.views.settings');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('hatti.views.overview');
goog.require('hatti.views.table');
hatti.views.dataview.dataview_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$table,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$settings,cljs.core.cst$kw$overview,cljs.core.cst$kw$chart,cljs.core.cst$kw$photos,cljs.core.cst$kw$map],[new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$user_DASH_guide,cljs.core.cst$kw$label,"User Guide",cljs.core.cst$kw$component,hatti.views.user_guide_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$table,cljs.core.cst$kw$label,"Table",cljs.core.cst$kw$component,hatti.views.table_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$report_DASH_view,cljs.core.cst$kw$label,"Reports",cljs.core.cst$kw$component,hatti.views.report_view_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$saved_DASH_charts,cljs.core.cst$kw$label,"Dashboard",cljs.core.cst$kw$component,hatti.views.saved_charts_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$settings,cljs.core.cst$kw$label,"Settings",cljs.core.cst$kw$component,hatti.views.settings_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$overview,cljs.core.cst$kw$label,"Overview",cljs.core.cst$kw$component,hatti.views.overview_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$chart,cljs.core.cst$kw$label,"Charts",cljs.core.cst$kw$component,hatti.views.chart_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$photos,cljs.core.cst$kw$label,"Photos",cljs.core.cst$kw$component,hatti.views.photos_page], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$view,cljs.core.cst$kw$map,cljs.core.cst$kw$label,"Map",cljs.core.cst$kw$component,hatti.views.map_page], null)]);
/**
 * Initial Dataview State
 */
hatti.views.dataview.default_dataviews = (function hatti$views$dataview$default_dataviews(){
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.dataview_map) : cljs.core.atom.call(null,hatti.views.dataview.dataview_map));
});
hatti.views.dataview.view_state = hatti.views.dataview.default_dataviews();
/**
 * Build and set the tooltips for inactive views based on why they are
 * inactive.
 */
hatti.views.dataview.view__GT_inactive_tab = (function hatti$views$dataview$view__GT_inactive_tab(view,label,is_encrypted_QMARK_,not_within_pricing_limits_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$inactive,[cljs.core.str(label),cljs.core.str(" ")].join(''),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tooltip,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_info$tooltip,(cljs.core.truth_(is_encrypted_QMARK_)?"This tab is disabled because this form is encrypted.":(cljs.core.truth_(not_within_pricing_limits_QMARK_)?"This tab is disabled because you are over the pricing limits.":(function (){var pred__39348 = cljs.core._EQ_;
var expr__39349 = view;
if(cljs.core.truth_((function (){var G__39351 = cljs.core.cst$kw$map;
var G__39352 = expr__39349;
return (pred__39348.cljs$core$IFn$_invoke$arity$2 ? pred__39348.cljs$core$IFn$_invoke$arity$2(G__39351,G__39352) : pred__39348.call(null,G__39351,G__39352));
})())){
return [cljs.core.str("The Map tab is disabled because this form "),cljs.core.str("has no location questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39353 = cljs.core.cst$kw$photos;
var G__39354 = expr__39349;
return (pred__39348.cljs$core$IFn$_invoke$arity$2 ? pred__39348.cljs$core$IFn$_invoke$arity$2(G__39353,G__39354) : pred__39348.call(null,G__39353,G__39354));
})())){
return [cljs.core.str("The Photos tab is disabled because this form has no "),cljs.core.str("photo questions.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39355 = cljs.core.cst$kw$table;
var G__39356 = expr__39349;
return (pred__39348.cljs$core$IFn$_invoke$arity$2 ? pred__39348.cljs$core$IFn$_invoke$arity$2(G__39355,G__39356) : pred__39348.call(null,G__39355,G__39356));
})())){
return [cljs.core.str("The table tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39357 = cljs.core.cst$kw$chart;
var G__39358 = expr__39349;
return (pred__39348.cljs$core$IFn$_invoke$arity$2 ? pred__39348.cljs$core$IFn$_invoke$arity$2(G__39357,G__39358) : pred__39348.call(null,G__39357,G__39358));
})())){
return [cljs.core.str("The charts tab is disabled because you do not have "),cljs.core.str("permission to view it.")].join('');
} else {
if(cljs.core.truth_((function (){var G__39359 = cljs.core.cst$kw$saved_DASH_charts;
var G__39360 = expr__39349;
return (pred__39348.cljs$core$IFn$_invoke$arity$2 ? pred__39348.cljs$core$IFn$_invoke$arity$2(G__39359,G__39360) : pred__39348.call(null,G__39359,G__39360));
})())){
return [cljs.core.str("The dashboards tab is disabled because "),cljs.core.str("you do not have permission to view it.")].join('');
} else {
return "This tab is disabled.";
}
}
}
}
}
})()
))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tip_DASH_question,"?"], null)], null)], null);
});
hatti.views.dataview_actions.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (cursor,owner){
if(typeof hatti.views.dataview.t_hatti$views$dataview39361 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39361 = (function (cursor,owner,meta39362){
this.cursor = cursor;
this.owner = owner;
this.meta39362 = meta39362;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39361.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39363,meta39362__$1){
var self__ = this;
var _39363__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39361(self__.cursor,self__.owner,meta39362__$1));
});

hatti.views.dataview.t_hatti$views$dataview39361.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39363){
var self__ = this;
var _39363__$1 = this;
return self__.meta39362;
});

hatti.views.dataview.t_hatti$views$dataview39361.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39361.prototype.om$core$IRender$render$arity$1 = (function (this__18254__auto__){
var self__ = this;
var this__18254__auto____$1 = this;
return null;
});

hatti.views.dataview.t_hatti$views$dataview39361.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cursor,cljs.core.cst$sym$owner,cljs.core.cst$sym$meta39362], null);
});

hatti.views.dataview.t_hatti$views$dataview39361.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39361.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39361";

hatti.views.dataview.t_hatti$views$dataview39361.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39361");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39361 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39361(cursor__$1,owner__$1,meta39362){
return (new hatti.views.dataview.t_hatti$views$dataview39361(cursor__$1,owner__$1,meta39362));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39361(cursor,owner,null));
}));
hatti.views.dataview_infobar.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (p__39364,owner){
var map__39365 = p__39364;
var map__39365__$1 = ((((!((map__39365 == null)))?((((map__39365.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39365.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39365):map__39365);
var dataset_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39365__$1,cljs.core.cst$kw$dataset_DASH_info);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39365__$1,cljs.core.cst$kw$status);
if(typeof hatti.views.dataview.t_hatti$views$dataview39367 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {om.core.IWillMount}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39367 = (function (p__39364,owner,map__39365,dataset_info,status,meta39368){
this.p__39364 = p__39364;
this.owner = owner;
this.map__39365 = map__39365;
this.dataset_info = dataset_info;
this.status = status;
this.meta39368 = meta39368;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39367.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__39365,map__39365__$1,dataset_info,status){
return (function (_39369,meta39368__$1){
var self__ = this;
var _39369__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39367(self__.p__39364,self__.owner,self__.map__39365,self__.dataset_info,self__.status,meta39368__$1));
});})(map__39365,map__39365__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39367.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__39365,map__39365__$1,dataset_info,status){
return (function (_39369){
var self__ = this;
var _39369__$1 = this;
return self__.meta39368;
});})(map__39365,map__39365__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39367.prototype.om$core$IWillMount$ = true;

hatti.views.dataview.t_hatti$views$dataview39367.prototype.om$core$IWillMount$will_mount$arity$1 = ((function (map__39365,map__39365__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
return hatti.shared.maybe_merge_languages_BANG_(om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form));
});})(map__39365,map__39365__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39367.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39367.prototype.om$core$IRender$render$arity$1 = ((function (map__39365,map__39365__$1,dataset_info,status){
return (function (_){
var self__ = this;
var ___$1 = this;
var form = om.core.get_shared.cljs$core$IFn$_invoke$arity$2(self__.owner,cljs.core.cst$kw$flat_DASH_form);
var map__39370 = self__.dataset_info;
var map__39370__$1 = ((((!((map__39370 == null)))?((((map__39370.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39370.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39370):map__39370);
var num_of_submissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39370__$1,cljs.core.cst$kw$num_of_submissions);
var formid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39370__$1,cljs.core.cst$kw$formid);
var map__39371 = self__.status;
var map__39371__$1 = ((((!((map__39371 == null)))?((((map__39371.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39371.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39371):map__39371);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39371__$1,cljs.core.cst$kw$loading_QMARK_);
var total_records = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39371__$1,cljs.core.cst$kw$total_DASH_records);
var G__39378 = ({"className": "right rec-summary rec-margin"});
var G__39379 = (function (){var attrs39374 = (cljs.core.truth_(hatti.ona.forms.multilingual_QMARK_(form))?om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.shared.language_selector,null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39374))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"language-selector"], null),attrs39374], 0))):({"id": "language-selector"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39374))?cljs.core.PersistentVector.EMPTY:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39374)], null))));
})();
var G__39380 = (function (){var G__39383 = ({"id": "data-status"});
var G__39384 = (function (){var attrs39375 = (cljs.core.truth_(loading_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_spinner$fa_DASH_pulse], null):null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.span,((cljs.core.map_QMARK_(attrs39375))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["rec"], null)], null),attrs39375], 0))):({"className": "rec"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39375))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39375),sablono.interpreter.interpret(hatti.utils.pluralize_number(num_of_submissions," Record"))], null))));
})();
return React.DOM.div(G__39383,G__39384);
})();
var G__39381 = (function (){var G__39385 = ({"className": "divider"});
return React.DOM.div(G__39385);
})();
var G__39382 = sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_actions,formid));
return React.DOM.div(G__39378,G__39379,G__39380,G__39381,G__39382);
});})(map__39365,map__39365__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39367.getBasis = ((function (map__39365,map__39365__$1,dataset_info,status){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p__39364,cljs.core.cst$sym$owner,cljs.core.cst$sym$map__39365,cljs.core.cst$sym$dataset_DASH_info,cljs.core.cst$sym$status,cljs.core.cst$sym$meta39368], null);
});})(map__39365,map__39365__$1,dataset_info,status))
;

hatti.views.dataview.t_hatti$views$dataview39367.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39367.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39367";

hatti.views.dataview.t_hatti$views$dataview39367.cljs$lang$ctorPrWriter = ((function (map__39365,map__39365__$1,dataset_info,status){
return (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39367");
});})(map__39365,map__39365__$1,dataset_info,status))
;

hatti.views.dataview.__GT_t_hatti$views$dataview39367 = ((function (map__39365,map__39365__$1,dataset_info,status){
return (function hatti$views$dataview$__GT_t_hatti$views$dataview39367(p__39364__$1,owner__$1,map__39365__$2,dataset_info__$1,status__$1,meta39368){
return (new hatti.views.dataview.t_hatti$views$dataview39367(p__39364__$1,owner__$1,map__39365__$2,dataset_info__$1,status__$1,meta39368));
});})(map__39365,map__39365__$1,dataset_info,status))
;

}

return (new hatti.views.dataview.t_hatti$views$dataview39367(p__39364,owner,map__39365__$1,dataset_info,status,cljs.core.PersistentArrayMap.EMPTY));
}));
/**
 * Strip off ampersand suffixes then switch to view if result is a valid view
 */
hatti.views.dataview.activate_view_BANG_ = (function hatti$views$dataview$activate_view_BANG_(view){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((function (){var or__6409__auto__ = cljs.core.last(cljs.core.re_find(/(.*?)&/,view));
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return view;
}
})());
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
if(cljs.core.contains_QMARK_(cljs.core.set(views),view__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_settings_view_BANG_ = (function hatti$views$dataview$activate_settings_view_BANG_(view,settings_section){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state))));
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$selected,view__$1], null));

chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$active_DASH_tab,settings_section__$1], null));

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.dataview.activate_integrated_apps_view_BANG_ = (function hatti$views$dataview$activate_integrated_apps_view_BANG_(view,settings_section,app_type){
var view__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(view);
var settings_section__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(settings_section);
var settings_views = cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.shared.app_state) : cljs.core.deref.call(null,hatti.shared.app_state)))));
if(cljs.core.contains_QMARK_(cljs.core.set(settings_views),settings_section__$1)){
chimera.om.state.transact_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.app_state,((function (view__$1,settings_section__$1,settings_views){
return (function (app_state){
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(app_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$selected], null),view__$1),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$active_DASH_tab], null),settings_section__$1),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps,cljs.core.cst$kw$active_DASH_section], null),app_type);
});})(view__$1,settings_section__$1,settings_views))
);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(app_type,hatti.constants.google_sheets)){
chimera.om.state.merge_into_app_state_BANG_.cljs$core$IFn$_invoke$arity$3(hatti.shared.app_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$views,cljs.core.cst$kw$settings,cljs.core.cst$kw$integrated_DASH_apps], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$add_QMARK_,true], null));
} else {
}

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(hatti.shared.event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$re_DASH_render,view__$1], null));
} else {
return null;
}
});
hatti.views.tabbed_dataview.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (app_state,owner,opts){
if(typeof hatti.views.dataview.t_hatti$views$dataview39389 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {om.core.IRender}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
hatti.views.dataview.t_hatti$views$dataview39389 = (function (app_state,owner,opts,meta39390){
this.app_state = app_state;
this.owner = owner;
this.opts = opts;
this.meta39390 = meta39390;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
hatti.views.dataview.t_hatti$views$dataview39389.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39391,meta39390__$1){
var self__ = this;
var _39391__$1 = this;
return (new hatti.views.dataview.t_hatti$views$dataview39389(self__.app_state,self__.owner,self__.opts,meta39390__$1));
});

hatti.views.dataview.t_hatti$views$dataview39389.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39391){
var self__ = this;
var _39391__$1 = this;
return self__.meta39390;
});

hatti.views.dataview.t_hatti$views$dataview39389.prototype.om$core$IRender$ = true;

hatti.views.dataview.t_hatti$views$dataview39389.prototype.om$core$IRender$render$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var map__39392 = self__.app_state;
var map__39392__$1 = ((((!((map__39392 == null)))?((((map__39392.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39392.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39392):map__39392);
var map__39393 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39392__$1,cljs.core.cst$kw$views);
var map__39393__$1 = ((((!((map__39393 == null)))?((((map__39393.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39393.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39393):map__39393);
var active = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39393__$1,cljs.core.cst$kw$active);
var disabled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39393__$1,cljs.core.cst$kw$disabled);
var selected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39393__$1,cljs.core.cst$kw$selected);
var is_encrypted_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39392__$1,cljs.core.cst$kw$is_DASH_encrypted_QMARK_);
var is_within_pricing_limits_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39392__$1,cljs.core.cst$kw$is_DASH_within_DASH_pricing_DASH_limits_QMARK_);
var view__GT_display = ((function (map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1){
return (function (p1__39386_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__39386_SHARP_)){
return "block";
} else {
return "none";
}
});})(map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,___$1))
;
var view__GT_cls = ((function (map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1){
return (function (p1__39387_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,p1__39387_SHARP_)){
return "clicked";
} else {
return null;
}
});})(map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,___$1))
;
var dataviews = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(hatti.views.dataview.view_state) : cljs.core.deref.call(null,hatti.views.dataview.view_state)),cljs.core.cst$kw$all.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(self__.app_state))));
var dv__GT_link = ((function (map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p__39396){
var map__39397 = p__39396;
var map__39397__$1 = ((((!((map__39397 == null)))?((((map__39397.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39397.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39397):map__39397);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39397__$1,cljs.core.cst$kw$view);
var label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39397__$1,cljs.core.cst$kw$label);
if(cljs.core.truth_((function (){var and__6397__auto__ = cljs.core.some(((function (map__39397,map__39397__$1,view,label,map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1){
return (function (p1__39388_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,p1__39388_SHARP_);
});})(map__39397,map__39397__$1,view,label,map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
,active);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not(chimera.seq.in_QMARK_(disabled,view));
} else {
return and__6397__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,view__GT_cls(view),cljs.core.cst$kw$href,[cljs.core.str("#/"),cljs.core.str(cljs.core.name(view))].join('')], null),label], null);
} else {
return hatti.views.dataview.view__GT_inactive_tab(view,label,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_);
}
});})(map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,___$1))
;
var G__39400 = ({"className": "tab-container dataset-tabs"});
var G__39401 = (function (){var attrs39399 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(dv__GT_link,dataviews);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.DOM.div,((cljs.core.map_QMARK_(attrs39399))?sablono.interpreter.attributes(sablono.util.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tab-bar"], null)], null),attrs39399], 0))):({"className": "tab-bar"})),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,((cljs.core.map_QMARK_(attrs39399))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs39399),sablono.interpreter.interpret(om.core.build.cljs$core$IFn$_invoke$arity$2(hatti.views.dataview_infobar,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dataset_DASH_info,cljs.core.cst$kw$dataset_DASH_info.cljs$core$IFn$_invoke$arity$1(self__.app_state),cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(self__.app_state)], null)))], null))));
})();
var G__39402 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7189__auto__ = ((function (G__39400,G__39401,map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function hatti$views$dataview$iter__39403(s__39404){
return (new cljs.core.LazySeq(null,((function (G__39400,G__39401,map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1){
return (function (){
var s__39404__$1 = s__39404;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__39404__$1);
if(temp__4657__auto__){
var s__39404__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__39404__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__39404__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__39406 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__39405 = (0);
while(true){
if((i__39405 < size__7188__auto__)){
var map__39417 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__39405);
var map__39417__$1 = ((((!((map__39417 == null)))?((((map__39417.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39417.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39417):map__39417);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39417__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39417__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
cljs.core.chunk_append(b__39406,(function (){var G__39419 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__39420 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__39419,G__39420);
})());

var G__39425 = (i__39405 + (1));
i__39405 = G__39425;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__39406),hatti$views$dataview$iter__39403(cljs.core.chunk_rest(s__39404__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__39406),null);
}
} else {
var map__39421 = cljs.core.first(s__39404__$2);
var map__39421__$1 = ((((!((map__39421 == null)))?((((map__39421.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39421.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39421):map__39421);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39421__$1,cljs.core.cst$kw$component);
var view = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39421__$1,cljs.core.cst$kw$view);
var view_name = cljs.core.name(view);
return cljs.core.cons((function (){var G__39423 = ({"style": ({"display": view__GT_display(view)}), "className": [cljs.core.str("tab-page "),cljs.core.str(view_name),cljs.core.str("-page")].join('')});
var G__39424 = sablono.interpreter.interpret(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(selected,view))?(function (){
chimera.metrics.send_event(cljs.core.cst$kw$Dataview,[cljs.core.str(view_name),cljs.core.str("-page-load")].join(''));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tab_DASH_content,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,[cljs.core.str("tab-content"),cljs.core.str(view_name)].join('')], null),om.core.build.cljs$core$IFn$_invoke$arity$3(component,self__.app_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$opts,self__.opts], null))], null);
})()
:null));
return React.DOM.div(G__39423,G__39424);
})(),hatti$views$dataview$iter__39403(cljs.core.rest(s__39404__$2)));
}
} else {
return null;
}
break;
}
});})(G__39400,G__39401,map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
,null,null));
});})(G__39400,G__39401,map__39392,map__39392__$1,map__39393,map__39393__$1,active,disabled,selected,is_encrypted_QMARK_,is_within_pricing_limits_QMARK_,view__GT_display,view__GT_cls,dataviews,dv__GT_link,___$1))
;
return iter__7189__auto__(dataviews);
})());
return React.DOM.div(G__39400,G__39401,G__39402);
});

hatti.views.dataview.t_hatti$views$dataview39389.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$app_DASH_state,cljs.core.cst$sym$owner,cljs.core.cst$sym$opts,cljs.core.cst$sym$meta39390], null);
});

hatti.views.dataview.t_hatti$views$dataview39389.cljs$lang$type = true;

hatti.views.dataview.t_hatti$views$dataview39389.cljs$lang$ctorStr = "hatti.views.dataview/t_hatti$views$dataview39389";

hatti.views.dataview.t_hatti$views$dataview39389.cljs$lang$ctorPrWriter = (function (this__7015__auto__,writer__7016__auto__,opt__7017__auto__){
return cljs.core._write(writer__7016__auto__,"hatti.views.dataview/t_hatti$views$dataview39389");
});

hatti.views.dataview.__GT_t_hatti$views$dataview39389 = (function hatti$views$dataview$__GT_t_hatti$views$dataview39389(app_state__$1,owner__$1,opts__$1,meta39390){
return (new hatti.views.dataview.t_hatti$views$dataview39389(app_state__$1,owner__$1,opts__$1,meta39390));
});

}

return (new hatti.views.dataview.t_hatti$views$dataview39389(app_state,owner,opts,cljs.core.PersistentArrayMap.EMPTY));
}));
