// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.map.utils');
goog.require('cljs.core');
goog.require('hatti.constants');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('hatti.ona.forms');
goog.require('clojure.string');
goog.require('om.core');
goog.require('hatti.utils');
goog.require('cljs.reader');
hatti.map.utils.ona_styles = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"radius": (6), "fillColor": "#f30", "reset": ({"fillColor": "#f30"}), "color": "#fff", "border": (8), "opacity": 0.5, "fillOpacity": 0.9}),cljs.core.cst$kw$hover,({"fillColor": "#631400"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300"})], null),cljs.core.cst$kw$shape,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"fillColor": "#f30", "color": "#666", "weight": (3), "dashArray": "3", "fillOpacity": 0.7, "opacity": 0.8}),cljs.core.cst$kw$hover,({"fillColor": "#631400", "color": "#222"}),cljs.core.cst$kw$clicked,({"fillColor": "#ad2300", "color": "#222"})], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,({"color": "#f30", "opacity": (1), "weight": (6), "reset": ({"color": "#f30"})}),cljs.core.cst$kw$hover,({"color": "#631400"}),cljs.core.cst$kw$clicked,({"color": "#ad2300"})], null)], null);
hatti.map.utils.circle_border_id = "point-casting";
/**
 * Returns geotype (:point :line or :shape) based on marker.
 */
hatti.map.utils.marker__GT_geotype = (function hatti$map$utils$marker__GT_geotype(marker){
return new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,(((marker["feature"])["geometry"])["type"]));
});
/**
 * Appropriate style given style-type (:normal, :clicked, :hover), and
 * either a leaflet marker or clojurescript keyword (one of :point or :shape).
 */
hatti.map.utils.get_ona_style = (function hatti$map$utils$get_ona_style(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33254 = arguments.length;
var i__7485__auto___33255 = (0);
while(true){
if((i__7485__auto___33255 < len__7484__auto___33254)){
args__7491__auto__.push((arguments[i__7485__auto___33255]));

var G__33256 = (i__7485__auto___33255 + (1));
i__7485__auto___33255 = G__33256;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic = (function (marker_or_keyword,style_type,p__33250){
var map__33251 = p__33250;
var map__33251__$1 = ((((!((map__33251 == null)))?((((map__33251.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33251.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33251):map__33251);
var custom_styles = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33251__$1,cljs.core.cst$kw$custom_DASH_styles,hatti.map.utils.ona_styles);
var kw = (((marker_or_keyword instanceof cljs.core.Keyword))?marker_or_keyword:hatti.map.utils.marker__GT_geotype(marker_or_keyword));
var G__33253 = (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(custom_styles) : kw.call(null,custom_styles));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__33253) : style_type.call(null,G__33253));
});

hatti.map.utils.get_ona_style.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_ona_style.cljs$lang$applyTo = (function (seq33247){
var G__33248 = cljs.core.first(seq33247);
var seq33247__$1 = cljs.core.next(seq33247);
var G__33249 = cljs.core.first(seq33247__$1);
var seq33247__$2 = cljs.core.next(seq33247__$1);
return hatti.map.utils.get_ona_style.cljs$core$IFn$_invoke$arity$variadic(G__33248,G__33249,seq33247__$2);
});

hatti.map.utils.equivalent_style = (function hatti$map$utils$equivalent_style(s,t){

var sc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(s);
var tc = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(t);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.select_keys(sc,cljs.core.keys(tc)),cljs.core.select_keys(tc,cljs.core.keys(sc)));
});
hatti.map.utils.get_id = (function hatti$map$utils$get_id(marker){
return (((marker["feature"])["properties"])[hatti.constants._id]);
});
hatti.map.utils.get_rank = (function hatti$map$utils$get_rank(marker){
return (((marker["feature"])["properties"])[hatti.constants._rank]);
});
/**
 * Get the style of a marker. Second arg specifies style attribute to get.
 * eg. For marker m1, call like: (get-style m1) or (get-style m1 :fillColor)
 */
hatti.map.utils.get_style = (function hatti$map$utils$get_style(var_args){
var args33257 = [];
var len__7484__auto___33261 = arguments.length;
var i__7485__auto___33262 = (0);
while(true){
if((i__7485__auto___33262 < len__7484__auto___33261)){
args33257.push((arguments[i__7485__auto___33262]));

var G__33263 = (i__7485__auto___33262 + (1));
i__7485__auto___33262 = G__33263;
continue;
} else {
}
break;
}

var G__33259 = args33257.length;
switch (G__33259) {
case 1:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33257.length)].join('')));

}
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1 = (function (marker){
return (marker["options"]);
});

hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$2 = (function (marker,kw){
var G__33260 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker));
return (kw.cljs$core$IFn$_invoke$arity$1 ? kw.cljs$core$IFn$_invoke$arity$1(G__33260) : kw.call(null,G__33260));
});

hatti.map.utils.get_style.cljs$lang$maxFixedArity = 2;

/**
 * Check whether a marker is clicked, so it's style can be preserved.
 */
hatti.map.utils.is_clicked_QMARK_ = (function hatti$map$utils$is_clicked_QMARK_(marker){
return hatti.map.utils.equivalent_style(hatti.map.utils.get_style.cljs$core$IFn$_invoke$arity$1(marker),hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
});
/**
 * Apply a style to a marker. Style comes from a function that takes marker.
 */
hatti.map.utils.re_style_marker = (function hatti$map$utils$re_style_marker(marker__GT_style,marker){
var style = (marker__GT_style.cljs$core$IFn$_invoke$arity$1 ? marker__GT_style.cljs$core$IFn$_invoke$arity$1(marker) : marker__GT_style.call(null,marker));
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return marker.setStyle(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reset,style], null)));
} else {
return marker.setStyle(cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(style,cljs.core.cst$kw$reset,style)));
}
});
/**
 * Reset styles pulls the 'reset' property from within a markers options,
 * clearing styles to default if nothing found.
 */
hatti.map.utils.reset_style = (function hatti$map$utils$reset_style(marker){
var temp__4655__auto__ = ((marker["options"])["reset"]);
if(cljs.core.truth_(temp__4655__auto__)){
var rstyle = temp__4655__auto__;
return marker.setStyle(rstyle);
} else {
return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
}
});
/**
 * Looks at the _id in marker, and brings to top if (1) marker clicked or
 * (2) marker's id is selected (via id-selected?)
 */
hatti.map.utils.bring_to_top_if_selected = (function hatti$map$utils$bring_to_top_if_selected(id_selected_QMARK_,marker){
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.map.utils.is_clicked_QMARK_(marker);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var G__33266 = hatti.map.utils.get_id(marker);
return (id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? id_selected_QMARK_.cljs$core$IFn$_invoke$arity$1(G__33266) : id_selected_QMARK_.call(null,G__33266));
}
})())){
return marker.bringToFront();
} else {
return null;
}
});
hatti.map.utils.apply_click_style = (function hatti$map$utils$apply_click_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$clicked));
} else {
return null;
}
});
hatti.map.utils.apply_unclick_style = (function hatti$map$utils$apply_unclick_style(marker){
if(cljs.core.truth_(marker)){
return hatti.map.utils.reset_style(marker);
} else {
return null;
}
});
hatti.map.utils.apply_hover_style = (function hatti$map$utils$apply_hover_style(marker){
if(cljs.core.truth_(marker)){
marker.bringToFront();

return marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$hover));
} else {
return null;
}
});
/**
 * Sets the default style on a marker.
 */
hatti.map.utils.clear_all_styles = (function hatti$map$utils$clear_all_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33276 = arguments.length;
var i__7485__auto___33277 = (0);
while(true){
if((i__7485__auto___33277 < len__7484__auto___33276)){
args__7491__auto__.push((arguments[i__7485__auto___33277]));

var G__33278 = (i__7485__auto___33277 + (1));
i__7485__auto___33277 = G__33278;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic = (function (markers,p__33269){
var map__33270 = p__33269;
var map__33270__$1 = ((((!((map__33270 == null)))?((((map__33270.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33270.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33270):map__33270);
var preserve_clicked_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33270__$1,cljs.core.cst$kw$preserve_DASH_clicked_QMARK_,true);
var seq__33272 = cljs.core.seq(markers);
var chunk__33273 = null;
var count__33274 = (0);
var i__33275 = (0);
while(true){
if((i__33275 < count__33274)){
var marker = chunk__33273.cljs$core$IIndexed$_nth$arity$2(null,i__33275);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__33279 = seq__33272;
var G__33280 = chunk__33273;
var G__33281 = count__33274;
var G__33282 = (i__33275 + (1));
seq__33272 = G__33279;
chunk__33273 = G__33280;
count__33274 = G__33281;
i__33275 = G__33282;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__33272);
if(temp__4657__auto__){
var seq__33272__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33272__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__33272__$1);
var G__33283 = cljs.core.chunk_rest(seq__33272__$1);
var G__33284 = c__7220__auto__;
var G__33285 = cljs.core.count(c__7220__auto__);
var G__33286 = (0);
seq__33272 = G__33283;
chunk__33273 = G__33284;
count__33274 = G__33285;
i__33275 = G__33286;
continue;
} else {
var marker = cljs.core.first(seq__33272__$1);
if(cljs.core.not((function (){var and__6397__auto__ = preserve_clicked_QMARK_;
if(cljs.core.truth_(and__6397__auto__)){
return hatti.map.utils.is_clicked_QMARK_(marker);
} else {
return and__6397__auto__;
}
})())){
marker.setStyle(hatti.map.utils.get_ona_style(marker,cljs.core.cst$kw$normal));
} else {
}

var G__33287 = cljs.core.next(seq__33272__$1);
var G__33288 = null;
var G__33289 = (0);
var G__33290 = (0);
seq__33272 = G__33287;
chunk__33273 = G__33288;
count__33274 = G__33289;
i__33275 = G__33290;
continue;
}
} else {
return null;
}
}
break;
}
});

hatti.map.utils.clear_all_styles.cljs$lang$maxFixedArity = (1);

hatti.map.utils.clear_all_styles.cljs$lang$applyTo = (function (seq33267){
var G__33268 = cljs.core.first(seq33267);
var seq33267__$1 = cljs.core.next(seq33267);
return hatti.map.utils.clear_all_styles.cljs$core$IFn$_invoke$arity$variadic(G__33268,seq33267__$1);
});

hatti.map.utils.read_string_or_number = (function hatti$map$utils$read_string_or_number(maybe_s){
if(typeof maybe_s === 'string'){
return cljs.reader.read_string(maybe_s);
} else {
return maybe_s;
}
});
hatti.map.utils.make_feature = (function hatti$map$utils$make_feature(geometry,record_id,index){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"Feature",cljs.core.cst$kw$properties,cljs.core.PersistentArrayMap.fromArray([cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._rank),(index + (1)),cljs.core.cst$kw$id,record_id,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id),record_id], true, false),cljs.core.cst$kw$geometry,geometry], null);
});
if(typeof hatti.map.utils.get_as_geom !== 'undefined'){
} else {
hatti.map.utils.get_as_geom = (function (){var method_table__7334__auto__ = (function (){var G__33291 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33291) : cljs.core.atom.call(null,G__33291));
})();
var prefer_table__7335__auto__ = (function (){var G__33292 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33292) : cljs.core.atom.call(null,G__33292));
})();
var method_cache__7336__auto__ = (function (){var G__33293 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33293) : cljs.core.atom.call(null,G__33293));
})();
var cached_hierarchy__7337__auto__ = (function (){var G__33294 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33294) : cljs.core.atom.call(null,G__33294));
})();
var hierarchy__7338__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("hatti.map.utils","get-as-geom"),((function (method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__){
return (function() { 
var G__33299__delegate = function (record,field,p__33295){
var vec__33296 = p__33295;
var repeat_child_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33296,(0),null);
if(cljs.core.truth_(hatti.ona.forms.repeat_QMARK_(field))){
return cljs.core.cst$kw$repeat;
} else {
return cljs.core.cst$kw$default;

}
};
var G__33299 = function (record,field,var_args){
var p__33295 = null;
if (arguments.length > 2) {
var G__33300__i = 0, G__33300__a = new Array(arguments.length -  2);
while (G__33300__i < G__33300__a.length) {G__33300__a[G__33300__i] = arguments[G__33300__i + 2]; ++G__33300__i;}
  p__33295 = new cljs.core.IndexedSeq(G__33300__a,0);
} 
return G__33299__delegate.call(this,record,field,p__33295);};
G__33299.cljs$lang$maxFixedArity = 2;
G__33299.cljs$lang$applyTo = (function (arglist__33301){
var record = cljs.core.first(arglist__33301);
arglist__33301 = cljs.core.next(arglist__33301);
var field = cljs.core.first(arglist__33301);
var p__33295 = cljs.core.rest(arglist__33301);
return G__33299__delegate(record,field,p__33295);
});
G__33299.cljs$core$IFn$_invoke$arity$variadic = G__33299__delegate;
return G__33299;
})()
;})(method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__,hierarchy__7338__auto__))
,cljs.core.cst$kw$default,hierarchy__7338__auto__,method_table__7334__auto__,prefer_table__7335__auto__,method_cache__7336__auto__,cached_hierarchy__7337__auto__));
})();
}
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$repeat,(function (record,p__33302){
var map__33303 = p__33302;
var map__33303__$1 = ((((!((map__33303 == null)))?((((map__33303.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33303.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33303):map__33303);
var field = map__33303__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33303__$1,cljs.core.cst$kw$children);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33303__$1,cljs.core.cst$kw$full_DASH_name);
var iter__7189__auto__ = ((function (map__33303,map__33303__$1,field,children,full_name){
return (function hatti$map$utils$iter__33305(s__33306){
return (new cljs.core.LazySeq(null,((function (map__33303,map__33303__$1,field,children,full_name){
return (function (){
var s__33306__$1 = s__33306;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33306__$1);
if(temp__4657__auto__){
var s__33306__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33306__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33306__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33308 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33307 = (0);
while(true){
if((i__33307 < size__7188__auto__)){
var child_record = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33307);
cljs.core.chunk_append(b__33308,(function (){var iter__7189__auto__ = ((function (i__33307,child_record,c__7187__auto__,size__7188__auto__,b__33308,s__33306__$2,temp__4657__auto__,map__33303,map__33303__$1,field,children,full_name){
return (function hatti$map$utils$iter__33305_$_iter__33323(s__33324){
return (new cljs.core.LazySeq(null,((function (i__33307,child_record,c__7187__auto__,size__7188__auto__,b__33308,s__33306__$2,temp__4657__auto__,map__33303,map__33303__$1,field,children,full_name){
return (function (){
var s__33324__$1 = s__33324;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__33324__$1);
if(temp__4657__auto____$1){
var s__33324__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__33324__$2)){
var c__7187__auto____$1 = cljs.core.chunk_first(s__33324__$2);
var size__7188__auto____$1 = cljs.core.count(c__7187__auto____$1);
var b__33326 = cljs.core.chunk_buffer(size__7188__auto____$1);
if((function (){var i__33325 = (0);
while(true){
if((i__33325 < size__7188__auto____$1)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto____$1,i__33325);
cljs.core.chunk_append(b__33326,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__33335 = (i__33325 + (1));
i__33325 = G__33335;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33326),hatti$map$utils$iter__33305_$_iter__33323(cljs.core.chunk_rest(s__33324__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33326),null);
}
} else {
var child = cljs.core.first(s__33324__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__33305_$_iter__33323(cljs.core.rest(s__33324__$2)));
}
} else {
return null;
}
break;
}
});})(i__33307,child_record,c__7187__auto__,size__7188__auto__,b__33308,s__33306__$2,temp__4657__auto__,map__33303,map__33303__$1,field,children,full_name))
,null,null));
});})(i__33307,child_record,c__7187__auto__,size__7188__auto__,b__33308,s__33306__$2,temp__4657__auto__,map__33303,map__33303__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})());

var G__33336 = (i__33307 + (1));
i__33307 = G__33336;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33308),hatti$map$utils$iter__33305(cljs.core.chunk_rest(s__33306__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33308),null);
}
} else {
var child_record = cljs.core.first(s__33306__$2);
return cljs.core.cons((function (){var iter__7189__auto__ = ((function (child_record,s__33306__$2,temp__4657__auto__,map__33303,map__33303__$1,field,children,full_name){
return (function hatti$map$utils$iter__33305_$_iter__33329(s__33330){
return (new cljs.core.LazySeq(null,((function (child_record,s__33306__$2,temp__4657__auto__,map__33303,map__33303__$1,field,children,full_name){
return (function (){
var s__33330__$1 = s__33330;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__33330__$1);
if(temp__4657__auto____$1){
var s__33330__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__33330__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33330__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33332 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33331 = (0);
while(true){
if((i__33331 < size__7188__auto__)){
var child = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33331);
cljs.core.chunk_append(b__33332,(hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)));

var G__33337 = (i__33331 + (1));
i__33331 = G__33337;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33332),hatti$map$utils$iter__33305_$_iter__33329(cljs.core.chunk_rest(s__33330__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33332),null);
}
} else {
var child = cljs.core.first(s__33330__$2);
return cljs.core.cons((hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(child_record,child) : hatti.map.utils.get_as_geom.call(null,child_record,child)),hatti$map$utils$iter__33305_$_iter__33329(cljs.core.rest(s__33330__$2)));
}
} else {
return null;
}
break;
}
});})(child_record,s__33306__$2,temp__4657__auto__,map__33303,map__33303__$1,field,children,full_name))
,null,null));
});})(child_record,s__33306__$2,temp__4657__auto__,map__33303,map__33303__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(hatti.ona.forms.geofield_QMARK_,children));
})(),hatti$map$utils$iter__33305(cljs.core.rest(s__33306__$2)));
}
} else {
return null;
}
break;
}
});})(map__33303,map__33303__$1,field,children,full_name))
,null,null));
});})(map__33303,map__33303__$1,field,children,full_name))
;
return iter__7189__auto__(cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,full_name));
}));
hatti.map.utils.get_as_geom.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (record,geofield){
var geotype = new cljs.core.PersistentArrayMap(null, 4, ["geopoint","Point","gps","Point","geoshape","Polygon","geotrace","LineString"], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(geofield));
var parse = ((function (geotype){
return (function (s){
if((cljs.core.seq(s)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,"n/a"))){
var iter__7189__auto__ = ((function (geotype){
return (function hatti$map$utils$iter__33340(s__33341){
return (new cljs.core.LazySeq(null,((function (geotype){
return (function (){
var s__33341__$1 = s__33341;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33341__$1);
if(temp__4657__auto__){
var s__33341__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33341__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33341__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33343 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33342 = (0);
while(true){
if((i__33342 < size__7188__auto__)){
var coord_string = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33342);
cljs.core.chunk_append(b__33343,(function (){var vec__33352 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33352,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33352,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33352,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33352,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})());

var G__33359 = (i__33342 + (1));
i__33342 = G__33359;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33343),hatti$map$utils$iter__33340(cljs.core.chunk_rest(s__33341__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33343),null);
}
} else {
var coord_string = cljs.core.first(s__33341__$2);
return cljs.core.cons((function (){var vec__33355 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(coord_string,/ /);
var lat = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33355,(0),null);
var lng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33355,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33355,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33355,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.reader.read_string(lng),cljs.reader.read_string(lat)], null);
})(),hatti$map$utils$iter__33340(cljs.core.rest(s__33341__$2)));
}
} else {
return null;
}
break;
}
});})(geotype))
,null,null));
});})(geotype))
;
return iter__7189__auto__(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/;/));
} else {
return null;
}
});})(geotype))
;
var coordfn = (function (){var G__33358 = geotype;
switch (G__33358) {
case "Point":
return ((function (G__33358,geotype,parse){
return (function (p1__33338_SHARP_){
return cljs.core.first(parse(p1__33338_SHARP_));
});
;})(G__33358,geotype,parse))

break;
case "LineString":
return parse;

break;
case "Polygon":
return ((function (G__33358,geotype,parse){
return (function (p1__33339_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[parse(p1__33339_SHARP_)],null));
});
;})(G__33358,geotype,parse))

break;
default:
return cljs.core.identity;

}
})();
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(record,cljs.core.cst$kw$full_DASH_name.cljs$core$IFn$_invoke$arity$1(geofield));
var coords = (coordfn.cljs$core$IFn$_invoke$arity$1 ? coordfn.cljs$core$IFn$_invoke$arity$1(value) : coordfn.call(null,value));
if(cljs.core.truth_(hatti.ona.forms.osm_QMARK_(geofield))){
return cljs.core.cst$kw$geom.cljs$core$IFn$_invoke$arity$1(value);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = (coords == null);
if(or__6409__auto__){
return or__6409__auto__;
} else {
return cljs.core.some(cljs.core.nil_QMARK_,coords);
}
})())){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,geotype,cljs.core.cst$kw$coordinates,coords], null);
}
}
}));
/**
 * Given the dataset, and the form schema, get out geojson.
 * Optional specification of field will map that field data to the geom.
 */
hatti.map.utils.as_geojson = (function hatti$map$utils$as_geojson(var_args){
var args33362 = [];
var len__7484__auto___33383 = arguments.length;
var i__7485__auto___33384 = (0);
while(true){
if((i__7485__auto___33384 < len__7484__auto___33383)){
args33362.push((arguments[i__7485__auto___33384]));

var G__33385 = (i__7485__auto___33384 + (1));
i__7485__auto___33384 = G__33385;
continue;
} else {
}
break;
}

var G__33364 = args33362.length;
switch (G__33364) {
case 2:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33362.length)].join('')));

}
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$2 = (function (dataset,form){
return hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3(dataset,form,hatti.ona.forms.default_geofield(form));
});

hatti.map.utils.as_geojson.cljs$core$IFn$_invoke$arity$3 = (function (dataset,form,geofield){
if(cljs.core.truth_(geofield)){
var features = (function (){var iter__7189__auto__ = (function hatti$map$utils$iter__33365(s__33366){
return (new cljs.core.LazySeq(null,(function (){
var s__33366__$1 = s__33366;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33366__$1);
if(temp__4657__auto__){
var s__33366__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33366__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33366__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33368 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33367 = (0);
while(true){
if((i__33367 < size__7188__auto__)){
var vec__33377 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33367);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33377,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33377,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
cljs.core.chunk_append(b__33368,((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__33367,s__33366__$1,geom_or_geoms,vec__33377,idx,record,c__7187__auto__,size__7188__auto__,b__33368,s__33366__$2,temp__4657__auto__){
return (function (p1__33361_SHARP_){
return hatti.map.utils.make_feature(p1__33361_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(i__33367,s__33366__$1,geom_or_geoms,vec__33377,idx,record,c__7187__auto__,size__7188__auto__,b__33368,s__33366__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))));

var G__33387 = (i__33367 + (1));
i__33367 = G__33387;
continue;
} else {
var G__33388 = (i__33367 + (1));
i__33367 = G__33388;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33368),hatti$map$utils$iter__33365(cljs.core.chunk_rest(s__33366__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33368),null);
}
} else {
var vec__33380 = cljs.core.first(s__33366__$2);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33380,(0),null);
var record = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33380,(1),null);
var geom_or_geoms = (hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2 ? hatti.map.utils.get_as_geom.cljs$core$IFn$_invoke$arity$2(record,geofield) : hatti.map.utils.get_as_geom.call(null,record,geofield));
if(cljs.core.truth_(geom_or_geoms)){
return cljs.core.cons(((cljs.core.map_QMARK_(geom_or_geoms))?hatti.map.utils.make_feature(geom_or_geoms,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx):cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (s__33366__$1,geom_or_geoms,vec__33380,idx,record,s__33366__$2,temp__4657__auto__){
return (function (p1__33361_SHARP_){
return hatti.map.utils.make_feature(p1__33361_SHARP_,(record.cljs$core$IFn$_invoke$arity$1 ? record.cljs$core$IFn$_invoke$arity$1(hatti.constants._id) : record.call(null,hatti.constants._id)),idx);
});})(s__33366__$1,geom_or_geoms,vec__33380,idx,record,s__33366__$2,temp__4657__auto__))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(geom_or_geoms)))),hatti$map$utils$iter__33365(cljs.core.rest(s__33366__$2)));
} else {
var G__33389 = cljs.core.rest(s__33366__$2);
s__33366__$1 = G__33389;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(hatti.utils.indexed(dataset));
})();
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,cljs.core.flatten(features)], null);
} else {
return null;
}
});

hatti.map.utils.as_geojson.cljs$lang$maxFixedArity = 3;

/**
 * Creates a leaflet map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_map = (function hatti$map$utils$create_map(id,p__33391){
var map__33394 = p__33391;
var map__33394__$1 = ((((!((map__33394 == null)))?((((map__33394.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33394.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33394):map__33394);
var mapbox_tiles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33394__$1,cljs.core.cst$kw$mapbox_DASH_tiles);
var include_google_maps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33394__$1,cljs.core.cst$kw$include_DASH_google_DASH_maps_QMARK_);
var layers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__33394,map__33394__$1,mapbox_tiles,include_google_maps_QMARK_){
return (function (p1__33390_SHARP_){
return L.tileLayer(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(p1__33390_SHARP_));
});})(map__33394,map__33394__$1,mapbox_tiles,include_google_maps_QMARK_))
,mapbox_tiles);
var nlayers = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name,mapbox_tiles),layers);
var named_layers = (cljs.core.truth_(include_google_maps_QMARK_)?cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(nlayers,"Google Satellite",new L.Google)):cljs.core.clj__GT_js(nlayers));
var m = L.map(id,({"layers": cljs.core.first(layers), "zoomControl": false}));
var z = L.control.zoom.call(null,({"position": "bottomleft"}));
z.addTo(m);

L.control.layers.call(null,named_layers,null,({"position": "bottomleft"})).addTo(m);

m.setView([(0),(0)],(1));

return m;
});
/**
 * Mouse events for markers.
 *   On click or arrow, mapped-submission-to-rank events are generated.
 *   On hover, marker is brought to the front and color changed.
 */
hatti.map.utils.register_mouse_events = (function hatti$map$utils$register_mouse_events(feature,marker,event_chan){
marker.on("click",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_rank,((feature["properties"])[hatti.constants._rank])], null));
}
}));

marker.on("mouseover",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_hover_style(marker);
}
}));

return marker.on("mouseout",(function (){
if(cljs.core.truth_(hatti.map.utils.is_clicked_QMARK_(marker))){
return null;
} else {
return hatti.map.utils.apply_unclick_style(marker);
}
}));
});
/**
 * Re-renders map by invalidating leaflet size.
 * If map is zoomed out beyond layer-bounds, re-zooms to layer.
 */
hatti.map.utils.re_render_map_BANG_ = (function hatti$map$utils$re_render_map_BANG_(leaflet_map,feature_layer){
var map_bounds = leaflet_map.getBounds();
var layer_bounds = feature_layer.getBounds();
leaflet_map.invalidateSize(false);

if(((leaflet_map.getZoom() === (0))) || (cljs.core.not(layer_bounds.contains(map_bounds)))){
return leaflet_map.fitBounds(layer_bounds);
} else {
return null;
}
});
/**
 * Create a map with the given GeoJSON data.
 * Adds mouse events and centers on the geojson features.
 */
hatti.map.utils.load_geo_json = (function hatti$map$utils$load_geo_json(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33408 = arguments.length;
var i__7485__auto___33409 = (0);
while(true){
if((i__7485__auto___33409 < len__7484__auto___33408)){
args__7491__auto__.push((arguments[i__7485__auto___33409]));

var G__33410 = (i__7485__auto___33409 + (1));
i__7485__auto___33409 = G__33410;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic = (function (m,geojson,event_chan,p__33405){
var map__33406 = p__33405;
var map__33406__$1 = ((((!((map__33406 == null)))?((((map__33406.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33406.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33406):map__33406);
var rezoom_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33406__$1,cljs.core.cst$kw$rezoom_QMARK_);
var on_events = ((function (map__33406,map__33406__$1,rezoom_QMARK_){
return (function (p1__33396_SHARP_,p2__33397_SHARP_){
return hatti.map.utils.register_mouse_events(p1__33396_SHARP_,p2__33397_SHARP_,event_chan);
});})(map__33406,map__33406__$1,rezoom_QMARK_))
;
var geometry_type = new cljs.core.PersistentArrayMap(null, 3, ["Point",cljs.core.cst$kw$point,"Polygon",cljs.core.cst$kw$shape,"LineString",cljs.core.cst$kw$line], null).call(null,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)))));
var stylefn = ((function (on_events,geometry_type,map__33406,map__33406__$1,rezoom_QMARK_){
return (function (){
return hatti.map.utils.get_ona_style(geometry_type,cljs.core.cst$kw$normal);
});})(on_events,geometry_type,map__33406,map__33406__$1,rezoom_QMARK_))
;
var point__GT_marker = ((function (on_events,geometry_type,stylefn,map__33406,map__33406__$1,rezoom_QMARK_){
return (function (p1__33399_SHARP_,p2__33398_SHARP_){
return L.circleMarker(p2__33398_SHARP_);
});})(on_events,geometry_type,stylefn,map__33406,map__33406__$1,rezoom_QMARK_))
;
var feature_layer = L.geoJson(cljs.core.clj__GT_js(geojson),({"onEachFeature": on_events, "pointToLayer": point__GT_marker, "style": stylefn}));
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__33406,map__33406__$1,rezoom_QMARK_){
return (function (p1__33400_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__33400_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$properties,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(hatti.constants._id)], null));
});})(on_events,geometry_type,stylefn,point__GT_marker,feature_layer,map__33406,map__33406__$1,rezoom_QMARK_))
,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson));
var markers = feature_layer.getLayers();
if(cljs.core.seq(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson))){
if(cljs.core.truth_(rezoom_QMARK_)){
m.fitBounds(feature_layer.getBounds());
} else {
}

feature_layer.addTo(m);
} else {
}

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$feature_DASH_layer,feature_layer,cljs.core.cst$kw$markers,markers,cljs.core.cst$kw$id_DASH__GT_marker,cljs.core.zipmap(ids,markers)], null);
});

hatti.map.utils.load_geo_json.cljs$lang$maxFixedArity = (3);

hatti.map.utils.load_geo_json.cljs$lang$applyTo = (function (seq33401){
var G__33402 = cljs.core.first(seq33401);
var seq33401__$1 = cljs.core.next(seq33401);
var G__33403 = cljs.core.first(seq33401__$1);
var seq33401__$2 = cljs.core.next(seq33401__$1);
var G__33404 = cljs.core.first(seq33401__$2);
var seq33401__$3 = cljs.core.next(seq33401__$2);
return hatti.map.utils.load_geo_json.cljs$core$IFn$_invoke$arity$variadic(G__33402,G__33403,G__33404,seq33401__$3);
});

/**
 * Creates a mapboxgl map, rendering it to the dom element with given id.
 */
hatti.map.utils.create_mapboxgl_map = (function hatti$map$utils$create_mapboxgl_map(id){
mapboxgl.accessToken = hatti.constants.mapboxgl_access_token;

var Map = mapboxgl.Map;
var NavigationControl = mapboxgl.NavigationControl;
var ScaleControl = mapboxgl.ScaleControl;
var m = (new Map(({"container": id, "style": "mapbox://styles/mapbox/streets-v9"})));
m.addControl((new ScaleControl(({"maxWidth": (100), "unit": "metric"}))),"bottom-left");

return m.addControl((new NavigationControl()),"bottom-left");
});
/**
 * Gets query filter and returns filters based on field type
 */
hatti.map.utils.get_filter = (function hatti$map$utils$get_filter(p__33411,flat_form){
var map__33417 = p__33411;
var map__33417__$1 = ((((!((map__33417 == null)))?((((map__33417.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33417.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33417):map__33417);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33417__$1,cljs.core.cst$kw$column);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33417__$1,cljs.core.cst$kw$filter);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33417__$1,cljs.core.cst$kw$value);
var field = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__33417,map__33417__$1,column,filter,value){
return (function (p__33419){
var map__33420 = p__33419;
var map__33420__$1 = ((((!((map__33420 == null)))?((((map__33420.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33420.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33420):map__33420);
var full_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33420__$1,cljs.core.cst$kw$full_DASH_name);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(full_name,column);
});})(map__33417,map__33417__$1,column,filter,value))
,flat_form));
if(cljs.core.truth_(hatti.ona.forms.numeric_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS INT) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
if(cljs.core.truth_(hatti.ona.forms.time_based_QMARK_(field))){
return [cljs.core.str("CAST(json->>'"),cljs.core.str(column),cljs.core.str("' AS AS TIMESTAMP) "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');
} else {
return [cljs.core.str("json->>'"),cljs.core.str(column),cljs.core.str("' "),cljs.core.str(filter),cljs.core.str(" '"),cljs.core.str(value),cljs.core.str("'")].join('');

}
}
});
/**
 * Generates query params filters for filtered datasets 
 */
hatti.map.utils.generate_filter_string = (function hatti$map$utils$generate_filter_string(query,flat_form){
if(cljs.core.truth_(cljs.core.not_empty(query))){
return [cljs.core.str(" and "),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" and ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33422_SHARP_){
return hatti.map.utils.get_filter(p1__33422_SHARP_,flat_form);
}),query)))].join('');
} else {
return null;
}
});
/**
 * Generates tiles url with appropriate filters as query params
 */
hatti.map.utils.get_tiles_endpoint = (function hatti$map$utils$get_tiles_endpoint(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33432 = arguments.length;
var i__7485__auto___33433 = (0);
while(true){
if((i__7485__auto___33433 < len__7484__auto___33432)){
args__7491__auto__.push((arguments[i__7485__auto___33433]));

var G__33434 = (i__7485__auto___33433 + (1));
i__7485__auto___33433 = G__33434;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((4) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((4)),(0),null)):null);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7492__auto__);
});

hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic = (function (tiles_server,formid,fields,flat_form,p__33428){
var vec__33429 = p__33428;
var query = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33429,(0),null);
return [cljs.core.str(tiles_server),cljs.core.str(hatti.constants.tiles_endpoint),cljs.core.str("?where=deleted_at is null and xform_id ="),cljs.core.str(formid),cljs.core.str(hatti.map.utils.generate_filter_string(query,flat_form)),cljs.core.str("&fields="),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",fields))].join('');
});

hatti.map.utils.get_tiles_endpoint.cljs$lang$maxFixedArity = (4);

hatti.map.utils.get_tiles_endpoint.cljs$lang$applyTo = (function (seq33423){
var G__33424 = cljs.core.first(seq33423);
var seq33423__$1 = cljs.core.next(seq33423);
var G__33425 = cljs.core.first(seq33423__$1);
var seq33423__$2 = cljs.core.next(seq33423__$1);
var G__33426 = cljs.core.first(seq33423__$2);
var seq33423__$3 = cljs.core.next(seq33423__$2);
var G__33427 = cljs.core.first(seq33423__$3);
var seq33423__$4 = cljs.core.next(seq33423__$3);
return hatti.map.utils.get_tiles_endpoint.cljs$core$IFn$_invoke$arity$variadic(G__33424,G__33425,G__33426,G__33427,seq33423__$4);
});

/**
 * Add map source. This is called with either tiles-url or geoson which
 *   determins the source type (Vector or  GeosJSON). 
 */
hatti.map.utils.add_mapboxgl_source = (function hatti$map$utils$add_mapboxgl_source(map,id_string,p__33435){
var map__33439 = p__33435;
var map__33439__$1 = ((((!((map__33439 == null)))?((((map__33439.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33439.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33439):map__33439);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33439__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33439__$1,cljs.core.cst$kw$geojson);
var cluster = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33439__$1,cljs.core.cst$kw$cluster,false);
var clusterRadius = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33439__$1,cljs.core.cst$kw$clusterRadius);
var clusterMaxZoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33439__$1,cljs.core.cst$kw$clusterMaxZoom);
var geojson_source_defn = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"geojson",cljs.core.cst$kw$data,geojson,cljs.core.cst$kw$cluster,cluster], null);
var source = (cljs.core.truth_(geojson)?cljs.core.clj__GT_js((function (){var G__33441 = geojson_source_defn;
var G__33441__$1 = (cljs.core.truth_(clusterRadius)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33441,cljs.core.cst$kw$clusterRadius,clusterRadius):G__33441);
if(cljs.core.truth_(clusterMaxZoom)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33441__$1,cljs.core.cst$kw$clusterMaxZoom,clusterMaxZoom);
} else {
return G__33441__$1;
}
})()):(cljs.core.truth_(tiles_url)?cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"vector",cljs.core.cst$kw$tiles,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tiles_url], null)], null)):null));
if(cljs.core.truth_(map.getSource(id_string))){
return null;
} else {
return map.addSource(id_string,source);
}
});
/**
 * Add map layer from available sources.
 */
hatti.map.utils.add_mapboxgl_layer = (function hatti$map$utils$add_mapboxgl_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33450 = arguments.length;
var i__7485__auto___33451 = (0);
while(true){
if((i__7485__auto___33451 < len__7484__auto___33450)){
args__7491__auto__.push((arguments[i__7485__auto___33451]));

var G__33452 = (i__7485__auto___33451 + (1));
i__7485__auto___33451 = G__33452;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id_string,layer_type,p__33446){
var map__33447 = p__33446;
var map__33447__$1 = ((((!((map__33447 == null)))?((((map__33447.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33447.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33447):map__33447);
var layer_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33447__$1,cljs.core.cst$kw$layer_DASH_id);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33447__$1,cljs.core.cst$kw$layout);
var paint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33447__$1,cljs.core.cst$kw$paint);
var filter = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33447__$1,cljs.core.cst$kw$filter);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33447__$1,cljs.core.cst$kw$tiles_DASH_url);
var l_id = (function (){var or__6409__auto__ = layer_id;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return id_string;
}
})();
var layer_def = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$id,l_id,cljs.core.cst$kw$type,layer_type,cljs.core.cst$kw$source,id_string], null);
var layer = cljs.core.clj__GT_js((function (){var G__33449 = layer_def;
var G__33449__$1 = (cljs.core.truth_(tiles_url)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33449,cljs.core.cst$kw$source_DASH_layer,hatti.constants.vector_source_layer):G__33449);
var G__33449__$2 = (cljs.core.truth_(paint)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33449__$1,cljs.core.cst$kw$paint,paint):G__33449__$1);
var G__33449__$3 = (cljs.core.truth_(layout)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33449__$2,cljs.core.cst$kw$layout,layout):G__33449__$2);
if(cljs.core.truth_(filter)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33449__$3,cljs.core.cst$kw$filter,filter);
} else {
return G__33449__$3;
}
})());
if(cljs.core.truth_(map.getLayer(l_id))){
return null;
} else {
return map.addLayer(layer,id_string);
}
});

hatti.map.utils.add_mapboxgl_layer.cljs$lang$maxFixedArity = (3);

hatti.map.utils.add_mapboxgl_layer.cljs$lang$applyTo = (function (seq33442){
var G__33443 = cljs.core.first(seq33442);
var seq33442__$1 = cljs.core.next(seq33442);
var G__33444 = cljs.core.first(seq33442__$1);
var seq33442__$2 = cljs.core.next(seq33442__$1);
var G__33445 = cljs.core.first(seq33442__$2);
var seq33442__$3 = cljs.core.next(seq33442__$2);
return hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(G__33443,G__33444,G__33445,seq33442__$3);
});

/**
 * Generates a collection of input - output value pairs known
 * as stops. These stops are used by get-styles function to decide the style
 * output based on an input vaue from the dataset. e.g. _id. By defauly this
 *  function purely generates color stops.
 */
hatti.map.utils.generate_stops = (function hatti$map$utils$generate_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Generates cirlce size property stops base on values from dataset.
 */
hatti.map.utils.generate_size_stops = (function hatti$map$utils$generate_size_stops(selected_id,selected_color){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(4)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [selected_id,selected_color], null)], null);
});
/**
 * Gets predefined styles for diffent layer types and states.
 */
hatti.map.utils.get_styles = (function hatti$map$utils$get_styles(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33458 = arguments.length;
var i__7485__auto___33459 = (0);
while(true){
if((i__7485__auto___33459 < len__7484__auto___33458)){
args__7491__auto__.push((arguments[i__7485__auto___33459]));

var G__33460 = (i__7485__auto___33459 + (1));
i__7485__auto___33459 = G__33460;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((0) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((0)),(0),null)):null);
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(argseq__7492__auto__);
});

hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic = (function (p__33454){
var vec__33455 = p__33454;
var selected_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33455,(0),null);
var stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33455,(1),null);
var size_stops = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33455,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$point,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",(4)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null),cljs.core.cst$kw$sized,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-radius",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(size_stops)?size_stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(6)], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["circle-opacity",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(3),0.2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(15),0.8], null)], null)], null))], null)], null)], null),cljs.core.cst$kw$fill,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-opacity",0.7], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-outline-color","#666"], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["fill-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null),cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$normal,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,(cljs.core.truth_(stops)?stops:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"#f30"], null)], null))], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-opacity",0.8], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-width",(7)], null)], null),cljs.core.cst$kw$hover,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#631400")], null))], null)], null),cljs.core.cst$kw$clicked,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["line-color",cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,"_id",cljs.core.cst$kw$type,"categorical",cljs.core.cst$kw$stops,hatti.map.utils.generate_stops(selected_id,"#ad2300")], null))], null)], null)], null)], null);
});

hatti.map.utils.get_styles.cljs$lang$maxFixedArity = (0);

hatti.map.utils.get_styles.cljs$lang$applyTo = (function (seq33453){
return hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33453));
});

/**
 * Get style properties for layer.
 */
hatti.map.utils.get_style_properties = (function hatti$map$utils$get_style_properties(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33469 = arguments.length;
var i__7485__auto___33470 = (0);
while(true){
if((i__7485__auto___33470 < len__7484__auto___33469)){
args__7491__auto__.push((arguments[i__7485__auto___33470]));

var G__33471 = (i__7485__auto___33470 + (1));
i__7485__auto___33470 = G__33471;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic = (function (style_type,style_state,p__33464){
var map__33465 = p__33464;
var map__33465__$1 = ((((!((map__33465 == null)))?((((map__33465.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33465.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33465):map__33465);
var selected_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33465__$1,cljs.core.cst$kw$selected_DASH_id);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33465__$1,cljs.core.cst$kw$stops);
var G__33467 = (function (){var G__33468 = hatti.map.utils.get_styles.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([selected_id,stops], 0));
return (style_type.cljs$core$IFn$_invoke$arity$1 ? style_type.cljs$core$IFn$_invoke$arity$1(G__33468) : style_type.call(null,G__33468));
})();
return (style_state.cljs$core$IFn$_invoke$arity$1 ? style_state.cljs$core$IFn$_invoke$arity$1(G__33467) : style_state.call(null,G__33467));
});

hatti.map.utils.get_style_properties.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_style_properties.cljs$lang$applyTo = (function (seq33461){
var G__33462 = cljs.core.first(seq33461);
var seq33461__$1 = cljs.core.next(seq33461);
var G__33463 = cljs.core.first(seq33461__$1);
var seq33461__$2 = cljs.core.next(seq33461__$1);
return hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(G__33462,G__33463,seq33461__$2);
});

/**
 * Sets maps paint properties given layer-id and list of properties to set.
 *   properties should be a list of properties that contains the propery name
 *   and value in a vector. e.g. [[property1 value1] [property2 value2]
 */
hatti.map.utils.set_mapboxgl_paint_property = (function hatti$map$utils$set_mapboxgl_paint_property(map,layer_id,properties){
var seq__33482 = cljs.core.seq(properties);
var chunk__33483 = null;
var count__33484 = (0);
var i__33485 = (0);
while(true){
if((i__33485 < count__33484)){
var vec__33486 = chunk__33483.cljs$core$IIndexed$_nth$arity$2(null,i__33485);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33486,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33486,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__33492 = seq__33482;
var G__33493 = chunk__33483;
var G__33494 = count__33484;
var G__33495 = (i__33485 + (1));
seq__33482 = G__33492;
chunk__33483 = G__33493;
count__33484 = G__33494;
i__33485 = G__33495;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__33482);
if(temp__4657__auto__){
var seq__33482__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33482__$1)){
var c__7220__auto__ = cljs.core.chunk_first(seq__33482__$1);
var G__33496 = cljs.core.chunk_rest(seq__33482__$1);
var G__33497 = c__7220__auto__;
var G__33498 = cljs.core.count(c__7220__auto__);
var G__33499 = (0);
seq__33482 = G__33496;
chunk__33483 = G__33497;
count__33484 = G__33498;
i__33485 = G__33499;
continue;
} else {
var vec__33489 = cljs.core.first(seq__33482__$1);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33489,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33489,(1),null);
map.setPaintProperty(layer_id,p,v);

var G__33500 = cljs.core.next(seq__33482__$1);
var G__33501 = null;
var G__33502 = (0);
var G__33503 = (0);
seq__33482 = G__33500;
chunk__33483 = G__33501;
count__33484 = G__33502;
i__33485 = G__33503;
continue;
}
} else {
return null;
}
}
break;
}
});
hatti.map.utils.get_id_property = (function hatti$map$utils$get_id_property(features){
var properties = (cljs.core.first(features)["properties"]);
var or__6409__auto__ = (properties["id"]);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return (properties[hatti.constants._id]);
}
});
/**
 * Register map mouse events.
 */
hatti.map.utils.register_mapboxgl_mouse_events = (function hatti$map$utils$register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style){
var layer_id = id_string;
var mousemove_fn = ((function (layer_id){
return (function (e){
if(cljs.core.truth_(map.getLayer(layer_id))){
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
var selected_id = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$submission_DASH_clicked,cljs.core.cst$kw$id], null));
map.getCanvas().style.cursor = (((features.length > (0)))?"pointer":"");

if(cljs.core.truth_(view_by)){
return null;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(no_of_features,(1))){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$hover,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,hatti.map.utils.get_id_property(features)], 0)));
} else {
hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties(style,cljs.core.cst$kw$normal));

if(cljs.core.truth_(selected_id)){
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,selected_id], 0)));
} else {
return null;
}
}
}
} else {
return null;
}
});})(layer_id))
;
var click_fn = ((function (layer_id,mousemove_fn){
return (function (e){
if(cljs.core.truth_(map.getLayer(layer_id))){
var features = map.queryRenderedFeatures(e.point,cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
var no_of_features = features.length;
var view_by = om.core.get_props.cljs$core$IFn$_invoke$arity$2(owner,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$map_DASH_page,cljs.core.cst$kw$view_DASH_by], null));
if((no_of_features > (0))){
var feature_id = hatti.map.utils.get_id_property(features);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mapped_DASH_submission_DASH_to_DASH_id,feature_id], null));

if(cljs.core.truth_(view_by)){
return null;
} else {
return hatti.map.utils.set_mapboxgl_paint_property(map,layer_id,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$clicked,cljs.core.array_seq([cljs.core.cst$kw$selected_DASH_id,feature_id], 0)));
}
} else {
return null;
}
} else {
return null;
}
});})(layer_id,mousemove_fn))
;
map.off("mousemove",om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mousemove_DASH_fn));

map.off("click",om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$click_DASH_fn));

map.on("mousemove",mousemove_fn);

map.on("click",click_fn);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$mousemove_DASH_fn,mousemove_fn);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$click_DASH_fn,click_fn);
});
/**
 * Fits map boundaries on rendered features.
 */
hatti.map.utils.fitMapBounds = (function hatti$map$utils$fitMapBounds(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33511 = arguments.length;
var i__7485__auto___33512 = (0);
while(true){
if((i__7485__auto___33512 < len__7484__auto___33511)){
args__7491__auto__.push((arguments[i__7485__auto___33512]));

var G__33513 = (i__7485__auto___33512 + (1));
i__7485__auto___33512 = G__33513;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__33507){
var vec__33508 = p__33507;
var geojson = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33508,(0),null);
var features = (function (){var or__6409__auto__ = cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var or__6409__auto____$1 = (cljs.core.truth_(map.getLayer(layer_id))?map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null))):null);
if(cljs.core.truth_(or__6409__auto____$1)){
return or__6409__auto____$1;
} else {
return cljs.core.PersistentVector.EMPTY;
}
}
})();
var layer_data = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,features], null));
}
})();
var bbox = turf.bbox(cljs.core.clj__GT_js(layer_data));
if((cljs.core.count(features) > (0))){
return map.fitBounds(bbox,({"padding": "15", "linear": true}));
} else {
return null;
}
});

hatti.map.utils.fitMapBounds.cljs$lang$maxFixedArity = (2);

hatti.map.utils.fitMapBounds.cljs$lang$applyTo = (function (seq33504){
var G__33505 = cljs.core.first(seq33504);
var seq33504__$1 = cljs.core.next(seq33504);
var G__33506 = cljs.core.first(seq33504__$1);
var seq33504__$2 = cljs.core.next(seq33504__$1);
return hatti.map.utils.fitMapBounds.cljs$core$IFn$_invoke$arity$variadic(G__33505,G__33506,seq33504__$2);
});

/**
 * Get marker style for field type.
 */
hatti.map.utils.geotype__GT_marker_style = (function hatti$map$utils$geotype__GT_marker_style(p__33514){
var map__33517 = p__33514;
var map__33517__$1 = ((((!((map__33517 == null)))?((((map__33517.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33517.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33517):map__33517);
var field = map__33517__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33517__$1,cljs.core.cst$kw$children);
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.geoshape_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.ona.forms.osm_QMARK_(field);
}
})())){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"fill",cljs.core.cst$kw$style,cljs.core.cst$kw$fill], null);
} else {
if(cljs.core.truth_((function (){var or__6409__auto__ = hatti.ona.forms.geotrace_QMARK_(field);
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
var and__6397__auto__ = hatti.ona.forms.repeat_QMARK_(field);
if(cljs.core.truth_(and__6397__auto__)){
return hatti.ona.forms.geotrace_QMARK_(cljs.core.first(children));
} else {
return and__6397__auto__;
}
}
})())){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$layer_DASH_type,"line",cljs.core.cst$kw$style,cljs.core.cst$kw$line,cljs.core.cst$kw$layout,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line_DASH_join,"round",cljs.core.cst$kw$line_DASH_cap,"round"], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$layer_DASH_type,"circle",cljs.core.cst$kw$style,cljs.core.cst$kw$point], null);

}
}
});
/**
 * Filter features and return only selected features. Returns all features
 *   features if selected-ids is nil. 
 */
hatti.map.utils.filter_selected_features = (function hatti$map$utils$filter_selected_features(features,selected_ids){
var G__33525 = features;
if(cljs.core.truth_(selected_ids)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__33525){
return (function (p__33526){
var map__33527 = p__33526;
var map__33527__$1 = ((((!((map__33527 == null)))?((((map__33527.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33527.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33527):map__33527);
var map__33528 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33527__$1,cljs.core.cst$kw$properties);
var map__33528__$1 = ((((!((map__33528 == null)))?((((map__33528.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33528.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33528):map__33528);
var _id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33528__$1,cljs.core.cst$kw$_id);
return chimera.seq.in_QMARK_(selected_ids,_id);
});})(G__33525))
,G__33525);
} else {
return G__33525;
}
});
/**
 * Counts points collected into hexbins.
 */
hatti.map.utils.count_hexbin_points = (function hatti$map$utils$count_hexbin_points(hexbins){
var iter__7189__auto__ = (function hatti$map$utils$count_hexbin_points_$_iter__33553(s__33554){
return (new cljs.core.LazySeq(null,(function (){
var s__33554__$1 = s__33554;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33554__$1);
if(temp__4657__auto__){
var s__33554__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33554__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33554__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33556 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33555 = (0);
while(true){
if((i__33555 < size__7188__auto__)){
var map__33567 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33555);
var map__33567__$1 = ((((!((map__33567 == null)))?((((map__33567.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33567.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33567):map__33567);
var feature = map__33567__$1;
var map__33568 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33567__$1,cljs.core.cst$kw$properties);
var map__33568__$1 = ((((!((map__33568 == null)))?((((map__33568.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33568.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33568):map__33568);
var points = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33568__$1,cljs.core.cst$kw$points);
var point_count = cljs.core.count(points);
cljs.core.chunk_append(b__33556,(((point_count > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(feature,cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$point_DASH_count,point_count], null)):null));

var G__33575 = (i__33555 + (1));
i__33555 = G__33575;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33556),hatti$map$utils$count_hexbin_points_$_iter__33553(cljs.core.chunk_rest(s__33554__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33556),null);
}
} else {
var map__33571 = cljs.core.first(s__33554__$2);
var map__33571__$1 = ((((!((map__33571 == null)))?((((map__33571.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33571.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33571):map__33571);
var feature = map__33571__$1;
var map__33572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33571__$1,cljs.core.cst$kw$properties);
var map__33572__$1 = ((((!((map__33572 == null)))?((((map__33572.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33572.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33572):map__33572);
var points = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33572__$1,cljs.core.cst$kw$points);
var point_count = cljs.core.count(points);
return cljs.core.cons((((point_count > (0)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(feature,cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$point_DASH_count,point_count], null)):null),hatti$map$utils$count_hexbin_points_$_iter__33553(cljs.core.rest(s__33554__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7189__auto__(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(hexbins));
});
hatti.map.utils.get_rendered_features = (function hatti$map$utils$get_rendered_features(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33583 = arguments.length;
var i__7485__auto___33584 = (0);
while(true){
if((i__7485__auto___33584 < len__7484__auto___33583)){
args__7491__auto__.push((arguments[i__7485__auto___33584]));

var G__33585 = (i__7485__auto___33584 + (1));
i__7485__auto___33584 = G__33585;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__33580){
var map__33581 = p__33580;
var map__33581__$1 = ((((!((map__33581 == null)))?((((map__33581.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33581.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33581):map__33581);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33581__$1,cljs.core.cst$kw$geojson);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33581__$1,cljs.core.cst$kw$selected_DASH_ids);

var get_rendered_features = ((function (map__33581,map__33581__$1,geojson,selected_ids){
return (function (){
return map.queryRenderedFeatures(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$layers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [layer_id], null)], null)));
});})(map__33581,map__33581__$1,geojson,selected_ids))
;
var rendered_features = (function (){var or__6409__auto__ = geojson;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"FeatureCollection",cljs.core.cst$kw$features,get_rendered_features()], null);
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(rendered_features,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$features], null),((function (get_rendered_features,rendered_features,map__33581,map__33581__$1,geojson,selected_ids){
return (function (p1__33576_SHARP_){
return hatti.map.utils.filter_selected_features(p1__33576_SHARP_,selected_ids);
});})(get_rendered_features,rendered_features,map__33581,map__33581__$1,geojson,selected_ids))
);
});

hatti.map.utils.get_rendered_features.cljs$lang$maxFixedArity = (2);

hatti.map.utils.get_rendered_features.cljs$lang$applyTo = (function (seq33577){
var G__33578 = cljs.core.first(seq33577);
var seq33577__$1 = cljs.core.next(seq33577);
var G__33579 = cljs.core.first(seq33577__$1);
var seq33577__$2 = cljs.core.next(seq33577__$1);
return hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(G__33578,G__33579,seq33577__$2);
});

/**
 * Generates hexbins with point count aggregation given rendered
 *   layer-id or geojson.
 */
hatti.map.utils.generate_hexgrid = (function hatti$map$utils$generate_hexgrid(map,layer_id,geojson,p__33586){
var map__33595 = p__33586;
var map__33595__$1 = ((((!((map__33595 == null)))?((((map__33595.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33595.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33595):map__33595);
var cell_width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33595__$1,cljs.core.cst$kw$cell_DASH_width);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33595__$1,cljs.core.cst$kw$selected_DASH_ids);
var rendered_features = hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(map,layer_id,cljs.core.array_seq([cljs.core.cst$kw$geojson,geojson,cljs.core.cst$kw$selected_DASH_ids,selected_ids], 0));
var js_rendered_features = cljs.core.clj__GT_js(rendered_features);
var bbox = turf.bbox(js_rendered_features);
var cellWidth = (function (){var or__6409__auto__ = cell_width;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.hexbin_cell_width;
}
})();
var units = "kilometers";
var hexgrid = turf.hexGrid(bbox,cellWidth,units);
var hex_collection = turf.collect(hexgrid,js_rendered_features,"_id","points");
var hexbins = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(hex_collection,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
var features_w_count = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,hatti.map.utils.count_hexbin_points(hexbins));
var point_counts = (function (){var iter__7189__auto__ = ((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__33595,map__33595__$1,cell_width,selected_ids){
return (function hatti$map$utils$generate_hexgrid_$_iter__33597(s__33598){
return (new cljs.core.LazySeq(null,((function (rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__33595,map__33595__$1,cell_width,selected_ids){
return (function (){
var s__33598__$1 = s__33598;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__33598__$1);
if(temp__4657__auto__){
var s__33598__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__33598__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__33598__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__33600 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__33599 = (0);
while(true){
if((i__33599 < size__7188__auto__)){
var f = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__33599);
cljs.core.chunk_append(b__33600,cljs.core.cst$kw$point_DASH_count.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(f)));

var G__33603 = (i__33599 + (1));
i__33599 = G__33603;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__33600),hatti$map$utils$generate_hexgrid_$_iter__33597(cljs.core.chunk_rest(s__33598__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__33600),null);
}
} else {
var f = cljs.core.first(s__33598__$2);
return cljs.core.cons(cljs.core.cst$kw$point_DASH_count.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(f)),hatti$map$utils$generate_hexgrid_$_iter__33597(cljs.core.rest(s__33598__$2)));
}
} else {
return null;
}
break;
}
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__33595,map__33595__$1,cell_width,selected_ids))
,null,null));
});})(rendered_features,js_rendered_features,bbox,cellWidth,units,hexgrid,hex_collection,hexbins,features_w_count,map__33595,map__33595__$1,cell_width,selected_ids))
;
return iter__7189__auto__(features_w_count);
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(hexbins,cljs.core.cst$kw$features,features_w_count,cljs.core.array_seq([cljs.core.cst$kw$properties,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$min_DASH_count,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,point_counts),cljs.core.cst$kw$max_DASH_count,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,point_counts)], null)], 0));
});
/**
 * Show/or hide geopoints. Hide geopoints if hide-points is true.
 */
hatti.map.utils.show_hide_points = (function hatti$map$utils$show_hide_points(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33611 = arguments.length;
var i__7485__auto___33612 = (0);
while(true){
if((i__7485__auto___33612 < len__7484__auto___33611)){
args__7491__auto__.push((arguments[i__7485__auto___33612]));

var G__33613 = (i__7485__auto___33612 + (1));
i__7485__auto___33612 = G__33613;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic = (function (map,layer_id,p__33607){
var vec__33608 = p__33607;
var hide_points_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33608,(0),null);
var visibility = (cljs.core.truth_(hide_points_QMARK_)?"none":"visible");
if(cljs.core.truth_(map.getLayer(layer_id))){
map.setLayoutProperty(layer_id,"visibility",visibility);
} else {
}

if(cljs.core.truth_(map.getLayer(hatti.map.utils.circle_border_id))){
return map.setLayoutProperty(hatti.map.utils.circle_border_id,"visibility",visibility);
} else {
return null;
}
});

hatti.map.utils.show_hide_points.cljs$lang$maxFixedArity = (2);

hatti.map.utils.show_hide_points.cljs$lang$applyTo = (function (seq33604){
var G__33605 = cljs.core.first(seq33604);
var seq33604__$1 = cljs.core.next(seq33604);
var G__33606 = cljs.core.first(seq33604__$1);
var seq33604__$2 = cljs.core.next(seq33604__$1);
return hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(G__33605,G__33606,seq33604__$2);
});

/**
 * Remove layer from map and it's source from map.
 */
hatti.map.utils.remove_layer = (function hatti$map$utils$remove_layer(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33620 = arguments.length;
var i__7485__auto___33621 = (0);
while(true){
if((i__7485__auto___33621 < len__7484__auto___33620)){
args__7491__auto__.push((arguments[i__7485__auto___33621]));

var G__33622 = (i__7485__auto___33621 + (1));
i__7485__auto___33621 = G__33622;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic = (function (map,id,p__33617){
var map__33618 = p__33617;
var map__33618__$1 = ((((!((map__33618 == null)))?((((map__33618.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33618.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33618):map__33618);
var keep_source_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33618__$1,cljs.core.cst$kw$keep_DASH_source_QMARK_);
if(cljs.core.truth_(map.getLayer(id))){
map.removeLayer(id);
} else {
}

if(cljs.core.truth_((function (){var and__6397__auto__ = map.getSource(id);
if(cljs.core.truth_(and__6397__auto__)){
return cljs.core.not(keep_source_QMARK_);
} else {
return and__6397__auto__;
}
})())){
return map.removeSource(id);
} else {
return null;
}
});

hatti.map.utils.remove_layer.cljs$lang$maxFixedArity = (2);

hatti.map.utils.remove_layer.cljs$lang$applyTo = (function (seq33614){
var G__33615 = cljs.core.first(seq33614);
var seq33614__$1 = cljs.core.next(seq33614);
var G__33616 = cljs.core.first(seq33614__$1);
var seq33614__$2 = cljs.core.next(seq33614__$1);
return hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(G__33615,G__33616,seq33614__$2);
});

/**
 * Renders hexbin layer on map.
 */
hatti.map.utils.show_hexbins = (function hatti$map$utils$show_hexbins(owner,map,id_string,geojson,p__33623){
var map__33628 = p__33623;
var map__33628__$1 = ((((!((map__33628 == null)))?((((map__33628.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33628.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33628):map__33628);
var opts = map__33628__$1;
var cell_color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33628__$1,cljs.core.cst$kw$cell_DASH_color);
var extrusion_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33628__$1,cljs.core.cst$kw$extrusion_QMARK_);
var hide_points_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33628__$1,cljs.core.cst$kw$hide_DASH_points_QMARK_);
var hexgrid = hatti.map.utils.generate_hexgrid(map,id_string,geojson,opts);
var map__33630 = cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(hexgrid);
var map__33630__$1 = ((((!((map__33630 == null)))?((((map__33630.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33630.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33630):map__33630);
var min_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33630__$1,cljs.core.cst$kw$min_DASH_count);
var max_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33630__$1,cljs.core.cst$kw$max_DASH_count);
var max_color = (function (){var or__6409__auto__ = cell_color;
if(cljs.core.truth_(or__6409__auto__)){
return or__6409__auto__;
} else {
return hatti.constants.max_count_color;
}
})();
var min_color = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(min_count,max_count))?max_color:hatti.constants.min_count_color);
var property = "point-count";
var fill_color = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$property,"point-count",cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,min_color], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,max_color], null)], null)], null);
var fill_opacity = 0.6;
var paint = (cljs.core.truth_(extrusion_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fill_DASH_extrusion_DASH_color,fill_color,cljs.core.cst$kw$fill_DASH_extrusion_DASH_opacity,fill_opacity,cljs.core.cst$kw$fill_DASH_extrusion_DASH_height,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$property,property,cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [min_count,(10)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,(25000)], null)], null),cljs.core.cst$kw$base,(1)], null)], null):new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$fill_DASH_outline_DASH_color,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$property,property,cljs.core.cst$kw$stops,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"transparent"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [max_count,"white"], null)], null)], null),cljs.core.cst$kw$fill_DASH_color,fill_color,cljs.core.cst$kw$fill_DASH_opacity,fill_opacity], null));
var layer_type = (cljs.core.truth_(extrusion_QMARK_)?"fill-extrusion":"fill");
var extrusion_layer_id = [cljs.core.str(hatti.constants.hexgrid_id),cljs.core.str("-extrusion")].join('');
if(cljs.core.truth_((function (){var and__6397__auto__ = min_count;
if(cljs.core.truth_(and__6397__auto__)){
return max_count;
} else {
return and__6397__auto__;
}
})())){
hatti.map.utils.add_mapboxgl_source(map,hatti.constants.hexgrid_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$geojson,hexgrid], null));

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,hatti.constants.hexgrid_id,layer_type,cljs.core.array_seq([cljs.core.cst$kw$paint,paint], 0));

if(cljs.core.truth_(extrusion_QMARK_)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,hatti.constants.hexgrid_id,layer_type,cljs.core.array_seq([cljs.core.cst$kw$paint,paint,cljs.core.cst$kw$layer_DASH_id,extrusion_layer_id], 0));

map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","none");
} else {
map.setLayoutProperty(hatti.constants.hexgrid_id,"visibility","visible");

hatti.map.utils.remove_layer.cljs$core$IFn$_invoke$arity$variadic(map,extrusion_layer_id,cljs.core.array_seq([cljs.core.cst$kw$keep_DASH_source_QMARK_,true], 0));
}

map.setPitch((cljs.core.truth_(extrusion_QMARK_)?(50):(0)));

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([hide_points_QMARK_], 0));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$show_DASH_hexbins_QMARK_,true);
} else {
return null;
}
});
/**
 * Renders heatmap layer on map.
 */
hatti.map.utils.show_heatmap = (function hatti$map$utils$show_heatmap(owner,map,id_string,geojson,p__33632){
var map__33651 = p__33632;
var map__33651__$1 = ((((!((map__33651 == null)))?((((map__33651.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33651.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33651):map__33651);
var selected_ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33651__$1,cljs.core.cst$kw$selected_DASH_ids);
var rendered_features = hatti.map.utils.get_rendered_features.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([cljs.core.cst$kw$geojson,geojson,cljs.core.cst$kw$selected_DASH_ids,selected_ids], 0));
var layers = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (rendered_features,map__33651,map__33651__$1,selected_ids){
return (function (idx,item){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,item], null);
});})(rendered_features,map__33651,map__33651__$1,selected_ids))
,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),"green"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(30),"#ffeda0"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(80),"orange"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(200),"red"], null)], null));
var layer_count = cljs.core.count(layers);
hatti.map.utils.add_mapboxgl_source(map,"heatmap",new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$geojson,rendered_features,cljs.core.cst$kw$cluster,true,cljs.core.cst$kw$clusterRadius,(20),cljs.core.cst$kw$clusterMaxZoom,(15)], null));

var seq__33653_33669 = cljs.core.seq(layers);
var chunk__33654_33670 = null;
var count__33655_33671 = (0);
var i__33656_33672 = (0);
while(true){
if((i__33656_33672 < count__33655_33671)){
var vec__33657_33673 = chunk__33654_33670.cljs$core$IIndexed$_nth$arity$2(null,i__33656_33672);
var i_33674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33657_33673,(0),null);
var vec__33660_33675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33657_33673,(1),null);
var point_count_33676 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33660_33675,(0),null);
var color_33677 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33660_33675,(1),null);
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,"heatmap","circle",cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,[cljs.core.str("cluster-"),cljs.core.str(i_33674)].join(''),cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$circle_DASH_color,color_33677,cljs.core.cst$kw$circle_DASH_radius,(70),cljs.core.cst$kw$circle_DASH_blur,(1),cljs.core.cst$kw$circle_DASH_opacity,0.7], null),cljs.core.cst$kw$filter,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i_33674,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_33676], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_33676], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first(cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(layers,(i_33674 + (1)))))], null)], null))], 0));

var G__33678 = seq__33653_33669;
var G__33679 = chunk__33654_33670;
var G__33680 = count__33655_33671;
var G__33681 = (i__33656_33672 + (1));
seq__33653_33669 = G__33678;
chunk__33654_33670 = G__33679;
count__33655_33671 = G__33680;
i__33656_33672 = G__33681;
continue;
} else {
var temp__4657__auto___33682 = cljs.core.seq(seq__33653_33669);
if(temp__4657__auto___33682){
var seq__33653_33683__$1 = temp__4657__auto___33682;
if(cljs.core.chunked_seq_QMARK_(seq__33653_33683__$1)){
var c__7220__auto___33684 = cljs.core.chunk_first(seq__33653_33683__$1);
var G__33685 = cljs.core.chunk_rest(seq__33653_33683__$1);
var G__33686 = c__7220__auto___33684;
var G__33687 = cljs.core.count(c__7220__auto___33684);
var G__33688 = (0);
seq__33653_33669 = G__33685;
chunk__33654_33670 = G__33686;
count__33655_33671 = G__33687;
i__33656_33672 = G__33688;
continue;
} else {
var vec__33663_33689 = cljs.core.first(seq__33653_33683__$1);
var i_33690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33663_33689,(0),null);
var vec__33666_33691 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33663_33689,(1),null);
var point_count_33692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33666_33691,(0),null);
var color_33693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33666_33691,(1),null);
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,"heatmap","circle",cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,[cljs.core.str("cluster-"),cljs.core.str(i_33690)].join(''),cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$circle_DASH_color,color_33693,cljs.core.cst$kw$circle_DASH_radius,(70),cljs.core.cst$kw$circle_DASH_blur,(1),cljs.core.cst$kw$circle_DASH_opacity,0.7], null),cljs.core.cst$kw$filter,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i_33690,(layer_count - (1))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_33692], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["all",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [">=","point_count",point_count_33692], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["<","point_count",cljs.core.first(cljs.core.second(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(layers,(i_33690 + (1)))))], null)], null))], 0));

var G__33694 = cljs.core.next(seq__33653_33683__$1);
var G__33695 = null;
var G__33696 = (0);
var G__33697 = (0);
seq__33653_33669 = G__33694;
chunk__33654_33670 = G__33695;
count__33655_33671 = G__33696;
i__33656_33672 = G__33697;
continue;
}
} else {
}
}
break;
}

hatti.map.utils.show_hide_points.cljs$core$IFn$_invoke$arity$variadic(map,id_string,cljs.core.array_seq([true], 0));

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$show_DASH_heatmap_QMARK_,true);
});
/**
 * Functions that are called after map is loaded in DOM.
 */
hatti.map.utils.map_on_load = (function hatti$map$utils$map_on_load(var_args){
var args__7491__auto__ = [];
var len__7484__auto___33709 = arguments.length;
var i__7485__auto___33710 = (0);
while(true){
if((i__7485__auto___33710 < len__7484__auto___33709)){
args__7491__auto__.push((arguments[i__7485__auto___33710]));

var G__33711 = (i__7485__auto___33710 + (1));
i__7485__auto___33710 = G__33711;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((3) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((3)),(0),null)):null);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7492__auto__);
});

hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic = (function (map,event_chan,id_string,p__33702){
var map__33703 = p__33702;
var map__33703__$1 = ((((!((map__33703 == null)))?((((map__33703.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33703.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33703):map__33703);
var map_data = map__33703__$1;
var geofield = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33703__$1,cljs.core.cst$kw$geofield);
var owner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33703__$1,cljs.core.cst$kw$owner);
var tiles_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33703__$1,cljs.core.cst$kw$tiles_DASH_url);
var geojson = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33703__$1,cljs.core.cst$kw$geojson);
var map__33705 = hatti.map.utils.geotype__GT_marker_style(geofield);
var map__33705__$1 = ((((!((map__33705 == null)))?((((map__33705.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33705.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33705):map__33705);
var layer_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33705__$1,cljs.core.cst$kw$layer_DASH_type);
var layout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33705__$1,cljs.core.cst$kw$layout);
var style = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33705__$1,cljs.core.cst$kw$style);
var map__33706 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(owner);
var map__33706__$1 = ((((!((map__33706 == null)))?((((map__33706.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33706.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33706):map__33706);
var stops = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33706__$1,cljs.core.cst$kw$stops);
var layer_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33706__$1,cljs.core.cst$kw$layer_DASH_opts);
var show_hexbins_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33706__$1,cljs.core.cst$kw$show_DASH_hexbins_QMARK_);
var show_heatmap_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33706__$1,cljs.core.cst$kw$show_DASH_heatmap_QMARK_);
if(cljs.core.truth_((function (){var or__6409__auto__ = (cljs.core.count(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geojson)) > (0));
if(or__6409__auto__){
return or__6409__auto__;
} else {
return tiles_url;
}
})())){
om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,false);

hatti.map.utils.add_mapboxgl_source(map,id_string,map_data);

hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layout,layout,cljs.core.cst$kw$tiles_DASH_url,tiles_url], 0));

hatti.map.utils.register_mapboxgl_mouse_events(owner,map,event_chan,id_string,style);

hatti.map.utils.set_mapboxgl_paint_property(map,id_string,hatti.map.utils.get_style_properties.cljs$core$IFn$_invoke$arity$variadic(style,cljs.core.cst$kw$normal,cljs.core.array_seq([cljs.core.cst$kw$stops,stops], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$point,style)){
hatti.map.utils.add_mapboxgl_layer.cljs$core$IFn$_invoke$arity$variadic(map,id_string,layer_type,cljs.core.array_seq([cljs.core.cst$kw$layer_DASH_id,hatti.map.utils.circle_border_id,cljs.core.cst$kw$tiles_DASH_url,tiles_url,cljs.core.cst$kw$paint,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$circle_DASH_color,"#fff",cljs.core.cst$kw$circle_DASH_radius,(6)], null)], 0));
} else {
if(cljs.core.truth_(map.getLayer(hatti.map.utils.circle_border_id))){
map.removeLayer(hatti.map.utils.circle_border_id);
} else {
}
}

if(cljs.core.truth_(show_hexbins_QMARK_)){
hatti.map.utils.show_hexbins(owner,map,id_string,geojson,layer_opts);
} else {
}

if(cljs.core.truth_(show_heatmap_QMARK_)){
hatti.map.utils.show_heatmap(owner,map,id_string,geojson,layer_opts);
} else {
}

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$geojson,geojson);

om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$style,style);

return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$loaded_QMARK_,true);
} else {
return null;
}
});

hatti.map.utils.map_on_load.cljs$lang$maxFixedArity = (3);

hatti.map.utils.map_on_load.cljs$lang$applyTo = (function (seq33698){
var G__33699 = cljs.core.first(seq33698);
var seq33698__$1 = cljs.core.next(seq33698);
var G__33700 = cljs.core.first(seq33698__$1);
var seq33698__$2 = cljs.core.next(seq33698__$1);
var G__33701 = cljs.core.first(seq33698__$2);
var seq33698__$3 = cljs.core.next(seq33698__$2);
return hatti.map.utils.map_on_load.cljs$core$IFn$_invoke$arity$variadic(G__33699,G__33700,G__33701,seq33698__$3);
});

/**
 * Set default style
 */
hatti.map.utils.clear_map_styles = (function hatti$map$utils$clear_map_styles(owner){
return hatti.map.utils.set_mapboxgl_paint_property(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$mapboxgl_DASH_map),om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$layer_DASH_id),hatti.map.utils.get_style_properties(om.core.get_state.cljs$core$IFn$_invoke$arity$2(owner,cljs.core.cst$kw$style),cljs.core.cst$kw$normal));
});
/**
 * Update map zoom level in local component state on zoom event.
 */
hatti.map.utils.set_zoom_level = (function hatti$map$utils$set_zoom_level(owner){
var map__33714 = om.core.get_state.cljs$core$IFn$_invoke$arity$1(owner);
var map__33714__$1 = ((((!((map__33714 == null)))?((((map__33714.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33714.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33714):map__33714);
var mapboxgl_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33714__$1,cljs.core.cst$kw$mapboxgl_DASH_map);
var zoom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33714__$1,cljs.core.cst$kw$zoom);
var next_zoom = mapboxgl_map.getZoom();
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(zoom,next_zoom)){
return om.core.set_state_BANG_.cljs$core$IFn$_invoke$arity$3(owner,cljs.core.cst$kw$zoom,next_zoom);
} else {
return null;
}
});
