// Compiled by ClojureScript 1.9.229 {:static-fns true, :optimize-constants true}
goog.provide('hatti.charting');
goog.require('cljs.core');
goog.require('chimera.js_interop');
goog.require('c2.layout.histogram');
goog.require('chimera.date');
goog.require('hatti.maths');
goog.require('cljs_time.coerce');
goog.require('c2.scale');
goog.require('cljs_time.format');
goog.require('hatti.ona.forms');
goog.require('c2.svg');
goog.require('clojure.string');
hatti.charting.millis_in_day = (86400000);
/**
 * Parse an integer from a string.
 */
hatti.charting.parse_int = (function hatti$charting$parse_int(st){
var ans = parseInt(st);
if(cljs.core.truth_(isNaN(ans))){
return null;
} else {
return ans;
}
});
hatti.charting.parse_date = (function hatti$charting$parse_date(date_string){
if(cljs.core.truth_(date_string)){
return hatti.maths.floor((cljs_time.coerce.to_long((new Date(date_string))) / hatti.charting.millis_in_day));
} else {
return null;
}
});
/**
 * Remove the colon in a time string
 *   String -> String
 */
hatti.charting.parse_time = (function hatti$charting$parse_time(time_string){
if(cljs.core.truth_(time_string)){
return hatti.charting.parse_int(clojure.string.replace(time_string,/:/,""));
} else {
return null;
}
});
/**
 * Converts string to integer, for typ (int|date).
 */
hatti.charting.str__GT_int = (function hatti$charting$str__GT_int(typ){
var G__34628 = typ;
switch (G__34628) {
case "int":
return hatti.charting.parse_int;

break;
case "date":
return hatti.charting.parse_date;

break;
case "time":
return hatti.charting.parse_time;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});
hatti.charting.time__GT_string = (function hatti$charting$time__GT_string(time){
return clojure.string.replace([cljs.core.str(time)].join(''),/..$/,(function (p1__34630_SHARP_){
return [cljs.core.str(":"),cljs.core.str(p1__34630_SHARP_)].join('');
}));
});
/**
 * Converts integers to strings, for type (int|date).
 * Optional digits parameter = number of digits after decimal, default is 1.
 */
hatti.charting.int__GT_str = (function hatti$charting$int__GT_str(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34641 = arguments.length;
var i__7485__auto___34642 = (0);
while(true){
if((i__7485__auto___34642 < len__7484__auto___34641)){
args__7491__auto__.push((arguments[i__7485__auto___34642]));

var G__34643 = (i__7485__auto___34642 + (1));
i__7485__auto___34642 = G__34643;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic = (function (typ,p__34637){
var map__34638 = p__34637;
var map__34638__$1 = ((((!((map__34638 == null)))?((((map__34638.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34638.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34638):map__34638);
var digits = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34638__$1,cljs.core.cst$kw$digits,(1));
var int_fmt_s = [cljs.core.str("%."),cljs.core.str(digits),cljs.core.str("f")].join('');
var d__GT_millis = ((function (int_fmt_s,map__34638,map__34638__$1,digits){
return (function (p1__34631_SHARP_){
return (hatti.charting.millis_in_day * p1__34631_SHARP_);
});})(int_fmt_s,map__34638,map__34638__$1,digits))
;
var date__GT_str = ((function (int_fmt_s,d__GT_millis,map__34638,map__34638__$1,digits){
return (function (p1__34632_SHARP_){
if(cljs.core.truth_(p1__34632_SHARP_)){
return chimera.date.format_date(p1__34632_SHARP_);
} else {
return null;
}
});})(int_fmt_s,d__GT_millis,map__34638,map__34638__$1,digits))
;
var G__34640 = typ;
switch (G__34640) {
case "int":
return ((function (G__34640,int_fmt_s,d__GT_millis,date__GT_str,map__34638,map__34638__$1,digits){
return (function (p1__34633_SHARP_){
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(int_fmt_s,cljs.core.array_seq([p1__34633_SHARP_], 0));
});
;})(G__34640,int_fmt_s,d__GT_millis,date__GT_str,map__34638,map__34638__$1,digits))

break;
case "date":
return ((function (G__34640,int_fmt_s,d__GT_millis,date__GT_str,map__34638,map__34638__$1,digits){
return (function (p1__34634_SHARP_){
return date__GT_str(d__GT_millis(p1__34634_SHARP_));
});
;})(G__34640,int_fmt_s,d__GT_millis,date__GT_str,map__34638,map__34638__$1,digits))

break;
case "time":
return hatti.charting.time__GT_string;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
});

hatti.charting.int__GT_str.cljs$lang$maxFixedArity = (1);

hatti.charting.int__GT_str.cljs$lang$applyTo = (function (seq34635){
var G__34636 = cljs.core.first(seq34635);
var seq34635__$1 = cljs.core.next(seq34635);
return hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(G__34636,seq34635__$1);
});

/**
 * Converts a range of typ (int|date) to a string.
 */
hatti.charting.range__GT_str = (function hatti$charting$range__GT_str(p__34645,typ){
var vec__34652 = p__34645;
var minimum = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34652,(0),null);
var maximum = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34652,(1),null);
var vec__34655 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [hatti.maths.ceil(minimum),hatti.maths.floor(maximum)], null);
var minimum__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34655,(0),null);
var maximum__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34655,(1),null);
var fmt = hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(typ,cljs.core.array_seq([cljs.core.cst$kw$digits,(0)], 0));
if((maximum__$1 <= minimum__$1)){
return (fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(minimum__$1) : fmt.call(null,minimum__$1));
} else {
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" to ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(minimum__$1) : fmt.call(null,minimum__$1)),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(maximum__$1) : fmt.call(null,maximum__$1))], null));
}
});
/**
 * Given a list of answers, returns each one as a bin, in string form.
 * nil is mapped to nil. The bins, in order, are returned as metadata.
 * eg. (evenly-spaced-bins [1 2 10] 5 'int') => ['1 to 2' '1 to 2' '9 to 10']
 * metadata of this above value would be:
 * {:bins ['1 to 2', '3 to 4', '5 to 6', '7 to 8', '9 to 10']}
 */
hatti.charting.evenly_spaced_bins = (function hatti$charting$evenly_spaced_bins(answers,bins,type_STAR_){
var numbers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.charting.str__GT_int(type_STAR_),answers);
var mx = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,numbers));
var mn = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,numbers));
var s = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(bins - ((1) / (10000)))], null)], 0));
var is = cljs.core.map.cljs$core$IFn$_invoke$arity$2(hatti.maths.floor,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s){
return (function (p1__34658_SHARP_){
if(cljs.core.truth_(p1__34658_SHARP_)){
return (s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(p1__34658_SHARP_) : s.call(null,p1__34658_SHARP_));
} else {
return null;
}
});})(numbers,mx,mn,s))
,numbers));
var t = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),bins], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mn,mx], null)], 0));
var lbounds = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.float$,cljs.core.map.cljs$core$IFn$_invoke$arity$2(t,cljs.core.range.cljs$core$IFn$_invoke$arity$1(bins))));
var ubounds = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s,is,t,lbounds){
return (function (p1__34659_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__34659_SHARP_,hatti.maths.floor(p1__34659_SHARP_))){
return (p1__34659_SHARP_ - (1));
} else {
return p1__34659_SHARP_;
}
});})(numbers,mx,mn,s,is,t,lbounds))
,cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),lbounds)),mx);
var fmt = hatti.charting.int__GT_str.cljs$core$IFn$_invoke$arity$variadic(type_STAR_,cljs.core.array_seq([cljs.core.cst$kw$digits,(0)], 0));
var strings = cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt){
return (function (p1__34660_SHARP_,p2__34661_SHARP_){
return hatti.charting.range__GT_str(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__34660_SHARP_,p2__34661_SHARP_], null),type_STAR_);
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt))
,lbounds,ubounds);
var results = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings){
return (function (i){
if(cljs.core.truth_(i)){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(strings,(i | (0)));
} else {
return null;
}
});})(numbers,mx,mn,s,is,t,lbounds,ubounds,fmt,strings))
,is);
var strings__$1 = cljs.core.vec(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(strings));
return cljs.core.with_meta(results,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$bins,((cljs.core.contains_QMARK_(cljs.core.set(answers),null))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(strings__$1,null):strings__$1)], null));
});
/**
 * Take chart-data from the ona API, returns label->count map.
 * eg. Input: {:field_xpath 'D' :data [{:count 2 :D ['Option_1']}]}
 * Output: {:Option_1 2}
 * eg. Input: {:field_xpath 'D' :data [{:count 1 :D ['O1' 'O_2']
 * :count 2 :D ['O1']}]}
 * Output: {:Option_1 3 :O_2 1}
 */
hatti.charting.label_count_pairs = (function hatti$charting$label_count_pairs(var_args){
var args34664 = [];
var len__7484__auto___34675 = arguments.length;
var i__7485__auto___34676 = (0);
while(true){
if((i__7485__auto___34676 < len__7484__auto___34675)){
args34664.push((arguments[i__7485__auto___34676]));

var G__34677 = (i__7485__auto___34676 + (1));
i__7485__auto___34676 = G__34677;
continue;
} else {
}
break;
}

var G__34666 = args34664.length;
switch (G__34666) {
case 1:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34664.length)].join('')));

}
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2(chart_data,null);
});

hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__34667 = chart_data;
var map__34667__$1 = ((((!((map__34667 == null)))?((((map__34667.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34667.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34667):map__34667);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34667__$1,cljs.core.cst$kw$data);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34667__$1,cljs.core.cst$kw$field_xpath);
var unboxed = (function (){var iter__7189__auto__ = ((function (map__34667,map__34667__$1,data,field_xpath){
return (function hatti$charting$iter__34669(s__34670){
return (new cljs.core.LazySeq(null,((function (map__34667,map__34667__$1,data,field_xpath){
return (function (){
var s__34670__$1 = s__34670;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34670__$1);
if(temp__4657__auto__){
var s__34670__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34670__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34670__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34672 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34671 = (0);
while(true){
if((i__34671 < size__7188__auto__)){
var data_item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34671);
cljs.core.chunk_append(b__34672,(function (){var labels = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,data_item);
var count = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (i__34671,labels,count,data_item,c__7187__auto__,size__7188__auto__,b__34672,s__34670__$2,temp__4657__auto__,map__34667,map__34667__$1,data,field_xpath){
return (function (p1__34662_SHARP_){
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,p1__34662_SHARP_], null),cljs.core.array_seq([language], 0));
});})(i__34671,labels,count,data_item,c__7187__auto__,size__7188__auto__,b__34672,s__34670__$2,temp__4657__auto__,map__34667,map__34667__$1,data,field_xpath))
;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__34671,labels,count,labelify,data_item,c__7187__auto__,size__7188__auto__,b__34672,s__34670__$2,temp__4657__auto__,map__34667,map__34667__$1,data,field_xpath){
return (function (p1__34663_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify(p1__34663_SHARP_)],[count]);
});})(i__34671,labels,count,labelify,data_item,c__7187__auto__,size__7188__auto__,b__34672,s__34670__$2,temp__4657__auto__,map__34667,map__34667__$1,data,field_xpath))
,labels);
})());

var G__34679 = (i__34671 + (1));
i__34671 = G__34679;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34672),hatti$charting$iter__34669(cljs.core.chunk_rest(s__34670__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34672),null);
}
} else {
var data_item = cljs.core.first(s__34670__$2);
return cljs.core.cons((function (){var labels = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,data_item);
var count = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(data_item);
var labelify = ((function (labels,count,data_item,s__34670__$2,temp__4657__auto__,map__34667,map__34667__$1,data,field_xpath){
return (function (p1__34662_SHARP_){
return hatti.ona.forms.get_label.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$label,p1__34662_SHARP_], null),cljs.core.array_seq([language], 0));
});})(labels,count,data_item,s__34670__$2,temp__4657__auto__,map__34667,map__34667__$1,data,field_xpath))
;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (labels,count,labelify,data_item,s__34670__$2,temp__4657__auto__,map__34667,map__34667__$1,data,field_xpath){
return (function (p1__34663_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([labelify(p1__34663_SHARP_)],[count]);
});})(labels,count,labelify,data_item,s__34670__$2,temp__4657__auto__,map__34667,map__34667__$1,data,field_xpath))
,labels);
})(),hatti$charting$iter__34669(cljs.core.rest(s__34670__$2)));
}
} else {
return null;
}
break;
}
});})(map__34667,map__34667__$1,data,field_xpath))
,null,null));
});})(map__34667,map__34667__$1,data,field_xpath))
;
return iter__7189__auto__(data);
})();
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.last,cljs.core._GT_,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core._PLUS_,cljs.core.flatten(unboxed)));
});

hatti.charting.label_count_pairs.cljs$lang$maxFixedArity = 2;

/**
 * Determine number of bins if there are n possible of values of data.
 *   Custom algorithm, based on a pleasant range of bins being between
 *   roughly 7 and 15 (though customizable). Idea is that we try to divide
 *   n into a number between 
 */
hatti.charting.num_bins = (function hatti$charting$num_bins(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34685 = arguments.length;
var i__7485__auto___34686 = (0);
while(true){
if((i__7485__auto___34686 < len__7484__auto___34685)){
args__7491__auto__.push((arguments[i__7485__auto___34686]));

var G__34687 = (i__7485__auto___34686 + (1));
i__7485__auto___34686 = G__34687;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__34682){
var map__34683 = p__34682;
var map__34683__$1 = ((((!((map__34683 == null)))?((((map__34683.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34683.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34683):map__34683);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34683__$1,cljs.core.cst$kw$data_DASH_type,"int");
var rough_min = (7);
var rough_max = (15);
var real_max = (24);
var full_range = cljs.core.range.cljs$core$IFn$_invoke$arity$2(rough_min,rough_max);
var best_guess = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.maths.gcd,n),full_range));
if((best_guess < rough_min)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(cljs.core.min,real_max,n),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(hatti.maths.lcm,n),full_range));
} else {
return best_guess;
}
});

hatti.charting.num_bins.cljs$lang$maxFixedArity = (1);

hatti.charting.num_bins.cljs$lang$applyTo = (function (seq34680){
var G__34681 = cljs.core.first(seq34680);
var seq34680__$1 = cljs.core.next(seq34680);
return hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(G__34681,seq34680__$1);
});

/**
 * Turn numerical / date chart-data from ona API histogram-friendly.
 *   Return data looks like [(x dx y)] with-meta {:bins num-bins}.
 */
hatti.charting.extract_data_for_histogram = (function hatti$charting$extract_data_for_histogram(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34701 = arguments.length;
var i__7485__auto___34702 = (0);
while(true){
if((i__7485__auto___34702 < len__7484__auto___34701)){
args__7491__auto__.push((arguments[i__7485__auto___34702]));

var G__34703 = (i__7485__auto___34702 + (1));
i__7485__auto___34702 = G__34703;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__34690){
var map__34691 = p__34690;
var map__34691__$1 = ((((!((map__34691 == null)))?((((map__34691.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34691.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34691):map__34691);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34691__$1,cljs.core.cst$kw$data_DASH_type,"int");
var map__34693 = chart_data;
var map__34693__$1 = ((((!((map__34693 == null)))?((((map__34693.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34693.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34693):map__34693);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34693__$1,cljs.core.cst$kw$data);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34693__$1,cljs.core.cst$kw$field_xpath);
var retype_fn = hatti.charting.str__GT_int(data_type);
var qn_key = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath);
var retyped_data = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__34693,map__34693__$1,data,field_xpath,retype_fn,qn_key,map__34691,map__34691__$1,data_type){
return (function (el){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(el,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [qn_key], null),retype_fn);
});})(map__34693,map__34693__$1,data,field_xpath,retype_fn,qn_key,map__34691,map__34691__$1,data_type))
,data);
var data_range = (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(qn_key,retyped_data)) - cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.map.cljs$core$IFn$_invoke$arity$2(qn_key,retyped_data)));
var bins = (((data_range === (0)))?(1):hatti.charting.num_bins.cljs$core$IFn$_invoke$arity$variadic(data_range,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,data_type], 0)));
var binned_data = c2.layout.histogram.histogram.cljs$core$IFn$_invoke$arity$variadic(retyped_data,cljs.core.array_seq([cljs.core.cst$kw$value,qn_key,cljs.core.cst$kw$bins,bins], 0));
return cljs.core.with_meta((function (){var iter__7189__auto__ = ((function (map__34693,map__34693__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__34691,map__34691__$1,data_type){
return (function hatti$charting$iter__34695(s__34696){
return (new cljs.core.LazySeq(null,((function (map__34693,map__34693__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__34691,map__34691__$1,data_type){
return (function (){
var s__34696__$1 = s__34696;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34696__$1);
if(temp__4657__auto__){
var s__34696__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34696__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34696__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34698 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34697 = (0);
while(true){
if((i__34697 < size__7188__auto__)){
var data_item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34697);
cljs.core.chunk_append(b__34698,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.cst$kw$dx.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data_item))], null));

var G__34704 = (i__34697 + (1));
i__34697 = G__34704;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34698),hatti$charting$iter__34695(cljs.core.chunk_rest(s__34696__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34698),null);
}
} else {
var data_item = cljs.core.first(s__34696__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.cst$kw$dx.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(data_item)),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data_item))], null),hatti$charting$iter__34695(cljs.core.rest(s__34696__$2)));
}
} else {
return null;
}
break;
}
});})(map__34693,map__34693__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__34691,map__34691__$1,data_type))
,null,null));
});})(map__34693,map__34693__$1,data,field_xpath,retype_fn,qn_key,retyped_data,data_range,bins,binned_data,map__34691,map__34691__$1,data_type))
;
return iter__7189__auto__(binned_data);
})(),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$bins,bins], null));
});

hatti.charting.extract_data_for_histogram.cljs$lang$maxFixedArity = (1);

hatti.charting.extract_data_for_histogram.cljs$lang$applyTo = (function (seq34688){
var G__34689 = cljs.core.first(seq34688);
var seq34688__$1 = cljs.core.next(seq34688);
return hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(G__34689,seq34688__$1);
});

/**
 * Produces a linear mapping [0,max-count] -> [0, max-length], for data which
 * is a vector, each element a map with key :count. If total-asmax?, then
 * linear map is [0,total-count] -> [0, max-length].
 */
hatti.charting.counts__GT_lengths = (function hatti$charting$counts__GT_lengths(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34711 = arguments.length;
var i__7485__auto___34712 = (0);
while(true){
if((i__7485__auto___34712 < len__7484__auto___34711)){
args__7491__auto__.push((arguments[i__7485__auto___34712]));

var G__34713 = (i__7485__auto___34712 + (1));
i__7485__auto___34712 = G__34713;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((2) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((2)),(0),null)):null);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7492__auto__);
});

hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic = (function (data,max_length,p__34708){
var map__34709 = p__34708;
var map__34709__$1 = ((((!((map__34709 == null)))?((((map__34709.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34709.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34709):map__34709);
var total_as_max_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34709__$1,cljs.core.cst$kw$total_DASH_as_DASH_max_QMARK_);
var datamin_as_min_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34709__$1,cljs.core.cst$kw$datamin_DASH_as_DASH_min_QMARK_);
var counts = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,data);
var xmax = (cljs.core.truth_(total_as_max_QMARK_)?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),counts):cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(0),counts));
var xmin = (cljs.core.truth_(datamin_as_min_QMARK_)?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(0),counts):(0));
var scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),max_length], null)], 0));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(scale,counts);
});

hatti.charting.counts__GT_lengths.cljs$lang$maxFixedArity = (2);

hatti.charting.counts__GT_lengths.cljs$lang$applyTo = (function (seq34705){
var G__34706 = cljs.core.first(seq34705);
var seq34705__$1 = cljs.core.next(seq34705);
var G__34707 = cljs.core.first(seq34705__$1);
var seq34705__$2 = cljs.core.next(seq34705__$1);
return hatti.charting.counts__GT_lengths.cljs$core$IFn$_invoke$arity$variadic(G__34706,G__34707,seq34705__$2);
});

hatti.charting.response_count_message = (function hatti$charting$response_count_message(response_count){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$t_DASH_right$t_DASH_grey,[cljs.core.str("Based on "),cljs.core.str(response_count),cljs.core.str(" responses.")].join('')], null);
});
/**
 * Create numeric (or date) chart out of some chart-data from ona API.
 */
hatti.charting.numeric_chart = (function hatti$charting$numeric_chart(var_args){
var args__7491__auto__ = [];
var len__7484__auto___34760 = arguments.length;
var i__7485__auto___34761 = (0);
while(true){
if((i__7485__auto___34761 < len__7484__auto___34760)){
args__7491__auto__.push((arguments[i__7485__auto___34761]));

var G__34762 = (i__7485__auto___34761 + (1));
i__7485__auto___34761 = G__34762;
continue;
} else {
}
break;
}

var argseq__7492__auto__ = ((((1) < args__7491__auto__.length))?(new cljs.core.IndexedSeq(args__7491__auto__.slice((1)),(0),null)):null);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7492__auto__);
});

hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic = (function (chart_data,p__34716){
var map__34717 = p__34716;
var map__34717__$1 = ((((!((map__34717 == null)))?((((map__34717.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34717.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34717):map__34717);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34717__$1,cljs.core.cst$kw$data_DASH_type,"int");
var chart_width = 700.0;
var chart_height = 300.0;
var margin = 33.0;
var small_margin = 2.0;
var y_lim = 8.0;
var neg_margin = (-15);
var extracted_data = hatti.charting.extract_data_for_histogram.cljs$core$IFn$_invoke$arity$variadic(chart_data,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,data_type], 0));
var map__34719 = cljs.core.meta(chart_data);
var map__34719__$1 = ((((!((map__34719 == null)))?((((map__34719.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34719.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34719):map__34719);
var nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34719__$1,cljs.core.cst$kw$nil_DASH_count);
var non_nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34719__$1,cljs.core.cst$kw$non_DASH_nil_DASH_count);
var bins = cljs.core.cst$kw$bins.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(extracted_data));
var x_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,extracted_data);
var dx_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,extracted_data);
var y_series = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.last,extracted_data);
var xmin = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,x_series);
var xmax = (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,x_series) + cljs.core.last(dx_series));
var x_scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [xmin,xmax], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_width], null)], 0));
var y_scale = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,y_series)], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null)], 0));
var bin_width = hatti.maths.floor(((chart_width / bins) - small_margin));
var x_ticks = cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((2),cljs.core.rest(x_series));
var fmt = hatti.charting.int__GT_str(data_type);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(extracted_data))){
var vec__34721 = cljs.core.first(extracted_data);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34721,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34721,(1),null);
var total = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34721,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,total," records have identical value: ",(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(value) : fmt.call(null,value))], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,(margin + chart_width),cljs.core.cst$kw$height,(margin + chart_height)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$chart,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [margin,(0)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,(function (){var iter__7189__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__34719,map__34719__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__34717,map__34717__$1,data_type){
return (function hatti$charting$iter__34724(s__34725){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__34719,map__34719__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__34717,map__34717__$1,data_type){
return (function (){
var s__34725__$1 = s__34725;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34725__$1);
if(temp__4657__auto__){
var s__34725__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34725__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34725__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34727 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34726 = (0);
while(true){
if((i__34726 < size__7188__auto__)){
var vec__34742 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34726);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34742,(0),null);
var dx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34742,(1),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34742,(2),null);
cljs.core.chunk_append(b__34727,(function (){var x_scaled = (x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x));
var y_scaled = (y_scale.cljs$core$IFn$_invoke$arity$1 ? y_scale.cljs$core$IFn$_invoke$arity$1(y) : y_scale.call(null,y));
var vec__34745 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34745,(0),null);
var txt_ht = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34745,(1),null);
var txt_cls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34745,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$bars,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(1),cljs.core.cst$kw$height,y_scaled__$1,cljs.core.cst$kw$width,bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$y,txt_ht,cljs.core.cst$kw$x,(bin_width / 2.0),cljs.core.cst$kw$dy,"1em",cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,txt_cls], null),y], null):null)], null);
})());

var G__34763 = (i__34726 + (1));
i__34726 = G__34763;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34727),hatti$charting$iter__34724(cljs.core.chunk_rest(s__34725__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34727),null);
}
} else {
var vec__34748 = cljs.core.first(s__34725__$2);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34748,(0),null);
var dx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34748,(1),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34748,(2),null);
return cljs.core.cons((function (){var x_scaled = (x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x));
var y_scaled = (y_scale.cljs$core$IFn$_invoke$arity$1 ? y_scale.cljs$core$IFn$_invoke$arity$1(y) : y_scale.call(null,y));
var vec__34751 = (((((0) < y_scaled)) && ((y_scaled < y_lim)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [small_margin,neg_margin,"out-of-bar"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_scaled,small_margin,"in-bar"], null));
var y_scaled__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34751,(0),null);
var txt_ht = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34751,(1),null);
var txt_cls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34751,(2),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$bars,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_scaled,(chart_height - y_scaled__$1)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(1),cljs.core.cst$kw$height,y_scaled__$1,cljs.core.cst$kw$width,bin_width], null)], null)], null),(((y_scaled__$1 > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$y,txt_ht,cljs.core.cst$kw$x,(bin_width / 2.0),cljs.core.cst$kw$dy,"1em",cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,txt_cls], null),y], null):null)], null);
})(),hatti$charting$iter__34724(cljs.core.rest(s__34725__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__34719,map__34719__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__34717,map__34717__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__34719,map__34719__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__34717,map__34717__$1,data_type))
;
return iter__7189__auto__(extracted_data);
})()], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$axis,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),chart_height], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$x1,(0),cljs.core.cst$kw$x2,chart_width], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,(function (){var iter__7189__auto__ = ((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__34719,map__34719__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__34717,map__34717__$1,data_type){
return (function hatti$charting$iter__34754(s__34755){
return (new cljs.core.LazySeq(null,((function (chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__34719,map__34719__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__34717,map__34717__$1,data_type){
return (function (){
var s__34755__$1 = s__34755;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34755__$1);
if(temp__4657__auto__){
var s__34755__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34755__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34755__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34757 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34756 = (0);
while(true){
if((i__34756 < size__7188__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34756);
cljs.core.chunk_append(b__34757,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x)),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$y,(25),cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,data_type], null),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(x) : fmt.call(null,x))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,"tick",cljs.core.cst$kw$y2,(10),cljs.core.cst$kw$x2,(0)], null)], null)], null));

var G__34764 = (i__34756 + (1));
i__34756 = G__34764;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34757),hatti$charting$iter__34754(cljs.core.chunk_rest(s__34755__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34757),null);
}
} else {
var x = cljs.core.first(s__34755__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g$tick,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,c2.svg.translate(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_scale.cljs$core$IFn$_invoke$arity$1 ? x_scale.cljs$core$IFn$_invoke$arity$1(x) : x_scale.call(null,x)),(0)], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$y,(25),cljs.core.cst$kw$text_DASH_anchor,"middle",cljs.core.cst$kw$class,data_type], null),(fmt.cljs$core$IFn$_invoke$arity$1 ? fmt.cljs$core$IFn$_invoke$arity$1(x) : fmt.call(null,x))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,"tick",cljs.core.cst$kw$y2,(10),cljs.core.cst$kw$x2,(0)], null)], null)], null),hatti$charting$iter__34754(cljs.core.rest(s__34755__$2)));
}
} else {
return null;
}
break;
}
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__34719,map__34719__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__34717,map__34717__$1,data_type))
,null,null));
});})(chart_width,chart_height,margin,small_margin,y_lim,neg_margin,extracted_data,map__34719,map__34719__$1,nil_count,non_nil_count,bins,x_series,dx_series,y_series,xmin,xmax,x_scale,y_scale,bin_width,x_ticks,fmt,map__34717,map__34717__$1,data_type))
;
return iter__7189__auto__(x_ticks);
})()], null)], null)], null)], null),hatti.charting.response_count_message(non_nil_count)], null);
}
});

hatti.charting.numeric_chart.cljs$lang$maxFixedArity = (1);

hatti.charting.numeric_chart.cljs$lang$applyTo = (function (seq34714){
var G__34715 = cljs.core.first(seq34714);
var seq34714__$1 = cljs.core.next(seq34714);
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(G__34715,seq34714__$1);
});

/**
 * Create category bar chart out of some data + count data. Data of form:
 *   {'Label1' 1 'Label2' 2}, etc. where the numbers are counts.
 */
hatti.charting.table_chart_h = (function hatti$charting$table_chart_h(data,nil_count,non_nil_count,field_type){
var max_count = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.vals(data));
var percent_s = ((function (max_count){
return (function (n,total){
var s = c2.scale.linear.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$domain,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),total], null),cljs.core.cst$kw$range,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(100)], null)], 0));
return [cljs.core.str(chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic("%.1f",cljs.core.array_seq([(s.cljs$core$IFn$_invoke$arity$1 ? s.cljs$core$IFn$_invoke$arity$1(n) : s.call(null,n))], 0))),cljs.core.str("%")].join('');
});})(max_count))
;
var select_mult_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_type,"select all that apply");
var bar_div = ((select_mult_QMARK_)?cljs.core.cst$kw$div$bars$select_DASH_mult:cljs.core.cst$kw$div$bars$select_DASH_one);
var tdr = cljs.core.cst$kw$td$t_DASH_right;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table_SHARP_bar_DASH_chart$table,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$t_DASH_right,"Count"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$t_DASH_right,"Percent"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tfoot,((select_mult_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$col_DASH_span,(4)], null),hatti.charting.response_count_message(non_nil_count)], null)], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"Total"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,non_nil_count], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tdr,"100%"], null)], null)),(((!(select_mult_QMARK_)) && ((nil_count > (0))))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$t_DASH_grey,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,"No response"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,nil_count], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td], null)], null):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,(function (){var iter__7189__auto__ = ((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function hatti$charting$table_chart_h_$_iter__34783(s__34784){
return (new cljs.core.LazySeq(null,((function (max_count,percent_s,select_mult_QMARK_,bar_div,tdr){
return (function (){
var s__34784__$1 = s__34784;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34784__$1);
if(temp__4657__auto__){
var s__34784__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34784__$2)){
var c__7187__auto__ = cljs.core.chunk_first(s__34784__$2);
var size__7188__auto__ = cljs.core.count(c__7187__auto__);
var b__34786 = cljs.core.chunk_buffer(size__7188__auto__);
if((function (){var i__34785 = (0);
while(true){
if((i__34785 < size__7188__auto__)){
var vec__34795 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7187__auto__,i__34785);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34795,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34795,(1),null);
cljs.core.chunk_append(b__34786,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,percent_s(val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,percent_s(val,non_nil_count)], null)], null));

var G__34801 = (i__34785 + (1));
i__34785 = G__34801;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34786),hatti$charting$table_chart_h_$_iter__34783(cljs.core.chunk_rest(s__34784__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34786),null);
}
} else {
var vec__34798 = cljs.core.first(s__34784__$2);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34798,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34798,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,label], null),label], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bar_div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,percent_s(val,max_count)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,val], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$t_DASH_right,percent_s(val,non_nil_count)], null)], null),hatti$charting$table_chart_h_$_iter__34783(cljs.core.rest(s__34784__$2)));
}
} else {
return null;
}
break;
}
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
,null,null));
});})(max_count,percent_s,select_mult_QMARK_,bar_div,tdr))
;
return iter__7189__auto__(data);
})()], null)], null);
});
/**
 * Removes nil from Ona API chart data; adds nil- and non-nil-count metadata.
 * ex. Input:  {:field_xpath 'D' :data [{:D nil :count 5} {:D 1 :count 10}]}
 *     Output: {:field_xpath 'D' :data [{:D 1 :count 10}]}
 *             w/ metadata: {:nil-count 5 :non-nil-count 10}
 */
hatti.charting.extract_nil = (function hatti$charting$extract_nil(chart_data){
var map__34807 = chart_data;
var map__34807__$1 = ((((!((map__34807 == null)))?((((map__34807.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34807.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34807):map__34807);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34807__$1,cljs.core.cst$kw$field_xpath);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34807__$1,cljs.core.cst$kw$data);
var na_QMARK_ = ((function (map__34807,map__34807__$1,field_xpath,data){
return (function (p1__34802_SHARP_){
return ((p1__34802_SHARP_ == null)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__34802_SHARP_));
});})(map__34807,map__34807__$1,field_xpath,data))
;
var nil_data = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__34807,map__34807__$1,field_xpath,data,na_QMARK_){
return (function (p1__34803_SHARP_){
return na_QMARK_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,p1__34803_SHARP_));
});})(map__34807,map__34807__$1,field_xpath,data,na_QMARK_))
,data));
var non_nil_data = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__34807,map__34807__$1,field_xpath,data,na_QMARK_,nil_data){
return (function (p1__34804_SHARP_){
return na_QMARK_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(field_xpath).call(null,p1__34804_SHARP_));
});})(map__34807,map__34807__$1,field_xpath,data,na_QMARK_,nil_data))
,data);
var nil_count = (function (){var temp__4655__auto__ = cljs.core.cst$kw$count.cljs$core$IFn$_invoke$arity$1(nil_data);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
return n;
} else {
return (0);
}
})();
var non_nil_count = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$count,non_nil_data));
return cljs.core.with_meta(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(chart_data,cljs.core.cst$kw$data,non_nil_data),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$nil_DASH_count,nil_count,cljs.core.cst$kw$non_DASH_nil_DASH_count,non_nil_count], null));
});
/**
 * Make chart depending on datatype.
 */
hatti.charting.make_chart = (function hatti$charting$make_chart(var_args){
var args34810 = [];
var len__7484__auto___34818 = arguments.length;
var i__7485__auto___34819 = (0);
while(true){
if((i__7485__auto___34819 < len__7484__auto___34818)){
args34810.push((arguments[i__7485__auto___34819]));

var G__34820 = (i__7485__auto___34819 + (1));
i__7485__auto___34819 = G__34820;
continue;
} else {
}
break;
}

var G__34812 = args34810.length;
switch (G__34812) {
case 1:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34810.length)].join('')));

}
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$1 = (function (chart_data){
return hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2(chart_data,null);
});

hatti.charting.make_chart.cljs$core$IFn$_invoke$arity$2 = (function (chart_data,language){
var map__34813 = chart_data;
var map__34813__$1 = ((((!((map__34813 == null)))?((((map__34813.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34813.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34813):map__34813);
var field_label = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34813__$1,cljs.core.cst$kw$field_label);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34813__$1,cljs.core.cst$kw$data_type);
var field_xpath = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34813__$1,cljs.core.cst$kw$field_xpath);
var field_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34813__$1,cljs.core.cst$kw$field_type);
var chart_data__$1 = hatti.charting.extract_nil(chart_data);
var map__34814 = cljs.core.meta(chart_data__$1);
var map__34814__$1 = ((((!((map__34814 == null)))?((((map__34814.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34814.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34814):map__34814);
var nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34814__$1,cljs.core.cst$kw$nil_DASH_count);
var non_nil_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34814__$1,cljs.core.cst$kw$non_DASH_nil_DASH_count);
var not_supported = ((function (map__34813,map__34813__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__34814,map__34814__$1,nil_count,non_nil_count){
return (function (p1__34809_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$div$t_DASH_red,[cljs.core.str("Aplogies. At the moment, making a chart of\n                                     this data type ("),cljs.core.str(p1__34809_SHARP_),cljs.core.str(") is not supported.")].join('')],null));
});})(map__34813,map__34813__$1,field_label,data_type,field_xpath,field_type,chart_data__$1,map__34814,map__34814__$1,nil_count,non_nil_count))
;
var chart = (((non_nil_count === (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"No data"], null):(function (){var G__34817 = data_type;
switch (G__34817) {
case "categorized":
return hatti.charting.table_chart_h(hatti.charting.label_count_pairs.cljs$core$IFn$_invoke$arity$2(chart_data__$1,language),nil_count,non_nil_count,field_type);

break;
case "time_based":
return hatti.charting.numeric_chart.cljs$core$IFn$_invoke$arity$variadic(chart_data__$1,cljs.core.array_seq([cljs.core.cst$kw$data_DASH_type,"date"], 0));

break;
case "numeric":
return hatti.charting.numeric_chart(chart_data__$1);

break;
default:
return not_supported(data_type);

}
})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$label,field_label,cljs.core.cst$kw$name,field_xpath,cljs.core.cst$kw$chart,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,chart], null)], null);
});

hatti.charting.make_chart.cljs$lang$maxFixedArity = 2;

